/* valanamespace.c generated by valac, the Vala compiler
 * generated from valanamespace.vala, do not modify */

/* valanamespace.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaNamespacePrivate {
	ValaList* classes;
	ValaList* interfaces;
	ValaList* structs;
	ValaList* enums;
	ValaList* error_domains;
	ValaList* delegates;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* comments;
	ValaList* namespaces;
	ValaList* using_directives;
};

static gint ValaNamespace_private_offset;
static gpointer vala_namespace_parent_class = NULL;

static void vala_namespace_real_add_namespace (ValaSymbol* base,
                                        ValaNamespace* ns);
static void vala_namespace_real_add_class (ValaSymbol* base,
                                    ValaClass* cl);
static void vala_namespace_real_add_interface (ValaSymbol* base,
                                        ValaInterface* iface);
static void vala_namespace_real_add_struct (ValaSymbol* base,
                                     ValaStruct* st);
static void vala_namespace_real_add_enum (ValaSymbol* base,
                                   ValaEnum* en);
static void vala_namespace_real_add_error_domain (ValaSymbol* base,
                                           ValaErrorDomain* edomain);
static void vala_namespace_real_add_delegate (ValaSymbol* base,
                                       ValaDelegate* d);
static void vala_namespace_real_add_constant (ValaSymbol* base,
                                       ValaConstant* constant);
static void vala_namespace_real_add_field (ValaSymbol* base,
                                    ValaField* f);
static void vala_namespace_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_namespace_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_namespace_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_namespace_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static gchar* vala_namespace_real_to_string (ValaCodeNode* base);
static void vala_namespace_finalize (ValaCodeNode * obj);

static inline gpointer
vala_namespace_get_instance_private (ValaNamespace* self)
{
	return G_STRUCT_MEMBER_P (self, ValaNamespace_private_offset);
}

/**
 * Creates a new namespace.
 *
 * @param name             namespace name
 * @param source_reference reference to source code
 * @return                 newly created namespace
 */
ValaNamespace*
vala_namespace_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference)
{
	ValaNamespace* self = NULL;
	self = (ValaNamespace*) vala_symbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaNamespace*
vala_namespace_new (const gchar* name,
                    ValaSourceReference* source_reference)
{
	return vala_namespace_construct (VALA_TYPE_NAMESPACE, name, source_reference);
}

/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void
vala_namespace_add_using_directive (ValaNamespace* self,
                                    ValaUsingDirective* ns)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	_tmp0_ = self->priv->using_directives;
	vala_collection_add ((ValaCollection*) _tmp0_, ns);
}

void
vala_namespace_add_comment (ValaNamespace* self,
                            ValaComment* comment)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	_tmp0_ = self->priv->comments;
	vala_collection_add ((ValaCollection*) _tmp0_, comment);
}

/**
 * Returns the list of namespaces.
 *
 * @return comment list
 */
ValaList*
vala_namespace_get_comments (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->comments;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified namespace to this source file.
 *
 * @param ns a namespace
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_namespace_real_add_namespace (ValaSymbol* base,
                                   ValaNamespace* ns)
{
	ValaNamespace * self;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp6_;
	ValaScope* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = vala_symbol_get_owner ((ValaSymbol*) ns);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		ValaSourceFile* _tmp4_;
		ValaSourceFile* _tmp5_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_source_reference_get_file (_tmp3_);
		_tmp5_ = _tmp4_;
		vala_source_file_add_node (_tmp5_, (ValaCodeNode*) ns);
	}
	_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) ns);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_scope_lookup (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = VALA_IS_NAMESPACE (_tmp11_);
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaNamespace* old_ns = NULL;
		ValaScope* _tmp13_;
		ValaScope* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		ValaSymbol* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaNamespace* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		GList* _tmp135_;
		_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_scope_lookup (_tmp14_, _tmp16_);
		old_ns = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_NAMESPACE, ValaNamespace);
		_tmp19_ = old_ns;
		_tmp20_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			gboolean _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = vala_symbol_get_external_package ((ValaSymbol*) ns);
			_tmp23_ = _tmp22_;
			_tmp18_ = !_tmp23_;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaNamespace* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			_tmp24_ = old_ns;
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) ns);
			_tmp26_ = _tmp25_;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp24_, _tmp26_);
		}
		{
			ValaList* _using_directive_list = NULL;
			ValaList* _tmp27_;
			ValaList* _tmp28_;
			gint _using_directive_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _using_directive_index = 0;
			_tmp27_ = ns->priv->using_directives;
			_tmp28_ = _vala_iterable_ref0 (_tmp27_);
			_using_directive_list = _tmp28_;
			_tmp29_ = _using_directive_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_using_directive_size = _tmp31_;
			_using_directive_index = -1;
			while (TRUE) {
				ValaUsingDirective* using_directive = NULL;
				ValaList* _tmp32_;
				gpointer _tmp33_;
				ValaNamespace* _tmp34_;
				ValaUsingDirective* _tmp35_;
				_using_directive_index = _using_directive_index + 1;
				if (!(_using_directive_index < _using_directive_size)) {
					break;
				}
				_tmp32_ = _using_directive_list;
				_tmp33_ = vala_list_get (_tmp32_, _using_directive_index);
				using_directive = (ValaUsingDirective*) _tmp33_;
				_tmp34_ = old_ns;
				_tmp35_ = using_directive;
				vala_namespace_add_using_directive (_tmp34_, _tmp35_);
				_vala_code_node_unref0 (using_directive);
			}
			_vala_iterable_unref0 (_using_directive_list);
		}
		{
			ValaList* _sub_ns_list = NULL;
			ValaList* _tmp36_;
			ValaList* _tmp37_;
			gint _sub_ns_size = 0;
			ValaList* _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			gint _sub_ns_index = 0;
			_tmp36_ = vala_namespace_get_namespaces (ns);
			_tmp37_ = _vala_iterable_ref0 (_tmp36_);
			_sub_ns_list = _tmp37_;
			_tmp38_ = _sub_ns_list;
			_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
			_tmp40_ = _tmp39_;
			_sub_ns_size = _tmp40_;
			_sub_ns_index = -1;
			while (TRUE) {
				ValaNamespace* sub_ns = NULL;
				ValaList* _tmp41_;
				gpointer _tmp42_;
				ValaNamespace* _tmp43_;
				ValaNamespace* _tmp44_;
				_sub_ns_index = _sub_ns_index + 1;
				if (!(_sub_ns_index < _sub_ns_size)) {
					break;
				}
				_tmp41_ = _sub_ns_list;
				_tmp42_ = vala_list_get (_tmp41_, _sub_ns_index);
				sub_ns = (ValaNamespace*) _tmp42_;
				_tmp43_ = old_ns;
				_tmp44_ = sub_ns;
				vala_symbol_add_namespace ((ValaSymbol*) _tmp43_, _tmp44_);
				_vala_code_node_unref0 (sub_ns);
			}
			_vala_iterable_unref0 (_sub_ns_list);
		}
		{
			ValaList* _cl_list = NULL;
			ValaList* _tmp45_;
			ValaList* _tmp46_;
			gint _cl_size = 0;
			ValaList* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			gint _cl_index = 0;
			_tmp45_ = vala_namespace_get_classes (ns);
			_tmp46_ = _vala_iterable_ref0 (_tmp45_);
			_cl_list = _tmp46_;
			_tmp47_ = _cl_list;
			_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
			_tmp49_ = _tmp48_;
			_cl_size = _tmp49_;
			_cl_index = -1;
			while (TRUE) {
				ValaClass* cl = NULL;
				ValaList* _tmp50_;
				gpointer _tmp51_;
				ValaNamespace* _tmp52_;
				ValaClass* _tmp53_;
				_cl_index = _cl_index + 1;
				if (!(_cl_index < _cl_size)) {
					break;
				}
				_tmp50_ = _cl_list;
				_tmp51_ = vala_list_get (_tmp50_, _cl_index);
				cl = (ValaClass*) _tmp51_;
				_tmp52_ = old_ns;
				_tmp53_ = cl;
				vala_symbol_add_class ((ValaSymbol*) _tmp52_, _tmp53_);
				_vala_code_node_unref0 (cl);
			}
			_vala_iterable_unref0 (_cl_list);
		}
		{
			ValaList* _st_list = NULL;
			ValaList* _tmp54_;
			ValaList* _tmp55_;
			gint _st_size = 0;
			ValaList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint _st_index = 0;
			_tmp54_ = vala_namespace_get_structs (ns);
			_tmp55_ = _vala_iterable_ref0 (_tmp54_);
			_st_list = _tmp55_;
			_tmp56_ = _st_list;
			_tmp57_ = vala_collection_get_size ((ValaCollection*) _tmp56_);
			_tmp58_ = _tmp57_;
			_st_size = _tmp58_;
			_st_index = -1;
			while (TRUE) {
				ValaStruct* st = NULL;
				ValaList* _tmp59_;
				gpointer _tmp60_;
				ValaNamespace* _tmp61_;
				ValaStruct* _tmp62_;
				_st_index = _st_index + 1;
				if (!(_st_index < _st_size)) {
					break;
				}
				_tmp59_ = _st_list;
				_tmp60_ = vala_list_get (_tmp59_, _st_index);
				st = (ValaStruct*) _tmp60_;
				_tmp61_ = old_ns;
				_tmp62_ = st;
				vala_symbol_add_struct ((ValaSymbol*) _tmp61_, _tmp62_);
				_vala_code_node_unref0 (st);
			}
			_vala_iterable_unref0 (_st_list);
		}
		{
			ValaList* _iface_list = NULL;
			ValaList* _tmp63_;
			ValaList* _tmp64_;
			gint _iface_size = 0;
			ValaList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			gint _iface_index = 0;
			_tmp63_ = vala_namespace_get_interfaces (ns);
			_tmp64_ = _vala_iterable_ref0 (_tmp63_);
			_iface_list = _tmp64_;
			_tmp65_ = _iface_list;
			_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			_iface_size = _tmp67_;
			_iface_index = -1;
			while (TRUE) {
				ValaInterface* iface = NULL;
				ValaList* _tmp68_;
				gpointer _tmp69_;
				ValaNamespace* _tmp70_;
				ValaInterface* _tmp71_;
				_iface_index = _iface_index + 1;
				if (!(_iface_index < _iface_size)) {
					break;
				}
				_tmp68_ = _iface_list;
				_tmp69_ = vala_list_get (_tmp68_, _iface_index);
				iface = (ValaInterface*) _tmp69_;
				_tmp70_ = old_ns;
				_tmp71_ = iface;
				vala_symbol_add_interface ((ValaSymbol*) _tmp70_, _tmp71_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		{
			ValaList* _d_list = NULL;
			ValaList* _tmp72_;
			ValaList* _tmp73_;
			gint _d_size = 0;
			ValaList* _tmp74_;
			gint _tmp75_;
			gint _tmp76_;
			gint _d_index = 0;
			_tmp72_ = vala_namespace_get_delegates (ns);
			_tmp73_ = _vala_iterable_ref0 (_tmp72_);
			_d_list = _tmp73_;
			_tmp74_ = _d_list;
			_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
			_tmp76_ = _tmp75_;
			_d_size = _tmp76_;
			_d_index = -1;
			while (TRUE) {
				ValaDelegate* d = NULL;
				ValaList* _tmp77_;
				gpointer _tmp78_;
				ValaNamespace* _tmp79_;
				ValaDelegate* _tmp80_;
				_d_index = _d_index + 1;
				if (!(_d_index < _d_size)) {
					break;
				}
				_tmp77_ = _d_list;
				_tmp78_ = vala_list_get (_tmp77_, _d_index);
				d = (ValaDelegate*) _tmp78_;
				_tmp79_ = old_ns;
				_tmp80_ = d;
				vala_symbol_add_delegate ((ValaSymbol*) _tmp79_, _tmp80_);
				_vala_code_node_unref0 (d);
			}
			_vala_iterable_unref0 (_d_list);
		}
		{
			ValaList* _en_list = NULL;
			ValaList* _tmp81_;
			ValaList* _tmp82_;
			gint _en_size = 0;
			ValaList* _tmp83_;
			gint _tmp84_;
			gint _tmp85_;
			gint _en_index = 0;
			_tmp81_ = vala_namespace_get_enums (ns);
			_tmp82_ = _vala_iterable_ref0 (_tmp81_);
			_en_list = _tmp82_;
			_tmp83_ = _en_list;
			_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			_en_size = _tmp85_;
			_en_index = -1;
			while (TRUE) {
				ValaEnum* en = NULL;
				ValaList* _tmp86_;
				gpointer _tmp87_;
				ValaNamespace* _tmp88_;
				ValaEnum* _tmp89_;
				_en_index = _en_index + 1;
				if (!(_en_index < _en_size)) {
					break;
				}
				_tmp86_ = _en_list;
				_tmp87_ = vala_list_get (_tmp86_, _en_index);
				en = (ValaEnum*) _tmp87_;
				_tmp88_ = old_ns;
				_tmp89_ = en;
				vala_symbol_add_enum ((ValaSymbol*) _tmp88_, _tmp89_);
				_vala_code_node_unref0 (en);
			}
			_vala_iterable_unref0 (_en_list);
		}
		{
			ValaList* _ed_list = NULL;
			ValaList* _tmp90_;
			ValaList* _tmp91_;
			gint _ed_size = 0;
			ValaList* _tmp92_;
			gint _tmp93_;
			gint _tmp94_;
			gint _ed_index = 0;
			_tmp90_ = vala_namespace_get_error_domains (ns);
			_tmp91_ = _vala_iterable_ref0 (_tmp90_);
			_ed_list = _tmp91_;
			_tmp92_ = _ed_list;
			_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
			_tmp94_ = _tmp93_;
			_ed_size = _tmp94_;
			_ed_index = -1;
			while (TRUE) {
				ValaErrorDomain* ed = NULL;
				ValaList* _tmp95_;
				gpointer _tmp96_;
				ValaNamespace* _tmp97_;
				ValaErrorDomain* _tmp98_;
				_ed_index = _ed_index + 1;
				if (!(_ed_index < _ed_size)) {
					break;
				}
				_tmp95_ = _ed_list;
				_tmp96_ = vala_list_get (_tmp95_, _ed_index);
				ed = (ValaErrorDomain*) _tmp96_;
				_tmp97_ = old_ns;
				_tmp98_ = ed;
				vala_symbol_add_error_domain ((ValaSymbol*) _tmp97_, _tmp98_);
				_vala_code_node_unref0 (ed);
			}
			_vala_iterable_unref0 (_ed_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp99_;
			ValaList* _tmp100_;
			gint _c_size = 0;
			ValaList* _tmp101_;
			gint _tmp102_;
			gint _tmp103_;
			gint _c_index = 0;
			_tmp99_ = vala_namespace_get_constants (ns);
			_tmp100_ = _vala_iterable_ref0 (_tmp99_);
			_c_list = _tmp100_;
			_tmp101_ = _c_list;
			_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
			_tmp103_ = _tmp102_;
			_c_size = _tmp103_;
			_c_index = -1;
			while (TRUE) {
				ValaConstant* c = NULL;
				ValaList* _tmp104_;
				gpointer _tmp105_;
				ValaNamespace* _tmp106_;
				ValaConstant* _tmp107_;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp104_ = _c_list;
				_tmp105_ = vala_list_get (_tmp104_, _c_index);
				c = (ValaConstant*) _tmp105_;
				_tmp106_ = old_ns;
				_tmp107_ = c;
				vala_symbol_add_constant ((ValaSymbol*) _tmp106_, _tmp107_);
				_vala_code_node_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		{
			ValaList* _f_list = NULL;
			ValaList* _tmp108_;
			ValaList* _tmp109_;
			gint _f_size = 0;
			ValaList* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gint _f_index = 0;
			_tmp108_ = vala_namespace_get_fields (ns);
			_tmp109_ = _vala_iterable_ref0 (_tmp108_);
			_f_list = _tmp109_;
			_tmp110_ = _f_list;
			_tmp111_ = vala_collection_get_size ((ValaCollection*) _tmp110_);
			_tmp112_ = _tmp111_;
			_f_size = _tmp112_;
			_f_index = -1;
			while (TRUE) {
				ValaField* f = NULL;
				ValaList* _tmp113_;
				gpointer _tmp114_;
				ValaNamespace* _tmp115_;
				ValaField* _tmp116_;
				_f_index = _f_index + 1;
				if (!(_f_index < _f_size)) {
					break;
				}
				_tmp113_ = _f_list;
				_tmp114_ = vala_list_get (_tmp113_, _f_index);
				f = (ValaField*) _tmp114_;
				_tmp115_ = old_ns;
				_tmp116_ = f;
				vala_symbol_add_field ((ValaSymbol*) _tmp115_, _tmp116_);
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp117_;
			ValaList* _tmp118_;
			gint _m_size = 0;
			ValaList* _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			gint _m_index = 0;
			_tmp117_ = vala_namespace_get_methods (ns);
			_tmp118_ = _vala_iterable_ref0 (_tmp117_);
			_m_list = _tmp118_;
			_tmp119_ = _m_list;
			_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
			_tmp121_ = _tmp120_;
			_m_size = _tmp121_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp122_;
				gpointer _tmp123_;
				ValaNamespace* _tmp124_;
				ValaMethod* _tmp125_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp122_ = _m_list;
				_tmp123_ = vala_list_get (_tmp122_, _m_index);
				m = (ValaMethod*) _tmp123_;
				_tmp124_ = old_ns;
				_tmp125_ = m;
				vala_symbol_add_method ((ValaSymbol*) _tmp124_, _tmp125_);
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _c_list = NULL;
			ValaList* _tmp126_;
			ValaList* _tmp127_;
			gint _c_size = 0;
			ValaList* _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			gint _c_index = 0;
			_tmp126_ = vala_namespace_get_comments (ns);
			_tmp127_ = _vala_iterable_ref0 (_tmp126_);
			_c_list = _tmp127_;
			_tmp128_ = _c_list;
			_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
			_tmp130_ = _tmp129_;
			_c_size = _tmp130_;
			_c_index = -1;
			while (TRUE) {
				ValaComment* c = NULL;
				ValaList* _tmp131_;
				gpointer _tmp132_;
				ValaNamespace* _tmp133_;
				ValaComment* _tmp134_;
				_c_index = _c_index + 1;
				if (!(_c_index < _c_size)) {
					break;
				}
				_tmp131_ = _c_list;
				_tmp132_ = vala_list_get (_tmp131_, _c_index);
				c = (ValaComment*) _tmp132_;
				_tmp133_ = old_ns;
				_tmp134_ = c;
				vala_namespace_add_comment (_tmp133_, _tmp134_);
				_vala_comment_unref0 (c);
			}
			_vala_iterable_unref0 (_c_list);
		}
		_tmp135_ = ((ValaCodeNode*) ns)->attributes;
		{
			GList* a_collection = NULL;
			GList* a_it = NULL;
			a_collection = _tmp135_;
			for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
				ValaAttribute* _tmp136_;
				ValaAttribute* a = NULL;
				_tmp136_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
				a = _tmp136_;
				{
					ValaNamespace* _tmp137_;
					ValaAttribute* _tmp138_;
					const gchar* _tmp139_;
					const gchar* _tmp140_;
					ValaAttribute* _tmp141_;
					_tmp137_ = old_ns;
					_tmp138_ = a;
					_tmp139_ = vala_attribute_get_name (_tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp137_, _tmp140_);
					if (_tmp141_ == NULL) {
						ValaNamespace* _tmp142_;
						ValaAttribute* _tmp143_;
						ValaAttribute* _tmp144_;
						_tmp142_ = old_ns;
						_tmp143_ = a;
						_tmp144_ = _vala_code_node_ref0 (_tmp143_);
						((ValaCodeNode*) _tmp142_)->attributes = g_list_append (((ValaCodeNode*) _tmp142_)->attributes, _tmp144_);
					}
					_vala_code_node_unref0 (a);
				}
			}
		}
		_vala_code_node_unref0 (old_ns);
	} else {
		ValaList* _tmp145_;
		ValaScope* _tmp146_;
		ValaScope* _tmp147_;
		const gchar* _tmp148_;
		const gchar* _tmp149_;
		_tmp145_ = self->priv->namespaces;
		vala_collection_add ((ValaCollection*) _tmp145_, ns);
		_tmp146_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_symbol_get_name ((ValaSymbol*) ns);
		_tmp149_ = _tmp148_;
		vala_scope_add (_tmp147_, _tmp149_, (ValaSymbol*) ns);
	}
}

/**
 * Returns the list of namespaces.
 *
 * @return namespace list
 */
ValaList*
vala_namespace_get_namespaces (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->namespaces;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified class to this namespace.
 *
 * @param cl a class
 */
static void
vala_namespace_real_add_class (ValaSymbol* base,
                               ValaClass* cl)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) cl, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) cl);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) cl);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) cl);
	}
	_tmp8_ = self->priv->classes;
	vala_collection_add ((ValaCollection*) _tmp8_, cl);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) cl);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) cl);
}

/**
 * Adds the specified interface to this namespace.
 *
 * @param iface an interface
 */
static void
vala_namespace_real_add_interface (ValaSymbol* base,
                                   ValaInterface* iface)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) iface);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) iface, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) iface);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) iface);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) iface);
	}
	_tmp8_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp8_, iface);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) iface);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) iface);
}

/**
 * Adds the specified struct to this namespace.
 *
 * @param st a struct
 */
static void
vala_namespace_real_add_struct (ValaSymbol* base,
                                ValaStruct* st)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) st);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) st, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) st);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) st);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) st);
	}
	_tmp8_ = self->priv->structs;
	vala_collection_add ((ValaCollection*) _tmp8_, st);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) st);
}

/**
 * Removes the specified struct from this namespace.
 *
 * @param st a struct
 */
void
vala_namespace_remove_struct (ValaNamespace* self,
                              ValaStruct* st)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	vala_collection_remove ((ValaCollection*) _tmp0_, st);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) st);
	_tmp4_ = _tmp3_;
	vala_scope_remove (_tmp2_, _tmp4_);
}

/**
 * Adds the specified enum to this namespace.
 *
 * @param en an enum
 */
static void
vala_namespace_real_add_enum (ValaSymbol* base,
                              ValaEnum* en)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) en);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) en, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) en);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) en);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) en);
	}
	_tmp8_ = self->priv->enums;
	vala_collection_add ((ValaCollection*) _tmp8_, en);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) en);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) en);
}

/**
 * Adds the specified error domain to this namespace.
 *
 * @param edomain an error domain
 */
static void
vala_namespace_real_add_error_domain (ValaSymbol* base,
                                      ValaErrorDomain* edomain)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) edomain, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) edomain);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) edomain);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) edomain);
	}
	_tmp8_ = self->priv->error_domains;
	vala_collection_add ((ValaCollection*) _tmp8_, edomain);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) edomain);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) edomain);
}

/**
 * Adds the specified delegate to this namespace.
 *
 * @param d a delegate
 */
static void
vala_namespace_real_add_delegate (ValaSymbol* base,
                                  ValaDelegate* d)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) d, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) d);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) d);
	}
	_tmp8_ = self->priv->delegates;
	vala_collection_add ((ValaCollection*) _tmp8_, d);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) d);
}

/**
 * Returns the list of structs.
 *
 * @return struct list
 */
ValaList*
vala_namespace_get_structs (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of classes.
 *
 * @return class list
 */
ValaList*
vala_namespace_get_classes (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of interfaces.
 *
 * @return interface list
 */
ValaList*
vala_namespace_get_interfaces (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of enums.
 *
 * @return enum list
 */
ValaList*
vala_namespace_get_enums (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of error domains.
 *
 * @return error domain list
 */
ValaList*
vala_namespace_get_error_domains (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->error_domains;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of fields.
 *
 * @return field list
 */
ValaList*
vala_namespace_get_fields (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of constants.
 *
 * @return constant list
 */
ValaList*
vala_namespace_get_constants (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of delegates.
 *
 * @return delegate list
 */
ValaList*
vala_namespace_get_delegates (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	result = _tmp0_;
	return result;
}

/**
 * Returns the list of methods.
 *
 * @return method list
 */
ValaList*
vala_namespace_get_methods (ValaNamespace* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	result = _tmp0_;
	return result;
}

/**
 * Adds the specified constant to this namespace.
 *
 * @param constant a constant
 */
static void
vala_namespace_real_add_constant (ValaSymbol* base,
                                  ValaConstant* constant)
{
	ValaNamespace * self;
	ValaSymbolAccessibility _tmp0_;
	ValaSymbolAccessibility _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaList* _tmp8_;
	ValaScope* _tmp9_;
	ValaScope* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	self = (ValaNamespace*) base;
	g_return_if_fail (constant != NULL);
	_tmp0_ = vala_symbol_get_access ((ValaSymbol*) constant);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) constant, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp2_ = vala_symbol_get_owner ((ValaSymbol*) constant);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaSourceFile* _tmp6_;
		ValaSourceFile* _tmp7_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) constant);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_source_reference_get_file (_tmp5_);
		_tmp7_ = _tmp6_;
		vala_source_file_add_node (_tmp7_, (ValaCodeNode*) constant);
	}
	_tmp8_ = self->priv->constants;
	vala_collection_add ((ValaCollection*) _tmp8_, constant);
	_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_symbol_get_name ((ValaSymbol*) constant);
	_tmp12_ = _tmp11_;
	vala_scope_add (_tmp10_, _tmp12_, (ValaSymbol*) constant);
}

/**
 * Adds the specified field to this namespace.
 *
 * @param f a field
 */
static void
vala_namespace_real_add_field (ValaSymbol* base,
                               ValaField* f)
{
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	ValaMemberBinding _tmp4_;
	ValaMemberBinding _tmp5_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaList* _tmp18_;
	ValaScope* _tmp19_;
	ValaScope* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_;
	self = (ValaNamespace*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = vala_field_get_binding (f);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_field_set_binding (f, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp2_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	_tmp4_ = vala_field_get_binding (f);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp8_;
		ValaMemberBinding _tmp9_;
		_tmp8_ = vala_field_get_binding (f);
		_tmp9_ = _tmp8_;
		if (_tmp9_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp10_;
			ValaSourceReference* _tmp11_;
			_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp11_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) f, TRUE);
			return;
		}
	}
	_tmp12_ = vala_symbol_get_owner ((ValaSymbol*) f);
	_tmp13_ = _tmp12_;
	if (_tmp13_ == NULL) {
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaSourceFile* _tmp16_;
		ValaSourceFile* _tmp17_;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_source_reference_get_file (_tmp15_);
		_tmp17_ = _tmp16_;
		vala_source_file_add_node (_tmp17_, (ValaCodeNode*) f);
	}
	_tmp18_ = self->priv->fields;
	vala_collection_add ((ValaCollection*) _tmp18_, f);
	_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_symbol_get_name ((ValaSymbol*) f);
	_tmp22_ = _tmp21_;
	vala_scope_add (_tmp20_, _tmp22_, (ValaSymbol*) f);
}

/**
 * Adds the specified method to this namespace.
 *
 * @param m a method
 */
static void
vala_namespace_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaNamespace * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	ValaSymbolAccessibility _tmp3_;
	ValaMemberBinding _tmp6_;
	ValaMemberBinding _tmp7_;
	gboolean _tmp14_ = FALSE;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaScope* _tmp30_;
	ValaScope* _tmp31_;
	ValaList* _tmp36_;
	ValaScope* _tmp37_;
	ValaScope* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	self = (ValaNamespace*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		vala_method_set_binding (m, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp2_ = vala_symbol_get_access ((ValaSymbol*) m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		vala_symbol_set_access ((ValaSymbol*) m, VALA_SYMBOL_ACCESSIBILITY_INTERNAL);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp5_ = _tmp4_;
		vala_report_error (_tmp5_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp6_ = vala_method_get_binding (m);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "instance members are not allowed outside of data types");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	} else {
		ValaMemberBinding _tmp10_;
		ValaMemberBinding _tmp11_;
		_tmp10_ = vala_method_get_binding (m);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_MEMBER_BINDING_CLASS) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "class members are not allowed outside of classes");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			return;
		}
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp16_ = _tmp15_;
	if (!VALA_IS_VOID_TYPE (_tmp16_)) {
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = vala_method_get_postconditions (m);
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp14_ = _tmp19_ > 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaDataType* _tmp20_;
		ValaDataType* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaLocalVariable* _tmp26_;
		ValaLocalVariable* _tmp27_;
		ValaLocalVariable* _tmp28_;
		ValaLocalVariable* _tmp29_;
		_tmp20_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_data_type_copy (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_local_variable_new (_tmp23_, "result", NULL, _tmp25_);
		_tmp27_ = _tmp26_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		_vala_code_node_unref0 (_tmp23_);
		_tmp28_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp29_ = _tmp28_;
		vala_local_variable_set_is_result (_tmp29_, TRUE);
	}
	_tmp30_ = vala_symbol_get_owner ((ValaSymbol*) m);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == NULL) {
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFile* _tmp35_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_source_reference_get_file (_tmp33_);
		_tmp35_ = _tmp34_;
		vala_source_file_add_node (_tmp35_, (ValaCodeNode*) m);
	}
	_tmp36_ = self->priv->methods;
	vala_collection_add ((ValaCollection*) _tmp36_, m);
	_tmp37_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_symbol_get_name ((ValaSymbol*) m);
	_tmp40_ = _tmp39_;
	vala_scope_add (_tmp38_, _tmp40_, (ValaSymbol*) m);
}

static void
vala_namespace_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_namespace (visitor, self);
}

static void
vala_namespace_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaNamespace * self;
	self = (ValaNamespace*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _ns_ref_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _ns_ref_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _ns_ref_index = 0;
		_tmp0_ = self->priv->using_directives;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_ns_ref_list = _tmp1_;
		_tmp2_ = _ns_ref_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_ns_ref_size = _tmp4_;
		_ns_ref_index = -1;
		while (TRUE) {
			ValaUsingDirective* ns_ref = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaUsingDirective* _tmp7_;
			_ns_ref_index = _ns_ref_index + 1;
			if (!(_ns_ref_index < _ns_ref_size)) {
				break;
			}
			_tmp5_ = _ns_ref_list;
			_tmp6_ = vala_list_get (_tmp5_, _ns_ref_index);
			ns_ref = (ValaUsingDirective*) _tmp6_;
			_tmp7_ = ns_ref;
			vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
			_vala_code_node_unref0 (ns_ref);
		}
		_vala_iterable_unref0 (_ns_ref_list);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _ns_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _ns_index = 0;
		_tmp8_ = self->priv->namespaces;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_ns_list = _tmp9_;
		_tmp10_ = _ns_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_ns_size = _tmp12_;
		_ns_index = -1;
		while (TRUE) {
			ValaNamespace* ns = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaNamespace* _tmp15_;
			_ns_index = _ns_index + 1;
			if (!(_ns_index < _ns_size)) {
				break;
			}
			_tmp13_ = _ns_list;
			_tmp14_ = vala_list_get (_tmp13_, _ns_index);
			ns = (ValaNamespace*) _tmp14_;
			_tmp15_ = ns;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _en_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _en_index = 0;
		_tmp16_ = self->priv->enums;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_en_list = _tmp17_;
		_tmp18_ = _en_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_en_size = _tmp20_;
		_en_index = -1;
		while (TRUE) {
			ValaEnum* en = NULL;
			ValaList* _tmp21_;
			gpointer _tmp22_;
			ValaEnum* _tmp23_;
			_en_index = _en_index + 1;
			if (!(_en_index < _en_size)) {
				break;
			}
			_tmp21_ = _en_list;
			_tmp22_ = vala_list_get (_tmp21_, _en_index);
			en = (ValaEnum*) _tmp22_;
			_tmp23_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _edomain_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _edomain_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _edomain_index = 0;
		_tmp24_ = self->priv->error_domains;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_edomain_list = _tmp25_;
		_tmp26_ = _edomain_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_edomain_size = _tmp28_;
		_edomain_index = -1;
		while (TRUE) {
			ValaErrorDomain* edomain = NULL;
			ValaList* _tmp29_;
			gpointer _tmp30_;
			ValaErrorDomain* _tmp31_;
			_edomain_index = _edomain_index + 1;
			if (!(_edomain_index < _edomain_size)) {
				break;
			}
			_tmp29_ = _edomain_list;
			_tmp30_ = vala_list_get (_tmp29_, _edomain_index);
			edomain = (ValaErrorDomain*) _tmp30_;
			_tmp31_ = edomain;
			vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
			_vala_code_node_unref0 (edomain);
		}
		_vala_iterable_unref0 (_edomain_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _cl_size = 0;
		ValaList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _cl_index = 0;
		_tmp32_ = self->priv->classes;
		_tmp33_ = _vala_iterable_ref0 (_tmp32_);
		_cl_list = _tmp33_;
		_tmp34_ = _cl_list;
		_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_cl_size = _tmp36_;
		_cl_index = -1;
		while (TRUE) {
			ValaClass* cl = NULL;
			ValaList* _tmp37_;
			gpointer _tmp38_;
			ValaClass* _tmp39_;
			_cl_index = _cl_index + 1;
			if (!(_cl_index < _cl_size)) {
				break;
			}
			_tmp37_ = _cl_list;
			_tmp38_ = vala_list_get (_tmp37_, _cl_index);
			cl = (ValaClass*) _tmp38_;
			_tmp39_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _iface_list = NULL;
		ValaList* _tmp40_;
		ValaList* _tmp41_;
		gint _iface_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _iface_index = 0;
		_tmp40_ = self->priv->interfaces;
		_tmp41_ = _vala_iterable_ref0 (_tmp40_);
		_iface_list = _tmp41_;
		_tmp42_ = _iface_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_iface_size = _tmp44_;
		_iface_index = -1;
		while (TRUE) {
			ValaInterface* iface = NULL;
			ValaList* _tmp45_;
			gpointer _tmp46_;
			ValaInterface* _tmp47_;
			_iface_index = _iface_index + 1;
			if (!(_iface_index < _iface_size)) {
				break;
			}
			_tmp45_ = _iface_list;
			_tmp46_ = vala_list_get (_tmp45_, _iface_index);
			iface = (ValaInterface*) _tmp46_;
			_tmp47_ = iface;
			vala_code_node_accept ((ValaCodeNode*) _tmp47_, visitor);
			_vala_code_node_unref0 (iface);
		}
		_vala_iterable_unref0 (_iface_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp48_;
		ValaList* _tmp49_;
		gint _st_size = 0;
		ValaList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _st_index = 0;
		_tmp48_ = self->priv->structs;
		_tmp49_ = _vala_iterable_ref0 (_tmp48_);
		_st_list = _tmp49_;
		_tmp50_ = _st_list;
		_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_st_size = _tmp52_;
		_st_index = -1;
		while (TRUE) {
			ValaStruct* st = NULL;
			ValaList* _tmp53_;
			gpointer _tmp54_;
			ValaStruct* _tmp55_;
			_st_index = _st_index + 1;
			if (!(_st_index < _st_size)) {
				break;
			}
			_tmp53_ = _st_list;
			_tmp54_ = vala_list_get (_tmp53_, _st_index);
			st = (ValaStruct*) _tmp54_;
			_tmp55_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp56_;
		ValaList* _tmp57_;
		gint _d_size = 0;
		ValaList* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _d_index = 0;
		_tmp56_ = self->priv->delegates;
		_tmp57_ = _vala_iterable_ref0 (_tmp56_);
		_d_list = _tmp57_;
		_tmp58_ = _d_list;
		_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
		_tmp60_ = _tmp59_;
		_d_size = _tmp60_;
		_d_index = -1;
		while (TRUE) {
			ValaDelegate* d = NULL;
			ValaList* _tmp61_;
			gpointer _tmp62_;
			ValaDelegate* _tmp63_;
			_d_index = _d_index + 1;
			if (!(_d_index < _d_size)) {
				break;
			}
			_tmp61_ = _d_list;
			_tmp62_ = vala_list_get (_tmp61_, _d_index);
			d = (ValaDelegate*) _tmp62_;
			_tmp63_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp63_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		gint _c_size = 0;
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _c_index = 0;
		_tmp64_ = self->priv->constants;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_c_list = _tmp65_;
		_tmp66_ = _c_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_c_size = _tmp68_;
		_c_index = -1;
		while (TRUE) {
			ValaConstant* c = NULL;
			ValaList* _tmp69_;
			gpointer _tmp70_;
			ValaConstant* _tmp71_;
			_c_index = _c_index + 1;
			if (!(_c_index < _c_size)) {
				break;
			}
			_tmp69_ = _c_list;
			_tmp70_ = vala_list_get (_tmp69_, _c_index);
			c = (ValaConstant*) _tmp70_;
			_tmp71_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp71_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp72_;
		ValaList* _tmp73_;
		gint _f_size = 0;
		ValaList* _tmp74_;
		gint _tmp75_;
		gint _tmp76_;
		gint _f_index = 0;
		_tmp72_ = self->priv->fields;
		_tmp73_ = _vala_iterable_ref0 (_tmp72_);
		_f_list = _tmp73_;
		_tmp74_ = _f_list;
		_tmp75_ = vala_collection_get_size ((ValaCollection*) _tmp74_);
		_tmp76_ = _tmp75_;
		_f_size = _tmp76_;
		_f_index = -1;
		while (TRUE) {
			ValaField* f = NULL;
			ValaList* _tmp77_;
			gpointer _tmp78_;
			ValaField* _tmp79_;
			_f_index = _f_index + 1;
			if (!(_f_index < _f_size)) {
				break;
			}
			_tmp77_ = _f_list;
			_tmp78_ = vala_list_get (_tmp77_, _f_index);
			f = (ValaField*) _tmp78_;
			_tmp79_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp79_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _m_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _m_index = 0;
		_tmp80_ = self->priv->methods;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_m_list = _tmp81_;
		_tmp82_ = _m_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_m_size = _tmp84_;
		_m_index = -1;
		while (TRUE) {
			ValaMethod* m = NULL;
			ValaList* _tmp85_;
			gpointer _tmp86_;
			ValaMethod* _tmp87_;
			_m_index = _m_index + 1;
			if (!(_m_index < _m_size)) {
				break;
			}
			_tmp85_ = _m_list;
			_tmp86_ = vala_list_get (_tmp85_, _m_index);
			m = (ValaMethod*) _tmp86_;
			_tmp87_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp87_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
}

static gboolean
vala_namespace_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaNamespace * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* a = NULL;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp5_;
	gboolean _tmp6_ = FALSE;
	ValaAttribute* _tmp7_;
	gboolean _tmp16_ = FALSE;
	ValaAttribute* _tmp17_;
	gboolean _tmp34_;
	gboolean _tmp35_;
	gboolean result = FALSE;
	self = (ValaNamespace*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
	_tmp5_ = _vala_code_node_ref0 (_tmp4_);
	a = _tmp5_;
	_tmp7_ = a;
	if (_tmp7_ != NULL) {
		ValaAttribute* _tmp8_;
		_tmp8_ = a;
		_tmp6_ = vala_attribute_has_argument (_tmp8_, "gir_namespace");
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		ValaSourceFile* _tmp11_;
		ValaSourceFile* _tmp12_;
		ValaAttribute* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_source_reference_get_file (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = a;
		_tmp14_ = vala_attribute_get_string (_tmp13_, "gir_namespace", NULL);
		_tmp15_ = _tmp14_;
		vala_source_file_set_gir_namespace (_tmp12_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp17_ = a;
	if (_tmp17_ != NULL) {
		ValaAttribute* _tmp18_;
		_tmp18_ = a;
		_tmp16_ = vala_attribute_has_argument (_tmp18_, "gir_version");
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceFile* _tmp21_;
		ValaSourceFile* _tmp22_;
		ValaAttribute* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_source_reference_get_file (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = a;
		_tmp24_ = vala_attribute_get_string (_tmp23_, "gir_version", NULL);
		_tmp25_ = _tmp24_;
		vala_source_file_set_gir_version (_tmp22_, _tmp25_);
		_g_free0 (_tmp25_);
	}
	{
		ValaList* _ns_list = NULL;
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _ns_size = 0;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		gint _ns_index = 0;
		_tmp26_ = self->priv->namespaces;
		_tmp27_ = _vala_iterable_ref0 (_tmp26_);
		_ns_list = _tmp27_;
		_tmp28_ = _ns_list;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_ns_size = _tmp30_;
		_ns_index = -1;
		while (TRUE) {
			ValaNamespace* ns = NULL;
			ValaList* _tmp31_;
			gpointer _tmp32_;
			ValaNamespace* _tmp33_;
			_ns_index = _ns_index + 1;
			if (!(_ns_index < _ns_size)) {
				break;
			}
			_tmp31_ = _ns_list;
			_tmp32_ = vala_list_get (_tmp31_, _ns_index);
			ns = (ValaNamespace*) _tmp32_;
			_tmp33_ = ns;
			vala_code_node_check ((ValaCodeNode*) _tmp33_, context);
			_vala_code_node_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp34_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp35_ = _tmp34_;
	result = !_tmp35_;
	_vala_code_node_unref0 (a);
	return result;
}

static gchar*
vala_namespace_real_to_string (ValaCodeNode* base)
{
	ValaNamespace * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	self = (ValaNamespace*) base;
	_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("(root namespace)");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("namespace %s", _tmp4_);
		result = _tmp5_;
		return result;
	}
}

static void
vala_namespace_class_init (ValaNamespaceClass * klass,
                           gpointer klass_data)
{
	vala_namespace_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_namespace_finalize;
	g_type_class_adjust_private_offset (klass, &ValaNamespace_private_offset);
	((ValaSymbolClass *) klass)->add_namespace = (void (*) (ValaSymbol*, ValaNamespace*)) vala_namespace_real_add_namespace;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol*, ValaClass*)) vala_namespace_real_add_class;
	((ValaSymbolClass *) klass)->add_interface = (void (*) (ValaSymbol*, ValaInterface*)) vala_namespace_real_add_interface;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol*, ValaStruct*)) vala_namespace_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol*, ValaEnum*)) vala_namespace_real_add_enum;
	((ValaSymbolClass *) klass)->add_error_domain = (void (*) (ValaSymbol*, ValaErrorDomain*)) vala_namespace_real_add_error_domain;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol*, ValaDelegate*)) vala_namespace_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol*, ValaConstant*)) vala_namespace_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_namespace_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_namespace_real_add_method;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_namespace_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_namespace_real_check;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_namespace_real_to_string;
}

static void
vala_namespace_instance_init (ValaNamespace * self,
                              gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	GEqualFunc _tmp20_;
	ValaArrayList* _tmp21_;
	GEqualFunc _tmp22_;
	ValaArrayList* _tmp23_;
	self->priv = vala_namespace_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->classes = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->interfaces = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->structs = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->enums = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_ERROR_DOMAIN, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->error_domains = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->delegates = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->constants = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->fields = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->methods = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, (GDestroyNotify) vala_comment_unref, _tmp18_);
	self->priv->comments = (ValaList*) _tmp19_;
	_tmp20_ = g_direct_equal;
	_tmp21_ = vala_array_list_new (VALA_TYPE_NAMESPACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp20_);
	self->priv->namespaces = (ValaList*) _tmp21_;
	_tmp22_ = g_direct_equal;
	_tmp23_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp22_);
	self->priv->using_directives = (ValaList*) _tmp23_;
}

static void
vala_namespace_finalize (ValaCodeNode * obj)
{
	ValaNamespace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_NAMESPACE, ValaNamespace);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->interfaces);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->error_domains);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->comments);
	_vala_iterable_unref0 (self->priv->namespaces);
	_vala_iterable_unref0 (self->priv->using_directives);
	VALA_CODE_NODE_CLASS (vala_namespace_parent_class)->finalize (obj);
}

/**
 * Represents a namespace declaration in the source code.
 */
GType
vala_namespace_get_type (void)
{
	static volatile gsize vala_namespace_type_id__volatile = 0;
	if (g_once_init_enter (&vala_namespace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaNamespaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_namespace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaNamespace), 0, (GInstanceInitFunc) vala_namespace_instance_init, NULL };
		GType vala_namespace_type_id;
		vala_namespace_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaNamespace", &g_define_type_info, 0);
		ValaNamespace_private_offset = g_type_add_instance_private (vala_namespace_type_id, sizeof (ValaNamespacePrivate));
		g_once_init_leave (&vala_namespace_type_id__volatile, vala_namespace_type_id);
	}
	return vala_namespace_type_id__volatile;
}

