/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};

static gint ValaLocalVariable_private_offset;
static gpointer vala_local_variable_parent_class = NULL;

static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);
static GType vala_local_variable_get_type_once (void);

static inline gpointer
vala_local_variable_get_instance_private (ValaLocalVariable* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLocalVariable_private_offset);
}

gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_result;
	return result;
}

void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}

gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_captured;
	return result;
}

void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}

gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_init;
	return result;
}

void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}

/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}

ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}

static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}

static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}

static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}

static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}

static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp35_;
	ValaExpression* _tmp36_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaArrayType* variable_array_type = NULL;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	gboolean _tmp104_ = FALSE;
	gboolean _tmp105_ = FALSE;
	gboolean _tmp106_ = FALSE;
	ValaArrayType* _tmp107_;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	ValaArrayType* _tmp122_;
	gboolean _tmp133_ = FALSE;
	ValaExpression* _tmp134_;
	ValaExpression* _tmp135_;
	ValaSemanticAnalyzer* _tmp241_;
	ValaSemanticAnalyzer* _tmp242_;
	ValaSymbol* _tmp243_;
	ValaSymbol* _tmp244_;
	ValaScope* _tmp245_;
	ValaScope* _tmp246_;
	const gchar* _tmp247_;
	const gchar* _tmp248_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp249_;
	ValaSemanticAnalyzer* _tmp250_;
	ValaSymbol* _tmp251_;
	ValaSymbol* _tmp252_;
	ValaBlock* _tmp253_;
	gboolean _tmp255_;
	gboolean _tmp256_;
	gboolean result = FALSE;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaVarType* _tmp6_;
		ValaVarType* _tmp7_;
		_tmp6_ = vala_var_type_new (TRUE);
		_tmp7_ = _tmp6_;
		vala_variable_set_variable_type ((ValaVariable*) self, (ValaDataType*) _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
	}
	_tmp8_ = vala_code_context_get_experimental_non_null (context);
	_tmp9_ = _tmp8_;
	if (!_tmp9_) {
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_REFERENCE_TYPE (_tmp11_)) {
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaArrayType* _tmp15_;
			_tmp12_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp13_ = _tmp12_;
			array_type = VALA_IS_ARRAY_TYPE (_tmp13_) ? ((ValaArrayType*) _tmp13_) : NULL;
			_tmp15_ = array_type;
			if (_tmp15_ != NULL) {
				ValaArrayType* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
				_tmp16_ = array_type;
				_tmp17_ = vala_array_type_get_fixed_length (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp14_ = _tmp18_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
			} else {
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp20_ = _tmp19_;
				vala_data_type_set_nullable (_tmp20_, TRUE);
			}
		}
	}
	_tmp21_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp22_ = _tmp21_;
	if (!VALA_IS_VAR_TYPE (_tmp22_)) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		gboolean _tmp29_;
		gboolean _tmp30_;
		_tmp23_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp24_ = _tmp23_;
		if (VALA_IS_VOID_TYPE (_tmp24_)) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp27_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp28_ = _tmp27_;
		vala_code_node_check ((ValaCodeNode*) _tmp28_, context);
		_tmp29_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp30_ = _tmp29_;
		if (!_tmp30_) {
			ValaSemanticAnalyzer* _tmp31_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			_tmp31_ = vala_code_context_get_analyzer (context);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp34_ = _tmp33_;
			vala_semantic_analyzer_check_type (_tmp32_, _tmp34_);
		}
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp35_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp36_ = _tmp35_;
	if (_tmp36_ != NULL) {
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		ValaExpression* _tmp47_;
		ValaExpression* _tmp48_;
		_tmp37_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		vala_expression_set_target_type (_tmp38_, _tmp40_);
		_tmp41_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp42_ = _tmp41_;
		if (VALA_IS_INITIALIZER_LIST (_tmp42_)) {
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			_tmp43_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp46_ = _tmp45_;
			initializer_size = _tmp46_;
			is_initializer_list = TRUE;
		}
		_tmp47_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp48_ = _tmp47_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp48_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp49_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp50_ = _tmp49_;
	if (VALA_IS_VAR_TYPE (_tmp50_)) {
		ValaExpression* _tmp51_;
		ValaExpression* _tmp52_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaDataType* _tmp57_;
		ValaDataType* _tmp58_;
		gboolean _tmp61_ = FALSE;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		gboolean value_owned = FALSE;
		ValaDataType* _tmp82_;
		ValaDataType* _tmp83_;
		gboolean _tmp84_;
		gboolean _tmp85_;
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaDataType* _tmp88_;
		ValaDataType* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		ValaDataType* _tmp92_;
		ValaDataType* _tmp93_;
		ValaDataType* _tmp94_;
		ValaDataType* _tmp95_;
		ValaExpression* _tmp96_;
		ValaExpression* _tmp97_;
		ValaDataType* _tmp98_;
		ValaDataType* _tmp99_;
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp52_ = _tmp51_;
		if (_tmp52_ == NULL) {
			ValaSourceReference* _tmp53_;
			ValaSourceReference* _tmp54_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp54_ = _tmp53_;
			vala_report_error (_tmp54_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp55_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_expression_get_value_type (_tmp56_);
		_tmp58_ = _tmp57_;
		if (_tmp58_ == NULL) {
			ValaSourceReference* _tmp59_;
			ValaSourceReference* _tmp60_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp60_ = _tmp59_;
			vala_report_error (_tmp60_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp62_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_expression_get_value_type (_tmp63_);
		_tmp65_ = _tmp64_;
		if (VALA_IS_FIELD_PROTOTYPE (_tmp65_)) {
			_tmp61_ = TRUE;
		} else {
			ValaExpression* _tmp66_;
			ValaExpression* _tmp67_;
			ValaDataType* _tmp68_;
			ValaDataType* _tmp69_;
			_tmp66_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_expression_get_value_type (_tmp67_);
			_tmp69_ = _tmp68_;
			_tmp61_ = VALA_IS_PROPERTY_PROTOTYPE (_tmp69_);
		}
		if (_tmp61_) {
			ValaExpression* _tmp70_;
			ValaExpression* _tmp71_;
			ValaSourceReference* _tmp72_;
			ValaSourceReference* _tmp73_;
			ValaExpression* _tmp74_;
			ValaExpression* _tmp75_;
			ValaSymbol* _tmp76_;
			ValaSymbol* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp70_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp71_ = _tmp70_;
			_tmp72_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_expression_get_symbol_reference (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_symbol_get_full_name (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp79_);
			_tmp81_ = _tmp80_;
			vala_report_error (_tmp73_, _tmp81_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
			result = FALSE;
			return result;
		}
		_tmp82_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_data_type_get_value_owned (_tmp83_);
		_tmp85_ = _tmp84_;
		value_owned = _tmp85_;
		_tmp86_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_expression_get_value_type (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_data_type_copy (_tmp89_);
		_tmp91_ = _tmp90_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp91_);
		_vala_code_node_unref0 (_tmp91_);
		_tmp92_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp93_ = _tmp92_;
		vala_data_type_set_value_owned (_tmp93_, value_owned);
		_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp95_ = _tmp94_;
		vala_data_type_set_floating_reference (_tmp95_, FALSE);
		_tmp96_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp97_ = _tmp96_;
		_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp99_ = _tmp98_;
		vala_expression_set_target_type (_tmp97_, _tmp99_);
		_tmp100_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp101_ = _tmp100_;
		vala_code_node_check ((ValaCodeNode*) _tmp101_, context);
	}
	_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp103_ = _tmp102_;
	variable_array_type = VALA_IS_ARRAY_TYPE (_tmp103_) ? ((ValaArrayType*) _tmp103_) : NULL;
	_tmp107_ = variable_array_type;
	if (_tmp107_ != NULL) {
		ValaArrayType* _tmp108_;
		gboolean _tmp109_;
		gboolean _tmp110_;
		_tmp108_ = variable_array_type;
		_tmp109_ = vala_array_type_get_fixed_length (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp106_ = _tmp110_;
	} else {
		_tmp106_ = FALSE;
	}
	if (_tmp106_) {
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		_tmp111_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp112_ = _tmp111_;
		_tmp105_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp112_);
	} else {
		_tmp105_ = FALSE;
	}
	if (_tmp105_) {
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaInitializerList* _tmp115_;
		ValaInitializerList* _tmp116_;
		_tmp113_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_array_creation_expression_get_initializer_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp114_, VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression));
		_tmp116_ = _tmp115_;
		_tmp104_ = _tmp116_ == NULL;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaSourceReference* _tmp117_;
		ValaSourceReference* _tmp118_;
		_tmp117_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp118_ = _tmp117_;
		vala_report_warning (_tmp118_, "Arrays with fixed length don't require an explicit instantiation");
		vala_variable_set_initializer ((ValaVariable*) self, NULL);
	}
	_tmp122_ = variable_array_type;
	if (_tmp122_ != NULL) {
		ValaArrayType* _tmp123_;
		gboolean _tmp124_;
		gboolean _tmp125_;
		_tmp123_ = variable_array_type;
		_tmp124_ = vala_array_type_get_inline_allocated (_tmp123_);
		_tmp125_ = _tmp124_;
		_tmp121_ = _tmp125_;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		ValaArrayType* _tmp126_;
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		_tmp126_ = variable_array_type;
		_tmp127_ = vala_array_type_get_length (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp120_ = _tmp128_ == NULL;
	} else {
		_tmp120_ = FALSE;
	}
	if (_tmp120_) {
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		_tmp129_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp130_ = _tmp129_;
		_tmp119_ = !VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp130_);
	} else {
		_tmp119_ = FALSE;
	}
	if (_tmp119_) {
		ValaSourceReference* _tmp131_;
		ValaSourceReference* _tmp132_;
		_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp132_ = _tmp131_;
		vala_report_error (_tmp132_, "Inline allocated array requires either a given length or an initialize" \
"r");
	}
	_tmp134_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp135_ = _tmp134_;
	if (_tmp135_ != NULL) {
		ValaExpression* _tmp136_;
		ValaExpression* _tmp137_;
		gboolean _tmp138_;
		gboolean _tmp139_;
		_tmp136_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_code_node_get_error ((ValaCodeNode*) _tmp137_);
		_tmp139_ = _tmp138_;
		_tmp133_ = !_tmp139_;
	} else {
		_tmp133_ = FALSE;
	}
	if (_tmp133_) {
		ValaExpression* _tmp140_;
		ValaExpression* _tmp141_;
		ValaDataType* _tmp142_;
		ValaDataType* _tmp143_;
		ValaExpression* _tmp179_;
		ValaExpression* _tmp180_;
		ValaDataType* _tmp181_;
		ValaDataType* _tmp182_;
		ValaDataType* _tmp183_;
		ValaDataType* _tmp184_;
		gboolean _tmp199_ = FALSE;
		gboolean _tmp200_ = FALSE;
		gboolean _tmp201_ = FALSE;
		ValaArrayType* _tmp202_;
		gboolean _tmp216_ = FALSE;
		gboolean _tmp217_ = FALSE;
		ValaArrayType* _tmp218_;
		ValaExpression* _tmp228_;
		ValaExpression* _tmp229_;
		ValaDataType* _tmp230_;
		ValaDataType* _tmp231_;
		_tmp140_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp141_ = _tmp140_;
		_tmp142_ = vala_expression_get_value_type (_tmp141_);
		_tmp143_ = _tmp142_;
		if (VALA_IS_METHOD_TYPE (_tmp143_)) {
			gboolean _tmp144_ = FALSE;
			ValaExpression* _tmp145_;
			ValaExpression* _tmp146_;
			ValaDataType* _tmp151_;
			ValaDataType* _tmp152_;
			_tmp145_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp146_ = _tmp145_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp146_)) {
				ValaExpression* _tmp147_;
				ValaExpression* _tmp148_;
				_tmp147_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp148_ = _tmp147_;
				_tmp144_ = !VALA_IS_LAMBDA_EXPRESSION (_tmp148_);
			} else {
				_tmp144_ = FALSE;
			}
			if (_tmp144_) {
				ValaSourceReference* _tmp149_;
				ValaSourceReference* _tmp150_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp150_ = _tmp149_;
				vala_report_error (_tmp150_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp151_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp152_ = _tmp151_;
			if (VALA_IS_DELEGATE_TYPE (_tmp152_)) {
				ValaExpression* _tmp153_;
				ValaExpression* _tmp154_;
				ValaDataType* _tmp155_;
				ValaDataType* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				_tmp153_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp154_ = _tmp153_;
				_tmp155_ = vala_expression_get_value_type (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp158_ = _tmp157_;
				if (!vala_data_type_compatible (_tmp156_, _tmp158_)) {
					ValaMethod* m = NULL;
					ValaExpression* _tmp159_;
					ValaExpression* _tmp160_;
					ValaSymbol* _tmp161_;
					ValaSymbol* _tmp162_;
					ValaDelegate* cb = NULL;
					ValaDataType* _tmp163_;
					ValaDataType* _tmp164_;
					ValaDelegate* _tmp165_;
					ValaDelegate* _tmp166_;
					ValaSourceReference* _tmp167_;
					ValaSourceReference* _tmp168_;
					ValaMethod* _tmp169_;
					gchar* _tmp170_;
					gchar* _tmp171_;
					ValaDelegate* _tmp172_;
					gchar* _tmp173_;
					gchar* _tmp174_;
					gchar* _tmp175_;
					gchar* _tmp176_;
					_tmp159_ = vala_variable_get_initializer ((ValaVariable*) self);
					_tmp160_ = _tmp159_;
					_tmp161_ = vala_expression_get_symbol_reference (_tmp160_);
					_tmp162_ = _tmp161_;
					m = G_TYPE_CHECK_INSTANCE_CAST (_tmp162_, VALA_TYPE_METHOD, ValaMethod);
					_tmp163_ = vala_variable_get_variable_type ((ValaVariable*) self);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp166_ = _tmp165_;
					cb = _tmp166_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp168_ = _tmp167_;
					_tmp169_ = m;
					_tmp170_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp169_);
					_tmp171_ = _tmp170_;
					_tmp172_ = cb;
					_tmp173_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp172_);
					_tmp174_ = _tmp173_;
					_tmp175_ = g_strdup_printf ("Declaration of method `%s' is not compatible with delegate `%s'", _tmp171_, _tmp174_);
					_tmp176_ = _tmp175_;
					vala_report_error (_tmp168_, _tmp176_);
					_g_free0 (_tmp176_);
					_g_free0 (_tmp174_);
					_g_free0 (_tmp171_);
					result = FALSE;
					return result;
				}
			} else {
				ValaSourceReference* _tmp177_;
				ValaSourceReference* _tmp178_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp178_ = _tmp177_;
				vala_report_error (_tmp178_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_expression_get_value_type (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp184_ = _tmp183_;
		if (!vala_data_type_compatible (_tmp182_, _tmp184_)) {
			ValaSourceReference* _tmp185_;
			ValaSourceReference* _tmp186_;
			ValaExpression* _tmp187_;
			ValaExpression* _tmp188_;
			ValaDataType* _tmp189_;
			ValaDataType* _tmp190_;
			gchar* _tmp191_;
			gchar* _tmp192_;
			ValaDataType* _tmp193_;
			ValaDataType* _tmp194_;
			gchar* _tmp195_;
			gchar* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp186_ = _tmp185_;
			_tmp187_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp188_ = _tmp187_;
			_tmp189_ = vala_expression_get_value_type (_tmp188_);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_code_node_to_string ((ValaCodeNode*) _tmp190_);
			_tmp192_ = _tmp191_;
			_tmp193_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp194_ = _tmp193_;
			_tmp195_ = vala_code_node_to_string ((ValaCodeNode*) _tmp194_);
			_tmp196_ = _tmp195_;
			_tmp197_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp192_, _tmp196_);
			_tmp198_ = _tmp197_;
			vala_report_error (_tmp186_, _tmp198_);
			_g_free0 (_tmp198_);
			_g_free0 (_tmp196_);
			_g_free0 (_tmp192_);
			result = FALSE;
			return result;
		}
		_tmp202_ = variable_array_type;
		if (_tmp202_ != NULL) {
			ValaArrayType* _tmp203_;
			gboolean _tmp204_;
			gboolean _tmp205_;
			_tmp203_ = variable_array_type;
			_tmp204_ = vala_array_type_get_inline_allocated (_tmp203_);
			_tmp205_ = _tmp204_;
			_tmp201_ = _tmp205_;
		} else {
			_tmp201_ = FALSE;
		}
		if (_tmp201_) {
			ValaArrayType* _tmp206_;
			gboolean _tmp207_;
			gboolean _tmp208_;
			_tmp206_ = variable_array_type;
			_tmp207_ = vala_array_type_get_fixed_length (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp200_ = !_tmp208_;
		} else {
			_tmp200_ = FALSE;
		}
		if (_tmp200_) {
			_tmp199_ = is_initializer_list;
		} else {
			_tmp199_ = FALSE;
		}
		if (_tmp199_) {
			ValaArrayType* _tmp209_;
			gchar* _tmp210_;
			gchar* _tmp211_;
			ValaIntegerLiteral* _tmp212_;
			ValaIntegerLiteral* _tmp213_;
			ValaArrayType* _tmp214_;
			ValaArrayType* _tmp215_;
			_tmp209_ = variable_array_type;
			_tmp210_ = g_strdup_printf ("%i", initializer_size);
			_tmp211_ = _tmp210_;
			_tmp212_ = vala_integer_literal_new (_tmp211_, NULL);
			_tmp213_ = _tmp212_;
			vala_array_type_set_length (_tmp209_, (ValaExpression*) _tmp213_);
			_vala_code_node_unref0 (_tmp213_);
			_g_free0 (_tmp211_);
			_tmp214_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp214_, TRUE);
			_tmp215_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp215_, FALSE);
		}
		_tmp218_ = variable_array_type;
		if (_tmp218_ != NULL) {
			ValaArrayType* _tmp219_;
			gboolean _tmp220_;
			gboolean _tmp221_;
			_tmp219_ = variable_array_type;
			_tmp220_ = vala_array_type_get_inline_allocated (_tmp219_);
			_tmp221_ = _tmp220_;
			_tmp217_ = _tmp221_;
		} else {
			_tmp217_ = FALSE;
		}
		if (_tmp217_) {
			ValaExpression* _tmp222_;
			ValaExpression* _tmp223_;
			ValaDataType* _tmp224_;
			ValaDataType* _tmp225_;
			_tmp222_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp223_ = _tmp222_;
			_tmp224_ = vala_expression_get_value_type (_tmp223_);
			_tmp225_ = _tmp224_;
			_tmp216_ = VALA_IS_ARRAY_TYPE (_tmp225_) == FALSE;
		} else {
			_tmp216_ = FALSE;
		}
		if (_tmp216_) {
			ValaSourceReference* _tmp226_;
			ValaSourceReference* _tmp227_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp227_ = _tmp226_;
			vala_report_error (_tmp227_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			return result;
		}
		_tmp228_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_expression_get_value_type (_tmp229_);
		_tmp231_ = _tmp230_;
		if (vala_data_type_is_disposable (_tmp231_)) {
			gboolean _tmp232_ = FALSE;
			ValaDataType* _tmp233_;
			ValaDataType* _tmp234_;
			_tmp233_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp234_ = _tmp233_;
			if (!VALA_IS_POINTER_TYPE (_tmp234_)) {
				ValaDataType* _tmp235_;
				ValaDataType* _tmp236_;
				gboolean _tmp237_;
				gboolean _tmp238_;
				_tmp235_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp236_ = _tmp235_;
				_tmp237_ = vala_data_type_get_value_owned (_tmp236_);
				_tmp238_ = _tmp237_;
				_tmp232_ = !_tmp238_;
			} else {
				_tmp232_ = FALSE;
			}
			if (_tmp232_) {
				ValaSourceReference* _tmp239_;
				ValaSourceReference* _tmp240_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp239_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp240_ = _tmp239_;
				vala_report_error (_tmp240_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				return result;
			}
		}
	}
	_tmp241_ = vala_code_context_get_analyzer (context);
	_tmp242_ = _tmp241_;
	_tmp243_ = vala_semantic_analyzer_get_current_symbol (_tmp242_);
	_tmp244_ = _tmp243_;
	_tmp245_ = vala_symbol_get_scope (_tmp244_);
	_tmp246_ = _tmp245_;
	_tmp247_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp248_ = _tmp247_;
	vala_scope_add (_tmp246_, _tmp248_, (ValaSymbol*) self);
	_tmp249_ = vala_code_context_get_analyzer (context);
	_tmp250_ = _tmp249_;
	_tmp251_ = vala_semantic_analyzer_get_current_symbol (_tmp250_);
	_tmp252_ = _tmp251_;
	block = VALA_IS_BLOCK (_tmp252_) ? ((ValaBlock*) _tmp252_) : NULL;
	_tmp253_ = block;
	if (_tmp253_ != NULL) {
		ValaBlock* _tmp254_;
		_tmp254_ = block;
		vala_block_add_local_variable (_tmp254_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp255_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp256_ = _tmp255_;
	result = !_tmp256_;
	return result;
}

static void
vala_local_variable_class_init (ValaLocalVariableClass * klass,
                                gpointer klass_data)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLocalVariable_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}

static void
vala_local_variable_instance_init (ValaLocalVariable * self,
                                   gpointer klass)
{
	self->priv = vala_local_variable_get_instance_private (self);
}

static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}

/**
 * Represents a local variable declaration in the source code.
 */
static GType
vala_local_variable_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
	GType vala_local_variable_type_id;
	vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
	ValaLocalVariable_private_offset = g_type_add_instance_private (vala_local_variable_type_id, sizeof (ValaLocalVariablePrivate));
	return vala_local_variable_type_id;
}

GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = vala_local_variable_get_type_once ();
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}

