/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp9_ = _type_arg_list;
			_tmp10_ = vala_list_get (_tmp9_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp10_;
			_tmp11_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp16_;
	gboolean _tmp601_ = FALSE;
	gboolean _tmp602_ = FALSE;
	gboolean _tmp603_ = FALSE;
	ValaExpression* _tmp604_;
	ValaExpression* _tmp605_;
	ValaSymbol* _tmp631_;
	ValaSymbol* _tmp632_;
	ValaSymbol* _tmp686_;
	ValaSymbol* _tmp687_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp725_;
	ValaSymbol* _tmp726_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp727_;
	ValaSymbol* _tmp728_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1115_;
	ValaSymbol* _tmp1116_;
	ValaSymbol* _tmp1118_;
	ValaVersionAttribute* _tmp1119_;
	ValaVersionAttribute* _tmp1120_;
	ValaSourceReference* _tmp1121_;
	ValaSourceReference* _tmp1122_;
	gboolean _tmp1123_ = FALSE;
	ValaSymbolAccessibility _tmp1124_;
	gboolean _tmp1180_ = FALSE;
	gboolean _tmp1207_ = FALSE;
	gboolean _tmp1208_ = FALSE;
	ValaDataType* _tmp1485_;
	ValaDataType* _tmp1486_;
	gboolean _tmp1489_;
	gboolean _tmp1490_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			ValaDataType* type_arg = NULL;
			ValaList* _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_type_arg_index = _type_arg_index + 1;
			if (!(_type_arg_index < _type_arg_size)) {
				break;
			}
			_tmp13_ = _type_arg_list;
			_tmp14_ = vala_list_get (_tmp13_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp15_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp16_ = self->priv->_qualified;
	if (_tmp16_) {
		ValaNamespace* _tmp17_;
		ValaNamespace* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		const gchar* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp17_ = vala_code_context_get_root (context);
		_tmp18_ = _tmp17_;
		base_symbol = (ValaSymbol*) _tmp18_;
		_tmp19_ = base_symbol;
		_tmp20_ = vala_symbol_get_scope (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_member_name;
		_tmp23_ = vala_scope_lookup (_tmp21_, _tmp22_);
		_tmp24_ = _tmp23_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp24_);
		_vala_code_node_unref0 (_tmp24_);
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		_tmp25_ = vala_member_access_get_inner (self);
		_tmp26_ = _tmp25_;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_;
			ValaSemanticAnalyzer* _tmp32_;
			ValaSemanticAnalyzer* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			gboolean _tmp138_ = FALSE;
			ValaSymbol* _tmp139_;
			ValaSymbol* _tmp140_;
			_tmp27_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp27_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp28_;
				ValaSemanticAnalyzer* _tmp29_;
				_tmp28_ = vala_code_context_get_analyzer (context);
				_tmp29_ = _tmp28_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp29_)) {
					ValaSourceReference* _tmp30_;
					ValaSourceReference* _tmp31_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					vala_report_error (_tmp31_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp32_ = vala_code_context_get_analyzer (context);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_semantic_analyzer_get_current_symbol (_tmp33_);
			_tmp35_ = _tmp34_;
			base_symbol = _tmp35_;
			method_found = FALSE;
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			sym = _tmp39_;
			while (TRUE) {
				gboolean _tmp40_ = FALSE;
				ValaSymbol* _tmp41_;
				ValaSymbol* _tmp87_;
				const gchar* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaSymbol* _tmp90_;
				gboolean _tmp91_ = FALSE;
				gboolean _tmp92_ = FALSE;
				ValaSymbol* _tmp93_;
				ValaSymbol* _tmp94_;
				ValaSymbol* _tmp132_;
				ValaSymbol* _tmp133_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp136_;
				ValaSymbol* _tmp137_;
				_tmp41_ = sym;
				if (_tmp41_ != NULL) {
					ValaSymbol* _tmp42_;
					ValaSymbol* _tmp43_;
					_tmp42_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp43_ = _tmp42_;
					_tmp40_ = _tmp43_ == NULL;
				} else {
					_tmp40_ = FALSE;
				}
				if (!_tmp40_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp44_;
					_tmp44_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp44_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp45_;
						ValaCreationMethod* _tmp46_;
						ValaParameter* _tmp47_;
						ValaParameter* _tmp48_;
						_tmp45_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp46_ = cm;
						_tmp47_ = vala_method_get_this_parameter ((ValaMethod*) _tmp46_);
						_tmp48_ = _tmp47_;
						this_parameter = _tmp48_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp49_;
						_tmp49_ = sym;
						if (VALA_IS_PROPERTY (_tmp49_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp50_;
							ValaProperty* _tmp51_;
							ValaParameter* _tmp52_;
							ValaParameter* _tmp53_;
							ValaProperty* _tmp54_;
							ValaMemberBinding _tmp55_;
							ValaMemberBinding _tmp56_;
							ValaProperty* _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaMemberBinding _tmp59_;
							_tmp50_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp51_ = prop;
							_tmp52_ = vala_property_get_this_parameter (_tmp51_);
							_tmp53_ = _tmp52_;
							this_parameter = _tmp53_;
							_tmp54_ = prop;
							_tmp55_ = vala_property_get_binding (_tmp54_);
							_tmp56_ = _tmp55_;
							may_access_instance_members = _tmp56_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp57_ = prop;
							_tmp58_ = vala_property_get_binding (_tmp57_);
							_tmp59_ = _tmp58_;
							may_access_klass_members = _tmp59_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp60_;
							_tmp60_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp60_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp61_;
								ValaConstructor* _tmp62_;
								ValaParameter* _tmp63_;
								ValaParameter* _tmp64_;
								ValaConstructor* _tmp65_;
								ValaMemberBinding _tmp66_;
								ValaMemberBinding _tmp67_;
								_tmp61_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp62_ = c;
								_tmp63_ = vala_constructor_get_this_parameter (_tmp62_);
								_tmp64_ = _tmp63_;
								this_parameter = _tmp64_;
								_tmp65_ = c;
								_tmp66_ = vala_constructor_get_binding (_tmp65_);
								_tmp67_ = _tmp66_;
								may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp68_;
								_tmp68_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp68_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp69_;
									ValaDestructor* _tmp70_;
									ValaParameter* _tmp71_;
									ValaParameter* _tmp72_;
									ValaDestructor* _tmp73_;
									ValaMemberBinding _tmp74_;
									ValaMemberBinding _tmp75_;
									_tmp69_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp70_ = d;
									_tmp71_ = vala_destructor_get_this_parameter (_tmp70_);
									_tmp72_ = _tmp71_;
									this_parameter = _tmp72_;
									_tmp73_ = d;
									_tmp74_ = vala_destructor_get_binding (_tmp73_);
									_tmp75_ = _tmp74_;
									may_access_instance_members = _tmp75_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp76_;
									_tmp76_ = sym;
									if (VALA_IS_METHOD (_tmp76_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp77_;
										ValaMethod* _tmp78_;
										ValaParameter* _tmp79_;
										ValaParameter* _tmp80_;
										ValaMethod* _tmp81_;
										ValaMemberBinding _tmp82_;
										ValaMemberBinding _tmp83_;
										ValaMethod* _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMemberBinding _tmp86_;
										_tmp77_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_METHOD, ValaMethod);
										_tmp78_ = m;
										_tmp79_ = vala_method_get_this_parameter (_tmp78_);
										_tmp80_ = _tmp79_;
										this_parameter = _tmp80_;
										_tmp81_ = m;
										_tmp82_ = vala_method_get_binding (_tmp81_);
										_tmp83_ = _tmp82_;
										may_access_instance_members = _tmp83_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp84_ = m;
										_tmp85_ = vala_method_get_binding (_tmp84_);
										_tmp86_ = _tmp85_;
										may_access_klass_members = _tmp86_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp87_ = sym;
				_tmp88_ = self->priv->_member_name;
				_tmp89_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp87_, _tmp88_);
				_tmp90_ = _tmp89_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp90_);
				_vala_code_node_unref0 (_tmp90_);
				_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp94_ = _tmp93_;
				if (_tmp94_ == NULL) {
					ValaSymbol* _tmp95_;
					_tmp95_ = sym;
					_tmp92_ = VALA_IS_TYPESYMBOL (_tmp95_);
				} else {
					_tmp92_ = FALSE;
				}
				if (_tmp92_) {
					_tmp91_ = may_access_instance_members;
				} else {
					_tmp91_ = FALSE;
				}
				if (_tmp91_) {
					ValaParameter* _tmp96_;
					ValaDataType* _tmp97_;
					ValaDataType* _tmp98_;
					const gchar* _tmp99_;
					ValaSymbol* _tmp100_;
					ValaSymbol* _tmp101_;
					gboolean _tmp102_ = FALSE;
					ValaSymbol* _tmp103_;
					ValaSymbol* _tmp104_;
					_tmp96_ = this_parameter;
					_tmp97_ = vala_variable_get_variable_type ((ValaVariable*) _tmp96_);
					_tmp98_ = _tmp97_;
					_tmp99_ = self->priv->_member_name;
					_tmp100_ = vala_data_type_get_member (_tmp98_, _tmp99_);
					_tmp101_ = _tmp100_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp101_);
					_vala_code_node_unref0 (_tmp101_);
					_tmp103_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp104_ = _tmp103_;
					if (_tmp104_ != NULL) {
						ValaSymbol* _tmp105_;
						ValaSymbol* _tmp106_;
						_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp106_ = _tmp105_;
						_tmp102_ = vala_member_access_is_instance_symbol (_tmp106_);
					} else {
						_tmp102_ = FALSE;
					}
					if (_tmp102_) {
						ValaSourceReference* _tmp107_;
						ValaSourceReference* _tmp108_;
						ValaMemberAccess* _tmp109_;
						ValaMemberAccess* _tmp110_;
						ValaExpression* _tmp111_;
						ValaExpression* _tmp112_;
						ValaParameter* _tmp113_;
						ValaDataType* _tmp114_;
						ValaDataType* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaExpression* _tmp118_;
						ValaExpression* _tmp119_;
						ValaDataType* _tmp120_;
						ValaDataType* _tmp121_;
						ValaExpression* _tmp122_;
						ValaExpression* _tmp123_;
						ValaParameter* _tmp124_;
						ValaExpression* _tmp125_;
						ValaExpression* _tmp126_;
						ValaDataType* _tmp127_;
						ValaDataType* _tmp128_;
						const gchar* _tmp129_;
						ValaSymbol* _tmp130_;
						ValaSymbol* _tmp131_;
						_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp108_ = _tmp107_;
						_tmp109_ = vala_member_access_new (NULL, "this", _tmp108_);
						_tmp110_ = _tmp109_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp110_);
						_vala_code_node_unref0 (_tmp110_);
						_tmp111_ = vala_member_access_get_inner (self);
						_tmp112_ = _tmp111_;
						_tmp113_ = this_parameter;
						_tmp114_ = vala_variable_get_variable_type ((ValaVariable*) _tmp113_);
						_tmp115_ = _tmp114_;
						_tmp116_ = vala_data_type_copy (_tmp115_);
						_tmp117_ = _tmp116_;
						vala_expression_set_value_type (_tmp112_, _tmp117_);
						_vala_code_node_unref0 (_tmp117_);
						_tmp118_ = vala_member_access_get_inner (self);
						_tmp119_ = _tmp118_;
						_tmp120_ = vala_expression_get_value_type (_tmp119_);
						_tmp121_ = _tmp120_;
						vala_data_type_set_value_owned (_tmp121_, FALSE);
						_tmp122_ = vala_member_access_get_inner (self);
						_tmp123_ = _tmp122_;
						_tmp124_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp123_, (ValaSymbol*) _tmp124_);
						_tmp125_ = vala_member_access_get_inner (self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_expression_get_value_type (_tmp126_);
						_tmp128_ = _tmp127_;
						_tmp129_ = self->priv->_member_name;
						_tmp130_ = vala_data_type_get_member (_tmp128_, _tmp129_);
						_tmp131_ = _tmp130_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp131_);
						_vala_code_node_unref0 (_tmp131_);
					}
				}
				_tmp132_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp133_ = _tmp132_;
				if (_tmp133_ == NULL) {
					ValaSymbol* _tmp134_;
					_tmp134_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp134_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp135_ = sym;
				_tmp136_ = vala_symbol_get_parent_symbol (_tmp135_);
				_tmp137_ = _tmp136_;
				sym = _tmp137_;
			}
			_tmp139_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp140_ = _tmp139_;
			if (_tmp140_ == NULL) {
				ValaSourceReference* _tmp141_;
				ValaSourceReference* _tmp142_;
				_tmp141_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp142_ = _tmp141_;
				_tmp138_ = _tmp142_ != NULL;
			} else {
				_tmp138_ = FALSE;
			}
			if (_tmp138_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					ValaList* _tmp145_;
					ValaList* _tmp146_;
					ValaList* _tmp147_;
					gint _ns_size = 0;
					ValaList* _tmp148_;
					gint _tmp149_;
					gint _tmp150_;
					gint _ns_index = 0;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp144_ = _tmp143_;
					_tmp145_ = vala_source_reference_get_using_directives (_tmp144_);
					_tmp146_ = _tmp145_;
					_tmp147_ = _vala_iterable_ref0 (_tmp146_);
					_ns_list = _tmp147_;
					_tmp148_ = _ns_list;
					_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
					_tmp150_ = _tmp149_;
					_ns_size = _tmp150_;
					_ns_index = -1;
					while (TRUE) {
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp151_;
						gpointer _tmp152_;
						ValaUsingDirective* _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp155_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp156_;
						ValaSymbol* _tmp157_;
						ValaSymbol* _tmp158_;
						ValaScope* _tmp159_;
						ValaScope* _tmp160_;
						const gchar* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaSymbol* _tmp163_;
						_ns_index = _ns_index + 1;
						if (!(_ns_index < _ns_size)) {
							break;
						}
						_tmp151_ = _ns_list;
						_tmp152_ = vala_list_get (_tmp151_, _ns_index);
						ns = (ValaUsingDirective*) _tmp152_;
						_tmp153_ = ns;
						_tmp154_ = vala_code_node_get_error ((ValaCodeNode*) _tmp153_);
						_tmp155_ = _tmp154_;
						if (_tmp155_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp156_ = ns;
						_tmp157_ = vala_using_directive_get_namespace_symbol (_tmp156_);
						_tmp158_ = _tmp157_;
						_tmp159_ = vala_symbol_get_scope (_tmp158_);
						_tmp160_ = _tmp159_;
						_tmp161_ = self->priv->_member_name;
						_tmp162_ = vala_scope_lookup (_tmp160_, _tmp161_);
						local_sym = _tmp162_;
						_tmp163_ = local_sym;
						if (_tmp163_ != NULL) {
							gboolean _tmp164_ = FALSE;
							ValaSymbol* _tmp165_;
							ValaSymbol* _tmp166_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp182_;
							ValaSymbol* _tmp183_;
							ValaSymbol* _tmp184_;
							ValaMemberAccess* inner_ma = NULL;
							ValaExpression* _tmp204_;
							ValaExpression* _tmp205_;
							ValaSymbol* _tmp206_;
							_tmp165_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp166_ = _tmp165_;
							if (_tmp166_ != NULL) {
								ValaSymbol* _tmp167_;
								ValaSymbol* _tmp168_;
								ValaSymbol* _tmp169_;
								_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp168_ = _tmp167_;
								_tmp169_ = local_sym;
								_tmp164_ = _tmp168_ != _tmp169_;
							} else {
								_tmp164_ = FALSE;
							}
							if (_tmp164_) {
								ValaSourceReference* _tmp170_;
								ValaSourceReference* _tmp171_;
								const gchar* _tmp172_;
								ValaSymbol* _tmp173_;
								ValaSymbol* _tmp174_;
								gchar* _tmp175_;
								gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								gchar* _tmp181_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp170_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp171_ = _tmp170_;
								_tmp172_ = self->priv->_member_name;
								_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp174_ = _tmp173_;
								_tmp175_ = vala_symbol_get_full_name (_tmp174_);
								_tmp176_ = _tmp175_;
								_tmp177_ = local_sym;
								_tmp178_ = vala_symbol_get_full_name (_tmp177_);
								_tmp179_ = _tmp178_;
								_tmp180_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp172_, _tmp176_, _tmp179_);
								_tmp181_ = _tmp180_;
								vala_report_error (_tmp171_, _tmp181_);
								_g_free0 (_tmp181_);
								_g_free0 (_tmp179_);
								_g_free0 (_tmp176_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp182_ = local_sym;
							_tmp183_ = vala_symbol_get_parent_symbol (_tmp182_);
							_tmp184_ = _tmp183_;
							inner_sym = _tmp184_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp185_ = FALSE;
								ValaSymbol* _tmp186_;
								ValaMemberAccess* _tmp190_;
								ValaSymbol* _tmp191_;
								const gchar* _tmp192_;
								const gchar* _tmp193_;
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								ValaMemberAccess* _tmp196_;
								ValaMemberAccess* _tmp197_;
								ValaMemberAccess* _tmp198_;
								ValaExpression* _tmp199_;
								ValaExpression* _tmp200_;
								ValaSymbol* _tmp201_;
								ValaSymbol* _tmp202_;
								ValaSymbol* _tmp203_;
								_tmp186_ = inner_sym;
								if (_tmp186_ != NULL) {
									ValaSymbol* _tmp187_;
									const gchar* _tmp188_;
									const gchar* _tmp189_;
									_tmp187_ = inner_sym;
									_tmp188_ = vala_symbol_get_name (_tmp187_);
									_tmp189_ = _tmp188_;
									_tmp185_ = _tmp189_ != NULL;
								} else {
									_tmp185_ = FALSE;
								}
								if (!_tmp185_) {
									break;
								}
								_tmp190_ = inner_ma;
								_tmp191_ = inner_sym;
								_tmp192_ = vala_symbol_get_name (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_member_access_new (NULL, _tmp193_, _tmp195_);
								_tmp197_ = _tmp196_;
								vala_member_access_set_inner (_tmp190_, (ValaExpression*) _tmp197_);
								_vala_code_node_unref0 (_tmp197_);
								_tmp198_ = inner_ma;
								_tmp199_ = vala_member_access_get_inner (_tmp198_);
								_tmp200_ = _tmp199_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp200_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp201_ = inner_sym;
								_tmp202_ = vala_symbol_get_parent_symbol (_tmp201_);
								_tmp203_ = _tmp202_;
								inner_sym = _tmp203_;
							}
							_tmp204_ = vala_member_access_get_inner (self);
							_tmp205_ = _tmp204_;
							vala_code_node_check ((ValaCodeNode*) _tmp205_, context);
							_tmp206_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp206_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp207_;
			ValaExpression* _tmp208_;
			gboolean _tmp209_;
			gboolean _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaDataType* _tmp213_;
			ValaDataType* _tmp214_;
			ValaExpression* _tmp232_;
			ValaExpression* _tmp233_;
			gboolean _tmp248_ = FALSE;
			ValaExpression* _tmp249_;
			ValaExpression* _tmp250_;
			gboolean _tmp257_ = FALSE;
			ValaExpression* _tmp258_;
			ValaExpression* _tmp259_;
			gboolean _tmp280_ = FALSE;
			ValaExpression* _tmp281_;
			ValaExpression* _tmp282_;
			gboolean _tmp301_ = FALSE;
			ValaSymbol* _tmp302_;
			ValaSymbol* _tmp303_;
			gboolean _tmp337_ = FALSE;
			gboolean _tmp338_ = FALSE;
			ValaSymbol* _tmp339_;
			ValaSymbol* _tmp340_;
			gboolean _tmp572_ = FALSE;
			ValaSymbol* _tmp573_;
			ValaSymbol* _tmp574_;
			_tmp207_ = vala_member_access_get_inner (self);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) _tmp208_);
			_tmp210_ = _tmp209_;
			if (_tmp210_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp211_ = vala_member_access_get_inner (self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_value_type (_tmp212_);
			_tmp214_ = _tmp213_;
			if (VALA_IS_POINTER_TYPE (_tmp214_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp215_;
				ValaExpression* _tmp216_;
				ValaDataType* _tmp217_;
				ValaDataType* _tmp218_;
				gboolean _tmp219_ = FALSE;
				ValaPointerType* _tmp220_;
				_tmp215_ = vala_member_access_get_inner (self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_expression_get_value_type (_tmp216_);
				_tmp218_ = _tmp217_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp218_) ? ((ValaPointerType*) _tmp218_) : NULL;
				_tmp220_ = pointer_type;
				if (_tmp220_ != NULL) {
					ValaPointerType* _tmp221_;
					ValaDataType* _tmp222_;
					ValaDataType* _tmp223_;
					_tmp221_ = pointer_type;
					_tmp222_ = vala_pointer_type_get_base_type (_tmp221_);
					_tmp223_ = _tmp222_;
					_tmp219_ = VALA_IS_VALUE_TYPE (_tmp223_);
				} else {
					_tmp219_ = FALSE;
				}
				if (_tmp219_) {
					ValaExpression* _tmp224_;
					ValaExpression* _tmp225_;
					ValaSourceReference* _tmp226_;
					ValaSourceReference* _tmp227_;
					ValaPointerIndirection* _tmp228_;
					ValaPointerIndirection* _tmp229_;
					ValaExpression* _tmp230_;
					ValaExpression* _tmp231_;
					_tmp224_ = vala_member_access_get_inner (self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp227_ = _tmp226_;
					_tmp228_ = vala_pointer_indirection_new (_tmp225_, _tmp227_);
					_tmp229_ = _tmp228_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp229_);
					_vala_code_node_unref0 (_tmp229_);
					_tmp230_ = vala_member_access_get_inner (self);
					_tmp231_ = _tmp230_;
					vala_code_node_check ((ValaCodeNode*) _tmp231_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp232_ = vala_member_access_get_inner (self);
			_tmp233_ = _tmp232_;
			if (VALA_IS_MEMBER_ACCESS (_tmp233_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp234_;
				ValaExpression* _tmp235_;
				ValaMemberAccess* _tmp236_;
				gboolean _tmp237_;
				_tmp234_ = vala_member_access_get_inner (self);
				_tmp235_ = _tmp234_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp235_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp236_ = ma;
				_tmp237_ = _tmp236_->priv->_prototype_access;
				if (_tmp237_) {
					ValaSourceReference* _tmp238_;
					ValaSourceReference* _tmp239_;
					ValaExpression* _tmp240_;
					ValaExpression* _tmp241_;
					ValaSymbol* _tmp242_;
					ValaSymbol* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_member_access_get_inner (self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_expression_get_symbol_reference (_tmp241_);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_symbol_get_full_name (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp245_);
					_tmp247_ = _tmp246_;
					vala_report_error (_tmp239_, _tmp247_);
					_g_free0 (_tmp247_);
					_g_free0 (_tmp245_);
					result = FALSE;
					return result;
				}
			}
			_tmp249_ = vala_member_access_get_inner (self);
			_tmp250_ = _tmp249_;
			if (VALA_IS_CAST_EXPRESSION (_tmp250_)) {
				ValaExpression* _tmp251_;
				ValaExpression* _tmp252_;
				gboolean _tmp253_;
				gboolean _tmp254_;
				_tmp251_ = vala_member_access_get_inner (self);
				_tmp252_ = _tmp251_;
				_tmp253_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp252_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp254_ = _tmp253_;
				_tmp248_ = _tmp254_;
			} else {
				_tmp248_ = FALSE;
			}
			if (_tmp248_) {
				ValaSourceReference* _tmp255_;
				ValaSourceReference* _tmp256_;
				_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp256_ = _tmp255_;
				vala_report_warning (_tmp256_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp258_ = vala_member_access_get_inner (self);
			_tmp259_ = _tmp258_;
			if (VALA_IS_MEMBER_ACCESS (_tmp259_)) {
				_tmp257_ = TRUE;
			} else {
				ValaExpression* _tmp260_;
				ValaExpression* _tmp261_;
				_tmp260_ = vala_member_access_get_inner (self);
				_tmp261_ = _tmp260_;
				_tmp257_ = VALA_IS_BASE_ACCESS (_tmp261_);
			}
			if (_tmp257_) {
				ValaExpression* _tmp262_;
				ValaExpression* _tmp263_;
				ValaSymbol* _tmp264_;
				ValaSymbol* _tmp265_;
				gboolean _tmp266_ = FALSE;
				ValaSymbol* _tmp267_;
				ValaSymbol* _tmp268_;
				_tmp262_ = vala_member_access_get_inner (self);
				_tmp263_ = _tmp262_;
				_tmp264_ = vala_expression_get_symbol_reference (_tmp263_);
				_tmp265_ = _tmp264_;
				base_symbol = _tmp265_;
				_tmp267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp268_ = _tmp267_;
				if (_tmp268_ == NULL) {
					gboolean _tmp269_ = FALSE;
					ValaSymbol* _tmp270_;
					_tmp270_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp270_)) {
						_tmp269_ = TRUE;
					} else {
						ValaSymbol* _tmp271_;
						_tmp271_ = base_symbol;
						_tmp269_ = VALA_IS_TYPESYMBOL (_tmp271_);
					}
					_tmp266_ = _tmp269_;
				} else {
					_tmp266_ = FALSE;
				}
				if (_tmp266_) {
					ValaSymbol* _tmp272_;
					ValaScope* _tmp273_;
					ValaScope* _tmp274_;
					const gchar* _tmp275_;
					ValaSymbol* _tmp276_;
					ValaSymbol* _tmp277_;
					ValaExpression* _tmp278_;
					ValaExpression* _tmp279_;
					_tmp272_ = base_symbol;
					_tmp273_ = vala_symbol_get_scope (_tmp272_);
					_tmp274_ = _tmp273_;
					_tmp275_ = self->priv->_member_name;
					_tmp276_ = vala_scope_lookup (_tmp274_, _tmp275_);
					_tmp277_ = _tmp276_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp277_);
					_vala_code_node_unref0 (_tmp277_);
					_tmp278_ = vala_member_access_get_inner (self);
					_tmp279_ = _tmp278_;
					if (VALA_IS_BASE_ACCESS (_tmp279_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp281_ = vala_member_access_get_inner (self);
			_tmp282_ = _tmp281_;
			if (VALA_IS_MEMBER_ACCESS (_tmp282_)) {
				ValaExpression* _tmp283_;
				ValaExpression* _tmp284_;
				ValaSymbol* _tmp285_;
				ValaSymbol* _tmp286_;
				_tmp283_ = vala_member_access_get_inner (self);
				_tmp284_ = _tmp283_;
				_tmp285_ = vala_expression_get_symbol_reference (_tmp284_);
				_tmp286_ = _tmp285_;
				_tmp280_ = VALA_IS_TYPEPARAMETER (_tmp286_);
			} else {
				_tmp280_ = FALSE;
			}
			if (_tmp280_) {
				ValaExpression* _tmp287_;
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaExpression* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaSymbol* _tmp292_;
				ValaGenericType* _tmp293_;
				ValaGenericType* _tmp294_;
				ValaExpression* _tmp295_;
				ValaExpression* _tmp296_;
				ValaDataType* _tmp297_;
				ValaDataType* _tmp298_;
				ValaSourceReference* _tmp299_;
				ValaSourceReference* _tmp300_;
				_tmp287_ = vala_member_access_get_inner (self);
				_tmp288_ = _tmp287_;
				_tmp289_ = vala_member_access_get_inner (self);
				_tmp290_ = _tmp289_;
				_tmp291_ = vala_expression_get_symbol_reference (_tmp290_);
				_tmp292_ = _tmp291_;
				_tmp293_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp292_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp294_ = _tmp293_;
				vala_expression_set_value_type (_tmp288_, (ValaDataType*) _tmp294_);
				_vala_code_node_unref0 (_tmp294_);
				_tmp295_ = vala_member_access_get_inner (self);
				_tmp296_ = _tmp295_;
				_tmp297_ = vala_expression_get_value_type (_tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp300_ = _tmp299_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp298_, _tmp300_);
			}
			_tmp302_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp303_ = _tmp302_;
			if (_tmp303_ == NULL) {
				ValaExpression* _tmp304_;
				ValaExpression* _tmp305_;
				ValaDataType* _tmp306_;
				ValaDataType* _tmp307_;
				_tmp304_ = vala_member_access_get_inner (self);
				_tmp305_ = _tmp304_;
				_tmp306_ = vala_expression_get_value_type (_tmp305_);
				_tmp307_ = _tmp306_;
				_tmp301_ = _tmp307_ != NULL;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				gboolean _tmp308_;
				ValaSymbol* _tmp335_;
				ValaSymbol* _tmp336_;
				_tmp308_ = self->priv->_pointer_member_access;
				if (_tmp308_) {
					ValaExpression* _tmp309_;
					ValaExpression* _tmp310_;
					ValaDataType* _tmp311_;
					ValaDataType* _tmp312_;
					const gchar* _tmp313_;
					ValaSymbol* _tmp314_;
					ValaSymbol* _tmp315_;
					_tmp309_ = vala_member_access_get_inner (self);
					_tmp310_ = _tmp309_;
					_tmp311_ = vala_expression_get_value_type (_tmp310_);
					_tmp312_ = _tmp311_;
					_tmp313_ = self->priv->_member_name;
					_tmp314_ = vala_data_type_get_pointer_member (_tmp312_, _tmp313_);
					_tmp315_ = _tmp314_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp315_);
					_vala_code_node_unref0 (_tmp315_);
				} else {
					ValaExpression* _tmp316_;
					ValaExpression* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaTypeSymbol* _tmp320_;
					ValaTypeSymbol* _tmp321_;
					ValaExpression* _tmp328_;
					ValaExpression* _tmp329_;
					ValaDataType* _tmp330_;
					ValaDataType* _tmp331_;
					const gchar* _tmp332_;
					ValaSymbol* _tmp333_;
					ValaSymbol* _tmp334_;
					_tmp316_ = vala_member_access_get_inner (self);
					_tmp317_ = _tmp316_;
					_tmp318_ = vala_expression_get_value_type (_tmp317_);
					_tmp319_ = _tmp318_;
					_tmp320_ = vala_data_type_get_type_symbol (_tmp319_);
					_tmp321_ = _tmp320_;
					if (_tmp321_ != NULL) {
						ValaExpression* _tmp322_;
						ValaExpression* _tmp323_;
						ValaDataType* _tmp324_;
						ValaDataType* _tmp325_;
						ValaTypeSymbol* _tmp326_;
						ValaTypeSymbol* _tmp327_;
						_tmp322_ = vala_member_access_get_inner (self);
						_tmp323_ = _tmp322_;
						_tmp324_ = vala_expression_get_value_type (_tmp323_);
						_tmp325_ = _tmp324_;
						_tmp326_ = vala_data_type_get_type_symbol (_tmp325_);
						_tmp327_ = _tmp326_;
						base_symbol = (ValaSymbol*) _tmp327_;
					}
					_tmp328_ = vala_member_access_get_inner (self);
					_tmp329_ = _tmp328_;
					_tmp330_ = vala_expression_get_value_type (_tmp329_);
					_tmp331_ = _tmp330_;
					_tmp332_ = self->priv->_member_name;
					_tmp333_ = vala_data_type_get_member (_tmp331_, _tmp332_);
					_tmp334_ = _tmp333_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp334_);
					_vala_code_node_unref0 (_tmp334_);
				}
				_tmp335_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp336_ = _tmp335_;
				if (_tmp336_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp339_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp340_ = _tmp339_;
			if (_tmp340_ == NULL) {
				ValaExpression* _tmp341_;
				ValaExpression* _tmp342_;
				ValaDataType* _tmp343_;
				ValaDataType* _tmp344_;
				_tmp341_ = vala_member_access_get_inner (self);
				_tmp342_ = _tmp341_;
				_tmp343_ = vala_expression_get_value_type (_tmp342_);
				_tmp344_ = _tmp343_;
				_tmp338_ = _tmp344_ != NULL;
			} else {
				_tmp338_ = FALSE;
			}
			if (_tmp338_) {
				ValaExpression* _tmp345_;
				ValaExpression* _tmp346_;
				ValaDataType* _tmp347_;
				ValaDataType* _tmp348_;
				gboolean _tmp349_;
				gboolean _tmp350_;
				_tmp345_ = vala_member_access_get_inner (self);
				_tmp346_ = _tmp345_;
				_tmp347_ = vala_expression_get_value_type (_tmp346_);
				_tmp348_ = _tmp347_;
				_tmp349_ = vala_data_type_get_is_dynamic (_tmp348_);
				_tmp350_ = _tmp349_;
				_tmp337_ = _tmp350_;
			} else {
				_tmp337_ = FALSE;
			}
			if (_tmp337_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp351_;
				ValaExpression* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				ValaObjectType* _tmp355_;
				ValaCodeNode* _tmp356_;
				ValaCodeNode* _tmp357_;
				ValaSymbol* _tmp520_;
				ValaSymbol* _tmp521_;
				ValaSymbol* _tmp570_;
				ValaSymbol* _tmp571_;
				_tmp351_ = vala_member_access_get_inner (self);
				_tmp352_ = _tmp351_;
				_tmp353_ = vala_expression_get_value_type (_tmp352_);
				_tmp354_ = _tmp353_;
				_tmp355_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp354_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp355_;
				_tmp356_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp357_ = _tmp356_;
				if (VALA_IS_METHOD_CALL (_tmp357_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp358_;
					ValaCodeNode* _tmp359_;
					ValaMethodCall* _tmp360_;
					ValaExpression* _tmp361_;
					ValaExpression* _tmp362_;
					_tmp358_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp359_ = _tmp358_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp359_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp360_ = invoc;
					_tmp361_ = vala_method_call_get_call (_tmp360_);
					_tmp362_ = _tmp361_;
					if (_tmp362_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp363_;
						ValaDataType* _tmp364_;
						ValaDataType* _tmp365_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp380_;
						ValaExpression* _tmp381_;
						ValaDataType* _tmp382_;
						ValaDataType* _tmp383_;
						const gchar* _tmp384_;
						ValaDataType* _tmp385_;
						ValaSourceReference* _tmp386_;
						ValaSourceReference* _tmp387_;
						ValaDynamicMethod* _tmp388_;
						ValaDynamicMethod* _tmp389_;
						ValaMethodCall* _tmp390_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp391_;
						ValaErrorType* _tmp392_;
						ValaDynamicMethod* _tmp393_;
						ValaErrorType* _tmp394_;
						ValaDynamicMethod* _tmp395_;
						ValaDynamicMethod* _tmp396_;
						ValaParameter* _tmp397_;
						ValaParameter* _tmp398_;
						ValaDynamicMethod* _tmp399_;
						ValaObjectType* _tmp400_;
						ValaDataType* _tmp401_;
						ValaDataType* _tmp402_;
						ValaParameter* _tmp403_;
						ValaParameter* _tmp404_;
						ValaObjectType* _tmp405_;
						ValaTypeSymbol* _tmp406_;
						ValaTypeSymbol* _tmp407_;
						ValaScope* _tmp408_;
						ValaScope* _tmp409_;
						ValaDynamicMethod* _tmp410_;
						ValaDynamicMethod* _tmp411_;
						_tmp363_ = invoc;
						_tmp364_ = vala_expression_get_target_type ((ValaExpression*) _tmp363_);
						_tmp365_ = _tmp364_;
						if (_tmp365_ != NULL) {
							ValaMethodCall* _tmp366_;
							ValaDataType* _tmp367_;
							ValaDataType* _tmp368_;
							ValaDataType* _tmp369_;
							ValaDataType* _tmp370_;
							_tmp366_ = invoc;
							_tmp367_ = vala_expression_get_target_type ((ValaExpression*) _tmp366_);
							_tmp368_ = _tmp367_;
							_tmp369_ = vala_data_type_copy (_tmp368_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp369_;
							_tmp370_ = ret_type;
							vala_data_type_set_value_owned (_tmp370_, TRUE);
						} else {
							ValaMethodCall* _tmp371_;
							ValaCodeNode* _tmp372_;
							ValaCodeNode* _tmp373_;
							_tmp371_ = invoc;
							_tmp372_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp371_);
							_tmp373_ = _tmp372_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp373_)) {
								ValaVoidType* _tmp374_;
								_tmp374_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp374_;
							} else {
								ValaExpression* _tmp375_;
								ValaExpression* _tmp376_;
								ValaDataType* _tmp377_;
								ValaDataType* _tmp378_;
								ValaDataType* _tmp379_;
								_tmp375_ = vala_member_access_get_inner (self);
								_tmp376_ = _tmp375_;
								_tmp377_ = vala_expression_get_value_type (_tmp376_);
								_tmp378_ = _tmp377_;
								_tmp379_ = vala_data_type_copy (_tmp378_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp379_;
							}
						}
						_tmp380_ = vala_member_access_get_inner (self);
						_tmp381_ = _tmp380_;
						_tmp382_ = vala_expression_get_value_type (_tmp381_);
						_tmp383_ = _tmp382_;
						_tmp384_ = self->priv->_member_name;
						_tmp385_ = ret_type;
						_tmp386_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp387_ = _tmp386_;
						_tmp388_ = vala_dynamic_method_new (_tmp383_, _tmp384_, _tmp385_, _tmp387_, NULL);
						m = _tmp388_;
						_tmp389_ = m;
						_tmp390_ = invoc;
						vala_dynamic_method_set_invocation (_tmp389_, _tmp390_);
						_tmp391_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp391_;
						_tmp392_ = err;
						vala_error_type_set_dynamic_error (_tmp392_, TRUE);
						_tmp393_ = m;
						_tmp394_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp393_, (ValaDataType*) _tmp394_);
						_tmp395_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp395_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp396_ = m;
						_tmp397_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp398_ = _tmp397_;
						vala_callable_add_parameter ((ValaCallable*) _tmp396_, _tmp398_);
						_vala_code_node_unref0 (_tmp398_);
						_tmp399_ = m;
						_tmp400_ = dynamic_object_type;
						_tmp401_ = vala_data_type_copy ((ValaDataType*) _tmp400_);
						_tmp402_ = _tmp401_;
						_tmp403_ = vala_parameter_new ("this", _tmp402_, NULL);
						_tmp404_ = _tmp403_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp399_, _tmp404_);
						_vala_code_node_unref0 (_tmp404_);
						_vala_code_node_unref0 (_tmp402_);
						_tmp405_ = dynamic_object_type;
						_tmp406_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp405_);
						_tmp407_ = _tmp406_;
						_tmp408_ = vala_symbol_get_scope ((ValaSymbol*) _tmp407_);
						_tmp409_ = _tmp408_;
						_tmp410_ = m;
						vala_scope_add (_tmp409_, NULL, (ValaSymbol*) _tmp410_);
						_tmp411_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp411_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp412_;
					ValaCodeNode* _tmp413_;
					_tmp412_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp413_ = _tmp412_;
					if (VALA_IS_ASSIGNMENT (_tmp413_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp414_;
						ValaCodeNode* _tmp415_;
						ValaAssignment* _tmp416_;
						ValaExpression* _tmp417_;
						ValaExpression* _tmp418_;
						_tmp414_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp415_ = _tmp414_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp415_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp416_ = a;
						_tmp417_ = vala_assignment_get_left (_tmp416_);
						_tmp418_ = _tmp417_;
						if (_tmp418_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp419_;
							ValaExpression* _tmp420_;
							ValaDataType* _tmp421_;
							ValaDataType* _tmp422_;
							const gchar* _tmp423_;
							ValaSourceReference* _tmp424_;
							ValaSourceReference* _tmp425_;
							ValaDynamicProperty* _tmp426_;
							ValaDynamicProperty* _tmp427_;
							ValaDynamicProperty* _tmp428_;
							ValaDynamicProperty* _tmp429_;
							ValaSourceReference* _tmp430_;
							ValaSourceReference* _tmp431_;
							ValaPropertyAccessor* _tmp432_;
							ValaPropertyAccessor* _tmp433_;
							ValaDynamicProperty* _tmp434_;
							ValaExpression* _tmp435_;
							ValaExpression* _tmp436_;
							ValaDataType* _tmp437_;
							ValaDataType* _tmp438_;
							ValaTypeSymbol* _tmp439_;
							ValaTypeSymbol* _tmp440_;
							ValaScope* _tmp441_;
							ValaScope* _tmp442_;
							ValaObjectType* _tmp443_;
							ValaTypeSymbol* _tmp444_;
							ValaTypeSymbol* _tmp445_;
							ValaScope* _tmp446_;
							ValaScope* _tmp447_;
							ValaDynamicProperty* _tmp448_;
							ValaDynamicProperty* _tmp449_;
							_tmp419_ = vala_member_access_get_inner (self);
							_tmp420_ = _tmp419_;
							_tmp421_ = vala_expression_get_value_type (_tmp420_);
							_tmp422_ = _tmp421_;
							_tmp423_ = self->priv->_member_name;
							_tmp424_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp425_ = _tmp424_;
							_tmp426_ = vala_dynamic_property_new (_tmp422_, _tmp423_, _tmp425_, NULL);
							prop = _tmp426_;
							_tmp427_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp427_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp428_ = prop;
							_tmp429_ = prop;
							_tmp430_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp429_);
							_tmp431_ = _tmp430_;
							_tmp432_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp431_, NULL);
							_tmp433_ = _tmp432_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp428_, _tmp433_);
							_vala_code_node_unref0 (_tmp433_);
							_tmp434_ = prop;
							_tmp435_ = vala_member_access_get_inner (self);
							_tmp436_ = _tmp435_;
							_tmp437_ = vala_expression_get_value_type (_tmp436_);
							_tmp438_ = _tmp437_;
							_tmp439_ = vala_data_type_get_type_symbol (_tmp438_);
							_tmp440_ = _tmp439_;
							_tmp441_ = vala_symbol_get_scope ((ValaSymbol*) _tmp440_);
							_tmp442_ = _tmp441_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp434_, _tmp442_);
							_tmp443_ = dynamic_object_type;
							_tmp444_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp443_);
							_tmp445_ = _tmp444_;
							_tmp446_ = vala_symbol_get_scope ((ValaSymbol*) _tmp445_);
							_tmp447_ = _tmp446_;
							_tmp448_ = prop;
							vala_scope_add (_tmp447_, NULL, (ValaSymbol*) _tmp448_);
							_tmp449_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp449_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp450_ = FALSE;
						gboolean _tmp451_ = FALSE;
						ValaCodeNode* _tmp452_;
						ValaCodeNode* _tmp453_;
						_tmp452_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp453_ = _tmp452_;
						if (VALA_IS_MEMBER_ACCESS (_tmp453_)) {
							ValaExpression* _tmp454_;
							ValaExpression* _tmp455_;
							_tmp454_ = vala_member_access_get_inner (self);
							_tmp455_ = _tmp454_;
							_tmp451_ = VALA_IS_MEMBER_ACCESS (_tmp455_);
						} else {
							_tmp451_ = FALSE;
						}
						if (_tmp451_) {
							ValaCodeNode* _tmp456_;
							ValaCodeNode* _tmp457_;
							ValaCodeNode* _tmp458_;
							ValaCodeNode* _tmp459_;
							_tmp456_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp457_ = _tmp456_;
							_tmp458_ = vala_code_node_get_parent_node (_tmp457_);
							_tmp459_ = _tmp458_;
							_tmp450_ = VALA_IS_METHOD_CALL (_tmp459_);
						} else {
							_tmp450_ = FALSE;
						}
						if (_tmp450_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp460_;
							ValaCodeNode* _tmp461_;
							gboolean _tmp462_ = FALSE;
							ValaMemberAccess* _tmp463_;
							const gchar* _tmp464_;
							_tmp460_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp461_ = _tmp460_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp461_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp463_ = ma;
							_tmp464_ = _tmp463_->priv->_member_name;
							if (g_strcmp0 (_tmp464_, "connect") == 0) {
								_tmp462_ = TRUE;
							} else {
								ValaMemberAccess* _tmp465_;
								const gchar* _tmp466_;
								_tmp465_ = ma;
								_tmp466_ = _tmp465_->priv->_member_name;
								_tmp462_ = g_strcmp0 (_tmp466_, "connect_after") == 0;
							}
							if (_tmp462_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp467_;
								ValaExpression* _tmp468_;
								ValaDataType* _tmp469_;
								ValaDataType* _tmp470_;
								const gchar* _tmp471_;
								ValaVoidType* _tmp472_;
								ValaVoidType* _tmp473_;
								ValaSourceReference* _tmp474_;
								ValaSourceReference* _tmp475_;
								ValaDynamicSignal* _tmp476_;
								ValaDynamicSignal* _tmp477_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp478_;
								ValaCodeNode* _tmp479_;
								ValaCodeNode* _tmp480_;
								ValaCodeNode* _tmp481_;
								ValaMethodCall* _tmp482_;
								ValaMethodCall* _tmp483_;
								ValaList* _tmp484_;
								gint _tmp485_;
								gint _tmp486_;
								ValaDynamicSignal* _tmp512_;
								ValaObjectType* _tmp513_;
								ValaTypeSymbol* _tmp514_;
								ValaTypeSymbol* _tmp515_;
								ValaScope* _tmp516_;
								ValaScope* _tmp517_;
								ValaDynamicSignal* _tmp518_;
								ValaDynamicSignal* _tmp519_;
								_tmp467_ = vala_member_access_get_inner (self);
								_tmp468_ = _tmp467_;
								_tmp469_ = vala_expression_get_value_type (_tmp468_);
								_tmp470_ = _tmp469_;
								_tmp471_ = self->priv->_member_name;
								_tmp472_ = vala_void_type_new (NULL);
								_tmp473_ = _tmp472_;
								_tmp474_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp475_ = _tmp474_;
								_tmp476_ = vala_dynamic_signal_new (_tmp470_, _tmp471_, (ValaDataType*) _tmp473_, _tmp475_, NULL);
								_tmp477_ = _tmp476_;
								_vala_code_node_unref0 (_tmp473_);
								s = _tmp477_;
								_tmp478_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp479_ = _tmp478_;
								_tmp480_ = vala_code_node_get_parent_node (_tmp479_);
								_tmp481_ = _tmp480_;
								_tmp482_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp481_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp482_;
								_tmp483_ = mcall;
								_tmp484_ = vala_method_call_get_argument_list (_tmp483_);
								_tmp485_ = vala_collection_get_size ((ValaCollection*) _tmp484_);
								_tmp486_ = _tmp485_;
								if (_tmp486_ > 0) {
									ValaDynamicSignal* _tmp487_;
									ValaMethodCall* _tmp488_;
									ValaList* _tmp489_;
									gpointer _tmp490_;
									ValaExpression* _tmp491_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp492_;
									ValaExpression* _tmp493_;
									ValaExpression* _tmp494_;
									gboolean _tmp495_ = FALSE;
									gboolean _tmp496_ = FALSE;
									ValaMemberAccess* _tmp497_;
									_tmp487_ = s;
									_tmp488_ = mcall;
									_tmp489_ = vala_method_call_get_argument_list (_tmp488_);
									_tmp490_ = vala_list_get (_tmp489_, 0);
									_tmp491_ = (ValaExpression*) _tmp490_;
									vala_dynamic_signal_set_handler (_tmp487_, _tmp491_);
									_vala_code_node_unref0 (_tmp491_);
									_tmp492_ = s;
									_tmp493_ = vala_dynamic_signal_get_handler (_tmp492_);
									_tmp494_ = _tmp493_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp494_) ? ((ValaMemberAccess*) _tmp494_) : NULL;
									_tmp497_ = arg;
									if (_tmp497_ == NULL) {
										_tmp496_ = TRUE;
									} else {
										ValaMemberAccess* _tmp498_;
										_tmp498_ = arg;
										_tmp496_ = !vala_code_node_check ((ValaCodeNode*) _tmp498_, context);
									}
									if (_tmp496_) {
										_tmp495_ = TRUE;
									} else {
										ValaMemberAccess* _tmp499_;
										ValaSymbol* _tmp500_;
										ValaSymbol* _tmp501_;
										_tmp499_ = arg;
										_tmp500_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp499_);
										_tmp501_ = _tmp500_;
										_tmp495_ = !VALA_IS_METHOD (_tmp501_);
									}
									if (_tmp495_) {
										ValaDynamicSignal* _tmp502_;
										ValaExpression* _tmp503_;
										ValaExpression* _tmp504_;
										ValaSourceReference* _tmp505_;
										ValaSourceReference* _tmp506_;
										ValaDynamicSignal* _tmp507_;
										gchar* _tmp508_;
										gchar* _tmp509_;
										gchar* _tmp510_;
										gchar* _tmp511_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp502_ = s;
										_tmp503_ = vala_dynamic_signal_get_handler (_tmp502_);
										_tmp504_ = _tmp503_;
										_tmp505_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp504_);
										_tmp506_ = _tmp505_;
										_tmp507_ = s;
										_tmp508_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp507_);
										_tmp509_ = _tmp508_;
										_tmp510_ = g_strdup_printf ("Invalid handler for `%s'", _tmp509_);
										_tmp511_ = _tmp510_;
										vala_report_error (_tmp506_, _tmp511_);
										_g_free0 (_tmp511_);
										_g_free0 (_tmp509_);
									}
								}
								_tmp512_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp512_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp513_ = dynamic_object_type;
								_tmp514_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp513_);
								_tmp515_ = _tmp514_;
								_tmp516_ = vala_symbol_get_scope ((ValaSymbol*) _tmp515_);
								_tmp517_ = _tmp516_;
								_tmp518_ = s;
								vala_scope_add (_tmp517_, NULL, (ValaSymbol*) _tmp518_);
								_tmp519_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp519_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp520_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp521_ = _tmp520_;
				if (_tmp521_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp522_;
					ValaExpression* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDataType* _tmp525_;
					const gchar* _tmp526_;
					ValaSourceReference* _tmp527_;
					ValaSourceReference* _tmp528_;
					ValaDynamicProperty* _tmp529_;
					ValaDataType* _tmp530_;
					ValaDataType* _tmp531_;
					ValaDynamicProperty* _tmp542_;
					ValaDynamicProperty* _tmp543_;
					ValaDynamicProperty* _tmp544_;
					ValaDataType* _tmp545_;
					ValaDataType* _tmp546_;
					ValaDataType* _tmp547_;
					ValaDataType* _tmp548_;
					ValaDynamicProperty* _tmp549_;
					ValaSourceReference* _tmp550_;
					ValaSourceReference* _tmp551_;
					ValaPropertyAccessor* _tmp552_;
					ValaPropertyAccessor* _tmp553_;
					ValaDynamicProperty* _tmp554_;
					ValaExpression* _tmp555_;
					ValaExpression* _tmp556_;
					ValaDataType* _tmp557_;
					ValaDataType* _tmp558_;
					ValaTypeSymbol* _tmp559_;
					ValaTypeSymbol* _tmp560_;
					ValaScope* _tmp561_;
					ValaScope* _tmp562_;
					ValaObjectType* _tmp563_;
					ValaTypeSymbol* _tmp564_;
					ValaTypeSymbol* _tmp565_;
					ValaScope* _tmp566_;
					ValaScope* _tmp567_;
					ValaDynamicProperty* _tmp568_;
					ValaDynamicProperty* _tmp569_;
					_tmp522_ = vala_member_access_get_inner (self);
					_tmp523_ = _tmp522_;
					_tmp524_ = vala_expression_get_value_type (_tmp523_);
					_tmp525_ = _tmp524_;
					_tmp526_ = self->priv->_member_name;
					_tmp527_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp528_ = _tmp527_;
					_tmp529_ = vala_dynamic_property_new (_tmp525_, _tmp526_, _tmp528_, NULL);
					prop = _tmp529_;
					_tmp530_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp531_ = _tmp530_;
					if (_tmp531_ != NULL) {
						ValaDynamicProperty* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						_tmp532_ = prop;
						_tmp533_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp534_ = _tmp533_;
						vala_property_set_property_type ((ValaProperty*) _tmp532_, _tmp534_);
					} else {
						ValaDynamicProperty* _tmp535_;
						ValaExpression* _tmp536_;
						ValaExpression* _tmp537_;
						ValaDataType* _tmp538_;
						ValaDataType* _tmp539_;
						ValaDataType* _tmp540_;
						ValaDataType* _tmp541_;
						_tmp535_ = prop;
						_tmp536_ = vala_member_access_get_inner (self);
						_tmp537_ = _tmp536_;
						_tmp538_ = vala_expression_get_value_type (_tmp537_);
						_tmp539_ = _tmp538_;
						_tmp540_ = vala_data_type_copy (_tmp539_);
						_tmp541_ = _tmp540_;
						vala_property_set_property_type ((ValaProperty*) _tmp535_, _tmp541_);
						_vala_code_node_unref0 (_tmp541_);
					}
					_tmp542_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp542_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp543_ = prop;
					_tmp544_ = prop;
					_tmp545_ = vala_property_get_property_type ((ValaProperty*) _tmp544_);
					_tmp546_ = _tmp545_;
					_tmp547_ = vala_data_type_copy (_tmp546_);
					_tmp548_ = _tmp547_;
					_tmp549_ = prop;
					_tmp550_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp549_);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp548_, NULL, _tmp551_, NULL);
					_tmp553_ = _tmp552_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp543_, _tmp553_);
					_vala_code_node_unref0 (_tmp553_);
					_vala_code_node_unref0 (_tmp548_);
					_tmp554_ = prop;
					_tmp555_ = vala_member_access_get_inner (self);
					_tmp556_ = _tmp555_;
					_tmp557_ = vala_expression_get_value_type (_tmp556_);
					_tmp558_ = _tmp557_;
					_tmp559_ = vala_data_type_get_type_symbol (_tmp558_);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_symbol_get_scope ((ValaSymbol*) _tmp560_);
					_tmp562_ = _tmp561_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp554_, _tmp562_);
					_tmp563_ = dynamic_object_type;
					_tmp564_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp563_);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_symbol_get_scope ((ValaSymbol*) _tmp565_);
					_tmp567_ = _tmp566_;
					_tmp568_ = prop;
					vala_scope_add (_tmp567_, NULL, (ValaSymbol*) _tmp568_);
					_tmp569_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp569_);
					_vala_code_node_unref0 (prop);
				}
				_tmp570_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp571_ = _tmp570_;
				if (_tmp571_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp573_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp574_ = _tmp573_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp574_)) {
				ValaExpression* _tmp575_;
				ValaExpression* _tmp576_;
				ValaSymbol* _tmp577_;
				ValaSymbol* _tmp578_;
				_tmp575_ = vala_member_access_get_inner (self);
				_tmp576_ = _tmp575_;
				_tmp577_ = vala_expression_get_symbol_reference (_tmp576_);
				_tmp578_ = _tmp577_;
				_tmp572_ = VALA_IS_VARIABLE (_tmp578_);
			} else {
				_tmp572_ = FALSE;
			}
			if (_tmp572_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp579_;
				ValaSemanticAnalyzer* _tmp580_;
				ValaExpression* _tmp581_;
				ValaExpression* _tmp582_;
				ValaSymbol* _tmp583_;
				ValaSymbol* _tmp584_;
				ValaDataType* _tmp585_;
				ValaArrayType* _tmp586_;
				gboolean _tmp587_ = FALSE;
				ValaArrayType* _tmp588_;
				_tmp579_ = vala_code_context_get_analyzer (context);
				_tmp580_ = _tmp579_;
				_tmp581_ = vala_member_access_get_inner (self);
				_tmp582_ = _tmp581_;
				_tmp583_ = vala_expression_get_symbol_reference (_tmp582_);
				_tmp584_ = _tmp583_;
				_tmp585_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp580_, _tmp584_, TRUE);
				_tmp586_ = VALA_IS_ARRAY_TYPE (_tmp585_) ? ((ValaArrayType*) _tmp585_) : NULL;
				if (_tmp586_ == NULL) {
					_vala_code_node_unref0 (_tmp585_);
				}
				inner_type = _tmp586_;
				_tmp588_ = inner_type;
				if (_tmp588_ != NULL) {
					ValaArrayType* _tmp589_;
					gboolean _tmp590_;
					gboolean _tmp591_;
					_tmp589_ = inner_type;
					_tmp590_ = vala_array_type_get_inline_allocated (_tmp589_);
					_tmp591_ = _tmp590_;
					_tmp587_ = _tmp591_;
				} else {
					_tmp587_ = FALSE;
				}
				if (_tmp587_) {
					ValaSourceReference* _tmp592_;
					ValaSourceReference* _tmp593_;
					_tmp592_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp593_ = _tmp592_;
					vala_report_error (_tmp593_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp594_ = FALSE;
					ValaArrayType* _tmp595_;
					_tmp595_ = inner_type;
					if (_tmp595_ != NULL) {
						ValaArrayType* _tmp596_;
						gboolean _tmp597_;
						gboolean _tmp598_;
						_tmp596_ = inner_type;
						_tmp597_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp596_);
						_tmp598_ = _tmp597_;
						_tmp594_ = !_tmp598_;
					} else {
						_tmp594_ = FALSE;
					}
					if (_tmp594_) {
						ValaSourceReference* _tmp599_;
						ValaSourceReference* _tmp600_;
						_tmp599_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp600_ = _tmp599_;
						vala_report_error (_tmp600_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp604_ = vala_member_access_get_inner (self);
	_tmp605_ = _tmp604_;
	if (_tmp605_ == NULL) {
		ValaSymbol* _tmp606_;
		ValaSymbol* _tmp607_;
		_tmp606_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp607_ = _tmp606_;
		_tmp603_ = _tmp607_ == NULL;
	} else {
		_tmp603_ = FALSE;
	}
	if (_tmp603_) {
		ValaDataType* _tmp608_;
		ValaDataType* _tmp609_;
		_tmp608_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp609_ = _tmp608_;
		_tmp602_ = _tmp609_ != NULL;
	} else {
		_tmp602_ = FALSE;
	}
	if (_tmp602_) {
		ValaDataType* _tmp610_;
		ValaDataType* _tmp611_;
		ValaTypeSymbol* _tmp612_;
		ValaTypeSymbol* _tmp613_;
		_tmp610_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp611_ = _tmp610_;
		_tmp612_ = vala_data_type_get_type_symbol (_tmp611_);
		_tmp613_ = _tmp612_;
		_tmp601_ = VALA_IS_ENUM (_tmp613_);
	} else {
		_tmp601_ = FALSE;
	}
	if (_tmp601_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp614_;
		ValaDataType* _tmp615_;
		ValaTypeSymbol* _tmp616_;
		ValaTypeSymbol* _tmp617_;
		_tmp614_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp615_ = _tmp614_;
		_tmp616_ = vala_data_type_get_type_symbol (_tmp615_);
		_tmp617_ = _tmp616_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp617_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp618_;
			ValaList* _tmp619_;
			ValaList* _tmp620_;
			gint _val_size = 0;
			ValaList* _tmp621_;
			gint _tmp622_;
			gint _tmp623_;
			gint _val_index = 0;
			_tmp618_ = enum_type;
			_tmp619_ = vala_enum_get_values (_tmp618_);
			_tmp620_ = _vala_iterable_ref0 (_tmp619_);
			_val_list = _tmp620_;
			_tmp621_ = _val_list;
			_tmp622_ = vala_collection_get_size ((ValaCollection*) _tmp621_);
			_tmp623_ = _tmp622_;
			_val_size = _tmp623_;
			_val_index = -1;
			while (TRUE) {
				ValaEnumValue* val = NULL;
				ValaList* _tmp624_;
				gpointer _tmp625_;
				const gchar* _tmp626_;
				ValaEnumValue* _tmp627_;
				const gchar* _tmp628_;
				const gchar* _tmp629_;
				_val_index = _val_index + 1;
				if (!(_val_index < _val_size)) {
					break;
				}
				_tmp624_ = _val_list;
				_tmp625_ = vala_list_get (_tmp624_, _val_index);
				val = (ValaEnumValue*) _tmp625_;
				_tmp626_ = self->priv->_member_name;
				_tmp627_ = val;
				_tmp628_ = vala_symbol_get_name ((ValaSymbol*) _tmp627_);
				_tmp629_ = _tmp628_;
				if (g_strcmp0 (_tmp626_, _tmp629_) == 0) {
					ValaEnumValue* _tmp630_;
					_tmp630_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp630_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp631_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp632_ = _tmp631_;
	if (_tmp632_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp633_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp634_ = FALSE;
		ValaExpression* _tmp635_;
		ValaExpression* _tmp636_;
		gchar* base_type_package = NULL;
		gchar* _tmp656_;
		gboolean _tmp657_ = FALSE;
		ValaSymbol* _tmp658_;
		ValaSourceReference* _tmp673_;
		ValaSourceReference* _tmp674_;
		const gchar* _tmp675_;
		const gchar* _tmp676_;
		const gchar* _tmp677_;
		gchar* _tmp678_;
		gchar* _tmp679_;
		ValaInvalidType* _tmp680_;
		ValaInvalidType* _tmp681_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp633_ = g_strdup ("(null)");
		base_type_name = _tmp633_;
		base_type = NULL;
		_tmp635_ = vala_member_access_get_inner (self);
		_tmp636_ = _tmp635_;
		if (_tmp636_ != NULL) {
			ValaExpression* _tmp637_;
			ValaExpression* _tmp638_;
			ValaDataType* _tmp639_;
			ValaDataType* _tmp640_;
			_tmp637_ = vala_member_access_get_inner (self);
			_tmp638_ = _tmp637_;
			_tmp639_ = vala_expression_get_value_type (_tmp638_);
			_tmp640_ = _tmp639_;
			_tmp634_ = _tmp640_ != NULL;
		} else {
			_tmp634_ = FALSE;
		}
		if (_tmp634_) {
			ValaExpression* _tmp641_;
			ValaExpression* _tmp642_;
			ValaDataType* _tmp643_;
			ValaDataType* _tmp644_;
			gchar* _tmp645_;
			ValaExpression* _tmp646_;
			ValaExpression* _tmp647_;
			ValaDataType* _tmp648_;
			ValaDataType* _tmp649_;
			ValaTypeSymbol* _tmp650_;
			ValaTypeSymbol* _tmp651_;
			_tmp641_ = vala_member_access_get_inner (self);
			_tmp642_ = _tmp641_;
			_tmp643_ = vala_expression_get_value_type (_tmp642_);
			_tmp644_ = _tmp643_;
			_tmp645_ = vala_code_node_to_string ((ValaCodeNode*) _tmp644_);
			_g_free0 (base_type_name);
			base_type_name = _tmp645_;
			_tmp646_ = vala_member_access_get_inner (self);
			_tmp647_ = _tmp646_;
			_tmp648_ = vala_expression_get_value_type (_tmp647_);
			_tmp649_ = _tmp648_;
			_tmp650_ = vala_data_type_get_type_symbol (_tmp649_);
			_tmp651_ = _tmp650_;
			base_type = (ValaSymbol*) _tmp651_;
		} else {
			ValaSymbol* _tmp652_;
			_tmp652_ = base_symbol;
			if (_tmp652_ != NULL) {
				ValaSymbol* _tmp653_;
				gchar* _tmp654_;
				ValaSymbol* _tmp655_;
				_tmp653_ = base_symbol;
				_tmp654_ = vala_symbol_get_full_name (_tmp653_);
				_g_free0 (base_type_name);
				base_type_name = _tmp654_;
				_tmp655_ = base_symbol;
				base_type = _tmp655_;
			}
		}
		_tmp656_ = g_strdup ("");
		base_type_package = _tmp656_;
		_tmp658_ = base_type;
		if (_tmp658_ != NULL) {
			ValaSymbol* _tmp659_;
			gboolean _tmp660_;
			gboolean _tmp661_;
			_tmp659_ = base_type;
			_tmp660_ = vala_symbol_get_external_package (_tmp659_);
			_tmp661_ = _tmp660_;
			_tmp657_ = _tmp661_;
		} else {
			_tmp657_ = FALSE;
		}
		if (_tmp657_) {
			ValaSymbol* _tmp662_;
			ValaSourceReference* _tmp663_;
			ValaSourceReference* _tmp664_;
			ValaSourceFile* _tmp665_;
			ValaSourceFile* _tmp666_;
			const gchar* _tmp667_;
			const gchar* _tmp668_;
			gchar* _tmp669_;
			const gchar* _tmp670_;
			_tmp662_ = base_symbol;
			_tmp663_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp662_);
			_tmp664_ = _tmp663_;
			_tmp665_ = vala_source_reference_get_file (_tmp664_);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_source_file_get_package_name (_tmp666_);
			_tmp668_ = _tmp667_;
			_tmp669_ = g_strdup (_tmp668_);
			_g_free0 (base_type_package);
			base_type_package = _tmp669_;
			_tmp670_ = base_type_package;
			if (_tmp670_ != NULL) {
				const gchar* _tmp671_;
				gchar* _tmp672_;
				_tmp671_ = base_type_package;
				_tmp672_ = g_strdup_printf (" (%s)", _tmp671_);
				_g_free0 (base_type_package);
				base_type_package = _tmp672_;
			}
		}
		_tmp673_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp674_ = _tmp673_;
		_tmp675_ = self->priv->_member_name;
		_tmp676_ = base_type_name;
		_tmp677_ = base_type_package;
		_tmp678_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp675_, _tmp676_, _tmp677_);
		_tmp679_ = _tmp678_;
		vala_report_error (_tmp674_, _tmp679_);
		_g_free0 (_tmp679_);
		_tmp680_ = vala_invalid_type_new ();
		_tmp681_ = _tmp680_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp681_);
		_vala_code_node_unref0 (_tmp681_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp682_;
		ValaSymbol* _tmp683_;
		gboolean _tmp684_;
		gboolean _tmp685_;
		_tmp682_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp683_ = _tmp682_;
		_tmp684_ = vala_code_node_get_error ((ValaCodeNode*) _tmp683_);
		_tmp685_ = _tmp684_;
		if (_tmp685_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp686_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp687_ = _tmp686_;
	if (VALA_IS_SIGNAL (_tmp687_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp688_;
		ValaSymbol* _tmp689_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp696_;
		ValaCodeNode* _tmp697_;
		ValaCodeNode* _tmp698_;
		gboolean _tmp699_ = FALSE;
		gboolean _tmp700_ = FALSE;
		gboolean _tmp701_ = FALSE;
		ValaCodeNode* _tmp702_;
		_tmp688_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp689_ = _tmp688_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp689_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp690_;
			ValaCodeNode* _tmp691_;
			ValaCodeNode* _tmp692_;
			ValaCodeNode* _tmp693_;
			ValaCodeNode* _tmp694_;
			ValaCodeNode* _tmp695_;
			_tmp690_ = ma;
			_tmp691_ = vala_code_node_get_parent_node (_tmp690_);
			_tmp692_ = _tmp691_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp692_)) {
				break;
			}
			_tmp693_ = ma;
			_tmp694_ = vala_code_node_get_parent_node (_tmp693_);
			_tmp695_ = _tmp694_;
			ma = _tmp695_;
		}
		_tmp696_ = ma;
		_tmp697_ = vala_code_node_get_parent_node (_tmp696_);
		_tmp698_ = _tmp697_;
		parent = _tmp698_;
		_tmp702_ = parent;
		if (_tmp702_ != NULL) {
			ValaCodeNode* _tmp703_;
			_tmp703_ = parent;
			_tmp701_ = !VALA_IS_ELEMENT_ACCESS (_tmp703_);
		} else {
			_tmp701_ = FALSE;
		}
		if (_tmp701_) {
			ValaCodeNode* _tmp704_;
			ValaExpression* _tmp705_;
			ValaExpression* _tmp706_;
			_tmp704_ = ma;
			_tmp705_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp704_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp706_ = _tmp705_;
			_tmp700_ = !VALA_IS_BASE_ACCESS (_tmp706_);
		} else {
			_tmp700_ = FALSE;
		}
		if (_tmp700_) {
			gboolean _tmp707_ = FALSE;
			ValaCodeNode* _tmp708_;
			_tmp708_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp708_)) {
				_tmp707_ = TRUE;
			} else {
				ValaCodeNode* _tmp709_;
				ValaList* _tmp710_;
				_tmp709_ = parent;
				_tmp710_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp709_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp707_ = vala_collection_contains ((ValaCollection*) _tmp710_, (ValaExpression*) self);
			}
			_tmp699_ = _tmp707_;
		} else {
			_tmp699_ = FALSE;
		}
		if (_tmp699_) {
			ValaSignal* _tmp711_;
			ValaAttribute* _tmp712_;
			_tmp711_ = sig;
			_tmp712_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp711_, "HasEmitter");
			if (_tmp712_ != NULL) {
				ValaSignal* _tmp713_;
				ValaSignal* _tmp714_;
				ValaMethod* _tmp715_;
				ValaMethod* _tmp716_;
				_tmp713_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp713_, context)) {
					result = FALSE;
					return result;
				}
				_tmp714_ = sig;
				_tmp715_ = vala_signal_get_emitter (_tmp714_);
				_tmp716_ = _tmp715_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp716_);
			} else {
				ValaSourceReference* _tmp717_;
				ValaSourceReference* _tmp718_;
				ValaSymbol* _tmp719_;
				ValaSymbol* _tmp720_;
				gchar* _tmp721_;
				gchar* _tmp722_;
				gchar* _tmp723_;
				gchar* _tmp724_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp717_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp718_ = _tmp717_;
				_tmp719_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp720_ = _tmp719_;
				_tmp721_ = vala_symbol_get_full_name (_tmp720_);
				_tmp722_ = _tmp721_;
				_tmp723_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp722_);
				_tmp724_ = _tmp723_;
				vala_report_error (_tmp718_, _tmp724_);
				_g_free0 (_tmp724_);
				_g_free0 (_tmp722_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp725_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp726_ = _tmp725_;
	member = _tmp726_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp727_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp727_, context)) {
		result = FALSE;
		return result;
	}
	_tmp728_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp728_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp729_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp730_;
		ValaSymbol* _tmp731_;
		ValaSymbol* _tmp732_;
		gboolean _tmp733_ = FALSE;
		ValaBlock* _tmp734_;
		_tmp729_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp729_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp730_ = local;
		_tmp731_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp730_);
		_tmp732_ = _tmp731_;
		block = VALA_IS_BLOCK (_tmp732_) ? ((ValaBlock*) _tmp732_) : NULL;
		_tmp734_ = block;
		if (_tmp734_ != NULL) {
			ValaBlock* _tmp735_;
			ValaSymbol* _tmp736_;
			ValaSemanticAnalyzer* _tmp737_;
			ValaSemanticAnalyzer* _tmp738_;
			ValaSymbol* _tmp739_;
			ValaSymbol* _tmp740_;
			_tmp735_ = block;
			_tmp736_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp735_);
			_tmp737_ = vala_code_context_get_analyzer (context);
			_tmp738_ = _tmp737_;
			_tmp739_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp738_);
			_tmp740_ = _tmp739_;
			_tmp733_ = _tmp736_ != _tmp740_;
		} else {
			_tmp733_ = FALSE;
		}
		if (_tmp733_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp741_;
			ValaSemanticAnalyzer* _tmp742_;
			ValaSymbol* _tmp743_;
			ValaSymbol* _tmp744_;
			ValaLocalVariable* _tmp755_;
			ValaBlock* _tmp756_;
			_tmp741_ = vala_code_context_get_analyzer (context);
			_tmp742_ = _tmp741_;
			_tmp743_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp742_);
			_tmp744_ = _tmp743_;
			sym = _tmp744_;
			while (TRUE) {
				ValaSymbol* _tmp745_;
				ValaBlock* _tmp746_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp747_;
				ValaMethod* _tmp748_;
				ValaSymbol* _tmp752_;
				ValaSymbol* _tmp753_;
				ValaSymbol* _tmp754_;
				_tmp745_ = sym;
				_tmp746_ = block;
				if (!(_tmp745_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp746_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp747_ = sym;
				method = VALA_IS_METHOD (_tmp747_) ? ((ValaMethod*) _tmp747_) : NULL;
				_tmp748_ = method;
				if (_tmp748_ != NULL) {
					ValaMethod* _tmp749_;
					ValaMethod* _tmp750_;
					ValaLocalVariable* _tmp751_;
					_tmp749_ = method;
					vala_method_set_closure (_tmp749_, TRUE);
					_tmp750_ = method;
					_tmp751_ = local;
					vala_method_add_captured_variable (_tmp750_, _tmp751_);
				}
				_tmp752_ = sym;
				_tmp753_ = vala_symbol_get_parent_symbol (_tmp752_);
				_tmp754_ = _tmp753_;
				sym = _tmp754_;
			}
			_tmp755_ = local;
			vala_local_variable_set_captured (_tmp755_, TRUE);
			_tmp756_ = block;
			vala_block_set_captured (_tmp756_, TRUE);
		}
	} else {
		ValaSymbol* _tmp757_;
		_tmp757_ = member;
		if (VALA_IS_PARAMETER (_tmp757_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp758_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp759_;
			ValaSymbol* _tmp760_;
			ValaSymbol* _tmp761_;
			gboolean _tmp762_ = FALSE;
			gboolean _tmp763_ = FALSE;
			ValaMethod* _tmp764_;
			_tmp758_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp758_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp759_ = param;
			_tmp760_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp759_);
			_tmp761_ = _tmp760_;
			m = VALA_IS_METHOD (_tmp761_) ? ((ValaMethod*) _tmp761_) : NULL;
			_tmp764_ = m;
			if (_tmp764_ != NULL) {
				ValaMethod* _tmp765_;
				ValaSemanticAnalyzer* _tmp766_;
				ValaSemanticAnalyzer* _tmp767_;
				ValaSymbol* _tmp768_;
				ValaSymbol* _tmp769_;
				_tmp765_ = m;
				_tmp766_ = vala_code_context_get_analyzer (context);
				_tmp767_ = _tmp766_;
				_tmp768_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp767_);
				_tmp769_ = _tmp768_;
				_tmp763_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp769_;
			} else {
				_tmp763_ = FALSE;
			}
			if (_tmp763_) {
				ValaParameter* _tmp770_;
				ValaMethod* _tmp771_;
				ValaParameter* _tmp772_;
				ValaParameter* _tmp773_;
				_tmp770_ = param;
				_tmp771_ = m;
				_tmp772_ = vala_method_get_this_parameter (_tmp771_);
				_tmp773_ = _tmp772_;
				_tmp762_ = _tmp770_ != _tmp773_;
			} else {
				_tmp762_ = FALSE;
			}
			if (_tmp762_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp774_;
				ValaSemanticAnalyzer* _tmp775_;
				ValaSymbol* _tmp776_;
				ValaSymbol* _tmp777_;
				ValaParameter* _tmp786_;
				ValaMethod* _tmp787_;
				ValaBlock* _tmp788_;
				ValaBlock* _tmp789_;
				ValaParameter* _tmp790_;
				ValaParameterDirection _tmp791_;
				ValaParameterDirection _tmp792_;
				_tmp774_ = vala_code_context_get_analyzer (context);
				_tmp775_ = _tmp774_;
				_tmp776_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp775_);
				_tmp777_ = _tmp776_;
				sym = _tmp777_;
				while (TRUE) {
					ValaSymbol* _tmp778_;
					ValaMethod* _tmp779_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp780_;
					ValaMethod* _tmp781_;
					ValaSymbol* _tmp783_;
					ValaSymbol* _tmp784_;
					ValaSymbol* _tmp785_;
					_tmp778_ = sym;
					_tmp779_ = m;
					if (!(_tmp778_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp779_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp780_ = sym;
					method = VALA_IS_METHOD (_tmp780_) ? ((ValaMethod*) _tmp780_) : NULL;
					_tmp781_ = method;
					if (_tmp781_ != NULL) {
						ValaMethod* _tmp782_;
						_tmp782_ = method;
						vala_method_set_closure (_tmp782_, TRUE);
					}
					_tmp783_ = sym;
					_tmp784_ = vala_symbol_get_parent_symbol (_tmp783_);
					_tmp785_ = _tmp784_;
					sym = _tmp785_;
				}
				_tmp786_ = param;
				vala_parameter_set_captured (_tmp786_, TRUE);
				_tmp787_ = m;
				_tmp788_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp787_);
				_tmp789_ = _tmp788_;
				vala_block_set_captured (_tmp789_, TRUE);
				_tmp790_ = param;
				_tmp791_ = vala_parameter_get_direction (_tmp790_);
				_tmp792_ = _tmp791_;
				if (_tmp792_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp793_;
					ValaSourceReference* _tmp794_;
					ValaParameter* _tmp795_;
					gchar* _tmp796_;
					gchar* _tmp797_;
					gchar* _tmp798_;
					gchar* _tmp799_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp793_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp794_ = _tmp793_;
					_tmp795_ = param;
					_tmp796_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp795_);
					_tmp797_ = _tmp796_;
					_tmp798_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp797_);
					_tmp799_ = _tmp798_;
					vala_report_error (_tmp794_, _tmp799_);
					_g_free0 (_tmp799_);
					_g_free0 (_tmp797_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp800_;
				ValaSymbol* _tmp801_;
				ValaSymbol* _tmp802_;
				ValaSymbol* _tmp803_;
				ValaSymbol* _tmp804_;
				gboolean _tmp805_ = FALSE;
				gboolean _tmp806_ = FALSE;
				ValaPropertyAccessor* _tmp807_;
				_tmp800_ = param;
				_tmp801_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp800_);
				_tmp802_ = _tmp801_;
				_tmp803_ = vala_symbol_get_parent_symbol (_tmp802_);
				_tmp804_ = _tmp803_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp804_) ? ((ValaPropertyAccessor*) _tmp804_) : NULL;
				_tmp807_ = acc;
				if (_tmp807_ != NULL) {
					ValaPropertyAccessor* _tmp808_;
					ValaSemanticAnalyzer* _tmp809_;
					ValaSemanticAnalyzer* _tmp810_;
					ValaSymbol* _tmp811_;
					ValaSymbol* _tmp812_;
					_tmp808_ = acc;
					_tmp809_ = vala_code_context_get_analyzer (context);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp810_);
					_tmp812_ = _tmp811_;
					_tmp806_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp808_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp812_;
				} else {
					_tmp806_ = FALSE;
				}
				if (_tmp806_) {
					ValaParameter* _tmp813_;
					ValaPropertyAccessor* _tmp814_;
					ValaProperty* _tmp815_;
					ValaProperty* _tmp816_;
					ValaParameter* _tmp817_;
					ValaParameter* _tmp818_;
					_tmp813_ = param;
					_tmp814_ = acc;
					_tmp815_ = vala_property_accessor_get_prop (_tmp814_);
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_property_get_this_parameter (_tmp816_);
					_tmp818_ = _tmp817_;
					_tmp805_ = _tmp813_ != _tmp818_;
				} else {
					_tmp805_ = FALSE;
				}
				if (_tmp805_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp819_;
					ValaSemanticAnalyzer* _tmp820_;
					ValaSymbol* _tmp821_;
					ValaSymbol* _tmp822_;
					ValaParameter* _tmp831_;
					ValaPropertyAccessor* _tmp832_;
					ValaBlock* _tmp833_;
					ValaBlock* _tmp834_;
					_tmp819_ = vala_code_context_get_analyzer (context);
					_tmp820_ = _tmp819_;
					_tmp821_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp820_);
					_tmp822_ = _tmp821_;
					sym = _tmp822_;
					while (TRUE) {
						ValaSymbol* _tmp823_;
						ValaMethod* _tmp824_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp825_;
						ValaMethod* _tmp826_;
						ValaSymbol* _tmp828_;
						ValaSymbol* _tmp829_;
						ValaSymbol* _tmp830_;
						_tmp823_ = sym;
						_tmp824_ = m;
						if (!(_tmp823_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp824_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp825_ = sym;
						method = VALA_IS_METHOD (_tmp825_) ? ((ValaMethod*) _tmp825_) : NULL;
						_tmp826_ = method;
						if (_tmp826_ != NULL) {
							ValaMethod* _tmp827_;
							_tmp827_ = method;
							vala_method_set_closure (_tmp827_, TRUE);
						}
						_tmp828_ = sym;
						_tmp829_ = vala_symbol_get_parent_symbol (_tmp828_);
						_tmp830_ = _tmp829_;
						sym = _tmp830_;
					}
					_tmp831_ = param;
					vala_parameter_set_captured (_tmp831_, TRUE);
					_tmp832_ = acc;
					_tmp833_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp832_);
					_tmp834_ = _tmp833_;
					vala_block_set_captured (_tmp834_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp835_;
			_tmp835_ = member;
			if (VALA_IS_FIELD (_tmp835_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp836_;
				ValaField* _tmp837_;
				ValaSymbolAccessibility _tmp838_;
				ValaSymbolAccessibility _tmp839_;
				ValaField* _tmp840_;
				ValaMemberBinding _tmp841_;
				ValaMemberBinding _tmp842_;
				ValaField* _tmp843_;
				ValaMemberBinding _tmp844_;
				ValaMemberBinding _tmp845_;
				ValaField* _tmp846_;
				ValaDataType* _tmp847_;
				ValaDataType* _tmp848_;
				_tmp836_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp836_, VALA_TYPE_FIELD, ValaField);
				_tmp837_ = f;
				_tmp838_ = vala_symbol_get_access ((ValaSymbol*) _tmp837_);
				_tmp839_ = _tmp838_;
				access = _tmp839_;
				_tmp840_ = f;
				_tmp841_ = vala_field_get_binding (_tmp840_);
				_tmp842_ = _tmp841_;
				instance = _tmp842_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp843_ = f;
				_tmp844_ = vala_field_get_binding (_tmp843_);
				_tmp845_ = _tmp844_;
				klass = _tmp845_ == VALA_MEMBER_BINDING_CLASS;
				_tmp846_ = f;
				_tmp847_ = vala_variable_get_variable_type ((ValaVariable*) _tmp846_);
				_tmp848_ = _tmp847_;
				if (VALA_IS_GENERIC_TYPE (_tmp848_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp849_;
				_tmp849_ = member;
				if (VALA_IS_CONSTANT (_tmp849_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp850_;
					ValaConstant* _tmp851_;
					ValaSymbolAccessibility _tmp852_;
					ValaSymbolAccessibility _tmp853_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp854_;
					ValaSymbol* _tmp855_;
					ValaSymbol* _tmp856_;
					gboolean _tmp857_ = FALSE;
					ValaBlock* _tmp858_;
					_tmp850_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp850_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp851_ = c;
					_tmp852_ = vala_symbol_get_access ((ValaSymbol*) _tmp851_);
					_tmp853_ = _tmp852_;
					access = _tmp853_;
					_tmp854_ = c;
					_tmp855_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp854_);
					_tmp856_ = _tmp855_;
					block = VALA_IS_BLOCK (_tmp856_) ? ((ValaBlock*) _tmp856_) : NULL;
					_tmp858_ = block;
					if (_tmp858_ != NULL) {
						ValaBlock* _tmp859_;
						ValaSymbol* _tmp860_;
						ValaSemanticAnalyzer* _tmp861_;
						ValaSemanticAnalyzer* _tmp862_;
						ValaSymbol* _tmp863_;
						ValaSymbol* _tmp864_;
						_tmp859_ = block;
						_tmp860_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp859_);
						_tmp861_ = vala_code_context_get_analyzer (context);
						_tmp862_ = _tmp861_;
						_tmp863_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp862_);
						_tmp864_ = _tmp863_;
						_tmp857_ = _tmp860_ != _tmp864_;
					} else {
						_tmp857_ = FALSE;
					}
					if (_tmp857_) {
						ValaSourceReference* _tmp865_;
						ValaSourceReference* _tmp866_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp865_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp866_ = _tmp865_;
						vala_report_error (_tmp866_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp867_;
					_tmp867_ = member;
					if (VALA_IS_METHOD (_tmp867_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp868_;
						ValaMethod* _tmp869_;
						gboolean _tmp870_;
						gboolean _tmp871_;
						ValaMethod* _tmp960_;
						ValaSymbolAccessibility _tmp961_;
						ValaSymbolAccessibility _tmp962_;
						ValaMethod* _tmp963_;
						ValaMethod* _tmp967_;
						ValaMemberBinding _tmp968_;
						ValaMemberBinding _tmp969_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp988_;
						ValaDataType* _tmp989_;
						ValaDataType* _tmp990_;
						gboolean _tmp991_ = FALSE;
						ValaGenericType* _tmp992_;
						_tmp868_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp868_, VALA_TYPE_METHOD, ValaMethod);
						_tmp869_ = m;
						_tmp870_ = vala_method_get_is_async_callback (_tmp869_);
						_tmp871_ = _tmp870_;
						if (_tmp871_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp872_;
							ValaSemanticAnalyzer* _tmp873_;
							ValaMethod* _tmp874_;
							ValaMethod* _tmp875_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp876_;
							ValaMethod* _tmp905_;
							ValaSemanticAnalyzer* _tmp906_;
							ValaSemanticAnalyzer* _tmp907_;
							ValaMethod* _tmp908_;
							ValaMethod* _tmp909_;
							ValaMethod* _tmp925_;
							ValaMethod* _tmp926_;
							ValaMethod* _tmp927_;
							ValaSymbol* _tmp928_;
							ValaSymbol* _tmp929_;
							_tmp872_ = vala_code_context_get_analyzer (context);
							_tmp873_ = _tmp872_;
							_tmp874_ = vala_semantic_analyzer_get_current_async_method (_tmp873_);
							_tmp875_ = _tmp874_;
							async_method = _tmp875_;
							is_valid_access = FALSE;
							_tmp876_ = async_method;
							if (_tmp876_ != NULL) {
								ValaMethod* _tmp877_;
								ValaMethod* _tmp878_;
								ValaMethod* _tmp879_;
								_tmp877_ = m;
								_tmp878_ = async_method;
								_tmp879_ = vala_method_get_callback_method (_tmp878_);
								if (_tmp877_ == _tmp879_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp880_ = FALSE;
									ValaMethod* _tmp881_;
									ValaMethod* _tmp882_;
									ValaMethod* _tmp883_;
									_tmp881_ = async_method;
									_tmp882_ = vala_method_get_base_method (_tmp881_);
									_tmp883_ = _tmp882_;
									if (_tmp883_ != NULL) {
										ValaMethod* _tmp884_;
										ValaMethod* _tmp885_;
										ValaMethod* _tmp886_;
										ValaMethod* _tmp887_;
										ValaMethod* _tmp888_;
										_tmp884_ = m;
										_tmp885_ = async_method;
										_tmp886_ = vala_method_get_base_method (_tmp885_);
										_tmp887_ = _tmp886_;
										_tmp888_ = vala_method_get_callback_method (_tmp887_);
										_tmp880_ = _tmp884_ == _tmp888_;
									} else {
										_tmp880_ = FALSE;
									}
									if (_tmp880_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp889_ = FALSE;
										ValaMethod* _tmp890_;
										ValaMethod* _tmp891_;
										ValaMethod* _tmp892_;
										_tmp890_ = async_method;
										_tmp891_ = vala_method_get_base_interface_method (_tmp890_);
										_tmp892_ = _tmp891_;
										if (_tmp892_ != NULL) {
											ValaMethod* _tmp893_;
											ValaMethod* _tmp894_;
											ValaMethod* _tmp895_;
											ValaMethod* _tmp896_;
											ValaMethod* _tmp897_;
											_tmp893_ = m;
											_tmp894_ = async_method;
											_tmp895_ = vala_method_get_base_interface_method (_tmp894_);
											_tmp896_ = _tmp895_;
											_tmp897_ = vala_method_get_callback_method (_tmp896_);
											_tmp889_ = _tmp893_ == _tmp897_;
										} else {
											_tmp889_ = FALSE;
										}
										if (_tmp889_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp898_;
								ValaSourceReference* _tmp899_;
								ValaMethod* _tmp900_;
								gchar* _tmp901_;
								gchar* _tmp902_;
								gchar* _tmp903_;
								gchar* _tmp904_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp898_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp899_ = _tmp898_;
								_tmp900_ = m;
								_tmp901_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp900_);
								_tmp902_ = _tmp901_;
								_tmp903_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp902_);
								_tmp904_ = _tmp903_;
								vala_report_error (_tmp899_, _tmp904_);
								_g_free0 (_tmp904_);
								_g_free0 (_tmp902_);
								result = FALSE;
								return result;
							}
							_tmp905_ = async_method;
							_tmp906_ = vala_code_context_get_analyzer (context);
							_tmp907_ = _tmp906_;
							_tmp908_ = vala_semantic_analyzer_get_current_method (_tmp907_);
							_tmp909_ = _tmp908_;
							if (_tmp905_ != _tmp909_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp910_;
								ValaSemanticAnalyzer* _tmp911_;
								ValaMethod* _tmp912_;
								ValaMethod* _tmp913_;
								ValaMethod* _tmp922_;
								ValaBlock* _tmp923_;
								ValaBlock* _tmp924_;
								_tmp910_ = vala_code_context_get_analyzer (context);
								_tmp911_ = _tmp910_;
								_tmp912_ = vala_semantic_analyzer_get_current_method (_tmp911_);
								_tmp913_ = _tmp912_;
								sym = (ValaSymbol*) _tmp913_;
								while (TRUE) {
									ValaSymbol* _tmp914_;
									ValaMethod* _tmp915_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp916_;
									ValaMethod* _tmp917_;
									ValaSymbol* _tmp919_;
									ValaSymbol* _tmp920_;
									ValaSymbol* _tmp921_;
									_tmp914_ = sym;
									_tmp915_ = async_method;
									if (!(_tmp914_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp915_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp916_ = sym;
									method = VALA_IS_METHOD (_tmp916_) ? ((ValaMethod*) _tmp916_) : NULL;
									_tmp917_ = method;
									if (_tmp917_ != NULL) {
										ValaMethod* _tmp918_;
										_tmp918_ = method;
										vala_method_set_closure (_tmp918_, TRUE);
									}
									_tmp919_ = sym;
									_tmp920_ = vala_symbol_get_parent_symbol (_tmp919_);
									_tmp921_ = _tmp920_;
									sym = _tmp921_;
								}
								_tmp922_ = async_method;
								_tmp923_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp922_);
								_tmp924_ = _tmp923_;
								vala_block_set_captured (_tmp924_, TRUE);
							}
							_tmp925_ = async_method;
							_tmp926_ = vala_method_get_callback_method (_tmp925_);
							m = _tmp926_;
							_tmp927_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp927_);
							_tmp928_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp929_ = _tmp928_;
							member = _tmp929_;
						} else {
							ValaMethod* _tmp930_;
							ValaMethod* _tmp931_;
							ValaMethod* _tmp932_;
							_tmp930_ = m;
							_tmp931_ = vala_method_get_base_method (_tmp930_);
							_tmp932_ = _tmp931_;
							if (_tmp932_ != NULL) {
								ValaMethod* _tmp933_;
								ValaMethod* _tmp934_;
								ValaMethod* _tmp935_;
								ValaMethod* _tmp936_;
								ValaSignal* _tmp937_;
								ValaSignal* _tmp938_;
								ValaSymbol* _tmp943_;
								ValaSymbol* _tmp944_;
								_tmp933_ = m;
								_tmp934_ = vala_method_get_base_method (_tmp933_);
								_tmp935_ = _tmp934_;
								m = _tmp935_;
								_tmp936_ = m;
								_tmp937_ = vala_method_get_signal_reference (_tmp936_);
								_tmp938_ = _tmp937_;
								if (_tmp938_ != NULL) {
									ValaMethod* _tmp939_;
									ValaSignal* _tmp940_;
									ValaSignal* _tmp941_;
									_tmp939_ = m;
									_tmp940_ = vala_method_get_signal_reference (_tmp939_);
									_tmp941_ = _tmp940_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp941_);
								} else {
									ValaMethod* _tmp942_;
									_tmp942_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp942_);
								}
								_tmp943_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp944_ = _tmp943_;
								member = _tmp944_;
							} else {
								ValaMethod* _tmp945_;
								ValaMethod* _tmp946_;
								ValaMethod* _tmp947_;
								_tmp945_ = m;
								_tmp946_ = vala_method_get_base_interface_method (_tmp945_);
								_tmp947_ = _tmp946_;
								if (_tmp947_ != NULL) {
									ValaMethod* _tmp948_;
									ValaMethod* _tmp949_;
									ValaMethod* _tmp950_;
									ValaMethod* _tmp951_;
									ValaSignal* _tmp952_;
									ValaSignal* _tmp953_;
									ValaSymbol* _tmp958_;
									ValaSymbol* _tmp959_;
									_tmp948_ = m;
									_tmp949_ = vala_method_get_base_interface_method (_tmp948_);
									_tmp950_ = _tmp949_;
									m = _tmp950_;
									_tmp951_ = m;
									_tmp952_ = vala_method_get_signal_reference (_tmp951_);
									_tmp953_ = _tmp952_;
									if (_tmp953_ != NULL) {
										ValaMethod* _tmp954_;
										ValaSignal* _tmp955_;
										ValaSignal* _tmp956_;
										_tmp954_ = m;
										_tmp955_ = vala_method_get_signal_reference (_tmp954_);
										_tmp956_ = _tmp955_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp956_);
									} else {
										ValaMethod* _tmp957_;
										_tmp957_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp957_);
									}
									_tmp958_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp959_ = _tmp958_;
									member = _tmp959_;
								}
							}
						}
						_tmp960_ = m;
						_tmp961_ = vala_symbol_get_access ((ValaSymbol*) _tmp960_);
						_tmp962_ = _tmp961_;
						access = _tmp962_;
						_tmp963_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp963_)) {
							ValaMethod* _tmp964_;
							ValaMemberBinding _tmp965_;
							ValaMemberBinding _tmp966_;
							_tmp964_ = m;
							_tmp965_ = vala_method_get_binding (_tmp964_);
							_tmp966_ = _tmp965_;
							instance = _tmp966_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp967_ = m;
						_tmp968_ = vala_method_get_binding (_tmp967_);
						_tmp969_ = _tmp968_;
						klass = _tmp969_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp970_;
							ValaList* _tmp971_;
							ValaList* _tmp972_;
							gint _param_size = 0;
							ValaList* _tmp973_;
							gint _tmp974_;
							gint _tmp975_;
							gint _param_index = 0;
							_tmp970_ = m;
							_tmp971_ = vala_callable_get_parameters ((ValaCallable*) _tmp970_);
							_tmp972_ = _vala_iterable_ref0 (_tmp971_);
							_param_list = _tmp972_;
							_tmp973_ = _param_list;
							_tmp974_ = vala_collection_get_size ((ValaCollection*) _tmp973_);
							_tmp975_ = _tmp974_;
							_param_size = _tmp975_;
							_param_index = -1;
							while (TRUE) {
								ValaParameter* param = NULL;
								ValaList* _tmp976_;
								gpointer _tmp977_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp978_;
								ValaDataType* _tmp979_;
								ValaDataType* _tmp980_;
								gboolean _tmp981_ = FALSE;
								ValaGenericType* _tmp982_;
								_param_index = _param_index + 1;
								if (!(_param_index < _param_size)) {
									break;
								}
								_tmp976_ = _param_list;
								_tmp977_ = vala_list_get (_tmp976_, _param_index);
								param = (ValaParameter*) _tmp977_;
								_tmp978_ = param;
								_tmp979_ = vala_variable_get_variable_type ((ValaVariable*) _tmp978_);
								_tmp980_ = _tmp979_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp980_) ? ((ValaGenericType*) _tmp980_) : NULL;
								_tmp982_ = generic_type;
								if (_tmp982_ != NULL) {
									ValaGenericType* _tmp983_;
									ValaTypeParameter* _tmp984_;
									ValaTypeParameter* _tmp985_;
									ValaSymbol* _tmp986_;
									ValaSymbol* _tmp987_;
									_tmp983_ = generic_type;
									_tmp984_ = vala_generic_type_get_type_parameter (_tmp983_);
									_tmp985_ = _tmp984_;
									_tmp986_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp985_);
									_tmp987_ = _tmp986_;
									_tmp981_ = VALA_IS_TYPESYMBOL (_tmp987_);
								} else {
									_tmp981_ = FALSE;
								}
								if (_tmp981_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp988_ = m;
						_tmp989_ = vala_callable_get_return_type ((ValaCallable*) _tmp988_);
						_tmp990_ = _tmp989_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp990_) ? ((ValaGenericType*) _tmp990_) : NULL;
						_tmp992_ = generic_type;
						if (_tmp992_ != NULL) {
							ValaGenericType* _tmp993_;
							ValaTypeParameter* _tmp994_;
							ValaTypeParameter* _tmp995_;
							ValaSymbol* _tmp996_;
							ValaSymbol* _tmp997_;
							_tmp993_ = generic_type;
							_tmp994_ = vala_generic_type_get_type_parameter (_tmp993_);
							_tmp995_ = _tmp994_;
							_tmp996_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp995_);
							_tmp997_ = _tmp996_;
							_tmp991_ = VALA_IS_TYPESYMBOL (_tmp997_);
						} else {
							_tmp991_ = FALSE;
						}
						if (_tmp991_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp998_;
						_tmp998_ = member;
						if (VALA_IS_PROPERTY (_tmp998_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp999_;
							ValaProperty* _tmp1000_;
							ValaProperty* _tmp1001_;
							ValaProperty* _tmp1002_;
							ValaProperty* _tmp1003_;
							ValaProperty* _tmp1019_;
							ValaSymbolAccessibility _tmp1020_;
							ValaSymbolAccessibility _tmp1021_;
							gboolean _tmp1022_;
							gboolean _tmp1023_;
							ValaProperty* _tmp1088_;
							ValaMemberBinding _tmp1089_;
							ValaMemberBinding _tmp1090_;
							ValaProperty* _tmp1091_;
							ValaDataType* _tmp1092_;
							ValaDataType* _tmp1093_;
							_tmp999_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp999_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1000_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1000_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1001_ = prop;
							_tmp1002_ = vala_property_get_base_property (_tmp1001_);
							_tmp1003_ = _tmp1002_;
							if (_tmp1003_ != NULL) {
								ValaProperty* _tmp1004_;
								ValaProperty* _tmp1005_;
								ValaProperty* _tmp1006_;
								ValaProperty* _tmp1007_;
								ValaSymbol* _tmp1008_;
								ValaSymbol* _tmp1009_;
								_tmp1004_ = prop;
								_tmp1005_ = vala_property_get_base_property (_tmp1004_);
								_tmp1006_ = _tmp1005_;
								prop = _tmp1006_;
								_tmp1007_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1007_);
								_tmp1008_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1009_ = _tmp1008_;
								member = _tmp1009_;
							} else {
								ValaProperty* _tmp1010_;
								ValaProperty* _tmp1011_;
								ValaProperty* _tmp1012_;
								_tmp1010_ = prop;
								_tmp1011_ = vala_property_get_base_interface_property (_tmp1010_);
								_tmp1012_ = _tmp1011_;
								if (_tmp1012_ != NULL) {
									ValaProperty* _tmp1013_;
									ValaProperty* _tmp1014_;
									ValaProperty* _tmp1015_;
									ValaProperty* _tmp1016_;
									ValaSymbol* _tmp1017_;
									ValaSymbol* _tmp1018_;
									_tmp1013_ = prop;
									_tmp1014_ = vala_property_get_base_interface_property (_tmp1013_);
									_tmp1015_ = _tmp1014_;
									prop = _tmp1015_;
									_tmp1016_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1016_);
									_tmp1017_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1018_ = _tmp1017_;
									member = _tmp1018_;
								}
							}
							_tmp1019_ = prop;
							_tmp1020_ = vala_symbol_get_access ((ValaSymbol*) _tmp1019_);
							_tmp1021_ = _tmp1020_;
							access = _tmp1021_;
							_tmp1022_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1023_ = _tmp1022_;
							if (_tmp1023_) {
								ValaProperty* _tmp1024_;
								ValaPropertyAccessor* _tmp1025_;
								ValaPropertyAccessor* _tmp1026_;
								ValaProperty* _tmp1034_;
								ValaSymbolAccessibility _tmp1035_;
								ValaSymbolAccessibility _tmp1036_;
								_tmp1024_ = prop;
								_tmp1025_ = vala_property_get_set_accessor (_tmp1024_);
								_tmp1026_ = _tmp1025_;
								if (_tmp1026_ == NULL) {
									ValaSourceReference* _tmp1027_;
									ValaSourceReference* _tmp1028_;
									ValaProperty* _tmp1029_;
									gchar* _tmp1030_;
									gchar* _tmp1031_;
									gchar* _tmp1032_;
									gchar* _tmp1033_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1027_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1028_ = _tmp1027_;
									_tmp1029_ = prop;
									_tmp1030_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1029_);
									_tmp1031_ = _tmp1030_;
									_tmp1032_ = g_strdup_printf ("Property `%s' is read-only", _tmp1031_);
									_tmp1033_ = _tmp1032_;
									vala_report_error (_tmp1028_, _tmp1033_);
									_g_free0 (_tmp1033_);
									_g_free0 (_tmp1031_);
									result = FALSE;
									return result;
								}
								_tmp1034_ = prop;
								_tmp1035_ = vala_symbol_get_access ((ValaSymbol*) _tmp1034_);
								_tmp1036_ = _tmp1035_;
								if (_tmp1036_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1037_;
									ValaPropertyAccessor* _tmp1038_;
									ValaPropertyAccessor* _tmp1039_;
									ValaSymbolAccessibility _tmp1040_;
									ValaSymbolAccessibility _tmp1041_;
									_tmp1037_ = prop;
									_tmp1038_ = vala_property_get_set_accessor (_tmp1037_);
									_tmp1039_ = _tmp1038_;
									_tmp1040_ = vala_symbol_get_access ((ValaSymbol*) _tmp1039_);
									_tmp1041_ = _tmp1040_;
									access = _tmp1041_;
								} else {
									gboolean _tmp1042_ = FALSE;
									ValaProperty* _tmp1043_;
									ValaSymbolAccessibility _tmp1044_;
									ValaSymbolAccessibility _tmp1045_;
									_tmp1043_ = prop;
									_tmp1044_ = vala_symbol_get_access ((ValaSymbol*) _tmp1043_);
									_tmp1045_ = _tmp1044_;
									if (_tmp1045_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1046_;
										ValaPropertyAccessor* _tmp1047_;
										ValaPropertyAccessor* _tmp1048_;
										ValaSymbolAccessibility _tmp1049_;
										ValaSymbolAccessibility _tmp1050_;
										_tmp1046_ = prop;
										_tmp1047_ = vala_property_get_set_accessor (_tmp1046_);
										_tmp1048_ = _tmp1047_;
										_tmp1049_ = vala_symbol_get_access ((ValaSymbol*) _tmp1048_);
										_tmp1050_ = _tmp1049_;
										_tmp1042_ = _tmp1050_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1042_ = FALSE;
									}
									if (_tmp1042_) {
										ValaProperty* _tmp1051_;
										ValaPropertyAccessor* _tmp1052_;
										ValaPropertyAccessor* _tmp1053_;
										ValaSymbolAccessibility _tmp1054_;
										ValaSymbolAccessibility _tmp1055_;
										_tmp1051_ = prop;
										_tmp1052_ = vala_property_get_set_accessor (_tmp1051_);
										_tmp1053_ = _tmp1052_;
										_tmp1054_ = vala_symbol_get_access ((ValaSymbol*) _tmp1053_);
										_tmp1055_ = _tmp1054_;
										access = _tmp1055_;
									}
								}
							} else {
								ValaProperty* _tmp1056_;
								ValaPropertyAccessor* _tmp1057_;
								ValaPropertyAccessor* _tmp1058_;
								ValaProperty* _tmp1066_;
								ValaSymbolAccessibility _tmp1067_;
								ValaSymbolAccessibility _tmp1068_;
								_tmp1056_ = prop;
								_tmp1057_ = vala_property_get_get_accessor (_tmp1056_);
								_tmp1058_ = _tmp1057_;
								if (_tmp1058_ == NULL) {
									ValaSourceReference* _tmp1059_;
									ValaSourceReference* _tmp1060_;
									ValaProperty* _tmp1061_;
									gchar* _tmp1062_;
									gchar* _tmp1063_;
									gchar* _tmp1064_;
									gchar* _tmp1065_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1059_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1060_ = _tmp1059_;
									_tmp1061_ = prop;
									_tmp1062_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1061_);
									_tmp1063_ = _tmp1062_;
									_tmp1064_ = g_strdup_printf ("Property `%s' is write-only", _tmp1063_);
									_tmp1065_ = _tmp1064_;
									vala_report_error (_tmp1060_, _tmp1065_);
									_g_free0 (_tmp1065_);
									_g_free0 (_tmp1063_);
									result = FALSE;
									return result;
								}
								_tmp1066_ = prop;
								_tmp1067_ = vala_symbol_get_access ((ValaSymbol*) _tmp1066_);
								_tmp1068_ = _tmp1067_;
								if (_tmp1068_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1069_;
									ValaPropertyAccessor* _tmp1070_;
									ValaPropertyAccessor* _tmp1071_;
									ValaSymbolAccessibility _tmp1072_;
									ValaSymbolAccessibility _tmp1073_;
									_tmp1069_ = prop;
									_tmp1070_ = vala_property_get_get_accessor (_tmp1069_);
									_tmp1071_ = _tmp1070_;
									_tmp1072_ = vala_symbol_get_access ((ValaSymbol*) _tmp1071_);
									_tmp1073_ = _tmp1072_;
									access = _tmp1073_;
								} else {
									gboolean _tmp1074_ = FALSE;
									ValaProperty* _tmp1075_;
									ValaSymbolAccessibility _tmp1076_;
									ValaSymbolAccessibility _tmp1077_;
									_tmp1075_ = prop;
									_tmp1076_ = vala_symbol_get_access ((ValaSymbol*) _tmp1075_);
									_tmp1077_ = _tmp1076_;
									if (_tmp1077_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1078_;
										ValaPropertyAccessor* _tmp1079_;
										ValaPropertyAccessor* _tmp1080_;
										ValaSymbolAccessibility _tmp1081_;
										ValaSymbolAccessibility _tmp1082_;
										_tmp1078_ = prop;
										_tmp1079_ = vala_property_get_get_accessor (_tmp1078_);
										_tmp1080_ = _tmp1079_;
										_tmp1081_ = vala_symbol_get_access ((ValaSymbol*) _tmp1080_);
										_tmp1082_ = _tmp1081_;
										_tmp1074_ = _tmp1082_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1074_ = FALSE;
									}
									if (_tmp1074_) {
										ValaProperty* _tmp1083_;
										ValaPropertyAccessor* _tmp1084_;
										ValaPropertyAccessor* _tmp1085_;
										ValaSymbolAccessibility _tmp1086_;
										ValaSymbolAccessibility _tmp1087_;
										_tmp1083_ = prop;
										_tmp1084_ = vala_property_get_get_accessor (_tmp1083_);
										_tmp1085_ = _tmp1084_;
										_tmp1086_ = vala_symbol_get_access ((ValaSymbol*) _tmp1085_);
										_tmp1087_ = _tmp1086_;
										access = _tmp1087_;
									}
								}
							}
							_tmp1088_ = prop;
							_tmp1089_ = vala_property_get_binding (_tmp1088_);
							_tmp1090_ = _tmp1089_;
							instance = _tmp1090_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1091_ = prop;
							_tmp1092_ = vala_property_get_property_type (_tmp1091_);
							_tmp1093_ = _tmp1092_;
							if (VALA_IS_GENERIC_TYPE (_tmp1093_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1094_;
							_tmp1094_ = member;
							if (VALA_IS_SIGNAL (_tmp1094_)) {
								ValaSymbol* _tmp1095_;
								ValaSymbolAccessibility _tmp1096_;
								ValaSymbolAccessibility _tmp1097_;
								instance = TRUE;
								_tmp1095_ = member;
								_tmp1096_ = vala_symbol_get_access (_tmp1095_);
								_tmp1097_ = _tmp1096_;
								access = _tmp1097_;
							} else {
								gboolean _tmp1098_ = FALSE;
								gboolean _tmp1099_;
								_tmp1099_ = self->priv->_creation_member;
								if (!_tmp1099_) {
									ValaSymbol* _tmp1100_;
									_tmp1100_ = member;
									_tmp1098_ = VALA_IS_ERROR_CODE (_tmp1100_);
								} else {
									_tmp1098_ = FALSE;
								}
								if (_tmp1098_) {
									ValaSymbol* _tmp1101_;
									ValaConstant* _tmp1102_;
									ValaConstant* _tmp1103_;
									ValaSymbol* _tmp1104_;
									ValaSymbol* _tmp1105_;
									_tmp1101_ = member;
									_tmp1102_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1103_ = _tmp1102_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1103_);
									_tmp1104_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1105_ = _tmp1104_;
									member = _tmp1105_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1106_;
		ValaSymbol* _tmp1107_;
		ValaCodeNode* _tmp1108_;
		ValaCodeNode* _tmp1109_;
		ValaCodeNode* _tmp1110_;
		gboolean _tmp1111_ = FALSE;
		ValaCodeNode* _tmp1112_;
		_tmp1106_ = parent;
		_tmp1107_ = member;
		if (!(_tmp1106_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1107_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1108_ = parent;
		_tmp1109_ = vala_code_node_get_parent_node (_tmp1108_);
		_tmp1110_ = _tmp1109_;
		parent = _tmp1110_;
		_tmp1112_ = parent;
		if (_tmp1112_ == NULL) {
			_tmp1111_ = TRUE;
		} else {
			ValaCodeNode* _tmp1113_;
			ValaSymbol* _tmp1114_;
			_tmp1113_ = parent;
			_tmp1114_ = member;
			_tmp1111_ = _tmp1113_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1111_) {
			break;
		}
	}
	_tmp1115_ = parent;
	_tmp1116_ = member;
	if (_tmp1115_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1116_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1117_;
		_tmp1117_ = member;
		vala_symbol_set_used (_tmp1117_, TRUE);
	}
	_tmp1118_ = member;
	_tmp1119_ = vala_symbol_get_version (_tmp1118_);
	_tmp1120_ = _tmp1119_;
	_tmp1121_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1122_ = _tmp1121_;
	vala_version_attribute_check (_tmp1120_, _tmp1122_);
	_tmp1124_ = access;
	if (_tmp1124_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1125_;
		ValaSymbol* _tmp1126_;
		ValaSymbol* _tmp1127_;
		_tmp1125_ = member;
		_tmp1126_ = vala_symbol_get_parent_symbol (_tmp1125_);
		_tmp1127_ = _tmp1126_;
		_tmp1123_ = VALA_IS_TYPESYMBOL (_tmp1127_);
	} else {
		_tmp1123_ = FALSE;
	}
	if (_tmp1123_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1128_;
		ValaSymbol* _tmp1129_;
		ValaSymbol* _tmp1130_;
		gboolean in_subtype = FALSE;
		_tmp1128_ = member;
		_tmp1129_ = vala_symbol_get_parent_symbol (_tmp1128_);
		_tmp1130_ = _tmp1129_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1130_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1131_;
			ValaSemanticAnalyzer* _tmp1132_;
			ValaSymbol* _tmp1133_;
			ValaSymbol* _tmp1134_;
			ValaSymbol* _tmp1135_;
			_tmp1131_ = vala_code_context_get_analyzer (context);
			_tmp1132_ = _tmp1131_;
			_tmp1133_ = vala_semantic_analyzer_get_current_symbol (_tmp1132_);
			_tmp1134_ = _tmp1133_;
			_tmp1135_ = _vala_code_node_ref0 (_tmp1134_);
			this_symbol = _tmp1135_;
			{
				gboolean _tmp1136_ = FALSE;
				_tmp1136_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1141_;
					ValaSymbol* _tmp1142_;
					ValaTypeSymbol* _tmp1143_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1144_;
					gboolean _tmp1145_ = FALSE;
					ValaClass* _tmp1146_;
					if (!_tmp1136_) {
						ValaSymbol* _tmp1137_;
						ValaSymbol* _tmp1138_;
						ValaSymbol* _tmp1139_;
						ValaSymbol* _tmp1140_;
						_tmp1137_ = this_symbol;
						_tmp1138_ = vala_symbol_get_parent_symbol (_tmp1137_);
						_tmp1139_ = _tmp1138_;
						_tmp1140_ = _vala_code_node_ref0 (_tmp1139_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1140_;
					}
					_tmp1136_ = FALSE;
					_tmp1141_ = this_symbol;
					if (!(_tmp1141_ != NULL)) {
						break;
					}
					_tmp1142_ = this_symbol;
					_tmp1143_ = target_type;
					if (_tmp1142_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1143_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1144_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1144_) ? ((ValaClass*) _tmp1144_) : NULL;
					_tmp1146_ = cl;
					if (_tmp1146_ != NULL) {
						ValaClass* _tmp1147_;
						ValaTypeSymbol* _tmp1148_;
						_tmp1147_ = cl;
						_tmp1148_ = target_type;
						_tmp1145_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1147_, _tmp1148_);
					} else {
						_tmp1145_ = FALSE;
					}
					if (_tmp1145_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1149_;
			ValaSourceReference* _tmp1150_;
			ValaSymbol* _tmp1151_;
			gchar* _tmp1152_;
			gchar* _tmp1153_;
			gchar* _tmp1154_;
			gchar* _tmp1155_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1150_ = _tmp1149_;
			_tmp1151_ = member;
			_tmp1152_ = vala_symbol_get_full_name (_tmp1151_);
			_tmp1153_ = _tmp1152_;
			_tmp1154_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1153_);
			_tmp1155_ = _tmp1154_;
			vala_report_error (_tmp1150_, _tmp1155_);
			_g_free0 (_tmp1155_);
			_g_free0 (_tmp1153_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1156_;
		_tmp1156_ = access;
		if (_tmp1156_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1157_;
			ValaSymbol* _tmp1158_;
			ValaSymbol* _tmp1159_;
			gboolean in_target_type = FALSE;
			_tmp1157_ = member;
			_tmp1158_ = vala_symbol_get_parent_symbol (_tmp1157_);
			_tmp1159_ = _tmp1158_;
			target_type = _tmp1159_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1160_;
				ValaSemanticAnalyzer* _tmp1161_;
				ValaSymbol* _tmp1162_;
				ValaSymbol* _tmp1163_;
				ValaSymbol* _tmp1164_;
				_tmp1160_ = vala_code_context_get_analyzer (context);
				_tmp1161_ = _tmp1160_;
				_tmp1162_ = vala_semantic_analyzer_get_current_symbol (_tmp1161_);
				_tmp1163_ = _tmp1162_;
				_tmp1164_ = _vala_code_node_ref0 (_tmp1163_);
				this_symbol = _tmp1164_;
				{
					gboolean _tmp1165_ = FALSE;
					_tmp1165_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1170_;
						ValaSymbol* _tmp1171_;
						ValaSymbol* _tmp1172_;
						if (!_tmp1165_) {
							ValaSymbol* _tmp1166_;
							ValaSymbol* _tmp1167_;
							ValaSymbol* _tmp1168_;
							ValaSymbol* _tmp1169_;
							_tmp1166_ = this_symbol;
							_tmp1167_ = vala_symbol_get_parent_symbol (_tmp1166_);
							_tmp1168_ = _tmp1167_;
							_tmp1169_ = _vala_code_node_ref0 (_tmp1168_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1169_;
						}
						_tmp1165_ = FALSE;
						_tmp1170_ = this_symbol;
						if (!(_tmp1170_ != NULL)) {
							break;
						}
						_tmp1171_ = target_type;
						_tmp1172_ = this_symbol;
						if (_tmp1171_ == _tmp1172_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1173_;
				ValaSourceReference* _tmp1174_;
				ValaSymbol* _tmp1175_;
				gchar* _tmp1176_;
				gchar* _tmp1177_;
				gchar* _tmp1178_;
				gchar* _tmp1179_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1173_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1174_ = _tmp1173_;
				_tmp1175_ = member;
				_tmp1176_ = vala_symbol_get_full_name (_tmp1175_);
				_tmp1177_ = _tmp1176_;
				_tmp1178_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1177_);
				_tmp1179_ = _tmp1178_;
				vala_report_error (_tmp1174_, _tmp1179_);
				_g_free0 (_tmp1179_);
				_g_free0 (_tmp1177_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1181_;
		ValaExpression* _tmp1182_;
		_tmp1181_ = vala_member_access_get_inner (self);
		_tmp1182_ = _tmp1181_;
		_tmp1180_ = _tmp1182_ != NULL;
	} else {
		_tmp1180_ = FALSE;
	}
	if (_tmp1180_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1183_;
		ValaExpression* _tmp1184_;
		ValaDataType* _tmp1185_;
		ValaDataType* _tmp1186_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1187_;
		ValaExpression* _tmp1188_;
		ValaDataType* _tmp1189_;
		ValaDataType* _tmp1190_;
		ValaPointerType* _tmp1191_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1195_;
		gboolean _tmp1196_ = FALSE;
		gboolean _tmp1197_ = FALSE;
		ValaObjectType* _tmp1198_;
		_tmp1183_ = vala_member_access_get_inner (self);
		_tmp1184_ = _tmp1183_;
		_tmp1185_ = vala_expression_get_value_type (_tmp1184_);
		_tmp1186_ = _tmp1185_;
		instance_type = _tmp1186_;
		_tmp1187_ = vala_member_access_get_inner (self);
		_tmp1188_ = _tmp1187_;
		_tmp1189_ = vala_expression_get_value_type (_tmp1188_);
		_tmp1190_ = _tmp1189_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1190_) ? ((ValaPointerType*) _tmp1190_) : NULL;
		_tmp1191_ = pointer_type;
		if (_tmp1191_ != NULL) {
			ValaPointerType* _tmp1192_;
			ValaDataType* _tmp1193_;
			ValaDataType* _tmp1194_;
			_tmp1192_ = pointer_type;
			_tmp1193_ = vala_pointer_type_get_base_type (_tmp1192_);
			_tmp1194_ = _tmp1193_;
			instance_type = _tmp1194_;
		}
		_tmp1195_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1195_) ? ((ValaObjectType*) _tmp1195_) : NULL;
		_tmp1198_ = object_type;
		if (_tmp1198_ != NULL) {
			ValaObjectType* _tmp1199_;
			ValaObjectTypeSymbol* _tmp1200_;
			ValaObjectTypeSymbol* _tmp1201_;
			_tmp1199_ = object_type;
			_tmp1200_ = vala_object_type_get_object_type_symbol (_tmp1199_);
			_tmp1201_ = _tmp1200_;
			_tmp1197_ = vala_object_type_symbol_has_type_parameters (_tmp1201_);
		} else {
			_tmp1197_ = FALSE;
		}
		if (_tmp1197_) {
			ValaDataType* _tmp1202_;
			_tmp1202_ = instance_type;
			_tmp1196_ = !vala_data_type_has_type_arguments (_tmp1202_);
		} else {
			_tmp1196_ = FALSE;
		}
		if (_tmp1196_) {
			ValaExpression* _tmp1203_;
			ValaExpression* _tmp1204_;
			ValaSourceReference* _tmp1205_;
			ValaSourceReference* _tmp1206_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1203_ = vala_member_access_get_inner (self);
			_tmp1204_ = _tmp1203_;
			_tmp1205_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1204_);
			_tmp1206_ = _tmp1205_;
			vala_report_error (_tmp1206_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1208_ = !may_access_instance_members;
	} else {
		_tmp1208_ = FALSE;
	}
	if (_tmp1208_) {
		_tmp1207_ = TRUE;
	} else {
		gboolean _tmp1209_ = FALSE;
		if (klass) {
			_tmp1209_ = !may_access_klass_members;
		} else {
			_tmp1209_ = FALSE;
		}
		_tmp1207_ = _tmp1209_;
	}
	if (_tmp1207_) {
		ValaSymbol* _tmp1210_;
		ValaSymbol* _tmp1211_;
		ValaDataType* _tmp1234_;
		ValaDataType* _tmp1235_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1210_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1211_ = _tmp1210_;
		if (VALA_IS_METHOD (_tmp1211_)) {
			ValaSemanticAnalyzer* _tmp1212_;
			ValaSemanticAnalyzer* _tmp1213_;
			ValaSymbol* _tmp1214_;
			ValaSymbol* _tmp1215_;
			gboolean _tmp1216_;
			gboolean _tmp1217_;
			ValaDataType* _tmp1218_;
			ValaDataType* _tmp1219_;
			_tmp1212_ = vala_code_context_get_analyzer (context);
			_tmp1213_ = _tmp1212_;
			_tmp1214_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1217_ = _tmp1216_;
			_tmp1218_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1213_, _tmp1215_, _tmp1217_);
			_tmp1219_ = _tmp1218_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1219_);
			_vala_code_node_unref0 (_tmp1219_);
		} else {
			ValaSymbol* _tmp1220_;
			ValaSymbol* _tmp1221_;
			_tmp1220_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1221_ = _tmp1220_;
			if (VALA_IS_FIELD (_tmp1221_)) {
				ValaSymbol* _tmp1222_;
				ValaSymbol* _tmp1223_;
				ValaFieldPrototype* _tmp1224_;
				ValaFieldPrototype* _tmp1225_;
				_tmp1222_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1223_ = _tmp1222_;
				_tmp1224_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1223_, VALA_TYPE_FIELD, ValaField));
				_tmp1225_ = _tmp1224_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1225_);
				_vala_code_node_unref0 (_tmp1225_);
			} else {
				ValaSymbol* _tmp1226_;
				ValaSymbol* _tmp1227_;
				_tmp1226_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1227_ = _tmp1226_;
				if (VALA_IS_PROPERTY (_tmp1227_)) {
					ValaSymbol* _tmp1228_;
					ValaSymbol* _tmp1229_;
					ValaPropertyPrototype* _tmp1230_;
					ValaPropertyPrototype* _tmp1231_;
					_tmp1228_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1229_ = _tmp1228_;
					_tmp1230_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1229_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1231_ = _tmp1230_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1231_);
					_vala_code_node_unref0 (_tmp1231_);
				} else {
					ValaInvalidType* _tmp1232_;
					ValaInvalidType* _tmp1233_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1232_ = vala_invalid_type_new ();
					_tmp1233_ = _tmp1232_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1233_);
					_vala_code_node_unref0 (_tmp1233_);
				}
			}
		}
		_tmp1234_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1235_ = _tmp1234_;
		if (_tmp1235_ != NULL) {
			ValaDataType* _tmp1236_;
			ValaDataType* _tmp1237_;
			ValaDataType* _tmp1238_;
			ValaDataType* _tmp1239_;
			gboolean _tmp1240_;
			gboolean _tmp1241_;
			_tmp1236_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1239_ = _tmp1238_;
			_tmp1240_ = vala_data_type_get_value_owned (_tmp1239_);
			_tmp1241_ = _tmp1240_;
			vala_data_type_set_value_owned (_tmp1237_, _tmp1241_);
		}
	} else {
		gboolean _tmp1242_ = FALSE;
		gboolean _tmp1263_ = FALSE;
		gboolean _tmp1264_ = FALSE;
		gboolean _tmp1265_ = FALSE;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1308_ = FALSE;
		gboolean _tmp1309_ = FALSE;
		gboolean _tmp1310_ = FALSE;
		gboolean _tmp1311_ = FALSE;
		gboolean _tmp1312_ = FALSE;
		gboolean _tmp1313_;
		gboolean _tmp1314_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1341_;
		ValaSymbol* _tmp1342_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1343_;
		ValaExpression* _tmp1344_;
		gboolean _tmp1345_ = FALSE;
		gboolean _tmp1346_ = FALSE;
		gboolean _tmp1347_ = FALSE;
		gboolean _tmp1348_ = FALSE;
		gboolean _tmp1349_ = FALSE;
		ValaMethod* _tmp1350_;
		ValaSemanticAnalyzer* _tmp1387_;
		ValaSemanticAnalyzer* _tmp1388_;
		ValaSymbol* _tmp1389_;
		ValaSymbol* _tmp1390_;
		gboolean _tmp1391_;
		gboolean _tmp1392_;
		ValaDataType* _tmp1393_;
		ValaDataType* _tmp1394_;
		gboolean _tmp1395_ = FALSE;
		ValaExpression* _tmp1396_;
		ValaExpression* _tmp1397_;
		ValaSymbol* _tmp1410_;
		ValaSymbol* _tmp1411_;
		if (instance) {
			ValaExpression* _tmp1243_;
			ValaExpression* _tmp1244_;
			_tmp1243_ = vala_member_access_get_inner (self);
			_tmp1244_ = _tmp1243_;
			_tmp1242_ = _tmp1244_ == NULL;
		} else {
			_tmp1242_ = FALSE;
		}
		if (_tmp1242_) {
			ValaSourceReference* _tmp1245_;
			ValaSourceReference* _tmp1246_;
			ValaMemberAccess* _tmp1247_;
			ValaMemberAccess* _tmp1248_;
			ValaExpression* _tmp1249_;
			ValaExpression* _tmp1250_;
			ValaParameter* _tmp1251_;
			ValaDataType* _tmp1252_;
			ValaDataType* _tmp1253_;
			ValaDataType* _tmp1254_;
			ValaDataType* _tmp1255_;
			ValaExpression* _tmp1256_;
			ValaExpression* _tmp1257_;
			ValaDataType* _tmp1258_;
			ValaDataType* _tmp1259_;
			ValaExpression* _tmp1260_;
			ValaExpression* _tmp1261_;
			ValaParameter* _tmp1262_;
			_tmp1245_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1246_ = _tmp1245_;
			_tmp1247_ = vala_member_access_new (NULL, "this", _tmp1246_);
			_tmp1248_ = _tmp1247_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1248_);
			_vala_code_node_unref0 (_tmp1248_);
			_tmp1249_ = vala_member_access_get_inner (self);
			_tmp1250_ = _tmp1249_;
			_tmp1251_ = this_parameter;
			_tmp1252_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1251_);
			_tmp1253_ = _tmp1252_;
			_tmp1254_ = vala_data_type_copy (_tmp1253_);
			_tmp1255_ = _tmp1254_;
			vala_expression_set_value_type (_tmp1250_, _tmp1255_);
			_vala_code_node_unref0 (_tmp1255_);
			_tmp1256_ = vala_member_access_get_inner (self);
			_tmp1257_ = _tmp1256_;
			_tmp1258_ = vala_expression_get_value_type (_tmp1257_);
			_tmp1259_ = _tmp1258_;
			vala_data_type_set_value_owned (_tmp1259_, FALSE);
			_tmp1260_ = vala_member_access_get_inner (self);
			_tmp1261_ = _tmp1260_;
			_tmp1262_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1261_, (ValaSymbol*) _tmp1262_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1266_ = !klass;
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			ValaSymbol* _tmp1267_;
			ValaSymbol* _tmp1268_;
			_tmp1267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1268_ = _tmp1267_;
			_tmp1265_ = !VALA_IS_CREATION_METHOD (_tmp1268_);
		} else {
			_tmp1265_ = FALSE;
		}
		if (_tmp1265_) {
			_tmp1264_ = may_access_instance_members;
		} else {
			_tmp1264_ = FALSE;
		}
		if (_tmp1264_) {
			ValaExpression* _tmp1269_;
			ValaExpression* _tmp1270_;
			_tmp1269_ = vala_member_access_get_inner (self);
			_tmp1270_ = _tmp1269_;
			_tmp1263_ = _tmp1270_ != NULL;
		} else {
			_tmp1263_ = FALSE;
		}
		if (_tmp1263_) {
			ValaExpression* _tmp1271_;
			ValaExpression* _tmp1272_;
			ValaSymbol* _tmp1273_;
			ValaSymbol* _tmp1274_;
			_tmp1271_ = vala_member_access_get_inner (self);
			_tmp1272_ = _tmp1271_;
			_tmp1273_ = vala_expression_get_symbol_reference (_tmp1272_);
			_tmp1274_ = _tmp1273_;
			if (VALA_IS_METHOD (_tmp1274_)) {
			} else {
				ValaSourceReference* _tmp1275_;
				ValaSourceReference* _tmp1276_;
				ValaSymbol* _tmp1277_;
				ValaSymbol* _tmp1278_;
				gchar* _tmp1279_;
				gchar* _tmp1280_;
				gchar* _tmp1281_;
				gchar* _tmp1282_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1283_;
				ValaSymbol* _tmp1284_;
				ValaSymbol* _tmp1285_;
				ValaSymbol* _tmp1286_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1306_;
				ValaExpression* _tmp1307_;
				_tmp1275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1276_ = _tmp1275_;
				_tmp1277_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1278_ = _tmp1277_;
				_tmp1279_ = vala_symbol_get_full_name (_tmp1278_);
				_tmp1280_ = _tmp1279_;
				_tmp1281_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1280_);
				_tmp1282_ = _tmp1281_;
				vala_report_warning (_tmp1276_, _tmp1282_);
				_g_free0 (_tmp1282_);
				_g_free0 (_tmp1280_);
				_tmp1283_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1284_ = _tmp1283_;
				_tmp1285_ = vala_symbol_get_parent_symbol (_tmp1284_);
				_tmp1286_ = _tmp1285_;
				inner_sym = _tmp1286_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1287_ = FALSE;
					ValaSymbol* _tmp1288_;
					ValaMemberAccess* _tmp1292_;
					ValaSymbol* _tmp1293_;
					const gchar* _tmp1294_;
					const gchar* _tmp1295_;
					ValaSourceReference* _tmp1296_;
					ValaSourceReference* _tmp1297_;
					ValaMemberAccess* _tmp1298_;
					ValaMemberAccess* _tmp1299_;
					ValaMemberAccess* _tmp1300_;
					ValaExpression* _tmp1301_;
					ValaExpression* _tmp1302_;
					ValaSymbol* _tmp1303_;
					ValaSymbol* _tmp1304_;
					ValaSymbol* _tmp1305_;
					_tmp1288_ = inner_sym;
					if (_tmp1288_ != NULL) {
						ValaSymbol* _tmp1289_;
						const gchar* _tmp1290_;
						const gchar* _tmp1291_;
						_tmp1289_ = inner_sym;
						_tmp1290_ = vala_symbol_get_name (_tmp1289_);
						_tmp1291_ = _tmp1290_;
						_tmp1287_ = _tmp1291_ != NULL;
					} else {
						_tmp1287_ = FALSE;
					}
					if (!_tmp1287_) {
						break;
					}
					_tmp1292_ = inner_ma;
					_tmp1293_ = inner_sym;
					_tmp1294_ = vala_symbol_get_name (_tmp1293_);
					_tmp1295_ = _tmp1294_;
					_tmp1296_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1297_ = _tmp1296_;
					_tmp1298_ = vala_member_access_new (NULL, _tmp1295_, _tmp1297_);
					_tmp1299_ = _tmp1298_;
					vala_member_access_set_inner (_tmp1292_, (ValaExpression*) _tmp1299_);
					_vala_code_node_unref0 (_tmp1299_);
					_tmp1300_ = inner_ma;
					_tmp1301_ = vala_member_access_get_inner (_tmp1300_);
					_tmp1302_ = _tmp1301_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1302_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1303_ = inner_sym;
					_tmp1304_ = vala_symbol_get_parent_symbol (_tmp1303_);
					_tmp1305_ = _tmp1304_;
					inner_sym = _tmp1305_;
				}
				_tmp1306_ = vala_member_access_get_inner (self);
				_tmp1307_ = _tmp1306_;
				vala_code_node_check ((ValaCodeNode*) _tmp1307_, context);
			}
		}
		_tmp1313_ = vala_code_context_get_experimental_non_null (context);
		_tmp1314_ = _tmp1313_;
		if (_tmp1314_) {
			_tmp1312_ = instance;
		} else {
			_tmp1312_ = FALSE;
		}
		if (_tmp1312_) {
			ValaExpression* _tmp1315_;
			ValaExpression* _tmp1316_;
			ValaDataType* _tmp1317_;
			ValaDataType* _tmp1318_;
			gboolean _tmp1319_;
			gboolean _tmp1320_;
			_tmp1315_ = vala_member_access_get_inner (self);
			_tmp1316_ = _tmp1315_;
			_tmp1317_ = vala_expression_get_value_type (_tmp1316_);
			_tmp1318_ = _tmp1317_;
			_tmp1319_ = vala_data_type_get_nullable (_tmp1318_);
			_tmp1320_ = _tmp1319_;
			_tmp1311_ = _tmp1320_;
		} else {
			_tmp1311_ = FALSE;
		}
		if (_tmp1311_) {
			ValaExpression* _tmp1321_;
			ValaExpression* _tmp1322_;
			ValaDataType* _tmp1323_;
			ValaDataType* _tmp1324_;
			_tmp1321_ = vala_member_access_get_inner (self);
			_tmp1322_ = _tmp1321_;
			_tmp1323_ = vala_expression_get_value_type (_tmp1322_);
			_tmp1324_ = _tmp1323_;
			_tmp1310_ = !VALA_IS_POINTER_TYPE (_tmp1324_);
		} else {
			_tmp1310_ = FALSE;
		}
		if (_tmp1310_) {
			ValaExpression* _tmp1325_;
			ValaExpression* _tmp1326_;
			ValaDataType* _tmp1327_;
			ValaDataType* _tmp1328_;
			_tmp1325_ = vala_member_access_get_inner (self);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = vala_expression_get_value_type (_tmp1326_);
			_tmp1328_ = _tmp1327_;
			_tmp1309_ = !VALA_IS_GENERIC_TYPE (_tmp1328_);
		} else {
			_tmp1309_ = FALSE;
		}
		if (_tmp1309_) {
			ValaExpression* _tmp1329_;
			ValaExpression* _tmp1330_;
			ValaDataType* _tmp1331_;
			ValaDataType* _tmp1332_;
			_tmp1329_ = vala_member_access_get_inner (self);
			_tmp1330_ = _tmp1329_;
			_tmp1331_ = vala_expression_get_value_type (_tmp1330_);
			_tmp1332_ = _tmp1331_;
			_tmp1308_ = !VALA_IS_ARRAY_TYPE (_tmp1332_);
		} else {
			_tmp1308_ = FALSE;
		}
		if (_tmp1308_) {
			ValaSourceReference* _tmp1333_;
			ValaSourceReference* _tmp1334_;
			ValaSymbol* _tmp1335_;
			ValaSymbol* _tmp1336_;
			gchar* _tmp1337_;
			gchar* _tmp1338_;
			gchar* _tmp1339_;
			gchar* _tmp1340_;
			_tmp1333_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1334_ = _tmp1333_;
			_tmp1335_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1336_ = _tmp1335_;
			_tmp1337_ = vala_symbol_get_full_name (_tmp1336_);
			_tmp1338_ = _tmp1337_;
			_tmp1339_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1338_);
			_tmp1340_ = _tmp1339_;
			vala_report_error (_tmp1334_, _tmp1340_);
			_g_free0 (_tmp1340_);
			_g_free0 (_tmp1338_);
		}
		_tmp1341_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1342_ = _tmp1341_;
		m = VALA_IS_METHOD (_tmp1342_) ? ((ValaMethod*) _tmp1342_) : NULL;
		_tmp1343_ = vala_member_access_get_inner (self);
		_tmp1344_ = _tmp1343_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1344_) ? ((ValaMemberAccess*) _tmp1344_) : NULL;
		_tmp1350_ = m;
		if (_tmp1350_ != NULL) {
			ValaMethod* _tmp1351_;
			ValaMemberBinding _tmp1352_;
			ValaMemberBinding _tmp1353_;
			_tmp1351_ = m;
			_tmp1352_ = vala_method_get_binding (_tmp1351_);
			_tmp1353_ = _tmp1352_;
			_tmp1349_ = _tmp1353_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1349_ = FALSE;
		}
		if (_tmp1349_) {
			ValaMethod* _tmp1354_;
			ValaSymbol* _tmp1355_;
			ValaSymbol* _tmp1356_;
			_tmp1354_ = m;
			_tmp1355_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1354_);
			_tmp1356_ = _tmp1355_;
			_tmp1348_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1356_);
		} else {
			_tmp1348_ = FALSE;
		}
		if (_tmp1348_) {
			ValaExpression* _tmp1357_;
			ValaExpression* _tmp1358_;
			_tmp1357_ = vala_member_access_get_inner (self);
			_tmp1358_ = _tmp1357_;
			_tmp1347_ = _tmp1358_ != NULL;
		} else {
			_tmp1347_ = FALSE;
		}
		if (_tmp1347_) {
			ValaExpression* _tmp1359_;
			ValaExpression* _tmp1360_;
			ValaDataType* _tmp1361_;
			ValaDataType* _tmp1362_;
			_tmp1359_ = vala_member_access_get_inner (self);
			_tmp1360_ = _tmp1359_;
			_tmp1361_ = vala_expression_get_value_type (_tmp1360_);
			_tmp1362_ = _tmp1361_;
			_tmp1346_ = _tmp1362_ == NULL;
		} else {
			_tmp1346_ = FALSE;
		}
		if (_tmp1346_) {
			ValaMemberAccess* _tmp1363_;
			ValaList* _tmp1364_;
			gint _tmp1365_;
			gint _tmp1366_;
			_tmp1363_ = inner_ma;
			_tmp1364_ = _tmp1363_->priv->type_argument_list;
			_tmp1365_ = vala_collection_get_size ((ValaCollection*) _tmp1364_);
			_tmp1366_ = _tmp1365_;
			_tmp1345_ = _tmp1366_ > 0;
		} else {
			_tmp1345_ = FALSE;
		}
		if (_tmp1345_) {
			ValaExpression* _tmp1367_;
			ValaExpression* _tmp1368_;
			ValaMethod* _tmp1369_;
			ValaSymbol* _tmp1370_;
			ValaSymbol* _tmp1371_;
			ValaObjectType* _tmp1372_;
			ValaObjectType* _tmp1373_;
			_tmp1367_ = vala_member_access_get_inner (self);
			_tmp1368_ = _tmp1367_;
			_tmp1369_ = m;
			_tmp1370_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1369_);
			_tmp1371_ = _tmp1370_;
			_tmp1372_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1371_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1373_ = _tmp1372_;
			vala_expression_set_value_type (_tmp1368_, (ValaDataType*) _tmp1373_);
			_vala_code_node_unref0 (_tmp1373_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1374_;
				ValaList* _tmp1375_;
				ValaList* _tmp1376_;
				gint _type_argument_size = 0;
				ValaList* _tmp1377_;
				gint _tmp1378_;
				gint _tmp1379_;
				gint _type_argument_index = 0;
				_tmp1374_ = inner_ma;
				_tmp1375_ = _tmp1374_->priv->type_argument_list;
				_tmp1376_ = _vala_iterable_ref0 (_tmp1375_);
				_type_argument_list = _tmp1376_;
				_tmp1377_ = _type_argument_list;
				_tmp1378_ = vala_collection_get_size ((ValaCollection*) _tmp1377_);
				_tmp1379_ = _tmp1378_;
				_type_argument_size = _tmp1379_;
				_type_argument_index = -1;
				while (TRUE) {
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1380_;
					gpointer _tmp1381_;
					ValaExpression* _tmp1382_;
					ValaExpression* _tmp1383_;
					ValaDataType* _tmp1384_;
					ValaDataType* _tmp1385_;
					ValaDataType* _tmp1386_;
					_type_argument_index = _type_argument_index + 1;
					if (!(_type_argument_index < _type_argument_size)) {
						break;
					}
					_tmp1380_ = _type_argument_list;
					_tmp1381_ = vala_list_get (_tmp1380_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1381_;
					_tmp1382_ = vala_member_access_get_inner (self);
					_tmp1383_ = _tmp1382_;
					_tmp1384_ = vala_expression_get_value_type (_tmp1383_);
					_tmp1385_ = _tmp1384_;
					_tmp1386_ = type_argument;
					vala_data_type_add_type_argument (_tmp1385_, _tmp1386_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1387_ = vala_code_context_get_analyzer (context);
		_tmp1388_ = _tmp1387_;
		_tmp1389_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1390_ = _tmp1389_;
		_tmp1391_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1392_ = _tmp1391_;
		_tmp1393_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1388_, _tmp1390_, _tmp1392_);
		_tmp1394_ = _tmp1393_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1394_);
		_vala_code_node_unref0 (_tmp1394_);
		_tmp1396_ = vala_member_access_get_inner (self);
		_tmp1397_ = _tmp1396_;
		if (_tmp1397_ != NULL) {
			ValaDataType* _tmp1398_;
			ValaDataType* _tmp1399_;
			_tmp1398_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1399_ = _tmp1398_;
			_tmp1395_ = _tmp1399_ != NULL;
		} else {
			_tmp1395_ = FALSE;
		}
		if (_tmp1395_) {
			ValaDataType* _tmp1400_;
			ValaDataType* _tmp1401_;
			ValaExpression* _tmp1402_;
			ValaExpression* _tmp1403_;
			ValaDataType* _tmp1404_;
			ValaDataType* _tmp1405_;
			ValaDataType* _tmp1406_;
			ValaDataType* _tmp1407_;
			_tmp1400_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1401_ = _tmp1400_;
			_tmp1402_ = vala_member_access_get_inner (self);
			_tmp1403_ = _tmp1402_;
			_tmp1404_ = vala_expression_get_value_type (_tmp1403_);
			_tmp1405_ = _tmp1404_;
			_tmp1406_ = vala_data_type_get_actual_type (_tmp1401_, _tmp1405_, NULL, (ValaCodeNode*) self);
			_tmp1407_ = _tmp1406_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1407_);
			_vala_code_node_unref0 (_tmp1407_);
		} else {
			ValaDataType* _tmp1408_;
			ValaDataType* _tmp1409_;
			_tmp1408_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1409_ = _tmp1408_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1409_);
		}
		_tmp1410_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1411_ = _tmp1410_;
		if (VALA_IS_METHOD (_tmp1411_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1412_;
			ValaSymbol* _tmp1413_;
			ValaDataType* _tmp1414_;
			ValaDataType* _tmp1415_;
			gboolean _tmp1422_ = FALSE;
			_tmp1412_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1413_ = _tmp1412_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1413_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1414_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1415_ = _tmp1414_;
			if (_tmp1415_ != NULL) {
				ValaDataType* _tmp1416_;
				ValaDataType* _tmp1417_;
				ValaDataType* _tmp1418_;
				ValaDataType* _tmp1419_;
				gboolean _tmp1420_;
				gboolean _tmp1421_;
				_tmp1416_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1417_ = _tmp1416_;
				_tmp1418_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1419_ = _tmp1418_;
				_tmp1420_ = vala_data_type_get_value_owned (_tmp1419_);
				_tmp1421_ = _tmp1420_;
				vala_data_type_set_value_owned (_tmp1417_, _tmp1421_);
			}
			if (instance) {
				ValaMethod* _tmp1423_;
				ValaSymbol* _tmp1424_;
				ValaSymbol* _tmp1425_;
				_tmp1423_ = method;
				_tmp1424_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1423_);
				_tmp1425_ = _tmp1424_;
				_tmp1422_ = VALA_IS_TYPESYMBOL (_tmp1425_);
			} else {
				_tmp1422_ = FALSE;
			}
			if (_tmp1422_) {
				ValaExpression* _tmp1426_;
				ValaExpression* _tmp1427_;
				ValaMethod* _tmp1428_;
				ValaSymbol* _tmp1429_;
				ValaSymbol* _tmp1430_;
				ValaDataType* _tmp1431_;
				ValaDataType* _tmp1432_;
				ValaExpression* _tmp1433_;
				ValaExpression* _tmp1434_;
				ValaDataType* _tmp1435_;
				ValaDataType* _tmp1436_;
				ValaMethod* _tmp1437_;
				ValaParameter* _tmp1438_;
				ValaParameter* _tmp1439_;
				ValaDataType* _tmp1440_;
				ValaDataType* _tmp1441_;
				gboolean _tmp1442_;
				gboolean _tmp1443_;
				_tmp1426_ = vala_member_access_get_inner (self);
				_tmp1427_ = _tmp1426_;
				_tmp1428_ = method;
				_tmp1429_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1428_);
				_tmp1430_ = _tmp1429_;
				_tmp1431_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1430_);
				_tmp1432_ = _tmp1431_;
				vala_expression_set_target_type (_tmp1427_, _tmp1432_);
				_vala_code_node_unref0 (_tmp1432_);
				_tmp1433_ = vala_member_access_get_inner (self);
				_tmp1434_ = _tmp1433_;
				_tmp1435_ = vala_expression_get_target_type (_tmp1434_);
				_tmp1436_ = _tmp1435_;
				_tmp1437_ = method;
				_tmp1438_ = vala_method_get_this_parameter (_tmp1437_);
				_tmp1439_ = _tmp1438_;
				_tmp1440_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1439_);
				_tmp1441_ = _tmp1440_;
				_tmp1442_ = vala_data_type_get_value_owned (_tmp1441_);
				_tmp1443_ = _tmp1442_;
				vala_data_type_set_value_owned (_tmp1436_, _tmp1443_);
			}
		} else {
			gboolean _tmp1444_ = FALSE;
			gboolean _tmp1445_ = FALSE;
			ValaSymbol* _tmp1446_;
			ValaSymbol* _tmp1447_;
			_tmp1446_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1447_ = _tmp1446_;
			if (VALA_IS_PROPERTY (_tmp1447_)) {
				_tmp1445_ = instance;
			} else {
				_tmp1445_ = FALSE;
			}
			if (_tmp1445_) {
				ValaSymbol* _tmp1448_;
				ValaSymbol* _tmp1449_;
				ValaSymbol* _tmp1450_;
				ValaSymbol* _tmp1451_;
				_tmp1448_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1449_ = _tmp1448_;
				_tmp1450_ = vala_symbol_get_parent_symbol (_tmp1449_);
				_tmp1451_ = _tmp1450_;
				_tmp1444_ = _tmp1451_ != NULL;
			} else {
				_tmp1444_ = FALSE;
			}
			if (_tmp1444_) {
				ValaExpression* _tmp1452_;
				ValaExpression* _tmp1453_;
				ValaSymbol* _tmp1454_;
				ValaSymbol* _tmp1455_;
				ValaSymbol* _tmp1456_;
				ValaSymbol* _tmp1457_;
				ValaDataType* _tmp1458_;
				ValaDataType* _tmp1459_;
				_tmp1452_ = vala_member_access_get_inner (self);
				_tmp1453_ = _tmp1452_;
				_tmp1454_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1455_ = _tmp1454_;
				_tmp1456_ = vala_symbol_get_parent_symbol (_tmp1455_);
				_tmp1457_ = _tmp1456_;
				_tmp1458_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1457_);
				_tmp1459_ = _tmp1458_;
				vala_expression_set_target_type (_tmp1453_, _tmp1459_);
				_vala_code_node_unref0 (_tmp1459_);
			} else {
				gboolean _tmp1460_ = FALSE;
				gboolean _tmp1461_ = FALSE;
				gboolean _tmp1462_ = FALSE;
				ValaSymbol* _tmp1463_;
				ValaSymbol* _tmp1464_;
				_tmp1463_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1464_ = _tmp1463_;
				if (VALA_IS_FIELD (_tmp1464_)) {
					_tmp1462_ = TRUE;
				} else {
					ValaSymbol* _tmp1465_;
					ValaSymbol* _tmp1466_;
					_tmp1465_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1466_ = _tmp1465_;
					_tmp1462_ = VALA_IS_SIGNAL (_tmp1466_);
				}
				if (_tmp1462_) {
					_tmp1461_ = instance;
				} else {
					_tmp1461_ = FALSE;
				}
				if (_tmp1461_) {
					ValaSymbol* _tmp1467_;
					ValaSymbol* _tmp1468_;
					ValaSymbol* _tmp1469_;
					ValaSymbol* _tmp1470_;
					_tmp1467_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1468_ = _tmp1467_;
					_tmp1469_ = vala_symbol_get_parent_symbol (_tmp1468_);
					_tmp1470_ = _tmp1469_;
					_tmp1460_ = _tmp1470_ != NULL;
				} else {
					_tmp1460_ = FALSE;
				}
				if (_tmp1460_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1471_;
					ValaSymbol* _tmp1472_;
					ValaSymbol* _tmp1473_;
					ValaSymbol* _tmp1474_;
					ValaDataType* _tmp1475_;
					ValaExpression* _tmp1476_;
					ValaExpression* _tmp1477_;
					ValaDataType* _tmp1478_;
					ValaExpression* _tmp1479_;
					ValaExpression* _tmp1480_;
					ValaDataType* _tmp1481_;
					ValaDataType* _tmp1482_;
					ValaDataType* _tmp1483_;
					ValaDataType* _tmp1484_;
					_tmp1471_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1472_ = _tmp1471_;
					_tmp1473_ = vala_symbol_get_parent_symbol (_tmp1472_);
					_tmp1474_ = _tmp1473_;
					_tmp1475_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1474_);
					parent_type = _tmp1475_;
					_tmp1476_ = vala_member_access_get_inner (self);
					_tmp1477_ = _tmp1476_;
					_tmp1478_ = parent_type;
					_tmp1479_ = vala_member_access_get_inner (self);
					_tmp1480_ = _tmp1479_;
					_tmp1481_ = vala_expression_get_value_type (_tmp1480_);
					_tmp1482_ = _tmp1481_;
					_tmp1483_ = vala_data_type_get_actual_type (_tmp1478_, _tmp1482_, NULL, (ValaCodeNode*) self);
					_tmp1484_ = _tmp1483_;
					vala_expression_set_target_type (_tmp1477_, _tmp1484_);
					_vala_code_node_unref0 (_tmp1484_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1485_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1486_ = _tmp1485_;
	if (_tmp1486_ != NULL) {
		ValaDataType* _tmp1487_;
		ValaDataType* _tmp1488_;
		_tmp1487_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1488_ = _tmp1487_;
		vala_code_node_check ((ValaCodeNode*) _tmp1488_, context);
	}
	_tmp1489_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1490_ = _tmp1489_;
	result = !_tmp1490_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

