/* valaccodevariabledeclarator.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeVariableDeclaratorPrivate {
	char* _name;
	ValaCCodeExpression* _initializer;
};

#define VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_VARIABLE_DECLARATOR, ValaCCodeVariableDeclaratorPrivate))
enum  {
	VALA_CCODE_VARIABLE_DECLARATOR_DUMMY_PROPERTY
};
static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_variable_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_variable_declarator_real_write_initialization (ValaCCodeDeclarator* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_variable_declarator_parent_class = NULL;
static void vala_ccode_variable_declarator_finalize (ValaCCodeNode* obj);



ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_construct (GType object_type, const char* name) {
	ValaCCodeVariableDeclarator* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = ((ValaCCodeVariableDeclarator*) (g_type_create_instance (object_type)));
	vala_ccode_variable_declarator_set_name (self, name);
	return self;
}


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new (const char* name) {
	return vala_ccode_variable_declarator_construct (VALA_TYPE_CCODE_VARIABLE_DECLARATOR, name);
}


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_construct_with_initializer (GType object_type, const char* name, ValaCCodeExpression* initializer) {
	ValaCCodeVariableDeclarator* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = ((ValaCCodeVariableDeclarator*) (g_type_create_instance (object_type)));
	vala_ccode_variable_declarator_set_name (self, name);
	vala_ccode_variable_declarator_set_initializer (self, initializer);
	return self;
}


ValaCCodeVariableDeclarator* vala_ccode_variable_declarator_new_with_initializer (const char* name, ValaCCodeExpression* initializer) {
	return vala_ccode_variable_declarator_construct_with_initializer (VALA_TYPE_CCODE_VARIABLE_DECLARATOR, name, initializer);
}


static void vala_ccode_variable_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	self = ((ValaCCodeVariableDeclarator*) (base));
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
	if (self->priv->_initializer != NULL) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write (((ValaCCodeNode*) (self->priv->_initializer)), writer);
	}
}


static void vala_ccode_variable_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	self = ((ValaCCodeVariableDeclarator*) (base));
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, self->priv->_name);
	/* initializer lists can't be moved to a separate statement*/
	if (VALA_IS_CCODE_INITIALIZER_LIST (self->priv->_initializer)) {
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write (((ValaCCodeNode*) (self->priv->_initializer)), writer);
	}
}


static void vala_ccode_variable_declarator_real_write_initialization (ValaCCodeDeclarator* base, ValaCCodeWriter* writer) {
	ValaCCodeVariableDeclarator * self;
	self = ((ValaCCodeVariableDeclarator*) (base));
	g_return_if_fail (writer != NULL);
	if (self->priv->_initializer != NULL && !(VALA_IS_CCODE_INITIALIZER_LIST (self->priv->_initializer))) {
		vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (((ValaCCodeNode*) (self))));
		vala_ccode_writer_write_string (writer, self->priv->_name);
		vala_ccode_writer_write_string (writer, " = ");
		vala_ccode_node_write (((ValaCCodeNode*) (self->priv->_initializer)), writer);
		vala_ccode_writer_write_string (writer, ";");
		vala_ccode_writer_write_newline (writer);
	}
}


const char* vala_ccode_variable_declarator_get_name (ValaCCodeVariableDeclarator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_variable_declarator_set_name (ValaCCodeVariableDeclarator* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_name = (g_free (self->priv->_name), NULL)), _tmp2);
}


ValaCCodeExpression* vala_ccode_variable_declarator_get_initializer (ValaCCodeVariableDeclarator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_initializer;
}


void vala_ccode_variable_declarator_set_initializer (ValaCCodeVariableDeclarator* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (vala_ccode_node_unref (self->priv->_initializer), NULL))), _tmp2);
}


static void vala_ccode_variable_declarator_class_init (ValaCCodeVariableDeclaratorClass * klass) {
	vala_ccode_variable_declarator_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_variable_declarator_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeVariableDeclaratorPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_variable_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_variable_declarator_real_write_declaration;
	VALA_CCODE_DECLARATOR_CLASS (klass)->write_initialization = vala_ccode_variable_declarator_real_write_initialization;
}


static void vala_ccode_variable_declarator_instance_init (ValaCCodeVariableDeclarator * self) {
	self->priv = VALA_CCODE_VARIABLE_DECLARATOR_GET_PRIVATE (self);
}


static void vala_ccode_variable_declarator_finalize (ValaCCodeNode* obj) {
	ValaCCodeVariableDeclarator * self;
	self = VALA_CCODE_VARIABLE_DECLARATOR (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->_initializer == NULL ? NULL : (self->priv->_initializer = (vala_ccode_node_unref (self->priv->_initializer), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_variable_declarator_parent_class)->finalize (obj);
}


GType vala_ccode_variable_declarator_get_type (void) {
	static GType vala_ccode_variable_declarator_type_id = 0;
	if (vala_ccode_variable_declarator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeVariableDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_variable_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeVariableDeclarator), 0, (GInstanceInitFunc) vala_ccode_variable_declarator_instance_init, NULL };
		vala_ccode_variable_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeVariableDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_variable_declarator_type_id;
}




