/* valaccodeassignmentmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeassignmentmodule.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaexpressionstatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valasignal.h>
#include <vala/valamethod.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadynamicsignal.h>
#include <vala/valamember.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaelementaccess.h>
#include <gee/list.h>
#include <vala/valastringliteral.h>
#include <vala/valasymbol.h>
#include <vala/valalocalvariable.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valalambdaexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valascope.h>
#include <vala/valaformalparameter.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaarraytype.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeelementaccess.h>
#include <vala/valacodevisitor.h>
#include <vala/valapointertype.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_ASSIGNMENT_MODULE_DUMMY_PROPERTY
};
static ValaCCodeExpression* vala_ccode_assignment_module_emit_property_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_ccode_assignment_module_emit_signal_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_ccode_assignment_module_emit_non_array_element_access (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_ccode_assignment_module_emit_simple_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static void vala_ccode_assignment_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
static gpointer vala_ccode_assignment_module_parent_class = NULL;



ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeAssignmentModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeAssignmentModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeAssignmentModule*) (vala_ccode_member_access_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_assignment_module_construct (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, codegen, next);
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_property_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (assignment), (VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop)) && VALA_IS_CLASS (((ValaCCodeBaseModule*) (self))->current_type_symbol) && vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), ((ValaCCodeBaseModule*) (self))->gobject_type) && ((ValaCCodeBaseModule*) (self))->in_creation_method) {
		ValaCCodeConstant* _tmp3;
		ValaCCodeExpression* _tmp4;
		ValaCCodeExpression* _tmp5;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = vala_ccode_module_get_construct_property_assignment (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), (_tmp3 = vala_property_get_canonical_cconstant (prop)), vala_property_get_property_type (prop), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_assignment_get_right (assignment)))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL))), _tmp4), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), _tmp5);
	} else {
		ValaCCodeExpression* _tmp6;
		ValaCCodeExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		_tmp6 = NULL;
		cexpr = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_assignment_get_right (assignment))))), (_tmp6 == NULL ? NULL : vala_ccode_node_ref (_tmp6)));
		if (!vala_property_get_no_accessor_method (prop)) {
			if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
				ValaCCodeExpression* _tmp7;
				_tmp7 = NULL;
				cexpr = (_tmp7 = vala_ccode_base_module_get_address_of_expression (((ValaCCodeBaseModule*) (self)), vala_assignment_get_right (assignment), cexpr), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp7);
			}
		}
		if (vala_assignment_get_operator (assignment) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			ValaCCodeBinaryOperator cop;
			ValaCCodeExpression* _tmp10;
			ValaCCodeParenthesizedExpression* _tmp9;
			ValaCCodeExpression* _tmp8;
			cop = 0;
			if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
						} else {
							if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
							} else {
								if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_BINARY_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_BINARY_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_BINARY_OPERATOR_MOD;
										} else {
											if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp10 = NULL;
			_tmp9 = NULL;
			_tmp8 = NULL;
			cexpr = (_tmp10 = ((ValaCCodeExpression*) (vala_ccode_binary_expression_new (cop, (_tmp8 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_assignment_get_left (assignment)))))), ((ValaCCodeExpression*) ((_tmp9 = vala_ccode_parenthesized_expression_new (cexpr))))))), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), _tmp10);
			(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
		}
		ccall = vala_ccode_base_module_get_property_set_call (((ValaCCodeBaseModule*) (self)), prop, ma, cexpr);
		/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
		if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (assignment)))))) {
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp11;
			ValaCCodeExpression* _tmp12;
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ccall)));
			/* update property*/
			_tmp11 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (_tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (ma))))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
			/* current property value*/
			_tmp12 = NULL;
			return (_tmp12 = ((ValaCCodeExpression*) (ccomma)), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), _tmp12);
		} else {
			ValaCCodeExpression* _tmp13;
			_tmp13 = NULL;
			return (_tmp13 = ((ValaCCodeExpression*) (ccall)), (cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), _tmp13);
		}
		(cexpr == NULL ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	}
	(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_signal_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaSignal* _tmp0;
	ValaSignal* sig;
	ValaMethod* _tmp1;
	ValaMethod* m;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall;
	char* signal_detail;
	ValaMemberAccess* ma;
	ValaCCodeCastExpression* _tmp42;
	ValaCCodeExpression* _tmp48;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp0 = NULL;
	sig = (_tmp0 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (assignment))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp2;
			_tmp2 = NULL;
			connect_func = (_tmp2 = vala_ccode_module_get_dynamic_signal_connect_wrapper_name (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), VALA_DYNAMIC_SIGNAL (sig)), (connect_func = (g_free (connect_func), NULL)), _tmp2);
		} else {
			char* _tmp3;
			_tmp3 = NULL;
			connect_func = (_tmp3 = g_strdup ("g_signal_connect_object"), (connect_func = (g_free (connect_func), NULL)), _tmp3);
			if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
				char* _tmp4;
				_tmp4 = NULL;
				connect_func = (_tmp4 = g_strdup ("g_signal_connect"), (connect_func = (g_free (connect_func), NULL)), _tmp4);
			}
		}
	} else {
		if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
				char* _tmp5;
				_tmp5 = NULL;
				connect_func = (_tmp5 = vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), VALA_DYNAMIC_SIGNAL (sig)), (connect_func = (g_free (connect_func), NULL)), _tmp5);
			} else {
				char* _tmp6;
				_tmp6 = NULL;
				connect_func = (_tmp6 = g_strdup ("g_signal_handlers_disconnect_matched"), (connect_func = (g_free (connect_func), NULL)), _tmp6);
			}
			disconnect = TRUE;
		} else {
			ValaCCodeExpression* _tmp7;
			vala_code_node_set_error (((ValaCodeNode*) (assignment)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (assignment))), "Specified compound assignment type for signals not supported.");
			_tmp7 = NULL;
			return (_tmp7 = NULL, (sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (connect_func = (g_free (connect_func), NULL)), _tmp7);
		}
	}
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall = (_tmp9 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp8 = vala_ccode_identifier_new (connect_func))))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp9);
	signal_detail = NULL;
	/* first argument: instance of sender*/
	ma = NULL;
	if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (assignment))) {
		ValaElementAccess* _tmp10;
		ValaElementAccess* ea;
		ValaMemberAccess* _tmp12;
		ValaMemberAccess* _tmp11;
		GeeList* _tmp13;
		ValaExpression* _tmp14;
		ValaStringLiteral* _tmp15;
		ValaStringLiteral* detail_expr;
		char* _tmp17;
		_tmp10 = NULL;
		ea = (_tmp10 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment)), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
		_tmp12 = NULL;
		_tmp11 = NULL;
		ma = (_tmp12 = (_tmp11 = VALA_MEMBER_ACCESS (vala_element_access_get_container (ea)), (_tmp11 == NULL ? NULL : vala_code_node_ref (_tmp11))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp12);
		_tmp13 = NULL;
		_tmp14 = NULL;
		_tmp15 = NULL;
		detail_expr = (_tmp15 = (_tmp14 = ((ValaExpression*) (gee_list_get ((_tmp13 = vala_element_access_get_indices (ea)), 0))), (VALA_IS_STRING_LITERAL (_tmp14) ? ((ValaStringLiteral*) (_tmp14)) : NULL)), (_tmp13 == NULL ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL))), _tmp15);
		if (detail_expr == NULL) {
			ValaCCodeExpression* _tmp16;
			vala_code_node_set_error (((ValaCodeNode*) (assignment)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (detail_expr))), "internal error: only literal string details supported");
			_tmp16 = NULL;
			return (_tmp16 = NULL, (ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL))), (detail_expr == NULL ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL))), (sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (connect_func = (g_free (connect_func), NULL)), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (signal_detail = (g_free (signal_detail), NULL)), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp16);
		}
		_tmp17 = NULL;
		signal_detail = (_tmp17 = vala_string_literal_eval (detail_expr), (signal_detail = (g_free (signal_detail), NULL)), _tmp17);
		(ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL)));
		(detail_expr == NULL ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL)));
	} else {
		ValaMemberAccess* _tmp19;
		ValaMemberAccess* _tmp18;
		_tmp19 = NULL;
		_tmp18 = NULL;
		ma = (_tmp19 = (_tmp18 = VALA_MEMBER_ACCESS (vala_assignment_get_left (assignment)), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp19);
	}
	if (vala_member_access_get_inner (ma) != NULL) {
		ValaCCodeExpression* _tmp20;
		_tmp20 = NULL;
		vala_ccode_function_call_add_argument (ccall, (_tmp20 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_member_access_get_inner (ma)))))));
		(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp21;
		_tmp21 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ("self")))));
		(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp23;
		char* _tmp22;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp23 = NULL;
		_tmp22 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp23 = vala_ccode_constant_new ((_tmp22 = g_strdup_printf ("\"%s\"", vala_symbol_get_name (((ValaSymbol*) (sig))))))))));
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		_tmp22 = (g_free (_tmp22), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp24;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp24 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp24 = vala_signal_get_canonical_cconstant (sig, signal_detail)))));
			(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
		} else {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp27;
			ValaCCodeFunctionCall* _tmp28;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp29;
			ValaTypeSymbol* _tmp30;
			ValaTypeSymbol* decl_type;
			ValaCCodeIdentifier* _tmp32;
			char* _tmp31;
			ValaCCodeUnaryExpression* _tmp34;
			ValaCCodeIdentifier* _tmp33;
			ValaCCodeConstant* _tmp38;
			ValaCCodeIdentifier* _tmp39;
			ValaCCodeConstant* _tmp40;
			ValaCCodeConstant* _tmp41;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp25;
				_tmp25 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp25 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
			} else {
				ValaCCodeConstant* _tmp26;
				_tmp26 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp26 = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")))));
				(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
			}
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->uint_type, TRUE, NULL);
			gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_decl);
			_tmp27 = NULL;
			_tmp28 = NULL;
			parse_call = (_tmp28 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp27 = vala_ccode_identifier_new ("g_signal_parse_name"))))), (_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL))), _tmp28);
			_tmp29 = NULL;
			vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp29 = vala_signal_get_canonical_cconstant (sig, signal_detail)))));
			(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
			_tmp30 = NULL;
			decl_type = (_tmp30 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (sig)))), (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30)));
			_tmp32 = NULL;
			_tmp31 = NULL;
			vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = vala_typesymbol_get_type_id (decl_type)))))));
			(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
			_tmp31 = (g_free (_tmp31), NULL);
			_tmp34 = NULL;
			_tmp33 = NULL;
			vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp34 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp33 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))))))));
			(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
			(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp35;
				_tmp35 = NULL;
				vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp35 = vala_ccode_constant_new ("NULL")))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
			} else {
				ValaLocalVariable* detail_temp_decl;
				ValaCCodeUnaryExpression* _tmp37;
				ValaCCodeIdentifier* _tmp36;
				detail_temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->gquark_type, TRUE, NULL);
				gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, detail_temp_decl);
				_tmp37 = NULL;
				_tmp36 = NULL;
				vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp37 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) ((_tmp36 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (detail_temp_decl))))))))))));
				(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
				(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
				(detail_temp_decl == NULL ? NULL : (detail_temp_decl = (vala_code_node_unref (detail_temp_decl), NULL)));
			}
			_tmp38 = NULL;
			vala_ccode_function_call_add_argument (parse_call, ((ValaCCodeExpression*) ((_tmp38 = vala_ccode_constant_new ("FALSE")))));
			(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (parse_call)));
			_tmp39 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp39 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))));
			(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (ccomma)));
			/* fourth argument: detail*/
			_tmp40 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp40 = vala_ccode_constant_new ("0")))));
			(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
			/* fifth argument: closure*/
			_tmp41 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp41 = vala_ccode_constant_new ("NULL")))));
			(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
			(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
			(parse_call == NULL ? NULL : (parse_call = (vala_ccode_node_unref (parse_call), NULL)));
			(decl_type == NULL ? NULL : (decl_type = (vala_code_node_unref (decl_type), NULL)));
		}
	}
	/* third resp. sixth argument: handler*/
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp42 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_assignment_get_right (assignment))))), "GCallback")))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (assignment))) {
			ValaMemberAccess* _tmp43;
			ValaMemberAccess* right_ma;
			_tmp43 = NULL;
			right_ma = (_tmp43 = VALA_MEMBER_ACCESS (vala_assignment_get_right (assignment)), (_tmp43 == NULL ? NULL : vala_code_node_ref (_tmp43)));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (right_ma))))));
			} else {
				ValaCCodeIdentifier* _tmp44;
				_tmp44 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp44 = vala_ccode_identifier_new ("self")))));
				(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
			}
			(right_ma == NULL ? NULL : (right_ma = (vala_code_node_unref (right_ma), NULL)));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (assignment))) {
				ValaCCodeIdentifier* _tmp45;
				_tmp45 = NULL;
				vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp45 = vala_ccode_identifier_new ("self")))));
				(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
			}
		}
		if (!disconnect && !(VALA_IS_DYNAMIC_SIGNAL (sig))) {
			ValaCCodeConstant* _tmp46;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp46 = NULL;
			vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp46 = vala_ccode_constant_new ("0")))));
			(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
		}
	} else {
		ValaCCodeConstant* _tmp47;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp47 = NULL;
		vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp47 = vala_ccode_constant_new ("NULL")))));
		(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
	}
	_tmp48 = NULL;
	return (_tmp48 = ((ValaCCodeExpression*) (ccall)), (sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL))), (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (connect_func = (g_free (connect_func), NULL)), (signal_detail = (g_free (signal_detail), NULL)), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), _tmp48);
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_non_array_element_access (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaElementAccess* _tmp1;
	ValaElementAccess* expr;
	ValaTypeSymbol* _tmp2;
	ValaTypeSymbol* container_type;
	GeeList* indices;
	GeeIterator* indices_it;
	ValaCCodeExpression* ccontainer;
	ValaExpression* _tmp3;
	ValaCCodeExpression* _tmp4;
	ValaCCodeExpression* cindex;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	/* custom element access*/
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_assignment_get_right (assignment))))), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	_tmp1 = NULL;
	expr = (_tmp1 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	container_type = (_tmp2 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	indices = vala_element_access_get_indices (expr);
	indices_it = gee_iterable_iterator (((GeeIterable*) (indices)));
	gee_iterator_next (indices_it);
	ccontainer = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_element_access_get_container (expr)))));
	_tmp3 = NULL;
	_tmp4 = NULL;
	cindex = (_tmp4 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) ((_tmp3 = ((ValaExpression*) (gee_iterator_get (indices_it)))))))), (_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL))), _tmp4);
	if (container_type != NULL && ((ValaCCodeBaseModule*) (self))->list_type != NULL && ((ValaCCodeBaseModule*) (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type))) || vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type))))) {
		ValaTypeSymbol* collection_iface;
		ValaMethod* set_method;
		GeeList* set_params;
		GeeIterator* set_params_it;
		ValaFormalParameter* set_param;
		ValaCCodeIdentifier* _tmp11;
		char* _tmp10;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* set_ccall;
		ValaCCodeCastExpression* _tmp15;
		char* _tmp14;
		char* _tmp13;
		ValaCCodeExpression* _tmp16;
		ValaCCodeExpression* _tmp17;
		/* lookup symbol in interface instead of class as implemented interface methods are not in VAPI files*/
		collection_iface = NULL;
		if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type)))) {
			ValaTypeSymbol* _tmp6;
			ValaTypeSymbol* _tmp5;
			_tmp6 = NULL;
			_tmp5 = NULL;
			collection_iface = (_tmp6 = (_tmp5 = ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->list_type)), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5))), (collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL))), _tmp6);
		} else {
			if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type)))) {
				ValaTypeSymbol* _tmp8;
				ValaTypeSymbol* _tmp7;
				_tmp8 = NULL;
				_tmp7 = NULL;
				collection_iface = (_tmp8 = (_tmp7 = ((ValaTypeSymbol*) (((ValaCCodeBaseModule*) (self))->map_type)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7))), (collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL))), _tmp8);
			}
		}
		set_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (collection_iface))), "set"));
		set_params = vala_method_get_parameters (set_method);
		set_params_it = gee_iterable_iterator (((GeeIterable*) (set_params)));
		gee_iterator_next (set_params_it);
		set_param = ((ValaFormalParameter*) (gee_iterator_get (set_params_it)));
		if (vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (set_param)) != NULL) {
			ValaDataType* index_type;
			ValaCCodeExpression* _tmp9;
			index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), ((ValaSymbol*) (set_method)), vala_formal_parameter_get_parameter_type (set_param), ((ValaCodeNode*) (assignment)));
			_tmp9 = NULL;
			cindex = (_tmp9 = vala_ccode_base_module_convert_to_generic_pointer (((ValaCCodeBaseModule*) (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL))), _tmp9);
			(index_type == NULL ? NULL : (index_type = (vala_code_node_unref (index_type), NULL)));
		}
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp12 = NULL;
		set_ccall = (_tmp12 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = vala_method_get_cname (set_method))))))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
		_tmp15 = NULL;
		_tmp14 = NULL;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, ((ValaCCodeExpression*) ((_tmp15 = vala_ccode_cast_expression_new (ccontainer, (_tmp14 = g_strconcat ((_tmp13 = vala_typesymbol_get_cname (collection_iface, FALSE)), "*", NULL)))))));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		_tmp14 = (g_free (_tmp14), NULL);
		_tmp13 = (g_free (_tmp13), NULL);
		vala_ccode_function_call_add_argument (set_ccall, cindex);
		_tmp16 = NULL;
		vala_ccode_function_call_add_argument (set_ccall, (_tmp16 = vala_ccode_base_module_convert_to_generic_pointer (((ValaCCodeBaseModule*) (self)), rhs, vala_expression_get_value_type (((ValaExpression*) (expr))))));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		_tmp17 = NULL;
		return (_tmp17 = ((ValaCCodeExpression*) (set_ccall)), (collection_iface == NULL ? NULL : (collection_iface = (vala_code_node_unref (collection_iface), NULL))), (set_method == NULL ? NULL : (set_method = (vala_code_node_unref (set_method), NULL))), (set_params == NULL ? NULL : (set_params = (gee_collection_object_unref (set_params), NULL))), (set_params_it == NULL ? NULL : (set_params_it = (gee_collection_object_unref (set_params_it), NULL))), (set_param == NULL ? NULL : (set_param = (vala_code_node_unref (set_param), NULL))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), (expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL))), (container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL))), (indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL))), (indices_it == NULL ? NULL : (indices_it = (gee_collection_object_unref (indices_it), NULL))), (ccontainer == NULL ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL))), (cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL))), _tmp17);
	} else {
		ValaCCodeExpression* _tmp18;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (assignment))), "internal error: unsupported element access");
		vala_code_node_set_error (((ValaCodeNode*) (assignment)), TRUE);
		_tmp18 = NULL;
		return (_tmp18 = NULL, (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), (expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL))), (container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL))), (indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL))), (indices_it == NULL ? NULL : (indices_it = (gee_collection_object_unref (indices_it), NULL))), (ccontainer == NULL ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL))), (cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL))), _tmp18);
	}
	(rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)));
	(expr == NULL ? NULL : (expr = (vala_code_node_unref (expr), NULL)));
	(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
	(indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL)));
	(indices_it == NULL ? NULL : (indices_it = (gee_collection_object_unref (indices_it), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (vala_ccode_node_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (vala_ccode_node_unref (cindex), NULL)));
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_simple_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	gboolean unref_old;
	gboolean array;
	gboolean instance_delegate;
	ValaCCodeAssignmentOperator cop;
	ValaCCodeExpression* _tmp14;
	ValaCCodeExpression* _tmp15;
	ValaCCodeExpression* codenode;
	ValaCCodeNode* _tmp16;
	gboolean _tmp17;
	ValaCCodeExpression* _tmp23;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_assignment_get_right (assignment))))), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0)));
	unref_old = vala_ccode_base_module_requires_destroy (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_assignment_get_left (assignment)));
	array = FALSE;
	instance_delegate = FALSE;
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment)))) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		array = !(VALA_IS_CCODE_CONSTANT ((_tmp1 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_assignment_get_left (assignment), 1))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment)))) {
			ValaDelegateType* _tmp2;
			ValaDelegateType* delegate_type;
			_tmp2 = NULL;
			delegate_type = (_tmp2 = VALA_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
			instance_delegate = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type));
			(delegate_type == NULL ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL)));
		}
	}
	if (unref_old || array || instance_delegate) {
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp4;
		ValaCCodeIdentifier* _tmp3;
		ValaCCodeIdentifier* _tmp11;
		ValaCCodeExpression* _tmp13;
		ValaCCodeExpression* _tmp12;
		ccomma = vala_ccode_comma_expression_new ();
		temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_assignment_get_left (assignment)), TRUE, NULL);
		gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_decl);
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp4 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp3 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
		if (unref_old) {
			ValaCCodeExpression* _tmp6;
			ValaCCodeExpression* _tmp5;
			/* unref old value */
			_tmp6 = NULL;
			_tmp5 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (_tmp6 = vala_ccode_base_module_get_unref_expression (((ValaCCodeBaseModule*) (self)), (_tmp5 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_assignment_get_left (assignment)))))), vala_expression_get_value_type (vala_assignment_get_left (assignment)), vala_assignment_get_left (assignment))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
			(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		}
		if (array) {
			ValaArrayType* _tmp7;
			ValaArrayType* array_type;
			_tmp7 = NULL;
			array_type = (_tmp7 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment))), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp8;
					lhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_assignment_get_left (assignment), dim);
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_assignment_get_right (assignment), dim);
					_tmp8 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
					(lhs_array_len == NULL ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL)));
					(rhs_array_len == NULL ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL)));
				}
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		} else {
			if (instance_delegate) {
				ValaDelegateType* _tmp9;
				ValaDelegateType* delegate_type;
				ValaCCodeExpression* lhs_delegate_target;
				ValaCCodeExpression* rhs_delegate_target;
				ValaCCodeAssignment* _tmp10;
				_tmp9 = NULL;
				delegate_type = (_tmp9 = VALA_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment))), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
				lhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (((ValaCCodeBaseModule*) (self)), vala_assignment_get_left (assignment));
				rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression (((ValaCCodeBaseModule*) (self)), vala_assignment_get_right (assignment));
				_tmp10 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp10 = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
				(delegate_type == NULL ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL)));
				(lhs_delegate_target == NULL ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL)));
				(rhs_delegate_target == NULL ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL)));
			}
		}
		_tmp11 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp11 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_decl))))))));
		(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
		_tmp13 = NULL;
		_tmp12 = NULL;
		rhs = (_tmp13 = (_tmp12 = ((ValaCCodeExpression*) (ccomma)), (_tmp12 == NULL ? NULL : vala_ccode_node_ref (_tmp12))), (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp13);
		(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		(temp_decl == NULL ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL)));
	}
	cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
	if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} else {
		if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
		} else {
			if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			} else {
				if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
				} else {
					if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
					} else {
						if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
						} else {
							if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
							} else {
								if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
								} else {
									if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
									} else {
										if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp14 = NULL;
	_tmp15 = NULL;
	codenode = (_tmp15 = ((ValaCCodeExpression*) (vala_ccode_assignment_new ((_tmp14 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_assignment_get_left (assignment)))))), rhs, cop))), (_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL))), _tmp15);
	_tmp16 = NULL;
	if ((_tmp17 = unref_old && VALA_IS_CCODE_ELEMENT_ACCESS ((_tmp16 = vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_assignment_get_left (assignment)))))), (_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL))), _tmp17)) {
		ValaCCodeElementAccess* cea;
		/* ensure that index expression in element access doesn't get evaluated more than once
		 except when it's a simple expression*/
		cea = VALA_CCODE_ELEMENT_ACCESS (vala_ccode_base_module_get_ccodenode (((ValaCCodeBaseModule*) (self)), ((ValaCodeNode*) (vala_assignment_get_left (assignment)))));
		if (!(VALA_IS_CCODE_CONSTANT (vala_ccode_element_access_get_index (cea)) || VALA_IS_CCODE_IDENTIFIER (vala_ccode_element_access_get_index (cea)))) {
			ValaLocalVariable* index_temp_decl;
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeAssignment* _tmp19;
			ValaCCodeIdentifier* _tmp18;
			ValaCCodeIdentifier* _tmp20;
			ValaCCodeExpression* _tmp22;
			ValaCCodeExpression* _tmp21;
			index_temp_decl = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), ((ValaCCodeBaseModule*) (self))->int_type, TRUE, NULL);
			gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, index_temp_decl);
			ccomma = vala_ccode_comma_expression_new ();
			_tmp19 = NULL;
			_tmp18 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) ((_tmp19 = vala_ccode_assignment_new (((ValaCCodeExpression*) ((_tmp18 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (index_temp_decl))))))), vala_ccode_element_access_get_index (cea), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
			(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
			vala_ccode_comma_expression_append_expression (ccomma, codenode);
			_tmp20 = NULL;
			vala_ccode_element_access_set_index (cea, ((ValaCCodeExpression*) ((_tmp20 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (index_temp_decl))))))));
			(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
			_tmp22 = NULL;
			_tmp21 = NULL;
			codenode = (_tmp22 = (_tmp21 = ((ValaCCodeExpression*) (ccomma)), (_tmp21 == NULL ? NULL : vala_ccode_node_ref (_tmp21))), (codenode == NULL ? NULL : (codenode = (vala_ccode_node_unref (codenode), NULL))), _tmp22);
			(index_temp_decl == NULL ? NULL : (index_temp_decl = (vala_code_node_unref (index_temp_decl), NULL)));
			(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
		}
		(cea == NULL ? NULL : (cea = (vala_ccode_node_unref (cea), NULL)));
	}
	_tmp23 = NULL;
	return (_tmp23 = codenode, (rhs == NULL ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL))), _tmp23);
}


static void vala_ccode_assignment_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaCCodeAssignmentModule * self;
	self = ((ValaCCodeAssignmentModule*) (base));
	g_return_if_fail (assignment != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_assignment_get_right (assignment))), ((ValaCodeVisitor*) (vala_ccode_module_get_codegen (((ValaCCodeModule*) (self))))));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_assignment_get_left (assignment)))) || vala_code_node_get_error (((ValaCodeNode*) (vala_assignment_get_right (assignment))))) {
		vala_code_node_set_error (((ValaCodeNode*) (assignment)), TRUE);
		return;
	}
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)))) {
		ValaCCodeExpression* _tmp0;
		_tmp0 = NULL;
		vala_code_node_set_ccodenode (((ValaCodeNode*) (assignment)), ((ValaCCodeNode*) ((_tmp0 = vala_ccode_assignment_module_emit_property_assignment (self, assignment)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	} else {
		if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)))) {
			ValaCCodeExpression* _tmp1;
			_tmp1 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (assignment)), ((ValaCCodeNode*) ((_tmp1 = vala_ccode_assignment_module_emit_signal_assignment (self, assignment)))));
			(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (assignment)) && !(VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment))))))) && !(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_element_access_get_container ((VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment)))))))) {
				ValaCCodeExpression* _tmp2;
				_tmp2 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (assignment)), ((ValaCCodeNode*) ((_tmp2 = vala_ccode_assignment_module_emit_non_array_element_access (self, assignment)))));
				(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
			} else {
				ValaCCodeExpression* _tmp3;
				_tmp3 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (assignment)), ((ValaCCodeNode*) ((_tmp3 = vala_ccode_assignment_module_emit_simple_assignment (self, assignment)))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
			}
		}
	}
}


static void vala_ccode_assignment_module_class_init (ValaCCodeAssignmentModuleClass * klass) {
	vala_ccode_assignment_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_ccode_assignment_module_real_visit_assignment;
}


static void vala_ccode_assignment_module_instance_init (ValaCCodeAssignmentModule * self) {
}


GType vala_ccode_assignment_module_get_type (void) {
	static GType vala_ccode_assignment_module_type_id = 0;
	if (vala_ccode_assignment_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignmentModule), 0, (GInstanceInitFunc) vala_ccode_assignment_module_instance_init, NULL };
		vala_ccode_assignment_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, "ValaCCodeAssignmentModule", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_module_type_id;
}




