/* valaccodememberaccessmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessmodule.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valadynamicproperty.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <vala/valasignal.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_MEMBER_ACCESS_MODULE_DUMMY_PROPERTY
};
static void vala_ccode_member_access_module_process_cmember (ValaCCodeMemberAccessModule* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
static gpointer vala_ccode_member_access_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessModule* vala_ccode_member_access_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMemberAccessModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = ((ValaCCodeMemberAccessModule*) (g_type_create_instance (object_type)));
	self = ((ValaCCodeMemberAccessModule*) (vala_ccode_method_module_construct (object_type, codegen, next)));
	return self;
}


ValaCCodeMemberAccessModule* vala_ccode_member_access_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_member_access_module_construct (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, codegen, next);
}


static void vala_ccode_member_access_module_process_cmember (ValaCCodeMemberAccessModule* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
		ValaMethod* _tmp0;
		ValaMethod* m;
		_tmp0 = NULL;
		m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp1;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				char* _tmp2;
				ValaCCodeFunctionCall* _tmp5;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeMemberAccess* _tmp9;
				_tmp1 = NULL;
				base_class = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_method_get_base_method (m))))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp5 = NULL;
				vcast = (_tmp5 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = g_strdup_printf ("%s_CLASS", (_tmp2 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (base_class)), NULL))))))))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp5);
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), NULL)))))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
				_tmp7 = (g_free (_tmp7), NULL);
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp9 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp9 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), vala_symbol_get_name (((ValaSymbol*) (m))))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
				(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
				(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp10;
					ValaInterface* base_iface;
					char* _tmp12;
					char* _tmp11;
					char* _tmp13;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp15;
					ValaCCodeIdentifier* _tmp14;
					_tmp10 = NULL;
					base_iface = (_tmp10 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_method_get_base_interface_method (m))))), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
					_tmp12 = NULL;
					_tmp11 = NULL;
					_tmp13 = NULL;
					parent_iface_var = (_tmp13 = g_strdup_printf ("%s_%s_parent_iface", (_tmp11 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), NULL)), (_tmp12 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (base_iface)), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp15 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp14 = vala_ccode_identifier_new (parent_iface_var)))), vala_symbol_get_name (((ValaSymbol*) (m))))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
					(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
					(base_iface == NULL ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL)));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			if (!vala_ccode_module_method_has_wrapper (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_method_get_base_method (m))) {
				ValaCCodeExpression* _tmp16;
				ValaCCodeExpression* inst;
				ValaClass* _tmp18;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp21;
				char* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp22;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp23;
				_tmp16 = NULL;
				inst = (_tmp16 = pub_inst, (_tmp16 == NULL ? NULL : vala_ccode_node_ref (_tmp16)));
				if (vala_member_access_get_inner (expr) != NULL && !vala_expression_is_pure (vala_member_access_get_inner (expr))) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp17;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
					_tmp17 = NULL;
					inst = (_tmp17 = ((ValaCCodeExpression*) (vala_ccode_assignment_new (((ValaCCodeExpression*) (ctemp)), pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp17);
					vala_code_node_set_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (expr))), ((ValaCCodeNode*) (ctemp)));
					(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
					(ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)));
				}
				_tmp18 = NULL;
				base_class = (_tmp18 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_method_get_base_method (m))))), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp22 = NULL;
				vclass = (_tmp22 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_GET_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (base_class)), NULL))))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp23 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp23 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vclass)), vala_symbol_get_name (((ValaSymbol*) (m))))))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				(inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)));
				(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
				(vclass == NULL ? NULL : (vclass = (vala_ccode_node_unref (vclass), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp25;
				char* _tmp24;
				_tmp25 = NULL;
				_tmp24 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_method_get_cname (vala_method_get_base_method (m))))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
				_tmp24 = (g_free (_tmp24), NULL);
			}
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp27;
				char* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_method_get_cname (vala_method_get_base_interface_method (m))))))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
				_tmp26 = (g_free (_tmp26), NULL);
			} else {
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				_tmp29 = NULL;
				_tmp28 = NULL;
				vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_method_get_cname (m)))))));
				(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
				_tmp28 = (g_free (_tmp28), NULL);
			}
		}
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
			ValaCCodeExpression* _tmp30;
			_tmp30 = NULL;
			vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp30 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), vala_member_access_get_inner (expr), 1)))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
				ValaField* _tmp31;
				ValaField* f;
				_tmp31 = NULL;
				f = (_tmp31 = VALA_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp31 == NULL ? NULL : vala_code_node_ref (_tmp31)));
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					ValaDataType* _tmp32;
					ValaDataType* instance_expression_type;
					ValaDataType* instance_target_type;
					ValaClass* _tmp34;
					ValaTypeSymbol* _tmp33;
					ValaClass* cl;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					_tmp32 = NULL;
					instance_expression_type = (_tmp32 = base_type, (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32)));
					instance_target_type = vala_ccode_base_module_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))));
					_tmp34 = NULL;
					_tmp33 = NULL;
					cl = (_tmp34 = (_tmp33 = vala_data_type_get_data_type (instance_target_type), (VALA_IS_CLASS (_tmp33) ? ((ValaClass*) (_tmp33)) : NULL)), (_tmp34 == NULL ? NULL : vala_code_node_ref (_tmp34)));
					is_gtypeinstance = ((vala_data_type_get_data_type (instance_target_type) == VALA_TYPESYMBOL (cl)) && (cl == NULL || !vala_class_get_is_compact (cl)));
					inst = NULL;
					if (is_gtypeinstance && vala_symbol_get_access (((ValaSymbol*) (f))) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* _tmp35;
						_tmp35 = NULL;
						inst = (_tmp35 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (pub_inst, "priv"))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp35);
					} else {
						ValaCCodeExpression* _tmp37;
						ValaCCodeExpression* _tmp36;
						_tmp37 = NULL;
						_tmp36 = NULL;
						inst = (_tmp37 = (_tmp36 = pub_inst, (_tmp36 == NULL ? NULL : vala_ccode_node_ref (_tmp36))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp37);
					}
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type)) || (vala_member_access_get_inner (expr) != NULL && VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr))))) {
						ValaCCodeMemberAccess* _tmp39;
						char* _tmp38;
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp39 = vala_ccode_member_access_new_pointer (inst, (_tmp38 = vala_field_get_cname (f)))))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
						_tmp38 = (g_free (_tmp38), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp41;
						char* _tmp40;
						_tmp41 = NULL;
						_tmp40 = NULL;
						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp41 = vala_ccode_member_access_new (inst, (_tmp40 = vala_field_get_cname (f)), FALSE)))));
						(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
						_tmp40 = (g_free (_tmp40), NULL);
					}
					(instance_expression_type == NULL ? NULL : (instance_expression_type = (vala_code_node_unref (instance_expression_type), NULL)));
					(instance_target_type == NULL ? NULL : (instance_target_type = (vala_code_node_unref (instance_target_type), NULL)));
					(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
					(inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)));
				} else {
					if (vala_field_get_binding (f) == MEMBER_BINDING_CLASS) {
						ValaClass* _tmp42;
						ValaClass* cl;
						ValaCCodeIdentifier* _tmp45;
						char* _tmp44;
						char* _tmp43;
						ValaCCodeFunctionCall* _tmp46;
						ValaCCodeFunctionCall* cast;
						ValaCCodeExpression* klass;
						ValaCCodeMemberAccess* _tmp58;
						char* _tmp57;
						_tmp42 = NULL;
						cl = (_tmp42 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (f)))), (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42)));
						_tmp45 = NULL;
						_tmp44 = NULL;
						_tmp43 = NULL;
						_tmp46 = NULL;
						cast = (_tmp46 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp45 = vala_ccode_identifier_new ((_tmp44 = g_strconcat ((_tmp43 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (cl)), NULL)), "_CLASS", NULL))))))), (_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL))), (_tmp44 = (g_free (_tmp44), NULL)), (_tmp43 = (g_free (_tmp43), NULL)), _tmp46);
						klass = NULL;
						if (vala_member_access_get_inner (expr) == NULL) {
							if (((ValaCCodeBaseModule*) (self))->in_static_or_class_ctor) {
								ValaCCodeExpression* _tmp47;
								/* Accessing the field from a static or class constructor*/
								_tmp47 = NULL;
								klass = (_tmp47 = ((ValaCCodeExpression*) (vala_ccode_identifier_new ("klass"))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp47);
							} else {
								ValaCCodeIdentifier* _tmp48;
								ValaCCodeFunctionCall* _tmp49;
								ValaCCodeFunctionCall* k;
								ValaCCodeIdentifier* _tmp50;
								ValaCCodeExpression* _tmp52;
								ValaCCodeExpression* _tmp51;
								/* Accessing the field from within an instance method*/
								_tmp48 = NULL;
								_tmp49 = NULL;
								k = (_tmp49 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp48 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL))), _tmp49);
								_tmp50 = NULL;
								vala_ccode_function_call_add_argument (k, ((ValaCCodeExpression*) ((_tmp50 = vala_ccode_identifier_new ("self")))));
								(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
								_tmp52 = NULL;
								_tmp51 = NULL;
								klass = (_tmp52 = (_tmp51 = ((ValaCCodeExpression*) (k)), (_tmp51 == NULL ? NULL : vala_ccode_node_ref (_tmp51))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp52);
								(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
							}
						} else {
							ValaCCodeIdentifier* _tmp53;
							ValaCCodeFunctionCall* _tmp54;
							ValaCCodeFunctionCall* k;
							ValaCCodeExpression* _tmp56;
							ValaCCodeExpression* _tmp55;
							/* Accessing the field of an instance*/
							_tmp53 = NULL;
							_tmp54 = NULL;
							k = (_tmp54 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp53 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))))), (_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL))), _tmp54);
							vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (expr))))));
							_tmp56 = NULL;
							_tmp55 = NULL;
							klass = (_tmp56 = (_tmp55 = ((ValaCCodeExpression*) (k)), (_tmp55 == NULL ? NULL : vala_ccode_node_ref (_tmp55))), (klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL))), _tmp56);
							(k == NULL ? NULL : (k = (vala_ccode_node_unref (k), NULL)));
						}
						vala_ccode_function_call_add_argument (cast, klass);
						_tmp58 = NULL;
						_tmp57 = NULL;
						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp58 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (cast)), (_tmp57 = vala_field_get_cname (f)))))));
						(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
						_tmp57 = (g_free (_tmp57), NULL);
						(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
						(cast == NULL ? NULL : (cast = (vala_ccode_node_unref (cast), NULL)));
						(klass == NULL ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp60;
						char* _tmp59;
						_tmp60 = NULL;
						_tmp59 = NULL;
						vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp60 = vala_ccode_identifier_new ((_tmp59 = vala_field_get_cname (f)))))));
						(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
						_tmp59 = (g_free (_tmp59), NULL);
					}
				}
				if (vala_data_type_get_type_parameter (vala_field_get_field_type (f)) != NULL && vala_data_type_get_type_parameter (vala_expression_get_value_type (((ValaExpression*) (expr)))) == NULL) {
					ValaCCodeExpression* _tmp61;
					_tmp61 = NULL;
					vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp61 = vala_ccode_base_module_convert_from_generic_pointer (((ValaCCodeBaseModule*) (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (expr)))), vala_expression_get_value_type (((ValaExpression*) (expr))))))));
					(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
				}
				(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
					ValaConstant* _tmp62;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp64;
					char* _tmp63;
					_tmp62 = NULL;
					c = (_tmp62 = VALA_CONSTANT (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp62 == NULL ? NULL : vala_code_node_ref (_tmp62)));
					_tmp64 = NULL;
					_tmp63 = NULL;
					vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp64 = vala_ccode_identifier_new ((_tmp63 = vala_constant_get_cname (c)))))));
					(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
					_tmp63 = (g_free (_tmp63), NULL);
					(c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
						ValaProperty* _tmp65;
						ValaProperty* prop;
						_tmp65 = NULL;
						prop = (_tmp65 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp65 == NULL ? NULL : vala_code_node_ref (_tmp65)));
						if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
							if (vala_property_get_base_property (prop) != NULL) {
								ValaClass* _tmp66;
								ValaClass* base_class;
								ValaCCodeIdentifier* _tmp69;
								char* _tmp68;
								char* _tmp67;
								ValaCCodeFunctionCall* _tmp70;
								ValaCCodeFunctionCall* vcast;
								ValaCCodeIdentifier* _tmp73;
								char* _tmp72;
								char* _tmp71;
								ValaCCodeMemberAccess* _tmp75;
								char* _tmp74;
								ValaCCodeFunctionCall* _tmp76;
								ValaCCodeFunctionCall* ccall;
								_tmp66 = NULL;
								base_class = (_tmp66 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_property (prop))))), (_tmp66 == NULL ? NULL : vala_code_node_ref (_tmp66)));
								_tmp69 = NULL;
								_tmp68 = NULL;
								_tmp67 = NULL;
								_tmp70 = NULL;
								vcast = (_tmp70 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp69 = vala_ccode_identifier_new ((_tmp68 = g_strdup_printf ("%s_CLASS", (_tmp67 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (base_class)), NULL))))))))), (_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL))), (_tmp68 = (g_free (_tmp68), NULL)), (_tmp67 = (g_free (_tmp67), NULL)), _tmp70);
								_tmp73 = NULL;
								_tmp72 = NULL;
								_tmp71 = NULL;
								vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp73 = vala_ccode_identifier_new ((_tmp72 = g_strdup_printf ("%s_parent_class", (_tmp71 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), NULL)))))))));
								(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
								_tmp72 = (g_free (_tmp72), NULL);
								_tmp71 = (g_free (_tmp71), NULL);
								_tmp75 = NULL;
								_tmp74 = NULL;
								_tmp76 = NULL;
								ccall = (_tmp76 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp75 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), (_tmp74 = g_strdup_printf ("get_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL))), (_tmp74 = (g_free (_tmp74), NULL)), _tmp76);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (expr))))));
								vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
								(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
								(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
								(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
								return;
							} else {
								if (vala_property_get_base_interface_property (prop) != NULL) {
									ValaInterface* _tmp77;
									ValaInterface* base_iface;
									char* _tmp79;
									char* _tmp78;
									char* _tmp80;
									char* parent_iface_var;
									ValaCCodeMemberAccess* _tmp83;
									char* _tmp82;
									ValaCCodeIdentifier* _tmp81;
									ValaCCodeFunctionCall* _tmp84;
									ValaCCodeFunctionCall* ccall;
									_tmp77 = NULL;
									base_iface = (_tmp77 = VALA_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_get_base_interface_property (prop))))), (_tmp77 == NULL ? NULL : vala_code_node_ref (_tmp77)));
									_tmp79 = NULL;
									_tmp78 = NULL;
									_tmp80 = NULL;
									parent_iface_var = (_tmp80 = g_strdup_printf ("%s_%s_parent_iface", (_tmp78 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), NULL)), (_tmp79 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (base_iface)), NULL))), (_tmp79 = (g_free (_tmp79), NULL)), (_tmp78 = (g_free (_tmp78), NULL)), _tmp80);
									_tmp83 = NULL;
									_tmp82 = NULL;
									_tmp81 = NULL;
									_tmp84 = NULL;
									ccall = (_tmp84 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp83 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) ((_tmp81 = vala_ccode_identifier_new (parent_iface_var)))), (_tmp82 = g_strdup_printf ("get_%s", vala_symbol_get_name (((ValaSymbol*) (prop)))))))))), (_tmp83 == NULL ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL))), (_tmp82 = (g_free (_tmp82), NULL)), (_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL))), _tmp84);
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (expr))))));
									vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
									(base_iface == NULL ? NULL : (base_iface = (vala_code_node_unref (base_iface), NULL)));
									parent_iface_var = (g_free (parent_iface_var), NULL);
									(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
									(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
									return;
								}
							}
						}
						if (vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop)) && VALA_SYMBOL (((ValaCCodeBaseModule*) (self))->current_type_symbol) == vala_symbol_get_parent_symbol (((ValaSymbol*) (prop))) && vala_property_get_base_property (prop) == NULL && vala_property_get_base_interface_property (prop) == NULL) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp85;
							ValaCCodeMemberAccess* _tmp87;
							char* _tmp86;
							inst = NULL;
							_tmp85 = NULL;
							inst = (_tmp85 = ((ValaCCodeExpression*) (vala_ccode_member_access_new_pointer (pub_inst, "priv"))), (inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL))), _tmp85);
							_tmp87 = NULL;
							_tmp86 = NULL;
							vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp87 = vala_ccode_member_access_new_pointer (inst, (_tmp86 = vala_field_get_cname (vala_property_get_field (prop))))))));
							(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
							_tmp86 = (g_free (_tmp86), NULL);
							(inst == NULL ? NULL : (inst = (vala_ccode_node_unref (inst), NULL)));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp88;
								ValaProperty* base_property;
								char* getter_cname;
								ValaCCodeIdentifier* _tmp95;
								ValaCCodeFunctionCall* _tmp96;
								ValaCCodeFunctionCall* ccall;
								_tmp88 = NULL;
								base_property = (_tmp88 = prop, (_tmp88 == NULL ? NULL : vala_code_node_ref (_tmp88)));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp90;
									ValaProperty* _tmp89;
									_tmp90 = NULL;
									_tmp89 = NULL;
									base_property = (_tmp90 = (_tmp89 = vala_property_get_base_property (prop), (_tmp89 == NULL ? NULL : vala_code_node_ref (_tmp89))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp90);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp92;
										ValaProperty* _tmp91;
										_tmp92 = NULL;
										_tmp91 = NULL;
										base_property = (_tmp92 = (_tmp91 = vala_property_get_base_interface_property (prop), (_tmp91 == NULL ? NULL : vala_code_node_ref (_tmp91))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp92);
									}
								}
								getter_cname = NULL;
								if (VALA_IS_DYNAMIC_PROPERTY (prop)) {
									char* _tmp93;
									_tmp93 = NULL;
									getter_cname = (_tmp93 = vala_ccode_module_get_dynamic_property_getter_cname (vala_ccode_module_get_head (((ValaCCodeModule*) (self))), VALA_DYNAMIC_PROPERTY (prop)), (getter_cname = (g_free (getter_cname), NULL)), _tmp93);
								} else {
									char* _tmp94;
									_tmp94 = NULL;
									getter_cname = (_tmp94 = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property)), (getter_cname = (g_free (getter_cname), NULL)), _tmp94);
								}
								_tmp95 = NULL;
								_tmp96 = NULL;
								ccall = (_tmp96 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp95 = vala_ccode_identifier_new (getter_cname))))), (_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL))), _tmp96);
								if (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE) {
									vala_ccode_function_call_add_argument (ccall, pub_inst);
								}
								/* Property acesses to real struct types are handeled different to other properties.
								 They are returned as out parameter.*/
								if (vala_data_type_is_real_struct_type (vala_property_get_property_type (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp97;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_property_get_property_type (base_property), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
									gee_collection_add (((GeeCollection*) (((ValaCCodeBaseModule*) (self))->temp_vars)), temp_var);
									_tmp97 = NULL;
									vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp97 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (ctemp)))))));
									(_tmp97 == NULL ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL)));
									vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ccall)));
									vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ctemp)));
									vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
									(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
									(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
									(ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)));
								} else {
									vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
								}
								(base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)));
								getter_cname = (g_free (getter_cname), NULL);
								(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
							} else {
								ValaCCodeIdentifier* _tmp98;
								ValaCCodeFunctionCall* _tmp99;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp100;
								ValaCCodeFunctionCall* _tmp101;
								ValaCCodeFunctionCall* ccast;
								ValaCCodeConstant* _tmp102;
								ValaDataType* temp_type;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp103;
								ValaCCodeConstant* _tmp104;
								ValaCCodeCommaExpression* ccomma;
								_tmp98 = NULL;
								_tmp99 = NULL;
								ccall = (_tmp99 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp98 = vala_ccode_identifier_new ("g_object_get"))))), (_tmp98 == NULL ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL))), _tmp99);
								_tmp100 = NULL;
								_tmp101 = NULL;
								ccast = (_tmp101 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp100 = vala_ccode_identifier_new ("G_OBJECT"))))), (_tmp100 == NULL ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL))), _tmp101);
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (ccast)));
								/* property name is second argument of g_object_get*/
								_tmp102 = NULL;
								vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp102 = vala_property_get_canonical_cconstant (prop)))));
								(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
								/* g_object_get always returns owned values*/
								temp_type = vala_data_type_copy (vala_expression_get_value_type (((ValaExpression*) (expr))));
								vala_data_type_set_value_owned (temp_type, TRUE);
								/* we need a temporary variable to save the property value*/
								temp_var = vala_ccode_base_module_get_temp_variable (((ValaCCodeBaseModule*) (self)), vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE, NULL);
								gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_vars)), 0, temp_var);
								if (vala_ccode_base_module_requires_destroy (((ValaCCodeBaseModule*) (self)), temp_type)) {
									gee_list_insert (((GeeList*) (((ValaCCodeBaseModule*) (self))->temp_ref_vars)), 0, temp_var);
								}
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (temp_var))));
								_tmp103 = NULL;
								vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp103 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, ((ValaCCodeExpression*) (ctemp)))))));
								(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
								_tmp104 = NULL;
								vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp104 = vala_ccode_constant_new ("NULL")))));
								(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
								ccomma = vala_ccode_comma_expression_new ();
								vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ccall)));
								vala_ccode_comma_expression_append_expression (ccomma, ((ValaCCodeExpression*) (ctemp)));
								vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccomma)));
								(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
								(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
								(temp_type == NULL ? NULL : (temp_type = (vala_code_node_unref (temp_type), NULL)));
								(temp_var == NULL ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL)));
								(ctemp == NULL ? NULL : (ctemp = (vala_ccode_node_unref (ctemp), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL)));
							}
						}
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
							ValaEnumValue* _tmp105;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp107;
							char* _tmp106;
							_tmp105 = NULL;
							ev = (_tmp105 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp105 == NULL ? NULL : vala_code_node_ref (_tmp105)));
							_tmp107 = NULL;
							_tmp106 = NULL;
							vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp107 = vala_ccode_constant_new ((_tmp106 = vala_enum_value_get_cname (ev)))))));
							(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
							_tmp106 = (g_free (_tmp106), NULL);
							(ev == NULL ? NULL : (ev = (vala_code_node_unref (ev), NULL)));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
								ValaLocalVariable* _tmp108;
								ValaLocalVariable* local;
								ValaCCodeIdentifier* _tmp110;
								char* _tmp109;
								_tmp108 = NULL;
								local = (_tmp108 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp108 == NULL ? NULL : vala_code_node_ref (_tmp108)));
								_tmp110 = NULL;
								_tmp109 = NULL;
								vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp110 = vala_ccode_identifier_new ((_tmp109 = vala_ccode_base_module_get_variable_cname (((ValaCCodeBaseModule*) (self)), vala_symbol_get_name (((ValaSymbol*) (local))))))))));
								(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
								_tmp109 = (g_free (_tmp109), NULL);
								(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
									ValaFormalParameter* _tmp111;
									ValaFormalParameter* p;
									_tmp111 = NULL;
									p = (_tmp111 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp111 == NULL ? NULL : vala_code_node_ref (_tmp111)));
									if (_vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (p))), "this") == 0) {
										ValaStruct* _tmp113;
										ValaTypeSymbol* _tmp112;
										ValaStruct* st;
										_tmp113 = NULL;
										_tmp112 = NULL;
										st = (_tmp113 = (_tmp112 = ((ValaCCodeBaseModule*) (self))->current_type_symbol, (VALA_IS_STRUCT (_tmp112) ? ((ValaStruct*) (_tmp112)) : NULL)), (_tmp113 == NULL ? NULL : vala_code_node_ref (_tmp113)));
										if (st != NULL && !vala_struct_is_simple_type (st)) {
											ValaCCodeIdentifier* _tmp114;
											_tmp114 = NULL;
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp114 = vala_ccode_identifier_new ("(*self)")))));
											(_tmp114 == NULL ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp115;
											_tmp115 = NULL;
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp115 = vala_ccode_identifier_new ("self")))));
											(_tmp115 == NULL ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL)));
										}
										(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
									} else {
										ValaStruct* _tmp117;
										ValaTypeSymbol* _tmp116;
										ValaStruct* type_as_struct;
										_tmp117 = NULL;
										_tmp116 = NULL;
										type_as_struct = (_tmp117 = (_tmp116 = vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)), (VALA_IS_STRUCT (_tmp116) ? ((ValaStruct*) (_tmp116)) : NULL)), (_tmp117 == NULL ? NULL : vala_code_node_ref (_tmp117)));
										if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN || (type_as_struct != NULL && !vala_struct_is_simple_type (type_as_struct) && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (p)))) {
											ValaCCodeIdentifier* _tmp119;
											char* _tmp118;
											_tmp119 = NULL;
											_tmp118 = NULL;
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp119 = vala_ccode_identifier_new ((_tmp118 = g_strdup_printf ("(*%s)", vala_symbol_get_name (((ValaSymbol*) (p))))))))));
											(_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL)));
											_tmp118 = (g_free (_tmp118), NULL);
										} else {
											/* Property setters of non simple structs shall replace all occurences
											 of the "value" formal parameter with a dereferencing version of that
											 parameter.*/
											if (((ValaCCodeBaseModule*) (self))->current_property_accessor != NULL && vala_property_accessor_get_writable (((ValaCCodeBaseModule*) (self))->current_property_accessor) && vala_property_accessor_get_value_parameter (((ValaCCodeBaseModule*) (self))->current_property_accessor) == p && vala_data_type_is_real_struct_type (vala_property_get_property_type (vala_property_accessor_get_prop (((ValaCCodeBaseModule*) (self))->current_property_accessor)))) {
												ValaCCodeIdentifier* _tmp120;
												_tmp120 = NULL;
												vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp120 = vala_ccode_identifier_new ("(*value)")))));
												(_tmp120 == NULL ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL)));
											} else {
												ValaCCodeIdentifier* _tmp121;
												_tmp121 = NULL;
												vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp121 = vala_ccode_identifier_new (vala_symbol_get_name (((ValaSymbol*) (p))))))));
												(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
											}
										}
										(type_as_struct == NULL ? NULL : (type_as_struct = (vala_code_node_unref (type_as_struct), NULL)));
									}
									(p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
										ValaSignal* _tmp122;
										ValaSignal* sig;
										ValaTypeSymbol* _tmp123;
										ValaTypeSymbol* cl;
										_tmp122 = NULL;
										sig = (_tmp122 = VALA_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp122 == NULL ? NULL : vala_code_node_ref (_tmp122)));
										_tmp123 = NULL;
										cl = (_tmp123 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (sig)))), (_tmp123 == NULL ? NULL : vala_code_node_ref (_tmp123)));
										if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr)) && vala_signal_get_is_virtual (sig)) {
											ValaMethod* m;
											ValaClass* _tmp124;
											ValaClass* base_class;
											ValaCCodeIdentifier* _tmp127;
											char* _tmp126;
											char* _tmp125;
											ValaCCodeFunctionCall* _tmp128;
											ValaCCodeFunctionCall* vcast;
											ValaCCodeIdentifier* _tmp131;
											char* _tmp130;
											char* _tmp129;
											ValaCCodeMemberAccess* _tmp132;
											m = vala_signal_get_method_handler (sig);
											_tmp124 = NULL;
											base_class = (_tmp124 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp124 == NULL ? NULL : vala_code_node_ref (_tmp124)));
											_tmp127 = NULL;
											_tmp126 = NULL;
											_tmp125 = NULL;
											_tmp128 = NULL;
											vcast = (_tmp128 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp127 = vala_ccode_identifier_new ((_tmp126 = g_strdup_printf ("%s_CLASS", (_tmp125 = vala_typesymbol_get_upper_case_cname (((ValaTypeSymbol*) (base_class)), NULL))))))))), (_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL))), (_tmp126 = (g_free (_tmp126), NULL)), (_tmp125 = (g_free (_tmp125), NULL)), _tmp128);
											_tmp131 = NULL;
											_tmp130 = NULL;
											_tmp129 = NULL;
											vala_ccode_function_call_add_argument (vcast, ((ValaCCodeExpression*) ((_tmp131 = vala_ccode_identifier_new ((_tmp130 = g_strdup_printf ("%s_parent_class", (_tmp129 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (((ValaCCodeBaseModule*) (self))->current_class)), NULL)))))))));
											(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
											_tmp130 = (g_free (_tmp130), NULL);
											_tmp129 = (g_free (_tmp129), NULL);
											_tmp132 = NULL;
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) ((_tmp132 = vala_ccode_member_access_new_pointer (((ValaCCodeExpression*) (vcast)), vala_symbol_get_name (((ValaSymbol*) (m))))))));
											(_tmp132 == NULL ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)));
											(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
											(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
											(vcast == NULL ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL)));
											(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
											(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
											return;
										}
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* _tmp135;
											char* _tmp134;
											char* _tmp133;
											ValaCCodeFunctionCall* _tmp136;
											ValaCCodeFunctionCall* ccall;
											_tmp135 = NULL;
											_tmp134 = NULL;
											_tmp133 = NULL;
											_tmp136 = NULL;
											ccall = (_tmp136 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp135 = vala_ccode_identifier_new ((_tmp134 = g_strdup_printf ("%s_%s", (_tmp133 = vala_symbol_get_lower_case_cname (((ValaSymbol*) (cl)), NULL)), vala_symbol_get_name (((ValaSymbol*) (sig)))))))))), (_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL))), (_tmp134 = (g_free (_tmp134), NULL)), (_tmp133 = (g_free (_tmp133), NULL)), _tmp136);
											vala_ccode_function_call_add_argument (ccall, pub_inst);
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
											(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp137;
											ValaCCodeFunctionCall* _tmp138;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* _tmp139;
											ValaCCodeFunctionCall* _tmp140;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* _tmp141;
											_tmp137 = NULL;
											_tmp138 = NULL;
											ccall = (_tmp138 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp137 = vala_ccode_identifier_new ("g_signal_emit_by_name"))))), (_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL))), _tmp138);
											/* FIXME: use C cast if debugging disabled*/
											_tmp139 = NULL;
											_tmp140 = NULL;
											ccast = (_tmp140 = vala_ccode_function_call_new (((ValaCCodeExpression*) ((_tmp139 = vala_ccode_identifier_new ("G_OBJECT"))))), (_tmp139 == NULL ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL))), _tmp140);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) (ccast)));
											_tmp141 = NULL;
											vala_ccode_function_call_add_argument (ccall, ((ValaCCodeExpression*) ((_tmp141 = vala_signal_get_canonical_cconstant (sig, NULL)))));
											(_tmp141 == NULL ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL)));
											vala_code_node_set_ccodenode (((ValaCodeNode*) (expr)), ((ValaCCodeNode*) (ccall)));
											(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_ccode_member_access_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaCCodeMemberAccessModule * self;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = ((ValaCCodeMemberAccessModule*) (base));
	g_return_if_fail (expr != NULL);
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) != NULL) {
		ValaCCodeExpression* _tmp1;
		ValaCCodeExpression* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		pub_inst = (_tmp1 = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (((ValaCodeNode*) (vala_member_access_get_inner (expr))))), (_tmp0 == NULL ? NULL : vala_ccode_node_ref (_tmp0))), (pub_inst == NULL ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL))), _tmp1);
		if (vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp3;
			ValaDataType* _tmp2;
			_tmp3 = NULL;
			_tmp2 = NULL;
			base_type = (_tmp3 = (_tmp2 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), _tmp3);
		}
	}
	vala_ccode_member_access_module_process_cmember (self, expr, pub_inst, base_type);
	(pub_inst == NULL ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
}


static void vala_ccode_member_access_module_class_init (ValaCCodeMemberAccessModuleClass * klass) {
	vala_ccode_member_access_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_ccode_member_access_module_real_visit_member_access;
}


static void vala_ccode_member_access_module_instance_init (ValaCCodeMemberAccessModule * self) {
}


GType vala_ccode_member_access_module_get_type (void) {
	static GType vala_ccode_member_access_module_type_id = 0;
	if (vala_ccode_member_access_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessModule), 0, (GInstanceInitFunc) vala_ccode_member_access_module_instance_init, NULL };
		vala_ccode_member_access_module_type_id = g_type_register_static (VALA_TYPE_CCODE_METHOD_MODULE, "ValaCCodeMemberAccessModule", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




