/* valabasicblock.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabasicblock.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <gobject/gvaluecollector.h>




struct _ValaBasicBlockPrivate {
	GeeList* nodes;
	GeeList* predecessors;
	GeeList* successors;
};

#define VALA_BASIC_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockPrivate))
enum  {
	VALA_BASIC_BLOCK_DUMMY_PROPERTY
};
static gpointer vala_basic_block_parent_class = NULL;
static void vala_basic_block_finalize (ValaBasicBlock* obj);



ValaBasicBlock* vala_basic_block_construct (GType object_type) {
	ValaBasicBlock* self;
	self = ((ValaBasicBlock*) (g_type_create_instance (object_type)));
	return self;
}


ValaBasicBlock* vala_basic_block_new (void) {
	return vala_basic_block_construct (VALA_TYPE_BASIC_BLOCK);
}


ValaBasicBlock* vala_basic_block_construct_entry (GType object_type) {
	ValaBasicBlock* self;
	self = ((ValaBasicBlock*) (g_type_create_instance (object_type)));
	return self;
}


ValaBasicBlock* vala_basic_block_new_entry (void) {
	return vala_basic_block_construct_entry (VALA_TYPE_BASIC_BLOCK);
}


ValaBasicBlock* vala_basic_block_construct_exit (GType object_type) {
	ValaBasicBlock* self;
	self = ((ValaBasicBlock*) (g_type_create_instance (object_type)));
	return self;
}


ValaBasicBlock* vala_basic_block_new_exit (void) {
	return vala_basic_block_construct_exit (VALA_TYPE_BASIC_BLOCK);
}


void vala_basic_block_add_node (ValaBasicBlock* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	gee_collection_add (((GeeCollection*) (self->priv->nodes)), node);
}


void vala_basic_block_connect (ValaBasicBlock* self, ValaBasicBlock* target) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (target != NULL);
	if (!gee_collection_contains (((GeeCollection*) (self->priv->successors)), target)) {
		gee_collection_add (((GeeCollection*) (self->priv->successors)), target);
	}
	if (!gee_collection_contains (((GeeCollection*) (target->priv->predecessors)), self)) {
		gee_collection_add (((GeeCollection*) (target->priv->predecessors)), self);
	}
}


GeeList* vala_basic_block_get_predecessors (ValaBasicBlock* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ((GeeList*) (gee_read_only_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, self->priv->predecessors)));
}


GeeList* vala_basic_block_get_successors (ValaBasicBlock* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return ((GeeList*) (gee_read_only_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, self->priv->successors)));
}


static void vala_value_basic_block_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_basic_block_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_basic_block_unref (value->data[0].v_pointer);
	}
}


static void vala_value_basic_block_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_basic_block_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_basic_block_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_basic_block_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaBasicBlock* object;
		object = value->data[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_OBJECT_TYPE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", G_OBJECT_TYPE (object), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_basic_block_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaBasicBlock** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_basic_block_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_basic_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecBasicBlock* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_BASIC_BLOCK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_basic_block (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_BASIC_BLOCK), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_basic_block (GValue* value, gpointer v_object) {
	ValaBasicBlock* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_BASIC_BLOCK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_BASIC_BLOCK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_basic_block_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_basic_block_unref (old);
	}
}


static void vala_basic_block_class_init (ValaBasicBlockClass * klass) {
	vala_basic_block_parent_class = g_type_class_peek_parent (klass);
	VALA_BASIC_BLOCK_CLASS (klass)->finalize = vala_basic_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaBasicBlockPrivate));
}


static void vala_basic_block_instance_init (ValaBasicBlock * self) {
	self->priv = VALA_BASIC_BLOCK_GET_PRIVATE (self);
	self->priv->nodes = ((GeeList*) (gee_array_list_new (VALA_TYPE_CODE_NODE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
	self->priv->predecessors = ((GeeList*) (gee_array_list_new (VALA_TYPE_BASIC_BLOCK, NULL, NULL, g_direct_equal)));
	self->priv->successors = ((GeeList*) (gee_array_list_new (VALA_TYPE_BASIC_BLOCK, ((GBoxedCopyFunc) (vala_basic_block_ref)), vala_basic_block_unref, g_direct_equal)));
	self->ref_count = 1;
}


static void vala_basic_block_finalize (ValaBasicBlock* obj) {
	ValaBasicBlock * self;
	self = VALA_BASIC_BLOCK (obj);
	(self->priv->nodes == NULL ? NULL : (self->priv->nodes = (gee_collection_object_unref (self->priv->nodes), NULL)));
	(self->priv->predecessors == NULL ? NULL : (self->priv->predecessors = (gee_collection_object_unref (self->priv->predecessors), NULL)));
	(self->priv->successors == NULL ? NULL : (self->priv->successors = (gee_collection_object_unref (self->priv->successors), NULL)));
}


GType vala_basic_block_get_type (void) {
	static GType vala_basic_block_type_id = 0;
	if (vala_basic_block_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_basic_block_init, vala_value_basic_block_free_value, vala_value_basic_block_copy_value, vala_value_basic_block_peek_pointer, "p", vala_value_basic_block_collect_value, "p", vala_value_basic_block_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaBasicBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_basic_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBasicBlock), 0, (GInstanceInitFunc) vala_basic_block_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_basic_block_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaBasicBlock", &g_define_type_info, &g_define_type_fundamental_info, 0);
	}
	return vala_basic_block_type_id;
}


gpointer vala_basic_block_ref (gpointer instance) {
	ValaBasicBlock* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_basic_block_unref (gpointer instance) {
	ValaBasicBlock* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_BASIC_BLOCK_GET_CLASS (self)->finalize (self);
		g_type_free_instance (((GTypeInstance *) (self)));
	}
}




