/* valabooleanliteral.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valabooleanliteral.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaexpression.h>




struct _ValaBooleanLiteralPrivate {
	gboolean _value;
};

#define VALA_BOOLEAN_LITERAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralPrivate))
enum  {
	VALA_BOOLEAN_LITERAL_DUMMY_PROPERTY
};
static void vala_boolean_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_boolean_literal_real_to_string (ValaCodeNode* base);
static gboolean vala_boolean_literal_real_is_pure (ValaExpression* base);
static gpointer vala_boolean_literal_parent_class = NULL;
static void vala_boolean_literal_finalize (ValaCodeNode* obj);



/**
 * Creates a new boolean literal.
 *
 * @param b      boolean value
 * @param source reference to source code
 * @return       newly created boolean literal
 */
ValaBooleanLiteral* vala_boolean_literal_construct (GType object_type, gboolean b, ValaSourceReference* source) {
	ValaBooleanLiteral* self;
	g_return_val_if_fail (source != NULL, NULL);
	self = ((ValaBooleanLiteral*) (g_type_create_instance (object_type)));
	vala_boolean_literal_set_value (self, b);
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source);
	return self;
}


ValaBooleanLiteral* vala_boolean_literal_new (gboolean b, ValaSourceReference* source) {
	return vala_boolean_literal_construct (VALA_TYPE_BOOLEAN_LITERAL, b, source);
}


static void vala_boolean_literal_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaBooleanLiteral * self;
	self = ((ValaBooleanLiteral*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_boolean_literal (visitor, self);
	vala_code_visitor_visit_expression (visitor, ((ValaExpression*) (self)));
}


static char* vala_boolean_literal_real_to_string (ValaCodeNode* base) {
	ValaBooleanLiteral * self;
	self = ((ValaBooleanLiteral*) (base));
	if (self->priv->_value) {
		return g_strdup ("true");
	} else {
		return g_strdup ("false");
	}
}


static gboolean vala_boolean_literal_real_is_pure (ValaExpression* base) {
	ValaBooleanLiteral * self;
	self = ((ValaBooleanLiteral*) (base));
	return TRUE;
}


gboolean vala_boolean_literal_get_value (ValaBooleanLiteral* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_value;
}


void vala_boolean_literal_set_value (ValaBooleanLiteral* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_value = value;
}


static void vala_boolean_literal_class_init (ValaBooleanLiteralClass * klass) {
	vala_boolean_literal_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_boolean_literal_finalize;
	g_type_class_add_private (klass, sizeof (ValaBooleanLiteralPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_boolean_literal_real_accept;
	VALA_CODE_NODE_CLASS (klass)->to_string = vala_boolean_literal_real_to_string;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_boolean_literal_real_is_pure;
}


static void vala_boolean_literal_instance_init (ValaBooleanLiteral * self) {
	self->priv = VALA_BOOLEAN_LITERAL_GET_PRIVATE (self);
}


static void vala_boolean_literal_finalize (ValaCodeNode* obj) {
	ValaBooleanLiteral * self;
	self = VALA_BOOLEAN_LITERAL (obj);
	VALA_CODE_NODE_CLASS (vala_boolean_literal_parent_class)->finalize (obj);
}


GType vala_boolean_literal_get_type (void) {
	static GType vala_boolean_literal_type_id = 0;
	if (vala_boolean_literal_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBooleanLiteralClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_boolean_literal_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBooleanLiteral), 0, (GInstanceInitFunc) vala_boolean_literal_instance_init, NULL };
		vala_boolean_literal_type_id = g_type_register_static (VALA_TYPE_LITERAL, "ValaBooleanLiteral", &g_define_type_info, 0);
	}
	return vala_boolean_literal_type_id;
}




