/* valasemanticanalyzer.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valasemanticanalyzer.h>
#include <gee/list.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valasymbol.h>
#include <vala/valasourcefile.h>
#include <vala/valacodecontext.h>
#include <vala/valadatatype.h>
#include <vala/valaclass.h>
#include <vala/valastruct.h>
#include <vala/valatypesymbol.h>
#include <vala/valainterface.h>
#include <vala/valavaluetype.h>
#include <vala/valascope.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valanamespace.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valamethod.h>
#include <vala/valaproperty.h>
#include <vala/valaenum.h>
#include <vala/valaenumvalue.h>
#include <vala/valaerrordomain.h>
#include <vala/valadelegate.h>
#include <vala/valaconstant.h>
#include <vala/valaexpression.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valaattribute.h>
#include <vala/valacreationmethod.h>
#include <vala/valaformalparameter.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valavoidtype.h>
#include <vala/valablock.h>
#include <vala/valamemberaccess.h>
#include <vala/valareturnstatement.h>
#include <vala/valastatement.h>
#include <vala/valaassignment.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valasignal.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valalocalvariable.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valalambdaexpression.h>
#include <vala/valadelegatetype.h>
#include <vala/valapointertype.h>
#include <vala/valainitializerlist.h>
#include <vala/valaarraytype.h>
#include <vala/valaunaryexpression.h>
#include <vala/valaifstatement.h>
#include <vala/valaswitchsection.h>
#include <vala/valaswitchlabel.h>
#include <vala/valawhilestatement.h>
#include <vala/valadostatement.h>
#include <vala/valaforstatement.h>
#include <vala/valaforeachstatement.h>
#include <vala/valanullliteral.h>
#include <vala/valayieldstatement.h>
#include <vala/valathrowstatement.h>
#include <vala/valaerrortype.h>
#include <vala/valaerrorcode.h>
#include <vala/valatrystatement.h>
#include <vala/valacatchclause.h>
#include <vala/valalockstatement.h>
#include <vala/valalockable.h>
#include <vala/valadeletestatement.h>
#include <vala/valaintegerliteral.h>
#include <vala/valaarraycreationexpression.h>
#include <vala/valaliteral.h>
#include <vala/valabooleanliteral.h>
#include <vala/valacharacterliteral.h>
#include <vala/valaintegertype.h>
#include <vala/valarealliteral.h>
#include <vala/valastringliteral.h>
#include <vala/valanulltype.h>
#include <vala/valamethodtype.h>
#include <vala/valasignaltype.h>
#include <vala/valaparenthesizedexpression.h>
#include <vala/valausingdirective.h>
#include <vala/valapointerindirection.h>
#include <vala/valabaseaccess.h>
#include <vala/valainvocationexpression.h>
#include <vala/valadynamicmethod.h>
#include <vala/valadynamicsignal.h>
#include <vala/valadynamicproperty.h>
#include <vala/valafieldprototype.h>
#include <vala/valainvalidtype.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valareferencetype.h>
#include <vala/valaelementaccess.h>
#include <vala/valapostfixexpression.h>
#include <vala/valamemberinitializer.h>
#include <vala/valasizeofexpression.h>
#include <vala/valatypeofexpression.h>
#include <vala/valabinaryexpression.h>
#include <vala/valacastexpression.h>
#include <vala/valaaddressofexpression.h>
#include <vala/valareferencetransferexpression.h>
#include <vala/valatypecheck.h>
#include <vala/valaconditionalexpression.h>




struct _ValaSemanticAnalyzerPrivate {
	ValaCodeContext* _context;
	ValaSymbol* root_symbol;
	ValaSymbol* _current_symbol;
	ValaSourceFile* _current_source_file;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	GeeList* current_using_directives;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaTypeSymbol* initially_unowned_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaClass* gerror_type;
	ValaDataType* iterable_type;
	ValaInterface* iterator_type;
	ValaInterface* list_type;
	ValaInterface* collection_type;
	ValaInterface* map_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

#define VALA_SEMANTIC_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerPrivate))
enum  {
	VALA_SEMANTIC_ANALYZER_DUMMY_PROPERTY
};
static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static void vala_semantic_analyzer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_semantic_analyzer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_semantic_analyzer_get_all_prerequisites (ValaSemanticAnalyzer* self, ValaInterface* iface, GeeList* list);
static gboolean vala_semantic_analyzer_class_is_a (ValaSemanticAnalyzer* self, ValaClass* cl, ValaTypeSymbol* t);
static void vala_semantic_analyzer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_semantic_analyzer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_semantic_analyzer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_semantic_analyzer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev);
static void vala_semantic_analyzer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_semantic_analyzer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static void vala_semantic_analyzer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c);
static void vala_semantic_analyzer_real_visit_field (ValaCodeVisitor* base, ValaField* f);
static void vala_semantic_analyzer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m);
static void vala_semantic_analyzer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m);
static void vala_semantic_analyzer_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p);
static void vala_semantic_analyzer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop);
static void vala_semantic_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc);
static void vala_semantic_analyzer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig);
static void vala_semantic_analyzer_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c);
static void vala_semantic_analyzer_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d);
static void vala_semantic_analyzer_real_visit_block (ValaCodeVisitor* base, ValaBlock* b);
static void vala_semantic_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt);
static void vala_semantic_analyzer_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local);
static void vala_semantic_analyzer_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list);
static void vala_semantic_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt);
static void vala_semantic_analyzer_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt);
static void vala_semantic_analyzer_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section);
static void vala_semantic_analyzer_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt);
static void vala_semantic_analyzer_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt);
static void vala_semantic_analyzer_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt);
static void vala_semantic_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt);
static void vala_semantic_analyzer_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt);
static void vala_semantic_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt);
static void vala_semantic_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt);
static void vala_semantic_analyzer_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt);
static void vala_semantic_analyzer_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause);
static void vala_semantic_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt);
static void vala_semantic_analyzer_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt);
static gint vala_semantic_analyzer_create_sizes_from_initializer_list (ValaSemanticAnalyzer* self, ValaInitializerList* il, gint rank, GeeList* sl);
static void vala_semantic_analyzer_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr);
static void vala_semantic_analyzer_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr);
static void vala_semantic_analyzer_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr);
static void vala_semantic_analyzer_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr);
static void vala_semantic_analyzer_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr);
static void vala_semantic_analyzer_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr);
static void vala_semantic_analyzer_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr);
static ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue);
static void vala_semantic_analyzer_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr);
static void vala_semantic_analyzer_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr);
static void vala_semantic_analyzer_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr);
static gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaSymbol* member, ValaCodeNode* node_reference);
static void vala_semantic_analyzer_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr);
static gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self);
static void vala_semantic_analyzer_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr);
static void vala_semantic_analyzer_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr);
static void vala_semantic_analyzer_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr);
static void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type);
static void vala_semantic_analyzer_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr);
static void vala_semantic_analyzer_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr);
static gboolean vala_semantic_analyzer_is_numeric_type (ValaSemanticAnalyzer* self, ValaDataType* type);
static gboolean vala_semantic_analyzer_is_integer_type (ValaSemanticAnalyzer* self, ValaDataType* type);
static void vala_semantic_analyzer_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr);
static ValaMemberAccess* vala_semantic_analyzer_find_member_access (ValaSemanticAnalyzer* self, ValaExpression* expr);
static void vala_semantic_analyzer_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr);
static void vala_semantic_analyzer_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr);
static void vala_semantic_analyzer_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr);
static void vala_semantic_analyzer_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr);
static ValaDataType* vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self, ValaDataType* left_type, ValaDataType* right_type);
static void vala_semantic_analyzer_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr);
static void vala_semantic_analyzer_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr);
static void vala_semantic_analyzer_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr);
static char* vala_semantic_analyzer_get_lambda_name (ValaSemanticAnalyzer* self);
static ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self);
static gboolean vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self);
static void vala_semantic_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l);
static void vala_semantic_analyzer_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a);
static gpointer vala_semantic_analyzer_parent_class = NULL;
static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaSemanticAnalyzer* vala_semantic_analyzer_construct (GType object_type) {
	ValaSemanticAnalyzer* self;
	self = ((ValaSemanticAnalyzer*) (g_type_create_instance (object_type)));
	return self;
}


ValaSemanticAnalyzer* vala_semantic_analyzer_new (void) {
	return vala_semantic_analyzer_construct (VALA_TYPE_SEMANTIC_ANALYZER);
}


/**
 * Analyze and check code in the specified context.
 *
 * @param context a code context
 */
void vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self, ValaCodeContext* context) {
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaDataType* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaDataType* _tmp5;
	ValaClass* _tmp4;
	ValaDataType* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypeSymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypeSymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypeSymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypeSymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypeSymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypeSymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypeSymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypeSymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypeSymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypeSymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypeSymbol* _tmp28;
	ValaSymbol* glib_ns;
	ValaSymbol* gee_ns;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	vala_semantic_analyzer_set_context (self, context);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->root_symbol = (_tmp1 = (_tmp0 = ((ValaSymbol*) (vala_code_context_get_root (context))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (vala_code_node_unref (self->priv->root_symbol), NULL))), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->bool_type = (_tmp3 = ((ValaDataType*) (vala_value_type_new ((_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "bool")))))), (self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (vala_code_node_unref (self->priv->bool_type), NULL))), _tmp3);
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->string_type = (_tmp5 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) ((_tmp4 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "string")))))))), (self->priv->string_type == NULL ? NULL : (self->priv->string_type = (vala_code_node_unref (self->priv->string_type), NULL))), _tmp5);
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->uchar_type = (_tmp7 = ((ValaDataType*) (vala_value_type_new ((_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uchar")))))), (self->priv->uchar_type == NULL ? NULL : (self->priv->uchar_type = (vala_code_node_unref (self->priv->uchar_type), NULL))), _tmp7);
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->priv->short_type = (_tmp9 = ((ValaDataType*) (vala_value_type_new ((_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "short")))))), (self->priv->short_type == NULL ? NULL : (self->priv->short_type = (vala_code_node_unref (self->priv->short_type), NULL))), _tmp9);
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL)));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->priv->ushort_type = (_tmp11 = ((ValaDataType*) (vala_value_type_new ((_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ushort")))))), (self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (vala_code_node_unref (self->priv->ushort_type), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->priv->int_type = (_tmp13 = ((ValaDataType*) (vala_value_type_new ((_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int")))))), (self->priv->int_type == NULL ? NULL : (self->priv->int_type = (vala_code_node_unref (self->priv->int_type), NULL))), _tmp13);
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->priv->uint_type = (_tmp15 = ((ValaDataType*) (vala_value_type_new ((_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "uint")))))), (self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (vala_code_node_unref (self->priv->uint_type), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->priv->long_type = (_tmp17 = ((ValaDataType*) (vala_value_type_new ((_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "long")))))), (self->priv->long_type == NULL ? NULL : (self->priv->long_type = (vala_code_node_unref (self->priv->long_type), NULL))), _tmp17);
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL)));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->priv->ulong_type = (_tmp19 = ((ValaDataType*) (vala_value_type_new ((_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ulong")))))), (self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (vala_code_node_unref (self->priv->ulong_type), NULL))), _tmp19);
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->priv->size_t_type = (_tmp21 = ((ValaDataType*) (vala_value_type_new ((_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "size_t")))))), (self->priv->size_t_type == NULL ? NULL : (self->priv->size_t_type = (vala_code_node_unref (self->priv->size_t_type), NULL))), _tmp21);
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->priv->ssize_t_type = (_tmp23 = ((ValaDataType*) (vala_value_type_new ((_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "ssize_t")))))), (self->priv->ssize_t_type == NULL ? NULL : (self->priv->ssize_t_type = (vala_code_node_unref (self->priv->ssize_t_type), NULL))), _tmp23);
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->priv->int8_type = (_tmp25 = ((ValaDataType*) (vala_value_type_new ((_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "int8")))))), (self->priv->int8_type == NULL ? NULL : (self->priv->int8_type = (vala_code_node_unref (self->priv->int8_type), NULL))), _tmp25);
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->priv->unichar_type = (_tmp27 = ((ValaDataType*) (vala_value_type_new ((_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "unichar")))))), (self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (vala_code_node_unref (self->priv->unichar_type), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->priv->double_type = (_tmp29 = ((ValaDataType*) (vala_value_type_new ((_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "double")))))), (self->priv->double_type == NULL ? NULL : (self->priv->double_type = (vala_code_node_unref (self->priv->double_type), NULL))), _tmp29);
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_code_node_unref (_tmp28), NULL)));
	/* TODO: don't require GLib namespace in semantic analyzer*/
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "GLib");
	if (glib_ns != NULL) {
		ValaClass* _tmp30;
		ValaTypeSymbol* _tmp31;
		ValaDataType* _tmp33;
		ValaTypeSymbol* _tmp32;
		ValaDataType* _tmp35;
		ValaClass* _tmp34;
		ValaDataType* _tmp37;
		ValaClass* _tmp36;
		ValaClass* _tmp38;
		_tmp30 = NULL;
		self->priv->object_type = (_tmp30 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->priv->object_type == NULL ? NULL : (self->priv->object_type = (vala_code_node_unref (self->priv->object_type), NULL))), _tmp30);
		_tmp31 = NULL;
		self->priv->initially_unowned_type = (_tmp31 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "InitiallyUnowned")), (self->priv->initially_unowned_type == NULL ? NULL : (self->priv->initially_unowned_type = (vala_code_node_unref (self->priv->initially_unowned_type), NULL))), _tmp31);
		_tmp33 = NULL;
		_tmp32 = NULL;
		self->priv->type_type = (_tmp33 = ((ValaDataType*) (vala_value_type_new ((_tmp32 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type")))))), (self->priv->type_type == NULL ? NULL : (self->priv->type_type = (vala_code_node_unref (self->priv->type_type), NULL))), _tmp33);
		(_tmp32 == NULL ? NULL : (_tmp32 = (vala_code_node_unref (_tmp32), NULL)));
		_tmp35 = NULL;
		_tmp34 = NULL;
		self->priv->glist_type = (_tmp35 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) ((_tmp34 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")))))))), (self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (vala_code_node_unref (self->priv->glist_type), NULL))), _tmp35);
		(_tmp34 == NULL ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL)));
		_tmp37 = NULL;
		_tmp36 = NULL;
		self->priv->gslist_type = (_tmp37 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) ((_tmp36 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")))))))), (self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (vala_code_node_unref (self->priv->gslist_type), NULL))), _tmp37);
		(_tmp36 == NULL ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL)));
		_tmp38 = NULL;
		self->priv->gerror_type = (_tmp38 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Error")), (self->priv->gerror_type == NULL ? NULL : (self->priv->gerror_type = (vala_code_node_unref (self->priv->gerror_type), NULL))), _tmp38);
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaDataType* _tmp40;
		ValaInterface* _tmp39;
		ValaInterface* _tmp41;
		ValaInterface* _tmp42;
		ValaInterface* _tmp43;
		ValaInterface* _tmp44;
		_tmp40 = NULL;
		_tmp39 = NULL;
		self->priv->iterable_type = (_tmp40 = ((ValaDataType*) (vala_object_type_new (((ValaObjectTypeSymbol*) ((_tmp39 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterable")))))))), (self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (vala_code_node_unref (self->priv->iterable_type), NULL))), _tmp40);
		(_tmp39 == NULL ? NULL : (_tmp39 = (vala_code_node_unref (_tmp39), NULL)));
		_tmp41 = NULL;
		self->priv->iterator_type = (_tmp41 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Iterator")), (self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (vala_code_node_unref (self->priv->iterator_type), NULL))), _tmp41);
		_tmp42 = NULL;
		self->priv->list_type = (_tmp42 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->priv->list_type == NULL ? NULL : (self->priv->list_type = (vala_code_node_unref (self->priv->list_type), NULL))), _tmp42);
		_tmp43 = NULL;
		self->priv->collection_type = (_tmp43 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Collection")), (self->priv->collection_type == NULL ? NULL : (self->priv->collection_type = (vala_code_node_unref (self->priv->collection_type), NULL))), _tmp43);
		_tmp44 = NULL;
		self->priv->map_type = (_tmp44 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->priv->map_type == NULL ? NULL : (self->priv->map_type = (vala_code_node_unref (self->priv->map_type), NULL))), _tmp44);
	}
	vala_semantic_analyzer_set_current_symbol (self, self->priv->root_symbol);
	vala_code_context_accept (context, ((ValaCodeVisitor*) (self)));
	(glib_ns == NULL ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL)));
	(gee_ns == NULL ? NULL : (gee_ns = (vala_code_node_unref (gee_ns), NULL)));
}


static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp0;
	GeeList* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (file != NULL);
	vala_semantic_analyzer_set_current_source_file (self, file);
	_tmp0 = NULL;
	self->priv->current_using_directives = (_tmp0 = vala_source_file_get_using_directives (file), (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (gee_collection_object_unref (self->priv->current_using_directives), NULL))), _tmp0);
	self->priv->next_lambda_id = 0;
	vala_source_file_accept_children (file, ((ValaCodeVisitor*) (self)));
	_tmp1 = NULL;
	self->priv->current_using_directives = (_tmp1 = NULL, (self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (gee_collection_object_unref (self->priv->current_using_directives), NULL))), _tmp1);
}


static void vala_semantic_analyzer_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (ns != NULL);
	vala_namespace_process_attributes (ns);
}


static void vala_semantic_analyzer_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaSemanticAnalyzer * self;
	ValaClass* _tmp1;
	ValaClass* _tmp0;
	GeeList* prerequisites;
	GeeList* missing_prereqs;
	ValaClass* _tmp39;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (cl != NULL);
	vala_class_process_attributes (cl);
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (cl)));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_class = (_tmp1 = (_tmp0 = cl, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (vala_code_node_unref (self->priv->current_class), NULL))), _tmp1);
	{
		GeeList* base_type_reference_collection;
		int base_type_reference_it;
		base_type_reference_collection = vala_class_get_base_types (cl);
		for (base_type_reference_it = 0; base_type_reference_it < gee_collection_get_size (GEE_COLLECTION (base_type_reference_collection)); base_type_reference_it = base_type_reference_it + 1) {
			ValaDataType* base_type_reference;
			base_type_reference = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_reference_collection), base_type_reference_it)));
			{
				/* check whether base type is at least as accessible as the class*/
				if (!vala_semantic_analyzer_is_type_accessible (self, ((ValaSymbol*) (cl)), base_type_reference)) {
					char* _tmp4;
					char* _tmp3;
					char* _tmp2;
					vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp4 = g_strdup_printf ("base type `%s` is less accessible than class `%s`", (_tmp2 = vala_code_node_to_string (((ValaCodeNode*) (base_type_reference)))), (_tmp3 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))))));
					_tmp4 = (g_free (_tmp4), NULL);
					_tmp3 = (g_free (_tmp3), NULL);
					_tmp2 = (g_free (_tmp2), NULL);
					(base_type_reference == NULL ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL)));
					(base_type_reference_collection == NULL ? NULL : (base_type_reference_collection = (gee_collection_object_unref (base_type_reference_collection), NULL)));
					return;
				}
				vala_source_file_add_type_dependency (self->priv->_current_source_file, base_type_reference, VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL);
				(base_type_reference == NULL ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL)));
			}
		}
		(base_type_reference_collection == NULL ? NULL : (base_type_reference_collection = (gee_collection_object_unref (base_type_reference_collection), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (cl)), ((ValaCodeVisitor*) (self)));
	/* compact classes cannot implement interfaces */
	if (vala_class_get_is_compact (cl)) {
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						char* _tmp6;
						char* _tmp5;
						vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
						_tmp6 = NULL;
						_tmp5 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp6 = g_strdup_printf ("compact classes `%s` may not implement interfaces", (_tmp5 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))))));
						_tmp6 = (g_free (_tmp6), NULL);
						_tmp5 = (g_free (_tmp5), NULL);
					}
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
		}
	}
	/* gather all prerequisites */
	prerequisites = ((GeeList*) (gee_array_list_new (VALA_TYPE_TYPESYMBOL, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
	{
		GeeList* base_type_collection;
		int base_type_it;
		base_type_collection = vala_class_get_base_types (cl);
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					vala_semantic_analyzer_get_all_prerequisites (self, VALA_INTERFACE (vala_data_type_get_data_type (base_type)), prerequisites);
				}
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
	}
	/* check whether all prerequisites are met */
	missing_prereqs = ((GeeList*) (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal)));
	{
		GeeList* prereq_collection;
		int prereq_it;
		prereq_collection = prerequisites;
		for (prereq_it = 0; prereq_it < gee_collection_get_size (GEE_COLLECTION (prereq_collection)); prereq_it = prereq_it + 1) {
			ValaTypeSymbol* prereq;
			prereq = ((ValaTypeSymbol*) (gee_list_get (GEE_LIST (prereq_collection), prereq_it)));
			{
				if (!vala_semantic_analyzer_class_is_a (self, cl, prereq)) {
					char* _tmp7;
					_tmp7 = NULL;
					gee_list_insert (missing_prereqs, 0, (_tmp7 = vala_symbol_get_full_name (((ValaSymbol*) (prereq)))));
					_tmp7 = (g_free (_tmp7), NULL);
				}
				(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
			}
		}
	}
	/* report any missing prerequisites */
	if (gee_collection_get_size (((GeeCollection*) (missing_prereqs))) > 0) {
		char* _tmp8;
		char* _tmp9;
		char* error_string;
		gboolean first;
		char* _tmp12;
		vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
		_tmp8 = NULL;
		_tmp9 = NULL;
		error_string = (_tmp9 = g_strdup_printf ("%s: some prerequisites (", (_tmp8 = vala_symbol_get_full_name (((ValaSymbol*) (cl))))), (_tmp8 = (g_free (_tmp8), NULL)), _tmp9);
		first = TRUE;
		{
			GeeList* s_collection;
			int s_it;
			s_collection = missing_prereqs;
			for (s_it = 0; s_it < gee_collection_get_size (GEE_COLLECTION (s_collection)); s_it = s_it + 1) {
				char* s;
				s = ((char*) (gee_list_get (GEE_LIST (s_collection), s_it)));
				{
					if (first) {
						char* _tmp10;
						_tmp10 = NULL;
						error_string = (_tmp10 = g_strdup_printf ("%s`%s'", error_string, s), (error_string = (g_free (error_string), NULL)), _tmp10);
						first = FALSE;
					} else {
						char* _tmp11;
						_tmp11 = NULL;
						error_string = (_tmp11 = g_strdup_printf ("%s, `%s'", error_string, s), (error_string = (g_free (error_string), NULL)), _tmp11);
					}
					s = (g_free (s), NULL);
				}
			}
		}
		_tmp12 = NULL;
		error_string = (_tmp12 = g_strconcat (error_string, (") are not met"), NULL), (error_string = (g_free (error_string), NULL)), _tmp12);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), error_string);
		error_string = (g_free (error_string), NULL);
	}
	/* VAPI classes don't have to specify overridden methods */
	if (!vala_symbol_get_external_package (((ValaSymbol*) (cl)))) {
		/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						ValaInterface* _tmp13;
						ValaInterface* iface;
						_tmp13 = NULL;
						iface = (_tmp13 = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13)));
						if (vala_class_get_base_class (cl) != NULL && vala_typesymbol_is_subtype_of (((ValaTypeSymbol*) (vala_class_get_base_class (cl))), ((ValaTypeSymbol*) (iface)))) {
							/* reimplementation of interface, class is not required to reimplement all methods*/
							(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
							(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
							break;
						}
						/* We do not need to do expensive equality checking here since this is done
						 * already. We only need to guarantee the symbols are present.
						 
						 check methods */
						{
							GeeList* m_collection;
							int m_it;
							m_collection = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (iface)));
							for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
								ValaMethod* m;
								m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
								{
									if (vala_method_get_is_abstract (m)) {
										ValaSymbol* sym;
										ValaClass* _tmp14;
										ValaClass* base_class;
										sym = NULL;
										_tmp14 = NULL;
										base_class = (_tmp14 = cl, (_tmp14 == NULL ? NULL : vala_code_node_ref (_tmp14)));
										while (base_class != NULL && !(VALA_IS_METHOD (sym))) {
											ValaSymbol* _tmp15;
											ValaClass* _tmp17;
											ValaClass* _tmp16;
											_tmp15 = NULL;
											sym = (_tmp15 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (base_class))), vala_symbol_get_name (((ValaSymbol*) (m)))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp15);
											_tmp17 = NULL;
											_tmp16 = NULL;
											base_class = (_tmp17 = (_tmp16 = vala_class_get_base_class (base_class), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16))), (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), _tmp17);
										}
										if (!(VALA_IS_METHOD (sym))) {
											char* _tmp20;
											char* _tmp19;
											char* _tmp18;
											vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
											_tmp20 = NULL;
											_tmp19 = NULL;
											_tmp18 = NULL;
											vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp20 = g_strdup_printf ("`%s' does not implement interface method `%s'", (_tmp18 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))), (_tmp19 = vala_symbol_get_full_name (((ValaSymbol*) (m)))))));
											_tmp20 = (g_free (_tmp20), NULL);
											_tmp19 = (g_free (_tmp19), NULL);
											_tmp18 = (g_free (_tmp18), NULL);
										}
										(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
										(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
									}
									(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
								}
							}
							(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
						}
						/* check properties */
						{
							GeeList* prop_collection;
							int prop_it;
							prop_collection = vala_object_type_symbol_get_properties (((ValaObjectTypeSymbol*) (iface)));
							for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
								ValaProperty* prop;
								prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
								{
									if (vala_property_get_is_abstract (prop)) {
										ValaSymbol* sym;
										ValaClass* _tmp21;
										ValaClass* base_class;
										sym = NULL;
										_tmp21 = NULL;
										base_class = (_tmp21 = cl, (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21)));
										while (base_class != NULL && !(VALA_IS_PROPERTY (sym))) {
											ValaSymbol* _tmp22;
											ValaClass* _tmp24;
											ValaClass* _tmp23;
											_tmp22 = NULL;
											sym = (_tmp22 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (base_class))), vala_symbol_get_name (((ValaSymbol*) (prop)))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp22);
											_tmp24 = NULL;
											_tmp23 = NULL;
											base_class = (_tmp24 = (_tmp23 = vala_class_get_base_class (base_class), (_tmp23 == NULL ? NULL : vala_code_node_ref (_tmp23))), (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), _tmp24);
										}
										if (!(VALA_IS_PROPERTY (sym))) {
											char* _tmp27;
											char* _tmp26;
											char* _tmp25;
											vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
											_tmp27 = NULL;
											_tmp26 = NULL;
											_tmp25 = NULL;
											vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp27 = g_strdup_printf ("`%s' does not implement interface property `%s'", (_tmp25 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))), (_tmp26 = vala_symbol_get_full_name (((ValaSymbol*) (prop)))))));
											_tmp27 = (g_free (_tmp27), NULL);
											_tmp26 = (g_free (_tmp26), NULL);
											_tmp25 = (g_free (_tmp25), NULL);
										}
										(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
										(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
									}
									(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
								}
							}
							(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
						}
						(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
					}
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
		}
		/* all abstract symbols defined in base classes have to be implemented in non-abstract classes */
		if (!vala_class_get_is_abstract (cl)) {
			ValaClass* _tmp28;
			ValaClass* base_class;
			_tmp28 = NULL;
			base_class = (_tmp28 = vala_class_get_base_class (cl), (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28)));
			while (base_class != NULL && vala_class_get_is_abstract (base_class)) {
				ValaClass* _tmp38;
				ValaClass* _tmp37;
				{
					GeeList* base_method_collection;
					int base_method_it;
					base_method_collection = vala_object_type_symbol_get_methods (((ValaObjectTypeSymbol*) (base_class)));
					for (base_method_it = 0; base_method_it < gee_collection_get_size (GEE_COLLECTION (base_method_collection)); base_method_it = base_method_it + 1) {
						ValaMethod* base_method;
						base_method = ((ValaMethod*) (gee_list_get (GEE_LIST (base_method_collection), base_method_it)));
						{
							if (vala_method_get_is_abstract (base_method)) {
								ValaSymbol* _tmp29;
								ValaMethod* override_method;
								_tmp29 = NULL;
								override_method = (_tmp29 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (cl)), vala_symbol_get_name (((ValaSymbol*) (base_method)))), (VALA_IS_METHOD (_tmp29) ? ((ValaMethod*) (_tmp29)) : NULL));
								if (override_method == NULL || !vala_method_get_overrides (override_method)) {
									char* _tmp32;
									char* _tmp31;
									char* _tmp30;
									vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
									_tmp32 = NULL;
									_tmp31 = NULL;
									_tmp30 = NULL;
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp32 = g_strdup_printf ("`%s' does not implement abstract method `%s'", (_tmp30 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))), (_tmp31 = vala_symbol_get_full_name (((ValaSymbol*) (base_method)))))));
									_tmp32 = (g_free (_tmp32), NULL);
									_tmp31 = (g_free (_tmp31), NULL);
									_tmp30 = (g_free (_tmp30), NULL);
								}
								(override_method == NULL ? NULL : (override_method = (vala_code_node_unref (override_method), NULL)));
							}
							(base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)));
						}
					}
					(base_method_collection == NULL ? NULL : (base_method_collection = (gee_collection_object_unref (base_method_collection), NULL)));
				}
				{
					GeeList* base_property_collection;
					int base_property_it;
					base_property_collection = vala_object_type_symbol_get_properties (((ValaObjectTypeSymbol*) (base_class)));
					for (base_property_it = 0; base_property_it < gee_collection_get_size (GEE_COLLECTION (base_property_collection)); base_property_it = base_property_it + 1) {
						ValaProperty* base_property;
						base_property = ((ValaProperty*) (gee_list_get (GEE_LIST (base_property_collection), base_property_it)));
						{
							if (vala_property_get_is_abstract (base_property)) {
								ValaSymbol* _tmp33;
								ValaProperty* override_property;
								_tmp33 = NULL;
								override_property = (_tmp33 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (cl)), vala_symbol_get_name (((ValaSymbol*) (base_property)))), (VALA_IS_PROPERTY (_tmp33) ? ((ValaProperty*) (_tmp33)) : NULL));
								if (override_property == NULL || !vala_property_get_overrides (override_property)) {
									char* _tmp36;
									char* _tmp35;
									char* _tmp34;
									vala_code_node_set_error (((ValaCodeNode*) (cl)), TRUE);
									_tmp36 = NULL;
									_tmp35 = NULL;
									_tmp34 = NULL;
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (cl))), (_tmp36 = g_strdup_printf ("`%s' does not implement abstract property `%s'", (_tmp34 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))), (_tmp35 = vala_symbol_get_full_name (((ValaSymbol*) (base_property)))))));
									_tmp36 = (g_free (_tmp36), NULL);
									_tmp35 = (g_free (_tmp35), NULL);
									_tmp34 = (g_free (_tmp34), NULL);
								}
								(override_property == NULL ? NULL : (override_property = (vala_code_node_unref (override_property), NULL)));
							}
							(base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)));
						}
					}
					(base_property_collection == NULL ? NULL : (base_property_collection = (gee_collection_object_unref (base_property_collection), NULL)));
				}
				_tmp38 = NULL;
				_tmp37 = NULL;
				base_class = (_tmp38 = (_tmp37 = vala_class_get_base_class (base_class), (_tmp37 == NULL ? NULL : vala_code_node_ref (_tmp37))), (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), _tmp38);
			}
			(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
		}
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
	_tmp39 = NULL;
	self->priv->current_class = (_tmp39 = NULL, (self->priv->current_class == NULL ? NULL : (self->priv->current_class = (vala_code_node_unref (self->priv->current_class), NULL))), _tmp39);
	(prerequisites == NULL ? NULL : (prerequisites = (gee_collection_object_unref (prerequisites), NULL)));
	(missing_prereqs == NULL ? NULL : (missing_prereqs = (gee_collection_object_unref (missing_prereqs), NULL)));
}


static void vala_semantic_analyzer_get_all_prerequisites (ValaSemanticAnalyzer* self, ValaInterface* iface, GeeList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		GeeList* prereq_collection;
		int prereq_it;
		prereq_collection = vala_interface_get_prerequisites (iface);
		for (prereq_it = 0; prereq_it < gee_collection_get_size (GEE_COLLECTION (prereq_collection)); prereq_it = prereq_it + 1) {
			ValaDataType* prereq;
			prereq = ((ValaDataType*) (gee_list_get (GEE_LIST (prereq_collection), prereq_it)));
			{
				ValaTypeSymbol* _tmp0;
				ValaTypeSymbol* type;
				_tmp0 = NULL;
				type = (_tmp0 = vala_data_type_get_data_type (prereq), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
				/* skip on previous errors */
				if (type == NULL) {
					(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
					(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
					continue;
				}
				gee_collection_add (((GeeCollection*) (list)), type);
				if (VALA_IS_INTERFACE (type)) {
					vala_semantic_analyzer_get_all_prerequisites (self, VALA_INTERFACE (type), list);
				}
				(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
				(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			}
		}
		(prereq_collection == NULL ? NULL : (prereq_collection = (gee_collection_object_unref (prereq_collection), NULL)));
	}
}


static gboolean vala_semantic_analyzer_class_is_a (ValaSemanticAnalyzer* self, ValaClass* cl, ValaTypeSymbol* t) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (cl) == t) {
		return TRUE;
	}
	{
		GeeList* base_type_collection;
		int base_type_it;
		base_type_collection = vala_class_get_base_types (cl);
		for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
			ValaDataType* base_type;
			base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
			{
				if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
					if (vala_semantic_analyzer_class_is_a (self, VALA_CLASS (vala_data_type_get_data_type (base_type)), t)) {
						gboolean _tmp1;
						return (_tmp1 = TRUE, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), _tmp1);
					}
				} else {
					if (vala_data_type_get_data_type (base_type) == t) {
						gboolean _tmp2;
						return (_tmp2 = TRUE, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), _tmp2);
					}
				}
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
			}
		}
		(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
	}
	return FALSE;
}


static void vala_semantic_analyzer_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaSemanticAnalyzer * self;
	ValaStruct* _tmp1;
	ValaStruct* _tmp0;
	GeeList* _tmp3;
	GeeList* _tmp2;
	gboolean _tmp4;
	ValaStruct* _tmp5;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (st != NULL);
	vala_struct_process_attributes (st);
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (st)));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->current_struct = (_tmp1 = (_tmp0 = st, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (self->priv->current_struct == NULL ? NULL : (self->priv->current_struct = (vala_code_node_unref (self->priv->current_struct), NULL))), _tmp1);
	vala_code_node_accept_children (((ValaCodeNode*) (st)), ((ValaCodeVisitor*) (self)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	if ((_tmp4 = !vala_symbol_get_external (((ValaSymbol*) (st))) && !vala_symbol_get_external_package (((ValaSymbol*) (st))) && gee_collection_get_size (((GeeCollection*) ((_tmp2 = vala_struct_get_base_types (st))))) == 0 && gee_collection_get_size (((GeeCollection*) ((_tmp3 = vala_struct_get_fields (st))))) == 0, (_tmp3 == NULL ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL))), (_tmp2 == NULL ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL))), _tmp4)) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (st))), "structs cannot be empty");
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
	_tmp5 = NULL;
	self->priv->current_struct = (_tmp5 = NULL, (self->priv->current_struct == NULL ? NULL : (self->priv->current_struct = (vala_code_node_unref (self->priv->current_struct), NULL))), _tmp5);
}


static void vala_semantic_analyzer_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaSemanticAnalyzer * self;
	ValaClass* prereq_class;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (iface != NULL);
	vala_interface_process_attributes (iface);
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (iface)));
	{
		GeeList* prerequisite_reference_collection;
		int prerequisite_reference_it;
		prerequisite_reference_collection = vala_interface_get_prerequisites (iface);
		for (prerequisite_reference_it = 0; prerequisite_reference_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_reference_collection)); prerequisite_reference_it = prerequisite_reference_it + 1) {
			ValaDataType* prerequisite_reference;
			prerequisite_reference = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_reference_collection), prerequisite_reference_it)));
			{
				/* check whether prerequisite is at least as accessible as the interface*/
				if (!vala_semantic_analyzer_is_type_accessible (self, ((ValaSymbol*) (iface)), prerequisite_reference)) {
					char* _tmp2;
					char* _tmp1;
					char* _tmp0;
					vala_code_node_set_error (((ValaCodeNode*) (iface)), TRUE);
					_tmp2 = NULL;
					_tmp1 = NULL;
					_tmp0 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (iface))), (_tmp2 = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", (_tmp0 = vala_code_node_to_string (((ValaCodeNode*) (prerequisite_reference)))), (_tmp1 = vala_symbol_get_full_name (((ValaSymbol*) (iface)))))));
					_tmp2 = (g_free (_tmp2), NULL);
					_tmp1 = (g_free (_tmp1), NULL);
					_tmp0 = (g_free (_tmp0), NULL);
					(prerequisite_reference == NULL ? NULL : (prerequisite_reference = (vala_code_node_unref (prerequisite_reference), NULL)));
					(prerequisite_reference_collection == NULL ? NULL : (prerequisite_reference_collection = (gee_collection_object_unref (prerequisite_reference_collection), NULL)));
					return;
				}
				vala_source_file_add_type_dependency (self->priv->_current_source_file, prerequisite_reference, VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL);
				(prerequisite_reference == NULL ? NULL : (prerequisite_reference = (vala_code_node_unref (prerequisite_reference), NULL)));
			}
		}
		(prerequisite_reference_collection == NULL ? NULL : (prerequisite_reference_collection = (gee_collection_object_unref (prerequisite_reference_collection), NULL)));
	}
	/* check prerequisites */
	prereq_class = NULL;
	{
		GeeList* prereq_collection;
		int prereq_it;
		prereq_collection = vala_interface_get_prerequisites (iface);
		for (prereq_it = 0; prereq_it < gee_collection_get_size (GEE_COLLECTION (prereq_collection)); prereq_it = prereq_it + 1) {
			ValaDataType* prereq;
			prereq = ((ValaDataType*) (gee_list_get (GEE_LIST (prereq_collection), prereq_it)));
			{
				ValaTypeSymbol* _tmp3;
				ValaTypeSymbol* class_or_interface;
				_tmp3 = NULL;
				class_or_interface = (_tmp3 = vala_data_type_get_data_type (prereq), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
				/* skip on previous errors */
				if (class_or_interface == NULL) {
					vala_code_node_set_error (((ValaCodeNode*) (iface)), TRUE);
					(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
					(class_or_interface == NULL ? NULL : (class_or_interface = (vala_code_node_unref (class_or_interface), NULL)));
					continue;
				}
				/* interfaces are not allowed to have multiple instantiable prerequisites */
				if (VALA_IS_CLASS (class_or_interface)) {
					ValaClass* _tmp9;
					ValaClass* _tmp8;
					if (prereq_class != NULL) {
						char* _tmp7;
						char* _tmp6;
						char* _tmp5;
						char* _tmp4;
						vala_code_node_set_error (((ValaCodeNode*) (iface)), TRUE);
						_tmp7 = NULL;
						_tmp6 = NULL;
						_tmp5 = NULL;
						_tmp4 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (iface))), (_tmp7 = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' and `%s')", (_tmp4 = vala_symbol_get_full_name (((ValaSymbol*) (iface)))), (_tmp5 = vala_symbol_get_full_name (((ValaSymbol*) (class_or_interface)))), (_tmp6 = vala_symbol_get_full_name (((ValaSymbol*) (prereq_class)))))));
						_tmp7 = (g_free (_tmp7), NULL);
						_tmp6 = (g_free (_tmp6), NULL);
						_tmp5 = (g_free (_tmp5), NULL);
						_tmp4 = (g_free (_tmp4), NULL);
						(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
						(class_or_interface == NULL ? NULL : (class_or_interface = (vala_code_node_unref (class_or_interface), NULL)));
						(prereq_collection == NULL ? NULL : (prereq_collection = (gee_collection_object_unref (prereq_collection), NULL)));
						(prereq_class == NULL ? NULL : (prereq_class = (vala_code_node_unref (prereq_class), NULL)));
						return;
					}
					_tmp9 = NULL;
					_tmp8 = NULL;
					prereq_class = (_tmp9 = (_tmp8 = VALA_CLASS (class_or_interface), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8))), (prereq_class == NULL ? NULL : (prereq_class = (vala_code_node_unref (prereq_class), NULL))), _tmp9);
				}
				(prereq == NULL ? NULL : (prereq = (vala_code_node_unref (prereq), NULL)));
				(class_or_interface == NULL ? NULL : (class_or_interface = (vala_code_node_unref (class_or_interface), NULL)));
			}
		}
		(prereq_collection == NULL ? NULL : (prereq_collection = (gee_collection_object_unref (prereq_collection), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (iface)), ((ValaCodeVisitor*) (self)));
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
	(prereq_class == NULL ? NULL : (prereq_class = (vala_code_node_unref (prereq_class), NULL)));
}


static void vala_semantic_analyzer_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (en != NULL);
	vala_enum_process_attributes (en);
	vala_code_node_accept_children (((ValaCodeNode*) (en)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_enum_value (ValaCodeVisitor* base, ValaEnumValue* ev) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (ev != NULL);
	vala_enum_value_process_attributes (ev);
	vala_code_node_accept_children (((ValaCodeNode*) (ev)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (ed != NULL);
	vala_error_domain_process_attributes (ed);
	vala_code_node_accept_children (((ValaCodeNode*) (ed)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (d != NULL);
	vala_delegate_process_attributes (d);
	vala_code_node_accept_children (((ValaCodeNode*) (d)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_constant (ValaCodeVisitor* base, ValaConstant* c) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (c != NULL);
	vala_constant_process_attributes (c);
	vala_code_node_accept (((ValaCodeNode*) (vala_constant_get_type_reference (c))), ((ValaCodeVisitor*) (self)));
	if (!vala_symbol_get_external_package (((ValaSymbol*) (c)))) {
		if (vala_constant_get_initializer (c) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (c)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (c))), "A const field requires a initializer to be provided");
		} else {
			vala_expression_set_target_type (vala_constant_get_initializer (c), vala_constant_get_type_reference (c));
			vala_code_node_accept (((ValaCodeNode*) (vala_constant_get_initializer (c))), ((ValaCodeVisitor*) (self)));
		}
	}
}


static void vala_semantic_analyzer_real_visit_field (ValaCodeVisitor* base, ValaField* f) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (f != NULL);
	vala_field_process_attributes (f);
	if (vala_field_get_initializer (f) != NULL) {
		vala_expression_set_target_type (vala_field_get_initializer (f), vala_field_get_field_type (f));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (f)), ((ValaCodeVisitor*) (self)));
	if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE && VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (f))))) {
		vala_code_node_set_error (((ValaCodeNode*) (f)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (f))), "Interfaces may not have instance fields");
		return;
	}
	if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (f)))) {
		if (VALA_IS_VALUE_TYPE (vala_field_get_field_type (f))) {
			vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_field_get_field_type (f), VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL);
		} else {
			vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_field_get_field_type (f), VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_SHALLOW);
		}
	} else {
		if (VALA_IS_NAMESPACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (f))))) {
			vala_code_node_set_error (((ValaCodeNode*) (f)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (f))), "Namespaces may not have private members");
			return;
		}
		vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_field_get_field_type (f), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	}
}


static void vala_semantic_analyzer_real_visit_method (ValaCodeVisitor* base, ValaMethod* m) {
	ValaSemanticAnalyzer * self;
	ValaSymbol* _tmp2;
	ValaSymbol* old_symbol;
	ValaDataType* _tmp3;
	ValaDataType* old_return_type;
	ValaDataType* _tmp5;
	ValaDataType* _tmp4;
	ValaAttribute* init_attr;
	ValaDataType* _tmp7;
	ValaDataType* _tmp6;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (m != NULL);
	vala_method_process_attributes (m);
	if (vala_method_get_is_abstract (m)) {
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
			ValaClass* _tmp0;
			ValaClass* cl;
			_tmp0 = NULL;
			cl = (_tmp0 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
			if (!vala_class_get_is_abstract (cl)) {
				vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Abstract methods may not be declared in non-abstract classes");
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
				return;
			}
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
		} else {
			if (!(VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))))) {
				vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Abstract methods may not be declared outside of classes and interfaces");
				return;
			}
		}
	} else {
		if (vala_method_get_is_virtual (m)) {
			if (!(VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) && !(VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))))) {
				vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Virtual methods may not be declared outside of classes and interfaces");
				return;
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m))))) {
				ValaClass* _tmp1;
				ValaClass* cl;
				_tmp1 = NULL;
				cl = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
				if (vala_class_get_is_compact (cl)) {
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Virtual methods may not be declared in compact classes");
					(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
					return;
				}
				(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			}
		} else {
			if (vala_method_get_overrides (m)) {
				if (!(VALA_IS_CLASS (vala_symbol_get_parent_symbol (((ValaSymbol*) (m)))))) {
					vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Methods may not be overridden outside of classes");
					return;
				}
			}
		}
	}
	if (vala_method_get_is_abstract (m) && vala_method_get_body (m) != NULL) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Abstract methods cannot have bodies");
	} else {
		if (vala_symbol_get_external (((ValaSymbol*) (m))) && vala_method_get_body (m) != NULL) {
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Extern methods cannot have bodies");
		} else {
			if (!vala_method_get_is_abstract (m) && !vala_symbol_get_external (((ValaSymbol*) (m))) && !vala_symbol_get_external_package (((ValaSymbol*) (m))) && vala_method_get_body (m) == NULL) {
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "Non-abstract, non-extern methods must have bodies");
			}
		}
	}
	_tmp2 = NULL;
	old_symbol = (_tmp2 = self->priv->_current_symbol, (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	_tmp3 = NULL;
	old_return_type = (_tmp3 = self->priv->current_return_type, (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (m)));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->priv->current_return_type = (_tmp5 = (_tmp4 = vala_method_get_return_type (m), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp5);
	init_attr = vala_code_node_get_attribute (((ValaCodeNode*) (m)), "ModuleInit");
	if (init_attr != NULL) {
		vala_code_context_set_module_init_method (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) (m))))), m);
	}
	if (!vala_symbol_is_internal_symbol (((ValaSymbol*) (m)))) {
		if (VALA_IS_VALUE_TYPE (vala_method_get_return_type (m))) {
			vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_method_get_return_type (m), VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_FULL);
		} else {
			vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_method_get_return_type (m), VALA_SOURCE_FILE_DEPENDENCY_TYPE_HEADER_SHALLOW);
		}
	}
	vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_method_get_return_type (m), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	vala_code_node_accept_children (((ValaCodeNode*) (m)), ((ValaCodeVisitor*) (self)));
	vala_semantic_analyzer_set_current_symbol (self, old_symbol);
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->priv->current_return_type = (_tmp7 = (_tmp6 = old_return_type, (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp7);
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (self->priv->_current_symbol))) {
		ValaMethod* _tmp8;
		ValaMethod* up_method;
		ValaDataType* _tmp10;
		ValaDataType* _tmp9;
		/* lambda expressions produce nested methods */
		_tmp8 = NULL;
		up_method = (_tmp8 = VALA_METHOD (vala_symbol_get_parent_symbol (self->priv->_current_symbol)), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
		_tmp10 = NULL;
		_tmp9 = NULL;
		self->priv->current_return_type = (_tmp10 = (_tmp9 = vala_method_get_return_type (up_method), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp10);
		(up_method == NULL ? NULL : (up_method = (vala_code_node_unref (up_method), NULL)));
	}
	if (VALA_IS_STRUCT (self->priv->_current_symbol)) {
		if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m) || vala_method_get_overrides (m)) {
			char* _tmp12;
			char* _tmp11;
			_tmp12 = NULL;
			_tmp11 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), (_tmp12 = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstract", (_tmp11 = vala_symbol_get_full_name (((ValaSymbol*) (m)))))));
			_tmp12 = (g_free (_tmp12), NULL);
			_tmp11 = (g_free (_tmp11), NULL);
			(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
			(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
			(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
			return;
		}
	} else {
		if (vala_method_get_overrides (m) && vala_method_get_base_method (m) == NULL) {
			char* _tmp14;
			char* _tmp13;
			_tmp14 = NULL;
			_tmp13 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), (_tmp14 = g_strdup_printf ("%s: no suitable method found to override", (_tmp13 = vala_symbol_get_full_name (((ValaSymbol*) (m)))))));
			_tmp14 = (g_free (_tmp14), NULL);
			_tmp13 = (g_free (_tmp13), NULL);
		}
	}
	/* check whether return type is at least as accessible as the method*/
	if (!vala_semantic_analyzer_is_type_accessible (self, ((ValaSymbol*) (m)), vala_method_get_return_type (m))) {
		char* _tmp17;
		char* _tmp16;
		char* _tmp15;
		vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), (_tmp17 = g_strdup_printf ("return type `%s` is less accessible than method `%s`", (_tmp15 = vala_code_node_to_string (((ValaCodeNode*) (vala_method_get_return_type (m))))), (_tmp16 = vala_symbol_get_full_name (((ValaSymbol*) (m)))))));
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp16 = (g_free (_tmp16), NULL);
		_tmp15 = (g_free (_tmp15), NULL);
		(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
		(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
		(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
		return;
	}
	{
		GeeList* precondition_collection;
		int precondition_it;
		precondition_collection = vala_method_get_preconditions (m);
		for (precondition_it = 0; precondition_it < gee_collection_get_size (GEE_COLLECTION (precondition_collection)); precondition_it = precondition_it + 1) {
			ValaExpression* precondition;
			precondition = ((ValaExpression*) (gee_list_get (GEE_LIST (precondition_collection), precondition_it)));
			{
				if (vala_code_node_get_error (((ValaCodeNode*) (precondition)))) {
					/* if there was an error in the precondition, skip this check*/
					vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
					(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
					(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
					(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
					(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
					(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
					return;
				}
				if (!vala_data_type_compatible (vala_expression_get_value_type (precondition), self->priv->bool_type)) {
					vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (precondition))), "Precondition must be boolean");
					(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
					(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
					(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
					(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
					(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
					return;
				}
				(precondition == NULL ? NULL : (precondition = (vala_code_node_unref (precondition), NULL)));
			}
		}
		(precondition_collection == NULL ? NULL : (precondition_collection = (gee_collection_object_unref (precondition_collection), NULL)));
	}
	{
		GeeList* postcondition_collection;
		int postcondition_it;
		postcondition_collection = vala_method_get_postconditions (m);
		for (postcondition_it = 0; postcondition_it < gee_collection_get_size (GEE_COLLECTION (postcondition_collection)); postcondition_it = postcondition_it + 1) {
			ValaExpression* postcondition;
			postcondition = ((ValaExpression*) (gee_list_get (GEE_LIST (postcondition_collection), postcondition_it)));
			{
				if (vala_code_node_get_error (((ValaCodeNode*) (postcondition)))) {
					/* if there was an error in the postcondition, skip this check*/
					vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
					(postcondition == NULL ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL)));
					(postcondition_collection == NULL ? NULL : (postcondition_collection = (gee_collection_object_unref (postcondition_collection), NULL)));
					(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
					(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
					(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
					return;
				}
				if (!vala_data_type_compatible (vala_expression_get_value_type (postcondition), self->priv->bool_type)) {
					vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (postcondition))), "Postcondition must be boolean");
					(postcondition == NULL ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL)));
					(postcondition_collection == NULL ? NULL : (postcondition_collection = (gee_collection_object_unref (postcondition_collection), NULL)));
					(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
					(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
					(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
					return;
				}
				(postcondition == NULL ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL)));
			}
		}
		(postcondition_collection == NULL ? NULL : (postcondition_collection = (gee_collection_object_unref (postcondition_collection), NULL)));
	}
	if (vala_code_node_get_tree_can_fail (((ValaCodeNode*) (m))) && _vala_strcmp0 (vala_symbol_get_name (((ValaSymbol*) (m))), "main") == 0) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), "\"main\" method cannot throw errors");
	}
	/* check that all errors that can be thrown in the method body are declared*/
	if (vala_method_get_body (m) != NULL) {
		{
			GeeList* body_error_type_collection;
			int body_error_type_it;
			body_error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (vala_method_get_body (m))));
			for (body_error_type_it = 0; body_error_type_it < gee_collection_get_size (GEE_COLLECTION (body_error_type_collection)); body_error_type_it = body_error_type_it + 1) {
				ValaDataType* body_error_type;
				body_error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (body_error_type_collection), body_error_type_it)));
				{
					gboolean can_propagate_error;
					can_propagate_error = FALSE;
					{
						GeeList* method_error_type_collection;
						int method_error_type_it;
						method_error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (m)));
						for (method_error_type_it = 0; method_error_type_it < gee_collection_get_size (GEE_COLLECTION (method_error_type_collection)); method_error_type_it = method_error_type_it + 1) {
							ValaDataType* method_error_type;
							method_error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (method_error_type_collection), method_error_type_it)));
							{
								if (vala_data_type_compatible (body_error_type, method_error_type)) {
									can_propagate_error = TRUE;
								}
								(method_error_type == NULL ? NULL : (method_error_type = (vala_code_node_unref (method_error_type), NULL)));
							}
						}
						(method_error_type_collection == NULL ? NULL : (method_error_type_collection = (gee_collection_object_unref (method_error_type_collection), NULL)));
					}
					if (!can_propagate_error) {
						char* _tmp19;
						char* _tmp18;
						_tmp19 = NULL;
						_tmp18 = NULL;
						vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (body_error_type))), (_tmp19 = g_strdup_printf ("unhandled error `%s'", (_tmp18 = vala_code_node_to_string (((ValaCodeNode*) (body_error_type)))))));
						_tmp19 = (g_free (_tmp19), NULL);
						_tmp18 = (g_free (_tmp18), NULL);
					}
					(body_error_type == NULL ? NULL : (body_error_type = (vala_code_node_unref (body_error_type), NULL)));
				}
			}
			(body_error_type_collection == NULL ? NULL : (body_error_type_collection = (gee_collection_object_unref (body_error_type_collection), NULL)));
		}
	}
	(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
	(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
	(init_attr == NULL ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL)));
}


static void vala_semantic_analyzer_real_visit_creation_method (ValaCodeVisitor* base, ValaCreationMethod* m) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp3;
	ValaDataType* _tmp2;
	ValaDataType* _tmp4;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (m != NULL);
	vala_method_process_attributes (((ValaMethod*) (m)));
	if (vala_creation_method_get_type_name (m) != NULL && _vala_strcmp0 (vala_creation_method_get_type_name (m), vala_symbol_get_name (self->priv->_current_symbol)) != 0) {
		char* _tmp1;
		char* _tmp0;
		/* type_name is null for constructors generated by GIdlParser*/
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), (_tmp1 = g_strdup_printf ("missing return type in method `%s.%s´", (_tmp0 = vala_symbol_get_full_name (self->priv->_current_symbol)), vala_creation_method_get_type_name (m))));
		_tmp1 = (g_free (_tmp1), NULL);
		_tmp0 = (g_free (_tmp0), NULL);
		vala_code_node_set_error (((ValaCodeNode*) (m)), TRUE);
		return;
	}
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (m)));
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->priv->current_return_type = (_tmp3 = (_tmp2 = vala_method_get_return_type (((ValaMethod*) (m))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp3);
	vala_code_node_accept_children (((ValaCodeNode*) (m)), ((ValaCodeVisitor*) (self)));
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
	_tmp4 = NULL;
	self->priv->current_return_type = (_tmp4 = NULL, (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp4);
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (self->priv->_current_symbol))) {
		ValaMethod* _tmp5;
		ValaMethod* up_method;
		ValaDataType* _tmp7;
		ValaDataType* _tmp6;
		/* lambda expressions produce nested methods */
		_tmp5 = NULL;
		up_method = (_tmp5 = VALA_METHOD (vala_symbol_get_parent_symbol (self->priv->_current_symbol)), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		self->priv->current_return_type = (_tmp7 = (_tmp6 = vala_method_get_return_type (up_method), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp7);
		(up_method == NULL ? NULL : (up_method = (vala_code_node_unref (up_method), NULL)));
	}
	if (vala_method_get_is_abstract (((ValaMethod*) (m))) || vala_method_get_is_virtual (((ValaMethod*) (m))) || vala_method_get_overrides (((ValaMethod*) (m)))) {
		char* _tmp9;
		char* _tmp8;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (m))), (_tmp9 = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abstract", (_tmp8 = vala_symbol_get_full_name (((ValaSymbol*) (m)))))));
		_tmp9 = (g_free (_tmp9), NULL);
		_tmp8 = (g_free (_tmp8), NULL);
		return;
	}
}


static void vala_semantic_analyzer_real_visit_formal_parameter (ValaCodeVisitor* base, ValaFormalParameter* p) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (p != NULL);
	vala_formal_parameter_process_attributes (p);
	vala_code_node_check (((ValaCodeNode*) (p)), self);
}


/* check whether type is at least as accessible as the specified symbol*/
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	{
		GeeList* type_symbol_collection;
		int type_symbol_it;
		type_symbol_collection = vala_data_type_get_symbols (type);
		for (type_symbol_it = 0; type_symbol_it < gee_collection_get_size (GEE_COLLECTION (type_symbol_collection)); type_symbol_it = type_symbol_it + 1) {
			ValaSymbol* type_symbol;
			type_symbol = ((ValaSymbol*) (gee_list_get (GEE_LIST (type_symbol_collection), type_symbol_it)));
			{
				ValaScope* method_scope;
				ValaScope* type_scope;
				method_scope = vala_symbol_get_top_accessible_scope (sym);
				type_scope = vala_symbol_get_top_accessible_scope (type_symbol);
				if ((method_scope == NULL && type_scope != NULL) || (method_scope != NULL && !vala_scope_is_subscope_of (method_scope, type_scope))) {
					gboolean _tmp0;
					return (_tmp0 = FALSE, (type_symbol == NULL ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL))), (method_scope == NULL ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL))), (type_scope == NULL ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL))), (type_symbol_collection == NULL ? NULL : (type_symbol_collection = (gee_collection_object_unref (type_symbol_collection), NULL))), _tmp0);
				}
				(type_symbol == NULL ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL)));
				(method_scope == NULL ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL)));
				(type_scope == NULL ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL)));
			}
		}
		(type_symbol_collection == NULL ? NULL : (type_symbol_collection = (gee_collection_object_unref (type_symbol_collection), NULL)));
	}
	return TRUE;
}


static void vala_semantic_analyzer_real_visit_property (ValaCodeVisitor* base, ValaProperty* prop) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (prop != NULL);
	vala_property_process_attributes (prop);
	vala_code_node_check (((ValaCodeNode*) (prop)), self);
}


static void vala_semantic_analyzer_real_visit_property_accessor (ValaCodeVisitor* base, ValaPropertyAccessor* acc) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp0;
	ValaDataType* old_return_type;
	ValaDataType* _tmp13;
	ValaDataType* _tmp12;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (acc != NULL);
	vala_property_accessor_process_attributes (acc);
	_tmp0 = NULL;
	old_return_type = (_tmp0 = self->priv->current_return_type, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (vala_property_accessor_get_readable (acc)) {
		ValaDataType* _tmp2;
		ValaDataType* _tmp1;
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->current_return_type = (_tmp2 = (_tmp1 = vala_property_get_property_type (vala_property_accessor_get_prop (acc)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp2);
	} else {
		ValaDataType* _tmp3;
		/* void*/
		_tmp3 = NULL;
		self->priv->current_return_type = (_tmp3 = ((ValaDataType*) (vala_void_type_new ())), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp3);
	}
	if (!vala_symbol_get_external_package (((ValaSymbol*) (vala_property_accessor_get_prop (acc))))) {
		if (vala_property_accessor_get_body (acc) == NULL && !vala_property_get_interface_only (vala_property_accessor_get_prop (acc)) && !vala_property_get_is_abstract (vala_property_accessor_get_prop (acc))) {
			ValaBlock* _tmp4;
			char* _tmp5;
			ValaMemberAccess* _tmp6;
			ValaMemberAccess* ma;
			/* no accessor body specified, insert default body */
			if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol (((ValaSymbol*) (vala_property_accessor_get_prop (acc)))))) {
				vala_code_node_set_error (((ValaCodeNode*) (acc)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (acc))), "Automatic properties can't be used in interfaces");
				(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
				return;
			}
			vala_property_accessor_set_automatic_body (acc, TRUE);
			_tmp4 = NULL;
			vala_property_accessor_set_body (acc, (_tmp4 = vala_block_new (vala_code_node_get_source_reference (((ValaCodeNode*) (acc))))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
			_tmp5 = NULL;
			_tmp6 = NULL;
			ma = (_tmp6 = vala_member_access_new_simple ((_tmp5 = g_strdup_printf ("_%s", vala_symbol_get_name (((ValaSymbol*) (vala_property_accessor_get_prop (acc)))))), vala_code_node_get_source_reference (((ValaCodeNode*) (acc)))), (_tmp5 = (g_free (_tmp5), NULL)), _tmp6);
			if (vala_property_accessor_get_readable (acc)) {
				ValaReturnStatement* _tmp7;
				_tmp7 = NULL;
				vala_block_add_statement (vala_property_accessor_get_body (acc), ((ValaStatement*) ((_tmp7 = vala_return_statement_new (((ValaExpression*) (ma)), vala_code_node_get_source_reference (((ValaCodeNode*) (acc))))))));
				(_tmp7 == NULL ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL)));
			} else {
				ValaMemberAccess* _tmp8;
				ValaAssignment* _tmp9;
				ValaAssignment* assignment;
				ValaExpressionStatement* _tmp10;
				_tmp8 = NULL;
				_tmp9 = NULL;
				assignment = (_tmp9 = vala_assignment_new (((ValaExpression*) (ma)), ((ValaExpression*) ((_tmp8 = vala_member_access_new_simple ("value", vala_code_node_get_source_reference (((ValaCodeNode*) (acc))))))), VALA_ASSIGNMENT_OPERATOR_SIMPLE, vala_code_node_get_source_reference (((ValaCodeNode*) (acc)))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL))), _tmp9);
				_tmp10 = NULL;
				vala_block_add_statement (vala_property_accessor_get_body (acc), ((ValaStatement*) ((_tmp10 = vala_expression_statement_new (((ValaExpression*) (assignment)), NULL)))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL)));
				(assignment == NULL ? NULL : (assignment = (vala_code_node_unref (assignment), NULL)));
			}
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
		if (vala_property_accessor_get_body (acc) != NULL && (vala_property_accessor_get_writable (acc) || vala_property_accessor_get_construction (acc))) {
			ValaDataType* value_type;
			ValaFormalParameter* _tmp11;
			value_type = vala_data_type_copy (vala_property_get_property_type (vala_property_accessor_get_prop (acc)));
			_tmp11 = NULL;
			vala_property_accessor_set_value_parameter (acc, (_tmp11 = vala_formal_parameter_new ("value", value_type, vala_code_node_get_source_reference (((ValaCodeNode*) (acc))))));
			(_tmp11 == NULL ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL)));
			vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_property_accessor_get_body (acc)))), vala_symbol_get_name (((ValaSymbol*) (vala_property_accessor_get_value_parameter (acc)))), ((ValaSymbol*) (vala_property_accessor_get_value_parameter (acc))));
			(value_type == NULL ? NULL : (value_type = (vala_code_node_unref (value_type), NULL)));
		}
	}
	vala_code_node_accept_children (((ValaCodeNode*) (acc)), ((ValaCodeVisitor*) (self)));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->priv->current_return_type = (_tmp13 = (_tmp12 = old_return_type, (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12))), (self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL))), _tmp13);
	(old_return_type == NULL ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL)));
}


static void vala_semantic_analyzer_real_visit_signal (ValaCodeVisitor* base, ValaSignal* sig) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (sig != NULL);
	vala_signal_process_attributes (sig);
	vala_code_node_accept_children (((ValaCodeNode*) (sig)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_constructor (ValaCodeVisitor* base, ValaConstructor* c) {
	ValaSemanticAnalyzer * self;
	ValaFormalParameter* _tmp1;
	ValaObjectType* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (c != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_constructor_set_this_parameter (c, (_tmp1 = vala_formal_parameter_new ("this", ((ValaDataType*) ((_tmp0 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->priv->current_class)))))), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (c))), vala_symbol_get_name (((ValaSymbol*) (vala_constructor_get_this_parameter (c)))), ((ValaSymbol*) (vala_constructor_get_this_parameter (c))));
	vala_symbol_set_owner (((ValaSymbol*) (c)), vala_symbol_get_scope (self->priv->_current_symbol));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (c)));
	vala_code_node_accept_children (((ValaCodeNode*) (c)), ((ValaCodeVisitor*) (self)));
	{
		GeeList* body_error_type_collection;
		int body_error_type_it;
		body_error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (vala_constructor_get_body (c))));
		for (body_error_type_it = 0; body_error_type_it < gee_collection_get_size (GEE_COLLECTION (body_error_type_collection)); body_error_type_it = body_error_type_it + 1) {
			ValaDataType* body_error_type;
			body_error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (body_error_type_collection), body_error_type_it)));
			{
				char* _tmp3;
				char* _tmp2;
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (body_error_type))), (_tmp3 = g_strdup_printf ("unhandled error `%s'", (_tmp2 = vala_code_node_to_string (((ValaCodeNode*) (body_error_type)))))));
				_tmp3 = (g_free (_tmp3), NULL);
				_tmp2 = (g_free (_tmp2), NULL);
				(body_error_type == NULL ? NULL : (body_error_type = (vala_code_node_unref (body_error_type), NULL)));
			}
		}
		(body_error_type_collection == NULL ? NULL : (body_error_type_collection = (gee_collection_object_unref (body_error_type_collection), NULL)));
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
}


static void vala_semantic_analyzer_real_visit_destructor (ValaCodeVisitor* base, ValaDestructor* d) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (d != NULL);
	vala_symbol_set_owner (((ValaSymbol*) (d)), vala_symbol_get_scope (self->priv->_current_symbol));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (d)));
	vala_code_node_accept_children (((ValaCodeNode*) (d)), ((ValaCodeVisitor*) (self)));
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
}


static void vala_semantic_analyzer_real_visit_block (ValaCodeVisitor* base, ValaBlock* b) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (b != NULL);
	vala_symbol_set_owner (((ValaSymbol*) (b)), vala_symbol_get_scope (self->priv->_current_symbol));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (b)));
	vala_code_node_accept_children (((ValaCodeNode*) (b)), ((ValaCodeVisitor*) (self)));
	{
		GeeList* local_collection;
		int local_it;
		local_collection = vala_block_get_local_variables (b);
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				vala_symbol_set_active (((ValaSymbol*) (local)), FALSE);
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
		(local_collection == NULL ? NULL : (local_collection = (gee_collection_object_unref (local_collection), NULL)));
	}
	{
		GeeList* stmt_collection;
		int stmt_it;
		stmt_collection = vala_block_get_statements (b);
		for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
			ValaStatement* stmt;
			stmt = ((ValaStatement*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)));
			{
				GeeList* _tmp0;
				_tmp0 = NULL;
				vala_code_node_add_error_types (((ValaCodeNode*) (b)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (stmt)))));
				(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
				(stmt == NULL ? NULL : (stmt = (vala_code_node_unref (stmt), NULL)));
			}
		}
		(stmt_collection == NULL ? NULL : (stmt_collection = (gee_collection_object_unref (stmt_collection), NULL)));
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
}


static void vala_semantic_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base, ValaDeclarationStatement* stmt) {
	ValaSemanticAnalyzer * self;
	ValaLocalVariable* _tmp1;
	ValaSymbol* _tmp0;
	ValaLocalVariable* local;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	local = (_tmp1 = (_tmp0 = vala_declaration_statement_get_declaration (stmt), (VALA_IS_LOCAL_VARIABLE (_tmp0) ? ((ValaLocalVariable*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (local != NULL && vala_local_variable_get_initializer (local) != NULL) {
		{
			GeeList* error_type_collection;
			int error_type_it;
			error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (vala_local_variable_get_initializer (local))));
			for (error_type_it = 0; error_type_it < gee_collection_get_size (GEE_COLLECTION (error_type_collection)); error_type_it = error_type_it + 1) {
				ValaDataType* error_type;
				error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (error_type_collection), error_type_it)));
				{
					ValaDataType* initializer_error_type;
					/* ensure we can trace back which expression may throw errors of this type*/
					initializer_error_type = vala_data_type_copy (error_type);
					vala_code_node_set_source_reference (((ValaCodeNode*) (initializer_error_type)), vala_code_node_get_source_reference (((ValaCodeNode*) (vala_local_variable_get_initializer (local)))));
					vala_code_node_add_error_type (((ValaCodeNode*) (stmt)), initializer_error_type);
					(error_type == NULL ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)));
					(initializer_error_type == NULL ? NULL : (initializer_error_type = (vala_code_node_unref (initializer_error_type), NULL)));
				}
			}
			(error_type_collection == NULL ? NULL : (error_type_collection = (gee_collection_object_unref (error_type_collection), NULL)));
		}
	}
	(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
}


static void vala_semantic_analyzer_real_visit_local_variable (ValaCodeVisitor* base, ValaLocalVariable* local) {
	ValaSemanticAnalyzer * self;
	ValaBlock* _tmp10;
	ValaBlock* block;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (local != NULL);
	if (vala_local_variable_get_initializer (local) != NULL) {
		vala_expression_set_target_type (vala_local_variable_get_initializer (local), vala_local_variable_get_variable_type (local));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (local)), ((ValaCodeVisitor*) (self)));
	if (vala_local_variable_get_variable_type (local) == NULL) {
		ValaDataType* _tmp0;
		/* var type */
		if (vala_local_variable_get_initializer (local) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), "var declaration not allowed without initializer");
			return;
		}
		if (vala_expression_get_value_type (vala_local_variable_get_initializer (local)) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), "var declaration not allowed with non-typed initializer");
			return;
		}
		_tmp0 = NULL;
		vala_local_variable_set_variable_type (local, (_tmp0 = vala_data_type_copy (vala_expression_get_value_type (vala_local_variable_get_initializer (local)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
		vala_data_type_set_value_owned (vala_local_variable_get_variable_type (local), TRUE);
		vala_data_type_set_floating_reference (vala_local_variable_get_variable_type (local), FALSE);
		vala_expression_set_target_type (vala_local_variable_get_initializer (local), vala_local_variable_get_variable_type (local));
	}
	if (vala_local_variable_get_initializer (local) != NULL) {
		if (vala_expression_get_value_type (vala_local_variable_get_initializer (local)) == NULL) {
			if (!(VALA_IS_MEMBER_ACCESS (vala_local_variable_get_initializer (local))) && !(VALA_IS_LAMBDA_EXPRESSION (vala_local_variable_get_initializer (local)))) {
				vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), "expression type not allowed as initializer");
				return;
			}
			if (VALA_IS_METHOD (vala_expression_get_symbol_reference (vala_local_variable_get_initializer (local))) && VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
				ValaMethod* _tmp1;
				ValaMethod* m;
				ValaDelegateType* _tmp2;
				ValaDelegateType* dt;
				ValaDelegate* _tmp3;
				ValaDelegate* cb;
				_tmp1 = NULL;
				m = (_tmp1 = VALA_METHOD (vala_expression_get_symbol_reference (vala_local_variable_get_initializer (local))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
				_tmp2 = NULL;
				dt = (_tmp2 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
				_tmp3 = NULL;
				cb = (_tmp3 = vala_delegate_type_get_delegate_symbol (dt), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
				/* check whether method matches callback type */
				if (!vala_delegate_matches_method (cb, m)) {
					char* _tmp6;
					char* _tmp5;
					char* _tmp4;
					vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
					_tmp6 = NULL;
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), (_tmp6 = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", (_tmp4 = vala_symbol_get_full_name (((ValaSymbol*) (m)))), (_tmp5 = vala_symbol_get_full_name (((ValaSymbol*) (cb)))))));
					_tmp6 = (g_free (_tmp6), NULL);
					_tmp5 = (g_free (_tmp5), NULL);
					_tmp4 = (g_free (_tmp4), NULL);
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
					(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
					return;
				}
				vala_expression_set_value_type (vala_local_variable_get_initializer (local), vala_local_variable_get_variable_type (local));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
				(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
			} else {
				vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), "expression type not allowed as initializer");
				return;
			}
		}
		if (!vala_data_type_compatible (vala_expression_get_value_type (vala_local_variable_get_initializer (local)), vala_local_variable_get_variable_type (local))) {
			char* _tmp9;
			char* _tmp8;
			char* _tmp7;
			vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
			_tmp9 = NULL;
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), (_tmp9 = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", (_tmp7 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_local_variable_get_initializer (local)))))), (_tmp8 = vala_code_node_to_string (((ValaCodeNode*) (vala_local_variable_get_variable_type (local))))))));
			_tmp9 = (g_free (_tmp9), NULL);
			_tmp8 = (g_free (_tmp8), NULL);
			_tmp7 = (g_free (_tmp7), NULL);
			return;
		}
		if (vala_data_type_is_disposable (vala_expression_get_value_type (vala_local_variable_get_initializer (local)))) {
			/* rhs transfers ownership of the expression */
			if (!(VALA_IS_POINTER_TYPE (vala_local_variable_get_variable_type (local))) && !vala_data_type_get_value_owned (vala_local_variable_get_variable_type (local))) {
				/* lhs doesn't own the value */
				vala_code_node_set_error (((ValaCodeNode*) (local)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (local))), "Invalid assignment from owned expression to unowned variable");
				return;
			}
		}
	}
	vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_local_variable_get_variable_type (local), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	vala_scope_add (vala_symbol_get_scope (self->priv->_current_symbol), vala_symbol_get_name (((ValaSymbol*) (local))), ((ValaSymbol*) (local)));
	_tmp10 = NULL;
	block = (_tmp10 = VALA_BLOCK (self->priv->_current_symbol), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10)));
	vala_block_add_local_variable (block, local);
	vala_symbol_set_active (((ValaSymbol*) (local)), TRUE);
	(block == NULL ? NULL : (block = (vala_code_node_unref (block), NULL)));
}


/**
 * Visit operation called for initializer lists
 *
 * @param list an initializer list
 */
static void vala_semantic_analyzer_real_visit_initializer_list (ValaCodeVisitor* base, ValaInitializerList* list) {
	ValaSemanticAnalyzer * self;
	gboolean error;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (list != NULL);
	if (vala_expression_get_target_type (((ValaExpression*) (list))) == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (list)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (list))), "initializer list used for unknown type");
		return;
	} else {
		if (VALA_IS_ARRAY_TYPE (vala_expression_get_target_type (((ValaExpression*) (list))))) {
			ValaArrayType* _tmp0;
			ValaArrayType* array_type;
			/* initializer is used as array initializer */
			_tmp0 = NULL;
			array_type = (_tmp0 = VALA_ARRAY_TYPE (vala_expression_get_target_type (((ValaExpression*) (list)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
			{
				GeeList* e_collection;
				int e_it;
				e_collection = vala_initializer_list_get_initializers (list);
				for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
					ValaExpression* e;
					e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
					{
						ValaDataType* _tmp1;
						_tmp1 = NULL;
						vala_expression_set_target_type (e, (_tmp1 = vala_data_type_copy (vala_array_type_get_element_type (array_type))));
						(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
						(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
					}
				}
				(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
			}
			(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
		} else {
			if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type (((ValaExpression*) (list)))))) {
				ValaStruct* _tmp2;
				ValaStruct* st;
				GeeList* _tmp3;
				GeeIterator* _tmp4;
				GeeIterator* field_it;
				/* initializer is used as struct initializer */
				_tmp2 = NULL;
				st = (_tmp2 = VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_target_type (((ValaExpression*) (list))))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
				_tmp3 = NULL;
				_tmp4 = NULL;
				field_it = (_tmp4 = gee_iterable_iterator (((GeeIterable*) ((_tmp3 = vala_struct_get_fields (st))))), (_tmp3 == NULL ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL))), _tmp4);
				{
					GeeList* e_collection;
					int e_it;
					e_collection = vala_initializer_list_get_initializers (list);
					for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
						ValaExpression* e;
						e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
						{
							ValaField* field;
							ValaDataType* _tmp9;
							field = NULL;
							while (field == NULL) {
								ValaField* _tmp7;
								if (!gee_iterator_next (field_it)) {
									char* _tmp6;
									char* _tmp5;
									vala_code_node_set_error (((ValaCodeNode*) (list)), TRUE);
									_tmp6 = NULL;
									_tmp5 = NULL;
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), (_tmp6 = g_strdup_printf ("too many expressions in initializer list for `%s'", (_tmp5 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (((ValaExpression*) (list))))))))));
									_tmp6 = (g_free (_tmp6), NULL);
									_tmp5 = (g_free (_tmp5), NULL);
									(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
									(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
									(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
									(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
									(field_it == NULL ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL)));
									return;
								}
								_tmp7 = NULL;
								field = (_tmp7 = ((ValaField*) (gee_iterator_get (field_it))), (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp7);
								if (vala_field_get_binding (field) != MEMBER_BINDING_INSTANCE) {
									ValaField* _tmp8;
									/* we only initialize instance fields*/
									_tmp8 = NULL;
									field = (_tmp8 = NULL, (field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL))), _tmp8);
								}
							}
							_tmp9 = NULL;
							vala_expression_set_target_type (e, (_tmp9 = vala_data_type_copy (vala_field_get_field_type (field))));
							(_tmp9 == NULL ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL)));
							if (!vala_data_type_get_value_owned (vala_expression_get_target_type (((ValaExpression*) (list))))) {
								vala_data_type_set_value_owned (vala_expression_get_target_type (e), FALSE);
							}
							(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
							(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
						}
					}
					(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
				}
				(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
				(field_it == NULL ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL)));
			} else {
				char* _tmp11;
				char* _tmp10;
				vala_code_node_set_error (((ValaCodeNode*) (list)), TRUE);
				_tmp11 = NULL;
				_tmp10 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (list))), (_tmp11 = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", (_tmp10 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (((ValaExpression*) (list))))))))));
				_tmp11 = (g_free (_tmp11), NULL);
				_tmp10 = (g_free (_tmp10), NULL);
				return;
			}
		}
	}
	vala_code_node_accept_children (((ValaCodeNode*) (list)), ((ValaCodeVisitor*) (self)));
	error = FALSE;
	{
		GeeList* e_collection;
		int e_it;
		e_collection = vala_initializer_list_get_initializers (list);
		for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
			ValaExpression* e;
			e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
			{
				ValaUnaryExpression* _tmp13;
				ValaExpression* _tmp12;
				ValaUnaryExpression* unary;
				if (vala_expression_get_value_type (e) == NULL) {
					error = TRUE;
					(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
					continue;
				}
				_tmp13 = NULL;
				_tmp12 = NULL;
				unary = (_tmp13 = (_tmp12 = e, (VALA_IS_UNARY_EXPRESSION (_tmp12) ? ((ValaUnaryExpression*) (_tmp12)) : NULL)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13)));
				if (unary != NULL && (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF || vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT)) {
				} else {
					if (!vala_data_type_compatible (vala_expression_get_value_type (e), vala_expression_get_target_type (e))) {
						char* _tmp16;
						char* _tmp15;
						char* _tmp14;
						error = TRUE;
						vala_code_node_set_error (((ValaCodeNode*) (e)), TRUE);
						_tmp16 = NULL;
						_tmp15 = NULL;
						_tmp14 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), (_tmp16 = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", (_tmp14 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (e))))), (_tmp15 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (e))))))));
						_tmp16 = (g_free (_tmp16), NULL);
						_tmp15 = (g_free (_tmp15), NULL);
						_tmp14 = (g_free (_tmp14), NULL);
					}
				}
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
				(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
			}
		}
		(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
	}
	if (!error) {
		/* everything seems to be correct */
		vala_expression_set_value_type (((ValaExpression*) (list)), vala_expression_get_target_type (((ValaExpression*) (list))));
	}
}


static void vala_semantic_analyzer_real_visit_expression_statement (ValaCodeVisitor* base, ValaExpressionStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))))) {
		/* ignore inner error*/
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	_tmp0 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_expression_statement_get_expression (stmt))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
}


static void vala_semantic_analyzer_real_visit_if_statement (ValaCodeVisitor* base, ValaIfStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp0;
	GeeList* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_if_statement_get_condition (stmt))))) {
		/* if there was an error in the condition, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	if (!vala_data_type_compatible (vala_expression_get_value_type (vala_if_statement_get_condition (stmt)), self->priv->bool_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_if_statement_get_condition (stmt)))), "Condition must be boolean");
		return;
	}
	_tmp0 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_if_statement_get_condition (stmt))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp1 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_if_statement_get_true_statement (stmt))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)));
	if (vala_if_statement_get_false_statement (stmt) != NULL) {
		GeeList* _tmp2;
		_tmp2 = NULL;
		vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp2 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_if_statement_get_false_statement (stmt))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)));
	}
}


static void vala_semantic_analyzer_real_visit_switch_section (ValaCodeVisitor* base, ValaSwitchSection* section) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (section != NULL);
	{
		GeeList* label_collection;
		int label_it;
		label_collection = vala_switch_section_get_labels (section);
		for (label_it = 0; label_it < gee_collection_get_size (GEE_COLLECTION (label_collection)); label_it = label_it + 1) {
			ValaSwitchLabel* label;
			label = ((ValaSwitchLabel*) (gee_list_get (GEE_LIST (label_collection), label_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (label)), ((ValaCodeVisitor*) (self)));
				(label == NULL ? NULL : (label = (vala_code_node_unref (label), NULL)));
			}
		}
		(label_collection == NULL ? NULL : (label_collection = (gee_collection_object_unref (label_collection), NULL)));
	}
	vala_symbol_set_owner (((ValaSymbol*) (section)), vala_symbol_get_scope (self->priv->_current_symbol));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (section)));
	{
		GeeList* st_collection;
		int st_it;
		st_collection = vala_block_get_statements (((ValaBlock*) (section)));
		for (st_it = 0; st_it < gee_collection_get_size (GEE_COLLECTION (st_collection)); st_it = st_it + 1) {
			ValaStatement* st;
			st = ((ValaStatement*) (gee_list_get (GEE_LIST (st_collection), st_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (st)), ((ValaCodeVisitor*) (self)));
				(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
			}
		}
		(st_collection == NULL ? NULL : (st_collection = (gee_collection_object_unref (st_collection), NULL)));
	}
	{
		GeeList* local_collection;
		int local_it;
		local_collection = vala_block_get_local_variables (((ValaBlock*) (section)));
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				vala_symbol_set_active (((ValaSymbol*) (local)), FALSE);
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
		(local_collection == NULL ? NULL : (local_collection = (gee_collection_object_unref (local_collection), NULL)));
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
}


static void vala_semantic_analyzer_real_visit_while_statement (ValaCodeVisitor* base, ValaWhileStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp0;
	GeeList* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_while_statement_get_condition (stmt))))) {
		/* if there was an error in the condition, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	if (!vala_data_type_compatible (vala_expression_get_value_type (vala_while_statement_get_condition (stmt)), self->priv->bool_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_while_statement_get_condition (stmt)))), "Condition must be boolean");
		return;
	}
	_tmp0 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_while_statement_get_condition (stmt))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp1 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_while_statement_get_body (stmt))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)));
}


static void vala_semantic_analyzer_real_visit_do_statement (ValaCodeVisitor* base, ValaDoStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp0;
	GeeList* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_do_statement_get_condition (stmt))))) {
		/* if there was an error in the condition, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	if (!vala_data_type_compatible (vala_expression_get_value_type (vala_do_statement_get_condition (stmt)), self->priv->bool_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_do_statement_get_condition (stmt)))), "Condition must be boolean");
		return;
	}
	_tmp0 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_do_statement_get_condition (stmt))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp1 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_do_statement_get_body (stmt))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)));
}


static void vala_semantic_analyzer_real_visit_for_statement (ValaCodeVisitor* base, ValaForStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_for_statement_get_condition (stmt) != NULL && vala_code_node_get_error (((ValaCodeNode*) (vala_for_statement_get_condition (stmt))))) {
		/* if there was an error in the condition, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	if (vala_for_statement_get_condition (stmt) != NULL && !vala_data_type_compatible (vala_expression_get_value_type (vala_for_statement_get_condition (stmt)), self->priv->bool_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_for_statement_get_condition (stmt)))), "Condition must be boolean");
		return;
	}
	if (vala_for_statement_get_condition (stmt) != NULL) {
		GeeList* _tmp0;
		_tmp0 = NULL;
		vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp0 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_for_statement_get_condition (stmt))))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)));
	}
	_tmp1 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp1 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_for_statement_get_body (stmt))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL)));
	{
		GeeList* exp_collection;
		int exp_it;
		exp_collection = vala_for_statement_get_initializer (stmt);
		for (exp_it = 0; exp_it < gee_collection_get_size (GEE_COLLECTION (exp_collection)); exp_it = exp_it + 1) {
			ValaExpression* exp;
			exp = ((ValaExpression*) (gee_list_get (GEE_LIST (exp_collection), exp_it)));
			{
				GeeList* _tmp2;
				_tmp2 = NULL;
				vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp2 = vala_code_node_get_error_types (((ValaCodeNode*) (exp)))));
				(_tmp2 == NULL ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)));
				(exp == NULL ? NULL : (exp = (vala_code_node_unref (exp), NULL)));
			}
		}
		(exp_collection == NULL ? NULL : (exp_collection = (gee_collection_object_unref (exp_collection), NULL)));
	}
	{
		GeeList* exp_collection;
		int exp_it;
		exp_collection = vala_for_statement_get_iterator (stmt);
		for (exp_it = 0; exp_it < gee_collection_get_size (GEE_COLLECTION (exp_collection)); exp_it = exp_it + 1) {
			ValaExpression* exp;
			exp = ((ValaExpression*) (gee_list_get (GEE_LIST (exp_collection), exp_it)));
			{
				GeeList* _tmp3;
				_tmp3 = NULL;
				vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp3 = vala_code_node_get_error_types (((ValaCodeNode*) (exp)))));
				(_tmp3 == NULL ? NULL : (_tmp3 = (gee_collection_object_unref (_tmp3), NULL)));
				(exp == NULL ? NULL : (exp = (vala_code_node_unref (exp), NULL)));
			}
		}
		(exp_collection == NULL ? NULL : (exp_collection = (gee_collection_object_unref (exp_collection), NULL)));
	}
}


static void vala_semantic_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base, ValaForeachStatement* stmt) {
	ValaSemanticAnalyzer * self;
	ValaDataType* collection_type;
	ValaDataType* _tmp0;
	ValaDataType* element_data_type;
	gboolean element_owned;
	ValaLocalVariable* _tmp23;
	ValaLocalVariable* _tmp25;
	char* _tmp24;
	GeeList* _tmp26;
	GeeList* _tmp27;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	/* analyze collection expression first, used for type inference*/
	vala_code_node_accept (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))))) {
		/* ignore inner error*/
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	} else {
		if (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)) == NULL) {
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt)))), "invalid collection expression");
			vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
			return;
		}
	}
	collection_type = vala_data_type_copy (vala_expression_get_value_type (vala_foreach_statement_get_collection (stmt)));
	_tmp0 = NULL;
	vala_expression_set_target_type (vala_foreach_statement_get_collection (stmt), (_tmp0 = vala_data_type_copy (collection_type)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	element_data_type = NULL;
	element_owned = FALSE;
	if (vala_data_type_is_array (collection_type)) {
		ValaArrayType* _tmp1;
		ValaArrayType* array_type;
		ValaDataType* _tmp3;
		ValaDataType* _tmp2;
		_tmp1 = NULL;
		array_type = (_tmp1 = VALA_ARRAY_TYPE (collection_type), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		_tmp3 = NULL;
		_tmp2 = NULL;
		element_data_type = (_tmp3 = (_tmp2 = vala_array_type_get_element_type (array_type), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL))), _tmp3);
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (vala_data_type_compatible (collection_type, self->priv->glist_type) || vala_data_type_compatible (collection_type, self->priv->gslist_type)) {
			GeeList* _tmp4;
			gboolean _tmp5;
			_tmp4 = NULL;
			if ((_tmp5 = gee_collection_get_size (((GeeCollection*) ((_tmp4 = vala_data_type_get_type_arguments (collection_type))))) > 0, (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5)) {
				ValaDataType* _tmp7;
				GeeList* _tmp6;
				_tmp7 = NULL;
				_tmp6 = NULL;
				element_data_type = (_tmp7 = VALA_DATA_TYPE (((ValaDataType*) (gee_list_get ((_tmp6 = vala_data_type_get_type_arguments (collection_type)), 0)))), (element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL))), _tmp7);
				(_tmp6 == NULL ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)));
			}
		} else {
			if (self->priv->iterable_type != NULL && vala_data_type_compatible (collection_type, self->priv->iterable_type)) {
				ValaObjectType* _tmp8;
				gboolean _tmp9;
				ValaMethod* it_method;
				GeeList* _tmp12;
				gboolean _tmp13;
				element_owned = TRUE;
				_tmp8 = NULL;
				if ((_tmp9 = self->priv->list_type == NULL || !vala_data_type_compatible (collection_type, ((ValaDataType*) ((_tmp8 = vala_object_type_new (((ValaObjectTypeSymbol*) (self->priv->list_type))))))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL))), _tmp9)) {
					ValaObjectType* foreach_iterator_type;
					ValaLocalVariable* _tmp11;
					char* _tmp10;
					/* don't use iterator objects for lists for performance reasons*/
					foreach_iterator_type = vala_object_type_new (((ValaObjectTypeSymbol*) (self->priv->iterator_type)));
					vala_data_type_set_value_owned (((ValaDataType*) (foreach_iterator_type)), TRUE);
					vala_data_type_add_type_argument (((ValaDataType*) (foreach_iterator_type)), vala_foreach_statement_get_type_reference (stmt));
					_tmp11 = NULL;
					_tmp10 = NULL;
					vala_foreach_statement_set_iterator_variable (stmt, (_tmp11 = vala_local_variable_new (((ValaDataType*) (foreach_iterator_type)), (_tmp10 = g_strdup_printf ("%s_it", vala_foreach_statement_get_variable_name (stmt))), NULL, NULL)));
					(_tmp11 == NULL ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL)));
					_tmp10 = (g_free (_tmp10), NULL);
					vala_block_add_local_variable (((ValaBlock*) (stmt)), vala_foreach_statement_get_iterator_variable (stmt));
					vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_iterator_variable (stmt))), TRUE);
					(foreach_iterator_type == NULL ? NULL : (foreach_iterator_type = (vala_code_node_unref (foreach_iterator_type), NULL)));
				}
				it_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (vala_data_type_get_data_type (self->priv->iterable_type)))), "iterator"));
				_tmp12 = NULL;
				if ((_tmp13 = gee_collection_get_size (((GeeCollection*) ((_tmp12 = vala_data_type_get_type_arguments (vala_method_get_return_type (it_method)))))) > 0, (_tmp12 == NULL ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL))), _tmp13)) {
					GeeList* _tmp14;
					ValaDataType* _tmp15;
					ValaDataType* type_arg;
					_tmp14 = NULL;
					_tmp15 = NULL;
					type_arg = (_tmp15 = ((ValaDataType*) (gee_list_get ((_tmp14 = vala_data_type_get_type_arguments (vala_method_get_return_type (it_method))), 0))), (_tmp14 == NULL ? NULL : (_tmp14 = (gee_collection_object_unref (_tmp14), NULL))), _tmp15);
					if (vala_data_type_get_type_parameter (type_arg) != NULL) {
						ValaDataType* _tmp16;
						_tmp16 = NULL;
						element_data_type = (_tmp16 = vala_semantic_analyzer_get_actual_type (collection_type, ((ValaSymbol*) (it_method)), type_arg, ((ValaCodeNode*) (stmt))), (element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL))), _tmp16);
					} else {
						ValaDataType* _tmp18;
						ValaDataType* _tmp17;
						_tmp18 = NULL;
						_tmp17 = NULL;
						element_data_type = (_tmp18 = (_tmp17 = type_arg, (_tmp17 == NULL ? NULL : vala_code_node_ref (_tmp17))), (element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL))), _tmp18);
					}
					(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
				}
				(it_method == NULL ? NULL : (it_method = (vala_code_node_unref (it_method), NULL)));
			} else {
				vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Gee.List not iterable");
				(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
				(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
				return;
			}
		}
	}
	if (element_data_type == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt)))), "missing type argument for collection");
		(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
		(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
		return;
	}
	/* analyze element type*/
	if (vala_foreach_statement_get_type_reference (stmt) == NULL) {
		ValaDataType* _tmp19;
		/* var type*/
		_tmp19 = NULL;
		vala_foreach_statement_set_type_reference (stmt, (_tmp19 = vala_data_type_copy (element_data_type)));
		(_tmp19 == NULL ? NULL : (_tmp19 = (vala_code_node_unref (_tmp19), NULL)));
	} else {
		if (!vala_data_type_compatible (element_data_type, vala_foreach_statement_get_type_reference (stmt))) {
			char* _tmp22;
			char* _tmp21;
			char* _tmp20;
			vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
			_tmp22 = NULL;
			_tmp21 = NULL;
			_tmp20 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), (_tmp22 = g_strdup_printf ("Foreach: Cannot convert from `%s' to `%s'", (_tmp20 = vala_code_node_to_string (((ValaCodeNode*) (element_data_type)))), (_tmp21 = vala_code_node_to_string (((ValaCodeNode*) (vala_foreach_statement_get_type_reference (stmt))))))));
			_tmp22 = (g_free (_tmp22), NULL);
			_tmp21 = (g_free (_tmp21), NULL);
			_tmp20 = (g_free (_tmp20), NULL);
			(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
			(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
			return;
		} else {
			if (vala_data_type_is_disposable (element_data_type) && element_owned && !vala_data_type_get_value_owned (vala_foreach_statement_get_type_reference (stmt))) {
				vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Foreach: Invalid assignment from owned expression to unowned variable");
				(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
				(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
				return;
			}
		}
	}
	vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_foreach_statement_get_type_reference (stmt), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	_tmp23 = NULL;
	vala_foreach_statement_set_element_variable (stmt, (_tmp23 = vala_local_variable_new (vala_foreach_statement_get_type_reference (stmt), vala_foreach_statement_get_variable_name (stmt), NULL, NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_code_node_unref (_tmp23), NULL)));
	vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_foreach_statement_get_body (stmt)))), vala_foreach_statement_get_variable_name (stmt), ((ValaSymbol*) (vala_foreach_statement_get_element_variable (stmt))));
	vala_block_add_local_variable (vala_foreach_statement_get_body (stmt), vala_foreach_statement_get_element_variable (stmt));
	vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_element_variable (stmt))), TRUE);
	/* analyze body*/
	vala_symbol_set_owner (((ValaSymbol*) (stmt)), vala_symbol_get_scope (self->priv->_current_symbol));
	vala_semantic_analyzer_set_current_symbol (self, ((ValaSymbol*) (stmt)));
	vala_code_node_accept (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt))), ((ValaCodeVisitor*) (self)));
	{
		GeeList* local_collection;
		int local_it;
		local_collection = vala_block_get_local_variables (((ValaBlock*) (stmt)));
		for (local_it = 0; local_it < gee_collection_get_size (GEE_COLLECTION (local_collection)); local_it = local_it + 1) {
			ValaLocalVariable* local;
			local = ((ValaLocalVariable*) (gee_list_get (GEE_LIST (local_collection), local_it)));
			{
				vala_symbol_set_active (((ValaSymbol*) (local)), FALSE);
				(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
			}
		}
		(local_collection == NULL ? NULL : (local_collection = (gee_collection_object_unref (local_collection), NULL)));
	}
	vala_semantic_analyzer_set_current_symbol (self, vala_symbol_get_parent_symbol (self->priv->_current_symbol));
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_foreach_statement_set_collection_variable (stmt, (_tmp25 = vala_local_variable_new (collection_type, (_tmp24 = g_strdup_printf ("%s_collection", vala_foreach_statement_get_variable_name (stmt))), NULL, NULL)));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_code_node_unref (_tmp25), NULL)));
	_tmp24 = (g_free (_tmp24), NULL);
	vala_block_add_local_variable (((ValaBlock*) (stmt)), vala_foreach_statement_get_collection_variable (stmt));
	vala_symbol_set_active (((ValaSymbol*) (vala_foreach_statement_get_collection_variable (stmt))), TRUE);
	_tmp26 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp26 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_foreach_statement_get_collection (stmt))))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (gee_collection_object_unref (_tmp26), NULL)));
	_tmp27 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp27 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_foreach_statement_get_body (stmt))))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (gee_collection_object_unref (_tmp27), NULL)));
	(collection_type == NULL ? NULL : (collection_type = (vala_code_node_unref (collection_type), NULL)));
	(element_data_type == NULL ? NULL : (element_data_type = (vala_code_node_unref (element_data_type), NULL)));
}


static void vala_semantic_analyzer_real_visit_return_statement (ValaCodeVisitor* base, ValaReturnStatement* stmt) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp5;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		vala_expression_set_target_type (vala_return_statement_get_return_expression (stmt), self->priv->current_return_type);
	}
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_return_statement_get_return_expression (stmt) != NULL && vala_code_node_get_error (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))))) {
		/* ignore inner error*/
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		return;
	}
	if (self->priv->current_return_type == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Return not allowed in this context");
		return;
	}
	if (vala_return_statement_get_return_expression (stmt) == NULL) {
		if (VALA_IS_VOID_TYPE (self->priv->current_return_type)) {
			return;
		} else {
			vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Return without value in non-void function");
			return;
		}
	}
	if (VALA_IS_VOID_TYPE (self->priv->current_return_type)) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Return with value in void function");
		return;
	}
	if (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)) == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Invalid expression in return value");
		return;
	}
	if (!vala_data_type_compatible (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)), self->priv->current_return_type)) {
		char* _tmp2;
		char* _tmp1;
		char* _tmp0;
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), (_tmp2 = g_strdup_printf ("Return: Cannot convert from `%s' to `%s'", (_tmp0 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt)))))), (_tmp1 = vala_code_node_to_string (((ValaCodeNode*) (self->priv->current_return_type)))))));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp1 = (g_free (_tmp1), NULL);
		_tmp0 = (g_free (_tmp0), NULL);
		return;
	}
	if (vala_data_type_is_disposable (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt))) && !vala_data_type_get_value_owned (self->priv->current_return_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Return value transfers ownership but method return type hasn't been declared to transfer ownership");
		return;
	}
	if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_return_statement_get_return_expression (stmt))) && vala_data_type_is_disposable (vala_expression_get_value_type (vala_return_statement_get_return_expression (stmt))) && !vala_data_type_get_value_owned (self->priv->current_return_type)) {
		vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), "Local variable with strong reference used as return value and method return type hasn't been declared to transfer ownership");
	}
	if (vala_code_context_get_non_null (self->priv->_context) && VALA_IS_NULL_LITERAL (vala_return_statement_get_return_expression (stmt)) && !vala_data_type_get_nullable (self->priv->current_return_type)) {
		char* _tmp4;
		char* _tmp3;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), (_tmp4 = g_strdup_printf ("`null' incompatible with return type `%s`", (_tmp3 = vala_code_node_to_string (((ValaCodeNode*) (self->priv->current_return_type)))))));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
	}
	_tmp5 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (stmt)), (_tmp5 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_return_statement_get_return_expression (stmt))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (gee_collection_object_unref (_tmp5), NULL)));
}


static void vala_semantic_analyzer_real_visit_yield_statement (ValaCodeVisitor* base, ValaYieldStatement* stmt) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_check (((ValaCodeNode*) (stmt)), self);
}


static void vala_semantic_analyzer_real_visit_throw_statement (ValaCodeVisitor* base, ValaThrowStatement* stmt) {
	ValaSemanticAnalyzer * self;
	ValaErrorType* _tmp0;
	ValaDataType* error_type;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	_tmp0 = NULL;
	vala_expression_set_target_type (vala_throw_statement_get_error_expression (stmt), ((ValaDataType*) ((_tmp0 = vala_error_type_new (NULL, NULL, vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	vala_data_type_set_value_owned (vala_expression_get_target_type (vala_throw_statement_get_error_expression (stmt)), TRUE);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	error_type = vala_data_type_copy (vala_expression_get_value_type (vala_throw_statement_get_error_expression (stmt)));
	vala_code_node_set_source_reference (((ValaCodeNode*) (error_type)), vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))));
	vala_code_node_add_error_type (((ValaCodeNode*) (stmt)), error_type);
	(error_type == NULL ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)));
}


static void vala_semantic_analyzer_real_visit_try_statement (ValaCodeVisitor* base, ValaTryStatement* stmt) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_catch_clause (ValaCodeVisitor* base, ValaCatchClause* clause) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (clause != NULL);
	if (vala_catch_clause_get_error_type (clause) != NULL) {
		ValaLocalVariable* _tmp1;
		ValaDataType* _tmp0;
		vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_catch_clause_get_error_type (clause), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_catch_clause_set_error_variable (clause, (_tmp1 = vala_local_variable_new ((_tmp0 = vala_data_type_copy (vala_catch_clause_get_error_type (clause))), vala_catch_clause_get_variable_name (clause), NULL, NULL)));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
		vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_catch_clause_get_body (clause)))), vala_catch_clause_get_variable_name (clause), ((ValaSymbol*) (vala_catch_clause_get_error_variable (clause))));
		vala_block_add_local_variable (vala_catch_clause_get_body (clause), vala_catch_clause_get_error_variable (clause));
	} else {
		ValaErrorType* _tmp2;
		_tmp2 = NULL;
		vala_catch_clause_set_error_type (clause, ((ValaDataType*) ((_tmp2 = vala_error_type_new (NULL, NULL, vala_code_node_get_source_reference (((ValaCodeNode*) (clause))))))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (clause)), ((ValaCodeVisitor*) (self)));
}


static void vala_semantic_analyzer_real_visit_lock_statement (ValaCodeVisitor* base, ValaLockStatement* stmt) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	/* resource must be a member access and denote a Lockable */
	if (!(VALA_IS_MEMBER_ACCESS (vala_lock_statement_get_resource (stmt)) && VALA_IS_LOCKABLE (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))))) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_code_node_set_error (((ValaCodeNode*) (vala_lock_statement_get_resource (stmt))), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_lock_statement_get_resource (stmt)))), "Expression is either not a member access or does not denote a lockable member");
		return;
	}
	/* parent symbol must be the current class */
	if (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt))) != VALA_SYMBOL (self->priv->current_class)) {
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		vala_code_node_set_error (((ValaCodeNode*) (vala_lock_statement_get_resource (stmt))), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_lock_statement_get_resource (stmt)))), "Only members of the current class are lockable");
	}
	vala_lockable_set_lock_used ((VALA_LOCKABLE (vala_expression_get_symbol_reference (vala_lock_statement_get_resource (stmt)))), TRUE);
}


static void vala_semantic_analyzer_real_visit_delete_statement (ValaCodeVisitor* base, ValaDeleteStatement* stmt) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children (((ValaCodeNode*) (stmt)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_delete_statement_get_expression (stmt))))) {
		/* if there was an error in the inner expression, skip this check*/
		return;
	}
	if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt))))) {
		char* _tmp1;
		char* _tmp0;
		vala_code_node_set_error (((ValaCodeNode*) (stmt)), TRUE);
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (stmt))), (_tmp1 = g_strdup_printf ("delete operator not supported for `%s'", (_tmp0 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_delete_statement_get_expression (stmt)))))))));
		_tmp1 = (g_free (_tmp1), NULL);
		_tmp0 = (g_free (_tmp0), NULL);
	}
}


static gint vala_semantic_analyzer_create_sizes_from_initializer_list (ValaSemanticAnalyzer* self, ValaInitializerList* il, gint rank, GeeList* sl) {
	char* _tmp0;
	ValaIntegerLiteral* _tmp1;
	ValaIntegerLiteral* init;
	gint subsize;
	gint _tmp7;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (il != NULL, 0);
	g_return_val_if_fail (sl != NULL, 0);
	_tmp0 = NULL;
	_tmp1 = NULL;
	init = (_tmp1 = vala_integer_literal_new ((_tmp0 = g_strdup_printf ("%i", vala_initializer_list_get_size (il))), vala_code_node_get_source_reference (((ValaCodeNode*) (il)))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	vala_code_node_accept (((ValaCodeNode*) (init)), ((ValaCodeVisitor*) (self)));
	gee_collection_add (((GeeCollection*) (sl)), ((ValaLiteral*) (init)));
	subsize = -1;
	{
		GeeList* e_collection;
		int e_it;
		e_collection = vala_initializer_list_get_initializers (il);
		for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
			ValaExpression* e;
			e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
			{
				if (VALA_IS_INITIALIZER_LIST (e)) {
					gint size;
					if (rank == 1) {
						gint _tmp2;
						vala_code_node_set_error (((ValaCodeNode*) (il)), TRUE);
						vala_code_node_set_error (((ValaCodeNode*) (e)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), "Expected array element, got array initializer list");
						return (_tmp2 = -1, (e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL))), (e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL))), (init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL))), _tmp2);
					}
					size = vala_semantic_analyzer_create_sizes_from_initializer_list (self, VALA_INITIALIZER_LIST (e), rank - 1, sl);
					if (size == -1) {
						gint _tmp3;
						return (_tmp3 = -1, (e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL))), (e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL))), (init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL))), _tmp3);
					}
					if (subsize >= 0 && subsize != size) {
						char* _tmp4;
						gint _tmp5;
						vala_code_node_set_error (((ValaCodeNode*) (il)), TRUE);
						_tmp4 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (il))), (_tmp4 = g_strdup_printf ("Expected initializer list of size %d, got size %d", subsize, size)));
						_tmp4 = (g_free (_tmp4), NULL);
						return (_tmp5 = -1, (e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL))), (e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL))), (init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL))), _tmp5);
					} else {
						subsize = size;
					}
				} else {
					if (rank != 1) {
						gint _tmp6;
						vala_code_node_set_error (((ValaCodeNode*) (il)), TRUE);
						vala_code_node_set_error (((ValaCodeNode*) (e)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), "Expected array initializer list, got array element");
						return (_tmp6 = -1, (e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL))), (e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL))), (init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL))), _tmp6);
					}
				}
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
			}
		}
		(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
	}
	return (_tmp7 = vala_initializer_list_get_size (il), (init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL))), _tmp7);
}


/**
 * Visit operations called for array creation expresions.
 *
 * @param expr an array creation expression
 */
static void vala_semantic_analyzer_real_visit_array_creation_expression (ValaCodeVisitor* base, ValaArrayCreationExpression* expr) {
	ValaSemanticAnalyzer * self;
	GeeList* size;
	ValaInitializerList* _tmp0;
	ValaInitializerList* initlist;
	GeeArrayList* calc_sizes;
	ValaArrayType* _tmp2;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	size = vala_array_creation_expression_get_sizes (expr);
	_tmp0 = NULL;
	initlist = (_tmp0 = vala_array_creation_expression_get_initializer_list (expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (vala_array_creation_expression_get_element_type (expr) != NULL) {
		vala_code_node_accept (((ValaCodeNode*) (vala_array_creation_expression_get_element_type (expr))), ((ValaCodeVisitor*) (self)));
	}
	{
		GeeList* e_collection;
		int e_it;
		e_collection = size;
		for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
			ValaExpression* e;
			e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (e)), ((ValaCodeVisitor*) (self)));
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
			}
		}
	}
	calc_sizes = gee_array_list_new (VALA_TYPE_LITERAL, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
	if (initlist != NULL) {
		ValaArrayType* _tmp1;
		gint ret;
		_tmp1 = NULL;
		vala_expression_set_target_type (((ValaExpression*) (initlist)), ((ValaDataType*) ((_tmp1 = vala_array_type_new (vala_array_creation_expression_get_element_type (expr), vala_array_creation_expression_get_rank (expr), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
		vala_code_node_accept (((ValaCodeNode*) (initlist)), ((ValaCodeVisitor*) (self)));
		ret = vala_semantic_analyzer_create_sizes_from_initializer_list (self, initlist, vala_array_creation_expression_get_rank (expr), ((GeeList*) (calc_sizes)));
		if (ret == -1) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		}
	}
	if (gee_collection_get_size (((GeeCollection*) (size))) > 0) {
		/* check for errors in the size list */
		{
			GeeList* e_collection;
			int e_it;
			e_collection = size;
			for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
				ValaExpression* e;
				e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
				{
					if (vala_expression_get_value_type (e) == NULL) {
						/* return on previous error */
						(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
						(size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL)));
						(initlist == NULL ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)));
						(calc_sizes == NULL ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)));
						return;
					} else {
						if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_value_type (e)))) || !vala_struct_is_integer_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_value_type (e)))))) {
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), "Expression of integer type expected");
						}
					}
					(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
				}
			}
		}
	} else {
		if (initlist == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			/* this is an internal error because it is already handeld by the parser */
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "internal error: initializer list expected");
		} else {
			{
				GeeArrayList* size_collection;
				int size_it;
				size_collection = calc_sizes;
				for (size_it = 0; size_it < gee_collection_get_size (GEE_COLLECTION (size_collection)); size_it = size_it + 1) {
					ValaExpression* size;
					size = ((ValaExpression*) (((ValaExpression*) (gee_list_get (GEE_LIST (size_collection), size_it)))));
					{
						vala_array_creation_expression_append_size (expr, size);
						(size == NULL ? NULL : (size = (vala_code_node_unref (size), NULL)));
					}
				}
			}
		}
	}
	if (vala_code_node_get_error (((ValaCodeNode*) (expr)))) {
		(size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL)));
		(initlist == NULL ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)));
		(calc_sizes == NULL ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)));
		return;
	}
	/* check for wrong elements inside the initializer */
	if (vala_array_creation_expression_get_initializer_list (expr) != NULL && vala_expression_get_value_type (((ValaExpression*) (vala_array_creation_expression_get_initializer_list (expr)))) == NULL) {
		(size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL)));
		(initlist == NULL ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)));
		(calc_sizes == NULL ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)));
		return;
	}
	/* try to construct the type of the array */
	if (vala_array_creation_expression_get_element_type (expr) == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Cannot determine the element type of the created array");
		(size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL)));
		(initlist == NULL ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)));
		(calc_sizes == NULL ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)));
		return;
	}
	vala_data_type_set_value_owned (vala_array_creation_expression_get_element_type (expr), TRUE);
	_tmp2 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp2 = vala_array_type_new (vala_array_creation_expression_get_element_type (expr), vala_array_creation_expression_get_rank (expr), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE);
	(size == NULL ? NULL : (size = (gee_collection_object_unref (size), NULL)));
	(initlist == NULL ? NULL : (initlist = (vala_code_node_unref (initlist), NULL)));
	(calc_sizes == NULL ? NULL : (calc_sizes = (gee_collection_object_unref (calc_sizes), NULL)));
}


static void vala_semantic_analyzer_real_visit_boolean_literal (ValaCodeVisitor* base, ValaBooleanLiteral* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
}


static void vala_semantic_analyzer_real_visit_character_literal (ValaCodeVisitor* base, ValaCharacterLiteral* expr) {
	ValaSemanticAnalyzer * self;
	ValaValueType* _tmp1;
	ValaTypeSymbol* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp1 = vala_value_type_new ((_tmp0 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), "char"))))))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
}


static void vala_semantic_analyzer_real_visit_integer_literal (ValaCodeVisitor* base, ValaIntegerLiteral* expr) {
	ValaSemanticAnalyzer * self;
	ValaIntegerType* _tmp3;
	char* _tmp2;
	ValaTypeSymbol* _tmp1;
	char* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	_tmp3 = NULL;
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp3 = vala_integer_type_new ((_tmp1 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), (_tmp0 = vala_integer_literal_get_type_name (expr))))), vala_integer_literal_get_value (expr), (_tmp2 = vala_integer_literal_get_type_name (expr)))))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)));
	_tmp2 = (g_free (_tmp2), NULL);
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
	_tmp0 = (g_free (_tmp0), NULL);
}


static void vala_semantic_analyzer_real_visit_real_literal (ValaCodeVisitor* base, ValaRealLiteral* expr) {
	ValaSemanticAnalyzer * self;
	ValaValueType* _tmp2;
	ValaTypeSymbol* _tmp1;
	char* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp2 = vala_value_type_new ((_tmp1 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), (_tmp0 = vala_real_literal_get_type_name (expr))))))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
	_tmp0 = (g_free (_tmp0), NULL);
}


static void vala_semantic_analyzer_real_visit_string_literal (ValaCodeVisitor* base, ValaStringLiteral* expr) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp0 = vala_data_type_copy (self->priv->string_type)));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
}


static void vala_semantic_analyzer_real_visit_null_literal (ValaCodeVisitor* base, ValaNullLiteral* expr) {
	ValaSemanticAnalyzer * self;
	ValaNullType* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp0 = vala_null_type_new (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
}


static ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (VALA_IS_FIELD (sym)) {
		ValaField* _tmp0;
		ValaField* f;
		ValaDataType* type;
		ValaDataType* _tmp1;
		_tmp0 = NULL;
		f = (_tmp0 = VALA_FIELD (sym), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		type = vala_data_type_copy (vala_field_get_field_type (f));
		if (!lvalue) {
			vala_data_type_set_value_owned (type, FALSE);
		}
		_tmp1 = NULL;
		return (_tmp1 = type, (f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL))), _tmp1);
	} else {
		if (VALA_IS_CONSTANT (sym)) {
			ValaConstant* _tmp2;
			ValaConstant* c;
			ValaDataType* _tmp3;
			ValaDataType* _tmp4;
			_tmp2 = NULL;
			c = (_tmp2 = VALA_CONSTANT (sym), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = vala_constant_get_type_reference (c), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3))), (c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL))), _tmp4);
		} else {
			if (VALA_IS_PROPERTY (sym)) {
				ValaProperty* _tmp5;
				ValaProperty* prop;
				_tmp5 = NULL;
				prop = (_tmp5 = VALA_PROPERTY (sym), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
				if (vala_property_get_property_type (prop) != NULL) {
					ValaDataType* type;
					ValaDataType* _tmp6;
					type = vala_data_type_copy (vala_property_get_property_type (prop));
					vala_data_type_set_value_owned (type, FALSE);
					_tmp6 = NULL;
					return (_tmp6 = type, (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), _tmp6);
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
			} else {
				if (VALA_IS_FORMAL_PARAMETER (sym)) {
					ValaFormalParameter* _tmp7;
					ValaFormalParameter* p;
					ValaDataType* type;
					ValaDataType* _tmp8;
					_tmp7 = NULL;
					p = (_tmp7 = VALA_FORMAL_PARAMETER (sym), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
					type = vala_data_type_copy (vala_formal_parameter_get_parameter_type (p));
					if (!lvalue) {
						vala_data_type_set_value_owned (type, FALSE);
					}
					_tmp8 = NULL;
					return (_tmp8 = type, (p == NULL ? NULL : (p = (vala_code_node_unref (p), NULL))), _tmp8);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* _tmp9;
						ValaLocalVariable* local;
						ValaDataType* type;
						ValaDataType* _tmp10;
						_tmp9 = NULL;
						local = (_tmp9 = VALA_LOCAL_VARIABLE (sym), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
						type = vala_data_type_copy (vala_local_variable_get_variable_type (local));
						if (!lvalue) {
							vala_data_type_set_value_owned (type, FALSE);
						}
						_tmp10 = NULL;
						return (_tmp10 = type, (local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL))), _tmp10);
					} else {
						if (VALA_IS_ENUM_VALUE (sym)) {
							return ((ValaDataType*) (vala_value_type_new (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (sym)))));
						} else {
							if (VALA_IS_METHOD (sym)) {
								return ((ValaDataType*) (vala_method_type_new (VALA_METHOD (sym))));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									return ((ValaDataType*) (vala_signal_type_new (VALA_SIGNAL (sym))));
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name) {
	ValaSymbol* result;
	ValaSymbol* _tmp13;
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = vala_scope_lookup (vala_symbol_get_scope (sym), name);
	if (result != NULL) {
		return result;
	}
	if (VALA_IS_CLASS (sym)) {
		ValaClass* _tmp1;
		ValaClass* cl;
		_tmp1 = NULL;
		cl = (_tmp1 = VALA_CLASS (sym), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						ValaSymbol* _tmp2;
						_tmp2 = NULL;
						result = (_tmp2 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (vala_data_type_get_data_type (base_type)))), name), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp2);
						if (result != NULL) {
							ValaSymbol* _tmp3;
							_tmp3 = NULL;
							return (_tmp3 = result, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp3);
						}
					}
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
		}
		/* then check base class recursively*/
		if (vala_class_get_base_class (cl) != NULL) {
			ValaSymbol* _tmp4;
			_tmp4 = NULL;
			return (_tmp4 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (vala_class_get_base_class (cl))), name), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp4);
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* _tmp5;
			ValaStruct* st;
			_tmp5 = NULL;
			st = (_tmp5 = VALA_STRUCT (sym), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
			{
				GeeList* base_type_collection;
				int base_type_it;
				base_type_collection = vala_struct_get_base_types (st);
				for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
					ValaDataType* base_type;
					base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
					{
						ValaSymbol* _tmp6;
						_tmp6 = NULL;
						result = (_tmp6 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (vala_data_type_get_data_type (base_type))), name), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp6);
						if (result != NULL) {
							ValaSymbol* _tmp7;
							_tmp7 = NULL;
							return (_tmp7 = result, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), _tmp7);
						}
						(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					}
				}
				(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
			}
			(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				ValaInterface* _tmp8;
				ValaInterface* iface;
				_tmp8 = NULL;
				iface = (_tmp8 = VALA_INTERFACE (sym), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
				/* first check interface prerequisites recursively*/
				{
					GeeList* prerequisite_collection;
					int prerequisite_it;
					prerequisite_collection = vala_interface_get_prerequisites (iface);
					for (prerequisite_it = 0; prerequisite_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_collection)); prerequisite_it = prerequisite_it + 1) {
						ValaDataType* prerequisite;
						prerequisite = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_collection), prerequisite_it)));
						{
							if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
								ValaSymbol* _tmp9;
								_tmp9 = NULL;
								result = (_tmp9 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (vala_data_type_get_data_type (prerequisite))), name), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp9);
								if (result != NULL) {
									ValaSymbol* _tmp10;
									_tmp10 = NULL;
									return (_tmp10 = result, (prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL))), (prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp10);
								}
							}
							(prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)));
						}
					}
					(prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL)));
				}
				/* then check class prerequisite recursively*/
				{
					GeeList* prerequisite_collection;
					int prerequisite_it;
					prerequisite_collection = vala_interface_get_prerequisites (iface);
					for (prerequisite_it = 0; prerequisite_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_collection)); prerequisite_it = prerequisite_it + 1) {
						ValaDataType* prerequisite;
						prerequisite = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_collection), prerequisite_it)));
						{
							if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
								ValaSymbol* _tmp11;
								_tmp11 = NULL;
								result = (_tmp11 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (vala_data_type_get_data_type (prerequisite))), name), (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp11);
								if (result != NULL) {
									ValaSymbol* _tmp12;
									_tmp12 = NULL;
									return (_tmp12 = result, (prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL))), (prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), _tmp12);
								}
							}
							(prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)));
						}
					}
					(prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL)));
				}
				(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
			}
		}
	}
	_tmp13 = NULL;
	return (_tmp13 = NULL, (result == NULL ? NULL : (result = (vala_code_node_unref (result), NULL))), _tmp13);
}


static void vala_semantic_analyzer_real_visit_parenthesized_expression (ValaCodeVisitor* base, ValaParenthesizedExpression* expr) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp0;
	ValaDataType* _tmp1;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_target_type (vala_parenthesized_expression_get_inner (expr), vala_expression_get_target_type (((ValaExpression*) (expr))));
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_parenthesized_expression_get_inner (expr))))) {
		/* ignore inner error*/
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (vala_expression_get_value_type (vala_parenthesized_expression_get_inner (expr)) == NULL) {
		/* static type may be null for method references*/
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_parenthesized_expression_get_inner (expr)))), "Invalid expression type");
		return;
	}
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp0 = vala_data_type_copy (vala_expression_get_value_type (vala_parenthesized_expression_get_inner (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	/* don't call g_object_ref_sink on inner and outer expression*/
	vala_data_type_set_floating_reference (vala_expression_get_value_type (((ValaExpression*) (expr))), FALSE);
	/* don't transform expression twice*/
	_tmp1 = NULL;
	vala_expression_set_target_type (vala_parenthesized_expression_get_inner (expr), (_tmp1 = vala_data_type_copy (vala_expression_get_value_type (vala_parenthesized_expression_get_inner (expr)))));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
}


static void vala_semantic_analyzer_real_visit_member_access (ValaCodeVisitor* base, ValaMemberAccess* expr) {
	ValaSemanticAnalyzer * self;
	ValaSymbol* base_symbol;
	ValaFormalParameter* this_parameter;
	gboolean may_access_instance_members;
	ValaSymbol* _tmp56;
	ValaSymbol* member;
	ValaSymbolAccessibility access;
	gboolean instance;
	gboolean klass;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	vala_expression_set_symbol_reference (((ValaExpression*) (expr)), NULL);
	if (vala_member_access_get_qualified (expr)) {
		ValaSymbol* _tmp1;
		ValaSymbol* _tmp0;
		ValaSymbol* _tmp2;
		_tmp1 = NULL;
		_tmp0 = NULL;
		base_symbol = (_tmp1 = (_tmp0 = self->priv->root_symbol, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0))), (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp1);
		_tmp2 = NULL;
		vala_expression_set_symbol_reference (((ValaExpression*) (expr)), (_tmp2 = vala_scope_lookup (vala_symbol_get_scope (self->priv->root_symbol), vala_member_access_get_member_name (expr))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	} else {
		if (vala_member_access_get_inner (expr) == NULL) {
			ValaSymbol* _tmp4;
			ValaSymbol* _tmp3;
			ValaSymbol* _tmp5;
			ValaSymbol* sym;
			if (_vala_strcmp0 (vala_member_access_get_member_name (expr), "this") == 0) {
				if (!vala_semantic_analyzer_is_in_instance_method (self)) {
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "This access invalid outside of instance methods");
					(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
					(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
					return;
				}
			}
			_tmp4 = NULL;
			_tmp3 = NULL;
			base_symbol = (_tmp4 = (_tmp3 = self->priv->_current_symbol, (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3))), (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp4);
			_tmp5 = NULL;
			sym = (_tmp5 = self->priv->_current_symbol, (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
			while (sym != NULL && vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
				ValaSymbol* _tmp21;
				ValaSymbol* _tmp23;
				ValaSymbol* _tmp22;
				if (this_parameter == NULL) {
					if (VALA_IS_CREATION_METHOD (sym)) {
						ValaCreationMethod* _tmp6;
						ValaCreationMethod* cm;
						ValaFormalParameter* _tmp8;
						ValaFormalParameter* _tmp7;
						_tmp6 = NULL;
						cm = (_tmp6 = VALA_CREATION_METHOD (sym), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
						_tmp8 = NULL;
						_tmp7 = NULL;
						this_parameter = (_tmp8 = (_tmp7 = vala_method_get_this_parameter (((ValaMethod*) (cm))), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7))), (this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL))), _tmp8);
						may_access_instance_members = TRUE;
						(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
					} else {
						if (VALA_IS_PROPERTY (sym)) {
							ValaProperty* _tmp9;
							ValaProperty* prop;
							ValaFormalParameter* _tmp11;
							ValaFormalParameter* _tmp10;
							_tmp9 = NULL;
							prop = (_tmp9 = VALA_PROPERTY (sym), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
							_tmp11 = NULL;
							_tmp10 = NULL;
							this_parameter = (_tmp11 = (_tmp10 = vala_property_get_this_parameter (prop), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10))), (this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL))), _tmp11);
							may_access_instance_members = TRUE;
							(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						} else {
							if (VALA_IS_CONSTRUCTOR (sym)) {
								ValaConstructor* _tmp12;
								ValaConstructor* c;
								ValaFormalParameter* _tmp14;
								ValaFormalParameter* _tmp13;
								_tmp12 = NULL;
								c = (_tmp12 = VALA_CONSTRUCTOR (sym), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
								_tmp14 = NULL;
								_tmp13 = NULL;
								this_parameter = (_tmp14 = (_tmp13 = vala_constructor_get_this_parameter (c), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL))), _tmp14);
								may_access_instance_members = TRUE;
								(c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL)));
							} else {
								if (VALA_IS_DESTRUCTOR (sym)) {
									ValaDestructor* _tmp15;
									ValaDestructor* d;
									ValaFormalParameter* _tmp17;
									ValaFormalParameter* _tmp16;
									_tmp15 = NULL;
									d = (_tmp15 = VALA_DESTRUCTOR (sym), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
									_tmp17 = NULL;
									_tmp16 = NULL;
									this_parameter = (_tmp17 = (_tmp16 = vala_destructor_get_this_parameter (d), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16))), (this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL))), _tmp17);
									may_access_instance_members = TRUE;
									(d == NULL ? NULL : (d = (vala_code_node_unref (d), NULL)));
								} else {
									if (VALA_IS_METHOD (sym)) {
										ValaMethod* _tmp18;
										ValaMethod* m;
										ValaFormalParameter* _tmp20;
										ValaFormalParameter* _tmp19;
										_tmp18 = NULL;
										m = (_tmp18 = VALA_METHOD (sym), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
										_tmp20 = NULL;
										_tmp19 = NULL;
										this_parameter = (_tmp20 = (_tmp19 = vala_method_get_this_parameter (m), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19))), (this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL))), _tmp20);
										may_access_instance_members = (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE);
										(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
									}
								}
							}
						}
					}
				}
				_tmp21 = NULL;
				vala_expression_set_symbol_reference (((ValaExpression*) (expr)), (_tmp21 = vala_semantic_analyzer_symbol_lookup_inherited (sym, vala_member_access_get_member_name (expr))));
				(_tmp21 == NULL ? NULL : (_tmp21 = (vala_code_node_unref (_tmp21), NULL)));
				_tmp23 = NULL;
				_tmp22 = NULL;
				sym = (_tmp23 = (_tmp22 = vala_symbol_get_parent_symbol (sym), (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp23);
			}
			if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
				{
					GeeList* ns_collection;
					int ns_it;
					ns_collection = self->priv->current_using_directives;
					for (ns_it = 0; ns_it < gee_collection_get_size (GEE_COLLECTION (ns_collection)); ns_it = ns_it + 1) {
						ValaUsingDirective* ns;
						ns = ((ValaUsingDirective*) (gee_list_get (GEE_LIST (ns_collection), ns_it)));
						{
							ValaSymbol* local_sym;
							local_sym = vala_scope_lookup (vala_symbol_get_scope (vala_using_directive_get_namespace_symbol (ns)), vala_member_access_get_member_name (expr));
							if (local_sym != NULL) {
								if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) != NULL) {
									char* _tmp26;
									char* _tmp25;
									char* _tmp24;
									vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
									_tmp26 = NULL;
									_tmp25 = NULL;
									_tmp24 = NULL;
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp26 = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", vala_member_access_get_member_name (expr), (_tmp24 = vala_symbol_get_full_name (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))), (_tmp25 = vala_symbol_get_full_name (local_sym)))));
									_tmp26 = (g_free (_tmp26), NULL);
									_tmp25 = (g_free (_tmp25), NULL);
									_tmp24 = (g_free (_tmp24), NULL);
									(ns == NULL ? NULL : (ns = (vala_code_node_unref (ns), NULL)));
									(local_sym == NULL ? NULL : (local_sym = (vala_code_node_unref (local_sym), NULL)));
									(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
									(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
									(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
									return;
								}
								vala_expression_set_symbol_reference (((ValaExpression*) (expr)), local_sym);
							}
							(ns == NULL ? NULL : (ns = (vala_code_node_unref (ns), NULL)));
							(local_sym == NULL ? NULL : (local_sym = (vala_code_node_unref (local_sym), NULL)));
						}
					}
				}
			}
			(sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL)));
		} else {
			if (vala_code_node_get_error (((ValaCodeNode*) (vala_member_access_get_inner (expr))))) {
				/* if there was an error in the inner expression, skip this check */
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
				(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
				return;
			}
			if (vala_member_access_get_pointer_member_access (expr)) {
				ValaPointerType* _tmp28;
				ValaDataType* _tmp27;
				ValaPointerType* pointer_type;
				_tmp28 = NULL;
				_tmp27 = NULL;
				pointer_type = (_tmp28 = (_tmp27 = vala_expression_get_value_type (vala_member_access_get_inner (expr)), (VALA_IS_POINTER_TYPE (_tmp27) ? ((ValaPointerType*) (_tmp27)) : NULL)), (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28)));
				if (pointer_type != NULL && VALA_IS_VALUE_TYPE (vala_pointer_type_get_base_type (pointer_type))) {
					ValaPointerIndirection* _tmp29;
					/* transform foo->bar to (*foo).bar*/
					_tmp29 = NULL;
					vala_member_access_set_inner (expr, ((ValaExpression*) ((_tmp29 = vala_pointer_indirection_new (vala_member_access_get_inner (expr), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
					(_tmp29 == NULL ? NULL : (_tmp29 = (vala_code_node_unref (_tmp29), NULL)));
					vala_code_node_accept (((ValaCodeNode*) (vala_member_access_get_inner (expr))), ((ValaCodeVisitor*) (self)));
					vala_member_access_set_pointer_member_access (expr, FALSE);
				}
				(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
			}
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (expr))) {
				ValaMemberAccess* _tmp30;
				ValaMemberAccess* ma;
				_tmp30 = NULL;
				ma = (_tmp30 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (expr)), (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30)));
				if (vala_member_access_get_prototype_access (ma)) {
					char* _tmp32;
					char* _tmp31;
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					_tmp32 = NULL;
					_tmp31 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp32 = g_strdup_printf ("Access to instance member `%s' denied", (_tmp31 = vala_symbol_get_full_name (vala_expression_get_symbol_reference (vala_member_access_get_inner (expr)))))));
					_tmp32 = (g_free (_tmp32), NULL);
					_tmp31 = (g_free (_tmp31), NULL);
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
					(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
					return;
				}
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			}
			if (VALA_IS_MEMBER_ACCESS (vala_member_access_get_inner (expr)) || VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
				ValaSymbol* _tmp34;
				ValaSymbol* _tmp33;
				_tmp34 = NULL;
				_tmp33 = NULL;
				base_symbol = (_tmp34 = (_tmp33 = vala_expression_get_symbol_reference (vala_member_access_get_inner (expr)), (_tmp33 == NULL ? NULL : vala_code_node_ref (_tmp33))), (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp34);
				if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL && (VALA_IS_NAMESPACE (base_symbol) || VALA_IS_TYPESYMBOL (base_symbol))) {
					ValaSymbol* _tmp35;
					_tmp35 = NULL;
					vala_expression_set_symbol_reference (((ValaExpression*) (expr)), (_tmp35 = vala_scope_lookup (vala_symbol_get_scope (base_symbol), vala_member_access_get_member_name (expr))));
					(_tmp35 == NULL ? NULL : (_tmp35 = (vala_code_node_unref (_tmp35), NULL)));
					if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
						/* inner expression is base access
						 access to instance members of the base type possible*/
						may_access_instance_members = TRUE;
					}
				}
			}
			if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL && vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
				if (vala_member_access_get_pointer_member_access (expr)) {
					ValaSymbol* _tmp36;
					_tmp36 = NULL;
					vala_expression_set_symbol_reference (((ValaExpression*) (expr)), (_tmp36 = vala_data_type_get_pointer_member (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr))));
					(_tmp36 == NULL ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL)));
				} else {
					ValaSymbol* _tmp39;
					if (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (expr))) != NULL) {
						ValaSymbol* _tmp38;
						ValaSymbol* _tmp37;
						_tmp38 = NULL;
						_tmp37 = NULL;
						base_symbol = (_tmp38 = (_tmp37 = ((ValaSymbol*) (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (expr))))), (_tmp37 == NULL ? NULL : vala_code_node_ref (_tmp37))), (base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL))), _tmp38);
					}
					_tmp39 = NULL;
					vala_expression_set_symbol_reference (((ValaExpression*) (expr)), (_tmp39 = vala_data_type_get_member (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr))));
					(_tmp39 == NULL ? NULL : (_tmp39 = (vala_code_node_unref (_tmp39), NULL)));
				}
				if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) != NULL) {
					/* inner expression is variable, field, or parameter
					 access to instance members of the corresponding type possible*/
					may_access_instance_members = TRUE;
				}
			}
			if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL && vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL && vala_data_type_get_is_dynamic (vala_expression_get_value_type (vala_member_access_get_inner (expr)))) {
				ValaObjectType* _tmp40;
				ValaObjectType* dynamic_object_type;
				/* allow late bound members for dynamic types*/
				_tmp40 = NULL;
				dynamic_object_type = (_tmp40 = VALA_OBJECT_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (expr))), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
				if (VALA_IS_INVOCATION_EXPRESSION (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))))) {
					ValaInvocationExpression* _tmp41;
					ValaInvocationExpression* invoc;
					_tmp41 = NULL;
					invoc = (_tmp41 = VALA_INVOCATION_EXPRESSION (vala_code_node_get_parent_node (((ValaCodeNode*) (expr)))), (_tmp41 == NULL ? NULL : vala_code_node_ref (_tmp41)));
					if (vala_invocation_expression_get_call (invoc) == VALA_EXPRESSION (expr)) {
						ValaDataType* ret_type;
						ValaDynamicMethod* m;
						ValaErrorType* _tmp45;
						ValaFormalParameter* _tmp46;
						/* dynamic method*/
						ret_type = NULL;
						if (vala_expression_get_target_type (((ValaExpression*) (invoc))) != NULL) {
							ValaDataType* _tmp42;
							_tmp42 = NULL;
							ret_type = (_tmp42 = vala_data_type_copy (vala_expression_get_target_type (((ValaExpression*) (invoc)))), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp42);
							vala_data_type_set_value_owned (ret_type, TRUE);
						} else {
							if (VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (invoc))))) {
								ValaDataType* _tmp43;
								_tmp43 = NULL;
								ret_type = (_tmp43 = ((ValaDataType*) (vala_void_type_new ())), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp43);
							} else {
								ValaDataType* _tmp44;
								/* expect dynamic object of the same type*/
								_tmp44 = NULL;
								ret_type = (_tmp44 = vala_data_type_copy (vala_expression_get_value_type (vala_member_access_get_inner (expr))), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp44);
							}
						}
						m = vala_dynamic_method_new (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr), ret_type, vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
						vala_dynamic_method_set_invocation (m, invoc);
						_tmp45 = NULL;
						vala_code_node_add_error_type (((ValaCodeNode*) (m)), ((ValaDataType*) ((_tmp45 = vala_error_type_new (NULL, NULL, NULL)))));
						(_tmp45 == NULL ? NULL : (_tmp45 = (vala_code_node_unref (_tmp45), NULL)));
						vala_symbol_set_access (((ValaSymbol*) (m)), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp46 = NULL;
						vala_method_add_parameter (((ValaMethod*) (m)), (_tmp46 = vala_formal_parameter_new_with_ellipsis (NULL)));
						(_tmp46 == NULL ? NULL : (_tmp46 = (vala_code_node_unref (_tmp46), NULL)));
						vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_object_type_get_type_symbol (dynamic_object_type)))), NULL, ((ValaSymbol*) (m)));
						vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (m)));
						(ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)));
						(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					}
					(invoc == NULL ? NULL : (invoc = (vala_code_node_unref (invoc), NULL)));
				} else {
					if (VALA_IS_ASSIGNMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))))) {
						ValaAssignment* _tmp47;
						ValaAssignment* a;
						_tmp47 = NULL;
						a = (_tmp47 = VALA_ASSIGNMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (expr)))), (_tmp47 == NULL ? NULL : vala_code_node_ref (_tmp47)));
						if (vala_assignment_get_left (a) == VALA_EXPRESSION (expr) && (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD || vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB)) {
							ValaVoidType* _tmp48;
							ValaDynamicSignal* _tmp49;
							ValaDynamicSignal* s;
							/* dynamic signal*/
							_tmp48 = NULL;
							_tmp49 = NULL;
							s = (_tmp49 = vala_dynamic_signal_new (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr), ((ValaDataType*) ((_tmp48 = vala_void_type_new ()))), vala_code_node_get_source_reference (((ValaCodeNode*) (expr)))), (_tmp48 == NULL ? NULL : (_tmp48 = (vala_code_node_unref (_tmp48), NULL))), _tmp49);
							vala_dynamic_signal_set_handler (s, vala_assignment_get_right (a));
							vala_symbol_set_access (((ValaSymbol*) (s)), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_object_type_get_type_symbol (dynamic_object_type)))), NULL, ((ValaSymbol*) (s)));
							vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (s)));
							(s == NULL ? NULL : (s = (vala_code_node_unref (s), NULL)));
						} else {
							if (vala_assignment_get_left (a) == VALA_EXPRESSION (expr)) {
								ValaDynamicProperty* prop;
								ValaPropertyAccessor* _tmp50;
								/* dynamic property assignment*/
								prop = vala_dynamic_property_new (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
								vala_symbol_set_access (((ValaSymbol*) (prop)), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp50 = NULL;
								vala_property_set_set_accessor (((ValaProperty*) (prop)), (_tmp50 = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL)));
								(_tmp50 == NULL ? NULL : (_tmp50 = (vala_code_node_unref (_tmp50), NULL)));
								vala_property_accessor_set_access (vala_property_get_set_accessor (((ValaProperty*) (prop))), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								vala_symbol_set_owner (((ValaSymbol*) (prop)), vala_symbol_get_scope (((ValaSymbol*) (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (expr)))))));
								vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_object_type_get_type_symbol (dynamic_object_type)))), NULL, ((ValaSymbol*) (prop)));
								vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (prop)));
								(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
							}
						}
						(a == NULL ? NULL : (a = (vala_code_node_unref (a), NULL)));
					}
				}
				if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
					ValaDynamicProperty* prop;
					ValaPropertyAccessor* _tmp52;
					/* dynamic property read access*/
					prop = vala_dynamic_property_new (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_member_access_get_member_name (expr), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
					if (vala_expression_get_target_type (((ValaExpression*) (expr))) != NULL) {
						vala_property_set_property_type (((ValaProperty*) (prop)), vala_expression_get_target_type (((ValaExpression*) (expr))));
					} else {
						ValaDataType* _tmp51;
						/* expect dynamic object of the same type*/
						_tmp51 = NULL;
						vala_property_set_property_type (((ValaProperty*) (prop)), (_tmp51 = vala_data_type_copy (vala_expression_get_value_type (vala_member_access_get_inner (expr)))));
						(_tmp51 == NULL ? NULL : (_tmp51 = (vala_code_node_unref (_tmp51), NULL)));
					}
					vala_symbol_set_access (((ValaSymbol*) (prop)), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp52 = NULL;
					vala_property_set_get_accessor (((ValaProperty*) (prop)), (_tmp52 = vala_property_accessor_new (TRUE, FALSE, FALSE, NULL, NULL)));
					(_tmp52 == NULL ? NULL : (_tmp52 = (vala_code_node_unref (_tmp52), NULL)));
					vala_property_accessor_set_access (vala_property_get_get_accessor (((ValaProperty*) (prop))), VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					vala_symbol_set_owner (((ValaSymbol*) (prop)), vala_symbol_get_scope (((ValaSymbol*) (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (expr)))))));
					vala_scope_add (vala_symbol_get_scope (((ValaSymbol*) (vala_object_type_get_type_symbol (dynamic_object_type)))), NULL, ((ValaSymbol*) (prop)));
					vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (prop)));
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				}
				if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) != NULL) {
					may_access_instance_members = TRUE;
				}
				(dynamic_object_type == NULL ? NULL : (dynamic_object_type = (vala_code_node_unref (dynamic_object_type), NULL)));
			}
		}
	}
	if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
		char* base_type_name;
		char* _tmp55;
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		base_type_name = g_strdup ("(null)");
		if (vala_member_access_get_inner (expr) != NULL && vala_expression_get_value_type (vala_member_access_get_inner (expr)) != NULL) {
			char* _tmp53;
			_tmp53 = NULL;
			base_type_name = (_tmp53 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_member_access_get_inner (expr))))), (base_type_name = (g_free (base_type_name), NULL)), _tmp53);
		} else {
			if (base_symbol != NULL) {
				char* _tmp54;
				_tmp54 = NULL;
				base_type_name = (_tmp54 = vala_symbol_get_full_name (base_symbol), (base_type_name = (g_free (base_type_name), NULL)), _tmp54);
			}
		}
		_tmp55 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp55 = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", vala_member_access_get_member_name (expr), base_type_name)));
		_tmp55 = (g_free (_tmp55), NULL);
		base_type_name = (g_free (base_type_name), NULL);
		(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
		(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
		return;
	}
	_tmp56 = NULL;
	member = (_tmp56 = vala_expression_get_symbol_reference (((ValaExpression*) (expr))), (_tmp56 == NULL ? NULL : vala_code_node_ref (_tmp56)));
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	if (VALA_IS_FIELD (member)) {
		ValaField* _tmp57;
		ValaField* f;
		_tmp57 = NULL;
		f = (_tmp57 = VALA_FIELD (member), (_tmp57 == NULL ? NULL : vala_code_node_ref (_tmp57)));
		access = vala_symbol_get_access (((ValaSymbol*) (f)));
		instance = (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE);
		klass = (vala_field_get_binding (f) == MEMBER_BINDING_CLASS);
		(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
	} else {
		if (VALA_IS_METHOD (member)) {
			ValaMethod* _tmp58;
			ValaMethod* m;
			_tmp58 = NULL;
			m = (_tmp58 = VALA_METHOD (member), (_tmp58 == NULL ? NULL : vala_code_node_ref (_tmp58)));
			access = vala_symbol_get_access (((ValaSymbol*) (m)));
			if (!(VALA_IS_CREATION_METHOD (m))) {
				instance = (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE);
			}
			klass = (vala_method_get_binding (m) == MEMBER_BINDING_CLASS);
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
		} else {
			if (VALA_IS_PROPERTY (member)) {
				ValaProperty* _tmp59;
				ValaProperty* prop;
				_tmp59 = NULL;
				prop = (_tmp59 = VALA_PROPERTY (member), (_tmp59 == NULL ? NULL : vala_code_node_ref (_tmp59)));
				if (!vala_code_node_check (((ValaCodeNode*) (prop)), self)) {
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
					(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
					(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
					return;
				}
				access = vala_symbol_get_access (((ValaSymbol*) (prop)));
				if (vala_expression_get_lvalue (((ValaExpression*) (expr)))) {
					if (vala_property_get_set_accessor (prop) == NULL) {
						char* _tmp61;
						char* _tmp60;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp61 = NULL;
						_tmp60 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp61 = g_strdup_printf ("Property `%s' is read-only", (_tmp60 = vala_symbol_get_full_name (((ValaSymbol*) (prop)))))));
						_tmp61 = (g_free (_tmp61), NULL);
						_tmp60 = (g_free (_tmp60), NULL);
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
						(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
						(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
						return;
					}
					if (vala_symbol_get_access (((ValaSymbol*) (prop))) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						access = vala_property_accessor_get_access (vala_property_get_set_accessor (prop));
					} else {
						if (vala_symbol_get_access (((ValaSymbol*) (prop))) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED && vala_property_accessor_get_access (vala_property_get_set_accessor (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
							access = vala_property_accessor_get_access (vala_property_get_set_accessor (prop));
						}
					}
				} else {
					if (vala_property_get_get_accessor (prop) == NULL) {
						char* _tmp63;
						char* _tmp62;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp63 = NULL;
						_tmp62 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp63 = g_strdup_printf ("Property `%s' is write-only", (_tmp62 = vala_symbol_get_full_name (((ValaSymbol*) (prop)))))));
						_tmp63 = (g_free (_tmp63), NULL);
						_tmp62 = (g_free (_tmp62), NULL);
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
						(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
						(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
						return;
					}
					if (vala_symbol_get_access (((ValaSymbol*) (prop))) == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
						access = vala_property_accessor_get_access (vala_property_get_get_accessor (prop));
					} else {
						if (vala_symbol_get_access (((ValaSymbol*) (prop))) == VALA_SYMBOL_ACCESSIBILITY_PROTECTED && vala_property_accessor_get_access (vala_property_get_get_accessor (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
							access = vala_property_accessor_get_access (vala_property_get_get_accessor (prop));
						}
					}
				}
				instance = (vala_property_get_binding (prop) == MEMBER_BINDING_INSTANCE);
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
			} else {
				if (VALA_IS_SIGNAL (member)) {
					instance = TRUE;
				}
			}
		}
	}
	if (access == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaSymbol* _tmp64;
		ValaSymbol* target_type;
		gboolean in_target_type;
		_tmp64 = NULL;
		target_type = (_tmp64 = vala_symbol_get_parent_symbol (member), (_tmp64 == NULL ? NULL : vala_code_node_ref (_tmp64)));
		in_target_type = FALSE;
		{
			ValaSymbol* _tmp65;
			ValaSymbol* this_symbol;
			ValaSymbol* _tmp67;
			ValaSymbol* _tmp66;
			_tmp65 = NULL;
			this_symbol = (_tmp65 = self->priv->_current_symbol, (_tmp65 == NULL ? NULL : vala_code_node_ref (_tmp65)));
			_tmp67 = NULL;
			_tmp66 = NULL;
			for (; this_symbol != NULL; this_symbol = (_tmp67 = (_tmp66 = vala_symbol_get_parent_symbol (this_symbol), (_tmp66 == NULL ? NULL : vala_code_node_ref (_tmp66))), (this_symbol == NULL ? NULL : (this_symbol = (vala_code_node_unref (this_symbol), NULL))), _tmp67)) {
				if (target_type == this_symbol) {
					in_target_type = TRUE;
					break;
				}
			}
			(this_symbol == NULL ? NULL : (this_symbol = (vala_code_node_unref (this_symbol), NULL)));
		}
		if (!in_target_type) {
			char* _tmp69;
			char* _tmp68;
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			_tmp69 = NULL;
			_tmp68 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp69 = g_strdup_printf ("Access to private member `%s' denied", (_tmp68 = vala_symbol_get_full_name (member)))));
			_tmp69 = (g_free (_tmp69), NULL);
			_tmp68 = (g_free (_tmp68), NULL);
			(target_type == NULL ? NULL : (target_type = (vala_code_node_unref (target_type), NULL)));
			(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
			(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
			(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
			return;
		}
		(target_type == NULL ? NULL : (target_type = (vala_code_node_unref (target_type), NULL)));
	}
	if ((instance || klass) && !may_access_instance_members) {
		vala_member_access_set_prototype_access (expr, TRUE);
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
			ValaDataType* _tmp70;
			/* also set static type for prototype access
			 required when using instance methods as delegates in constants
			 TODO replace by MethodPrototype*/
			_tmp70 = NULL;
			vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp70 = vala_semantic_analyzer_get_value_type_for_symbol (self, vala_expression_get_symbol_reference (((ValaExpression*) (expr))), vala_expression_get_lvalue (((ValaExpression*) (expr))))));
			(_tmp70 == NULL ? NULL : (_tmp70 = (vala_code_node_unref (_tmp70), NULL)));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
				ValaFieldPrototype* _tmp71;
				_tmp71 = NULL;
				vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp71 = vala_field_prototype_new (VALA_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))))))));
				(_tmp71 == NULL ? NULL : (_tmp71 = (vala_code_node_unref (_tmp71), NULL)));
			}
		}
	} else {
		ValaDataType* _tmp74;
		/* implicit this access*/
		if (instance && vala_member_access_get_inner (expr) == NULL) {
			ValaMemberAccess* _tmp72;
			ValaDataType* _tmp73;
			_tmp72 = NULL;
			vala_member_access_set_inner (expr, ((ValaExpression*) ((_tmp72 = vala_member_access_new (NULL, "this", vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
			(_tmp72 == NULL ? NULL : (_tmp72 = (vala_code_node_unref (_tmp72), NULL)));
			_tmp73 = NULL;
			vala_expression_set_value_type (vala_member_access_get_inner (expr), (_tmp73 = vala_data_type_copy (vala_formal_parameter_get_parameter_type (this_parameter))));
			(_tmp73 == NULL ? NULL : (_tmp73 = (vala_code_node_unref (_tmp73), NULL)));
			vala_expression_set_symbol_reference (vala_member_access_get_inner (expr), ((ValaSymbol*) (this_parameter)));
		}
		_tmp74 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp74 = vala_semantic_analyzer_get_value_type_for_symbol (self, vala_expression_get_symbol_reference (((ValaExpression*) (expr))), vala_expression_get_lvalue (((ValaExpression*) (expr))))));
		(_tmp74 == NULL ? NULL : (_tmp74 = (vala_code_node_unref (_tmp74), NULL)));
		/* resolve generic return values*/
		if (vala_expression_get_value_type (((ValaExpression*) (expr))) != NULL && vala_data_type_get_type_parameter (vala_expression_get_value_type (((ValaExpression*) (expr)))) != NULL) {
			if (vala_member_access_get_inner (expr) != NULL) {
				ValaDataType* _tmp75;
				_tmp75 = NULL;
				vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp75 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_member_access_get_inner (expr)), vala_expression_get_symbol_reference (((ValaExpression*) (expr))), vala_expression_get_value_type (((ValaExpression*) (expr))), ((ValaCodeNode*) (expr)))));
				(_tmp75 == NULL ? NULL : (_tmp75 = (vala_code_node_unref (_tmp75), NULL)));
				if (vala_expression_get_value_type (((ValaExpression*) (expr))) == NULL) {
					(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
					(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
					(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
					return;
				}
			}
		}
		if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
			ValaMethod* _tmp76;
			ValaMethod* m;
			ValaMethod* base_method;
			_tmp76 = NULL;
			m = (_tmp76 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp76 == NULL ? NULL : vala_code_node_ref (_tmp76)));
			base_method = NULL;
			if (vala_method_get_base_method (m) != NULL) {
				ValaMethod* _tmp78;
				ValaMethod* _tmp77;
				_tmp78 = NULL;
				_tmp77 = NULL;
				base_method = (_tmp78 = (_tmp77 = vala_method_get_base_method (m), (_tmp77 == NULL ? NULL : vala_code_node_ref (_tmp77))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp78);
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaMethod* _tmp80;
					ValaMethod* _tmp79;
					_tmp80 = NULL;
					_tmp79 = NULL;
					base_method = (_tmp80 = (_tmp79 = vala_method_get_base_interface_method (m), (_tmp79 == NULL ? NULL : vala_code_node_ref (_tmp79))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp80);
				} else {
					ValaMethod* _tmp82;
					ValaMethod* _tmp81;
					_tmp82 = NULL;
					_tmp81 = NULL;
					base_method = (_tmp82 = (_tmp81 = m, (_tmp81 == NULL ? NULL : vala_code_node_ref (_tmp81))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp82);
				}
			}
			if (instance && vala_symbol_get_parent_symbol (((ValaSymbol*) (base_method))) != NULL) {
				ValaDataType* _tmp83;
				_tmp83 = NULL;
				vala_expression_set_target_type (vala_member_access_get_inner (expr), (_tmp83 = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (base_method)))))));
				(_tmp83 == NULL ? NULL : (_tmp83 = (vala_code_node_unref (_tmp83), NULL)));
			}
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			(base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)));
		} else {
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
				ValaProperty* _tmp84;
				ValaProperty* prop;
				ValaProperty* base_property;
				_tmp84 = NULL;
				prop = (_tmp84 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp84 == NULL ? NULL : vala_code_node_ref (_tmp84)));
				base_property = NULL;
				if (vala_property_get_base_property (prop) != NULL) {
					ValaProperty* _tmp86;
					ValaProperty* _tmp85;
					_tmp86 = NULL;
					_tmp85 = NULL;
					base_property = (_tmp86 = (_tmp85 = vala_property_get_base_property (prop), (_tmp85 == NULL ? NULL : vala_code_node_ref (_tmp85))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp86);
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaProperty* _tmp88;
						ValaProperty* _tmp87;
						_tmp88 = NULL;
						_tmp87 = NULL;
						base_property = (_tmp88 = (_tmp87 = vala_property_get_base_interface_property (prop), (_tmp87 == NULL ? NULL : vala_code_node_ref (_tmp87))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp88);
					} else {
						ValaProperty* _tmp90;
						ValaProperty* _tmp89;
						_tmp90 = NULL;
						_tmp89 = NULL;
						base_property = (_tmp90 = (_tmp89 = prop, (_tmp89 == NULL ? NULL : vala_code_node_ref (_tmp89))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp90);
					}
				}
				if (instance && vala_symbol_get_parent_symbol (((ValaSymbol*) (base_property))) != NULL) {
					ValaDataType* _tmp91;
					_tmp91 = NULL;
					vala_expression_set_target_type (vala_member_access_get_inner (expr), (_tmp91 = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (base_property)))))));
					(_tmp91 == NULL ? NULL : (_tmp91 = (vala_code_node_unref (_tmp91), NULL)));
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)));
			} else {
				if ((VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))) || VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) && instance && vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))) != NULL) {
					ValaDataType* _tmp92;
					_tmp92 = NULL;
					vala_expression_set_target_type (vala_member_access_get_inner (expr), (_tmp92 = vala_semantic_analyzer_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))))));
					(_tmp92 == NULL ? NULL : (_tmp92 = (vala_code_node_unref (_tmp92), NULL)));
				}
			}
		}
	}
	vala_source_file_add_symbol_dependency (self->priv->_current_source_file, vala_expression_get_symbol_reference (((ValaExpression*) (expr))), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	(base_symbol == NULL ? NULL : (base_symbol = (vala_code_node_unref (base_symbol), NULL)));
	(this_parameter == NULL ? NULL : (this_parameter = (vala_code_node_unref (this_parameter), NULL)));
	(member == NULL ? NULL : (member = (vala_code_node_unref (member), NULL)));
}


ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = ((ValaDataType*) (vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (sym)))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp0);
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = ((ValaDataType*) (vala_value_type_new (((ValaTypeSymbol*) (VALA_STRUCT (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp1);
		} else {
			if (VALA_IS_ENUM (sym)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				type = (_tmp2 = ((ValaDataType*) (vala_value_type_new (((ValaTypeSymbol*) (VALA_ENUM (sym)))))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp2);
			} else {
				if (VALA_IS_ERROR_DOMAIN (sym)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = ((ValaDataType*) (vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp3);
				} else {
					if (VALA_IS_ERROR_CODE (sym)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = ((ValaDataType*) (vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (((ValaSymbol*) (sym)))), VALA_ERROR_CODE (sym), NULL))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp4);
					} else {
						char* _tmp6;
						char* _tmp5;
						ValaDataType* _tmp7;
						_tmp6 = NULL;
						_tmp5 = NULL;
						vala_report_error (NULL, (_tmp6 = g_strdup_printf ("internal error: `%s' is not a supported type", (_tmp5 = vala_symbol_get_full_name (((ValaSymbol*) (sym)))))));
						_tmp6 = (g_free (_tmp6), NULL);
						_tmp5 = (g_free (_tmp5), NULL);
						_tmp7 = NULL;
						return (_tmp7 = ((ValaDataType*) (vala_invalid_type_new ())), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp7);
					}
				}
			}
		}
	}
	return type;
}


static void vala_semantic_analyzer_real_visit_invocation_expression (ValaCodeVisitor* base, ValaInvocationExpression* expr) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp3;
	ValaDataType* mtype;
	GeeList* params;
	ValaExpression* last_arg;
	GeeList* args;
	GeeIterator* arg_it;
	ValaDataType* ret_type;
	ValaDataType* _tmp46;
	GeeList* _tmp47;
	ValaMemberAccess* _tmp49;
	ValaExpression* _tmp48;
	ValaMemberAccess* ma;
	GeeList* resolved_type_args;
	ValaDataType* _tmp52;
	GeeList* _tmp54;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_invocation_expression_get_call (expr))), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_invocation_expression_get_call (expr))))) {
		/* if method resolving didn't succeed, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr))) {
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* ma;
		_tmp0 = NULL;
		ma = (_tmp0 = VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (vala_member_access_get_prototype_access (ma)) {
			char* _tmp2;
			char* _tmp1;
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			_tmp2 = NULL;
			_tmp1 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp2 = g_strdup_printf ("Access to instance member `%s' denied", (_tmp1 = vala_symbol_get_full_name (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))))));
			_tmp2 = (g_free (_tmp2), NULL);
			_tmp1 = (g_free (_tmp1), NULL);
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			return;
		}
		(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	}
	_tmp3 = NULL;
	mtype = (_tmp3 = vala_expression_get_value_type (vala_invocation_expression_get_call (expr)), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	if (VALA_IS_OBJECT_TYPE (mtype)) {
		ValaMethod* _tmp4;
		ValaCreationMethod* cm;
		/* constructor chain-up*/
		_tmp4 = NULL;
		cm = (_tmp4 = vala_semantic_analyzer_find_current_method (self), (VALA_IS_CREATION_METHOD (_tmp4) ? ((ValaCreationMethod*) (_tmp4)) : NULL));
		g_assert (cm != NULL);
		if (vala_creation_method_get_chain_up (cm)) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Multiple constructor calls in the same constructor are not permitted");
			(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
			(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
			return;
		}
		vala_creation_method_set_chain_up (cm, TRUE);
		(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
	}
	/* check for struct construction*/
	if (VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)) && ((VALA_IS_CREATION_METHOD (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))) && VALA_IS_STRUCT (vala_symbol_get_parent_symbol (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))))) || VALA_IS_STRUCT (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr))))) {
		ValaObjectCreationExpression* struct_creation_expression;
		struct_creation_expression = vala_object_creation_expression_new (VALA_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
		vala_object_creation_expression_set_struct_creation (struct_creation_expression, TRUE);
		{
			GeeList* arg_collection;
			int arg_it;
			arg_collection = vala_invocation_expression_get_argument_list (expr);
			for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
				ValaExpression* arg;
				arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
				{
					vala_object_creation_expression_add_argument (struct_creation_expression, arg);
					(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
				}
			}
			(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
		}
		vala_expression_set_target_type (((ValaExpression*) (struct_creation_expression)), vala_expression_get_target_type (((ValaExpression*) (expr))));
		gee_collection_add (((GeeCollection*) (self->priv->replaced_nodes)), ((ValaCodeNode*) (expr)));
		vala_code_node_replace_expression (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))), ((ValaExpression*) (expr)), ((ValaExpression*) (struct_creation_expression)));
		vala_code_node_accept (((ValaCodeNode*) (struct_creation_expression)), ((ValaCodeVisitor*) (self)));
		(struct_creation_expression == NULL ? NULL : (struct_creation_expression = (vala_code_node_unref (struct_creation_expression), NULL)));
		(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
		return;
	} else {
		if (VALA_IS_MEMBER_ACCESS (vala_invocation_expression_get_call (expr)) && VALA_IS_CREATION_METHOD (vala_expression_get_symbol_reference (vala_invocation_expression_get_call (expr)))) {
			ValaMethod* _tmp5;
			ValaCreationMethod* cm;
			/* constructor chain-up*/
			_tmp5 = NULL;
			cm = (_tmp5 = vala_semantic_analyzer_find_current_method (self), (VALA_IS_CREATION_METHOD (_tmp5) ? ((ValaCreationMethod*) (_tmp5)) : NULL));
			g_assert (cm != NULL);
			if (vala_creation_method_get_chain_up (cm)) {
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Multiple constructor calls in the same constructor are not permitted");
				(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
				(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
				return;
			}
			vala_creation_method_set_chain_up (cm, TRUE);
			(cm == NULL ? NULL : (cm = (vala_code_node_unref (cm), NULL)));
		}
	}
	params = NULL;
	if (mtype != NULL && vala_data_type_is_invokable (mtype)) {
		GeeList* _tmp6;
		_tmp6 = NULL;
		params = (_tmp6 = vala_data_type_get_parameters (mtype), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp6);
	} else {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "invocation not supported in this context");
		(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
		(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
		return;
	}
	last_arg = NULL;
	args = vala_invocation_expression_get_argument_list (expr);
	arg_it = gee_iterable_iterator (((GeeIterable*) (args)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_formal_parameter_get_ellipsis (param)) {
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				if (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					ValaMemberAccess* _tmp8;
					ValaExpression* _tmp7;
					ValaMemberAccess* ma;
					ValaExpression* _tmp11;
					ValaExpression* _tmp10;
					arg = ((ValaExpression*) (gee_iterator_get (arg_it)));
					/* store expected type for callback parameters */
					vala_expression_set_target_type (arg, vala_formal_parameter_get_parameter_type (param));
					/* resolve generic type parameters*/
					_tmp8 = NULL;
					_tmp7 = NULL;
					ma = (_tmp8 = (_tmp7 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp7) ? ((ValaMemberAccess*) (_tmp7)) : NULL)), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
					if (vala_data_type_get_type_parameter (vala_expression_get_target_type (arg)) != NULL) {
						if (ma != NULL && vala_member_access_get_inner (ma) != NULL) {
							ValaDataType* _tmp9;
							_tmp9 = NULL;
							vala_expression_set_target_type (arg, (_tmp9 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_expression_get_symbol_reference (((ValaExpression*) (ma))), vala_expression_get_target_type (arg), ((ValaCodeNode*) (arg)))));
							(_tmp9 == NULL ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL)));
							g_assert (vala_expression_get_target_type (arg) != NULL);
						}
					}
					_tmp11 = NULL;
					_tmp10 = NULL;
					last_arg = (_tmp11 = (_tmp10 = arg, (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10))), (last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL))), _tmp11);
					(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	/* printf arguments*/
	if (VALA_IS_METHOD_TYPE (mtype) && vala_method_get_printf_format (vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (mtype))))) {
		ValaStringLiteral* format_literal;
		format_literal = NULL;
		if (last_arg != NULL) {
			ValaStringLiteral* _tmp14;
			ValaStringLiteral* _tmp13;
			ValaExpression* _tmp12;
			/* use last argument as format string*/
			_tmp14 = NULL;
			_tmp13 = NULL;
			_tmp12 = NULL;
			format_literal = (_tmp14 = (_tmp13 = (_tmp12 = last_arg, (VALA_IS_STRING_LITERAL (_tmp12) ? ((ValaStringLiteral*) (_tmp12)) : NULL)), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (format_literal == NULL ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL))), _tmp14);
		} else {
			ValaMemberAccess* _tmp16;
			ValaExpression* _tmp15;
			ValaMemberAccess* ma;
			/* use instance as format string for string.printf (...)*/
			_tmp16 = NULL;
			_tmp15 = NULL;
			ma = (_tmp16 = (_tmp15 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp15) ? ((ValaMemberAccess*) (_tmp15)) : NULL)), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16)));
			if (ma != NULL) {
				ValaStringLiteral* _tmp19;
				ValaStringLiteral* _tmp18;
				ValaExpression* _tmp17;
				_tmp19 = NULL;
				_tmp18 = NULL;
				_tmp17 = NULL;
				format_literal = (_tmp19 = (_tmp18 = (_tmp17 = vala_member_access_get_inner (ma), (VALA_IS_STRING_LITERAL (_tmp17) ? ((ValaStringLiteral*) (_tmp17)) : NULL)), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18))), (format_literal == NULL ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL))), _tmp19);
			}
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
		if (format_literal != NULL) {
			char* format;
			gboolean unsupported_format;
			const char* format_it;
			gunichar c;
			format = vala_string_literal_eval (format_literal);
			unsupported_format = FALSE;
			format_it = format;
			c = g_utf8_get_char (format_it);
			while (c != '\0') {
				gint length;
				ValaDataType* param_type;
				if (c != '%') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					continue;
				}
				format_it = g_utf8_next_char (format_it);
				c = g_utf8_get_char (format_it);
				while (c == '#' || c == '0' || c == '-' || c == ' ' || c == '+') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				while (c >= '0' && c <= '9') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				/* precision*/
				if (c == '.') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					while (c >= '0' && c <= '9') {
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					}
				}
				/* length modifier*/
				length = 0;
				if (c == 'h') {
					length = -1;
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
					if (c == 'h') {
						length = -2;
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					}
				} else {
					if (c == 'l') {
						length = 1;
						format_it = g_utf8_next_char (format_it);
						c = g_utf8_get_char (format_it);
					} else {
						if (c == 'z') {
							length = 2;
							format_it = g_utf8_next_char (format_it);
							c = g_utf8_get_char (format_it);
						}
					}
				}
				/* conversion specifier*/
				param_type = NULL;
				if (c == 'd' || c == 'i' || c == 'c') {
					/* integer*/
					if (length == -2) {
						ValaDataType* _tmp21;
						ValaDataType* _tmp20;
						_tmp21 = NULL;
						_tmp20 = NULL;
						param_type = (_tmp21 = (_tmp20 = self->priv->int8_type, (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp21);
					} else {
						if (length == -1) {
							ValaDataType* _tmp23;
							ValaDataType* _tmp22;
							_tmp23 = NULL;
							_tmp22 = NULL;
							param_type = (_tmp23 = (_tmp22 = self->priv->short_type, (_tmp22 == NULL ? NULL : vala_code_node_ref (_tmp22))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp23);
						} else {
							if (length == 0) {
								ValaDataType* _tmp25;
								ValaDataType* _tmp24;
								_tmp25 = NULL;
								_tmp24 = NULL;
								param_type = (_tmp25 = (_tmp24 = self->priv->int_type, (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp25);
							} else {
								if (length == 1) {
									ValaDataType* _tmp27;
									ValaDataType* _tmp26;
									_tmp27 = NULL;
									_tmp26 = NULL;
									param_type = (_tmp27 = (_tmp26 = self->priv->long_type, (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp27);
								} else {
									if (length == 2) {
										ValaDataType* _tmp29;
										ValaDataType* _tmp28;
										_tmp29 = NULL;
										_tmp28 = NULL;
										param_type = (_tmp29 = (_tmp28 = self->priv->ssize_t_type, (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp29);
									}
								}
							}
						}
					}
				} else {
					if (c == 'o' || c == 'u' || c == 'x' || c == 'X') {
						/* unsigned integer*/
						if (length == -2) {
							ValaDataType* _tmp31;
							ValaDataType* _tmp30;
							_tmp31 = NULL;
							_tmp30 = NULL;
							param_type = (_tmp31 = (_tmp30 = self->priv->uchar_type, (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp31);
						} else {
							if (length == -1) {
								ValaDataType* _tmp33;
								ValaDataType* _tmp32;
								_tmp33 = NULL;
								_tmp32 = NULL;
								param_type = (_tmp33 = (_tmp32 = self->priv->ushort_type, (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp33);
							} else {
								if (length == 0) {
									ValaDataType* _tmp35;
									ValaDataType* _tmp34;
									_tmp35 = NULL;
									_tmp34 = NULL;
									param_type = (_tmp35 = (_tmp34 = self->priv->uint_type, (_tmp34 == NULL ? NULL : vala_code_node_ref (_tmp34))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp35);
								} else {
									if (length == 1) {
										ValaDataType* _tmp37;
										ValaDataType* _tmp36;
										_tmp37 = NULL;
										_tmp36 = NULL;
										param_type = (_tmp37 = (_tmp36 = self->priv->ulong_type, (_tmp36 == NULL ? NULL : vala_code_node_ref (_tmp36))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp37);
									} else {
										if (length == 2) {
											ValaDataType* _tmp39;
											ValaDataType* _tmp38;
											_tmp39 = NULL;
											_tmp38 = NULL;
											param_type = (_tmp39 = (_tmp38 = self->priv->size_t_type, (_tmp38 == NULL ? NULL : vala_code_node_ref (_tmp38))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp39);
										}
									}
								}
							}
						}
					} else {
						if (c == 'e' || c == 'E' || c == 'f' || c == 'F' || c == 'g' || c == 'G' || c == 'a' || c == 'A') {
							ValaDataType* _tmp41;
							ValaDataType* _tmp40;
							/* double*/
							_tmp41 = NULL;
							_tmp40 = NULL;
							param_type = (_tmp41 = (_tmp40 = self->priv->double_type, (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp41);
						} else {
							if (c == 's') {
								ValaDataType* _tmp43;
								ValaDataType* _tmp42;
								/* string*/
								_tmp43 = NULL;
								_tmp42 = NULL;
								param_type = (_tmp43 = (_tmp42 = self->priv->string_type, (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp43);
							} else {
								if (c == 'p') {
									ValaDataType* _tmp45;
									ValaVoidType* _tmp44;
									/* pointer*/
									_tmp45 = NULL;
									_tmp44 = NULL;
									param_type = (_tmp45 = ((ValaDataType*) (vala_pointer_type_new (((ValaDataType*) ((_tmp44 = vala_void_type_new ()))), NULL))), (param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL))), _tmp45);
									(_tmp44 == NULL ? NULL : (_tmp44 = (vala_code_node_unref (_tmp44), NULL)));
								} else {
									if (c == '%') {
									} else {
										/* literal %*/
										unsupported_format = TRUE;
										(param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)));
										break;
									}
								}
							}
						}
					}
				}
				if (c != '\0') {
					format_it = g_utf8_next_char (format_it);
					c = g_utf8_get_char (format_it);
				}
				if (param_type != NULL) {
					if (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = ((ValaExpression*) (gee_iterator_get (arg_it)));
						vala_expression_set_target_type (arg, param_type);
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
					} else {
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Too few arguments for specified format");
						(param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)));
						format = (g_free (format), NULL);
						(format_literal == NULL ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)));
						(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
						(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
						(last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)));
						(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
						(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
						return;
					}
				}
				(param_type == NULL ? NULL : (param_type = (vala_code_node_unref (param_type), NULL)));
			}
			if (!unsupported_format && gee_iterator_next (arg_it)) {
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Too many arguments for specified format");
				format = (g_free (format), NULL);
				(format_literal == NULL ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)));
				(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
				(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
				(last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)));
				(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
				return;
			}
			format = (g_free (format), NULL);
		}
		(format_literal == NULL ? NULL : (format_literal = (vala_code_node_unref (format_literal), NULL)));
	}
	{
		GeeList* arg_collection;
		int arg_it;
		arg_collection = vala_invocation_expression_get_argument_list (expr);
		for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (arg)), ((ValaCodeVisitor*) (self)));
				(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
			}
		}
		(arg_collection == NULL ? NULL : (arg_collection = (gee_collection_object_unref (arg_collection), NULL)));
	}
	ret_type = NULL;
	_tmp46 = NULL;
	ret_type = (_tmp46 = vala_data_type_get_return_type (mtype), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp46);
	_tmp47 = NULL;
	params = (_tmp47 = vala_data_type_get_parameters (mtype), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp47);
	if (VALA_IS_VOID_TYPE (ret_type)) {
		/* void return type*/
		if (!(VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))))) && !(VALA_IS_FOR_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))))) && !(VALA_IS_YIELD_STATEMENT (vala_code_node_get_parent_node (((ValaCodeNode*) (expr)))))) {
			/* A void method invocation can be in the initializer or
			 iterator of a for statement*/
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "invocation of void method not allowed as expression");
			(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
			(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
			(last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)));
			(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
			(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
			(ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)));
			return;
		}
	}
	/* resolve generic return values*/
	_tmp49 = NULL;
	_tmp48 = NULL;
	ma = (_tmp49 = (_tmp48 = vala_invocation_expression_get_call (expr), (VALA_IS_MEMBER_ACCESS (_tmp48) ? ((ValaMemberAccess*) (_tmp48)) : NULL)), (_tmp49 == NULL ? NULL : vala_code_node_ref (_tmp49)));
	if (vala_data_type_get_type_parameter (ret_type) != NULL) {
		if (ma != NULL && vala_member_access_get_inner (ma) != NULL) {
			ValaDataType* _tmp50;
			_tmp50 = NULL;
			ret_type = (_tmp50 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_expression_get_symbol_reference (((ValaExpression*) (ma))), ret_type, ((ValaCodeNode*) (expr))), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp50);
			if (ret_type == NULL) {
				(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
				(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
				(last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)));
				(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
				(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
				(ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				return;
			}
		}
	}
	resolved_type_args = ((GeeList*) (gee_array_list_new (VALA_TYPE_DATA_TYPE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
	{
		GeeList* type_arg_collection;
		int type_arg_it;
		type_arg_collection = vala_data_type_get_type_arguments (ret_type);
		for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
			ValaDataType* type_arg;
			type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
			{
				if (vala_data_type_get_type_parameter (type_arg) != NULL && ma != NULL && vala_member_access_get_inner (ma) != NULL) {
					ValaDataType* _tmp51;
					_tmp51 = NULL;
					gee_collection_add (((GeeCollection*) (resolved_type_args)), (_tmp51 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_member_access_get_inner (ma)), vala_expression_get_symbol_reference (((ValaExpression*) (ma))), type_arg, ((ValaCodeNode*) (expr)))));
					(_tmp51 == NULL ? NULL : (_tmp51 = (vala_code_node_unref (_tmp51), NULL)));
				} else {
					gee_collection_add (((GeeCollection*) (resolved_type_args)), type_arg);
				}
				(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
			}
		}
		(type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL)));
	}
	_tmp52 = NULL;
	ret_type = (_tmp52 = vala_data_type_copy (ret_type), (ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL))), _tmp52);
	vala_data_type_remove_all_type_arguments (ret_type);
	{
		GeeList* resolved_type_arg_collection;
		int resolved_type_arg_it;
		resolved_type_arg_collection = resolved_type_args;
		for (resolved_type_arg_it = 0; resolved_type_arg_it < gee_collection_get_size (GEE_COLLECTION (resolved_type_arg_collection)); resolved_type_arg_it = resolved_type_arg_it + 1) {
			ValaDataType* resolved_type_arg;
			resolved_type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (resolved_type_arg_collection), resolved_type_arg_it)));
			{
				vala_data_type_add_type_argument (ret_type, resolved_type_arg);
				(resolved_type_arg == NULL ? NULL : (resolved_type_arg = (vala_code_node_unref (resolved_type_arg), NULL)));
			}
		}
	}
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaMethod* _tmp53;
		ValaMethod* m;
		_tmp53 = NULL;
		m = (_tmp53 = vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (mtype))), (_tmp53 == NULL ? NULL : vala_code_node_ref (_tmp53)));
		{
			GeeList* error_type_collection;
			int error_type_it;
			error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (m)));
			for (error_type_it = 0; error_type_it < gee_collection_get_size (GEE_COLLECTION (error_type_collection)); error_type_it = error_type_it + 1) {
				ValaDataType* error_type;
				error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (error_type_collection), error_type_it)));
				{
					ValaDataType* call_error_type;
					/* ensure we can trace back which expression may throw errors of this type*/
					call_error_type = vala_data_type_copy (error_type);
					vala_code_node_set_source_reference (((ValaCodeNode*) (call_error_type)), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
					vala_code_node_add_error_type (((ValaCodeNode*) (expr)), call_error_type);
					(error_type == NULL ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)));
					(call_error_type == NULL ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL)));
				}
			}
			(error_type_collection == NULL ? NULL : (error_type_collection = (gee_collection_object_unref (error_type_collection), NULL)));
		}
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
	}
	vala_expression_set_value_type (((ValaExpression*) (expr)), ret_type);
	_tmp54 = NULL;
	vala_semantic_analyzer_check_arguments (self, ((ValaExpression*) (expr)), mtype, params, (_tmp54 = vala_invocation_expression_get_argument_list (expr)));
	(_tmp54 == NULL ? NULL : (_tmp54 = (gee_collection_object_unref (_tmp54), NULL)));
	(mtype == NULL ? NULL : (mtype = (vala_code_node_unref (mtype), NULL)));
	(params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL)));
	(last_arg == NULL ? NULL : (last_arg = (vala_code_node_unref (last_arg), NULL)));
	(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
	(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
	(ret_type == NULL ? NULL : (ret_type = (vala_code_node_unref (ret_type), NULL)));
	(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	(resolved_type_args == NULL ? NULL : (resolved_type_args = (gee_collection_object_unref (resolved_type_args), NULL)));
}


static gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args) {
	ValaExpression* prev_arg;
	GeeIterator* arg_it;
	ValaAttribute* _tmp0;
	gboolean _tmp1;
	gboolean diag;
	gboolean ellipsis;
	gint i;
	gboolean _tmp46;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	g_return_val_if_fail (mtype != NULL, FALSE);
	g_return_val_if_fail (params != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	prev_arg = NULL;
	arg_it = gee_iterable_iterator (((GeeIterable*) (args)));
	_tmp0 = NULL;
	diag = (_tmp1 = (VALA_IS_METHOD_TYPE (mtype) && (_tmp0 = vala_code_node_get_attribute (((ValaCodeNode*) (vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (mtype))))), "Diagnostics")) != NULL), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL))), _tmp1);
	ellipsis = FALSE;
	i = 0;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (!vala_code_node_check (((ValaCodeNode*) (param)), self)) {
					gboolean _tmp2;
					return (_tmp2 = FALSE, (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp2);
				}
				if (vala_formal_parameter_get_ellipsis (param)) {
					ellipsis = TRUE;
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					break;
				}
				/* header file necessary if we need to cast argument */
				vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_formal_parameter_get_parameter_type (param), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
				if (arg_it == NULL || !gee_iterator_next (arg_it)) {
					if (vala_formal_parameter_get_default_expression (param) == NULL) {
						char* _tmp4;
						char* _tmp3;
						gboolean _tmp5;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp4 = NULL;
						_tmp3 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp4 = g_strdup_printf ("Too few arguments, method `%s' does not take %d arguments", (_tmp3 = vala_code_node_to_string (((ValaCodeNode*) (mtype)))), gee_collection_get_size (((GeeCollection*) (args))))));
						_tmp4 = (g_free (_tmp4), NULL);
						_tmp3 = (g_free (_tmp3), NULL);
						return (_tmp5 = FALSE, (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp5);
					} else {
						ValaInvocationExpression* _tmp7;
						ValaExpression* _tmp6;
						ValaInvocationExpression* invocation_expr;
						ValaObjectCreationExpression* _tmp9;
						ValaExpression* _tmp8;
						ValaObjectCreationExpression* object_creation_expr;
						GeeIterator* _tmp10;
						_tmp7 = NULL;
						_tmp6 = NULL;
						invocation_expr = (_tmp7 = (_tmp6 = expr, (VALA_IS_INVOCATION_EXPRESSION (_tmp6) ? ((ValaInvocationExpression*) (_tmp6)) : NULL)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
						_tmp9 = NULL;
						_tmp8 = NULL;
						object_creation_expr = (_tmp9 = (_tmp8 = expr, (VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp8) ? ((ValaObjectCreationExpression*) (_tmp8)) : NULL)), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9)));
						if (invocation_expr != NULL) {
							vala_invocation_expression_add_argument (invocation_expr, vala_formal_parameter_get_default_expression (param));
						} else {
							if (object_creation_expr != NULL) {
								vala_object_creation_expression_add_argument (object_creation_expr, vala_formal_parameter_get_default_expression (param));
							} else {
								g_assert_not_reached ();
							}
						}
						_tmp10 = NULL;
						arg_it = (_tmp10 = NULL, (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp10);
						(invocation_expr == NULL ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL)));
						(object_creation_expr == NULL ? NULL : (object_creation_expr = (vala_code_node_unref (object_creation_expr), NULL)));
					}
				} else {
					ValaExpression* arg;
					ValaExpression* _tmp31;
					ValaExpression* _tmp30;
					arg = ((ValaExpression*) (gee_iterator_get (arg_it)));
					if (vala_code_node_get_error (((ValaCodeNode*) (arg)))) {
						gboolean _tmp11;
						/* ignore inner error*/
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						return (_tmp11 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp11);
					} else {
						if (vala_expression_get_value_type (arg) == NULL) {
							/* disallow untyped arguments except for type inference of callbacks*/
							if (!(VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) || !(VALA_IS_METHOD (vala_expression_get_symbol_reference (arg)))) {
								char* _tmp12;
								gboolean _tmp13;
								vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
								_tmp12 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp12 = g_strdup_printf ("Invalid type for argument %d", i + 1)));
								_tmp12 = (g_free (_tmp12), NULL);
								return (_tmp13 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp13);
							}
						} else {
							if (vala_expression_get_target_type (arg) != NULL && !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg)) && !(VALA_IS_NULL_LITERAL (arg) && vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT)) {
								char* _tmp16;
								char* _tmp15;
								char* _tmp14;
								gboolean _tmp17;
								vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
								_tmp16 = NULL;
								_tmp15 = NULL;
								_tmp14 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp16 = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, (_tmp14 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (arg))))), (_tmp15 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (arg))))))));
								_tmp16 = (g_free (_tmp16), NULL);
								_tmp15 = (g_free (_tmp15), NULL);
								_tmp14 = (g_free (_tmp14), NULL);
								return (_tmp17 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp17);
							} else {
								gint arg_type;
								/* 0 => null, 1 => in, 2 => ref, 3 => out*/
								arg_type = 1;
								if (VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) {
									arg_type = 0;
								} else {
									if (VALA_IS_UNARY_EXPRESSION (arg)) {
										ValaUnaryExpression* _tmp18;
										ValaUnaryExpression* unary;
										_tmp18 = NULL;
										unary = (_tmp18 = VALA_UNARY_EXPRESSION (arg), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
										if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
											arg_type = 2;
										} else {
											if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
												arg_type = 3;
											}
										}
										(unary == NULL ? NULL : (unary = (vala_code_node_unref (unary), NULL)));
									}
								}
								if (arg_type == 0) {
									if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
										char* _tmp19;
										gboolean _tmp20;
										vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
										_tmp19 = NULL;
										vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp19 = g_strdup_printf ("Argument %d: Cannot pass null to reference parameter", i + 1)));
										_tmp19 = (g_free (_tmp19), NULL);
										return (_tmp20 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp20);
									} else {
										if (vala_code_context_get_non_null (self->priv->_context) && vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT && !vala_data_type_get_nullable (vala_formal_parameter_get_parameter_type (param))) {
											char* _tmp21;
											_tmp21 = NULL;
											vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp21 = g_strdup_printf ("Argument %d: Cannot pass null to non-null parameter type", i + 1)));
											_tmp21 = (g_free (_tmp21), NULL);
										}
									}
								} else {
									if (arg_type == 1) {
										if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
											char* _tmp22;
											gboolean _tmp23;
											vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
											_tmp22 = NULL;
											vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp22 = g_strdup_printf ("Argument %d: Cannot pass value to reference or output parameter", i + 1)));
											_tmp22 = (g_free (_tmp22), NULL);
											return (_tmp23 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp23);
										}
									} else {
										if (arg_type == 2) {
											if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_REF) {
												char* _tmp24;
												gboolean _tmp25;
												vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
												_tmp24 = NULL;
												vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp24 = g_strdup_printf ("Argument %d: Cannot pass ref argument to non-reference parameter", i + 1)));
												_tmp24 = (g_free (_tmp24), NULL);
												return (_tmp25 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp25);
											}
											/* weak variables can only be used with weak ref parameters*/
											if (vala_data_type_is_disposable (vala_formal_parameter_get_parameter_type (param))) {
												if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg))) && !vala_data_type_get_value_owned (vala_expression_get_value_type (arg))) {
													gboolean _tmp26;
													/* variable doesn't own the value */
													vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
													vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), "Invalid assignment from owned expression to unowned variable");
													return (_tmp26 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp26);
												}
											}
										} else {
											if (arg_type == 3) {
												if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
													char* _tmp27;
													gboolean _tmp28;
													vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
													_tmp27 = NULL;
													vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp27 = g_strdup_printf ("Argument %d: Cannot pass out argument to non-output parameter", i + 1)));
													_tmp27 = (g_free (_tmp27), NULL);
													return (_tmp28 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp28);
												}
												/* weak variables can only be used with weak out parameters*/
												if (vala_data_type_is_disposable (vala_formal_parameter_get_parameter_type (param))) {
													if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg))) && !vala_data_type_get_value_owned (vala_expression_get_value_type (arg))) {
														gboolean _tmp29;
														/* variable doesn't own the value */
														vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
														vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), "Invalid assignment from owned expression to unowned variable");
														return (_tmp29 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp29);
													}
												}
											}
										}
									}
								}
							}
						}
					}
					_tmp31 = NULL;
					_tmp30 = NULL;
					prev_arg = (_tmp31 = (_tmp30 = arg, (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), _tmp31);
					i++;
					(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	if (ellipsis) {
		while (arg_it != NULL && gee_iterator_next (arg_it)) {
			ValaExpression* arg;
			arg = ((ValaExpression*) (gee_iterator_get (arg_it)));
			if (vala_code_node_get_error (((ValaCodeNode*) (arg)))) {
				gboolean _tmp32;
				/* ignore inner error*/
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				return (_tmp32 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp32);
			} else {
				if (vala_expression_get_value_type (arg) == NULL) {
					/* disallow untyped arguments except for type inference of callbacks*/
					if (!(VALA_IS_METHOD (vala_expression_get_symbol_reference (arg)))) {
						char* _tmp33;
						gboolean _tmp34;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp33 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp33 = g_strdup_printf ("Invalid type for argument %d", i + 1)));
						_tmp33 = (g_free (_tmp33), NULL);
						return (_tmp34 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp34);
					}
				} else {
					if (vala_expression_get_target_type (arg) != NULL && !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg))) {
						char* _tmp37;
						char* _tmp36;
						char* _tmp35;
						gboolean _tmp38;
						/* target_type known for printf arguments*/
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp37 = NULL;
						_tmp36 = NULL;
						_tmp35 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (arg))), (_tmp37 = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, (_tmp35 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (arg))))), (_tmp36 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (arg))))))));
						_tmp37 = (g_free (_tmp37), NULL);
						_tmp36 = (g_free (_tmp36), NULL);
						_tmp35 = (g_free (_tmp35), NULL);
						return (_tmp38 = FALSE, (arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL))), (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp38);
					}
				}
			}
			i++;
			(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
		}
	} else {
		if (!ellipsis && arg_it != NULL && gee_iterator_next (arg_it)) {
			char* _tmp40;
			char* _tmp39;
			gboolean _tmp41;
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			_tmp40 = NULL;
			_tmp39 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp40 = g_strdup_printf ("Too many arguments, method `%s' does not take %d arguments", (_tmp39 = vala_code_node_to_string (((ValaCodeNode*) (mtype)))), gee_collection_get_size (((GeeCollection*) (args))))));
			_tmp40 = (g_free (_tmp40), NULL);
			_tmp39 = (g_free (_tmp39), NULL);
			return (_tmp41 = FALSE, (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp41);
		}
	}
	if (diag && prev_arg != NULL) {
		ValaStringLiteral* _tmp43;
		ValaExpression* _tmp42;
		ValaStringLiteral* format_arg;
		_tmp43 = NULL;
		_tmp42 = NULL;
		format_arg = (_tmp43 = (_tmp42 = prev_arg, (VALA_IS_STRING_LITERAL (_tmp42) ? ((ValaStringLiteral*) (_tmp42)) : NULL)), (_tmp43 == NULL ? NULL : vala_code_node_ref (_tmp43)));
		if (format_arg != NULL) {
			char* _tmp45;
			char* _tmp44;
			_tmp45 = NULL;
			_tmp44 = NULL;
			vala_string_literal_set_value (format_arg, (_tmp45 = g_strdup_printf ("\"%s:%d: %s", (_tmp44 = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))), vala_source_reference_get_first_line (vala_code_node_get_source_reference (((ValaCodeNode*) (expr)))), g_utf8_offset_to_pointer (vala_string_literal_get_value (format_arg), ((glong) (1))))));
			_tmp45 = (g_free (_tmp45), NULL);
			_tmp44 = (g_free (_tmp44), NULL);
		}
		(format_arg == NULL ? NULL : (format_arg = (vala_code_node_unref (format_arg), NULL)));
	}
	return (_tmp46 = TRUE, (prev_arg == NULL ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL))), (arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL))), _tmp46);
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference) {
	ValaReferenceType* instance_base_type;
	g_return_val_if_fail (instance_type != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* construct a new type reference for the base type with correctly linked type arguments*/
	instance_base_type = NULL;
	if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
		ValaReferenceType* _tmp0;
		_tmp0 = NULL;
		instance_base_type = (_tmp0 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (vala_data_type_get_data_type (base_type))))))), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp0);
	} else {
		ValaReferenceType* _tmp1;
		_tmp1 = NULL;
		instance_base_type = (_tmp1 = ((ValaReferenceType*) (vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_INTERFACE (vala_data_type_get_data_type (base_type))))))), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp1);
	}
	{
		GeeList* type_arg_collection;
		int type_arg_it;
		type_arg_collection = vala_data_type_get_type_arguments (base_type);
		for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
			ValaDataType* type_arg;
			type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
			{
				if (vala_data_type_get_type_parameter (type_arg) != NULL) {
					gint param_index;
					GeeList* _tmp4;
					gboolean _tmp5;
					ValaDataType* _tmp11;
					GeeList* _tmp10;
					/* link to type argument of derived type*/
					param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type_arg)))));
					if (param_index == -1) {
						char* _tmp2;
						ValaDataType* _tmp3;
						_tmp2 = NULL;
						vala_report_error (vala_code_node_get_source_reference (node_reference), (_tmp2 = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type_arg)))))));
						_tmp2 = (g_free (_tmp2), NULL);
						vala_code_node_set_error (node_reference, TRUE);
						_tmp3 = NULL;
						return (_tmp3 = NULL, (type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL))), (type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL))), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp3);
					}
					_tmp4 = NULL;
					if ((_tmp5 = gee_collection_get_size (((GeeCollection*) ((_tmp4 = vala_data_type_get_type_arguments (instance_type))))) <= param_index, (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5)) {
						char* _tmp8;
						char* _tmp7;
						char* _tmp6;
						ValaDataType* _tmp9;
						_tmp8 = NULL;
						_tmp7 = NULL;
						_tmp6 = NULL;
						vala_report_error (vala_code_node_get_source_reference (node_reference), (_tmp8 = g_strdup_printf ("internal error: missing type argument for type parameter `%s' in `%s'", (_tmp6 = vala_symbol_get_full_name (((ValaSymbol*) (vala_data_type_get_type_parameter (type_arg))))), (_tmp7 = vala_code_node_to_string (((ValaCodeNode*) (instance_type)))))));
						_tmp8 = (g_free (_tmp8), NULL);
						_tmp7 = (g_free (_tmp7), NULL);
						_tmp6 = (g_free (_tmp6), NULL);
						vala_code_node_set_error (node_reference, TRUE);
						_tmp9 = NULL;
						return (_tmp9 = NULL, (type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL))), (type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL))), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp9);
					}
					_tmp11 = NULL;
					_tmp10 = NULL;
					type_arg = (_tmp11 = ((ValaDataType*) (gee_list_get ((_tmp10 = vala_data_type_get_type_arguments (instance_type)), param_index))), (type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL))), _tmp11);
					(_tmp10 == NULL ? NULL : (_tmp10 = (gee_collection_object_unref (_tmp10), NULL)));
				}
				vala_data_type_add_type_argument (((ValaDataType*) (instance_base_type)), type_arg);
				(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
			}
		}
		(type_arg_collection == NULL ? NULL : (type_arg_collection = (gee_collection_object_unref (type_arg_collection), NULL)));
	}
	return ((ValaDataType*) (instance_base_type));
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaSymbol* member, ValaCodeNode* node_reference) {
	ValaDataType* _tmp0;
	ValaDataType* instance_type;
	ValaDataType* instance_base_type;
	ValaDataType* _tmp23;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (member != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0 = NULL;
	instance_type = (_tmp0 = derived_instance_type, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	while (VALA_IS_POINTER_TYPE (instance_type)) {
		ValaPointerType* _tmp1;
		ValaPointerType* instance_pointer_type;
		ValaDataType* _tmp3;
		ValaDataType* _tmp2;
		_tmp1 = NULL;
		instance_pointer_type = (_tmp1 = VALA_POINTER_TYPE (instance_type), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		_tmp3 = NULL;
		_tmp2 = NULL;
		instance_type = (_tmp3 = (_tmp2 = vala_pointer_type_get_base_type (instance_pointer_type), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp3);
		(instance_pointer_type == NULL ? NULL : (instance_pointer_type = (vala_code_node_unref (instance_pointer_type), NULL)));
	}
	if (VALA_SYMBOL (vala_data_type_get_data_type (instance_type)) == vala_symbol_get_parent_symbol (member)) {
		return instance_type;
	}
	instance_base_type = NULL;
	/* use same algorithm as symbol_lookup_inherited*/
	if (VALA_IS_CLASS (vala_data_type_get_data_type (instance_type))) {
		ValaClass* _tmp5;
		ValaClass* cl;
		_tmp5 = NULL;
		cl = (_tmp5 = VALA_CLASS (vala_data_type_get_data_type (instance_type)), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						ValaDataType* _tmp7;
						ValaDataType* _tmp6;
						_tmp7 = NULL;
						_tmp6 = NULL;
						instance_base_type = (_tmp7 = vala_semantic_analyzer_get_instance_base_type_for_member ((_tmp6 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference)), member, node_reference), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp7);
						(_tmp6 == NULL ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)));
						if (instance_base_type != NULL) {
							ValaDataType* _tmp8;
							_tmp8 = NULL;
							return (_tmp8 = instance_base_type, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp8);
						}
					}
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
		}
		/* then check base class recursively*/
		if (instance_base_type == NULL) {
			{
				GeeList* base_type_collection;
				int base_type_it;
				base_type_collection = vala_class_get_base_types (cl);
				for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
					ValaDataType* base_type;
					base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
					{
						if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
							ValaDataType* _tmp10;
							ValaDataType* _tmp9;
							_tmp10 = NULL;
							_tmp9 = NULL;
							instance_base_type = (_tmp10 = vala_semantic_analyzer_get_instance_base_type_for_member ((_tmp9 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference)), member, node_reference), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp10);
							(_tmp9 == NULL ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL)));
							if (instance_base_type != NULL) {
								ValaDataType* _tmp11;
								_tmp11 = NULL;
								return (_tmp11 = instance_base_type, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp11);
							}
						}
						(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					}
				}
				(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
			}
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	} else {
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (instance_type))) {
			ValaStruct* _tmp12;
			ValaStruct* st;
			_tmp12 = NULL;
			st = (_tmp12 = VALA_STRUCT (vala_data_type_get_data_type (instance_type)), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
			{
				GeeList* base_type_collection;
				int base_type_it;
				base_type_collection = vala_struct_get_base_types (st);
				for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
					ValaDataType* base_type;
					base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
					{
						ValaDataType* _tmp14;
						ValaDataType* _tmp13;
						_tmp14 = NULL;
						_tmp13 = NULL;
						instance_base_type = (_tmp14 = vala_semantic_analyzer_get_instance_base_type_for_member ((_tmp13 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference)), member, node_reference), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp14);
						(_tmp13 == NULL ? NULL : (_tmp13 = (vala_code_node_unref (_tmp13), NULL)));
						if (instance_base_type != NULL) {
							ValaDataType* _tmp15;
							_tmp15 = NULL;
							return (_tmp15 = instance_base_type, (base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL))), (base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL))), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp15);
						}
						(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					}
				}
				(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
			}
			(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		} else {
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (instance_type))) {
				ValaInterface* _tmp16;
				ValaInterface* iface;
				_tmp16 = NULL;
				iface = (_tmp16 = VALA_INTERFACE (vala_data_type_get_data_type (instance_type)), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16)));
				/* first check interface prerequisites recursively*/
				{
					GeeList* prerequisite_collection;
					int prerequisite_it;
					prerequisite_collection = vala_interface_get_prerequisites (iface);
					for (prerequisite_it = 0; prerequisite_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_collection)); prerequisite_it = prerequisite_it + 1) {
						ValaDataType* prerequisite;
						prerequisite = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_collection), prerequisite_it)));
						{
							if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
								ValaDataType* _tmp18;
								ValaDataType* _tmp17;
								_tmp18 = NULL;
								_tmp17 = NULL;
								instance_base_type = (_tmp18 = vala_semantic_analyzer_get_instance_base_type_for_member ((_tmp17 = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference)), member, node_reference), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp18);
								(_tmp17 == NULL ? NULL : (_tmp17 = (vala_code_node_unref (_tmp17), NULL)));
								if (instance_base_type != NULL) {
									ValaDataType* _tmp19;
									_tmp19 = NULL;
									return (_tmp19 = instance_base_type, (prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL))), (prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp19);
								}
							}
							(prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)));
						}
					}
					(prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL)));
				}
				if (instance_base_type == NULL) {
					/* then check class prerequisite recursively*/
					{
						GeeList* prerequisite_collection;
						int prerequisite_it;
						prerequisite_collection = vala_interface_get_prerequisites (iface);
						for (prerequisite_it = 0; prerequisite_it < gee_collection_get_size (GEE_COLLECTION (prerequisite_collection)); prerequisite_it = prerequisite_it + 1) {
							ValaDataType* prerequisite;
							prerequisite = ((ValaDataType*) (gee_list_get (GEE_LIST (prerequisite_collection), prerequisite_it)));
							{
								if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
									ValaDataType* _tmp21;
									ValaDataType* _tmp20;
									_tmp21 = NULL;
									_tmp20 = NULL;
									instance_base_type = (_tmp21 = vala_semantic_analyzer_get_instance_base_type_for_member ((_tmp20 = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference)), member, node_reference), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp21);
									(_tmp20 == NULL ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL)));
									if (instance_base_type != NULL) {
										ValaDataType* _tmp22;
										_tmp22 = NULL;
										return (_tmp22 = instance_base_type, (prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL))), (prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL))), (iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp22);
									}
								}
								(prerequisite == NULL ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)));
							}
						}
						(prerequisite_collection == NULL ? NULL : (prerequisite_collection = (gee_collection_object_unref (prerequisite_collection), NULL)));
					}
				}
				(iface == NULL ? NULL : (iface = (vala_code_node_unref (iface), NULL)));
			}
		}
	}
	_tmp23 = NULL;
	return (_tmp23 = NULL, (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), (instance_base_type == NULL ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL))), _tmp23);
}


ValaDataType* vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type, ValaSymbol* generic_member, ValaDataType* generic_type, ValaCodeNode* node_reference) {
	ValaDataType* instance_type;
	gint param_index;
	ValaDataType* actual_type;
	GeeList* _tmp4;
	gboolean _tmp5;
	ValaDataType* _tmp10;
	ValaDataType* _tmp11;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (generic_member != NULL, NULL);
	g_return_val_if_fail (generic_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* trace type arguments back to the datatype where the method has been declared*/
	instance_type = vala_semantic_analyzer_get_instance_base_type_for_member (derived_instance_type, generic_member, node_reference);
	if (instance_type == NULL) {
		char* _tmp0;
		ValaDataType* _tmp1;
		_tmp0 = NULL;
		vala_report_error (vala_code_node_get_source_reference (node_reference), (_tmp0 = g_strdup_printf ("internal error: unable to find generic member `%s'", vala_symbol_get_name (generic_member))));
		_tmp0 = (g_free (_tmp0), NULL);
		vala_code_node_set_error (node_reference, TRUE);
		_tmp1 = NULL;
		return (_tmp1 = NULL, (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp1);
	}
	param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (generic_type)))));
	if (param_index == -1) {
		char* _tmp2;
		ValaDataType* _tmp3;
		_tmp2 = NULL;
		vala_report_error (vala_code_node_get_source_reference (node_reference), (_tmp2 = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name (((ValaSymbol*) (vala_data_type_get_type_parameter (generic_type)))))));
		_tmp2 = (g_free (_tmp2), NULL);
		vala_code_node_set_error (node_reference, TRUE);
		_tmp3 = NULL;
		return (_tmp3 = NULL, (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp3);
	}
	actual_type = NULL;
	_tmp4 = NULL;
	if ((_tmp5 = param_index < gee_collection_get_size (((GeeCollection*) ((_tmp4 = vala_data_type_get_type_arguments (instance_type))))), (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5)) {
		ValaDataType* _tmp7;
		GeeList* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		actual_type = (_tmp7 = VALA_DATA_TYPE (((ValaDataType*) (gee_list_get ((_tmp6 = vala_data_type_get_type_arguments (instance_type)), param_index)))), (actual_type == NULL ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL))), _tmp7);
		(_tmp6 == NULL ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)));
	}
	if (actual_type == NULL) {
		ValaDataType* _tmp8;
		ValaDataType* _tmp9;
		/* no actual type available*/
		_tmp8 = NULL;
		_tmp9 = NULL;
		return (_tmp9 = (_tmp8 = generic_type, (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8))), (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), (actual_type == NULL ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL))), _tmp9);
	}
	_tmp10 = NULL;
	actual_type = (_tmp10 = vala_data_type_copy (actual_type), (actual_type == NULL ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL))), _tmp10);
	vala_data_type_set_is_type_argument (actual_type, TRUE);
	vala_data_type_set_value_owned (actual_type, vala_data_type_get_value_owned (actual_type) && vala_data_type_get_value_owned (generic_type));
	_tmp11 = NULL;
	return (_tmp11 = actual_type, (instance_type == NULL ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL))), _tmp11);
}


static void vala_semantic_analyzer_real_visit_element_access (ValaCodeVisitor* base, ValaElementAccess* expr) {
	ValaSemanticAnalyzer * self;
	ValaTypeSymbol* _tmp0;
	ValaTypeSymbol* container_type;
	gboolean index_int_type_check;
	ValaPointerType* _tmp7;
	ValaDataType* _tmp6;
	ValaPointerType* pointer_type;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_element_access_get_container (expr))), ((ValaCodeVisitor*) (self)));
	if (vala_expression_get_value_type (vala_element_access_get_container (expr)) == NULL) {
		/* don't proceed if a child expression failed */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	_tmp0 = NULL;
	container_type = (_tmp0 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr)) && VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		GeeList* _tmp1;
		gboolean _tmp2;
		ValaExpression* _tmp5;
		GeeList* _tmp4;
		ValaDataType* _tmp3;
		/* signal detail access*/
		_tmp1 = NULL;
		if ((_tmp2 = gee_collection_get_size (((GeeCollection*) ((_tmp1 = vala_element_access_get_indices (expr))))) != 1, (_tmp1 == NULL ? NULL : (_tmp1 = (gee_collection_object_unref (_tmp1), NULL))), _tmp2)) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Element access with more than one dimension is not supported for signals");
			(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
			return;
		}
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_expression_set_target_type ((_tmp5 = ((ValaExpression*) (gee_list_get ((_tmp4 = vala_element_access_get_indices (expr)), 0)))), (_tmp3 = vala_data_type_copy (self->priv->string_type)));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL)));
		(_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL)));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)));
	}
	{
		GeeList* index_collection;
		int index_it;
		index_collection = vala_element_access_get_indices (expr);
		for (index_it = 0; index_it < gee_collection_get_size (GEE_COLLECTION (index_collection)); index_it = index_it + 1) {
			ValaExpression* index;
			index = ((ValaExpression*) (gee_list_get (GEE_LIST (index_collection), index_it)));
			{
				vala_code_node_accept (((ValaCodeNode*) (index)), ((ValaCodeVisitor*) (self)));
				(index == NULL ? NULL : (index = (vala_code_node_unref (index), NULL)));
			}
		}
		(index_collection == NULL ? NULL : (index_collection = (gee_collection_object_unref (index_collection), NULL)));
	}
	index_int_type_check = TRUE;
	_tmp7 = NULL;
	_tmp6 = NULL;
	pointer_type = (_tmp7 = (_tmp6 = vala_expression_get_value_type (vala_element_access_get_container (expr)), (VALA_IS_POINTER_TYPE (_tmp6) ? ((ValaPointerType*) (_tmp6)) : NULL)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
	/* assign a value_type when possible */
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container (expr)))) {
		ValaArrayType* _tmp8;
		ValaArrayType* array_type;
		ValaDataType* _tmp9;
		_tmp8 = NULL;
		array_type = (_tmp8 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
		_tmp9 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp9 = vala_data_type_copy (vala_array_type_get_element_type (array_type))));
		(_tmp9 == NULL ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL)));
		if (!vala_expression_get_lvalue (((ValaExpression*) (expr)))) {
			vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), FALSE);
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	} else {
		if (pointer_type != NULL && !vala_data_type_is_reference_type_or_type_parameter (vala_pointer_type_get_base_type (pointer_type))) {
			ValaDataType* _tmp10;
			_tmp10 = NULL;
			vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp10 = vala_data_type_copy (vala_pointer_type_get_base_type (pointer_type))));
			(_tmp10 == NULL ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL)));
		} else {
			if (container_type == vala_data_type_get_data_type (self->priv->string_type)) {
				GeeList* _tmp11;
				gboolean _tmp12;
				_tmp11 = NULL;
				if ((_tmp12 = gee_collection_get_size (((GeeCollection*) ((_tmp11 = vala_element_access_get_indices (expr))))) != 1, (_tmp11 == NULL ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL))), _tmp12)) {
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Element access with more than one dimension is not supported for strings");
					(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
					(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
					return;
				}
				vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->unichar_type);
			} else {
				if (container_type != NULL && self->priv->list_type != NULL && self->priv->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->list_type))) || vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->map_type))))) {
					GeeList* indices;
					GeeIterator* indices_it;
					ValaExpression* index;
					ValaSymbol* get_sym;
					ValaMethod* _tmp15;
					ValaMethod* get_method;
					GeeList* get_params;
					GeeIterator* get_params_it;
					ValaFormalParameter* get_param;
					ValaDataType* _tmp16;
					ValaDataType* index_type;
					ValaDataType* _tmp22;
					ValaDataType* _tmp21;
					indices = vala_element_access_get_indices (expr);
					if (gee_collection_get_size (((GeeCollection*) (indices))) != 1) {
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Element access with more than one dimension is not supported for the specified type");
						(indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL)));
						(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
						(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
						return;
					}
					indices_it = gee_iterable_iterator (((GeeIterable*) (indices)));
					gee_iterator_next (indices_it);
					index = ((ValaExpression*) (gee_iterator_get (indices_it)));
					index_int_type_check = FALSE;
					/* lookup symbol in interface instead of class as implemented interface methods are not in VAPI files*/
					get_sym = NULL;
					if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->list_type)))) {
						ValaSymbol* _tmp13;
						_tmp13 = NULL;
						get_sym = (_tmp13 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->priv->list_type))), "get"), (get_sym == NULL ? NULL : (get_sym = (vala_code_node_unref (get_sym), NULL))), _tmp13);
					} else {
						if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->map_type)))) {
							ValaSymbol* _tmp14;
							_tmp14 = NULL;
							get_sym = (_tmp14 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->priv->map_type))), "get"), (get_sym == NULL ? NULL : (get_sym = (vala_code_node_unref (get_sym), NULL))), _tmp14);
						}
					}
					_tmp15 = NULL;
					get_method = (_tmp15 = VALA_METHOD (get_sym), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
					get_params = vala_method_get_parameters (get_method);
					get_params_it = gee_iterable_iterator (((GeeIterable*) (get_params)));
					gee_iterator_next (get_params_it);
					get_param = ((ValaFormalParameter*) (gee_iterator_get (get_params_it)));
					_tmp16 = NULL;
					index_type = (_tmp16 = vala_formal_parameter_get_parameter_type (get_param), (_tmp16 == NULL ? NULL : vala_code_node_ref (_tmp16)));
					if (vala_data_type_get_type_parameter (index_type) != NULL) {
						ValaDataType* _tmp17;
						_tmp17 = NULL;
						index_type = (_tmp17 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), ((ValaSymbol*) (get_method)), vala_formal_parameter_get_parameter_type (get_param), ((ValaCodeNode*) (expr))), (index_type == NULL ? NULL : (index_type = (vala_code_node_unref (index_type), NULL))), _tmp17);
					}
					if (!vala_data_type_compatible (vala_expression_get_value_type (index), index_type)) {
						char* _tmp20;
						char* _tmp19;
						char* _tmp18;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp20 = NULL;
						_tmp19 = NULL;
						_tmp18 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp20 = g_strdup_printf ("index expression: Cannot convert from `%s' to `%s'", (_tmp18 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (index))))), (_tmp19 = vala_code_node_to_string (((ValaCodeNode*) (index_type)))))));
						_tmp20 = (g_free (_tmp20), NULL);
						_tmp19 = (g_free (_tmp19), NULL);
						_tmp18 = (g_free (_tmp18), NULL);
						(indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL)));
						(indices_it == NULL ? NULL : (indices_it = (gee_collection_object_unref (indices_it), NULL)));
						(index == NULL ? NULL : (index = (vala_code_node_unref (index), NULL)));
						(get_sym == NULL ? NULL : (get_sym = (vala_code_node_unref (get_sym), NULL)));
						(get_method == NULL ? NULL : (get_method = (vala_code_node_unref (get_method), NULL)));
						(get_params == NULL ? NULL : (get_params = (gee_collection_object_unref (get_params), NULL)));
						(get_params_it == NULL ? NULL : (get_params_it = (gee_collection_object_unref (get_params_it), NULL)));
						(get_param == NULL ? NULL : (get_param = (vala_code_node_unref (get_param), NULL)));
						(index_type == NULL ? NULL : (index_type = (vala_code_node_unref (index_type), NULL)));
						(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
						(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
						return;
					}
					_tmp22 = NULL;
					_tmp21 = NULL;
					vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp22 = vala_data_type_copy ((_tmp21 = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), ((ValaSymbol*) (get_method)), vala_method_get_return_type (get_method), ((ValaCodeNode*) (expr)))))));
					(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
					(_tmp21 == NULL ? NULL : (_tmp21 = (vala_code_node_unref (_tmp21), NULL)));
					if (vala_expression_get_lvalue (((ValaExpression*) (expr)))) {
						/* get () returns owned value, set () accepts unowned value*/
						vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), FALSE);
					}
					(indices == NULL ? NULL : (indices = (gee_collection_object_unref (indices), NULL)));
					(indices_it == NULL ? NULL : (indices_it = (gee_collection_object_unref (indices_it), NULL)));
					(index == NULL ? NULL : (index = (vala_code_node_unref (index), NULL)));
					(get_sym == NULL ? NULL : (get_sym = (vala_code_node_unref (get_sym), NULL)));
					(get_method == NULL ? NULL : (get_method = (vala_code_node_unref (get_method), NULL)));
					(get_params == NULL ? NULL : (get_params = (gee_collection_object_unref (get_params), NULL)));
					(get_params_it == NULL ? NULL : (get_params_it = (gee_collection_object_unref (get_params_it), NULL)));
					(get_param == NULL ? NULL : (get_param = (vala_code_node_unref (get_param), NULL)));
					(index_type == NULL ? NULL : (index_type = (vala_code_node_unref (index_type), NULL)));
				} else {
					if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr)) && VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
						index_int_type_check = FALSE;
						vala_expression_set_symbol_reference (((ValaExpression*) (expr)), vala_expression_get_symbol_reference (vala_element_access_get_container (expr)));
						vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_element_access_get_container (expr)));
					} else {
						char* _tmp24;
						char* _tmp23;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp24 = NULL;
						_tmp23 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp24 = g_strdup_printf ("The expression `%s' does not denote an Array", (_tmp23 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_element_access_get_container (expr)))))))));
						_tmp24 = (g_free (_tmp24), NULL);
						_tmp23 = (g_free (_tmp23), NULL);
					}
				}
			}
		}
	}
	if (index_int_type_check) {
		/* check if the index is of type integer */
		{
			GeeList* e_collection;
			int e_it;
			e_collection = vala_element_access_get_indices (expr);
			for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
				ValaExpression* e;
				e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
				{
					/* don't proceed if a child expression failed */
					if (vala_expression_get_value_type (e) == NULL) {
						(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
						(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
						(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
						(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
						return;
					}
					/* check if the index is of type integer */
					if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (vala_expression_get_value_type (e)))) || !vala_struct_is_integer_type ((VALA_STRUCT (vala_data_type_get_data_type (vala_expression_get_value_type (e)))))) {
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (e))), "Expression of integer type expected");
					}
					(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
				}
			}
			(e_collection == NULL ? NULL : (e_collection = (gee_collection_object_unref (e_collection), NULL)));
		}
	}
	(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
	(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
}


static gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	gboolean _tmp10;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	while (sym != NULL) {
		ValaSymbol* _tmp9;
		ValaSymbol* _tmp8;
		if (VALA_IS_CREATION_METHOD (sym)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp1);
		} else {
			if (VALA_IS_METHOD (sym)) {
				ValaMethod* _tmp2;
				ValaMethod* m;
				gboolean _tmp3;
				_tmp2 = NULL;
				m = (_tmp2 = VALA_METHOD (sym), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
				return (_tmp3 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE, (m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp3);
			} else {
				if (VALA_IS_CONSTRUCTOR (sym)) {
					ValaConstructor* _tmp4;
					ValaConstructor* c;
					gboolean _tmp5;
					_tmp4 = NULL;
					c = (_tmp4 = VALA_CONSTRUCTOR (sym), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
					return (_tmp5 = vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE, (c == NULL ? NULL : (c = (vala_code_node_unref (c), NULL))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp5);
				} else {
					if (VALA_IS_DESTRUCTOR (sym)) {
						gboolean _tmp6;
						return (_tmp6 = TRUE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp6);
					} else {
						if (VALA_IS_PROPERTY (sym)) {
							gboolean _tmp7;
							return (_tmp7 = TRUE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp7);
						}
					}
				}
			}
		}
		_tmp9 = NULL;
		_tmp8 = NULL;
		sym = (_tmp9 = (_tmp8 = vala_symbol_get_parent_symbol (sym), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp9);
	}
	return (_tmp10 = FALSE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp10);
}


static void vala_semantic_analyzer_real_visit_base_access (ValaCodeVisitor* base, ValaBaseAccess* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (!vala_semantic_analyzer_is_in_instance_method (self)) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Base access invalid outside of instance methods");
		return;
	}
	if (self->priv->current_class == NULL) {
		GeeList* _tmp4;
		GeeIterator* _tmp5;
		GeeIterator* base_type_it;
		ValaDataType* _tmp6;
		if (self->priv->current_struct == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Base access invalid outside of class and struct");
			return;
		} else {
			GeeList* _tmp0;
			gboolean _tmp1;
			_tmp0 = NULL;
			if ((_tmp1 = gee_collection_get_size (((GeeCollection*) ((_tmp0 = vala_struct_get_base_types (self->priv->current_struct))))) != 1, (_tmp0 == NULL ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL))), _tmp1)) {
				char* _tmp3;
				GeeList* _tmp2;
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp3 = g_strdup_printf ("Base access invalid without base type %d", gee_collection_get_size (((GeeCollection*) ((_tmp2 = vala_struct_get_base_types (self->priv->current_struct))))))));
				_tmp3 = (g_free (_tmp3), NULL);
				(_tmp2 == NULL ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)));
				return;
			}
		}
		_tmp4 = NULL;
		_tmp5 = NULL;
		base_type_it = (_tmp5 = gee_iterable_iterator (((GeeIterable*) ((_tmp4 = vala_struct_get_base_types (self->priv->current_struct))))), (_tmp4 == NULL ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL))), _tmp5);
		gee_iterator_next (base_type_it);
		_tmp6 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp6 = ((ValaDataType*) (gee_iterator_get (base_type_it)))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL)));
		(base_type_it == NULL ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)));
	} else {
		if (vala_class_get_base_class (self->priv->current_class) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Base access invalid without base class");
			return;
		} else {
			ValaObjectType* _tmp7;
			_tmp7 = NULL;
			vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp7 = vala_object_type_new (((ValaObjectTypeSymbol*) (vala_class_get_base_class (self->priv->current_class))))))));
			(_tmp7 == NULL ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL)));
		}
	}
	vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (vala_data_type_get_data_type (vala_expression_get_value_type (((ValaExpression*) (expr)))))));
}


static void vala_semantic_analyzer_real_visit_postfix_expression (ValaCodeVisitor* base, ValaPostfixExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_postfix_expression_get_inner (expr)));
}


static void vala_semantic_analyzer_real_visit_object_creation_expression (ValaCodeVisitor* base, ValaObjectCreationExpression* expr) {
	ValaSemanticAnalyzer * self;
	ValaTypeSymbol* type;
	ValaDataType* _tmp21;
	GeeList* _tmp22;
	gint _tmp23;
	gint given_num_type_args;
	gint expected_num_type_args;
	GeeList* _tmp32;
	gboolean _tmp33;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_object_creation_expression_get_member_name (expr) != NULL) {
		vala_code_node_accept (((ValaCodeNode*) (vala_object_creation_expression_get_member_name (expr))), ((ValaCodeVisitor*) (self)));
	}
	type = NULL;
	if (vala_object_creation_expression_get_type_reference (expr) == NULL) {
		ValaSymbol* _tmp0;
		ValaSymbol* constructor_sym;
		ValaSymbol* _tmp1;
		ValaSymbol* type_sym;
		GeeList* type_args;
		if (vala_object_creation_expression_get_member_name (expr) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Incomplete object creation expression");
			(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			return;
		}
		if (vala_expression_get_symbol_reference (((ValaExpression*) (vala_object_creation_expression_get_member_name (expr)))) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			return;
		}
		_tmp0 = NULL;
		constructor_sym = (_tmp0 = vala_expression_get_symbol_reference (((ValaExpression*) (vala_object_creation_expression_get_member_name (expr)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		_tmp1 = NULL;
		type_sym = (_tmp1 = vala_expression_get_symbol_reference (((ValaExpression*) (vala_object_creation_expression_get_member_name (expr)))), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
		type_args = vala_member_access_get_type_arguments (vala_object_creation_expression_get_member_name (expr));
		if (VALA_IS_METHOD (constructor_sym)) {
			ValaSymbol* _tmp3;
			ValaSymbol* _tmp2;
			ValaMethod* _tmp4;
			ValaMethod* constructor;
			ValaMemberAccess* _tmp8;
			ValaExpression* _tmp7;
			ValaMemberAccess* ma;
			_tmp3 = NULL;
			_tmp2 = NULL;
			type_sym = (_tmp3 = (_tmp2 = vala_symbol_get_parent_symbol (constructor_sym), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (type_sym == NULL ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL))), _tmp3);
			_tmp4 = NULL;
			constructor = (_tmp4 = VALA_METHOD (constructor_sym), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4)));
			if (!(VALA_IS_CREATION_METHOD (constructor_sym))) {
				char* _tmp6;
				char* _tmp5;
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp6 = g_strdup_printf ("`%s' is not a creation method", (_tmp5 = vala_symbol_get_full_name (((ValaSymbol*) (constructor)))))));
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp5 = (g_free (_tmp5), NULL);
				(constructor == NULL ? NULL : (constructor = (vala_code_node_unref (constructor), NULL)));
				(constructor_sym == NULL ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL)));
				(type_sym == NULL ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)));
				(type_args == NULL ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)));
				(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
				return;
			}
			vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (constructor)));
			/* inner expression can also be base access when chaining constructors*/
			_tmp8 = NULL;
			_tmp7 = NULL;
			ma = (_tmp8 = (_tmp7 = vala_member_access_get_inner (vala_object_creation_expression_get_member_name (expr)), (VALA_IS_MEMBER_ACCESS (_tmp7) ? ((ValaMemberAccess*) (_tmp7)) : NULL)), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
			if (ma != NULL) {
				GeeList* _tmp9;
				_tmp9 = NULL;
				type_args = (_tmp9 = vala_member_access_get_type_arguments (ma), (type_args == NULL ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL))), _tmp9);
			}
			(constructor == NULL ? NULL : (constructor = (vala_code_node_unref (constructor), NULL)));
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
		if (VALA_IS_CLASS (type_sym)) {
			ValaTypeSymbol* _tmp11;
			ValaTypeSymbol* _tmp10;
			ValaObjectType* _tmp12;
			_tmp11 = NULL;
			_tmp10 = NULL;
			type = (_tmp11 = (_tmp10 = VALA_TYPESYMBOL (type_sym), (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp11);
			_tmp12 = NULL;
			vala_object_creation_expression_set_type_reference (expr, ((ValaDataType*) ((_tmp12 = vala_object_type_new (((ValaObjectTypeSymbol*) (VALA_CLASS (type))))))));
			(_tmp12 == NULL ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL)));
		} else {
			if (VALA_IS_STRUCT (type_sym)) {
				ValaTypeSymbol* _tmp14;
				ValaTypeSymbol* _tmp13;
				ValaValueType* _tmp15;
				_tmp14 = NULL;
				_tmp13 = NULL;
				type = (_tmp14 = (_tmp13 = VALA_TYPESYMBOL (type_sym), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp14);
				_tmp15 = NULL;
				vala_object_creation_expression_set_type_reference (expr, ((ValaDataType*) ((_tmp15 = vala_value_type_new (type)))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_code_node_unref (_tmp15), NULL)));
			} else {
				if (VALA_IS_ERROR_CODE (type_sym)) {
					ValaErrorType* _tmp16;
					_tmp16 = NULL;
					vala_object_creation_expression_set_type_reference (expr, ((ValaDataType*) ((_tmp16 = vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (type_sym)), VALA_ERROR_CODE (type_sym), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))))))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL)));
					vala_expression_set_symbol_reference (((ValaExpression*) (expr)), type_sym);
				} else {
					char* _tmp18;
					char* _tmp17;
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp18 = g_strdup_printf ("`%s' is not a class, struct, or error code", (_tmp17 = vala_symbol_get_full_name (type_sym)))));
					_tmp18 = (g_free (_tmp18), NULL);
					_tmp17 = (g_free (_tmp17), NULL);
					(constructor_sym == NULL ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL)));
					(type_sym == NULL ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)));
					(type_args == NULL ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)));
					(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
					return;
				}
			}
		}
		{
			GeeList* type_arg_collection;
			int type_arg_it;
			type_arg_collection = type_args;
			for (type_arg_it = 0; type_arg_it < gee_collection_get_size (GEE_COLLECTION (type_arg_collection)); type_arg_it = type_arg_it + 1) {
				ValaDataType* type_arg;
				type_arg = ((ValaDataType*) (gee_list_get (GEE_LIST (type_arg_collection), type_arg_it)));
				{
					vala_data_type_add_type_argument (vala_object_creation_expression_get_type_reference (expr), type_arg);
					vala_source_file_add_type_dependency (self->priv->_current_source_file, type_arg, VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
					(type_arg == NULL ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)));
				}
			}
		}
		(constructor_sym == NULL ? NULL : (constructor_sym = (vala_code_node_unref (constructor_sym), NULL)));
		(type_sym == NULL ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL)));
		(type_args == NULL ? NULL : (type_args = (gee_collection_object_unref (type_args), NULL)));
	} else {
		ValaTypeSymbol* _tmp20;
		ValaTypeSymbol* _tmp19;
		_tmp20 = NULL;
		_tmp19 = NULL;
		type = (_tmp20 = (_tmp19 = vala_data_type_get_data_type (vala_object_creation_expression_get_type_reference (expr)), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19))), (type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL))), _tmp20);
	}
	vala_source_file_add_symbol_dependency (self->priv->_current_source_file, ((ValaSymbol*) (type)), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	_tmp21 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp21 = vala_data_type_copy (vala_object_creation_expression_get_type_reference (expr))));
	(_tmp21 == NULL ? NULL : (_tmp21 = (vala_code_node_unref (_tmp21), NULL)));
	vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE);
	_tmp22 = NULL;
	given_num_type_args = (_tmp23 = gee_collection_get_size (((GeeCollection*) ((_tmp22 = vala_data_type_get_type_arguments (vala_object_creation_expression_get_type_reference (expr)))))), (_tmp22 == NULL ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL))), _tmp23);
	expected_num_type_args = 0;
	if (VALA_IS_CLASS (type)) {
		ValaClass* _tmp24;
		ValaClass* cl;
		GeeList* _tmp25;
		_tmp24 = NULL;
		cl = (_tmp24 = VALA_CLASS (type), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
		_tmp25 = NULL;
		expected_num_type_args = gee_collection_get_size (((GeeCollection*) ((_tmp25 = vala_class_get_type_parameters (cl)))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (gee_collection_object_unref (_tmp25), NULL)));
		if (vala_object_creation_expression_get_struct_creation (expr)) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "syntax error, use `new' to create new objects");
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			return;
		}
		if (vala_class_get_is_abstract (cl)) {
			char* _tmp27;
			char* _tmp26;
			vala_expression_set_value_type (((ValaExpression*) (expr)), NULL);
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			_tmp27 = NULL;
			_tmp26 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp27 = g_strdup_printf ("Can't create instance of abstract class `%s'", (_tmp26 = vala_symbol_get_full_name (((ValaSymbol*) (cl)))))));
			_tmp27 = (g_free (_tmp27), NULL);
			_tmp26 = (g_free (_tmp26), NULL);
			(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
			(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			return;
		}
		if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
			vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (vala_class_get_default_construction_method (cl))));
		}
		while (cl != NULL) {
			ValaClass* _tmp29;
			ValaClass* _tmp28;
			if (VALA_TYPESYMBOL (cl) == self->priv->initially_unowned_type) {
				vala_data_type_set_floating_reference (vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE);
				break;
			}
			_tmp29 = NULL;
			_tmp28 = NULL;
			cl = (_tmp29 = (_tmp28 = vala_class_get_base_class (cl), (_tmp28 == NULL ? NULL : vala_code_node_ref (_tmp28))), (cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL))), _tmp29);
		}
		(cl == NULL ? NULL : (cl = (vala_code_node_unref (cl), NULL)));
	} else {
		if (VALA_IS_STRUCT (type)) {
			ValaStruct* _tmp30;
			ValaStruct* st;
			GeeList* _tmp31;
			_tmp30 = NULL;
			st = (_tmp30 = VALA_STRUCT (type), (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30)));
			_tmp31 = NULL;
			expected_num_type_args = gee_collection_get_size (((GeeCollection*) ((_tmp31 = vala_struct_get_type_parameters (st)))));
			(_tmp31 == NULL ? NULL : (_tmp31 = (gee_collection_object_unref (_tmp31), NULL)));
			if (!vala_object_creation_expression_get_struct_creation (expr)) {
				vala_report_warning (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "deprecated syntax, don't use `new' to initialize structs");
			}
			if (vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL) {
				vala_expression_set_symbol_reference (((ValaExpression*) (expr)), ((ValaSymbol*) (vala_struct_get_default_construction_method (st))));
			}
			(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
		}
	}
	if (expected_num_type_args > given_num_type_args) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "too few type arguments");
		(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
		return;
	} else {
		if (expected_num_type_args < given_num_type_args) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "too many type arguments");
			(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
			return;
		}
	}
	_tmp32 = NULL;
	if ((_tmp33 = vala_expression_get_symbol_reference (((ValaExpression*) (expr))) == NULL && gee_collection_get_size (((GeeCollection*) ((_tmp32 = vala_object_creation_expression_get_argument_list (expr))))) != 0, (_tmp32 == NULL ? NULL : (_tmp32 = (gee_collection_object_unref (_tmp32), NULL))), _tmp33)) {
		char* _tmp35;
		char* _tmp34;
		vala_expression_set_value_type (((ValaExpression*) (expr)), NULL);
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		_tmp35 = NULL;
		_tmp34 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp35 = g_strdup_printf ("No arguments allowed when constructing type `%s'", (_tmp34 = vala_symbol_get_full_name (((ValaSymbol*) (type)))))));
		_tmp35 = (g_free (_tmp35), NULL);
		_tmp34 = (g_free (_tmp34), NULL);
		(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
		return;
	}
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr))))) {
		ValaMethod* _tmp36;
		ValaMethod* m;
		GeeList* args;
		GeeIterator* arg_it;
		GeeList* _tmp38;
		ValaMethodType* _tmp37;
		_tmp36 = NULL;
		m = (_tmp36 = VALA_METHOD (vala_expression_get_symbol_reference (((ValaExpression*) (expr)))), (_tmp36 == NULL ? NULL : vala_code_node_ref (_tmp36)));
		args = vala_object_creation_expression_get_argument_list (expr);
		arg_it = gee_iterable_iterator (((GeeIterable*) (args)));
		{
			GeeList* param_collection;
			int param_it;
			param_collection = vala_method_get_parameters (m);
			for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
				ValaFormalParameter* param;
				param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
				{
					if (vala_formal_parameter_get_ellipsis (param)) {
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						break;
					}
					if (gee_iterator_next (arg_it)) {
						ValaExpression* arg;
						arg = ((ValaExpression*) (gee_iterator_get (arg_it)));
						/* store expected type for callback parameters */
						vala_expression_set_target_type (arg, vala_formal_parameter_get_parameter_type (param));
						(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
					}
					(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				}
			}
			(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
		}
		{
			GeeList* arg_collection;
			int arg_it;
			arg_collection = args;
			for (arg_it = 0; arg_it < gee_collection_get_size (GEE_COLLECTION (arg_collection)); arg_it = arg_it + 1) {
				ValaExpression* arg;
				arg = ((ValaExpression*) (gee_list_get (GEE_LIST (arg_collection), arg_it)));
				{
					vala_code_node_accept (((ValaCodeNode*) (arg)), ((ValaCodeVisitor*) (self)));
					(arg == NULL ? NULL : (arg = (vala_code_node_unref (arg), NULL)));
				}
			}
		}
		_tmp38 = NULL;
		_tmp37 = NULL;
		vala_semantic_analyzer_check_arguments (self, ((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp37 = vala_method_type_new (m)))), (_tmp38 = vala_method_get_parameters (m)), args);
		(_tmp38 == NULL ? NULL : (_tmp38 = (gee_collection_object_unref (_tmp38), NULL)));
		(_tmp37 == NULL ? NULL : (_tmp37 = (vala_code_node_unref (_tmp37), NULL)));
		{
			GeeList* error_type_collection;
			int error_type_it;
			error_type_collection = vala_code_node_get_error_types (((ValaCodeNode*) (m)));
			for (error_type_it = 0; error_type_it < gee_collection_get_size (GEE_COLLECTION (error_type_collection)); error_type_it = error_type_it + 1) {
				ValaDataType* error_type;
				error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (error_type_collection), error_type_it)));
				{
					ValaDataType* call_error_type;
					/* ensure we can trace back which expression may throw errors of this type*/
					call_error_type = vala_data_type_copy (error_type);
					vala_code_node_set_source_reference (((ValaCodeNode*) (call_error_type)), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
					vala_code_node_add_error_type (((ValaCodeNode*) (expr)), call_error_type);
					(error_type == NULL ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)));
					(call_error_type == NULL ? NULL : (call_error_type = (vala_code_node_unref (call_error_type), NULL)));
				}
			}
			(error_type_collection == NULL ? NULL : (error_type_collection = (gee_collection_object_unref (error_type_collection), NULL)));
		}
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
		(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
		(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_object_creation_expression_get_type_reference (expr))) {
			GeeList* _tmp39;
			gboolean _tmp40;
			vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (self)));
			_tmp39 = NULL;
			if ((_tmp40 = gee_collection_get_size (((GeeCollection*) ((_tmp39 = vala_object_creation_expression_get_argument_list (expr))))) == 0, (_tmp39 == NULL ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL))), _tmp40)) {
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Too few arguments, errors need at least 1 argument");
			} else {
				GeeList* _tmp41;
				GeeIterator* _tmp42;
				GeeIterator* arg_it;
				ValaExpression* ex;
				_tmp41 = NULL;
				_tmp42 = NULL;
				arg_it = (_tmp42 = gee_iterable_iterator (((GeeIterable*) ((_tmp41 = vala_object_creation_expression_get_argument_list (expr))))), (_tmp41 == NULL ? NULL : (_tmp41 = (gee_collection_object_unref (_tmp41), NULL))), _tmp42);
				gee_iterator_next (arg_it);
				ex = ((ValaExpression*) (gee_iterator_get (arg_it)));
				if (vala_expression_get_value_type (ex) == NULL || !vala_data_type_compatible (vala_expression_get_value_type (ex), self->priv->string_type)) {
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Invalid type for argument 1");
				}
				(arg_it == NULL ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)));
				(ex == NULL ? NULL : (ex = (vala_code_node_unref (ex), NULL)));
			}
		}
	}
	{
		GeeList* init_collection;
		int init_it;
		init_collection = vala_object_creation_expression_get_object_initializer (expr);
		for (init_it = 0; init_it < gee_collection_get_size (GEE_COLLECTION (init_collection)); init_it = init_it + 1) {
			ValaMemberInitializer* init;
			init = ((ValaMemberInitializer*) (gee_list_get (GEE_LIST (init_collection), init_it)));
			{
				vala_semantic_analyzer_visit_member_initializer (self, init, vala_object_creation_expression_get_type_reference (expr));
				(init == NULL ? NULL : (init = (vala_code_node_unref (init), NULL)));
			}
		}
		(init_collection == NULL ? NULL : (init_collection = (gee_collection_object_unref (init_collection), NULL)));
	}
	(type == NULL ? NULL : (type = (vala_code_node_unref (type), NULL)));
}


static void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type) {
	ValaSymbol* _tmp0;
	ValaDataType* member_type;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	g_return_if_fail (type != NULL);
	vala_code_node_accept (((ValaCodeNode*) (init)), ((ValaCodeVisitor*) (self)));
	_tmp0 = NULL;
	vala_member_initializer_set_symbol_reference (init, (_tmp0 = vala_semantic_analyzer_symbol_lookup_inherited (((ValaSymbol*) (vala_data_type_get_data_type (type))), vala_member_initializer_get_name (init))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	if (!(VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init)) || VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init)))) {
		char* _tmp2;
		char* _tmp1;
		vala_code_node_set_error (((ValaCodeNode*) (init)), TRUE);
		_tmp2 = NULL;
		_tmp1 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (init))), (_tmp2 = g_strdup_printf ("Invalid member `%s' in `%s'", vala_member_initializer_get_name (init), (_tmp1 = vala_symbol_get_full_name (((ValaSymbol*) (vala_data_type_get_data_type (type))))))));
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp1 = (g_free (_tmp1), NULL);
		return;
	}
	if (vala_symbol_get_access (vala_member_initializer_get_symbol_reference (init)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		char* _tmp4;
		char* _tmp3;
		vala_code_node_set_error (((ValaCodeNode*) (init)), TRUE);
		_tmp4 = NULL;
		_tmp3 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (init))), (_tmp4 = g_strdup_printf ("Access to private member `%s' denied", (_tmp3 = vala_symbol_get_full_name (vala_member_initializer_get_symbol_reference (init))))));
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
		return;
	}
	member_type = NULL;
	if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
		ValaField* _tmp5;
		ValaField* f;
		ValaDataType* _tmp7;
		ValaDataType* _tmp6;
		_tmp5 = NULL;
		f = (_tmp5 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp5 == NULL ? NULL : vala_code_node_ref (_tmp5)));
		_tmp7 = NULL;
		_tmp6 = NULL;
		member_type = (_tmp7 = (_tmp6 = vala_field_get_field_type (f), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (member_type == NULL ? NULL : (member_type = (vala_code_node_unref (member_type), NULL))), _tmp7);
		(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
	} else {
		if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
			ValaProperty* _tmp8;
			ValaProperty* prop;
			ValaDataType* _tmp10;
			ValaDataType* _tmp9;
			_tmp8 = NULL;
			prop = (_tmp8 = VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
			_tmp10 = NULL;
			_tmp9 = NULL;
			member_type = (_tmp10 = (_tmp9 = vala_property_get_property_type (prop), (_tmp9 == NULL ? NULL : vala_code_node_ref (_tmp9))), (member_type == NULL ? NULL : (member_type = (vala_code_node_unref (member_type), NULL))), _tmp10);
			if (vala_property_get_set_accessor (prop) == NULL || !vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp12;
				char* _tmp11;
				vala_code_node_set_error (((ValaCodeNode*) (init)), TRUE);
				_tmp12 = NULL;
				_tmp11 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (init))), (_tmp12 = g_strdup_printf ("Property `%s' is read-only", (_tmp11 = vala_symbol_get_full_name (((ValaSymbol*) (prop)))))));
				_tmp12 = (g_free (_tmp12), NULL);
				_tmp11 = (g_free (_tmp11), NULL);
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(member_type == NULL ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)));
				return;
			}
			(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
		}
	}
	if (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)) == NULL || !vala_data_type_compatible (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)), member_type)) {
		char* _tmp13;
		vala_code_node_set_error (((ValaCodeNode*) (init)), TRUE);
		_tmp13 = NULL;
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (init))), (_tmp13 = g_strdup_printf ("Invalid type for member `%s'", vala_member_initializer_get_name (init))));
		_tmp13 = (g_free (_tmp13), NULL);
		(member_type == NULL ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)));
		return;
	}
	(member_type == NULL ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)));
}


static void vala_semantic_analyzer_real_visit_sizeof_expression (ValaCodeVisitor* base, ValaSizeofExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->ulong_type);
}


static void vala_semantic_analyzer_real_visit_typeof_expression (ValaCodeVisitor* base, ValaTypeofExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->type_type);
}


static gboolean vala_semantic_analyzer_is_numeric_type (ValaSemanticAnalyzer* self, ValaDataType* type) {
	ValaStruct* _tmp1;
	ValaStruct* st;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (type)))) {
		return FALSE;
	}
	_tmp1 = NULL;
	st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	return (_tmp2 = vala_struct_is_integer_type (st) || vala_struct_is_floating_type (st), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), _tmp2);
}


static gboolean vala_semantic_analyzer_is_integer_type (ValaSemanticAnalyzer* self, ValaDataType* type) {
	ValaStruct* _tmp1;
	ValaStruct* st;
	gboolean _tmp2;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (type)))) {
		return FALSE;
	}
	_tmp1 = NULL;
	st = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	return (_tmp2 = vala_struct_is_integer_type (st), (st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL))), _tmp2);
}


static void vala_semantic_analyzer_real_visit_unary_expression (ValaCodeVisitor* base, ValaUnaryExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF || vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
		vala_expression_set_lvalue (vala_unary_expression_get_inner (expr), TRUE);
		vala_expression_set_target_type (vala_unary_expression_get_inner (expr), vala_expression_get_target_type (((ValaExpression*) (expr))));
	}
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_unary_expression_get_inner (expr))))) {
		/* if there was an error in the inner expression, skip type check */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_PLUS || vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_MINUS) {
		/* integer or floating point type*/
		if (!vala_semantic_analyzer_is_numeric_type (self, vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))) {
			char* _tmp1;
			char* _tmp0;
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			_tmp1 = NULL;
			_tmp0 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp1 = g_strdup_printf ("Operator not supported for `%s'", (_tmp0 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))))))));
			_tmp1 = (g_free (_tmp1), NULL);
			_tmp0 = (g_free (_tmp0), NULL);
			return;
		}
		vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_unary_expression_get_inner (expr)));
	} else {
		if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
			/* boolean type*/
			if (!vala_data_type_compatible (vala_expression_get_value_type (vala_unary_expression_get_inner (expr)), self->priv->bool_type)) {
				char* _tmp3;
				char* _tmp2;
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				_tmp3 = NULL;
				_tmp2 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp3 = g_strdup_printf ("Operator not supported for `%s'", (_tmp2 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))))))));
				_tmp3 = (g_free (_tmp3), NULL);
				_tmp2 = (g_free (_tmp2), NULL);
				return;
			}
			vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_unary_expression_get_inner (expr)));
		} else {
			if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
				/* integer type*/
				if (!vala_semantic_analyzer_is_integer_type (self, vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))) {
					char* _tmp5;
					char* _tmp4;
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					_tmp5 = NULL;
					_tmp4 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp5 = g_strdup_printf ("Operator not supported for `%s'", (_tmp4 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))))))));
					_tmp5 = (g_free (_tmp5), NULL);
					_tmp4 = (g_free (_tmp4), NULL);
					return;
				}
				vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_unary_expression_get_inner (expr)));
			} else {
				if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT || vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_DECREMENT) {
					ValaMemberAccess* ma;
					ValaMemberAccess* old_value;
					ValaIntegerLiteral* _tmp8;
					ValaBinaryExpression* _tmp9;
					ValaBinaryExpression* bin;
					ValaAssignment* assignment;
					ValaParenthesizedExpression* parenthexp;
					/* integer type*/
					if (!vala_semantic_analyzer_is_integer_type (self, vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))) {
						char* _tmp7;
						char* _tmp6;
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						_tmp7 = NULL;
						_tmp6 = NULL;
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp7 = g_strdup_printf ("Operator not supported for `%s'", (_tmp6 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_unary_expression_get_inner (expr)))))))));
						_tmp7 = (g_free (_tmp7), NULL);
						_tmp6 = (g_free (_tmp6), NULL);
						return;
					}
					ma = vala_semantic_analyzer_find_member_access (self, vala_unary_expression_get_inner (expr));
					if (ma == NULL) {
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Prefix operators not supported for this expression");
						(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
						return;
					}
					old_value = vala_member_access_new (vala_member_access_get_inner (ma), vala_member_access_get_member_name (ma), vala_code_node_get_source_reference (((ValaCodeNode*) (vala_unary_expression_get_inner (expr)))));
					_tmp8 = NULL;
					_tmp9 = NULL;
					bin = (_tmp9 = vala_binary_expression_new ((vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_INCREMENT ? VALA_BINARY_OPERATOR_PLUS : VALA_BINARY_OPERATOR_MINUS), ((ValaExpression*) (old_value)), ((ValaExpression*) ((_tmp8 = vala_integer_literal_new ("1", NULL)))), vala_code_node_get_source_reference (((ValaCodeNode*) (expr)))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL))), _tmp9);
					assignment = vala_assignment_new (((ValaExpression*) (ma)), ((ValaExpression*) (bin)), VALA_ASSIGNMENT_OPERATOR_SIMPLE, vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
					parenthexp = vala_parenthesized_expression_new (((ValaExpression*) (assignment)), vala_code_node_get_source_reference (((ValaCodeNode*) (expr))));
					vala_expression_set_target_type (((ValaExpression*) (parenthexp)), vala_expression_get_target_type (((ValaExpression*) (expr))));
					gee_collection_add (((GeeCollection*) (self->priv->replaced_nodes)), ((ValaCodeNode*) (expr)));
					vala_code_node_replace_expression (vala_code_node_get_parent_node (((ValaCodeNode*) (expr))), ((ValaExpression*) (expr)), ((ValaExpression*) (parenthexp)));
					vala_code_node_accept (((ValaCodeNode*) (parenthexp)), ((ValaCodeVisitor*) (self)));
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					(old_value == NULL ? NULL : (old_value = (vala_code_node_unref (old_value), NULL)));
					(bin == NULL ? NULL : (bin = (vala_code_node_unref (bin), NULL)));
					(assignment == NULL ? NULL : (assignment = (vala_code_node_unref (assignment), NULL)));
					(parenthexp == NULL ? NULL : (parenthexp = (vala_code_node_unref (parenthexp), NULL)));
					return;
				} else {
					if (vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_REF || vala_unary_expression_get_operator (expr) == VALA_UNARY_OPERATOR_OUT) {
						if (VALA_IS_FIELD (vala_expression_get_symbol_reference (vala_unary_expression_get_inner (expr))) || VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (vala_unary_expression_get_inner (expr))) || VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (vala_unary_expression_get_inner (expr)))) {
							/* ref and out can only be used with fields, parameters, and local variables*/
							vala_expression_set_lvalue (((ValaExpression*) (expr)), TRUE);
							vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_unary_expression_get_inner (expr)));
						} else {
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "ref and out method arguments can only be used with fields, parameters, and local variables");
							return;
						}
					} else {
						vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "internal error: unsupported unary operator");
						return;
					}
				}
			}
		}
	}
}


static ValaMemberAccess* vala_semantic_analyzer_find_member_access (ValaSemanticAnalyzer* self, ValaExpression* expr) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (VALA_IS_PARENTHESIZED_EXPRESSION (expr)) {
		ValaParenthesizedExpression* _tmp0;
		ValaParenthesizedExpression* pe;
		ValaMemberAccess* _tmp1;
		_tmp0 = NULL;
		pe = (_tmp0 = VALA_PARENTHESIZED_EXPRESSION (expr), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		_tmp1 = NULL;
		return (_tmp1 = vala_semantic_analyzer_find_member_access (self, vala_parenthesized_expression_get_inner (pe)), (pe == NULL ? NULL : (pe = (vala_code_node_unref (pe), NULL))), _tmp1);
	}
	if (VALA_IS_MEMBER_ACCESS (expr)) {
		ValaMemberAccess* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = VALA_MEMBER_ACCESS (expr), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	}
	return NULL;
}


static void vala_semantic_analyzer_real_visit_cast_expression (ValaCodeVisitor* base, ValaCastExpression* expr) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_cast_expression_get_inner (expr))))) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	/* FIXME: check whether cast is allowed*/
	vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_cast_expression_get_type_reference (expr), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	vala_expression_set_value_type (((ValaExpression*) (expr)), vala_cast_expression_get_type_reference (expr));
	vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_cast_expression_get_inner (expr))));
	_tmp0 = NULL;
	vala_expression_set_target_type (vala_cast_expression_get_inner (expr), (_tmp0 = vala_data_type_copy (vala_expression_get_value_type (vala_cast_expression_get_inner (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
}


static void vala_semantic_analyzer_real_visit_pointer_indirection (ValaCodeVisitor* base, ValaPointerIndirection* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_pointer_indirection_get_inner (expr))))) {
		return;
	}
	if (vala_expression_get_value_type (vala_pointer_indirection_get_inner (expr)) == NULL) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "internal error: unknown type of inner expression");
		return;
	}
	if (VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_pointer_indirection_get_inner (expr)))) {
		ValaPointerType* _tmp0;
		ValaPointerType* pointer_type;
		_tmp0 = NULL;
		pointer_type = (_tmp0 = VALA_POINTER_TYPE (vala_expression_get_value_type (vala_pointer_indirection_get_inner (expr))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (VALA_IS_REFERENCE_TYPE (vala_pointer_type_get_base_type (pointer_type))) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Pointer indirection not supported for this expression");
			(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
			return;
		}
		vala_expression_set_value_type (((ValaExpression*) (expr)), vala_pointer_type_get_base_type (pointer_type));
		(pointer_type == NULL ? NULL : (pointer_type = (vala_code_node_unref (pointer_type), NULL)));
	} else {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Pointer indirection not supported for this expression");
		return;
	}
}


static void vala_semantic_analyzer_real_visit_addressof_expression (ValaCodeVisitor* base, ValaAddressofExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_addressof_expression_get_inner (expr))))) {
		return;
	}
	if (!(VALA_IS_VALUE_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr))) || VALA_IS_OBJECT_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr))) || VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr))))) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Address-of operator not supported for this expression");
		return;
	}
	if (vala_data_type_is_reference_type_or_type_parameter (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr)))) {
		ValaPointerType* _tmp1;
		ValaPointerType* _tmp0;
		_tmp1 = NULL;
		_tmp0 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp1 = vala_pointer_type_new (((ValaDataType*) ((_tmp0 = vala_pointer_type_new (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr)), NULL)))), NULL)))));
		(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	} else {
		ValaPointerType* _tmp2;
		_tmp2 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), ((ValaDataType*) ((_tmp2 = vala_pointer_type_new (vala_expression_get_value_type (vala_addressof_expression_get_inner (expr)), NULL)))));
		(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	}
}


static void vala_semantic_analyzer_real_visit_reference_transfer_expression (ValaCodeVisitor* base, ValaReferenceTransferExpression* expr) {
	ValaSemanticAnalyzer * self;
	ValaDataType* _tmp0;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	vala_expression_set_lvalue (vala_reference_transfer_expression_get_inner (expr), TRUE);
	vala_code_node_accept_children (((ValaCodeNode*) (expr)), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_reference_transfer_expression_get_inner (expr))))) {
		/* if there was an error in the inner expression, skip type check */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (!(VALA_IS_MEMBER_ACCESS (vala_reference_transfer_expression_get_inner (expr)) || VALA_IS_ELEMENT_ACCESS (vala_reference_transfer_expression_get_inner (expr)))) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Reference transfer not supported for this expression");
		return;
	}
	if (!vala_data_type_is_disposable (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (expr))) && !(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (expr))))) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "No reference to be transferred");
		return;
	}
	_tmp0 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp0 = vala_data_type_copy (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (expr)))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE);
}


static ValaDataType* vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self, ValaDataType* left_type, ValaDataType* right_type) {
	ValaStruct* _tmp1;
	ValaStruct* left;
	ValaStruct* _tmp2;
	ValaStruct* right;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (left_type != NULL, NULL);
	g_return_val_if_fail (right_type != NULL, NULL);
	if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (left_type))) || !(VALA_IS_STRUCT (vala_data_type_get_data_type (right_type)))) {
		/* at least one operand not struct*/
		return NULL;
	}
	_tmp1 = NULL;
	left = (_tmp1 = VALA_STRUCT (vala_data_type_get_data_type (left_type)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	right = (_tmp2 = VALA_STRUCT (vala_data_type_get_data_type (right_type)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	if ((!vala_struct_is_floating_type (left) && !vala_struct_is_integer_type (left)) || (!vala_struct_is_floating_type (right) && !vala_struct_is_integer_type (right))) {
		ValaDataType* _tmp3;
		/* at least one operand not numeric*/
		_tmp3 = NULL;
		return (_tmp3 = NULL, (left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL))), (right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL))), _tmp3);
	}
	if (vala_struct_is_floating_type (left) == vala_struct_is_floating_type (right)) {
		/* both operands integer or floating type*/
		if (vala_struct_get_rank (left) >= vala_struct_get_rank (right)) {
			ValaDataType* _tmp4;
			ValaDataType* _tmp5;
			_tmp4 = NULL;
			_tmp5 = NULL;
			return (_tmp5 = (_tmp4 = left_type, (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4))), (left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL))), (right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL))), _tmp5);
		} else {
			ValaDataType* _tmp6;
			ValaDataType* _tmp7;
			_tmp6 = NULL;
			_tmp7 = NULL;
			return (_tmp7 = (_tmp6 = right_type, (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6))), (left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL))), (right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL))), _tmp7);
		}
	} else {
		/* one integer and one floating type operand*/
		if (vala_struct_is_floating_type (left)) {
			ValaDataType* _tmp8;
			ValaDataType* _tmp9;
			_tmp8 = NULL;
			_tmp9 = NULL;
			return (_tmp9 = (_tmp8 = left_type, (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8))), (left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL))), (right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL))), _tmp9);
		} else {
			ValaDataType* _tmp10;
			ValaDataType* _tmp11;
			_tmp10 = NULL;
			_tmp11 = NULL;
			return (_tmp11 = (_tmp10 = right_type, (_tmp10 == NULL ? NULL : vala_code_node_ref (_tmp10))), (left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL))), (right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL))), _tmp11);
		}
	}
	(left == NULL ? NULL : (left = (vala_code_node_unref (left), NULL)));
	(right == NULL ? NULL : (right = (vala_code_node_unref (right), NULL)));
}


static void vala_semantic_analyzer_real_visit_binary_expression (ValaCodeVisitor* base, ValaBinaryExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_binary_expression_get_left (expr)))) || vala_code_node_get_error (((ValaCodeNode*) (vala_binary_expression_get_right (expr))))) {
		/* if there were any errors in inner expressions, skip type check */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (vala_expression_get_value_type (vala_binary_expression_get_left (expr)) == NULL) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_binary_expression_get_left (expr)))), "invalid left operand");
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (vala_binary_expression_get_operator (expr) != VALA_BINARY_OPERATOR_IN && vala_expression_get_value_type (vala_binary_expression_get_right (expr)) == NULL) {
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_binary_expression_get_right (expr)))), "invalid right operand");
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	if (vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_left (expr))) == vala_data_type_get_data_type (self->priv->string_type) && vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS) {
		ValaDataType* _tmp0;
		/* string concatenation*/
		if (vala_expression_get_value_type (vala_binary_expression_get_right (expr)) == NULL || vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))) != vala_data_type_get_data_type (self->priv->string_type)) {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Operands must be strings");
			return;
		}
		_tmp0 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp0 = vala_data_type_copy (self->priv->string_type)));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
		if (vala_expression_is_constant (vala_binary_expression_get_left (expr)) && vala_expression_is_constant (vala_binary_expression_get_right (expr))) {
			vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), FALSE);
		} else {
			vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (expr))), TRUE);
		}
	} else {
		if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MUL || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_DIV) {
			/* check for pointer arithmetic*/
			if (VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))) {
				ValaStruct* _tmp2;
				ValaTypeSymbol* _tmp1;
				ValaStruct* offset_type;
				_tmp2 = NULL;
				_tmp1 = NULL;
				offset_type = (_tmp2 = (_tmp1 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), (VALA_IS_STRUCT (_tmp1) ? ((ValaStruct*) (_tmp1)) : NULL)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
				if (offset_type != NULL && vala_struct_is_integer_type (offset_type)) {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_PLUS || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MINUS) {
						ValaDataType* _tmp3;
						/* pointer arithmetic: pointer +/- offset*/
						_tmp3 = NULL;
						vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp3 = vala_data_type_copy (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))));
						(_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)));
					}
				} else {
					if (VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
						/* pointer arithmetic: pointer - pointer*/
						vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->size_t_type);
					}
				}
				(offset_type == NULL ? NULL : (offset_type = (vala_code_node_unref (offset_type), NULL)));
			}
			if (vala_expression_get_value_type (((ValaExpression*) (expr))) == NULL) {
				ValaDataType* _tmp4;
				_tmp4 = NULL;
				vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp4 = vala_semantic_analyzer_get_arithmetic_result_type (self, vala_expression_get_value_type (vala_binary_expression_get_left (expr)), vala_expression_get_value_type (vala_binary_expression_get_right (expr)))));
				(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
			}
			if (vala_expression_get_value_type (((ValaExpression*) (expr))) == NULL) {
				char* _tmp7;
				char* _tmp6;
				char* _tmp5;
				vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
				_tmp7 = NULL;
				_tmp6 = NULL;
				_tmp5 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp7 = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", (_tmp5 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))))), (_tmp6 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))))))));
				_tmp7 = (g_free (_tmp7), NULL);
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp5 = (g_free (_tmp5), NULL);
				return;
			}
		} else {
			if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_MOD || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_LEFT || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_SHIFT_RIGHT || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_XOR) {
				ValaDataType* _tmp8;
				_tmp8 = NULL;
				vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp8 = vala_semantic_analyzer_get_arithmetic_result_type (self, vala_expression_get_value_type (vala_binary_expression_get_left (expr)), vala_expression_get_value_type (vala_binary_expression_get_right (expr)))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL)));
				if (vala_expression_get_value_type (((ValaExpression*) (expr))) == NULL) {
					char* _tmp11;
					char* _tmp10;
					char* _tmp9;
					vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
					_tmp11 = NULL;
					_tmp10 = NULL;
					_tmp9 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp11 = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", (_tmp9 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))))), (_tmp10 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))))))));
					_tmp11 = (g_free (_tmp11), NULL);
					_tmp10 = (g_free (_tmp10), NULL);
					_tmp9 = (g_free (_tmp9), NULL);
					return;
				}
			} else {
				if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL) {
					if (vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->priv->string_type) && vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->priv->string_type)) {
					} else {
						if (VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_binary_expression_get_left (expr))) && VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
						} else {
							ValaDataType* resulting_type;
							/* pointer arithmetic*/
							resulting_type = vala_semantic_analyzer_get_arithmetic_result_type (self, vala_expression_get_value_type (vala_binary_expression_get_left (expr)), vala_expression_get_value_type (vala_binary_expression_get_right (expr)));
							if (resulting_type == NULL) {
								char* _tmp14;
								char* _tmp13;
								char* _tmp12;
								vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
								_tmp14 = NULL;
								_tmp13 = NULL;
								_tmp12 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp14 = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", (_tmp12 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))))), (_tmp13 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))))))));
								_tmp14 = (g_free (_tmp14), NULL);
								_tmp13 = (g_free (_tmp13), NULL);
								_tmp12 = (g_free (_tmp12), NULL);
								(resulting_type == NULL ? NULL : (resulting_type = (vala_code_node_unref (resulting_type), NULL)));
								return;
							}
							(resulting_type == NULL ? NULL : (resulting_type = (vala_code_node_unref (resulting_type), NULL)));
						}
					}
					vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
				} else {
					if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_EQUALITY || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_INEQUALITY) {
						/* relational operation */
						if (!vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), vala_expression_get_value_type (vala_binary_expression_get_left (expr))) && !vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), vala_expression_get_value_type (vala_binary_expression_get_right (expr)))) {
							char* _tmp17;
							char* _tmp16;
							char* _tmp15;
							_tmp17 = NULL;
							_tmp16 = NULL;
							_tmp15 = NULL;
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), (_tmp17 = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", (_tmp15 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_right (expr)))))), (_tmp16 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_binary_expression_get_left (expr)))))))));
							_tmp17 = (g_free (_tmp17), NULL);
							_tmp16 = (g_free (_tmp16), NULL);
							_tmp15 = (g_free (_tmp15), NULL);
							vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
							return;
						}
						if (vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->priv->string_type) && vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->priv->string_type)) {
						}
						/* string comparison*/
						vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
					} else {
						if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_AND || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_BITWISE_OR) {
							/* integer type or flags type*/
							vala_expression_set_value_type (((ValaExpression*) (expr)), vala_expression_get_value_type (vala_binary_expression_get_left (expr)));
						} else {
							if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_AND || vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_OR) {
								if (!vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_left (expr)), self->priv->bool_type) || !vala_data_type_compatible (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), self->priv->bool_type)) {
									vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (expr))), "Operands must be boolean");
								}
								vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
							} else {
								if (vala_binary_expression_get_operator (expr) == VALA_BINARY_OPERATOR_IN) {
									ValaTypeSymbol* _tmp18;
									ValaTypeSymbol* container_type;
									/* integer type or flags type or collection/map
									 handle collections and maps */
									_tmp18 = NULL;
									container_type = (_tmp18 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr))), (_tmp18 == NULL ? NULL : vala_code_node_ref (_tmp18)));
									if ((self->priv->collection_type != NULL && vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->collection_type)))) || (self->priv->map_type != NULL && vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->map_type))))) {
										ValaSymbol* contains_sym;
										ValaMethod* _tmp21;
										ValaMethod* contains_method;
										GeeList* contains_params;
										GeeIterator* contains_params_it;
										ValaFormalParameter* contains_param;
										ValaDataType* key_type;
										contains_sym = NULL;
										if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->collection_type)))) {
											ValaSymbol* _tmp19;
											_tmp19 = NULL;
											contains_sym = (_tmp19 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->priv->collection_type))), "contains"), (contains_sym == NULL ? NULL : (contains_sym = (vala_code_node_unref (contains_sym), NULL))), _tmp19);
										} else {
											if (vala_typesymbol_is_subtype_of (container_type, ((ValaTypeSymbol*) (self->priv->map_type)))) {
												ValaSymbol* _tmp20;
												_tmp20 = NULL;
												contains_sym = (_tmp20 = vala_scope_lookup (vala_symbol_get_scope (((ValaSymbol*) (self->priv->map_type))), "contains"), (contains_sym == NULL ? NULL : (contains_sym = (vala_code_node_unref (contains_sym), NULL))), _tmp20);
											}
										}
										_tmp21 = NULL;
										contains_method = (_tmp21 = VALA_METHOD (contains_sym), (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21)));
										contains_params = vala_method_get_parameters (contains_method);
										contains_params_it = gee_iterable_iterator (((GeeIterable*) (contains_params)));
										gee_iterator_next (contains_params_it);
										contains_param = ((ValaFormalParameter*) (gee_iterator_get (contains_params_it)));
										key_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_binary_expression_get_right (expr)), ((ValaSymbol*) (contains_method)), vala_formal_parameter_get_parameter_type (contains_param), ((ValaCodeNode*) (expr)));
										vala_expression_set_target_type (vala_binary_expression_get_left (expr), key_type);
										(contains_sym == NULL ? NULL : (contains_sym = (vala_code_node_unref (contains_sym), NULL)));
										(contains_method == NULL ? NULL : (contains_method = (vala_code_node_unref (contains_method), NULL)));
										(contains_params == NULL ? NULL : (contains_params = (gee_collection_object_unref (contains_params), NULL)));
										(contains_params_it == NULL ? NULL : (contains_params_it = (gee_collection_object_unref (contains_params_it), NULL)));
										(contains_param == NULL ? NULL : (contains_param = (vala_code_node_unref (contains_param), NULL)));
										(key_type == NULL ? NULL : (key_type = (vala_code_node_unref (key_type), NULL)));
									}
									vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
									(container_type == NULL ? NULL : (container_type = (vala_code_node_unref (container_type), NULL)));
								} else {
									g_assert_not_reached ();
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_semantic_analyzer_real_visit_type_check (ValaCodeVisitor* base, ValaTypeCheck* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_data_type_get_data_type (vala_typecheck_get_type_reference (expr)) == NULL) {
		/* if type resolving didn't succeed, skip this check */
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		return;
	}
	vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_typecheck_get_type_reference (expr), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	vala_expression_set_value_type (((ValaExpression*) (expr)), self->priv->bool_type);
}


static void vala_semantic_analyzer_real_visit_conditional_expression (ValaCodeVisitor* base, ValaConditionalExpression* expr) {
	ValaSemanticAnalyzer * self;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (expr != NULL);
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_conditional_expression_get_condition (expr)))) || vala_code_node_get_error (((ValaCodeNode*) (vala_conditional_expression_get_false_expression (expr)))) || vala_code_node_get_error (((ValaCodeNode*) (vala_conditional_expression_get_true_expression (expr))))) {
		return;
	}
	if (!vala_data_type_compatible (vala_expression_get_value_type (vala_conditional_expression_get_condition (expr)), self->priv->bool_type)) {
		vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_conditional_expression_get_condition (expr)))), "Condition must be boolean");
		return;
	}
	/* FIXME: support memory management */
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_conditional_expression_get_false_expression (expr)), vala_expression_get_value_type (vala_conditional_expression_get_true_expression (expr)))) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp0 = vala_data_type_copy (vala_expression_get_value_type (vala_conditional_expression_get_true_expression (expr)))));
		(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	} else {
		if (vala_data_type_compatible (vala_expression_get_value_type (vala_conditional_expression_get_true_expression (expr)), vala_expression_get_value_type (vala_conditional_expression_get_false_expression (expr)))) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			vala_expression_set_value_type (((ValaExpression*) (expr)), (_tmp1 = vala_data_type_copy (vala_expression_get_value_type (vala_conditional_expression_get_false_expression (expr)))));
			(_tmp1 == NULL ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL)));
		} else {
			vala_code_node_set_error (((ValaCodeNode*) (expr)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_conditional_expression_get_condition (expr)))), "Incompatible expressions");
			return;
		}
	}
}


static char* vala_semantic_analyzer_get_lambda_name (ValaSemanticAnalyzer* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = g_strdup_printf ("__lambda%d", self->priv->next_lambda_id);
	self->priv->next_lambda_id++;
	return result;
}


static ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	ValaMethod* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	while (sym != NULL) {
		ValaSymbol* _tmp4;
		ValaSymbol* _tmp3;
		if (VALA_IS_METHOD (sym)) {
			ValaMethod* _tmp1;
			ValaMethod* _tmp2;
			_tmp1 = NULL;
			_tmp2 = NULL;
			return (_tmp2 = (_tmp1 = VALA_METHOD (sym), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp2);
		}
		_tmp4 = NULL;
		_tmp3 = NULL;
		sym = (_tmp4 = (_tmp3 = vala_symbol_get_parent_symbol (sym), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp4);
	}
	_tmp5 = NULL;
	return (_tmp5 = NULL, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp5);
}


static gboolean vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	while (sym != NULL) {
		ValaSymbol* _tmp3;
		ValaSymbol* _tmp2;
		if (VALA_IS_CONSTRUCTOR (sym)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp1);
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		sym = (_tmp3 = (_tmp2 = vala_symbol_get_parent_symbol (sym), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp3);
	}
	return (_tmp4 = FALSE, (sym == NULL ? NULL : (sym = (vala_code_node_unref (sym), NULL))), _tmp4);
}


static void vala_semantic_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base, ValaLambdaExpression* l) {
	ValaSemanticAnalyzer * self;
	gboolean in_instance_method;
	ValaMethod* current_method;
	ValaDelegate* _tmp0;
	ValaDelegate* cb;
	ValaMethod* _tmp2;
	char* _tmp1;
	GeeList* lambda_params;
	GeeIterator* lambda_param_it;
	ValaMethodType* _tmp5;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (l != NULL);
	if (!(VALA_IS_DELEGATE_TYPE (vala_expression_get_target_type (((ValaExpression*) (l)))))) {
		vala_code_node_set_error (((ValaCodeNode*) (l)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (l))), "lambda expression not allowed in this context");
		return;
	}
	in_instance_method = FALSE;
	current_method = vala_semantic_analyzer_find_current_method (self);
	if (current_method != NULL) {
		in_instance_method = (vala_method_get_binding (current_method) == MEMBER_BINDING_INSTANCE);
	} else {
		in_instance_method = vala_semantic_analyzer_is_in_constructor (self);
	}
	_tmp0 = NULL;
	cb = (_tmp0 = VALA_DELEGATE (vala_delegate_type_get_delegate_symbol ((VALA_DELEGATE_TYPE (vala_expression_get_target_type (((ValaExpression*) (l))))))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_lambda_expression_set_method (l, (_tmp2 = vala_method_new ((_tmp1 = vala_semantic_analyzer_get_lambda_name (self)), vala_delegate_get_return_type (cb), NULL)));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	if (!vala_delegate_get_has_target (cb) || !in_instance_method) {
		vala_method_set_binding (vala_lambda_expression_get_method (l), MEMBER_BINDING_STATIC);
	}
	vala_symbol_set_owner (((ValaSymbol*) (vala_lambda_expression_get_method (l))), vala_symbol_get_scope (self->priv->_current_symbol));
	lambda_params = vala_lambda_expression_get_parameters (l);
	lambda_param_it = gee_iterable_iterator (((GeeIterable*) (lambda_params)));
	{
		GeeList* cb_param_collection;
		int cb_param_it;
		cb_param_collection = vala_delegate_get_parameters (cb);
		for (cb_param_it = 0; cb_param_it < gee_collection_get_size (GEE_COLLECTION (cb_param_collection)); cb_param_it = cb_param_it + 1) {
			ValaFormalParameter* cb_param;
			cb_param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (cb_param_collection), cb_param_it)));
			{
				char* lambda_param;
				ValaFormalParameter* param;
				if (!gee_iterator_next (lambda_param_it)) {
					/* lambda expressions are allowed to have less parameters */
					(cb_param == NULL ? NULL : (cb_param = (vala_code_node_unref (cb_param), NULL)));
					break;
				}
				lambda_param = ((char*) (gee_iterator_get (lambda_param_it)));
				param = vala_formal_parameter_new (lambda_param, vala_formal_parameter_get_parameter_type (cb_param), NULL);
				vala_method_add_parameter (vala_lambda_expression_get_method (l), param);
				(cb_param == NULL ? NULL : (cb_param = (vala_code_node_unref (cb_param), NULL)));
				lambda_param = (g_free (lambda_param), NULL);
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(cb_param_collection == NULL ? NULL : (cb_param_collection = (gee_collection_object_unref (cb_param_collection), NULL)));
	}
	if (gee_iterator_next (lambda_param_it)) {
		/* lambda expressions may not expect more parameters */
		vala_code_node_set_error (((ValaCodeNode*) (l)), TRUE);
		vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (l))), "lambda expression: too many parameters");
		(current_method == NULL ? NULL : (current_method = (vala_code_node_unref (current_method), NULL)));
		(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
		(lambda_params == NULL ? NULL : (lambda_params = (gee_collection_object_unref (lambda_params), NULL)));
		(lambda_param_it == NULL ? NULL : (lambda_param_it = (gee_collection_object_unref (lambda_param_it), NULL)));
		return;
	}
	if (vala_lambda_expression_get_expression_body (l) != NULL) {
		ValaBlock* block;
		block = vala_block_new (vala_code_node_get_source_reference (((ValaCodeNode*) (l))));
		vala_scope_set_parent_scope (vala_symbol_get_scope (((ValaSymbol*) (block))), vala_symbol_get_scope (((ValaSymbol*) (vala_lambda_expression_get_method (l)))));
		if (vala_data_type_get_data_type (vala_method_get_return_type (vala_lambda_expression_get_method (l))) != NULL) {
			ValaReturnStatement* _tmp3;
			_tmp3 = NULL;
			vala_block_add_statement (block, ((ValaStatement*) ((_tmp3 = vala_return_statement_new (vala_lambda_expression_get_expression_body (l), vala_code_node_get_source_reference (((ValaCodeNode*) (l))))))));
			(_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)));
		} else {
			ValaExpressionStatement* _tmp4;
			_tmp4 = NULL;
			vala_block_add_statement (block, ((ValaStatement*) ((_tmp4 = vala_expression_statement_new (vala_lambda_expression_get_expression_body (l), vala_code_node_get_source_reference (((ValaCodeNode*) (l))))))));
			(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
		}
		vala_method_set_body (vala_lambda_expression_get_method (l), block);
		(block == NULL ? NULL : (block = (vala_code_node_unref (block), NULL)));
	} else {
		vala_method_set_body (vala_lambda_expression_get_method (l), vala_lambda_expression_get_statement_body (l));
	}
	vala_symbol_set_owner (((ValaSymbol*) (vala_method_get_body (vala_lambda_expression_get_method (l)))), vala_symbol_get_scope (((ValaSymbol*) (vala_lambda_expression_get_method (l)))));
	/* lambda expressions should be usable like MemberAccess of a method */
	vala_expression_set_symbol_reference (((ValaExpression*) (l)), ((ValaSymbol*) (vala_lambda_expression_get_method (l))));
	vala_code_node_accept_children (((ValaCodeNode*) (l)), ((ValaCodeVisitor*) (self)));
	_tmp5 = NULL;
	vala_expression_set_value_type (((ValaExpression*) (l)), ((ValaDataType*) ((_tmp5 = vala_method_type_new (vala_lambda_expression_get_method (l))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL)));
	(current_method == NULL ? NULL : (current_method = (vala_code_node_unref (current_method), NULL)));
	(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
	(lambda_params == NULL ? NULL : (lambda_params = (gee_collection_object_unref (lambda_params), NULL)));
	(lambda_param_it == NULL ? NULL : (lambda_param_it = (gee_collection_object_unref (lambda_param_it), NULL)));
}


static void vala_semantic_analyzer_real_visit_assignment (ValaCodeVisitor* base, ValaAssignment* a) {
	ValaSemanticAnalyzer * self;
	GeeList* _tmp65;
	GeeList* _tmp66;
	self = ((ValaSemanticAnalyzer*) (base));
	g_return_if_fail (a != NULL);
	vala_expression_set_lvalue (vala_assignment_get_left (a), TRUE);
	vala_code_node_accept (((ValaCodeNode*) (vala_assignment_get_left (a))), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_assignment_get_left (a))))) {
		/* skip on error in inner expression*/
		vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
		return;
	}
	if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* _tmp0;
		ValaMemberAccess* ma;
		_tmp0 = NULL;
		ma = (_tmp0 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (!(VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))) || VALA_IS_DYNAMIC_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) && vala_expression_get_value_type (((ValaExpression*) (ma))) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "unsupported lvalue in assignment");
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			return;
		}
		if (vala_member_access_get_prototype_access (ma)) {
			char* _tmp2;
			char* _tmp1;
			vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
			_tmp2 = NULL;
			_tmp1 = NULL;
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), (_tmp2 = g_strdup_printf ("Access to instance member `%s' denied", (_tmp1 = vala_symbol_get_full_name (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))))));
			_tmp2 = (g_free (_tmp2), NULL);
			_tmp1 = (g_free (_tmp1), NULL);
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			return;
		}
		if (vala_code_node_get_error (((ValaCodeNode*) (ma))) || vala_expression_get_symbol_reference (((ValaExpression*) (ma))) == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
			/* if no symbol found, skip this check */
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
			return;
		}
		if (VALA_IS_DYNAMIC_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
		} else {
			if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
				ValaSignal* _tmp3;
				ValaSignal* sig;
				ValaDelegateType* _tmp5;
				ValaDelegate* _tmp4;
				_tmp3 = NULL;
				sig = (_tmp3 = VALA_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
				_tmp5 = NULL;
				_tmp4 = NULL;
				vala_expression_set_target_type (vala_assignment_get_right (a), ((ValaDataType*) ((_tmp5 = vala_delegate_type_new ((_tmp4 = vala_signal_get_delegate (sig, vala_expression_get_value_type (vala_member_access_get_inner (ma)))))))));
				(_tmp5 == NULL ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL)));
				(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
				(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
			} else {
				vala_expression_set_target_type (vala_assignment_get_right (a), vala_expression_get_value_type (((ValaExpression*) (ma))));
			}
		}
		(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	} else {
		if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (a))) {
			ValaElementAccess* _tmp6;
			ValaElementAccess* ea;
			_tmp6 = NULL;
			ea = (_tmp6 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (a)), (_tmp6 == NULL ? NULL : vala_code_node_ref (_tmp6)));
			if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (ea)) && VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (ea)))) {
				ValaMemberAccess* _tmp7;
				ValaMemberAccess* ma;
				ValaSignal* _tmp8;
				ValaSignal* sig;
				ValaDelegateType* _tmp10;
				ValaDelegate* _tmp9;
				_tmp7 = NULL;
				ma = (_tmp7 = VALA_MEMBER_ACCESS (vala_element_access_get_container (ea)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
				_tmp8 = NULL;
				sig = (_tmp8 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (ea))), (_tmp8 == NULL ? NULL : vala_code_node_ref (_tmp8)));
				_tmp10 = NULL;
				_tmp9 = NULL;
				vala_expression_set_target_type (vala_assignment_get_right (a), ((ValaDataType*) ((_tmp10 = vala_delegate_type_new ((_tmp9 = vala_signal_get_delegate (sig, vala_expression_get_value_type (vala_member_access_get_inner (ma)))))))));
				(_tmp10 == NULL ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL)));
				(_tmp9 == NULL ? NULL : (_tmp9 = (vala_code_node_unref (_tmp9), NULL)));
				(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
				(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
			} else {
				vala_expression_set_target_type (vala_assignment_get_right (a), vala_expression_get_value_type (vala_assignment_get_left (a)));
			}
			(ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL)));
		} else {
			if (VALA_IS_POINTER_INDIRECTION (vala_assignment_get_left (a))) {
				vala_expression_set_target_type (vala_assignment_get_right (a), vala_expression_get_value_type (vala_assignment_get_left (a)));
			} else {
				vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "unsupported lvalue in assignment");
				return;
			}
		}
	}
	vala_code_node_accept (((ValaCodeNode*) (vala_assignment_get_right (a))), ((ValaCodeVisitor*) (self)));
	if (vala_code_node_get_error (((ValaCodeNode*) (vala_assignment_get_right (a))))) {
		/* skip on error in inner expression*/
		vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
		return;
	}
	if (vala_assignment_get_operator (a) != VALA_ASSIGNMENT_OPERATOR_SIMPLE && VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
		ValaMemberAccess* _tmp11;
		ValaMemberAccess* ma;
		/* transform into simple assignment
		 FIXME: only do this if the backend doesn't support
		 the assignment natively*/
		_tmp11 = NULL;
		ma = (_tmp11 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (_tmp11 == NULL ? NULL : vala_code_node_ref (_tmp11)));
		if (!(VALA_IS_SIGNAL (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))))) {
			ValaMemberAccess* old_value;
			ValaParenthesizedExpression* _tmp12;
			ValaBinaryExpression* _tmp13;
			ValaBinaryExpression* bin;
			ValaDataType* _tmp14;
			old_value = vala_member_access_new (vala_member_access_get_inner (ma), vala_member_access_get_member_name (ma), NULL);
			_tmp12 = NULL;
			_tmp13 = NULL;
			bin = (_tmp13 = vala_binary_expression_new (VALA_BINARY_OPERATOR_PLUS, ((ValaExpression*) (old_value)), ((ValaExpression*) ((_tmp12 = vala_parenthesized_expression_new (vala_assignment_get_right (a), vala_code_node_get_source_reference (((ValaCodeNode*) (vala_assignment_get_right (a)))))))), NULL), (_tmp12 == NULL ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL))), _tmp13);
			vala_expression_set_target_type (((ValaExpression*) (bin)), vala_expression_get_target_type (vala_assignment_get_right (a)));
			_tmp14 = NULL;
			vala_expression_set_target_type (vala_assignment_get_right (a), (_tmp14 = vala_data_type_copy (vala_expression_get_target_type (vala_assignment_get_right (a)))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL)));
			vala_data_type_set_value_owned (vala_expression_get_target_type (vala_assignment_get_right (a)), FALSE);
			if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_BITWISE_OR);
			} else {
				if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_BITWISE_AND);
				} else {
					if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_BITWISE_XOR);
					} else {
						if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_PLUS);
						} else {
							if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_MINUS);
							} else {
								if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_MUL);
								} else {
									if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_DIV);
									} else {
										if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_MOD);
										} else {
											if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_SHIFT_LEFT);
											} else {
												if (vala_assignment_get_operator (a) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													vala_binary_expression_set_operator (bin, VALA_BINARY_OPERATOR_SHIFT_RIGHT);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			vala_assignment_set_right (a, ((ValaExpression*) (bin)));
			vala_code_node_accept (((ValaCodeNode*) (vala_assignment_get_right (a))), ((ValaCodeVisitor*) (self)));
			vala_assignment_set_operator (a, VALA_ASSIGNMENT_OPERATOR_SIMPLE);
			(old_value == NULL ? NULL : (old_value = (vala_code_node_unref (old_value), NULL)));
			(bin == NULL ? NULL : (bin = (vala_code_node_unref (bin), NULL)));
		}
		(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
	}
	if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a)))) {
		ValaSignal* _tmp15;
		ValaSignal* sig;
		ValaMethod* _tmp17;
		ValaSymbol* _tmp16;
		ValaMethod* m;
		ValaDynamicSignal* _tmp19;
		ValaSignal* _tmp18;
		ValaDynamicSignal* dynamic_sig;
		_tmp15 = NULL;
		sig = (_tmp15 = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (a))), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
		_tmp17 = NULL;
		_tmp16 = NULL;
		m = (_tmp17 = (_tmp16 = vala_expression_get_symbol_reference (vala_assignment_get_right (a)), (VALA_IS_METHOD (_tmp16) ? ((ValaMethod*) (_tmp16)) : NULL)), (_tmp17 == NULL ? NULL : vala_code_node_ref (_tmp17)));
		if (m == NULL) {
			vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
			vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_assignment_get_right (a)))), "unsupported expression for signal handler");
			(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
			(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			return;
		}
		_tmp19 = NULL;
		_tmp18 = NULL;
		dynamic_sig = (_tmp19 = (_tmp18 = sig, (VALA_IS_DYNAMIC_SIGNAL (_tmp18) ? ((ValaDynamicSignal*) (_tmp18)) : NULL)), (_tmp19 == NULL ? NULL : vala_code_node_ref (_tmp19)));
		if (dynamic_sig != NULL) {
			gboolean first;
			ValaDelegateType* _tmp23;
			ValaDelegate* _tmp22;
			ValaObjectType* _tmp21;
			first = TRUE;
			{
				GeeList* param_collection;
				int param_it;
				param_collection = vala_data_type_get_parameters (vala_expression_get_value_type (vala_dynamic_signal_get_handler (dynamic_sig)));
				for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
					ValaFormalParameter* param;
					param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
					{
						if (first) {
							/* skip sender parameter*/
							first = FALSE;
						} else {
							ValaFormalParameter* _tmp20;
							_tmp20 = NULL;
							vala_signal_add_parameter (((ValaSignal*) (dynamic_sig)), (_tmp20 = vala_formal_parameter_copy (param)));
							(_tmp20 == NULL ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL)));
						}
						(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
					}
				}
				(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
			}
			_tmp23 = NULL;
			_tmp22 = NULL;
			_tmp21 = NULL;
			vala_expression_set_target_type (vala_assignment_get_right (a), ((ValaDataType*) ((_tmp23 = vala_delegate_type_new ((_tmp22 = vala_signal_get_delegate (sig, ((ValaDataType*) ((_tmp21 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol (((ValaSymbol*) (sig)))))))))))))));
			(_tmp23 == NULL ? NULL : (_tmp23 = (vala_code_node_unref (_tmp23), NULL)));
			(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
			(_tmp21 == NULL ? NULL : (_tmp21 = (vala_code_node_unref (_tmp21), NULL)));
		} else {
			if (!vala_data_type_compatible (vala_expression_get_value_type (vala_assignment_get_right (a)), vala_expression_get_target_type (vala_assignment_get_right (a)))) {
				ValaDelegateType* _tmp24;
				ValaDelegateType* delegate_type;
				char* _tmp28;
				char* _tmp27;
				char* _tmp26;
				char* _tmp25;
				_tmp24 = NULL;
				delegate_type = (_tmp24 = VALA_DELEGATE_TYPE (vala_expression_get_target_type (vala_assignment_get_right (a))), (_tmp24 == NULL ? NULL : vala_code_node_ref (_tmp24)));
				vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
				_tmp28 = NULL;
				_tmp27 = NULL;
				_tmp26 = NULL;
				_tmp25 = NULL;
				vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (vala_assignment_get_right (a)))), (_tmp28 = g_strdup_printf ("method `%s' is incompatible with signal `%s', expected `%s'", (_tmp25 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_assignment_get_right (a)))))), (_tmp26 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_target_type (vala_assignment_get_right (a)))))), (_tmp27 = vala_delegate_get_prototype_string (vala_delegate_type_get_delegate_symbol (delegate_type), vala_symbol_get_name (((ValaSymbol*) (m))))))));
				_tmp28 = (g_free (_tmp28), NULL);
				_tmp27 = (g_free (_tmp27), NULL);
				_tmp26 = (g_free (_tmp26), NULL);
				_tmp25 = (g_free (_tmp25), NULL);
				(delegate_type == NULL ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL)));
				(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				(dynamic_sig == NULL ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)));
				return;
			}
		}
		(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
		(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
		(dynamic_sig == NULL ? NULL : (dynamic_sig = (vala_code_node_unref (dynamic_sig), NULL)));
	} else {
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (a))) {
			ValaMemberAccess* _tmp29;
			ValaMemberAccess* ma;
			_tmp29 = NULL;
			ma = (_tmp29 = VALA_MEMBER_ACCESS (vala_assignment_get_left (a)), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29)));
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
				ValaProperty* _tmp30;
				ValaProperty* prop;
				ValaDynamicProperty* _tmp32;
				ValaProperty* _tmp31;
				ValaDynamicProperty* dynamic_prop;
				ValaMethod* _tmp35;
				gboolean _tmp36;
				_tmp30 = NULL;
				prop = (_tmp30 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp30 == NULL ? NULL : vala_code_node_ref (_tmp30)));
				_tmp32 = NULL;
				_tmp31 = NULL;
				dynamic_prop = (_tmp32 = (_tmp31 = prop, (VALA_IS_DYNAMIC_PROPERTY (_tmp31) ? ((ValaDynamicProperty*) (_tmp31)) : NULL)), (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32)));
				if (dynamic_prop != NULL) {
					ValaDataType* _tmp33;
					ValaDataType* _tmp34;
					_tmp33 = NULL;
					vala_property_set_property_type (((ValaProperty*) (dynamic_prop)), (_tmp33 = vala_data_type_copy (vala_expression_get_value_type (vala_assignment_get_right (a)))));
					(_tmp33 == NULL ? NULL : (_tmp33 = (vala_code_node_unref (_tmp33), NULL)));
					_tmp34 = NULL;
					vala_expression_set_value_type (vala_assignment_get_left (a), (_tmp34 = vala_data_type_copy (vala_property_get_property_type (((ValaProperty*) (dynamic_prop))))));
					(_tmp34 == NULL ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL)));
				}
				_tmp35 = NULL;
				if ((_tmp36 = vala_property_get_set_accessor (prop) == NULL || (!vala_property_accessor_get_writable (vala_property_get_set_accessor (prop)) && !(VALA_IS_CREATION_METHOD ((_tmp35 = vala_semantic_analyzer_find_current_method (self))) || vala_semantic_analyzer_is_in_constructor (self))), (_tmp35 == NULL ? NULL : (_tmp35 = (vala_code_node_unref (_tmp35), NULL))), _tmp36)) {
					char* _tmp38;
					char* _tmp37;
					vala_code_node_set_error (((ValaCodeNode*) (ma)), TRUE);
					_tmp38 = NULL;
					_tmp37 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (ma))), (_tmp38 = g_strdup_printf ("Property `%s' is read-only", (_tmp37 = vala_symbol_get_full_name (((ValaSymbol*) (prop)))))));
					_tmp38 = (g_free (_tmp38), NULL);
					_tmp37 = (g_free (_tmp37), NULL);
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					(dynamic_prop == NULL ? NULL : (dynamic_prop = (vala_code_node_unref (dynamic_prop), NULL)));
					(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
					return;
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(dynamic_prop == NULL ? NULL : (dynamic_prop = (vala_code_node_unref (dynamic_prop), NULL)));
			} else {
				if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))) && vala_expression_get_value_type (vala_assignment_get_right (a)) == NULL) {
					ValaLocalVariable* _tmp39;
					ValaLocalVariable* local;
					_tmp39 = NULL;
					local = (_tmp39 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp39 == NULL ? NULL : vala_code_node_ref (_tmp39)));
					if (VALA_IS_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))) && VALA_IS_DELEGATE_TYPE (vala_local_variable_get_variable_type (local))) {
						ValaMethod* _tmp40;
						ValaMethod* m;
						ValaDelegateType* _tmp41;
						ValaDelegateType* dt;
						ValaDelegate* _tmp42;
						ValaDelegate* cb;
						_tmp40 = NULL;
						m = (_tmp40 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))), (_tmp40 == NULL ? NULL : vala_code_node_ref (_tmp40)));
						_tmp41 = NULL;
						dt = (_tmp41 = VALA_DELEGATE_TYPE (vala_local_variable_get_variable_type (local)), (_tmp41 == NULL ? NULL : vala_code_node_ref (_tmp41)));
						_tmp42 = NULL;
						cb = (_tmp42 = vala_delegate_type_get_delegate_symbol (dt), (_tmp42 == NULL ? NULL : vala_code_node_ref (_tmp42)));
						/* check whether method matches callback type */
						if (!vala_delegate_matches_method (cb, m)) {
							char* _tmp45;
							char* _tmp44;
							char* _tmp43;
							vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
							_tmp45 = NULL;
							_tmp44 = NULL;
							_tmp43 = NULL;
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), (_tmp45 = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", (_tmp43 = vala_symbol_get_full_name (((ValaSymbol*) (m)))), (_tmp44 = vala_symbol_get_full_name (((ValaSymbol*) (cb)))))));
							_tmp45 = (g_free (_tmp45), NULL);
							_tmp44 = (g_free (_tmp44), NULL);
							_tmp43 = (g_free (_tmp43), NULL);
							(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
							(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
							(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
							(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
							(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
							return;
						}
						vala_expression_set_value_type (vala_assignment_get_right (a), vala_local_variable_get_variable_type (local));
						(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
						(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
						(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
					} else {
						vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "Assignment: Invalid callback assignment attempt");
						(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
						(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
						return;
					}
					(local == NULL ? NULL : (local = (vala_code_node_unref (local), NULL)));
				} else {
					if (VALA_IS_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))) && vala_expression_get_value_type (vala_assignment_get_right (a)) == NULL) {
						ValaField* _tmp46;
						ValaField* f;
						_tmp46 = NULL;
						f = (_tmp46 = VALA_FIELD (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp46 == NULL ? NULL : vala_code_node_ref (_tmp46)));
						if (VALA_IS_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))) && VALA_IS_DELEGATE_TYPE (vala_field_get_field_type (f))) {
							ValaMethod* _tmp47;
							ValaMethod* m;
							ValaDelegateType* _tmp48;
							ValaDelegateType* dt;
							ValaDelegate* _tmp49;
							ValaDelegate* cb;
							_tmp47 = NULL;
							m = (_tmp47 = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (a))), (_tmp47 == NULL ? NULL : vala_code_node_ref (_tmp47)));
							_tmp48 = NULL;
							dt = (_tmp48 = VALA_DELEGATE_TYPE (vala_field_get_field_type (f)), (_tmp48 == NULL ? NULL : vala_code_node_ref (_tmp48)));
							_tmp49 = NULL;
							cb = (_tmp49 = vala_delegate_type_get_delegate_symbol (dt), (_tmp49 == NULL ? NULL : vala_code_node_ref (_tmp49)));
							/* check whether method matches callback type */
							if (!vala_delegate_matches_method (cb, m)) {
								char* _tmp52;
								char* _tmp51;
								char* _tmp50;
								vala_code_node_set_error (((ValaCodeNode*) (f)), TRUE);
								_tmp52 = NULL;
								_tmp51 = NULL;
								_tmp50 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), (_tmp52 = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", (_tmp50 = vala_symbol_get_full_name (((ValaSymbol*) (m)))), (_tmp51 = vala_symbol_get_full_name (((ValaSymbol*) (cb)))))));
								_tmp52 = (g_free (_tmp52), NULL);
								_tmp51 = (g_free (_tmp51), NULL);
								_tmp50 = (g_free (_tmp50), NULL);
								(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
								(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
								(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
								(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
								(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
								return;
							}
							vala_expression_set_value_type (vala_assignment_get_right (a), vala_field_get_field_type (f));
							(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
							(dt == NULL ? NULL : (dt = (vala_code_node_unref (dt), NULL)));
							(cb == NULL ? NULL : (cb = (vala_code_node_unref (cb), NULL)));
						} else {
							vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
							vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "Assignment: Invalid callback assignment attempt");
							(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
							(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
							return;
						}
						(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
					} else {
						if (vala_expression_get_value_type (vala_assignment_get_left (a)) != NULL && vala_expression_get_value_type (vala_assignment_get_right (a)) != NULL) {
							/* if there was an error on either side,
							 * i.e. a.{left|right}.value_type == null, skip type check */
							if (!vala_data_type_compatible (vala_expression_get_value_type (vala_assignment_get_right (a)), vala_expression_get_value_type (vala_assignment_get_left (a)))) {
								char* _tmp55;
								char* _tmp54;
								char* _tmp53;
								vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
								_tmp55 = NULL;
								_tmp54 = NULL;
								_tmp53 = NULL;
								vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), (_tmp55 = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", (_tmp53 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_assignment_get_right (a)))))), (_tmp54 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_assignment_get_left (a)))))))));
								_tmp55 = (g_free (_tmp55), NULL);
								_tmp54 = (g_free (_tmp54), NULL);
								_tmp53 = (g_free (_tmp53), NULL);
								(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
								return;
							}
							if (vala_data_type_is_disposable (vala_expression_get_value_type (vala_assignment_get_right (a)))) {
								/* rhs transfers ownership of the expression */
								if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_assignment_get_left (a)))) && !vala_data_type_get_value_owned (vala_expression_get_value_type (vala_assignment_get_left (a)))) {
									/* lhs doesn't own the value */
									vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
									vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "Invalid assignment from owned expression to unowned variable");
								}
							} else {
								if (vala_data_type_get_value_owned (vala_expression_get_value_type (vala_assignment_get_left (a)))) {
								}
							}
						}
					}
				}
			}
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		} else {
			if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (a))) {
				ValaElementAccess* _tmp56;
				ValaElementAccess* ea;
				_tmp56 = NULL;
				ea = (_tmp56 = VALA_ELEMENT_ACCESS (vala_assignment_get_left (a)), (_tmp56 == NULL ? NULL : vala_code_node_ref (_tmp56)));
				if (!vala_data_type_compatible (vala_expression_get_value_type (vala_assignment_get_right (a)), vala_expression_get_value_type (vala_assignment_get_left (a)))) {
					char* _tmp59;
					char* _tmp58;
					char* _tmp57;
					vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
					_tmp59 = NULL;
					_tmp58 = NULL;
					_tmp57 = NULL;
					vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), (_tmp59 = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", (_tmp57 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_assignment_get_right (a)))))), (_tmp58 = vala_code_node_to_string (((ValaCodeNode*) (vala_expression_get_value_type (vala_assignment_get_left (a)))))))));
					_tmp59 = (g_free (_tmp59), NULL);
					_tmp58 = (g_free (_tmp58), NULL);
					_tmp57 = (g_free (_tmp57), NULL);
					(ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL)));
					return;
				}
				if (vala_data_type_is_disposable (vala_expression_get_value_type (vala_assignment_get_right (a)))) {
					ValaDataType* element_type;
					/* rhs transfers ownership of the expression */
					element_type = NULL;
					if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container (ea)))) {
						ValaArrayType* _tmp60;
						ValaArrayType* array_type;
						ValaDataType* _tmp62;
						ValaDataType* _tmp61;
						_tmp60 = NULL;
						array_type = (_tmp60 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_element_access_get_container (ea))), (_tmp60 == NULL ? NULL : vala_code_node_ref (_tmp60)));
						_tmp62 = NULL;
						_tmp61 = NULL;
						element_type = (_tmp62 = (_tmp61 = vala_array_type_get_element_type (array_type), (_tmp61 == NULL ? NULL : vala_code_node_ref (_tmp61))), (element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL))), _tmp62);
						(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
					} else {
						GeeList* args;
						ValaDataType* _tmp63;
						args = vala_data_type_get_type_arguments (vala_expression_get_value_type (vala_element_access_get_container (ea)));
						g_assert (gee_collection_get_size (((GeeCollection*) (args))) == 1);
						_tmp63 = NULL;
						element_type = (_tmp63 = ((ValaDataType*) (gee_list_get (args, 0))), (element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL))), _tmp63);
						(args == NULL ? NULL : (args = (gee_collection_object_unref (args), NULL)));
					}
					if (!(VALA_IS_POINTER_TYPE (element_type)) && !vala_data_type_get_value_owned (element_type)) {
						/* lhs doesn't own the value */
						vala_code_node_set_error (((ValaCodeNode*) (a)), TRUE);
						vala_report_error (vala_code_node_get_source_reference (((ValaCodeNode*) (a))), "Invalid assignment from owned expression to unowned variable");
						(element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)));
						(ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL)));
						return;
					}
					(element_type == NULL ? NULL : (element_type = (vala_code_node_unref (element_type), NULL)));
				} else {
					if (vala_data_type_get_value_owned (vala_expression_get_value_type (vala_assignment_get_left (a)))) {
					}
				}
				(ea == NULL ? NULL : (ea = (vala_code_node_unref (ea), NULL)));
			} else {
				/* lhs wants to own the value
				 * rhs doesn't transfer the ownership
				 * code generator needs to add reference
				 * increment calls */
				return;
			}
		}
	}
	if (vala_expression_get_value_type (vala_assignment_get_left (a)) != NULL) {
		ValaDataType* _tmp64;
		_tmp64 = NULL;
		vala_expression_set_value_type (((ValaExpression*) (a)), (_tmp64 = vala_data_type_copy (vala_expression_get_value_type (vala_assignment_get_left (a)))));
		(_tmp64 == NULL ? NULL : (_tmp64 = (vala_code_node_unref (_tmp64), NULL)));
		vala_data_type_set_value_owned (vala_expression_get_value_type (((ValaExpression*) (a))), FALSE);
	} else {
		vala_expression_set_value_type (((ValaExpression*) (a)), NULL);
	}
	_tmp65 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (a)), (_tmp65 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_assignment_get_left (a))))));
	(_tmp65 == NULL ? NULL : (_tmp65 = (gee_collection_object_unref (_tmp65), NULL)));
	_tmp66 = NULL;
	vala_code_node_add_error_types (((ValaCodeNode*) (a)), (_tmp66 = vala_code_node_get_error_types (((ValaCodeNode*) (vala_assignment_get_right (a))))));
	(_tmp66 == NULL ? NULL : (_tmp66 = (gee_collection_object_unref (_tmp66), NULL)));
}


ValaCodeContext* vala_semantic_analyzer_get_context (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_semantic_analyzer_set_context (ValaSemanticAnalyzer* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_context_ref (_tmp1))), (self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL))), _tmp2);
}


ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_symbol;
}


void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_current_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_current_symbol == NULL ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL))), _tmp2);
}


ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_source_file;
}


void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp2;
	ValaSourceFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_current_source_file = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_source_file_ref (_tmp1))), (self->priv->_current_source_file == NULL ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL))), _tmp2);
}


static void vala_semantic_analyzer_class_init (ValaSemanticAnalyzerClass * klass) {
	vala_semantic_analyzer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_semantic_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaSemanticAnalyzerPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_semantic_analyzer_real_visit_source_file;
	VALA_CODE_VISITOR_CLASS (klass)->visit_namespace = vala_semantic_analyzer_real_visit_namespace;
	VALA_CODE_VISITOR_CLASS (klass)->visit_class = vala_semantic_analyzer_real_visit_class;
	VALA_CODE_VISITOR_CLASS (klass)->visit_struct = vala_semantic_analyzer_real_visit_struct;
	VALA_CODE_VISITOR_CLASS (klass)->visit_interface = vala_semantic_analyzer_real_visit_interface;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum = vala_semantic_analyzer_real_visit_enum;
	VALA_CODE_VISITOR_CLASS (klass)->visit_enum_value = vala_semantic_analyzer_real_visit_enum_value;
	VALA_CODE_VISITOR_CLASS (klass)->visit_error_domain = vala_semantic_analyzer_real_visit_error_domain;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delegate = vala_semantic_analyzer_real_visit_delegate;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constant = vala_semantic_analyzer_real_visit_constant;
	VALA_CODE_VISITOR_CLASS (klass)->visit_field = vala_semantic_analyzer_real_visit_field;
	VALA_CODE_VISITOR_CLASS (klass)->visit_method = vala_semantic_analyzer_real_visit_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_creation_method = vala_semantic_analyzer_real_visit_creation_method;
	VALA_CODE_VISITOR_CLASS (klass)->visit_formal_parameter = vala_semantic_analyzer_real_visit_formal_parameter;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property = vala_semantic_analyzer_real_visit_property;
	VALA_CODE_VISITOR_CLASS (klass)->visit_property_accessor = vala_semantic_analyzer_real_visit_property_accessor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_signal = vala_semantic_analyzer_real_visit_signal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_constructor = vala_semantic_analyzer_real_visit_constructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_destructor = vala_semantic_analyzer_real_visit_destructor;
	VALA_CODE_VISITOR_CLASS (klass)->visit_block = vala_semantic_analyzer_real_visit_block;
	VALA_CODE_VISITOR_CLASS (klass)->visit_declaration_statement = vala_semantic_analyzer_real_visit_declaration_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_local_variable = vala_semantic_analyzer_real_visit_local_variable;
	VALA_CODE_VISITOR_CLASS (klass)->visit_initializer_list = vala_semantic_analyzer_real_visit_initializer_list;
	VALA_CODE_VISITOR_CLASS (klass)->visit_expression_statement = vala_semantic_analyzer_real_visit_expression_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_if_statement = vala_semantic_analyzer_real_visit_if_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_switch_section = vala_semantic_analyzer_real_visit_switch_section;
	VALA_CODE_VISITOR_CLASS (klass)->visit_while_statement = vala_semantic_analyzer_real_visit_while_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_do_statement = vala_semantic_analyzer_real_visit_do_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_for_statement = vala_semantic_analyzer_real_visit_for_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_foreach_statement = vala_semantic_analyzer_real_visit_foreach_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_return_statement = vala_semantic_analyzer_real_visit_return_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_yield_statement = vala_semantic_analyzer_real_visit_yield_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_throw_statement = vala_semantic_analyzer_real_visit_throw_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_try_statement = vala_semantic_analyzer_real_visit_try_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_catch_clause = vala_semantic_analyzer_real_visit_catch_clause;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lock_statement = vala_semantic_analyzer_real_visit_lock_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_delete_statement = vala_semantic_analyzer_real_visit_delete_statement;
	VALA_CODE_VISITOR_CLASS (klass)->visit_array_creation_expression = vala_semantic_analyzer_real_visit_array_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_boolean_literal = vala_semantic_analyzer_real_visit_boolean_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_character_literal = vala_semantic_analyzer_real_visit_character_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_integer_literal = vala_semantic_analyzer_real_visit_integer_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_real_literal = vala_semantic_analyzer_real_visit_real_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_string_literal = vala_semantic_analyzer_real_visit_string_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_null_literal = vala_semantic_analyzer_real_visit_null_literal;
	VALA_CODE_VISITOR_CLASS (klass)->visit_parenthesized_expression = vala_semantic_analyzer_real_visit_parenthesized_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_member_access = vala_semantic_analyzer_real_visit_member_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_invocation_expression = vala_semantic_analyzer_real_visit_invocation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_element_access = vala_semantic_analyzer_real_visit_element_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_base_access = vala_semantic_analyzer_real_visit_base_access;
	VALA_CODE_VISITOR_CLASS (klass)->visit_postfix_expression = vala_semantic_analyzer_real_visit_postfix_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_object_creation_expression = vala_semantic_analyzer_real_visit_object_creation_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_sizeof_expression = vala_semantic_analyzer_real_visit_sizeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_typeof_expression = vala_semantic_analyzer_real_visit_typeof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_unary_expression = vala_semantic_analyzer_real_visit_unary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_cast_expression = vala_semantic_analyzer_real_visit_cast_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_pointer_indirection = vala_semantic_analyzer_real_visit_pointer_indirection;
	VALA_CODE_VISITOR_CLASS (klass)->visit_addressof_expression = vala_semantic_analyzer_real_visit_addressof_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_reference_transfer_expression = vala_semantic_analyzer_real_visit_reference_transfer_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_binary_expression = vala_semantic_analyzer_real_visit_binary_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_type_check = vala_semantic_analyzer_real_visit_type_check;
	VALA_CODE_VISITOR_CLASS (klass)->visit_conditional_expression = vala_semantic_analyzer_real_visit_conditional_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_lambda_expression = vala_semantic_analyzer_real_visit_lambda_expression;
	VALA_CODE_VISITOR_CLASS (klass)->visit_assignment = vala_semantic_analyzer_real_visit_assignment;
}


static void vala_semantic_analyzer_instance_init (ValaSemanticAnalyzer * self) {
	self->priv = VALA_SEMANTIC_ANALYZER_GET_PRIVATE (self);
	self->priv->next_lambda_id = 0;
	self->priv->replaced_nodes = ((GeeList*) (gee_array_list_new (VALA_TYPE_CODE_NODE, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal)));
}


static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj) {
	ValaSemanticAnalyzer * self;
	self = VALA_SEMANTIC_ANALYZER (obj);
	(self->priv->_context == NULL ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)));
	(self->priv->root_symbol == NULL ? NULL : (self->priv->root_symbol = (vala_code_node_unref (self->priv->root_symbol), NULL)));
	(self->priv->_current_symbol == NULL ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL)));
	(self->priv->_current_source_file == NULL ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL)));
	(self->priv->current_return_type == NULL ? NULL : (self->priv->current_return_type = (vala_code_node_unref (self->priv->current_return_type), NULL)));
	(self->priv->current_class == NULL ? NULL : (self->priv->current_class = (vala_code_node_unref (self->priv->current_class), NULL)));
	(self->priv->current_struct == NULL ? NULL : (self->priv->current_struct = (vala_code_node_unref (self->priv->current_struct), NULL)));
	(self->priv->current_using_directives == NULL ? NULL : (self->priv->current_using_directives = (gee_collection_object_unref (self->priv->current_using_directives), NULL)));
	(self->priv->bool_type == NULL ? NULL : (self->priv->bool_type = (vala_code_node_unref (self->priv->bool_type), NULL)));
	(self->priv->string_type == NULL ? NULL : (self->priv->string_type = (vala_code_node_unref (self->priv->string_type), NULL)));
	(self->priv->uchar_type == NULL ? NULL : (self->priv->uchar_type = (vala_code_node_unref (self->priv->uchar_type), NULL)));
	(self->priv->short_type == NULL ? NULL : (self->priv->short_type = (vala_code_node_unref (self->priv->short_type), NULL)));
	(self->priv->ushort_type == NULL ? NULL : (self->priv->ushort_type = (vala_code_node_unref (self->priv->ushort_type), NULL)));
	(self->priv->int_type == NULL ? NULL : (self->priv->int_type = (vala_code_node_unref (self->priv->int_type), NULL)));
	(self->priv->uint_type == NULL ? NULL : (self->priv->uint_type = (vala_code_node_unref (self->priv->uint_type), NULL)));
	(self->priv->long_type == NULL ? NULL : (self->priv->long_type = (vala_code_node_unref (self->priv->long_type), NULL)));
	(self->priv->ulong_type == NULL ? NULL : (self->priv->ulong_type = (vala_code_node_unref (self->priv->ulong_type), NULL)));
	(self->priv->size_t_type == NULL ? NULL : (self->priv->size_t_type = (vala_code_node_unref (self->priv->size_t_type), NULL)));
	(self->priv->ssize_t_type == NULL ? NULL : (self->priv->ssize_t_type = (vala_code_node_unref (self->priv->ssize_t_type), NULL)));
	(self->priv->int8_type == NULL ? NULL : (self->priv->int8_type = (vala_code_node_unref (self->priv->int8_type), NULL)));
	(self->priv->unichar_type == NULL ? NULL : (self->priv->unichar_type = (vala_code_node_unref (self->priv->unichar_type), NULL)));
	(self->priv->double_type == NULL ? NULL : (self->priv->double_type = (vala_code_node_unref (self->priv->double_type), NULL)));
	(self->priv->type_type == NULL ? NULL : (self->priv->type_type = (vala_code_node_unref (self->priv->type_type), NULL)));
	(self->priv->object_type == NULL ? NULL : (self->priv->object_type = (vala_code_node_unref (self->priv->object_type), NULL)));
	(self->priv->initially_unowned_type == NULL ? NULL : (self->priv->initially_unowned_type = (vala_code_node_unref (self->priv->initially_unowned_type), NULL)));
	(self->priv->glist_type == NULL ? NULL : (self->priv->glist_type = (vala_code_node_unref (self->priv->glist_type), NULL)));
	(self->priv->gslist_type == NULL ? NULL : (self->priv->gslist_type = (vala_code_node_unref (self->priv->gslist_type), NULL)));
	(self->priv->gerror_type == NULL ? NULL : (self->priv->gerror_type = (vala_code_node_unref (self->priv->gerror_type), NULL)));
	(self->priv->iterable_type == NULL ? NULL : (self->priv->iterable_type = (vala_code_node_unref (self->priv->iterable_type), NULL)));
	(self->priv->iterator_type == NULL ? NULL : (self->priv->iterator_type = (vala_code_node_unref (self->priv->iterator_type), NULL)));
	(self->priv->list_type == NULL ? NULL : (self->priv->list_type = (vala_code_node_unref (self->priv->list_type), NULL)));
	(self->priv->collection_type == NULL ? NULL : (self->priv->collection_type = (vala_code_node_unref (self->priv->collection_type), NULL)));
	(self->priv->map_type == NULL ? NULL : (self->priv->map_type = (vala_code_node_unref (self->priv->map_type), NULL)));
	(self->priv->replaced_nodes == NULL ? NULL : (self->priv->replaced_nodes = (gee_collection_object_unref (self->priv->replaced_nodes), NULL)));
	VALA_CODE_VISITOR_CLASS (vala_semantic_analyzer_parent_class)->finalize (obj);
}


GType vala_semantic_analyzer_get_type (void) {
	static GType vala_semantic_analyzer_type_id = 0;
	if (vala_semantic_analyzer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSemanticAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_semantic_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSemanticAnalyzer), 0, (GInstanceInitFunc) vala_semantic_analyzer_instance_init, NULL };
		vala_semantic_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSemanticAnalyzer", &g_define_type_info, 0);
	}
	return vala_semantic_analyzer_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




