/* valagobjectmodule.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valagobjectmodule.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefragment.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <gee/collection.h>
#include <ccode/valaccodecomment.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeunaryexpression.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeswitchstatement.h>
#include <gee/list.h>
#include <vala/valaobjecttype.h>
#include <vala/valaexpression.h>
#include <vala/valainterface.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebreakstatement.h>
#include <ccode/valaccodelabel.h>
#include <vala/valatypeparameter.h>
#include <vala/valamethod.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valasignal.h>
#include <vala/valascope.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valacodecontext.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valaenum.h>
#include <vala/valastruct.h>
#include <ccode/valaccodecommaexpression.h>
#include <gobject/valaccodebasemodule.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>




struct _ValaGObjectModulePrivate {
	gint dynamic_property_id;
	gint signal_wrapper_id;
};

#define VALA_GOBJECT_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModulePrivate))
enum  {
	VALA_GOBJECT_MODULE_DUMMY_PROPERTY
};
static void vala_gobject_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_init_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_free_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_copy_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_peek_pointer_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_lcopy_value_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_type_value_table_collect_value_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_g_param_spec_type_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_g_value_set_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_g_value_get_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_class_init_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_interface_init_function (ValaGObjectModule* self, ValaClass* cl, ValaInterface* iface);
static void vala_gobject_module_add_instance_init_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_finalize_function (ValaGObjectModule* self, ValaClass* cl);
static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self, ValaClass* cl);
static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self, ValaClass* cl);
static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self, ValaClass* cl);
static ValaCCodeStatement* vala_gobject_module_get_invalid_property_id_warn_statement (ValaGObjectModule* self);
static ValaCCodeFunctionCall* vala_gobject_module_real_get_param_spec (ValaCCodeModule* base, ValaProperty* prop);
static ValaCCodeExpression* vala_gobject_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
static void vala_gobject_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c);
static char* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
static char* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop);
static void vala_gobject_module_generate_gobject_property_getter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static void vala_gobject_module_generate_gobject_property_setter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block);
static char* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeModule* base, ValaDynamicSignal* node);
static char* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig);
static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block);
static gpointer vala_gobject_module_parent_class = NULL;
static void vala_gobject_module_finalize (ValaCCodeModule* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaGObjectModule* vala_gobject_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGObjectModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGObjectModule*) vala_gtype_module_construct (object_type, codegen, next);
	return self;
}


ValaGObjectModule* vala_gobject_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gobject_module_construct (VALA_TYPE_GOBJECT_MODULE, codegen, next);
}


static void vala_gobject_module_real_visit_class (ValaCCodeModule* base, ValaClass* cl) {
	ValaGObjectModule * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaTypeSymbol* _tmp1;
	ValaTypeSymbol* old_type_symbol;
	ValaClass* _tmp2;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* old_param_spec_struct;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* _tmp6;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* _tmp7;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp10;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaSymbol* _tmp12;
	ValaSymbol* _tmp11;
	ValaTypeSymbol* _tmp14;
	ValaTypeSymbol* _tmp13;
	ValaClass* _tmp16;
	ValaClass* _tmp15;
	gboolean is_gtypeinstance;
	gboolean is_gobject;
	gboolean _tmp17;
	gboolean is_fundamental;
	char* _tmp18;
	gboolean _tmp19;
	ValaCCodeStruct* _tmp24;
	char* _tmp23;
	char* _tmp22;
	ValaCCodeStruct* _tmp27;
	char* _tmp26;
	char* _tmp25;
	ValaCCodeStruct* _tmp30;
	char* _tmp29;
	char* _tmp28;
	ValaCCodeEnum* _tmp31;
	ValaCCodeEnumValue* _tmp34;
	char* _tmp33;
	char* _tmp32;
	ValaCCodeFragment* _tmp35;
	ValaCCodeFragment* _tmp36;
	ValaCCodeFragment* _tmp37;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	gboolean _tmp85;
	gboolean _tmp86;
	ValaSymbol* _tmp209;
	ValaSymbol* _tmp208;
	ValaTypeSymbol* _tmp211;
	ValaTypeSymbol* _tmp210;
	ValaClass* _tmp213;
	ValaClass* _tmp212;
	ValaCCodeStruct* _tmp215;
	ValaCCodeStruct* _tmp214;
	ValaCCodeStruct* _tmp217;
	ValaCCodeStruct* _tmp216;
	ValaCCodeStruct* _tmp219;
	ValaCCodeStruct* _tmp218;
	ValaCCodeStruct* _tmp221;
	ValaCCodeStruct* _tmp220;
	ValaCCodeEnum* _tmp223;
	ValaCCodeEnum* _tmp222;
	ValaCCodeFragment* _tmp225;
	ValaCCodeFragment* _tmp224;
	ValaCCodeFragment* _tmp227;
	ValaCCodeFragment* _tmp226;
	ValaCCodeFragment* _tmp229;
	ValaCCodeFragment* _tmp228;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (cl != NULL);
	_tmp0 = NULL;
	old_symbol = (_tmp0 = ((ValaCCodeBaseModule*) self)->current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	_tmp1 = NULL;
	old_type_symbol = (_tmp1 = ((ValaCCodeBaseModule*) self)->current_type_symbol, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	old_class = (_tmp2 = ((ValaCCodeBaseModule*) self)->current_class, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	old_instance_struct = (_tmp3 = ((ValaCCodeBaseModule*) self)->instance_struct, (_tmp3 == NULL) ? NULL : vala_ccode_node_ref (_tmp3));
	_tmp4 = NULL;
	old_param_spec_struct = (_tmp4 = ((ValaCCodeBaseModule*) self)->param_spec_struct, (_tmp4 == NULL) ? NULL : vala_ccode_node_ref (_tmp4));
	_tmp5 = NULL;
	old_type_struct = (_tmp5 = ((ValaCCodeBaseModule*) self)->type_struct, (_tmp5 == NULL) ? NULL : vala_ccode_node_ref (_tmp5));
	_tmp6 = NULL;
	old_instance_priv_struct = (_tmp6 = ((ValaCCodeBaseModule*) self)->instance_priv_struct, (_tmp6 == NULL) ? NULL : vala_ccode_node_ref (_tmp6));
	_tmp7 = NULL;
	old_prop_enum = (_tmp7 = ((ValaCCodeBaseModule*) self)->prop_enum, (_tmp7 == NULL) ? NULL : vala_ccode_node_ref (_tmp7));
	_tmp8 = NULL;
	old_class_init_fragment = (_tmp8 = ((ValaCCodeBaseModule*) self)->class_init_fragment, (_tmp8 == NULL) ? NULL : vala_ccode_node_ref (_tmp8));
	_tmp9 = NULL;
	old_instance_init_fragment = (_tmp9 = ((ValaCCodeBaseModule*) self)->instance_init_fragment, (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9));
	_tmp10 = NULL;
	old_instance_finalize_fragment = (_tmp10 = ((ValaCCodeBaseModule*) self)->instance_finalize_fragment, (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10));
	_tmp12 = NULL;
	_tmp11 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp12 = (_tmp11 = (ValaSymbol*) cl, (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp12);
	_tmp14 = NULL;
	_tmp13 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp14 = (_tmp13 = (ValaTypeSymbol*) cl, (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp14);
	_tmp16 = NULL;
	_tmp15 = NULL;
	((ValaCCodeBaseModule*) self)->current_class = (_tmp16 = (_tmp15 = cl, (_tmp15 == NULL) ? NULL : vala_code_node_ref (_tmp15)), (((ValaCCodeBaseModule*) self)->current_class == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_class = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_class), NULL)), _tmp16);
	is_gtypeinstance = !vala_class_get_is_compact (cl);
	is_gobject = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	_tmp17 = FALSE;
	if (is_gtypeinstance) {
		_tmp17 = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp17 = FALSE;
	}
	is_fundamental = _tmp17;
	_tmp18 = NULL;
	if ((_tmp19 = g_utf8_strlen (_tmp18 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), -1) < 3, _tmp18 = (g_free (_tmp18), NULL), _tmp19)) {
		char* _tmp21;
		char* _tmp20;
		vala_code_node_set_error ((ValaCodeNode*) cl, TRUE);
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) cl), _tmp21 = g_strdup_printf ("Class name `%s' is too short", _tmp20 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)));
		_tmp21 = (g_free (_tmp21), NULL);
		_tmp20 = (g_free (_tmp20), NULL);
		(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
		(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
		(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
		(old_instance_struct == NULL) ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL));
		(old_param_spec_struct == NULL) ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL));
		(old_type_struct == NULL) ? NULL : (old_type_struct = (vala_ccode_node_unref (old_type_struct), NULL));
		(old_instance_priv_struct == NULL) ? NULL : (old_instance_priv_struct = (vala_ccode_node_unref (old_instance_priv_struct), NULL));
		(old_prop_enum == NULL) ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL));
		(old_class_init_fragment == NULL) ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL));
		(old_instance_init_fragment == NULL) ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL));
		(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
		return;
	}
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp24 = vala_ccode_struct_new (_tmp23 = g_strdup_printf ("_%s", _tmp22 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp24);
	_tmp23 = (g_free (_tmp23), NULL);
	_tmp22 = (g_free (_tmp22), NULL);
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	((ValaCCodeBaseModule*) self)->type_struct = (_tmp27 = vala_ccode_struct_new (_tmp26 = g_strdup_printf ("_%sClass", _tmp25 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (((ValaCCodeBaseModule*) self)->type_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->type_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->type_struct), NULL)), _tmp27);
	_tmp26 = (g_free (_tmp26), NULL);
	_tmp25 = (g_free (_tmp25), NULL);
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	((ValaCCodeBaseModule*) self)->instance_priv_struct = (_tmp30 = vala_ccode_struct_new (_tmp29 = g_strdup_printf ("_%sPrivate", _tmp28 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (((ValaCCodeBaseModule*) self)->instance_priv_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_priv_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_priv_struct), NULL)), _tmp30);
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp28 = (g_free (_tmp28), NULL);
	_tmp31 = NULL;
	((ValaCCodeBaseModule*) self)->prop_enum = (_tmp31 = vala_ccode_enum_new (NULL), (((ValaCCodeBaseModule*) self)->prop_enum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->prop_enum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->prop_enum), NULL)), _tmp31);
	_tmp34 = NULL;
	_tmp33 = NULL;
	_tmp32 = NULL;
	vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp34 = vala_ccode_enum_value_new (_tmp33 = g_strdup_printf ("%s_DUMMY_PROPERTY", _tmp32 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), NULL));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	_tmp33 = (g_free (_tmp33), NULL);
	_tmp32 = (g_free (_tmp32), NULL);
	_tmp35 = NULL;
	((ValaCCodeBaseModule*) self)->class_init_fragment = (_tmp35 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->class_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_init_fragment), NULL)), _tmp35);
	_tmp36 = NULL;
	((ValaCCodeBaseModule*) self)->instance_init_fragment = (_tmp36 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_init_fragment), NULL)), _tmp36);
	_tmp37 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp37 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp37);
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access ((ValaSymbol*) cl) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp39;
		ValaCCodeFragment* _tmp38;
		ValaCCodeFragment* _tmp41;
		ValaCCodeFragment* _tmp40;
		_tmp39 = NULL;
		_tmp38 = NULL;
		decl_frag = (_tmp39 = (_tmp38 = ((ValaCCodeBaseModule*) self)->header_type_declaration, (_tmp38 == NULL) ? NULL : vala_ccode_node_ref (_tmp38)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp39);
		_tmp41 = NULL;
		_tmp40 = NULL;
		def_frag = (_tmp41 = (_tmp40 = ((ValaCCodeBaseModule*) self)->header_type_definition, (_tmp40 == NULL) ? NULL : vala_ccode_node_ref (_tmp40)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp41);
	} else {
		ValaCCodeFragment* _tmp43;
		ValaCCodeFragment* _tmp42;
		ValaCCodeFragment* _tmp45;
		ValaCCodeFragment* _tmp44;
		_tmp43 = NULL;
		_tmp42 = NULL;
		decl_frag = (_tmp43 = (_tmp42 = ((ValaCCodeBaseModule*) self)->source_type_declaration, (_tmp42 == NULL) ? NULL : vala_ccode_node_ref (_tmp42)), (decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)), _tmp43);
		_tmp45 = NULL;
		_tmp44 = NULL;
		def_frag = (_tmp45 = (_tmp44 = ((ValaCCodeBaseModule*) self)->source_type_definition, (_tmp44 == NULL) ? NULL : vala_ccode_node_ref (_tmp44)), (def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)), _tmp45);
	}
	if (is_gtypeinstance) {
		ValaCCodeNewline* _tmp46;
		char* _tmp47;
		char* _tmp48;
		char* macro;
		ValaCCodeMacroReplacement* _tmp50;
		char* _tmp49;
		char* _tmp53;
		char* _tmp52;
		char* _tmp51;
		ValaCCodeMacroReplacement* _tmp56;
		char* _tmp55;
		char* _tmp54;
		char* _tmp59;
		char* _tmp58;
		char* _tmp57;
		ValaCCodeMacroReplacement* _tmp62;
		char* _tmp61;
		char* _tmp60;
		char* _tmp64;
		char* _tmp63;
		ValaCCodeMacroReplacement* _tmp67;
		char* _tmp66;
		char* _tmp65;
		char* _tmp69;
		char* _tmp68;
		ValaCCodeMacroReplacement* _tmp72;
		char* _tmp71;
		char* _tmp70;
		char* _tmp75;
		char* _tmp74;
		char* _tmp73;
		ValaCCodeMacroReplacement* _tmp78;
		char* _tmp77;
		char* _tmp76;
		ValaCCodeNewline* _tmp79;
		_tmp46 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp46 = vala_ccode_newline_new ()));
		(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
		_tmp47 = NULL;
		_tmp48 = NULL;
		macro = (_tmp48 = g_strdup_printf ("(%s_get_type ())", _tmp47 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), _tmp47 = (g_free (_tmp47), NULL), _tmp48);
		_tmp50 = NULL;
		_tmp49 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp50 = vala_ccode_macro_replacement_new (_tmp49 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), macro)));
		(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
		_tmp49 = (g_free (_tmp49), NULL);
		_tmp53 = NULL;
		_tmp52 = NULL;
		_tmp51 = NULL;
		macro = (_tmp53 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", _tmp51 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp52 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp53);
		_tmp52 = (g_free (_tmp52), NULL);
		_tmp51 = (g_free (_tmp51), NULL);
		_tmp56 = NULL;
		_tmp55 = NULL;
		_tmp54 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp56 = vala_ccode_macro_replacement_new (_tmp55 = g_strdup_printf ("%s(obj)", _tmp54 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
		_tmp55 = (g_free (_tmp55), NULL);
		_tmp54 = (g_free (_tmp54), NULL);
		_tmp59 = NULL;
		_tmp58 = NULL;
		_tmp57 = NULL;
		macro = (_tmp59 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", _tmp57 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp58 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp59);
		_tmp58 = (g_free (_tmp58), NULL);
		_tmp57 = (g_free (_tmp57), NULL);
		_tmp62 = NULL;
		_tmp61 = NULL;
		_tmp60 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp62 = vala_ccode_macro_replacement_new (_tmp61 = g_strdup_printf ("%s_CLASS(klass)", _tmp60 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
		_tmp61 = (g_free (_tmp61), NULL);
		_tmp60 = (g_free (_tmp60), NULL);
		_tmp64 = NULL;
		_tmp63 = NULL;
		macro = (_tmp64 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", _tmp63 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl)), macro = (g_free (macro), NULL), _tmp64);
		_tmp63 = (g_free (_tmp63), NULL);
		_tmp67 = NULL;
		_tmp66 = NULL;
		_tmp65 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp67 = vala_ccode_macro_replacement_new (_tmp66 = g_strdup_printf ("%s(obj)", _tmp65 = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) cl)), macro)));
		(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
		_tmp66 = (g_free (_tmp66), NULL);
		_tmp65 = (g_free (_tmp65), NULL);
		_tmp69 = NULL;
		_tmp68 = NULL;
		macro = (_tmp69 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", _tmp68 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl)), macro = (g_free (macro), NULL), _tmp69);
		_tmp68 = (g_free (_tmp68), NULL);
		_tmp72 = NULL;
		_tmp71 = NULL;
		_tmp70 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp72 = vala_ccode_macro_replacement_new (_tmp71 = g_strdup_printf ("%s_CLASS(klass)", _tmp70 = vala_ccode_base_module_get_type_check_function ((ValaCCodeBaseModule*) self, (ValaTypeSymbol*) cl)), macro)));
		(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
		_tmp71 = (g_free (_tmp71), NULL);
		_tmp70 = (g_free (_tmp70), NULL);
		_tmp75 = NULL;
		_tmp74 = NULL;
		_tmp73 = NULL;
		macro = (_tmp75 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", _tmp73 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp74 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), macro = (g_free (macro), NULL), _tmp75);
		_tmp74 = (g_free (_tmp74), NULL);
		_tmp73 = (g_free (_tmp73), NULL);
		_tmp78 = NULL;
		_tmp77 = NULL;
		_tmp76 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp78 = vala_ccode_macro_replacement_new (_tmp77 = g_strdup_printf ("%s_GET_CLASS(obj)", _tmp76 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
		(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
		_tmp77 = (g_free (_tmp77), NULL);
		_tmp76 = (g_free (_tmp76), NULL);
		_tmp79 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp79 = vala_ccode_newline_new ()));
		(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
		macro = (g_free (macro), NULL);
	}
	if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) cl))) == NULL) {
		ValaCCodeTypeDefinition* _tmp83;
		ValaCCodeVariableDeclarator* _tmp82;
		char* _tmp81;
		char* _tmp80;
		_tmp83 = NULL;
		_tmp82 = NULL;
		_tmp81 = NULL;
		_tmp80 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp83 = vala_ccode_type_definition_new (_tmp80 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->instance_struct)), (ValaCCodeDeclarator*) (_tmp82 = vala_ccode_variable_declarator_new (_tmp81 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))))));
		(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
		_tmp81 = (g_free (_tmp81), NULL);
		_tmp80 = (g_free (_tmp80), NULL);
	}
	if (vala_class_get_base_class (cl) != NULL) {
		char* _tmp84;
		_tmp84 = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_struct, _tmp84 = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE), "parent_instance");
		_tmp84 = (g_free (_tmp84), NULL);
	} else {
		if (is_fundamental) {
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_struct, "GTypeInstance", "parent_instance");
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_struct, "volatile int", "ref_count");
		}
	}
	_tmp85 = FALSE;
	_tmp86 = FALSE;
	if (vala_class_get_is_compact (cl)) {
		_tmp86 = vala_class_get_base_class (cl) == NULL;
	} else {
		_tmp86 = FALSE;
	}
	if (_tmp86) {
		GeeList* _tmp87;
		_tmp87 = NULL;
		_tmp85 = gee_collection_get_size ((GeeCollection*) (_tmp87 = vala_class_get_fields (cl))) == 0;
		(_tmp87 == NULL) ? NULL : (_tmp87 = (gee_collection_object_unref (_tmp87), NULL));
	} else {
		_tmp85 = FALSE;
	}
	if (_tmp85) {
		/* add dummy member, C doesn't allow empty structs*/
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_struct, "int", "dummy");
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp97;
		ValaCCodeVariableDeclarator* _tmp96;
		char* _tmp95;
		char* _tmp94;
		char* _tmp93;
		char* _tmp99;
		char* _tmp98;
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) cl))) == NULL) {
			ValaCCodeTypeDefinition* _tmp92;
			ValaCCodeVariableDeclarator* _tmp91;
			char* _tmp90;
			char* _tmp89;
			char* _tmp88;
			_tmp92 = NULL;
			_tmp91 = NULL;
			_tmp90 = NULL;
			_tmp89 = NULL;
			_tmp88 = NULL;
			vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp92 = vala_ccode_type_definition_new (_tmp88 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->type_struct)), (ValaCCodeDeclarator*) (_tmp91 = vala_ccode_variable_declarator_new (_tmp90 = g_strdup_printf ("%sClass", _tmp89 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))))));
			(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
			(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
			_tmp90 = (g_free (_tmp90), NULL);
			_tmp89 = (g_free (_tmp89), NULL);
			_tmp88 = (g_free (_tmp88), NULL);
		}
		_tmp97 = NULL;
		_tmp96 = NULL;
		_tmp95 = NULL;
		_tmp94 = NULL;
		_tmp93 = NULL;
		vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp97 = vala_ccode_type_definition_new (_tmp93 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->instance_priv_struct)), (ValaCCodeDeclarator*) (_tmp96 = vala_ccode_variable_declarator_new (_tmp95 = g_strdup_printf ("%sPrivate", _tmp94 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))))));
		(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
		(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
		_tmp95 = (g_free (_tmp95), NULL);
		_tmp94 = (g_free (_tmp94), NULL);
		_tmp93 = (g_free (_tmp93), NULL);
		_tmp99 = NULL;
		_tmp98 = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_struct, _tmp99 = g_strdup_printf ("%sPrivate *", _tmp98 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), "priv");
		_tmp99 = (g_free (_tmp99), NULL);
		_tmp98 = (g_free (_tmp98), NULL);
		if (is_fundamental) {
			char* _tmp101;
			char* _tmp100;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->type_struct, "GTypeClass", "parent_class");
			_tmp101 = NULL;
			_tmp100 = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->type_struct, "void", _tmp101 = g_strdup_printf ("(*finalize) (%s *self)", _tmp100 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)));
			_tmp101 = (g_free (_tmp101), NULL);
			_tmp100 = (g_free (_tmp100), NULL);
		} else {
			char* _tmp103;
			char* _tmp102;
			_tmp103 = NULL;
			_tmp102 = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->type_struct, _tmp103 = g_strdup_printf ("%sClass", _tmp102 = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_class_get_base_class (cl), FALSE)), "parent_class");
			_tmp103 = (g_free (_tmp103), NULL);
			_tmp102 = (g_free (_tmp102), NULL);
		}
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) cl)) != NULL) {
		ValaCCodeComment* _tmp104;
		_tmp104 = NULL;
		vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) (_tmp104 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) cl)))));
		(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
	}
	vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_struct);
	if (is_gtypeinstance) {
		gboolean _tmp105;
		vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->type_struct);
		_tmp105 = FALSE;
		if (vala_class_get_has_private_fields (cl)) {
			_tmp105 = TRUE;
		} else {
			GeeList* _tmp106;
			_tmp106 = NULL;
			_tmp105 = gee_collection_get_size ((GeeCollection*) (_tmp106 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp106 == NULL) ? NULL : (_tmp106 = (gee_collection_object_unref (_tmp106), NULL));
		}
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		if (_tmp105) {
			char* _tmp108;
			char* _tmp107;
			char* _tmp109;
			char* macro;
			ValaCCodeMacroReplacement* _tmp112;
			char* _tmp111;
			char* _tmp110;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_priv_struct);
			_tmp108 = NULL;
			_tmp107 = NULL;
			_tmp109 = NULL;
			macro = (_tmp109 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", _tmp107 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl), _tmp108 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)), _tmp108 = (g_free (_tmp108), NULL), _tmp107 = (g_free (_tmp107), NULL), _tmp109);
			_tmp112 = NULL;
			_tmp111 = NULL;
			_tmp110 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp112 = vala_ccode_macro_replacement_new (_tmp111 = g_strdup_printf ("%s_GET_PRIVATE(o)", _tmp110 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL)), macro)));
			(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
			_tmp111 = (g_free (_tmp111), NULL);
			_tmp110 = (g_free (_tmp110), NULL);
			macro = (g_free (macro), NULL);
		}
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->prop_enum);
	}
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (is_gtypeinstance) {
		gboolean _tmp132;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp139;
		if (is_fundamental) {
			ValaCCodeStruct* _tmp115;
			char* _tmp114;
			char* _tmp113;
			ValaCCodeTypeDefinition* _tmp120;
			ValaCCodeVariableDeclarator* _tmp119;
			char* _tmp118;
			char* _tmp117;
			char* _tmp116;
			ValaCCodeConstant* _tmp123;
			ValaCCodeMemberAccess* _tmp122;
			ValaCCodeIdentifier* _tmp121;
			ValaCCodeAssignment* _tmp124;
			ValaCCodeAssignment* ref_count;
			ValaCCodeExpressionStatement* _tmp125;
			_tmp115 = NULL;
			_tmp114 = NULL;
			_tmp113 = NULL;
			((ValaCCodeBaseModule*) self)->param_spec_struct = (_tmp115 = vala_ccode_struct_new (_tmp114 = g_strdup_printf ("_%sParamSpec%s", _tmp113 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl))), (((ValaCCodeBaseModule*) self)->param_spec_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->param_spec_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->param_spec_struct), NULL)), _tmp115);
			_tmp114 = (g_free (_tmp114), NULL);
			_tmp113 = (g_free (_tmp113), NULL);
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->param_spec_struct, "GParamSpec", "parent_instance");
			vala_ccode_fragment_append (def_frag, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->param_spec_struct);
			_tmp120 = NULL;
			_tmp119 = NULL;
			_tmp118 = NULL;
			_tmp117 = NULL;
			_tmp116 = NULL;
			vala_ccode_fragment_append (decl_frag, (ValaCCodeNode*) (_tmp120 = vala_ccode_type_definition_new (_tmp116 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (((ValaCCodeBaseModule*) self)->param_spec_struct)), (ValaCCodeDeclarator*) (_tmp119 = vala_ccode_variable_declarator_new (_tmp118 = g_strdup_printf ("%sParamSpec%s", _tmp117 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl)))))));
			(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
			(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
			_tmp118 = (g_free (_tmp118), NULL);
			_tmp117 = (g_free (_tmp117), NULL);
			_tmp116 = (g_free (_tmp116), NULL);
			((ValaCCodeBaseModule*) self)->gvaluecollector_h_needed = TRUE;
			vala_gobject_module_add_type_value_table_init_function (self, cl);
			vala_gobject_module_add_type_value_table_free_function (self, cl);
			vala_gobject_module_add_type_value_table_copy_function (self, cl);
			vala_gobject_module_add_type_value_table_peek_pointer_function (self, cl);
			vala_gobject_module_add_type_value_table_collect_value_function (self, cl);
			vala_gobject_module_add_type_value_table_lcopy_value_function (self, cl);
			vala_gobject_module_add_g_param_spec_type_function (self, cl);
			vala_gobject_module_add_g_value_get_function (self, cl);
			vala_gobject_module_add_g_value_set_function (self, cl);
			_tmp123 = NULL;
			_tmp122 = NULL;
			_tmp121 = NULL;
			_tmp124 = NULL;
			ref_count = (_tmp124 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp122 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("self")), "ref_count")), (ValaCCodeExpression*) (_tmp123 = vala_ccode_constant_new ("1")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)), (_tmp122 == NULL) ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)), (_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)), _tmp124);
			_tmp125 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->instance_init_fragment, (ValaCCodeNode*) (_tmp125 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ref_count)));
			(_tmp125 == NULL) ? NULL : (_tmp125 = (vala_ccode_node_unref (_tmp125), NULL));
			(ref_count == NULL) ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL));
		} else {
			if (is_gobject) {
				gboolean _tmp126;
				gboolean _tmp128;
				_tmp126 = FALSE;
				if (vala_gobject_module_class_has_readable_properties (self, cl)) {
					_tmp126 = TRUE;
				} else {
					GeeList* _tmp127;
					_tmp127 = NULL;
					_tmp126 = gee_collection_get_size ((GeeCollection*) (_tmp127 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
					(_tmp127 == NULL) ? NULL : (_tmp127 = (gee_collection_object_unref (_tmp127), NULL));
				}
				if (_tmp126) {
					vala_gobject_module_add_get_property_function (self, cl);
				}
				_tmp128 = FALSE;
				if (vala_gobject_module_class_has_writable_properties (self, cl)) {
					_tmp128 = TRUE;
				} else {
					GeeList* _tmp129;
					_tmp129 = NULL;
					_tmp128 = gee_collection_get_size ((GeeCollection*) (_tmp129 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
					(_tmp129 == NULL) ? NULL : (_tmp129 = (gee_collection_object_unref (_tmp129), NULL));
				}
				if (_tmp128) {
					vala_gobject_module_add_set_property_function (self, cl);
				}
			}
		}
		vala_gobject_module_add_class_init_function (self, cl);
		{
			GeeList* _tmp130;
			GeeIterator* _tmp131;
			GeeIterator* base_type_it;
			_tmp130 = NULL;
			_tmp131 = NULL;
			base_type_it = (_tmp131 = gee_iterable_iterator ((GeeIterable*) (_tmp130 = vala_class_get_base_types (cl))), (_tmp130 == NULL) ? NULL : (_tmp130 = (gee_collection_object_unref (_tmp130), NULL)), _tmp131);
			while (gee_iterator_next (base_type_it)) {
				ValaDataType* base_type;
				base_type = (ValaDataType*) gee_iterator_get (base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					vala_gobject_module_add_interface_init_function (self, cl, VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
		}
		vala_gobject_module_add_instance_init_function (self, cl);
		_tmp132 = FALSE;
		if (!vala_class_get_is_compact (cl)) {
			gboolean _tmp133;
			gboolean _tmp134;
			GeeList* _tmp135;
			gboolean _tmp136;
			_tmp133 = FALSE;
			_tmp134 = FALSE;
			_tmp135 = NULL;
			if ((_tmp136 = gee_collection_get_size ((GeeCollection*) (_tmp135 = vala_class_get_fields (cl))) > 0, (_tmp135 == NULL) ? NULL : (_tmp135 = (gee_collection_object_unref (_tmp135), NULL)), _tmp136)) {
				_tmp134 = TRUE;
			} else {
				_tmp134 = vala_class_get_destructor (cl) != NULL;
			}
			if (_tmp134) {
				_tmp133 = TRUE;
			} else {
				_tmp133 = vala_class_is_fundamental (cl);
			}
			_tmp132 = (_tmp133);
		} else {
			_tmp132 = FALSE;
		}
		if (_tmp132) {
			vala_gobject_module_add_finalize_function (self, cl);
		}
		type_fun = vala_class_register_function_new (cl, vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self));
		vala_typeregister_function_init_from_type ((ValaTypeRegisterFunction*) type_fun, ((ValaCCodeBaseModule*) self)->in_plugin);
		if (vala_symbol_get_access ((ValaSymbol*) cl) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp137;
			_tmp137 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp137 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
			(_tmp137 == NULL) ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL));
		} else {
			ValaCCodeFragment* _tmp138;
			_tmp138 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp138 = vala_typeregister_function_get_declaration ((ValaTypeRegisterFunction*) type_fun)));
			(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
		}
		_tmp139 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp139 = vala_typeregister_function_get_definition ((ValaTypeRegisterFunction*) type_fun)));
		(_tmp139 == NULL) ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL));
		if (((ValaCCodeBaseModule*) self)->in_plugin) {
			ValaCCodeIdentifier* _tmp142;
			char* _tmp141;
			char* _tmp140;
			ValaCCodeFunctionCall* _tmp143;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp144;
			ValaCCodeExpressionStatement* _tmp145;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp142 = NULL;
			_tmp141 = NULL;
			_tmp140 = NULL;
			_tmp143 = NULL;
			register_call = (_tmp143 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp142 = vala_ccode_identifier_new (_tmp141 = g_strdup_printf ("%s_register_type", _tmp140 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))))), (_tmp142 == NULL) ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)), _tmp141 = (g_free (_tmp141), NULL), _tmp140 = (g_free (_tmp140), NULL), _tmp143);
			_tmp144 = NULL;
			vala_ccode_function_call_add_argument (register_call, (ValaCCodeExpression*) (_tmp144 = vala_ccode_identifier_new (((ValaCCodeBaseModule*) self)->module_init_param_name)));
			(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
			_tmp145 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->module_init_fragment, (ValaCCodeNode*) (_tmp145 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) register_call)));
			(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
			(register_call == NULL) ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL));
		}
		if (is_fundamental) {
			char* _tmp147;
			char* _tmp146;
			ValaCCodeFunction* _tmp148;
			ValaCCodeFunction* ref_fun;
			char* _tmp150;
			char* _tmp149;
			ValaCCodeFunction* _tmp151;
			ValaCCodeFunction* unref_fun;
			ValaCCodeFormalParameter* _tmp152;
			ValaCCodeFormalParameter* _tmp153;
			ValaCCodeBlock* ref_block;
			ValaCCodeBlock* unref_block;
			char* _tmp159;
			char* _tmp158;
			ValaCCodeDeclaration* _tmp160;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp162;
			ValaCCodeIdentifier* _tmp161;
			ValaCCodeIdentifier* _tmp163;
			ValaCCodeMemberAccess* _tmp164;
			ValaCCodeMemberAccess* ref_count;
			ValaCCodeIdentifier* _tmp165;
			ValaCCodeFunctionCall* _tmp166;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeUnaryExpression* _tmp167;
			ValaCCodeExpressionStatement* _tmp168;
			ValaCCodeReturnStatement* _tmp170;
			ValaCCodeIdentifier* _tmp169;
			ValaCCodeBlock* destroy_block;
			ValaCCodeIdentifier* _tmp173;
			char* _tmp172;
			char* _tmp171;
			ValaCCodeFunctionCall* _tmp174;
			ValaCCodeFunctionCall* get_class;
			ValaCCodeIdentifier* _tmp175;
			ValaCCodeIdentifier* _tmp178;
			char* _tmp177;
			char* _tmp176;
			ValaCCodeFunctionCall* _tmp179;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp180;
			ValaCCodeFunctionCall* _tmp182;
			ValaCCodeMemberAccess* _tmp181;
			ValaCCodeIdentifier* _tmp183;
			ValaCCodeExpressionStatement* _tmp184;
			ValaCCodeIdentifier* _tmp185;
			ValaCCodeFunctionCall* _tmp186;
			ValaCCodeFunctionCall* free;
			ValaCCodeCastExpression* _tmp188;
			ValaCCodeIdentifier* _tmp187;
			ValaCCodeExpressionStatement* _tmp189;
			ValaCCodeFunctionCall* _tmp191;
			ValaCCodeIdentifier* _tmp190;
			ValaCCodeUnaryExpression* _tmp192;
			ValaCCodeIfStatement* _tmp193;
			_tmp147 = NULL;
			_tmp146 = NULL;
			_tmp148 = NULL;
			ref_fun = (_tmp148 = vala_ccode_function_new (_tmp147 = g_strconcat (_tmp146 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "ref", NULL), "gpointer"), _tmp147 = (g_free (_tmp147), NULL), _tmp146 = (g_free (_tmp146), NULL), _tmp148);
			_tmp150 = NULL;
			_tmp149 = NULL;
			_tmp151 = NULL;
			unref_fun = (_tmp151 = vala_ccode_function_new (_tmp150 = g_strconcat (_tmp149 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "unref", NULL), "void"), _tmp150 = (g_free (_tmp150), NULL), _tmp149 = (g_free (_tmp149), NULL), _tmp151);
			if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp152 = NULL;
			vala_ccode_function_add_parameter (ref_fun, _tmp152 = vala_ccode_formal_parameter_new ("instance", "gpointer"));
			(_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL));
			_tmp153 = NULL;
			vala_ccode_function_add_parameter (unref_fun, _tmp153 = vala_ccode_formal_parameter_new ("instance", "gpointer"));
			(_tmp153 == NULL) ? NULL : (_tmp153 = (vala_ccode_node_unref (_tmp153), NULL));
			if (vala_symbol_get_access ((ValaSymbol*) cl) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp154;
				ValaCCodeFunction* _tmp155;
				_tmp154 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp154 = vala_ccode_function_copy (ref_fun)));
				(_tmp154 == NULL) ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL));
				_tmp155 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp155 = vala_ccode_function_copy (unref_fun)));
				(_tmp155 == NULL) ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL));
			} else {
				ValaCCodeFunction* _tmp156;
				ValaCCodeFunction* _tmp157;
				_tmp156 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp156 = vala_ccode_function_copy (ref_fun)));
				(_tmp156 == NULL) ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL));
				_tmp157 = NULL;
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp157 = vala_ccode_function_copy (unref_fun)));
				(_tmp157 == NULL) ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL));
			}
			ref_block = vala_ccode_block_new ();
			unref_block = vala_ccode_block_new ();
			_tmp159 = NULL;
			_tmp158 = NULL;
			_tmp160 = NULL;
			cdecl_ = (_tmp160 = vala_ccode_declaration_new (_tmp159 = g_strconcat (_tmp158 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp159 = (g_free (_tmp159), NULL), _tmp158 = (g_free (_tmp158), NULL), _tmp160);
			_tmp162 = NULL;
			_tmp161 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp162 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) (_tmp161 = vala_ccode_identifier_new ("instance")))));
			(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
			(_tmp161 == NULL) ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL));
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) cdecl_);
			vala_ccode_block_add_statement (unref_block, (ValaCCodeNode*) cdecl_);
			_tmp163 = NULL;
			_tmp164 = NULL;
			ref_count = (_tmp164 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp163 = vala_ccode_identifier_new ("self")), "ref_count"), (_tmp163 == NULL) ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)), _tmp164);
			_tmp165 = NULL;
			_tmp166 = NULL;
			ccall = (_tmp166 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp165 = vala_ccode_identifier_new ("g_atomic_int_inc"))), (_tmp165 == NULL) ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)), _tmp166);
			_tmp167 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp167 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ref_count)));
			(_tmp167 == NULL) ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL));
			_tmp168 = NULL;
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) (_tmp168 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp168 == NULL) ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL));
			_tmp170 = NULL;
			_tmp169 = NULL;
			vala_ccode_block_add_statement (ref_block, (ValaCCodeNode*) (_tmp170 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp169 = vala_ccode_identifier_new ("instance")))));
			(_tmp170 == NULL) ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL));
			(_tmp169 == NULL) ? NULL : (_tmp169 = (vala_ccode_node_unref (_tmp169), NULL));
			destroy_block = vala_ccode_block_new ();
			_tmp173 = NULL;
			_tmp172 = NULL;
			_tmp171 = NULL;
			_tmp174 = NULL;
			get_class = (_tmp174 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp173 = vala_ccode_identifier_new (_tmp172 = g_strdup_printf ("%s_GET_CLASS", _tmp171 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp173 == NULL) ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)), _tmp172 = (g_free (_tmp172), NULL), _tmp171 = (g_free (_tmp171), NULL), _tmp174);
			_tmp175 = NULL;
			vala_ccode_function_call_add_argument (get_class, (ValaCCodeExpression*) (_tmp175 = vala_ccode_identifier_new ("self")));
			(_tmp175 == NULL) ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL));
			/* finalize class*/
			_tmp178 = NULL;
			_tmp177 = NULL;
			_tmp176 = NULL;
			_tmp179 = NULL;
			ccast = (_tmp179 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp178 = vala_ccode_identifier_new (_tmp177 = g_strdup_printf ("%s_GET_CLASS", _tmp176 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp178 == NULL) ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)), _tmp177 = (g_free (_tmp177), NULL), _tmp176 = (g_free (_tmp176), NULL), _tmp179);
			_tmp180 = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp180 = vala_ccode_identifier_new ("self")));
			(_tmp180 == NULL) ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL));
			_tmp182 = NULL;
			_tmp181 = NULL;
			ccall = (_tmp182 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp181 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp182);
			(_tmp181 == NULL) ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL));
			_tmp183 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp183 = vala_ccode_identifier_new ("self")));
			(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
			_tmp184 = NULL;
			vala_ccode_block_add_statement (destroy_block, (ValaCCodeNode*) (_tmp184 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp184 == NULL) ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL));
			/* free type instance*/
			_tmp185 = NULL;
			_tmp186 = NULL;
			free = (_tmp186 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp185 = vala_ccode_identifier_new ("g_type_free_instance"))), (_tmp185 == NULL) ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)), _tmp186);
			_tmp188 = NULL;
			_tmp187 = NULL;
			vala_ccode_function_call_add_argument (free, (ValaCCodeExpression*) (_tmp188 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp187 = vala_ccode_identifier_new ("self")), "GTypeInstance *")));
			(_tmp188 == NULL) ? NULL : (_tmp188 = (vala_ccode_node_unref (_tmp188), NULL));
			(_tmp187 == NULL) ? NULL : (_tmp187 = (vala_ccode_node_unref (_tmp187), NULL));
			_tmp189 = NULL;
			vala_ccode_block_add_statement (destroy_block, (ValaCCodeNode*) (_tmp189 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free)));
			(_tmp189 == NULL) ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL));
			_tmp191 = NULL;
			_tmp190 = NULL;
			ccall = (_tmp191 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp190 = vala_ccode_identifier_new ("g_atomic_int_dec_and_test"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp191);
			(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
			_tmp192 = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp192 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) ref_count)));
			(_tmp192 == NULL) ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL));
			_tmp193 = NULL;
			vala_ccode_block_add_statement (unref_block, (ValaCCodeNode*) (_tmp193 = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccall, (ValaCCodeStatement*) destroy_block, NULL)));
			(_tmp193 == NULL) ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL));
			vala_ccode_function_set_block (ref_fun, ref_block);
			vala_ccode_function_set_block (unref_fun, unref_block);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ref_fun);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) unref_fun);
			(ref_fun == NULL) ? NULL : (ref_fun = (vala_ccode_node_unref (ref_fun), NULL));
			(unref_fun == NULL) ? NULL : (unref_fun = (vala_ccode_node_unref (unref_fun), NULL));
			(ref_block == NULL) ? NULL : (ref_block = (vala_ccode_node_unref (ref_block), NULL));
			(unref_block == NULL) ? NULL : (unref_block = (vala_ccode_node_unref (unref_block), NULL));
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			(ref_count == NULL) ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(destroy_block == NULL) ? NULL : (destroy_block = (vala_ccode_node_unref (destroy_block), NULL));
			(get_class == NULL) ? NULL : (get_class = (vala_ccode_node_unref (get_class), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
			(free == NULL) ? NULL : (free = (vala_ccode_node_unref (free), NULL));
		}
		(type_fun == NULL) ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL));
	} else {
		char* _tmp195;
		char* _tmp194;
		ValaCCodeFunction* _tmp196;
		ValaCCodeFunction* function;
		ValaCCodeFormalParameter* _tmp199;
		char* _tmp198;
		char* _tmp197;
		ValaCCodeBlock* cblock;
		ValaCCodeIdentifier* _tmp202;
		ValaCCodeFunctionCall* _tmp203;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp205;
		char* _tmp204;
		ValaCCodeIdentifier* _tmp206;
		ValaCCodeExpressionStatement* _tmp207;
		vala_gobject_module_add_instance_init_function (self, cl);
		_tmp195 = NULL;
		_tmp194 = NULL;
		_tmp196 = NULL;
		function = (_tmp196 = vala_ccode_function_new (_tmp195 = g_strconcat (_tmp194 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "free", NULL), "void"), _tmp195 = (g_free (_tmp195), NULL), _tmp194 = (g_free (_tmp194), NULL), _tmp196);
		if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp199 = NULL;
		_tmp198 = NULL;
		_tmp197 = NULL;
		vala_ccode_function_add_parameter (function, _tmp199 = vala_ccode_formal_parameter_new ("self", _tmp198 = g_strconcat (_tmp197 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)));
		(_tmp199 == NULL) ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL));
		_tmp198 = (g_free (_tmp198), NULL);
		_tmp197 = (g_free (_tmp197), NULL);
		if (vala_symbol_get_access ((ValaSymbol*) cl) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFunction* _tmp200;
			_tmp200 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp200 = vala_ccode_function_copy (function)));
			(_tmp200 == NULL) ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL));
		} else {
			ValaCCodeFunction* _tmp201;
			_tmp201 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp201 = vala_ccode_function_copy (function)));
			(_tmp201 == NULL) ? NULL : (_tmp201 = (vala_ccode_node_unref (_tmp201), NULL));
		}
		cblock = vala_ccode_block_new ();
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
		if (vala_class_get_destructor (cl) != NULL) {
			vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_destructor (cl)));
		}
		_tmp202 = NULL;
		_tmp203 = NULL;
		ccall = (_tmp203 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp202 = vala_ccode_identifier_new ("g_slice_free"))), (_tmp202 == NULL) ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL)), _tmp203);
		_tmp205 = NULL;
		_tmp204 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp205 = vala_ccode_identifier_new (_tmp204 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
		(_tmp205 == NULL) ? NULL : (_tmp205 = (vala_ccode_node_unref (_tmp205), NULL));
		_tmp204 = (g_free (_tmp204), NULL);
		_tmp206 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp206 = vala_ccode_identifier_new ("self")));
		(_tmp206 == NULL) ? NULL : (_tmp206 = (vala_ccode_node_unref (_tmp206), NULL));
		_tmp207 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp207 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp207 == NULL) ? NULL : (_tmp207 = (vala_ccode_node_unref (_tmp207), NULL));
		vala_ccode_function_set_block (function, cblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
		(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	_tmp209 = NULL;
	_tmp208 = NULL;
	((ValaCCodeBaseModule*) self)->current_symbol = (_tmp209 = (_tmp208 = old_symbol, (_tmp208 == NULL) ? NULL : vala_code_node_ref (_tmp208)), (((ValaCCodeBaseModule*) self)->current_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_symbol), NULL)), _tmp209);
	_tmp211 = NULL;
	_tmp210 = NULL;
	((ValaCCodeBaseModule*) self)->current_type_symbol = (_tmp211 = (_tmp210 = old_type_symbol, (_tmp210 == NULL) ? NULL : vala_code_node_ref (_tmp210)), (((ValaCCodeBaseModule*) self)->current_type_symbol == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_type_symbol = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_type_symbol), NULL)), _tmp211);
	_tmp213 = NULL;
	_tmp212 = NULL;
	((ValaCCodeBaseModule*) self)->current_class = (_tmp213 = (_tmp212 = old_class, (_tmp212 == NULL) ? NULL : vala_code_node_ref (_tmp212)), (((ValaCCodeBaseModule*) self)->current_class == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_class = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_class), NULL)), _tmp213);
	_tmp215 = NULL;
	_tmp214 = NULL;
	((ValaCCodeBaseModule*) self)->instance_struct = (_tmp215 = (_tmp214 = old_instance_struct, (_tmp214 == NULL) ? NULL : vala_ccode_node_ref (_tmp214)), (((ValaCCodeBaseModule*) self)->instance_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_struct), NULL)), _tmp215);
	_tmp217 = NULL;
	_tmp216 = NULL;
	((ValaCCodeBaseModule*) self)->param_spec_struct = (_tmp217 = (_tmp216 = old_param_spec_struct, (_tmp216 == NULL) ? NULL : vala_ccode_node_ref (_tmp216)), (((ValaCCodeBaseModule*) self)->param_spec_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->param_spec_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->param_spec_struct), NULL)), _tmp217);
	_tmp219 = NULL;
	_tmp218 = NULL;
	((ValaCCodeBaseModule*) self)->type_struct = (_tmp219 = (_tmp218 = old_type_struct, (_tmp218 == NULL) ? NULL : vala_ccode_node_ref (_tmp218)), (((ValaCCodeBaseModule*) self)->type_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->type_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->type_struct), NULL)), _tmp219);
	_tmp221 = NULL;
	_tmp220 = NULL;
	((ValaCCodeBaseModule*) self)->instance_priv_struct = (_tmp221 = (_tmp220 = old_instance_priv_struct, (_tmp220 == NULL) ? NULL : vala_ccode_node_ref (_tmp220)), (((ValaCCodeBaseModule*) self)->instance_priv_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_priv_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_priv_struct), NULL)), _tmp221);
	_tmp223 = NULL;
	_tmp222 = NULL;
	((ValaCCodeBaseModule*) self)->prop_enum = (_tmp223 = (_tmp222 = old_prop_enum, (_tmp222 == NULL) ? NULL : vala_ccode_node_ref (_tmp222)), (((ValaCCodeBaseModule*) self)->prop_enum == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->prop_enum = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->prop_enum), NULL)), _tmp223);
	_tmp225 = NULL;
	_tmp224 = NULL;
	((ValaCCodeBaseModule*) self)->class_init_fragment = (_tmp225 = (_tmp224 = old_class_init_fragment, (_tmp224 == NULL) ? NULL : vala_ccode_node_ref (_tmp224)), (((ValaCCodeBaseModule*) self)->class_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->class_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->class_init_fragment), NULL)), _tmp225);
	_tmp227 = NULL;
	_tmp226 = NULL;
	((ValaCCodeBaseModule*) self)->instance_init_fragment = (_tmp227 = (_tmp226 = old_instance_init_fragment, (_tmp226 == NULL) ? NULL : vala_ccode_node_ref (_tmp226)), (((ValaCCodeBaseModule*) self)->instance_init_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_init_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_init_fragment), NULL)), _tmp227);
	_tmp229 = NULL;
	_tmp228 = NULL;
	((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (_tmp229 = (_tmp228 = old_instance_finalize_fragment, (_tmp228 == NULL) ? NULL : vala_ccode_node_ref (_tmp228)), (((ValaCCodeBaseModule*) self)->instance_finalize_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->instance_finalize_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->instance_finalize_fragment), NULL)), _tmp229);
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_type_symbol == NULL) ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL));
	(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
	(old_instance_struct == NULL) ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL));
	(old_param_spec_struct == NULL) ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL));
	(old_type_struct == NULL) ? NULL : (old_type_struct = (vala_ccode_node_unref (old_type_struct), NULL));
	(old_instance_priv_struct == NULL) ? NULL : (old_instance_priv_struct = (vala_ccode_node_unref (old_instance_priv_struct), NULL));
	(old_prop_enum == NULL) ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL));
	(old_class_init_fragment == NULL) ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL));
	(old_instance_init_fragment == NULL) ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL));
	(old_instance_finalize_fragment == NULL) ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL));
	(decl_frag == NULL) ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL));
	(def_frag == NULL) ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL));
}


static void vala_gobject_module_add_type_value_table_init_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeExpressionStatement* _tmp9;
	ValaCCodeAssignment* _tmp8;
	ValaCCodeConstant* _tmp7;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp9 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE)), (ValaCCodeExpression*) (_tmp7 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
}


static void vala_gobject_module_add_type_value_table_free_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* _tmp9;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* ifbody;
	ValaCCodeExpressionStatement* _tmp11;
	ValaCCodeIfStatement* _tmp12;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_free_value", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	vpointer = (_tmp6 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp6);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp10 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_identifier_new (_tmp8 = g_strconcat (_tmp7 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "unref", NULL)))), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), _tmp8 = (g_free (_tmp8), NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp10);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) vpointer);
	ifbody = vala_ccode_block_new ();
	_tmp11 = NULL;
	vala_ccode_block_add_statement (ifbody, (ValaCCodeNode*) (_tmp11 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp12 = vala_ccode_if_statement_new ((ValaCCodeExpression*) vpointer, (ValaCCodeStatement*) ifbody, NULL)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(ifbody == NULL) ? NULL : (ifbody = (vala_ccode_node_unref (ifbody), NULL));
}


static void vala_gobject_module_add_type_value_table_copy_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeMemberAccess* dest_vpointer;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeMemberAccess* _tmp10;
	ValaCCodeMemberAccess* src_vpointer;
	ValaCCodeIdentifier* _tmp13;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ref_ccall;
	ValaCCodeBlock* true_stmt;
	ValaCCodeExpressionStatement* _tmp16;
	ValaCCodeAssignment* _tmp15;
	ValaCCodeBlock* false_stmt;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIfStatement* if_statement;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_copy_value", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("src_value", "const GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("dest_value", "GValue*"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	dest_vpointer = (_tmp7 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("dest_value")), "data[0]")), "v_pointer", FALSE), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	src_vpointer = (_tmp10 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("src_value")), "data[0]")), "v_pointer", FALSE), (_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp10);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp14 = NULL;
	ref_ccall = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new (_tmp12 = g_strconcat (_tmp11 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "ref", NULL)))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp12 = (g_free (_tmp12), NULL), _tmp11 = (g_free (_tmp11), NULL), _tmp14);
	vala_ccode_function_call_add_argument (ref_ccall, (ValaCCodeExpression*) src_vpointer);
	true_stmt = vala_ccode_block_new ();
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp16 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_assignment_new ((ValaCCodeExpression*) dest_vpointer, (ValaCCodeExpression*) ref_ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	false_stmt = vala_ccode_block_new ();
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_assignment_new ((ValaCCodeExpression*) dest_vpointer, (ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) src_vpointer, (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(dest_vpointer == NULL) ? NULL : (dest_vpointer = (vala_ccode_node_unref (dest_vpointer), NULL));
	(src_vpointer == NULL) ? NULL : (src_vpointer = (vala_ccode_node_unref (src_vpointer), NULL));
	(ref_ccall == NULL) ? NULL : (ref_ccall = (vala_ccode_node_unref (ref_ccall), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
}


static void vala_gobject_module_add_type_value_table_peek_pointer_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeReturnStatement* ret;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_peek_pointer", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gpointer"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	vpointer = (_tmp6 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp5 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), (_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)), _tmp6);
	ret = vala_ccode_return_statement_new ((ValaCCodeExpression*) vpointer);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ret);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(ret == NULL) ? NULL : (ret = (vala_ccode_node_unref (ret), NULL));
}


static void vala_gobject_module_add_type_value_table_lcopy_value_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* object_p_ptr;
	ValaCCodeConstant* null_;
	ValaCCodeBlock* init_block;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeMemberAccess* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* value_type_name_fct;
	ValaCCodeConstant* _tmp18;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeUnaryExpression* _tmp20;
	ValaCCodeUnaryExpression* assert_condition;
	ValaCCodeBlock* assert_true;
	ValaCCodeIdentifier* _tmp21;
	ValaCCodeFunctionCall* _tmp22;
	ValaCCodeFunctionCall* assert_printf;
	ValaCCodeConstant* _tmp23;
	ValaCCodeReturnStatement* _tmp24;
	ValaCCodeIfStatement* if_assert;
	ValaCCodeBlock* main_else_true;
	ValaCCodeBlock* main_else_if_true;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeBinaryExpression* _tmp27;
	ValaCCodeBinaryExpression* main_else_if_condition;
	ValaCCodeIfStatement* main_else_if;
	ValaCCodeBlock* main_true;
	ValaCCodeUnaryExpression* main_condition;
	ValaCCodeIfStatement* if_main;
	ValaCCodeIdentifier* _tmp29;
	char* _tmp28;
	ValaCCodeFunctionCall* _tmp30;
	ValaCCodeFunctionCall* ref_fct;
	ValaCCodeExpressionStatement* _tmp32;
	ValaCCodeAssignment* _tmp31;
	ValaCCodeExpressionStatement* _tmp34;
	ValaCCodeAssignment* _tmp33;
	ValaCCodeExpressionStatement* _tmp36;
	ValaCCodeAssignment* _tmp35;
	ValaCCodeReturnStatement* _tmp37;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_lcopy_value", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gchar*"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("n_collect_values", "guint"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("collect_flags", "guint"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	vpointer = (_tmp9 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp9);
	object_p_ptr = vala_ccode_identifier_new ("*object_p");
	null_ = vala_ccode_constant_new ("NULL");
	init_block = vala_ccode_block_new ();
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	ctypedecl = (_tmp12 = vala_ccode_declaration_new (_tmp11 = g_strconcat (_tmp10 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "**", NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp12);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("object_p", (ValaCCodeExpression*) (_tmp14 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("collect_values[0]")), "v_pointer", FALSE)))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp16 = NULL;
	_tmp17 = NULL;
	value_type_name_fct = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("G_VALUE_TYPE_NAME"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (value_type_name_fct, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("value")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	_tmp20 = NULL;
	assert_condition = (_tmp20 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("object_p"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	vala_ccode_function_set_block (function, init_block);
	assert_true = vala_ccode_block_new ();
	_tmp21 = NULL;
	_tmp22 = NULL;
	assert_printf = (_tmp22 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new ("g_strdup_printf"))), (_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)), _tmp22);
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (assert_printf, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("\"value location for `%s' passed as NULL\"")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	vala_ccode_function_call_add_argument (assert_printf, (ValaCCodeExpression*) value_type_name_fct);
	_tmp24 = NULL;
	vala_ccode_block_add_statement (assert_true, (ValaCCodeNode*) (_tmp24 = vala_ccode_return_statement_new ((ValaCCodeExpression*) assert_printf)));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	if_assert = vala_ccode_if_statement_new ((ValaCCodeExpression*) assert_condition, (ValaCCodeStatement*) assert_true, NULL);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_assert);
	main_else_true = vala_ccode_block_new ();
	main_else_if_true = vala_ccode_block_new ();
	_tmp26 = NULL;
	_tmp25 = NULL;
	_tmp27 = NULL;
	main_else_if_condition = (_tmp27 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("collect_flags")), (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("G_VALUE_NOCOPY_CONTENTS"))), (_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), _tmp27);
	main_else_if = vala_ccode_if_statement_new ((ValaCCodeExpression*) main_else_if_condition, (ValaCCodeStatement*) main_else_if_true, (ValaCCodeStatement*) main_else_true);
	main_true = vala_ccode_block_new ();
	main_condition = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) vpointer);
	if_main = vala_ccode_if_statement_new ((ValaCCodeExpression*) main_condition, (ValaCCodeStatement*) main_true, (ValaCCodeStatement*) main_else_if);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_main);
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp30 = NULL;
	ref_fct = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (_tmp28 = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)), _tmp28 = (g_free (_tmp28), NULL), _tmp30);
	vala_ccode_function_call_add_argument (ref_fct, (ValaCCodeExpression*) vpointer);
	_tmp32 = NULL;
	_tmp31 = NULL;
	vala_ccode_block_add_statement (main_true, (ValaCCodeNode*) (_tmp32 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) null_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (main_else_if_true, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) vpointer, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp36 = NULL;
	_tmp35 = NULL;
	vala_ccode_block_add_statement (main_else_true, (ValaCCodeNode*) (_tmp36 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_assignment_new ((ValaCCodeExpression*) object_p_ptr, (ValaCCodeExpression*) ref_fct, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	_tmp37 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp37 = vala_ccode_return_statement_new ((ValaCCodeExpression*) null_)));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(object_p_ptr == NULL) ? NULL : (object_p_ptr = (vala_ccode_node_unref (object_p_ptr), NULL));
	(null_ == NULL) ? NULL : (null_ = (vala_ccode_node_unref (null_), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(value_type_name_fct == NULL) ? NULL : (value_type_name_fct = (vala_ccode_node_unref (value_type_name_fct), NULL));
	(assert_condition == NULL) ? NULL : (assert_condition = (vala_ccode_node_unref (assert_condition), NULL));
	(assert_true == NULL) ? NULL : (assert_true = (vala_ccode_node_unref (assert_true), NULL));
	(assert_printf == NULL) ? NULL : (assert_printf = (vala_ccode_node_unref (assert_printf), NULL));
	(if_assert == NULL) ? NULL : (if_assert = (vala_ccode_node_unref (if_assert), NULL));
	(main_else_true == NULL) ? NULL : (main_else_true = (vala_ccode_node_unref (main_else_true), NULL));
	(main_else_if_true == NULL) ? NULL : (main_else_if_true = (vala_ccode_node_unref (main_else_if_true), NULL));
	(main_else_if_condition == NULL) ? NULL : (main_else_if_condition = (vala_ccode_node_unref (main_else_if_condition), NULL));
	(main_else_if == NULL) ? NULL : (main_else_if = (vala_ccode_node_unref (main_else_if), NULL));
	(main_true == NULL) ? NULL : (main_true = (vala_ccode_node_unref (main_true), NULL));
	(main_condition == NULL) ? NULL : (main_condition = (vala_ccode_node_unref (main_condition), NULL));
	(if_main == NULL) ? NULL : (if_main = (vala_ccode_node_unref (if_main), NULL));
	(ref_fct == NULL) ? NULL : (ref_fct = (vala_ccode_node_unref (ref_fct), NULL));
}


static void vala_gobject_module_add_type_value_table_collect_value_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeMemberAccess* _tmp11;
	ValaCCodeMemberAccess* collect_vpointer;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeIdentifier* obj_identifier;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeDeclaration* _tmp14;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeMemberAccess* _tmp16;
	ValaCCodeMemberAccess* _tmp17;
	ValaCCodeMemberAccess* l_expression;
	ValaCCodeConstant* _tmp18;
	ValaCCodeBinaryExpression* _tmp19;
	ValaCCodeBinaryExpression* sub_condition;
	ValaCCodeBlock* sub_true_stmt;
	ValaCCodeBlock* sub_false_stmt;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* type_check;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeFunctionCall* _tmp26;
	ValaCCodeFunctionCall* type_name_fct;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp28;
	ValaCCodeFunctionCall* stored_type;
	ValaCCodeIdentifier* _tmp29;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeFunctionCall* value_type_name_fct;
	ValaCCodeConstant* _tmp32;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeFunctionCall* _tmp34;
	ValaCCodeFunctionCall* true_return;
	ValaCCodeConstant* _tmp35;
	ValaCCodeConstant* _tmp36;
	ValaCCodeConstant* _tmp37;
	ValaCCodeReturnStatement* _tmp38;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeFunctionCall* _tmp40;
	ValaCCodeFunctionCall* false_return;
	ValaCCodeConstant* _tmp41;
	ValaCCodeConstant* _tmp42;
	ValaCCodeConstant* _tmp43;
	ValaCCodeConstant* _tmp44;
	ValaCCodeReturnStatement* _tmp45;
	ValaCCodeUnaryExpression* _tmp46;
	ValaCCodeIfStatement* _tmp47;
	ValaCCodeIfStatement* sub_else_if_statement;
	ValaCCodeIfStatement* sub_if_statement;
	ValaCCodeIdentifier* _tmp49;
	char* _tmp48;
	ValaCCodeFunctionCall* _tmp50;
	ValaCCodeFunctionCall* ref_call;
	ValaCCodeIdentifier* _tmp51;
	ValaCCodeAssignment* _tmp52;
	ValaCCodeExpressionStatement* _tmp53;
	ValaCCodeExpressionStatement* true_assignment;
	ValaCCodeAssignment* _tmp55;
	ValaCCodeConstant* _tmp54;
	ValaCCodeExpressionStatement* _tmp56;
	ValaCCodeExpressionStatement* else_assigment;
	ValaCCodeReturnStatement* _tmp58;
	ValaCCodeConstant* _tmp57;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_collect_value", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "value_")), "gchar*"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("n_collect_values", "guint"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, _tmp5 = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp6 = vala_ccode_formal_parameter_new ("collect_flags", "guint"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	vpointer = (_tmp9 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp9);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp10 = NULL;
	_tmp11 = NULL;
	collect_vpointer = (_tmp11 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("collect_values[0]")), "v_pointer", FALSE), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) collect_vpointer, (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	obj_identifier = vala_ccode_identifier_new ("object");
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	ctypedecl = (_tmp14 = vala_ccode_declaration_new (_tmp13 = g_strconcat (_tmp12 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp13 = (g_free (_tmp13), NULL), _tmp12 = (g_free (_tmp12), NULL), _tmp14);
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("object", (ValaCCodeExpression*) collect_vpointer)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) ctypedecl);
	_tmp16 = NULL;
	_tmp17 = NULL;
	l_expression = (_tmp17 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) obj_identifier, "parent_instance")), "g_class", FALSE), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	_tmp18 = NULL;
	_tmp19 = NULL;
	sub_condition = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) l_expression, (ValaCCodeExpression*) (_tmp18 = vala_ccode_constant_new ("NULL"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
	sub_true_stmt = vala_ccode_block_new ();
	sub_false_stmt = vala_ccode_block_new ();
	_tmp20 = NULL;
	_tmp21 = NULL;
	reg_call = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("g_value_type_compatible"))), (_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)), _tmp21);
	_tmp22 = NULL;
	_tmp23 = NULL;
	type_check = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp23);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (type_check, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("object")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) type_check);
	_tmp25 = NULL;
	_tmp26 = NULL;
	type_name_fct = (_tmp26 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("g_type_name"))), (_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)), _tmp26);
	vala_ccode_function_call_add_argument (type_name_fct, (ValaCCodeExpression*) type_check);
	_tmp27 = NULL;
	_tmp28 = NULL;
	stored_type = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)), _tmp28);
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (stored_type, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("value")));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) stored_type);
	_tmp30 = NULL;
	_tmp31 = NULL;
	value_type_name_fct = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("G_VALUE_TYPE_NAME"))), (_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)), _tmp31);
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (value_type_name_fct, (ValaCCodeExpression*) (_tmp32 = vala_ccode_constant_new ("value")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp33 = NULL;
	_tmp34 = NULL;
	true_return = (_tmp34 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("g_strconcat"))), (_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)), _tmp34);
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp35 = vala_ccode_constant_new ("\"invalid unclassed object pointer for value type `\"")));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) value_type_name_fct);
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp36 = vala_ccode_constant_new ("\"'\"")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp37 = NULL;
	vala_ccode_function_call_add_argument (true_return, (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new ("NULL")));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp38 = NULL;
	vala_ccode_block_add_statement (sub_true_stmt, (ValaCCodeNode*) (_tmp38 = vala_ccode_return_statement_new ((ValaCCodeExpression*) true_return)));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	_tmp39 = NULL;
	_tmp40 = NULL;
	false_return = (_tmp40 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("g_strconcat"))), (_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)), _tmp40);
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp41 = vala_ccode_constant_new ("\"invalid object type `\"")));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) type_name_fct);
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp42 = vala_ccode_constant_new ("\"' for value type `\"")));
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) value_type_name_fct);
	_tmp43 = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp43 = vala_ccode_constant_new ("\"'\"")));
	(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
	_tmp44 = NULL;
	vala_ccode_function_call_add_argument (false_return, (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("NULL")));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	_tmp45 = NULL;
	vala_ccode_block_add_statement (sub_false_stmt, (ValaCCodeNode*) (_tmp45 = vala_ccode_return_statement_new ((ValaCCodeExpression*) false_return)));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp46 = NULL;
	_tmp47 = NULL;
	sub_else_if_statement = (_tmp47 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, (ValaCCodeExpression*) reg_call)), (ValaCCodeStatement*) sub_false_stmt, NULL), (_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)), _tmp47);
	vala_ccode_if_statement_set_else_if (sub_else_if_statement, TRUE);
	sub_if_statement = vala_ccode_if_statement_new ((ValaCCodeExpression*) sub_condition, (ValaCCodeStatement*) sub_true_stmt, (ValaCCodeStatement*) sub_else_if_statement);
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) sub_if_statement);
	_tmp49 = NULL;
	_tmp48 = NULL;
	_tmp50 = NULL;
	ref_call = (_tmp50 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new (_tmp48 = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)), _tmp48 = (g_free (_tmp48), NULL), _tmp50);
	_tmp51 = NULL;
	vala_ccode_function_call_add_argument (ref_call, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("object")));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp52 = NULL;
	_tmp53 = NULL;
	true_assignment = (_tmp53 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) ref_call, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), _tmp53);
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) true_assignment);
	_tmp55 = NULL;
	_tmp54 = NULL;
	_tmp56 = NULL;
	else_assigment = (_tmp56 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp55 = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp54 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE))), (_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)), (_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)), _tmp56);
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) else_assigment);
	_tmp58 = NULL;
	_tmp57 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp58 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_constant_new ("NULL")))));
	(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(collect_vpointer == NULL) ? NULL : (collect_vpointer = (vala_ccode_node_unref (collect_vpointer), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
	(obj_identifier == NULL) ? NULL : (obj_identifier = (vala_ccode_node_unref (obj_identifier), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(l_expression == NULL) ? NULL : (l_expression = (vala_ccode_node_unref (l_expression), NULL));
	(sub_condition == NULL) ? NULL : (sub_condition = (vala_ccode_node_unref (sub_condition), NULL));
	(sub_true_stmt == NULL) ? NULL : (sub_true_stmt = (vala_ccode_node_unref (sub_true_stmt), NULL));
	(sub_false_stmt == NULL) ? NULL : (sub_false_stmt = (vala_ccode_node_unref (sub_false_stmt), NULL));
	(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
	(type_check == NULL) ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL));
	(type_name_fct == NULL) ? NULL : (type_name_fct = (vala_ccode_node_unref (type_name_fct), NULL));
	(stored_type == NULL) ? NULL : (stored_type = (vala_ccode_node_unref (stored_type), NULL));
	(value_type_name_fct == NULL) ? NULL : (value_type_name_fct = (vala_ccode_node_unref (value_type_name_fct), NULL));
	(true_return == NULL) ? NULL : (true_return = (vala_ccode_node_unref (true_return), NULL));
	(false_return == NULL) ? NULL : (false_return = (vala_ccode_node_unref (false_return), NULL));
	(sub_else_if_statement == NULL) ? NULL : (sub_else_if_statement = (vala_ccode_node_unref (sub_else_if_statement), NULL));
	(sub_if_statement == NULL) ? NULL : (sub_if_statement = (vala_ccode_node_unref (sub_if_statement), NULL));
	(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
	(true_assignment == NULL) ? NULL : (true_assignment = (vala_ccode_node_unref (true_assignment), NULL));
	(else_assigment == NULL) ? NULL : (else_assigment = (vala_ccode_node_unref (else_assigment), NULL));
}


static void vala_gobject_module_add_g_param_spec_type_function (ValaGObjectModule* self, ValaClass* cl) {
	char* function_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeBlock* init_block;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* subccall;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeExpressionStatement* _tmp36;
	ValaCCodeAssignment* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeMemberAccess* _tmp33;
	ValaCCodeReturnStatement* _tmp37;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	function_name = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, "param_spec_");
	function = vala_ccode_function_new (function_name, "GParamSpec*");
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (function, _tmp0 = vala_ccode_formal_parameter_new ("name", "const gchar*"));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (function, _tmp1 = vala_ccode_formal_parameter_new ("nick", "const gchar*"));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp2 = vala_ccode_formal_parameter_new ("blurb", "const gchar*"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("object_type", "GType"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, _tmp4 = vala_ccode_formal_parameter_new ("flags", "GParamFlags"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	vala_class_set_param_spec_function (cl, function_name);
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp5;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp5 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (function)));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	} else {
		ValaCCodeFunction* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (function)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	ctypedecl = (_tmp9 = vala_ccode_declaration_new (_tmp8 = g_strdup_printf ("%sParamSpec%s*", _tmp7 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) cl)), vala_symbol_get_name ((ValaSymbol*) cl))), _tmp8 = (g_free (_tmp8), NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp10 = vala_ccode_variable_declarator_new ("spec")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp11 = NULL;
	_tmp12 = NULL;
	subccall = (_tmp12 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_type_is_a"))), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (subccall, (ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("object_type")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (subccall, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp16 = NULL;
	_tmp17 = NULL;
	ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_return_val_if_fail"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) subccall);
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("NULL")));
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	ccall = (_tmp21 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp20 = vala_ccode_identifier_new ("g_param_spec_internal"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp21);
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("G_TYPE_PARAM_OBJECT")));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23 = vala_ccode_identifier_new ("name")));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("nick")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("blurb")));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("flags")));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp29 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("spec")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	ccall = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("G_PARAM_SPEC"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp31);
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("spec")));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp36 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp35 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "value_type")), (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("object_type")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp37 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp37 = vala_ccode_return_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	function_name = (g_free (function_name), NULL);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(subccall == NULL) ? NULL : (subccall = (vala_ccode_node_unref (subccall), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_gobject_module_add_g_value_set_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp17;
	char* _tmp16;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeAssignment* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIfStatement* _tmp25;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp30;
	char* _tmp29;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeFunctionCall* _tmp35;
	ValaCCodeFunctionCall* ccall_typefrominstance;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeFunctionCall* _tmp38;
	ValaCCodeFunctionCall* ccall_gvaluetype;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeFunctionCall* ccall_typecompatible;
	ValaCCodeFunctionCall* _tmp43;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpressionStatement* _tmp44;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeAssignment* _tmp46;
	ValaCCodeConstant* _tmp45;
	ValaCCodeFunctionCall* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	char* _tmp48;
	ValaCCodeExpressionStatement* _tmp51;
	ValaCCodeExpressionStatement* _tmp54;
	ValaCCodeAssignment* _tmp53;
	ValaCCodeConstant* _tmp52;
	ValaCCodeBlock* _tmp55;
	ValaCCodeIfStatement* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeFunctionCall* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	char* _tmp58;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeExpressionStatement* _tmp62;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) cl), "void"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp2 = vala_ccode_formal_parameter_new ("value", "GValue*"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, _tmp3 = vala_ccode_formal_parameter_new ("v_object", "gpointer"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp4;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp4 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp4 = vala_ccode_function_copy (function)));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	} else {
		ValaCCodeFunction* _tmp5;
		_tmp5 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp5 = vala_ccode_function_copy (function)));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	vpointer = (_tmp8 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp8);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	ctypedecl = (_tmp11 = vala_ccode_declaration_new (_tmp10 = g_strconcat (_tmp9 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE), "*", NULL)), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new ("old")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ctypedecl);
	_tmp13 = NULL;
	_tmp14 = NULL;
	ccall_typecheck = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("value")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (_tmp16 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp18 = NULL;
	_tmp19 = NULL;
	ccall = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new ("g_return_if_fail"))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp19);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp20 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp20 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("old")), (ValaCCodeExpression*) vpointer, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	_tmp24 = NULL;
	_tmp25 = NULL;
	if_statement = (_tmp25 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("v_object")), (ValaCCodeStatement*) true_stmt, (ValaCCodeStatement*) false_stmt), (_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)), _tmp25);
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	_tmp27 = NULL;
	_tmp26 = NULL;
	ccall_typecheck = (_tmp27 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new ("G_TYPE_CHECK_INSTANCE_TYPE"))), (ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("v_object")));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new (_tmp29 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp32 = NULL;
	_tmp31 = NULL;
	ccall = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("g_return_if_fail"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp32);
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp33 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp33 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	_tmp34 = NULL;
	_tmp35 = NULL;
	ccall_typefrominstance = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE"))), (_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)), _tmp35);
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (ccall_typefrominstance, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("v_object")));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	_tmp37 = NULL;
	_tmp38 = NULL;
	ccall_gvaluetype = (_tmp38 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37 = vala_ccode_identifier_new ("G_VALUE_TYPE"))), (_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)), _tmp38);
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (ccall_gvaluetype, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("value")));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp40 = NULL;
	_tmp41 = NULL;
	ccall_typecompatible = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("g_value_type_compatible"))), (_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)), _tmp41);
	vala_ccode_function_call_add_argument (ccall_typecompatible, (ValaCCodeExpression*) ccall_typefrominstance);
	vala_ccode_function_call_add_argument (ccall_typecompatible, (ValaCCodeExpression*) ccall_gvaluetype);
	_tmp43 = NULL;
	_tmp42 = NULL;
	ccall = (_tmp43 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("g_return_if_fail"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp43);
	(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecompatible);
	_tmp44 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp44 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp47 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("v_object")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
	(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	ccall = (_tmp50 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new (_tmp48 = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) cl)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp50);
	(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
	_tmp48 = (g_free (_tmp48), NULL);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) vpointer);
	_tmp51 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp51 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
	_tmp54 = NULL;
	_tmp53 = NULL;
	_tmp52 = NULL;
	vala_ccode_block_add_statement (false_stmt, (ValaCCodeNode*) (_tmp54 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp53 = vala_ccode_assignment_new ((ValaCCodeExpression*) vpointer, (ValaCCodeExpression*) (_tmp52 = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
	(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
	_tmp55 = NULL;
	true_stmt = (_tmp55 = vala_ccode_block_new (), (true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL)), _tmp55);
	_tmp57 = NULL;
	_tmp56 = NULL;
	if_statement = (_tmp57 = vala_ccode_if_statement_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("old")), (ValaCCodeStatement*) true_stmt, NULL), (if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL)), _tmp57);
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) if_statement);
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp58 = NULL;
	ccall = (_tmp60 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_identifier_new (_tmp58 = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) cl)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp60);
	(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
	_tmp58 = (g_free (_tmp58), NULL);
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new ("old")));
	(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
	_tmp62 = NULL;
	vala_ccode_block_add_statement (true_stmt, (ValaCCodeNode*) (_tmp62 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
	(ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(true_stmt == NULL) ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL));
	(false_stmt == NULL) ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL));
	(if_statement == NULL) ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL));
	(ccall_typefrominstance == NULL) ? NULL : (ccall_typefrominstance = (vala_ccode_node_unref (ccall_typefrominstance), NULL));
	(ccall_gvaluetype == NULL) ? NULL : (ccall_gvaluetype = (vala_ccode_node_unref (ccall_gvaluetype), NULL));
	(ccall_typecompatible == NULL) ? NULL : (ccall_typecompatible = (vala_ccode_node_unref (ccall_typecompatible), NULL));
}


static void vala_gobject_module_add_g_value_get_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	char* _tmp11;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeExpressionStatement* _tmp16;
	ValaCCodeReturnStatement* _tmp17;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new (_tmp0 = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) cl), "gpointer"), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, _tmp2 = vala_ccode_formal_parameter_new ("value", "const GValue*"));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	if (vala_symbol_get_access ((ValaSymbol*) cl) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp3;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp3 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp3 = vala_ccode_function_copy (function)));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	} else {
		ValaCCodeFunction* _tmp4;
		_tmp4 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp4 = vala_ccode_function_copy (function)));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	vpointer = (_tmp7 = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("value")), "data[0]")), "v_pointer", FALSE), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), (_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)), _tmp7);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall_typecheck = (_tmp9 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE"))), (_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("value")));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp11 = (g_free (_tmp11), NULL);
	_tmp13 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp14 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("g_return_val_if_fail"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccall_typecheck);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("NULL")));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	_tmp16 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp16 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17 = vala_ccode_return_statement_new ((ValaCCodeExpression*) vpointer)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(vpointer == NULL) ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall_typecheck == NULL) ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
}


static void vala_gobject_module_add_class_init_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17;
	gboolean _tmp18;
	gboolean _tmp19;
	gboolean _tmp38;
	GeeList* fields;
	ValaCCodeFragment* _tmp210;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	class_init = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_class_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (class_init, _tmp5 = vala_ccode_formal_parameter_new ("klass", _tmp4 = g_strdup_printf ("%sClass *", _tmp3 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	parent_var_decl = (_tmp8 = vala_ccode_variable_declarator_new (_tmp7 = g_strdup_printf ("%s_parent_class", _tmp6 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL))), _tmp7 = (g_free (_tmp7), NULL), _tmp6 = (g_free (_tmp6), NULL), _tmp8);
	_tmp9 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	vala_ccode_declaration_add_declarator (parent_decl, (ValaCCodeDeclarator*) parent_var_decl);
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) parent_decl);
	_tmp11 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp11 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new ("klass")));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	parent_assignment = (_tmp16 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new (_tmp14 = g_strdup_printf ("%s_parent_class", _tmp13 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)), _tmp14 = (g_free (_tmp14), NULL), _tmp13 = (g_free (_tmp13), NULL), _tmp16);
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp17 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) parent_assignment)));
	(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
	_tmp18 = FALSE;
	_tmp19 = FALSE;
	if (!vala_class_get_is_compact (cl)) {
		_tmp19 = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		gboolean _tmp20;
		gboolean _tmp21;
		GeeList* _tmp22;
		gboolean _tmp23;
		_tmp20 = FALSE;
		_tmp21 = FALSE;
		_tmp22 = NULL;
		if ((_tmp23 = gee_collection_get_size ((GeeCollection*) (_tmp22 = vala_class_get_fields (cl))) > 0, (_tmp22 == NULL) ? NULL : (_tmp22 = (gee_collection_object_unref (_tmp22), NULL)), _tmp23)) {
			_tmp21 = TRUE;
		} else {
			_tmp21 = vala_class_get_destructor (cl) != NULL;
		}
		if (_tmp21) {
			_tmp20 = TRUE;
		} else {
			_tmp20 = vala_class_is_fundamental (cl);
		}
		_tmp18 = (_tmp20);
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		ValaClass* _tmp24;
		ValaClass* fundamental_class;
		ValaCCodeFunctionCall* _tmp30;
		ValaCCodeIdentifier* _tmp29;
		char* _tmp28;
		char* _tmp27;
		ValaCCodeIdentifier* _tmp31;
		ValaCCodeIdentifier* _tmp35;
		char* _tmp34;
		char* _tmp33;
		ValaCCodeMemberAccess* _tmp32;
		ValaCCodeAssignment* _tmp36;
		ValaCCodeAssignment* finalize_assignment;
		ValaCCodeExpressionStatement* _tmp37;
		/* set finalize function*/
		_tmp24 = NULL;
		fundamental_class = (_tmp24 = cl, (_tmp24 == NULL) ? NULL : vala_code_node_ref (_tmp24));
		while (vala_class_get_base_class (fundamental_class) != NULL) {
			ValaClass* _tmp26;
			ValaClass* _tmp25;
			_tmp26 = NULL;
			_tmp25 = NULL;
			fundamental_class = (_tmp26 = (_tmp25 = vala_class_get_base_class (fundamental_class), (_tmp25 == NULL) ? NULL : vala_code_node_ref (_tmp25)), (fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)), _tmp26);
		}
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp27 = NULL;
		ccall = (_tmp30 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new (_tmp28 = g_strdup_printf ("%s_CLASS", _tmp27 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) fundamental_class, NULL))))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp30);
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		_tmp28 = (g_free (_tmp28), NULL);
		_tmp27 = (g_free (_tmp27), NULL);
		_tmp31 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new ("klass")));
		(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
		_tmp35 = NULL;
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp36 = NULL;
		finalize_assignment = (_tmp36 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "finalize")), (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new (_tmp34 = g_strconcat (_tmp33 = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) cl), "finalize", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)), _tmp34 = (g_free (_tmp34), NULL), _tmp33 = (g_free (_tmp33), NULL), (_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)), _tmp36);
		_tmp37 = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) finalize_assignment)));
		(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
		(fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL));
		(finalize_assignment == NULL) ? NULL : (finalize_assignment = (vala_ccode_node_unref (finalize_assignment), NULL));
	}
	_tmp38 = FALSE;
	if (vala_class_get_has_private_fields (cl)) {
		_tmp38 = TRUE;
	} else {
		GeeList* _tmp39;
		_tmp39 = NULL;
		_tmp38 = gee_collection_get_size ((GeeCollection*) (_tmp39 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
		(_tmp39 == NULL) ? NULL : (_tmp39 = (gee_collection_object_unref (_tmp39), NULL));
	}
	/* add struct for private fields */
	if (_tmp38) {
		ValaCCodeFunctionCall* _tmp41;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeIdentifier* _tmp42;
		ValaCCodeConstant* _tmp45;
		char* _tmp44;
		char* _tmp43;
		ValaCCodeExpressionStatement* _tmp46;
		_tmp41 = NULL;
		_tmp40 = NULL;
		ccall = (_tmp41 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("g_type_class_add_private"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp41);
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		_tmp42 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("klass")));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		_tmp45 = NULL;
		_tmp44 = NULL;
		_tmp43 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new (_tmp44 = g_strdup_printf ("sizeof (%sPrivate)", _tmp43 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE)))));
		(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
		_tmp44 = (g_free (_tmp44), NULL);
		_tmp43 = (g_free (_tmp43), NULL);
		_tmp46 = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp46 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
	}
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		ValaCCodeFunctionCall* _tmp48;
		ValaCCodeIdentifier* _tmp47;
		ValaCCodeIdentifier* _tmp49;
		gboolean _tmp50;
		gboolean _tmp58;
		gboolean _tmp75;
		GeeList* _tmp76;
		gboolean _tmp77;
		/* set property handlers */
		_tmp48 = NULL;
		_tmp47 = NULL;
		ccall = (_tmp48 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp48);
		(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
		_tmp49 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new ("klass")));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
		_tmp50 = FALSE;
		if (vala_gobject_module_class_has_readable_properties (self, cl)) {
			_tmp50 = TRUE;
		} else {
			GeeList* _tmp51;
			_tmp51 = NULL;
			_tmp50 = gee_collection_get_size ((GeeCollection*) (_tmp51 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp51 == NULL) ? NULL : (_tmp51 = (gee_collection_object_unref (_tmp51), NULL));
		}
		if (_tmp50) {
			ValaCCodeExpressionStatement* _tmp57;
			ValaCCodeAssignment* _tmp56;
			ValaCCodeIdentifier* _tmp55;
			char* _tmp54;
			char* _tmp53;
			ValaCCodeMemberAccess* _tmp52;
			_tmp57 = NULL;
			_tmp56 = NULL;
			_tmp55 = NULL;
			_tmp54 = NULL;
			_tmp53 = NULL;
			_tmp52 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp57 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp56 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "get_property")), (ValaCCodeExpression*) (_tmp55 = vala_ccode_identifier_new (_tmp54 = g_strdup_printf ("%s_get_property", _tmp53 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
			(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
			(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
			_tmp54 = (g_free (_tmp54), NULL);
			_tmp53 = (g_free (_tmp53), NULL);
			(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
		}
		_tmp58 = FALSE;
		if (vala_gobject_module_class_has_writable_properties (self, cl)) {
			_tmp58 = TRUE;
		} else {
			GeeList* _tmp59;
			_tmp59 = NULL;
			_tmp58 = gee_collection_get_size ((GeeCollection*) (_tmp59 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp59 == NULL) ? NULL : (_tmp59 = (gee_collection_object_unref (_tmp59), NULL));
		}
		if (_tmp58) {
			ValaCCodeExpressionStatement* _tmp65;
			ValaCCodeAssignment* _tmp64;
			ValaCCodeIdentifier* _tmp63;
			char* _tmp62;
			char* _tmp61;
			ValaCCodeMemberAccess* _tmp60;
			_tmp65 = NULL;
			_tmp64 = NULL;
			_tmp63 = NULL;
			_tmp62 = NULL;
			_tmp61 = NULL;
			_tmp60 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp65 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp64 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp60 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccall, "set_property")), (ValaCCodeExpression*) (_tmp63 = vala_ccode_identifier_new (_tmp62 = g_strdup_printf ("%s_set_property", _tmp61 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
			(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
			(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
			_tmp62 = (g_free (_tmp62), NULL);
			_tmp61 = (g_free (_tmp61), NULL);
			(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
		}
		/* set constructor */
		if (vala_class_get_constructor (cl) != NULL) {
			ValaCCodeIdentifier* _tmp66;
			ValaCCodeFunctionCall* _tmp67;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp68;
			ValaCCodeExpressionStatement* _tmp74;
			ValaCCodeAssignment* _tmp73;
			ValaCCodeIdentifier* _tmp72;
			char* _tmp71;
			char* _tmp70;
			ValaCCodeMemberAccess* _tmp69;
			_tmp66 = NULL;
			_tmp67 = NULL;
			ccast = (_tmp67 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)), _tmp67);
			_tmp68 = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new ("klass")));
			(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
			_tmp74 = NULL;
			_tmp73 = NULL;
			_tmp72 = NULL;
			_tmp71 = NULL;
			_tmp70 = NULL;
			_tmp69 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp74 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp69 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "constructor")), (ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new (_tmp71 = g_strdup_printf ("%s_constructor", _tmp70 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
			(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
			_tmp71 = (g_free (_tmp71), NULL);
			_tmp70 = (g_free (_tmp70), NULL);
			(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
		_tmp75 = FALSE;
		_tmp76 = NULL;
		if ((_tmp77 = gee_collection_get_size ((GeeCollection*) (_tmp76 = vala_class_get_fields (cl))) > 0, (_tmp76 == NULL) ? NULL : (_tmp76 = (gee_collection_object_unref (_tmp76), NULL)), _tmp77)) {
			_tmp75 = TRUE;
		} else {
			_tmp75 = vala_class_get_destructor (cl) != NULL;
		}
		/* set finalize function */
		if (_tmp75) {
			ValaCCodeIdentifier* _tmp78;
			ValaCCodeFunctionCall* _tmp79;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp80;
			ValaCCodeExpressionStatement* _tmp86;
			ValaCCodeAssignment* _tmp85;
			ValaCCodeIdentifier* _tmp84;
			char* _tmp83;
			char* _tmp82;
			ValaCCodeMemberAccess* _tmp81;
			_tmp78 = NULL;
			_tmp79 = NULL;
			ccast = (_tmp79 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp78 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)), _tmp79);
			_tmp80 = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp80 = vala_ccode_identifier_new ("klass")));
			(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
			_tmp86 = NULL;
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			_tmp82 = NULL;
			_tmp81 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp86 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp85 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize")), (ValaCCodeExpression*) (_tmp84 = vala_ccode_identifier_new (_tmp83 = g_strdup_printf ("%s_finalize", _tmp82 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			_tmp83 = (g_free (_tmp83), NULL);
			_tmp82 = (g_free (_tmp82), NULL);
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
	}
	/* connect overridden methods */
	{
		GeeList* _tmp87;
		GeeIterator* _tmp88;
		GeeIterator* m_it;
		/* connect overridden methods */
		_tmp87 = NULL;
		_tmp88 = NULL;
		m_it = (_tmp88 = gee_iterable_iterator ((GeeIterable*) (_tmp87 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), (_tmp87 == NULL) ? NULL : (_tmp87 = (gee_collection_object_unref (_tmp87), NULL)), _tmp88);
		/* connect overridden methods */
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			ValaSymbol* _tmp89;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* _tmp92;
			char* _tmp91;
			char* _tmp90;
			ValaCCodeFunctionCall* _tmp93;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp94;
			ValaCCodeExpressionStatement* _tmp99;
			ValaCCodeAssignment* _tmp98;
			ValaCCodeIdentifier* _tmp97;
			char* _tmp96;
			ValaCCodeMemberAccess* _tmp95;
			/* connect overridden methods */
			m = (ValaMethod*) gee_iterator_get (m_it);
			if (vala_method_get_base_method (m) == NULL) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp89 = NULL;
			base_type = (_tmp89 = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_method (m)), (_tmp89 == NULL) ? NULL : vala_code_node_ref (_tmp89));
			_tmp92 = NULL;
			_tmp91 = NULL;
			_tmp90 = NULL;
			_tmp93 = NULL;
			ccast = (_tmp93 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new (_tmp91 = g_strdup_printf ("%s_CLASS", _tmp90 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) (VALA_CLASS (base_type)), NULL))))), (_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)), _tmp91 = (g_free (_tmp91), NULL), _tmp90 = (g_free (_tmp90), NULL), _tmp93);
			_tmp94 = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("klass")));
			(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
			_tmp99 = NULL;
			_tmp98 = NULL;
			_tmp97 = NULL;
			_tmp96 = NULL;
			_tmp95 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp99 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp98 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp95 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, vala_method_get_vfunc_name (vala_method_get_base_method (m)))), (ValaCCodeExpression*) (_tmp97 = vala_ccode_identifier_new (_tmp96 = vala_method_get_real_cname (m))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp99 == NULL) ? NULL : (_tmp99 = (vala_ccode_node_unref (_tmp99), NULL));
			(_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL));
			(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
			_tmp96 = (g_free (_tmp96), NULL);
			(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
		(m_it == NULL) ? NULL : (m_it = (gee_collection_object_unref (m_it), NULL));
	}
	/* connect overridden properties */
	{
		GeeList* _tmp100;
		GeeIterator* _tmp101;
		GeeIterator* prop_it;
		/* connect overridden properties */
		_tmp100 = NULL;
		_tmp101 = NULL;
		prop_it = (_tmp101 = gee_iterable_iterator ((GeeIterable*) (_tmp100 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp100 == NULL) ? NULL : (_tmp100 = (gee_collection_object_unref (_tmp100), NULL)), _tmp101);
		/* connect overridden properties */
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			ValaSymbol* _tmp102;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* _tmp105;
			char* _tmp104;
			char* _tmp103;
			ValaCCodeFunctionCall* _tmp106;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp107;
			/* connect overridden properties */
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (vala_property_get_base_property (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp102 = NULL;
			base_type = (_tmp102 = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop)), (_tmp102 == NULL) ? NULL : vala_code_node_ref (_tmp102));
			_tmp105 = NULL;
			_tmp104 = NULL;
			_tmp103 = NULL;
			_tmp106 = NULL;
			ccast = (_tmp106 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp105 = vala_ccode_identifier_new (_tmp104 = g_strdup_printf ("%s_CLASS", _tmp103 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) (VALA_CLASS (base_type)), NULL))))), (_tmp105 == NULL) ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)), _tmp104 = (g_free (_tmp104), NULL), _tmp103 = (g_free (_tmp103), NULL), _tmp106);
			_tmp107 = NULL;
			vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp107 = vala_ccode_identifier_new ("klass")));
			(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp108;
				char* _tmp109;
				char* cname;
				ValaCCodeExpressionStatement* _tmp114;
				ValaCCodeAssignment* _tmp113;
				ValaCCodeIdentifier* _tmp112;
				ValaCCodeMemberAccess* _tmp111;
				char* _tmp110;
				_tmp108 = NULL;
				_tmp109 = NULL;
				cname = (_tmp109 = g_strdup_printf ("%s_real_get_%s", _tmp108 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp108 = (g_free (_tmp108), NULL), _tmp109);
				_tmp114 = NULL;
				_tmp113 = NULL;
				_tmp112 = NULL;
				_tmp111 = NULL;
				_tmp110 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp114 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp113 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp111 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, _tmp110 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp112 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
				(_tmp113 == NULL) ? NULL : (_tmp113 = (vala_ccode_node_unref (_tmp113), NULL));
				(_tmp112 == NULL) ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL));
				(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL));
				_tmp110 = (g_free (_tmp110), NULL);
				cname = (g_free (cname), NULL);
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp115;
				char* _tmp116;
				char* cname;
				ValaCCodeExpressionStatement* _tmp121;
				ValaCCodeAssignment* _tmp120;
				ValaCCodeIdentifier* _tmp119;
				ValaCCodeMemberAccess* _tmp118;
				char* _tmp117;
				_tmp115 = NULL;
				_tmp116 = NULL;
				cname = (_tmp116 = g_strdup_printf ("%s_real_set_%s", _tmp115 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp115 = (g_free (_tmp115), NULL), _tmp116);
				_tmp121 = NULL;
				_tmp120 = NULL;
				_tmp119 = NULL;
				_tmp118 = NULL;
				_tmp117 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp121 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp120 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp118 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, _tmp117 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp119 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
				(_tmp120 == NULL) ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL));
				(_tmp119 == NULL) ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL));
				(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL));
				_tmp117 = (g_free (_tmp117), NULL);
				cname = (g_free (cname), NULL);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	/* initialize class fields */
	fields = vala_class_get_fields (cl);
	{
		GeeIterator* field_it;
		field_it = gee_iterable_iterator ((GeeIterable*) fields);
		while (gee_iterator_next (field_it)) {
			ValaField* field;
			gboolean _tmp122;
			char* _tmp124;
			ValaCCodeIdentifier* _tmp123;
			ValaCCodeExpression* _tmp125;
			ValaCCodeExpression* left;
			ValaCCodeExpression* _tmp126;
			ValaCCodeExpression* right;
			ValaCCodeAssignment* assign;
			ValaCCodeExpressionStatement* _tmp127;
			field = (ValaField*) gee_iterator_get (field_it);
			_tmp122 = FALSE;
			if (vala_field_get_binding (field) != MEMBER_BINDING_CLASS) {
				_tmp122 = TRUE;
			} else {
				_tmp122 = vala_field_get_initializer (field) == NULL;
			}
			if (_tmp122) {
				(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
				continue;
			}
			_tmp124 = NULL;
			_tmp123 = NULL;
			_tmp125 = NULL;
			left = (_tmp125 = (ValaCCodeExpression*) vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp123 = vala_ccode_identifier_new ("klass")), _tmp124 = vala_field_get_cname (field), TRUE), _tmp124 = (g_free (_tmp124), NULL), (_tmp123 == NULL) ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)), _tmp125);
			_tmp126 = NULL;
			right = (_tmp126 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_field_get_initializer (field))), (_tmp126 == NULL) ? NULL : vala_ccode_node_ref (_tmp126));
			assign = vala_ccode_assignment_new (left, right, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_tmp127 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp127 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign)));
			(_tmp127 == NULL) ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL));
			(field == NULL) ? NULL : (field = (vala_code_node_unref (field), NULL));
			(left == NULL) ? NULL : (left = (vala_ccode_node_unref (left), NULL));
			(right == NULL) ? NULL : (right = (vala_ccode_node_unref (right), NULL));
			(assign == NULL) ? NULL : (assign = (vala_ccode_node_unref (assign), NULL));
		}
		(field_it == NULL) ? NULL : (field_it = (gee_collection_object_unref (field_it), NULL));
	}
	if (vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type)) {
		GeeList* props;
		/* create type, dup_func, and destroy_func properties for generic types */
		{
			GeeList* _tmp128;
			GeeIterator* _tmp129;
			GeeIterator* type_param_it;
			/* create type, dup_func, and destroy_func properties for generic types */
			_tmp128 = NULL;
			_tmp129 = NULL;
			type_param_it = (_tmp129 = gee_iterable_iterator ((GeeIterable*) (_tmp128 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp128 == NULL) ? NULL : (_tmp128 = (gee_collection_object_unref (_tmp128), NULL)), _tmp129);
			/* create type, dup_func, and destroy_func properties for generic types */
			while (gee_iterator_next (type_param_it)) {
				ValaTypeParameter* type_param;
				char* func_name;
				char* enum_value;
				ValaCCodeConstant* func_name_constant;
				ValaCCodeFunctionCall* cinst;
				ValaCCodeFunctionCall* cspec;
				char* _tmp131;
				char* _tmp130;
				ValaCCodeConstant* _tmp134;
				char* _tmp133;
				char* _tmp132;
				char* _tmp137;
				char* _tmp136;
				char* _tmp135;
				ValaCCodeFunctionCall* _tmp139;
				ValaCCodeIdentifier* _tmp138;
				ValaCCodeConstant* _tmp140;
				ValaCCodeFunctionCall* _tmp142;
				ValaCCodeIdentifier* _tmp141;
				ValaCCodeConstant* _tmp143;
				ValaCCodeConstant* _tmp144;
				ValaCCodeIdentifier* _tmp145;
				ValaCCodeConstant* _tmp146;
				ValaCCodeExpressionStatement* _tmp147;
				ValaCCodeEnumValue* _tmp148;
				char* _tmp150;
				char* _tmp149;
				ValaCCodeConstant* _tmp153;
				char* _tmp152;
				char* _tmp151;
				char* _tmp156;
				char* _tmp155;
				char* _tmp154;
				ValaCCodeFunctionCall* _tmp158;
				ValaCCodeIdentifier* _tmp157;
				ValaCCodeConstant* _tmp159;
				ValaCCodeFunctionCall* _tmp161;
				ValaCCodeIdentifier* _tmp160;
				ValaCCodeConstant* _tmp162;
				ValaCCodeConstant* _tmp163;
				ValaCCodeConstant* _tmp164;
				ValaCCodeExpressionStatement* _tmp165;
				ValaCCodeEnumValue* _tmp166;
				char* _tmp168;
				char* _tmp167;
				ValaCCodeConstant* _tmp171;
				char* _tmp170;
				char* _tmp169;
				char* _tmp174;
				char* _tmp173;
				char* _tmp172;
				ValaCCodeFunctionCall* _tmp176;
				ValaCCodeIdentifier* _tmp175;
				ValaCCodeConstant* _tmp177;
				ValaCCodeFunctionCall* _tmp179;
				ValaCCodeIdentifier* _tmp178;
				ValaCCodeConstant* _tmp180;
				ValaCCodeConstant* _tmp181;
				ValaCCodeConstant* _tmp182;
				ValaCCodeExpressionStatement* _tmp183;
				ValaCCodeEnumValue* _tmp184;
				/* create type, dup_func, and destroy_func properties for generic types */
				type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
				func_name = NULL;
				enum_value = NULL;
				func_name_constant = NULL;
				cinst = NULL;
				cspec = NULL;
				_tmp131 = NULL;
				_tmp130 = NULL;
				func_name = (_tmp131 = g_strdup_printf ("%s_type", _tmp130 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp131);
				_tmp130 = (g_free (_tmp130), NULL);
				_tmp134 = NULL;
				_tmp133 = NULL;
				_tmp132 = NULL;
				func_name_constant = (_tmp134 = vala_ccode_constant_new (_tmp133 = g_strdup_printf ("\"%s-type\"", _tmp132 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp134);
				_tmp133 = (g_free (_tmp133), NULL);
				_tmp132 = (g_free (_tmp132), NULL);
				_tmp137 = NULL;
				_tmp136 = NULL;
				_tmp135 = NULL;
				enum_value = (_tmp137 = g_utf8_strup (_tmp136 = g_strdup_printf ("%s_%s", _tmp135 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp137);
				_tmp136 = (g_free (_tmp136), NULL);
				_tmp135 = (g_free (_tmp135), NULL);
				_tmp139 = NULL;
				_tmp138 = NULL;
				cinst = (_tmp139 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp138 = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp139);
				(_tmp138 == NULL) ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
				_tmp140 = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp140 = vala_ccode_constant_new (enum_value)));
				(_tmp140 == NULL) ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL));
				_tmp142 = NULL;
				_tmp141 = NULL;
				cspec = (_tmp142 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp141 = vala_ccode_identifier_new ("g_param_spec_gtype"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp142);
				(_tmp141 == NULL) ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL));
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
				_tmp143 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp143 = vala_ccode_constant_new ("\"type\"")));
				(_tmp143 == NULL) ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL));
				_tmp144 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp144 = vala_ccode_constant_new ("\"type\"")));
				(_tmp144 == NULL) ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL));
				_tmp145 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp145 = vala_ccode_identifier_new ("G_TYPE_NONE")));
				(_tmp145 == NULL) ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL));
				_tmp146 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp146 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
				(_tmp146 == NULL) ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
				_tmp147 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp147 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
				(_tmp147 == NULL) ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL));
				_tmp148 = NULL;
				vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp148 = vala_ccode_enum_value_new (enum_value, NULL));
				(_tmp148 == NULL) ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL));
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GType", func_name);
				_tmp150 = NULL;
				_tmp149 = NULL;
				func_name = (_tmp150 = g_strdup_printf ("%s_dup_func", _tmp149 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp150);
				_tmp149 = (g_free (_tmp149), NULL);
				_tmp153 = NULL;
				_tmp152 = NULL;
				_tmp151 = NULL;
				func_name_constant = (_tmp153 = vala_ccode_constant_new (_tmp152 = g_strdup_printf ("\"%s-dup-func\"", _tmp151 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp153);
				_tmp152 = (g_free (_tmp152), NULL);
				_tmp151 = (g_free (_tmp151), NULL);
				_tmp156 = NULL;
				_tmp155 = NULL;
				_tmp154 = NULL;
				enum_value = (_tmp156 = g_utf8_strup (_tmp155 = g_strdup_printf ("%s_%s", _tmp154 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp156);
				_tmp155 = (g_free (_tmp155), NULL);
				_tmp154 = (g_free (_tmp154), NULL);
				_tmp158 = NULL;
				_tmp157 = NULL;
				cinst = (_tmp158 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp157 = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp158);
				(_tmp157 == NULL) ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
				_tmp159 = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp159 = vala_ccode_constant_new (enum_value)));
				(_tmp159 == NULL) ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL));
				_tmp161 = NULL;
				_tmp160 = NULL;
				cspec = (_tmp161 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp160 = vala_ccode_identifier_new ("g_param_spec_pointer"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp161);
				(_tmp160 == NULL) ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL));
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
				_tmp162 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp162 = vala_ccode_constant_new ("\"dup func\"")));
				(_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL));
				_tmp163 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp163 = vala_ccode_constant_new ("\"dup func\"")));
				(_tmp163 == NULL) ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL));
				_tmp164 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp164 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
				(_tmp164 == NULL) ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
				_tmp165 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp165 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
				(_tmp165 == NULL) ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL));
				_tmp166 = NULL;
				vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp166 = vala_ccode_enum_value_new (enum_value, NULL));
				(_tmp166 == NULL) ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL));
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GBoxedCopyFunc", func_name);
				_tmp168 = NULL;
				_tmp167 = NULL;
				func_name = (_tmp168 = g_strdup_printf ("%s_destroy_func", _tmp167 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp168);
				_tmp167 = (g_free (_tmp167), NULL);
				_tmp171 = NULL;
				_tmp170 = NULL;
				_tmp169 = NULL;
				func_name_constant = (_tmp171 = vala_ccode_constant_new (_tmp170 = g_strdup_printf ("\"%s-destroy-func\"", _tmp169 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1))), (func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)), _tmp171);
				_tmp170 = (g_free (_tmp170), NULL);
				_tmp169 = (g_free (_tmp169), NULL);
				_tmp174 = NULL;
				_tmp173 = NULL;
				_tmp172 = NULL;
				enum_value = (_tmp174 = g_utf8_strup (_tmp173 = g_strdup_printf ("%s_%s", _tmp172 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp174);
				_tmp173 = (g_free (_tmp173), NULL);
				_tmp172 = (g_free (_tmp172), NULL);
				_tmp176 = NULL;
				_tmp175 = NULL;
				cinst = (_tmp176 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp175 = vala_ccode_identifier_new ("g_object_class_install_property"))), (cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)), _tmp176);
				(_tmp175 == NULL) ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
				_tmp177 = NULL;
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp177 = vala_ccode_constant_new (enum_value)));
				(_tmp177 == NULL) ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL));
				_tmp179 = NULL;
				_tmp178 = NULL;
				cspec = (_tmp179 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp178 = vala_ccode_identifier_new ("g_param_spec_pointer"))), (cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)), _tmp179);
				(_tmp178 == NULL) ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL));
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) func_name_constant);
				_tmp180 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp180 = vala_ccode_constant_new ("\"destroy func\"")));
				(_tmp180 == NULL) ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL));
				_tmp181 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp181 = vala_ccode_constant_new ("\"destroy func\"")));
				(_tmp181 == NULL) ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL));
				_tmp182 = NULL;
				vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp182 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY")));
				(_tmp182 == NULL) ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL));
				vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) cspec);
				_tmp183 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp183 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
				(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
				_tmp184 = NULL;
				vala_ccode_enum_add_value (((ValaCCodeBaseModule*) self)->prop_enum, _tmp184 = vala_ccode_enum_value_new (enum_value, NULL));
				(_tmp184 == NULL) ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL));
				vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GDestroyNotify", func_name);
				(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
				func_name = (g_free (func_name), NULL);
				enum_value = (g_free (enum_value), NULL);
				(func_name_constant == NULL) ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL));
				(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				(cspec == NULL) ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL));
			}
			(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
		}
		/* create properties */
		props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
		{
			GeeIterator* prop_it;
			prop_it = gee_iterable_iterator ((GeeIterable*) props);
			while (gee_iterator_next (prop_it)) {
				ValaProperty* prop;
				gboolean _tmp185;
				prop = (ValaProperty*) gee_iterator_get (prop_it);
				/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
				if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					continue;
				}
				if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					/* don't register private properties*/
					(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
					continue;
				}
				_tmp185 = FALSE;
				if (vala_property_get_overrides (prop)) {
					_tmp185 = TRUE;
				} else {
					_tmp185 = vala_property_get_base_interface_property (prop) != NULL;
				}
				if (_tmp185) {
					ValaCCodeIdentifier* _tmp186;
					ValaCCodeFunctionCall* _tmp187;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* _tmp189;
					char* _tmp188;
					ValaCCodeConstant* _tmp190;
					ValaCCodeExpressionStatement* _tmp191;
					_tmp186 = NULL;
					_tmp187 = NULL;
					cinst = (_tmp187 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp186 = vala_ccode_identifier_new ("g_object_class_override_property"))), (_tmp186 == NULL) ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)), _tmp187);
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
					_tmp189 = NULL;
					_tmp188 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp189 = vala_ccode_constant_new (_tmp188 = vala_property_get_upper_case_cname (prop))));
					(_tmp189 == NULL) ? NULL : (_tmp189 = (vala_ccode_node_unref (_tmp189), NULL));
					_tmp188 = (g_free (_tmp188), NULL);
					_tmp190 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp190 = vala_property_get_canonical_cconstant (prop)));
					(_tmp190 == NULL) ? NULL : (_tmp190 = (vala_ccode_node_unref (_tmp190), NULL));
					_tmp191 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp191 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
					(_tmp191 == NULL) ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL));
					(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				} else {
					ValaCCodeIdentifier* _tmp192;
					ValaCCodeFunctionCall* _tmp193;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeConstant* _tmp195;
					char* _tmp194;
					ValaCCodeFunctionCall* _tmp196;
					ValaCCodeExpressionStatement* _tmp197;
					_tmp192 = NULL;
					_tmp193 = NULL;
					cinst = (_tmp193 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp192 = vala_ccode_identifier_new ("g_object_class_install_property"))), (_tmp192 == NULL) ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL)), _tmp193);
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) ccall);
					_tmp195 = NULL;
					_tmp194 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp195 = vala_ccode_constant_new (_tmp194 = vala_property_get_upper_case_cname (prop))));
					(_tmp195 == NULL) ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL));
					_tmp194 = (g_free (_tmp194), NULL);
					_tmp196 = NULL;
					vala_ccode_function_call_add_argument (cinst, (ValaCCodeExpression*) (_tmp196 = vala_ccode_module_get_param_spec (vala_ccode_module_get_head ((ValaCCodeModule*) self), prop)));
					(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
					_tmp197 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp197 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cinst)));
					(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
					(cinst == NULL) ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL));
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			}
			(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
		}
		(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
	} else {
		if (!vala_class_get_is_compact (cl)) {
			/* create type, dup_func, and destroy_func fields for generic types */
			{
				GeeList* _tmp198;
				GeeIterator* _tmp199;
				GeeIterator* type_param_it;
				/* create type, dup_func, and destroy_func fields for generic types */
				_tmp198 = NULL;
				_tmp199 = NULL;
				type_param_it = (_tmp199 = gee_iterable_iterator ((GeeIterable*) (_tmp198 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp198 == NULL) ? NULL : (_tmp198 = (gee_collection_object_unref (_tmp198), NULL)), _tmp199);
				/* create type, dup_func, and destroy_func fields for generic types */
				while (gee_iterator_next (type_param_it)) {
					ValaTypeParameter* type_param;
					char* func_name;
					char* _tmp201;
					char* _tmp200;
					char* _tmp203;
					char* _tmp202;
					char* _tmp205;
					char* _tmp204;
					/* create type, dup_func, and destroy_func fields for generic types */
					type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
					func_name = NULL;
					_tmp201 = NULL;
					_tmp200 = NULL;
					func_name = (_tmp201 = g_strdup_printf ("%s_type", _tmp200 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp201);
					_tmp200 = (g_free (_tmp200), NULL);
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GType", func_name);
					_tmp203 = NULL;
					_tmp202 = NULL;
					func_name = (_tmp203 = g_strdup_printf ("%s_dup_func", _tmp202 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp203);
					_tmp202 = (g_free (_tmp202), NULL);
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GBoxedCopyFunc", func_name);
					_tmp205 = NULL;
					_tmp204 = NULL;
					func_name = (_tmp205 = g_strdup_printf ("%s_destroy_func", _tmp204 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp205);
					_tmp204 = (g_free (_tmp204), NULL);
					vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->instance_priv_struct, "GDestroyNotify", func_name);
					(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
					func_name = (g_free (func_name), NULL);
				}
				(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
			}
		}
	}
	if (!vala_class_get_is_compact (cl)) {
		/* create signals */
		{
			GeeList* _tmp206;
			GeeIterator* _tmp207;
			GeeIterator* sig_it;
			/* create signals */
			_tmp206 = NULL;
			_tmp207 = NULL;
			sig_it = (_tmp207 = gee_iterable_iterator ((GeeIterable*) (_tmp206 = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) cl))), (_tmp206 == NULL) ? NULL : (_tmp206 = (gee_collection_object_unref (_tmp206), NULL)), _tmp207);
			/* create signals */
			while (gee_iterator_next (sig_it)) {
				ValaSignal* sig;
				ValaCCodeExpressionStatement* _tmp209;
				ValaCCodeFunctionCall* _tmp208;
				/* create signals */
				sig = (ValaSignal*) gee_iterator_get (sig_it);
				_tmp209 = NULL;
				_tmp208 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp209 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp208 = vala_ccode_module_get_signal_creation (vala_ccode_module_get_head ((ValaCCodeModule*) self), sig, (ValaTypeSymbol*) cl)))));
				(_tmp209 == NULL) ? NULL : (_tmp209 = (vala_ccode_node_unref (_tmp209), NULL));
				(_tmp208 == NULL) ? NULL : (_tmp208 = (vala_ccode_node_unref (_tmp208), NULL));
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			}
			(sig_it == NULL) ? NULL : (sig_it = (gee_collection_object_unref (sig_it), NULL));
		}
	}
	_tmp210 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp210 = vala_ccode_module_register_dbus_info (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaObjectTypeSymbol*) cl)));
	(_tmp210 == NULL) ? NULL : (_tmp210 = (vala_ccode_node_unref (_tmp210), NULL));
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->class_init_fragment);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) class_init);
	(class_init == NULL) ? NULL : (class_init = (vala_ccode_node_unref (class_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(parent_decl == NULL) ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL));
	(parent_var_decl == NULL) ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL));
	(parent_assignment == NULL) ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL));
	(fields == NULL) ? NULL : (fields = (gee_collection_object_unref (fields), NULL));
}


static void vala_gobject_module_add_interface_init_function (ValaGObjectModule* self, ValaClass* cl, ValaInterface* iface) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	char* _tmp9;
	char* parent_iface_var;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (iface != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	iface_init = (_tmp3 = vala_ccode_function_new (_tmp2 = g_strdup_printf ("%s_%s_interface_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), _tmp1 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), "void"), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (iface_init, _tmp6 = vala_ccode_formal_parameter_new ("iface", _tmp5 = g_strdup_printf ("%s *", _tmp4 = vala_interface_get_type_cname (iface))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	parent_iface_var = (_tmp9 = g_strdup_printf ("%s_%s_parent_iface", _tmp7 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), _tmp8 = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp8 = (g_free (_tmp8), NULL), _tmp7 = (g_free (_tmp7), NULL), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	parent_decl = (_tmp12 = vala_ccode_declaration_new (_tmp11 = g_strconcat (_tmp10 = vala_interface_get_type_cname (iface), "*", NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp12);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	_tmp13 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, (ValaCCodeExpression*) (_tmp13 = vala_ccode_constant_new ("NULL")));
	(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
	vala_ccode_declaration_add_declarator (parent_decl, (ValaCCodeDeclarator*) parent_var_decl);
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) parent_decl);
	_tmp15 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("g_type_interface_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp15);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("iface")));
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
	_tmp17 = NULL;
	_tmp18 = NULL;
	parent_assignment = (_tmp18 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_identifier_new (parent_iface_var)), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)), _tmp18);
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) parent_assignment)));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	{
		GeeList* _tmp20;
		GeeIterator* _tmp21;
		GeeIterator* m_it;
		_tmp20 = NULL;
		_tmp21 = NULL;
		m_it = (_tmp21 = gee_iterable_iterator ((GeeIterable*) (_tmp20 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl))), (_tmp20 == NULL) ? NULL : (_tmp20 = (gee_collection_object_unref (_tmp20), NULL)), _tmp21);
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			ValaSymbol* _tmp22;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* ciface;
			char* cname;
			gboolean _tmp23;
			ValaCCodeExpressionStatement* _tmp28;
			ValaCCodeAssignment* _tmp27;
			ValaCCodeIdentifier* _tmp26;
			ValaCCodeMemberAccess* _tmp25;
			m = (ValaMethod*) gee_iterator_get (m_it);
			if (vala_method_get_base_interface_method (m) == NULL) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				continue;
			}
			_tmp22 = NULL;
			base_type = (_tmp22 = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_get_base_interface_method (m)), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
			if (base_type != VALA_SYMBOL (iface)) {
				(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			ciface = vala_ccode_identifier_new ("iface");
			cname = vala_method_get_real_cname (m);
			_tmp23 = FALSE;
			if (vala_method_get_is_abstract (m)) {
				_tmp23 = TRUE;
			} else {
				_tmp23 = vala_method_get_is_virtual (m);
			}
			if (_tmp23) {
				char* _tmp24;
				/* FIXME results in C compiler warning*/
				_tmp24 = NULL;
				cname = (_tmp24 = vala_method_get_cname (m), cname = (g_free (cname), NULL), _tmp24);
			}
			_tmp28 = NULL;
			_tmp27 = NULL;
			_tmp26 = NULL;
			_tmp25 = NULL;
			vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp28 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (vala_method_get_base_interface_method (m)))), (ValaCCodeExpression*) (_tmp26 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
			(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
			(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
			cname = (g_free (cname), NULL);
		}
		(m_it == NULL) ? NULL : (m_it = (gee_collection_object_unref (m_it), NULL));
	}
	/* connect inherited implementations*/
	{
		GeeList* _tmp29;
		GeeIterator* _tmp30;
		GeeIterator* m_it;
		/* connect inherited implementations*/
		_tmp29 = NULL;
		_tmp30 = NULL;
		m_it = (_tmp30 = gee_iterable_iterator ((GeeIterable*) (_tmp29 = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp29 == NULL) ? NULL : (_tmp29 = (gee_collection_object_unref (_tmp29), NULL)), _tmp30);
		/* connect inherited implementations*/
		while (gee_iterator_next (m_it)) {
			ValaMethod* m;
			/* connect inherited implementations*/
			m = (ValaMethod*) gee_iterator_get (m_it);
			if (vala_method_get_is_abstract (m)) {
				ValaMethod* cl_method;
				ValaClass* _tmp31;
				ValaClass* base_class;
				gboolean _tmp37;
				cl_method = NULL;
				_tmp31 = NULL;
				base_class = (_tmp31 = cl, (_tmp31 == NULL) ? NULL : vala_code_node_ref (_tmp31));
				while (TRUE) {
					gboolean _tmp32;
					ValaMethod* _tmp34;
					ValaSymbol* _tmp33;
					ValaClass* _tmp36;
					ValaClass* _tmp35;
					_tmp32 = FALSE;
					if (base_class != NULL) {
						_tmp32 = cl_method == NULL;
					} else {
						_tmp32 = FALSE;
					}
					if (!_tmp32) {
						break;
					}
					_tmp34 = NULL;
					_tmp33 = NULL;
					cl_method = (_tmp34 = (_tmp33 = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) m)), VALA_IS_METHOD (_tmp33) ? ((ValaMethod*) _tmp33) : NULL), (cl_method == NULL) ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL)), _tmp34);
					_tmp36 = NULL;
					_tmp35 = NULL;
					base_class = (_tmp36 = (_tmp35 = vala_class_get_base_class (base_class), (_tmp35 == NULL) ? NULL : vala_code_node_ref (_tmp35)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp36);
				}
				_tmp37 = FALSE;
				if (base_class != NULL) {
					_tmp37 = vala_symbol_get_parent_symbol ((ValaSymbol*) cl_method) != VALA_SYMBOL (cl);
				} else {
					_tmp37 = FALSE;
				}
				if (_tmp37) {
					ValaMethod* _tmp38;
					ValaMethod* base_method;
					ValaCCodeIdentifier* ciface;
					ValaCCodeExpressionStatement* _tmp47;
					ValaCCodeAssignment* _tmp46;
					ValaCCodeIdentifier* _tmp45;
					char* _tmp44;
					ValaCCodeMemberAccess* _tmp43;
					/* method inherited from base class*/
					_tmp38 = NULL;
					base_method = (_tmp38 = cl_method, (_tmp38 == NULL) ? NULL : vala_code_node_ref (_tmp38));
					if (vala_method_get_base_method (cl_method) != NULL) {
						ValaMethod* _tmp40;
						ValaMethod* _tmp39;
						_tmp40 = NULL;
						_tmp39 = NULL;
						base_method = (_tmp40 = (_tmp39 = vala_method_get_base_method (cl_method), (_tmp39 == NULL) ? NULL : vala_code_node_ref (_tmp39)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp40);
					} else {
						if (vala_method_get_base_interface_method (cl_method) != NULL) {
							ValaMethod* _tmp42;
							ValaMethod* _tmp41;
							_tmp42 = NULL;
							_tmp41 = NULL;
							base_method = (_tmp42 = (_tmp41 = vala_method_get_base_interface_method (cl_method), (_tmp41 == NULL) ? NULL : vala_code_node_ref (_tmp41)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp42);
						}
					}
					ciface = vala_ccode_identifier_new ("iface");
					_tmp47 = NULL;
					_tmp46 = NULL;
					_tmp45 = NULL;
					_tmp44 = NULL;
					_tmp43 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp47 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp43 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, vala_method_get_vfunc_name (m))), (ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new (_tmp44 = vala_method_get_cname (base_method))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
					(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
					(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
					_tmp44 = (g_free (_tmp44), NULL);
					(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
				}
				(cl_method == NULL) ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL));
				(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
			}
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(m_it == NULL) ? NULL : (m_it = (gee_collection_object_unref (m_it), NULL));
	}
	{
		GeeList* _tmp48;
		GeeIterator* _tmp49;
		GeeIterator* prop_it;
		_tmp48 = NULL;
		_tmp49 = NULL;
		prop_it = (_tmp49 = gee_iterable_iterator ((GeeIterable*) (_tmp48 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp48 == NULL) ? NULL : (_tmp48 = (gee_collection_object_unref (_tmp48), NULL)), _tmp49);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			ValaSymbol* _tmp50;
			ValaSymbol* base_type;
			ValaCCodeIdentifier* ciface;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (vala_property_get_base_interface_property (prop) == NULL) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			_tmp50 = NULL;
			base_type = (_tmp50 = vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop)), (_tmp50 == NULL) ? NULL : vala_code_node_ref (_tmp50));
			if (base_type != VALA_SYMBOL (iface)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			ciface = vala_ccode_identifier_new ("iface");
			if (vala_property_get_get_accessor (prop) != NULL) {
				char* _tmp51;
				char* _tmp52;
				char* cname;
				gboolean _tmp53;
				ValaCCodeExpressionStatement* _tmp60;
				ValaCCodeAssignment* _tmp59;
				ValaCCodeIdentifier* _tmp58;
				ValaCCodeMemberAccess* _tmp57;
				char* _tmp56;
				_tmp51 = NULL;
				_tmp52 = NULL;
				cname = (_tmp52 = g_strdup_printf ("%s_real_get_%s", _tmp51 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp51 = (g_free (_tmp51), NULL), _tmp52);
				_tmp53 = FALSE;
				if (vala_property_get_is_abstract (prop)) {
					_tmp53 = TRUE;
				} else {
					_tmp53 = vala_property_get_is_virtual (prop);
				}
				if (_tmp53) {
					char* _tmp55;
					char* _tmp54;
					_tmp55 = NULL;
					_tmp54 = NULL;
					cname = (_tmp55 = g_strdup_printf ("%s_get_%s", _tmp54 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp55);
					_tmp54 = (g_free (_tmp54), NULL);
				}
				_tmp60 = NULL;
				_tmp59 = NULL;
				_tmp58 = NULL;
				_tmp57 = NULL;
				_tmp56 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp60 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp59 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp56 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp58 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
				(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
				(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
				(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
				_tmp56 = (g_free (_tmp56), NULL);
				cname = (g_free (cname), NULL);
			}
			if (vala_property_get_set_accessor (prop) != NULL) {
				char* _tmp61;
				char* _tmp62;
				char* cname;
				gboolean _tmp63;
				ValaCCodeExpressionStatement* _tmp70;
				ValaCCodeAssignment* _tmp69;
				ValaCCodeIdentifier* _tmp68;
				ValaCCodeMemberAccess* _tmp67;
				char* _tmp66;
				_tmp61 = NULL;
				_tmp62 = NULL;
				cname = (_tmp62 = g_strdup_printf ("%s_real_set_%s", _tmp61 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), _tmp61 = (g_free (_tmp61), NULL), _tmp62);
				_tmp63 = FALSE;
				if (vala_property_get_is_abstract (prop)) {
					_tmp63 = TRUE;
				} else {
					_tmp63 = vala_property_get_is_virtual (prop);
				}
				if (_tmp63) {
					char* _tmp65;
					char* _tmp64;
					_tmp65 = NULL;
					_tmp64 = NULL;
					cname = (_tmp65 = g_strdup_printf ("%s_set_%s", _tmp64 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) prop)), cname = (g_free (cname), NULL), _tmp65);
					_tmp64 = (g_free (_tmp64), NULL);
				}
				_tmp70 = NULL;
				_tmp69 = NULL;
				_tmp68 = NULL;
				_tmp67 = NULL;
				_tmp66 = NULL;
				vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp70 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp69 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp67 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp66 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp68 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
				(_tmp69 == NULL) ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL));
				(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
				(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
				_tmp66 = (g_free (_tmp66), NULL);
				cname = (g_free (cname), NULL);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	{
		GeeList* _tmp71;
		GeeIterator* _tmp72;
		GeeIterator* prop_it;
		_tmp71 = NULL;
		_tmp72 = NULL;
		prop_it = (_tmp72 = gee_iterable_iterator ((GeeIterable*) (_tmp71 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp71 == NULL) ? NULL : (_tmp71 = (gee_collection_object_unref (_tmp71), NULL)), _tmp72);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			ValaProperty* cl_prop;
			ValaClass* _tmp73;
			ValaClass* base_class;
			gboolean _tmp79;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (!vala_property_get_is_abstract (prop)) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			cl_prop = NULL;
			_tmp73 = NULL;
			base_class = (_tmp73 = cl, (_tmp73 == NULL) ? NULL : vala_code_node_ref (_tmp73));
			while (TRUE) {
				gboolean _tmp74;
				ValaProperty* _tmp76;
				ValaSymbol* _tmp75;
				ValaClass* _tmp78;
				ValaClass* _tmp77;
				_tmp74 = FALSE;
				if (base_class != NULL) {
					_tmp74 = cl_prop == NULL;
				} else {
					_tmp74 = FALSE;
				}
				if (!_tmp74) {
					break;
				}
				_tmp76 = NULL;
				_tmp75 = NULL;
				cl_prop = (_tmp76 = (_tmp75 = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) prop)), VALA_IS_PROPERTY (_tmp75) ? ((ValaProperty*) _tmp75) : NULL), (cl_prop == NULL) ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL)), _tmp76);
				_tmp78 = NULL;
				_tmp77 = NULL;
				base_class = (_tmp78 = (_tmp77 = vala_class_get_base_class (base_class), (_tmp77 == NULL) ? NULL : vala_code_node_ref (_tmp77)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp78);
			}
			_tmp79 = FALSE;
			if (base_class != NULL) {
				_tmp79 = vala_symbol_get_parent_symbol ((ValaSymbol*) cl_prop) != VALA_SYMBOL (cl);
			} else {
				_tmp79 = FALSE;
			}
			if (_tmp79) {
				ValaProperty* _tmp80;
				ValaProperty* base_property;
				ValaCCodeIdentifier* ciface;
				/* property inherited from base class*/
				_tmp80 = NULL;
				base_property = (_tmp80 = cl_prop, (_tmp80 == NULL) ? NULL : vala_code_node_ref (_tmp80));
				if (vala_property_get_base_property (cl_prop) != NULL) {
					ValaProperty* _tmp82;
					ValaProperty* _tmp81;
					_tmp82 = NULL;
					_tmp81 = NULL;
					base_property = (_tmp82 = (_tmp81 = vala_property_get_base_property (cl_prop), (_tmp81 == NULL) ? NULL : vala_code_node_ref (_tmp81)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp82);
				} else {
					if (vala_property_get_base_interface_property (cl_prop) != NULL) {
						ValaProperty* _tmp84;
						ValaProperty* _tmp83;
						_tmp84 = NULL;
						_tmp83 = NULL;
						base_property = (_tmp84 = (_tmp83 = vala_property_get_base_interface_property (cl_prop), (_tmp83 == NULL) ? NULL : vala_code_node_ref (_tmp83)), (base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)), _tmp84);
					}
				}
				ciface = vala_ccode_identifier_new ("iface");
				if (vala_property_get_get_accessor (base_property) != NULL) {
					char* cname;
					ValaCCodeExpressionStatement* _tmp89;
					ValaCCodeAssignment* _tmp88;
					ValaCCodeIdentifier* _tmp87;
					ValaCCodeMemberAccess* _tmp86;
					char* _tmp85;
					cname = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property));
					_tmp89 = NULL;
					_tmp88 = NULL;
					_tmp87 = NULL;
					_tmp86 = NULL;
					_tmp85 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp89 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp88 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp86 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp85 = g_strdup_printf ("get_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp87 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
					(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
					(_tmp87 == NULL) ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL));
					(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
					_tmp85 = (g_free (_tmp85), NULL);
					cname = (g_free (cname), NULL);
				}
				if (vala_property_get_set_accessor (base_property) != NULL) {
					char* cname;
					ValaCCodeExpressionStatement* _tmp94;
					ValaCCodeAssignment* _tmp93;
					ValaCCodeIdentifier* _tmp92;
					ValaCCodeMemberAccess* _tmp91;
					char* _tmp90;
					cname = vala_property_accessor_get_cname (vala_property_get_set_accessor (base_property));
					_tmp94 = NULL;
					_tmp93 = NULL;
					_tmp92 = NULL;
					_tmp91 = NULL;
					_tmp90 = NULL;
					vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp94 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp93 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ciface, _tmp90 = g_strdup_printf ("set_%s", vala_symbol_get_name ((ValaSymbol*) prop)))), (ValaCCodeExpression*) (_tmp92 = vala_ccode_identifier_new (cname)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
					(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
					(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
					(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
					(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
					_tmp90 = (g_free (_tmp90), NULL);
					cname = (g_free (cname), NULL);
				}
				(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
				(ciface == NULL) ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL));
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			(cl_prop == NULL) ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL));
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) iface_init);
	(iface_init == NULL) ? NULL : (iface_init = (vala_ccode_node_unref (iface_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	parent_iface_var = (g_free (parent_iface_var), NULL);
	(parent_decl == NULL) ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL));
	(parent_var_decl == NULL) ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL));
	(parent_assignment == NULL) ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL));
}


static void vala_gobject_module_add_instance_init_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	gboolean _tmp7;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	instance_init = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_instance_init", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (instance_init, _tmp5 = vala_ccode_formal_parameter_new ("self", _tmp4 = g_strdup_printf ("%s *", _tmp3 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	if (vala_class_get_is_compact (cl)) {
		ValaCCodeFunction* _tmp6;
		/* Add declaration, since the instance_init function is explicitly called
		 by the creation methods*/
		_tmp6 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (instance_init)));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp7 = FALSE;
	if (!vala_class_get_is_compact (cl)) {
		gboolean _tmp8;
		_tmp8 = FALSE;
		if (vala_class_get_has_private_fields (cl)) {
			_tmp8 = TRUE;
		} else {
			GeeList* _tmp9;
			_tmp9 = NULL;
			_tmp8 = gee_collection_get_size ((GeeCollection*) (_tmp9 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))) > 0;
			(_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL));
		}
		_tmp7 = (_tmp8);
	} else {
		_tmp7 = FALSE;
	}
	if (_tmp7) {
		ValaCCodeIdentifier* _tmp12;
		char* _tmp11;
		char* _tmp10;
		ValaCCodeFunctionCall* _tmp13;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp14;
		ValaCCodeExpressionStatement* _tmp18;
		ValaCCodeAssignment* _tmp17;
		ValaCCodeMemberAccess* _tmp16;
		ValaCCodeIdentifier* _tmp15;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp13 = NULL;
		ccall = (_tmp13 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_identifier_new (_tmp11 = g_strdup_printf ("%s_GET_PRIVATE", _tmp10 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)), _tmp11 = (g_free (_tmp11), NULL), _tmp10 = (g_free (_tmp10), NULL), _tmp13);
		_tmp14 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp14 = vala_ccode_identifier_new ("self")));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) (_tmp18 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("self")), "priv")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	vala_ccode_block_add_statement (init_block, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_init_fragment);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) instance_init);
	(instance_init == NULL) ? NULL : (instance_init = (vala_ccode_node_unref (instance_init), NULL));
	(init_block == NULL) ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL));
}


static void vala_gobject_module_add_finalize_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaClass* _tmp3;
	ValaClass* fundamental_class;
	ValaCCodeFormalParameter* _tmp8;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeFunction* _tmp9;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* ccall;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeDeclaration* _tmp14;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_finalize", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	fundamental_class = (_tmp3 = cl, (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	while (vala_class_get_base_class (fundamental_class) != NULL) {
		ValaClass* _tmp5;
		ValaClass* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		fundamental_class = (_tmp5 = (_tmp4 = vala_class_get_base_class (fundamental_class), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)), _tmp5);
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, _tmp8 = vala_ccode_formal_parameter_new ("obj", _tmp7 = g_strconcat (_tmp6 = vala_typesymbol_get_cname ((ValaTypeSymbol*) fundamental_class, FALSE), "*", NULL)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp9 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp9 = vala_ccode_function_copy (function)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	cblock = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	ccall = (_tmp11 = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new ("obj")), (ValaTypeSymbol*) cl), (_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	cdecl_ = (_tmp14 = vala_ccode_declaration_new (_tmp13 = g_strdup_printf ("%s *", _tmp12 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp13 = (g_free (_tmp13), NULL), _tmp12 = (g_free (_tmp12), NULL), _tmp14);
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) ccall)));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_class_get_destructor (cl)));
	}
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->instance_finalize_fragment);
	/* chain up to finalize function of the base class*/
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCCodeIdentifier* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaCCodeFunctionCall* _tmp19;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		char* _tmp20;
		ValaCCodeFunctionCall* _tmp24;
		ValaCCodeMemberAccess* _tmp23;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeExpressionStatement* _tmp26;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp19 = NULL;
		ccast = (_tmp19 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (_tmp17 = g_strdup_printf ("%s_CLASS", _tmp16 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) fundamental_class, NULL))))), (_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)), _tmp17 = (g_free (_tmp17), NULL), _tmp16 = (g_free (_tmp16), NULL), _tmp19);
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (_tmp21 = g_strdup_printf ("%s_parent_class", _tmp20 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)))));
		(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
		_tmp21 = (g_free (_tmp21), NULL);
		_tmp20 = (g_free (_tmp20), NULL);
		_tmp24 = NULL;
		_tmp23 = NULL;
		ccall = (_tmp24 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) ccast, "finalize"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp24);
		(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("obj")));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
		_tmp26 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	}
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(function == NULL) ? NULL : (function = (vala_ccode_node_unref (function), NULL));
	(fundamental_class == NULL) ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
}


static gboolean vala_gobject_module_class_has_readable_properties (ValaGObjectModule* self, ValaClass* cl) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* prop_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		prop_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (vala_property_get_get_accessor (prop) != NULL) {
				gboolean _tmp2;
				return (_tmp2 = TRUE, (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), (prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL)), _tmp2);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	return FALSE;
}


static gboolean vala_gobject_module_class_has_writable_properties (ValaGObjectModule* self, ValaClass* cl) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* prop_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		prop_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			if (vala_property_get_set_accessor (prop) != NULL) {
				gboolean _tmp2;
				return (_tmp2 = TRUE, (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), (prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL)), _tmp2);
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	return FALSE;
}


static void vala_gobject_module_add_get_property_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeLabel* _tmp37;
	ValaCCodeStatement* _tmp38;
	ValaCCodeBreakStatement* _tmp39;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	get_prop = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_get_property", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp5 = vala_ccode_formal_parameter_new ("value", "GValue *"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (get_prop, _tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("object")), (ValaTypeSymbol*) cl), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new (_tmp10 = g_strdup_printf ("%s *", _tmp9 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) ccall)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("property_id"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	{
		GeeIterator* prop_it;
		prop_it = gee_iterable_iterator ((GeeIterable*) props);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			gboolean _tmp15;
			gboolean _tmp16;
			char* prefix;
			ValaCCodeExpression* cself;
			ValaCCodeCaseStatement* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			char* _tmp27;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* csetcall;
			ValaCCodeIdentifier* _tmp33;
			ValaCCodeIdentifier* _tmp34;
			ValaCCodeExpressionStatement* _tmp35;
			ValaCCodeBreakStatement* _tmp36;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			_tmp15 = FALSE;
			_tmp16 = FALSE;
			if (vala_property_get_get_accessor (prop) == NULL) {
				_tmp16 = TRUE;
			} else {
				_tmp16 = vala_property_get_is_abstract (prop);
			}
			if (_tmp16) {
				_tmp15 = TRUE;
			} else {
				_tmp15 = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
			}
			/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
			if (_tmp15) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				/* don't register private properties*/
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prefix = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			cself = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			if (vala_property_get_base_property (prop) != NULL) {
				ValaClass* _tmp17;
				ValaClass* base_type;
				char* _tmp18;
				ValaCCodeExpression* _tmp21;
				ValaObjectType* _tmp20;
				ValaObjectType* _tmp19;
				_tmp17 = NULL;
				base_type = (_tmp17 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
				_tmp18 = NULL;
				prefix = (_tmp18 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp18);
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				cself = (_tmp21 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp19 = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp20 = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp21);
				(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
				(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_code_node_unref (_tmp19), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_property_get_base_interface_property (prop) != NULL) {
					ValaInterface* _tmp22;
					ValaInterface* base_type;
					char* _tmp23;
					ValaCCodeExpression* _tmp26;
					ValaObjectType* _tmp25;
					ValaObjectType* _tmp24;
					_tmp22 = NULL;
					base_type = (_tmp22 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
					_tmp23 = NULL;
					prefix = (_tmp23 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp23);
					_tmp26 = NULL;
					_tmp25 = NULL;
					_tmp24 = NULL;
					cself = (_tmp26 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp24 = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp25 = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp26);
					(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_code_node_unref (_tmp25), NULL));
					(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
			}
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp29 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new (_tmp27 = vala_property_get_upper_case_cname (prop))))));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			_tmp27 = (g_free (_tmp27), NULL);
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp32 = NULL;
			ccall = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (_tmp30 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp30 = (g_free (_tmp30), NULL), _tmp32);
			vala_ccode_function_call_add_argument (ccall, cself);
			csetcall = vala_ccode_function_call_new (NULL);
			_tmp33 = NULL;
			vala_ccode_function_call_set_call (csetcall, (ValaCCodeExpression*) (_tmp33 = vala_ccode_module_get_value_setter_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_property_get_property_type (prop))));
			(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
			_tmp34 = NULL;
			vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new ("value")));
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
			vala_ccode_function_call_add_argument (csetcall, (ValaCCodeExpression*) ccall);
			_tmp35 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp35 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) csetcall)));
			(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			_tmp36 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp36 = vala_ccode_break_statement_new ()));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			prefix = (g_free (prefix), NULL);
			(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(csetcall == NULL) ? NULL : (csetcall = (vala_ccode_node_unref (csetcall), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	_tmp37 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp37 = vala_ccode_label_new ("default")));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	_tmp38 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp38 = vala_gobject_module_get_invalid_property_id_warn_statement (self)));
	(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	_tmp39 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp39 = vala_ccode_break_statement_new ()));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cswitch);
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) get_prop);
	(get_prop == NULL) ? NULL : (get_prop = (vala_ccode_node_unref (get_prop), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
	(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
}


static void vala_gobject_module_add_set_property_function (ValaGObjectModule* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeLabel* _tmp39;
	ValaCCodeStatement* _tmp40;
	ValaCCodeBreakStatement* _tmp41;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	set_prop = (_tmp2 = vala_ccode_function_new (_tmp1 = g_strdup_printf ("%s_set_property", _tmp0 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *"));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp5 = vala_ccode_formal_parameter_new ("value", "const GValue *"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (set_prop, _tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new ((ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("object")), (ValaTypeSymbol*) cl), (_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new (_tmp10 = g_strdup_printf ("%s *", _tmp9 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), _tmp10 = (g_free (_tmp10), NULL), _tmp9 = (g_free (_tmp9), NULL), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) ccall)));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new ((ValaCCodeExpression*) (_tmp13 = vala_ccode_identifier_new ("property_id"))), (_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)), _tmp14);
	props = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) cl);
	{
		GeeIterator* prop_it;
		prop_it = gee_iterable_iterator ((GeeIterable*) props);
		while (gee_iterator_next (prop_it)) {
			ValaProperty* prop;
			gboolean _tmp15;
			gboolean _tmp16;
			char* prefix;
			ValaCCodeExpression* cself;
			ValaCCodeCaseStatement* _tmp29;
			ValaCCodeIdentifier* _tmp28;
			char* _tmp27;
			ValaCCodeIdentifier* _tmp31;
			char* _tmp30;
			ValaCCodeFunctionCall* _tmp32;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeFunctionCall* cgetcall;
			ValaCCodeIdentifier* _tmp36;
			ValaCCodeExpressionStatement* _tmp37;
			ValaCCodeBreakStatement* _tmp38;
			prop = (ValaProperty*) gee_iterator_get (prop_it);
			_tmp15 = FALSE;
			_tmp16 = FALSE;
			if (vala_property_get_set_accessor (prop) == NULL) {
				_tmp16 = TRUE;
			} else {
				_tmp16 = vala_property_get_is_abstract (prop);
			}
			if (_tmp16) {
				_tmp15 = TRUE;
			} else {
				_tmp15 = vala_data_type_is_real_struct_type (vala_property_get_property_type (prop));
			}
			/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
			if (_tmp15) {
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			if (vala_symbol_get_access ((ValaSymbol*) prop) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				/* don't register private properties*/
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				continue;
			}
			prefix = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL);
			cself = (ValaCCodeExpression*) vala_ccode_identifier_new ("self");
			if (vala_property_get_base_property (prop) != NULL) {
				ValaClass* _tmp17;
				ValaClass* base_type;
				char* _tmp18;
				ValaCCodeExpression* _tmp21;
				ValaObjectType* _tmp20;
				ValaObjectType* _tmp19;
				_tmp17 = NULL;
				base_type = (_tmp17 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_property (prop))), (_tmp17 == NULL) ? NULL : vala_code_node_ref (_tmp17));
				_tmp18 = NULL;
				prefix = (_tmp18 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp18);
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				cself = (_tmp21 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp19 = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp20 = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp21);
				(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
				(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_code_node_unref (_tmp19), NULL));
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			} else {
				if (vala_property_get_base_interface_property (prop) != NULL) {
					ValaInterface* _tmp22;
					ValaInterface* base_type;
					char* _tmp23;
					ValaCCodeExpression* _tmp26;
					ValaObjectType* _tmp25;
					ValaObjectType* _tmp24;
					_tmp22 = NULL;
					base_type = (_tmp22 = VALA_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_property_get_base_interface_property (prop))), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
					_tmp23 = NULL;
					prefix = (_tmp23 = vala_symbol_get_lower_case_cname ((ValaSymbol*) base_type, NULL), prefix = (g_free (prefix), NULL), _tmp23);
					_tmp26 = NULL;
					_tmp25 = NULL;
					_tmp24 = NULL;
					cself = (_tmp26 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, cself, (ValaDataType*) (_tmp24 = vala_object_type_new ((ValaObjectTypeSymbol*) cl)), (ValaDataType*) (_tmp25 = vala_object_type_new ((ValaObjectTypeSymbol*) base_type)), NULL), (cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)), _tmp26);
					(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_code_node_unref (_tmp25), NULL));
					(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL));
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
			}
			_tmp29 = NULL;
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp29 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new (_tmp27 = vala_property_get_upper_case_cname (prop))))));
			(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
			(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
			_tmp27 = (g_free (_tmp27), NULL);
			_tmp31 = NULL;
			_tmp30 = NULL;
			_tmp32 = NULL;
			ccall = (_tmp32 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_identifier_new (_tmp30 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name ((ValaSymbol*) prop))))), (_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)), _tmp30 = (g_free (_tmp30), NULL), _tmp32);
			vala_ccode_function_call_add_argument (ccall, cself);
			cgetcall = vala_ccode_function_call_new (NULL);
			if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) != NULL) {
				ValaCCodeIdentifier* _tmp34;
				char* _tmp33;
				_tmp34 = NULL;
				_tmp33 = NULL;
				vala_ccode_function_call_set_call (cgetcall, (ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
				(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
				_tmp33 = (g_free (_tmp33), NULL);
			} else {
				ValaCCodeIdentifier* _tmp35;
				_tmp35 = NULL;
				vala_ccode_function_call_set_call (cgetcall, (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("g_value_get_pointer")));
				(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
			}
			_tmp36 = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("value")));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) cgetcall);
			_tmp37 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
			_tmp38 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp38 = vala_ccode_break_statement_new ()));
			(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			prefix = (g_free (prefix), NULL);
			(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			(cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL));
		}
		(prop_it == NULL) ? NULL : (prop_it = (gee_collection_object_unref (prop_it), NULL));
	}
	_tmp39 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp39 = vala_ccode_label_new ("default")));
	(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
	_tmp40 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp40 = vala_gobject_module_get_invalid_property_id_warn_statement (self)));
	(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
	_tmp41 = NULL;
	vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp41 = vala_ccode_break_statement_new ()));
	(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cswitch);
	/* type, dup func, and destroy func properties for generic types */
	{
		GeeList* _tmp42;
		GeeIterator* _tmp43;
		GeeIterator* type_param_it;
		/* type, dup func, and destroy func properties for generic types */
		_tmp42 = NULL;
		_tmp43 = NULL;
		type_param_it = (_tmp43 = gee_iterable_iterator ((GeeIterable*) (_tmp42 = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) cl))), (_tmp42 == NULL) ? NULL : (_tmp42 = (gee_collection_object_unref (_tmp42), NULL)), _tmp43);
		/* type, dup func, and destroy func properties for generic types */
		while (gee_iterator_next (type_param_it)) {
			ValaTypeParameter* type_param;
			char* func_name;
			char* enum_value;
			ValaCCodeMemberAccess* cfield;
			ValaCCodeFunctionCall* cgetcall;
			char* _tmp45;
			char* _tmp44;
			char* _tmp48;
			char* _tmp47;
			char* _tmp46;
			ValaCCodeCaseStatement* _tmp50;
			ValaCCodeIdentifier* _tmp49;
			ValaCCodeMemberAccess* _tmp53;
			ValaCCodeMemberAccess* _tmp52;
			ValaCCodeIdentifier* _tmp51;
			ValaCCodeFunctionCall* _tmp55;
			ValaCCodeIdentifier* _tmp54;
			ValaCCodeIdentifier* _tmp56;
			ValaCCodeExpressionStatement* _tmp58;
			ValaCCodeAssignment* _tmp57;
			ValaCCodeBreakStatement* _tmp59;
			char* _tmp61;
			char* _tmp60;
			char* _tmp64;
			char* _tmp63;
			char* _tmp62;
			ValaCCodeCaseStatement* _tmp66;
			ValaCCodeIdentifier* _tmp65;
			ValaCCodeMemberAccess* _tmp69;
			ValaCCodeMemberAccess* _tmp68;
			ValaCCodeIdentifier* _tmp67;
			ValaCCodeFunctionCall* _tmp71;
			ValaCCodeIdentifier* _tmp70;
			ValaCCodeIdentifier* _tmp72;
			ValaCCodeExpressionStatement* _tmp74;
			ValaCCodeAssignment* _tmp73;
			ValaCCodeBreakStatement* _tmp75;
			char* _tmp77;
			char* _tmp76;
			char* _tmp80;
			char* _tmp79;
			char* _tmp78;
			ValaCCodeCaseStatement* _tmp82;
			ValaCCodeIdentifier* _tmp81;
			ValaCCodeMemberAccess* _tmp85;
			ValaCCodeMemberAccess* _tmp84;
			ValaCCodeIdentifier* _tmp83;
			ValaCCodeFunctionCall* _tmp87;
			ValaCCodeIdentifier* _tmp86;
			ValaCCodeIdentifier* _tmp88;
			ValaCCodeExpressionStatement* _tmp90;
			ValaCCodeAssignment* _tmp89;
			ValaCCodeBreakStatement* _tmp91;
			/* type, dup func, and destroy func properties for generic types */
			type_param = (ValaTypeParameter*) gee_iterator_get (type_param_it);
			func_name = NULL;
			enum_value = NULL;
			cfield = NULL;
			cgetcall = NULL;
			_tmp45 = NULL;
			_tmp44 = NULL;
			func_name = (_tmp45 = g_strdup_printf ("%s_type", _tmp44 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp45);
			_tmp44 = (g_free (_tmp44), NULL);
			_tmp48 = NULL;
			_tmp47 = NULL;
			_tmp46 = NULL;
			enum_value = (_tmp48 = g_utf8_strup (_tmp47 = g_strdup_printf ("%s_%s", _tmp46 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp48);
			_tmp47 = (g_free (_tmp47), NULL);
			_tmp46 = (g_free (_tmp46), NULL);
			_tmp50 = NULL;
			_tmp49 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp50 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new (enum_value)))));
			(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
			(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
			_tmp53 = NULL;
			_tmp52 = NULL;
			_tmp51 = NULL;
			cfield = (_tmp53 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp52 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp53);
			(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
			(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
			_tmp55 = NULL;
			_tmp54 = NULL;
			cgetcall = (_tmp55 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("g_value_get_gtype"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp55);
			(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
			_tmp56 = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp56 = vala_ccode_identifier_new ("value")));
			(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
			_tmp58 = NULL;
			_tmp57 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp58 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp57 = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp58 == NULL) ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL));
			(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
			_tmp59 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp59 = vala_ccode_break_statement_new ()));
			(_tmp59 == NULL) ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL));
			_tmp61 = NULL;
			_tmp60 = NULL;
			func_name = (_tmp61 = g_strdup_printf ("%s_dup_func", _tmp60 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp61);
			_tmp60 = (g_free (_tmp60), NULL);
			_tmp64 = NULL;
			_tmp63 = NULL;
			_tmp62 = NULL;
			enum_value = (_tmp64 = g_utf8_strup (_tmp63 = g_strdup_printf ("%s_%s", _tmp62 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp64);
			_tmp63 = (g_free (_tmp63), NULL);
			_tmp62 = (g_free (_tmp62), NULL);
			_tmp66 = NULL;
			_tmp65 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp66 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp65 = vala_ccode_identifier_new (enum_value)))));
			(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
			(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
			_tmp69 = NULL;
			_tmp68 = NULL;
			_tmp67 = NULL;
			cfield = (_tmp69 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp68 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp67 = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp69);
			(_tmp68 == NULL) ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL));
			(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
			_tmp71 = NULL;
			_tmp70 = NULL;
			cgetcall = (_tmp71 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new ("g_value_get_pointer"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp71);
			(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
			_tmp72 = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp72 = vala_ccode_identifier_new ("value")));
			(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
			_tmp74 = NULL;
			_tmp73 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp74 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp73 = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp74 == NULL) ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL));
			(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
			_tmp75 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp75 = vala_ccode_break_statement_new ()));
			(_tmp75 == NULL) ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL));
			_tmp77 = NULL;
			_tmp76 = NULL;
			func_name = (_tmp77 = g_strdup_printf ("%s_destroy_func", _tmp76 = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) type_param), -1)), func_name = (g_free (func_name), NULL), _tmp77);
			_tmp76 = (g_free (_tmp76), NULL);
			_tmp80 = NULL;
			_tmp79 = NULL;
			_tmp78 = NULL;
			enum_value = (_tmp80 = g_utf8_strup (_tmp79 = g_strdup_printf ("%s_%s", _tmp78 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), func_name), -1), enum_value = (g_free (enum_value), NULL), _tmp80);
			_tmp79 = (g_free (_tmp79), NULL);
			_tmp78 = (g_free (_tmp78), NULL);
			_tmp82 = NULL;
			_tmp81 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp82 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp81 = vala_ccode_identifier_new (enum_value)))));
			(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
			(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
			_tmp85 = NULL;
			_tmp84 = NULL;
			_tmp83 = NULL;
			cfield = (_tmp85 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp84 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp83 = vala_ccode_identifier_new ("self")), "priv")), func_name), (cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)), _tmp85);
			(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
			(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
			_tmp87 = NULL;
			_tmp86 = NULL;
			cgetcall = (_tmp87 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp86 = vala_ccode_identifier_new ("g_value_get_pointer"))), (cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)), _tmp87);
			(_tmp86 == NULL) ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL));
			_tmp88 = NULL;
			vala_ccode_function_call_add_argument (cgetcall, (ValaCCodeExpression*) (_tmp88 = vala_ccode_identifier_new ("value")));
			(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
			_tmp90 = NULL;
			_tmp89 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp90 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp89 = vala_ccode_assignment_new ((ValaCCodeExpression*) cfield, (ValaCCodeExpression*) cgetcall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
			(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
			_tmp91 = NULL;
			vala_ccode_block_add_statement ((ValaCCodeBlock*) cswitch, (ValaCCodeNode*) (_tmp91 = vala_ccode_break_statement_new ()));
			(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
			(type_param == NULL) ? NULL : (type_param = (vala_code_node_unref (type_param), NULL));
			func_name = (g_free (func_name), NULL);
			enum_value = (g_free (enum_value), NULL);
			(cfield == NULL) ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL));
			(cgetcall == NULL) ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL));
		}
		(type_param_it == NULL) ? NULL : (type_param_it = (gee_collection_object_unref (type_param_it), NULL));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) set_prop);
	(set_prop == NULL) ? NULL : (set_prop = (vala_ccode_node_unref (set_prop), NULL));
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(cswitch == NULL) ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL));
	(props == NULL) ? NULL : (props = (gee_collection_object_unref (props), NULL));
}


static ValaCCodeStatement* vala_gobject_module_get_invalid_property_id_warn_statement (ValaGObjectModule* self) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	/* warn on invalid property id*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cwarn = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("object")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("property_id")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cwarn, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("pspec")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	return (_tmp5 = (ValaCCodeStatement*) vala_ccode_expression_statement_new ((ValaCCodeExpression*) cwarn), (cwarn == NULL) ? NULL : (cwarn = (vala_ccode_node_unref (cwarn), NULL)), _tmp5);
}


static ValaCCodeFunctionCall* vala_gobject_module_real_get_param_spec (ValaCCodeModule* base, ValaProperty* prop) {
	ValaGObjectModule * self;
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp2;
	char* _tmp1;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	gboolean _tmp5;
	gboolean _tmp6;
	char* pflags;
	ValaCCodeConstant* _tmp102;
	ValaCCodeFunctionCall* _tmp103;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp0 = vala_property_get_canonical_cconstant (prop)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp2 = vala_ccode_constant_new (_tmp1 = g_strdup_printf ("\"%s\"", vala_property_get_nick (prop)))));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp4 = vala_ccode_constant_new (_tmp3 = g_strdup_printf ("\"%s\"", vala_property_get_blurb (prop)))));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
		_tmp6 = !(vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
	} else {
		_tmp6 = FALSE;
	}
	if ((_tmp6)) {
		_tmp5 = TRUE;
	} else {
		_tmp5 = VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_property_type (prop)));
	}
	if (_tmp5) {
		char* param_spec_name;
		param_spec_name = vala_typesymbol_get_param_spec_function (vala_data_type_get_data_type (vala_property_get_property_type (prop)));
		if (param_spec_name == NULL) {
			ValaCCodeIdentifier* _tmp7;
			_tmp7 = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("g_param_spec_pointer")));
			(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		} else {
			ValaCCodeIdentifier* _tmp8;
			ValaCCodeIdentifier* _tmp10;
			char* _tmp9;
			_tmp8 = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new (param_spec_name)));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
			_tmp10 = NULL;
			_tmp9 = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp10 = vala_ccode_identifier_new (_tmp9 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
			(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
			_tmp9 = (g_free (_tmp9), NULL);
		}
		param_spec_name = (g_free (param_spec_name), NULL);
	} else {
		if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
			ValaCCodeIdentifier* _tmp11;
			ValaCCodeConstant* _tmp12;
			_tmp11 = NULL;
			vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("g_param_spec_string")));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			_tmp12 = NULL;
			vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp12 = vala_ccode_constant_new ("NULL")));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
				ValaEnum* _tmp14;
				ValaTypeSymbol* _tmp13;
				ValaEnum* e;
				_tmp14 = NULL;
				_tmp13 = NULL;
				e = (_tmp14 = (_tmp13 = vala_data_type_get_data_type (vala_property_get_property_type (prop)), VALA_IS_ENUM (_tmp13) ? ((ValaEnum*) _tmp13) : NULL), (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14));
				if (vala_enum_get_has_type_id (e)) {
					ValaCCodeIdentifier* _tmp18;
					char* _tmp17;
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp15;
						_tmp15 = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp15 = vala_ccode_identifier_new ("g_param_spec_flags")));
						(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
					} else {
						ValaCCodeIdentifier* _tmp16;
						_tmp16 = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_param_spec_enum")));
						(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
					}
					_tmp18 = NULL;
					_tmp17 = NULL;
					vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp18 = vala_ccode_identifier_new (_tmp17 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) e))));
					(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
					_tmp17 = (g_free (_tmp17), NULL);
				} else {
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp19;
						ValaCCodeConstant* _tmp20;
						ValaCCodeConstant* _tmp21;
						_tmp19 = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("g_param_spec_uint")));
						(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp20 = vala_ccode_constant_new ("0")));
						(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp21 = vala_ccode_constant_new ("G_MAXUINT")));
						(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
					} else {
						ValaCCodeIdentifier* _tmp22;
						ValaCCodeConstant* _tmp23;
						ValaCCodeConstant* _tmp24;
						_tmp22 = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new ("g_param_spec_int")));
						(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp23 = vala_ccode_constant_new ("G_MININT")));
						(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
						_tmp24 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp24 = vala_ccode_constant_new ("G_MAXINT")));
						(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
					}
				}
				if (vala_property_get_default_expression (prop) != NULL) {
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
				} else {
					ValaCCodeConstant* _tmp26;
					char* _tmp25;
					_tmp26 = NULL;
					_tmp25 = NULL;
					vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp26 = vala_ccode_constant_new (_tmp25 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_property_get_property_type (prop))))));
					(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
					_tmp25 = (g_free (_tmp25), NULL);
				}
				(e == NULL) ? NULL : (e = (vala_code_node_unref (e), NULL));
			} else {
				if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
					ValaStruct* _tmp27;
					ValaStruct* st;
					char* _tmp28;
					gboolean _tmp29;
					_tmp27 = NULL;
					st = (_tmp27 = VALA_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop))), (_tmp27 == NULL) ? NULL : vala_code_node_ref (_tmp27));
					_tmp28 = NULL;
					if ((_tmp29 = _vala_strcmp0 (_tmp28 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_INT") == 0, _tmp28 = (g_free (_tmp28), NULL), _tmp29)) {
						ValaCCodeIdentifier* _tmp30;
						ValaCCodeConstant* _tmp31;
						ValaCCodeConstant* _tmp32;
						_tmp30 = NULL;
						vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("g_param_spec_int")));
						(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
						_tmp31 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp31 = vala_ccode_constant_new ("G_MININT")));
						(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
						_tmp32 = NULL;
						vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp32 = vala_ccode_constant_new ("G_MAXINT")));
						(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
						if (vala_property_get_default_expression (prop) != NULL) {
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
						} else {
							ValaCCodeConstant* _tmp33;
							_tmp33 = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp33 = vala_ccode_constant_new ("0")));
							(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
						}
					} else {
						char* _tmp34;
						gboolean _tmp35;
						_tmp34 = NULL;
						if ((_tmp35 = _vala_strcmp0 (_tmp34 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UINT") == 0, _tmp34 = (g_free (_tmp34), NULL), _tmp35)) {
							ValaCCodeIdentifier* _tmp36;
							ValaCCodeConstant* _tmp37;
							ValaCCodeConstant* _tmp38;
							_tmp36 = NULL;
							vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("g_param_spec_uint")));
							(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
							_tmp37 = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp37 = vala_ccode_constant_new ("0")));
							(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
							_tmp38 = NULL;
							vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp38 = vala_ccode_constant_new ("G_MAXUINT")));
							(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
							if (vala_property_get_default_expression (prop) != NULL) {
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
							} else {
								ValaCCodeConstant* _tmp39;
								_tmp39 = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp39 = vala_ccode_constant_new ("0U")));
								(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
							}
						} else {
							char* _tmp40;
							gboolean _tmp41;
							_tmp40 = NULL;
							if ((_tmp41 = _vala_strcmp0 (_tmp40 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_INT64") == 0, _tmp40 = (g_free (_tmp40), NULL), _tmp41)) {
								ValaCCodeIdentifier* _tmp42;
								ValaCCodeConstant* _tmp43;
								ValaCCodeConstant* _tmp44;
								_tmp42 = NULL;
								vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp42 = vala_ccode_identifier_new ("g_param_spec_int64")));
								(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
								_tmp43 = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp43 = vala_ccode_constant_new ("G_MININT64")));
								(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
								_tmp44 = NULL;
								vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp44 = vala_ccode_constant_new ("G_MAXINT64")));
								(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
								if (vala_property_get_default_expression (prop) != NULL) {
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
								} else {
									ValaCCodeConstant* _tmp45;
									_tmp45 = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp45 = vala_ccode_constant_new ("0")));
									(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
								}
							} else {
								char* _tmp46;
								gboolean _tmp47;
								_tmp46 = NULL;
								if ((_tmp47 = _vala_strcmp0 (_tmp46 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UINT64") == 0, _tmp46 = (g_free (_tmp46), NULL), _tmp47)) {
									ValaCCodeIdentifier* _tmp48;
									ValaCCodeConstant* _tmp49;
									ValaCCodeConstant* _tmp50;
									_tmp48 = NULL;
									vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp48 = vala_ccode_identifier_new ("g_param_spec_uint64")));
									(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
									_tmp49 = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp49 = vala_ccode_constant_new ("0")));
									(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
									_tmp50 = NULL;
									vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp50 = vala_ccode_constant_new ("G_MAXUINT64")));
									(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
									if (vala_property_get_default_expression (prop) != NULL) {
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
									} else {
										ValaCCodeConstant* _tmp51;
										_tmp51 = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp51 = vala_ccode_constant_new ("0U")));
										(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
									}
								} else {
									char* _tmp52;
									gboolean _tmp53;
									_tmp52 = NULL;
									if ((_tmp53 = _vala_strcmp0 (_tmp52 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_LONG") == 0, _tmp52 = (g_free (_tmp52), NULL), _tmp53)) {
										ValaCCodeIdentifier* _tmp54;
										ValaCCodeConstant* _tmp55;
										ValaCCodeConstant* _tmp56;
										_tmp54 = NULL;
										vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("g_param_spec_long")));
										(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
										_tmp55 = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp55 = vala_ccode_constant_new ("G_MINLONG")));
										(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
										_tmp56 = NULL;
										vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp56 = vala_ccode_constant_new ("G_MAXLONG")));
										(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
										if (vala_property_get_default_expression (prop) != NULL) {
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
										} else {
											ValaCCodeConstant* _tmp57;
											_tmp57 = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp57 = vala_ccode_constant_new ("0L")));
											(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
										}
									} else {
										char* _tmp58;
										gboolean _tmp59;
										_tmp58 = NULL;
										if ((_tmp59 = _vala_strcmp0 (_tmp58 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_ULONG") == 0, _tmp58 = (g_free (_tmp58), NULL), _tmp59)) {
											ValaCCodeIdentifier* _tmp60;
											ValaCCodeConstant* _tmp61;
											ValaCCodeConstant* _tmp62;
											_tmp60 = NULL;
											vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp60 = vala_ccode_identifier_new ("g_param_spec_ulong")));
											(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
											_tmp61 = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp61 = vala_ccode_constant_new ("0")));
											(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
											_tmp62 = NULL;
											vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp62 = vala_ccode_constant_new ("G_MAXULONG")));
											(_tmp62 == NULL) ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL));
											if (vala_property_get_default_expression (prop) != NULL) {
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
											} else {
												ValaCCodeConstant* _tmp63;
												_tmp63 = NULL;
												vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp63 = vala_ccode_constant_new ("0UL")));
												(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
											}
										} else {
											char* _tmp64;
											gboolean _tmp65;
											_tmp64 = NULL;
											if ((_tmp65 = _vala_strcmp0 (_tmp64 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_BOOLEAN") == 0, _tmp64 = (g_free (_tmp64), NULL), _tmp65)) {
												ValaCCodeIdentifier* _tmp66;
												_tmp66 = NULL;
												vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp66 = vala_ccode_identifier_new ("g_param_spec_boolean")));
												(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
												if (vala_property_get_default_expression (prop) != NULL) {
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
												} else {
													ValaCCodeConstant* _tmp67;
													_tmp67 = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp67 = vala_ccode_constant_new ("FALSE")));
													(_tmp67 == NULL) ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL));
												}
											} else {
												char* _tmp68;
												gboolean _tmp69;
												_tmp68 = NULL;
												if ((_tmp69 = _vala_strcmp0 (_tmp68 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_CHAR") == 0, _tmp68 = (g_free (_tmp68), NULL), _tmp69)) {
													ValaCCodeIdentifier* _tmp70;
													ValaCCodeConstant* _tmp71;
													ValaCCodeConstant* _tmp72;
													_tmp70 = NULL;
													vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp70 = vala_ccode_identifier_new ("g_param_spec_char")));
													(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
													_tmp71 = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp71 = vala_ccode_constant_new ("G_MININT8")));
													(_tmp71 == NULL) ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL));
													_tmp72 = NULL;
													vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp72 = vala_ccode_constant_new ("G_MAXINT8")));
													(_tmp72 == NULL) ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL));
													if (vala_property_get_default_expression (prop) != NULL) {
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
													} else {
														ValaCCodeConstant* _tmp73;
														_tmp73 = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp73 = vala_ccode_constant_new ("0")));
														(_tmp73 == NULL) ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL));
													}
												} else {
													char* _tmp74;
													gboolean _tmp75;
													_tmp74 = NULL;
													if ((_tmp75 = _vala_strcmp0 (_tmp74 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_UCHAR") == 0, _tmp74 = (g_free (_tmp74), NULL), _tmp75)) {
														ValaCCodeIdentifier* _tmp76;
														ValaCCodeConstant* _tmp77;
														ValaCCodeConstant* _tmp78;
														_tmp76 = NULL;
														vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp76 = vala_ccode_identifier_new ("g_param_spec_uchar")));
														(_tmp76 == NULL) ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL));
														_tmp77 = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp77 = vala_ccode_constant_new ("0")));
														(_tmp77 == NULL) ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL));
														_tmp78 = NULL;
														vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp78 = vala_ccode_constant_new ("G_MAXUINT8")));
														(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
														if (vala_property_get_default_expression (prop) != NULL) {
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
														} else {
															ValaCCodeConstant* _tmp79;
															_tmp79 = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp79 = vala_ccode_constant_new ("0")));
															(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
														}
													} else {
														char* _tmp80;
														gboolean _tmp81;
														_tmp80 = NULL;
														if ((_tmp81 = _vala_strcmp0 (_tmp80 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_FLOAT") == 0, _tmp80 = (g_free (_tmp80), NULL), _tmp81)) {
															ValaCCodeIdentifier* _tmp82;
															ValaCCodeConstant* _tmp83;
															ValaCCodeConstant* _tmp84;
															_tmp82 = NULL;
															vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp82 = vala_ccode_identifier_new ("g_param_spec_float")));
															(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
															_tmp83 = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp83 = vala_ccode_constant_new ("-G_MAXFLOAT")));
															(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
															_tmp84 = NULL;
															vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp84 = vala_ccode_constant_new ("G_MAXFLOAT")));
															(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
															if (vala_property_get_default_expression (prop) != NULL) {
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
															} else {
																ValaCCodeConstant* _tmp85;
																_tmp85 = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp85 = vala_ccode_constant_new ("0.0F")));
																(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
															}
														} else {
															char* _tmp86;
															gboolean _tmp87;
															_tmp86 = NULL;
															if ((_tmp87 = _vala_strcmp0 (_tmp86 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_DOUBLE") == 0, _tmp86 = (g_free (_tmp86), NULL), _tmp87)) {
																ValaCCodeIdentifier* _tmp88;
																ValaCCodeConstant* _tmp89;
																ValaCCodeConstant* _tmp90;
																_tmp88 = NULL;
																vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp88 = vala_ccode_identifier_new ("g_param_spec_double")));
																(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
																_tmp89 = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp89 = vala_ccode_constant_new ("-G_MAXDOUBLE")));
																(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
																_tmp90 = NULL;
																vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp90 = vala_ccode_constant_new ("G_MAXDOUBLE")));
																(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
																if (vala_property_get_default_expression (prop) != NULL) {
																	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
																} else {
																	ValaCCodeConstant* _tmp91;
																	_tmp91 = NULL;
																	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp91 = vala_ccode_constant_new ("0.0")));
																	(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
																}
															} else {
																char* _tmp92;
																gboolean _tmp93;
																_tmp92 = NULL;
																if ((_tmp93 = _vala_strcmp0 (_tmp92 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st), "G_TYPE_GTYPE") == 0, _tmp92 = (g_free (_tmp92), NULL), _tmp93)) {
																	ValaCCodeIdentifier* _tmp94;
																	_tmp94 = NULL;
																	vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp94 = vala_ccode_identifier_new ("g_param_spec_gtype")));
																	(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
																	if (vala_property_get_default_expression (prop) != NULL) {
																		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_property_get_default_expression (prop))));
																	} else {
																		ValaCCodeConstant* _tmp95;
																		_tmp95 = NULL;
																		vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp95 = vala_ccode_constant_new ("G_TYPE_NONE")));
																		(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
																	}
																} else {
																	ValaCCodeIdentifier* _tmp96;
																	_tmp96 = NULL;
																	vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp96 = vala_ccode_identifier_new ("g_param_spec_pointer")));
																	(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
				} else {
					ValaCCodeIdentifier* _tmp97;
					_tmp97 = NULL;
					vala_ccode_function_call_set_call (cspec, (ValaCCodeExpression*) (_tmp97 = vala_ccode_identifier_new ("g_param_spec_pointer")));
					(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp98;
		_tmp98 = NULL;
		pflags = (_tmp98 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), pflags = (g_free (pflags), NULL), _tmp98);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp99;
		_tmp99 = NULL;
		pflags = (_tmp99 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), pflags = (g_free (pflags), NULL), _tmp99);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp100;
				_tmp100 = NULL;
				pflags = (_tmp100 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), pflags = (g_free (pflags), NULL), _tmp100);
			} else {
				char* _tmp101;
				_tmp101 = NULL;
				pflags = (_tmp101 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), pflags = (g_free (pflags), NULL), _tmp101);
			}
		}
	}
	_tmp102 = NULL;
	vala_ccode_function_call_add_argument (cspec, (ValaCCodeExpression*) (_tmp102 = vala_ccode_constant_new (pflags)));
	(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
	_tmp103 = NULL;
	return (_tmp103 = cspec, pflags = (g_free (pflags), NULL), _tmp103);
}


static ValaCCodeExpression* vala_gobject_module_real_get_construct_property_assignment (ValaCCodeModule* base, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value) {
	ValaGObjectModule * self;
	ValaCCodeIdentifier* cpointer;
	ValaCCodeCommaExpression* ccomma;
	ValaCCodeMemberAccess* cnamemember;
	ValaCCodeAssignment* cnameassign;
	ValaCCodeMemberAccess* _tmp0;
	ValaCCodeUnaryExpression* _tmp1;
	ValaCCodeUnaryExpression* gvaluearg;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* cvalueinit;
	ValaCCodeIdentifier* _tmp5;
	char* _tmp4;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeFunctionCall* _tmp7;
	ValaCCodeFunctionCall* cvalueset;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeExpression* _tmp9;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (canonical_cconstant != NULL, NULL);
	g_return_val_if_fail (property_type != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	/* this property is used as a construction parameter*/
	cpointer = vala_ccode_identifier_new ("__params_it");
	ccomma = vala_ccode_comma_expression_new ();
	/* set name in array for current parameter*/
	cnamemember = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cpointer, "name");
	cnameassign = vala_ccode_assignment_new ((ValaCCodeExpression*) cnamemember, (ValaCCodeExpression*) canonical_cconstant, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cnameassign);
	_tmp0 = NULL;
	_tmp1 = NULL;
	gvaluearg = (_tmp1 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp0 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) cpointer, "value"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	/* initialize GValue in array for current parameter*/
	_tmp2 = NULL;
	_tmp3 = NULL;
	cvalueinit = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("g_value_init"))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	vala_ccode_function_call_add_argument (cvalueinit, (ValaCCodeExpression*) gvaluearg);
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cvalueinit, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new (_tmp4 = vala_data_type_get_type_id (property_type))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cvalueinit);
	/* set GValue for current parameter*/
	_tmp6 = NULL;
	_tmp7 = NULL;
	cvalueset = (_tmp7 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6 = vala_ccode_module_get_value_setter_function ((ValaCCodeModule*) self, property_type))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7);
	vala_ccode_function_call_add_argument (cvalueset, (ValaCCodeExpression*) gvaluearg);
	vala_ccode_function_call_add_argument (cvalueset, value);
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) cvalueset);
	/* move pointer to next parameter in array*/
	_tmp8 = NULL;
	vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, (ValaCCodeExpression*) cpointer)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	_tmp9 = NULL;
	return (_tmp9 = (ValaCCodeExpression*) ccomma, (cpointer == NULL) ? NULL : (cpointer = (vala_ccode_node_unref (cpointer), NULL)), (cnamemember == NULL) ? NULL : (cnamemember = (vala_ccode_node_unref (cnamemember), NULL)), (cnameassign == NULL) ? NULL : (cnameassign = (vala_ccode_node_unref (cnameassign), NULL)), (gvaluearg == NULL) ? NULL : (gvaluearg = (vala_ccode_node_unref (gvaluearg), NULL)), (cvalueinit == NULL) ? NULL : (cvalueinit = (vala_ccode_node_unref (cvalueinit), NULL)), (cvalueset == NULL) ? NULL : (cvalueset = (vala_ccode_node_unref (cvalueset), NULL)), _tmp9);
}


static void vala_gobject_module_real_visit_constructor (ValaCCodeModule* base, ValaConstructor* c) {
	ValaGObjectModule * self;
	gboolean _tmp0;
	ValaClass* _tmp1;
	ValaClass* cl;
	self = (ValaGObjectModule*) base;
	g_return_if_fail (c != NULL);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = FALSE;
	((ValaCCodeBaseModule*) self)->in_constructor = TRUE;
	_tmp0 = FALSE;
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC;
	}
	if (_tmp0) {
		((ValaCCodeBaseModule*) self)->in_static_or_class_ctor = TRUE;
	}
	vala_code_node_accept_children ((ValaCodeNode*) c, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	((ValaCCodeBaseModule*) self)->in_static_or_class_ctor = FALSE;
	((ValaCCodeBaseModule*) self)->in_constructor = FALSE;
	_tmp1 = NULL;
	cl = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) c)), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	if (vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeFunction* _tmp4;
		char* _tmp3;
		char* _tmp2;
		ValaCCodeFormalParameter* _tmp5;
		ValaCCodeFormalParameter* _tmp6;
		ValaCCodeFormalParameter* _tmp7;
		ValaCCodeFunction* _tmp8;
		ValaCCodeBlock* cblock;
		ValaCCodeDeclaration* cdecl_;
		ValaCCodeVariableDeclarator* _tmp9;
		ValaCCodeDeclaration* _tmp12;
		char* _tmp11;
		char* _tmp10;
		ValaCCodeVariableDeclarator* _tmp13;
		ValaCCodeDeclaration* _tmp14;
		ValaCCodeVariableDeclarator* _tmp15;
		ValaCCodeIdentifier* _tmp16;
		ValaCCodeFunctionCall* _tmp17;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp19;
		char* _tmp18;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		char* _tmp20;
		ValaCCodeFunctionCall* _tmp23;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeExpressionStatement* _tmp26;
		ValaCCodeAssignment* _tmp25;
		ValaCCodeIdentifier* _tmp24;
		ValaCCodeFunctionCall* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp29;
		ValaCCodeFunctionCall* _tmp31;
		ValaCCodeIdentifier* _tmp30;
		ValaCCodeExpressionStatement* _tmp34;
		ValaCCodeAssignment* _tmp33;
		ValaCCodeIdentifier* _tmp32;
		ValaCCodeFunctionCall* _tmp37;
		ValaCCodeMemberAccess* _tmp36;
		ValaCCodeIdentifier* _tmp35;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeIdentifier* _tmp39;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeExpressionStatement* _tmp43;
		ValaCCodeAssignment* _tmp42;
		ValaCCodeIdentifier* _tmp41;
		ValaCCodeFunctionCall* _tmp45;
		ValaCCodeIdentifier* _tmp44;
		ValaCCodeDeclaration* _tmp48;
		char* _tmp47;
		char* _tmp46;
		ValaCCodeVariableDeclarator* _tmp49;
		ValaCCodeReturnStatement* _tmp53;
		ValaCCodeIdentifier* _tmp52;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		((ValaCCodeBaseModule*) self)->function = (_tmp4 = vala_ccode_function_new (_tmp3 = g_strdup_printf ("%s_constructor", _tmp2 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "GObject *"), (((ValaCCodeBaseModule*) self)->function == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->function = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->function), NULL)), _tmp4);
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		vala_ccode_function_set_modifiers (((ValaCCodeBaseModule*) self)->function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp5 = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp5 = vala_ccode_formal_parameter_new ("type", "GType"));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		_tmp6 = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp6 = vala_ccode_formal_parameter_new ("n_construct_properties", "guint"));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		_tmp7 = NULL;
		vala_ccode_function_add_parameter (((ValaCCodeBaseModule*) self)->function, _tmp7 = vala_ccode_formal_parameter_new ("construct_properties", "GObjectConstructParam *"));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp8 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp8 = vala_ccode_function_copy (((ValaCCodeBaseModule*) self)->function)));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		cblock = vala_ccode_block_new ();
		cdecl_ = vala_ccode_declaration_new ("GObject *");
		_tmp9 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp9 = vala_ccode_variable_declarator_new ("obj")));
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		cdecl_ = (_tmp12 = vala_ccode_declaration_new (_tmp11 = g_strdup_printf ("%sClass *", _tmp10 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp12);
		_tmp11 = (g_free (_tmp11), NULL);
		_tmp10 = (g_free (_tmp10), NULL);
		_tmp13 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp13 = vala_ccode_variable_declarator_new ("klass")));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
		_tmp14 = NULL;
		cdecl_ = (_tmp14 = vala_ccode_declaration_new ("GObjectClass *"), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp14);
		_tmp15 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp15 = vala_ccode_variable_declarator_new ("parent_class")));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
		_tmp16 = NULL;
		_tmp17 = NULL;
		ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new ("g_type_class_peek"))), (_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)), _tmp17);
		_tmp19 = NULL;
		_tmp18 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new (_tmp18 = vala_typesymbol_get_type_id ((ValaTypeSymbol*) cl))));
		(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
		_tmp18 = (g_free (_tmp18), NULL);
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp23 = NULL;
		ccast = (_tmp23 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp22 = vala_ccode_identifier_new (_tmp21 = g_strdup_printf ("%s_CLASS", _tmp20 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL))))), (_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)), _tmp21 = (g_free (_tmp21), NULL), _tmp20 = (g_free (_tmp20), NULL), _tmp23);
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) ccall);
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp26 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp24 = vala_ccode_identifier_new ("klass")), (ValaCCodeExpression*) ccast, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
		(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
		(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
		_tmp28 = NULL;
		_tmp27 = NULL;
		ccall = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new ("g_type_class_peek_parent"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp28);
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp29 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29 = vala_ccode_identifier_new ("klass")));
		(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
		_tmp31 = NULL;
		_tmp30 = NULL;
		ccast = (_tmp31 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("G_OBJECT_CLASS"))), (ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)), _tmp31);
		(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
		vala_ccode_function_call_add_argument (ccast, (ValaCCodeExpression*) ccall);
		_tmp34 = NULL;
		_tmp33 = NULL;
		_tmp32 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp34 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp33 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32 = vala_ccode_identifier_new ("parent_class")), (ValaCCodeExpression*) ccast, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
		(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
		(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
		_tmp37 = NULL;
		_tmp36 = NULL;
		_tmp35 = NULL;
		ccall = (_tmp37 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("parent_class")), "constructor"))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp37);
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("type")));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp39 = vala_ccode_identifier_new ("n_construct_properties")));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		_tmp40 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("construct_properties")));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		_tmp43 = NULL;
		_tmp42 = NULL;
		_tmp41 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp43 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp42 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("obj")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp43 == NULL) ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		_tmp45 = NULL;
		_tmp44 = NULL;
		ccall = (_tmp45 = (ValaCCodeFunctionCall*) vala_instance_cast_new ((ValaCCodeExpression*) (_tmp44 = vala_ccode_identifier_new ("obj")), (ValaTypeSymbol*) cl), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp45);
		(_tmp44 == NULL) ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL));
		_tmp48 = NULL;
		_tmp47 = NULL;
		_tmp46 = NULL;
		cdecl_ = (_tmp48 = vala_ccode_declaration_new (_tmp47 = g_strdup_printf ("%s *", _tmp46 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))), (cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)), _tmp48);
		_tmp47 = (g_free (_tmp47), NULL);
		_tmp46 = (g_free (_tmp46), NULL);
		_tmp49 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp49 = vala_ccode_variable_declarator_new_with_initializer ("self", (ValaCCodeExpression*) ccall)));
		(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
		if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp51;
			ValaCCodeConstant* _tmp50;
			/* always separate error parameter and inner_error local variable
			 * as error may be set to NULL but we're always interested in inner errors
			 */
			cdecl_ = vala_ccode_declaration_new ("GError *");
			_tmp51 = NULL;
			_tmp50 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp51 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp50 = vala_ccode_constant_new ("NULL")))));
			(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
			(_tmp50 == NULL) ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL));
			vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) cdecl_);
			(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		}
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c)));
		_tmp53 = NULL;
		_tmp52 = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp53 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new ("obj")))));
		(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
		(_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL));
		vala_ccode_function_set_block (((ValaCCodeBaseModule*) self)->function, cblock);
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) c)) != NULL) {
			ValaCCodeComment* _tmp54;
			_tmp54 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) (_tmp54 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) c)))));
			(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
		}
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function);
		(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
		(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		(ccast == NULL) ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL));
	} else {
		if (vala_constructor_get_binding (c) == MEMBER_BINDING_CLASS) {
			char* _tmp56;
			char* _tmp55;
			ValaCCodeFunction* _tmp57;
			ValaCCodeFunction* base_init;
			ValaCCodeFormalParameter* _tmp60;
			char* _tmp59;
			char* _tmp58;
			ValaCCodeFunction* _tmp61;
			ValaCCodeBlock* _tmp62;
			ValaCCodeBlock* block;
			/* class constructor*/
			_tmp56 = NULL;
			_tmp55 = NULL;
			_tmp57 = NULL;
			base_init = (_tmp57 = vala_ccode_function_new (_tmp56 = g_strdup_printf ("%s_base_init", _tmp55 = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL)), "void"), _tmp56 = (g_free (_tmp56), NULL), _tmp55 = (g_free (_tmp55), NULL), _tmp57);
			_tmp60 = NULL;
			_tmp59 = NULL;
			_tmp58 = NULL;
			vala_ccode_function_add_parameter (base_init, _tmp60 = vala_ccode_formal_parameter_new ("klass", _tmp59 = g_strdup_printf ("%sClass *", _tmp58 = vala_typesymbol_get_cname ((ValaTypeSymbol*) cl, FALSE))));
			(_tmp60 == NULL) ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL));
			_tmp59 = (g_free (_tmp59), NULL);
			_tmp58 = (g_free (_tmp58), NULL);
			vala_ccode_function_set_modifiers (base_init, VALA_CCODE_MODIFIERS_STATIC);
			_tmp61 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp61 = vala_ccode_function_copy (base_init)));
			(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
			_tmp62 = NULL;
			block = (_tmp62 = VALA_CCODE_BLOCK (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c))), (_tmp62 == NULL) ? NULL : vala_ccode_node_ref (_tmp62));
			if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp64;
				ValaCCodeConstant* _tmp63;
				/* always separate error parameter and inner_error local variable
				 * as error may be set to NULL but we're always interested in inner errors
				 */
				cdecl_ = vala_ccode_declaration_new ("GError *");
				_tmp64 = NULL;
				_tmp63 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp64 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp63 = vala_ccode_constant_new ("NULL")))));
				(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
				(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
				vala_ccode_block_prepend_statement (block, (ValaCCodeNode*) cdecl_);
				(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
			}
			vala_ccode_function_set_block (base_init, block);
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) base_init);
			(base_init == NULL) ? NULL : (base_init = (vala_ccode_node_unref (base_init), NULL));
			(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
		} else {
			if (vala_constructor_get_binding (c) == MEMBER_BINDING_STATIC) {
				/* static class constructor
				 add to class_init*/
				if (((ValaCCodeBaseModule*) self)->current_method_inner_error) {
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp66;
					ValaCCodeConstant* _tmp65;
					/* always separate error parameter and inner_error local variable
					 * as error may be set to NULL but we're always interested in inner errors
					 */
					cdecl_ = vala_ccode_declaration_new ("GError *");
					_tmp66 = NULL;
					_tmp65 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp66 = vala_ccode_variable_declarator_new_with_initializer ("inner_error", (ValaCCodeExpression*) (_tmp65 = vala_ccode_constant_new ("NULL")))));
					(_tmp66 == NULL) ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL));
					(_tmp65 == NULL) ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL));
					vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->class_init_fragment, (ValaCCodeNode*) cdecl_);
					(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
				}
				vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->class_init_fragment, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_constructor_get_body (c)));
			} else {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) c), "internal error: constructors must have instance, class, or static binding");
			}
		}
	}
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static char* vala_gobject_module_real_get_dynamic_property_getter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaGObjectModule * self;
	gboolean _tmp0;
	char* getter_cname;
	char* _tmp2;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp6;
	char* _tmp7;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0) {
		return VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_getter_cname ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), prop);
	}
	getter_cname = g_strdup_printf ("_dynamic_get_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	_tmp2 = NULL;
	_tmp3 = NULL;
	func = (_tmp3 = vala_ccode_function_new (getter_cname, _tmp2 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, _tmp5 = vala_ccode_formal_parameter_new ("obj", _tmp4 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_property_getter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp6 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (func)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp7 = NULL;
	return (_tmp7 = getter_cname, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp7);
}


static char* vala_gobject_module_real_get_dynamic_property_setter_cname (ValaCCodeModule* base, ValaDynamicProperty* prop) {
	ValaGObjectModule * self;
	gboolean _tmp0;
	char* setter_cname;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp6;
	char* _tmp7;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)) == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_property_get_dynamic_type (prop)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0) {
		return VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_property_setter_cname ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), prop);
	}
	setter_cname = g_strdup_printf ("_dynamic_set_%s%d", vala_symbol_get_name ((ValaSymbol*) prop), self->priv->dynamic_property_id++);
	func = vala_ccode_function_new (setter_cname, "void");
	vala_ccode_function_set_modifiers (func, vala_ccode_function_get_modifiers (func) | (VALA_CCODE_MODIFIERS_STATIC | VALA_CCODE_MODIFIERS_INLINE));
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (func, _tmp3 = vala_ccode_formal_parameter_new ("obj", _tmp2 = vala_data_type_get_cname (vala_dynamic_property_get_dynamic_type (prop))));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, _tmp5 = vala_ccode_formal_parameter_new ("value", _tmp4 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) prop))));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp4 = (g_free (_tmp4), NULL);
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_property_setter_wrapper (self, prop, block);
	/* append to C source file*/
	_tmp6 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp6 = vala_ccode_function_copy (func)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp7 = NULL;
	return (_tmp7 = setter_cname, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp7);
}


static void vala_gobject_module_generate_gobject_property_getter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	char* _tmp0;
	ValaCCodeDeclaration* _tmp1;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeFunctionCall* _tmp4;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeConstant* _tmp6;
	ValaCCodeUnaryExpression* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeConstant* _tmp9;
	ValaCCodeExpressionStatement* _tmp10;
	ValaCCodeReturnStatement* _tmp12;
	ValaCCodeIdentifier* _tmp11;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	cdecl_ = (_tmp1 = vala_ccode_declaration_new (_tmp0 = vala_data_type_get_cname (vala_property_get_property_type ((ValaProperty*) node))), _tmp0 = (g_free (_tmp0), NULL), _tmp1);
	_tmp2 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, (ValaCCodeDeclarator*) (_tmp2 = vala_ccode_variable_declarator_new ("result")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) cdecl_);
	_tmp3 = NULL;
	_tmp4 = NULL;
	call = (_tmp4 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp3 = vala_ccode_identifier_new ("g_object_get"))), (_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)), _tmp4);
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("obj")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp6 = vala_property_get_canonical_cconstant ((ValaProperty*) node)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp8 = NULL;
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("result")))));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp9 = vala_ccode_constant_new ("NULL")));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	_tmp10 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp10 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp12 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11 = vala_ccode_identifier_new ("result")))));
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
	(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
	(cdecl_ == NULL) ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_gobject_module_generate_gobject_property_setter_wrapper (ValaGObjectModule* self, ValaDynamicProperty* node, ValaCCodeBlock* block) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeConstant* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeConstant* _tmp5;
	ValaCCodeExpressionStatement* _tmp6;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_object_set"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new ("obj")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp3 = vala_property_get_canonical_cconstant ((ValaProperty*) node)));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("value")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_constant_new ("NULL")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp6 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static char* vala_gobject_module_real_get_dynamic_signal_cname (ValaCCodeModule* base, ValaDynamicSignal* node) {
	ValaGObjectModule * self;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (node != NULL, NULL);
	return g_strdup_printf ("dynamic_%s%d_", vala_symbol_get_name ((ValaSymbol*) node), self->priv->signal_wrapper_id++);
}


static char* vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* base, ValaDynamicSignal* sig) {
	ValaGObjectModule * self;
	gboolean _tmp0;
	char* _tmp2;
	char* _tmp3;
	char* connect_wrapper_name;
	ValaCCodeFunction* func;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeFormalParameter* _tmp7;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp8;
	char* _tmp9;
	self = (ValaGObjectModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0 = FALSE;
	if (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)) == NULL) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = !vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_dynamic_signal_get_dynamic_type (sig)), ((ValaCCodeBaseModule*) self)->gobject_type);
	}
	if (_tmp0) {
		return VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->get_dynamic_signal_connect_wrapper_name ((ValaCCodeModule*) VALA_GTYPE_MODULE (self), sig);
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	connect_wrapper_name = (_tmp3 = g_strdup_printf ("_%sconnect", _tmp2 = vala_ccode_module_get_dynamic_signal_cname ((ValaCCodeModule*) self, sig)), _tmp2 = (g_free (_tmp2), NULL), _tmp3);
	func = vala_ccode_function_new (connect_wrapper_name, "void");
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (func, _tmp4 = vala_ccode_formal_parameter_new ("obj", "gpointer"));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (func, _tmp5 = vala_ccode_formal_parameter_new ("signal_name", "const char *"));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (func, _tmp6 = vala_ccode_formal_parameter_new ("handler", "GCallback"));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_function_add_parameter (func, _tmp7 = vala_ccode_formal_parameter_new ("data", "gpointer"));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	block = vala_ccode_block_new ();
	vala_gobject_module_generate_gobject_connect_wrapper (self, sig, block);
	/* append to C source file*/
	_tmp8 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp8 = vala_ccode_function_copy (func)));
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	vala_ccode_function_set_block (func, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) func);
	_tmp9 = NULL;
	return (_tmp9 = connect_wrapper_name, (func == NULL) ? NULL : (func = (vala_ccode_node_unref (func), NULL)), (block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL)), _tmp9);
}


static void vala_gobject_module_generate_gobject_connect_wrapper (ValaGObjectModule* self, ValaDynamicSignal* sig, ValaCCodeBlock* block) {
	ValaMethod* _tmp0;
	ValaMethod* m;
	char* connect_func;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeFunctionCall* _tmp3;
	ValaCCodeFunctionCall* call;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeExpressionStatement* _tmp9;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (block != NULL);
	_tmp0 = NULL;
	m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (vala_dynamic_signal_get_handler (sig))), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	vala_code_node_accept ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	connect_func = g_strdup ("g_signal_connect_object");
	if (vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE) {
		char* _tmp1;
		_tmp1 = NULL;
		connect_func = (_tmp1 = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp1);
	}
	_tmp2 = NULL;
	_tmp3 = NULL;
	call = (_tmp3 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2 = vala_ccode_identifier_new (connect_func))), (_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)), _tmp3);
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new ("obj")));
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_identifier_new ("signal_name")));
	(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
	_tmp6 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("handler")));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp7 = vala_ccode_identifier_new ("data")));
	(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeConstant* _tmp8;
		_tmp8 = NULL;
		vala_ccode_function_call_add_argument (call, (ValaCCodeExpression*) (_tmp8 = vala_ccode_constant_new ("0")));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
	}
	_tmp9 = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp9 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) call)));
	(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	connect_func = (g_free (connect_func), NULL);
	(call == NULL) ? NULL : (call = (vala_ccode_node_unref (call), NULL));
}


static void vala_gobject_module_class_init (ValaGObjectModuleClass * klass) {
	vala_gobject_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_gobject_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGObjectModulePrivate));
	VALA_CCODE_MODULE_CLASS (klass)->visit_class = vala_gobject_module_real_visit_class;
	VALA_CCODE_MODULE_CLASS (klass)->get_param_spec = vala_gobject_module_real_get_param_spec;
	VALA_CCODE_MODULE_CLASS (klass)->get_construct_property_assignment = vala_gobject_module_real_get_construct_property_assignment;
	VALA_CCODE_MODULE_CLASS (klass)->visit_constructor = vala_gobject_module_real_visit_constructor;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_getter_cname = vala_gobject_module_real_get_dynamic_property_getter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_property_setter_cname = vala_gobject_module_real_get_dynamic_property_setter_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_cname = vala_gobject_module_real_get_dynamic_signal_cname;
	VALA_CCODE_MODULE_CLASS (klass)->get_dynamic_signal_connect_wrapper_name = vala_gobject_module_real_get_dynamic_signal_connect_wrapper_name;
}


static void vala_gobject_module_instance_init (ValaGObjectModule * self) {
	self->priv = VALA_GOBJECT_MODULE_GET_PRIVATE (self);
}


static void vala_gobject_module_finalize (ValaCCodeModule* obj) {
	ValaGObjectModule * self;
	self = VALA_GOBJECT_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_gobject_module_parent_class)->finalize (obj);
}


GType vala_gobject_module_get_type (void) {
	static GType vala_gobject_module_type_id = 0;
	if (vala_gobject_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGObjectModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gobject_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGObjectModule), 0, (GInstanceInitFunc) vala_gobject_module_instance_init, NULL };
		vala_gobject_module_type_id = g_type_register_static (VALA_TYPE_GTYPE_MODULE, "ValaGObjectModule", &g_define_type_info, 0);
	}
	return vala_gobject_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




