/* valasemanticanalyzer.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valasemanticanalyzer.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <gee/collection.h>
#include <gee/arraylist.h>
#include <vala/valacodecontext.h>
#include <vala/valasymbol.h>
#include <vala/valasourcefile.h>
#include <vala/valascope.h>
#include <vala/valaclass.h>
#include <vala/valadatatype.h>
#include <vala/valagenerictype.h>
#include <vala/valatypesymbol.h>
#include <vala/valapointertype.h>
#include <vala/valainterface.h>
#include <vala/valareferencetype.h>
#include <vala/valaobjecttype.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <vala/valastruct.h>
#include <vala/valacreationmethod.h>
#include <vala/valamethod.h>
#include <vala/valamember.h>
#include <vala/valaconstructor.h>
#include <vala/valadestructor.h>
#include <vala/valaproperty.h>
#include <vala/valaexpression.h>
#include <vala/valamethodtype.h>
#include <vala/valaformalparameter.h>
#include <vala/valadelegatetype.h>
#include <vala/valanullliteral.h>
#include <vala/valanulltype.h>
#include <vala/valaunaryexpression.h>
#include <vala/valamethodcall.h>
#include <vala/valaobjectcreationexpression.h>
#include <vala/valastringliteral.h>
#include <vala/valamemberinitializer.h>
#include <vala/valafield.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaconstant.h>
#include <vala/valalocalvariable.h>
#include <vala/valaenumvalue.h>
#include <vala/valavaluetype.h>
#include <vala/valasignal.h>
#include <vala/valasignaltype.h>
#include <vala/valaenum.h>
#include <vala/valaerrordomain.h>
#include <vala/valaerrortype.h>
#include <vala/valaerrorcode.h>
#include <vala/valainvalidtype.h>
#include <vala/valanamespace.h>




struct _ValaSemanticAnalyzerPrivate {
	ValaCodeContext* _context;
	ValaSymbol* _current_symbol;
	ValaSourceFile* _current_source_file;
};

#define VALA_SEMANTIC_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerPrivate))
enum  {
	VALA_SEMANTIC_ANALYZER_DUMMY_PROPERTY
};
static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file);
static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self, ValaExpression* arg, gint i, ValaParameterDirection direction);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference);
static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaTypeSymbol* type_symbol, ValaCodeNode* node_reference);
static gpointer vala_semantic_analyzer_parent_class = NULL;
static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj);



ValaSemanticAnalyzer* vala_semantic_analyzer_construct (GType object_type) {
	ValaSemanticAnalyzer* self;
	self = (ValaSemanticAnalyzer*) g_type_create_instance (object_type);
	return self;
}


ValaSemanticAnalyzer* vala_semantic_analyzer_new (void) {
	return vala_semantic_analyzer_construct (VALA_TYPE_SEMANTIC_ANALYZER);
}


/**
 * Analyze and check code in the specified context.
 *
 * @param context a code context
 */
void vala_semantic_analyzer_analyze (ValaSemanticAnalyzer* self, ValaCodeContext* context) {
	ValaSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaDataType* _tmp3;
	ValaTypeSymbol* _tmp2;
	ValaDataType* _tmp5;
	ValaClass* _tmp4;
	ValaDataType* _tmp7;
	ValaTypeSymbol* _tmp6;
	ValaDataType* _tmp9;
	ValaTypeSymbol* _tmp8;
	ValaDataType* _tmp11;
	ValaTypeSymbol* _tmp10;
	ValaDataType* _tmp13;
	ValaTypeSymbol* _tmp12;
	ValaDataType* _tmp15;
	ValaTypeSymbol* _tmp14;
	ValaDataType* _tmp17;
	ValaTypeSymbol* _tmp16;
	ValaDataType* _tmp19;
	ValaTypeSymbol* _tmp18;
	ValaDataType* _tmp21;
	ValaTypeSymbol* _tmp20;
	ValaDataType* _tmp23;
	ValaTypeSymbol* _tmp22;
	ValaDataType* _tmp25;
	ValaTypeSymbol* _tmp24;
	ValaDataType* _tmp27;
	ValaTypeSymbol* _tmp26;
	ValaDataType* _tmp29;
	ValaTypeSymbol* _tmp28;
	ValaDataType* _tmp31;
	ValaTypeSymbol* _tmp30;
	ValaSymbol* glib_ns;
	ValaSymbol* gee_ns;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	vala_semantic_analyzer_set_context (self, context);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->root_symbol = (_tmp1 = (_tmp0 = (ValaSymbol*) vala_code_context_get_root (context), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0)), (self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL)), _tmp1);
	_tmp3 = NULL;
	_tmp2 = NULL;
	self->bool_type = (_tmp3 = (ValaDataType*) vala_value_type_new (_tmp2 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "bool"))), (self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL)), _tmp3);
	(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL));
	_tmp5 = NULL;
	_tmp4 = NULL;
	self->string_type = (_tmp5 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp4 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "string")))), (self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL)), _tmp5);
	(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL));
	_tmp7 = NULL;
	_tmp6 = NULL;
	self->uchar_type = (_tmp7 = (ValaDataType*) vala_value_type_new (_tmp6 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uchar"))), (self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL)), _tmp7);
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
	_tmp9 = NULL;
	_tmp8 = NULL;
	self->short_type = (_tmp9 = (ValaDataType*) vala_value_type_new (_tmp8 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "short"))), (self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL)), _tmp9);
	(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
	_tmp11 = NULL;
	_tmp10 = NULL;
	self->ushort_type = (_tmp11 = (ValaDataType*) vala_value_type_new (_tmp10 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ushort"))), (self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL)), _tmp11);
	(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_code_node_unref (_tmp10), NULL));
	_tmp13 = NULL;
	_tmp12 = NULL;
	self->int_type = (_tmp13 = (ValaDataType*) vala_value_type_new (_tmp12 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int"))), (self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL)), _tmp13);
	(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL));
	_tmp15 = NULL;
	_tmp14 = NULL;
	self->uint_type = (_tmp15 = (ValaDataType*) vala_value_type_new (_tmp14 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint"))), (self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL)), _tmp15);
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL));
	_tmp17 = NULL;
	_tmp16 = NULL;
	self->long_type = (_tmp17 = (ValaDataType*) vala_value_type_new (_tmp16 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "long"))), (self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL)), _tmp17);
	(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_code_node_unref (_tmp16), NULL));
	_tmp19 = NULL;
	_tmp18 = NULL;
	self->ulong_type = (_tmp19 = (ValaDataType*) vala_value_type_new (_tmp18 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ulong"))), (self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL)), _tmp19);
	(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL));
	_tmp21 = NULL;
	_tmp20 = NULL;
	self->size_t_type = (_tmp21 = (ValaDataType*) vala_value_type_new (_tmp20 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "size_t"))), (self->size_t_type == NULL) ? NULL : (self->size_t_type = (vala_code_node_unref (self->size_t_type), NULL)), _tmp21);
	(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_code_node_unref (_tmp20), NULL));
	_tmp23 = NULL;
	_tmp22 = NULL;
	self->ssize_t_type = (_tmp23 = (ValaDataType*) vala_value_type_new (_tmp22 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "ssize_t"))), (self->ssize_t_type == NULL) ? NULL : (self->ssize_t_type = (vala_code_node_unref (self->ssize_t_type), NULL)), _tmp23);
	(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL));
	_tmp25 = NULL;
	_tmp24 = NULL;
	self->uint64_type = (_tmp25 = (ValaDataType*) vala_value_type_new (_tmp24 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "uint64"))), (self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL)), _tmp25);
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_code_node_unref (_tmp24), NULL));
	_tmp27 = NULL;
	_tmp26 = NULL;
	self->int8_type = (_tmp27 = (ValaDataType*) vala_value_type_new (_tmp26 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "int8"))), (self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL)), _tmp27);
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_code_node_unref (_tmp26), NULL));
	_tmp29 = NULL;
	_tmp28 = NULL;
	self->unichar_type = (_tmp29 = (ValaDataType*) vala_value_type_new (_tmp28 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "unichar"))), (self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL)), _tmp29);
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_code_node_unref (_tmp28), NULL));
	_tmp31 = NULL;
	_tmp30 = NULL;
	self->double_type = (_tmp31 = (ValaDataType*) vala_value_type_new (_tmp30 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "double"))), (self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL)), _tmp31);
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL));
	/* TODO: don't require GLib namespace in semantic analyzer*/
	glib_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "GLib");
	if (glib_ns != NULL) {
		ValaClass* _tmp32;
		ValaTypeSymbol* _tmp33;
		ValaDataType* _tmp35;
		ValaTypeSymbol* _tmp34;
		ValaDataType* _tmp37;
		ValaClass* _tmp36;
		ValaDataType* _tmp39;
		ValaClass* _tmp38;
		ValaDataType* _tmp41;
		ValaClass* _tmp40;
		ValaClass* _tmp42;
		_tmp32 = NULL;
		self->object_type = (_tmp32 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Object")), (self->object_type == NULL) ? NULL : (self->object_type = (vala_code_node_unref (self->object_type), NULL)), _tmp32);
		_tmp33 = NULL;
		self->initially_unowned_type = (_tmp33 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "InitiallyUnowned")), (self->initially_unowned_type == NULL) ? NULL : (self->initially_unowned_type = (vala_code_node_unref (self->initially_unowned_type), NULL)), _tmp33);
		_tmp35 = NULL;
		_tmp34 = NULL;
		self->type_type = (_tmp35 = (ValaDataType*) vala_value_type_new (_tmp34 = VALA_TYPESYMBOL (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Type"))), (self->type_type == NULL) ? NULL : (self->type_type = (vala_code_node_unref (self->type_type), NULL)), _tmp35);
		(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_code_node_unref (_tmp34), NULL));
		_tmp37 = NULL;
		_tmp36 = NULL;
		self->glist_type = (_tmp37 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp36 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "List")))), (self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL)), _tmp37);
		(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_code_node_unref (_tmp36), NULL));
		_tmp39 = NULL;
		_tmp38 = NULL;
		self->gslist_type = (_tmp39 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp38 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "SList")))), (self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL)), _tmp39);
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_code_node_unref (_tmp38), NULL));
		_tmp41 = NULL;
		_tmp40 = NULL;
		self->garray_type = (_tmp41 = (ValaDataType*) vala_object_type_new ((ValaObjectTypeSymbol*) (_tmp40 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Array")))), (self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL)), _tmp41);
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_code_node_unref (_tmp40), NULL));
		_tmp42 = NULL;
		self->gerror_type = (_tmp42 = VALA_CLASS (vala_scope_lookup (vala_symbol_get_scope (glib_ns), "Error")), (self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL)), _tmp42);
	}
	gee_ns = vala_scope_lookup (vala_symbol_get_scope (self->root_symbol), "Gee");
	if (gee_ns != NULL) {
		ValaInterface* _tmp43;
		ValaInterface* _tmp44;
		_tmp43 = NULL;
		self->list_type = (_tmp43 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "List")), (self->list_type == NULL) ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL)), _tmp43);
		_tmp44 = NULL;
		self->map_type = (_tmp44 = VALA_INTERFACE (vala_scope_lookup (vala_symbol_get_scope (gee_ns), "Map")), (self->map_type == NULL) ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL)), _tmp44);
	}
	vala_semantic_analyzer_set_current_symbol (self, self->root_symbol);
	vala_code_node_check ((ValaCodeNode*) vala_code_context_get_root (context), self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	(glib_ns == NULL) ? NULL : (glib_ns = (vala_code_node_unref (glib_ns), NULL));
	(gee_ns == NULL) ? NULL : (gee_ns = (vala_code_node_unref (gee_ns), NULL));
}


static void vala_semantic_analyzer_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* file) {
	ValaSemanticAnalyzer * self;
	self = (ValaSemanticAnalyzer*) base;
	g_return_if_fail (file != NULL);
	vala_semantic_analyzer_set_current_source_file (self, file);
	self->next_lambda_id = 0;
	vala_source_file_check (file, self);
}


/* check whether type is at least as accessible as the specified symbol*/
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	{
		GeeList* _tmp0;
		GeeIterator* _tmp1;
		GeeIterator* type_symbol_it;
		_tmp0 = NULL;
		_tmp1 = NULL;
		type_symbol_it = (_tmp1 = gee_iterable_iterator ((GeeIterable*) (_tmp0 = vala_data_type_get_symbols (type))), (_tmp0 == NULL) ? NULL : (_tmp0 = (gee_collection_object_unref (_tmp0), NULL)), _tmp1);
		while (gee_iterator_next (type_symbol_it)) {
			ValaSymbol* type_symbol;
			ValaScope* method_scope;
			ValaScope* type_scope;
			gboolean _tmp2;
			gboolean _tmp3;
			type_symbol = (ValaSymbol*) gee_iterator_get (type_symbol_it);
			method_scope = vala_symbol_get_top_accessible_scope (sym);
			type_scope = vala_symbol_get_top_accessible_scope (type_symbol);
			_tmp2 = FALSE;
			_tmp3 = FALSE;
			if (method_scope == NULL) {
				_tmp3 = type_scope != NULL;
			} else {
				_tmp3 = FALSE;
			}
			if ((_tmp3)) {
				_tmp2 = TRUE;
			} else {
				gboolean _tmp4;
				_tmp4 = FALSE;
				if (method_scope != NULL) {
					_tmp4 = !vala_scope_is_subscope_of (method_scope, type_scope);
				} else {
					_tmp4 = FALSE;
				}
				_tmp2 = (_tmp4);
			}
			if (_tmp2) {
				gboolean _tmp5;
				return (_tmp5 = FALSE, (type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL)), (method_scope == NULL) ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL)), (type_scope == NULL) ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL)), (type_symbol_it == NULL) ? NULL : (type_symbol_it = (gee_collection_object_unref (type_symbol_it), NULL)), _tmp5);
			}
			(type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL));
			(method_scope == NULL) ? NULL : (method_scope = (vala_scope_unref (method_scope), NULL));
			(type_scope == NULL) ? NULL : (type_scope = (vala_scope_unref (type_scope), NULL));
		}
		(type_symbol_it == NULL) ? NULL : (type_symbol_it = (gee_collection_object_unref (type_symbol_it), NULL));
	}
	return TRUE;
}


ValaDataType* vala_semantic_analyzer_get_value_type_for_symbol (ValaSemanticAnalyzer* self, ValaSymbol* sym, gboolean lvalue) {
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	if (VALA_IS_FIELD (sym)) {
		ValaField* _tmp0;
		ValaField* f;
		ValaDataType* type;
		ValaDataType* _tmp1;
		_tmp0 = NULL;
		f = (_tmp0 = VALA_FIELD (sym), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
		type = vala_data_type_copy (vala_field_get_field_type (f));
		if (!lvalue) {
			vala_data_type_set_value_owned (type, FALSE);
		}
		_tmp1 = NULL;
		return (_tmp1 = type, (f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL)), _tmp1);
	} else {
		if (VALA_IS_CONSTANT (sym)) {
			ValaConstant* _tmp2;
			ValaConstant* c;
			ValaDataType* _tmp3;
			ValaDataType* _tmp4;
			_tmp2 = NULL;
			c = (_tmp2 = VALA_CONSTANT (sym), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
			_tmp3 = NULL;
			_tmp4 = NULL;
			return (_tmp4 = (_tmp3 = vala_constant_get_type_reference (c), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL)), _tmp4);
		} else {
			if (VALA_IS_PROPERTY (sym)) {
				ValaProperty* _tmp5;
				ValaProperty* prop;
				_tmp5 = NULL;
				prop = (_tmp5 = VALA_PROPERTY (sym), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
				if (vala_property_get_property_type (prop) != NULL) {
					ValaDataType* type;
					ValaDataType* _tmp6;
					type = vala_data_type_copy (vala_property_get_property_type (prop));
					vala_data_type_set_value_owned (type, FALSE);
					_tmp6 = NULL;
					return (_tmp6 = type, (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp6);
				}
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
			} else {
				if (VALA_IS_FORMAL_PARAMETER (sym)) {
					ValaFormalParameter* _tmp7;
					ValaFormalParameter* p;
					ValaDataType* type;
					ValaDataType* _tmp8;
					_tmp7 = NULL;
					p = (_tmp7 = VALA_FORMAL_PARAMETER (sym), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
					type = vala_data_type_copy (vala_formal_parameter_get_parameter_type (p));
					if (!lvalue) {
						vala_data_type_set_value_owned (type, FALSE);
					}
					_tmp8 = NULL;
					return (_tmp8 = type, (p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL)), _tmp8);
				} else {
					if (VALA_IS_LOCAL_VARIABLE (sym)) {
						ValaLocalVariable* _tmp9;
						ValaLocalVariable* local;
						ValaDataType* type;
						gboolean _tmp10;
						ValaDataType* _tmp11;
						_tmp9 = NULL;
						local = (_tmp9 = VALA_LOCAL_VARIABLE (sym), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
						type = vala_data_type_copy (vala_local_variable_get_variable_type (local));
						_tmp10 = FALSE;
						if (!lvalue) {
							_tmp10 = !vala_local_variable_get_floating (local);
						} else {
							_tmp10 = FALSE;
						}
						if (_tmp10) {
							vala_data_type_set_value_owned (type, FALSE);
						}
						_tmp11 = NULL;
						return (_tmp11 = type, (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), _tmp11);
					} else {
						if (VALA_IS_ENUM_VALUE (sym)) {
							return (ValaDataType*) vala_value_type_new (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (sym)));
						} else {
							if (VALA_IS_METHOD (sym)) {
								return (ValaDataType*) vala_method_type_new (VALA_METHOD (sym));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									return (ValaDataType*) vala_signal_type_new (VALA_SIGNAL (sym));
								}
							}
						}
					}
				}
			}
		}
	}
	return NULL;
}


ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name) {
	ValaSymbol* result;
	ValaSymbol* _tmp21;
	g_return_val_if_fail (sym != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	result = vala_scope_lookup (vala_symbol_get_scope (sym), name);
	if (result != NULL) {
		return result;
	}
	if (VALA_IS_CLASS (sym)) {
		ValaClass* _tmp1;
		ValaClass* cl;
		_tmp1 = NULL;
		cl = (_tmp1 = VALA_CLASS (sym), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* _tmp2;
			GeeIterator* _tmp3;
			GeeIterator* base_type_it;
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			_tmp2 = NULL;
			_tmp3 = NULL;
			base_type_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_class_get_base_types (cl))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			while (gee_iterator_next (base_type_it)) {
				ValaDataType* base_type;
				/* first check interfaces without prerequisites
				 (prerequisites can be assumed to be met already)*/
				base_type = (ValaDataType*) gee_iterator_get (base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaSymbol* _tmp4;
					_tmp4 = NULL;
					result = (_tmp4 = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (base_type)), name), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp4);
					if (result != NULL) {
						ValaSymbol* _tmp5;
						_tmp5 = NULL;
						return (_tmp5 = result, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), _tmp5);
					}
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
		}
		/* then check base class recursively*/
		if (vala_class_get_base_class (cl) != NULL) {
			ValaSymbol* _tmp6;
			_tmp6 = NULL;
			return (_tmp6 = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_class_get_base_class (cl), name), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp6);
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaStruct* _tmp7;
			ValaStruct* st;
			_tmp7 = NULL;
			st = (_tmp7 = VALA_STRUCT (sym), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7));
			{
				GeeList* _tmp8;
				GeeIterator* _tmp9;
				GeeIterator* base_type_it;
				_tmp8 = NULL;
				_tmp9 = NULL;
				base_type_it = (_tmp9 = gee_iterable_iterator ((GeeIterable*) (_tmp8 = vala_struct_get_base_types (st))), (_tmp8 == NULL) ? NULL : (_tmp8 = (gee_collection_object_unref (_tmp8), NULL)), _tmp9);
				while (gee_iterator_next (base_type_it)) {
					ValaDataType* base_type;
					ValaSymbol* _tmp10;
					base_type = (ValaDataType*) gee_iterator_get (base_type_it);
					_tmp10 = NULL;
					result = (_tmp10 = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (base_type), name), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp10);
					if (result != NULL) {
						ValaSymbol* _tmp11;
						_tmp11 = NULL;
						return (_tmp11 = result, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), _tmp11);
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
				(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			if (VALA_IS_INTERFACE (sym)) {
				ValaInterface* _tmp12;
				ValaInterface* iface;
				_tmp12 = NULL;
				iface = (_tmp12 = VALA_INTERFACE (sym), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
				/* first check interface prerequisites recursively*/
				{
					GeeList* _tmp13;
					GeeIterator* _tmp14;
					GeeIterator* prerequisite_it;
					/* first check interface prerequisites recursively*/
					_tmp13 = NULL;
					_tmp14 = NULL;
					prerequisite_it = (_tmp14 = gee_iterable_iterator ((GeeIterable*) (_tmp13 = vala_interface_get_prerequisites (iface))), (_tmp13 == NULL) ? NULL : (_tmp13 = (gee_collection_object_unref (_tmp13), NULL)), _tmp14);
					/* first check interface prerequisites recursively*/
					while (gee_iterator_next (prerequisite_it)) {
						ValaDataType* prerequisite;
						/* first check interface prerequisites recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (prerequisite_it);
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
							ValaSymbol* _tmp15;
							_tmp15 = NULL;
							result = (_tmp15 = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (prerequisite), name), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp15);
							if (result != NULL) {
								ValaSymbol* _tmp16;
								_tmp16 = NULL;
								return (_tmp16 = result, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp16);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL));
				}
				/* then check class prerequisite recursively*/
				{
					GeeList* _tmp17;
					GeeIterator* _tmp18;
					GeeIterator* prerequisite_it;
					/* then check class prerequisite recursively*/
					_tmp17 = NULL;
					_tmp18 = NULL;
					prerequisite_it = (_tmp18 = gee_iterable_iterator ((GeeIterable*) (_tmp17 = vala_interface_get_prerequisites (iface))), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp18);
					/* then check class prerequisite recursively*/
					while (gee_iterator_next (prerequisite_it)) {
						ValaDataType* prerequisite;
						/* then check class prerequisite recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (prerequisite_it);
						if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
							ValaSymbol* _tmp19;
							_tmp19 = NULL;
							result = (_tmp19 = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (prerequisite), name), (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp19);
							if (result != NULL) {
								ValaSymbol* _tmp20;
								_tmp20 = NULL;
								return (_tmp20 = result, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), _tmp20);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL));
				}
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			}
		}
	}
	_tmp21 = NULL;
	return (_tmp21 = NULL, (result == NULL) ? NULL : (result = (vala_code_node_unref (result), NULL)), _tmp21);
}


ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym) {
	ValaDataType* type;
	g_return_val_if_fail (sym != NULL, NULL);
	type = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		ValaDataType* _tmp0;
		_tmp0 = NULL;
		type = (_tmp0 = (ValaDataType*) vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp0);
	} else {
		if (VALA_IS_STRUCT (sym)) {
			ValaDataType* _tmp1;
			_tmp1 = NULL;
			type = (_tmp1 = (ValaDataType*) vala_value_type_new ((ValaTypeSymbol*) VALA_STRUCT (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp1);
		} else {
			if (VALA_IS_ENUM (sym)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				type = (_tmp2 = (ValaDataType*) vala_value_type_new ((ValaTypeSymbol*) VALA_ENUM (sym)), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp2);
			} else {
				if (VALA_IS_ERROR_DOMAIN (sym)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					type = (_tmp3 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (sym), NULL, NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp3);
				} else {
					if (VALA_IS_ERROR_CODE (sym)) {
						ValaDataType* _tmp4;
						_tmp4 = NULL;
						type = (_tmp4 = (ValaDataType*) vala_error_type_new (VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol ((ValaSymbol*) sym)), VALA_ERROR_CODE (sym), NULL), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp4);
					} else {
						char* _tmp6;
						char* _tmp5;
						ValaDataType* _tmp7;
						_tmp6 = NULL;
						_tmp5 = NULL;
						vala_report_error (NULL, _tmp6 = g_strdup_printf ("internal error: `%s' is not a supported type", _tmp5 = vala_symbol_get_full_name ((ValaSymbol*) sym)));
						_tmp6 = (g_free (_tmp6), NULL);
						_tmp5 = (g_free (_tmp5), NULL);
						_tmp7 = NULL;
						return (_tmp7 = (ValaDataType*) vala_invalid_type_new (), (type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL)), _tmp7);
					}
				}
			}
		}
	}
	return type;
}


gboolean vala_semantic_analyzer_check_arguments (ValaSemanticAnalyzer* self, ValaExpression* expr, ValaDataType* mtype, GeeList* params, GeeList* args) {
	ValaExpression* prev_arg;
	GeeIterator* arg_it;
	gboolean _tmp0;
	gboolean diag;
	gboolean ellipsis;
	gint i;
	gboolean _tmp30;
	gboolean _tmp35;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (expr != NULL, FALSE);
	g_return_val_if_fail (mtype != NULL, FALSE);
	g_return_val_if_fail (params != NULL, FALSE);
	g_return_val_if_fail (args != NULL, FALSE);
	prev_arg = NULL;
	arg_it = gee_iterable_iterator ((GeeIterable*) args);
	_tmp0 = FALSE;
	if (VALA_IS_METHOD_TYPE (mtype)) {
		ValaAttribute* _tmp1;
		_tmp1 = NULL;
		_tmp0 = (_tmp1 = vala_code_node_get_attribute ((ValaCodeNode*) vala_method_type_get_method_symbol ((VALA_METHOD_TYPE (mtype))), "Diagnostics")) != NULL;
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_code_node_unref (_tmp1), NULL));
	} else {
		_tmp0 = FALSE;
	}
	diag = (_tmp0);
	ellipsis = FALSE;
	i = 0;
	{
		GeeIterator* param_it;
		param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (gee_iterator_next (param_it)) {
			ValaFormalParameter* param;
			gboolean _tmp4;
			param = (ValaFormalParameter*) gee_iterator_get (param_it);
			if (!vala_code_node_check ((ValaCodeNode*) param, self)) {
				gboolean _tmp2;
				return (_tmp2 = FALSE, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp2);
			}
			if (vala_formal_parameter_get_ellipsis (param)) {
				ellipsis = TRUE;
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			/* header file necessary if we need to cast argument */
			vala_source_file_add_type_dependency (self->priv->_current_source_file, vala_formal_parameter_get_parameter_type (param), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
			if (vala_formal_parameter_get_params_array (param)) {
				while (gee_iterator_next (arg_it)) {
					ValaExpression* arg;
					arg = (ValaExpression*) gee_iterator_get (arg_it);
					if (!vala_semantic_analyzer_check_argument (self, arg, i, vala_formal_parameter_get_direction (param))) {
						gboolean _tmp3;
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						return (_tmp3 = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp3);
					}
					i++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				break;
			}
			_tmp4 = FALSE;
			if (arg_it == NULL) {
				_tmp4 = TRUE;
			} else {
				_tmp4 = !gee_iterator_next (arg_it);
			}
			if (_tmp4) {
				if (vala_formal_parameter_get_default_expression (param) == NULL) {
					char* _tmp6;
					char* _tmp5;
					gboolean _tmp7;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					_tmp6 = NULL;
					_tmp5 = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp6 = g_strdup_printf ("Too few arguments, method `%s' does not take %d arguments", _tmp5 = vala_code_node_to_string ((ValaCodeNode*) mtype), gee_collection_get_size ((GeeCollection*) args)));
					_tmp6 = (g_free (_tmp6), NULL);
					_tmp5 = (g_free (_tmp5), NULL);
					return (_tmp7 = FALSE, (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp7);
				} else {
					ValaMethodCall* _tmp9;
					ValaExpression* _tmp8;
					ValaMethodCall* invocation_expr;
					ValaObjectCreationExpression* _tmp11;
					ValaExpression* _tmp10;
					ValaObjectCreationExpression* object_creation_expr;
					GeeIterator* _tmp12;
					_tmp9 = NULL;
					_tmp8 = NULL;
					invocation_expr = (_tmp9 = (_tmp8 = expr, VALA_IS_METHOD_CALL (_tmp8) ? ((ValaMethodCall*) _tmp8) : NULL), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
					_tmp11 = NULL;
					_tmp10 = NULL;
					object_creation_expr = (_tmp11 = (_tmp10 = expr, VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp10) ? ((ValaObjectCreationExpression*) _tmp10) : NULL), (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11));
					if (invocation_expr != NULL) {
						vala_method_call_add_argument (invocation_expr, vala_formal_parameter_get_default_expression (param));
					} else {
						if (object_creation_expr != NULL) {
							vala_object_creation_expression_add_argument (object_creation_expr, vala_formal_parameter_get_default_expression (param));
						} else {
							g_assert_not_reached ();
						}
					}
					_tmp12 = NULL;
					arg_it = (_tmp12 = NULL, (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp12);
					(invocation_expr == NULL) ? NULL : (invocation_expr = (vala_code_node_unref (invocation_expr), NULL));
					(object_creation_expr == NULL) ? NULL : (object_creation_expr = (vala_code_node_unref (object_creation_expr), NULL));
				}
			} else {
				ValaExpression* arg;
				ValaExpression* _tmp15;
				ValaExpression* _tmp14;
				arg = (ValaExpression*) gee_iterator_get (arg_it);
				if (!vala_semantic_analyzer_check_argument (self, arg, i, vala_formal_parameter_get_direction (param))) {
					gboolean _tmp13;
					vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
					return (_tmp13 = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL)), (param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp13);
				}
				_tmp15 = NULL;
				_tmp14 = NULL;
				prev_arg = (_tmp15 = (_tmp14 = arg, (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), _tmp15);
				i++;
				(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(param_it == NULL) ? NULL : (param_it = (gee_collection_object_unref (param_it), NULL));
	}
	if (ellipsis) {
		while (TRUE) {
			gboolean _tmp16;
			ValaExpression* arg;
			_tmp16 = FALSE;
			if (arg_it != NULL) {
				_tmp16 = gee_iterator_next (arg_it);
			} else {
				_tmp16 = FALSE;
			}
			if (!_tmp16) {
				break;
			}
			arg = (ValaExpression*) gee_iterator_get (arg_it);
			if (vala_code_node_get_error ((ValaCodeNode*) arg)) {
				gboolean _tmp17;
				/* ignore inner error*/
				vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
				return (_tmp17 = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp17);
			} else {
				if (vala_expression_get_value_type (arg) == NULL) {
					/* disallow untyped arguments except for type inference of callbacks*/
					if (!(VALA_IS_METHOD (vala_expression_get_symbol_reference (arg)))) {
						char* _tmp18;
						gboolean _tmp19;
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_tmp18 = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp18 = g_strdup_printf ("Invalid type for argument %d", i + 1));
						_tmp18 = (g_free (_tmp18), NULL);
						return (_tmp19 = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp19);
					}
				} else {
					gboolean _tmp20;
					_tmp20 = FALSE;
					if (vala_expression_get_target_type (arg) != NULL) {
						_tmp20 = !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg));
					} else {
						_tmp20 = FALSE;
					}
					if (_tmp20) {
						char* _tmp23;
						char* _tmp22;
						char* _tmp21;
						gboolean _tmp24;
						/* target_type known for printf arguments*/
						vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
						_tmp23 = NULL;
						_tmp22 = NULL;
						_tmp21 = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp23 = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp21 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (arg)), _tmp22 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type (arg))));
						_tmp23 = (g_free (_tmp23), NULL);
						_tmp22 = (g_free (_tmp22), NULL);
						_tmp21 = (g_free (_tmp21), NULL);
						return (_tmp24 = FALSE, (arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL)), (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp24);
					}
				}
			}
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
		}
	} else {
		gboolean _tmp25;
		gboolean _tmp26;
		_tmp25 = FALSE;
		_tmp26 = FALSE;
		if (!ellipsis) {
			_tmp26 = arg_it != NULL;
		} else {
			_tmp26 = FALSE;
		}
		if (_tmp26) {
			_tmp25 = gee_iterator_next (arg_it);
		} else {
			_tmp25 = FALSE;
		}
		if (_tmp25) {
			char* _tmp28;
			char* _tmp27;
			gboolean _tmp29;
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			_tmp28 = NULL;
			_tmp27 = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) expr), _tmp28 = g_strdup_printf ("Too many arguments, method `%s' does not take %d arguments", _tmp27 = vala_code_node_to_string ((ValaCodeNode*) mtype), gee_collection_get_size ((GeeCollection*) args)));
			_tmp28 = (g_free (_tmp28), NULL);
			_tmp27 = (g_free (_tmp27), NULL);
			return (_tmp29 = FALSE, (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp29);
		}
	}
	_tmp30 = FALSE;
	if (diag) {
		_tmp30 = prev_arg != NULL;
	} else {
		_tmp30 = FALSE;
	}
	if (_tmp30) {
		ValaStringLiteral* _tmp32;
		ValaExpression* _tmp31;
		ValaStringLiteral* format_arg;
		_tmp32 = NULL;
		_tmp31 = NULL;
		format_arg = (_tmp32 = (_tmp31 = prev_arg, VALA_IS_STRING_LITERAL (_tmp31) ? ((ValaStringLiteral*) _tmp31) : NULL), (_tmp32 == NULL) ? NULL : vala_code_node_ref (_tmp32));
		if (format_arg != NULL) {
			char* _tmp34;
			char* _tmp33;
			_tmp34 = NULL;
			_tmp33 = NULL;
			vala_string_literal_set_value (format_arg, _tmp34 = g_strdup_printf ("\"%s:%d: %s", _tmp33 = g_path_get_basename (vala_source_file_get_filename (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) expr)))), vala_source_reference_get_first_line (vala_code_node_get_source_reference ((ValaCodeNode*) expr)), g_utf8_offset_to_pointer (vala_string_literal_get_value (format_arg), (glong) 1)));
			_tmp34 = (g_free (_tmp34), NULL);
			_tmp33 = (g_free (_tmp33), NULL);
		}
		(format_arg == NULL) ? NULL : (format_arg = (vala_code_node_unref (format_arg), NULL));
	}
	return (_tmp35 = TRUE, (prev_arg == NULL) ? NULL : (prev_arg = (vala_code_node_unref (prev_arg), NULL)), (arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL)), _tmp35);
}


static gboolean vala_semantic_analyzer_check_argument (ValaSemanticAnalyzer* self, ValaExpression* arg, gint i, ValaParameterDirection direction) {
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (arg != NULL, FALSE);
	if (vala_code_node_get_error ((ValaCodeNode*) arg)) {
		/* ignore inner error*/
		return FALSE;
	} else {
		if (vala_expression_get_value_type (arg) == NULL) {
			gboolean _tmp1;
			_tmp1 = FALSE;
			if (!(VALA_IS_DELEGATE_TYPE (vala_expression_get_target_type (arg)))) {
				_tmp1 = TRUE;
			} else {
				_tmp1 = !(VALA_IS_METHOD (vala_expression_get_symbol_reference (arg)));
			}
			/* disallow untyped arguments except for type inference of callbacks*/
			if (_tmp1) {
				char* _tmp2;
				_tmp2 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp2 = g_strdup_printf ("Invalid type for argument %d", i + 1));
				_tmp2 = (g_free (_tmp2), NULL);
				return FALSE;
			}
		} else {
			gboolean _tmp4;
			gboolean _tmp5;
			_tmp4 = FALSE;
			_tmp5 = FALSE;
			if (vala_expression_get_target_type (arg) != NULL) {
				_tmp5 = !vala_data_type_compatible (vala_expression_get_value_type (arg), vala_expression_get_target_type (arg));
			} else {
				_tmp5 = FALSE;
			}
			if (_tmp5) {
				gboolean _tmp6;
				_tmp6 = FALSE;
				if (VALA_IS_NULL_LITERAL (arg)) {
					_tmp6 = direction == VALA_PARAMETER_DIRECTION_OUT;
				} else {
					_tmp6 = FALSE;
				}
				_tmp4 = !(_tmp6);
			} else {
				_tmp4 = FALSE;
			}
			if (_tmp4) {
				char* _tmp9;
				char* _tmp8;
				char* _tmp7;
				_tmp9 = NULL;
				_tmp8 = NULL;
				_tmp7 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp9 = g_strdup_printf ("Argument %d: Cannot convert from `%s' to `%s'", i + 1, _tmp7 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_value_type (arg)), _tmp8 = vala_code_node_to_string ((ValaCodeNode*) vala_expression_get_target_type (arg))));
				_tmp9 = (g_free (_tmp9), NULL);
				_tmp8 = (g_free (_tmp8), NULL);
				_tmp7 = (g_free (_tmp7), NULL);
				return FALSE;
			} else {
				gint arg_type;
				/* 0 => null, 1 => in, 2 => ref, 3 => out*/
				arg_type = 1;
				if (VALA_IS_NULL_TYPE (vala_expression_get_value_type (arg))) {
					arg_type = 0;
				} else {
					if (VALA_IS_UNARY_EXPRESSION (arg)) {
						ValaUnaryExpression* _tmp11;
						ValaUnaryExpression* unary;
						_tmp11 = NULL;
						unary = (_tmp11 = VALA_UNARY_EXPRESSION (arg), (_tmp11 == NULL) ? NULL : vala_code_node_ref (_tmp11));
						if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF) {
							arg_type = 2;
						} else {
							if (vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT) {
								arg_type = 3;
							}
						}
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
					}
				}
				if (arg_type == 0) {
					if (direction == VALA_PARAMETER_DIRECTION_REF) {
						char* _tmp12;
						_tmp12 = NULL;
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp12 = g_strdup_printf ("Argument %d: Cannot pass null to reference parameter", i + 1));
						_tmp12 = (g_free (_tmp12), NULL);
						return FALSE;
					} else {
						gboolean _tmp14;
						gboolean _tmp15;
						_tmp14 = FALSE;
						_tmp15 = FALSE;
						if (vala_code_context_get_non_null (self->priv->_context)) {
							_tmp15 = direction != VALA_PARAMETER_DIRECTION_OUT;
						} else {
							_tmp15 = FALSE;
						}
						if (_tmp15) {
							_tmp14 = !vala_data_type_get_nullable (vala_expression_get_target_type (arg));
						} else {
							_tmp14 = FALSE;
						}
						if (_tmp14) {
							char* _tmp16;
							_tmp16 = NULL;
							vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp16 = g_strdup_printf ("Argument %d: Cannot pass null to non-null parameter type", i + 1));
							_tmp16 = (g_free (_tmp16), NULL);
						}
					}
				} else {
					if (arg_type == 1) {
						if (direction != VALA_PARAMETER_DIRECTION_IN) {
							char* _tmp17;
							_tmp17 = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp17 = g_strdup_printf ("Argument %d: Cannot pass value to reference or output parameter", i + 1));
							_tmp17 = (g_free (_tmp17), NULL);
							return FALSE;
						}
					} else {
						if (arg_type == 2) {
							if (direction != VALA_PARAMETER_DIRECTION_REF) {
								char* _tmp19;
								_tmp19 = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp19 = g_strdup_printf ("Argument %d: Cannot pass ref argument to non-reference parameter", i + 1));
								_tmp19 = (g_free (_tmp19), NULL);
								return FALSE;
							}
							/* weak variables can only be used with weak ref parameters*/
							if (vala_data_type_is_disposable (vala_expression_get_target_type (arg))) {
								gboolean _tmp21;
								_tmp21 = FALSE;
								if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg)))) {
									_tmp21 = !vala_data_type_get_value_owned (vala_expression_get_value_type (arg));
								} else {
									_tmp21 = FALSE;
								}
								if (_tmp21) {
									/* variable doesn't own the value */
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), "Invalid assignment from owned expression to unowned variable");
									return FALSE;
								}
							}
						} else {
							if (arg_type == 3) {
								if (direction != VALA_PARAMETER_DIRECTION_OUT) {
									char* _tmp23;
									_tmp23 = NULL;
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), _tmp23 = g_strdup_printf ("Argument %d: Cannot pass out argument to non-output parameter", i + 1));
									_tmp23 = (g_free (_tmp23), NULL);
									return FALSE;
								}
								/* weak variables can only be used with weak out parameters*/
								if (vala_data_type_is_disposable (vala_expression_get_target_type (arg))) {
									gboolean _tmp25;
									_tmp25 = FALSE;
									if (!(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (arg)))) {
										_tmp25 = !vala_data_type_get_value_owned (vala_expression_get_value_type (arg));
									} else {
										_tmp25 = FALSE;
									}
									if (_tmp25) {
										/* variable doesn't own the value */
										vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) arg), "Invalid assignment from owned expression to unowned variable");
										return FALSE;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	return TRUE;
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type (ValaDataType* instance_type, ValaDataType* base_type, ValaCodeNode* node_reference) {
	ValaReferenceType* instance_base_type;
	g_return_val_if_fail (instance_type != NULL, NULL);
	g_return_val_if_fail (base_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* construct a new type reference for the base type with correctly linked type arguments*/
	instance_base_type = NULL;
	if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
		ValaReferenceType* _tmp0;
		_tmp0 = NULL;
		instance_base_type = (_tmp0 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_CLASS (vala_data_type_get_data_type (base_type))), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp0);
	} else {
		ValaReferenceType* _tmp1;
		_tmp1 = NULL;
		instance_base_type = (_tmp1 = (ValaReferenceType*) vala_object_type_new ((ValaObjectTypeSymbol*) VALA_INTERFACE (vala_data_type_get_data_type (base_type))), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp1);
	}
	{
		GeeList* _tmp2;
		GeeIterator* _tmp3;
		GeeIterator* type_arg_it;
		_tmp2 = NULL;
		_tmp3 = NULL;
		type_arg_it = (_tmp3 = gee_iterable_iterator ((GeeIterable*) (_tmp2 = vala_data_type_get_type_arguments (base_type))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3);
		while (gee_iterator_next (type_arg_it)) {
			ValaDataType* type_arg;
			type_arg = (ValaDataType*) gee_iterator_get (type_arg_it);
			if (vala_data_type_get_type_parameter (type_arg) != NULL) {
				gint param_index;
				GeeList* _tmp6;
				gboolean _tmp7;
				ValaDataType* _tmp13;
				GeeList* _tmp12;
				/* link to type argument of derived type*/
				param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)));
				if (param_index == (-1)) {
					char* _tmp4;
					ValaDataType* _tmp5;
					_tmp4 = NULL;
					vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp4 = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg))));
					_tmp4 = (g_free (_tmp4), NULL);
					vala_code_node_set_error (node_reference, TRUE);
					_tmp5 = NULL;
					return (_tmp5 = NULL, (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), (type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp5);
				}
				_tmp6 = NULL;
				if ((_tmp7 = gee_collection_get_size ((GeeCollection*) (_tmp6 = vala_data_type_get_type_arguments (instance_type))) <= param_index, (_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)), _tmp7)) {
					char* _tmp10;
					char* _tmp9;
					char* _tmp8;
					ValaDataType* _tmp11;
					_tmp10 = NULL;
					_tmp9 = NULL;
					_tmp8 = NULL;
					vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp10 = g_strdup_printf ("internal error: missing type argument for type parameter `%s' in `%s'", _tmp8 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)), _tmp9 = vala_code_node_to_string ((ValaCodeNode*) instance_type)));
					_tmp10 = (g_free (_tmp10), NULL);
					_tmp9 = (g_free (_tmp9), NULL);
					_tmp8 = (g_free (_tmp8), NULL);
					vala_code_node_set_error (node_reference, TRUE);
					_tmp11 = NULL;
					return (_tmp11 = NULL, (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), (type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp11);
				}
				_tmp13 = NULL;
				_tmp12 = NULL;
				type_arg = (_tmp13 = (ValaDataType*) gee_list_get (_tmp12 = vala_data_type_get_type_arguments (instance_type), param_index), (type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL)), _tmp13);
				(_tmp12 == NULL) ? NULL : (_tmp12 = (gee_collection_object_unref (_tmp12), NULL));
			}
			vala_data_type_add_type_argument ((ValaDataType*) instance_base_type, type_arg);
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(type_arg_it == NULL) ? NULL : (type_arg_it = (gee_collection_object_unref (type_arg_it), NULL));
	}
	return (ValaDataType*) instance_base_type;
}


static ValaDataType* vala_semantic_analyzer_get_instance_base_type_for_member (ValaDataType* derived_instance_type, ValaTypeSymbol* type_symbol, ValaCodeNode* node_reference) {
	ValaDataType* _tmp0;
	ValaDataType* instance_type;
	ValaDataType* instance_base_type;
	ValaDataType* _tmp33;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (type_symbol != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	_tmp0 = NULL;
	instance_type = (_tmp0 = derived_instance_type, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	while (VALA_IS_POINTER_TYPE (instance_type)) {
		ValaPointerType* _tmp1;
		ValaPointerType* instance_pointer_type;
		ValaDataType* _tmp3;
		ValaDataType* _tmp2;
		_tmp1 = NULL;
		instance_pointer_type = (_tmp1 = VALA_POINTER_TYPE (instance_type), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
		_tmp3 = NULL;
		_tmp2 = NULL;
		instance_type = (_tmp3 = (_tmp2 = vala_pointer_type_get_base_type (instance_pointer_type), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp3);
		(instance_pointer_type == NULL) ? NULL : (instance_pointer_type = (vala_code_node_unref (instance_pointer_type), NULL));
	}
	if (vala_data_type_get_data_type (instance_type) == type_symbol) {
		return instance_type;
	}
	instance_base_type = NULL;
	/* use same algorithm as symbol_lookup_inherited*/
	if (VALA_IS_CLASS (vala_data_type_get_data_type (instance_type))) {
		ValaClass* _tmp5;
		ValaClass* cl;
		_tmp5 = NULL;
		cl = (_tmp5 = VALA_CLASS (vala_data_type_get_data_type (instance_type)), (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5));
		/* first check interfaces without prerequisites
		 (prerequisites can be assumed to be met already)*/
		{
			GeeList* _tmp6;
			GeeIterator* _tmp7;
			GeeIterator* base_type_it;
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			_tmp6 = NULL;
			_tmp7 = NULL;
			base_type_it = (_tmp7 = gee_iterable_iterator ((GeeIterable*) (_tmp6 = vala_class_get_base_types (cl))), (_tmp6 == NULL) ? NULL : (_tmp6 = (gee_collection_object_unref (_tmp6), NULL)), _tmp7);
			/* first check interfaces without prerequisites
			 (prerequisites can be assumed to be met already)*/
			while (gee_iterator_next (base_type_it)) {
				ValaDataType* base_type;
				/* first check interfaces without prerequisites
				 (prerequisites can be assumed to be met already)*/
				base_type = (ValaDataType*) gee_iterator_get (base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaDataType* _tmp9;
					ValaDataType* _tmp8;
					_tmp9 = NULL;
					_tmp8 = NULL;
					instance_base_type = (_tmp9 = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp8 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp9);
					(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
					if (instance_base_type != NULL) {
						ValaDataType* _tmp10;
						_tmp10 = NULL;
						return (_tmp10 = instance_base_type, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp10);
					}
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
		}
		/* then check base class recursively*/
		if (instance_base_type == NULL) {
			{
				GeeList* _tmp11;
				GeeIterator* _tmp12;
				GeeIterator* base_type_it;
				_tmp11 = NULL;
				_tmp12 = NULL;
				base_type_it = (_tmp12 = gee_iterable_iterator ((GeeIterable*) (_tmp11 = vala_class_get_base_types (cl))), (_tmp11 == NULL) ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL)), _tmp12);
				while (gee_iterator_next (base_type_it)) {
					ValaDataType* base_type;
					base_type = (ValaDataType*) gee_iterator_get (base_type_it);
					if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
						ValaDataType* _tmp14;
						ValaDataType* _tmp13;
						_tmp14 = NULL;
						_tmp13 = NULL;
						instance_base_type = (_tmp14 = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp13 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp14);
						(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_code_node_unref (_tmp13), NULL));
						if (instance_base_type != NULL) {
							ValaDataType* _tmp15;
							_tmp15 = NULL;
							return (_tmp15 = instance_base_type, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)), (cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp15);
						}
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
				(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
			}
		}
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		if (VALA_IS_STRUCT (vala_data_type_get_data_type (instance_type))) {
			ValaStruct* _tmp16;
			ValaStruct* st;
			_tmp16 = NULL;
			st = (_tmp16 = VALA_STRUCT (vala_data_type_get_data_type (instance_type)), (_tmp16 == NULL) ? NULL : vala_code_node_ref (_tmp16));
			{
				GeeList* _tmp17;
				GeeIterator* _tmp18;
				GeeIterator* base_type_it;
				_tmp17 = NULL;
				_tmp18 = NULL;
				base_type_it = (_tmp18 = gee_iterable_iterator ((GeeIterable*) (_tmp17 = vala_struct_get_base_types (st))), (_tmp17 == NULL) ? NULL : (_tmp17 = (gee_collection_object_unref (_tmp17), NULL)), _tmp18);
				while (gee_iterator_next (base_type_it)) {
					ValaDataType* base_type;
					ValaDataType* _tmp20;
					ValaDataType* _tmp19;
					base_type = (ValaDataType*) gee_iterator_get (base_type_it);
					_tmp20 = NULL;
					_tmp19 = NULL;
					instance_base_type = (_tmp20 = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp19 = vala_semantic_analyzer_get_instance_base_type (instance_type, base_type, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp20);
					(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_code_node_unref (_tmp19), NULL));
					if (instance_base_type != NULL) {
						ValaDataType* _tmp21;
						_tmp21 = NULL;
						return (_tmp21 = instance_base_type, (base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)), (base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL)), (st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp21);
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				}
				(base_type_it == NULL) ? NULL : (base_type_it = (gee_collection_object_unref (base_type_it), NULL));
			}
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		} else {
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (instance_type))) {
				ValaInterface* _tmp22;
				ValaInterface* iface;
				_tmp22 = NULL;
				iface = (_tmp22 = VALA_INTERFACE (vala_data_type_get_data_type (instance_type)), (_tmp22 == NULL) ? NULL : vala_code_node_ref (_tmp22));
				/* first check interface prerequisites recursively*/
				{
					GeeList* _tmp23;
					GeeIterator* _tmp24;
					GeeIterator* prerequisite_it;
					/* first check interface prerequisites recursively*/
					_tmp23 = NULL;
					_tmp24 = NULL;
					prerequisite_it = (_tmp24 = gee_iterable_iterator ((GeeIterable*) (_tmp23 = vala_interface_get_prerequisites (iface))), (_tmp23 == NULL) ? NULL : (_tmp23 = (gee_collection_object_unref (_tmp23), NULL)), _tmp24);
					/* first check interface prerequisites recursively*/
					while (gee_iterator_next (prerequisite_it)) {
						ValaDataType* prerequisite;
						/* first check interface prerequisites recursively*/
						prerequisite = (ValaDataType*) gee_iterator_get (prerequisite_it);
						if (VALA_IS_INTERFACE (vala_data_type_get_data_type (prerequisite))) {
							ValaDataType* _tmp26;
							ValaDataType* _tmp25;
							_tmp26 = NULL;
							_tmp25 = NULL;
							instance_base_type = (_tmp26 = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp25 = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp26);
							(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_code_node_unref (_tmp25), NULL));
							if (instance_base_type != NULL) {
								ValaDataType* _tmp27;
								_tmp27 = NULL;
								return (_tmp27 = instance_base_type, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp27);
							}
						}
						(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
					}
					(prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL));
				}
				if (instance_base_type == NULL) {
					/* then check class prerequisite recursively*/
					{
						GeeList* _tmp28;
						GeeIterator* _tmp29;
						GeeIterator* prerequisite_it;
						/* then check class prerequisite recursively*/
						_tmp28 = NULL;
						_tmp29 = NULL;
						prerequisite_it = (_tmp29 = gee_iterable_iterator ((GeeIterable*) (_tmp28 = vala_interface_get_prerequisites (iface))), (_tmp28 == NULL) ? NULL : (_tmp28 = (gee_collection_object_unref (_tmp28), NULL)), _tmp29);
						/* then check class prerequisite recursively*/
						while (gee_iterator_next (prerequisite_it)) {
							ValaDataType* prerequisite;
							/* then check class prerequisite recursively*/
							prerequisite = (ValaDataType*) gee_iterator_get (prerequisite_it);
							if (VALA_IS_CLASS (vala_data_type_get_data_type (prerequisite))) {
								ValaDataType* _tmp31;
								ValaDataType* _tmp30;
								_tmp31 = NULL;
								_tmp30 = NULL;
								instance_base_type = (_tmp31 = vala_semantic_analyzer_get_instance_base_type_for_member (_tmp30 = vala_semantic_analyzer_get_instance_base_type (instance_type, prerequisite, node_reference), type_symbol, node_reference), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp31);
								(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_code_node_unref (_tmp30), NULL));
								if (instance_base_type != NULL) {
									ValaDataType* _tmp32;
									_tmp32 = NULL;
									return (_tmp32 = instance_base_type, (prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL)), (prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL)), (iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp32);
								}
							}
							(prerequisite == NULL) ? NULL : (prerequisite = (vala_code_node_unref (prerequisite), NULL));
						}
						(prerequisite_it == NULL) ? NULL : (prerequisite_it = (gee_collection_object_unref (prerequisite_it), NULL));
					}
				}
				(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			}
		}
	}
	_tmp33 = NULL;
	return (_tmp33 = NULL, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), (instance_base_type == NULL) ? NULL : (instance_base_type = (vala_code_node_unref (instance_base_type), NULL)), _tmp33);
}


ValaDataType* vala_semantic_analyzer_get_actual_type (ValaDataType* derived_instance_type, ValaGenericType* generic_type, ValaCodeNode* node_reference) {
	ValaDataType* instance_type;
	gint param_index;
	ValaDataType* actual_type;
	GeeList* _tmp2;
	gboolean _tmp3;
	ValaDataType* _tmp8;
	gboolean _tmp9;
	ValaDataType* _tmp10;
	g_return_val_if_fail (derived_instance_type != NULL, NULL);
	g_return_val_if_fail (generic_type != NULL, NULL);
	g_return_val_if_fail (node_reference != NULL, NULL);
	/* trace type arguments back to the datatype where the method has been declared*/
	instance_type = vala_semantic_analyzer_get_instance_base_type_for_member (derived_instance_type, VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type))), node_reference);
	g_assert (instance_type != NULL);
	param_index = vala_typesymbol_get_type_parameter_index (vala_data_type_get_data_type (instance_type), vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type)));
	if (param_index == (-1)) {
		char* _tmp0;
		ValaDataType* _tmp1;
		_tmp0 = NULL;
		vala_report_error (vala_code_node_get_source_reference (node_reference), _tmp0 = g_strdup_printf ("internal error: unknown type parameter %s", vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter ((ValaDataType*) generic_type))));
		_tmp0 = (g_free (_tmp0), NULL);
		vala_code_node_set_error (node_reference, TRUE);
		_tmp1 = NULL;
		return (_tmp1 = NULL, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp1);
	}
	actual_type = NULL;
	_tmp2 = NULL;
	if ((_tmp3 = param_index < gee_collection_get_size ((GeeCollection*) (_tmp2 = vala_data_type_get_type_arguments (instance_type))), (_tmp2 == NULL) ? NULL : (_tmp2 = (gee_collection_object_unref (_tmp2), NULL)), _tmp3)) {
		ValaDataType* _tmp5;
		GeeList* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		actual_type = (_tmp5 = VALA_DATA_TYPE ((ValaDataType*) gee_list_get (_tmp4 = vala_data_type_get_type_arguments (instance_type), param_index)), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp5);
		(_tmp4 == NULL) ? NULL : (_tmp4 = (gee_collection_object_unref (_tmp4), NULL));
	}
	if (actual_type == NULL) {
		ValaDataType* _tmp6;
		ValaDataType* _tmp7;
		/* no actual type available*/
		_tmp6 = NULL;
		_tmp7 = NULL;
		return (_tmp7 = (_tmp6 = (ValaDataType*) generic_type, (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6)), (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp7);
	}
	_tmp8 = NULL;
	actual_type = (_tmp8 = vala_data_type_copy (actual_type), (actual_type == NULL) ? NULL : (actual_type = (vala_code_node_unref (actual_type), NULL)), _tmp8);
	_tmp9 = FALSE;
	if (vala_data_type_get_value_owned (actual_type)) {
		_tmp9 = vala_data_type_get_value_owned ((ValaDataType*) generic_type);
	} else {
		_tmp9 = FALSE;
	}
	vala_data_type_set_value_owned (actual_type, _tmp9);
	_tmp10 = NULL;
	return (_tmp10 = actual_type, (instance_type == NULL) ? NULL : (instance_type = (vala_code_node_unref (instance_type), NULL)), _tmp10);
}


gboolean vala_semantic_analyzer_is_in_instance_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	gboolean _tmp10;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	while (sym != NULL) {
		ValaSymbol* _tmp9;
		ValaSymbol* _tmp8;
		if (VALA_IS_CREATION_METHOD (sym)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp1);
		} else {
			if (VALA_IS_METHOD (sym)) {
				ValaMethod* _tmp2;
				ValaMethod* m;
				gboolean _tmp3;
				_tmp2 = NULL;
				m = (_tmp2 = VALA_METHOD (sym), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
				return (_tmp3 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE, (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp3);
			} else {
				if (VALA_IS_CONSTRUCTOR (sym)) {
					ValaConstructor* _tmp4;
					ValaConstructor* c;
					gboolean _tmp5;
					_tmp4 = NULL;
					c = (_tmp4 = VALA_CONSTRUCTOR (sym), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
					return (_tmp5 = vala_constructor_get_binding (c) == MEMBER_BINDING_INSTANCE, (c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp5);
				} else {
					if (VALA_IS_DESTRUCTOR (sym)) {
						gboolean _tmp6;
						return (_tmp6 = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp6);
					} else {
						if (VALA_IS_PROPERTY (sym)) {
							gboolean _tmp7;
							return (_tmp7 = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp7);
						}
					}
				}
			}
		}
		_tmp9 = NULL;
		_tmp8 = NULL;
		sym = (_tmp9 = (_tmp8 = vala_symbol_get_parent_symbol (sym), (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp9);
	}
	return (_tmp10 = FALSE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp10);
}


void vala_semantic_analyzer_visit_member_initializer (ValaSemanticAnalyzer* self, ValaMemberInitializer* init, ValaDataType* type) {
	ValaSymbol* _tmp0;
	gboolean _tmp1;
	ValaDataType* member_type;
	gboolean _tmp15;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	g_return_if_fail (type != NULL);
	_tmp0 = NULL;
	vala_member_initializer_set_symbol_reference (init, _tmp0 = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) vala_data_type_get_data_type (type), vala_member_initializer_get_name (init)));
	(_tmp0 == NULL) ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL));
	_tmp1 = FALSE;
	if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
		_tmp1 = TRUE;
	} else {
		_tmp1 = VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init));
	}
	if (!(_tmp1)) {
		char* _tmp3;
		char* _tmp2;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp3 = g_strdup_printf ("Invalid member `%s' in `%s'", vala_member_initializer_get_name (init), _tmp2 = vala_symbol_get_full_name ((ValaSymbol*) vala_data_type_get_data_type (type))));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		return;
	}
	if (vala_symbol_get_access (vala_member_initializer_get_symbol_reference (init)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
		char* _tmp5;
		char* _tmp4;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp5 = NULL;
		_tmp4 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp5 = g_strdup_printf ("Access to private member `%s' denied", _tmp4 = vala_symbol_get_full_name (vala_member_initializer_get_symbol_reference (init))));
		_tmp5 = (g_free (_tmp5), NULL);
		_tmp4 = (g_free (_tmp4), NULL);
		return;
	}
	member_type = NULL;
	if (VALA_IS_FIELD (vala_member_initializer_get_symbol_reference (init))) {
		ValaField* _tmp6;
		ValaField* f;
		ValaDataType* _tmp8;
		ValaDataType* _tmp7;
		_tmp6 = NULL;
		f = (_tmp6 = VALA_FIELD (vala_member_initializer_get_symbol_reference (init)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp8 = NULL;
		_tmp7 = NULL;
		member_type = (_tmp8 = (_tmp7 = vala_field_get_field_type (f), (_tmp7 == NULL) ? NULL : vala_code_node_ref (_tmp7)), (member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)), _tmp8);
		(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
	} else {
		if (VALA_IS_PROPERTY (vala_member_initializer_get_symbol_reference (init))) {
			ValaProperty* _tmp9;
			ValaProperty* prop;
			ValaDataType* _tmp11;
			ValaDataType* _tmp10;
			gboolean _tmp12;
			_tmp9 = NULL;
			prop = (_tmp9 = VALA_PROPERTY (vala_member_initializer_get_symbol_reference (init)), (_tmp9 == NULL) ? NULL : vala_code_node_ref (_tmp9));
			_tmp11 = NULL;
			_tmp10 = NULL;
			member_type = (_tmp11 = (_tmp10 = vala_property_get_property_type (prop), (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10)), (member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL)), _tmp11);
			_tmp12 = FALSE;
			if (vala_property_get_set_accessor (prop) == NULL) {
				_tmp12 = TRUE;
			} else {
				_tmp12 = !vala_property_accessor_get_writable (vala_property_get_set_accessor (prop));
			}
			if (_tmp12) {
				char* _tmp14;
				char* _tmp13;
				vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
				_tmp14 = NULL;
				_tmp13 = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp14 = g_strdup_printf ("Property `%s' is read-only", _tmp13 = vala_symbol_get_full_name ((ValaSymbol*) prop)));
				_tmp14 = (g_free (_tmp14), NULL);
				_tmp13 = (g_free (_tmp13), NULL);
				(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
				(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
				return;
			}
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
	}
	vala_expression_set_target_type (vala_member_initializer_get_initializer (init), member_type);
	vala_code_node_check ((ValaCodeNode*) init, self);
	_tmp15 = FALSE;
	if (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)) == NULL) {
		_tmp15 = TRUE;
	} else {
		_tmp15 = !vala_data_type_compatible (vala_expression_get_value_type (vala_member_initializer_get_initializer (init)), vala_expression_get_target_type (vala_member_initializer_get_initializer (init)));
	}
	if (_tmp15) {
		char* _tmp16;
		vala_code_node_set_error ((ValaCodeNode*) init, TRUE);
		_tmp16 = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) init), _tmp16 = g_strdup_printf ("Invalid type for member `%s'", vala_member_initializer_get_name (init)));
		_tmp16 = (g_free (_tmp16), NULL);
		(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
		return;
	}
	(member_type == NULL) ? NULL : (member_type = (vala_code_node_unref (member_type), NULL));
}


ValaDataType* vala_semantic_analyzer_get_arithmetic_result_type (ValaSemanticAnalyzer* self, ValaDataType* left_type, ValaDataType* right_type) {
	gboolean _tmp0;
	ValaStruct* _tmp2;
	ValaStruct* left;
	ValaStruct* _tmp3;
	ValaStruct* right;
	gboolean _tmp4;
	gboolean _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (left_type != NULL, NULL);
	g_return_val_if_fail (right_type != NULL, NULL);
	_tmp0 = FALSE;
	if (!(VALA_IS_STRUCT (vala_data_type_get_data_type (left_type)))) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = !(VALA_IS_STRUCT (vala_data_type_get_data_type (right_type)));
	}
	if (_tmp0) {
		/* at least one operand not struct*/
		return NULL;
	}
	_tmp2 = NULL;
	left = (_tmp2 = VALA_STRUCT (vala_data_type_get_data_type (left_type)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	right = (_tmp3 = VALA_STRUCT (vala_data_type_get_data_type (right_type)), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3));
	_tmp4 = FALSE;
	_tmp5 = FALSE;
	if (!vala_struct_is_floating_type (left)) {
		_tmp5 = !vala_struct_is_integer_type (left);
	} else {
		_tmp5 = FALSE;
	}
	if ((_tmp5)) {
		_tmp4 = TRUE;
	} else {
		gboolean _tmp6;
		_tmp6 = FALSE;
		if (!vala_struct_is_floating_type (right)) {
			_tmp6 = !vala_struct_is_integer_type (right);
		} else {
			_tmp6 = FALSE;
		}
		_tmp4 = (_tmp6);
	}
	if (_tmp4) {
		ValaDataType* _tmp7;
		/* at least one operand not numeric*/
		_tmp7 = NULL;
		return (_tmp7 = NULL, (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp7);
	}
	if (vala_struct_is_floating_type (left) == vala_struct_is_floating_type (right)) {
		/* both operands integer or floating type*/
		if (vala_struct_get_rank (left) >= vala_struct_get_rank (right)) {
			ValaDataType* _tmp8;
			ValaDataType* _tmp9;
			_tmp8 = NULL;
			_tmp9 = NULL;
			return (_tmp9 = (_tmp8 = left_type, (_tmp8 == NULL) ? NULL : vala_code_node_ref (_tmp8)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp9);
		} else {
			ValaDataType* _tmp10;
			ValaDataType* _tmp11;
			_tmp10 = NULL;
			_tmp11 = NULL;
			return (_tmp11 = (_tmp10 = right_type, (_tmp10 == NULL) ? NULL : vala_code_node_ref (_tmp10)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp11);
		}
	} else {
		/* one integer and one floating type operand*/
		if (vala_struct_is_floating_type (left)) {
			ValaDataType* _tmp12;
			ValaDataType* _tmp13;
			_tmp12 = NULL;
			_tmp13 = NULL;
			return (_tmp13 = (_tmp12 = left_type, (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp13);
		} else {
			ValaDataType* _tmp14;
			ValaDataType* _tmp15;
			_tmp14 = NULL;
			_tmp15 = NULL;
			return (_tmp15 = (_tmp14 = right_type, (_tmp14 == NULL) ? NULL : vala_code_node_ref (_tmp14)), (left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL)), (right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL)), _tmp15);
		}
	}
	(left == NULL) ? NULL : (left = (vala_code_node_unref (left), NULL));
	(right == NULL) ? NULL : (right = (vala_code_node_unref (right), NULL));
}


ValaMethod* vala_semantic_analyzer_find_current_method (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	ValaMethod* _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	while (sym != NULL) {
		ValaSymbol* _tmp4;
		ValaSymbol* _tmp3;
		if (VALA_IS_METHOD (sym)) {
			ValaMethod* _tmp1;
			ValaMethod* _tmp2;
			_tmp1 = NULL;
			_tmp2 = NULL;
			return (_tmp2 = (_tmp1 = VALA_METHOD (sym), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp2);
		}
		_tmp4 = NULL;
		_tmp3 = NULL;
		sym = (_tmp4 = (_tmp3 = vala_symbol_get_parent_symbol (sym), (_tmp3 == NULL) ? NULL : vala_code_node_ref (_tmp3)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp4);
	}
	_tmp5 = NULL;
	return (_tmp5 = NULL, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp5);
}


gboolean vala_semantic_analyzer_is_in_constructor (ValaSemanticAnalyzer* self) {
	ValaSymbol* _tmp0;
	ValaSymbol* sym;
	gboolean _tmp4;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0 = NULL;
	sym = (_tmp0 = self->priv->_current_symbol, (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	while (sym != NULL) {
		ValaSymbol* _tmp3;
		ValaSymbol* _tmp2;
		if (VALA_IS_CONSTRUCTOR (sym)) {
			gboolean _tmp1;
			return (_tmp1 = TRUE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp1);
		}
		_tmp3 = NULL;
		_tmp2 = NULL;
		sym = (_tmp3 = (_tmp2 = vala_symbol_get_parent_symbol (sym), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp3);
	}
	return (_tmp4 = FALSE, (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp4);
}


ValaCodeContext* vala_semantic_analyzer_get_context (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_context;
}


void vala_semantic_analyzer_set_context (ValaSemanticAnalyzer* self, ValaCodeContext* value) {
	ValaCodeContext* _tmp2;
	ValaCodeContext* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_context = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_context_ref (_tmp1)), (self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL)), _tmp2);
}


ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_symbol;
}


void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_current_symbol = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_current_symbol == NULL) ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL)), _tmp2);
}


ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_current_source_file;
}


void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value) {
	ValaSourceFile* _tmp2;
	ValaSourceFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_current_source_file = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_source_file_ref (_tmp1)), (self->priv->_current_source_file == NULL) ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL)), _tmp2);
}


static void vala_semantic_analyzer_class_init (ValaSemanticAnalyzerClass * klass) {
	vala_semantic_analyzer_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_VISITOR_CLASS (klass)->finalize = vala_semantic_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaSemanticAnalyzerPrivate));
	VALA_CODE_VISITOR_CLASS (klass)->visit_source_file = vala_semantic_analyzer_real_visit_source_file;
}


static void vala_semantic_analyzer_instance_init (ValaSemanticAnalyzer * self) {
	self->priv = VALA_SEMANTIC_ANALYZER_GET_PRIVATE (self);
	self->next_lambda_id = 0;
	self->replaced_nodes = (GeeList*) gee_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_semantic_analyzer_finalize (ValaCodeVisitor* obj) {
	ValaSemanticAnalyzer * self;
	self = VALA_SEMANTIC_ANALYZER (obj);
	(self->priv->_context == NULL) ? NULL : (self->priv->_context = (vala_code_context_unref (self->priv->_context), NULL));
	(self->root_symbol == NULL) ? NULL : (self->root_symbol = (vala_code_node_unref (self->root_symbol), NULL));
	(self->priv->_current_symbol == NULL) ? NULL : (self->priv->_current_symbol = (vala_code_node_unref (self->priv->_current_symbol), NULL));
	(self->priv->_current_source_file == NULL) ? NULL : (self->priv->_current_source_file = (vala_source_file_unref (self->priv->_current_source_file), NULL));
	(self->current_return_type == NULL) ? NULL : (self->current_return_type = (vala_code_node_unref (self->current_return_type), NULL));
	(self->current_class == NULL) ? NULL : (self->current_class = (vala_code_node_unref (self->current_class), NULL));
	(self->current_struct == NULL) ? NULL : (self->current_struct = (vala_code_node_unref (self->current_struct), NULL));
	(self->insert_block == NULL) ? NULL : (self->insert_block = (vala_code_node_unref (self->insert_block), NULL));
	(self->bool_type == NULL) ? NULL : (self->bool_type = (vala_code_node_unref (self->bool_type), NULL));
	(self->string_type == NULL) ? NULL : (self->string_type = (vala_code_node_unref (self->string_type), NULL));
	(self->uchar_type == NULL) ? NULL : (self->uchar_type = (vala_code_node_unref (self->uchar_type), NULL));
	(self->short_type == NULL) ? NULL : (self->short_type = (vala_code_node_unref (self->short_type), NULL));
	(self->ushort_type == NULL) ? NULL : (self->ushort_type = (vala_code_node_unref (self->ushort_type), NULL));
	(self->int_type == NULL) ? NULL : (self->int_type = (vala_code_node_unref (self->int_type), NULL));
	(self->uint_type == NULL) ? NULL : (self->uint_type = (vala_code_node_unref (self->uint_type), NULL));
	(self->long_type == NULL) ? NULL : (self->long_type = (vala_code_node_unref (self->long_type), NULL));
	(self->ulong_type == NULL) ? NULL : (self->ulong_type = (vala_code_node_unref (self->ulong_type), NULL));
	(self->size_t_type == NULL) ? NULL : (self->size_t_type = (vala_code_node_unref (self->size_t_type), NULL));
	(self->ssize_t_type == NULL) ? NULL : (self->ssize_t_type = (vala_code_node_unref (self->ssize_t_type), NULL));
	(self->uint64_type == NULL) ? NULL : (self->uint64_type = (vala_code_node_unref (self->uint64_type), NULL));
	(self->int8_type == NULL) ? NULL : (self->int8_type = (vala_code_node_unref (self->int8_type), NULL));
	(self->unichar_type == NULL) ? NULL : (self->unichar_type = (vala_code_node_unref (self->unichar_type), NULL));
	(self->double_type == NULL) ? NULL : (self->double_type = (vala_code_node_unref (self->double_type), NULL));
	(self->type_type == NULL) ? NULL : (self->type_type = (vala_code_node_unref (self->type_type), NULL));
	(self->object_type == NULL) ? NULL : (self->object_type = (vala_code_node_unref (self->object_type), NULL));
	(self->initially_unowned_type == NULL) ? NULL : (self->initially_unowned_type = (vala_code_node_unref (self->initially_unowned_type), NULL));
	(self->glist_type == NULL) ? NULL : (self->glist_type = (vala_code_node_unref (self->glist_type), NULL));
	(self->gslist_type == NULL) ? NULL : (self->gslist_type = (vala_code_node_unref (self->gslist_type), NULL));
	(self->garray_type == NULL) ? NULL : (self->garray_type = (vala_code_node_unref (self->garray_type), NULL));
	(self->gerror_type == NULL) ? NULL : (self->gerror_type = (vala_code_node_unref (self->gerror_type), NULL));
	(self->list_type == NULL) ? NULL : (self->list_type = (vala_code_node_unref (self->list_type), NULL));
	(self->map_type == NULL) ? NULL : (self->map_type = (vala_code_node_unref (self->map_type), NULL));
	(self->replaced_nodes == NULL) ? NULL : (self->replaced_nodes = (gee_collection_object_unref (self->replaced_nodes), NULL));
	VALA_CODE_VISITOR_CLASS (vala_semantic_analyzer_parent_class)->finalize (obj);
}


GType vala_semantic_analyzer_get_type (void) {
	static GType vala_semantic_analyzer_type_id = 0;
	if (vala_semantic_analyzer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSemanticAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_semantic_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSemanticAnalyzer), 0, (GInstanceInitFunc) vala_semantic_analyzer_instance_init, NULL };
		vala_semantic_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaSemanticAnalyzer", &g_define_type_info, 0);
	}
	return vala_semantic_analyzer_type_id;
}




