/* valagasyncmodule.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valagasyncmodule.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodestruct.h>
#include <vala/valamember.h>
#include <vala/valatypesymbol.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valavoidtype.h>
#include <ccode/valaccodefragment.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodefunction.h>
#include <gee/hashmap.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <gee/map.h>
#include <float.h>
#include <math.h>
#include <ccode/valaccodefunctiondeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <vala/valasourcereference.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecasestatement.h>
#include <vala/valacodevisitor.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valalocalvariable.h>
#include <vala/valamemberaccess.h>
#include <vala/valaexpression.h>
#include <gobject/valaccodemethodmodule.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_GASYNC_MODULE_DUMMY_PROPERTY
};
static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt);
static gpointer vala_gasync_module_parent_class = NULL;



ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGAsyncModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGAsyncModule*) vala_gsignal_module_construct (object_type, codegen, next);
	return self;
}


ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gasync_module_construct (VALA_TYPE_GASYNC_MODULE, codegen, next);
}


static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaGAsyncModule * self;
	ValaDataType* _tmp0;
	ValaDataType* creturn_type;
	gboolean visible;
	char* _tmp2;
	char* _tmp1;
	char* _tmp3;
	char* dataname;
	ValaCCodeStruct* _tmp5;
	char* _tmp4;
	ValaCCodeTypeDefinition* _tmp15;
	ValaCCodeVariableDeclarator* _tmp14;
	char* _tmp13;
	char* _tmp17;
	char* _tmp16;
	ValaCCodeFunction* _tmp18;
	ValaCCodeFunction* asyncfunc;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* asyncblock;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeFunctionCall* _tmp20;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp21;
	char* _tmp22;
	ValaCCodeDeclaration* _tmp23;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp24;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeAssignment* _tmp26;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeExpressionStatement* _tmp32;
	ValaCCodeAssignment* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeMemberAccess* _tmp29;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeExpressionStatement* _tmp37;
	ValaCCodeAssignment* _tmp36;
	ValaCCodeIdentifier* _tmp35;
	ValaCCodeMemberAccess* _tmp34;
	ValaCCodeIdentifier* _tmp33;
	ValaCCodeIdentifier* _tmp52;
	char* _tmp51;
	char* _tmp50;
	ValaCCodeFunctionCall* _tmp53;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeExpressionStatement* _tmp55;
	ValaCCodeFormalParameter* _tmp56;
	ValaCCodeFormalParameter* _tmp57;
	ValaCCodeFunctionDeclarator* vdeclarator;
	gboolean _tmp58;
	char* _tmp67;
	char* _tmp66;
	char* _tmp65;
	ValaCCodeFunction* _tmp68;
	ValaCCodeFunction* finishfunc;
	GeeHashMap* _tmp69;
	ValaCCodeBlock* finishblock;
	ValaCCodeFormalParameter* _tmp70;
	gboolean _tmp71;
	gboolean _tmp105;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (m != NULL);
	if (!vala_method_get_coroutine (m)) {
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
		return;
	}
	_tmp0 = NULL;
	creturn_type = (_tmp0 = vala_method_get_return_type (m), (_tmp0 == NULL) ? NULL : vala_code_node_ref (_tmp0));
	visible = !vala_symbol_is_internal_symbol ((ValaSymbol*) m);
	((ValaCCodeBaseModule*) self)->gio_h_needed = TRUE;
	/* generate struct to hold parameters, local variables, and the return value*/
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	dataname = (_tmp3 = g_strconcat (_tmp2 = vala_symbol_lower_case_to_camel_case (_tmp1 = vala_method_get_cname (m)), "Data", NULL), _tmp2 = (g_free (_tmp2), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp3);
	_tmp5 = NULL;
	_tmp4 = NULL;
	((ValaCCodeBaseModule*) self)->closure_struct = (_tmp5 = vala_ccode_struct_new (_tmp4 = g_strconcat ("_", dataname, NULL)), (((ValaCCodeBaseModule*) self)->closure_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->closure_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->closure_struct), NULL)), _tmp5);
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "int", "state");
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GAsyncReadyCallback", "callback");
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "gpointer", "user_data");
	vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GAsyncResult*", "res");
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaTypeSymbol* _tmp6;
		ValaTypeSymbol* type_sym;
		char* _tmp8;
		char* _tmp7;
		_tmp6 = NULL;
		type_sym = (_tmp6 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
		_tmp8 = NULL;
		_tmp7 = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp8 = g_strconcat (_tmp7 = vala_typesymbol_get_cname (type_sym, FALSE), "*", NULL), "self");
		_tmp8 = (g_free (_tmp8), NULL);
		_tmp7 = (g_free (_tmp7), NULL);
		(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
	}
	{
		GeeList* _tmp9;
		GeeIterator* _tmp10;
		GeeIterator* _param_it;
		_tmp9 = NULL;
		_tmp10 = NULL;
		_param_it = (_tmp10 = gee_iterable_iterator ((GeeIterable*) (_tmp9 = vala_method_get_parameters (m))), (_tmp9 == NULL) ? NULL : (_tmp9 = (gee_collection_object_unref (_tmp9), NULL)), _tmp10);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			char* _tmp11;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp11 = NULL;
			vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp11 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), vala_symbol_get_name ((ValaSymbol*) param));
			_tmp11 = (g_free (_tmp11), NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		char* _tmp12;
		_tmp12 = NULL;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, _tmp12 = vala_data_type_get_cname (vala_method_get_return_type (m)), "result");
		_tmp12 = (g_free (_tmp12), NULL);
	}
	VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_definition, (ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->closure_struct);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_declaration, (ValaCCodeNode*) (_tmp15 = vala_ccode_type_definition_new (_tmp13 = g_strconcat ("struct _", dataname, NULL), (ValaCCodeDeclarator*) (_tmp14 = vala_ccode_variable_declarator_new (dataname)))));
	(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
	(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
	_tmp13 = (g_free (_tmp13), NULL);
	/* generate async function*/
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp18 = NULL;
	asyncfunc = (_tmp18 = vala_ccode_function_new (_tmp17 = g_strconcat (_tmp16 = vala_method_get_real_cname (m), "_async", NULL), "void"), _tmp17 = (g_free (_tmp17), NULL), _tmp16 = (g_free (_tmp16), NULL), _tmp18);
	vala_ccode_node_set_line ((ValaCCodeNode*) asyncfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	asyncblock = vala_ccode_block_new ();
	_tmp19 = NULL;
	_tmp20 = NULL;
	dataalloc = (_tmp20 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp19 = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)), _tmp20);
	_tmp21 = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (dataname)));
	(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
	_tmp22 = NULL;
	_tmp23 = NULL;
	datadecl = (_tmp23 = vala_ccode_declaration_new (_tmp22 = g_strconcat (dataname, "*", NULL)), _tmp22 = (g_free (_tmp22), NULL), _tmp23);
	_tmp24 = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp24 = vala_ccode_variable_declarator_new ("data")));
	(_tmp24 == NULL) ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL));
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) datadecl);
	_tmp27 = NULL;
	_tmp26 = NULL;
	_tmp25 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp27 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp26 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp25 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
	(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
	(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp32 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp31 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp29 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp28 = vala_ccode_identifier_new ("data")), "callback")), (ValaCCodeExpression*) (_tmp30 = vala_ccode_identifier_new ("callback")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp32 == NULL) ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL));
	(_tmp31 == NULL) ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL));
	(_tmp30 == NULL) ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL));
	(_tmp29 == NULL) ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL));
	(_tmp28 == NULL) ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL));
	_tmp37 = NULL;
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp37 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp36 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp33 = vala_ccode_identifier_new ("data")), "user_data")), (ValaCCodeExpression*) (_tmp35 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
	(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
	(_tmp35 == NULL) ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL));
	(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
	(_tmp33 == NULL) ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpressionStatement* _tmp42;
		ValaCCodeAssignment* _tmp41;
		ValaCCodeIdentifier* _tmp40;
		ValaCCodeMemberAccess* _tmp39;
		ValaCCodeIdentifier* _tmp38;
		_tmp42 = NULL;
		_tmp41 = NULL;
		_tmp40 = NULL;
		_tmp39 = NULL;
		_tmp38 = NULL;
		vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp42 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp41 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp39 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp38 = vala_ccode_identifier_new ("data")), "self")), (ValaCCodeExpression*) (_tmp40 = vala_ccode_identifier_new ("self")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp42 == NULL) ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		(_tmp40 == NULL) ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL));
		(_tmp39 == NULL) ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL));
		(_tmp38 == NULL) ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL));
	}
	{
		GeeList* _tmp43;
		GeeIterator* _tmp44;
		GeeIterator* _param_it;
		_tmp43 = NULL;
		_tmp44 = NULL;
		_param_it = (_tmp44 = gee_iterable_iterator ((GeeIterable*) (_tmp43 = vala_method_get_parameters (m))), (_tmp43 == NULL) ? NULL : (_tmp43 = (gee_collection_object_unref (_tmp43), NULL)), _tmp44);
		while (gee_iterator_next (_param_it)) {
			ValaFormalParameter* param;
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				ValaCCodeExpressionStatement* _tmp49;
				ValaCCodeAssignment* _tmp48;
				ValaCCodeIdentifier* _tmp47;
				ValaCCodeMemberAccess* _tmp46;
				ValaCCodeIdentifier* _tmp45;
				_tmp49 = NULL;
				_tmp48 = NULL;
				_tmp47 = NULL;
				_tmp46 = NULL;
				_tmp45 = NULL;
				vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp49 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp48 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp45 = vala_ccode_identifier_new ("data")), vala_symbol_get_name ((ValaSymbol*) param))), (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
				(_tmp48 == NULL) ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL));
				(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
				(_tmp46 == NULL) ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL));
				(_tmp45 == NULL) ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp52 = NULL;
	_tmp51 = NULL;
	_tmp50 = NULL;
	_tmp53 = NULL;
	ccall = (_tmp53 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp52 = vala_ccode_identifier_new (_tmp51 = g_strconcat (_tmp50 = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp52 == NULL) ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)), _tmp51 = (g_free (_tmp51), NULL), _tmp50 = (g_free (_tmp50), NULL), _tmp53);
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp54 = vala_ccode_identifier_new ("data")));
	(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
	_tmp55 = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp55 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
	_tmp56 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp56 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
	_tmp57 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp57 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
	vdeclarator = NULL;
	_tmp58 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp58 = TRUE;
	} else {
		_tmp58 = vala_method_get_is_virtual (m);
	}
	if (_tmp58) {
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp60;
		char* _tmp59;
		vdecl = vala_ccode_declaration_new ("void");
		_tmp60 = NULL;
		_tmp59 = NULL;
		vdeclarator = (_tmp60 = vala_ccode_function_declarator_new (_tmp59 = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp60);
		_tmp59 = (g_free (_tmp59), NULL);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, FALSE, (GeeMap*) cparam_map, asyncfunc, vdeclarator, NULL, NULL, 1);
	if (!vala_method_get_is_abstract (m)) {
		gboolean _tmp61;
		gboolean _tmp62;
		_tmp61 = FALSE;
		_tmp62 = FALSE;
		if (visible) {
			_tmp62 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp62 = FALSE;
		}
		if (_tmp62) {
			_tmp61 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp61 = FALSE;
		}
		if (_tmp61) {
			ValaCCodeFunction* _tmp63;
			_tmp63 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp63 = vala_ccode_function_copy (asyncfunc)));
			(_tmp63 == NULL) ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL));
		} else {
			ValaCCodeFunction* _tmp64;
			vala_ccode_function_set_modifiers (asyncfunc, vala_ccode_function_get_modifiers (asyncfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp64 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp64 = vala_ccode_function_copy (asyncfunc)));
			(_tmp64 == NULL) ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL));
		}
		vala_ccode_function_set_block (asyncfunc, asyncblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) asyncfunc);
	}
	/* generate finish function*/
	_tmp67 = NULL;
	_tmp66 = NULL;
	_tmp65 = NULL;
	_tmp68 = NULL;
	finishfunc = (_tmp68 = vala_ccode_function_new (_tmp66 = g_strconcat (_tmp65 = vala_method_get_real_cname (m), "_finish", NULL), _tmp67 = vala_data_type_get_cname (creturn_type)), _tmp67 = (g_free (_tmp67), NULL), _tmp66 = (g_free (_tmp66), NULL), _tmp65 = (g_free (_tmp65), NULL), _tmp68);
	vala_ccode_node_set_line ((ValaCCodeNode*) finishfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
	_tmp69 = NULL;
	cparam_map = (_tmp69 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp69);
	finishblock = vala_ccode_block_new ();
	_tmp70 = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp70 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp70 == NULL) ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL));
	_tmp71 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp71 = TRUE;
	} else {
		_tmp71 = vala_method_get_is_virtual (m);
	}
	if (_tmp71) {
		char* _tmp72;
		ValaCCodeDeclaration* _tmp73;
		ValaCCodeDeclaration* vdecl;
		ValaCCodeFunctionDeclarator* _tmp75;
		char* _tmp74;
		_tmp72 = NULL;
		_tmp73 = NULL;
		vdecl = (_tmp73 = vala_ccode_declaration_new (_tmp72 = vala_data_type_get_cname (creturn_type)), _tmp72 = (g_free (_tmp72), NULL), _tmp73);
		_tmp75 = NULL;
		_tmp74 = NULL;
		vdeclarator = (_tmp75 = vala_ccode_function_declarator_new (_tmp74 = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), (vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL)), _tmp75);
		_tmp74 = (g_free (_tmp74), NULL);
		vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
		vala_ccode_struct_add_declaration (((ValaCCodeBaseModule*) self)->type_struct, vdecl);
		(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	}
	vala_ccode_module_generate_cparameters ((ValaCCodeModule*) self, m, creturn_type, FALSE, (GeeMap*) cparam_map, finishfunc, vdeclarator, NULL, NULL, 2);
	if (!vala_method_get_is_abstract (m)) {
		gboolean _tmp76;
		gboolean _tmp77;
		_tmp76 = FALSE;
		_tmp77 = FALSE;
		if (visible) {
			_tmp77 = vala_method_get_base_method (m) == NULL;
		} else {
			_tmp77 = FALSE;
		}
		if (_tmp77) {
			_tmp76 = vala_method_get_base_interface_method (m) == NULL;
		} else {
			_tmp76 = FALSE;
		}
		if (_tmp76) {
			ValaCCodeFunction* _tmp78;
			_tmp78 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->header_type_member_declaration, (ValaCCodeNode*) (_tmp78 = vala_ccode_function_copy (finishfunc)));
			(_tmp78 == NULL) ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL));
		} else {
			ValaCCodeFunction* _tmp79;
			vala_ccode_function_set_modifiers (finishfunc, vala_ccode_function_get_modifiers (finishfunc) | (VALA_CCODE_MODIFIERS_STATIC));
			_tmp79 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp79 = vala_ccode_function_copy (finishfunc)));
			(_tmp79 == NULL) ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL));
		}
		vala_ccode_function_set_block (finishfunc, finishblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) finishfunc);
	}
	if (!vala_method_get_is_abstract (m)) {
		char* _tmp81;
		char* _tmp80;
		ValaCCodeFunction* _tmp82;
		ValaCCodeFunction* readyfunc;
		ValaCCodeFormalParameter* _tmp83;
		ValaCCodeFormalParameter* _tmp84;
		ValaCCodeFormalParameter* _tmp85;
		ValaCCodeBlock* readyblock;
		ValaCCodeDeclaration* _tmp87;
		char* _tmp86;
		ValaCCodeVariableDeclarator* _tmp88;
		ValaCCodeExpressionStatement* _tmp92;
		ValaCCodeAssignment* _tmp91;
		ValaCCodeIdentifier* _tmp90;
		ValaCCodeIdentifier* _tmp89;
		ValaCCodeExpressionStatement* _tmp97;
		ValaCCodeAssignment* _tmp96;
		ValaCCodeIdentifier* _tmp95;
		ValaCCodeMemberAccess* _tmp94;
		ValaCCodeIdentifier* _tmp93;
		ValaCCodeFunctionCall* _tmp101;
		ValaCCodeIdentifier* _tmp100;
		char* _tmp99;
		char* _tmp98;
		ValaCCodeIdentifier* _tmp102;
		ValaCCodeExpressionStatement* _tmp103;
		ValaCCodeFunction* _tmp104;
		/* generate ready callback handler*/
		_tmp81 = NULL;
		_tmp80 = NULL;
		_tmp82 = NULL;
		readyfunc = (_tmp82 = vala_ccode_function_new (_tmp81 = g_strconcat (_tmp80 = vala_method_get_cname (m), "_ready", NULL), "void"), _tmp81 = (g_free (_tmp81), NULL), _tmp80 = (g_free (_tmp80), NULL), _tmp82);
		vala_ccode_node_set_line ((ValaCCodeNode*) readyfunc, vala_ccode_node_get_line ((ValaCCodeNode*) ((ValaCCodeBaseModule*) self)->function));
		_tmp83 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp83 = vala_ccode_formal_parameter_new ("source_object", "GObject*"));
		(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
		_tmp84 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp84 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
		(_tmp84 == NULL) ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL));
		_tmp85 = NULL;
		vala_ccode_function_add_parameter (readyfunc, _tmp85 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
		(_tmp85 == NULL) ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL));
		readyblock = vala_ccode_block_new ();
		_tmp87 = NULL;
		_tmp86 = NULL;
		datadecl = (_tmp87 = vala_ccode_declaration_new (_tmp86 = g_strconcat (dataname, "*", NULL)), (datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL)), _tmp87);
		_tmp86 = (g_free (_tmp86), NULL);
		_tmp88 = NULL;
		vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp88 = vala_ccode_variable_declarator_new ("data")));
		(_tmp88 == NULL) ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL));
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) datadecl);
		_tmp92 = NULL;
		_tmp91 = NULL;
		_tmp90 = NULL;
		_tmp89 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp92 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp91 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp89 = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp92 == NULL) ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL));
		(_tmp91 == NULL) ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL));
		(_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL));
		(_tmp89 == NULL) ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL));
		_tmp97 = NULL;
		_tmp96 = NULL;
		_tmp95 = NULL;
		_tmp94 = NULL;
		_tmp93 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp97 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp96 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp94 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new ("data")), "res")), (ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new ("res")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp97 == NULL) ? NULL : (_tmp97 = (vala_ccode_node_unref (_tmp97), NULL));
		(_tmp96 == NULL) ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL));
		(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
		(_tmp94 == NULL) ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL));
		(_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL));
		_tmp101 = NULL;
		_tmp100 = NULL;
		_tmp99 = NULL;
		_tmp98 = NULL;
		ccall = (_tmp101 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp100 = vala_ccode_identifier_new (_tmp99 = g_strconcat (_tmp98 = vala_method_get_real_cname (m), "_co", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp101);
		(_tmp100 == NULL) ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL));
		_tmp99 = (g_free (_tmp99), NULL);
		_tmp98 = (g_free (_tmp98), NULL);
		_tmp102 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp102 = vala_ccode_identifier_new ("data")));
		(_tmp102 == NULL) ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL));
		_tmp103 = NULL;
		vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp103 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
		(_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL));
		vala_ccode_function_set_modifiers (readyfunc, vala_ccode_function_get_modifiers (readyfunc) | (VALA_CCODE_MODIFIERS_STATIC));
		_tmp104 = NULL;
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_declaration, (ValaCCodeNode*) (_tmp104 = vala_ccode_function_copy (readyfunc)));
		(_tmp104 == NULL) ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL));
		vala_ccode_function_set_block (readyfunc, readyblock);
		vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) readyfunc);
		(readyfunc == NULL) ? NULL : (readyfunc = (vala_ccode_node_unref (readyfunc), NULL));
		(readyblock == NULL) ? NULL : (readyblock = (vala_ccode_node_unref (readyblock), NULL));
	}
	_tmp105 = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp105 = TRUE;
	} else {
		_tmp105 = vala_method_get_is_virtual (m);
	}
	if (_tmp105) {
		GeeHashMap* _tmp106;
		GeeHashMap* carg_map;
		ValaCCodeFormalParameter* _tmp107;
		ValaCCodeFormalParameter* _tmp108;
		ValaCCodeIdentifier* _tmp109;
		ValaCCodeIdentifier* _tmp110;
		ValaVoidType* _tmp111;
		GeeHashMap* _tmp112;
		GeeHashMap* _tmp113;
		ValaCCodeFormalParameter* _tmp114;
		ValaCCodeIdentifier* _tmp115;
		_tmp106 = NULL;
		cparam_map = (_tmp106 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp106);
		carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
		_tmp107 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp107 = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
		(_tmp107 == NULL) ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL));
		_tmp108 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp108 = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
		(_tmp108 == NULL) ? NULL : (_tmp108 = (vala_ccode_node_unref (_tmp108), NULL));
		_tmp109 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp109 = vala_ccode_identifier_new ("callback")));
		(_tmp109 == NULL) ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL));
		_tmp110 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp110 = vala_ccode_identifier_new ("user_data")));
		(_tmp110 == NULL) ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL));
		_tmp111 = NULL;
		vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, (ValaDataType*) (_tmp111 = vala_void_type_new (NULL)), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_async", 1);
		(_tmp111 == NULL) ? NULL : (_tmp111 = (vala_code_node_unref (_tmp111), NULL));
		_tmp112 = NULL;
		cparam_map = (_tmp112 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL)), _tmp112);
		_tmp113 = NULL;
		carg_map = (_tmp113 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp113);
		_tmp114 = NULL;
		gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp114 = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
		(_tmp114 == NULL) ? NULL : (_tmp114 = (vala_ccode_node_unref (_tmp114), NULL));
		_tmp115 = NULL;
		gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp115 = vala_ccode_identifier_new ("res")));
		(_tmp115 == NULL) ? NULL : (_tmp115 = (vala_ccode_node_unref (_tmp115), NULL));
		vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, vala_method_get_return_type (m), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_finish", 2);
		(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	}
	(creturn_type == NULL) ? NULL : (creturn_type = (vala_code_node_unref (creturn_type), NULL));
	dataname = (g_free (dataname), NULL);
	(asyncfunc == NULL) ? NULL : (asyncfunc = (vala_ccode_node_unref (asyncfunc), NULL));
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(asyncblock == NULL) ? NULL : (asyncblock = (vala_ccode_node_unref (asyncblock), NULL));
	(dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(finishfunc == NULL) ? NULL : (finishfunc = (vala_ccode_node_unref (finishfunc), NULL));
	(finishblock == NULL) ? NULL : (finishblock = (vala_ccode_node_unref (finishblock), NULL));
}


static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt) {
	ValaGAsyncModule * self;
	ValaCCodeExpressionStatement* _tmp19;
	gboolean _tmp20;
	ValaCCodeFragment* cfrag;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_yield_statement_get_yield_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeIdentifier* _tmp0;
		ValaCCodeFunctionCall* _tmp1;
		ValaCCodeFunctionCall* idle_call;
		ValaCCodeCastExpression* _tmp5;
		ValaCCodeIdentifier* _tmp4;
		char* _tmp3;
		char* _tmp2;
		ValaCCodeIdentifier* _tmp6;
		gint state;
		ValaCCodeExpressionStatement* _tmp7;
		ValaCCodeExpressionStatement* _tmp13;
		ValaCCodeAssignment* _tmp12;
		ValaCCodeConstant* _tmp11;
		char* _tmp10;
		ValaCCodeMemberAccess* _tmp9;
		ValaCCodeIdentifier* _tmp8;
		ValaCCodeReturnStatement* _tmp15;
		ValaCCodeConstant* _tmp14;
		ValaCCodeCaseStatement* _tmp18;
		ValaCCodeConstant* _tmp17;
		char* _tmp16;
		/* should be replaced by a simple return FALSE; when we have
		     void idle () yields;
		 working in the .vapi*/
		cfrag = vala_ccode_fragment_new ();
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		_tmp0 = NULL;
		_tmp1 = NULL;
		idle_call = (_tmp1 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0 = vala_ccode_identifier_new ("g_idle_add"))), (_tmp0 == NULL) ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)), _tmp1);
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp5 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp4 = vala_ccode_identifier_new (_tmp3 = g_strconcat (_tmp2 = vala_method_get_real_cname (((ValaCCodeBaseModule*) self)->current_method), "_co", NULL))), "GSourceFunc")));
		(_tmp5 == NULL) ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL));
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
		_tmp6 = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp6 = vala_ccode_identifier_new ("data")));
		(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL));
		state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
		_tmp7 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp7 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL));
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp8 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp13 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp12 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp9 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp8 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp11 = vala_ccode_constant_new (_tmp10 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
		(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
		(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		_tmp10 = (g_free (_tmp10), NULL);
		(_tmp9 == NULL) ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL));
		(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL));
		_tmp15 = NULL;
		_tmp14 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp15 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_constant_new ("FALSE")))));
		(_tmp15 == NULL) ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL));
		(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp18 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp17 = vala_ccode_constant_new (_tmp16 = g_strdup_printf ("%i", state))))));
		(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		_tmp16 = (g_free (_tmp16), NULL);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
		(idle_call == NULL) ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp19 = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))))));
	(_tmp19 == NULL) ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL));
	_tmp20 = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp20 = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt));
	} else {
		_tmp20 = FALSE;
	}
	if (_tmp20) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	/* free temporary objects */
	if (gee_collection_get_size ((GeeCollection*) (GEE_LIST (((ValaCCodeBaseModule*) self)->temp_vars))) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
		while (gee_iterator_next (_local_it)) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp23;
			ValaCCodeExpression* _tmp22;
			ValaCCodeIdentifier* _tmp21;
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp23 = NULL;
			_tmp22 = NULL;
			_tmp21 = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp23 = vala_ccode_expression_statement_new (_tmp22 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp21 = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp23 == NULL) ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL));
			(_tmp22 == NULL) ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL));
			(_tmp21 == NULL) ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_gasync_module_class_init (ValaGAsyncModuleClass * klass) {
	vala_gasync_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_gasync_module_real_visit_method;
	VALA_CCODE_MODULE_CLASS (klass)->visit_yield_statement = vala_gasync_module_real_visit_yield_statement;
}


static void vala_gasync_module_instance_init (ValaGAsyncModule * self) {
}


GType vala_gasync_module_get_type (void) {
	static GType vala_gasync_module_type_id = 0;
	if (vala_gasync_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGAsyncModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gasync_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGAsyncModule), 0, (GInstanceInitFunc) vala_gasync_module_instance_init, NULL };
		vala_gasync_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGAsyncModule", &g_define_type_info, 0);
	}
	return vala_gasync_module_type_id;
}




