/* valaobjecttypesymbol.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <vala/valaobjecttypesymbol.h>
#include <gee/readonlylist.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valatypeparameter.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>




struct _ValaObjectTypeSymbolPrivate {
	GeeList* type_parameters;
};

#define VALA_OBJECT_TYPE_SYMBOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolPrivate))
enum  {
	VALA_OBJECT_TYPE_SYMBOL_DUMMY_PROPERTY
};
static GeeList* vala_object_type_symbol_real_get_methods (ValaObjectTypeSymbol* self);
static GeeList* vala_object_type_symbol_real_get_signals (ValaObjectTypeSymbol* self);
static GeeList* vala_object_type_symbol_real_get_properties (ValaObjectTypeSymbol* self);
static gint vala_object_type_symbol_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name);
static gpointer vala_object_type_symbol_parent_class = NULL;
static void vala_object_type_symbol_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaObjectTypeSymbol* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaObjectTypeSymbol*) vala_typesymbol_construct (object_type, name, source_reference);
	return self;
}


ValaObjectTypeSymbol* vala_object_type_symbol_new (const char* name, ValaSourceReference* source_reference) {
	return vala_object_type_symbol_construct (VALA_TYPE_OBJECT_TYPE_SYMBOL, name, source_reference);
}


static GeeList* vala_object_type_symbol_real_get_methods (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_methods'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_methods (self);
}


static GeeList* vala_object_type_symbol_real_get_signals (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_signals'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_signals (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_signals (self);
}


static GeeList* vala_object_type_symbol_real_get_properties (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_object_type_symbol_get_properties'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self) {
	return VALA_OBJECT_TYPE_SYMBOL_GET_CLASS (self)->get_properties (self);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_object_type_symbol_add_type_parameter (ValaObjectTypeSymbol* self, ValaTypeParameter* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gee_collection_add ((GeeCollection*) self->priv->type_parameters, p);
	p->type = (ValaTypeSymbol*) self;
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) p), (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return (GeeList*) gee_read_only_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->type_parameters);
}


static gint vala_object_type_symbol_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name) {
	ValaObjectTypeSymbol * self;
	gint i;
	self = (ValaObjectTypeSymbol*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		GeeIterator* _parameter_it;
		_parameter_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_parameters);
		while (gee_iterator_next (_parameter_it)) {
			ValaTypeParameter* parameter;
			parameter = (ValaTypeParameter*) gee_iterator_get (_parameter_it);
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) parameter), name) == 0) {
				gint _tmp0;
				return (_tmp0 = i, (parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL)), (_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL)), _tmp0);
			}
			i++;
			(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
		}
		(_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL));
	}
	return -1;
}


static void vala_object_type_symbol_class_init (ValaObjectTypeSymbolClass * klass) {
	vala_object_type_symbol_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_object_type_symbol_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectTypeSymbolPrivate));
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_object_type_symbol_real_get_methods;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_object_type_symbol_real_get_signals;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_object_type_symbol_real_get_properties;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_object_type_symbol_real_get_type_parameter_index;
}


static void vala_object_type_symbol_instance_init (ValaObjectTypeSymbol * self) {
	self->priv = VALA_OBJECT_TYPE_SYMBOL_GET_PRIVATE (self);
	self->priv->type_parameters = (GeeList*) gee_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_object_type_symbol_finalize (ValaCodeNode* obj) {
	ValaObjectTypeSymbol * self;
	self = VALA_OBJECT_TYPE_SYMBOL (obj);
	(self->priv->type_parameters == NULL) ? NULL : (self->priv->type_parameters = (gee_collection_object_unref (self->priv->type_parameters), NULL));
	VALA_CODE_NODE_CLASS (vala_object_type_symbol_parent_class)->finalize (obj);
}


GType vala_object_type_symbol_get_type (void) {
	static GType vala_object_type_symbol_type_id = 0;
	if (vala_object_type_symbol_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectTypeSymbolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_type_symbol_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectTypeSymbol), 0, (GInstanceInitFunc) vala_object_type_symbol_instance_init, NULL };
		vala_object_type_symbol_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaObjectTypeSymbol", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_object_type_symbol_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




