/* valaccodeassignmentmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeassignmentmodule.h>
#include <vala/valacodenode.h>
#include <vala/valacodevisitor.h>
#include <vala/valaexpression.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valamemberaccess.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valaclass.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valadatatype.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodefunctioncall.h>
#include <vala/valaexpressionstatement.h>
#include <ccode/valaccodecommaexpression.h>
#include <vala/valaarraytype.h>
#include <vala/valafield.h>
#include <vala/valadelegatetype.h>
#include <vala/valadelegate.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valalocalvariable.h>
#include <vala/valasourcereference.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <vala/valasymbol.h>
#include <gobject/valaccodebasemodule.h>




enum  {
	VALA_CCODE_ASSIGNMENT_MODULE_DUMMY_PROPERTY
};
static ValaCCodeExpression* vala_ccode_assignment_module_emit_property_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static ValaCCodeExpression* vala_ccode_assignment_module_emit_simple_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment);
static void vala_ccode_assignment_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
static gpointer vala_ccode_assignment_module_parent_class = NULL;



ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeAssignmentModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeAssignmentModule*) vala_ccode_member_access_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_assignment_module_construct (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, codegen, next);
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_property_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaProperty* _tmp2;
	ValaProperty* prop;
	gboolean _tmp3;
	gboolean _tmp4;
	gboolean _tmp5;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_assignment_get_left (assignment), VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	prop = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment))), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = FALSE;
	_tmp4 = FALSE;
	_tmp5 = FALSE;
	if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
		_tmp5 = VALA_IS_CLASS (((ValaCCodeBaseModule*) self)->current_type_symbol);
	} else {
		_tmp5 = FALSE;
	}
	if (_tmp5) {
		_tmp4 = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		_tmp3 = ((ValaCCodeBaseModule*) self)->in_creation_method;
	} else {
		_tmp3 = FALSE;
	}
	if (_tmp3) {
		ValaCCodeConstant* _tmp6;
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = vala_ccode_module_get_construct_property_assignment (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp6 = vala_property_get_canonical_cconstant (prop), vala_property_get_property_type (prop), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_assignment_get_right (assignment)))), (_tmp6 == NULL) ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)), _tmp7), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp8);
	} else {
		ValaCCodeExpression* _tmp9;
		ValaCCodeExpression* cexpr;
		ValaCCodeFunctionCall* ccall;
		_tmp9 = NULL;
		cexpr = (_tmp9 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_assignment_get_right (assignment))), (_tmp9 == NULL) ? NULL : vala_ccode_node_ref (_tmp9));
		if (!vala_property_get_no_accessor_method (prop)) {
			if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
				ValaCCodeExpression* _tmp10;
				_tmp10 = NULL;
				cexpr = (_tmp10 = vala_ccode_base_module_get_address_of_expression ((ValaCCodeBaseModule*) self, vala_assignment_get_right (assignment), cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp10);
			}
		}
		if (vala_assignment_get_operator (assignment) != VALA_ASSIGNMENT_OPERATOR_SIMPLE) {
			ValaCCodeBinaryOperator cop;
			ValaCCodeExpression* _tmp12;
			ValaCCodeExpression* _tmp11;
			cop = 0;
			if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
				cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_OR;
			} else {
				if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
					cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_AND;
				} else {
					if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
						cop = VALA_CCODE_BINARY_OPERATOR_BITWISE_XOR;
					} else {
						if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
							cop = VALA_CCODE_BINARY_OPERATOR_PLUS;
						} else {
							if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
								cop = VALA_CCODE_BINARY_OPERATOR_MINUS;
							} else {
								if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
									cop = VALA_CCODE_BINARY_OPERATOR_MUL;
								} else {
									if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
										cop = VALA_CCODE_BINARY_OPERATOR_DIV;
									} else {
										if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
											cop = VALA_CCODE_BINARY_OPERATOR_MOD;
										} else {
											if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
												cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_LEFT;
											} else {
												if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
													cop = VALA_CCODE_BINARY_OPERATOR_SHIFT_RIGHT;
												} else {
													g_assert_not_reached ();
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
			_tmp12 = NULL;
			_tmp11 = NULL;
			cexpr = (_tmp12 = (ValaCCodeExpression*) vala_ccode_binary_expression_new (cop, _tmp11 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_assignment_get_left (assignment))), cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp12);
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
		}
		ccall = vala_ccode_base_module_get_property_set_call ((ValaCCodeBaseModule*) self, prop, ma, cexpr);
		/* assignments are expressions, so return the current property value, except if we're sure that it can't be used*/
		if (!VALA_IS_EXPRESSION_STATEMENT (vala_code_node_get_parent_node ((ValaCodeNode*) assignment))) {
			ValaCCodeCommaExpression* ccomma;
			ValaCCodeExpression* _tmp13;
			ValaCCodeExpression* _tmp14;
			ccomma = vala_ccode_comma_expression_new ();
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) ccall);
			/* update property*/
			_tmp13 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, _tmp13 = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) ma)));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			/* current property value*/
			_tmp14 = NULL;
			return (_tmp14 = (ValaCCodeExpression*) ccomma, (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp14);
		} else {
			ValaCCodeExpression* _tmp15;
			_tmp15 = NULL;
			return (_tmp15 = (ValaCCodeExpression*) ccall, (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), (prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL)), _tmp15);
		}
		(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	}
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
}


static ValaCCodeExpression* vala_ccode_assignment_module_emit_simple_assignment (ValaCCodeAssignmentModule* self, ValaAssignment* assignment) {
	ValaCCodeExpression* _tmp0;
	ValaCCodeExpression* rhs;
	ValaCCodeExpression* lhs;
	ValaCCodeCommaExpression* outer_ccomma;
	gboolean unref_old;
	gboolean array;
	gboolean instance_delegate;
	gboolean _tmp5;
	gboolean _tmp6;
	ValaCCodeAssignmentOperator cop;
	ValaCCodeExpression* codenode;
	ValaCCodeExpression* _tmp32;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp0 = NULL;
	rhs = (_tmp0 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_assignment_get_right (assignment))), (_tmp0 == NULL) ? NULL : vala_ccode_node_ref (_tmp0));
	lhs = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_assignment_get_left (assignment)));
	outer_ccomma = NULL;
	unref_old = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_assignment_get_left (assignment)));
	array = FALSE;
	instance_delegate = FALSE;
	if (VALA_IS_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment)))) {
		ValaField* _tmp2;
		ValaSymbol* _tmp1;
		ValaField* array_field;
		gboolean _tmp3;
		_tmp2 = NULL;
		_tmp1 = NULL;
		array_field = (_tmp2 = (_tmp1 = vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)), VALA_IS_FIELD (_tmp1) ? ((ValaField*) _tmp1) : NULL), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
		_tmp3 = FALSE;
		if (array_field == NULL) {
			_tmp3 = TRUE;
		} else {
			_tmp3 = !vala_field_get_no_array_length (array_field);
		}
		array = _tmp3;
		(array_field == NULL) ? NULL : (array_field = (vala_code_node_unref (array_field), NULL));
	} else {
		if (VALA_IS_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment)))) {
			ValaDelegateType* _tmp4;
			ValaDelegateType* delegate_type;
			_tmp4 = NULL;
			delegate_type = (_tmp4 = VALA_DELEGATE_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment))), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4));
			instance_delegate = vala_delegate_get_has_target (vala_delegate_type_get_delegate_symbol (delegate_type));
			(delegate_type == NULL) ? NULL : (delegate_type = (vala_code_node_unref (delegate_type), NULL));
		}
	}
	_tmp5 = FALSE;
	_tmp6 = FALSE;
	if (unref_old) {
		_tmp6 = TRUE;
	} else {
		_tmp6 = array;
	}
	if (_tmp6) {
		_tmp5 = TRUE;
	} else {
		_tmp5 = instance_delegate;
	}
	if (_tmp5) {
		ValaCCodeCommaExpression* ccomma;
		ValaLocalVariable* temp_decl;
		ValaCCodeAssignment* _tmp17;
		ValaCCodeExpression* _tmp16;
		ValaCCodeExpression* _tmp27;
		ValaCCodeExpression* _tmp29;
		ValaCCodeExpression* _tmp28;
		ccomma = vala_ccode_comma_expression_new ();
		if (!vala_ccode_base_module_is_pure_ccode_expression ((ValaCCodeBaseModule*) self, lhs)) {
			ValaCCodeCommaExpression* _tmp7;
			ValaDataType* lhs_value_type;
			char* lhs_temp_name;
			char* _tmp8;
			ValaLocalVariable* _tmp9;
			ValaLocalVariable* lhs_temp;
			ValaCCodeAssignment* _tmp12;
			ValaCCodeUnaryExpression* _tmp11;
			ValaCCodeExpression* _tmp10;
			ValaCCodeExpression* _tmp15;
			ValaCCodeUnaryExpression* _tmp14;
			ValaCCodeExpression* _tmp13;
			/* Assign lhs to temp var to avoid repeating side effect */
			_tmp7 = NULL;
			outer_ccomma = (_tmp7 = vala_ccode_comma_expression_new (), (outer_ccomma == NULL) ? NULL : (outer_ccomma = (vala_ccode_node_unref (outer_ccomma), NULL)), _tmp7);
			lhs_value_type = vala_data_type_copy (vala_expression_get_value_type (vala_assignment_get_left (assignment)));
			lhs_temp_name = g_strdup_printf ("_tmp%d", ((ValaCCodeBaseModule*) self)->next_temp_var_id++);
			_tmp8 = NULL;
			_tmp9 = NULL;
			lhs_temp = (_tmp9 = vala_local_variable_new (lhs_value_type, _tmp8 = g_strconcat ("*", lhs_temp_name, NULL), NULL, NULL), _tmp8 = (g_free (_tmp8), NULL), _tmp9);
			gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, lhs_temp);
			_tmp12 = NULL;
			_tmp11 = NULL;
			_tmp10 = NULL;
			vala_ccode_comma_expression_append_expression (outer_ccomma, (ValaCCodeExpression*) (_tmp12 = vala_ccode_assignment_new (_tmp10 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, lhs_temp_name), (ValaCCodeExpression*) (_tmp11 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, lhs)), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
			(_tmp12 == NULL) ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL));
			(_tmp11 == NULL) ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL));
			(_tmp10 == NULL) ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL));
			_tmp15 = NULL;
			_tmp14 = NULL;
			_tmp13 = NULL;
			lhs = (_tmp15 = (ValaCCodeExpression*) vala_ccode_parenthesized_expression_new ((ValaCCodeExpression*) (_tmp14 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, _tmp13 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, lhs_temp_name)))), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), _tmp15);
			(_tmp14 == NULL) ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL));
			(_tmp13 == NULL) ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL));
			(lhs_value_type == NULL) ? NULL : (lhs_value_type = (vala_code_node_unref (lhs_value_type), NULL));
			lhs_temp_name = (g_free (lhs_temp_name), NULL);
			(lhs_temp == NULL) ? NULL : (lhs_temp = (vala_code_node_unref (lhs_temp), NULL));
		}
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_assignment_get_left (assignment)), TRUE, NULL);
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		_tmp17 = NULL;
		_tmp16 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp17 = vala_ccode_assignment_new (_tmp16 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), rhs, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp17 == NULL) ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL));
		(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
		if (unref_old) {
			ValaCCodeExpression* _tmp18;
			/* unref old value */
			_tmp18 = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, _tmp18 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, lhs, vala_expression_get_value_type (vala_assignment_get_left (assignment)), vala_assignment_get_left (assignment)));
			(_tmp18 == NULL) ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL));
		}
		if (array) {
			ValaArrayType* _tmp19;
			ValaArrayType* array_type;
			_tmp19 = NULL;
			array_type = (_tmp19 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_assignment_get_left (assignment))), (_tmp19 == NULL) ? NULL : vala_code_node_ref (_tmp19));
			{
				gint dim;
				dim = 1;
				for (; dim <= vala_array_type_get_rank (array_type); dim++) {
					ValaCCodeExpression* lhs_array_len;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp20;
					lhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_assignment_get_left (assignment), dim);
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_assignment_get_right (assignment), dim);
					_tmp20 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp20 = vala_ccode_assignment_new (lhs_array_len, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp20 == NULL) ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL));
					(lhs_array_len == NULL) ? NULL : (lhs_array_len = (vala_ccode_node_unref (lhs_array_len), NULL));
					(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
				}
			}
			if (vala_array_type_get_rank (array_type) == 1) {
				ValaSymbol* _tmp21;
				ValaSymbol* array_var;
				gboolean _tmp22;
				gboolean _tmp23;
				_tmp21 = NULL;
				array_var = (_tmp21 = vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)), (_tmp21 == NULL) ? NULL : vala_code_node_ref (_tmp21));
				_tmp22 = FALSE;
				_tmp23 = FALSE;
				if (array_var != NULL) {
					_tmp23 = vala_symbol_is_internal_symbol (array_var);
				} else {
					_tmp23 = FALSE;
				}
				if (_tmp23) {
					gboolean _tmp24;
					_tmp24 = FALSE;
					if (VALA_IS_LOCAL_VARIABLE (array_var)) {
						_tmp24 = TRUE;
					} else {
						_tmp24 = VALA_IS_FIELD (array_var);
					}
					_tmp22 = _tmp24;
				} else {
					_tmp22 = FALSE;
				}
				if (_tmp22) {
					ValaCCodeExpression* lhs_array_size;
					ValaCCodeExpression* rhs_array_len;
					ValaCCodeAssignment* _tmp25;
					lhs_array_size = vala_ccode_module_get_array_size_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_assignment_get_left (assignment));
					rhs_array_len = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_assignment_get_left (assignment), 1);
					_tmp25 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp25 = vala_ccode_assignment_new (lhs_array_size, rhs_array_len, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp25 == NULL) ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL));
					(lhs_array_size == NULL) ? NULL : (lhs_array_size = (vala_ccode_node_unref (lhs_array_size), NULL));
					(rhs_array_len == NULL) ? NULL : (rhs_array_len = (vala_ccode_node_unref (rhs_array_len), NULL));
				}
				(array_var == NULL) ? NULL : (array_var = (vala_code_node_unref (array_var), NULL));
			}
			(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		} else {
			if (instance_delegate) {
				ValaCCodeExpression* lhs_delegate_target;
				ValaCCodeExpression* rhs_delegate_target;
				ValaCCodeAssignment* _tmp26;
				lhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_assignment_get_left (assignment));
				rhs_delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_assignment_get_right (assignment));
				_tmp26 = NULL;
				vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp26 = vala_ccode_assignment_new (lhs_delegate_target, rhs_delegate_target, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
				(_tmp26 == NULL) ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL));
				(lhs_delegate_target == NULL) ? NULL : (lhs_delegate_target = (vala_ccode_node_unref (lhs_delegate_target), NULL));
				(rhs_delegate_target == NULL) ? NULL : (rhs_delegate_target = (vala_ccode_node_unref (rhs_delegate_target), NULL));
			}
		}
		_tmp27 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, _tmp27 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)));
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp29 = NULL;
		_tmp28 = NULL;
		rhs = (_tmp29 = (_tmp28 = (ValaCCodeExpression*) ccomma, (_tmp28 == NULL) ? NULL : vala_ccode_node_ref (_tmp28)), (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), _tmp29);
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
	}
	cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE;
	if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_OR) {
		cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_OR;
	} else {
		if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_AND) {
			cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_AND;
		} else {
			if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_BITWISE_XOR) {
				cop = VALA_CCODE_ASSIGNMENT_OPERATOR_BITWISE_XOR;
			} else {
				if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
					cop = VALA_CCODE_ASSIGNMENT_OPERATOR_ADD;
				} else {
					if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
						cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SUB;
					} else {
						if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_MUL) {
							cop = VALA_CCODE_ASSIGNMENT_OPERATOR_MUL;
						} else {
							if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_DIV) {
								cop = VALA_CCODE_ASSIGNMENT_OPERATOR_DIV;
							} else {
								if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_PERCENT) {
									cop = VALA_CCODE_ASSIGNMENT_OPERATOR_PERCENT;
								} else {
									if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_LEFT) {
										cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_LEFT;
									} else {
										if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SHIFT_RIGHT) {
											cop = VALA_CCODE_ASSIGNMENT_OPERATOR_SHIFT_RIGHT;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	codenode = (ValaCCodeExpression*) vala_ccode_assignment_new (lhs, rhs, cop);
	if (outer_ccomma != NULL) {
		ValaCCodeExpression* _tmp31;
		ValaCCodeExpression* _tmp30;
		vala_ccode_comma_expression_append_expression (outer_ccomma, codenode);
		_tmp31 = NULL;
		_tmp30 = NULL;
		codenode = (_tmp31 = (_tmp30 = (ValaCCodeExpression*) outer_ccomma, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (codenode == NULL) ? NULL : (codenode = (vala_ccode_node_unref (codenode), NULL)), _tmp31);
	}
	_tmp32 = NULL;
	return (_tmp32 = codenode, (rhs == NULL) ? NULL : (rhs = (vala_ccode_node_unref (rhs), NULL)), (lhs == NULL) ? NULL : (lhs = (vala_ccode_node_unref (lhs), NULL)), (outer_ccomma == NULL) ? NULL : (outer_ccomma = (vala_ccode_node_unref (outer_ccomma), NULL)), _tmp32);
}


static void vala_ccode_assignment_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaCCodeAssignmentModule * self;
	gboolean _tmp0;
	self = (ValaCCodeAssignmentModule*) base;
	g_return_if_fail (assignment != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_assignment_get_right (assignment), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp0 = FALSE;
	if (vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_left (assignment))) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_right (assignment));
	}
	if (_tmp0) {
		vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
		return;
	}
	if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)))) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) (_tmp1 = vala_ccode_assignment_module_emit_property_assignment (self, assignment)));
		(_tmp1 == NULL) ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL));
	} else {
		ValaCCodeExpression* _tmp2;
		_tmp2 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) (_tmp2 = vala_ccode_assignment_module_emit_simple_assignment (self, assignment)));
		(_tmp2 == NULL) ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL));
	}
}


static void vala_ccode_assignment_module_class_init (ValaCCodeAssignmentModuleClass * klass) {
	vala_ccode_assignment_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_ccode_assignment_module_real_visit_assignment;
}


static void vala_ccode_assignment_module_instance_init (ValaCCodeAssignmentModule * self) {
}


GType vala_ccode_assignment_module_get_type (void) {
	static GType vala_ccode_assignment_module_type_id = 0;
	if (vala_ccode_assignment_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeAssignmentModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_assignment_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeAssignmentModule), 0, (GInstanceInitFunc) vala_ccode_assignment_module_instance_init, NULL };
		vala_ccode_assignment_module_type_id = g_type_register_static (VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, "ValaCCodeAssignmentModule", &g_define_type_info, 0);
	}
	return vala_ccode_assignment_module_type_id;
}




