/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_while_statement) (ValaCCodeModule* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCCodeModule* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCCodeModule* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	GeeSet* c_keywords;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean string_h_needed;
	gboolean gvaluecollector_h_needed;
	gboolean gio_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};



gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
enum  {
	VALA_CCODE_METHOD_CALL_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeAssignmentModule* vala_ccode_assignment_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_base_module_generate_method_declaration (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
gboolean vala_ccode_base_module_requires_copy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_dup_func_expression (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
ValaCCodeExpression* vala_ccode_base_module_get_destroy_func_expression (ValaCCodeBaseModule* self, ValaDataType* type);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
ValaCCodeExpression* vala_ccode_base_module_get_delegate_target_cexpression (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
ValaCCodeExpression* vala_ccode_base_module_handle_struct_argument (ValaCCodeBaseModule* self, ValaFormalParameter* param, ValaExpression* arg, ValaCCodeExpression* cexpr);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static gpointer vala_ccode_method_call_module_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMethodCallModule* vala_ccode_method_call_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaCCodeMethodCallModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type, codegen, next);
	return self;
}


ValaCCodeMethodCallModule* vala_ccode_method_call_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE, codegen, next);
}


static void vala_ccode_method_call_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeFunctionCall* async_call;
	ValaMethod* m;
	GeeList* params;
	ValaMemberAccess* _tmp1;
	ValaExpression* _tmp0;
	ValaMemberAccess* ma;
	ValaDataType* _tmp2;
	ValaDataType* itype;
	GeeList* _tmp3;
	GeeHashMap* in_arg_map;
	GeeHashMap* out_arg_map;
	gboolean _tmp18;
	gboolean _tmp19;
	ValaCCodeExpression* _tmp58;
	ValaCCodeExpression* ccall_expr;
	ValaCCodeExpression* instance;
	gboolean _tmp62;
	gboolean _tmp63;
	gboolean ellipsis;
	gint i;
	gint arg_pos;
	GeeIterator* params_it;
	gboolean _tmp207;
	gboolean _tmp223;
	gboolean _tmp234;
	gboolean _tmp245;
	gint last_pos;
	gint min_pos;
	gboolean _tmp265;
	gboolean _tmp266;
	gboolean _tmp268;
	gboolean _tmp269;
	gboolean _tmp270;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* the bare function call*/
	ccall = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))));
	async_call = NULL;
	m = NULL;
	params = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	ma = (_tmp1 = (_tmp0 = vala_method_call_get_call (expr), VALA_IS_MEMBER_ACCESS (_tmp0) ? ((ValaMemberAccess*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1));
	_tmp2 = NULL;
	itype = (_tmp2 = vala_expression_get_value_type (vala_method_call_get_call (expr)), (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	params = (_tmp3 = vala_data_type_get_parameters (itype), (params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL)), _tmp3);
	if (VALA_IS_METHOD_TYPE (itype)) {
		ValaMethod* _tmp5;
		ValaMethod* _tmp4;
		g_assert (ma != NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		m = (_tmp5 = (_tmp4 = vala_method_type_get_method_symbol (VALA_METHOD_TYPE (itype)), (_tmp4 == NULL) ? NULL : vala_code_node_ref (_tmp4)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp5);
	} else {
		if (VALA_IS_SIGNAL_TYPE (itype)) {
			ValaSignalType* _tmp6;
			ValaSignalType* sig_type;
			gboolean _tmp7;
			gboolean _tmp8;
			_tmp6 = NULL;
			sig_type = (_tmp6 = VALA_SIGNAL_TYPE (itype), (_tmp6 == NULL) ? NULL : vala_code_node_ref (_tmp6));
			_tmp7 = FALSE;
			_tmp8 = FALSE;
			if (ma != NULL) {
				_tmp8 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
			} else {
				_tmp8 = FALSE;
			}
			if (_tmp8) {
				_tmp7 = vala_signal_get_is_virtual (vala_signal_type_get_signal_symbol (sig_type));
			} else {
				_tmp7 = FALSE;
			}
			if (_tmp7) {
				ValaMethod* _tmp9;
				_tmp9 = NULL;
				m = (_tmp9 = vala_signal_get_method_handler (vala_signal_type_get_signal_symbol (sig_type)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp9);
			} else {
				ValaCCodeFunctionCall* _tmp11;
				ValaCCodeFunctionCall* _tmp10;
				_tmp11 = NULL;
				_tmp10 = NULL;
				ccall = (_tmp11 = (_tmp10 = VALA_CCODE_FUNCTION_CALL (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_method_call_get_call (expr))), (_tmp10 == NULL) ? NULL : vala_ccode_node_ref (_tmp10)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp11);
			}
			(sig_type == NULL) ? NULL : (sig_type = (vala_code_node_unref (sig_type), NULL));
		} else {
			if (VALA_IS_OBJECT_TYPE (itype)) {
				ValaClass* _tmp12;
				ValaClass* cl;
				ValaMethod* _tmp14;
				ValaMethod* _tmp13;
				ValaCCodeFunctionCall* _tmp17;
				ValaCCodeIdentifier* _tmp16;
				char* _tmp15;
				/* constructor*/
				_tmp12 = NULL;
				cl = (_tmp12 = VALA_CLASS (vala_object_type_get_type_symbol (VALA_OBJECT_TYPE (itype))), (_tmp12 == NULL) ? NULL : vala_code_node_ref (_tmp12));
				_tmp14 = NULL;
				_tmp13 = NULL;
				m = (_tmp14 = (_tmp13 = vala_class_get_default_construction_method (cl), (_tmp13 == NULL) ? NULL : vala_code_node_ref (_tmp13)), (m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL)), _tmp14);
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations);
				_tmp17 = NULL;
				_tmp16 = NULL;
				_tmp15 = NULL;
				ccall = (_tmp17 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16 = vala_ccode_identifier_new (_tmp15 = vala_method_get_real_cname (m)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp17);
				(_tmp16 == NULL) ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL));
				_tmp15 = (g_free (_tmp15), NULL);
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		}
	}
	in_arg_map = NULL;
	out_arg_map = NULL;
	_tmp18 = FALSE;
	_tmp19 = FALSE;
	if (m != NULL) {
		_tmp19 = vala_method_get_coroutine (m);
	} else {
		_tmp19 = FALSE;
	}
	if (_tmp19) {
		gboolean _tmp20;
		gboolean _tmp21;
		_tmp20 = FALSE;
		_tmp21 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp21 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp21 = FALSE;
		}
		if (_tmp21) {
			_tmp20 = TRUE;
		} else {
			gboolean _tmp22;
			_tmp22 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp22 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp22 = FALSE;
			}
			_tmp20 = _tmp22;
		}
		_tmp18 = _tmp20;
	} else {
		_tmp18 = FALSE;
	}
	if (_tmp18) {
		GeeHashMap* _tmp23;
		GeeHashMap* _tmp24;
		ValaCCodeFunctionCall* _tmp28;
		ValaCCodeIdentifier* _tmp27;
		char* _tmp26;
		char* _tmp25;
		gboolean _tmp29;
		/* async call*/
		_tmp23 = NULL;
		in_arg_map = (_tmp23 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp23);
		_tmp24 = NULL;
		out_arg_map = (_tmp24 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp24);
		_tmp28 = NULL;
		_tmp27 = NULL;
		_tmp26 = NULL;
		_tmp25 = NULL;
		async_call = (_tmp28 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp27 = vala_ccode_identifier_new (_tmp26 = g_strconcat (_tmp25 = vala_method_get_cname (m), "_async", NULL)))), (async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL)), _tmp28);
		(_tmp27 == NULL) ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL));
		_tmp26 = (g_free (_tmp26), NULL);
		_tmp25 = (g_free (_tmp25), NULL);
		_tmp29 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp29 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp29 = FALSE;
		}
		if (_tmp29) {
			ValaCCodeFunctionCall* _tmp31;
			ValaCCodeFunctionCall* _tmp30;
			/* no finish call*/
			_tmp31 = NULL;
			_tmp30 = NULL;
			ccall = (_tmp31 = (_tmp30 = async_call, (_tmp30 == NULL) ? NULL : vala_ccode_node_ref (_tmp30)), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp31);
		} else {
			ValaCCodeFunctionCall* _tmp35;
			ValaCCodeIdentifier* _tmp34;
			char* _tmp33;
			char* _tmp32;
			ValaCCodeMemberAccess* _tmp37;
			ValaCCodeIdentifier* _tmp36;
			_tmp35 = NULL;
			_tmp34 = NULL;
			_tmp33 = NULL;
			_tmp32 = NULL;
			ccall = (_tmp35 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp34 = vala_ccode_identifier_new (_tmp33 = g_strconcat (_tmp32 = vala_method_get_cname (m), "_finish", NULL)))), (ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)), _tmp35);
			(_tmp34 == NULL) ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL));
			_tmp33 = (g_free (_tmp33), NULL);
			_tmp32 = (g_free (_tmp32), NULL);
			/* pass GAsyncResult stored in closure to finish function*/
			_tmp37 = NULL;
			_tmp36 = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp37 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp36 = vala_ccode_identifier_new ("data")), "res")));
			(_tmp37 == NULL) ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL));
			(_tmp36 == NULL) ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL));
		}
	} else {
		GeeHashMap* _tmp38;
		GeeHashMap* _tmp40;
		GeeHashMap* _tmp39;
		_tmp38 = NULL;
		in_arg_map = (_tmp38 = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal), (in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL)), _tmp38);
		_tmp40 = NULL;
		_tmp39 = NULL;
		out_arg_map = (_tmp40 = (_tmp39 = in_arg_map, (_tmp39 == NULL) ? NULL : gee_collection_object_ref (_tmp39)), (out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL)), _tmp40);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCCodeIdentifier* _tmp41;
		_tmp41 = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp41 = vala_ccode_identifier_new ("object_type")));
		(_tmp41 == NULL) ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL));
		{
			GeeList* _tmp42;
			GeeIterator* _tmp43;
			GeeIterator* _base_type_it;
			_tmp42 = NULL;
			_tmp43 = NULL;
			_base_type_it = (_tmp43 = gee_iterable_iterator ((GeeIterable*) (_tmp42 = vala_class_get_base_types (((ValaCCodeBaseModule*) self)->current_class))), (_tmp42 == NULL) ? NULL : (_tmp42 = (gee_collection_object_unref (_tmp42), NULL)), _tmp43);
			while (gee_iterator_next (_base_type_it)) {
				ValaDataType* base_type;
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
					{
						GeeList* _tmp44;
						GeeIterator* _tmp45;
						GeeIterator* _type_arg_it;
						_tmp44 = NULL;
						_tmp45 = NULL;
						_type_arg_it = (_tmp45 = gee_iterable_iterator ((GeeIterable*) (_tmp44 = vala_data_type_get_type_arguments (base_type))), (_tmp44 == NULL) ? NULL : (_tmp44 = (gee_collection_object_unref (_tmp44), NULL)), _tmp45);
						while (gee_iterator_next (_type_arg_it)) {
							ValaDataType* type_arg;
							type_arg = (ValaDataType*) gee_iterator_get (_type_arg_it);
							if (VALA_IS_GENERIC_TYPE (type_arg)) {
								char* type_param;
								ValaCCodeIdentifier* _tmp47;
								char* _tmp46;
								ValaCCodeIdentifier* _tmp49;
								char* _tmp48;
								ValaCCodeIdentifier* _tmp51;
								char* _tmp50;
								/* map generic type parameter*/
								type_param = g_utf8_strdown (vala_symbol_get_name ((ValaSymbol*) vala_data_type_get_type_parameter (type_arg)), -1);
								_tmp47 = NULL;
								_tmp46 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp47 = vala_ccode_identifier_new (_tmp46 = g_strdup_printf ("%s_type", type_param))));
								(_tmp47 == NULL) ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL));
								_tmp46 = (g_free (_tmp46), NULL);
								_tmp49 = NULL;
								_tmp48 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49 = vala_ccode_identifier_new (_tmp48 = g_strdup_printf ("%s_dup_func", type_param))));
								(_tmp49 == NULL) ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL));
								_tmp48 = (g_free (_tmp48), NULL);
								_tmp51 = NULL;
								_tmp50 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp51 = vala_ccode_identifier_new (_tmp50 = g_strdup_printf ("%s_destroy_func", type_param))));
								(_tmp51 == NULL) ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL));
								_tmp50 = (g_free (_tmp50), NULL);
								type_param = (g_free (type_param), NULL);
							} else {
								ValaCCodeIdentifier* _tmp53;
								char* _tmp52;
								_tmp53 = NULL;
								_tmp52 = NULL;
								vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp53 = vala_ccode_identifier_new (_tmp52 = vala_data_type_get_type_id (type_arg))));
								(_tmp53 == NULL) ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL));
								_tmp52 = (g_free (_tmp52), NULL);
								if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, type_arg)) {
									ValaCCodeExpression* dup_func;
									ValaCCodeCastExpression* _tmp54;
									ValaCCodeExpression* _tmp55;
									dup_func = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, type_arg, vala_code_node_get_source_reference ((ValaCodeNode*) type_arg));
									if (dup_func == NULL) {
										/* type doesn't contain a copy function*/
										vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
										(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
										(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
										(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
										(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
										(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
										(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
										(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
										(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
										(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
										(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
										(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
										(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
										(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
										return;
									}
									_tmp54 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp54 = vala_ccode_cast_expression_new (dup_func, "GBoxedCopyFunc")));
									(_tmp54 == NULL) ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL));
									_tmp55 = NULL;
									vala_ccode_function_call_add_argument (ccall, _tmp55 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, type_arg));
									(_tmp55 == NULL) ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL));
									(dup_func == NULL) ? NULL : (dup_func = (vala_ccode_node_unref (dup_func), NULL));
								} else {
									ValaCCodeConstant* _tmp56;
									ValaCCodeConstant* _tmp57;
									_tmp56 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp56 = vala_ccode_constant_new ("NULL")));
									(_tmp56 == NULL) ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL));
									_tmp57 = NULL;
									vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp57 = vala_ccode_constant_new ("NULL")));
									(_tmp57 == NULL) ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL));
								}
							}
							(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
						}
						(_type_arg_it == NULL) ? NULL : (_type_arg_it = (gee_collection_object_unref (_type_arg_it), NULL));
					}
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					break;
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
	}
	/* the complete call expression, might include casts, comma expressions, and/or assignments*/
	_tmp58 = NULL;
	ccall_expr = (_tmp58 = (ValaCCodeExpression*) ccall, (_tmp58 == NULL) ? NULL : vala_ccode_node_ref (_tmp58));
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		ValaArrayType* _tmp59;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp61;
		char* _tmp60;
		_tmp59 = NULL;
		array_type = (_tmp59 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp59 == NULL) ? NULL : vala_code_node_ref (_tmp59));
		_tmp61 = NULL;
		_tmp60 = NULL;
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) 0, FALSE)), (ValaCCodeExpression*) (_tmp61 = vala_ccode_identifier_new (_tmp60 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp61 == NULL) ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL));
		_tmp60 = (g_free (_tmp60), NULL);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		}
	}
	instance = NULL;
	_tmp62 = FALSE;
	_tmp63 = FALSE;
	if (m != NULL) {
		_tmp63 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp63 = FALSE;
	}
	if (_tmp63) {
		_tmp62 = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp62 = FALSE;
	}
	if (_tmp62) {
		ValaCCodeExpression* _tmp65;
		ValaCCodeExpression* _tmp64;
		gboolean _tmp66;
		ValaStruct* _tmp71;
		ValaSymbol* _tmp70;
		ValaStruct* st;
		gboolean _tmp72;
		_tmp65 = NULL;
		_tmp64 = NULL;
		instance = (_tmp65 = (_tmp64 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp64 == NULL) ? NULL : vala_ccode_node_ref (_tmp64)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp65);
		_tmp66 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
			_tmp66 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
		} else {
			_tmp66 = FALSE;
		}
		if (_tmp66) {
			ValaMemberAccess* _tmp67;
			ValaMemberAccess* inner_ma;
			ValaCCodeExpression* _tmp69;
			ValaCCodeExpression* _tmp68;
			_tmp67 = NULL;
			inner_ma = (_tmp67 = VALA_MEMBER_ACCESS (vala_member_access_get_inner (ma)), (_tmp67 == NULL) ? NULL : vala_code_node_ref (_tmp67));
			_tmp69 = NULL;
			_tmp68 = NULL;
			instance = (_tmp69 = (_tmp68 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (inner_ma))), (_tmp68 == NULL) ? NULL : vala_ccode_node_ref (_tmp68)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp69);
			(inner_ma == NULL) ? NULL : (inner_ma = (vala_code_node_unref (inner_ma), NULL));
		}
		_tmp71 = NULL;
		_tmp70 = NULL;
		st = (_tmp71 = (_tmp70 = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_STRUCT (_tmp70) ? ((ValaStruct*) _tmp70) : NULL), (_tmp71 == NULL) ? NULL : vala_code_node_ref (_tmp71));
		_tmp72 = FALSE;
		if (st != NULL) {
			_tmp72 = !vala_struct_is_simple_type (st);
		} else {
			_tmp72 = FALSE;
		}
		if (_tmp72) {
			ValaCCodeUnaryExpression* _tmp74;
			ValaCCodeExpression* _tmp73;
			ValaCCodeUnaryExpression* unary;
			gboolean _tmp75;
			/* we need to pass struct instance by reference*/
			_tmp74 = NULL;
			_tmp73 = NULL;
			unary = (_tmp74 = (_tmp73 = instance, VALA_IS_CCODE_UNARY_EXPRESSION (_tmp73) ? ((ValaCCodeUnaryExpression*) _tmp73) : NULL), (_tmp74 == NULL) ? NULL : vala_ccode_node_ref (_tmp74));
			_tmp75 = FALSE;
			if (unary != NULL) {
				_tmp75 = vala_ccode_unary_expression_get_operator (unary) == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION;
			} else {
				_tmp75 = FALSE;
			}
			if (_tmp75) {
				ValaCCodeExpression* _tmp77;
				ValaCCodeExpression* _tmp76;
				/* *expr => expr*/
				_tmp77 = NULL;
				_tmp76 = NULL;
				instance = (_tmp77 = (_tmp76 = vala_ccode_unary_expression_get_inner (unary), (_tmp76 == NULL) ? NULL : vala_ccode_node_ref (_tmp76)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp77);
			} else {
				gboolean _tmp78;
				_tmp78 = FALSE;
				if (VALA_IS_CCODE_IDENTIFIER (instance)) {
					_tmp78 = TRUE;
				} else {
					_tmp78 = VALA_IS_CCODE_MEMBER_ACCESS (instance);
				}
				if (_tmp78) {
					ValaCCodeExpression* _tmp79;
					_tmp79 = NULL;
					instance = (_tmp79 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, instance), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp79);
				} else {
					ValaCCodeCommaExpression* ccomma;
					ValaLocalVariable* temp_var;
					ValaCCodeAssignment* _tmp81;
					ValaCCodeExpression* _tmp80;
					ValaCCodeUnaryExpression* _tmp83;
					ValaCCodeExpression* _tmp82;
					ValaCCodeExpression* _tmp85;
					ValaCCodeExpression* _tmp84;
					/* if instance is e.g. a function call, we can't take the address of the expression
					 (tmp = expr, &tmp)*/
					ccomma = vala_ccode_comma_expression_new ();
					temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_target_type (vala_member_access_get_inner (ma)), TRUE, NULL);
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp81 = NULL;
					_tmp80 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp81 = vala_ccode_assignment_new (_tmp80 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), instance, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
					(_tmp81 == NULL) ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL));
					(_tmp80 == NULL) ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL));
					_tmp83 = NULL;
					_tmp82 = NULL;
					vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp83 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp82 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)))));
					(_tmp83 == NULL) ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL));
					(_tmp82 == NULL) ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL));
					_tmp85 = NULL;
					_tmp84 = NULL;
					instance = (_tmp85 = (_tmp84 = (ValaCCodeExpression*) ccomma, (_tmp84 == NULL) ? NULL : vala_ccode_node_ref (_tmp84)), (instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL)), _tmp85);
					(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				}
			}
			(unary == NULL) ? NULL : (unary = (vala_ccode_node_unref (unary), NULL));
		}
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), instance);
		(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
	} else {
		gboolean _tmp86;
		_tmp86 = FALSE;
		if (m != NULL) {
			_tmp86 = vala_method_get_binding (m) == MEMBER_BINDING_CLASS;
		} else {
			_tmp86 = FALSE;
		}
		if (_tmp86) {
			ValaClass* _tmp87;
			ValaClass* cl;
			ValaCCodeIdentifier* _tmp90;
			char* _tmp89;
			char* _tmp88;
			ValaCCodeFunctionCall* _tmp91;
			ValaCCodeFunctionCall* cast;
			ValaCCodeExpression* klass;
			_tmp87 = NULL;
			cl = (_tmp87 = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp87 == NULL) ? NULL : vala_code_node_ref (_tmp87));
			_tmp90 = NULL;
			_tmp89 = NULL;
			_tmp88 = NULL;
			_tmp91 = NULL;
			cast = (_tmp91 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp90 = vala_ccode_identifier_new (_tmp89 = g_strconcat (_tmp88 = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) cl, NULL), "_CLASS", NULL)))), (_tmp90 == NULL) ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)), _tmp89 = (g_free (_tmp89), NULL), _tmp88 = (g_free (_tmp88), NULL), _tmp91);
			klass = NULL;
			if (vala_member_access_get_inner (ma) == NULL) {
				if (((ValaCCodeBaseModule*) self)->in_static_or_class_ctor) {
					ValaCCodeExpression* _tmp92;
					/* Accessing the method from a static or class constructor*/
					_tmp92 = NULL;
					klass = (_tmp92 = (ValaCCodeExpression*) vala_ccode_identifier_new ("klass"), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp92);
				} else {
					ValaCCodeIdentifier* _tmp93;
					ValaCCodeFunctionCall* _tmp94;
					ValaCCodeFunctionCall* k;
					ValaCCodeIdentifier* _tmp95;
					ValaCCodeExpression* _tmp97;
					ValaCCodeExpression* _tmp96;
					/* Accessing the method from within an instance method*/
					_tmp93 = NULL;
					_tmp94 = NULL;
					k = (_tmp94 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp93 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp93 == NULL) ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)), _tmp94);
					_tmp95 = NULL;
					vala_ccode_function_call_add_argument (k, (ValaCCodeExpression*) (_tmp95 = vala_ccode_identifier_new ("self")));
					(_tmp95 == NULL) ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL));
					_tmp97 = NULL;
					_tmp96 = NULL;
					klass = (_tmp97 = (_tmp96 = (ValaCCodeExpression*) k, (_tmp96 == NULL) ? NULL : vala_ccode_node_ref (_tmp96)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp97);
					(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
				}
			} else {
				ValaCCodeIdentifier* _tmp98;
				ValaCCodeFunctionCall* _tmp99;
				ValaCCodeFunctionCall* k;
				ValaCCodeExpression* _tmp101;
				ValaCCodeExpression* _tmp100;
				/* Accessing the method of an instance*/
				_tmp98 = NULL;
				_tmp99 = NULL;
				k = (_tmp99 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp98 = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS"))), (_tmp98 == NULL) ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL)), _tmp99);
				vala_ccode_function_call_add_argument (k, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
				_tmp101 = NULL;
				_tmp100 = NULL;
				klass = (_tmp101 = (_tmp100 = (ValaCCodeExpression*) k, (_tmp100 == NULL) ? NULL : vala_ccode_node_ref (_tmp100)), (klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL)), _tmp101);
				(k == NULL) ? NULL : (k = (vala_ccode_node_unref (k), NULL));
			}
			vala_ccode_function_call_add_argument (cast, klass);
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cinstance_parameter_position (m), FALSE)), (ValaCCodeExpression*) cast);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			(cast == NULL) ? NULL : (cast = (vala_ccode_node_unref (cast), NULL));
			(klass == NULL) ? NULL : (klass = (vala_ccode_node_unref (klass), NULL));
		}
	}
	if (VALA_IS_ARRAY_MOVE_METHOD (m)) {
		ValaArrayType* _tmp102;
		ValaArrayType* array_type;
		ValaCCodeIdentifier* _tmp103;
		ValaCCodeFunctionCall* _tmp104;
		ValaCCodeFunctionCall* csizeof;
		ValaCCodeIdentifier* _tmp106;
		char* _tmp105;
		_tmp102 = NULL;
		array_type = (_tmp102 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp102 == NULL) ? NULL : vala_code_node_ref (_tmp102));
		_tmp103 = NULL;
		_tmp104 = NULL;
		csizeof = (_tmp104 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp103 = vala_ccode_identifier_new ("sizeof"))), (_tmp103 == NULL) ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)), _tmp104);
		_tmp106 = NULL;
		_tmp105 = NULL;
		vala_ccode_function_call_add_argument (csizeof, (ValaCCodeExpression*) (_tmp106 = vala_ccode_identifier_new (_tmp105 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))));
		(_tmp106 == NULL) ? NULL : (_tmp106 = (vala_ccode_node_unref (_tmp106), NULL));
		_tmp105 = (g_free (_tmp105), NULL);
		gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) csizeof);
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
	} else {
		if (VALA_IS_DYNAMIC_METHOD (m)) {
			gint param_nr;
			vala_method_clear_parameters (m);
			param_nr = 1;
			{
				GeeList* _tmp107;
				GeeIterator* _tmp108;
				GeeIterator* _arg_it;
				_tmp107 = NULL;
				_tmp108 = NULL;
				_arg_it = (_tmp108 = gee_iterable_iterator ((GeeIterable*) (_tmp107 = vala_method_call_get_argument_list (expr))), (_tmp107 == NULL) ? NULL : (_tmp107 = (gee_collection_object_unref (_tmp107), NULL)), _tmp108);
				while (gee_iterator_next (_arg_it)) {
					ValaExpression* arg;
					ValaUnaryExpression* _tmp110;
					ValaExpression* _tmp109;
					ValaUnaryExpression* unary;
					gboolean _tmp111;
					arg = (ValaExpression*) gee_iterator_get (_arg_it);
					_tmp110 = NULL;
					_tmp109 = NULL;
					unary = (_tmp110 = (_tmp109 = arg, VALA_IS_UNARY_EXPRESSION (_tmp109) ? ((ValaUnaryExpression*) _tmp109) : NULL), (_tmp110 == NULL) ? NULL : vala_code_node_ref (_tmp110));
					_tmp111 = FALSE;
					if (unary != NULL) {
						_tmp111 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp111 = FALSE;
					}
					if (_tmp111) {
						char* _tmp112;
						ValaFormalParameter* _tmp113;
						ValaFormalParameter* param;
						/* out argument*/
						_tmp112 = NULL;
						_tmp113 = NULL;
						param = (_tmp113 = vala_formal_parameter_new (_tmp112 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp112 = (g_free (_tmp112), NULL), _tmp113);
						vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_OUT);
						vala_method_add_parameter (m, param);
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					} else {
						gboolean _tmp114;
						_tmp114 = FALSE;
						if (unary != NULL) {
							_tmp114 = vala_unary_expression_get_operator (unary) == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp114 = FALSE;
						}
						if (_tmp114) {
							char* _tmp115;
							ValaFormalParameter* _tmp116;
							ValaFormalParameter* param;
							/* ref argument*/
							_tmp115 = NULL;
							_tmp116 = NULL;
							param = (_tmp116 = vala_formal_parameter_new (_tmp115 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), NULL), _tmp115 = (g_free (_tmp115), NULL), _tmp116);
							vala_formal_parameter_set_direction (param, VALA_PARAMETER_DIRECTION_REF);
							vala_method_add_parameter (m, param);
							(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						} else {
							ValaFormalParameter* _tmp118;
							char* _tmp117;
							/* in argument*/
							_tmp118 = NULL;
							_tmp117 = NULL;
							vala_method_add_parameter (m, _tmp118 = vala_formal_parameter_new (_tmp117 = g_strdup_printf ("param%d", param_nr), vala_expression_get_value_type (arg), NULL));
							(_tmp118 == NULL) ? NULL : (_tmp118 = (vala_code_node_unref (_tmp118), NULL));
							_tmp117 = (g_free (_tmp117), NULL);
						}
					}
					param_nr++;
					(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
					(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
				}
				(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
			}
			{
				GeeList* _tmp119;
				GeeIterator* _tmp120;
				GeeIterator* _param_it;
				_tmp119 = NULL;
				_tmp120 = NULL;
				_param_it = (_tmp120 = gee_iterable_iterator ((GeeIterable*) (_tmp119 = vala_method_get_parameters (m))), (_tmp119 == NULL) ? NULL : (_tmp119 = (gee_collection_object_unref (_tmp119), NULL)), _tmp120);
				while (gee_iterator_next (_param_it)) {
					ValaFormalParameter* param;
					param = (ValaFormalParameter*) gee_iterator_get (_param_it);
					vala_code_node_accept ((ValaCodeNode*) param, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
				}
				(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
			}
			vala_ccode_module_generate_dynamic_method_wrapper (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_METHOD (m));
		} else {
			if (VALA_IS_CREATION_METHOD (m)) {
				ValaCCodeExpression* _tmp125;
				ValaCCodeCastExpression* _tmp124;
				char* _tmp123;
				char* _tmp122;
				ValaCCodeIdentifier* _tmp121;
				_tmp125 = NULL;
				_tmp124 = NULL;
				_tmp123 = NULL;
				_tmp122 = NULL;
				_tmp121 = NULL;
				ccall_expr = (_tmp125 = (ValaCCodeExpression*) vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp121 = vala_ccode_identifier_new ("self")), (ValaCCodeExpression*) (_tmp124 = vala_ccode_cast_expression_new ((ValaCCodeExpression*) ccall, _tmp123 = g_strconcat (_tmp122 = vala_typesymbol_get_cname ((ValaTypeSymbol*) ((ValaCCodeBaseModule*) self)->current_class, FALSE), "*", NULL))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp125);
				(_tmp124 == NULL) ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL));
				_tmp123 = (g_free (_tmp123), NULL);
				_tmp122 = (g_free (_tmp122), NULL);
				(_tmp121 == NULL) ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL));
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	arg_pos = 0;
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	{
		GeeList* _tmp126;
		GeeIterator* _tmp127;
		GeeIterator* _arg_it;
		_tmp126 = NULL;
		_tmp127 = NULL;
		_arg_it = (_tmp127 = gee_iterable_iterator ((GeeIterable*) (_tmp126 = vala_method_call_get_argument_list (expr))), (_tmp126 == NULL) ? NULL : (_tmp126 = (gee_collection_object_unref (_tmp126), NULL)), _tmp127);
		while (gee_iterator_next (_arg_it)) {
			ValaExpression* arg;
			ValaCCodeExpression* _tmp128;
			ValaCCodeExpression* cexpr;
			GeeHashMap* _tmp129;
			GeeHashMap* carg_map;
			arg = (ValaExpression*) gee_iterator_get (_arg_it);
			_tmp128 = NULL;
			cexpr = (_tmp128 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)), (_tmp128 == NULL) ? NULL : vala_ccode_node_ref (_tmp128));
			_tmp129 = NULL;
			carg_map = (_tmp129 = in_arg_map, (_tmp129 == NULL) ? NULL : gee_collection_object_ref (_tmp129));
			if (gee_iterator_next (params_it)) {
				ValaFormalParameter* param;
				gboolean _tmp130;
				param = (ValaFormalParameter*) gee_iterator_get (params_it);
				_tmp130 = FALSE;
				if (vala_formal_parameter_get_params_array (param)) {
					_tmp130 = TRUE;
				} else {
					_tmp130 = vala_formal_parameter_get_ellipsis (param);
				}
				ellipsis = _tmp130;
				if (!ellipsis) {
					gboolean _tmp131;
					gboolean _tmp132;
					gboolean multiple_cargs;
					gboolean _tmp139;
					ValaCCodeExpression* _tmp169;
					gboolean _tmp170;
					gboolean _tmp176;
					gboolean _tmp177;
					gboolean _tmp178;
					_tmp131 = FALSE;
					_tmp132 = FALSE;
					if (vala_formal_parameter_get_async_only (param)) {
						gboolean _tmp133;
						_tmp133 = FALSE;
						if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
							_tmp133 = TRUE;
						} else {
							_tmp133 = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
						}
						_tmp132 = _tmp133;
					} else {
						_tmp132 = FALSE;
					}
					if (_tmp132) {
						gboolean _tmp134;
						_tmp134 = FALSE;
						if (ma == NULL) {
							_tmp134 = TRUE;
						} else {
							_tmp134 = _vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0;
						}
						_tmp131 = _tmp134;
					} else {
						_tmp131 = FALSE;
					}
					if (_tmp131) {
						ValaCCodeCommaExpression* comma;
						ValaCCodeExpression* _tmp136;
						ValaCCodeExpression* _tmp135;
						/* only skip if we are in a sync function (or property handler) 
						 and not manually starting async 
						 [CCode (async_only = true)] and we're making a
						 * synchronous version of the call.  Emit the arg
						 * at the start of a comma expression so that we
						 * get any side effects but otherwise ignore the
						 * value.
						 */
						comma = vala_ccode_comma_expression_new ();
						vala_ccode_comma_expression_append_expression (comma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) arg)));
						vala_ccode_comma_expression_append_expression (comma, ccall_expr);
						_tmp136 = NULL;
						_tmp135 = NULL;
						ccall_expr = (_tmp136 = (_tmp135 = (ValaCCodeExpression*) comma, (_tmp135 == NULL) ? NULL : vala_ccode_node_ref (_tmp135)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp136);
						(comma == NULL) ? NULL : (comma = (vala_ccode_node_unref (comma), NULL));
						(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
						(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
						(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
						(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
						continue;
					}
					/* if the vala argument expands to multiple C arguments,
					 we have to make sure that the C arguments don't depend
					 on each other as there is no guaranteed argument
					 evaluation order
					 http://bugzilla.gnome.org/show_bug.cgi?id=519597*/
					multiple_cargs = FALSE;
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
						GeeHashMap* _tmp138;
						GeeHashMap* _tmp137;
						_tmp138 = NULL;
						_tmp137 = NULL;
						carg_map = (_tmp138 = (_tmp137 = out_arg_map, (_tmp137 == NULL) ? NULL : gee_collection_object_ref (_tmp137)), (carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL)), _tmp138);
					}
					_tmp139 = FALSE;
					if (!vala_formal_parameter_get_no_array_length (param)) {
						_tmp139 = VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp139 = FALSE;
					}
					if (_tmp139) {
						ValaArrayType* _tmp140;
						ValaArrayType* array_type;
						_tmp140 = NULL;
						array_type = (_tmp140 = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp140 == NULL) ? NULL : vala_code_node_ref (_tmp140));
						{
							gint dim;
							dim = 1;
							for (; dim <= vala_array_type_get_rank (array_type); dim++) {
								ValaCCodeExpression* _tmp141;
								_tmp141 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_carray_length_parameter_position (param) + (0.01 * dim), FALSE)), _tmp141 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), arg, dim));
								(_tmp141 == NULL) ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL));
							}
						}
						multiple_cargs = TRUE;
						(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
					} else {
						if (VALA_IS_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaDelegateType* _tmp142;
							ValaDelegateType* deleg_type;
							ValaDelegate* _tmp143;
							ValaDelegate* d;
							_tmp142 = NULL;
							deleg_type = (_tmp142 = VALA_DELEGATE_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp142 == NULL) ? NULL : vala_code_node_ref (_tmp142));
							_tmp143 = NULL;
							d = (_tmp143 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp143 == NULL) ? NULL : vala_code_node_ref (_tmp143));
							if (vala_delegate_get_has_target (d)) {
								ValaCCodeExpression* delegate_target;
								delegate_target = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg);
								if (vala_data_type_get_value_owned ((ValaDataType*) deleg_type)) {
									ValaCCodeExpression* delegate_target_destroy_notify;
									ValaMethod* _tmp145;
									ValaSymbol* _tmp144;
									ValaMethod* delegate_method;
									ValaLambdaExpression* _tmp147;
									ValaExpression* _tmp146;
									ValaLambdaExpression* lambda;
									ValaMemberAccess* _tmp149;
									ValaExpression* _tmp148;
									ValaMemberAccess* arg_ma;
									gboolean _tmp150;
									gboolean _tmp151;
									delegate_target_destroy_notify = NULL;
									_tmp145 = NULL;
									_tmp144 = NULL;
									delegate_method = (_tmp145 = (_tmp144 = vala_expression_get_symbol_reference (arg), VALA_IS_METHOD (_tmp144) ? ((ValaMethod*) _tmp144) : NULL), (_tmp145 == NULL) ? NULL : vala_code_node_ref (_tmp145));
									_tmp147 = NULL;
									_tmp146 = NULL;
									lambda = (_tmp147 = (_tmp146 = arg, VALA_IS_LAMBDA_EXPRESSION (_tmp146) ? ((ValaLambdaExpression*) _tmp146) : NULL), (_tmp147 == NULL) ? NULL : vala_code_node_ref (_tmp147));
									_tmp149 = NULL;
									_tmp148 = NULL;
									arg_ma = (_tmp149 = (_tmp148 = arg, VALA_IS_MEMBER_ACCESS (_tmp148) ? ((ValaMemberAccess*) _tmp148) : NULL), (_tmp149 == NULL) ? NULL : vala_code_node_ref (_tmp149));
									_tmp150 = FALSE;
									_tmp151 = FALSE;
									if (lambda != NULL) {
										_tmp151 = ((ValaCCodeBaseModule*) self)->current_method != NULL;
									} else {
										_tmp151 = FALSE;
									}
									if (_tmp151) {
										_tmp150 = vala_method_get_binding (((ValaCCodeBaseModule*) self)->current_method) == MEMBER_BINDING_INSTANCE;
									} else {
										_tmp150 = FALSE;
									}
									if (_tmp150) {
										ValaCCodeExpression* _tmp152;
										ValaCCodeFunctionCall* _tmp153;
										ValaCCodeFunctionCall* ref_call;
										ValaCCodeExpression* _tmp155;
										ValaCCodeExpression* _tmp154;
										ValaCCodeExpression* _tmp156;
										/* type of delegate target is same as `this'
										 for lambda expressions in instance methods*/
										_tmp152 = NULL;
										_tmp153 = NULL;
										ref_call = (_tmp153 = vala_ccode_function_call_new (_tmp152 = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp152 == NULL) ? NULL : (_tmp152 = (vala_ccode_node_unref (_tmp152), NULL)), _tmp153);
										vala_ccode_function_call_add_argument (ref_call, delegate_target);
										_tmp155 = NULL;
										_tmp154 = NULL;
										delegate_target = (_tmp155 = (_tmp154 = (ValaCCodeExpression*) ref_call, (_tmp154 == NULL) ? NULL : vala_ccode_node_ref (_tmp154)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp155);
										_tmp156 = NULL;
										delegate_target_destroy_notify = (_tmp156 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (vala_method_get_this_parameter (((ValaCCodeBaseModule*) self)->current_method))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp156);
										(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
									} else {
										gboolean _tmp157;
										gboolean _tmp158;
										gboolean _tmp159;
										gboolean _tmp160;
										gboolean _tmp161;
										_tmp157 = FALSE;
										_tmp158 = FALSE;
										_tmp159 = FALSE;
										_tmp160 = FALSE;
										_tmp161 = FALSE;
										if (delegate_method != NULL) {
											_tmp161 = vala_method_get_binding (delegate_method) == MEMBER_BINDING_INSTANCE;
										} else {
											_tmp161 = FALSE;
										}
										if (_tmp161) {
											_tmp160 = arg_ma != NULL;
										} else {
											_tmp160 = FALSE;
										}
										if (_tmp160) {
											_tmp159 = vala_member_access_get_inner (arg_ma) != NULL;
										} else {
											_tmp159 = FALSE;
										}
										if (_tmp159) {
											_tmp158 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))) != NULL;
										} else {
											_tmp158 = FALSE;
										}
										if (_tmp158) {
											_tmp157 = vala_typesymbol_is_reference_counting (vala_data_type_get_data_type (vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))));
										} else {
											_tmp157 = FALSE;
										}
										if (_tmp157) {
											ValaCCodeExpression* _tmp162;
											ValaCCodeFunctionCall* _tmp163;
											ValaCCodeFunctionCall* ref_call;
											ValaCCodeExpression* _tmp165;
											ValaCCodeExpression* _tmp164;
											ValaCCodeExpression* _tmp166;
											_tmp162 = NULL;
											_tmp163 = NULL;
											ref_call = (_tmp163 = vala_ccode_function_call_new (_tmp162 = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma)), vala_code_node_get_source_reference ((ValaCodeNode*) arg))), (_tmp162 == NULL) ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)), _tmp163);
											vala_ccode_function_call_add_argument (ref_call, delegate_target);
											_tmp165 = NULL;
											_tmp164 = NULL;
											delegate_target = (_tmp165 = (_tmp164 = (ValaCCodeExpression*) ref_call, (_tmp164 == NULL) ? NULL : vala_ccode_node_ref (_tmp164)), (delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL)), _tmp165);
											_tmp166 = NULL;
											delegate_target_destroy_notify = (_tmp166 = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_member_access_get_inner (arg_ma))), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp166);
											(ref_call == NULL) ? NULL : (ref_call = (vala_ccode_node_unref (ref_call), NULL));
										} else {
											ValaCCodeExpression* _tmp167;
											_tmp167 = NULL;
											delegate_target_destroy_notify = (_tmp167 = (ValaCCodeExpression*) vala_ccode_constant_new ("NULL"), (delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL)), _tmp167);
										}
									}
									gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param) + 0.01, FALSE)), delegate_target_destroy_notify);
									(delegate_target_destroy_notify == NULL) ? NULL : (delegate_target_destroy_notify = (vala_ccode_node_unref (delegate_target_destroy_notify), NULL));
									(delegate_method == NULL) ? NULL : (delegate_method = (vala_code_node_unref (delegate_method), NULL));
									(lambda == NULL) ? NULL : (lambda = (vala_code_node_unref (lambda), NULL));
									(arg_ma == NULL) ? NULL : (arg_ma = (vala_code_node_unref (arg_ma), NULL));
								}
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), delegate_target);
								multiple_cargs = TRUE;
								(delegate_target == NULL) ? NULL : (delegate_target = (vala_ccode_node_unref (delegate_target), NULL));
							}
							(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
							(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
						} else {
							if (VALA_IS_METHOD_TYPE (vala_formal_parameter_get_parameter_type (param))) {
								ValaCCodeExpression* _tmp168;
								_tmp168 = NULL;
								gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cdelegate_target_parameter_position (param), FALSE)), _tmp168 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, arg));
								(_tmp168 == NULL) ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL));
								multiple_cargs = TRUE;
							}
						}
					}
					_tmp169 = NULL;
					cexpr = (_tmp169 = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, param, arg, cexpr), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp169);
					_tmp170 = FALSE;
					if (multiple_cargs) {
						_tmp170 = VALA_IS_METHOD_CALL (arg);
					} else {
						_tmp170 = FALSE;
					}
					if (_tmp170) {
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_decl;
						ValaCCodeAssignment* _tmp172;
						ValaCCodeExpression* _tmp171;
						ValaCCodeExpression* _tmp173;
						ValaCCodeExpression* _tmp175;
						ValaCCodeExpression* _tmp174;
						/* if vala argument is invocation expression
						 the auxiliary C argument(s) will depend on the main C argument
						 (tmp = arg1, call (tmp, arg2, arg3,...))*/
						ccomma = vala_ccode_comma_expression_new ();
						temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg), TRUE, NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
						_tmp172 = NULL;
						_tmp171 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp172 = vala_ccode_assignment_new (_tmp171 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl)), cexpr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp172 == NULL) ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL));
						(_tmp171 == NULL) ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL));
						_tmp173 = NULL;
						cexpr = (_tmp173 = (ValaCCodeExpression*) vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp173);
						vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						_tmp175 = NULL;
						_tmp174 = NULL;
						ccall_expr = (_tmp175 = (_tmp174 = (ValaCCodeExpression*) ccomma, (_tmp174 == NULL) ? NULL : vala_ccode_node_ref (_tmp174)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp175);
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
					}
					_tmp176 = FALSE;
					_tmp177 = FALSE;
					_tmp178 = FALSE;
					if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						_tmp178 = vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (arg));
					} else {
						_tmp178 = FALSE;
					}
					if (_tmp178) {
						gboolean _tmp179;
						_tmp179 = FALSE;
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
							_tmp179 = TRUE;
						} else {
							_tmp179 = !vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param));
						}
						_tmp177 = _tmp179;
					} else {
						_tmp177 = FALSE;
					}
					if (_tmp177) {
						_tmp176 = !VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param));
					} else {
						_tmp176 = FALSE;
					}
					/* unref old value for non-null non-weak ref/out arguments
					 disabled for arrays for now as that requires special handling
					 (ret_tmp = call (&tmp), var1 = (assign_tmp = dup (tmp), free (var1), assign_tmp), ret_tmp)*/
					if (_tmp176) {
						ValaUnaryExpression* _tmp180;
						ValaUnaryExpression* unary;
						ValaCCodeCommaExpression* ccomma;
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* _tmp182;
						ValaCCodeExpression* _tmp181;
						ValaLocalVariable* ret_temp_var;
						ValaDataType* _tmp187;
						gboolean _tmp188;
						ValaCCodeCommaExpression* cassign_comma;
						ValaLocalVariable* assign_temp_var;
						ValaCCodeAssignment* _tmp196;
						ValaCCodeExpression* _tmp195;
						ValaCCodeExpression* _tmp194;
						ValaCCodeExpression* _tmp193;
						ValaCCodeExpression* _tmp197;
						ValaCCodeExpression* _tmp198;
						ValaCCodeAssignment* _tmp199;
						ValaDataType* _tmp200;
						gboolean _tmp201;
						ValaCCodeExpression* _tmp204;
						ValaCCodeExpression* _tmp203;
						_tmp180 = NULL;
						unary = (_tmp180 = VALA_UNARY_EXPRESSION (arg), (_tmp180 == NULL) ? NULL : vala_code_node_ref (_tmp180));
						ccomma = vala_ccode_comma_expression_new ();
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_parameter_type (param), vala_data_type_get_value_owned (vala_formal_parameter_get_parameter_type (param)), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp182 = NULL;
						_tmp181 = NULL;
						cexpr = (_tmp182 = (ValaCCodeExpression*) vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp181 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var))), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp182);
						(_tmp181 == NULL) ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL));
						if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_REF) {
							ValaCCodeCommaExpression* crefcomma;
							ValaCCodeAssignment* _tmp184;
							ValaCCodeExpression* _tmp183;
							ValaCCodeExpression* _tmp186;
							ValaCCodeExpression* _tmp185;
							crefcomma = vala_ccode_comma_expression_new ();
							_tmp184 = NULL;
							_tmp183 = NULL;
							vala_ccode_comma_expression_append_expression (crefcomma, (ValaCCodeExpression*) (_tmp184 = vala_ccode_assignment_new (_tmp183 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp184 == NULL) ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL));
							(_tmp183 == NULL) ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL));
							vala_ccode_comma_expression_append_expression (crefcomma, cexpr);
							_tmp186 = NULL;
							_tmp185 = NULL;
							cexpr = (_tmp186 = (_tmp185 = (ValaCCodeExpression*) crefcomma, (_tmp185 == NULL) ? NULL : vala_ccode_node_ref (_tmp185)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp186);
							(crefcomma == NULL) ? NULL : (crefcomma = (vala_ccode_node_unref (crefcomma), NULL));
						}
						/* call function*/
						ret_temp_var = NULL;
						_tmp187 = NULL;
						if ((_tmp188 = VALA_IS_VOID_TYPE (_tmp187 = vala_data_type_get_return_type (itype)), (_tmp187 == NULL) ? NULL : (_tmp187 = (vala_code_node_unref (_tmp187), NULL)), _tmp188)) {
							vala_ccode_comma_expression_append_expression (ccomma, ccall_expr);
						} else {
							ValaLocalVariable* _tmp190;
							ValaDataType* _tmp189;
							ValaCCodeAssignment* _tmp192;
							ValaCCodeExpression* _tmp191;
							_tmp190 = NULL;
							_tmp189 = NULL;
							ret_temp_var = (_tmp190 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp189 = vala_data_type_get_return_type (itype), TRUE, NULL), (ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL)), _tmp190);
							(_tmp189 == NULL) ? NULL : (_tmp189 = (vala_code_node_unref (_tmp189), NULL));
							gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, ret_temp_var);
							_tmp192 = NULL;
							_tmp191 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp192 = vala_ccode_assignment_new (_tmp191 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)), ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
							(_tmp192 == NULL) ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL));
							(_tmp191 == NULL) ? NULL : (_tmp191 = (vala_ccode_node_unref (_tmp191), NULL));
						}
						cassign_comma = vala_ccode_comma_expression_new ();
						assign_temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), vala_data_type_get_value_owned (vala_expression_get_value_type (vala_unary_expression_get_inner (unary))), NULL);
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, assign_temp_var);
						_tmp196 = NULL;
						_tmp195 = NULL;
						_tmp194 = NULL;
						_tmp193 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, (ValaCCodeExpression*) (_tmp196 = vala_ccode_assignment_new (_tmp193 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)), _tmp195 = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, _tmp194 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var)), vala_formal_parameter_get_parameter_type (param), vala_expression_get_value_type (vala_unary_expression_get_inner (unary)), arg), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp196 == NULL) ? NULL : (_tmp196 = (vala_ccode_node_unref (_tmp196), NULL));
						(_tmp195 == NULL) ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL));
						(_tmp194 == NULL) ? NULL : (_tmp194 = (vala_ccode_node_unref (_tmp194), NULL));
						(_tmp193 == NULL) ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL));
						/* unref old value*/
						_tmp197 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp197 = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), vala_expression_get_value_type (arg), arg));
						(_tmp197 == NULL) ? NULL : (_tmp197 = (vala_ccode_node_unref (_tmp197), NULL));
						_tmp198 = NULL;
						vala_ccode_comma_expression_append_expression (cassign_comma, _tmp198 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) assign_temp_var)));
						(_tmp198 == NULL) ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL));
						/* assign new value*/
						_tmp199 = NULL;
						vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp199 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_unary_expression_get_inner (unary))), (ValaCCodeExpression*) cassign_comma, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
						(_tmp199 == NULL) ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL));
						/* return value*/
						_tmp200 = NULL;
						if ((_tmp201 = !VALA_IS_VOID_TYPE (_tmp200 = vala_data_type_get_return_type (itype)), (_tmp200 == NULL) ? NULL : (_tmp200 = (vala_code_node_unref (_tmp200), NULL)), _tmp201)) {
							ValaCCodeExpression* _tmp202;
							_tmp202 = NULL;
							vala_ccode_comma_expression_append_expression (ccomma, _tmp202 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) ret_temp_var)));
							(_tmp202 == NULL) ? NULL : (_tmp202 = (vala_ccode_node_unref (_tmp202), NULL));
						}
						_tmp204 = NULL;
						_tmp203 = NULL;
						ccall_expr = (_tmp204 = (_tmp203 = (ValaCCodeExpression*) ccomma, (_tmp203 == NULL) ? NULL : vala_ccode_node_ref (_tmp203)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp204);
						(unary == NULL) ? NULL : (unary = (vala_code_node_unref (unary), NULL));
						(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(ret_temp_var == NULL) ? NULL : (ret_temp_var = (vala_code_node_unref (ret_temp_var), NULL));
						(cassign_comma == NULL) ? NULL : (cassign_comma = (vala_ccode_node_unref (cassign_comma), NULL));
						(assign_temp_var == NULL) ? NULL : (assign_temp_var = (vala_code_node_unref (assign_temp_var), NULL));
					}
					if (vala_formal_parameter_get_ctype (param) != NULL) {
						ValaCCodeExpression* _tmp205;
						_tmp205 = NULL;
						cexpr = (_tmp205 = (ValaCCodeExpression*) vala_ccode_cast_expression_new (cexpr, vala_formal_parameter_get_ctype (param)), (cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL)), _tmp205);
					}
				}
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_formal_parameter_get_cparameter_position (param), ellipsis);
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			} else {
				/* default argument position*/
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) i, ellipsis);
			}
			gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (arg_pos), cexpr);
			i++;
			(arg == NULL) ? NULL : (arg = (vala_code_node_unref (arg), NULL));
			(cexpr == NULL) ? NULL : (cexpr = (vala_ccode_node_unref (cexpr), NULL));
			(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
		}
		(_arg_it == NULL) ? NULL : (_arg_it = (gee_collection_object_unref (_arg_it), NULL));
	}
	if (gee_iterator_next (params_it)) {
		ValaFormalParameter* param;
		gboolean _tmp206;
		param = (ValaFormalParameter*) gee_iterator_get (params_it);
		_tmp206 = FALSE;
		if (vala_formal_parameter_get_params_array (param)) {
			_tmp206 = TRUE;
		} else {
			_tmp206 = vala_formal_parameter_get_ellipsis (param);
		}
		/* if there are more parameters than arguments,
		 * the additional parameter is an ellipsis parameter
		 * otherwise there is a bug in the semantic analyzer
		 */
		g_assert (_tmp206);
		ellipsis = TRUE;
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	}
	_tmp207 = FALSE;
	if (m != NULL) {
		_tmp207 = VALA_IS_ARRAY_TYPE (vala_method_get_return_type (m));
	} else {
		_tmp207 = FALSE;
	}
	/* add length argument for methods returning arrays */
	if (_tmp207) {
		ValaArrayType* _tmp208;
		ValaArrayType* array_type;
		_tmp208 = NULL;
		array_type = (_tmp208 = VALA_ARRAY_TYPE (vala_method_get_return_type (m)), (_tmp208 == NULL) ? NULL : vala_code_node_ref (_tmp208));
		{
			gint dim;
			dim = 1;
			for (; dim <= vala_array_type_get_rank (array_type); dim++) {
				if (vala_method_get_array_null_terminated (m)) {
					ValaDataType* _tmp209;
					ValaLocalVariable* _tmp210;
					ValaLocalVariable* temp_var;
					ValaCCodeExpression* temp_ref;
					ValaCCodeExpression* _tmp211;
					ValaCCodeIdentifier* _tmp212;
					ValaCCodeFunctionCall* _tmp213;
					ValaCCodeFunctionCall* len_call;
					/* handle calls to methods returning null-terminated arrays*/
					_tmp209 = NULL;
					_tmp210 = NULL;
					temp_var = (_tmp210 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp209 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp209 == NULL) ? NULL : (_tmp209 = (vala_code_node_unref (_tmp209), NULL)), _tmp210);
					temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
					gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
					_tmp211 = NULL;
					ccall_expr = (_tmp211 = (ValaCCodeExpression*) vala_ccode_assignment_new (temp_ref, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp211);
					((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
					_tmp212 = NULL;
					_tmp213 = NULL;
					len_call = (_tmp213 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp212 = vala_ccode_identifier_new ("_vala_array_length"))), (_tmp212 == NULL) ? NULL : (_tmp212 = (vala_ccode_node_unref (_tmp212), NULL)), _tmp213);
					vala_ccode_function_call_add_argument (len_call, temp_ref);
					vala_method_call_append_array_size (expr, (ValaCCodeExpression*) len_call);
					(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
					(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					(len_call == NULL) ? NULL : (len_call = (vala_ccode_node_unref (len_call), NULL));
				} else {
					if (!vala_method_get_no_array_length (m)) {
						ValaLocalVariable* temp_var;
						ValaCCodeExpression* temp_ref;
						ValaCCodeUnaryExpression* _tmp214;
						temp_var = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
						temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
						gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
						_tmp214 = NULL;
						gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_carray_length_parameter_position (m) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) (_tmp214 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
						(_tmp214 == NULL) ? NULL : (_tmp214 = (vala_ccode_node_unref (_tmp214), NULL));
						vala_method_call_append_array_size (expr, temp_ref);
						(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
						(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
					} else {
						ValaCCodeConstant* _tmp215;
						_tmp215 = NULL;
						vala_method_call_append_array_size (expr, (ValaCCodeExpression*) (_tmp215 = vala_ccode_constant_new ("-1")));
						(_tmp215 == NULL) ? NULL : (_tmp215 = (vala_ccode_node_unref (_tmp215), NULL));
					}
				}
			}
		}
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	} else {
		gboolean _tmp216;
		_tmp216 = FALSE;
		if (m != NULL) {
			_tmp216 = VALA_IS_DELEGATE_TYPE (vala_method_get_return_type (m));
		} else {
			_tmp216 = FALSE;
		}
		if (_tmp216) {
			ValaDelegateType* _tmp217;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp218;
			ValaDelegate* d;
			_tmp217 = NULL;
			deleg_type = (_tmp217 = VALA_DELEGATE_TYPE (vala_method_get_return_type (m)), (_tmp217 == NULL) ? NULL : vala_code_node_ref (_tmp217));
			_tmp218 = NULL;
			d = (_tmp218 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp218 == NULL) ? NULL : vala_code_node_ref (_tmp218));
			if (vala_delegate_get_has_target (d)) {
				ValaPointerType* _tmp220;
				ValaVoidType* _tmp219;
				ValaLocalVariable* _tmp221;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp222;
				_tmp220 = NULL;
				_tmp219 = NULL;
				_tmp221 = NULL;
				temp_var = (_tmp221 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) (_tmp220 = vala_pointer_type_new ((ValaDataType*) (_tmp219 = vala_void_type_new (NULL)), NULL)), TRUE, NULL), (_tmp220 == NULL) ? NULL : (_tmp220 = (vala_code_node_unref (_tmp220), NULL)), (_tmp219 == NULL) ? NULL : (_tmp219 = (vala_code_node_unref (_tmp219), NULL)), _tmp221);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp222 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_method_get_cdelegate_target_parameter_position (m), FALSE)), (ValaCCodeExpression*) (_tmp222 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp222 == NULL) ? NULL : (_tmp222 = (vala_ccode_node_unref (_tmp222), NULL));
				vala_method_call_set_delegate_target (expr, temp_ref);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp223 = FALSE;
	if (m != NULL) {
		_tmp223 = vala_method_get_coroutine (m);
	} else {
		_tmp223 = FALSE;
	}
	if (_tmp223) {
		gboolean _tmp224;
		gboolean _tmp225;
		_tmp224 = FALSE;
		_tmp225 = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			_tmp225 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
		} else {
			_tmp225 = FALSE;
		}
		if (_tmp225) {
			_tmp224 = TRUE;
		} else {
			gboolean _tmp226;
			_tmp226 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp226 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp226 = FALSE;
			}
			_tmp224 = _tmp226;
		}
		if (_tmp224) {
			gboolean _tmp227;
			_tmp227 = FALSE;
			if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") == 0) {
				_tmp227 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) == vala_expression_get_symbol_reference ((ValaExpression*) ma);
			} else {
				_tmp227 = FALSE;
			}
			/* asynchronous call*/
			if (_tmp227) {
				ValaCCodeConstant* _tmp228;
				ValaCCodeConstant* _tmp229;
				_tmp228 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp228 = vala_ccode_constant_new ("NULL")));
				(_tmp228 == NULL) ? NULL : (_tmp228 = (vala_ccode_node_unref (_tmp228), NULL));
				_tmp229 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp229 = vala_ccode_constant_new ("NULL")));
				(_tmp229 == NULL) ? NULL : (_tmp229 = (vala_ccode_node_unref (_tmp229), NULL));
			} else {
				ValaCCodeIdentifier* _tmp232;
				char* _tmp231;
				char* _tmp230;
				ValaCCodeIdentifier* _tmp233;
				_tmp232 = NULL;
				_tmp231 = NULL;
				_tmp230 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp232 = vala_ccode_identifier_new (_tmp231 = g_strconcat (_tmp230 = vala_method_get_cname (((ValaCCodeBaseModule*) self)->current_method), "_ready", NULL))));
				(_tmp232 == NULL) ? NULL : (_tmp232 = (vala_ccode_node_unref (_tmp232), NULL));
				_tmp231 = (g_free (_tmp231), NULL);
				_tmp230 = (g_free (_tmp230), NULL);
				_tmp233 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp233 = vala_ccode_identifier_new ("data")));
				(_tmp233 == NULL) ? NULL : (_tmp233 = (vala_ccode_node_unref (_tmp233), NULL));
			}
		}
	}
	_tmp234 = FALSE;
	if (VALA_IS_CREATION_METHOD (m)) {
		GeeList* _tmp235;
		_tmp235 = NULL;
		_tmp234 = gee_collection_get_size ((GeeCollection*) (_tmp235 = vala_code_node_get_error_types ((ValaCodeNode*) m))) > 0;
		(_tmp235 == NULL) ? NULL : (_tmp235 = (gee_collection_object_unref (_tmp235), NULL));
	} else {
		_tmp234 = FALSE;
	}
	if (_tmp234) {
		ValaCCodeIdentifier* _tmp236;
		_tmp236 = NULL;
		gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp236 = vala_ccode_identifier_new ("error")));
		(_tmp236 == NULL) ? NULL : (_tmp236 = (vala_ccode_node_unref (_tmp236), NULL));
	} else {
		if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr)) {
			ValaCCodeUnaryExpression* _tmp238;
			ValaCCodeExpression* _tmp237;
			/* method can fail*/
			((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
			/* add &inner_error before the ellipsis arguments*/
			_tmp238 = NULL;
			_tmp237 = NULL;
			gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp238 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp237 = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "inner_error"))));
			(_tmp238 == NULL) ? NULL : (_tmp238 = (vala_ccode_node_unref (_tmp238), NULL));
			(_tmp237 == NULL) ? NULL : (_tmp237 = (vala_ccode_node_unref (_tmp237), NULL));
		}
	}
	if (ellipsis) {
		gboolean _tmp239;
		_tmp239 = FALSE;
		if (!vala_method_get_printf_format (m)) {
			_tmp239 = _vala_strcmp0 (vala_method_get_sentinel (m), "") != 0;
		} else {
			_tmp239 = FALSE;
		}
		/* ensure variable argument list ends with NULL
		 * except when using printf-style arguments */
		if (_tmp239) {
			ValaCCodeConstant* _tmp240;
			_tmp240 = NULL;
			gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp240 = vala_ccode_constant_new (vala_method_get_sentinel (m))));
			(_tmp240 == NULL) ? NULL : (_tmp240 = (vala_ccode_node_unref (_tmp240), NULL));
		}
	} else {
		if (VALA_IS_DELEGATE_TYPE (itype)) {
			ValaDelegateType* _tmp241;
			ValaDelegateType* deleg_type;
			ValaDelegate* _tmp242;
			ValaDelegate* d;
			_tmp241 = NULL;
			deleg_type = (_tmp241 = VALA_DELEGATE_TYPE (itype), (_tmp241 == NULL) ? NULL : vala_code_node_ref (_tmp241));
			_tmp242 = NULL;
			d = (_tmp242 = vala_delegate_type_get_delegate_symbol (deleg_type), (_tmp242 == NULL) ? NULL : vala_code_node_ref (_tmp242));
			if (vala_delegate_get_has_target (d)) {
				ValaCCodeExpression* _tmp243;
				ValaCCodeExpression* _tmp244;
				_tmp243 = NULL;
				gee_map_set ((GeeMap*) in_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp243 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp243 == NULL) ? NULL : (_tmp243 = (vala_ccode_node_unref (_tmp243), NULL));
				_tmp244 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_delegate_get_cinstance_parameter_position (d), FALSE)), _tmp244 = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, vala_method_call_get_call (expr)));
				(_tmp244 == NULL) ? NULL : (_tmp244 = (vala_ccode_node_unref (_tmp244), NULL));
			}
			(deleg_type == NULL) ? NULL : (deleg_type = (vala_code_node_unref (deleg_type), NULL));
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
	}
	_tmp245 = FALSE;
	if (VALA_IS_SIGNAL_TYPE (itype)) {
		ValaDataType* _tmp246;
		_tmp246 = NULL;
		_tmp245 = !VALA_IS_VOID_TYPE (_tmp246 = vala_data_type_get_return_type (itype));
		(_tmp246 == NULL) ? NULL : (_tmp246 = (vala_code_node_unref (_tmp246), NULL));
	} else {
		_tmp245 = FALSE;
	}
	/* pass address for the return value of non-void signals without emitter functions*/
	if (_tmp245) {
		ValaSignal* _tmp247;
		ValaSignal* sig;
		gboolean _tmp248;
		gboolean _tmp249;
		_tmp247 = NULL;
		sig = (_tmp247 = vala_signal_type_get_signal_symbol (VALA_SIGNAL_TYPE (itype)), (_tmp247 == NULL) ? NULL : vala_code_node_ref (_tmp247));
		_tmp248 = FALSE;
		_tmp249 = FALSE;
		if (ma != NULL) {
			_tmp249 = VALA_IS_BASE_ACCESS (vala_member_access_get_inner (ma));
		} else {
			_tmp249 = FALSE;
		}
		if (_tmp249) {
			_tmp248 = vala_signal_get_is_virtual (sig);
		} else {
			_tmp248 = FALSE;
		}
		if (_tmp248) {
		} else {
			if (!vala_signal_get_has_emitter (sig)) {
				ValaDataType* _tmp250;
				ValaLocalVariable* _tmp251;
				ValaLocalVariable* temp_var;
				ValaCCodeExpression* temp_ref;
				ValaCCodeUnaryExpression* _tmp252;
				ValaCCodeCommaExpression* ccomma;
				ValaCCodeExpression* _tmp254;
				ValaCCodeExpression* _tmp253;
				_tmp250 = NULL;
				_tmp251 = NULL;
				temp_var = (_tmp251 = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp250 = vala_data_type_get_return_type (itype), TRUE, NULL), (_tmp250 == NULL) ? NULL : (_tmp250 = (vala_code_node_unref (_tmp250), NULL)), _tmp251);
				temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_var));
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_var);
				_tmp252 = NULL;
				gee_map_set ((GeeMap*) out_arg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), TRUE)), (ValaCCodeExpression*) (_tmp252 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, temp_ref)));
				(_tmp252 == NULL) ? NULL : (_tmp252 = (vala_ccode_node_unref (_tmp252), NULL));
				ccomma = vala_ccode_comma_expression_new ();
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall_expr));
				vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (temp_ref));
				_tmp254 = NULL;
				_tmp253 = NULL;
				ccall_expr = (_tmp254 = (_tmp253 = (ValaCCodeExpression*) ccomma, (_tmp253 == NULL) ? NULL : vala_ccode_node_ref (_tmp253)), (ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL)), _tmp254);
				(temp_var == NULL) ? NULL : (temp_var = (vala_code_node_unref (temp_var), NULL));
				(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
				(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			}
		}
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	}
	/* append C arguments in the right order*/
	last_pos = 0;
	min_pos = 0;
	if (async_call != ccall) {
		/* don't append out arguments for .begin() calls*/
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp259;
			min_pos = -1;
			{
				GeeSet* _tmp255;
				GeeIterator* _tmp256;
				GeeIterator* _pos_it;
				_tmp255 = NULL;
				_tmp256 = NULL;
				_pos_it = (_tmp256 = gee_iterable_iterator ((GeeIterable*) (_tmp255 = gee_map_get_keys ((GeeMap*) out_arg_map))), (_tmp255 == NULL) ? NULL : (_tmp255 = (gee_collection_object_unref (_tmp255), NULL)), _tmp256);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp257;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp257 = FALSE;
					if (pos > last_pos) {
						gboolean _tmp258;
						_tmp258 = FALSE;
						if (min_pos == (-1)) {
							_tmp258 = TRUE;
						} else {
							_tmp258 = pos < min_pos;
						}
						_tmp257 = _tmp258;
					} else {
						_tmp257 = FALSE;
					}
					if (_tmp257) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp259 = NULL;
			vala_ccode_function_call_add_argument (ccall, _tmp259 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) out_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp259 == NULL) ? NULL : (_tmp259 = (vala_ccode_node_unref (_tmp259), NULL));
			last_pos = min_pos;
		}
	}
	if (async_call != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeExpression* _tmp264;
			min_pos = -1;
			{
				GeeSet* _tmp260;
				GeeIterator* _tmp261;
				GeeIterator* _pos_it;
				_tmp260 = NULL;
				_tmp261 = NULL;
				_pos_it = (_tmp261 = gee_iterable_iterator ((GeeIterable*) (_tmp260 = gee_map_get_keys ((GeeMap*) in_arg_map))), (_tmp260 == NULL) ? NULL : (_tmp260 = (gee_collection_object_unref (_tmp260), NULL)), _tmp261);
				while (gee_iterator_next (_pos_it)) {
					gint pos;
					gboolean _tmp262;
					pos = GPOINTER_TO_INT (gee_iterator_get (_pos_it));
					_tmp262 = FALSE;
					if (pos > last_pos) {
						gboolean _tmp263;
						_tmp263 = FALSE;
						if (min_pos == (-1)) {
							_tmp263 = TRUE;
						} else {
							_tmp263 = pos < min_pos;
						}
						_tmp262 = _tmp263;
					} else {
						_tmp262 = FALSE;
					}
					if (_tmp262) {
						min_pos = pos;
					}
				}
				(_pos_it == NULL) ? NULL : (_pos_it = (gee_collection_object_unref (_pos_it), NULL));
			}
			if (min_pos == (-1)) {
				break;
			}
			_tmp264 = NULL;
			vala_ccode_function_call_add_argument (async_call, _tmp264 = (ValaCCodeExpression*) gee_map_get ((GeeMap*) in_arg_map, GINT_TO_POINTER (min_pos)));
			(_tmp264 == NULL) ? NULL : (_tmp264 = (vala_ccode_node_unref (_tmp264), NULL));
			last_pos = min_pos;
		}
	}
	_tmp265 = FALSE;
	_tmp266 = FALSE;
	if (m != NULL) {
		_tmp266 = vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp266 = FALSE;
	}
	if (_tmp266) {
		_tmp265 = vala_method_get_returns_modified_pointer (m);
	} else {
		_tmp265 = FALSE;
	}
	if (_tmp265) {
		ValaCCodeAssignment* _tmp267;
		_tmp267 = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp267 = vala_ccode_assignment_new (instance, ccall_expr, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp267 == NULL) ? NULL : (_tmp267 = (vala_ccode_node_unref (_tmp267), NULL));
	} else {
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall_expr);
	}
	_tmp268 = FALSE;
	_tmp269 = FALSE;
	_tmp270 = FALSE;
	if (m != NULL) {
		_tmp270 = vala_method_get_coroutine (m);
	} else {
		_tmp270 = FALSE;
	}
	if (_tmp270) {
		_tmp269 = ((ValaCCodeBaseModule*) self)->current_method != NULL;
	} else {
		_tmp269 = FALSE;
	}
	if (_tmp269) {
		_tmp268 = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp268 = FALSE;
	}
	if (_tmp268) {
		gboolean _tmp271;
		_tmp271 = FALSE;
		if (_vala_strcmp0 (vala_member_access_get_member_name (ma), "begin") != 0) {
			_tmp271 = TRUE;
		} else {
			_tmp271 = vala_expression_get_symbol_reference (vala_member_access_get_inner (ma)) != vala_expression_get_symbol_reference ((ValaExpression*) ma);
		}
		if (_tmp271) {
			ValaCCodeExpressionStatement* _tmp273;
			gint state;
			ValaCCodeExpressionStatement* _tmp279;
			ValaCCodeAssignment* _tmp278;
			ValaCCodeConstant* _tmp277;
			char* _tmp276;
			ValaCCodeMemberAccess* _tmp275;
			ValaCCodeIdentifier* _tmp274;
			ValaCCodeReturnStatement* _tmp281;
			ValaCCodeConstant* _tmp280;
			ValaCCodeCaseStatement* _tmp284;
			ValaCCodeConstant* _tmp283;
			char* _tmp282;
			if (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) {
				ValaCCodeFragment* _tmp272;
				_tmp272 = NULL;
				((ValaCCodeBaseModule*) self)->pre_statement_fragment = (_tmp272 = vala_ccode_fragment_new (), (((ValaCCodeBaseModule*) self)->pre_statement_fragment == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->pre_statement_fragment = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->pre_statement_fragment), NULL)), _tmp272);
			}
			_tmp273 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp273 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) async_call)));
			(_tmp273 == NULL) ? NULL : (_tmp273 = (vala_ccode_node_unref (_tmp273), NULL));
			state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
			_tmp279 = NULL;
			_tmp278 = NULL;
			_tmp277 = NULL;
			_tmp276 = NULL;
			_tmp275 = NULL;
			_tmp274 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp279 = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp278 = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp275 = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp274 = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp277 = vala_ccode_constant_new (_tmp276 = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp279 == NULL) ? NULL : (_tmp279 = (vala_ccode_node_unref (_tmp279), NULL));
			(_tmp278 == NULL) ? NULL : (_tmp278 = (vala_ccode_node_unref (_tmp278), NULL));
			(_tmp277 == NULL) ? NULL : (_tmp277 = (vala_ccode_node_unref (_tmp277), NULL));
			_tmp276 = (g_free (_tmp276), NULL);
			(_tmp275 == NULL) ? NULL : (_tmp275 = (vala_ccode_node_unref (_tmp275), NULL));
			(_tmp274 == NULL) ? NULL : (_tmp274 = (vala_ccode_node_unref (_tmp274), NULL));
			_tmp281 = NULL;
			_tmp280 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp281 = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp280 = vala_ccode_constant_new ("FALSE")))));
			(_tmp281 == NULL) ? NULL : (_tmp281 = (vala_ccode_node_unref (_tmp281), NULL));
			(_tmp280 == NULL) ? NULL : (_tmp280 = (vala_ccode_node_unref (_tmp280), NULL));
			_tmp284 = NULL;
			_tmp283 = NULL;
			_tmp282 = NULL;
			vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->pre_statement_fragment, (ValaCCodeNode*) (_tmp284 = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp283 = vala_ccode_constant_new (_tmp282 = g_strdup_printf ("%i", state))))));
			(_tmp284 == NULL) ? NULL : (_tmp284 = (vala_ccode_node_unref (_tmp284), NULL));
			(_tmp283 == NULL) ? NULL : (_tmp283 = (vala_ccode_node_unref (_tmp283), NULL));
			_tmp282 = (g_free (_tmp282), NULL);
		}
	}
	if (VALA_IS_ARRAY_RESIZE_METHOD (m)) {
		GeeList* _tmp285;
		GeeIterator* _tmp286;
		GeeIterator* arg_it;
		ValaCCodeExpression* _tmp288;
		ValaExpression* _tmp287;
		ValaCCodeExpression* _tmp289;
		ValaCCodeExpression* new_size;
		ValaLocalVariable* temp_decl;
		ValaCCodeExpression* temp_ref;
		ValaCCodeExpression* clen;
		ValaCCodeExpression* _tmp290;
		ValaCCodeExpression* celems;
		ValaArrayType* _tmp291;
		ValaArrayType* array_type;
		char* _tmp293;
		char* _tmp292;
		ValaCCodeIdentifier* _tmp294;
		ValaCCodeIdentifier* csizeof;
		ValaCCodeBinaryExpression* cdelta;
		ValaCCodeBinaryExpression* ccheck;
		ValaCCodeIdentifier* _tmp295;
		ValaCCodeFunctionCall* _tmp296;
		ValaCCodeFunctionCall* czero;
		ValaCCodeBinaryExpression* _tmp297;
		ValaCCodeConstant* _tmp298;
		ValaCCodeBinaryExpression* _tmp299;
		ValaCCodeCommaExpression* ccomma;
		ValaCCodeAssignment* _tmp300;
		ValaCCodeConditionalExpression* _tmp302;
		ValaCCodeConstant* _tmp301;
		ValaCCodeAssignment* _tmp304;
		ValaCCodeExpression* _tmp303;
		/* FIXME: size expression must not be evaluated twice at runtime (potential side effects)*/
		_tmp285 = NULL;
		_tmp286 = NULL;
		arg_it = (_tmp286 = gee_iterable_iterator ((GeeIterable*) (_tmp285 = vala_method_call_get_argument_list (expr))), (_tmp285 == NULL) ? NULL : (_tmp285 = (gee_collection_object_unref (_tmp285), NULL)), _tmp286);
		gee_iterator_next (arg_it);
		_tmp288 = NULL;
		_tmp287 = NULL;
		_tmp289 = NULL;
		new_size = (_tmp289 = (_tmp288 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) (_tmp287 = (ValaExpression*) gee_iterator_get (arg_it)))), (_tmp288 == NULL) ? NULL : vala_ccode_node_ref (_tmp288)), (_tmp287 == NULL) ? NULL : (_tmp287 = (vala_code_node_unref (_tmp287), NULL)), _tmp289);
		temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->int_type, TRUE, NULL);
		temp_ref = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) temp_decl));
		gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
		/* memset needs string.h */
		((ValaCCodeBaseModule*) self)->string_h_needed = TRUE;
		clen = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1);
		_tmp290 = NULL;
		celems = (_tmp290 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))), (_tmp290 == NULL) ? NULL : vala_ccode_node_ref (_tmp290));
		_tmp291 = NULL;
		array_type = (_tmp291 = VALA_ARRAY_TYPE (vala_expression_get_value_type (vala_member_access_get_inner (ma))), (_tmp291 == NULL) ? NULL : vala_code_node_ref (_tmp291));
		_tmp293 = NULL;
		_tmp292 = NULL;
		_tmp294 = NULL;
		csizeof = (_tmp294 = vala_ccode_identifier_new (_tmp293 = g_strdup_printf ("sizeof (%s)", _tmp292 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))), _tmp293 = (g_free (_tmp293), NULL), _tmp292 = (g_free (_tmp292), NULL), _tmp294);
		cdelta = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, temp_ref, clen);
		ccheck = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, temp_ref, clen);
		_tmp295 = NULL;
		_tmp296 = NULL;
		czero = (_tmp296 = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp295 = vala_ccode_identifier_new ("memset"))), (_tmp295 == NULL) ? NULL : (_tmp295 = (vala_ccode_node_unref (_tmp295), NULL)), _tmp296);
		_tmp297 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp297 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, celems, clen)));
		(_tmp297 == NULL) ? NULL : (_tmp297 = (vala_ccode_node_unref (_tmp297), NULL));
		_tmp298 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp298 = vala_ccode_constant_new ("0")));
		(_tmp298 == NULL) ? NULL : (_tmp298 = (vala_ccode_node_unref (_tmp298), NULL));
		_tmp299 = NULL;
		vala_ccode_function_call_add_argument (czero, (ValaCCodeExpression*) (_tmp299 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) csizeof, (ValaCCodeExpression*) cdelta)));
		(_tmp299 == NULL) ? NULL : (_tmp299 = (vala_ccode_node_unref (_tmp299), NULL));
		ccomma = vala_ccode_comma_expression_new ();
		_tmp300 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp300 = vala_ccode_assignment_new (temp_ref, new_size, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp300 == NULL) ? NULL : (_tmp300 = (vala_ccode_node_unref (_tmp300), NULL));
		vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) expr)));
		_tmp302 = NULL;
		_tmp301 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp302 = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) ccheck, (ValaCCodeExpression*) czero, (ValaCCodeExpression*) (_tmp301 = vala_ccode_constant_new ("NULL")))));
		(_tmp302 == NULL) ? NULL : (_tmp302 = (vala_ccode_node_unref (_tmp302), NULL));
		(_tmp301 == NULL) ? NULL : (_tmp301 = (vala_ccode_node_unref (_tmp301), NULL));
		_tmp304 = NULL;
		_tmp303 = NULL;
		vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp304 = vala_ccode_assignment_new (_tmp303 = vala_ccode_module_get_array_length_cexpression (vala_ccode_module_get_head ((ValaCCodeModule*) self), vala_member_access_get_inner (ma), 1), temp_ref, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)));
		(_tmp304 == NULL) ? NULL : (_tmp304 = (vala_ccode_node_unref (_tmp304), NULL));
		(_tmp303 == NULL) ? NULL : (_tmp303 = (vala_ccode_node_unref (_tmp303), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccomma);
		(arg_it == NULL) ? NULL : (arg_it = (gee_collection_object_unref (arg_it), NULL));
		(new_size == NULL) ? NULL : (new_size = (vala_ccode_node_unref (new_size), NULL));
		(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
		(temp_ref == NULL) ? NULL : (temp_ref = (vala_ccode_node_unref (temp_ref), NULL));
		(clen == NULL) ? NULL : (clen = (vala_ccode_node_unref (clen), NULL));
		(celems == NULL) ? NULL : (celems = (vala_ccode_node_unref (celems), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		(csizeof == NULL) ? NULL : (csizeof = (vala_ccode_node_unref (csizeof), NULL));
		(cdelta == NULL) ? NULL : (cdelta = (vala_ccode_node_unref (cdelta), NULL));
		(ccheck == NULL) ? NULL : (ccheck = (vala_ccode_node_unref (ccheck), NULL));
		(czero == NULL) ? NULL : (czero = (vala_ccode_node_unref (czero), NULL));
		(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
	}
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	(async_call == NULL) ? NULL : (async_call = (vala_ccode_node_unref (async_call), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	(itype == NULL) ? NULL : (itype = (vala_code_node_unref (itype), NULL));
	(in_arg_map == NULL) ? NULL : (in_arg_map = (gee_collection_object_unref (in_arg_map), NULL));
	(out_arg_map == NULL) ? NULL : (out_arg_map = (gee_collection_object_unref (out_arg_map), NULL));
	(ccall_expr == NULL) ? NULL : (ccall_expr = (vala_ccode_node_unref (ccall_expr), NULL));
	(instance == NULL) ? NULL : (instance = (vala_ccode_node_unref (instance), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
}


static void vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass) {
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_ccode_method_call_module_real_visit_method_call;
}


static void vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self) {
}


GType vala_ccode_method_call_module_get_type (void) {
	static GType vala_ccode_method_call_module_type_id = 0;
	if (vala_ccode_method_call_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
	}
	return vala_ccode_method_call_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




