/* valasourcelocation.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>

typedef struct _ValaSourceLocation ValaSourceLocation;

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())

/**
 * Represents a position in a source file.
 */
struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};



void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column);
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
GType vala_source_location_get_type (void);



void vala_source_location_init (ValaSourceLocation *self, gchar* _pos, gint _line, gint _column) {
	memset (self, 0, sizeof (ValaSourceLocation));
	(*self).pos = _pos;
	(*self).line = _line;
	(*self).column = _column;
}


ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self) {
	ValaSourceLocation* dup;
	dup = g_new0 (ValaSourceLocation, 1);
	memcpy (dup, self, sizeof (ValaSourceLocation));
	return dup;
}


void vala_source_location_free (ValaSourceLocation* self) {
	g_free (self);
}


GType vala_source_location_get_type (void) {
	static GType vala_source_location_type_id = 0;
	if (vala_source_location_type_id == 0) {
		vala_source_location_type_id = g_boxed_type_register_static ("ValaSourceLocation", (GBoxedCopyFunc) vala_source_location_dup, (GBoxedFreeFunc) vala_source_location_free);
	}
	return vala_source_location_type_id;
}




