/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;
typedef struct _ValaStructPrivate ValaStructPrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, ValaCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, ValaCollection* collection);
};

struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	ValaList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
	char* (*get_type_signature) (ValaTypeSymbol* self);
};

struct _ValaStruct {
	ValaTypeSymbol parent_instance;
	ValaStructPrivate * priv;
};

struct _ValaStructClass {
	ValaTypeSymbolClass parent_class;
};

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaDataType* _base_type;
	char* cname;
	char* const_cname;
	char* type_id;
	char* lower_case_cprefix;
	char* lower_case_csuffix;
	gboolean boolean_type;
	gboolean integer_type;
	gboolean floating_type;
	gint rank;
	char* marshaller_type_name;
	char* get_value_function;
	char* set_value_function;
	char* default_value;
	char* type_signature;
	char* copy_function;
	char* destroy_function;
	ValaMethod* _default_construction_method;
	gboolean _is_immutable;
	gboolean _has_type_id;
	gint _width;
	gboolean _signed;
	gboolean _has_copy_function;
	gboolean _has_destroy_function;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;


static gpointer vala_struct_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_struct_get_type (void);
GType vala_typeparameter_get_type (void);
GType vala_member_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_method_get_type (void);
GType vala_property_get_type (void);
#define VALA_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT, ValaStructPrivate))
enum  {
	VALA_STRUCT_DUMMY_PROPERTY
};
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void);
ValaTypeSymbol* vala_typesymbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment);
ValaStruct* vala_struct_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p);
ValaList* vala_struct_get_type_parameters (ValaStruct* self);
void vala_struct_add_constant (ValaStruct* self, ValaConstant* c);
GType vala_symbol_accessibility_get_type (void);
void vala_symbol_set_access (ValaSymbol* self, ValaSymbolAccessibility value);
void vala_struct_add_field (ValaStruct* self, ValaField* f);
ValaList* vala_struct_get_fields (ValaStruct* self);
ValaList* vala_struct_get_constants (ValaStruct* self);
GType member_binding_get_type (void);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void);
ValaDataType* vala_semantic_analyzer_get_data_type_for_symbol (ValaTypeSymbol* sym);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
GType vala_formal_parameter_get_type (void);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void);
ValaList* vala_method_get_postconditions (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
const char* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_struct_add_method (ValaStruct* self, ValaMethod* m);
ValaList* vala_struct_get_methods (ValaStruct* self);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_struct_add_property (ValaStruct* self, ValaProperty* prop);
ValaList* vala_struct_get_properties (ValaStruct* self);
void vala_code_visitor_visit_struct (ValaCodeVisitor* self, ValaStruct* st);
static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_struct_get_base_type (ValaStruct* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
char* vala_struct_get_default_cname (ValaStruct* self);
static char* vala_struct_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
void vala_struct_set_cname (ValaStruct* self, const char* cname);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
static void vala_struct_set_const_cname (ValaStruct* self, const char* cname);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_struct_real_get_lower_case_cprefix (ValaSymbol* base);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_struct_get_lower_case_csuffix (ValaStruct* self);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_struct_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
static char* vala_struct_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
MemberBinding vala_field_get_binding (ValaField* self);
ValaDataType* vala_field_get_field_type (ValaField* self);
char* vala_data_type_get_type_signature (ValaDataType* self);
static char* vala_struct_real_get_type_signature (ValaTypeSymbol* base);
ValaStruct* vala_struct_get_base_struct (ValaStruct* self);
gboolean vala_struct_is_boolean_type (ValaStruct* self);
gboolean vala_struct_is_integer_type (ValaStruct* self);
gboolean vala_struct_is_floating_type (ValaStruct* self);
gint vala_struct_get_rank (ValaStruct* self);
void vala_struct_set_rank (ValaStruct* self, gint rank);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
void vala_typesymbol_add_cheader_filename (ValaTypeSymbol* self, const char* filename);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_struct_set_has_type_id (ValaStruct* self, gboolean value);
void vala_struct_set_type_id (ValaStruct* self, const char* name);
static void vala_struct_set_marshaller_type_name (ValaStruct* self, const char* name);
static void vala_struct_set_get_value_function (ValaStruct* self, const char* function);
static void vala_struct_set_set_value_function (ValaStruct* self, const char* function);
static void vala_struct_set_default_value (ValaStruct* self, const char* value);
void vala_struct_set_copy_function (ValaStruct* self, const char* name);
void vala_struct_set_has_copy_function (ValaStruct* self, gboolean value);
void vala_struct_set_destroy_function (ValaStruct* self, const char* name);
void vala_struct_set_has_destroy_function (ValaStruct* self, gboolean value);
static void vala_struct_process_ccode_attribute (ValaStruct* self, ValaAttribute* a);
static void vala_struct_process_boolean_type_attribute (ValaStruct* self, ValaAttribute* a);
gint vala_attribute_get_integer (ValaAttribute* self, const char* name);
void vala_struct_set_width (ValaStruct* self, gint value);
void vala_struct_set_signed (ValaStruct* self, gboolean value);
static void vala_struct_process_integer_type_attribute (ValaStruct* self, ValaAttribute* a);
static void vala_struct_process_floating_type_attribute (ValaStruct* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_struct_set_is_immutable (ValaStruct* self, gboolean value);
void vala_struct_process_attributes (ValaStruct* self);
gboolean vala_struct_get_has_type_id (ValaStruct* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
gboolean vala_struct_is_simple_type (ValaStruct* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
static char* vala_struct_real_get_type_id (ValaTypeSymbol* base);
char* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
static char* vala_struct_real_get_marshaller_type_name (ValaTypeSymbol* base);
char* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
static char* vala_struct_real_get_get_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static char* vala_struct_real_get_set_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_default_value (ValaTypeSymbol* self);
static char* vala_struct_real_get_default_value (ValaTypeSymbol* base);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name);
ValaAttribute* vala_attribute_new (const char* name, ValaSourceReference* source_reference);
ValaAttribute* vala_attribute_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type);
void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value);
static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
static char* vala_struct_real_get_dup_function (ValaTypeSymbol* base);
static char* vala_struct_real_get_free_function (ValaTypeSymbol* base);
char* vala_struct_get_default_copy_function (ValaStruct* self);
static char* vala_struct_real_get_copy_function (ValaTypeSymbol* base);
char* vala_struct_get_default_destroy_function (ValaStruct* self);
static char* vala_struct_real_get_destroy_function (ValaTypeSymbol* base);
gboolean vala_data_type_is_disposable (ValaDataType* self);
gboolean vala_struct_is_disposable (ValaStruct* self);
GType vala_value_type_get_type (void);
GType vala_struct_value_type_get_type (void);
ValaTypeSymbol* vala_value_type_get_type_symbol (ValaValueType* self);
gboolean vala_data_type_get_nullable (ValaDataType* self);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
static gboolean vala_struct_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self);
gboolean vala_struct_get_is_immutable (ValaStruct* self);
gint vala_struct_get_width (ValaStruct* self);
gboolean vala_struct_get_signed (ValaStruct* self);
gboolean vala_struct_get_has_copy_function (ValaStruct* self);
gboolean vala_struct_get_has_destroy_function (ValaStruct* self);
static void vala_struct_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaStruct* vala_struct_construct (GType object_type, const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaStruct* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaStruct*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaStruct* vala_struct_new (const char* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}


void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	vala_collection_add ((ValaCollection*) self->priv->type_parameters, p);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) p), (ValaSymbol*) p);
}


ValaList* vala_struct_get_type_parameters (ValaStruct* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->type_parameters);
	return result;
}


void vala_struct_add_constant (ValaStruct* self, ValaConstant* c) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	vala_collection_add ((ValaCollection*) self->priv->constants, c);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) c), (ValaSymbol*) c);
}


void vala_struct_add_field (ValaStruct* self, ValaField* f) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	vala_symbol_set_access ((ValaSymbol*) f, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_collection_add ((ValaCollection*) self->priv->fields, f);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


ValaList* vala_struct_get_fields (ValaStruct* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->fields);
	return result;
}


ValaList* vala_struct_get_constants (ValaStruct* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->constants);
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_struct_add_method (ValaStruct* self, ValaMethod* m) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (m != NULL);
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaFormalParameter* _tmp2_;
		ValaDataType* _tmp1_;
		vala_method_set_this_parameter (m, _tmp2_ = vala_formal_parameter_new ("this", _tmp1_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self), NULL));
		_vala_code_node_unref0 (_tmp2_);
		_vala_code_node_unref0 (_tmp1_);
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaList* _tmp4_;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
		_vala_collection_object_unref0 (_tmp4_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaLocalVariable* _tmp6_;
		ValaDataType* _tmp5_;
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, NULL));
		_vala_code_node_unref0 (_tmp6_);
		_vala_code_node_unref0 (_tmp5_);
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCreationMethod* cm;
		gboolean _tmp7_ = FALSE;
		if (vala_symbol_get_name ((ValaSymbol*) m) == NULL) {
			vala_struct_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		cm = _vala_code_node_ref0 (VALA_CREATION_METHOD (m));
		if (vala_creation_method_get_class_name (cm) != NULL) {
			_tmp7_ = _vala_strcmp0 (vala_creation_method_get_class_name (cm), vala_symbol_get_name ((ValaSymbol*) self)) != 0;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			char* _tmp9_;
			char* _tmp8_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), _tmp9_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) self), vala_creation_method_get_class_name (cm)));
			_g_free0 (_tmp9_);
			_g_free0 (_tmp8_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	vala_collection_add ((ValaCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


ValaList* vala_struct_get_methods (ValaStruct* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->methods);
	return result;
}


void vala_struct_add_property (ValaStruct* self, ValaProperty* prop) {
	ValaFormalParameter* _tmp1_;
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	vala_collection_add ((ValaCollection*) self->priv->properties, prop);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) prop), (ValaSymbol*) prop);
	vala_property_set_this_parameter (prop, _tmp1_ = vala_formal_parameter_new ("this", _tmp0_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self), NULL));
	_vala_code_node_unref0 (_tmp1_);
	_vala_code_node_unref0 (_tmp0_);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) prop), vala_symbol_get_name ((ValaSymbol*) vala_property_get_this_parameter (prop)), (ValaSymbol*) vala_property_get_this_parameter (prop));
	if (vala_property_get_field (prop) != NULL) {
		vala_struct_add_field (self, vala_property_get_field (prop));
	}
}


ValaList* vala_struct_get_properties (ValaStruct* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (ValaList*) vala_read_only_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->properties);
	return result;
}


static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_struct (visitor, self);
}


static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_struct_get_base_type (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_struct_get_base_type (self), visitor);
	}
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!vala_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) vala_iterator_get (_p_it);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
	{
		ValaIterator* _f_it;
		_f_it = vala_iterable_iterator ((ValaIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!vala_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) vala_iterator_get (_f_it);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_collection_object_unref0 (_f_it);
	}
	{
		ValaIterator* _c_it;
		_c_it = vala_iterable_iterator ((ValaIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!vala_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) vala_iterator_get (_c_it);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_collection_object_unref0 (_c_it);
	}
	{
		ValaIterator* _m_it;
		_m_it = vala_iterable_iterator ((ValaIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!vala_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) vala_iterator_get (_m_it);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_collection_object_unref0 (_m_it);
	}
	{
		ValaIterator* _prop_it;
		_prop_it = vala_iterable_iterator ((ValaIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!vala_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) vala_iterator_get (_prop_it);
			vala_code_node_accept ((ValaCodeNode*) prop, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_collection_object_unref0 (_prop_it);
	}
}


static char* vala_struct_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaStruct * self;
	char* result;
	gboolean _tmp0_ = FALSE;
	self = (ValaStruct*) base;
	if (const_type) {
		_tmp0_ = self->priv->const_cname != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = g_strdup (self->priv->const_cname);
		return result;
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* attr;
		attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		if (attr != NULL) {
			char* _tmp1_;
			self->priv->cname = (_tmp1_ = vala_attribute_get_string (attr, "cname"), _g_free0 (self->priv->cname), _tmp1_);
		}
		if (self->priv->cname == NULL) {
			char* _tmp2_;
			self->priv->cname = (_tmp2_ = vala_struct_get_default_cname (self), _g_free0 (self->priv->cname), _tmp2_);
		}
		_vala_code_node_unref0 (attr);
	}
	result = g_strdup (self->priv->cname);
	return result;
}


void vala_struct_set_cname (ValaStruct* self, const char* cname) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	self->priv->cname = (_tmp0_ = g_strdup (cname), _g_free0 (self->priv->cname), _tmp0_);
}


char* vala_struct_get_default_cname (ValaStruct* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_symbol_get_parent_symbol ((ValaSymbol*) self) != NULL) {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (_tmp0_), _tmp1_);
		return result;
	} else {
		result = g_strdup (vala_symbol_get_name ((ValaSymbol*) self));
		return result;
	}
}


static void vala_struct_set_const_cname (ValaStruct* self, const char* cname) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	self->priv->const_cname = (_tmp0_ = g_strdup (cname), _g_free0 (self->priv->const_cname), _tmp0_);
}


static char* vala_struct_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		char* _tmp1_;
		char* _tmp0_;
		self->priv->lower_case_cprefix = (_tmp1_ = g_strdup_printf ("%s_", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL)), _g_free0 (self->priv->lower_case_cprefix), _tmp1_);
		_g_free0 (_tmp0_);
	}
	result = g_strdup (self->priv->lower_case_cprefix);
	return result;
}


static char* vala_struct_get_lower_case_csuffix (ValaStruct* self) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		char* _tmp0_;
		self->priv->lower_case_csuffix = (_tmp0_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self)), _g_free0 (self->priv->lower_case_csuffix), _tmp0_);
	}
	result = g_strdup (self->priv->lower_case_csuffix);
	return result;
}


static char* vala_struct_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaStruct * self;
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	self = (ValaStruct*) base;
	if (infix == NULL) {
		infix = "";
	}
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_struct_get_lower_case_csuffix (self)), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


static char* vala_struct_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaStruct * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaStruct*) base;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_struct_real_get_type_signature (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->type_signature == NULL) {
		GString* str;
		str = g_string_new ("");
		g_string_append_c (str, '(');
		{
			ValaIterator* _f_it;
			_f_it = vala_iterable_iterator ((ValaIterable*) self->priv->fields);
			while (TRUE) {
				ValaField* f;
				if (!vala_iterator_next (_f_it)) {
					break;
				}
				f = (ValaField*) vala_iterator_get (_f_it);
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					char* _tmp0_;
					g_string_append (str, _tmp0_ = vala_data_type_get_type_signature (vala_field_get_field_type (f)));
					_g_free0 (_tmp0_);
				}
				_vala_code_node_unref0 (f);
			}
			_vala_collection_object_unref0 (_f_it);
		}
		g_string_append_c (str, ')');
		result = g_strdup (str->str);
		_g_string_free0 (str);
		return result;
	}
	result = g_strdup (self->priv->type_signature);
	return result;
}


gboolean vala_struct_is_boolean_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* st;
		gboolean _tmp0_ = FALSE;
		st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
		if (st != NULL) {
			_tmp0_ = vala_struct_is_boolean_type (st);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			return result;
		}
		_vala_code_node_unref0 (st);
	}
	result = self->priv->boolean_type;
	return result;
}


gboolean vala_struct_is_integer_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* st;
		gboolean _tmp0_ = FALSE;
		st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
		if (st != NULL) {
			_tmp0_ = vala_struct_is_integer_type (st);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			return result;
		}
		_vala_code_node_unref0 (st);
	}
	result = self->priv->integer_type;
	return result;
}


gboolean vala_struct_is_floating_type (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* st;
		gboolean _tmp0_ = FALSE;
		st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
		if (st != NULL) {
			_tmp0_ = vala_struct_is_floating_type (st);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			return result;
		}
		_vala_code_node_unref0 (st);
	}
	result = self->priv->floating_type;
	return result;
}


gint vala_struct_get_rank (ValaStruct* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->rank;
	return result;
}


void vala_struct_set_rank (ValaStruct* self, gint rank) {
	g_return_if_fail (self != NULL);
	self->priv->rank = rank;
}


static void vala_struct_process_ccode_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "const_cname")) {
		char* _tmp0_;
		vala_struct_set_const_cname (self, _tmp0_ = vala_attribute_get_string (a, "const_cname"));
		_g_free0 (_tmp0_);
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* _tmp1_;
		self->priv->lower_case_cprefix = (_tmp1_ = vala_attribute_get_string (a, "cprefix"), _g_free0 (self->priv->lower_case_cprefix), _tmp1_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp2_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			filename_collection = _tmp2_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp2_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp2_); filename_it = filename_it + 1) {
				char* filename;
				filename = g_strdup (filename_collection[filename_it]);
				{
					vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) self, filename);
					_g_free0 (filename);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_free0 (val);
	}
	if (vala_attribute_has_argument (a, "has_type_id")) {
		vala_struct_set_has_type_id (self, vala_attribute_get_bool (a, "has_type_id"));
	}
	if (vala_attribute_has_argument (a, "type_id")) {
		char* _tmp3_;
		vala_struct_set_type_id (self, _tmp3_ = vala_attribute_get_string (a, "type_id"));
		_g_free0 (_tmp3_);
	}
	if (vala_attribute_has_argument (a, "marshaller_type_name")) {
		char* _tmp4_;
		vala_struct_set_marshaller_type_name (self, _tmp4_ = vala_attribute_get_string (a, "marshaller_type_name"));
		_g_free0 (_tmp4_);
	}
	if (vala_attribute_has_argument (a, "get_value_function")) {
		char* _tmp5_;
		vala_struct_set_get_value_function (self, _tmp5_ = vala_attribute_get_string (a, "get_value_function"));
		_g_free0 (_tmp5_);
	}
	if (vala_attribute_has_argument (a, "set_value_function")) {
		char* _tmp6_;
		vala_struct_set_set_value_function (self, _tmp6_ = vala_attribute_get_string (a, "set_value_function"));
		_g_free0 (_tmp6_);
	}
	if (vala_attribute_has_argument (a, "default_value")) {
		char* _tmp7_;
		vala_struct_set_default_value (self, _tmp7_ = vala_attribute_get_string (a, "default_value"));
		_g_free0 (_tmp7_);
	}
	if (vala_attribute_has_argument (a, "type_signature")) {
		char* _tmp8_;
		self->priv->type_signature = (_tmp8_ = vala_attribute_get_string (a, "type_signature"), _g_free0 (self->priv->type_signature), _tmp8_);
	}
	if (vala_attribute_has_argument (a, "copy_function")) {
		char* _tmp9_;
		vala_struct_set_copy_function (self, _tmp9_ = vala_attribute_get_string (a, "copy_function"));
		_g_free0 (_tmp9_);
	}
	if (vala_attribute_has_argument (a, "has_copy_function")) {
		vala_struct_set_has_copy_function (self, vala_attribute_get_bool (a, "has_copy_function"));
	}
	if (vala_attribute_has_argument (a, "destroy_function")) {
		char* _tmp10_;
		vala_struct_set_destroy_function (self, _tmp10_ = vala_attribute_get_string (a, "destroy_function"));
		_g_free0 (_tmp10_);
	}
	if (vala_attribute_has_argument (a, "has_destroy_function")) {
		vala_struct_set_has_destroy_function (self, vala_attribute_get_bool (a, "has_destroy_function"));
	}
}


static void vala_struct_process_boolean_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->boolean_type = TRUE;
}


static void vala_struct_process_integer_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->integer_type = TRUE;
	if (vala_attribute_has_argument (a, "rank")) {
		self->priv->rank = vala_attribute_get_integer (a, "rank");
	}
	if (vala_attribute_has_argument (a, "width")) {
		vala_struct_set_width (self, vala_attribute_get_integer (a, "width"));
	}
	if (vala_attribute_has_argument (a, "signed")) {
		vala_struct_set_signed (self, vala_attribute_get_bool (a, "signed"));
	}
}


static void vala_struct_process_floating_type_attribute (ValaStruct* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	self->priv->floating_type = TRUE;
	if (vala_attribute_has_argument (a, "rank")) {
		self->priv->rank = vala_attribute_get_integer (a, "rank");
	}
	if (vala_attribute_has_argument (a, "width")) {
		vala_struct_set_width (self, vala_attribute_get_integer (a, "width"));
	}
}


void vala_struct_process_attributes (ValaStruct* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* a;
			a = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_struct_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "BooleanType") == 0) {
						vala_struct_process_boolean_type_attribute (self, a);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "IntegerType") == 0) {
							vala_struct_process_integer_type_attribute (self, a);
						} else {
							if (_vala_strcmp0 (vala_attribute_get_name (a), "FloatingType") == 0) {
								vala_struct_process_floating_type_attribute (self, a);
							} else {
								if (_vala_strcmp0 (vala_attribute_get_name (a), "Immutable") == 0) {
									vala_struct_set_is_immutable (self, TRUE);
								}
							}
						}
					}
				}
				_vala_code_node_unref0 (a);
			}
		}
	}
}


static char* vala_struct_real_get_type_id (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->type_id == NULL) {
		if (!self->priv->_has_type_id) {
			if (vala_struct_get_base_type (self) != NULL) {
				ValaStruct* st;
				st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
				if (st != NULL) {
					result = vala_typesymbol_get_type_id ((ValaTypeSymbol*) st);
					_vala_code_node_unref0 (st);
					return result;
				}
				_vala_code_node_unref0 (st);
			}
			if (vala_struct_is_simple_type (self)) {
				result = NULL;
				return result;
			} else {
				result = g_strdup ("G_TYPE_POINTER");
				return result;
			}
		} else {
			char* _tmp0_;
			self->priv->type_id = (_tmp0_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_"), _g_free0 (self->priv->type_id), _tmp0_);
		}
	}
	result = g_strdup (self->priv->type_id);
	return result;
}


void vala_struct_set_type_id (ValaStruct* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->type_id = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->type_id), _tmp0_);
}


static char* vala_struct_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* st;
			st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
			if (st != NULL) {
				result = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) st);
				_vala_code_node_unref0 (st);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp1_;
			char* _tmp0_;
			char* _tmp2_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp1_ = g_strdup_printf ("The type `%s` doesn't declare a marshaller type name", _tmp0_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			self->priv->marshaller_type_name = (_tmp2_ = g_strdup (""), _g_free0 (self->priv->marshaller_type_name), _tmp2_);
			result = g_strdup ("");
			return result;
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("BOXED");
				return result;
			} else {
				result = g_strdup ("POINTER");
				return result;
			}
		}
	}
	result = g_strdup (self->priv->marshaller_type_name);
	return result;
}


static void vala_struct_set_marshaller_type_name (ValaStruct* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->marshaller_type_name = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->marshaller_type_name), _tmp0_);
}


static char* vala_struct_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->get_value_function == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* st;
			st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
			if (st != NULL) {
				result = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) st);
				_vala_code_node_unref0 (st);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp1_;
			char* _tmp0_;
			char* _tmp2_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp1_ = g_strdup_printf ("The value type `%s` doesn't declare a GValue get function", _tmp0_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			self->priv->get_value_function = (_tmp2_ = g_strdup (""), _g_free0 (self->priv->get_value_function), _tmp2_);
			result = g_strdup ("");
			return result;
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("g_value_get_boxed");
				return result;
			} else {
				result = g_strdup ("g_value_get_pointer");
				return result;
			}
		}
	} else {
		result = g_strdup (self->priv->get_value_function);
		return result;
	}
}


static char* vala_struct_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->set_value_function == NULL) {
		if (vala_struct_get_base_type (self) != NULL) {
			ValaStruct* st;
			st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
			if (st != NULL) {
				result = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) st);
				_vala_code_node_unref0 (st);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
		if (vala_struct_is_simple_type (self)) {
			char* _tmp1_;
			char* _tmp0_;
			char* _tmp2_;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp1_ = g_strdup_printf ("The value type `%s` doesn't declare a GValue set function", _tmp0_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			self->priv->set_value_function = (_tmp2_ = g_strdup (""), _g_free0 (self->priv->set_value_function), _tmp2_);
			result = g_strdup ("");
			return result;
		} else {
			if (self->priv->_has_type_id) {
				result = g_strdup ("g_value_set_boxed");
				return result;
			} else {
				result = g_strdup ("g_value_set_pointer");
				return result;
			}
		}
	} else {
		result = g_strdup (self->priv->set_value_function);
		return result;
	}
}


static void vala_struct_set_get_value_function (ValaStruct* self, const char* function) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->get_value_function = (_tmp0_ = g_strdup (function), _g_free0 (self->priv->get_value_function), _tmp0_);
}


static void vala_struct_set_set_value_function (ValaStruct* self, const char* function) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->set_value_function = (_tmp0_ = g_strdup (function), _g_free0 (self->priv->set_value_function), _tmp0_);
}


static char* vala_struct_real_get_default_value (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->default_value != NULL) {
		result = g_strdup (self->priv->default_value);
		return result;
	}
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* st;
		st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
		if (st != NULL) {
			result = vala_typesymbol_get_default_value ((ValaTypeSymbol*) st);
			_vala_code_node_unref0 (st);
			return result;
		}
		_vala_code_node_unref0 (st);
	}
	result = NULL;
	return result;
}


static void vala_struct_set_default_value (ValaStruct* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->default_value = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->default_value), _tmp0_);
}


static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const char* name) {
	ValaStruct * self;
	gint result;
	gint i;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!vala_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) vala_iterator_get (_p_it);
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) p), name) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				_vala_collection_object_unref0 (_p_it);
				return result;
			}
			i++;
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
	result = -1;
	return result;
}


gboolean vala_struct_is_simple_type (ValaStruct* self) {
	gboolean result;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (vala_struct_get_base_type (self) != NULL) {
		ValaStruct* st;
		gboolean _tmp0_ = FALSE;
		st = _vala_code_node_ref0 (vala_struct_get_base_struct (self));
		if (st != NULL) {
			_tmp0_ = vala_struct_is_simple_type (st);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			return result;
		}
		_vala_code_node_unref0 (st);
	}
	if ((_tmp2_ = (_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ByRef")) != NULL, _vala_code_node_unref0 (_tmp1_), _tmp2_)) {
		result = FALSE;
		return result;
	}
	if (self->priv->boolean_type) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = self->priv->integer_type;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = self->priv->floating_type;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		ValaAttribute* _tmp6_;
		_tmp3_ = (_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType")) != NULL;
		_vala_code_node_unref0 (_tmp6_);
	}
	result = _tmp3_;
	return result;
}


void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type) {
	g_return_if_fail (self != NULL);
	((ValaCodeNode*) self)->attributes = g_list_append (((ValaCodeNode*) self)->attributes, vala_attribute_new ("SimpleType", NULL));
}


static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaStruct * self;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_struct_get_base_type (self) == old_type) {
		vala_struct_set_base_type (self, new_type);
	}
}


static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaStruct * self;
	gboolean result;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	if (vala_struct_get_base_type (self) != NULL) {
		gboolean _tmp0_ = FALSE;
		if (vala_data_type_get_data_type (vala_struct_get_base_type (self)) != NULL) {
			_tmp0_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (vala_struct_get_base_type (self)), t);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static char* vala_struct_real_get_dup_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (vala_symbol_get_external_package ((ValaSymbol*) self)) {
		result = NULL;
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "dup", NULL), _g_free0 (_tmp0_), _tmp1_);
		return result;
	}
}


static char* vala_struct_real_get_free_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (vala_symbol_get_external_package ((ValaSymbol*) self)) {
		result = NULL;
		return result;
	} else {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "free", NULL), _g_free0 (_tmp0_), _tmp1_);
		return result;
	}
}


char* vala_struct_get_default_copy_function (ValaStruct* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "copy", NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_struct_real_get_copy_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->copy_function == NULL) {
		char* _tmp0_;
		self->priv->copy_function = (_tmp0_ = vala_struct_get_default_copy_function (self), _g_free0 (self->priv->copy_function), _tmp0_);
	}
	result = g_strdup (self->priv->copy_function);
	return result;
}


void vala_struct_set_copy_function (ValaStruct* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	self->priv->copy_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->copy_function), _tmp0_);
}


char* vala_struct_get_default_destroy_function (ValaStruct* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "destroy", NULL), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_struct_real_get_destroy_function (ValaTypeSymbol* base) {
	ValaStruct * self;
	char* result;
	self = (ValaStruct*) base;
	if (self->priv->destroy_function == NULL) {
		char* _tmp0_;
		self->priv->destroy_function = (_tmp0_ = vala_struct_get_default_destroy_function (self), _g_free0 (self->priv->destroy_function), _tmp0_);
	}
	result = g_strdup (self->priv->destroy_function);
	return result;
}


void vala_struct_set_destroy_function (ValaStruct* self, const char* name) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	self->priv->destroy_function = (_tmp0_ = g_strdup (name), _g_free0 (self->priv->destroy_function), _tmp0_);
}


gboolean vala_struct_is_disposable (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->destroy_function != NULL) {
		result = TRUE;
		return result;
	}
	{
		ValaIterator* _f_it;
		_f_it = vala_iterable_iterator ((ValaIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			gboolean _tmp0_ = FALSE;
			if (!vala_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) vala_iterator_get (_f_it);
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp0_ = vala_data_type_is_disposable (vala_field_get_field_type (f));
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = TRUE;
				_vala_code_node_unref0 (f);
				_vala_collection_object_unref0 (_f_it);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_collection_object_unref0 (_f_it);
	}
	result = FALSE;
	return result;
}


static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type) {
	gboolean result;
	ValaDataType* _tmp0_;
	ValaStructValueType* struct_type;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	struct_type = _vala_code_node_ref0 ((_tmp0_ = type, VALA_IS_STRUCT_VALUE_TYPE (_tmp0_) ? ((ValaStructValueType*) _tmp0_) : NULL));
	if (struct_type != NULL) {
		ValaStruct* st;
		st = _vala_code_node_ref0 (VALA_STRUCT (vala_value_type_get_type_symbol ((ValaValueType*) struct_type)));
		if (st == self) {
			if (vala_data_type_get_nullable (type)) {
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (struct_type);
				return result;
			}
			result = TRUE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (struct_type);
			return result;
		}
		{
			ValaIterator* _f_it;
			_f_it = vala_iterable_iterator ((ValaIterable*) st->priv->fields);
			while (TRUE) {
				ValaField* f;
				gboolean _tmp1_ = FALSE;
				if (!vala_iterator_next (_f_it)) {
					break;
				}
				f = (ValaField*) vala_iterator_get (_f_it);
				if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
					_tmp1_ = vala_struct_is_recursive_value_type (self, vala_field_get_field_type (f));
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					_vala_collection_object_unref0 (_f_it);
					_vala_code_node_unref0 (st);
					_vala_code_node_unref0 (struct_type);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_collection_object_unref0 (_f_it);
		}
		_vala_code_node_unref0 (st);
	}
	result = FALSE;
	_vala_code_node_unref0 (struct_type);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_struct_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaStruct * self;
	gboolean result;
	ValaSourceFile* old_source_file;
	ValaSymbol* old_symbol;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	self = (ValaStruct*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_struct_process_attributes (self);
	old_source_file = _vala_source_file_ref0 (vala_semantic_analyzer_get_current_source_file (analyzer));
	old_symbol = _vala_code_node_ref0 (vala_semantic_analyzer_get_current_symbol (analyzer));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	if (vala_struct_get_base_type (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_struct_get_base_type (self), analyzer);
		if (!VALA_IS_VALUE_TYPE (vala_struct_get_base_type (self))) {
			char* _tmp2_;
			char* _tmp1_;
			char* _tmp0_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp2_ = g_strdup_printf ("The base type `%s` of struct `%s` is not a struct", _tmp0_ = vala_code_node_to_string ((ValaCodeNode*) vala_struct_get_base_type (self)), _tmp1_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_g_free0 (_tmp2_);
			_g_free0 (_tmp1_);
			_g_free0 (_tmp0_);
			result = FALSE;
			_vala_source_file_unref0 (old_source_file);
			_vala_code_node_unref0 (old_symbol);
			return result;
		}
	}
	{
		ValaIterator* _p_it;
		_p_it = vala_iterable_iterator ((ValaIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!vala_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) vala_iterator_get (_p_it);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			_vala_code_node_unref0 (p);
		}
		_vala_collection_object_unref0 (_p_it);
	}
	{
		ValaIterator* _f_it;
		_f_it = vala_iterable_iterator ((ValaIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			gboolean _tmp3_ = FALSE;
			if (!vala_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) vala_iterator_get (_f_it);
			vala_code_node_check ((ValaCodeNode*) f, analyzer);
			if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
				_tmp3_ = vala_struct_is_recursive_value_type (self, vala_field_get_field_type (f));
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) f), "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_collection_object_unref0 (_f_it);
				_vala_source_file_unref0 (old_source_file);
				_vala_code_node_unref0 (old_symbol);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_collection_object_unref0 (_f_it);
	}
	{
		ValaIterator* _c_it;
		_c_it = vala_iterable_iterator ((ValaIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!vala_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) vala_iterator_get (_c_it);
			vala_code_node_check ((ValaCodeNode*) c, analyzer);
			_vala_code_node_unref0 (c);
		}
		_vala_collection_object_unref0 (_c_it);
	}
	{
		ValaIterator* _m_it;
		_m_it = vala_iterable_iterator ((ValaIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!vala_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) vala_iterator_get (_m_it);
			vala_code_node_check ((ValaCodeNode*) m, analyzer);
			_vala_code_node_unref0 (m);
		}
		_vala_collection_object_unref0 (_m_it);
	}
	{
		ValaIterator* _prop_it;
		_prop_it = vala_iterable_iterator ((ValaIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!vala_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) vala_iterator_get (_prop_it);
			vala_code_node_check ((ValaCodeNode*) prop, analyzer);
			_vala_code_node_unref0 (prop);
		}
		_vala_collection_object_unref0 (_prop_it);
	}
	if (!vala_symbol_get_external ((ValaSymbol*) self)) {
		_tmp9_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = vala_struct_get_base_type (self) == NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaList* _tmp10_;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) (_tmp10_ = vala_struct_get_fields (self))) == 0;
		_vala_collection_object_unref0 (_tmp10_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = !vala_struct_is_boolean_type (self);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = !vala_struct_is_integer_type (self);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_tmp4_ = !vala_struct_is_floating_type (self);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		char* _tmp11_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp11_ = g_strdup_printf ("structs cannot be empty: %s", vala_symbol_get_name ((ValaSymbol*) self)));
		_g_free0 (_tmp11_);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	_vala_source_file_unref0 (old_source_file);
	_vala_code_node_unref0 (old_symbol);
	return result;
}


ValaDataType* vala_struct_get_base_type (ValaStruct* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_type;
	return result;
}


void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	vala_code_node_set_parent_node ((ValaCodeNode*) value, (ValaCodeNode*) self);
	self->priv->_base_type = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_base_type), _tmp0_);
}


ValaStruct* vala_struct_get_base_struct (ValaStruct* self) {
	ValaStruct* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_base_type != NULL) {
		ValaTypeSymbol* _tmp0_;
		result = (_tmp0_ = vala_data_type_get_data_type (self->priv->_base_type), VALA_IS_STRUCT (_tmp0_) ? ((ValaStruct*) _tmp0_) : NULL);
		return result;
	}
	result = NULL;
	return result;
}


ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_default_construction_method = (_tmp0_ = _vala_code_node_ref0 (value), _vala_code_node_unref0 (self->priv->_default_construction_method), _tmp0_);
}


gboolean vala_struct_get_is_immutable (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_immutable;
	return result;
}


void vala_struct_set_is_immutable (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_immutable = value;
}


gboolean vala_struct_get_has_type_id (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_type_id;
	return result;
}


void vala_struct_set_has_type_id (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_type_id = value;
}


gint vala_struct_get_width (ValaStruct* self) {
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_width;
	return result;
}


void vala_struct_set_width (ValaStruct* self, gint value) {
	g_return_if_fail (self != NULL);
	self->priv->_width = value;
}


gboolean vala_struct_get_signed (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_signed;
	return result;
}


void vala_struct_set_signed (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_signed = value;
}


gboolean vala_struct_get_has_copy_function (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_copy_function;
	return result;
}


void vala_struct_set_has_copy_function (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_copy_function = value;
}


gboolean vala_struct_get_has_destroy_function (ValaStruct* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_destroy_function;
	return result;
}


void vala_struct_set_has_destroy_function (ValaStruct* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_destroy_function = value;
}


static void vala_struct_class_init (ValaStructClass * klass) {
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_struct_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_struct_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_struct_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_struct_real_get_lower_case_cprefix;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_struct_real_get_lower_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_struct_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_signature = vala_struct_real_get_type_signature;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_struct_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_struct_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_struct_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_struct_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_default_value = vala_struct_real_get_default_value;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_parameter_index = vala_struct_real_get_type_parameter_index;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_struct_real_replace_type;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_struct_real_is_subtype_of;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_struct_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_struct_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_copy_function = vala_struct_real_get_copy_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_destroy_function = vala_struct_real_get_destroy_function;
	VALA_CODE_NODE_CLASS (klass)->check = vala_struct_real_check;
}


static void vala_struct_instance_init (ValaStruct * self) {
	self->priv = VALA_STRUCT_GET_PRIVATE (self);
	self->priv->type_parameters = (ValaList*) vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (ValaList*) vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (ValaList*) vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (ValaList*) vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->properties = (ValaList*) vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->_base_type = NULL;
	self->priv->default_value = NULL;
	self->priv->_has_type_id = TRUE;
	self->priv->_width = 32;
	self->priv->_signed = TRUE;
	self->priv->_has_copy_function = TRUE;
	self->priv->_has_destroy_function = TRUE;
}


static void vala_struct_finalize (ValaCodeNode* obj) {
	ValaStruct * self;
	self = VALA_STRUCT (obj);
	_vala_collection_object_unref0 (self->priv->type_parameters);
	_vala_collection_object_unref0 (self->priv->constants);
	_vala_collection_object_unref0 (self->priv->fields);
	_vala_collection_object_unref0 (self->priv->methods);
	_vala_collection_object_unref0 (self->priv->properties);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->cname);
	_g_free0 (self->priv->const_cname);
	_g_free0 (self->priv->type_id);
	_g_free0 (self->priv->lower_case_cprefix);
	_g_free0 (self->priv->lower_case_csuffix);
	_g_free0 (self->priv->marshaller_type_name);
	_g_free0 (self->priv->get_value_function);
	_g_free0 (self->priv->set_value_function);
	_g_free0 (self->priv->default_value);
	_g_free0 (self->priv->type_signature);
	_g_free0 (self->priv->copy_function);
	_g_free0 (self->priv->destroy_function);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}


GType vala_struct_get_type (void) {
	static GType vala_struct_type_id = 0;
	if (vala_struct_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
	}
	return vala_struct_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




