
#ifndef __VALACODEGEN_H__
#define __VALACODEGEN_H__

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>

G_BEGIN_DECLS


#define VALA_TYPE_CCODE_COMPILER (vala_ccode_compiler_get_type ())
#define VALA_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompiler))
#define VALA_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))
#define VALA_IS_CCODE_COMPILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_COMPILER))
#define VALA_IS_CCODE_COMPILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_COMPILER))
#define VALA_CCODE_COMPILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_COMPILER, ValaCCodeCompilerClass))

typedef struct _ValaCCodeCompiler ValaCCodeCompiler;
typedef struct _ValaCCodeCompilerClass ValaCCodeCompilerClass;
typedef struct _ValaCCodeCompilerPrivate ValaCCodeCompilerPrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;
typedef struct _ValaCCodeGeneratorPrivate ValaCCodeGeneratorPrivate;

#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;

#define VALA_TYPE_CLASS_REGISTER_FUNCTION (vala_class_register_function_get_type ())
#define VALA_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunction))
#define VALA_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))
#define VALA_IS_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_IS_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_CLASS_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))

typedef struct _ValaClassRegisterFunction ValaClassRegisterFunction;
typedef struct _ValaClassRegisterFunctionClass ValaClassRegisterFunctionClass;
typedef struct _ValaClassRegisterFunctionPrivate ValaClassRegisterFunctionPrivate;

#define VALA_TYPE_GIR_WRITER (vala_gir_writer_get_type ())
#define VALA_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriter))
#define VALA_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))
#define VALA_IS_GIR_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIR_WRITER))
#define VALA_IS_GIR_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIR_WRITER))
#define VALA_GIR_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIR_WRITER, ValaGIRWriterClass))

typedef struct _ValaGIRWriter ValaGIRWriter;
typedef struct _ValaGIRWriterClass ValaGIRWriterClass;
typedef struct _ValaGIRWriterPrivate ValaGIRWriterPrivate;

#define VALA_TYPE_INTERFACE_REGISTER_FUNCTION (vala_interface_register_function_get_type ())
#define VALA_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunction))
#define VALA_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_IS_INTERFACE_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE_REGISTER_FUNCTION))
#define VALA_INTERFACE_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE_REGISTER_FUNCTION, ValaInterfaceRegisterFunctionClass))

typedef struct _ValaInterfaceRegisterFunction ValaInterfaceRegisterFunction;
typedef struct _ValaInterfaceRegisterFunctionClass ValaInterfaceRegisterFunctionClass;
typedef struct _ValaInterfaceRegisterFunctionPrivate ValaInterfaceRegisterFunctionPrivate;

#define VALA_TYPE_STRUCT_REGISTER_FUNCTION (vala_struct_register_function_get_type ())
#define VALA_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunction))
#define VALA_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))
#define VALA_IS_STRUCT_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_IS_STRUCT_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_REGISTER_FUNCTION))
#define VALA_STRUCT_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_REGISTER_FUNCTION, ValaStructRegisterFunctionClass))

typedef struct _ValaStructRegisterFunction ValaStructRegisterFunction;
typedef struct _ValaStructRegisterFunctionClass ValaStructRegisterFunctionClass;
typedef struct _ValaStructRegisterFunctionPrivate ValaStructRegisterFunctionPrivate;

/**
 * Interface to the C compiler.
 */
struct _ValaCCodeCompiler {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeCompilerPrivate * priv;
};

struct _ValaCCodeCompilerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeCompiler *self);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeGenerator {
	ValaCodeGenerator parent_instance;
	ValaCCodeGeneratorPrivate * priv;
	ValaCCodeModule* head;
};

struct _ValaCCodeGeneratorClass {
	ValaCodeGeneratorClass parent_class;
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * C function to register a type at runtime.
 */
struct _ValaTypeRegisterFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTypeRegisterFunctionPrivate * priv;
};

struct _ValaTypeRegisterFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTypeRegisterFunction *self);
	ValaTypeSymbol* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_init_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_peek_pointer_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_free_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_copy_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_lcopy_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_collect_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

/**
 * C function to register a class at runtime.
 */
struct _ValaClassRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaClassRegisterFunctionPrivate * priv;
};

struct _ValaClassRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};

/**
 * Code visitor generating .gir file for the public interface.
 */
struct _ValaGIRWriter {
	ValaCodeVisitor parent_instance;
	ValaGIRWriterPrivate * priv;
};

struct _ValaGIRWriterClass {
	ValaCodeVisitorClass parent_class;
};

/**
 * C function to register an interface at runtime.
 */
struct _ValaInterfaceRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaInterfaceRegisterFunctionPrivate * priv;
};

struct _ValaInterfaceRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};

/**
 * C function to register a class at runtime.
 */
struct _ValaStructRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaStructRegisterFunctionPrivate * priv;
};

struct _ValaStructRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};


gpointer vala_ccode_compiler_ref (gpointer instance);
void vala_ccode_compiler_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_compiler (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_compiler (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_compiler (const GValue* value);
GType vala_ccode_compiler_get_type (void);
ValaCCodeCompiler* vala_ccode_compiler_new (void);
ValaCCodeCompiler* vala_ccode_compiler_construct (GType object_type);
void vala_ccode_compiler_compile (ValaCCodeCompiler* self, ValaCodeContext* context, const char* cc_command, char** cc_options, int cc_options_length1);
GType vala_ccode_generator_get_type (void);
gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
ValaCCodeGenerator* vala_ccode_generator_new (void);
ValaCCodeGenerator* vala_ccode_generator_construct (GType object_type);
ValaCCodeModule* vala_ccode_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeModule* vala_ccode_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
void vala_ccode_module_emit (ValaCCodeModule* self, ValaCodeContext* context);
void vala_ccode_module_visit_source_file (ValaCCodeModule* self, ValaSourceFile* source_file);
void vala_ccode_module_visit_class (ValaCCodeModule* self, ValaClass* cl);
void vala_ccode_module_visit_interface (ValaCCodeModule* self, ValaInterface* iface);
void vala_ccode_module_visit_struct (ValaCCodeModule* self, ValaStruct* st);
void vala_ccode_module_visit_enum (ValaCCodeModule* self, ValaEnum* en);
void vala_ccode_module_visit_error_domain (ValaCCodeModule* self, ValaErrorDomain* edomain);
void vala_ccode_module_visit_delegate (ValaCCodeModule* self, ValaDelegate* d);
void vala_ccode_module_visit_member (ValaCCodeModule* self, ValaMember* m);
void vala_ccode_module_visit_constant (ValaCCodeModule* self, ValaConstant* c);
void vala_ccode_module_visit_field (ValaCCodeModule* self, ValaField* f);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
void vala_ccode_module_visit_creation_method (ValaCCodeModule* self, ValaCreationMethod* m);
void vala_ccode_module_visit_formal_parameter (ValaCCodeModule* self, ValaFormalParameter* p);
void vala_ccode_module_visit_property (ValaCCodeModule* self, ValaProperty* prop);
void vala_ccode_module_visit_property_accessor (ValaCCodeModule* self, ValaPropertyAccessor* acc);
void vala_ccode_module_visit_signal (ValaCCodeModule* self, ValaSignal* sig);
void vala_ccode_module_visit_constructor (ValaCCodeModule* self, ValaConstructor* c);
void vala_ccode_module_visit_destructor (ValaCCodeModule* self, ValaDestructor* d);
void vala_ccode_module_visit_block (ValaCCodeModule* self, ValaBlock* b);
void vala_ccode_module_visit_empty_statement (ValaCCodeModule* self, ValaEmptyStatement* stmt);
void vala_ccode_module_visit_declaration_statement (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
void vala_ccode_module_visit_local_variable (ValaCCodeModule* self, ValaLocalVariable* local);
void vala_ccode_module_visit_initializer_list (ValaCCodeModule* self, ValaInitializerList* list);
void vala_ccode_module_visit_end_full_expression (ValaCCodeModule* self, ValaExpression* expr);
void vala_ccode_module_visit_expression_statement (ValaCCodeModule* self, ValaExpressionStatement* stmt);
void vala_ccode_module_visit_if_statement (ValaCCodeModule* self, ValaIfStatement* stmt);
void vala_ccode_module_visit_switch_statement (ValaCCodeModule* self, ValaSwitchStatement* stmt);
void vala_ccode_module_visit_switch_section (ValaCCodeModule* self, ValaSwitchSection* section);
void vala_ccode_module_visit_switch_label (ValaCCodeModule* self, ValaSwitchLabel* label);
void vala_ccode_module_visit_loop (ValaCCodeModule* self, ValaLoop* stmt);
void vala_ccode_module_visit_foreach_statement (ValaCCodeModule* self, ValaForeachStatement* stmt);
void vala_ccode_module_visit_break_statement (ValaCCodeModule* self, ValaBreakStatement* stmt);
void vala_ccode_module_visit_continue_statement (ValaCCodeModule* self, ValaContinueStatement* stmt);
void vala_ccode_module_visit_return_statement (ValaCCodeModule* self, ValaReturnStatement* stmt);
void vala_ccode_module_visit_yield_statement (ValaCCodeModule* self, ValaYieldStatement* stmt);
void vala_ccode_module_visit_throw_statement (ValaCCodeModule* self, ValaThrowStatement* stmt);
void vala_ccode_module_visit_try_statement (ValaCCodeModule* self, ValaTryStatement* stmt);
void vala_ccode_module_visit_catch_clause (ValaCCodeModule* self, ValaCatchClause* clause);
void vala_ccode_module_visit_lock_statement (ValaCCodeModule* self, ValaLockStatement* stmt);
void vala_ccode_module_visit_delete_statement (ValaCCodeModule* self, ValaDeleteStatement* stmt);
void vala_ccode_module_visit_expression (ValaCCodeModule* self, ValaExpression* expr);
void vala_ccode_module_visit_array_creation_expression (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
void vala_ccode_module_visit_boolean_literal (ValaCCodeModule* self, ValaBooleanLiteral* expr);
void vala_ccode_module_visit_character_literal (ValaCCodeModule* self, ValaCharacterLiteral* expr);
void vala_ccode_module_visit_integer_literal (ValaCCodeModule* self, ValaIntegerLiteral* expr);
void vala_ccode_module_visit_real_literal (ValaCCodeModule* self, ValaRealLiteral* expr);
void vala_ccode_module_visit_string_literal (ValaCCodeModule* self, ValaStringLiteral* expr);
void vala_ccode_module_visit_null_literal (ValaCCodeModule* self, ValaNullLiteral* expr);
void vala_ccode_module_visit_member_access (ValaCCodeModule* self, ValaMemberAccess* expr);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
void vala_ccode_module_visit_element_access (ValaCCodeModule* self, ValaElementAccess* expr);
void vala_ccode_module_visit_base_access (ValaCCodeModule* self, ValaBaseAccess* expr);
void vala_ccode_module_visit_postfix_expression (ValaCCodeModule* self, ValaPostfixExpression* expr);
void vala_ccode_module_visit_object_creation_expression (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
void vala_ccode_module_visit_sizeof_expression (ValaCCodeModule* self, ValaSizeofExpression* expr);
void vala_ccode_module_visit_typeof_expression (ValaCCodeModule* self, ValaTypeofExpression* expr);
void vala_ccode_module_visit_unary_expression (ValaCCodeModule* self, ValaUnaryExpression* expr);
void vala_ccode_module_visit_cast_expression (ValaCCodeModule* self, ValaCastExpression* expr);
void vala_ccode_module_visit_pointer_indirection (ValaCCodeModule* self, ValaPointerIndirection* expr);
void vala_ccode_module_visit_addressof_expression (ValaCCodeModule* self, ValaAddressofExpression* expr);
void vala_ccode_module_visit_reference_transfer_expression (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
void vala_ccode_module_visit_binary_expression (ValaCCodeModule* self, ValaBinaryExpression* expr);
void vala_ccode_module_visit_type_check (ValaCCodeModule* self, ValaTypeCheck* expr);
void vala_ccode_module_visit_lambda_expression (ValaCCodeModule* self, ValaLambdaExpression* l);
void vala_ccode_module_visit_assignment (ValaCCodeModule* self, ValaAssignment* a);
char* vala_ccode_module_get_custom_creturn_type (ValaCCodeModule* self, ValaMethod* m);
void vala_ccode_module_generate_dynamic_method_wrapper (ValaCCodeModule* self, ValaDynamicMethod* method);
gboolean vala_ccode_module_method_has_wrapper (ValaCCodeModule* self, ValaMethod* method);
ValaCCodeIdentifier* vala_ccode_module_get_value_setter_function (ValaCCodeModule* self, ValaDataType* type_reference);
ValaCCodeExpression* vala_ccode_module_get_construct_property_assignment (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
ValaCCodeFunctionCall* vala_ccode_module_get_param_spec (ValaCCodeModule* self, ValaProperty* prop);
ValaCCodeFunctionCall* vala_ccode_module_get_signal_creation (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
ValaCCodeFragment* vala_ccode_module_register_dbus_info (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
char* vala_ccode_module_get_dynamic_property_getter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
char* vala_ccode_module_get_dynamic_property_setter_cname (ValaCCodeModule* self, ValaDynamicProperty* node);
char* vala_ccode_module_get_dynamic_signal_cname (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
void vala_ccode_module_generate_marshaller (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
char* vala_ccode_module_get_marshaller_function (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
char* vala_ccode_module_get_array_length_cname (ValaCCodeModule* self, const char* array_cname, gint dim);
ValaCCodeExpression* vala_ccode_module_get_array_length_cexpression (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
char* vala_ccode_module_get_array_size_cname (ValaCCodeModule* self, const char* array_cname);
ValaCCodeExpression* vala_ccode_module_get_array_size_cexpression (ValaCCodeModule* self, ValaExpression* array_expr);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_class_register_function_get_type (void);
ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl, ValaCodeContext* context);
ValaClassRegisterFunction* vala_class_register_function_construct (GType object_type, ValaClass* cl, ValaCodeContext* context);
ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self);
void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value);
GType vala_gir_writer_get_type (void);
void vala_gir_writer_write_file (ValaGIRWriter* self, ValaCodeContext* context, const char* directory, const char* gir_namespace, const char* gir_version, const char* package);
ValaGIRWriter* vala_gir_writer_new (void);
ValaGIRWriter* vala_gir_writer_construct (GType object_type);
GType vala_interface_register_function_get_type (void);
ValaInterfaceRegisterFunction* vala_interface_register_function_new (ValaInterface* iface, ValaCodeContext* context);
ValaInterfaceRegisterFunction* vala_interface_register_function_construct (GType object_type, ValaInterface* iface, ValaCodeContext* context);
ValaInterface* vala_interface_register_function_get_interface_reference (ValaInterfaceRegisterFunction* self);
void vala_interface_register_function_set_interface_reference (ValaInterfaceRegisterFunction* self, ValaInterface* value);
GType vala_struct_register_function_get_type (void);
ValaStructRegisterFunction* vala_struct_register_function_new (ValaStruct* st, ValaCodeContext* context);
ValaStructRegisterFunction* vala_struct_register_function_construct (GType object_type, ValaStruct* st, ValaCodeContext* context);
ValaStruct* vala_struct_register_function_get_struct_reference (ValaStructRegisterFunction* self);
void vala_struct_register_function_set_struct_reference (ValaStructRegisterFunction* self, ValaStruct* value);
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin);
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_base_finalize_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* self);
char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self);
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self);
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self);
ValaCodeContext* vala_typeregister_function_get_context (ValaTypeRegisterFunction* self);
void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value);


G_END_DECLS

#endif
