/* valagerrormodule.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Jürg Billeter <j@bitron.ch>
 *	Thijs Vermeir <thijsvermeir@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGErrorModulePrivate {
	gint current_try_id;
	gint next_try_id;
};


static gpointer vala_gerror_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
#define VALA_GERROR_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GERROR_MODULE, ValaGErrorModulePrivate))
enum  {
	VALA_GERROR_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaCCodeDelegateModule* vala_ccode_delegate_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaCCodeDelegateModule* vala_ccode_delegate_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGErrorModule* vala_gerror_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
gboolean vala_ccode_declaration_space_add_symbol_declaration (ValaCCodeDeclarationSpace* self, ValaSymbol* sym, const char* name);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
void vala_ccode_base_module_generate_error_domain_declaration (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
static void vala_gerror_module_real_visit_error_domain (ValaCCodeModule* base, ValaErrorDomain* edomain);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
static void vala_gerror_module_real_visit_throw_statement (ValaCCodeModule* base, ValaThrowStatement* stmt);
void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
ValaCCodeExpression* vala_ccode_base_module_default_value_for_type (ValaCCodeBaseModule* self, ValaDataType* type, gboolean initializer_expression);
ValaCCodeStatement* vala_gerror_module_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
static ValaCCodeStatement* vala_gerror_module_real_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
static ValaCCodeStatement* vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self, ValaCCodeExpression* inner_error);
ValaCCodeExpression* vala_ccode_base_module_get_variable_cexpression (ValaCCodeBaseModule* self, const char* name);
void vala_ccode_base_module_append_error_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, ValaTryStatement* current_try);
static void vala_gerror_module_real_add_simple_check (ValaCCodeModule* base, ValaCodeNode* node, ValaCCodeFragment* cfrag);
static void vala_gerror_module_real_visit_try_statement (ValaCCodeModule* base, ValaTryStatement* stmt);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
static void vala_gerror_module_real_visit_catch_clause (ValaCCodeModule* base, ValaCatchClause* clause);
static void vala_gerror_module_finalize (ValaCCodeModule* obj);



ValaGErrorModule* vala_gerror_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGErrorModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type, codegen, next);
	return self;
}


ValaGErrorModule* vala_gerror_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE, codegen, next);
}


static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space) {
	ValaGErrorModule * self;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	ValaCCodeEnum* _tmp3_;
	ValaCCodeEnum* cenum;
	char* _tmp11_;
	char* _tmp12_;
	char* quark_fun_name;
	char* _tmp14_;
	char* _tmp13_;
	ValaCCodeMacroReplacement* _tmp15_;
	ValaCCodeMacroReplacement* error_domain_define;
	char* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeFunction* cquark_fun;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = NULL;
	if ((_tmp1_ = vala_ccode_declaration_space_add_symbol_declaration (decl_space, (ValaSymbol*) edomain, _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) edomain, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_)) {
		return;
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cenum = (_tmp3_ = vala_ccode_enum_new (_tmp2_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) edomain, FALSE)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	{
		GeeList* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _ecode_it;
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		_ecode_it = (_tmp5_ = gee_iterable_iterator ((GeeIterable*) (_tmp4_ = vala_error_domain_get_codes (edomain))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL)), _tmp5_);
		while (TRUE) {
			ValaErrorCode* ecode;
			if (!gee_iterator_next (_ecode_it)) {
				break;
			}
			ecode = (ValaErrorCode*) gee_iterator_get (_ecode_it);
			if (vala_error_code_get_value (ecode) == NULL) {
				ValaCCodeEnumValue* _tmp7_;
				char* _tmp6_;
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				vala_ccode_enum_add_value (cenum, _tmp7_ = vala_ccode_enum_value_new (_tmp6_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE), NULL));
				(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
				_tmp6_ = (g_free (_tmp6_), NULL);
			} else {
				ValaCCodeEnumValue* _tmp9_;
				char* _tmp8_;
				vala_code_node_accept ((ValaCodeNode*) vala_error_code_get_value (ecode), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				vala_ccode_enum_add_value (cenum, _tmp9_ = vala_ccode_enum_value_new (_tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) ecode, FALSE), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_error_code_get_value (ecode)))));
				(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
				_tmp8_ = (g_free (_tmp8_), NULL);
			}
			(ecode == NULL) ? NULL : (ecode = (vala_code_node_unref (ecode), NULL));
		}
		(_ecode_it == NULL) ? NULL : (_ecode_it = (gee_collection_object_unref (_ecode_it), NULL));
	}
	if (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) edomain)) != NULL) {
		ValaCCodeComment* _tmp10_;
		_tmp10_ = NULL;
		vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) (_tmp10_ = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference ((ValaCodeNode*) edomain)))));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	}
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) cenum);
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	quark_fun_name = (_tmp12_ = g_strconcat (_tmp11_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain), "quark", NULL), _tmp11_ = (g_free (_tmp11_), NULL), _tmp12_);
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp15_ = NULL;
	error_domain_define = (_tmp15_ = vala_ccode_macro_replacement_new (_tmp13_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) edomain, NULL), _tmp14_ = g_strconcat (quark_fun_name, " ()", NULL)), _tmp14_ = (g_free (_tmp14_), NULL), _tmp13_ = (g_free (_tmp13_), NULL), _tmp15_);
	vala_ccode_declaration_space_add_type_definition (decl_space, (ValaCCodeNode*) error_domain_define);
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	cquark_fun = (_tmp17_ = vala_ccode_function_new (quark_fun_name, _tmp16_ = vala_typesymbol_get_cname (vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->gquark_type), FALSE)), _tmp16_ = (g_free (_tmp16_), NULL), _tmp17_);
	vala_ccode_declaration_space_add_type_member_declaration (decl_space, (ValaCCodeNode*) cquark_fun);
	(cenum == NULL) ? NULL : (cenum = (vala_ccode_node_unref (cenum), NULL));
	quark_fun_name = (g_free (quark_fun_name), NULL);
	(error_domain_define == NULL) ? NULL : (error_domain_define = (vala_ccode_node_unref (error_domain_define), NULL));
	(cquark_fun == NULL) ? NULL : (cquark_fun = (vala_ccode_node_unref (cquark_fun), NULL));
}


static void vala_gerror_module_real_visit_error_domain (ValaCCodeModule* base, ValaErrorDomain* edomain) {
	ValaGErrorModule * self;
	char* _tmp0_;
	char* _tmp1_;
	char* quark_fun_name;
	char* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* cquark_fun;
	ValaCCodeBlock* cquark_block;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* cquark_call;
	ValaCCodeConstant* _tmp9_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	ValaCCodeReturnStatement* _tmp10_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->source_declarations);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->header_declarations);
	}
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, ((ValaCCodeBaseModule*) self)->internal_header_declarations);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	quark_fun_name = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) edomain), "quark", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	cquark_fun = (_tmp3_ = vala_ccode_function_new (quark_fun_name, _tmp2_ = vala_typesymbol_get_cname (vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->gquark_type), FALSE)), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	cquark_block = vala_ccode_block_new ();
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	cquark_call = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_quark_from_static_string"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat ("\"", _tmp6_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) edomain, NULL), NULL), "-quark\"", NULL))));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp10_ = NULL;
	vala_ccode_block_add_statement (cquark_block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) cquark_call)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	vala_ccode_function_set_block (cquark_fun, cquark_block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) cquark_fun);
	quark_fun_name = (g_free (quark_fun_name), NULL);
	(cquark_fun == NULL) ? NULL : (cquark_fun = (vala_ccode_node_unref (cquark_fun), NULL));
	(cquark_block == NULL) ? NULL : (cquark_block = (vala_ccode_node_unref (cquark_block), NULL));
	(cquark_call == NULL) ? NULL : (cquark_call = (vala_ccode_node_unref (cquark_call), NULL));
}


static void vala_gerror_module_real_visit_throw_statement (ValaCCodeModule* base, ValaThrowStatement* stmt) {
	ValaGErrorModule * self;
	ValaCCodeFragment* cfrag;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeAssignment* _tmp1_;
	ValaCCodeAssignment* cassign;
	ValaCCodeExpressionStatement* _tmp2_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	cfrag = vala_ccode_fragment_new ();
	/* method will fail*/
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cassign = (_tmp1_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("_inner_error_")), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_throw_statement_get_error_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp2_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cassign)));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) stmt, cfrag);
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_throw_statement_get_error_expression (stmt)->temp_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(cassign == NULL) ? NULL : (cassign = (vala_ccode_node_unref (cassign), NULL));
}


static ValaCCodeStatement* vala_gerror_module_real_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr) {
	ValaCCodeStatement* result;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* cpropagate;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeBlock* cerror_block;
	ValaCCodeExpressionStatement* _tmp3_;
	ValaCCodeFragment* free_frag;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (error_expr != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	cpropagate = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_propagate_error"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (cpropagate, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("error")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_function_call_add_argument (cpropagate, error_expr);
	cerror_block = vala_ccode_block_new ();
	_tmp3_ = NULL;
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp3_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cpropagate)));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	/* free local variables*/
	free_frag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, FALSE);
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
	if (VALA_IS_VOID_TYPE (((ValaCCodeBaseModule*) self)->current_return_type)) {
		ValaCCodeReturnStatement* _tmp4_;
		_tmp4_ = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp4_ = vala_ccode_return_statement_new (NULL)));
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	} else {
		ValaCCodeReturnStatement* _tmp6_;
		ValaCCodeExpression* _tmp5_;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp6_ = vala_ccode_return_statement_new (_tmp5_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_return_type, FALSE))));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	}
	result = (ValaCCodeStatement*) cerror_block;
	(cpropagate == NULL) ? NULL : (cpropagate = (vala_ccode_node_unref (cpropagate), NULL));
	(free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL));
	return result;
}


ValaCCodeStatement* vala_gerror_module_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr) {
	return VALA_GERROR_MODULE_GET_CLASS (self)->return_with_exception (self, error_expr);
}


static ValaCCodeStatement* vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self, ValaCCodeExpression* inner_error) {
	ValaCCodeStatement* result;
	ValaCCodeBlock* cerror_block;
	ValaCCodeFragment* free_frag;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* ccritical;
	ValaCCodeConstant* _tmp2_;
	ValaCCodeConstant* _tmp3_;
	ValaCCodeConstant* _tmp4_;
	ValaCCodeMemberAccess* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunctionCall* cclear;
	ValaCCodeUnaryExpression* _tmp8_;
	ValaCCodeFragment* cprint_frag;
	ValaCCodeExpressionStatement* _tmp9_;
	ValaCCodeExpressionStatement* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (inner_error != NULL, NULL);
	cerror_block = vala_ccode_block_new ();
	/* free local variables*/
	free_frag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, FALSE);
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	ccritical = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_critical"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp2_ = vala_ccode_constant_new ("\"file %s: line %d: uncaught error: %s\"")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_constant_new ("__FILE__")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new ("__LINE__")));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (ccritical, (ValaCCodeExpression*) (_tmp5_ = vala_ccode_member_access_new_pointer (inner_error, "message")));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	_tmp7_ = NULL;
	cclear = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("g_clear_error"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (cclear, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	cprint_frag = vala_ccode_fragment_new ();
	_tmp9_ = NULL;
	vala_ccode_fragment_append (cprint_frag, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccritical)));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_fragment_append (cprint_frag, (ValaCCodeNode*) (_tmp10_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) cclear)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	/* print critical message*/
	vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) cprint_frag);
	if (VALA_IS_CREATION_METHOD (((ValaCCodeBaseModule*) self)->current_method)) {
		ValaCCodeReturnStatement* _tmp12_;
		ValaCCodeConstant* _tmp11_;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp12_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_constant_new ("NULL")))));
		(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	} else {
		if (VALA_IS_VOID_TYPE (((ValaCCodeBaseModule*) self)->current_return_type)) {
			ValaCCodeReturnStatement* _tmp13_;
			_tmp13_ = NULL;
			vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp13_ = vala_ccode_return_statement_new (NULL)));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		} else {
			if (((ValaCCodeBaseModule*) self)->current_return_type != NULL) {
				ValaCCodeReturnStatement* _tmp15_;
				ValaCCodeExpression* _tmp14_;
				_tmp15_ = NULL;
				_tmp14_ = NULL;
				vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_return_statement_new (_tmp14_ = vala_ccode_base_module_default_value_for_type ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_return_type, FALSE))));
				(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
				(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
			}
		}
	}
	result = (ValaCCodeStatement*) cerror_block;
	(free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL));
	(ccritical == NULL) ? NULL : (ccritical = (vala_ccode_node_unref (ccritical), NULL));
	(cclear == NULL) ? NULL : (cclear = (vala_ccode_node_unref (cclear), NULL));
	(cprint_frag == NULL) ? NULL : (cprint_frag = (vala_ccode_node_unref (cprint_frag), NULL));
	return result;
}


static void vala_gerror_module_real_add_simple_check (ValaCCodeModule* base, ValaCodeNode* node, ValaCCodeFragment* cfrag) {
	ValaGErrorModule * self;
	ValaCCodeExpression* inner_error;
	ValaCCodeStatement* cerror_handler;
	ValaCCodeConstant* _tmp39_;
	ValaCCodeBinaryExpression* _tmp40_;
	ValaCCodeBinaryExpression* ccond;
	ValaCCodeIfStatement* _tmp41_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	g_return_if_fail (cfrag != NULL);
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	inner_error = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
	cerror_handler = NULL;
	if (((ValaCCodeBaseModule*) self)->current_try != NULL) {
		ValaCCodeBlock* cerror_block;
		ValaCCodeFragment* free_frag;
		ValaCCodeGotoStatement* _tmp17_;
		char* _tmp16_;
		ValaCCodeStatement* _tmp19_;
		ValaCCodeStatement* _tmp18_;
		/* surrounding try found*/
		cerror_block = vala_ccode_block_new ();
		/* free local variables*/
		free_frag = vala_ccode_fragment_new ();
		vala_ccode_base_module_append_error_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_frag, ((ValaCCodeBaseModule*) self)->current_try);
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) free_frag);
		{
			GeeList* _tmp0_;
			GeeIterator* _tmp1_;
			GeeIterator* _clause_it;
			_tmp0_ = NULL;
			_tmp1_ = NULL;
			_clause_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_try_statement_get_catch_clauses (((ValaCCodeBaseModule*) self)->current_try))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
			while (TRUE) {
				ValaCatchClause* clause;
				ValaCCodeGotoStatement* cgoto_stmt;
				if (!gee_iterator_next (_clause_it)) {
					break;
				}
				clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
				/* go to catch clause if error domain matches*/
				cgoto_stmt = vala_ccode_goto_statement_new (vala_catch_clause_get_clabel_name (clause));
				if (vala_data_type_equals (vala_catch_clause_get_error_type (clause), (ValaDataType*) ((ValaCCodeBaseModule*) self)->gerror_type)) {
					/* general catch clause, this should be the last one*/
					vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) cgoto_stmt);
					(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
					(cgoto_stmt == NULL) ? NULL : (cgoto_stmt = (vala_ccode_node_unref (cgoto_stmt), NULL));
					break;
				} else {
					ValaErrorType* _tmp3_;
					ValaDataType* _tmp2_;
					ValaErrorType* catch_type;
					ValaCCodeBlock* cgoto_block;
					_tmp3_ = NULL;
					_tmp2_ = NULL;
					catch_type = (_tmp3_ = (_tmp2_ = vala_catch_clause_get_error_type (clause), VALA_IS_ERROR_TYPE (_tmp2_) ? ((ValaErrorType*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
					cgoto_block = vala_ccode_block_new ();
					vala_ccode_block_add_statement (cgoto_block, (ValaCCodeNode*) cgoto_stmt);
					if (vala_error_type_get_error_code (catch_type) != NULL) {
						ValaCCodeIdentifier* _tmp4_;
						ValaCCodeFunctionCall* _tmp5_;
						ValaCCodeFunctionCall* error_match;
						ValaCCodeIdentifier* _tmp7_;
						char* _tmp6_;
						ValaCCodeIdentifier* _tmp9_;
						char* _tmp8_;
						ValaCCodeIfStatement* _tmp10_;
						/* catch clause specifies a specific error code */
						_tmp4_ = NULL;
						_tmp5_ = NULL;
						error_match = (_tmp5_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp4_ = vala_ccode_identifier_new ("g_error_matches"))), (_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL)), _tmp5_);
						vala_ccode_function_call_add_argument (error_match, inner_error);
						_tmp7_ = NULL;
						_tmp6_ = NULL;
						vala_ccode_function_call_add_argument (error_match, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_identifier_new (_tmp6_ = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type ((ValaDataType*) catch_type), NULL))));
						(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
						_tmp6_ = (g_free (_tmp6_), NULL);
						_tmp9_ = NULL;
						_tmp8_ = NULL;
						vala_ccode_function_call_add_argument (error_match, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new (_tmp8_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) vala_error_type_get_error_code (catch_type), FALSE))));
						(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
						_tmp8_ = (g_free (_tmp8_), NULL);
						_tmp10_ = NULL;
						vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp10_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) error_match, (ValaCCodeStatement*) cgoto_block, NULL)));
						(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
						(error_match == NULL) ? NULL : (error_match = (vala_ccode_node_unref (error_match), NULL));
					} else {
						ValaCCodeIdentifier* _tmp13_;
						char* _tmp12_;
						ValaCCodeMemberAccess* _tmp11_;
						ValaCCodeBinaryExpression* _tmp14_;
						ValaCCodeBinaryExpression* ccond;
						ValaCCodeIfStatement* _tmp15_;
						/* catch clause specifies a full error domain */
						_tmp13_ = NULL;
						_tmp12_ = NULL;
						_tmp11_ = NULL;
						_tmp14_ = NULL;
						ccond = (_tmp14_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_member_access_new_pointer (inner_error, "domain")), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (vala_catch_clause_get_error_type (clause)), NULL)))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp12_ = (g_free (_tmp12_), NULL), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp14_);
						_tmp15_ = NULL;
						vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp15_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccond, (ValaCCodeStatement*) cgoto_block, NULL)));
						(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
						(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
					}
					(catch_type == NULL) ? NULL : (catch_type = (vala_code_node_unref (catch_type), NULL));
					(cgoto_block == NULL) ? NULL : (cgoto_block = (vala_ccode_node_unref (cgoto_block), NULL));
				}
				(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
				(cgoto_stmt == NULL) ? NULL : (cgoto_stmt = (vala_ccode_node_unref (cgoto_stmt), NULL));
			}
			(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
		}
		/* go to finally clause if no catch clause matches*/
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp17_ = vala_ccode_goto_statement_new (_tmp16_ = g_strdup_printf ("__finally%d", self->priv->current_try_id))));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		_tmp16_ = (g_free (_tmp16_), NULL);
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		cerror_handler = (_tmp19_ = (_tmp18_ = (ValaCCodeStatement*) cerror_block, (_tmp18_ == NULL) ? NULL : vala_ccode_node_ref (_tmp18_)), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp19_);
		(cerror_block == NULL) ? NULL : (cerror_block = (vala_ccode_node_unref (cerror_block), NULL));
		(free_frag == NULL) ? NULL : (free_frag = (vala_ccode_node_unref (free_frag), NULL));
	} else {
		gboolean _tmp20_;
		_tmp20_ = FALSE;
		if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
			GeeList* _tmp21_;
			_tmp21_ = NULL;
			_tmp20_ = gee_collection_get_size ((GeeCollection*) (_tmp21_ = vala_code_node_get_error_types ((ValaCodeNode*) ((ValaCCodeBaseModule*) self)->current_method))) > 0;
			(_tmp21_ == NULL) ? NULL : (_tmp21_ = (gee_collection_object_unref (_tmp21_), NULL));
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			ValaCCodeBinaryExpression* ccond;
			/* current method can fail, propagate error*/
			ccond = NULL;
			{
				GeeList* _tmp22_;
				GeeIterator* _tmp23_;
				GeeIterator* _error_type_it;
				_tmp22_ = NULL;
				_tmp23_ = NULL;
				_error_type_it = (_tmp23_ = gee_iterable_iterator ((GeeIterable*) (_tmp22_ = vala_code_node_get_error_types ((ValaCodeNode*) ((ValaCCodeBaseModule*) self)->current_method))), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp23_);
				while (TRUE) {
					ValaDataType* error_type;
					ValaCCodeIdentifier* _tmp27_;
					char* _tmp26_;
					ValaCCodeMemberAccess* _tmp25_;
					ValaCCodeBinaryExpression* _tmp28_;
					ValaCCodeBinaryExpression* domain_check;
					if (!gee_iterator_next (_error_type_it)) {
						break;
					}
					error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
					/* If GLib.Error is allowed we propagate everything*/
					if (vala_data_type_equals (error_type, (ValaDataType*) ((ValaCCodeBaseModule*) self)->gerror_type)) {
						ValaCCodeBinaryExpression* _tmp24_;
						_tmp24_ = NULL;
						ccond = (_tmp24_ = NULL, (ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)), _tmp24_);
						(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
						break;
					}
					/* Check the allowed error domains to propagate*/
					_tmp27_ = NULL;
					_tmp26_ = NULL;
					_tmp25_ = NULL;
					_tmp28_ = NULL;
					domain_check = (_tmp28_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_member_access_new_pointer (inner_error, "domain")), (ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new (_tmp26_ = vala_typesymbol_get_upper_case_cname (vala_data_type_get_data_type (error_type), NULL)))), (_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL)), _tmp26_ = (g_free (_tmp26_), NULL), (_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL)), _tmp28_);
					if (ccond == NULL) {
						ValaCCodeBinaryExpression* _tmp30_;
						ValaCCodeBinaryExpression* _tmp29_;
						_tmp30_ = NULL;
						_tmp29_ = NULL;
						ccond = (_tmp30_ = (_tmp29_ = domain_check, (_tmp29_ == NULL) ? NULL : vala_ccode_node_ref (_tmp29_)), (ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)), _tmp30_);
					} else {
						ValaCCodeBinaryExpression* _tmp31_;
						_tmp31_ = NULL;
						ccond = (_tmp31_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) ccond, (ValaCCodeExpression*) domain_check), (ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL)), _tmp31_);
					}
					(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
					(domain_check == NULL) ? NULL : (domain_check = (vala_ccode_node_unref (domain_check), NULL));
				}
				(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
			}
			if (ccond == NULL) {
				ValaCCodeStatement* _tmp32_;
				_tmp32_ = NULL;
				cerror_handler = (_tmp32_ = vala_gerror_module_return_with_exception (self, inner_error), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp32_);
			} else {
				ValaCCodeBlock* cerror_block;
				ValaCCodeIfStatement* _tmp35_;
				ValaCCodeStatement* _tmp34_;
				ValaCCodeStatement* _tmp33_;
				ValaCCodeStatement* _tmp37_;
				ValaCCodeStatement* _tmp36_;
				cerror_block = vala_ccode_block_new ();
				_tmp35_ = NULL;
				_tmp34_ = NULL;
				_tmp33_ = NULL;
				vala_ccode_block_add_statement (cerror_block, (ValaCCodeNode*) (_tmp35_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccond, _tmp33_ = vala_gerror_module_return_with_exception (self, inner_error), _tmp34_ = vala_gerror_module_uncaught_error_statement (self, inner_error))));
				(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
				(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
				_tmp37_ = NULL;
				_tmp36_ = NULL;
				cerror_handler = (_tmp37_ = (_tmp36_ = (ValaCCodeStatement*) cerror_block, (_tmp36_ == NULL) ? NULL : vala_ccode_node_ref (_tmp36_)), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp37_);
				(cerror_block == NULL) ? NULL : (cerror_block = (vala_ccode_node_unref (cerror_block), NULL));
			}
			(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
		} else {
			ValaCCodeStatement* _tmp38_;
			_tmp38_ = NULL;
			cerror_handler = (_tmp38_ = vala_gerror_module_uncaught_error_statement (self, inner_error), (cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL)), _tmp38_);
		}
	}
	_tmp39_ = NULL;
	_tmp40_ = NULL;
	ccond = (_tmp40_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, inner_error, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_constant_new ("NULL"))), (_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL)), _tmp40_);
	_tmp41_ = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp41_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) ccond, cerror_handler, NULL)));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	(inner_error == NULL) ? NULL : (inner_error = (vala_ccode_node_unref (inner_error), NULL));
	(cerror_handler == NULL) ? NULL : (cerror_handler = (vala_ccode_node_unref (cerror_handler), NULL));
	(ccond == NULL) ? NULL : (ccond = (vala_ccode_node_unref (ccond), NULL));
}


static void vala_gerror_module_real_visit_try_statement (ValaCCodeModule* base, ValaTryStatement* stmt) {
	ValaGErrorModule * self;
	gint this_try_id;
	ValaTryStatement* _tmp0_;
	ValaTryStatement* old_try;
	gint old_try_id;
	ValaTryStatement* _tmp2_;
	ValaTryStatement* _tmp1_;
	ValaTryStatement* _tmp8_;
	ValaTryStatement* _tmp7_;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp16_;
	char* _tmp15_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	this_try_id = self->priv->next_try_id++;
	_tmp0_ = NULL;
	old_try = (_tmp0_ = ((ValaCCodeBaseModule*) self)->current_try, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	old_try_id = self->priv->current_try_id;
	_tmp2_ = NULL;
	_tmp1_ = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp2_ = (_tmp1_ = stmt, (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp2_);
	self->priv->current_try_id = this_try_id;
	{
		GeeList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _clause_it;
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		_clause_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_try_statement_get_catch_clauses (stmt))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
		while (TRUE) {
			ValaCatchClause* clause;
			char* _tmp6_;
			char* _tmp5_;
			if (!gee_iterator_next (_clause_it)) {
				break;
			}
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_catch_clause_set_clabel_name (clause, _tmp6_ = g_strdup_printf ("__catch%d_%s", this_try_id, _tmp5_ = vala_data_type_get_lower_case_cname (vala_catch_clause_get_error_type (clause), NULL)));
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp8_ = NULL;
	_tmp7_ = NULL;
	((ValaCCodeBaseModule*) self)->current_try = (_tmp8_ = (_tmp7_ = old_try, (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_)), (((ValaCCodeBaseModule*) self)->current_try == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_try = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_try), NULL)), _tmp8_);
	self->priv->current_try_id = old_try_id;
	{
		GeeList* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _clause_it;
		_tmp9_ = NULL;
		_tmp10_ = NULL;
		_clause_it = (_tmp10_ = gee_iterable_iterator ((GeeIterable*) (_tmp9_ = vala_try_statement_get_catch_clauses (stmt))), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (gee_collection_object_unref (_tmp9_), NULL)), _tmp10_);
		while (TRUE) {
			ValaCatchClause* clause;
			if (!gee_iterator_next (_clause_it)) {
				break;
			}
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			vala_code_node_accept ((ValaCodeNode*) clause, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_try_statement_get_body (stmt)));
	{
		GeeList* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _clause_it;
		_tmp11_ = NULL;
		_tmp12_ = NULL;
		_clause_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_try_statement_get_catch_clauses (stmt))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
		while (TRUE) {
			ValaCatchClause* clause;
			ValaCCodeGotoStatement* _tmp14_;
			char* _tmp13_;
			if (!gee_iterator_next (_clause_it)) {
				break;
			}
			clause = (ValaCatchClause*) gee_iterator_get (_clause_it);
			_tmp14_ = NULL;
			_tmp13_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp14_ = vala_ccode_goto_statement_new (_tmp13_ = g_strdup_printf ("__finally%d", this_try_id))));
			(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
			_tmp13_ = (g_free (_tmp13_), NULL);
			vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) clause));
			(clause == NULL) ? NULL : (clause = (vala_code_node_unref (clause), NULL));
		}
		(_clause_it == NULL) ? NULL : (_clause_it = (gee_collection_object_unref (_clause_it), NULL));
	}
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp16_ = vala_ccode_label_new (_tmp15_ = g_strdup_printf ("__finally%d", this_try_id))));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp15_ = (g_free (_tmp15_), NULL);
	if (vala_try_statement_get_finally_body (stmt) != NULL) {
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_try_statement_get_finally_body (stmt)));
	}
	/* check for errors not handled by this try statement
	 may be handled by outer try statements or propagated*/
	vala_ccode_module_add_simple_check ((ValaCCodeModule*) self, (ValaCodeNode*) stmt, cfrag);
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	(old_try == NULL) ? NULL : (old_try = (vala_code_node_unref (old_try), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static void vala_gerror_module_real_visit_catch_clause (ValaCCodeModule* base, ValaCatchClause* clause) {
	ValaGErrorModule * self;
	ValaErrorType* _tmp0_;
	ValaErrorType* error_type;
	ValaCCodeFragment* cfrag;
	ValaCCodeLabel* _tmp1_;
	ValaCCodeBlock* cblock;
	char* variable_name;
	gboolean _tmp4_;
	ValaCCodeExpressionStatement* _tmp14_;
	ValaCCodeAssignment* _tmp13_;
	ValaCCodeConstant* _tmp12_;
	ValaCCodeExpression* _tmp11_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	if (vala_catch_clause_get_error_variable (clause) != NULL) {
		vala_symbol_set_active ((ValaSymbol*) vala_catch_clause_get_error_variable (clause), TRUE);
	}
	((ValaCCodeBaseModule*) self)->current_method_inner_error = TRUE;
	_tmp0_ = NULL;
	error_type = (_tmp0_ = VALA_ERROR_TYPE (vala_catch_clause_get_error_type (clause)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	if (vala_error_type_get_error_domain (error_type) != NULL) {
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, vala_error_type_get_error_domain (error_type), ((ValaCCodeBaseModule*) self)->source_declarations);
	}
	vala_code_node_accept_children ((ValaCodeNode*) clause, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	cfrag = vala_ccode_fragment_new ();
	_tmp1_ = NULL;
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp1_ = vala_ccode_label_new (vala_catch_clause_get_clabel_name (clause))));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	cblock = vala_ccode_block_new ();
	variable_name = NULL;
	if (vala_catch_clause_get_variable_name (clause) != NULL) {
		char* _tmp2_;
		_tmp2_ = NULL;
		variable_name = (_tmp2_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_catch_clause_get_variable_name (clause)), variable_name = (g_free (variable_name), NULL), _tmp2_);
	} else {
		char* _tmp3_;
		_tmp3_ = NULL;
		variable_name = (_tmp3_ = g_strdup ("__err"), variable_name = (g_free (variable_name), NULL), _tmp3_);
	}
	_tmp4_ = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method != NULL) {
		_tmp4_ = vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaCCodeExpressionStatement* _tmp8_;
		ValaCCodeAssignment* _tmp7_;
		ValaCCodeExpression* _tmp6_;
		ValaCCodeExpression* _tmp5_;
		vala_ccode_struct_add_field (((ValaCCodeBaseModule*) self)->closure_struct, "GError *", variable_name);
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp8_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp7_ = vala_ccode_assignment_new (_tmp5_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, variable_name), _tmp6_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	} else {
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp10_;
		ValaCCodeExpression* _tmp9_;
		_cdecl_ = vala_ccode_declaration_new ("GError *");
		_tmp10_ = NULL;
		_tmp9_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new (variable_name, _tmp9_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"), NULL)));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) _cdecl_);
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	}
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	vala_ccode_block_add_statement (cblock, (ValaCCodeNode*) (_tmp14_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_assignment_new (_tmp11_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_"), (ValaCCodeExpression*) (_tmp12_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode ((ValaCodeNode*) vala_catch_clause_get_body (clause)));
	vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) cblock);
	vala_code_node_set_ccodenode ((ValaCodeNode*) clause, (ValaCCodeNode*) cfrag);
	(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	(cblock == NULL) ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL));
	variable_name = (g_free (variable_name), NULL);
}


static void vala_gerror_module_class_init (ValaGErrorModuleClass * klass) {
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->finalize = vala_gerror_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGErrorModulePrivate));
	VALA_CCODE_BASE_MODULE_CLASS (klass)->generate_error_domain_declaration = vala_gerror_module_real_generate_error_domain_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_error_domain = vala_gerror_module_real_visit_error_domain;
	VALA_CCODE_MODULE_CLASS (klass)->visit_throw_statement = vala_gerror_module_real_visit_throw_statement;
	VALA_GERROR_MODULE_CLASS (klass)->return_with_exception = vala_gerror_module_real_return_with_exception;
	VALA_CCODE_MODULE_CLASS (klass)->add_simple_check = vala_gerror_module_real_add_simple_check;
	VALA_CCODE_MODULE_CLASS (klass)->visit_try_statement = vala_gerror_module_real_visit_try_statement;
	VALA_CCODE_MODULE_CLASS (klass)->visit_catch_clause = vala_gerror_module_real_visit_catch_clause;
}


static void vala_gerror_module_instance_init (ValaGErrorModule * self) {
	self->priv = VALA_GERROR_MODULE_GET_PRIVATE (self);
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
}


static void vala_gerror_module_finalize (ValaCCodeModule* obj) {
	ValaGErrorModule * self;
	self = VALA_GERROR_MODULE (obj);
	VALA_CCODE_MODULE_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}


GType vala_gerror_module_get_type (void) {
	static GType vala_gerror_module_type_id = 0;
	if (vala_gerror_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
		vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
	}
	return vala_gerror_module_type_id;
}




