/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};


static gpointer vala_gsignal_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
enum  {
	VALA_GSIGNAL_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGObjectModule* vala_gobject_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGObjectModule* vala_gobject_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGSignalModule* vala_gsignal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus);
static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus);
static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t);
static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
void vala_ccode_method_module_generate_parameter (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
void vala_ccode_module_generate_marshaller (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig);
char* vala_ccode_module_get_marshaller_function (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type);
ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type);
void vala_ccode_module_visit_element_access (ValaCCodeModule* self, ValaElementAccess* expr);
static void vala_gsignal_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr);
char* vala_ccode_module_get_dynamic_signal_connect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
char* vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (ValaCCodeModule* self, ValaDynamicSignal* node);
ValaCCodeNode* vala_ccode_base_module_get_ccodenode (ValaCCodeBaseModule* self, ValaCodeNode* node);
ValaLocalVariable* vala_ccode_base_module_get_temp_variable (ValaCCodeBaseModule* self, ValaDataType* type, gboolean value_owned, ValaCodeNode* node_reference);
static ValaCCodeExpression* vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment);
void vala_ccode_module_visit_assignment (ValaCCodeModule* self, ValaAssignment* a);
static void vala_gsignal_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment);
void vala_ccode_module_visit_member_access (ValaCCodeModule* self, ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr);
void vala_ccode_module_visit_method_call (ValaCCodeModule* self, ValaMethodCall* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaGSignalModule* vala_gsignal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGSignalModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type, codegen, next);
	return self;
}


ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE, codegen, next);
}


static char* vala_gsignal_module_get_marshaller_type_name (ValaGSignalModule* self, ValaDataType* t, gboolean dbus) {
	char* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_data_type_get_type_parameter (t) != NULL;
	}
	if (_tmp0_) {
		result = g_strdup ("POINTER");
		return result;
	} else {
		if (VALA_IS_ERROR_TYPE (t)) {
			result = g_strdup ("POINTER");
			return result;
		} else {
			if (VALA_IS_ARRAY_TYPE (t)) {
				if (dbus) {
					result = g_strdup ("BOXED");
					return result;
				} else {
					if (vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (t))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						result = g_strdup ("BOXED_INT");
						return result;
					} else {
						result = g_strdup ("POINTER_INT");
						return result;
					}
				}
			} else {
				if (VALA_IS_VOID_TYPE (t)) {
					result = g_strdup ("VOID");
					return result;
				} else {
					gboolean _tmp1_;
					_tmp1_ = FALSE;
					if (dbus) {
						char* _tmp2_;
						_tmp2_ = NULL;
						_tmp1_ = g_str_has_prefix (_tmp2_ = vala_data_type_get_type_signature (t), "(");
						_tmp2_ = (g_free (_tmp2_), NULL);
					} else {
						_tmp1_ = FALSE;
					}
					if (_tmp1_) {
						result = g_strdup ("BOXED");
						return result;
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							ValaEnum* _tmp3_;
							ValaEnum* en;
							_tmp3_ = NULL;
							en = (_tmp3_ = VALA_ENUM (vala_data_type_get_data_type (t)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
							if (dbus) {
								if (vala_enum_get_is_flags (en)) {
									result = g_strdup ("UINT");
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
									return result;
								} else {
									result = g_strdup ("INT");
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
									return result;
								}
							} else {
								result = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) en);
								(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
								return result;
							}
							(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
						} else {
							result = vala_typesymbol_get_marshaller_type_name (vala_data_type_get_data_type (t));
							return result;
						}
					}
				}
			}
		}
	}
}


static char* vala_gsignal_module_get_marshaller_type_name_for_parameter (ValaGSignalModule* self, ValaFormalParameter* param, gboolean dbus) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
		result = g_strdup ("POINTER");
		return result;
	} else {
		result = vala_gsignal_module_get_marshaller_type_name (self, vala_formal_parameter_get_parameter_type (param), dbus);
		return result;
	}
}


static char* vala_gsignal_module_real_get_marshaller_function (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus) {
	ValaGSignalModule * self;
	char* result;
	char* signature;
	char* ret;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus);
	ret = NULL;
	if (prefix == NULL) {
		if (gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	ret = (_tmp1_ = g_strdup_printf ("%s_%s_", prefix, _tmp0_ = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus)), ret = (g_free (ret), NULL), _tmp1_);
	_tmp0_ = (g_free (_tmp0_), NULL);
	_tmp2_ = FALSE;
	if (params == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gee_collection_get_size ((GeeCollection*) params) == 0;
	}
	if (_tmp2_) {
		char* _tmp3_;
		_tmp3_ = NULL;
		ret = (_tmp3_ = g_strconcat (ret, "_VOID", NULL), ret = (g_free (ret), NULL), _tmp3_);
	} else {
		{
			GeeIterator* _p_it;
			_p_it = gee_iterable_iterator ((GeeIterable*) params);
			while (TRUE) {
				ValaFormalParameter* p;
				char* _tmp5_;
				char* _tmp4_;
				if (!gee_iterator_next (_p_it)) {
					break;
				}
				p = (ValaFormalParameter*) gee_iterator_get (_p_it);
				_tmp5_ = NULL;
				_tmp4_ = NULL;
				ret = (_tmp5_ = g_strdup_printf ("%s_%s", ret, _tmp4_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus)), ret = (g_free (ret), NULL), _tmp5_);
				_tmp4_ = (g_free (_tmp4_), NULL);
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			}
			(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
		}
	}
	result = ret;
	signature = (g_free (signature), NULL);
	return result;
}


static char* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self, ValaDataType* t) {
	char* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_POINTER_TYPE (t)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_data_type_get_type_parameter (t) != NULL;
	}
	if (_tmp0_) {
		result = g_strdup ("gpointer");
		return result;
	} else {
		if (VALA_IS_VOID_TYPE (t)) {
			result = g_strdup ("void");
			return result;
		} else {
			if (vala_data_type_get_data_type (t) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
				result = g_strdup ("const char*");
				return result;
			} else {
				gboolean _tmp1_;
				_tmp1_ = FALSE;
				if (VALA_IS_CLASS (vala_data_type_get_data_type (t))) {
					_tmp1_ = TRUE;
				} else {
					_tmp1_ = VALA_IS_INTERFACE (vala_data_type_get_data_type (t));
				}
				if (_tmp1_) {
					result = g_strdup ("gpointer");
					return result;
				} else {
					if (VALA_IS_STRUCT (vala_data_type_get_data_type (t))) {
						ValaStruct* _tmp2_;
						ValaStruct* st;
						_tmp2_ = NULL;
						st = (_tmp2_ = VALA_STRUCT (vala_data_type_get_data_type (t)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
						if (vala_struct_is_simple_type (st)) {
							result = vala_typesymbol_get_cname (vala_data_type_get_data_type (t), FALSE);
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							return result;
						} else {
							result = g_strdup ("gpointer");
							(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
							return result;
						}
						(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
					} else {
						if (VALA_IS_ENUM (vala_data_type_get_data_type (t))) {
							result = g_strdup ("gint");
							return result;
						} else {
							if (VALA_IS_ARRAY_TYPE (t)) {
								result = g_strdup ("gpointer");
								return result;
							} else {
								if (VALA_IS_ERROR_TYPE (t)) {
									result = g_strdup ("gpointer");
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static char* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self, ValaFormalParameter* p) {
	char* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
		result = g_strdup ("gpointer");
		return result;
	} else {
		result = vala_gsignal_module_get_value_type_name_from_type_reference (self, vala_formal_parameter_get_parameter_type (p));
		return result;
	}
}


static char* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	char* result;
	char* signature;
	char* _tmp1_;
	char* _tmp0_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	signature = NULL;
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	signature = (_tmp1_ = g_strdup_printf ("%s:", _tmp0_ = vala_gsignal_module_get_marshaller_type_name (self, return_type, dbus)), signature = (g_free (signature), NULL), _tmp1_);
	_tmp0_ = (g_free (_tmp0_), NULL);
	_tmp2_ = FALSE;
	if (params == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = gee_collection_get_size ((GeeCollection*) params) == 0;
	}
	if (_tmp2_) {
		char* _tmp3_;
		_tmp3_ = NULL;
		signature = (_tmp3_ = g_strconcat (signature, "VOID", NULL), signature = (g_free (signature), NULL), _tmp3_);
	} else {
		gboolean first;
		first = TRUE;
		{
			GeeIterator* _p_it;
			_p_it = gee_iterable_iterator ((GeeIterable*) params);
			while (TRUE) {
				ValaFormalParameter* p;
				if (!gee_iterator_next (_p_it)) {
					break;
				}
				p = (ValaFormalParameter*) gee_iterator_get (_p_it);
				if (first) {
					char* _tmp5_;
					char* _tmp4_;
					_tmp5_ = NULL;
					_tmp4_ = NULL;
					signature = (_tmp5_ = g_strconcat (signature, _tmp4_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus), NULL), signature = (g_free (signature), NULL), _tmp5_);
					_tmp4_ = (g_free (_tmp4_), NULL);
					first = FALSE;
				} else {
					char* _tmp7_;
					char* _tmp6_;
					_tmp7_ = NULL;
					_tmp6_ = NULL;
					signature = (_tmp7_ = g_strdup_printf ("%s,%s", signature, _tmp6_ = vala_gsignal_module_get_marshaller_type_name_for_parameter (self, p, dbus)), signature = (g_free (signature), NULL), _tmp7_);
					_tmp6_ = (g_free (_tmp6_), NULL);
				}
				(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			}
			(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
		}
	}
	result = signature;
	return result;
}


static void vala_gsignal_module_real_visit_signal (ValaCCodeModule* base, ValaSignal* sig) {
	ValaGSignalModule * self;
	ValaClass* _tmp1_;
	ValaSymbol* _tmp0_;
	ValaClass* cl;
	gboolean _tmp2_;
	GeeList* _tmp6_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	/* parent_symbol may be null for dynamic signals*/
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	cl = (_tmp1_ = (_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig), VALA_IS_CLASS (_tmp0_) ? ((ValaClass*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (cl != NULL) {
		_tmp2_ = vala_class_get_is_compact (cl);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) sig), "Signals are not supported in compact classes");
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	/* declare parameter type*/
	{
		GeeList* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _p_it;
		/* declare parameter type*/
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		_p_it = (_tmp4_ = gee_iterable_iterator ((GeeIterable*) (_tmp3_ = vala_signal_get_parameters (sig))), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp4_);
		/* declare parameter type*/
		while (TRUE) {
			ValaFormalParameter* p;
			GeeHashMap* _tmp5_;
			/* declare parameter type*/
			if (!gee_iterator_next (_p_it)) {
				/* declare parameter type*/
				break;
			}
			/* declare parameter type*/
			p = (ValaFormalParameter*) gee_iterator_get (_p_it);
			_tmp5_ = NULL;
			vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, p, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) (_tmp5_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal)), NULL);
			(_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL));
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	_tmp6_ = NULL;
	vala_ccode_module_generate_marshaller ((ValaCCodeModule*) self, _tmp6_ = vala_signal_get_parameters (sig), vala_signal_get_return_type (sig), FALSE);
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (gee_collection_object_unref (_tmp6_), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
}


static void vala_gsignal_module_real_generate_marshaller (ValaCCodeModule* base, GeeList* params, ValaDataType* return_type, gboolean dbus) {
	ValaGSignalModule * self;
	char* signature;
	gint n_params;
	gint i;
	char* _tmp0_;
	gboolean _tmp1_;
	char* _tmp2_;
	ValaCCodeFunction* _tmp3_;
	ValaCCodeFunction* signal_marshaller;
	ValaCCodeFormalParameter* _tmp4_;
	ValaCCodeFormalParameter* _tmp5_;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeFormalParameter* _tmp7_;
	ValaCCodeFormalParameter* _tmp8_;
	ValaCCodeFormalParameter* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeBlock* marshaller_body;
	char* _tmp11_;
	ValaCCodeFunctionDeclarator* _tmp12_;
	ValaCCodeFunctionDeclarator* callback_decl;
	ValaCCodeFormalParameter* _tmp13_;
	ValaCCodeFormalParameter* _tmp20_;
	ValaCCodeTypeDefinition* _tmp22_;
	char* _tmp21_;
	char* _tmp23_;
	ValaCCodeDeclaration* _tmp24_;
	ValaCCodeDeclaration* var_decl;
	ValaCCodeVariableDeclarator* _tmp25_;
	ValaCCodeDeclaration* _tmp26_;
	ValaCCodeVariableDeclarator* _tmp29_;
	ValaCCodeCastExpression* _tmp28_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeDeclaration* _tmp30_;
	ValaCCodeVariableDeclarator* _tmp31_;
	ValaCCodeVariableDeclarator* _tmp32_;
	ValaCCodeFunctionCall* fc;
	gboolean _tmp33_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeIdentifier* _tmp43_;
	ValaCCodeBinaryExpression* _tmp48_;
	ValaCCodeConstant* _tmp47_;
	char* _tmp46_;
	ValaCCodeIdentifier* _tmp45_;
	ValaCCodeExpressionStatement* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeMemberAccess* _tmp51_;
	ValaCCodeMemberAccess* data;
	ValaCCodeMemberAccess* _tmp53_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeMemberAccess* _tmp54_;
	ValaCCodeMemberAccess* param;
	ValaCCodeConstant* _tmp55_;
	ValaCCodeFunctionCall* _tmp56_;
	ValaCCodeFunctionCall* cond;
	ValaCCodeIdentifier* _tmp57_;
	ValaCCodeBlock* true_block;
	ValaCCodeExpressionStatement* _tmp60_;
	ValaCCodeAssignment* _tmp59_;
	ValaCCodeIdentifier* _tmp58_;
	ValaCCodeExpressionStatement* _tmp63_;
	ValaCCodeAssignment* _tmp62_;
	ValaCCodeIdentifier* _tmp61_;
	ValaCCodeBlock* false_block;
	ValaCCodeExpressionStatement* _tmp66_;
	ValaCCodeAssignment* _tmp65_;
	ValaCCodeIdentifier* _tmp64_;
	ValaCCodeExpressionStatement* _tmp69_;
	ValaCCodeAssignment* _tmp68_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIfStatement* _tmp70_;
	ValaCCodeCastExpression* _tmp78_;
	char* _tmp77_;
	ValaCCodeConditionalExpression* _tmp76_;
	ValaCCodeMemberAccess* _tmp75_;
	ValaCCodeIdentifier* _tmp74_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp71_;
	ValaCCodeAssignment* _tmp79_;
	ValaCCodeAssignment* c_assign;
	ValaCCodeExpressionStatement* _tmp80_;
	ValaCCodeFunctionCall* _tmp82_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp83_;
	ValaCCodeIdentifier* _tmp112_;
	gboolean _tmp113_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	signature = NULL;
	n_params = 0;
	i = 0;
	/* check whether a signal with the same signature already exists for this source file (or predefined) */
	_tmp0_ = NULL;
	signature = (_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, params, return_type, dbus), signature = (g_free (signature), NULL), _tmp0_);
	_tmp1_ = FALSE;
	if (gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->predefined_marshal_set, signature)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = gee_collection_contains ((GeeCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	}
	if (_tmp1_) {
		signature = (g_free (signature), NULL);
		return;
	}
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	signal_marshaller = (_tmp3_ = vala_ccode_function_new (_tmp2_ = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, NULL, dbus), "void"), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	vala_ccode_function_set_modifiers (signal_marshaller, VALA_CCODE_MODIFIERS_STATIC);
	_tmp4_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp4_ = vala_ccode_formal_parameter_new ("closure", "GClosure *"));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp5_ = vala_ccode_formal_parameter_new ("return_value", "GValue *"));
	(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL));
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp6_ = vala_ccode_formal_parameter_new ("n_param_values", "guint"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp7_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp7_ = vala_ccode_formal_parameter_new ("param_values", "const GValue *"));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp8_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp8_ = vala_ccode_formal_parameter_new ("invocation_hint", "gpointer"));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp9_ = NULL;
	vala_ccode_function_add_parameter (signal_marshaller, _tmp9_ = vala_ccode_formal_parameter_new ("marshal_data", "gpointer"));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_signal_marshaller_declaration, (ValaCCodeNode*) (_tmp10_ = vala_ccode_function_copy (signal_marshaller)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	marshaller_body = vala_ccode_block_new ();
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	callback_decl = (_tmp12_ = vala_ccode_function_declarator_new (_tmp11_ = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus)), _tmp11_ = (g_free (_tmp11_), NULL), _tmp12_);
	_tmp13_ = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp13_ = vala_ccode_formal_parameter_new ("data1", "gpointer"));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	n_params = 1;
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) params);
		while (TRUE) {
			ValaFormalParameter* p;
			ValaCCodeFormalParameter* _tmp16_;
			char* _tmp15_;
			char* _tmp14_;
			gboolean _tmp17_;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaFormalParameter*) gee_iterator_get (_p_it);
			_tmp16_ = NULL;
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			vala_ccode_function_declarator_add_parameter (callback_decl, _tmp16_ = vala_ccode_formal_parameter_new (_tmp14_ = g_strdup_printf ("arg_%d", n_params), _tmp15_ = vala_gsignal_module_get_value_type_name_from_parameter (self, p)));
			(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
			_tmp15_ = (g_free (_tmp15_), NULL);
			_tmp14_ = (g_free (_tmp14_), NULL);
			n_params++;
			_tmp17_ = FALSE;
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p))) {
				_tmp17_ = !dbus;
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				ValaCCodeFormalParameter* _tmp19_;
				char* _tmp18_;
				_tmp19_ = NULL;
				_tmp18_ = NULL;
				vala_ccode_function_declarator_add_parameter (callback_decl, _tmp19_ = vala_ccode_formal_parameter_new (_tmp18_ = g_strdup_printf ("arg_%d", n_params), "gint"));
				(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
				_tmp18_ = (g_free (_tmp18_), NULL);
				n_params++;
			}
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	_tmp20_ = NULL;
	vala_ccode_function_declarator_add_parameter (callback_decl, _tmp20_ = vala_ccode_formal_parameter_new ("data2", "gpointer"));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp22_ = vala_ccode_type_definition_new (_tmp21_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type), (ValaCCodeDeclarator*) callback_decl)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp21_ = (g_free (_tmp21_), NULL);
	_tmp23_ = NULL;
	_tmp24_ = NULL;
	var_decl = (_tmp24_ = vala_ccode_declaration_new (_tmp23_ = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus)), _tmp23_ = (g_free (_tmp23_), NULL), _tmp24_);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp25_ = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp25_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL)));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp26_ = NULL;
	var_decl = (_tmp26_ = vala_ccode_declaration_new ("GCClosure *"), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp26_);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp29_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) (_tmp28_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("closure")), "GCClosure *")), NULL)));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	_tmp30_ = NULL;
	var_decl = (_tmp30_ = vala_ccode_declaration_new ("gpointer"), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp30_);
	vala_ccode_declaration_set_modifiers (var_decl, VALA_CCODE_MODIFIERS_REGISTER);
	_tmp31_ = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp31_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL)));
	(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
	_tmp32_ = NULL;
	vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp32_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL)));
	(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
	fc = NULL;
	_tmp33_ = FALSE;
	if (vala_data_type_get_data_type (return_type) != NULL) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = vala_data_type_is_array (return_type);
	}
	if (_tmp33_) {
		ValaCCodeDeclaration* _tmp35_;
		char* _tmp34_;
		ValaCCodeVariableDeclarator* _tmp36_;
		ValaCCodeFunctionCall* _tmp38_;
		ValaCCodeIdentifier* _tmp37_;
		ValaCCodeBinaryExpression* _tmp41_;
		ValaCCodeConstant* _tmp40_;
		ValaCCodeIdentifier* _tmp39_;
		ValaCCodeExpressionStatement* _tmp42_;
		_tmp35_ = NULL;
		_tmp34_ = NULL;
		var_decl = (_tmp35_ = vala_ccode_declaration_new (_tmp34_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type)), (var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL)), _tmp35_);
		_tmp34_ = (g_free (_tmp34_), NULL);
		_tmp36_ = NULL;
		vala_ccode_declaration_add_declarator (var_decl, (ValaCCodeDeclarator*) (_tmp36_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL)));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) var_decl);
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		fc = (_tmp38_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp38_);
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		_tmp41_ = NULL;
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_identifier_new ("return_value")), (ValaCCodeExpression*) (_tmp40_ = vala_ccode_constant_new ("NULL")))));
		(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		_tmp42_ = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp42_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
		(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
	}
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	fc = (_tmp44_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp43_ = vala_ccode_identifier_new ("g_return_if_fail"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp44_);
	(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	_tmp45_ = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("n_param_values")), (ValaCCodeExpression*) (_tmp47_ = vala_ccode_constant_new (_tmp46_ = g_strdup_printf ("%i", n_params))))));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	_tmp46_ = (g_free (_tmp46_), NULL);
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp49_ = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp49_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	_tmp50_ = NULL;
	_tmp51_ = NULL;
	data = (_tmp51_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp50_ = vala_ccode_identifier_new ("closure")), "data", TRUE), (_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL)), _tmp51_);
	_tmp53_ = NULL;
	_tmp52_ = NULL;
	_tmp54_ = NULL;
	param = (_tmp54_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp53_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("param_values")), "data[0]", TRUE)), "v_pointer", FALSE), (_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL)), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL)), _tmp54_);
	_tmp55_ = NULL;
	_tmp56_ = NULL;
	cond = (_tmp56_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp55_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA"))), (_tmp55_ == NULL) ? NULL : (_tmp55_ = (vala_ccode_node_unref (_tmp55_), NULL)), _tmp56_);
	_tmp57_ = NULL;
	vala_ccode_function_call_add_argument (cond, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_identifier_new ("closure")));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	true_block = vala_ccode_block_new ();
	_tmp60_ = NULL;
	_tmp59_ = NULL;
	_tmp58_ = NULL;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) (_tmp60_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new ("data1")), (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
	(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
	(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	_tmp63_ = NULL;
	_tmp62_ = NULL;
	_tmp61_ = NULL;
	vala_ccode_block_add_statement (true_block, (ValaCCodeNode*) (_tmp63_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp62_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_identifier_new ("data2")), (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp63_ == NULL) ? NULL : (_tmp63_ = (vala_ccode_node_unref (_tmp63_), NULL));
	(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
	(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
	false_block = vala_ccode_block_new ();
	_tmp66_ = NULL;
	_tmp65_ = NULL;
	_tmp64_ = NULL;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) (_tmp66_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp65_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp64_ = vala_ccode_identifier_new ("data1")), (ValaCCodeExpression*) param, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp66_ == NULL) ? NULL : (_tmp66_ = (vala_ccode_node_unref (_tmp66_), NULL));
	(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
	(_tmp64_ == NULL) ? NULL : (_tmp64_ = (vala_ccode_node_unref (_tmp64_), NULL));
	_tmp69_ = NULL;
	_tmp68_ = NULL;
	_tmp67_ = NULL;
	vala_ccode_block_add_statement (false_block, (ValaCCodeNode*) (_tmp69_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp68_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_identifier_new ("data2")), (ValaCCodeExpression*) data, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
	(_tmp68_ == NULL) ? NULL : (_tmp68_ = (vala_ccode_node_unref (_tmp68_), NULL));
	(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
	_tmp70_ = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp70_ = vala_ccode_if_statement_new ((ValaCCodeExpression*) cond, (ValaCCodeStatement*) true_block, (ValaCCodeStatement*) false_block)));
	(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
	_tmp78_ = NULL;
	_tmp77_ = NULL;
	_tmp76_ = NULL;
	_tmp75_ = NULL;
	_tmp74_ = NULL;
	_tmp73_ = NULL;
	_tmp72_ = NULL;
	_tmp71_ = NULL;
	_tmp79_ = NULL;
	c_assign = (_tmp79_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp71_ = vala_ccode_identifier_new ("callback")), (ValaCCodeExpression*) (_tmp78_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp76_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) (_tmp72_ = vala_ccode_identifier_new ("marshal_data")), (ValaCCodeExpression*) (_tmp73_ = vala_ccode_identifier_new ("marshal_data")), (ValaCCodeExpression*) (_tmp75_ = vala_ccode_member_access_new ((ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new ("cc")), "callback", TRUE)))), _tmp77_ = vala_ccode_module_get_marshaller_function ((ValaCCodeModule*) self, params, return_type, "GMarshalFunc", dbus))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL)), _tmp77_ = (g_free (_tmp77_), NULL), (_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL)), (_tmp75_ == NULL) ? NULL : (_tmp75_ = (vala_ccode_node_unref (_tmp75_), NULL)), (_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL)), (_tmp73_ == NULL) ? NULL : (_tmp73_ = (vala_ccode_node_unref (_tmp73_), NULL)), (_tmp72_ == NULL) ? NULL : (_tmp72_ = (vala_ccode_node_unref (_tmp72_), NULL)), (_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL)), _tmp79_);
	_tmp80_ = NULL;
	vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp80_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) c_assign)));
	(_tmp80_ == NULL) ? NULL : (_tmp80_ = (vala_ccode_node_unref (_tmp80_), NULL));
	_tmp82_ = NULL;
	_tmp81_ = NULL;
	fc = (_tmp82_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp81_ = vala_ccode_identifier_new ("callback"))), (fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL)), _tmp82_);
	(_tmp81_ == NULL) ? NULL : (_tmp81_ = (vala_ccode_node_unref (_tmp81_), NULL));
	_tmp83_ = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp83_ = vala_ccode_identifier_new ("data1")));
	(_tmp83_ == NULL) ? NULL : (_tmp83_ = (vala_ccode_node_unref (_tmp83_), NULL));
	i = 1;
	{
		GeeIterator* _p_it;
		_p_it = gee_iterable_iterator ((GeeIterable*) params);
		while (TRUE) {
			ValaFormalParameter* p;
			char* get_value_function;
			gboolean is_array;
			ValaCCodeIdentifier* _tmp99_;
			ValaCCodeFunctionCall* _tmp100_;
			ValaCCodeFunctionCall* inner_fc;
			ValaCCodeBinaryExpression* _tmp104_;
			ValaCCodeIdentifier* _tmp103_;
			char* _tmp102_;
			ValaCCodeIdentifier* _tmp101_;
			gboolean _tmp105_;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaFormalParameter*) gee_iterator_get (_p_it);
			get_value_function = NULL;
			is_array = vala_data_type_is_array (vala_formal_parameter_get_parameter_type (p));
			if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN) {
				char* _tmp84_;
				_tmp84_ = NULL;
				get_value_function = (_tmp84_ = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp84_);
			} else {
				if (is_array) {
					if (dbus) {
						char* _tmp85_;
						_tmp85_ = NULL;
						get_value_function = (_tmp85_ = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp85_);
					} else {
						if (vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (p)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
							char* _tmp86_;
							_tmp86_ = NULL;
							get_value_function = (_tmp86_ = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp86_);
						} else {
							char* _tmp87_;
							_tmp87_ = NULL;
							get_value_function = (_tmp87_ = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp87_);
						}
					}
				} else {
					gboolean _tmp88_;
					_tmp88_ = FALSE;
					if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (p))) {
						_tmp88_ = TRUE;
					} else {
						_tmp88_ = vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (p)) != NULL;
					}
					if (_tmp88_) {
						char* _tmp89_;
						_tmp89_ = NULL;
						get_value_function = (_tmp89_ = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp89_);
					} else {
						if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (p))) {
							char* _tmp90_;
							_tmp90_ = NULL;
							get_value_function = (_tmp90_ = g_strdup ("g_value_get_pointer"), get_value_function = (g_free (get_value_function), NULL), _tmp90_);
						} else {
							gboolean _tmp91_;
							_tmp91_ = FALSE;
							if (dbus) {
								char* _tmp92_;
								_tmp92_ = NULL;
								_tmp91_ = g_str_has_prefix (_tmp92_ = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (p)), "(");
								_tmp92_ = (g_free (_tmp92_), NULL);
							} else {
								_tmp91_ = FALSE;
							}
							if (_tmp91_) {
								char* _tmp93_;
								_tmp93_ = NULL;
								get_value_function = (_tmp93_ = g_strdup ("g_value_get_boxed"), get_value_function = (g_free (get_value_function), NULL), _tmp93_);
							} else {
								gboolean _tmp94_;
								_tmp94_ = FALSE;
								if (dbus) {
									_tmp94_ = VALA_IS_ENUM (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p)));
								} else {
									_tmp94_ = FALSE;
								}
								if (_tmp94_) {
									ValaEnum* _tmp95_;
									ValaEnum* en;
									_tmp95_ = NULL;
									en = (_tmp95_ = VALA_ENUM (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), (_tmp95_ == NULL) ? NULL : vala_code_node_ref (_tmp95_));
									if (vala_enum_get_is_flags (en)) {
										char* _tmp96_;
										_tmp96_ = NULL;
										get_value_function = (_tmp96_ = g_strdup ("g_value_get_uint"), get_value_function = (g_free (get_value_function), NULL), _tmp96_);
									} else {
										char* _tmp97_;
										_tmp97_ = NULL;
										get_value_function = (_tmp97_ = g_strdup ("g_value_get_int"), get_value_function = (g_free (get_value_function), NULL), _tmp97_);
									}
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
								} else {
									char* _tmp98_;
									_tmp98_ = NULL;
									get_value_function = (_tmp98_ = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (p))), get_value_function = (g_free (get_value_function), NULL), _tmp98_);
								}
							}
						}
					}
				}
			}
			_tmp99_ = NULL;
			_tmp100_ = NULL;
			inner_fc = (_tmp100_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp99_ = vala_ccode_identifier_new (get_value_function))), (_tmp99_ == NULL) ? NULL : (_tmp99_ = (vala_ccode_node_unref (_tmp99_), NULL)), _tmp100_);
			_tmp104_ = NULL;
			_tmp103_ = NULL;
			_tmp102_ = NULL;
			_tmp101_ = NULL;
			vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) (_tmp104_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp101_ = vala_ccode_identifier_new ("param_values")), (ValaCCodeExpression*) (_tmp103_ = vala_ccode_identifier_new (_tmp102_ = g_strdup_printf ("%i", i))))));
			(_tmp104_ == NULL) ? NULL : (_tmp104_ = (vala_ccode_node_unref (_tmp104_), NULL));
			(_tmp103_ == NULL) ? NULL : (_tmp103_ = (vala_ccode_node_unref (_tmp103_), NULL));
			_tmp102_ = (g_free (_tmp102_), NULL);
			(_tmp101_ == NULL) ? NULL : (_tmp101_ = (vala_ccode_node_unref (_tmp101_), NULL));
			vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
			i++;
			_tmp105_ = FALSE;
			if (is_array) {
				_tmp105_ = !dbus;
			} else {
				_tmp105_ = FALSE;
			}
			if (_tmp105_) {
				ValaCCodeFunctionCall* _tmp107_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeBinaryExpression* _tmp111_;
				ValaCCodeIdentifier* _tmp110_;
				char* _tmp109_;
				ValaCCodeIdentifier* _tmp108_;
				_tmp107_ = NULL;
				_tmp106_ = NULL;
				inner_fc = (_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp106_ = vala_ccode_identifier_new ("g_value_get_int"))), (inner_fc == NULL) ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL)), _tmp107_);
				(_tmp106_ == NULL) ? NULL : (_tmp106_ = (vala_ccode_node_unref (_tmp106_), NULL));
				_tmp111_ = NULL;
				_tmp110_ = NULL;
				_tmp109_ = NULL;
				_tmp108_ = NULL;
				vala_ccode_function_call_add_argument (inner_fc, (ValaCCodeExpression*) (_tmp111_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) (_tmp108_ = vala_ccode_identifier_new ("param_values")), (ValaCCodeExpression*) (_tmp110_ = vala_ccode_identifier_new (_tmp109_ = g_strdup_printf ("%i", i))))));
				(_tmp111_ == NULL) ? NULL : (_tmp111_ = (vala_ccode_node_unref (_tmp111_), NULL));
				(_tmp110_ == NULL) ? NULL : (_tmp110_ = (vala_ccode_node_unref (_tmp110_), NULL));
				_tmp109_ = (g_free (_tmp109_), NULL);
				(_tmp108_ == NULL) ? NULL : (_tmp108_ = (vala_ccode_node_unref (_tmp108_), NULL));
				vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) inner_fc);
				i++;
			}
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
			get_value_function = (g_free (get_value_function), NULL);
			(inner_fc == NULL) ? NULL : (inner_fc = (vala_ccode_node_unref (inner_fc), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	_tmp112_ = NULL;
	vala_ccode_function_call_add_argument (fc, (ValaCCodeExpression*) (_tmp112_ = vala_ccode_identifier_new ("data2")));
	(_tmp112_ == NULL) ? NULL : (_tmp112_ = (vala_ccode_node_unref (_tmp112_), NULL));
	_tmp113_ = FALSE;
	if (vala_data_type_get_data_type (return_type) != NULL) {
		_tmp113_ = TRUE;
	} else {
		_tmp113_ = vala_data_type_is_array (return_type);
	}
	if (_tmp113_) {
		ValaCCodeExpressionStatement* _tmp116_;
		ValaCCodeAssignment* _tmp115_;
		ValaCCodeIdentifier* _tmp114_;
		ValaCCodeFunctionCall* set_fc;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeIdentifier* _tmp146_;
		ValaCCodeExpressionStatement* _tmp147_;
		_tmp116_ = NULL;
		_tmp115_ = NULL;
		_tmp114_ = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp116_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp115_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp114_ = vala_ccode_identifier_new ("v_return")), (ValaCCodeExpression*) fc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp116_ == NULL) ? NULL : (_tmp116_ = (vala_ccode_node_unref (_tmp116_), NULL));
		(_tmp115_ == NULL) ? NULL : (_tmp115_ = (vala_ccode_node_unref (_tmp115_), NULL));
		(_tmp114_ == NULL) ? NULL : (_tmp114_ = (vala_ccode_node_unref (_tmp114_), NULL));
		set_fc = NULL;
		if (vala_data_type_is_array (return_type)) {
			if (dbus) {
				ValaCCodeFunctionCall* _tmp118_;
				ValaCCodeIdentifier* _tmp117_;
				_tmp118_ = NULL;
				_tmp117_ = NULL;
				set_fc = (_tmp118_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp117_ = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp118_);
				(_tmp117_ == NULL) ? NULL : (_tmp117_ = (vala_ccode_node_unref (_tmp117_), NULL));
			} else {
				if (vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (return_type))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeFunctionCall* _tmp120_;
					ValaCCodeIdentifier* _tmp119_;
					_tmp120_ = NULL;
					_tmp119_ = NULL;
					set_fc = (_tmp120_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp119_ = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp120_);
					(_tmp119_ == NULL) ? NULL : (_tmp119_ = (vala_ccode_node_unref (_tmp119_), NULL));
				} else {
					ValaCCodeFunctionCall* _tmp122_;
					ValaCCodeIdentifier* _tmp121_;
					_tmp122_ = NULL;
					_tmp121_ = NULL;
					set_fc = (_tmp122_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp121_ = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp122_);
					(_tmp121_ == NULL) ? NULL : (_tmp121_ = (vala_ccode_node_unref (_tmp121_), NULL));
				}
			}
		} else {
			if (vala_data_type_get_type_parameter (return_type) != NULL) {
				ValaCCodeFunctionCall* _tmp124_;
				ValaCCodeIdentifier* _tmp123_;
				_tmp124_ = NULL;
				_tmp123_ = NULL;
				set_fc = (_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp123_ = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp124_);
				(_tmp123_ == NULL) ? NULL : (_tmp123_ = (vala_ccode_node_unref (_tmp123_), NULL));
			} else {
				if (VALA_IS_ERROR_TYPE (return_type)) {
					ValaCCodeFunctionCall* _tmp126_;
					ValaCCodeIdentifier* _tmp125_;
					_tmp126_ = NULL;
					_tmp125_ = NULL;
					set_fc = (_tmp126_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp125_ = vala_ccode_identifier_new ("g_value_set_pointer"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp126_);
					(_tmp125_ == NULL) ? NULL : (_tmp125_ = (vala_ccode_node_unref (_tmp125_), NULL));
				} else {
					if (vala_data_type_get_data_type (return_type) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
						ValaCCodeFunctionCall* _tmp128_;
						ValaCCodeIdentifier* _tmp127_;
						_tmp128_ = NULL;
						_tmp127_ = NULL;
						set_fc = (_tmp128_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp127_ = vala_ccode_identifier_new ("g_value_take_string"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp128_);
						(_tmp127_ == NULL) ? NULL : (_tmp127_ = (vala_ccode_node_unref (_tmp127_), NULL));
					} else {
						gboolean _tmp129_;
						_tmp129_ = FALSE;
						if (VALA_IS_CLASS (vala_data_type_get_data_type (return_type))) {
							_tmp129_ = TRUE;
						} else {
							_tmp129_ = VALA_IS_INTERFACE (vala_data_type_get_data_type (return_type));
						}
						if (_tmp129_) {
							ValaCCodeFunctionCall* _tmp131_;
							ValaCCodeIdentifier* _tmp130_;
							_tmp131_ = NULL;
							_tmp130_ = NULL;
							set_fc = (_tmp131_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp130_ = vala_ccode_identifier_new ("g_value_take_object"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp131_);
							(_tmp130_ == NULL) ? NULL : (_tmp130_ = (vala_ccode_node_unref (_tmp130_), NULL));
						} else {
							gboolean _tmp132_;
							_tmp132_ = FALSE;
							if (dbus) {
								char* _tmp133_;
								_tmp133_ = NULL;
								_tmp132_ = g_str_has_prefix (_tmp133_ = vala_data_type_get_type_signature (return_type), "(");
								_tmp133_ = (g_free (_tmp133_), NULL);
							} else {
								_tmp132_ = FALSE;
							}
							if (_tmp132_) {
								ValaCCodeFunctionCall* _tmp135_;
								ValaCCodeIdentifier* _tmp134_;
								_tmp135_ = NULL;
								_tmp134_ = NULL;
								set_fc = (_tmp135_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp134_ = vala_ccode_identifier_new ("g_value_take_boxed"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp135_);
								(_tmp134_ == NULL) ? NULL : (_tmp134_ = (vala_ccode_node_unref (_tmp134_), NULL));
							} else {
								gboolean _tmp136_;
								_tmp136_ = FALSE;
								if (dbus) {
									_tmp136_ = VALA_IS_ENUM (vala_data_type_get_data_type (return_type));
								} else {
									_tmp136_ = FALSE;
								}
								if (_tmp136_) {
									ValaEnum* _tmp137_;
									ValaEnum* en;
									_tmp137_ = NULL;
									en = (_tmp137_ = VALA_ENUM (vala_data_type_get_data_type (return_type)), (_tmp137_ == NULL) ? NULL : vala_code_node_ref (_tmp137_));
									if (vala_enum_get_is_flags (en)) {
										ValaCCodeFunctionCall* _tmp139_;
										ValaCCodeIdentifier* _tmp138_;
										_tmp139_ = NULL;
										_tmp138_ = NULL;
										set_fc = (_tmp139_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp138_ = vala_ccode_identifier_new ("g_value_set_uint"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp139_);
										(_tmp138_ == NULL) ? NULL : (_tmp138_ = (vala_ccode_node_unref (_tmp138_), NULL));
									} else {
										ValaCCodeFunctionCall* _tmp141_;
										ValaCCodeIdentifier* _tmp140_;
										_tmp141_ = NULL;
										_tmp140_ = NULL;
										set_fc = (_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp140_ = vala_ccode_identifier_new ("g_value_set_int"))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp141_);
										(_tmp140_ == NULL) ? NULL : (_tmp140_ = (vala_ccode_node_unref (_tmp140_), NULL));
									}
									(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
								} else {
									ValaCCodeFunctionCall* _tmp144_;
									ValaCCodeIdentifier* _tmp143_;
									char* _tmp142_;
									_tmp144_ = NULL;
									_tmp143_ = NULL;
									_tmp142_ = NULL;
									set_fc = (_tmp144_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp143_ = vala_ccode_identifier_new (_tmp142_ = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (return_type))))), (set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL)), _tmp144_);
									(_tmp143_ == NULL) ? NULL : (_tmp143_ = (vala_ccode_node_unref (_tmp143_), NULL));
									_tmp142_ = (g_free (_tmp142_), NULL);
								}
							}
						}
					}
				}
			}
		}
		_tmp145_ = NULL;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) (_tmp145_ = vala_ccode_identifier_new ("return_value")));
		(_tmp145_ == NULL) ? NULL : (_tmp145_ = (vala_ccode_node_unref (_tmp145_), NULL));
		_tmp146_ = NULL;
		vala_ccode_function_call_add_argument (set_fc, (ValaCCodeExpression*) (_tmp146_ = vala_ccode_identifier_new ("v_return")));
		(_tmp146_ == NULL) ? NULL : (_tmp146_ = (vala_ccode_node_unref (_tmp146_), NULL));
		_tmp147_ = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp147_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_fc)));
		(_tmp147_ == NULL) ? NULL : (_tmp147_ = (vala_ccode_node_unref (_tmp147_), NULL));
		(set_fc == NULL) ? NULL : (set_fc = (vala_ccode_node_unref (set_fc), NULL));
	} else {
		ValaCCodeExpressionStatement* _tmp148_;
		_tmp148_ = NULL;
		vala_ccode_block_add_statement (marshaller_body, (ValaCCodeNode*) (_tmp148_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) fc)));
		(_tmp148_ == NULL) ? NULL : (_tmp148_ = (vala_ccode_node_unref (_tmp148_), NULL));
	}
	vala_ccode_function_set_block (signal_marshaller, marshaller_body);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_signal_marshaller_definition, (ValaCCodeNode*) signal_marshaller);
	gee_collection_add ((GeeCollection*) ((ValaCCodeBaseModule*) self)->user_marshal_set, signature);
	signature = (g_free (signature), NULL);
	(signal_marshaller == NULL) ? NULL : (signal_marshaller = (vala_ccode_node_unref (signal_marshaller), NULL));
	(marshaller_body == NULL) ? NULL : (marshaller_body = (vala_ccode_node_unref (marshaller_body), NULL));
	(callback_decl == NULL) ? NULL : (callback_decl = (vala_ccode_node_unref (callback_decl), NULL));
	(var_decl == NULL) ? NULL : (var_decl = (vala_ccode_node_unref (var_decl), NULL));
	(fc == NULL) ? NULL : (fc = (vala_ccode_node_unref (fc), NULL));
	(data == NULL) ? NULL : (data = (vala_ccode_node_unref (data), NULL));
	(param == NULL) ? NULL : (param = (vala_ccode_node_unref (param), NULL));
	(cond == NULL) ? NULL : (cond = (vala_ccode_node_unref (cond), NULL));
	(true_block == NULL) ? NULL : (true_block = (vala_ccode_node_unref (true_block), NULL));
	(false_block == NULL) ? NULL : (false_block = (vala_ccode_node_unref (false_block), NULL));
	(c_assign == NULL) ? NULL : (c_assign = (vala_ccode_node_unref (c_assign), NULL));
}


static ValaCCodeFunctionCall* vala_gsignal_module_real_get_signal_creation (ValaCCodeModule* base, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaGSignalModule * self;
	ValaCCodeFunctionCall* result;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp4_;
	char* _tmp3_;
	char* _tmp2_;
	ValaCCodeIdentifier* _tmp6_;
	char* _tmp5_;
	ValaCCodeConstant* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	GeeList* _tmp11_;
	char* _tmp12_;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gboolean _tmp13_;
	gint params_len;
	ValaCCodeConstant* _tmp20_;
	char* _tmp19_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	csignew = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_signal_new"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp4_ = vala_ccode_constant_new (_tmp3_ = g_strdup_printf ("\"%s\"", _tmp2_ = vala_signal_get_cname (sig)))));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = vala_typesymbol_get_type_id (type))));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp7_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST")));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp8_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new ("0")));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	_tmp9_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_constant_new ("NULL")));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	_tmp10_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp10_ = vala_ccode_constant_new ("NULL")));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	marshaller = (_tmp12_ = vala_ccode_module_get_marshaller_function (vala_ccode_module_get_head ((ValaCCodeModule*) self), _tmp11_ = vala_signal_get_parameters (sig), vala_signal_get_return_type (sig), NULL, FALSE), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) marshal_arg);
	params = vala_signal_get_parameters (sig);
	_tmp13_ = FALSE;
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig))) {
		_tmp13_ = TRUE;
	} else {
		_tmp13_ = vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL;
	}
	if (_tmp13_) {
		ValaCCodeConstant* _tmp14_;
		_tmp14_ = NULL;
		vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_constant_new ("G_TYPE_POINTER")));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp15_;
			_tmp15_ = NULL;
			vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_constant_new ("G_TYPE_POINTER")));
			(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp16_;
				_tmp16_ = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp16_ = vala_ccode_constant_new ("G_TYPE_NONE")));
				(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
			} else {
				ValaCCodeConstant* _tmp18_;
				char* _tmp17_;
				_tmp18_ = NULL;
				_tmp17_ = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp18_ = vala_ccode_constant_new (_tmp17_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))));
				(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
				_tmp17_ = (g_free (_tmp17_), NULL);
			}
		}
	}
	params_len = 0;
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			params_len++;
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
				params_len++;
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_constant_new (_tmp19_ = g_strdup_printf ("%d", params_len))));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp19_ = (g_free (_tmp19_), NULL);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) params);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
				ValaCCodeConstant* _tmp23_;
				if (vala_data_type_get_data_type (vala_array_type_get_element_type (VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)))) == vala_data_type_get_data_type (((ValaCCodeBaseModule*) self)->string_type)) {
					ValaCCodeConstant* _tmp21_;
					_tmp21_ = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_constant_new ("G_TYPE_STRV")));
					(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
				} else {
					ValaCCodeConstant* _tmp22_;
					_tmp22_ = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp22_ = vala_ccode_constant_new ("G_TYPE_POINTER")));
					(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
				}
				_tmp23_ = NULL;
				vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_constant_new ("G_TYPE_INT")));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
			} else {
				gboolean _tmp24_;
				gboolean _tmp25_;
				_tmp24_ = FALSE;
				_tmp25_ = FALSE;
				if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (param))) {
					_tmp25_ = TRUE;
				} else {
					_tmp25_ = vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (param)) != NULL;
				}
				if (_tmp25_) {
					_tmp24_ = TRUE;
				} else {
					_tmp24_ = vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN;
				}
				if (_tmp24_) {
					ValaCCodeConstant* _tmp26_;
					_tmp26_ = NULL;
					vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp26_ = vala_ccode_constant_new ("G_TYPE_POINTER")));
					(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
				} else {
					if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
						ValaCCodeConstant* _tmp27_;
						_tmp27_ = NULL;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_constant_new ("G_TYPE_POINTER")));
						(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
					} else {
						ValaCCodeConstant* _tmp29_;
						char* _tmp28_;
						_tmp29_ = NULL;
						_tmp28_ = NULL;
						vala_ccode_function_call_add_argument (csignew, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_constant_new (_tmp28_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))));
						(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
						_tmp28_ = (g_free (_tmp28_), NULL);
					}
				}
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	result = csignew;
	marshaller = (g_free (marshaller), NULL);
	(marshal_arg == NULL) ? NULL : (marshal_arg = (vala_ccode_node_unref (marshal_arg), NULL));
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	return result;
}


static ValaCCodeExpression* vala_gsignal_module_real_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	ValaCCodeExpression* result;
	char* _tmp0_;
	ValaCCodeExpression* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data_type != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = (ValaCCodeExpression*) vala_ccode_constant_new (_tmp0_ = vala_typesymbol_get_type_id (vala_data_type_get_data_type (data_type))), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


ValaCCodeExpression* vala_gsignal_module_get_dbus_g_type (ValaGSignalModule* self, ValaDataType* data_type) {
	return VALA_GSIGNAL_MODULE_GET_CLASS (self)->get_dbus_g_type (self, data_type);
}


static void vala_gsignal_module_real_visit_element_access (ValaCCodeModule* base, ValaElementAccess* expr) {
	ValaGSignalModule * self;
	gboolean _tmp0_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = FALSE;
	if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr))) {
		_tmp0_ = VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSignal* _tmp1_;
		ValaSignal* sig;
		ValaMemberAccess* _tmp2_;
		ValaMemberAccess* ma;
		GeeList* _tmp3_;
		ValaExpression* _tmp4_;
		ValaStringLiteral* _tmp5_;
		ValaStringLiteral* detail_expr;
		char* signal_detail;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeFunctionCall* _tmp7_;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeConstant* _tmp8_;
		/* detailed signal emission*/
		_tmp1_ = NULL;
		sig = (_tmp1_ = VALA_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
		_tmp2_ = NULL;
		ma = (_tmp2_ = VALA_MEMBER_ACCESS (vala_element_access_get_container (expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp3_ = NULL;
		_tmp4_ = NULL;
		_tmp5_ = NULL;
		detail_expr = (_tmp5_ = (_tmp4_ = (ValaExpression*) gee_list_get (_tmp3_ = vala_element_access_get_indices (expr), 0), VALA_IS_STRING_LITERAL (_tmp4_) ? ((ValaStringLiteral*) _tmp4_) : NULL), (_tmp3_ == NULL) ? NULL : (_tmp3_ = (gee_collection_object_unref (_tmp3_), NULL)), _tmp5_);
		signal_detail = vala_string_literal_eval (detail_expr);
		_tmp6_ = NULL;
		_tmp7_ = NULL;
		ccall = (_tmp7_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL)), _tmp7_);
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (ma))));
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp8_ = vala_signal_get_canonical_cconstant (sig, signal_detail)));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
		signal_detail = (g_free (signal_detail), NULL);
		(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static ValaCCodeExpression* vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self, ValaAssignment* assignment) {
	ValaCCodeExpression* result;
	ValaSignal* _tmp0_;
	ValaSignal* sig;
	ValaMethod* _tmp1_;
	ValaMethod* m;
	ValaTypeSymbol* _tmp3_;
	ValaSymbol* _tmp2_;
	ValaTypeSymbol* target_type_symbol;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeFunctionCall* ccall;
	char* signal_detail;
	ValaMemberAccess* ma;
	ValaCCodeCastExpression* _tmp44_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (assignment != NULL, NULL);
	_tmp0_ = NULL;
	sig = (_tmp0_ = VALA_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment))), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	_tmp1_ = NULL;
	m = (_tmp1_ = VALA_METHOD (vala_expression_get_symbol_reference (vala_assignment_get_right (assignment))), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	target_type_symbol = (_tmp3_ = (_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_TYPESYMBOL (_tmp2_) ? ((ValaTypeSymbol*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	connect_func = NULL;
	disconnect = FALSE;
	if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_ADD) {
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp4_;
			_tmp4_ = NULL;
			connect_func = (_tmp4_ = vala_ccode_module_get_dynamic_signal_connect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp4_);
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
				gboolean _tmp5_;
				_tmp5_ = FALSE;
				if (target_type_symbol != NULL) {
					_tmp5_ = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					char* _tmp6_;
					_tmp6_ = NULL;
					connect_func = (_tmp6_ = g_strdup ("g_signal_connect_object"), connect_func = (g_free (connect_func), NULL), _tmp6_);
				} else {
					char* _tmp7_;
					_tmp7_ = NULL;
					connect_func = (_tmp7_ = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp7_);
				}
			} else {
				char* _tmp8_;
				_tmp8_ = NULL;
				connect_func = (_tmp8_ = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp8_);
			}
		}
	} else {
		if (vala_assignment_get_operator (assignment) == VALA_ASSIGNMENT_OPERATOR_SUB) {
			if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
				char* _tmp9_;
				_tmp9_ = NULL;
				connect_func = (_tmp9_ = vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp9_);
			} else {
				char* _tmp10_;
				_tmp10_ = NULL;
				connect_func = (_tmp10_ = g_strdup ("g_signal_handlers_disconnect_matched"), connect_func = (g_free (connect_func), NULL), _tmp10_);
			}
			disconnect = TRUE;
		} else {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) assignment), "Specified compound assignment type for signals not supported.");
			result = NULL;
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL));
			connect_func = (g_free (connect_func), NULL);
			return result;
		}
	}
	_tmp11_ = NULL;
	_tmp12_ = NULL;
	ccall = (_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (connect_func))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL)), _tmp12_);
	signal_detail = NULL;
	/* first argument: instance of sender*/
	ma = NULL;
	if (VALA_IS_ELEMENT_ACCESS (vala_assignment_get_left (assignment))) {
		ValaElementAccess* _tmp13_;
		ValaElementAccess* ea;
		ValaMemberAccess* _tmp15_;
		ValaMemberAccess* _tmp14_;
		GeeList* _tmp16_;
		ValaExpression* _tmp17_;
		ValaStringLiteral* _tmp18_;
		ValaStringLiteral* detail_expr;
		char* _tmp19_;
		_tmp13_ = NULL;
		ea = (_tmp13_ = VALA_ELEMENT_ACCESS (vala_assignment_get_left (assignment)), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		ma = (_tmp15_ = (_tmp14_ = VALA_MEMBER_ACCESS (vala_element_access_get_container (ea)), (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp15_);
		_tmp16_ = NULL;
		_tmp17_ = NULL;
		_tmp18_ = NULL;
		detail_expr = (_tmp18_ = (_tmp17_ = (ValaExpression*) gee_list_get (_tmp16_ = vala_element_access_get_indices (ea), 0), VALA_IS_STRING_LITERAL (_tmp17_) ? ((ValaStringLiteral*) _tmp17_) : NULL), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (gee_collection_object_unref (_tmp16_), NULL)), _tmp18_);
		if (detail_expr == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr), "internal error: only literal string details supported");
			result = NULL;
			(ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL));
			(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL));
			connect_func = (g_free (connect_func), NULL);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			signal_detail = (g_free (signal_detail), NULL);
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			return result;
		}
		_tmp19_ = NULL;
		signal_detail = (_tmp19_ = vala_string_literal_eval (detail_expr), signal_detail = (g_free (signal_detail), NULL), _tmp19_);
		(ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL));
		(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
	} else {
		ValaMemberAccess* _tmp21_;
		ValaMemberAccess* _tmp20_;
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		ma = (_tmp21_ = (_tmp20_ = VALA_MEMBER_ACCESS (vala_assignment_get_left (assignment)), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp21_);
	}
	if (vala_member_access_get_inner (ma) != NULL) {
		ValaCCodeExpression* _tmp22_;
		_tmp22_ = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp22_ = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp23_;
		_tmp23_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new ("self")));
		(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp25_;
		char* _tmp24_;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp25_ = NULL;
		_tmp24_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_constant_new (_tmp24_ = g_strdup_printf ("\"%s\"", vala_symbol_get_name ((ValaSymbol*) sig)))));
		(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
		_tmp24_ = (g_free (_tmp24_), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp26_;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp26_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp26_ = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
		} else {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp29_;
			ValaCCodeFunctionCall* _tmp30_;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp31_;
			ValaTypeSymbol* _tmp32_;
			ValaTypeSymbol* decl_type;
			ValaCCodeIdentifier* _tmp34_;
			char* _tmp33_;
			ValaCCodeUnaryExpression* _tmp36_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeConstant* _tmp40_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp27_;
				_tmp27_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp27_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
			} else {
				ValaCCodeConstant* _tmp28_;
				_tmp28_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp28_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
			}
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->uint_type, TRUE, NULL);
			gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
			_tmp29_ = NULL;
			_tmp30_ = NULL;
			parse_call = (_tmp30_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("g_signal_parse_name"))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL)), _tmp30_);
			_tmp31_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp31_ = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
			_tmp32_ = NULL;
			decl_type = (_tmp32_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_));
			_tmp34_ = NULL;
			_tmp33_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_identifier_new (_tmp33_ = vala_typesymbol_get_type_id (decl_type))));
			(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
			_tmp33_ = (g_free (_tmp33_), NULL);
			_tmp36_ = NULL;
			_tmp35_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp36_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))))));
			(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
			(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp37_;
				_tmp37_ = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp37_ = vala_ccode_constant_new ("NULL")));
				(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			} else {
				ValaLocalVariable* detail_temp_decl;
				ValaCCodeUnaryExpression* _tmp39_;
				ValaCCodeIdentifier* _tmp38_;
				detail_temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL);
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, detail_temp_decl);
				_tmp39_ = NULL;
				_tmp38_ = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) detail_temp_decl))))));
				(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
				(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
				(detail_temp_decl == NULL) ? NULL : (detail_temp_decl = (vala_code_node_unref (detail_temp_decl), NULL));
			}
			_tmp40_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_constant_new ("FALSE")));
			(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) parse_call);
			_tmp41_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
			(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccomma);
			/* fourth argument: detail*/
			_tmp42_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_constant_new ("0")));
			(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
			/* fifth argument: closure*/
			_tmp43_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("NULL")));
			(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(parse_call == NULL) ? NULL : (parse_call = (vala_ccode_node_unref (parse_call), NULL));
			(decl_type == NULL) ? NULL : (decl_type = (vala_code_node_unref (decl_type), NULL));
		}
	}
	/* third resp. sixth argument: handler*/
	_tmp44_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_assignment_get_right (assignment))), "GCallback")));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_right (assignment))) {
			ValaMemberAccess* _tmp45_;
			ValaMemberAccess* right_ma;
			_tmp45_ = NULL;
			right_ma = (_tmp45_ = VALA_MEMBER_ACCESS (vala_assignment_get_right (assignment)), (_tmp45_ == NULL) ? NULL : vala_code_node_ref (_tmp45_));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (right_ma))));
			} else {
				ValaCCodeIdentifier* _tmp46_;
				_tmp46_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_identifier_new ("self")));
				(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
			}
			(right_ma == NULL) ? NULL : (right_ma = (vala_code_node_unref (right_ma), NULL));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (vala_assignment_get_right (assignment))) {
				ValaCCodeIdentifier* _tmp47_;
				_tmp47_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("self")));
				(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
			}
		}
		_tmp48_ = FALSE;
		_tmp49_ = FALSE;
		_tmp50_ = FALSE;
		if (!disconnect) {
			_tmp50_ = !VALA_IS_DYNAMIC_SIGNAL (sig);
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			_tmp49_ = target_type_symbol != NULL;
		} else {
			_tmp49_ = FALSE;
		}
		if (_tmp49_) {
			_tmp48_ = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			ValaCCodeConstant* _tmp51_;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp51_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp51_ = vala_ccode_constant_new ("0")));
			(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
		}
	} else {
		ValaCCodeConstant* _tmp52_;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp52_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_constant_new ("NULL")));
		(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	}
	result = (ValaCCodeExpression*) ccall;
	(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL));
	connect_func = (g_free (connect_func), NULL);
	signal_detail = (g_free (signal_detail), NULL);
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
	return result;
}


static void vala_gsignal_module_real_visit_assignment (ValaCCodeModule* base, ValaAssignment* assignment) {
	ValaGSignalModule * self;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_assignment_get_left (assignment)))) {
		gboolean _tmp0_;
		ValaCCodeExpression* _tmp1_;
		vala_code_node_accept ((ValaCodeNode*) vala_assignment_get_right (assignment), (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		_tmp0_ = FALSE;
		if (vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_left (assignment))) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_code_node_get_error ((ValaCodeNode*) vala_assignment_get_right (assignment));
		}
		if (_tmp0_) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		_tmp1_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) assignment, (ValaCCodeNode*) (_tmp1_ = vala_gsignal_module_emit_signal_assignment (self, assignment)));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), assignment);
	}
}


static void vala_gsignal_module_real_visit_member_access (ValaCCodeModule* base, ValaMemberAccess* expr) {
	ValaGSignalModule * self;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr))) {
		ValaCCodeExpression* pub_inst;
		ValaSignal* _tmp2_;
		ValaSignal* sig;
		ValaTypeSymbol* _tmp3_;
		ValaTypeSymbol* cl;
		gboolean _tmp4_;
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
		pub_inst = NULL;
		if (vala_member_access_get_inner (expr) != NULL) {
			ValaCCodeExpression* _tmp1_;
			ValaCCodeExpression* _tmp0_;
			_tmp1_ = NULL;
			_tmp0_ = NULL;
			pub_inst = (_tmp1_ = (_tmp0_ = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (expr))), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_)), (pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL)), _tmp1_);
		}
		_tmp2_ = NULL;
		sig = (_tmp2_ = VALA_SIGNAL (vala_expression_get_symbol_reference ((ValaExpression*) expr)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
		_tmp3_ = NULL;
		cl = (_tmp3_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
		_tmp4_ = FALSE;
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			_tmp4_ = vala_signal_get_is_virtual (sig);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMethod* m;
			ValaClass* _tmp5_;
			ValaClass* base_class;
			ValaCCodeIdentifier* _tmp8_;
			char* _tmp7_;
			char* _tmp6_;
			ValaCCodeFunctionCall* _tmp9_;
			ValaCCodeFunctionCall* vcast;
			ValaCCodeIdentifier* _tmp12_;
			char* _tmp11_;
			char* _tmp10_;
			ValaCCodeMemberAccess* _tmp13_;
			m = vala_signal_get_method_handler (sig);
			_tmp5_ = NULL;
			base_class = (_tmp5_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp9_ = NULL;
			vcast = (_tmp9_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new (_tmp7_ = g_strdup_printf ("%s_CLASS", _tmp6_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) base_class, NULL))))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL)), _tmp7_ = (g_free (_tmp7_), NULL), _tmp6_ = (g_free (_tmp6_), NULL), _tmp9_);
			_tmp12_ = NULL;
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			vala_ccode_function_call_add_argument (vcast, (ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new (_tmp11_ = g_strdup_printf ("%s_parent_class", _tmp10_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) ((ValaCCodeBaseModule*) self)->current_class, NULL)))));
			(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
			_tmp11_ = (g_free (_tmp11_), NULL);
			_tmp10_ = (g_free (_tmp10_), NULL);
			_tmp13_ = NULL;
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) (_tmp13_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) vcast, vala_symbol_get_name ((ValaSymbol*) m))));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
			(vcast == NULL) ? NULL : (vcast = (vala_ccode_node_unref (vcast), NULL));
			(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			return;
		}
		if (vala_signal_get_has_emitter (sig)) {
			ValaCCodeIdentifier* _tmp16_;
			char* _tmp15_;
			char* _tmp14_;
			ValaCCodeFunctionCall* _tmp17_;
			ValaCCodeFunctionCall* ccall;
			_tmp16_ = NULL;
			_tmp15_ = NULL;
			_tmp14_ = NULL;
			_tmp17_ = NULL;
			ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new (_tmp15_ = g_strdup_printf ("%s_%s", _tmp14_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) cl, NULL), vala_symbol_get_name ((ValaSymbol*) sig))))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp15_ = (g_free (_tmp15_), NULL), _tmp14_ = (g_free (_tmp14_), NULL), _tmp17_);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		} else {
			ValaCCodeIdentifier* _tmp18_;
			ValaCCodeFunctionCall* _tmp19_;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeConstant* _tmp20_;
			_tmp18_ = NULL;
			_tmp19_ = NULL;
			ccall = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_signal_emit_by_name"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
			vala_ccode_function_call_add_argument (ccall, pub_inst);
			_tmp20_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp20_ = vala_signal_get_canonical_cconstant (sig, NULL)));
			(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
			vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
		}
		(pub_inst == NULL) ? NULL : (pub_inst = (vala_ccode_node_unref (pub_inst), NULL));
		(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), expr);
	}
}


static void vala_gsignal_module_real_visit_method_call (ValaCCodeModule* base, ValaMethodCall* expr) {
	ValaGSignalModule * self;
	ValaMethodType* _tmp1_;
	ValaDataType* _tmp0_;
	ValaMethodType* method_type;
	gboolean _tmp2_;
	ValaSignal* _tmp3_;
	ValaSignal* sig;
	ValaExpression* _tmp4_;
	ValaExpression* signal_access;
	GeeList* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* handler;
	ValaMethod* _tmp7_;
	ValaMethod* m;
	ValaTypeSymbol* _tmp9_;
	ValaSymbol* _tmp8_;
	ValaTypeSymbol* target_type_symbol;
	char* connect_func;
	gboolean disconnect;
	ValaCCodeIdentifier* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeFunctionCall* ccall;
	char* signal_detail;
	ValaMemberAccess* ma;
	ValaCCodeCastExpression* _tmp50_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	method_type = (_tmp1_ = (_tmp0_ = vala_expression_get_value_type (vala_method_call_get_call (expr)), VALA_IS_METHOD_TYPE (_tmp0_) ? ((ValaMethodType*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = FALSE;
	if (method_type == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !VALA_IS_SIGNAL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_type_get_method_symbol (method_type)));
	}
	if (_tmp2_) {
		/* no signal connect/disconnect call*/
		VALA_CCODE_MODULE_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCCodeModule*) VALA_GOBJECT_MODULE (self), expr);
		(method_type == NULL) ? NULL : (method_type = (vala_code_node_unref (method_type), NULL));
		return;
	}
	_tmp3_ = NULL;
	sig = (_tmp3_ = VALA_SIGNAL (vala_symbol_get_parent_symbol ((ValaSymbol*) vala_method_type_get_method_symbol (method_type))), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_));
	_tmp4_ = NULL;
	signal_access = (_tmp4_ = vala_member_access_get_inner (VALA_MEMBER_ACCESS (vala_method_call_get_call (expr))), (_tmp4_ == NULL) ? NULL : vala_code_node_ref (_tmp4_));
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	handler = (_tmp6_ = (ValaExpression*) gee_list_get (_tmp5_ = vala_method_call_get_argument_list (expr), 0), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL)), _tmp6_);
	vala_code_node_accept ((ValaCodeNode*) signal_access, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	vala_code_node_accept ((ValaCodeNode*) handler, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	_tmp7_ = NULL;
	m = (_tmp7_ = VALA_METHOD (vala_expression_get_symbol_reference (handler)), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
	_tmp9_ = NULL;
	_tmp8_ = NULL;
	target_type_symbol = (_tmp9_ = (_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_TYPESYMBOL (_tmp8_) ? ((ValaTypeSymbol*) _tmp8_) : NULL), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
	connect_func = NULL;
	disconnect = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) vala_method_type_get_method_symbol (method_type)), "disconnect") == 0;
	if (!disconnect) {
		/* connect*/
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp10_;
			_tmp10_ = NULL;
			connect_func = (_tmp10_ = vala_ccode_module_get_dynamic_signal_connect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp10_);
		} else {
			if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
				gboolean _tmp11_;
				_tmp11_ = FALSE;
				if (target_type_symbol != NULL) {
					_tmp11_ = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					char* _tmp12_;
					_tmp12_ = NULL;
					connect_func = (_tmp12_ = g_strdup ("g_signal_connect_object"), connect_func = (g_free (connect_func), NULL), _tmp12_);
				} else {
					char* _tmp13_;
					_tmp13_ = NULL;
					connect_func = (_tmp13_ = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp13_);
				}
			} else {
				char* _tmp14_;
				_tmp14_ = NULL;
				connect_func = (_tmp14_ = g_strdup ("g_signal_connect"), connect_func = (g_free (connect_func), NULL), _tmp14_);
			}
		}
	} else {
		/* disconnect*/
		if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
			char* _tmp15_;
			_tmp15_ = NULL;
			connect_func = (_tmp15_ = vala_ccode_module_get_dynamic_signal_disconnect_wrapper_name (vala_ccode_module_get_head ((ValaCCodeModule*) self), VALA_DYNAMIC_SIGNAL (sig)), connect_func = (g_free (connect_func), NULL), _tmp15_);
		} else {
			char* _tmp16_;
			_tmp16_ = NULL;
			connect_func = (_tmp16_ = g_strdup ("g_signal_handlers_disconnect_matched"), connect_func = (g_free (connect_func), NULL), _tmp16_);
		}
	}
	_tmp17_ = NULL;
	_tmp18_ = NULL;
	ccall = (_tmp18_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_identifier_new (connect_func))), (_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL)), _tmp18_);
	signal_detail = NULL;
	/* first argument: instance of sender*/
	ma = NULL;
	if (VALA_IS_ELEMENT_ACCESS (signal_access)) {
		ValaElementAccess* _tmp19_;
		ValaElementAccess* ea;
		ValaMemberAccess* _tmp21_;
		ValaMemberAccess* _tmp20_;
		GeeList* _tmp22_;
		ValaExpression* _tmp23_;
		ValaStringLiteral* _tmp24_;
		ValaStringLiteral* detail_expr;
		char* _tmp25_;
		_tmp19_ = NULL;
		ea = (_tmp19_ = VALA_ELEMENT_ACCESS (signal_access), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_));
		_tmp21_ = NULL;
		_tmp20_ = NULL;
		ma = (_tmp21_ = (_tmp20_ = VALA_MEMBER_ACCESS (vala_element_access_get_container (ea)), (_tmp20_ == NULL) ? NULL : vala_code_node_ref (_tmp20_)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp21_);
		_tmp22_ = NULL;
		_tmp23_ = NULL;
		_tmp24_ = NULL;
		detail_expr = (_tmp24_ = (_tmp23_ = (ValaExpression*) gee_list_get (_tmp22_ = vala_element_access_get_indices (ea), 0), VALA_IS_STRING_LITERAL (_tmp23_) ? ((ValaStringLiteral*) _tmp23_) : NULL), (_tmp22_ == NULL) ? NULL : (_tmp22_ = (gee_collection_object_unref (_tmp22_), NULL)), _tmp24_);
		if (detail_expr == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) expr, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr), "internal error: only literal string details supported");
			(ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL));
			(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
			(method_type == NULL) ? NULL : (method_type = (vala_code_node_unref (method_type), NULL));
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
			(signal_access == NULL) ? NULL : (signal_access = (vala_code_node_unref (signal_access), NULL));
			(handler == NULL) ? NULL : (handler = (vala_code_node_unref (handler), NULL));
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
			(target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL));
			connect_func = (g_free (connect_func), NULL);
			(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
			signal_detail = (g_free (signal_detail), NULL);
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
			return;
		}
		_tmp25_ = NULL;
		signal_detail = (_tmp25_ = vala_string_literal_eval (detail_expr), signal_detail = (g_free (signal_detail), NULL), _tmp25_);
		(ea == NULL) ? NULL : (ea = (vala_code_node_unref (ea), NULL));
		(detail_expr == NULL) ? NULL : (detail_expr = (vala_code_node_unref (detail_expr), NULL));
	} else {
		ValaMemberAccess* _tmp27_;
		ValaMemberAccess* _tmp26_;
		_tmp27_ = NULL;
		_tmp26_ = NULL;
		ma = (_tmp27_ = (_tmp26_ = VALA_MEMBER_ACCESS (signal_access), (_tmp26_ == NULL) ? NULL : vala_code_node_ref (_tmp26_)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp27_);
	}
	if (vala_member_access_get_inner (ma) != NULL) {
		ValaCCodeExpression* _tmp28_;
		_tmp28_ = NULL;
		vala_ccode_function_call_add_argument (ccall, _tmp28_ = VALA_CCODE_EXPRESSION (vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, (ValaCodeNode*) vala_member_access_get_inner (ma))));
		(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	} else {
		ValaCCodeIdentifier* _tmp29_;
		_tmp29_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp29_ = vala_ccode_identifier_new ("self")));
		(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	}
	if (VALA_IS_DYNAMIC_SIGNAL (sig)) {
		ValaCCodeConstant* _tmp31_;
		char* _tmp30_;
		/* dynamic_signal_connect or dynamic_signal_disconnect
		 second argument: signal name*/
		_tmp31_ = NULL;
		_tmp30_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp31_ = vala_ccode_constant_new (_tmp30_ = g_strdup_printf ("\"%s\"", vala_symbol_get_name ((ValaSymbol*) sig)))));
		(_tmp31_ == NULL) ? NULL : (_tmp31_ = (vala_ccode_node_unref (_tmp31_), NULL));
		_tmp30_ = (g_free (_tmp30_), NULL);
	} else {
		if (!disconnect) {
			ValaCCodeConstant* _tmp32_;
			/* g_signal_connect_object or g_signal_connect
			 second argument: signal name*/
			_tmp32_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp32_ = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
		} else {
			ValaCCodeCommaExpression* ccomma;
			ValaLocalVariable* temp_decl;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* parse_call;
			ValaCCodeConstant* _tmp37_;
			ValaTypeSymbol* _tmp38_;
			ValaTypeSymbol* decl_type;
			ValaCCodeIdentifier* _tmp40_;
			char* _tmp39_;
			ValaCCodeUnaryExpression* _tmp42_;
			ValaCCodeIdentifier* _tmp41_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeIdentifier* _tmp47_;
			ValaCCodeConstant* _tmp48_;
			ValaCCodeConstant* _tmp49_;
			/* g_signal_handlers_disconnect_matched
			 second argument: mask*/
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp33_;
				_tmp33_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp33_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
			} else {
				ValaCCodeConstant* _tmp34_;
				_tmp34_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp34_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA")));
				(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
			}
			/* get signal id*/
			ccomma = vala_ccode_comma_expression_new ();
			temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->uint_type, TRUE, NULL);
			gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, temp_decl);
			_tmp35_ = NULL;
			_tmp36_ = NULL;
			parse_call = (_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp35_ = vala_ccode_identifier_new ("g_signal_parse_name"))), (_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL)), _tmp36_);
			_tmp37_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp37_ = vala_signal_get_canonical_cconstant (sig, signal_detail)));
			(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
			_tmp38_ = NULL;
			decl_type = (_tmp38_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) sig)), (_tmp38_ == NULL) ? NULL : vala_code_node_ref (_tmp38_));
			_tmp40_ = NULL;
			_tmp39_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new (_tmp39_ = vala_typesymbol_get_type_id (decl_type))));
			(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
			_tmp39_ = (g_free (_tmp39_), NULL);
			_tmp42_ = NULL;
			_tmp41_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp42_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))))));
			(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
			(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
			if (signal_detail == NULL) {
				ValaCCodeConstant* _tmp43_;
				_tmp43_ = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp43_ = vala_ccode_constant_new ("NULL")));
				(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
			} else {
				ValaLocalVariable* detail_temp_decl;
				ValaCCodeUnaryExpression* _tmp45_;
				ValaCCodeIdentifier* _tmp44_;
				detail_temp_decl = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->gquark_type, TRUE, NULL);
				gee_list_insert ((GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars, 0, detail_temp_decl);
				_tmp45_ = NULL;
				_tmp44_ = NULL;
				vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp45_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) detail_temp_decl))))));
				(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
				(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
				(detail_temp_decl == NULL) ? NULL : (detail_temp_decl = (vala_code_node_unref (detail_temp_decl), NULL));
			}
			_tmp46_ = NULL;
			vala_ccode_function_call_add_argument (parse_call, (ValaCCodeExpression*) (_tmp46_ = vala_ccode_constant_new ("FALSE")));
			(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) parse_call);
			_tmp47_ = NULL;
			vala_ccode_comma_expression_append_expression (ccomma, (ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) temp_decl))));
			(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
			/* third argument: signal_id*/
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) ccomma);
			/* fourth argument: detail*/
			_tmp48_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp48_ = vala_ccode_constant_new ("0")));
			(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
			/* fifth argument: closure*/
			_tmp49_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp49_ = vala_ccode_constant_new ("NULL")));
			(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
			(ccomma == NULL) ? NULL : (ccomma = (vala_ccode_node_unref (ccomma), NULL));
			(temp_decl == NULL) ? NULL : (temp_decl = (vala_code_node_unref (temp_decl), NULL));
			(parse_call == NULL) ? NULL : (parse_call = (vala_ccode_node_unref (parse_call), NULL));
			(decl_type == NULL) ? NULL : (decl_type = (vala_code_node_unref (decl_type), NULL));
		}
	}
	/* third resp. sixth argument: handler*/
	_tmp50_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp50_ = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) handler)), "GCallback")));
	(_tmp50_ == NULL) ? NULL : (_tmp50_ = (vala_ccode_node_unref (_tmp50_), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		gboolean _tmp54_;
		gboolean _tmp55_;
		gboolean _tmp56_;
		/* g_signal_connect_object or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: object/user_data*/
		if (VALA_IS_MEMBER_ACCESS (handler)) {
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* right_ma;
			_tmp51_ = NULL;
			right_ma = (_tmp51_ = VALA_MEMBER_ACCESS (handler), (_tmp51_ == NULL) ? NULL : vala_code_node_ref (_tmp51_));
			if (vala_member_access_get_inner (right_ma) != NULL) {
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_member_access_get_inner (right_ma))));
			} else {
				ValaCCodeIdentifier* _tmp52_;
				_tmp52_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_identifier_new ("self")));
				(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
			}
			(right_ma == NULL) ? NULL : (right_ma = (vala_code_node_unref (right_ma), NULL));
		} else {
			if (VALA_IS_LAMBDA_EXPRESSION (handler)) {
				ValaCCodeIdentifier* _tmp53_;
				_tmp53_ = NULL;
				vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("self")));
				(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
			}
		}
		_tmp54_ = FALSE;
		_tmp55_ = FALSE;
		_tmp56_ = FALSE;
		if (!disconnect) {
			_tmp56_ = !VALA_IS_DYNAMIC_SIGNAL (sig);
		} else {
			_tmp56_ = FALSE;
		}
		if (_tmp56_) {
			_tmp55_ = target_type_symbol != NULL;
		} else {
			_tmp55_ = FALSE;
		}
		if (_tmp55_) {
			_tmp54_ = vala_typesymbol_is_subtype_of (target_type_symbol, ((ValaCCodeBaseModule*) self)->gobject_type);
		} else {
			_tmp54_ = FALSE;
		}
		if (_tmp54_) {
			ValaCCodeConstant* _tmp57_;
			/* g_signal_connect_object
			 fifth argument: connect_flags*/
			_tmp57_ = NULL;
			vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp57_ = vala_ccode_constant_new ("0")));
			(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
		}
	} else {
		ValaCCodeConstant* _tmp58_;
		/* g_signal_connect or g_signal_handlers_disconnect_matched
		 or dynamic_signal_connect or dynamic_signal_disconnect
		 fourth resp. seventh argument: user_data*/
		_tmp58_ = NULL;
		vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp58_ = vala_ccode_constant_new ("NULL")));
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) expr, (ValaCCodeNode*) ccall);
	(method_type == NULL) ? NULL : (method_type = (vala_code_node_unref (method_type), NULL));
	(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
	(signal_access == NULL) ? NULL : (signal_access = (vala_code_node_unref (signal_access), NULL));
	(handler == NULL) ? NULL : (handler = (vala_code_node_unref (handler), NULL));
	(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
	(target_type_symbol == NULL) ? NULL : (target_type_symbol = (vala_code_node_unref (target_type_symbol), NULL));
	connect_func = (g_free (connect_func), NULL);
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	signal_detail = (g_free (signal_detail), NULL);
	(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
}


static void vala_gsignal_module_class_init (ValaGSignalModuleClass * klass) {
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->get_marshaller_function = vala_gsignal_module_real_get_marshaller_function;
	VALA_CCODE_MODULE_CLASS (klass)->visit_signal = vala_gsignal_module_real_visit_signal;
	VALA_CCODE_MODULE_CLASS (klass)->generate_marshaller = vala_gsignal_module_real_generate_marshaller;
	VALA_CCODE_MODULE_CLASS (klass)->get_signal_creation = vala_gsignal_module_real_get_signal_creation;
	VALA_GSIGNAL_MODULE_CLASS (klass)->get_dbus_g_type = vala_gsignal_module_real_get_dbus_g_type;
	VALA_CCODE_MODULE_CLASS (klass)->visit_element_access = vala_gsignal_module_real_visit_element_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_assignment = vala_gsignal_module_real_visit_assignment;
	VALA_CCODE_MODULE_CLASS (klass)->visit_member_access = vala_gsignal_module_real_visit_member_access;
	VALA_CCODE_MODULE_CLASS (klass)->visit_method_call = vala_gsignal_module_real_visit_method_call;
}


static void vala_gsignal_module_instance_init (ValaGSignalModule * self) {
}


GType vala_gsignal_module_get_type (void) {
	static GType vala_gsignal_module_type_id = 0;
	if (vala_gsignal_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
	}
	return vala_gsignal_module_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




