/* valaclassregisterfunction.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>


#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;
typedef struct _ValaTypeRegisterFunctionPrivate ValaTypeRegisterFunctionPrivate;

#define VALA_TYPE_CLASS_REGISTER_FUNCTION (vala_class_register_function_get_type ())
#define VALA_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunction))
#define VALA_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))
#define VALA_IS_CLASS_REGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_IS_CLASS_REGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS_REGISTER_FUNCTION))
#define VALA_CLASS_REGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionClass))

typedef struct _ValaClassRegisterFunction ValaClassRegisterFunction;
typedef struct _ValaClassRegisterFunctionClass ValaClassRegisterFunctionClass;
typedef struct _ValaClassRegisterFunctionPrivate ValaClassRegisterFunctionPrivate;

/**
 * C function to register a type at runtime.
 */
struct _ValaTypeRegisterFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaTypeRegisterFunctionPrivate * priv;
};

struct _ValaTypeRegisterFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaTypeRegisterFunction *self);
	ValaTypeSymbol* (*get_type_declaration) (ValaTypeRegisterFunction* self);
	char* (*get_type_struct_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_base_finalize_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_class_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_instance_struct_size) (ValaTypeRegisterFunction* self);
	char* (*get_instance_init_func_name) (ValaTypeRegisterFunction* self);
	char* (*get_parent_type_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_init_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_peek_pointer_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_free_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_copy_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_lcopy_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_gtype_value_table_collect_value_function_name) (ValaTypeRegisterFunction* self);
	char* (*get_type_flags) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_declaration) (ValaTypeRegisterFunction* self);
	ValaCCodeFragment* (*get_type_interface_init_statements) (ValaTypeRegisterFunction* self);
	ValaSymbolAccessibility (*get_accessibility) (ValaTypeRegisterFunction* self);
};

/**
 * C function to register a class at runtime.
 */
struct _ValaClassRegisterFunction {
	ValaTypeRegisterFunction parent_instance;
	ValaClassRegisterFunctionPrivate * priv;
};

struct _ValaClassRegisterFunctionClass {
	ValaTypeRegisterFunctionClass parent_class;
};

struct _ValaClassRegisterFunctionPrivate {
	ValaClass* _class_reference;
};


static gpointer vala_class_register_function_parent_class = NULL;

gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_class_register_function_get_type (void);
#define VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS_REGISTER_FUNCTION, ValaClassRegisterFunctionPrivate))
enum  {
	VALA_CLASS_REGISTER_FUNCTION_DUMMY_PROPERTY
};
void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value);
void vala_typeregister_function_set_context (ValaTypeRegisterFunction* self, ValaCodeContext* value);
ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl, ValaCodeContext* context);
ValaClassRegisterFunction* vala_class_register_function_construct (GType object_type, ValaClass* cl, ValaCodeContext* context);
ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self);
static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base);
static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* base);
static char* vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base);
static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base);
static void vala_class_register_function_finalize (ValaTypeRegisterFunction* obj);



/**
 * Creates a new C function to register the specified class at runtime.
 *
 * @param cl a class
 * @return   newly created class register function
 */
ValaClassRegisterFunction* vala_class_register_function_construct (GType object_type, ValaClass* cl, ValaCodeContext* context) {
	ValaClassRegisterFunction* self;
	g_return_val_if_fail (cl != NULL, NULL);
	g_return_val_if_fail (context != NULL, NULL);
	self = (ValaClassRegisterFunction*) g_type_create_instance (object_type);
	vala_class_register_function_set_class_reference (self, cl);
	vala_typeregister_function_set_context ((ValaTypeRegisterFunction*) self, context);
	return self;
}


ValaClassRegisterFunction* vala_class_register_function_new (ValaClass* cl, ValaCodeContext* context) {
	return vala_class_register_function_construct (VALA_TYPE_CLASS_REGISTER_FUNCTION, cl, context);
}


static ValaTypeSymbol* vala_class_register_function_real_get_type_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaTypeSymbol* result;
	ValaTypeSymbol* _tmp0_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = (ValaTypeSymbol*) self->priv->_class_reference, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
	return result;
}


static char* vala_class_register_function_real_get_type_struct_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("%sClass", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_class_reference, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_register_function_real_get_base_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (vala_class_get_class_constructor (self->priv->_class_reference) != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_class_get_has_class_private_fields (self->priv->_class_reference);
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_base_init", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	} else {
		result = g_strdup ("NULL");
		return result;
	}
}


static char* vala_class_register_function_real_get_class_finalize_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	self = (ValaClassRegisterFunction*) base;
	if (vala_class_get_static_destructor (self->priv->_class_reference) != NULL) {
		char* _tmp0_;
		char* _tmp1_;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		result = (_tmp1_ = g_strdup_printf ("%s_class_finalize", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
		return result;
	} else {
		result = g_strdup ("NULL");
		return result;
	}
}


static char* vala_class_register_function_real_get_base_finalize_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (vala_class_get_class_destructor (self->priv->_class_reference) != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_class_get_has_class_private_fields (self->priv->_class_reference);
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_base_finalize", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	} else {
		result = g_strdup ("NULL");
		return result;
	}
}


static char* vala_class_register_function_real_get_class_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("%s_class_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_register_function_real_get_instance_struct_size (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("sizeof (%s)", _tmp0_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self->priv->_class_reference, FALSE)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_register_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("%s_instance_init", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_register_function_real_get_parent_type_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	self = (ValaClassRegisterFunction*) base;
	result = vala_typesymbol_get_type_id ((ValaTypeSymbol*) vala_class_get_base_class (self->priv->_class_reference));
	return result;
}


static char* vala_class_register_function_real_get_type_flags (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	self = (ValaClassRegisterFunction*) base;
	if (vala_class_get_is_abstract (self->priv->_class_reference)) {
		result = g_strdup ("G_TYPE_FLAG_ABSTRACT");
		return result;
	} else {
		result = g_strdup ("0");
		return result;
	}
}


static ValaSymbolAccessibility vala_class_register_function_real_get_accessibility (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaSymbolAccessibility result;
	self = (ValaClassRegisterFunction*) base;
	result = vala_symbol_get_access ((ValaSymbol*) self->priv->_class_reference);
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_init_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_init", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_free_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_free_value", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_copy_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_copy_value", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_peek_pointer", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_collect_value_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_collect_value", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static char* vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	char* result;
	gboolean _tmp0_;
	gboolean is_fundamental;
	self = (ValaClassRegisterFunction*) base;
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self->priv->_class_reference)) {
		_tmp0_ = vala_class_get_base_class (self->priv->_class_reference) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	is_fundamental = _tmp0_;
	if (is_fundamental) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%s_lcopy_value", _tmp1_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, "value_")), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	}
	result = NULL;
	return result;
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* result;
	ValaCCodeFragment* frag;
	self = (ValaClassRegisterFunction*) base;
	frag = vala_ccode_fragment_new ();
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _base_type_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_base_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (self->priv->_class_reference))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaDataType* base_type;
			ValaInterface* _tmp2_;
			ValaInterface* iface;
			char* _tmp3_;
			char* _tmp4_;
			char* iface_info_name;
			ValaCCodeDeclaration* ctypedecl;
			ValaCCodeVariableDeclarator* _tmp9_;
			ValaCCodeConstant* _tmp8_;
			char* _tmp7_;
			char* _tmp6_;
			char* _tmp5_;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (!VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			_tmp2_ = NULL;
			iface = (_tmp2_ = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			iface_info_name = (_tmp4_ = g_strdup_printf ("%s_info", _tmp3_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
			ctypedecl = vala_ccode_declaration_new ("const GInterfaceInfo");
			vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			vala_ccode_declaration_add_declarator (ctypedecl, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new (iface_info_name, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_constant_new (_tmp7_ = g_strdup_printf ("{ (GInterfaceInitFunc) %s_%s_interface_init, (GInterfaceFinalizeFunc) NULL, NULL}", _tmp5_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL), _tmp6_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)))), NULL)));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
			(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
			_tmp7_ = (g_free (_tmp7_), NULL);
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp5_ = (g_free (_tmp5_), NULL);
			vala_ccode_fragment_append (frag, (ValaCCodeNode*) ctypedecl);
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			iface_info_name = (g_free (iface_info_name), NULL);
			(ctypedecl == NULL) ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	result = frag;
	return result;
}


static ValaCCodeFragment* vala_class_register_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* base) {
	ValaClassRegisterFunction * self;
	ValaCCodeFragment* result;
	ValaCCodeFragment* frag;
	self = (ValaClassRegisterFunction*) base;
	frag = vala_ccode_fragment_new ();
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _base_type_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_base_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (self->priv->_class_reference))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaDataType* base_type;
			ValaInterface* _tmp2_;
			ValaInterface* iface;
			char* _tmp3_;
			char* _tmp4_;
			char* iface_info_name;
			ValaCCodeIdentifier* _tmp5_;
			ValaCCodeFunctionCall* _tmp6_;
			ValaCCodeFunctionCall* reg_call;
			ValaCCodeIdentifier* _tmp9_;
			char* _tmp8_;
			char* _tmp7_;
			ValaCCodeIdentifier* _tmp11_;
			char* _tmp10_;
			ValaCCodeIdentifier* _tmp13_;
			char* _tmp12_;
			ValaCCodeExpressionStatement* _tmp14_;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (!VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				continue;
			}
			_tmp2_ = NULL;
			iface = (_tmp2_ = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			iface_info_name = (_tmp4_ = g_strdup_printf ("%s_info", _tmp3_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) iface, NULL)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
			_tmp5_ = NULL;
			_tmp6_ = NULL;
			reg_call = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("g_type_add_interface_static"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
			_tmp9_ = NULL;
			_tmp8_ = NULL;
			_tmp7_ = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new (_tmp8_ = g_strdup_printf ("%s_type_id", _tmp7_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self->priv->_class_reference, NULL)))));
			(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
			_tmp8_ = (g_free (_tmp8_), NULL);
			_tmp7_ = (g_free (_tmp7_), NULL);
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp11_ = vala_ccode_identifier_new (_tmp10_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) iface))));
			(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
			_tmp10_ = (g_free (_tmp10_), NULL);
			_tmp13_ = NULL;
			_tmp12_ = NULL;
			vala_ccode_function_call_add_argument (reg_call, (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new (_tmp12_ = g_strdup_printf ("&%s", iface_info_name))));
			(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
			_tmp12_ = (g_free (_tmp12_), NULL);
			_tmp14_ = NULL;
			vala_ccode_fragment_append (frag, (ValaCCodeNode*) (_tmp14_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) reg_call)));
			(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
			iface_info_name = (g_free (iface_info_name), NULL);
			(reg_call == NULL) ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	result = frag;
	return result;
}


ValaClass* vala_class_register_function_get_class_reference (ValaClassRegisterFunction* self) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_reference;
	return result;
}


void vala_class_register_function_set_class_reference (ValaClassRegisterFunction* self, ValaClass* value) {
	g_return_if_fail (self != NULL);
	self->priv->_class_reference = value;
}


static void vala_class_register_function_class_init (ValaClassRegisterFunctionClass * klass) {
	vala_class_register_function_parent_class = g_type_class_peek_parent (klass);
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->finalize = vala_class_register_function_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassRegisterFunctionPrivate));
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_class_register_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_class_register_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_class_register_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_finalize_func_name = vala_class_register_function_real_get_class_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_finalize_func_name = vala_class_register_function_real_get_base_finalize_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_class_register_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_class_register_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_class_register_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_class_register_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_class_register_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_class_register_function_real_get_accessibility;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_init_function_name = vala_class_register_function_real_get_gtype_value_table_init_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_free_function_name = vala_class_register_function_real_get_gtype_value_table_free_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_copy_function_name = vala_class_register_function_real_get_gtype_value_table_copy_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_peek_pointer_function_name = vala_class_register_function_real_get_gtype_value_table_peek_pointer_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_collect_value_function_name = vala_class_register_function_real_get_gtype_value_table_collect_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_gtype_value_table_lcopy_value_function_name = vala_class_register_function_real_get_gtype_value_table_lcopy_value_function_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_class_register_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_class_register_function_real_get_type_interface_init_statements;
}


static void vala_class_register_function_instance_init (ValaClassRegisterFunction * self) {
	self->priv = VALA_CLASS_REGISTER_FUNCTION_GET_PRIVATE (self);
}


static void vala_class_register_function_finalize (ValaTypeRegisterFunction* obj) {
	ValaClassRegisterFunction * self;
	self = VALA_CLASS_REGISTER_FUNCTION (obj);
	VALA_TYPEREGISTER_FUNCTION_CLASS (vala_class_register_function_parent_class)->finalize (obj);
}


GType vala_class_register_function_get_type (void) {
	static GType vala_class_register_function_type_id = 0;
	if (vala_class_register_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_register_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClassRegisterFunction), 0, (GInstanceInitFunc) vala_class_register_function_instance_init, NULL };
		vala_class_register_function_type_id = g_type_register_static (VALA_TYPE_TYPEREGISTER_FUNCTION, "ValaClassRegisterFunction", &g_define_type_info, 0);
	}
	return vala_class_register_function_type_id;
}




