/* valagasyncmodule.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <valaccode.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CCODE_MODULE (vala_ccode_module_get_type ())
#define VALA_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModule))
#define VALA_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))
#define VALA_IS_CCODE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MODULE))
#define VALA_IS_CCODE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MODULE))
#define VALA_CCODE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MODULE, ValaCCodeModuleClass))

typedef struct _ValaCCodeModule ValaCCodeModule;
typedef struct _ValaCCodeModuleClass ValaCCodeModuleClass;
typedef struct _ValaCCodeModulePrivate ValaCCodeModulePrivate;

#define VALA_TYPE_CCODE_BASE_MODULE (vala_ccode_base_module_get_type ())
#define VALA_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModule))
#define VALA_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))
#define VALA_IS_CCODE_BASE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_IS_CCODE_BASE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_BASE_MODULE))
#define VALA_CCODE_BASE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_BASE_MODULE, ValaCCodeBaseModuleClass))

typedef struct _ValaCCodeBaseModule ValaCCodeBaseModule;
typedef struct _ValaCCodeBaseModuleClass ValaCCodeBaseModuleClass;
typedef struct _ValaCCodeBaseModulePrivate ValaCCodeBaseModulePrivate;

#define VALA_TYPE_CCODE_DECLARATION_SPACE (vala_ccode_declaration_space_get_type ())
#define VALA_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpace))
#define VALA_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))
#define VALA_IS_CCODE_DECLARATION_SPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_IS_CCODE_DECLARATION_SPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DECLARATION_SPACE))
#define VALA_CCODE_DECLARATION_SPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DECLARATION_SPACE, ValaCCodeDeclarationSpaceClass))

typedef struct _ValaCCodeDeclarationSpace ValaCCodeDeclarationSpace;
typedef struct _ValaCCodeDeclarationSpaceClass ValaCCodeDeclarationSpaceClass;

#define VALA_TYPE_CCODE_STRUCT_MODULE (vala_ccode_struct_module_get_type ())
#define VALA_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModule))
#define VALA_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))
#define VALA_IS_CCODE_STRUCT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_IS_CCODE_STRUCT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_STRUCT_MODULE))
#define VALA_CCODE_STRUCT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_STRUCT_MODULE, ValaCCodeStructModuleClass))

typedef struct _ValaCCodeStructModule ValaCCodeStructModule;
typedef struct _ValaCCodeStructModuleClass ValaCCodeStructModuleClass;
typedef struct _ValaCCodeStructModulePrivate ValaCCodeStructModulePrivate;

#define VALA_TYPE_CCODE_METHOD_MODULE (vala_ccode_method_module_get_type ())
#define VALA_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModule))
#define VALA_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))
#define VALA_IS_CCODE_METHOD_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_IS_CCODE_METHOD_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_MODULE))
#define VALA_CCODE_METHOD_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_MODULE, ValaCCodeMethodModuleClass))

typedef struct _ValaCCodeMethodModule ValaCCodeMethodModule;
typedef struct _ValaCCodeMethodModuleClass ValaCCodeMethodModuleClass;
typedef struct _ValaCCodeMethodModulePrivate ValaCCodeMethodModulePrivate;

#define VALA_TYPE_CCODE_CONTROL_FLOW_MODULE (vala_ccode_control_flow_module_get_type ())
#define VALA_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModule))
#define VALA_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_IS_CCODE_CONTROL_FLOW_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE))
#define VALA_CCODE_CONTROL_FLOW_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_CONTROL_FLOW_MODULE, ValaCCodeControlFlowModuleClass))

typedef struct _ValaCCodeControlFlowModule ValaCCodeControlFlowModule;
typedef struct _ValaCCodeControlFlowModuleClass ValaCCodeControlFlowModuleClass;
typedef struct _ValaCCodeControlFlowModulePrivate ValaCCodeControlFlowModulePrivate;

#define VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE (vala_ccode_member_access_module_get_type ())
#define VALA_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModule))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_IS_CCODE_MEMBER_ACCESS_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE))
#define VALA_CCODE_MEMBER_ACCESS_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_MEMBER_ACCESS_MODULE, ValaCCodeMemberAccessModuleClass))

typedef struct _ValaCCodeMemberAccessModule ValaCCodeMemberAccessModule;
typedef struct _ValaCCodeMemberAccessModuleClass ValaCCodeMemberAccessModuleClass;
typedef struct _ValaCCodeMemberAccessModulePrivate ValaCCodeMemberAccessModulePrivate;

#define VALA_TYPE_CCODE_ASSIGNMENT_MODULE (vala_ccode_assignment_module_get_type ())
#define VALA_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModule))
#define VALA_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_IS_CCODE_ASSIGNMENT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ASSIGNMENT_MODULE))
#define VALA_CCODE_ASSIGNMENT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ASSIGNMENT_MODULE, ValaCCodeAssignmentModuleClass))

typedef struct _ValaCCodeAssignmentModule ValaCCodeAssignmentModule;
typedef struct _ValaCCodeAssignmentModuleClass ValaCCodeAssignmentModuleClass;
typedef struct _ValaCCodeAssignmentModulePrivate ValaCCodeAssignmentModulePrivate;

#define VALA_TYPE_CCODE_METHOD_CALL_MODULE (vala_ccode_method_call_module_get_type ())
#define VALA_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModule))
#define VALA_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))
#define VALA_IS_CCODE_METHOD_CALL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_IS_CCODE_METHOD_CALL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_METHOD_CALL_MODULE))
#define VALA_CCODE_METHOD_CALL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_METHOD_CALL_MODULE, ValaCCodeMethodCallModuleClass))

typedef struct _ValaCCodeMethodCallModule ValaCCodeMethodCallModule;
typedef struct _ValaCCodeMethodCallModuleClass ValaCCodeMethodCallModuleClass;
typedef struct _ValaCCodeMethodCallModulePrivate ValaCCodeMethodCallModulePrivate;

#define VALA_TYPE_CCODE_ARRAY_MODULE (vala_ccode_array_module_get_type ())
#define VALA_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModule))
#define VALA_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))
#define VALA_IS_CCODE_ARRAY_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_IS_CCODE_ARRAY_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_ARRAY_MODULE))
#define VALA_CCODE_ARRAY_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_ARRAY_MODULE, ValaCCodeArrayModuleClass))

typedef struct _ValaCCodeArrayModule ValaCCodeArrayModule;
typedef struct _ValaCCodeArrayModuleClass ValaCCodeArrayModuleClass;
typedef struct _ValaCCodeArrayModulePrivate ValaCCodeArrayModulePrivate;

#define VALA_TYPE_CCODE_DELEGATE_MODULE (vala_ccode_delegate_module_get_type ())
#define VALA_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule))
#define VALA_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))
#define VALA_IS_CCODE_DELEGATE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_IS_CCODE_DELEGATE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_DELEGATE_MODULE))
#define VALA_CCODE_DELEGATE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModuleClass))

typedef struct _ValaCCodeDelegateModule ValaCCodeDelegateModule;
typedef struct _ValaCCodeDelegateModuleClass ValaCCodeDelegateModuleClass;
typedef struct _ValaCCodeDelegateModulePrivate ValaCCodeDelegateModulePrivate;

#define VALA_TYPE_GERROR_MODULE (vala_gerror_module_get_type ())
#define VALA_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModule))
#define VALA_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))
#define VALA_IS_GERROR_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GERROR_MODULE))
#define VALA_IS_GERROR_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GERROR_MODULE))
#define VALA_GERROR_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GERROR_MODULE, ValaGErrorModuleClass))

typedef struct _ValaGErrorModule ValaGErrorModule;
typedef struct _ValaGErrorModuleClass ValaGErrorModuleClass;
typedef struct _ValaGErrorModulePrivate ValaGErrorModulePrivate;

#define VALA_TYPE_GTYPE_MODULE (vala_gtype_module_get_type ())
#define VALA_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModule))
#define VALA_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))
#define VALA_IS_GTYPE_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GTYPE_MODULE))
#define VALA_IS_GTYPE_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GTYPE_MODULE))
#define VALA_GTYPE_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GTYPE_MODULE, ValaGTypeModuleClass))

typedef struct _ValaGTypeModule ValaGTypeModule;
typedef struct _ValaGTypeModuleClass ValaGTypeModuleClass;
typedef struct _ValaGTypeModulePrivate ValaGTypeModulePrivate;

#define VALA_TYPE_TYPEREGISTER_FUNCTION (vala_typeregister_function_get_type ())
#define VALA_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunction))
#define VALA_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))
#define VALA_IS_TYPEREGISTER_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_IS_TYPEREGISTER_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEREGISTER_FUNCTION))
#define VALA_TYPEREGISTER_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionClass))

typedef struct _ValaTypeRegisterFunction ValaTypeRegisterFunction;
typedef struct _ValaTypeRegisterFunctionClass ValaTypeRegisterFunctionClass;

#define VALA_TYPE_GOBJECT_MODULE (vala_gobject_module_get_type ())
#define VALA_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule))
#define VALA_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))
#define VALA_IS_GOBJECT_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GOBJECT_MODULE))
#define VALA_IS_GOBJECT_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GOBJECT_MODULE))
#define VALA_GOBJECT_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GOBJECT_MODULE, ValaGObjectModuleClass))

typedef struct _ValaGObjectModule ValaGObjectModule;
typedef struct _ValaGObjectModuleClass ValaGObjectModuleClass;
typedef struct _ValaGObjectModulePrivate ValaGObjectModulePrivate;

#define VALA_TYPE_GSIGNAL_MODULE (vala_gsignal_module_get_type ())
#define VALA_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModule))
#define VALA_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))
#define VALA_IS_GSIGNAL_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_IS_GSIGNAL_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GSIGNAL_MODULE))
#define VALA_GSIGNAL_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GSIGNAL_MODULE, ValaGSignalModuleClass))

typedef struct _ValaGSignalModule ValaGSignalModule;
typedef struct _ValaGSignalModuleClass ValaGSignalModuleClass;
typedef struct _ValaGSignalModulePrivate ValaGSignalModulePrivate;

#define VALA_TYPE_GASYNC_MODULE (vala_gasync_module_get_type ())
#define VALA_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModule))
#define VALA_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))
#define VALA_IS_GASYNC_MODULE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GASYNC_MODULE))
#define VALA_IS_GASYNC_MODULE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GASYNC_MODULE))
#define VALA_GASYNC_MODULE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GASYNC_MODULE, ValaGAsyncModuleClass))

typedef struct _ValaGAsyncModule ValaGAsyncModule;
typedef struct _ValaGAsyncModuleClass ValaGAsyncModuleClass;
typedef struct _ValaGAsyncModulePrivate ValaGAsyncModulePrivate;

#define VALA_TYPE_CCODE_GENERATOR (vala_ccode_generator_get_type ())
#define VALA_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGenerator))
#define VALA_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))
#define VALA_IS_CCODE_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CCODE_GENERATOR))
#define VALA_IS_CCODE_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CCODE_GENERATOR))
#define VALA_CCODE_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CCODE_GENERATOR, ValaCCodeGeneratorClass))

typedef struct _ValaCCodeGenerator ValaCCodeGenerator;
typedef struct _ValaCCodeGeneratorClass ValaCCodeGeneratorClass;

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeModule {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCCodeModulePrivate * priv;
};

struct _ValaCCodeModuleClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCCodeModule *self);
	void (*emit) (ValaCCodeModule* self, ValaCodeContext* context);
	void (*visit_source_file) (ValaCCodeModule* self, ValaSourceFile* source_file);
	void (*visit_class) (ValaCCodeModule* self, ValaClass* cl);
	void (*visit_interface) (ValaCCodeModule* self, ValaInterface* iface);
	void (*visit_struct) (ValaCCodeModule* self, ValaStruct* st);
	void (*visit_enum) (ValaCCodeModule* self, ValaEnum* en);
	void (*visit_error_domain) (ValaCCodeModule* self, ValaErrorDomain* edomain);
	void (*visit_delegate) (ValaCCodeModule* self, ValaDelegate* d);
	void (*visit_member) (ValaCCodeModule* self, ValaMember* m);
	void (*visit_constant) (ValaCCodeModule* self, ValaConstant* c);
	void (*visit_field) (ValaCCodeModule* self, ValaField* f);
	void (*visit_method) (ValaCCodeModule* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCCodeModule* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCCodeModule* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCCodeModule* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCCodeModule* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCCodeModule* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCCodeModule* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCCodeModule* self, ValaDestructor* d);
	void (*visit_block) (ValaCCodeModule* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCCodeModule* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCCodeModule* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCCodeModule* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCCodeModule* self, ValaInitializerList* list);
	void (*visit_end_full_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_expression_statement) (ValaCCodeModule* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCCodeModule* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCCodeModule* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCCodeModule* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCCodeModule* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCCodeModule* self, ValaLoop* stmt);
	void (*visit_foreach_statement) (ValaCCodeModule* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCCodeModule* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCCodeModule* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCCodeModule* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCCodeModule* self, ValaYieldStatement* stmt);
	void (*visit_throw_statement) (ValaCCodeModule* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCCodeModule* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCCodeModule* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCCodeModule* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCCodeModule* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCCodeModule* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCCodeModule* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCCodeModule* self, ValaBooleanLiteral* expr);
	void (*visit_character_literal) (ValaCCodeModule* self, ValaCharacterLiteral* expr);
	void (*visit_integer_literal) (ValaCCodeModule* self, ValaIntegerLiteral* expr);
	void (*visit_real_literal) (ValaCCodeModule* self, ValaRealLiteral* expr);
	void (*visit_string_literal) (ValaCCodeModule* self, ValaStringLiteral* expr);
	void (*visit_null_literal) (ValaCCodeModule* self, ValaNullLiteral* expr);
	void (*visit_member_access) (ValaCCodeModule* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCCodeModule* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCCodeModule* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCCodeModule* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCCodeModule* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCCodeModule* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCCodeModule* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCCodeModule* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCCodeModule* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCCodeModule* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCCodeModule* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCCodeModule* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCCodeModule* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCCodeModule* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCCodeModule* self, ValaTypeCheck* expr);
	void (*visit_lambda_expression) (ValaCCodeModule* self, ValaLambdaExpression* l);
	void (*visit_assignment) (ValaCCodeModule* self, ValaAssignment* a);
	char* (*get_custom_creturn_type) (ValaCCodeModule* self, ValaMethod* m);
	void (*generate_dynamic_method_wrapper) (ValaCCodeModule* self, ValaDynamicMethod* method);
	gboolean (*method_has_wrapper) (ValaCCodeModule* self, ValaMethod* method);
	ValaCCodeIdentifier* (*get_value_setter_function) (ValaCCodeModule* self, ValaDataType* type_reference);
	ValaCCodeExpression* (*get_construct_property_assignment) (ValaCCodeModule* self, ValaCCodeConstant* canonical_cconstant, ValaDataType* property_type, ValaCCodeExpression* value);
	ValaCCodeFunctionCall* (*get_param_spec) (ValaCCodeModule* self, ValaProperty* prop);
	ValaCCodeFunctionCall* (*get_signal_creation) (ValaCCodeModule* self, ValaSignal* sig, ValaTypeSymbol* type);
	ValaCCodeFragment* (*register_dbus_info) (ValaCCodeModule* self, ValaObjectTypeSymbol* bindable);
	char* (*get_dynamic_property_getter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_property_setter_cname) (ValaCCodeModule* self, ValaDynamicProperty* node);
	char* (*get_dynamic_signal_cname) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_connect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	char* (*get_dynamic_signal_disconnect_wrapper_name) (ValaCCodeModule* self, ValaDynamicSignal* node);
	void (*generate_marshaller) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, gboolean dbus);
	char* (*get_marshaller_function) (ValaCCodeModule* self, GeeList* params, ValaDataType* return_type, const char* prefix, gboolean dbus);
	char* (*get_array_length_cname) (ValaCCodeModule* self, const char* array_cname, gint dim);
	ValaCCodeExpression* (*get_array_length_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr, gint dim);
	char* (*get_array_size_cname) (ValaCCodeModule* self, const char* array_cname);
	ValaCCodeExpression* (*get_array_size_cexpression) (ValaCCodeModule* self, ValaExpression* array_expr);
	void (*add_simple_check) (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
};

/**
 * Code visitor generating C Code.
 */
struct _ValaCCodeBaseModule {
	ValaCCodeModule parent_instance;
	ValaCCodeBaseModulePrivate * priv;
	ValaSymbol* root_symbol;
	ValaSymbol* current_symbol;
	ValaTypeSymbol* current_type_symbol;
	ValaClass* current_class;
	ValaMethod* current_method;
	ValaDataType* current_return_type;
	ValaTryStatement* current_try;
	ValaPropertyAccessor* current_property_accessor;
	ValaCCodeDeclarationSpace* header_declarations;
	ValaCCodeDeclarationSpace* internal_header_declarations;
	ValaCCodeDeclarationSpace* source_declarations;
	ValaCCodeFragment* source_signal_marshaller_declaration;
	ValaCCodeFragment* source_type_member_definition;
	ValaCCodeFragment* class_init_fragment;
	ValaCCodeFragment* base_init_fragment;
	ValaCCodeFragment* class_finalize_fragment;
	ValaCCodeFragment* base_finalize_fragment;
	ValaCCodeFragment* instance_init_fragment;
	ValaCCodeFragment* instance_finalize_fragment;
	ValaCCodeFragment* source_signal_marshaller_definition;
	ValaCCodeFragment* module_init_fragment;
	ValaCCodeStruct* param_spec_struct;
	ValaCCodeStruct* closure_struct;
	ValaCCodeEnum* prop_enum;
	ValaCCodeFunction* function;
	ValaCCodeFragment* pre_statement_fragment;
	GeeArrayList* temp_vars;
	GeeArrayList* temp_ref_vars;
	GeeSet* user_marshal_set;
	GeeSet* predefined_marshal_set;
	gint next_temp_var_id;
	gboolean in_creation_method;
	gboolean in_constructor;
	gboolean in_static_or_class_ctor;
	gboolean current_method_inner_error;
	gint next_coroutine_state;
	ValaDataType* bool_type;
	ValaDataType* char_type;
	ValaDataType* uchar_type;
	ValaDataType* unichar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* int8_type;
	ValaDataType* uint8_type;
	ValaDataType* int16_type;
	ValaDataType* uint16_type;
	ValaDataType* int32_type;
	ValaDataType* uint32_type;
	ValaDataType* int64_type;
	ValaDataType* uint64_type;
	ValaDataType* string_type;
	ValaDataType* float_type;
	ValaDataType* double_type;
	ValaTypeSymbol* gtype_type;
	ValaTypeSymbol* gobject_type;
	ValaErrorType* gerror_type;
	ValaClass* glist_type;
	ValaClass* gslist_type;
	ValaClass* gvaluearray_type;
	ValaTypeSymbol* gstringbuilder_type;
	ValaTypeSymbol* garray_type;
	ValaTypeSymbol* gbytearray_type;
	ValaTypeSymbol* gptrarray_type;
	ValaDataType* gquark_type;
	ValaStruct* gvalue_type;
	ValaStruct* mutex_type;
	ValaTypeSymbol* type_module_type;
	ValaTypeSymbol* dbus_object_type;
	gboolean in_plugin;
	char* module_init_param_name;
	gboolean gvaluecollector_h_needed;
	gboolean requires_array_free;
	gboolean requires_array_move;
	gboolean requires_array_length;
	gboolean requires_strcmp0;
	gboolean dbus_glib_h_needed;
	gboolean dbus_glib_h_needed_in_header;
	GeeSet* wrappers;
	GeeMap* variable_name_map;
};

struct _ValaCCodeBaseModuleClass {
	ValaCCodeModuleClass parent_class;
	void (*append_vala_array_free) (ValaCCodeBaseModule* self);
	void (*append_vala_array_move) (ValaCCodeBaseModule* self);
	void (*append_vala_array_length) (ValaCCodeBaseModule* self);
	void (*generate_class_struct_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_struct_declaration) (ValaCCodeBaseModule* self, ValaStruct* st, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_delegate_declaration) (ValaCCodeBaseModule* self, ValaDelegate* d, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_cparameters) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
	ValaCCodeExpression* (*get_dup_func_expression) (ValaCCodeBaseModule* self, ValaDataType* type, ValaSourceReference* source_reference, gboolean is_chainup);
	char* (*append_struct_array_free) (ValaCCodeBaseModule* self, ValaStruct* st);
	ValaCCodeExpression* (*get_unref_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
	void (*append_local_free) (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
	gboolean (*variable_accessible_in_finally) (ValaCCodeBaseModule* self, ValaLocalVariable* local);
	char* (*get_delegate_target_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_delegate_target_cexpression) (ValaCCodeBaseModule* self, ValaExpression* delegate_expr);
	char* (*get_delegate_target_destroy_notify_cname) (ValaCCodeBaseModule* self, const char* delegate_cname);
	ValaCCodeExpression* (*get_ref_cexpression) (ValaCCodeBaseModule* self, ValaDataType* expression_type, ValaCCodeExpression* cexpr, ValaExpression* expr, ValaCodeNode* node);
	void (*generate_class_declaration) (ValaCCodeBaseModule* self, ValaClass* cl, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_interface_declaration) (ValaCCodeBaseModule* self, ValaInterface* iface, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_method_declaration) (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space);
	void (*generate_error_domain_declaration) (ValaCCodeBaseModule* self, ValaErrorDomain* edomain, ValaCCodeDeclarationSpace* decl_space);
	ValaCCodeExpression* (*get_implicit_cast_expression) (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
	gboolean (*is_gobject_property) (ValaCCodeBaseModule* self, ValaProperty* prop);
};

struct _ValaCCodeStructModule {
	ValaCCodeBaseModule parent_instance;
	ValaCCodeStructModulePrivate * priv;
};

struct _ValaCCodeStructModuleClass {
	ValaCCodeBaseModuleClass parent_class;
};

/**
 * The link between a method and generated code.
 */
struct _ValaCCodeMethodModule {
	ValaCCodeStructModule parent_instance;
	ValaCCodeMethodModulePrivate * priv;
};

struct _ValaCCodeMethodModuleClass {
	ValaCCodeStructModuleClass parent_class;
	void (*generate_method_result_declaration) (ValaCCodeMethodModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeFunction* cfunc, GeeMap* cparam_map, GeeMap* carg_map);
	void (*generate_parameter) (ValaCCodeMethodModule* self, ValaFormalParameter* param, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, GeeMap* carg_map);
};

struct _ValaCCodeControlFlowModule {
	ValaCCodeMethodModule parent_instance;
	ValaCCodeControlFlowModulePrivate * priv;
};

struct _ValaCCodeControlFlowModuleClass {
	ValaCCodeMethodModuleClass parent_class;
};

struct _ValaCCodeMemberAccessModule {
	ValaCCodeControlFlowModule parent_instance;
	ValaCCodeMemberAccessModulePrivate * priv;
};

struct _ValaCCodeMemberAccessModuleClass {
	ValaCCodeControlFlowModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeAssignmentModule {
	ValaCCodeMemberAccessModule parent_instance;
	ValaCCodeAssignmentModulePrivate * priv;
};

struct _ValaCCodeAssignmentModuleClass {
	ValaCCodeMemberAccessModuleClass parent_class;
};

struct _ValaCCodeMethodCallModule {
	ValaCCodeAssignmentModule parent_instance;
	ValaCCodeMethodCallModulePrivate * priv;
};

struct _ValaCCodeMethodCallModuleClass {
	ValaCCodeAssignmentModuleClass parent_class;
};

struct _ValaCCodeArrayModule {
	ValaCCodeMethodCallModule parent_instance;
	ValaCCodeArrayModulePrivate * priv;
};

struct _ValaCCodeArrayModuleClass {
	ValaCCodeMethodCallModuleClass parent_class;
};

/**
 * The link between an assignment and generated code.
 */
struct _ValaCCodeDelegateModule {
	ValaCCodeArrayModule parent_instance;
	ValaCCodeDelegateModulePrivate * priv;
};

struct _ValaCCodeDelegateModuleClass {
	ValaCCodeArrayModuleClass parent_class;
};

struct _ValaGErrorModule {
	ValaCCodeDelegateModule parent_instance;
	ValaGErrorModulePrivate * priv;
};

struct _ValaGErrorModuleClass {
	ValaCCodeDelegateModuleClass parent_class;
	ValaCCodeStatement* (*return_with_exception) (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
};

struct _ValaGTypeModule {
	ValaGErrorModule parent_instance;
	ValaGTypeModulePrivate * priv;
};

struct _ValaGTypeModuleClass {
	ValaGErrorModuleClass parent_class;
	void (*generate_virtual_method_declaration) (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
	void (*generate_class_init) (ValaGTypeModule* self, ValaClass* cl, ValaCCodeBlock* init_block);
	ValaTypeRegisterFunction* (*create_interface_register_function) (ValaGTypeModule* self, ValaInterface* iface);
};

struct _ValaGObjectModule {
	ValaGTypeModule parent_instance;
	ValaGObjectModulePrivate * priv;
};

struct _ValaGObjectModuleClass {
	ValaGTypeModuleClass parent_class;
};

struct _ValaGSignalModule {
	ValaGObjectModule parent_instance;
	ValaGSignalModulePrivate * priv;
};

struct _ValaGSignalModuleClass {
	ValaGObjectModuleClass parent_class;
	ValaCCodeExpression* (*get_dbus_g_type) (ValaGSignalModule* self, ValaDataType* data_type);
};

struct _ValaGAsyncModule {
	ValaGSignalModule parent_instance;
	ValaGAsyncModulePrivate * priv;
};

struct _ValaGAsyncModuleClass {
	ValaGSignalModuleClass parent_class;
};


static gpointer vala_gasync_module_parent_class = NULL;

gpointer vala_ccode_module_ref (gpointer instance);
void vala_ccode_module_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_module (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_module (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_module (const GValue* value);
GType vala_ccode_module_get_type (void);
GType vala_ccode_base_module_get_type (void);
gpointer vala_ccode_declaration_space_ref (gpointer instance);
void vala_ccode_declaration_space_unref (gpointer instance);
GParamSpec* vala_param_spec_ccode_declaration_space (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_ccode_declaration_space (GValue* value, gpointer v_object);
gpointer vala_value_get_ccode_declaration_space (const GValue* value);
GType vala_ccode_declaration_space_get_type (void);
GType vala_ccode_struct_module_get_type (void);
GType vala_ccode_method_module_get_type (void);
GType vala_ccode_control_flow_module_get_type (void);
GType vala_ccode_member_access_module_get_type (void);
GType vala_ccode_assignment_module_get_type (void);
GType vala_ccode_method_call_module_get_type (void);
GType vala_ccode_array_module_get_type (void);
GType vala_ccode_delegate_module_get_type (void);
GType vala_gerror_module_get_type (void);
GType vala_gtype_module_get_type (void);
gpointer vala_typeregister_function_ref (gpointer instance);
void vala_typeregister_function_unref (gpointer instance);
GParamSpec* vala_param_spec_typeregister_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_typeregister_function (GValue* value, gpointer v_object);
gpointer vala_value_get_typeregister_function (const GValue* value);
GType vala_typeregister_function_get_type (void);
GType vala_gobject_module_get_type (void);
GType vala_gsignal_module_get_type (void);
GType vala_gasync_module_get_type (void);
enum  {
	VALA_GASYNC_MODULE_DUMMY_PROPERTY
};
GType vala_ccode_generator_get_type (void);
ValaGSignalModule* vala_gsignal_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGSignalModule* vala_gsignal_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next);
ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next);
char* vala_ccode_base_module_get_variable_cname (ValaCCodeBaseModule* self, const char* name);
static ValaCCodeStruct* vala_gasync_module_generate_data_struct (ValaGAsyncModule* self, ValaMethod* m);
gboolean vala_ccode_base_module_requires_destroy (ValaCCodeBaseModule* self, ValaDataType* type);
ValaCCodeExpression* vala_ccode_base_module_get_unref_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* cvar, ValaDataType* type, ValaExpression* expr);
static ValaCCodeFunction* vala_gasync_module_generate_free_function (ValaGAsyncModule* self, ValaMethod* m);
ValaCCodeExpression* vala_ccode_base_module_transform_expression (ValaCCodeBaseModule* self, ValaCCodeExpression* source_cexpr, ValaDataType* expression_type, ValaDataType* target_type, ValaExpression* expr);
gint vala_ccode_base_module_get_param_pos (ValaCCodeBaseModule* self, double param_pos, gboolean ellipsis);
void vala_ccode_base_module_generate_cparameters (ValaCCodeBaseModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, GeeMap* cparam_map, ValaCCodeFunction* func, ValaCCodeFunctionDeclarator* vdeclarator, GeeMap* carg_map, ValaCCodeFunctionCall* vcall, gint direction);
static ValaCCodeFunction* vala_gasync_module_generate_async_function (ValaGAsyncModule* self, ValaMethod* m);
void vala_ccode_declaration_space_add_type_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
void vala_ccode_declaration_space_add_type_definition (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_gasync_module_append_struct (ValaGAsyncModule* self, ValaCCodeStruct* structure);
void vala_ccode_declaration_space_add_type_member_declaration (ValaCCodeDeclarationSpace* self, ValaCCodeNode* node);
static void vala_gasync_module_append_function (ValaGAsyncModule* self, ValaCCodeFunction* function);
void vala_ccode_declaration_space_add_include (ValaCCodeDeclarationSpace* self, const char* filename, gboolean local);
void vala_ccode_module_visit_method (ValaCCodeModule* self, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_finish_function (ValaGAsyncModule* self, ValaMethod* m);
static ValaCCodeFunction* vala_gasync_module_generate_ready_function (ValaGAsyncModule* self, ValaMethod* m);
static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m);
void vala_gtype_module_generate_virtual_method_declaration (ValaGTypeModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
static void vala_gasync_module_append_async_virtual_function (ValaGAsyncModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
static void vala_gasync_module_append_finish_virtual_function (ValaGAsyncModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
static void vala_gasync_module_real_generate_virtual_method_declaration (ValaGTypeModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct);
void vala_ccode_method_module_generate_vfunc (ValaCCodeMethodModule* self, ValaMethod* m, ValaDataType* return_type, GeeMap* cparam_map, GeeMap* carg_map, const char* suffix, gint direction);
ValaCCodeGenerator* vala_ccode_module_get_codegen (ValaCCodeModule* self);
ValaCCodeModule* vala_ccode_module_get_head (ValaCCodeModule* self);
void vala_ccode_module_add_simple_check (ValaCCodeModule* self, ValaCodeNode* node, ValaCCodeFragment* cfrag);
void vala_ccode_base_module_append_temp_decl (ValaCCodeBaseModule* self, ValaCCodeFragment* cfrag, GeeList* temp_vars);
static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt);
ValaCCodeStatement* vala_gerror_module_return_with_exception (ValaGErrorModule* self, ValaCCodeExpression* error_expr);
void vala_ccode_base_module_append_local_free (ValaCCodeBaseModule* self, ValaSymbol* sym, ValaCCodeFragment* cfrag, gboolean stop_at_loop);
ValaCCodeStatement* vala_ccode_method_module_complete_async (ValaCCodeMethodModule* self);
static ValaCCodeStatement* vala_gasync_module_real_return_with_exception (ValaGErrorModule* base, ValaCCodeExpression* error_expr);
void vala_ccode_module_visit_return_statement (ValaCCodeModule* self, ValaReturnStatement* stmt);
void vala_ccode_base_module_create_temp_decl (ValaCCodeBaseModule* self, ValaStatement* stmt, GeeList* temp_vars);
static void vala_gasync_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt);



ValaGAsyncModule* vala_gasync_module_construct (GType object_type, ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	ValaGAsyncModule* self;
	g_return_val_if_fail (codegen != NULL, NULL);
	self = (ValaGAsyncModule*) vala_gsignal_module_construct (object_type, codegen, next);
	return self;
}


ValaGAsyncModule* vala_gasync_module_new (ValaCCodeGenerator* codegen, ValaCCodeModule* next) {
	return vala_gasync_module_construct (VALA_TYPE_GASYNC_MODULE, codegen, next);
}


static ValaCCodeStruct* vala_gasync_module_generate_data_struct (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeStruct* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* dataname;
	char* _tmp3_;
	ValaCCodeStruct* _tmp4_;
	ValaCCodeStruct* data;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	dataname = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_lower_case_to_camel_case (_tmp0_ = vala_method_get_cname (m)), "Data", NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp3_ = NULL;
	_tmp4_ = NULL;
	data = (_tmp4_ = vala_ccode_struct_new (_tmp3_ = g_strconcat ("_", dataname, NULL)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
	vala_ccode_struct_add_field (data, "int", "state");
	vala_ccode_struct_add_field (data, "GAsyncResult*", "res");
	vala_ccode_struct_add_field (data, "GSimpleAsyncResult*", "_async_result");
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaTypeSymbol* _tmp5_;
		ValaTypeSymbol* type_sym;
		char* _tmp7_;
		char* _tmp6_;
		_tmp5_ = NULL;
		type_sym = (_tmp5_ = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) m)), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_));
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		vala_ccode_struct_add_field (data, _tmp7_ = g_strconcat (_tmp6_ = vala_typesymbol_get_cname (type_sym, FALSE), "*", NULL), "self");
		_tmp7_ = (g_free (_tmp7_), NULL);
		_tmp6_ = (g_free (_tmp6_), NULL);
		(type_sym == NULL) ? NULL : (type_sym = (vala_code_node_unref (type_sym), NULL));
	}
	{
		GeeList* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _param_it;
		_tmp8_ = NULL;
		_tmp9_ = NULL;
		_param_it = (_tmp9_ = gee_iterable_iterator ((GeeIterable*) (_tmp8_ = vala_method_get_parameters (m))), (_tmp8_ == NULL) ? NULL : (_tmp8_ = (gee_collection_object_unref (_tmp8_), NULL)), _tmp9_);
		while (TRUE) {
			ValaFormalParameter* param;
			char* _tmp11_;
			char* _tmp10_;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			_tmp11_ = NULL;
			_tmp10_ = NULL;
			vala_ccode_struct_add_field (data, _tmp10_ = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)), _tmp11_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)));
			_tmp11_ = (g_free (_tmp11_), NULL);
			_tmp10_ = (g_free (_tmp10_), NULL);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		char* _tmp12_;
		_tmp12_ = NULL;
		vala_ccode_struct_add_field (data, _tmp12_ = vala_data_type_get_cname (vala_method_get_return_type (m)), "result");
		_tmp12_ = (g_free (_tmp12_), NULL);
	}
	result = data;
	dataname = (g_free (dataname), NULL);
	return result;
}


static ValaCCodeFunction* vala_gasync_module_generate_free_function (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeFunction* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* dataname;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* freefunc;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeBlock* freeblock;
	char* _tmp7_;
	ValaCCodeDeclaration* _tmp8_;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp10_;
	ValaCCodeIdentifier* _tmp9_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFunctionCall* _tmp19_;
	ValaCCodeFunctionCall* freecall;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeExpressionStatement* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	dataname = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_lower_case_to_camel_case (_tmp0_ = vala_method_get_cname (m)), "Data", NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	freefunc = (_tmp5_ = vala_ccode_function_new (_tmp4_ = g_strconcat (_tmp3_ = vala_method_get_real_cname (m), "_data_free", NULL), "void"), _tmp4_ = (g_free (_tmp4_), NULL), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
	vala_ccode_function_set_modifiers (freefunc, VALA_CCODE_MODIFIERS_STATIC);
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (freefunc, _tmp6_ = vala_ccode_formal_parameter_new ("_data", "gpointer"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	freeblock = vala_ccode_block_new ();
	vala_ccode_function_set_block (freefunc, freeblock);
	_tmp7_ = NULL;
	_tmp8_ = NULL;
	datadecl = (_tmp8_ = vala_ccode_declaration_new (_tmp7_ = g_strconcat (dataname, "*", NULL)), _tmp7_ = (g_free (_tmp7_), NULL), _tmp8_);
	_tmp10_ = NULL;
	_tmp9_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp10_ = vala_ccode_variable_declarator_new ("data", (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("_data")), NULL)));
	(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
	(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
	vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) datadecl);
	if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, vala_method_get_return_type (m))) {
		ValaLocalVariable* v;
		ValaMemberAccess* ma;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp11_;
		ValaCCodeMemberAccess* _tmp14_;
		ValaCCodeIdentifier* _tmp13_;
		ValaCCodeExpression* _tmp15_;
		ValaCCodeExpression* unref_expr;
		ValaCCodeExpressionStatement* _tmp16_;
		ValaMethod* _tmp17_;
		/* this is very evil. */
		v = vala_local_variable_new (vala_method_get_return_type (m), "result", NULL, NULL);
		ma = vala_member_access_new_simple ("result", NULL);
		vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) v);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		((ValaCCodeBaseModule*) self)->current_method = (_tmp12_ = (_tmp11_ = m, (_tmp11_ == NULL) ? NULL : vala_code_node_ref (_tmp11_)), (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp12_);
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		_tmp15_ = NULL;
		unref_expr = (_tmp15_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp14_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("data")), "result")), vala_method_get_return_type (m), (ValaExpression*) ma), (_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL)), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp15_);
		_tmp16_ = NULL;
		vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) (_tmp16_ = vala_ccode_expression_statement_new (unref_expr)));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		_tmp17_ = NULL;
		((ValaCCodeBaseModule*) self)->current_method = (_tmp17_ = NULL, (((ValaCCodeBaseModule*) self)->current_method == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->current_method = (vala_code_node_unref (((ValaCCodeBaseModule*) self)->current_method), NULL)), _tmp17_);
		(v == NULL) ? NULL : (v = (vala_code_node_unref (v), NULL));
		(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		(unref_expr == NULL) ? NULL : (unref_expr = (vala_ccode_node_unref (unref_expr), NULL));
	}
	_tmp18_ = NULL;
	_tmp19_ = NULL;
	freecall = (_tmp19_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("g_slice_free"))), (_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL)), _tmp19_);
	_tmp20_ = NULL;
	vala_ccode_function_call_add_argument (freecall, (ValaCCodeExpression*) (_tmp20_ = vala_ccode_identifier_new (dataname)));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	_tmp21_ = NULL;
	vala_ccode_function_call_add_argument (freecall, (ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("data")));
	(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
	_tmp22_ = NULL;
	vala_ccode_block_add_statement (freeblock, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) freecall)));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	result = freefunc;
	dataname = (g_free (dataname), NULL);
	(freeblock == NULL) ? NULL : (freeblock = (vala_ccode_node_unref (freeblock), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(freecall == NULL) ? NULL : (freecall = (vala_ccode_node_unref (freecall), NULL));
	return result;
}


static ValaCCodeFunction* vala_gasync_module_generate_async_function (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeFunction* result;
	ValaCCodeBlock* asyncblock;
	gboolean _tmp0_;
	char* _tmp16_;
	char* _tmp15_;
	char* _tmp17_;
	char* dataname;
	char* _tmp19_;
	char* _tmp18_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* asyncfunc;
	GeeHashMap* cparam_map;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* dataalloc;
	ValaCCodeIdentifier* _tmp23_;
	char* _tmp24_;
	ValaCCodeDeclaration* _tmp25_;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp26_;
	ValaCCodeExpressionStatement* _tmp29_;
	ValaCCodeAssignment* _tmp28_;
	ValaCCodeIdentifier* _tmp27_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeFunctionCall* create_result;
	ValaClass* _tmp33_;
	ValaSymbol* _tmp32_;
	ValaClass* cl;
	gboolean _tmp34_;
	gboolean _tmp35_;
	ValaCCodeIdentifier* _tmp40_;
	ValaCCodeIdentifier* _tmp41_;
	ValaCCodeIdentifier* _tmp44_;
	char* _tmp43_;
	char* _tmp42_;
	ValaCCodeExpressionStatement* _tmp48_;
	ValaCCodeAssignment* _tmp47_;
	ValaCCodeMemberAccess* _tmp46_;
	ValaCCodeIdentifier* _tmp45_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeFunctionCall* set_op_res_call;
	ValaCCodeMemberAccess* _tmp52_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp53_;
	ValaCCodeIdentifier* _tmp56_;
	char* _tmp55_;
	char* _tmp54_;
	ValaCCodeExpressionStatement* _tmp57_;
	ValaCCodeIdentifier* _tmp74_;
	char* _tmp73_;
	char* _tmp72_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp76_;
	ValaCCodeExpressionStatement* _tmp77_;
	ValaCCodeFormalParameter* _tmp78_;
	ValaCCodeFormalParameter* _tmp79_;
	gboolean _tmp80_;
	gboolean _tmp81_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	asyncblock = vala_ccode_block_new ();
	_tmp0_ = FALSE;
	if (vala_method_get_overrides (m)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = FALSE;
		_tmp2_ = FALSE;
		if (vala_method_get_base_interface_method (m) != NULL) {
			_tmp2_ = !vala_method_get_is_abstract (m);
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = !vala_method_get_is_virtual (m);
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	/* logic copied from valaccodemethodmodule*/
	if (_tmp0_) {
		ValaMethod* base_method;
		ValaObjectType* base_expression_type;
		ValaObjectTypeSymbol* _tmp8_;
		ValaSymbol* _tmp7_;
		ValaObjectTypeSymbol* type_symbol;
		ValaObjectType* self_target_type;
		ValaCCodeIdentifier* _tmp9_;
		ValaCCodeExpression* _tmp10_;
		ValaCCodeExpression* cself;
		char* _tmp12_;
		char* _tmp11_;
		ValaCCodeDeclaration* _tmp13_;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp14_;
		base_method = NULL;
		if (vala_method_get_overrides (m)) {
			ValaMethod* _tmp4_;
			ValaMethod* _tmp3_;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			base_method = (_tmp4_ = (_tmp3_ = vala_method_get_base_method (m), (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp4_);
		} else {
			ValaMethod* _tmp6_;
			ValaMethod* _tmp5_;
			_tmp6_ = NULL;
			_tmp5_ = NULL;
			base_method = (_tmp6_ = (_tmp5_ = vala_method_get_base_interface_method (m), (_tmp5_ == NULL) ? NULL : vala_code_node_ref (_tmp5_)), (base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)), _tmp6_);
		}
		base_expression_type = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) base_method)));
		_tmp8_ = NULL;
		_tmp7_ = NULL;
		type_symbol = (_tmp8_ = (_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7_) ? ((ValaObjectTypeSymbol*) _tmp7_) : NULL), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
		self_target_type = vala_object_type_new (type_symbol);
		_tmp9_ = NULL;
		_tmp10_ = NULL;
		cself = (_tmp10_ = vala_ccode_base_module_transform_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp9_ = vala_ccode_identifier_new ("base")), (ValaDataType*) base_expression_type, (ValaDataType*) self_target_type, NULL), (_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL)), _tmp10_);
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp13_ = NULL;
		_cdecl_ = (_tmp13_ = vala_ccode_declaration_new (_tmp12_ = g_strdup_printf ("%s *", _tmp11_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) type_symbol, FALSE))), _tmp12_ = (g_free (_tmp12_), NULL), _tmp11_ = (g_free (_tmp11_), NULL), _tmp13_);
		_tmp14_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp14_ = vala_ccode_variable_declarator_new ("self", cself, NULL)));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) _cdecl_);
		(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
		(base_expression_type == NULL) ? NULL : (base_expression_type = (vala_code_node_unref (base_expression_type), NULL));
		(type_symbol == NULL) ? NULL : (type_symbol = (vala_code_node_unref (type_symbol), NULL));
		(self_target_type == NULL) ? NULL : (self_target_type = (vala_code_node_unref (self_target_type), NULL));
		(cself == NULL) ? NULL : (cself = (vala_ccode_node_unref (cself), NULL));
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	}
	_tmp16_ = NULL;
	_tmp15_ = NULL;
	_tmp17_ = NULL;
	dataname = (_tmp17_ = g_strconcat (_tmp16_ = vala_symbol_lower_case_to_camel_case (_tmp15_ = vala_method_get_cname (m)), "Data", NULL), _tmp16_ = (g_free (_tmp16_), NULL), _tmp15_ = (g_free (_tmp15_), NULL), _tmp17_);
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp20_ = NULL;
	asyncfunc = (_tmp20_ = vala_ccode_function_new (_tmp19_ = g_strconcat (_tmp18_ = vala_method_get_real_cname (m), "_async", NULL), "void"), _tmp19_ = (g_free (_tmp19_), NULL), _tmp18_ = (g_free (_tmp18_), NULL), _tmp20_);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp21_ = NULL;
	_tmp22_ = NULL;
	dataalloc = (_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp21_ = vala_ccode_identifier_new ("g_slice_new0"))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL)), _tmp22_);
	_tmp23_ = NULL;
	vala_ccode_function_call_add_argument (dataalloc, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (dataname)));
	(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
	_tmp24_ = NULL;
	_tmp25_ = NULL;
	datadecl = (_tmp25_ = vala_ccode_declaration_new (_tmp24_ = g_strconcat (dataname, "*", NULL)), _tmp24_ = (g_free (_tmp24_), NULL), _tmp25_);
	_tmp26_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp26_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) datadecl);
	_tmp29_ = NULL;
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp27_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) dataalloc, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
	(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	_tmp30_ = NULL;
	_tmp31_ = NULL;
	create_result = (_tmp31_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("g_simple_async_result_new"))), (_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL)), _tmp31_);
	_tmp33_ = NULL;
	_tmp32_ = NULL;
	cl = (_tmp33_ = (_tmp32_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m), VALA_IS_CLASS (_tmp32_) ? ((ValaClass*) _tmp32_) : NULL), (_tmp33_ == NULL) ? NULL : vala_code_node_ref (_tmp33_));
	_tmp34_ = FALSE;
	_tmp35_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp35_ = cl != NULL;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) cl, ((ValaCCodeBaseModule*) self)->gobject_type);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		ValaCCodeIdentifier* _tmp36_;
		ValaCCodeFunctionCall* _tmp37_;
		ValaCCodeFunctionCall* gobject_cast;
		ValaCCodeIdentifier* _tmp38_;
		_tmp36_ = NULL;
		_tmp37_ = NULL;
		gobject_cast = (_tmp37_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("G_OBJECT"))), (_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL)), _tmp37_);
		_tmp38_ = NULL;
		vala_ccode_function_call_add_argument (gobject_cast, (ValaCCodeExpression*) (_tmp38_ = vala_ccode_identifier_new ("self")));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) gobject_cast);
		(gobject_cast == NULL) ? NULL : (gobject_cast = (vala_ccode_node_unref (gobject_cast), NULL));
	} else {
		ValaCCodeConstant* _tmp39_;
		_tmp39_ = NULL;
		vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp39_ = vala_ccode_constant_new ("NULL")));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
	}
	_tmp40_ = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp40_ = vala_ccode_identifier_new ("callback")));
	(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
	_tmp41_ = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp41_ = vala_ccode_identifier_new ("user_data")));
	(_tmp41_ == NULL) ? NULL : (_tmp41_ = (vala_ccode_node_unref (_tmp41_), NULL));
	_tmp44_ = NULL;
	_tmp43_ = NULL;
	_tmp42_ = NULL;
	vala_ccode_function_call_add_argument (create_result, (ValaCCodeExpression*) (_tmp44_ = vala_ccode_identifier_new (_tmp43_ = g_strconcat (_tmp42_ = vala_method_get_real_cname (m), "_async", NULL))));
	(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
	_tmp43_ = (g_free (_tmp43_), NULL);
	_tmp42_ = (g_free (_tmp42_), NULL);
	_tmp48_ = NULL;
	_tmp47_ = NULL;
	_tmp46_ = NULL;
	_tmp45_ = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp48_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp47_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp46_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_identifier_new ("data")), "_async_result")), (ValaCCodeExpression*) create_result, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
	(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
	(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
	_tmp49_ = NULL;
	_tmp50_ = NULL;
	set_op_res_call = (_tmp50_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp49_ = vala_ccode_identifier_new ("g_simple_async_result_set_op_res_gpointer"))), (_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL)), _tmp50_);
	_tmp52_ = NULL;
	_tmp51_ = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp52_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp51_ = vala_ccode_identifier_new ("data")), "_async_result")));
	(_tmp52_ == NULL) ? NULL : (_tmp52_ = (vala_ccode_node_unref (_tmp52_), NULL));
	(_tmp51_ == NULL) ? NULL : (_tmp51_ = (vala_ccode_node_unref (_tmp51_), NULL));
	_tmp53_ = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp53_ = vala_ccode_identifier_new ("data")));
	(_tmp53_ == NULL) ? NULL : (_tmp53_ = (vala_ccode_node_unref (_tmp53_), NULL));
	_tmp56_ = NULL;
	_tmp55_ = NULL;
	_tmp54_ = NULL;
	vala_ccode_function_call_add_argument (set_op_res_call, (ValaCCodeExpression*) (_tmp56_ = vala_ccode_identifier_new (_tmp55_ = g_strconcat (_tmp54_ = vala_method_get_real_cname (m), "_data_free", NULL))));
	(_tmp56_ == NULL) ? NULL : (_tmp56_ = (vala_ccode_node_unref (_tmp56_), NULL));
	_tmp55_ = (g_free (_tmp55_), NULL);
	_tmp54_ = (g_free (_tmp54_), NULL);
	_tmp57_ = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp57_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_op_res_call)));
	(_tmp57_ == NULL) ? NULL : (_tmp57_ = (vala_ccode_node_unref (_tmp57_), NULL));
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		ValaCCodeExpressionStatement* _tmp62_;
		ValaCCodeAssignment* _tmp61_;
		ValaCCodeIdentifier* _tmp60_;
		ValaCCodeMemberAccess* _tmp59_;
		ValaCCodeIdentifier* _tmp58_;
		_tmp62_ = NULL;
		_tmp61_ = NULL;
		_tmp60_ = NULL;
		_tmp59_ = NULL;
		_tmp58_ = NULL;
		vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp62_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp61_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp59_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp58_ = vala_ccode_identifier_new ("data")), "self")), (ValaCCodeExpression*) (_tmp60_ = vala_ccode_identifier_new ("self")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp62_ == NULL) ? NULL : (_tmp62_ = (vala_ccode_node_unref (_tmp62_), NULL));
		(_tmp61_ == NULL) ? NULL : (_tmp61_ = (vala_ccode_node_unref (_tmp61_), NULL));
		(_tmp60_ == NULL) ? NULL : (_tmp60_ = (vala_ccode_node_unref (_tmp60_), NULL));
		(_tmp59_ == NULL) ? NULL : (_tmp59_ = (vala_ccode_node_unref (_tmp59_), NULL));
		(_tmp58_ == NULL) ? NULL : (_tmp58_ = (vala_ccode_node_unref (_tmp58_), NULL));
	}
	{
		GeeList* _tmp63_;
		GeeIterator* _tmp64_;
		GeeIterator* _param_it;
		_tmp63_ = NULL;
		_tmp64_ = NULL;
		_param_it = (_tmp64_ = gee_iterable_iterator ((GeeIterable*) (_tmp63_ = vala_method_get_parameters (m))), (_tmp63_ == NULL) ? NULL : (_tmp63_ = (gee_collection_object_unref (_tmp63_), NULL)), _tmp64_);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_OUT) {
				ValaCCodeExpressionStatement* _tmp71_;
				ValaCCodeAssignment* _tmp70_;
				ValaCCodeIdentifier* _tmp69_;
				char* _tmp68_;
				ValaCCodeMemberAccess* _tmp67_;
				char* _tmp66_;
				ValaCCodeIdentifier* _tmp65_;
				_tmp71_ = NULL;
				_tmp70_ = NULL;
				_tmp69_ = NULL;
				_tmp68_ = NULL;
				_tmp67_ = NULL;
				_tmp66_ = NULL;
				_tmp65_ = NULL;
				vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp71_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp70_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp67_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp65_ = vala_ccode_identifier_new ("data")), _tmp66_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), (ValaCCodeExpression*) (_tmp69_ = vala_ccode_identifier_new (_tmp68_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp71_ == NULL) ? NULL : (_tmp71_ = (vala_ccode_node_unref (_tmp71_), NULL));
				(_tmp70_ == NULL) ? NULL : (_tmp70_ = (vala_ccode_node_unref (_tmp70_), NULL));
				(_tmp69_ == NULL) ? NULL : (_tmp69_ = (vala_ccode_node_unref (_tmp69_), NULL));
				_tmp68_ = (g_free (_tmp68_), NULL);
				(_tmp67_ == NULL) ? NULL : (_tmp67_ = (vala_ccode_node_unref (_tmp67_), NULL));
				_tmp66_ = (g_free (_tmp66_), NULL);
				(_tmp65_ == NULL) ? NULL : (_tmp65_ = (vala_ccode_node_unref (_tmp65_), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	_tmp74_ = NULL;
	_tmp73_ = NULL;
	_tmp72_ = NULL;
	_tmp75_ = NULL;
	ccall = (_tmp75_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp74_ = vala_ccode_identifier_new (_tmp73_ = g_strconcat (_tmp72_ = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp74_ == NULL) ? NULL : (_tmp74_ = (vala_ccode_node_unref (_tmp74_), NULL)), _tmp73_ = (g_free (_tmp73_), NULL), _tmp72_ = (g_free (_tmp72_), NULL), _tmp75_);
	_tmp76_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp76_ = vala_ccode_identifier_new ("data")));
	(_tmp76_ == NULL) ? NULL : (_tmp76_ = (vala_ccode_node_unref (_tmp76_), NULL));
	_tmp77_ = NULL;
	vala_ccode_block_add_statement (asyncblock, (ValaCCodeNode*) (_tmp77_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp77_ == NULL) ? NULL : (_tmp77_ = (vala_ccode_node_unref (_tmp77_), NULL));
	_tmp78_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp78_ = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp78_ == NULL) ? NULL : (_tmp78_ = (vala_ccode_node_unref (_tmp78_), NULL));
	_tmp79_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp79_ = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp79_ == NULL) ? NULL : (_tmp79_ = (vala_ccode_node_unref (_tmp79_), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, asyncfunc, NULL, NULL, NULL, 1);
	_tmp80_ = FALSE;
	_tmp81_ = FALSE;
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		_tmp81_ = vala_method_get_base_method (m) == NULL;
	} else {
		_tmp81_ = FALSE;
	}
	if (_tmp81_) {
		_tmp80_ = vala_method_get_base_interface_method (m) == NULL;
	} else {
		_tmp80_ = FALSE;
	}
	if (_tmp80_) {
		vala_ccode_function_set_modifiers (asyncfunc, vala_ccode_function_get_modifiers (asyncfunc) | VALA_CCODE_MODIFIERS_STATIC);
	}
	vala_ccode_function_set_block (asyncfunc, asyncblock);
	result = asyncfunc;
	(asyncblock == NULL) ? NULL : (asyncblock = (vala_ccode_node_unref (asyncblock), NULL));
	dataname = (g_free (dataname), NULL);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(dataalloc == NULL) ? NULL : (dataalloc = (vala_ccode_node_unref (dataalloc), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(create_result == NULL) ? NULL : (create_result = (vala_ccode_node_unref (create_result), NULL));
	(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
	(set_op_res_call == NULL) ? NULL : (set_op_res_call = (vala_ccode_node_unref (set_op_res_call), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void vala_gasync_module_append_struct (ValaGAsyncModule* self, ValaCCodeStruct* structure) {
	char* _tmp0_;
	ValaCCodeVariableDeclarator* _tmp1_;
	ValaCCodeVariableDeclarator* typename;
	char* _tmp2_;
	ValaCCodeTypeDefinition* _tmp3_;
	ValaCCodeTypeDefinition* _typedef_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (structure != NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	typename = (_tmp1_ = vala_ccode_variable_declarator_new (_tmp0_ = string_substring (vala_ccode_struct_get_name (structure), (glong) 1, -1), NULL, NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	_typedef_ = (_tmp3_ = vala_ccode_type_definition_new (_tmp2_ = g_strconcat ("struct ", vala_ccode_struct_get_name (structure), NULL), (ValaCCodeDeclarator*) typename), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	vala_ccode_declaration_space_add_type_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) _typedef_);
	vala_ccode_declaration_space_add_type_definition (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) structure);
	(typename == NULL) ? NULL : (typename = (vala_ccode_node_unref (typename), NULL));
	(_typedef_ == NULL) ? NULL : (_typedef_ = (vala_ccode_node_unref (_typedef_), NULL));
}


static void vala_gasync_module_append_function (ValaGAsyncModule* self, ValaCCodeFunction* function) {
	ValaCCodeBlock* _tmp0_;
	ValaCCodeBlock* block;
	ValaCCodeFunction* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (function != NULL);
	_tmp0_ = NULL;
	block = (_tmp0_ = vala_ccode_function_get_block (function), (_tmp0_ == NULL) ? NULL : vala_ccode_node_ref (_tmp0_));
	vala_ccode_function_set_block (function, NULL);
	_tmp1_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp1_ = vala_ccode_function_copy (function)));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (((ValaCCodeBaseModule*) self)->source_type_member_definition, (ValaCCodeNode*) function);
	(block == NULL) ? NULL : (block = (vala_ccode_node_unref (block), NULL));
}


static void vala_gasync_module_real_visit_method (ValaCCodeModule* base, ValaMethod* m) {
	ValaGAsyncModule * self;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (m != NULL);
	if (vala_method_get_coroutine (m)) {
		vala_ccode_declaration_space_add_include (((ValaCCodeBaseModule*) self)->source_declarations, "gio/gio.h", FALSE);
		/* append the synchronous version*/
		vala_method_set_coroutine (m, FALSE);
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
		vala_method_set_coroutine (m, TRUE);
		if (!vala_method_get_is_abstract (m)) {
			ValaCCodeStruct* data;
			ValaCCodeFunction* _tmp0_;
			ValaCCodeFunction* _tmp1_;
			ValaCCodeFunction* _tmp2_;
			ValaCCodeFunction* _tmp3_;
			ValaCCodeStruct* _tmp5_;
			ValaCCodeStruct* _tmp4_;
			ValaCCodeStruct* _tmp6_;
			data = vala_gasync_module_generate_data_struct (self, m);
			vala_gasync_module_append_struct (self, data);
			_tmp0_ = NULL;
			vala_gasync_module_append_function (self, _tmp0_ = vala_gasync_module_generate_free_function (self, m));
			(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
			_tmp1_ = NULL;
			vala_gasync_module_append_function (self, _tmp1_ = vala_gasync_module_generate_async_function (self, m));
			(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
			_tmp2_ = NULL;
			vala_gasync_module_append_function (self, _tmp2_ = vala_gasync_module_generate_finish_function (self, m));
			(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
			_tmp3_ = NULL;
			vala_gasync_module_append_function (self, _tmp3_ = vala_gasync_module_generate_ready_function (self, m));
			(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
			/* append the _co function*/
			_tmp5_ = NULL;
			_tmp4_ = NULL;
			((ValaCCodeBaseModule*) self)->closure_struct = (_tmp5_ = (_tmp4_ = data, (_tmp4_ == NULL) ? NULL : vala_ccode_node_ref (_tmp4_)), (((ValaCCodeBaseModule*) self)->closure_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->closure_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->closure_struct), NULL)), _tmp5_);
			VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
			_tmp6_ = NULL;
			((ValaCCodeBaseModule*) self)->closure_struct = (_tmp6_ = NULL, (((ValaCCodeBaseModule*) self)->closure_struct == NULL) ? NULL : (((ValaCCodeBaseModule*) self)->closure_struct = (vala_ccode_node_unref (((ValaCCodeBaseModule*) self)->closure_struct), NULL)), _tmp6_);
			(data == NULL) ? NULL : (data = (vala_ccode_node_unref (data), NULL));
		}
	} else {
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_method ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), m);
	}
}


static ValaCCodeFunction* vala_gasync_module_generate_finish_function (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeFunction* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* dataname;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* finishfunc;
	GeeHashMap* cparam_map;
	ValaCCodeBlock* finishblock;
	ValaDataType* _tmp6_;
	ValaDataType* return_type;
	char* _tmp10_;
	ValaCCodeDeclaration* _tmp11_;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp12_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeFunctionCall* _tmp14_;
	ValaCCodeFunctionCall* simple_async_result_cast;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeFunctionCall* _tmp17_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp20_;
	ValaCCodeAssignment* _tmp19_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeFormalParameter* _tmp49_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	dataname = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_lower_case_to_camel_case (_tmp0_ = vala_method_get_cname (m)), "Data", NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	finishfunc = (_tmp5_ = vala_ccode_function_new (_tmp4_ = g_strconcat (_tmp3_ = vala_method_get_real_cname (m), "_finish", NULL), "void"), _tmp4_ = (g_free (_tmp4_), NULL), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	finishblock = vala_ccode_block_new ();
	_tmp6_ = NULL;
	return_type = (_tmp6_ = vala_method_get_return_type (m), (_tmp6_ == NULL) ? NULL : vala_code_node_ref (_tmp6_));
	if (!VALA_IS_VOID_TYPE (return_type)) {
		char* _tmp7_;
		ValaCCodeDeclaration* _tmp8_;
		ValaCCodeDeclaration* _cdecl_;
		ValaCCodeVariableDeclarator* _tmp9_;
		_tmp7_ = NULL;
		_tmp8_ = NULL;
		_cdecl_ = (_tmp8_ = vala_ccode_declaration_new (_tmp7_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp7_ = (g_free (_tmp7_), NULL), _tmp8_);
		_tmp9_ = NULL;
		vala_ccode_declaration_add_declarator (_cdecl_, (ValaCCodeDeclarator*) (_tmp9_ = vala_ccode_variable_declarator_new ("result", NULL, NULL)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) _cdecl_);
		(_cdecl_ == NULL) ? NULL : (_cdecl_ = (vala_ccode_node_unref (_cdecl_), NULL));
	}
	_tmp10_ = NULL;
	_tmp11_ = NULL;
	datadecl = (_tmp11_ = vala_ccode_declaration_new (_tmp10_ = g_strconcat (dataname, "*", NULL)), _tmp10_ = (g_free (_tmp10_), NULL), _tmp11_);
	_tmp12_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp12_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) datadecl);
	_tmp13_ = NULL;
	_tmp14_ = NULL;
	simple_async_result_cast = (_tmp14_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("G_SIMPLE_ASYNC_RESULT"))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL)), _tmp14_);
	_tmp15_ = NULL;
	vala_ccode_function_call_add_argument (simple_async_result_cast, (ValaCCodeExpression*) (_tmp15_ = vala_ccode_identifier_new ("res")));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	_tmp16_ = NULL;
	_tmp17_ = NULL;
	ccall = (_tmp17_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("g_simple_async_result_get_op_res_gpointer"))), (_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL)), _tmp17_);
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) simple_async_result_cast);
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp20_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) ccall, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	{
		GeeList* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _param_it;
		_tmp21_ = NULL;
		_tmp22_ = NULL;
		_param_it = (_tmp22_ = gee_iterable_iterator ((GeeIterable*) (_tmp21_ = vala_method_get_parameters (m))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (gee_collection_object_unref (_tmp21_), NULL)), _tmp22_);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
				ValaCCodeExpressionStatement* _tmp29_;
				ValaCCodeAssignment* _tmp28_;
				ValaCCodeMemberAccess* _tmp27_;
				char* _tmp26_;
				ValaCCodeIdentifier* _tmp25_;
				ValaCCodeUnaryExpression* _tmp24_;
				ValaCCodeIdentifier* _tmp23_;
				ValaCCodeExpressionStatement* _tmp35_;
				ValaCCodeAssignment* _tmp34_;
				ValaCCodeConstant* _tmp33_;
				ValaCCodeMemberAccess* _tmp32_;
				char* _tmp31_;
				ValaCCodeIdentifier* _tmp30_;
				_tmp29_ = NULL;
				_tmp28_ = NULL;
				_tmp27_ = NULL;
				_tmp26_ = NULL;
				_tmp25_ = NULL;
				_tmp24_ = NULL;
				_tmp23_ = NULL;
				vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp29_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp28_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp24_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) param))))), (ValaCCodeExpression*) (_tmp27_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("data")), _tmp26_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp29_ == NULL) ? NULL : (_tmp29_ = (vala_ccode_node_unref (_tmp29_), NULL));
				(_tmp28_ == NULL) ? NULL : (_tmp28_ = (vala_ccode_node_unref (_tmp28_), NULL));
				(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
				_tmp26_ = (g_free (_tmp26_), NULL);
				(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
				(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
				(_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL));
				_tmp35_ = NULL;
				_tmp34_ = NULL;
				_tmp33_ = NULL;
				_tmp32_ = NULL;
				_tmp31_ = NULL;
				_tmp30_ = NULL;
				vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp35_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp34_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp32_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp30_ = vala_ccode_identifier_new ("data")), _tmp31_ = vala_ccode_base_module_get_variable_cname ((ValaCCodeBaseModule*) self, vala_symbol_get_name ((ValaSymbol*) param)))), (ValaCCodeExpression*) (_tmp33_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
				(_tmp35_ == NULL) ? NULL : (_tmp35_ = (vala_ccode_node_unref (_tmp35_), NULL));
				(_tmp34_ == NULL) ? NULL : (_tmp34_ = (vala_ccode_node_unref (_tmp34_), NULL));
				(_tmp33_ == NULL) ? NULL : (_tmp33_ = (vala_ccode_node_unref (_tmp33_), NULL));
				(_tmp32_ == NULL) ? NULL : (_tmp32_ = (vala_ccode_node_unref (_tmp32_), NULL));
				_tmp31_ = (g_free (_tmp31_), NULL);
				(_tmp30_ == NULL) ? NULL : (_tmp30_ = (vala_ccode_node_unref (_tmp30_), NULL));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	if (!VALA_IS_VOID_TYPE (return_type)) {
		ValaCCodeExpressionStatement* _tmp40_;
		ValaCCodeAssignment* _tmp39_;
		ValaCCodeMemberAccess* _tmp38_;
		ValaCCodeIdentifier* _tmp37_;
		ValaCCodeIdentifier* _tmp36_;
		gboolean _tmp41_;
		ValaCCodeReturnStatement* _tmp48_;
		ValaCCodeIdentifier* _tmp47_;
		_tmp40_ = NULL;
		_tmp39_ = NULL;
		_tmp38_ = NULL;
		_tmp37_ = NULL;
		_tmp36_ = NULL;
		vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp40_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp39_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp36_ = vala_ccode_identifier_new ("result")), (ValaCCodeExpression*) (_tmp38_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp37_ = vala_ccode_identifier_new ("data")), "result")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp40_ == NULL) ? NULL : (_tmp40_ = (vala_ccode_node_unref (_tmp40_), NULL));
		(_tmp39_ == NULL) ? NULL : (_tmp39_ = (vala_ccode_node_unref (_tmp39_), NULL));
		(_tmp38_ == NULL) ? NULL : (_tmp38_ = (vala_ccode_node_unref (_tmp38_), NULL));
		(_tmp37_ == NULL) ? NULL : (_tmp37_ = (vala_ccode_node_unref (_tmp37_), NULL));
		(_tmp36_ == NULL) ? NULL : (_tmp36_ = (vala_ccode_node_unref (_tmp36_), NULL));
		_tmp41_ = FALSE;
		if (!VALA_IS_VALUE_TYPE (return_type)) {
			_tmp41_ = TRUE;
		} else {
			_tmp41_ = vala_data_type_get_nullable (return_type);
		}
		if (_tmp41_) {
			ValaCCodeExpressionStatement* _tmp46_;
			ValaCCodeAssignment* _tmp45_;
			ValaCCodeConstant* _tmp44_;
			ValaCCodeMemberAccess* _tmp43_;
			ValaCCodeIdentifier* _tmp42_;
			_tmp46_ = NULL;
			_tmp45_ = NULL;
			_tmp44_ = NULL;
			_tmp43_ = NULL;
			_tmp42_ = NULL;
			vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp46_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp45_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp43_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp42_ = vala_ccode_identifier_new ("data")), "result")), (ValaCCodeExpression*) (_tmp44_ = vala_ccode_constant_new ("NULL")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
			(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_ccode_node_unref (_tmp46_), NULL));
			(_tmp45_ == NULL) ? NULL : (_tmp45_ = (vala_ccode_node_unref (_tmp45_), NULL));
			(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_ccode_node_unref (_tmp44_), NULL));
			(_tmp43_ == NULL) ? NULL : (_tmp43_ = (vala_ccode_node_unref (_tmp43_), NULL));
			(_tmp42_ == NULL) ? NULL : (_tmp42_ = (vala_ccode_node_unref (_tmp42_), NULL));
		}
		_tmp48_ = NULL;
		_tmp47_ = NULL;
		vala_ccode_block_add_statement (finishblock, (ValaCCodeNode*) (_tmp48_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp47_ = vala_ccode_identifier_new ("result")))));
		(_tmp48_ == NULL) ? NULL : (_tmp48_ = (vala_ccode_node_unref (_tmp48_), NULL));
		(_tmp47_ == NULL) ? NULL : (_tmp47_ = (vala_ccode_node_unref (_tmp47_), NULL));
	}
	_tmp49_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp49_ = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp49_ == NULL) ? NULL : (_tmp49_ = (vala_ccode_node_unref (_tmp49_), NULL));
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, ((ValaCCodeBaseModule*) self)->source_declarations, (GeeMap*) cparam_map, finishfunc, NULL, NULL, NULL, 2);
	vala_ccode_function_set_block (finishfunc, finishblock);
	result = finishfunc;
	dataname = (g_free (dataname), NULL);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(finishblock == NULL) ? NULL : (finishblock = (vala_ccode_node_unref (finishblock), NULL));
	(return_type == NULL) ? NULL : (return_type = (vala_code_node_unref (return_type), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(simple_async_result_cast == NULL) ? NULL : (simple_async_result_cast = (vala_ccode_node_unref (simple_async_result_cast), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	return result;
}


static ValaCCodeFunction* vala_gasync_module_generate_ready_function (ValaGAsyncModule* self, ValaMethod* m) {
	ValaCCodeFunction* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	char* dataname;
	char* _tmp4_;
	char* _tmp3_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeFunction* readyfunc;
	ValaCCodeFormalParameter* _tmp6_;
	ValaCCodeFormalParameter* _tmp7_;
	ValaCCodeFormalParameter* _tmp8_;
	ValaCCodeBlock* readyblock;
	char* _tmp9_;
	ValaCCodeDeclaration* _tmp10_;
	ValaCCodeDeclaration* datadecl;
	ValaCCodeVariableDeclarator* _tmp11_;
	ValaCCodeExpressionStatement* _tmp15_;
	ValaCCodeAssignment* _tmp14_;
	ValaCCodeIdentifier* _tmp13_;
	ValaCCodeIdentifier* _tmp12_;
	ValaCCodeExpressionStatement* _tmp20_;
	ValaCCodeAssignment* _tmp19_;
	ValaCCodeIdentifier* _tmp18_;
	ValaCCodeMemberAccess* _tmp17_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeIdentifier* _tmp23_;
	char* _tmp22_;
	char* _tmp21_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeExpressionStatement* _tmp26_;
	ValaCCodeFunction* _tmp27_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	/* generate ready callback handler*/
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	dataname = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_lower_case_to_camel_case (_tmp0_ = vala_method_get_cname (m)), "Data", NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	_tmp5_ = NULL;
	readyfunc = (_tmp5_ = vala_ccode_function_new (_tmp4_ = g_strconcat (_tmp3_ = vala_method_get_cname (m), "_ready", NULL), "void"), _tmp4_ = (g_free (_tmp4_), NULL), _tmp3_ = (g_free (_tmp3_), NULL), _tmp5_);
	_tmp6_ = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp6_ = vala_ccode_formal_parameter_new ("source_object", "GObject*"));
	(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
	_tmp7_ = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp7_ = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	_tmp8_ = NULL;
	vala_ccode_function_add_parameter (readyfunc, _tmp8_ = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	readyblock = vala_ccode_block_new ();
	_tmp9_ = NULL;
	_tmp10_ = NULL;
	datadecl = (_tmp10_ = vala_ccode_declaration_new (_tmp9_ = g_strconcat (dataname, "*", NULL)), _tmp9_ = (g_free (_tmp9_), NULL), _tmp10_);
	_tmp11_ = NULL;
	vala_ccode_declaration_add_declarator (datadecl, (ValaCCodeDeclarator*) (_tmp11_ = vala_ccode_variable_declarator_new ("data", NULL, NULL)));
	(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) datadecl);
	_tmp15_ = NULL;
	_tmp14_ = NULL;
	_tmp13_ = NULL;
	_tmp12_ = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp15_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp12_ = vala_ccode_identifier_new ("data")), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_identifier_new ("user_data")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
	(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
	(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
	(_tmp12_ == NULL) ? NULL : (_tmp12_ = (vala_ccode_node_unref (_tmp12_), NULL));
	_tmp20_ = NULL;
	_tmp19_ = NULL;
	_tmp18_ = NULL;
	_tmp17_ = NULL;
	_tmp16_ = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp20_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp17_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_identifier_new ("data")), "res")), (ValaCCodeExpression*) (_tmp18_ = vala_ccode_identifier_new ("res")), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
	(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
	(_tmp18_ == NULL) ? NULL : (_tmp18_ = (vala_ccode_node_unref (_tmp18_), NULL));
	(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
	(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
	_tmp23_ = NULL;
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	_tmp24_ = NULL;
	ccall = (_tmp24_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp23_ = vala_ccode_identifier_new (_tmp22_ = g_strconcat (_tmp21_ = vala_method_get_real_cname (m), "_co", NULL)))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (vala_ccode_node_unref (_tmp23_), NULL)), _tmp22_ = (g_free (_tmp22_), NULL), _tmp21_ = (g_free (_tmp21_), NULL), _tmp24_);
	_tmp25_ = NULL;
	vala_ccode_function_call_add_argument (ccall, (ValaCCodeExpression*) (_tmp25_ = vala_ccode_identifier_new ("data")));
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
	_tmp26_ = NULL;
	vala_ccode_block_add_statement (readyblock, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) ccall)));
	(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
	vala_ccode_function_set_modifiers (readyfunc, vala_ccode_function_get_modifiers (readyfunc) | VALA_CCODE_MODIFIERS_STATIC);
	_tmp27_ = NULL;
	vala_ccode_declaration_space_add_type_member_declaration (((ValaCCodeBaseModule*) self)->source_declarations, (ValaCCodeNode*) (_tmp27_ = vala_ccode_function_copy (readyfunc)));
	(_tmp27_ == NULL) ? NULL : (_tmp27_ = (vala_ccode_node_unref (_tmp27_), NULL));
	vala_ccode_function_set_block (readyfunc, readyblock);
	result = readyfunc;
	dataname = (g_free (dataname), NULL);
	(readyblock == NULL) ? NULL : (readyblock = (vala_ccode_node_unref (readyblock), NULL));
	(datadecl == NULL) ? NULL : (datadecl = (vala_ccode_node_unref (datadecl), NULL));
	(ccall == NULL) ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL));
	return result;
}


static void vala_gasync_module_real_generate_virtual_method_declaration (ValaGTypeModule* base, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct) {
	ValaGAsyncModule * self;
	gboolean _tmp0_;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (type_struct != NULL);
	if (!vala_method_get_coroutine (m)) {
		VALA_GTYPE_MODULE_CLASS (vala_gasync_module_parent_class)->generate_virtual_method_declaration ((ValaGTypeModule*) VALA_GSIGNAL_MODULE (self), m, decl_space, type_struct);
		return;
	}
	_tmp0_ = FALSE;
	if (vala_method_get_is_abstract (m)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_method_get_is_virtual (m);
	}
	if (_tmp0_) {
		vala_gasync_module_append_async_virtual_function (self, m, decl_space, type_struct);
		vala_gasync_module_append_finish_virtual_function (self, m, decl_space, type_struct);
	}
}


static void vala_gasync_module_append_async_virtual_function (ValaGAsyncModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct) {
	GeeHashMap* cparam_map;
	GeeHashMap* carg_map;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeFormalParameter* _tmp1_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaVoidType* _tmp4_;
	ValaCCodeDeclaration* vdecl;
	char* _tmp5_;
	ValaCCodeFunctionDeclarator* _tmp6_;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFunction* fake;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (type_struct != NULL);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp0_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), _tmp0_ = vala_ccode_formal_parameter_new ("callback", "GAsyncReadyCallback"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), _tmp1_ = vala_ccode_formal_parameter_new ("user_data", "gpointer"));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	_tmp2_ = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (double) (-1), FALSE)), (ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("callback")));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	_tmp3_ = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) (_tmp3_ = vala_ccode_identifier_new ("user_data")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	_tmp4_ = NULL;
	vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, (ValaDataType*) (_tmp4_ = vala_void_type_new (NULL)), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_async", 1);
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_code_node_unref (_tmp4_), NULL));
	vdecl = vala_ccode_declaration_new ("void");
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	vdeclarator = (_tmp6_ = vala_ccode_function_declarator_new (_tmp5_ = g_strconcat (vala_method_get_vfunc_name (m), "_async", NULL)), _tmp5_ = (g_free (_tmp5_), NULL), _tmp6_);
	vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
	vala_ccode_struct_add_declaration (type_struct, vdecl);
	fake = vala_ccode_function_new ("fake", "void");
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, fake, vdeclarator, NULL, NULL, 1);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(fake == NULL) ? NULL : (fake = (vala_ccode_node_unref (fake), NULL));
}


static void vala_gasync_module_append_finish_virtual_function (ValaGAsyncModule* self, ValaMethod* m, ValaCCodeDeclarationSpace* decl_space, ValaCCodeStruct* type_struct) {
	GeeHashMap* cparam_map;
	GeeHashMap* carg_map;
	ValaCCodeFormalParameter* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	char* _tmp2_;
	ValaCCodeDeclaration* _tmp3_;
	ValaCCodeDeclaration* vdecl;
	char* _tmp4_;
	ValaCCodeFunctionDeclarator* _tmp5_;
	ValaCCodeFunctionDeclarator* vdeclarator;
	ValaCCodeFunction* fake;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	g_return_if_fail (decl_space != NULL);
	g_return_if_fail (type_struct != NULL);
	cparam_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	carg_map = gee_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_hash, g_direct_equal, g_direct_equal);
	_tmp0_ = NULL;
	gee_map_set ((GeeMap*) cparam_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), _tmp0_ = vala_ccode_formal_parameter_new ("res", "GAsyncResult*"));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL));
	_tmp1_ = NULL;
	gee_map_set ((GeeMap*) carg_map, GINT_TO_POINTER (vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("res")));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
	vala_ccode_method_module_generate_vfunc ((ValaCCodeMethodModule*) self, m, vala_method_get_return_type (m), (GeeMap*) cparam_map, (GeeMap*) carg_map, "_finish", 2);
	_tmp2_ = NULL;
	_tmp3_ = NULL;
	vdecl = (_tmp3_ = vala_ccode_declaration_new (_tmp2_ = vala_data_type_get_cname (vala_method_get_return_type (m))), _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_);
	_tmp4_ = NULL;
	_tmp5_ = NULL;
	vdeclarator = (_tmp5_ = vala_ccode_function_declarator_new (_tmp4_ = g_strconcat (vala_method_get_vfunc_name (m), "_finish", NULL)), _tmp4_ = (g_free (_tmp4_), NULL), _tmp5_);
	vala_ccode_declaration_add_declarator (vdecl, (ValaCCodeDeclarator*) vdeclarator);
	vala_ccode_struct_add_declaration (type_struct, vdecl);
	fake = vala_ccode_function_new ("fake", "void");
	vala_ccode_base_module_generate_cparameters ((ValaCCodeBaseModule*) self, m, decl_space, (GeeMap*) cparam_map, fake, vdeclarator, NULL, NULL, 2);
	(cparam_map == NULL) ? NULL : (cparam_map = (gee_collection_object_unref (cparam_map), NULL));
	(carg_map == NULL) ? NULL : (carg_map = (gee_collection_object_unref (carg_map), NULL));
	(vdecl == NULL) ? NULL : (vdecl = (vala_ccode_node_unref (vdecl), NULL));
	(vdeclarator == NULL) ? NULL : (vdeclarator = (vala_ccode_node_unref (vdeclarator), NULL));
	(fake == NULL) ? NULL : (fake = (vala_ccode_node_unref (fake), NULL));
}


static void vala_gasync_module_real_visit_yield_statement (ValaCCodeModule* base, ValaYieldStatement* stmt) {
	ValaGAsyncModule * self;
	gboolean _tmp0_;
	ValaCCodeExpressionStatement* _tmp22_;
	gboolean _tmp23_;
	ValaCCodeFragment* cfrag;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	}
	if (_tmp0_) {
		ValaCCodeEmptyStatement* _tmp1_;
		_tmp1_ = NULL;
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp1_ = vala_ccode_empty_statement_new ()));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL));
		return;
	}
	if (vala_yield_statement_get_yield_expression (stmt) == NULL) {
		ValaCCodeFragment* cfrag;
		ValaCCodeIdentifier* _tmp2_;
		ValaCCodeFunctionCall* _tmp3_;
		ValaCCodeFunctionCall* idle_call;
		ValaCCodeCastExpression* _tmp7_;
		ValaCCodeIdentifier* _tmp6_;
		char* _tmp5_;
		char* _tmp4_;
		ValaCCodeIdentifier* _tmp8_;
		gint state;
		ValaCCodeExpressionStatement* _tmp9_;
		ValaCCodeExpressionStatement* _tmp15_;
		ValaCCodeAssignment* _tmp14_;
		ValaCCodeConstant* _tmp13_;
		char* _tmp12_;
		ValaCCodeMemberAccess* _tmp11_;
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeReturnStatement* _tmp17_;
		ValaCCodeConstant* _tmp16_;
		ValaCCodeCaseStatement* _tmp20_;
		ValaCCodeConstant* _tmp19_;
		char* _tmp18_;
		ValaCCodeEmptyStatement* _tmp21_;
		/* should be replaced by a simple return FALSE; when we have
		     void idle () yields;
		 working in the .vapi*/
		cfrag = vala_ccode_fragment_new ();
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		_tmp2_ = NULL;
		_tmp3_ = NULL;
		idle_call = (_tmp3_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("g_idle_add"))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL)), _tmp3_);
		_tmp7_ = NULL;
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		_tmp4_ = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp7_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) (_tmp6_ = vala_ccode_identifier_new (_tmp5_ = g_strconcat (_tmp4_ = vala_method_get_real_cname (((ValaCCodeBaseModule*) self)->current_method), "_co", NULL))), "GSourceFunc")));
		(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_ccode_node_unref (_tmp6_), NULL));
		_tmp5_ = (g_free (_tmp5_), NULL);
		_tmp4_ = (g_free (_tmp4_), NULL);
		_tmp8_ = NULL;
		vala_ccode_function_call_add_argument (idle_call, (ValaCCodeExpression*) (_tmp8_ = vala_ccode_identifier_new ("data")));
		(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
		state = ((ValaCCodeBaseModule*) self)->next_coroutine_state++;
		_tmp9_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp9_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) idle_call)));
		(_tmp9_ == NULL) ? NULL : (_tmp9_ = (vala_ccode_node_unref (_tmp9_), NULL));
		_tmp15_ = NULL;
		_tmp14_ = NULL;
		_tmp13_ = NULL;
		_tmp12_ = NULL;
		_tmp11_ = NULL;
		_tmp10_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp15_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) (_tmp14_ = vala_ccode_assignment_new ((ValaCCodeExpression*) (_tmp11_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp10_ = vala_ccode_identifier_new ("data")), "state")), (ValaCCodeExpression*) (_tmp13_ = vala_ccode_constant_new (_tmp12_ = g_strdup_printf ("%i", state))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))));
		(_tmp15_ == NULL) ? NULL : (_tmp15_ = (vala_ccode_node_unref (_tmp15_), NULL));
		(_tmp14_ == NULL) ? NULL : (_tmp14_ = (vala_ccode_node_unref (_tmp14_), NULL));
		(_tmp13_ == NULL) ? NULL : (_tmp13_ = (vala_ccode_node_unref (_tmp13_), NULL));
		_tmp12_ = (g_free (_tmp12_), NULL);
		(_tmp11_ == NULL) ? NULL : (_tmp11_ = (vala_ccode_node_unref (_tmp11_), NULL));
		(_tmp10_ == NULL) ? NULL : (_tmp10_ = (vala_ccode_node_unref (_tmp10_), NULL));
		_tmp17_ = NULL;
		_tmp16_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp17_ = vala_ccode_return_statement_new ((ValaCCodeExpression*) (_tmp16_ = vala_ccode_constant_new ("FALSE")))));
		(_tmp17_ == NULL) ? NULL : (_tmp17_ = (vala_ccode_node_unref (_tmp17_), NULL));
		(_tmp16_ == NULL) ? NULL : (_tmp16_ = (vala_ccode_node_unref (_tmp16_), NULL));
		_tmp20_ = NULL;
		_tmp19_ = NULL;
		_tmp18_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp20_ = vala_ccode_case_statement_new ((ValaCCodeExpression*) (_tmp19_ = vala_ccode_constant_new (_tmp18_ = g_strdup_printf ("%i", state))))));
		(_tmp20_ == NULL) ? NULL : (_tmp20_ = (vala_ccode_node_unref (_tmp20_), NULL));
		(_tmp19_ == NULL) ? NULL : (_tmp19_ = (vala_ccode_node_unref (_tmp19_), NULL));
		_tmp18_ = (g_free (_tmp18_), NULL);
		_tmp21_ = NULL;
		vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp21_ = vala_ccode_empty_statement_new ()));
		(_tmp21_ == NULL) ? NULL : (_tmp21_ = (vala_ccode_node_unref (_tmp21_), NULL));
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
		(idle_call == NULL) ? NULL : (idle_call = (vala_ccode_node_unref (idle_call), NULL));
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	if (vala_code_node_get_error ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))) {
		vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
		return;
	}
	_tmp22_ = NULL;
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) (_tmp22_ = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt))))));
	(_tmp22_ == NULL) ? NULL : (_tmp22_ = (vala_ccode_node_unref (_tmp22_), NULL));
	_tmp23_ = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) stmt)) {
		_tmp23_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt));
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaCCodeFragment* cfrag;
		/* simple case, no node breakdown necessary*/
		cfrag = vala_ccode_fragment_new ();
		vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
		vala_ccode_module_add_simple_check (vala_ccode_module_get_head ((ValaCCodeModule*) self), (ValaCodeNode*) vala_yield_statement_get_yield_expression (stmt), cfrag);
		vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
		(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
	}
	/* free temporary objects */
	if (gee_collection_get_size ((GeeCollection*) GEE_LIST (((ValaCCodeBaseModule*) self)->temp_vars)) == 0) {
		/* nothing to do without temporary variables */
		return;
	}
	cfrag = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_temp_decl ((ValaCCodeBaseModule*) self, cfrag, (GeeList*) ((ValaCCodeBaseModule*) self)->temp_vars);
	vala_ccode_fragment_append (cfrag, vala_code_node_get_ccodenode ((ValaCodeNode*) stmt));
	{
		GeeIterator* _local_it;
		_local_it = gee_iterable_iterator ((GeeIterable*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
		while (TRUE) {
			ValaLocalVariable* local;
			ValaMemberAccess* ma;
			ValaCCodeExpressionStatement* _tmp26_;
			ValaCCodeExpression* _tmp25_;
			ValaCCodeIdentifier* _tmp24_;
			if (!gee_iterator_next (_local_it)) {
				break;
			}
			local = (ValaLocalVariable*) gee_iterator_get (_local_it);
			ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), NULL);
			vala_expression_set_symbol_reference ((ValaExpression*) ma, (ValaSymbol*) local);
			_tmp26_ = NULL;
			_tmp25_ = NULL;
			_tmp24_ = NULL;
			vala_ccode_fragment_append (cfrag, (ValaCCodeNode*) (_tmp26_ = vala_ccode_expression_statement_new (_tmp25_ = vala_ccode_base_module_get_unref_expression ((ValaCCodeBaseModule*) self, (ValaCCodeExpression*) (_tmp24_ = vala_ccode_identifier_new (vala_symbol_get_name ((ValaSymbol*) local))), vala_local_variable_get_variable_type (local), (ValaExpression*) ma))));
			(_tmp26_ == NULL) ? NULL : (_tmp26_ = (vala_ccode_node_unref (_tmp26_), NULL));
			(_tmp25_ == NULL) ? NULL : (_tmp25_ = (vala_ccode_node_unref (_tmp25_), NULL));
			(_tmp24_ == NULL) ? NULL : (_tmp24_ = (vala_ccode_node_unref (_tmp24_), NULL));
			(local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL));
			(ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL));
		}
		(_local_it == NULL) ? NULL : (_local_it = (gee_collection_object_unref (_local_it), NULL));
	}
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) cfrag);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_vars);
	gee_collection_clear ((GeeCollection*) ((ValaCCodeBaseModule*) self)->temp_ref_vars);
	(cfrag == NULL) ? NULL : (cfrag = (vala_ccode_node_unref (cfrag), NULL));
}


static ValaCCodeStatement* vala_gasync_module_real_return_with_exception (ValaGErrorModule* base, ValaCCodeExpression* error_expr) {
	ValaGAsyncModule * self;
	ValaCCodeStatement* result;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeFunctionCall* _tmp1_;
	ValaCCodeFunctionCall* set_error;
	ValaCCodeMemberAccess* _tmp3_;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeExpressionStatement* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* free_error;
	ValaCCodeExpressionStatement* _tmp7_;
	ValaCCodeFragment* free_locals;
	ValaCCodeStatement* _tmp8_;
	self = (ValaGAsyncModule*) base;
	g_return_val_if_fail (error_expr != NULL, NULL);
	if (!vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method)) {
		result = VALA_GERROR_MODULE_CLASS (vala_gasync_module_parent_class)->return_with_exception ((ValaGErrorModule*) VALA_GSIGNAL_MODULE (self), error_expr);
		return result;
	}
	block = vala_ccode_block_new ();
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	set_error = (_tmp1_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp0_ = vala_ccode_identifier_new ("g_simple_async_result_set_from_error"))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_ccode_node_unref (_tmp0_), NULL)), _tmp1_);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	vala_ccode_function_call_add_argument (set_error, (ValaCCodeExpression*) (_tmp3_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp2_ = vala_ccode_identifier_new ("data")), "_async_result")));
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_ccode_node_unref (_tmp2_), NULL));
	vala_ccode_function_call_add_argument (set_error, error_expr);
	_tmp4_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp4_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) set_error)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	_tmp5_ = NULL;
	_tmp6_ = NULL;
	free_error = (_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) (_tmp5_ = vala_ccode_identifier_new ("g_error_free"))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_ccode_node_unref (_tmp5_), NULL)), _tmp6_);
	vala_ccode_function_call_add_argument (free_error, error_expr);
	_tmp7_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp7_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) free_error)));
	(_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_ccode_node_unref (_tmp7_), NULL));
	free_locals = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_locals, FALSE);
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) free_locals);
	_tmp8_ = NULL;
	vala_ccode_block_add_statement (block, (ValaCCodeNode*) (_tmp8_ = vala_ccode_method_module_complete_async ((ValaCCodeMethodModule*) self)));
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (vala_ccode_node_unref (_tmp8_), NULL));
	result = (ValaCCodeStatement*) block;
	(set_error == NULL) ? NULL : (set_error = (vala_ccode_node_unref (set_error), NULL));
	(free_error == NULL) ? NULL : (free_error = (vala_ccode_node_unref (free_error), NULL));
	(free_locals == NULL) ? NULL : (free_locals = (vala_ccode_node_unref (free_locals), NULL));
	return result;
}


static void vala_gasync_module_real_visit_return_statement (ValaCCodeModule* base, ValaReturnStatement* stmt) {
	ValaGAsyncModule * self;
	gboolean _tmp0_;
	ValaCCodeBlock* result_block;
	ValaCCodeFragment* free_locals;
	ValaCCodeStatement* _tmp4_;
	self = (ValaGAsyncModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = FALSE;
	if (((ValaCCodeBaseModule*) self)->current_method == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !vala_method_get_coroutine (((ValaCCodeBaseModule*) self)->current_method);
	}
	if (_tmp0_) {
		VALA_CCODE_MODULE_CLASS (vala_gasync_module_parent_class)->visit_return_statement ((ValaCCodeModule*) VALA_GSIGNAL_MODULE (self), stmt);
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) vala_ccode_module_get_codegen ((ValaCCodeModule*) self));
	result_block = vala_ccode_block_new ();
	vala_code_node_set_ccodenode ((ValaCodeNode*) stmt, (ValaCCodeNode*) result_block);
	if (vala_return_statement_get_return_expression (stmt) != NULL) {
		ValaCCodeIdentifier* _tmp1_;
		ValaCCodeMemberAccess* _tmp2_;
		ValaCCodeMemberAccess* result_var;
		ValaCCodeAssignment* assign_result;
		ValaCCodeExpressionStatement* _tmp3_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result_var = (_tmp2_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) (_tmp1_ = vala_ccode_identifier_new ("data")), "result"), (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_ccode_node_unref (_tmp1_), NULL)), _tmp2_);
		assign_result = vala_ccode_assignment_new ((ValaCCodeExpression*) result_var, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode ((ValaCodeNode*) vala_return_statement_get_return_expression (stmt))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
		_tmp3_ = NULL;
		vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) (_tmp3_ = vala_ccode_expression_statement_new ((ValaCCodeExpression*) assign_result)));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_ccode_node_unref (_tmp3_), NULL));
		vala_ccode_base_module_create_temp_decl ((ValaCCodeBaseModule*) self, (ValaStatement*) stmt, (GeeList*) vala_return_statement_get_return_expression (stmt)->temp_vars);
		(result_var == NULL) ? NULL : (result_var = (vala_ccode_node_unref (result_var), NULL));
		(assign_result == NULL) ? NULL : (assign_result = (vala_ccode_node_unref (assign_result), NULL));
	}
	free_locals = vala_ccode_fragment_new ();
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, ((ValaCCodeBaseModule*) self)->current_symbol, free_locals, FALSE);
	vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) free_locals);
	_tmp4_ = NULL;
	vala_ccode_block_add_statement (result_block, (ValaCCodeNode*) (_tmp4_ = vala_ccode_method_module_complete_async ((ValaCCodeMethodModule*) self)));
	(_tmp4_ == NULL) ? NULL : (_tmp4_ = (vala_ccode_node_unref (_tmp4_), NULL));
	(result_block == NULL) ? NULL : (result_block = (vala_ccode_node_unref (result_block), NULL));
	(free_locals == NULL) ? NULL : (free_locals = (vala_ccode_node_unref (free_locals), NULL));
}


static void vala_gasync_module_class_init (ValaGAsyncModuleClass * klass) {
	vala_gasync_module_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_MODULE_CLASS (klass)->visit_method = vala_gasync_module_real_visit_method;
	VALA_GTYPE_MODULE_CLASS (klass)->generate_virtual_method_declaration = vala_gasync_module_real_generate_virtual_method_declaration;
	VALA_CCODE_MODULE_CLASS (klass)->visit_yield_statement = vala_gasync_module_real_visit_yield_statement;
	VALA_GERROR_MODULE_CLASS (klass)->return_with_exception = vala_gasync_module_real_return_with_exception;
	VALA_CCODE_MODULE_CLASS (klass)->visit_return_statement = vala_gasync_module_real_visit_return_statement;
}


static void vala_gasync_module_instance_init (ValaGAsyncModule * self) {
}


GType vala_gasync_module_get_type (void) {
	static GType vala_gasync_module_type_id = 0;
	if (vala_gasync_module_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGAsyncModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gasync_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGAsyncModule), 0, (GInstanceInitFunc) vala_gasync_module_instance_init, NULL };
		vala_gasync_module_type_id = g_type_register_static (VALA_TYPE_GSIGNAL_MODULE, "ValaGAsyncModule", &g_define_type_info, 0);
	}
	return vala_gasync_module_type_id;
}




