/* valaclass.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;
typedef struct _ValaTypeSymbolPrivate ValaTypeSymbolPrivate;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;
typedef struct _ValaObjectTypeSymbolPrivate ValaObjectTypeSymbolPrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;
typedef struct _ValaClassPrivate ValaClassPrivate;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_SYMBOL_ACCESSIBILITY (vala_symbol_accessibility_get_type ())

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_LOOP (vala_loop_get_type ())
#define VALA_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOOP, ValaLoop))
#define VALA_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOOP, ValaLoopClass))
#define VALA_IS_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOOP))
#define VALA_IS_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOOP))
#define VALA_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOOP, ValaLoopClass))

typedef struct _ValaLoop ValaLoop;
typedef struct _ValaLoopClass ValaLoopClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Represents a node in the symbol tree.
 */
struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

/**
 * Represents a runtime data type. This data type may be defined in Vala source
 * code or imported from an external library with a Vala API file.
 */
struct _ValaTypeSymbol {
	ValaSymbol parent_instance;
	ValaTypeSymbolPrivate * priv;
};

struct _ValaTypeSymbolClass {
	ValaSymbolClass parent_class;
	char* (*get_cname) (ValaTypeSymbol* self, gboolean const_type);
	gboolean (*is_reference_type) (ValaTypeSymbol* self);
	char* (*get_dup_function) (ValaTypeSymbol* self);
	char* (*get_free_function) (ValaTypeSymbol* self);
	char* (*get_copy_function) (ValaTypeSymbol* self);
	char* (*get_destroy_function) (ValaTypeSymbol* self);
	gboolean (*is_reference_counting) (ValaTypeSymbol* self);
	char* (*get_ref_function) (ValaTypeSymbol* self);
	char* (*get_unref_function) (ValaTypeSymbol* self);
	char* (*get_ref_sink_function) (ValaTypeSymbol* self);
	char* (*get_type_id) (ValaTypeSymbol* self);
	char* (*get_marshaller_type_name) (ValaTypeSymbol* self);
	char* (*get_param_spec_function) (ValaTypeSymbol* self);
	char* (*get_get_value_function) (ValaTypeSymbol* self);
	char* (*get_set_value_function) (ValaTypeSymbol* self);
	char* (*get_upper_case_cname) (ValaTypeSymbol* self, const char* infix);
	char* (*get_default_value) (ValaTypeSymbol* self);
	gboolean (*is_subtype_of) (ValaTypeSymbol* self, ValaTypeSymbol* t);
	gint (*get_type_parameter_index) (ValaTypeSymbol* self, const char* name);
	char* (*get_type_signature) (ValaTypeSymbol* self);
};

/**
 * Represents a runtime data type for objects and interfaces. This data type may
 * be defined in Vala source code or imported from an external library with a 
 * Vala API file.
 */
struct _ValaObjectTypeSymbol {
	ValaTypeSymbol parent_instance;
	ValaObjectTypeSymbolPrivate * priv;
};

struct _ValaObjectTypeSymbolClass {
	ValaTypeSymbolClass parent_class;
	GeeList* (*get_methods) (ValaObjectTypeSymbol* self);
	GeeList* (*get_signals) (ValaObjectTypeSymbol* self);
	GeeList* (*get_properties) (ValaObjectTypeSymbol* self);
};

/**
 * Represents a class declaration in the source code.
 */
struct _ValaClass {
	ValaObjectTypeSymbol parent_instance;
	ValaClassPrivate * priv;
};

struct _ValaClassClass {
	ValaObjectTypeSymbolClass parent_class;
};

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	char* _type_check_function;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean _free_function_address_of;
	char* cname;
	char* const_cname;
	char* lower_case_cprefix;
	char* lower_case_csuffix;
	char* type_id;
	char* ref_function;
	char* unref_function;
	gboolean _ref_function_void;
	char* ref_sink_function;
	char* param_spec_function;
	char* copy_function;
	char* free_function;
	char* marshaller_type_name;
	char* get_value_function;
	char* set_value_function;
	char* type_signature;
	gboolean _is_compact;
	gboolean _is_immutable;
	GeeList* base_types;
	GeeList* constants;
	GeeList* fields;
	GeeList* methods;
	GeeList* properties;
	GeeList* signals;
	GeeList* classes;
	GeeList* structs;
	GeeList* enums;
	GeeList* delegates;
	ValaMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};

typedef enum  {
	VALA_SYMBOL_ACCESSIBILITY_PRIVATE,
	VALA_SYMBOL_ACCESSIBILITY_INTERNAL,
	VALA_SYMBOL_ACCESSIBILITY_PROTECTED,
	VALA_SYMBOL_ACCESSIBILITY_PUBLIC
} ValaSymbolAccessibility;

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCodeVisitor* self, ValaLoop* stmt);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaStructValueType* gvalue_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaDataType* gvaluearray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};


static gpointer vala_class_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
GType vala_signal_get_type (void);
GType vala_property_get_type (void);
GType vala_class_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_struct_get_type (void);
GType vala_enum_get_type (void);
GType vala_delegate_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
enum  {
	VALA_CLASS_DUMMY_PROPERTY
};
GeeList* vala_class_get_classes (ValaClass* self);
GeeList* vala_class_get_structs (ValaClass* self);
GeeList* vala_class_get_enums (ValaClass* self);
GeeList* vala_class_get_delegates (ValaClass* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
ValaObjectTypeSymbol* vala_object_type_symbol_new (const char* name, ValaSourceReference* source_reference);
ValaObjectTypeSymbol* vala_object_type_symbol_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference);
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_class_add_base_type (ValaClass* self, ValaDataType* type);
GeeList* vala_class_get_base_types (ValaClass* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_class_add_constant (ValaClass* self, ValaConstant* c);
GType vala_symbol_accessibility_get_type (void);
ValaSymbolAccessibility vala_symbol_get_access (ValaSymbol* self);
GType member_binding_get_type (void);
MemberBinding vala_field_get_binding (ValaField* self);
static void vala_class_set_has_private_fields (ValaClass* self, gboolean value);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
void vala_class_add_field (ValaClass* self, ValaField* f);
GeeList* vala_class_get_fields (ValaClass* self);
GeeList* vala_class_get_constants (ValaClass* self);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
GType vala_typeparameter_get_type (void);
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
ValaGenericType* vala_generic_type_new (ValaTypeParameter* type_parameter);
ValaGenericType* vala_generic_type_construct (GType object_type, ValaTypeParameter* type_parameter);
GType vala_generic_type_get_type (void);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
static ValaObjectType* vala_class_get_this_type (ValaClass* self);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_creation_method_get_type (void);
GType vala_formal_parameter_get_type (void);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const char* name);
ValaFormalParameter* vala_formal_parameter_new (const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
ValaFormalParameter* vala_formal_parameter_construct (GType object_type, const char* name, ValaDataType* parameter_type, ValaSourceReference* source_reference);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
GType vala_void_type_get_type (void);
GeeList* vala_method_get_postconditions (ValaMethod* self);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
ValaDataType* vala_data_type_copy (ValaDataType* self);
ValaLocalVariable* vala_local_variable_new (ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
ValaLocalVariable* vala_local_variable_construct (GType object_type, ValaDataType* variable_type, const char* name, ValaExpression* initializer, ValaSourceReference* source_reference);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
void vala_local_variable_set_is_result (ValaLocalVariable* self, gboolean value);
void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value);
void vala_symbol_set_name (ValaSymbol* self, const char* value);
const char* vala_creation_method_get_class_name (ValaCreationMethod* self);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_class_add_method (ValaClass* self, ValaMethod* m);
static GeeList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
void vala_property_set_this_parameter (ValaProperty* self, ValaFormalParameter* value);
ValaFormalParameter* vala_property_get_this_parameter (ValaProperty* self);
ValaField* vala_property_get_field (ValaProperty* self);
void vala_class_add_property (ValaClass* self, ValaProperty* prop);
static GeeList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
void vala_class_add_signal (ValaClass* self, ValaSignal* sig);
static GeeList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
void vala_class_add_class (ValaClass* self, ValaClass* cl);
void vala_class_add_struct (ValaClass* self, ValaStruct* st);
void vala_class_add_enum (ValaClass* self, ValaEnum* en);
void vala_class_add_delegate (ValaClass* self, ValaDelegate* d);
void vala_code_visitor_visit_class (ValaCodeVisitor* self, ValaClass* cl);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
ValaConstructor* vala_class_get_constructor (ValaClass* self);
ValaConstructor* vala_class_get_class_constructor (ValaClass* self);
ValaConstructor* vala_class_get_static_constructor (ValaClass* self);
ValaDestructor* vala_class_get_destructor (ValaClass* self);
ValaDestructor* vala_class_get_static_destructor (ValaClass* self);
ValaDestructor* vala_class_get_class_destructor (ValaClass* self);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
char* vala_typesymbol_get_cname (ValaTypeSymbol* self, gboolean const_type);
static char* vala_class_real_get_cprefix (ValaSymbol* base);
gboolean vala_class_get_is_immutable (ValaClass* self);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
char* vala_class_get_default_cname (ValaClass* self);
static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_cprefix (ValaSymbol* self);
void vala_class_set_cname (ValaClass* self, const char* cname);
char* vala_symbol_camel_case_to_lower_case (const char* camel_case);
static char* vala_class_get_lower_case_csuffix (ValaClass* self);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix);
char* vala_symbol_get_lower_case_cname (ValaSymbol* self, const char* infix);
static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base);
static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix);
static char* vala_class_real_get_type_signature (ValaTypeSymbol* base);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
void vala_class_set_ref_function (ValaClass* self, const char* name);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_class_set_ref_function_void (ValaClass* self, gboolean value);
void vala_class_set_unref_function (ValaClass* self, const char* name);
void vala_class_set_ref_sink_function (ValaClass* self, const char* name);
void vala_class_set_dup_function (ValaClass* self, const char* name);
void vala_class_set_free_function (ValaClass* self, const char* name);
static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value);
void vala_typesymbol_add_cheader_filename (ValaTypeSymbol* self, const char* filename);
void vala_class_set_type_check_function (ValaClass* self, const char* value);
static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_class_set_is_compact (ValaClass* self, gboolean value);
void vala_class_set_is_immutable (ValaClass* self, gboolean value);
void vala_class_process_attributes (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
char* vala_typesymbol_get_upper_case_cname (ValaTypeSymbol* self, const char* infix);
static char* vala_class_real_get_type_id (ValaTypeSymbol* base);
void vala_class_set_type_id (ValaClass* self, const char* type_id);
ValaClass* vala_class_get_base_class (ValaClass* self);
char* vala_typesymbol_get_marshaller_type_name (ValaTypeSymbol* self);
static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base);
char* vala_typesymbol_get_param_spec_function (ValaTypeSymbol* self);
static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base);
void vala_class_set_param_spec_function (ValaClass* self, const char* name);
gboolean vala_class_is_fundamental (ValaClass* self);
char* vala_typesymbol_get_get_value_function (ValaTypeSymbol* self);
char* vala_typesymbol_get_type_id (ValaTypeSymbol* self);
static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_set_value_function (ValaTypeSymbol* self);
static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_function (ValaTypeSymbol* self);
static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base);
static char* vala_class_real_get_ref_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_unref_function (ValaTypeSymbol* self);
static char* vala_class_real_get_unref_function (ValaTypeSymbol* base);
char* vala_typesymbol_get_ref_sink_function (ValaTypeSymbol* self);
static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base);
static char* vala_class_real_get_dup_function (ValaTypeSymbol* base);
char* vala_class_get_default_free_function (ValaClass* self);
char* vala_typesymbol_get_free_function (ValaTypeSymbol* self);
static char* vala_class_real_get_free_function (ValaTypeSymbol* base);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_typesymbol_is_subtype_of (ValaTypeSymbol* self, ValaTypeSymbol* t);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_interface_get_type (void);
GeeList* vala_interface_get_prerequisites (ValaInterface* self);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, GeeList* list);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
GType vala_namespace_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_block_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_loop_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_member_access_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
GType vala_value_type_get_type (void);
GType vala_struct_value_type_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
GeeList* vala_object_type_symbol_get_methods (ValaObjectTypeSymbol* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
GeeList* vala_object_type_symbol_get_properties (ValaObjectTypeSymbol* self);
gboolean vala_property_get_is_abstract (ValaProperty* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
ValaSymbol* vala_semantic_analyzer_symbol_lookup_inherited (ValaSymbol* sym, const char* name);
gboolean vala_method_get_overrides (ValaMethod* self);
gboolean vala_property_get_overrides (ValaProperty* self);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
void vala_class_set_base_class (ValaClass* self, ValaClass* value);
void vala_class_set_is_abstract (ValaClass* self, gboolean value);
gboolean vala_class_get_ref_function_void (ValaClass* self);
const char* vala_class_get_type_check_function (ValaClass* self);
gboolean vala_class_get_has_private_fields (ValaClass* self);
gboolean vala_class_get_has_class_private_fields (ValaClass* self);
gboolean vala_class_get_free_function_address_of (ValaClass* self);
ValaMethod* vala_class_get_default_construction_method (ValaClass* self);
void vala_class_set_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value);
void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value);
ValaFormalParameter* vala_destructor_get_this_parameter (ValaDestructor* self);
void vala_destructor_set_this_parameter (ValaDestructor* self, ValaFormalParameter* value);
void vala_class_set_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value);
void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value);
gboolean vala_class_get_is_error_base (ValaClass* self);
static void vala_class_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
GeeList* vala_class_get_classes (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->classes);
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
GeeList* vala_class_get_structs (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->structs);
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
GeeList* vala_class_get_enums (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->enums);
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
GeeList* vala_class_get_delegates (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->delegates);
	return result;
}


/**
 * Creates a new class.
 *
 * @param name   type name
 * @param source reference to source code
 * @return       newly created class
 */
ValaClass* vala_class_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaClass* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference);
	return self;
}


ValaClass* vala_class_new (const char* name, ValaSourceReference* source_reference) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	gee_collection_add ((GeeCollection*) self->priv->base_types, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
GeeList* vala_class_get_base_types (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->base_types);
	return result;
}


/**
 * Adds the specified constant as a member to this class.
 *
 * @param c a constant
 */
void vala_class_add_constant (ValaClass* self, ValaConstant* c) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	gee_collection_add ((GeeCollection*) self->priv->constants, c);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) c), (ValaSymbol*) c);
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
void vala_class_add_field (ValaClass* self, ValaField* f) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (f != NULL);
	gee_collection_add ((GeeCollection*) self->priv->fields, f);
	_tmp0_ = FALSE;
	if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		_tmp0_ = vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp1_;
		_tmp1_ = FALSE;
		if (vala_symbol_get_access ((ValaSymbol*) f) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			_tmp1_ = vala_field_get_binding (f) == MEMBER_BINDING_CLASS;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) f), (ValaSymbol*) f);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
GeeList* vala_class_get_fields (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->fields);
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
GeeList* vala_class_get_constants (ValaClass* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->constants);
	return result;
}


static ValaObjectType* vala_class_get_this_type (ValaClass* self) {
	ValaObjectType* result;
	ValaObjectType* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _type_parameter_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_type_parameter_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaTypeParameter* type_parameter;
			ValaGenericType* type_arg;
			if (!gee_iterator_next (_type_parameter_it)) {
				break;
			}
			type_parameter = (ValaTypeParameter*) gee_iterator_get (_type_parameter_it);
			type_arg = vala_generic_type_new (type_parameter);
			vala_data_type_set_value_owned ((ValaDataType*) type_arg, TRUE);
			vala_data_type_add_type_argument ((ValaDataType*) _result_, (ValaDataType*) type_arg);
			(type_parameter == NULL) ? NULL : (type_parameter = (vala_code_node_unref (type_parameter), NULL));
			(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
		}
		(_type_parameter_it == NULL) ? NULL : (_type_parameter_it = (gee_collection_object_unref (_type_parameter_it), NULL));
	}
	result = _result_;
	return result;
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
void vala_class_add_method (ValaClass* self, ValaMethod* m) {
	gboolean _tmp0_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = FALSE;
	if (vala_method_get_binding (m) == MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaFormalParameter* _tmp2_;
		ValaObjectType* _tmp1_;
		if (vala_method_get_this_parameter (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)));
		}
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		vala_method_set_this_parameter (m, _tmp2_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp1_ = vala_class_get_this_type (self)), NULL));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
		(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_this_parameter (m)), (ValaSymbol*) vala_method_get_this_parameter (m));
	}
	_tmp3_ = FALSE;
	if (!VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		GeeList* _tmp4_;
		_tmp4_ = NULL;
		_tmp3_ = gee_collection_get_size ((GeeCollection*) (_tmp4_ = vala_method_get_postconditions (m))) > 0;
		(_tmp4_ == NULL) ? NULL : (_tmp4_ = (gee_collection_object_unref (_tmp4_), NULL));
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaLocalVariable* _tmp6_;
		ValaDataType* _tmp5_;
		if (vala_method_get_result_var (m) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) m), vala_symbol_get_name ((ValaSymbol*) vala_method_get_result_var (m)));
		}
		_tmp6_ = NULL;
		_tmp5_ = NULL;
		vala_method_set_result_var (m, _tmp6_ = vala_local_variable_new (_tmp5_ = vala_data_type_copy (vala_method_get_return_type (m)), "result", NULL, NULL));
		(_tmp6_ == NULL) ? NULL : (_tmp6_ = (vala_code_node_unref (_tmp6_), NULL));
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (vala_code_node_unref (_tmp5_), NULL));
		vala_local_variable_set_is_result (vala_method_get_result_var (m), TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaCreationMethod* _tmp7_;
		ValaCreationMethod* cm;
		gboolean _tmp8_;
		if (vala_symbol_get_name ((ValaSymbol*) m) == NULL) {
			vala_class_set_default_construction_method (self, m);
			vala_symbol_set_name ((ValaSymbol*) m, "new");
		}
		_tmp7_ = NULL;
		cm = (_tmp7_ = VALA_CREATION_METHOD (m), (_tmp7_ == NULL) ? NULL : vala_code_node_ref (_tmp7_));
		_tmp8_ = FALSE;
		if (vala_creation_method_get_class_name (cm) != NULL) {
			_tmp8_ = _vala_strcmp0 (vala_creation_method_get_class_name (cm), vala_symbol_get_name ((ValaSymbol*) self)) != 0;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			char* _tmp10_;
			char* _tmp9_;
			/* class_name is null for constructors generated by GIdlParser*/
			_tmp10_ = NULL;
			_tmp9_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) m), _tmp10_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self), vala_creation_method_get_class_name (cm)));
			_tmp10_ = (g_free (_tmp10_), NULL);
			_tmp9_ = (g_free (_tmp9_), NULL);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
			return;
		}
		(cm == NULL) ? NULL : (cm = (vala_code_node_unref (cm), NULL));
	}
	gee_collection_add ((GeeCollection*) self->priv->methods, m);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) m), (ValaSymbol*) m);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static GeeList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->methods);
	return result;
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
void vala_class_add_property (ValaClass* self, ValaProperty* prop) {
	ValaFormalParameter* _tmp1_;
	ValaObjectType* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	gee_collection_add ((GeeCollection*) self->priv->properties, prop);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) prop), (ValaSymbol*) prop);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	vala_property_set_this_parameter (prop, _tmp1_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp0_ = vala_class_get_this_type (self)), NULL));
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL));
	(_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL));
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) prop), vala_symbol_get_name ((ValaSymbol*) vala_property_get_this_parameter (prop)), (ValaSymbol*) vala_property_get_this_parameter (prop));
	if (vala_property_get_field (prop) != NULL) {
		vala_class_add_field (self, vala_property_get_field (prop));
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static GeeList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->properties);
	return result;
}


/**
 * Adds the specified signal as a member to this class.
 *
 * @param sig a signal
 */
void vala_class_add_signal (ValaClass* self, ValaSignal* sig) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	gee_collection_add ((GeeCollection*) self->priv->signals, sig);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) sig), (ValaSymbol*) sig);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static GeeList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	GeeList* result;
	self = (ValaClass*) base;
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->signals);
	return result;
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
void vala_class_add_class (ValaClass* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	gee_collection_add ((GeeCollection*) self->priv->classes, cl);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) cl), (ValaSymbol*) cl);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
void vala_class_add_struct (ValaClass* self, ValaStruct* st) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (st != NULL);
	gee_collection_add ((GeeCollection*) self->priv->structs, st);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) st), (ValaSymbol*) st);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
void vala_class_add_enum (ValaClass* self, ValaEnum* en) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (en != NULL);
	gee_collection_add ((GeeCollection*) self->priv->enums, en);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) en), (ValaSymbol*) en);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
void vala_class_add_delegate (ValaClass* self, ValaDelegate* d) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (d != NULL);
	gee_collection_add ((GeeCollection*) self->priv->delegates, d);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) d), (ValaSymbol*) d);
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		GeeIterator* _type_it;
		_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* type;
			if (!gee_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) gee_iterator_get (_type_it);
			vala_code_node_accept ((ValaCodeNode*) type, visitor);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		}
		(_type_it == NULL) ? NULL : (_type_it = (gee_collection_object_unref (_type_it), NULL));
	}
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _p_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_p_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_accept ((ValaCodeNode*) p, visitor);
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	/* process enums first to avoid order problems in C code */
	{
		GeeIterator* _en_it;
		/* process enums first to avoid order problems in C code */
		_en_it = gee_iterable_iterator ((GeeIterable*) self->priv->enums);
		/* process enums first to avoid order problems in C code */
		while (TRUE) {
			ValaEnum* en;
			/* process enums first to avoid order problems in C code */
			if (!gee_iterator_next (_en_it)) {
				/* process enums first to avoid order problems in C code */
				break;
			}
			/* process enums first to avoid order problems in C code */
			en = (ValaEnum*) gee_iterator_get (_en_it);
			vala_code_node_accept ((ValaCodeNode*) en, visitor);
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
		}
		(_en_it == NULL) ? NULL : (_en_it = (gee_collection_object_unref (_en_it), NULL));
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_accept ((ValaCodeNode*) f, visitor);
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_accept ((ValaCodeNode*) c, visitor);
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		}
		(_c_it == NULL) ? NULL : (_c_it = (gee_collection_object_unref (_c_it), NULL));
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_accept ((ValaCodeNode*) m, visitor);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			vala_code_node_accept ((ValaCodeNode*) prop, visitor);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	{
		GeeIterator* _sig_it;
		_sig_it = gee_iterable_iterator ((GeeIterable*) self->priv->signals);
		while (TRUE) {
			ValaSignal* sig;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			vala_code_node_accept ((ValaCodeNode*) sig, visitor);
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_constructor, visitor);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_constructor, visitor);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_constructor, visitor);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_class_get_destructor (self), visitor);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_static_destructor, visitor);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_class_destructor, visitor);
	}
	{
		GeeIterator* _cl_it;
		_cl_it = gee_iterable_iterator ((GeeIterable*) self->priv->classes);
		while (TRUE) {
			ValaClass* cl;
			if (!gee_iterator_next (_cl_it)) {
				break;
			}
			cl = (ValaClass*) gee_iterator_get (_cl_it);
			vala_code_node_accept ((ValaCodeNode*) cl, visitor);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		}
		(_cl_it == NULL) ? NULL : (_cl_it = (gee_collection_object_unref (_cl_it), NULL));
	}
	{
		GeeIterator* _st_it;
		_st_it = gee_iterable_iterator ((GeeIterable*) self->priv->structs);
		while (TRUE) {
			ValaStruct* st;
			if (!gee_iterator_next (_st_it)) {
				break;
			}
			st = (ValaStruct*) gee_iterator_get (_st_it);
			vala_code_node_accept ((ValaCodeNode*) st, visitor);
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(_st_it == NULL) ? NULL : (_st_it = (gee_collection_object_unref (_st_it), NULL));
	}
	{
		GeeIterator* _d_it;
		_d_it = gee_iterable_iterator ((GeeIterable*) self->priv->delegates);
		while (TRUE) {
			ValaDelegate* d;
			if (!gee_iterator_next (_d_it)) {
				break;
			}
			d = (ValaDelegate*) gee_iterator_get (_d_it);
			vala_code_node_accept ((ValaCodeNode*) d, visitor);
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
		(_d_it == NULL) ? NULL : (_d_it = (gee_collection_object_unref (_d_it), NULL));
	}
}


static char* vala_class_real_get_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result;
	self = (ValaClass*) base;
	result = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE);
	return result;
}


static char* vala_class_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaClass * self;
	char* result;
	const char* _tmp5_;
	self = (ValaClass*) base;
	if (const_type) {
		if (self->priv->const_cname != NULL) {
			const char* _tmp0_;
			_tmp0_ = NULL;
			result = (_tmp0_ = self->priv->const_cname, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
			return result;
		} else {
			if (vala_class_get_is_immutable (self)) {
				char* _tmp1_;
				char* _tmp2_;
				_tmp1_ = NULL;
				_tmp2_ = NULL;
				result = (_tmp2_ = g_strconcat ("const ", _tmp1_ = vala_typesymbol_get_cname ((ValaTypeSymbol*) self, FALSE), NULL), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
				return result;
			}
		}
	}
	if (self->priv->cname == NULL) {
		ValaAttribute* attr;
		attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "CCode");
		if (attr != NULL) {
			char* _tmp3_;
			_tmp3_ = NULL;
			self->priv->cname = (_tmp3_ = vala_attribute_get_string (attr, "cname"), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp3_);
		}
		if (self->priv->cname == NULL) {
			char* _tmp4_;
			_tmp4_ = NULL;
			self->priv->cname = (_tmp4_ = vala_class_get_default_cname (self), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp4_);
		}
		(attr == NULL) ? NULL : (attr = (vala_code_node_unref (attr), NULL));
	}
	_tmp5_ = NULL;
	result = (_tmp5_ = self->priv->cname, (_tmp5_ == NULL) ? NULL : g_strdup (_tmp5_));
	return result;
}


/**
 * Returns the default name of this class as it is used in C code.
 *
 * @return the name to be used in C code by default
 */
char* vala_class_get_default_cname (ValaClass* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strdup_printf ("%s%s", _tmp0_ = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


/**
 * Sets the name of this class as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_class_set_cname (ValaClass* self, const char* cname) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->cname = (_tmp1_ = (_tmp0_ = cname, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp1_);
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* vala_class_get_lower_case_csuffix (ValaClass* self) {
	char* result;
	const char* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->lower_case_csuffix == NULL) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->lower_case_csuffix = (_tmp0_ = vala_symbol_camel_case_to_lower_case (vala_symbol_get_name ((ValaSymbol*) self)), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp0_);
		/* remove underscores in some cases to avoid conflicts of type macros*/
		if (g_str_has_prefix (self->priv->lower_case_csuffix, "type_")) {
			char* _tmp1_;
			_tmp1_ = NULL;
			self->priv->lower_case_csuffix = (_tmp1_ = g_strconcat ("type", g_utf8_offset_to_pointer (self->priv->lower_case_csuffix, g_utf8_strlen ("type_", -1)), NULL), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp1_);
		} else {
			if (g_str_has_prefix (self->priv->lower_case_csuffix, "is_")) {
				char* _tmp2_;
				_tmp2_ = NULL;
				self->priv->lower_case_csuffix = (_tmp2_ = g_strconcat ("is", g_utf8_offset_to_pointer (self->priv->lower_case_csuffix, g_utf8_strlen ("is_", -1)), NULL), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp2_);
			}
		}
		if (g_str_has_suffix (self->priv->lower_case_csuffix, "_class")) {
			char* _tmp4_;
			char* _tmp3_;
			_tmp4_ = NULL;
			_tmp3_ = NULL;
			self->priv->lower_case_csuffix = (_tmp4_ = g_strconcat (_tmp3_ = string_substring (self->priv->lower_case_csuffix, (glong) 0, g_utf8_strlen (self->priv->lower_case_csuffix, -1) - g_utf8_strlen ("_class", -1)), "class", NULL), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp4_);
			_tmp3_ = (g_free (_tmp3_), NULL);
		}
	}
	_tmp5_ = NULL;
	result = (_tmp5_ = self->priv->lower_case_csuffix, (_tmp5_ == NULL) ? NULL : g_strdup (_tmp5_));
	return result;
}


static char* vala_class_real_get_lower_case_cname (ValaSymbol* base, const char* infix) {
	ValaClass * self;
	char* result;
	char* _tmp1_;
	char* _tmp0_;
	char* _tmp2_;
	self = (ValaClass*) base;
	if (infix == NULL) {
		infix = "";
	}
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	_tmp2_ = NULL;
	result = (_tmp2_ = g_strdup_printf ("%s%s%s", _tmp0_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), infix, _tmp1_ = vala_class_get_lower_case_csuffix (self)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp2_);
	return result;
}


static char* vala_class_real_get_lower_case_cprefix (ValaSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp2_;
	self = (ValaClass*) base;
	if (self->priv->lower_case_cprefix == NULL) {
		char* _tmp1_;
		char* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->lower_case_cprefix = (_tmp1_ = g_strdup_printf ("%s_", _tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, NULL)), self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL), _tmp1_);
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->lower_case_cprefix, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


static char* vala_class_real_get_upper_case_cname (ValaTypeSymbol* base, const char* infix) {
	ValaClass * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_utf8_strup (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, infix), -1), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_real_get_type_signature (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->type_signature, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


static void vala_class_process_ccode_attribute (ValaClass* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "ref_function")) {
		char* _tmp0_;
		_tmp0_ = NULL;
		vala_class_set_ref_function (self, _tmp0_ = vala_attribute_get_string (a, "ref_function"));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	if (vala_attribute_has_argument (a, "ref_function_void")) {
		vala_class_set_ref_function_void (self, vala_attribute_get_bool (a, "ref_function_void"));
	}
	if (vala_attribute_has_argument (a, "unref_function")) {
		char* _tmp1_;
		_tmp1_ = NULL;
		vala_class_set_unref_function (self, _tmp1_ = vala_attribute_get_string (a, "unref_function"));
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	if (vala_attribute_has_argument (a, "ref_sink_function")) {
		char* _tmp2_;
		_tmp2_ = NULL;
		vala_class_set_ref_sink_function (self, _tmp2_ = vala_attribute_get_string (a, "ref_sink_function"));
		_tmp2_ = (g_free (_tmp2_), NULL);
	}
	if (vala_attribute_has_argument (a, "copy_function")) {
		char* _tmp3_;
		_tmp3_ = NULL;
		vala_class_set_dup_function (self, _tmp3_ = vala_attribute_get_string (a, "copy_function"));
		_tmp3_ = (g_free (_tmp3_), NULL);
	}
	if (vala_attribute_has_argument (a, "free_function")) {
		char* _tmp4_;
		_tmp4_ = NULL;
		vala_class_set_free_function (self, _tmp4_ = vala_attribute_get_string (a, "free_function"));
		_tmp4_ = (g_free (_tmp4_), NULL);
	}
	if (vala_attribute_has_argument (a, "free_function_address_of")) {
		vala_class_set_free_function_address_of (self, vala_attribute_get_bool (a, "free_function_address_of"));
	}
	if (vala_attribute_has_argument (a, "type_id")) {
		char* _tmp5_;
		_tmp5_ = NULL;
		self->priv->type_id = (_tmp5_ = vala_attribute_get_string (a, "type_id"), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp5_);
	}
	if (vala_attribute_has_argument (a, "marshaller_type_name")) {
		char* _tmp6_;
		_tmp6_ = NULL;
		self->priv->marshaller_type_name = (_tmp6_ = vala_attribute_get_string (a, "marshaller_type_name"), self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL), _tmp6_);
	}
	if (vala_attribute_has_argument (a, "get_value_function")) {
		char* _tmp7_;
		_tmp7_ = NULL;
		self->priv->get_value_function = (_tmp7_ = vala_attribute_get_string (a, "get_value_function"), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp7_);
	}
	if (vala_attribute_has_argument (a, "set_value_function")) {
		char* _tmp8_;
		_tmp8_ = NULL;
		self->priv->set_value_function = (_tmp8_ = vala_attribute_get_string (a, "set_value_function"), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp8_);
	}
	if (vala_attribute_has_argument (a, "const_cname")) {
		char* _tmp9_;
		_tmp9_ = NULL;
		self->priv->const_cname = (_tmp9_ = vala_attribute_get_string (a, "const_cname"), self->priv->const_cname = (g_free (self->priv->const_cname), NULL), _tmp9_);
	}
	if (vala_attribute_has_argument (a, "cprefix")) {
		char* _tmp10_;
		_tmp10_ = NULL;
		self->priv->lower_case_cprefix = (_tmp10_ = vala_attribute_get_string (a, "cprefix"), self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL), _tmp10_);
	}
	if (vala_attribute_has_argument (a, "lower_case_csuffix")) {
		char* _tmp11_;
		_tmp11_ = NULL;
		self->priv->lower_case_csuffix = (_tmp11_ = vala_attribute_get_string (a, "lower_case_csuffix"), self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL), _tmp11_);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp12_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			_tmp12_ = NULL;
			filename_collection = _tmp12_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp12_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp12_); filename_it = filename_it + 1) {
				const char* _tmp13_;
				char* filename;
				_tmp13_ = NULL;
				filename = (_tmp13_ = filename_collection[filename_it], (_tmp13_ == NULL) ? NULL : g_strdup (_tmp13_));
				{
					vala_typesymbol_add_cheader_filename ((ValaTypeSymbol*) self, filename);
					filename = (g_free (filename), NULL);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		val = (g_free (val), NULL);
	}
	if (vala_attribute_has_argument (a, "type_signature")) {
		char* _tmp14_;
		_tmp14_ = NULL;
		self->priv->type_signature = (_tmp14_ = vala_attribute_get_string (a, "type_signature"), self->priv->type_signature = (g_free (self->priv->type_signature), NULL), _tmp14_);
	}
	if (vala_attribute_has_argument (a, "type_check_function")) {
		char* _tmp15_;
		_tmp15_ = NULL;
		vala_class_set_type_check_function (self, _tmp15_ = vala_attribute_get_string (a, "type_check_function"));
		_tmp15_ = (g_free (_tmp15_), NULL);
	}
	if (vala_attribute_has_argument (a, "param_spec_function")) {
		char* _tmp16_;
		_tmp16_ = NULL;
		self->priv->param_spec_function = (_tmp16_ = vala_attribute_get_string (a, "param_spec_function"), self->priv->param_spec_function = (g_free (self->priv->param_spec_function), NULL), _tmp16_);
	}
}


/**
 * Process all associated attributes.
 */
void vala_class_process_attributes (ValaClass* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = NULL;
			a = (_tmp0_ = (ValaAttribute*) a_it->data, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_class_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "Compact") == 0) {
						vala_class_set_is_compact (self, TRUE);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "Immutable") == 0) {
							vala_class_set_is_immutable (self, TRUE);
						}
					}
				}
				(a == NULL) ? NULL : (a = (vala_code_node_unref (a), NULL));
			}
		}
	}
}


static char* vala_class_real_get_type_id (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp2_;
	self = (ValaClass*) base;
	if (self->priv->type_id == NULL) {
		if (!vala_class_get_is_compact (self)) {
			char* _tmp0_;
			_tmp0_ = NULL;
			self->priv->type_id = (_tmp0_ = vala_typesymbol_get_upper_case_cname ((ValaTypeSymbol*) self, "TYPE_"), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp0_);
		} else {
			char* _tmp1_;
			_tmp1_ = NULL;
			self->priv->type_id = (_tmp1_ = g_strdup ("G_TYPE_POINTER"), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp1_);
		}
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->type_id, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


void vala_class_set_type_id (ValaClass* self, const char* type_id) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_id != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->type_id = (_tmp1_ = (_tmp0_ = type_id, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->type_id = (g_free (self->priv->type_id), NULL), _tmp1_);
}


static char* vala_class_real_get_marshaller_type_name (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp2_;
	self = (ValaClass*) base;
	if (self->priv->marshaller_type_name == NULL) {
		if (self->priv->_base_class != NULL) {
			char* _tmp0_;
			_tmp0_ = NULL;
			self->priv->marshaller_type_name = (_tmp0_ = vala_typesymbol_get_marshaller_type_name ((ValaTypeSymbol*) self->priv->_base_class), self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL), _tmp0_);
		} else {
			char* _tmp1_;
			_tmp1_ = NULL;
			self->priv->marshaller_type_name = (_tmp1_ = g_strdup ("POINTER"), self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL), _tmp1_);
		}
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->marshaller_type_name, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


static char* vala_class_real_get_param_spec_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp2_;
	self = (ValaClass*) base;
	if (self->priv->param_spec_function == NULL) {
		gboolean _tmp0_;
		_tmp0_ = FALSE;
		if (vala_class_get_is_compact (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = self->priv->_base_class == NULL;
		}
		if (!_tmp0_) {
			char* _tmp1_;
			_tmp1_ = NULL;
			self->priv->param_spec_function = (_tmp1_ = vala_typesymbol_get_param_spec_function ((ValaTypeSymbol*) self->priv->_base_class), self->priv->param_spec_function = (g_free (self->priv->param_spec_function), NULL), _tmp1_);
		}
	}
	_tmp2_ = NULL;
	result = (_tmp2_ = self->priv->param_spec_function, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
	return result;
}


void vala_class_set_param_spec_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->param_spec_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->param_spec_function = (g_free (self->priv->param_spec_function), NULL), _tmp1_);
}


static char* vala_class_real_get_get_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp6_;
	self = (ValaClass*) base;
	if (self->priv->get_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			_tmp0_ = NULL;
			self->priv->get_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_get_"), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				_tmp1_ = NULL;
				self->priv->get_value_function = (_tmp1_ = vala_typesymbol_get_get_value_function ((ValaTypeSymbol*) self->priv->_base_class), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				_tmp2_ = NULL;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_)) {
					char* _tmp4_;
					_tmp4_ = NULL;
					self->priv->get_value_function = (_tmp4_ = g_strdup ("g_value_get_pointer"), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp4_);
				} else {
					char* _tmp5_;
					_tmp5_ = NULL;
					self->priv->get_value_function = (_tmp5_ = g_strdup ("g_value_get_boxed"), self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL), _tmp5_);
				}
			}
		}
	}
	_tmp6_ = NULL;
	result = (_tmp6_ = self->priv->get_value_function, (_tmp6_ == NULL) ? NULL : g_strdup (_tmp6_));
	return result;
}


static char* vala_class_real_get_set_value_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp6_;
	self = (ValaClass*) base;
	if (self->priv->set_value_function == NULL) {
		if (vala_class_is_fundamental (self)) {
			char* _tmp0_;
			_tmp0_ = NULL;
			self->priv->set_value_function = (_tmp0_ = vala_symbol_get_lower_case_cname ((ValaSymbol*) self, "value_set_"), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp0_);
		} else {
			if (self->priv->_base_class != NULL) {
				char* _tmp1_;
				_tmp1_ = NULL;
				self->priv->set_value_function = (_tmp1_ = vala_typesymbol_get_set_value_function ((ValaTypeSymbol*) self->priv->_base_class), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp1_);
			} else {
				char* _tmp2_;
				gboolean _tmp3_;
				_tmp2_ = NULL;
				if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = vala_typesymbol_get_type_id ((ValaTypeSymbol*) self), "G_TYPE_POINTER") == 0, _tmp2_ = (g_free (_tmp2_), NULL), _tmp3_)) {
					char* _tmp4_;
					_tmp4_ = NULL;
					self->priv->set_value_function = (_tmp4_ = g_strdup ("g_value_set_pointer"), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp4_);
				} else {
					char* _tmp5_;
					_tmp5_ = NULL;
					self->priv->set_value_function = (_tmp5_ = g_strdup ("g_value_set_boxed"), self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL), _tmp5_);
				}
			}
		}
	}
	_tmp6_ = NULL;
	result = (_tmp6_ = self->priv->set_value_function, (_tmp6_ == NULL) ? NULL : g_strdup (_tmp6_));
	return result;
}


static gboolean vala_class_real_is_reference_counting (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result;
	char* _tmp0_;
	gboolean _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = NULL;
	result = (_tmp1_ = (_tmp0_ = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self)) != NULL, _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = FALSE;
	if (!vala_class_get_is_compact (self)) {
		_tmp0_ = self->priv->_base_class == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static char* vala_class_real_get_ref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	gboolean _tmp3_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->ref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		self->priv->ref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "ref", NULL), self->priv->ref_function = (g_free (self->priv->ref_function), NULL), _tmp2_);
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	_tmp3_ = FALSE;
	if (self->priv->ref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_ref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		const char* _tmp4_;
		_tmp4_ = NULL;
		result = (_tmp4_ = self->priv->ref_function, (_tmp4_ == NULL) ? NULL : g_strdup (_tmp4_));
		return result;
	}
}


void vala_class_set_ref_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->ref_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->ref_function = (g_free (self->priv->ref_function), NULL), _tmp1_);
}


static char* vala_class_real_get_unref_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	gboolean _tmp3_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->unref_function == NULL) {
		_tmp0_ = vala_class_is_fundamental (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		_tmp2_ = NULL;
		_tmp1_ = NULL;
		self->priv->unref_function = (_tmp2_ = g_strconcat (_tmp1_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "unref", NULL), self->priv->unref_function = (g_free (self->priv->unref_function), NULL), _tmp2_);
		_tmp1_ = (g_free (_tmp1_), NULL);
	}
	_tmp3_ = FALSE;
	if (self->priv->unref_function == NULL) {
		_tmp3_ = self->priv->_base_class != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = vala_typesymbol_get_unref_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		const char* _tmp4_;
		_tmp4_ = NULL;
		result = (_tmp4_ = self->priv->unref_function, (_tmp4_ == NULL) ? NULL : g_strdup (_tmp4_));
		return result;
	}
}


void vala_class_set_unref_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->unref_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->unref_function = (g_free (self->priv->unref_function), NULL), _tmp1_);
}


static char* vala_class_real_get_ref_sink_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	gboolean _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = FALSE;
	if (self->priv->ref_sink_function == NULL) {
		_tmp0_ = self->priv->_base_class != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = vala_typesymbol_get_ref_sink_function ((ValaTypeSymbol*) self->priv->_base_class);
		return result;
	} else {
		const char* _tmp1_;
		_tmp1_ = NULL;
		result = (_tmp1_ = self->priv->ref_sink_function, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
		return result;
	}
}


void vala_class_set_ref_sink_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->ref_sink_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->ref_sink_function = (g_free (self->priv->ref_sink_function), NULL), _tmp1_);
}


static char* vala_class_real_get_dup_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp0_;
	self = (ValaClass*) base;
	_tmp0_ = NULL;
	result = (_tmp0_ = self->priv->copy_function, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_));
	return result;
}


void vala_class_set_dup_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->copy_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->copy_function = (g_free (self->priv->copy_function), NULL), _tmp1_);
}


char* vala_class_get_default_free_function (ValaClass* self) {
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = NULL;
	_tmp1_ = NULL;
	result = (_tmp1_ = g_strconcat (_tmp0_ = vala_symbol_get_lower_case_cprefix ((ValaSymbol*) self), "free", NULL), _tmp0_ = (g_free (_tmp0_), NULL), _tmp1_);
	return result;
}


static char* vala_class_real_get_free_function (ValaTypeSymbol* base) {
	ValaClass * self;
	char* result;
	const char* _tmp1_;
	self = (ValaClass*) base;
	if (self->priv->free_function == NULL) {
		char* _tmp0_;
		if (self->priv->_base_class != NULL) {
			result = vala_typesymbol_get_free_function ((ValaTypeSymbol*) self->priv->_base_class);
			return result;
		}
		_tmp0_ = NULL;
		self->priv->free_function = (_tmp0_ = vala_class_get_default_free_function (self), self->priv->free_function = (g_free (self->priv->free_function), NULL), _tmp0_);
	}
	_tmp1_ = NULL;
	result = (_tmp1_ = self->priv->free_function, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	return result;
}


void vala_class_set_free_function (ValaClass* self, const char* name) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->free_function = (_tmp1_ = (_tmp0_ = name, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->free_function = (g_free (self->priv->free_function), NULL), _tmp1_);
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (self) == t) {
		result = TRUE;
		return result;
	}
	{
		GeeIterator* _base_type_it;
		_base_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* base_type;
			gboolean _tmp0_;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			_tmp0_ = FALSE;
			if (vala_data_type_get_data_type (base_type) != NULL) {
				_tmp0_ = vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (base_type), t);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = TRUE;
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
				(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
				return result;
			}
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) self->priv->base_types))) {
					break;
				}
				_tmp1_ = NULL;
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) gee_list_get (self->priv->base_types, i)) == old_type, (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL)), _tmp2_)) {
					gee_list_set (self->priv->base_types, i, new_type);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, GeeList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _prereq_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_prereq_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_interface_get_prerequisites (iface))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaDataType* prereq;
			ValaTypeSymbol* _tmp2_;
			ValaTypeSymbol* type;
			if (!gee_iterator_next (_prereq_it)) {
				break;
			}
			prereq = (ValaDataType*) gee_iterator_get (_prereq_it);
			_tmp2_ = NULL;
			type = (_tmp2_ = vala_data_type_get_data_type (prereq), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
			/* skip on previous errors */
			if (type == NULL) {
				(prereq == NULL) ? NULL : (prereq = (vala_code_node_unref (prereq), NULL));
				(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
				continue;
			}
			gee_collection_add ((GeeCollection*) list, type);
			if (VALA_IS_INTERFACE (type)) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (type), list);
			}
			(prereq == NULL) ? NULL : (prereq = (vala_code_node_unref (prereq), NULL));
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		}
		(_prereq_it == NULL) ? NULL : (_prereq_it = (gee_collection_object_unref (_prereq_it), NULL));
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (VALA_TYPESYMBOL (cl) == t) {
		result = TRUE;
		return result;
	}
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _base_type_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_base_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (cl))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaDataType* base_type;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (VALA_IS_CLASS (vala_data_type_get_data_type (base_type))) {
				if (vala_class_class_is_a (self, VALA_CLASS (vala_data_type_get_data_type (base_type)), t)) {
					result = TRUE;
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
					return result;
				}
			} else {
				if (vala_data_type_get_data_type (base_type) == t) {
					result = TRUE;
					(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
					(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
					return result;
				}
			}
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	result = FALSE;
	return result;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaClass * self;
	gboolean result;
	ValaSourceFile* _tmp0_;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp1_;
	ValaSymbol* old_symbol;
	ValaClass* _tmp2_;
	ValaClass* old_class;
	ValaClass* _tmp4_;
	ValaClass* _tmp3_;
	GeeList* prerequisites;
	GeeList* missing_prereqs;
	ValaClass* _tmp72_;
	ValaClass* _tmp71_;
	self = (ValaClass*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_class_process_attributes (self);
	_tmp0_ = NULL;
	old_source_file = (_tmp0_ = vala_semantic_analyzer_get_current_source_file (analyzer), (_tmp0_ == NULL) ? NULL : vala_source_file_ref (_tmp0_));
	_tmp1_ = NULL;
	old_symbol = (_tmp1_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	_tmp2_ = NULL;
	old_class = (_tmp2_ = analyzer->current_class, (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	_tmp4_ = NULL;
	_tmp3_ = NULL;
	analyzer->current_class = (_tmp4_ = (_tmp3_ = self, (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp4_);
	{
		GeeList* _tmp5_;
		GeeIterator* _tmp6_;
		GeeIterator* _base_type_reference_it;
		_tmp5_ = NULL;
		_tmp6_ = NULL;
		_base_type_reference_it = (_tmp6_ = gee_iterable_iterator ((GeeIterable*) (_tmp5_ = vala_class_get_base_types (self))), (_tmp5_ == NULL) ? NULL : (_tmp5_ = (gee_collection_object_unref (_tmp5_), NULL)), _tmp6_);
		while (TRUE) {
			ValaDataType* base_type_reference;
			if (!gee_iterator_next (_base_type_reference_it)) {
				break;
			}
			base_type_reference = (ValaDataType*) gee_iterator_get (_base_type_reference_it);
			if (!vala_code_node_check ((ValaCodeNode*) base_type_reference, analyzer)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				(base_type_reference == NULL) ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL));
				(_base_type_reference_it == NULL) ? NULL : (_base_type_reference_it = (gee_collection_object_unref (_base_type_reference_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				return result;
			}
			if (!VALA_IS_OBJECT_TYPE (base_type_reference)) {
				char* _tmp9_;
				char* _tmp8_;
				char* _tmp7_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp9_ = NULL;
				_tmp8_ = NULL;
				_tmp7_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp9_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp7_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_tmp9_ = (g_free (_tmp9_), NULL);
				_tmp8_ = (g_free (_tmp8_), NULL);
				_tmp7_ = (g_free (_tmp7_), NULL);
				result = FALSE;
				(base_type_reference == NULL) ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL));
				(_base_type_reference_it == NULL) ? NULL : (_base_type_reference_it = (gee_collection_object_unref (_base_type_reference_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				return result;
			}
			/* check whether base type is at least as accessible as the class*/
			if (!vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, base_type_reference)) {
				char* _tmp12_;
				char* _tmp11_;
				char* _tmp10_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp12_ = NULL;
				_tmp11_ = NULL;
				_tmp10_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp12_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp10_ = vala_code_node_to_string ((ValaCodeNode*) base_type_reference), _tmp11_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
				_tmp12_ = (g_free (_tmp12_), NULL);
				_tmp11_ = (g_free (_tmp11_), NULL);
				_tmp10_ = (g_free (_tmp10_), NULL);
				result = FALSE;
				(base_type_reference == NULL) ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL));
				(_base_type_reference_it == NULL) ? NULL : (_base_type_reference_it = (gee_collection_object_unref (_base_type_reference_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				return result;
			}
			(base_type_reference == NULL) ? NULL : (base_type_reference = (vala_code_node_unref (base_type_reference), NULL));
		}
		(_base_type_reference_it == NULL) ? NULL : (_base_type_reference_it = (gee_collection_object_unref (_base_type_reference_it), NULL));
	}
	{
		GeeIterator* _type_it;
		_type_it = gee_iterable_iterator ((GeeIterable*) self->priv->base_types);
		while (TRUE) {
			ValaDataType* type;
			if (!gee_iterator_next (_type_it)) {
				break;
			}
			type = (ValaDataType*) gee_iterator_get (_type_it);
			vala_code_node_check ((ValaCodeNode*) type, analyzer);
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		}
		(_type_it == NULL) ? NULL : (_type_it = (gee_collection_object_unref (_type_it), NULL));
	}
	{
		GeeList* _tmp13_;
		GeeIterator* _tmp14_;
		GeeIterator* _p_it;
		_tmp13_ = NULL;
		_tmp14_ = NULL;
		_p_it = (_tmp14_ = gee_iterable_iterator ((GeeIterable*) (_tmp13_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (gee_collection_object_unref (_tmp13_), NULL)), _tmp14_);
		while (TRUE) {
			ValaTypeParameter* p;
			if (!gee_iterator_next (_p_it)) {
				break;
			}
			p = (ValaTypeParameter*) gee_iterator_get (_p_it);
			vala_code_node_check ((ValaCodeNode*) p, analyzer);
			(p == NULL) ? NULL : (p = (vala_code_node_unref (p), NULL));
		}
		(_p_it == NULL) ? NULL : (_p_it = (gee_collection_object_unref (_p_it), NULL));
	}
	/* process enums first to avoid order problems in C code */
	{
		GeeIterator* _en_it;
		/* process enums first to avoid order problems in C code */
		_en_it = gee_iterable_iterator ((GeeIterable*) self->priv->enums);
		/* process enums first to avoid order problems in C code */
		while (TRUE) {
			ValaEnum* en;
			/* process enums first to avoid order problems in C code */
			if (!gee_iterator_next (_en_it)) {
				/* process enums first to avoid order problems in C code */
				break;
			}
			/* process enums first to avoid order problems in C code */
			en = (ValaEnum*) gee_iterator_get (_en_it);
			vala_code_node_check ((ValaCodeNode*) en, analyzer);
			(en == NULL) ? NULL : (en = (vala_code_node_unref (en), NULL));
		}
		(_en_it == NULL) ? NULL : (_en_it = (gee_collection_object_unref (_en_it), NULL));
	}
	{
		GeeIterator* _f_it;
		_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
		while (TRUE) {
			ValaField* f;
			if (!gee_iterator_next (_f_it)) {
				break;
			}
			f = (ValaField*) gee_iterator_get (_f_it);
			vala_code_node_check ((ValaCodeNode*) f, analyzer);
			(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
		}
		(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
	}
	{
		GeeIterator* _c_it;
		_c_it = gee_iterable_iterator ((GeeIterable*) self->priv->constants);
		while (TRUE) {
			ValaConstant* c;
			if (!gee_iterator_next (_c_it)) {
				break;
			}
			c = (ValaConstant*) gee_iterator_get (_c_it);
			vala_code_node_check ((ValaCodeNode*) c, analyzer);
			(c == NULL) ? NULL : (c = (vala_code_node_unref (c), NULL));
		}
		(_c_it == NULL) ? NULL : (_c_it = (gee_collection_object_unref (_c_it), NULL));
	}
	{
		GeeIterator* _m_it;
		_m_it = gee_iterable_iterator ((GeeIterable*) self->priv->methods);
		while (TRUE) {
			ValaMethod* m;
			if (!gee_iterator_next (_m_it)) {
				break;
			}
			m = (ValaMethod*) gee_iterator_get (_m_it);
			vala_code_node_check ((ValaCodeNode*) m, analyzer);
			(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
		}
		(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
	}
	{
		GeeIterator* _prop_it;
		_prop_it = gee_iterable_iterator ((GeeIterable*) self->priv->properties);
		while (TRUE) {
			ValaProperty* prop;
			if (!gee_iterator_next (_prop_it)) {
				break;
			}
			prop = (ValaProperty*) gee_iterator_get (_prop_it);
			vala_code_node_check ((ValaCodeNode*) prop, analyzer);
			(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
		}
		(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
	}
	{
		GeeIterator* _sig_it;
		_sig_it = gee_iterable_iterator ((GeeIterable*) self->priv->signals);
		while (TRUE) {
			ValaSignal* sig;
			if (!gee_iterator_next (_sig_it)) {
				break;
			}
			sig = (ValaSignal*) gee_iterator_get (_sig_it);
			vala_code_node_check ((ValaCodeNode*) sig, analyzer);
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
		(_sig_it == NULL) ? NULL : (_sig_it = (gee_collection_object_unref (_sig_it), NULL));
	}
	if (self->priv->_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_constructor, analyzer);
	}
	if (self->priv->_class_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_constructor, analyzer);
	}
	if (self->priv->_static_constructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_constructor, analyzer);
	}
	if (vala_class_get_destructor (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_class_get_destructor (self), analyzer);
	}
	if (self->priv->_static_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_static_destructor, analyzer);
	}
	if (self->priv->_class_destructor != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_class_destructor, analyzer);
	}
	{
		GeeIterator* _cl_it;
		_cl_it = gee_iterable_iterator ((GeeIterable*) self->priv->classes);
		while (TRUE) {
			ValaClass* cl;
			if (!gee_iterator_next (_cl_it)) {
				break;
			}
			cl = (ValaClass*) gee_iterator_get (_cl_it);
			vala_code_node_check ((ValaCodeNode*) cl, analyzer);
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		}
		(_cl_it == NULL) ? NULL : (_cl_it = (gee_collection_object_unref (_cl_it), NULL));
	}
	{
		GeeIterator* _st_it;
		_st_it = gee_iterable_iterator ((GeeIterable*) self->priv->structs);
		while (TRUE) {
			ValaStruct* st;
			if (!gee_iterator_next (_st_it)) {
				break;
			}
			st = (ValaStruct*) gee_iterator_get (_st_it);
			vala_code_node_check ((ValaCodeNode*) st, analyzer);
			(st == NULL) ? NULL : (st = (vala_code_node_unref (st), NULL));
		}
		(_st_it == NULL) ? NULL : (_st_it = (gee_collection_object_unref (_st_it), NULL));
	}
	{
		GeeIterator* _d_it;
		_d_it = gee_iterable_iterator ((GeeIterable*) self->priv->delegates);
		while (TRUE) {
			ValaDelegate* d;
			if (!gee_iterator_next (_d_it)) {
				break;
			}
			d = (ValaDelegate*) gee_iterator_get (_d_it);
			vala_code_node_check ((ValaCodeNode*) d, analyzer);
			(d == NULL) ? NULL : (d = (vala_code_node_unref (d), NULL));
		}
		(_d_it == NULL) ? NULL : (_d_it = (gee_collection_object_unref (_d_it), NULL));
	}
	/* compact classes cannot implement interfaces */
	if (vala_class_get_is_compact (self)) {
		gboolean _tmp19_;
		gboolean _tmp20_;
		{
			GeeList* _tmp15_;
			GeeIterator* _tmp16_;
			GeeIterator* _base_type_it;
			_tmp15_ = NULL;
			_tmp16_ = NULL;
			_base_type_it = (_tmp16_ = gee_iterable_iterator ((GeeIterable*) (_tmp15_ = vala_class_get_base_types (self))), (_tmp15_ == NULL) ? NULL : (_tmp15_ = (gee_collection_object_unref (_tmp15_), NULL)), _tmp16_);
			while (TRUE) {
				ValaDataType* base_type;
				if (!gee_iterator_next (_base_type_it)) {
					break;
				}
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					char* _tmp18_;
					char* _tmp17_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp18_ = NULL;
					_tmp17_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp18_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp17_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
					_tmp18_ = (g_free (_tmp18_), NULL);
					_tmp17_ = (g_free (_tmp17_), NULL);
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
		_tmp19_ = FALSE;
		_tmp20_ = FALSE;
		if (!vala_symbol_get_external ((ValaSymbol*) self)) {
			_tmp20_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			_tmp19_ = self->priv->_base_class != NULL;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			{
				GeeIterator* _f_it;
				_f_it = gee_iterable_iterator ((GeeIterable*) self->priv->fields);
				while (TRUE) {
					ValaField* f;
					if (!gee_iterator_next (_f_it)) {
						break;
					}
					f = (ValaField*) gee_iterator_get (_f_it);
					if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "derived compact classes may not have instance fields");
					}
					(f == NULL) ? NULL : (f = (vala_code_node_unref (f), NULL));
				}
				(_f_it == NULL) ? NULL : (_f_it = (gee_collection_object_unref (_f_it), NULL));
			}
		}
	}
	/* gather all prerequisites */
	prerequisites = (GeeList*) gee_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	{
		GeeList* _tmp21_;
		GeeIterator* _tmp22_;
		GeeIterator* _base_type_it;
		_tmp21_ = NULL;
		_tmp22_ = NULL;
		_base_type_it = (_tmp22_ = gee_iterable_iterator ((GeeIterable*) (_tmp21_ = vala_class_get_base_types (self))), (_tmp21_ == NULL) ? NULL : (_tmp21_ = (gee_collection_object_unref (_tmp21_), NULL)), _tmp22_);
		while (TRUE) {
			ValaDataType* base_type;
			if (!gee_iterator_next (_base_type_it)) {
				break;
			}
			base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
				vala_class_get_all_prerequisites (self, VALA_INTERFACE (vala_data_type_get_data_type (base_type)), prerequisites);
			}
			(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
		}
		(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
	}
	/* check whether all prerequisites are met */
	missing_prereqs = (GeeList*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	{
		GeeIterator* _prereq_it;
		_prereq_it = gee_iterable_iterator ((GeeIterable*) prerequisites);
		while (TRUE) {
			ValaTypeSymbol* prereq;
			if (!gee_iterator_next (_prereq_it)) {
				break;
			}
			prereq = (ValaTypeSymbol*) gee_iterator_get (_prereq_it);
			if (!vala_class_class_is_a (self, self, prereq)) {
				char* _tmp23_;
				_tmp23_ = NULL;
				gee_list_insert (missing_prereqs, 0, _tmp23_ = vala_symbol_get_full_name ((ValaSymbol*) prereq));
				_tmp23_ = (g_free (_tmp23_), NULL);
			}
			(prereq == NULL) ? NULL : (prereq = (vala_code_node_unref (prereq), NULL));
		}
		(_prereq_it == NULL) ? NULL : (_prereq_it = (gee_collection_object_unref (_prereq_it), NULL));
	}
	/* report any missing prerequisites */
	if (gee_collection_get_size ((GeeCollection*) missing_prereqs) > 0) {
		char* _tmp24_;
		char* _tmp25_;
		char* error_string;
		gboolean first;
		char* _tmp28_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp24_ = NULL;
		_tmp25_ = NULL;
		error_string = (_tmp25_ = g_strdup_printf ("%s: some prerequisites (", _tmp24_ = vala_symbol_get_full_name ((ValaSymbol*) self)), _tmp24_ = (g_free (_tmp24_), NULL), _tmp25_);
		first = TRUE;
		{
			GeeIterator* _s_it;
			_s_it = gee_iterable_iterator ((GeeIterable*) missing_prereqs);
			while (TRUE) {
				char* s;
				if (!gee_iterator_next (_s_it)) {
					break;
				}
				s = (char*) gee_iterator_get (_s_it);
				if (first) {
					char* _tmp26_;
					_tmp26_ = NULL;
					error_string = (_tmp26_ = g_strdup_printf ("%s`%s'", error_string, s), error_string = (g_free (error_string), NULL), _tmp26_);
					first = FALSE;
				} else {
					char* _tmp27_;
					_tmp27_ = NULL;
					error_string = (_tmp27_ = g_strdup_printf ("%s, `%s'", error_string, s), error_string = (g_free (error_string), NULL), _tmp27_);
				}
				s = (g_free (s), NULL);
			}
			(_s_it == NULL) ? NULL : (_s_it = (gee_collection_object_unref (_s_it), NULL));
		}
		_tmp28_ = NULL;
		error_string = (_tmp28_ = g_strconcat (error_string, ") are not met", NULL), error_string = (g_free (error_string), NULL), _tmp28_);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), error_string);
		error_string = (g_free (error_string), NULL);
	}
	/* VAPI classes don't have to specify overridden methods */
	if (!vala_symbol_get_external_package ((ValaSymbol*) self)) {
		/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
		{
			GeeList* _tmp29_;
			GeeIterator* _tmp30_;
			GeeIterator* _base_type_it;
			/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
			_tmp29_ = NULL;
			_tmp30_ = NULL;
			_base_type_it = (_tmp30_ = gee_iterable_iterator ((GeeIterable*) (_tmp29_ = vala_class_get_base_types (self))), (_tmp29_ == NULL) ? NULL : (_tmp29_ = (gee_collection_object_unref (_tmp29_), NULL)), _tmp30_);
			/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
			while (TRUE) {
				ValaDataType* base_type;
				/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
				if (!gee_iterator_next (_base_type_it)) {
					/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
					break;
				}
				/* all abstract symbols defined in base types have to be at least defined (or implemented) also in this type */
				base_type = (ValaDataType*) gee_iterator_get (_base_type_it);
				if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
					ValaInterface* _tmp31_;
					ValaInterface* iface;
					gboolean _tmp32_;
					_tmp31_ = NULL;
					iface = (_tmp31_ = VALA_INTERFACE (vala_data_type_get_data_type (base_type)), (_tmp31_ == NULL) ? NULL : vala_code_node_ref (_tmp31_));
					_tmp32_ = FALSE;
					if (self->priv->_base_class != NULL) {
						_tmp32_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self->priv->_base_class, (ValaTypeSymbol*) iface);
					} else {
						_tmp32_ = FALSE;
					}
					if (_tmp32_) {
						/* reimplementation of interface, class is not required to reimplement all methods*/
						(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
						(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
						break;
					}
					/* We do not need to do expensive equality checking here since this is done
					 * already. We only need to guarantee the symbols are present.
					 
					 check methods */
					{
						GeeList* _tmp33_;
						GeeIterator* _tmp34_;
						GeeIterator* _m_it;
						/* We do not need to do expensive equality checking here since this is done
						 * already. We only need to guarantee the symbols are present.
						 
						 check methods */
						_tmp33_ = NULL;
						_tmp34_ = NULL;
						_m_it = (_tmp34_ = gee_iterable_iterator ((GeeIterable*) (_tmp33_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) iface))), (_tmp33_ == NULL) ? NULL : (_tmp33_ = (gee_collection_object_unref (_tmp33_), NULL)), _tmp34_);
						/* We do not need to do expensive equality checking here since this is done
						 * already. We only need to guarantee the symbols are present.
						 
						 check methods */
						while (TRUE) {
							ValaMethod* m;
							/* We do not need to do expensive equality checking here since this is done
							 * already. We only need to guarantee the symbols are present.
							 
							 check methods */
							if (!gee_iterator_next (_m_it)) {
								/* We do not need to do expensive equality checking here since this is done
								 * already. We only need to guarantee the symbols are present.
								 
								 check methods */
								break;
							}
							/* We do not need to do expensive equality checking here since this is done
							 * already. We only need to guarantee the symbols are present.
							 
							 check methods */
							m = (ValaMethod*) gee_iterator_get (_m_it);
							if (vala_method_get_is_abstract (m)) {
								ValaSymbol* sym;
								ValaClass* _tmp35_;
								ValaClass* base_class;
								sym = NULL;
								_tmp35_ = NULL;
								base_class = (_tmp35_ = self, (_tmp35_ == NULL) ? NULL : vala_code_node_ref (_tmp35_));
								while (TRUE) {
									gboolean _tmp36_;
									ValaSymbol* _tmp37_;
									ValaClass* _tmp39_;
									ValaClass* _tmp38_;
									_tmp36_ = FALSE;
									if (base_class != NULL) {
										_tmp36_ = !VALA_IS_METHOD (sym);
									} else {
										_tmp36_ = FALSE;
									}
									if (!_tmp36_) {
										break;
									}
									_tmp37_ = NULL;
									sym = (_tmp37_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) m)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp37_);
									_tmp39_ = NULL;
									_tmp38_ = NULL;
									base_class = (_tmp39_ = (_tmp38_ = base_class->priv->_base_class, (_tmp38_ == NULL) ? NULL : vala_code_node_ref (_tmp38_)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp39_);
								}
								if (!VALA_IS_METHOD (sym)) {
									char* _tmp42_;
									char* _tmp41_;
									char* _tmp40_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp42_ = NULL;
									_tmp41_ = NULL;
									_tmp40_ = NULL;
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp42_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) m)));
									_tmp42_ = (g_free (_tmp42_), NULL);
									_tmp41_ = (g_free (_tmp41_), NULL);
									_tmp40_ = (g_free (_tmp40_), NULL);
								}
								(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
							}
							(m == NULL) ? NULL : (m = (vala_code_node_unref (m), NULL));
						}
						(_m_it == NULL) ? NULL : (_m_it = (gee_collection_object_unref (_m_it), NULL));
					}
					/* check properties */
					{
						GeeList* _tmp43_;
						GeeIterator* _tmp44_;
						GeeIterator* _prop_it;
						/* check properties */
						_tmp43_ = NULL;
						_tmp44_ = NULL;
						_prop_it = (_tmp44_ = gee_iterable_iterator ((GeeIterable*) (_tmp43_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) iface))), (_tmp43_ == NULL) ? NULL : (_tmp43_ = (gee_collection_object_unref (_tmp43_), NULL)), _tmp44_);
						/* check properties */
						while (TRUE) {
							ValaProperty* prop;
							/* check properties */
							if (!gee_iterator_next (_prop_it)) {
								/* check properties */
								break;
							}
							/* check properties */
							prop = (ValaProperty*) gee_iterator_get (_prop_it);
							if (vala_property_get_is_abstract (prop)) {
								ValaSymbol* sym;
								ValaClass* _tmp45_;
								ValaClass* base_class;
								sym = NULL;
								_tmp45_ = NULL;
								base_class = (_tmp45_ = self, (_tmp45_ == NULL) ? NULL : vala_code_node_ref (_tmp45_));
								while (TRUE) {
									gboolean _tmp46_;
									ValaSymbol* _tmp47_;
									ValaClass* _tmp49_;
									ValaClass* _tmp48_;
									_tmp46_ = FALSE;
									if (base_class != NULL) {
										_tmp46_ = !VALA_IS_PROPERTY (sym);
									} else {
										_tmp46_ = FALSE;
									}
									if (!_tmp46_) {
										break;
									}
									_tmp47_ = NULL;
									sym = (_tmp47_ = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) base_class), vala_symbol_get_name ((ValaSymbol*) prop)), (sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL)), _tmp47_);
									_tmp49_ = NULL;
									_tmp48_ = NULL;
									base_class = (_tmp49_ = (_tmp48_ = base_class->priv->_base_class, (_tmp48_ == NULL) ? NULL : vala_code_node_ref (_tmp48_)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp49_);
								}
								if (!VALA_IS_PROPERTY (sym)) {
									char* _tmp52_;
									char* _tmp51_;
									char* _tmp50_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp52_ = NULL;
									_tmp51_ = NULL;
									_tmp50_ = NULL;
									vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp52_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp51_ = vala_symbol_get_full_name ((ValaSymbol*) prop)));
									_tmp52_ = (g_free (_tmp52_), NULL);
									_tmp51_ = (g_free (_tmp51_), NULL);
									_tmp50_ = (g_free (_tmp50_), NULL);
								}
								(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
								(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
							}
							(prop == NULL) ? NULL : (prop = (vala_code_node_unref (prop), NULL));
						}
						(_prop_it == NULL) ? NULL : (_prop_it = (gee_collection_object_unref (_prop_it), NULL));
					}
					(iface == NULL) ? NULL : (iface = (vala_code_node_unref (iface), NULL));
				}
				(base_type == NULL) ? NULL : (base_type = (vala_code_node_unref (base_type), NULL));
			}
			(_base_type_it == NULL) ? NULL : (_base_type_it = (gee_collection_object_unref (_base_type_it), NULL));
		}
		/* all abstract symbols defined in base classes have to be implemented in non-abstract classes */
		if (!self->priv->_is_abstract) {
			ValaClass* _tmp53_;
			ValaClass* base_class;
			_tmp53_ = NULL;
			base_class = (_tmp53_ = self->priv->_base_class, (_tmp53_ == NULL) ? NULL : vala_code_node_ref (_tmp53_));
			while (TRUE) {
				gboolean _tmp54_;
				ValaClass* _tmp70_;
				ValaClass* _tmp69_;
				_tmp54_ = FALSE;
				if (base_class != NULL) {
					_tmp54_ = base_class->priv->_is_abstract;
				} else {
					_tmp54_ = FALSE;
				}
				if (!_tmp54_) {
					break;
				}
				{
					GeeList* _tmp55_;
					GeeIterator* _tmp56_;
					GeeIterator* _base_method_it;
					_tmp55_ = NULL;
					_tmp56_ = NULL;
					_base_method_it = (_tmp56_ = gee_iterable_iterator ((GeeIterable*) (_tmp55_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) base_class))), (_tmp55_ == NULL) ? NULL : (_tmp55_ = (gee_collection_object_unref (_tmp55_), NULL)), _tmp56_);
					while (TRUE) {
						ValaMethod* base_method;
						if (!gee_iterator_next (_base_method_it)) {
							break;
						}
						base_method = (ValaMethod*) gee_iterator_get (_base_method_it);
						if (vala_method_get_is_abstract (base_method)) {
							ValaSymbol* _tmp57_;
							ValaMethod* override_method;
							gboolean _tmp58_;
							_tmp57_ = NULL;
							override_method = (_tmp57_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_method)), VALA_IS_METHOD (_tmp57_) ? ((ValaMethod*) _tmp57_) : NULL);
							_tmp58_ = FALSE;
							if (override_method == NULL) {
								_tmp58_ = TRUE;
							} else {
								_tmp58_ = !vala_method_get_overrides (override_method);
							}
							if (_tmp58_) {
								char* _tmp61_;
								char* _tmp60_;
								char* _tmp59_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp61_ = NULL;
								_tmp60_ = NULL;
								_tmp59_ = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp61_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp59_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp60_ = vala_symbol_get_full_name ((ValaSymbol*) base_method)));
								_tmp61_ = (g_free (_tmp61_), NULL);
								_tmp60_ = (g_free (_tmp60_), NULL);
								_tmp59_ = (g_free (_tmp59_), NULL);
							}
							(override_method == NULL) ? NULL : (override_method = (vala_code_node_unref (override_method), NULL));
						}
						(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					}
					(_base_method_it == NULL) ? NULL : (_base_method_it = (gee_collection_object_unref (_base_method_it), NULL));
				}
				{
					GeeList* _tmp62_;
					GeeIterator* _tmp63_;
					GeeIterator* _base_property_it;
					_tmp62_ = NULL;
					_tmp63_ = NULL;
					_base_property_it = (_tmp63_ = gee_iterable_iterator ((GeeIterable*) (_tmp62_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) base_class))), (_tmp62_ == NULL) ? NULL : (_tmp62_ = (gee_collection_object_unref (_tmp62_), NULL)), _tmp63_);
					while (TRUE) {
						ValaProperty* base_property;
						if (!gee_iterator_next (_base_property_it)) {
							break;
						}
						base_property = (ValaProperty*) gee_iterator_get (_base_property_it);
						if (vala_property_get_is_abstract (base_property)) {
							ValaSymbol* _tmp64_;
							ValaProperty* override_property;
							gboolean _tmp65_;
							_tmp64_ = NULL;
							override_property = (_tmp64_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, vala_symbol_get_name ((ValaSymbol*) base_property)), VALA_IS_PROPERTY (_tmp64_) ? ((ValaProperty*) _tmp64_) : NULL);
							_tmp65_ = FALSE;
							if (override_property == NULL) {
								_tmp65_ = TRUE;
							} else {
								_tmp65_ = !vala_property_get_overrides (override_property);
							}
							if (_tmp65_) {
								char* _tmp68_;
								char* _tmp67_;
								char* _tmp66_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp68_ = NULL;
								_tmp67_ = NULL;
								_tmp66_ = NULL;
								vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp68_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp66_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp67_ = vala_symbol_get_full_name ((ValaSymbol*) base_property)));
								_tmp68_ = (g_free (_tmp68_), NULL);
								_tmp67_ = (g_free (_tmp67_), NULL);
								_tmp66_ = (g_free (_tmp66_), NULL);
							}
							(override_property == NULL) ? NULL : (override_property = (vala_code_node_unref (override_property), NULL));
						}
						(base_property == NULL) ? NULL : (base_property = (vala_code_node_unref (base_property), NULL));
					}
					(_base_property_it == NULL) ? NULL : (_base_property_it = (gee_collection_object_unref (_base_property_it), NULL));
				}
				_tmp70_ = NULL;
				_tmp69_ = NULL;
				base_class = (_tmp70_ = (_tmp69_ = base_class->priv->_base_class, (_tmp69_ == NULL) ? NULL : vala_code_node_ref (_tmp69_)), (base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)), _tmp70_);
			}
			(base_class == NULL) ? NULL : (base_class = (vala_code_node_unref (base_class), NULL));
		}
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp72_ = NULL;
	_tmp71_ = NULL;
	analyzer->current_class = (_tmp72_ = (_tmp71_ = old_class, (_tmp71_ == NULL) ? NULL : vala_code_node_ref (_tmp71_)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp72_);
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
	(prerequisites == NULL) ? NULL : (prerequisites = (gee_collection_object_unref (prerequisites), NULL));
	(missing_prereqs == NULL) ? NULL : (missing_prereqs = (gee_collection_object_unref (missing_prereqs), NULL));
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_base_class;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp1_;
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_base_class = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_base_class == NULL) ? NULL : (self->priv->_base_class = (vala_code_node_unref (self->priv->_base_class), NULL)), _tmp1_);
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_compact (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_compact;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_compact = value;
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_is_immutable (self->priv->_base_class);
		return result;
	}
	result = self->priv->_is_immutable;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_immutable = value;
}


gboolean vala_class_get_ref_function_void (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_base_class != NULL) {
		result = vala_class_get_ref_function_void (self->priv->_base_class);
		return result;
	}
	result = self->priv->_ref_function_void;
	return result;
}


void vala_class_set_ref_function_void (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_ref_function_void = value;
}


const char* vala_class_get_type_check_function (ValaClass* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_type_check_function;
	return result;
}


void vala_class_set_type_check_function (ValaClass* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_type_check_function = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_type_check_function = (g_free (self->priv->_type_check_function), NULL), _tmp1_);
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_private_fields;
	return result;
}


static void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_class_private_fields;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


gboolean vala_class_get_free_function_address_of (ValaClass* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_free_function_address_of;
	return result;
}


static void vala_class_set_free_function_address_of (ValaClass* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_free_function_address_of = value;
}


ValaMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_default_construction_method;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaMethod* value) {
	ValaMethod* _tmp1_;
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_default_construction_method = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_default_construction_method == NULL) ? NULL : (self->priv->_default_construction_method = (vala_code_node_unref (self->priv->_default_construction_method), NULL)), _tmp1_);
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_constructor;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp1_;
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_constructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL)), _tmp1_);
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_constructor;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp1_;
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_class_constructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_class_constructor == NULL) ? NULL : (self->priv->_class_constructor = (vala_code_node_unref (self->priv->_class_constructor), NULL)), _tmp1_);
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_constructor;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp1_;
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_static_constructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_static_constructor == NULL) ? NULL : (self->priv->_static_constructor = (vala_code_node_unref (self->priv->_static_constructor), NULL)), _tmp1_);
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_destructor;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp1_;
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_destructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_destructor == NULL) ? NULL : (self->priv->_destructor = (vala_code_node_unref (self->priv->_destructor), NULL)), _tmp1_);
	if (self->priv->_destructor != NULL) {
		ValaFormalParameter* _tmp3_;
		ValaObjectType* _tmp2_;
		if (vala_destructor_get_this_parameter (self->priv->_destructor) != NULL) {
			vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)));
		}
		_tmp3_ = NULL;
		_tmp2_ = NULL;
		vala_destructor_set_this_parameter (self->priv->_destructor, _tmp3_ = vala_formal_parameter_new ("this", (ValaDataType*) (_tmp2_ = vala_class_get_this_type (self)), NULL));
		(_tmp3_ == NULL) ? NULL : (_tmp3_ = (vala_code_node_unref (_tmp3_), NULL));
		(_tmp2_ == NULL) ? NULL : (_tmp2_ = (vala_code_node_unref (_tmp2_), NULL));
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self->priv->_destructor), vala_symbol_get_name ((ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor)), (ValaSymbol*) vala_destructor_get_this_parameter (self->priv->_destructor));
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_static_destructor;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp1_;
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_static_destructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_static_destructor == NULL) ? NULL : (self->priv->_static_destructor = (vala_code_node_unref (self->priv->_static_destructor), NULL)), _tmp1_);
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_class_destructor;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp1_;
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_class_destructor = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_class_destructor == NULL) ? NULL : (self->priv->_class_destructor = (vala_code_node_unref (self->priv->_class_destructor), NULL)), _tmp1_);
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = NULL;
	result = (_tmp1_ = (_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase")) != NULL, (_tmp0_ == NULL) ? NULL : (_tmp0_ = (vala_code_node_unref (_tmp0_), NULL)), _tmp1_);
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_methods = vala_class_real_get_methods;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_properties = vala_class_real_get_properties;
	VALA_OBJECT_TYPE_SYMBOL_CLASS (klass)->get_signals = vala_class_real_get_signals;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_class_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_class_real_accept_children;
	VALA_SYMBOL_CLASS (klass)->get_cprefix = vala_class_real_get_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_class_real_get_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cname = vala_class_real_get_lower_case_cname;
	VALA_SYMBOL_CLASS (klass)->get_lower_case_cprefix = vala_class_real_get_lower_case_cprefix;
	VALA_TYPESYMBOL_CLASS (klass)->get_upper_case_cname = vala_class_real_get_upper_case_cname;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_signature = vala_class_real_get_type_signature;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_type = vala_class_real_is_reference_type;
	VALA_TYPESYMBOL_CLASS (klass)->get_type_id = vala_class_real_get_type_id;
	VALA_TYPESYMBOL_CLASS (klass)->get_marshaller_type_name = vala_class_real_get_marshaller_type_name;
	VALA_TYPESYMBOL_CLASS (klass)->get_param_spec_function = vala_class_real_get_param_spec_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_get_value_function = vala_class_real_get_get_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_set_value_function = vala_class_real_get_set_value_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_reference_counting = vala_class_real_is_reference_counting;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_function = vala_class_real_get_ref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_unref_function = vala_class_real_get_unref_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_ref_sink_function = vala_class_real_get_ref_sink_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_dup_function = vala_class_real_get_dup_function;
	VALA_TYPESYMBOL_CLASS (klass)->get_free_function = vala_class_real_get_free_function;
	VALA_TYPESYMBOL_CLASS (klass)->is_subtype_of = vala_class_real_is_subtype_of;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_class_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	self->priv->base_types = (GeeList*) gee_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->constants = (GeeList*) gee_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->fields = (GeeList*) gee_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->methods = (GeeList*) gee_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->properties = (GeeList*) gee_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->signals = (GeeList*) gee_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->classes = (GeeList*) gee_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->structs = (GeeList*) gee_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->enums = (GeeList*) gee_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->delegates = (GeeList*) gee_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_class_finalize (ValaCodeNode* obj) {
	ValaClass * self;
	self = VALA_CLASS (obj);
	(self->priv->_base_class == NULL) ? NULL : (self->priv->_base_class = (vala_code_node_unref (self->priv->_base_class), NULL));
	self->priv->_type_check_function = (g_free (self->priv->_type_check_function), NULL);
	self->priv->cname = (g_free (self->priv->cname), NULL);
	self->priv->const_cname = (g_free (self->priv->const_cname), NULL);
	self->priv->lower_case_cprefix = (g_free (self->priv->lower_case_cprefix), NULL);
	self->priv->lower_case_csuffix = (g_free (self->priv->lower_case_csuffix), NULL);
	self->priv->type_id = (g_free (self->priv->type_id), NULL);
	self->priv->ref_function = (g_free (self->priv->ref_function), NULL);
	self->priv->unref_function = (g_free (self->priv->unref_function), NULL);
	self->priv->ref_sink_function = (g_free (self->priv->ref_sink_function), NULL);
	self->priv->param_spec_function = (g_free (self->priv->param_spec_function), NULL);
	self->priv->copy_function = (g_free (self->priv->copy_function), NULL);
	self->priv->free_function = (g_free (self->priv->free_function), NULL);
	self->priv->marshaller_type_name = (g_free (self->priv->marshaller_type_name), NULL);
	self->priv->get_value_function = (g_free (self->priv->get_value_function), NULL);
	self->priv->set_value_function = (g_free (self->priv->set_value_function), NULL);
	self->priv->type_signature = (g_free (self->priv->type_signature), NULL);
	(self->priv->base_types == NULL) ? NULL : (self->priv->base_types = (gee_collection_object_unref (self->priv->base_types), NULL));
	(self->priv->constants == NULL) ? NULL : (self->priv->constants = (gee_collection_object_unref (self->priv->constants), NULL));
	(self->priv->fields == NULL) ? NULL : (self->priv->fields = (gee_collection_object_unref (self->priv->fields), NULL));
	(self->priv->methods == NULL) ? NULL : (self->priv->methods = (gee_collection_object_unref (self->priv->methods), NULL));
	(self->priv->properties == NULL) ? NULL : (self->priv->properties = (gee_collection_object_unref (self->priv->properties), NULL));
	(self->priv->signals == NULL) ? NULL : (self->priv->signals = (gee_collection_object_unref (self->priv->signals), NULL));
	(self->priv->classes == NULL) ? NULL : (self->priv->classes = (gee_collection_object_unref (self->priv->classes), NULL));
	(self->priv->structs == NULL) ? NULL : (self->priv->structs = (gee_collection_object_unref (self->priv->structs), NULL));
	(self->priv->enums == NULL) ? NULL : (self->priv->enums = (gee_collection_object_unref (self->priv->enums), NULL));
	(self->priv->delegates == NULL) ? NULL : (self->priv->delegates = (gee_collection_object_unref (self->priv->delegates), NULL));
	(self->priv->_default_construction_method == NULL) ? NULL : (self->priv->_default_construction_method = (vala_code_node_unref (self->priv->_default_construction_method), NULL));
	(self->priv->_constructor == NULL) ? NULL : (self->priv->_constructor = (vala_code_node_unref (self->priv->_constructor), NULL));
	(self->priv->_class_constructor == NULL) ? NULL : (self->priv->_class_constructor = (vala_code_node_unref (self->priv->_class_constructor), NULL));
	(self->priv->_static_constructor == NULL) ? NULL : (self->priv->_static_constructor = (vala_code_node_unref (self->priv->_static_constructor), NULL));
	(self->priv->_static_destructor == NULL) ? NULL : (self->priv->_static_destructor = (vala_code_node_unref (self->priv->_static_destructor), NULL));
	(self->priv->_class_destructor == NULL) ? NULL : (self->priv->_class_destructor = (vala_code_node_unref (self->priv->_class_destructor), NULL));
	(self->priv->_destructor == NULL) ? NULL : (self->priv->_destructor = (vala_code_node_unref (self->priv->_destructor), NULL));
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


GType vala_class_get_type (void) {
	static GType vala_class_type_id = 0;
	if (vala_class_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
	}
	return vala_class_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




