/* valamethod.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;
typedef struct _ValaCodeNodePrivate ValaCodeNodePrivate;

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;

#define VALA_TYPE_DATA_TYPE (vala_data_type_get_type ())
#define VALA_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DATA_TYPE, ValaDataType))
#define VALA_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))
#define VALA_IS_DATA_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DATA_TYPE))
#define VALA_IS_DATA_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DATA_TYPE))
#define VALA_DATA_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DATA_TYPE, ValaDataTypeClass))

typedef struct _ValaDataType ValaDataType;
typedef struct _ValaDataTypeClass ValaDataTypeClass;

#define VALA_TYPE_EXPRESSION (vala_expression_get_type ())
#define VALA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION, ValaExpression))
#define VALA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION, ValaExpressionClass))
#define VALA_IS_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION))
#define VALA_IS_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION))
#define VALA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION, ValaExpressionClass))

typedef struct _ValaExpression ValaExpression;
typedef struct _ValaExpressionClass ValaExpressionClass;

#define VALA_TYPE_SYMBOL (vala_symbol_get_type ())
#define VALA_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SYMBOL, ValaSymbol))
#define VALA_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SYMBOL, ValaSymbolClass))
#define VALA_IS_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SYMBOL))
#define VALA_IS_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SYMBOL))
#define VALA_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SYMBOL, ValaSymbolClass))

typedef struct _ValaSymbol ValaSymbol;
typedef struct _ValaSymbolClass ValaSymbolClass;

#define VALA_TYPE_LOCAL_VARIABLE (vala_local_variable_get_type ())
#define VALA_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable))
#define VALA_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))
#define VALA_IS_LOCAL_VARIABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_IS_LOCAL_VARIABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCAL_VARIABLE))
#define VALA_LOCAL_VARIABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariableClass))

typedef struct _ValaLocalVariable ValaLocalVariable;
typedef struct _ValaLocalVariableClass ValaLocalVariableClass;

#define VALA_TYPE_ATTRIBUTE (vala_attribute_get_type ())
#define VALA_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ATTRIBUTE, ValaAttribute))
#define VALA_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))
#define VALA_IS_ATTRIBUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ATTRIBUTE))
#define VALA_IS_ATTRIBUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ATTRIBUTE))
#define VALA_ATTRIBUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ATTRIBUTE, ValaAttributeClass))

typedef struct _ValaAttribute ValaAttribute;
typedef struct _ValaAttributeClass ValaAttributeClass;
typedef struct _ValaSymbolPrivate ValaSymbolPrivate;

#define VALA_TYPE_MEMBER (vala_member_get_type ())
#define VALA_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER, ValaMember))
#define VALA_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER, ValaMemberClass))
#define VALA_IS_MEMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER))
#define VALA_IS_MEMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER))
#define VALA_MEMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER, ValaMemberClass))

typedef struct _ValaMember ValaMember;
typedef struct _ValaMemberClass ValaMemberClass;
typedef struct _ValaMemberPrivate ValaMemberPrivate;

#define VALA_TYPE_METHOD (vala_method_get_type ())
#define VALA_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD, ValaMethod))
#define VALA_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD, ValaMethodClass))
#define VALA_IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD))
#define VALA_IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD))
#define VALA_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD, ValaMethodClass))

typedef struct _ValaMethod ValaMethod;
typedef struct _ValaMethodClass ValaMethodClass;
typedef struct _ValaMethodPrivate ValaMethodPrivate;

#define VALA_TYPE_TYPEPARAMETER (vala_typeparameter_get_type ())
#define VALA_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameter))
#define VALA_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))
#define VALA_IS_TYPEPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEPARAMETER))
#define VALA_IS_TYPEPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEPARAMETER))
#define VALA_TYPEPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterClass))

typedef struct _ValaTypeParameter ValaTypeParameter;
typedef struct _ValaTypeParameterClass ValaTypeParameterClass;

#define VALA_TYPE_BASIC_BLOCK (vala_basic_block_get_type ())
#define VALA_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlock))
#define VALA_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))
#define VALA_IS_BASIC_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASIC_BLOCK))
#define VALA_IS_BASIC_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASIC_BLOCK))
#define VALA_BASIC_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASIC_BLOCK, ValaBasicBlockClass))

typedef struct _ValaBasicBlock ValaBasicBlock;
typedef struct _ValaBasicBlockClass ValaBasicBlockClass;

#define TYPE_MEMBER_BINDING (member_binding_get_type ())

#define VALA_TYPE_FORMAL_PARAMETER (vala_formal_parameter_get_type ())
#define VALA_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameter))
#define VALA_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))
#define VALA_IS_FORMAL_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_IS_FORMAL_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FORMAL_PARAMETER))
#define VALA_FORMAL_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FORMAL_PARAMETER, ValaFormalParameterClass))

typedef struct _ValaFormalParameter ValaFormalParameter;
typedef struct _ValaFormalParameterClass ValaFormalParameterClass;

#define VALA_TYPE_SIGNAL (vala_signal_get_type ())
#define VALA_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIGNAL, ValaSignal))
#define VALA_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIGNAL, ValaSignalClass))
#define VALA_IS_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIGNAL))
#define VALA_IS_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIGNAL))
#define VALA_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIGNAL, ValaSignalClass))

typedef struct _ValaSignal ValaSignal;
typedef struct _ValaSignalClass ValaSignalClass;

#define VALA_TYPE_BLOCK (vala_block_get_type ())
#define VALA_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BLOCK, ValaBlock))
#define VALA_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BLOCK, ValaBlockClass))
#define VALA_IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BLOCK))
#define VALA_IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BLOCK))
#define VALA_BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BLOCK, ValaBlockClass))

typedef struct _ValaBlock ValaBlock;
typedef struct _ValaBlockClass ValaBlockClass;

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SCOPE (vala_scope_get_type ())
#define VALA_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCOPE, ValaScope))
#define VALA_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCOPE, ValaScopeClass))
#define VALA_IS_SCOPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCOPE))
#define VALA_IS_SCOPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCOPE))
#define VALA_SCOPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCOPE, ValaScopeClass))

typedef struct _ValaScope ValaScope;
typedef struct _ValaScopeClass ValaScopeClass;

#define VALA_TYPE_REFERENCE_TYPE (vala_reference_type_get_type ())
#define VALA_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceType))
#define VALA_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))
#define VALA_IS_REFERENCE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TYPE))
#define VALA_IS_REFERENCE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TYPE))
#define VALA_REFERENCE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TYPE, ValaReferenceTypeClass))

typedef struct _ValaReferenceType ValaReferenceType;
typedef struct _ValaReferenceTypeClass ValaReferenceTypeClass;

#define VALA_TYPE_OBJECT_TYPE (vala_object_type_get_type ())
#define VALA_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectType))
#define VALA_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))
#define VALA_IS_OBJECT_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE))
#define VALA_IS_OBJECT_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE))
#define VALA_OBJECT_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE, ValaObjectTypeClass))

typedef struct _ValaObjectType ValaObjectType;
typedef struct _ValaObjectTypeClass ValaObjectTypeClass;

#define VALA_TYPE_TYPESYMBOL (vala_typesymbol_get_type ())
#define VALA_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbol))
#define VALA_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))
#define VALA_IS_TYPESYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPESYMBOL))
#define VALA_IS_TYPESYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPESYMBOL))
#define VALA_TYPESYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPESYMBOL, ValaTypeSymbolClass))

typedef struct _ValaTypeSymbol ValaTypeSymbol;
typedef struct _ValaTypeSymbolClass ValaTypeSymbolClass;

#define VALA_TYPE_OBJECT_TYPE_SYMBOL (vala_object_type_symbol_get_type ())
#define VALA_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))
#define VALA_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))
#define VALA_IS_OBJECT_TYPE_SYMBOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_IS_OBJECT_TYPE_SYMBOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_TYPE_SYMBOL))
#define VALA_OBJECT_TYPE_SYMBOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbolClass))

typedef struct _ValaObjectTypeSymbol ValaObjectTypeSymbol;
typedef struct _ValaObjectTypeSymbolClass ValaObjectTypeSymbolClass;

#define VALA_TYPE_GENERIC_TYPE (vala_generic_type_get_type ())
#define VALA_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericType))
#define VALA_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))
#define VALA_IS_GENERIC_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GENERIC_TYPE))
#define VALA_IS_GENERIC_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GENERIC_TYPE))
#define VALA_GENERIC_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GENERIC_TYPE, ValaGenericTypeClass))

typedef struct _ValaGenericType ValaGenericType;
typedef struct _ValaGenericTypeClass ValaGenericTypeClass;

#define VALA_TYPE_MEMBER_ACCESS (vala_member_access_get_type ())
#define VALA_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess))
#define VALA_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))
#define VALA_IS_MEMBER_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MEMBER_ACCESS))
#define VALA_IS_MEMBER_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MEMBER_ACCESS))
#define VALA_MEMBER_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessClass))

typedef struct _ValaMemberAccess ValaMemberAccess;
typedef struct _ValaMemberAccessClass ValaMemberAccessClass;

#define VALA_TYPE_CLASS (vala_class_get_type ())
#define VALA_CLASS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CLASS, ValaClass))
#define VALA_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CLASS, ValaClassClass))
#define VALA_IS_CLASS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CLASS))
#define VALA_IS_CLASS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CLASS))
#define VALA_CLASS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CLASS, ValaClassClass))

typedef struct _ValaClass ValaClass;
typedef struct _ValaClassClass ValaClassClass;

#define VALA_TYPE_CREATION_METHOD (vala_creation_method_get_type ())
#define VALA_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethod))
#define VALA_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))
#define VALA_IS_CREATION_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CREATION_METHOD))
#define VALA_IS_CREATION_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CREATION_METHOD))
#define VALA_CREATION_METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CREATION_METHOD, ValaCreationMethodClass))

typedef struct _ValaCreationMethod ValaCreationMethod;
typedef struct _ValaCreationMethodClass ValaCreationMethodClass;

#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterface ValaInterface;
typedef struct _ValaInterfaceClass ValaInterfaceClass;

#define VALA_TYPE_PARAMETER_DIRECTION (vala_parameter_direction_get_type ())

#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaCodeVisitorPrivate ValaCodeVisitorPrivate;

#define VALA_TYPE_NAMESPACE (vala_namespace_get_type ())
#define VALA_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NAMESPACE, ValaNamespace))
#define VALA_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NAMESPACE, ValaNamespaceClass))
#define VALA_IS_NAMESPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NAMESPACE))
#define VALA_IS_NAMESPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NAMESPACE))
#define VALA_NAMESPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NAMESPACE, ValaNamespaceClass))

typedef struct _ValaNamespace ValaNamespace;
typedef struct _ValaNamespaceClass ValaNamespaceClass;

#define VALA_TYPE_STRUCT (vala_struct_get_type ())
#define VALA_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT, ValaStruct))
#define VALA_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT, ValaStructClass))
#define VALA_IS_STRUCT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT))
#define VALA_IS_STRUCT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT))
#define VALA_STRUCT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT, ValaStructClass))

typedef struct _ValaStruct ValaStruct;
typedef struct _ValaStructClass ValaStructClass;

#define VALA_TYPE_ENUM (vala_enum_get_type ())
#define VALA_ENUM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM, ValaEnum))
#define VALA_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM, ValaEnumClass))
#define VALA_IS_ENUM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM))
#define VALA_IS_ENUM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM))
#define VALA_ENUM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM, ValaEnumClass))

typedef struct _ValaEnum ValaEnum;
typedef struct _ValaEnumClass ValaEnumClass;

#define VALA_TYPE_ENUM_VALUE (vala_enum_value_get_type ())
#define VALA_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValue))
#define VALA_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))
#define VALA_IS_ENUM_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ENUM_VALUE))
#define VALA_IS_ENUM_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ENUM_VALUE))
#define VALA_ENUM_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ENUM_VALUE, ValaEnumValueClass))

typedef struct _ValaEnumValue ValaEnumValue;
typedef struct _ValaEnumValueClass ValaEnumValueClass;

#define VALA_TYPE_ERROR_DOMAIN (vala_error_domain_get_type ())
#define VALA_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain))
#define VALA_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))
#define VALA_IS_ERROR_DOMAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_DOMAIN))
#define VALA_IS_ERROR_DOMAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_DOMAIN))
#define VALA_ERROR_DOMAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_DOMAIN, ValaErrorDomainClass))

typedef struct _ValaErrorDomain ValaErrorDomain;
typedef struct _ValaErrorDomainClass ValaErrorDomainClass;

#define VALA_TYPE_ERROR_CODE (vala_error_code_get_type ())
#define VALA_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCode))
#define VALA_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))
#define VALA_IS_ERROR_CODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ERROR_CODE))
#define VALA_IS_ERROR_CODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ERROR_CODE))
#define VALA_ERROR_CODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ERROR_CODE, ValaErrorCodeClass))

typedef struct _ValaErrorCode ValaErrorCode;
typedef struct _ValaErrorCodeClass ValaErrorCodeClass;

#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegate ValaDelegate;
typedef struct _ValaDelegateClass ValaDelegateClass;

#define VALA_TYPE_CONSTANT (vala_constant_get_type ())
#define VALA_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTANT, ValaConstant))
#define VALA_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTANT, ValaConstantClass))
#define VALA_IS_CONSTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTANT))
#define VALA_IS_CONSTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTANT))
#define VALA_CONSTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTANT, ValaConstantClass))

typedef struct _ValaConstant ValaConstant;
typedef struct _ValaConstantClass ValaConstantClass;

#define VALA_TYPE_FIELD (vala_field_get_type ())
#define VALA_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FIELD, ValaField))
#define VALA_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FIELD, ValaFieldClass))
#define VALA_IS_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FIELD))
#define VALA_IS_FIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FIELD))
#define VALA_FIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FIELD, ValaFieldClass))

typedef struct _ValaField ValaField;
typedef struct _ValaFieldClass ValaFieldClass;

#define VALA_TYPE_PROPERTY (vala_property_get_type ())
#define VALA_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY, ValaProperty))
#define VALA_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY, ValaPropertyClass))
#define VALA_IS_PROPERTY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY))
#define VALA_IS_PROPERTY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY))
#define VALA_PROPERTY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY, ValaPropertyClass))

typedef struct _ValaProperty ValaProperty;
typedef struct _ValaPropertyClass ValaPropertyClass;

#define VALA_TYPE_PROPERTY_ACCESSOR (vala_property_accessor_get_type ())
#define VALA_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessor))
#define VALA_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))
#define VALA_IS_PROPERTY_ACCESSOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_IS_PROPERTY_ACCESSOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PROPERTY_ACCESSOR))
#define VALA_PROPERTY_ACCESSOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PROPERTY_ACCESSOR, ValaPropertyAccessorClass))

typedef struct _ValaPropertyAccessor ValaPropertyAccessor;
typedef struct _ValaPropertyAccessorClass ValaPropertyAccessorClass;

#define VALA_TYPE_CONSTRUCTOR (vala_constructor_get_type ())
#define VALA_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructor))
#define VALA_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))
#define VALA_IS_CONSTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONSTRUCTOR))
#define VALA_IS_CONSTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONSTRUCTOR))
#define VALA_CONSTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONSTRUCTOR, ValaConstructorClass))

typedef struct _ValaConstructor ValaConstructor;
typedef struct _ValaConstructorClass ValaConstructorClass;

#define VALA_TYPE_DESTRUCTOR (vala_destructor_get_type ())
#define VALA_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructor))
#define VALA_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))
#define VALA_IS_DESTRUCTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DESTRUCTOR))
#define VALA_IS_DESTRUCTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DESTRUCTOR))
#define VALA_DESTRUCTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DESTRUCTOR, ValaDestructorClass))

typedef struct _ValaDestructor ValaDestructor;
typedef struct _ValaDestructorClass ValaDestructorClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;

#define VALA_TYPE_EMPTY_STATEMENT (vala_empty_statement_get_type ())
#define VALA_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatement))
#define VALA_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))
#define VALA_IS_EMPTY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_IS_EMPTY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EMPTY_STATEMENT))
#define VALA_EMPTY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EMPTY_STATEMENT, ValaEmptyStatementClass))

typedef struct _ValaEmptyStatement ValaEmptyStatement;
typedef struct _ValaEmptyStatementClass ValaEmptyStatementClass;

#define VALA_TYPE_DECLARATION_STATEMENT (vala_declaration_statement_get_type ())
#define VALA_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatement))
#define VALA_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))
#define VALA_IS_DECLARATION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_IS_DECLARATION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DECLARATION_STATEMENT))
#define VALA_DECLARATION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementClass))

typedef struct _ValaDeclarationStatement ValaDeclarationStatement;
typedef struct _ValaDeclarationStatementClass ValaDeclarationStatementClass;

#define VALA_TYPE_INITIALIZER_LIST (vala_initializer_list_get_type ())
#define VALA_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerList))
#define VALA_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))
#define VALA_IS_INITIALIZER_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INITIALIZER_LIST))
#define VALA_IS_INITIALIZER_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INITIALIZER_LIST))
#define VALA_INITIALIZER_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListClass))

typedef struct _ValaInitializerList ValaInitializerList;
typedef struct _ValaInitializerListClass ValaInitializerListClass;

#define VALA_TYPE_EXPRESSION_STATEMENT (vala_expression_statement_get_type ())
#define VALA_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatement))
#define VALA_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))
#define VALA_IS_EXPRESSION_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_IS_EXPRESSION_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_EXPRESSION_STATEMENT))
#define VALA_EXPRESSION_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementClass))

typedef struct _ValaExpressionStatement ValaExpressionStatement;
typedef struct _ValaExpressionStatementClass ValaExpressionStatementClass;

#define VALA_TYPE_IF_STATEMENT (vala_if_statement_get_type ())
#define VALA_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatement))
#define VALA_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))
#define VALA_IS_IF_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_IF_STATEMENT))
#define VALA_IS_IF_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_IF_STATEMENT))
#define VALA_IF_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_IF_STATEMENT, ValaIfStatementClass))

typedef struct _ValaIfStatement ValaIfStatement;
typedef struct _ValaIfStatementClass ValaIfStatementClass;

#define VALA_TYPE_SWITCH_STATEMENT (vala_switch_statement_get_type ())
#define VALA_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement))
#define VALA_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))
#define VALA_IS_SWITCH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_IS_SWITCH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_STATEMENT))
#define VALA_SWITCH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementClass))

typedef struct _ValaSwitchStatement ValaSwitchStatement;
typedef struct _ValaSwitchStatementClass ValaSwitchStatementClass;

#define VALA_TYPE_SWITCH_SECTION (vala_switch_section_get_type ())
#define VALA_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSection))
#define VALA_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))
#define VALA_IS_SWITCH_SECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_SECTION))
#define VALA_IS_SWITCH_SECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_SECTION))
#define VALA_SWITCH_SECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_SECTION, ValaSwitchSectionClass))

typedef struct _ValaSwitchSection ValaSwitchSection;
typedef struct _ValaSwitchSectionClass ValaSwitchSectionClass;

#define VALA_TYPE_SWITCH_LABEL (vala_switch_label_get_type ())
#define VALA_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabel))
#define VALA_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))
#define VALA_IS_SWITCH_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SWITCH_LABEL))
#define VALA_IS_SWITCH_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SWITCH_LABEL))
#define VALA_SWITCH_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SWITCH_LABEL, ValaSwitchLabelClass))

typedef struct _ValaSwitchLabel ValaSwitchLabel;
typedef struct _ValaSwitchLabelClass ValaSwitchLabelClass;

#define VALA_TYPE_LOOP (vala_loop_get_type ())
#define VALA_LOOP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOOP, ValaLoop))
#define VALA_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOOP, ValaLoopClass))
#define VALA_IS_LOOP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOOP))
#define VALA_IS_LOOP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOOP))
#define VALA_LOOP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOOP, ValaLoopClass))

typedef struct _ValaLoop ValaLoop;
typedef struct _ValaLoopClass ValaLoopClass;

#define VALA_TYPE_WHILE_STATEMENT (vala_while_statement_get_type ())
#define VALA_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatement))
#define VALA_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))
#define VALA_IS_WHILE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_WHILE_STATEMENT))
#define VALA_IS_WHILE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_WHILE_STATEMENT))
#define VALA_WHILE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_WHILE_STATEMENT, ValaWhileStatementClass))

typedef struct _ValaWhileStatement ValaWhileStatement;
typedef struct _ValaWhileStatementClass ValaWhileStatementClass;

#define VALA_TYPE_DO_STATEMENT (vala_do_statement_get_type ())
#define VALA_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatement))
#define VALA_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))
#define VALA_IS_DO_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DO_STATEMENT))
#define VALA_IS_DO_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DO_STATEMENT))
#define VALA_DO_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DO_STATEMENT, ValaDoStatementClass))

typedef struct _ValaDoStatement ValaDoStatement;
typedef struct _ValaDoStatementClass ValaDoStatementClass;

#define VALA_TYPE_FOR_STATEMENT (vala_for_statement_get_type ())
#define VALA_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatement))
#define VALA_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))
#define VALA_IS_FOR_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOR_STATEMENT))
#define VALA_IS_FOR_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOR_STATEMENT))
#define VALA_FOR_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOR_STATEMENT, ValaForStatementClass))

typedef struct _ValaForStatement ValaForStatement;
typedef struct _ValaForStatementClass ValaForStatementClass;

#define VALA_TYPE_FOREACH_STATEMENT (vala_foreach_statement_get_type ())
#define VALA_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatement))
#define VALA_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))
#define VALA_IS_FOREACH_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_IS_FOREACH_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_FOREACH_STATEMENT))
#define VALA_FOREACH_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_FOREACH_STATEMENT, ValaForeachStatementClass))

typedef struct _ValaForeachStatement ValaForeachStatement;
typedef struct _ValaForeachStatementClass ValaForeachStatementClass;

#define VALA_TYPE_BREAK_STATEMENT (vala_break_statement_get_type ())
#define VALA_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatement))
#define VALA_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))
#define VALA_IS_BREAK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BREAK_STATEMENT))
#define VALA_IS_BREAK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BREAK_STATEMENT))
#define VALA_BREAK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BREAK_STATEMENT, ValaBreakStatementClass))

typedef struct _ValaBreakStatement ValaBreakStatement;
typedef struct _ValaBreakStatementClass ValaBreakStatementClass;

#define VALA_TYPE_CONTINUE_STATEMENT (vala_continue_statement_get_type ())
#define VALA_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatement))
#define VALA_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))
#define VALA_IS_CONTINUE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_IS_CONTINUE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONTINUE_STATEMENT))
#define VALA_CONTINUE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONTINUE_STATEMENT, ValaContinueStatementClass))

typedef struct _ValaContinueStatement ValaContinueStatement;
typedef struct _ValaContinueStatementClass ValaContinueStatementClass;

#define VALA_TYPE_RETURN_STATEMENT (vala_return_statement_get_type ())
#define VALA_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatement))
#define VALA_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))
#define VALA_IS_RETURN_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_RETURN_STATEMENT))
#define VALA_IS_RETURN_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_RETURN_STATEMENT))
#define VALA_RETURN_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_RETURN_STATEMENT, ValaReturnStatementClass))

typedef struct _ValaReturnStatement ValaReturnStatement;
typedef struct _ValaReturnStatementClass ValaReturnStatementClass;

#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatement ValaYieldStatement;
typedef struct _ValaYieldStatementClass ValaYieldStatementClass;

#define VALA_TYPE_THROW_STATEMENT (vala_throw_statement_get_type ())
#define VALA_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatement))
#define VALA_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))
#define VALA_IS_THROW_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_THROW_STATEMENT))
#define VALA_IS_THROW_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_THROW_STATEMENT))
#define VALA_THROW_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_THROW_STATEMENT, ValaThrowStatementClass))

typedef struct _ValaThrowStatement ValaThrowStatement;
typedef struct _ValaThrowStatementClass ValaThrowStatementClass;

#define VALA_TYPE_TRY_STATEMENT (vala_try_statement_get_type ())
#define VALA_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatement))
#define VALA_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))
#define VALA_IS_TRY_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TRY_STATEMENT))
#define VALA_IS_TRY_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TRY_STATEMENT))
#define VALA_TRY_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TRY_STATEMENT, ValaTryStatementClass))

typedef struct _ValaTryStatement ValaTryStatement;
typedef struct _ValaTryStatementClass ValaTryStatementClass;

#define VALA_TYPE_CATCH_CLAUSE (vala_catch_clause_get_type ())
#define VALA_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClause))
#define VALA_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))
#define VALA_IS_CATCH_CLAUSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CATCH_CLAUSE))
#define VALA_IS_CATCH_CLAUSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CATCH_CLAUSE))
#define VALA_CATCH_CLAUSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CATCH_CLAUSE, ValaCatchClauseClass))

typedef struct _ValaCatchClause ValaCatchClause;
typedef struct _ValaCatchClauseClass ValaCatchClauseClass;

#define VALA_TYPE_LOCK_STATEMENT (vala_lock_statement_get_type ())
#define VALA_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatement))
#define VALA_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))
#define VALA_IS_LOCK_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LOCK_STATEMENT))
#define VALA_IS_LOCK_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LOCK_STATEMENT))
#define VALA_LOCK_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementClass))

typedef struct _ValaLockStatement ValaLockStatement;
typedef struct _ValaLockStatementClass ValaLockStatementClass;

#define VALA_TYPE_DELETE_STATEMENT (vala_delete_statement_get_type ())
#define VALA_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatement))
#define VALA_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))
#define VALA_IS_DELETE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELETE_STATEMENT))
#define VALA_IS_DELETE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELETE_STATEMENT))
#define VALA_DELETE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELETE_STATEMENT, ValaDeleteStatementClass))

typedef struct _ValaDeleteStatement ValaDeleteStatement;
typedef struct _ValaDeleteStatementClass ValaDeleteStatementClass;

#define VALA_TYPE_ARRAY_CREATION_EXPRESSION (vala_array_creation_expression_get_type ())
#define VALA_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpression))
#define VALA_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))
#define VALA_IS_ARRAY_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_IS_ARRAY_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_CREATION_EXPRESSION))
#define VALA_ARRAY_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionClass))

typedef struct _ValaArrayCreationExpression ValaArrayCreationExpression;
typedef struct _ValaArrayCreationExpressionClass ValaArrayCreationExpressionClass;

#define VALA_TYPE_LITERAL (vala_literal_get_type ())
#define VALA_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LITERAL, ValaLiteral))
#define VALA_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LITERAL, ValaLiteralClass))
#define VALA_IS_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LITERAL))
#define VALA_IS_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LITERAL))
#define VALA_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LITERAL, ValaLiteralClass))

typedef struct _ValaLiteral ValaLiteral;
typedef struct _ValaLiteralClass ValaLiteralClass;

#define VALA_TYPE_BOOLEAN_LITERAL (vala_boolean_literal_get_type ())
#define VALA_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteral))
#define VALA_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))
#define VALA_IS_BOOLEAN_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_IS_BOOLEAN_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BOOLEAN_LITERAL))
#define VALA_BOOLEAN_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BOOLEAN_LITERAL, ValaBooleanLiteralClass))

typedef struct _ValaBooleanLiteral ValaBooleanLiteral;
typedef struct _ValaBooleanLiteralClass ValaBooleanLiteralClass;

#define VALA_TYPE_CHARACTER_LITERAL (vala_character_literal_get_type ())
#define VALA_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteral))
#define VALA_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))
#define VALA_IS_CHARACTER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_IS_CHARACTER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CHARACTER_LITERAL))
#define VALA_CHARACTER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CHARACTER_LITERAL, ValaCharacterLiteralClass))

typedef struct _ValaCharacterLiteral ValaCharacterLiteral;
typedef struct _ValaCharacterLiteralClass ValaCharacterLiteralClass;

#define VALA_TYPE_INTEGER_LITERAL (vala_integer_literal_get_type ())
#define VALA_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral))
#define VALA_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))
#define VALA_IS_INTEGER_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTEGER_LITERAL))
#define VALA_IS_INTEGER_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTEGER_LITERAL))
#define VALA_INTEGER_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteralClass))

typedef struct _ValaIntegerLiteral ValaIntegerLiteral;
typedef struct _ValaIntegerLiteralClass ValaIntegerLiteralClass;

#define VALA_TYPE_REAL_LITERAL (vala_real_literal_get_type ())
#define VALA_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteral))
#define VALA_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))
#define VALA_IS_REAL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REAL_LITERAL))
#define VALA_IS_REAL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REAL_LITERAL))
#define VALA_REAL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REAL_LITERAL, ValaRealLiteralClass))

typedef struct _ValaRealLiteral ValaRealLiteral;
typedef struct _ValaRealLiteralClass ValaRealLiteralClass;

#define VALA_TYPE_STRING_LITERAL (vala_string_literal_get_type ())
#define VALA_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteral))
#define VALA_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))
#define VALA_IS_STRING_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRING_LITERAL))
#define VALA_IS_STRING_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRING_LITERAL))
#define VALA_STRING_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRING_LITERAL, ValaStringLiteralClass))

typedef struct _ValaStringLiteral ValaStringLiteral;
typedef struct _ValaStringLiteralClass ValaStringLiteralClass;

#define VALA_TYPE_NULL_LITERAL (vala_null_literal_get_type ())
#define VALA_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteral))
#define VALA_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))
#define VALA_IS_NULL_LITERAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_NULL_LITERAL))
#define VALA_IS_NULL_LITERAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_NULL_LITERAL))
#define VALA_NULL_LITERAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_NULL_LITERAL, ValaNullLiteralClass))

typedef struct _ValaNullLiteral ValaNullLiteral;
typedef struct _ValaNullLiteralClass ValaNullLiteralClass;

#define VALA_TYPE_METHOD_CALL (vala_method_call_get_type ())
#define VALA_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCall))
#define VALA_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))
#define VALA_IS_METHOD_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_METHOD_CALL))
#define VALA_IS_METHOD_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_METHOD_CALL))
#define VALA_METHOD_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_METHOD_CALL, ValaMethodCallClass))

typedef struct _ValaMethodCall ValaMethodCall;
typedef struct _ValaMethodCallClass ValaMethodCallClass;

#define VALA_TYPE_ELEMENT_ACCESS (vala_element_access_get_type ())
#define VALA_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess))
#define VALA_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))
#define VALA_IS_ELEMENT_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_IS_ELEMENT_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ELEMENT_ACCESS))
#define VALA_ELEMENT_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ELEMENT_ACCESS, ValaElementAccessClass))

typedef struct _ValaElementAccess ValaElementAccess;
typedef struct _ValaElementAccessClass ValaElementAccessClass;

#define VALA_TYPE_BASE_ACCESS (vala_base_access_get_type ())
#define VALA_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccess))
#define VALA_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))
#define VALA_IS_BASE_ACCESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BASE_ACCESS))
#define VALA_IS_BASE_ACCESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BASE_ACCESS))
#define VALA_BASE_ACCESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BASE_ACCESS, ValaBaseAccessClass))

typedef struct _ValaBaseAccess ValaBaseAccess;
typedef struct _ValaBaseAccessClass ValaBaseAccessClass;

#define VALA_TYPE_POSTFIX_EXPRESSION (vala_postfix_expression_get_type ())
#define VALA_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpression))
#define VALA_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))
#define VALA_IS_POSTFIX_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_IS_POSTFIX_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POSTFIX_EXPRESSION))
#define VALA_POSTFIX_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionClass))

typedef struct _ValaPostfixExpression ValaPostfixExpression;
typedef struct _ValaPostfixExpressionClass ValaPostfixExpressionClass;

#define VALA_TYPE_OBJECT_CREATION_EXPRESSION (vala_object_creation_expression_get_type ())
#define VALA_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression))
#define VALA_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))
#define VALA_IS_OBJECT_CREATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_IS_OBJECT_CREATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_OBJECT_CREATION_EXPRESSION))
#define VALA_OBJECT_CREATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionClass))

typedef struct _ValaObjectCreationExpression ValaObjectCreationExpression;
typedef struct _ValaObjectCreationExpressionClass ValaObjectCreationExpressionClass;

#define VALA_TYPE_SIZEOF_EXPRESSION (vala_sizeof_expression_get_type ())
#define VALA_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpression))
#define VALA_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))
#define VALA_IS_SIZEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_IS_SIZEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SIZEOF_EXPRESSION))
#define VALA_SIZEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SIZEOF_EXPRESSION, ValaSizeofExpressionClass))

typedef struct _ValaSizeofExpression ValaSizeofExpression;
typedef struct _ValaSizeofExpressionClass ValaSizeofExpressionClass;

#define VALA_TYPE_TYPEOF_EXPRESSION (vala_typeof_expression_get_type ())
#define VALA_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpression))
#define VALA_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))
#define VALA_IS_TYPEOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_IS_TYPEOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPEOF_EXPRESSION))
#define VALA_TYPEOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionClass))

typedef struct _ValaTypeofExpression ValaTypeofExpression;
typedef struct _ValaTypeofExpressionClass ValaTypeofExpressionClass;

#define VALA_TYPE_UNARY_EXPRESSION (vala_unary_expression_get_type ())
#define VALA_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression))
#define VALA_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))
#define VALA_IS_UNARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_IS_UNARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_UNARY_EXPRESSION))
#define VALA_UNARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionClass))

typedef struct _ValaUnaryExpression ValaUnaryExpression;
typedef struct _ValaUnaryExpressionClass ValaUnaryExpressionClass;

#define VALA_TYPE_CAST_EXPRESSION (vala_cast_expression_get_type ())
#define VALA_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpression))
#define VALA_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))
#define VALA_IS_CAST_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CAST_EXPRESSION))
#define VALA_IS_CAST_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CAST_EXPRESSION))
#define VALA_CAST_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CAST_EXPRESSION, ValaCastExpressionClass))

typedef struct _ValaCastExpression ValaCastExpression;
typedef struct _ValaCastExpressionClass ValaCastExpressionClass;

#define VALA_TYPE_POINTER_INDIRECTION (vala_pointer_indirection_get_type ())
#define VALA_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection))
#define VALA_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))
#define VALA_IS_POINTER_INDIRECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_IS_POINTER_INDIRECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_POINTER_INDIRECTION))
#define VALA_POINTER_INDIRECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirectionClass))

typedef struct _ValaPointerIndirection ValaPointerIndirection;
typedef struct _ValaPointerIndirectionClass ValaPointerIndirectionClass;

#define VALA_TYPE_ADDRESSOF_EXPRESSION (vala_addressof_expression_get_type ())
#define VALA_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpression))
#define VALA_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))
#define VALA_IS_ADDRESSOF_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_IS_ADDRESSOF_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ADDRESSOF_EXPRESSION))
#define VALA_ADDRESSOF_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ADDRESSOF_EXPRESSION, ValaAddressofExpressionClass))

typedef struct _ValaAddressofExpression ValaAddressofExpression;
typedef struct _ValaAddressofExpressionClass ValaAddressofExpressionClass;

#define VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION (vala_reference_transfer_expression_get_type ())
#define VALA_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpression))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_IS_REFERENCE_TRANSFER_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION))
#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionClass))

typedef struct _ValaReferenceTransferExpression ValaReferenceTransferExpression;
typedef struct _ValaReferenceTransferExpressionClass ValaReferenceTransferExpressionClass;

#define VALA_TYPE_BINARY_EXPRESSION (vala_binary_expression_get_type ())
#define VALA_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression))
#define VALA_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))
#define VALA_IS_BINARY_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_IS_BINARY_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_BINARY_EXPRESSION))
#define VALA_BINARY_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpressionClass))

typedef struct _ValaBinaryExpression ValaBinaryExpression;
typedef struct _ValaBinaryExpressionClass ValaBinaryExpressionClass;

#define VALA_TYPE_TYPECHECK (vala_typecheck_get_type ())
#define VALA_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheck))
#define VALA_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))
#define VALA_IS_TYPECHECK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_TYPECHECK))
#define VALA_IS_TYPECHECK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_TYPECHECK))
#define VALA_TYPECHECK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_TYPECHECK, ValaTypeCheckClass))

typedef struct _ValaTypeCheck ValaTypeCheck;
typedef struct _ValaTypeCheckClass ValaTypeCheckClass;

#define VALA_TYPE_CONDITIONAL_EXPRESSION (vala_conditional_expression_get_type ())
#define VALA_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression))
#define VALA_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))
#define VALA_IS_CONDITIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_IS_CONDITIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CONDITIONAL_EXPRESSION))
#define VALA_CONDITIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionClass))

typedef struct _ValaConditionalExpression ValaConditionalExpression;
typedef struct _ValaConditionalExpressionClass ValaConditionalExpressionClass;

#define VALA_TYPE_LAMBDA_EXPRESSION (vala_lambda_expression_get_type ())
#define VALA_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression))
#define VALA_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))
#define VALA_IS_LAMBDA_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_IS_LAMBDA_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_LAMBDA_EXPRESSION))
#define VALA_LAMBDA_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionClass))

typedef struct _ValaLambdaExpression ValaLambdaExpression;
typedef struct _ValaLambdaExpressionClass ValaLambdaExpressionClass;

#define VALA_TYPE_ASSIGNMENT (vala_assignment_get_type ())
#define VALA_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignment))
#define VALA_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))
#define VALA_IS_ASSIGNMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ASSIGNMENT))
#define VALA_IS_ASSIGNMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ASSIGNMENT))
#define VALA_ASSIGNMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ASSIGNMENT, ValaAssignmentClass))

typedef struct _ValaAssignment ValaAssignment;
typedef struct _ValaAssignmentClass ValaAssignmentClass;
typedef struct _ValaSemanticAnalyzerPrivate ValaSemanticAnalyzerPrivate;

#define VALA_TYPE_VALUE_TYPE (vala_value_type_get_type ())
#define VALA_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VALUE_TYPE, ValaValueType))
#define VALA_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))
#define VALA_IS_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VALUE_TYPE))
#define VALA_IS_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VALUE_TYPE))
#define VALA_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VALUE_TYPE, ValaValueTypeClass))

typedef struct _ValaValueType ValaValueType;
typedef struct _ValaValueTypeClass ValaValueTypeClass;

#define VALA_TYPE_STRUCT_VALUE_TYPE (vala_struct_value_type_get_type ())
#define VALA_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType))
#define VALA_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))
#define VALA_IS_STRUCT_VALUE_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_IS_STRUCT_VALUE_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_STRUCT_VALUE_TYPE))
#define VALA_STRUCT_VALUE_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueTypeClass))

typedef struct _ValaStructValueType ValaStructValueType;
typedef struct _ValaStructValueTypeClass ValaStructValueTypeClass;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_VOID_TYPE (vala_void_type_get_type ())
#define VALA_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_VOID_TYPE, ValaVoidType))
#define VALA_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))
#define VALA_IS_VOID_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_VOID_TYPE))
#define VALA_IS_VOID_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_VOID_TYPE))
#define VALA_VOID_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_VOID_TYPE, ValaVoidTypeClass))

typedef struct _ValaVoidType ValaVoidType;
typedef struct _ValaVoidTypeClass ValaVoidTypeClass;

#define VALA_TYPE_ARRAY_TYPE (vala_array_type_get_type ())
#define VALA_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayType))
#define VALA_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))
#define VALA_IS_ARRAY_TYPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ARRAY_TYPE))
#define VALA_IS_ARRAY_TYPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ARRAY_TYPE))
#define VALA_ARRAY_TYPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ARRAY_TYPE, ValaArrayTypeClass))

typedef struct _ValaArrayType ValaArrayType;
typedef struct _ValaArrayTypeClass ValaArrayTypeClass;

/**
 * Represents a part of the parsed source code.
 *
 * Code nodes get created by the parser and are used throughout the whole
 * compilation process.
 */
struct _ValaCodeNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeNodePrivate * priv;
	GList* attributes;
};

struct _ValaCodeNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeNode *self);
	void (*accept) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	void (*accept_children) (ValaCodeNode* self, ValaCodeVisitor* visitor);
	gboolean (*check) (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
	void (*replace_type) (ValaCodeNode* self, ValaDataType* old_type, ValaDataType* new_type);
	void (*replace_expression) (ValaCodeNode* self, ValaExpression* old_node, ValaExpression* new_node);
	char* (*to_string) (ValaCodeNode* self);
	void (*get_defined_variables) (ValaCodeNode* self, GeeCollection* collection);
	void (*get_used_variables) (ValaCodeNode* self, GeeCollection* collection);
};

/**
 * Represents a node in the symbol tree.
 */
struct _ValaSymbol {
	ValaCodeNode parent_instance;
	ValaSymbolPrivate * priv;
};

struct _ValaSymbolClass {
	ValaCodeNodeClass parent_class;
	char* (*get_cprefix) (ValaSymbol* self);
	char* (*get_lower_case_cname) (ValaSymbol* self, const char* infix);
	char* (*get_lower_case_cprefix) (ValaSymbol* self);
	GeeList* (*get_cheader_filenames) (ValaSymbol* self);
	gboolean (*is_instance_member) (ValaSymbol* self);
	gboolean (*is_class_member) (ValaSymbol* self);
};

/**
 * Represents a general class member.
 */
struct _ValaMember {
	ValaSymbol parent_instance;
	ValaMemberPrivate * priv;
};

struct _ValaMemberClass {
	ValaSymbolClass parent_class;
};

/**
 * Represents a type or namespace method.
 */
struct _ValaMethod {
	ValaMember parent_instance;
	ValaMethodPrivate * priv;
};

struct _ValaMethodClass {
	ValaMemberClass parent_class;
	char* (*get_default_cname) (ValaMethod* self);
	char* (*get_real_cname) (ValaMethod* self);
};

typedef enum  {
	MEMBER_BINDING_INSTANCE,
	MEMBER_BINDING_CLASS,
	MEMBER_BINDING_STATIC
} MemberBinding;

struct _ValaMethodPrivate {
	GeeList* type_parameters;
	ValaBasicBlock* _entry_block;
	ValaBasicBlock* _exit_block;
	MemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _returns_modified_pointer;
	gboolean _entry_point;
	ValaFormalParameter* _this_parameter;
	ValaLocalVariable* _result_var;
	double _cinstance_parameter_position;
	double _carray_length_parameter_position;
	double _cdelegate_target_parameter_position;
	gboolean _no_array_length;
	gboolean _array_null_terminated;
	gboolean _printf_format;
	gboolean _scanf_format;
	gboolean _has_construct_function;
	ValaSignal* _signal_reference;
	gboolean _coroutine;
	GeeList* parameters;
	char* cname;
	char* _vfunc_name;
	char* _sentinel;
	GeeList* preconditions;
	GeeList* postconditions;
	ValaDataType* _return_type;
	ValaBlock* _body;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	gboolean base_methods_valid;
};

typedef enum  {
	VALA_PARAMETER_DIRECTION_IN,
	VALA_PARAMETER_DIRECTION_OUT,
	VALA_PARAMETER_DIRECTION_REF
} ValaParameterDirection;

/**
 * Abstract code node visitor for traversing source code tree.
 */
struct _ValaCodeVisitor {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaCodeVisitorPrivate * priv;
};

struct _ValaCodeVisitorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaCodeVisitor *self);
	void (*visit_source_file) (ValaCodeVisitor* self, ValaSourceFile* source_file);
	void (*visit_namespace) (ValaCodeVisitor* self, ValaNamespace* ns);
	void (*visit_class) (ValaCodeVisitor* self, ValaClass* cl);
	void (*visit_struct) (ValaCodeVisitor* self, ValaStruct* st);
	void (*visit_interface) (ValaCodeVisitor* self, ValaInterface* iface);
	void (*visit_enum) (ValaCodeVisitor* self, ValaEnum* en);
	void (*visit_enum_value) (ValaCodeVisitor* self, ValaEnumValue* ev);
	void (*visit_error_domain) (ValaCodeVisitor* self, ValaErrorDomain* edomain);
	void (*visit_error_code) (ValaCodeVisitor* self, ValaErrorCode* ecode);
	void (*visit_delegate) (ValaCodeVisitor* self, ValaDelegate* d);
	void (*visit_member) (ValaCodeVisitor* self, ValaMember* m);
	void (*visit_constant) (ValaCodeVisitor* self, ValaConstant* c);
	void (*visit_field) (ValaCodeVisitor* self, ValaField* f);
	void (*visit_method) (ValaCodeVisitor* self, ValaMethod* m);
	void (*visit_creation_method) (ValaCodeVisitor* self, ValaCreationMethod* m);
	void (*visit_formal_parameter) (ValaCodeVisitor* self, ValaFormalParameter* p);
	void (*visit_property) (ValaCodeVisitor* self, ValaProperty* prop);
	void (*visit_property_accessor) (ValaCodeVisitor* self, ValaPropertyAccessor* acc);
	void (*visit_signal) (ValaCodeVisitor* self, ValaSignal* sig);
	void (*visit_constructor) (ValaCodeVisitor* self, ValaConstructor* c);
	void (*visit_destructor) (ValaCodeVisitor* self, ValaDestructor* d);
	void (*visit_type_parameter) (ValaCodeVisitor* self, ValaTypeParameter* p);
	void (*visit_using_directive) (ValaCodeVisitor* self, ValaUsingDirective* ns);
	void (*visit_data_type) (ValaCodeVisitor* self, ValaDataType* type);
	void (*visit_block) (ValaCodeVisitor* self, ValaBlock* b);
	void (*visit_empty_statement) (ValaCodeVisitor* self, ValaEmptyStatement* stmt);
	void (*visit_declaration_statement) (ValaCodeVisitor* self, ValaDeclarationStatement* stmt);
	void (*visit_local_variable) (ValaCodeVisitor* self, ValaLocalVariable* local);
	void (*visit_initializer_list) (ValaCodeVisitor* self, ValaInitializerList* list);
	void (*visit_expression_statement) (ValaCodeVisitor* self, ValaExpressionStatement* stmt);
	void (*visit_if_statement) (ValaCodeVisitor* self, ValaIfStatement* stmt);
	void (*visit_switch_statement) (ValaCodeVisitor* self, ValaSwitchStatement* stmt);
	void (*visit_switch_section) (ValaCodeVisitor* self, ValaSwitchSection* section);
	void (*visit_switch_label) (ValaCodeVisitor* self, ValaSwitchLabel* label);
	void (*visit_loop) (ValaCodeVisitor* self, ValaLoop* stmt);
	void (*visit_while_statement) (ValaCodeVisitor* self, ValaWhileStatement* stmt);
	void (*visit_do_statement) (ValaCodeVisitor* self, ValaDoStatement* stmt);
	void (*visit_for_statement) (ValaCodeVisitor* self, ValaForStatement* stmt);
	void (*visit_foreach_statement) (ValaCodeVisitor* self, ValaForeachStatement* stmt);
	void (*visit_break_statement) (ValaCodeVisitor* self, ValaBreakStatement* stmt);
	void (*visit_continue_statement) (ValaCodeVisitor* self, ValaContinueStatement* stmt);
	void (*visit_return_statement) (ValaCodeVisitor* self, ValaReturnStatement* stmt);
	void (*visit_yield_statement) (ValaCodeVisitor* self, ValaYieldStatement* y);
	void (*visit_throw_statement) (ValaCodeVisitor* self, ValaThrowStatement* stmt);
	void (*visit_try_statement) (ValaCodeVisitor* self, ValaTryStatement* stmt);
	void (*visit_catch_clause) (ValaCodeVisitor* self, ValaCatchClause* clause);
	void (*visit_lock_statement) (ValaCodeVisitor* self, ValaLockStatement* stmt);
	void (*visit_delete_statement) (ValaCodeVisitor* self, ValaDeleteStatement* stmt);
	void (*visit_expression) (ValaCodeVisitor* self, ValaExpression* expr);
	void (*visit_array_creation_expression) (ValaCodeVisitor* self, ValaArrayCreationExpression* expr);
	void (*visit_boolean_literal) (ValaCodeVisitor* self, ValaBooleanLiteral* lit);
	void (*visit_character_literal) (ValaCodeVisitor* self, ValaCharacterLiteral* lit);
	void (*visit_integer_literal) (ValaCodeVisitor* self, ValaIntegerLiteral* lit);
	void (*visit_real_literal) (ValaCodeVisitor* self, ValaRealLiteral* lit);
	void (*visit_string_literal) (ValaCodeVisitor* self, ValaStringLiteral* lit);
	void (*visit_null_literal) (ValaCodeVisitor* self, ValaNullLiteral* lit);
	void (*visit_member_access) (ValaCodeVisitor* self, ValaMemberAccess* expr);
	void (*visit_method_call) (ValaCodeVisitor* self, ValaMethodCall* expr);
	void (*visit_element_access) (ValaCodeVisitor* self, ValaElementAccess* expr);
	void (*visit_base_access) (ValaCodeVisitor* self, ValaBaseAccess* expr);
	void (*visit_postfix_expression) (ValaCodeVisitor* self, ValaPostfixExpression* expr);
	void (*visit_object_creation_expression) (ValaCodeVisitor* self, ValaObjectCreationExpression* expr);
	void (*visit_sizeof_expression) (ValaCodeVisitor* self, ValaSizeofExpression* expr);
	void (*visit_typeof_expression) (ValaCodeVisitor* self, ValaTypeofExpression* expr);
	void (*visit_unary_expression) (ValaCodeVisitor* self, ValaUnaryExpression* expr);
	void (*visit_cast_expression) (ValaCodeVisitor* self, ValaCastExpression* expr);
	void (*visit_pointer_indirection) (ValaCodeVisitor* self, ValaPointerIndirection* expr);
	void (*visit_addressof_expression) (ValaCodeVisitor* self, ValaAddressofExpression* expr);
	void (*visit_reference_transfer_expression) (ValaCodeVisitor* self, ValaReferenceTransferExpression* expr);
	void (*visit_binary_expression) (ValaCodeVisitor* self, ValaBinaryExpression* expr);
	void (*visit_type_check) (ValaCodeVisitor* self, ValaTypeCheck* expr);
	void (*visit_conditional_expression) (ValaCodeVisitor* self, ValaConditionalExpression* expr);
	void (*visit_lambda_expression) (ValaCodeVisitor* self, ValaLambdaExpression* expr);
	void (*visit_assignment) (ValaCodeVisitor* self, ValaAssignment* a);
	void (*visit_end_full_expression) (ValaCodeVisitor* self, ValaExpression* expr);
};

/**
 * Code visitor analyzing and checking code.
 */
struct _ValaSemanticAnalyzer {
	ValaCodeVisitor parent_instance;
	ValaSemanticAnalyzerPrivate * priv;
	ValaSymbol* root_symbol;
	ValaDataType* current_return_type;
	ValaClass* current_class;
	ValaStruct* current_struct;
	ValaBlock* insert_block;
	ValaDataType* bool_type;
	ValaDataType* string_type;
	ValaDataType* uchar_type;
	ValaDataType* short_type;
	ValaDataType* ushort_type;
	ValaDataType* int_type;
	ValaDataType* uint_type;
	ValaDataType* long_type;
	ValaDataType* ulong_type;
	ValaDataType* size_t_type;
	ValaDataType* ssize_t_type;
	ValaDataType* int8_type;
	ValaDataType* unichar_type;
	ValaDataType* double_type;
	ValaDataType* type_type;
	ValaClass* object_type;
	ValaStructValueType* gvalue_type;
	ValaDataType* glist_type;
	ValaDataType* gslist_type;
	ValaDataType* garray_type;
	ValaDataType* gvaluearray_type;
	ValaClass* gerror_type;
	gint next_lambda_id;
	GeeList* replaced_nodes;
};

struct _ValaSemanticAnalyzerClass {
	ValaCodeVisitorClass parent_class;
};


static gpointer vala_method_parent_class = NULL;

gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void);
GType vala_semantic_analyzer_get_type (void);
GType vala_data_type_get_type (void);
GType vala_expression_get_type (void);
GType vala_symbol_get_type (void);
GType vala_local_variable_get_type (void);
GType vala_attribute_get_type (void);
GType vala_member_get_type (void);
GType vala_method_get_type (void);
GType vala_typeparameter_get_type (void);
gpointer vala_basic_block_ref (gpointer instance);
void vala_basic_block_unref (gpointer instance);
GParamSpec* vala_param_spec_basic_block (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_basic_block (GValue* value, gpointer v_object);
gpointer vala_value_get_basic_block (const GValue* value);
GType vala_basic_block_get_type (void);
GType member_binding_get_type (void);
GType vala_formal_parameter_get_type (void);
GType vala_signal_get_type (void);
GType vala_block_get_type (void);
#define VALA_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD, ValaMethodPrivate))
enum  {
	VALA_METHOD_DUMMY_PROPERTY
};
#define VALA_METHOD_DEFAULT_SENTINEL "NULL"
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void);
ValaMember* vala_member_new (const char* name, ValaSourceReference* source_reference);
ValaMember* vala_member_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
void vala_method_set_return_type (ValaMethod* self, ValaDataType* value);
void vala_method_set_carray_length_parameter_position (ValaMethod* self, double value);
void vala_method_set_cdelegate_target_parameter_position (ValaMethod* self, double value);
ValaMethod* vala_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaMethod* vala_method_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_formal_parameter_set_cparameter_position (ValaFormalParameter* self, double value);
double vala_formal_parameter_get_cparameter_position (ValaFormalParameter* self);
void vala_formal_parameter_set_carray_length_parameter_position (ValaFormalParameter* self, double value);
void vala_formal_parameter_set_cdelegate_target_parameter_position (ValaFormalParameter* self, double value);
gboolean vala_formal_parameter_get_ellipsis (ValaFormalParameter* self);
gpointer vala_scope_ref (gpointer instance);
void vala_scope_unref (gpointer instance);
GParamSpec* vala_param_spec_scope (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_scope (GValue* value, gpointer v_object);
gpointer vala_value_get_scope (const GValue* value);
GType vala_scope_get_type (void);
ValaScope* vala_symbol_get_scope (ValaSymbol* self);
void vala_scope_add (ValaScope* self, const char* name, ValaSymbol* sym);
const char* vala_symbol_get_name (ValaSymbol* self);
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param);
GeeList* vala_method_get_parameters (ValaMethod* self);
void vala_scope_remove (ValaScope* self, const char* name);
void vala_method_clear_parameters (ValaMethod* self);
void vala_code_visitor_visit_method (ValaCodeVisitor* self, ValaMethod* m);
static void vala_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
ValaDataType* vala_method_get_return_type (ValaMethod* self);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
GeeList* vala_code_node_get_error_types (ValaCodeNode* self);
ValaLocalVariable* vala_method_get_result_var (ValaMethod* self);
ValaBlock* vala_method_get_body (ValaMethod* self);
static void vala_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
char* vala_method_get_default_cname (ValaMethod* self);
char* vala_method_get_cname (ValaMethod* self);
ValaSymbol* vala_symbol_get_parent_symbol (ValaSymbol* self);
char* vala_symbol_get_lower_case_cprefix (ValaSymbol* self);
static char* vala_method_real_get_default_cname (ValaMethod* self);
ValaMethod* vala_method_get_base_method (ValaMethod* self);
ValaMethod* vala_method_get_base_interface_method (ValaMethod* self);
char* vala_method_get_real_cname (ValaMethod* self);
static char* vala_method_real_get_real_cname (ValaMethod* self);
void vala_method_set_cname (ValaMethod* self, const char* cname);
gboolean vala_attribute_has_argument (ValaAttribute* self, const char* name);
char* vala_attribute_get_string (ValaAttribute* self, const char* name);
void vala_member_add_cheader_filename (ValaMember* self, const char* filename);
void vala_method_set_vfunc_name (ValaMethod* self, const char* value);
void vala_method_set_sentinel (ValaMethod* self, const char* value);
double vala_attribute_get_double (ValaAttribute* self, const char* name);
void vala_method_set_cinstance_parameter_position (ValaMethod* self, double value);
gboolean vala_attribute_get_bool (ValaAttribute* self, const char* name);
void vala_method_set_no_array_length (ValaMethod* self, gboolean value);
void vala_method_set_array_null_terminated (ValaMethod* self, gboolean value);
void vala_method_set_has_construct_function (ValaMethod* self, gboolean value);
static void vala_method_process_ccode_attribute (ValaMethod* self, ValaAttribute* a);
const char* vala_attribute_get_name (ValaAttribute* self);
void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value);
void vala_data_type_set_floating_reference (ValaDataType* self, gboolean value);
void vala_method_set_printf_format (ValaMethod* self, gboolean value);
void vala_method_set_scanf_format (ValaMethod* self, gboolean value);
void vala_method_process_attributes (ValaMethod* self);
MemberBinding vala_method_get_binding (ValaMethod* self);
GType vala_reference_type_get_type (void);
GType vala_object_type_get_type (void);
GType vala_typesymbol_get_type (void);
GType vala_object_type_symbol_get_type (void);
ValaObjectType* vala_object_type_new (ValaObjectTypeSymbol* type_symbol);
ValaObjectType* vala_object_type_construct (GType object_type, ValaObjectTypeSymbol* type_symbol);
ValaObjectTypeSymbol* vala_object_type_get_type_symbol (ValaObjectType* self);
GeeList* vala_object_type_symbol_get_type_parameters (ValaObjectTypeSymbol* self);
ValaGenericType* vala_generic_type_new (ValaTypeParameter* type_parameter);
ValaGenericType* vala_generic_type_construct (GType object_type, ValaTypeParameter* type_parameter);
GType vala_generic_type_get_type (void);
void vala_data_type_set_value_owned (ValaDataType* self, gboolean value);
void vala_data_type_add_type_argument (ValaDataType* self, ValaDataType* arg);
GType vala_member_access_get_type (void);
ValaDataType* vala_data_type_get_actual_type (ValaDataType* self, ValaDataType* derived_instance_type, ValaMemberAccess* method_access, ValaCodeNode* node_reference);
gboolean vala_data_type_equals (ValaDataType* self, ValaDataType* type2);
ValaDataType* vala_formal_parameter_get_parameter_type (ValaFormalParameter* self);
gboolean vala_data_type_compatible (ValaDataType* self, ValaDataType* target_type);
char* vala_code_node_to_string (ValaCodeNode* self);
gboolean vala_method_compatible (ValaMethod* self, ValaMethod* base_method, char** invalid_match);
void vala_method_add_type_parameter (ValaMethod* self, ValaTypeParameter* p);
GeeList* vala_method_get_type_parameters (ValaMethod* self);
gint vala_method_get_type_parameter_index (ValaMethod* self, const char* name);
void vala_code_node_set_parent_node (ValaCodeNode* self, ValaCodeNode* value);
void vala_method_add_precondition (ValaMethod* self, ValaExpression* precondition);
GeeList* vala_method_get_preconditions (ValaMethod* self);
void vala_method_add_postcondition (ValaMethod* self, ValaExpression* postcondition);
GeeList* vala_method_get_postconditions (ValaMethod* self);
static void vala_method_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
GType vala_class_get_type (void);
GType vala_creation_method_get_type (void);
static void vala_method_find_base_interface_method (ValaMethod* self, ValaClass* cl);
gboolean vala_method_get_is_virtual (ValaMethod* self);
gboolean vala_method_get_is_abstract (ValaMethod* self);
gboolean vala_method_get_overrides (ValaMethod* self);
static void vala_method_find_base_class_method (ValaMethod* self, ValaClass* cl);
GType vala_interface_get_type (void);
static void vala_method_find_base_methods (ValaMethod* self);
ValaSymbol* vala_scope_lookup (ValaScope* self, const char* name);
void vala_code_node_set_error (ValaCodeNode* self, gboolean value);
void vala_report_error (ValaSourceReference* source, const char* message);
ValaSourceReference* vala_code_node_get_source_reference (ValaCodeNode* self);
char* vala_symbol_get_full_name (ValaSymbol* self);
gboolean vala_signal_get_is_virtual (ValaSignal* self);
ValaMethod* vala_signal_get_default_handler (ValaSignal* self);
ValaClass* vala_class_get_base_class (ValaClass* self);
GeeList* vala_class_get_base_types (ValaClass* self);
ValaTypeSymbol* vala_data_type_get_data_type (ValaDataType* self);
gboolean vala_code_node_get_checked (ValaCodeNode* self);
gboolean vala_code_node_get_error (ValaCodeNode* self);
void vala_code_node_set_checked (ValaCodeNode* self, gboolean value);
gboolean vala_method_get_coroutine (ValaMethod* self);
GType vala_parameter_direction_get_type (void);
ValaParameterDirection vala_formal_parameter_get_direction (ValaFormalParameter* self);
gboolean vala_class_get_is_abstract (ValaClass* self);
gboolean vala_class_get_is_compact (ValaClass* self);
gboolean vala_symbol_get_external (ValaSymbol* self);
gboolean vala_symbol_get_external_package (ValaSymbol* self);
gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void);
ValaSourceFile* vala_semantic_analyzer_get_current_source_file (ValaSemanticAnalyzer* self);
ValaSymbol* vala_semantic_analyzer_get_current_symbol (ValaSemanticAnalyzer* self);
GType vala_namespace_get_type (void);
GType vala_struct_get_type (void);
GType vala_enum_get_type (void);
GType vala_enum_value_get_type (void);
GType vala_error_domain_get_type (void);
GType vala_error_code_get_type (void);
GType vala_delegate_get_type (void);
GType vala_constant_get_type (void);
GType vala_field_get_type (void);
GType vala_property_get_type (void);
GType vala_property_accessor_get_type (void);
GType vala_constructor_get_type (void);
GType vala_destructor_get_type (void);
GType vala_using_directive_get_type (void);
GType vala_empty_statement_get_type (void);
GType vala_declaration_statement_get_type (void);
GType vala_initializer_list_get_type (void);
GType vala_expression_statement_get_type (void);
GType vala_if_statement_get_type (void);
GType vala_switch_statement_get_type (void);
GType vala_switch_section_get_type (void);
GType vala_switch_label_get_type (void);
GType vala_loop_get_type (void);
GType vala_while_statement_get_type (void);
GType vala_do_statement_get_type (void);
GType vala_for_statement_get_type (void);
GType vala_foreach_statement_get_type (void);
GType vala_break_statement_get_type (void);
GType vala_continue_statement_get_type (void);
GType vala_return_statement_get_type (void);
GType vala_yield_statement_get_type (void);
GType vala_throw_statement_get_type (void);
GType vala_try_statement_get_type (void);
GType vala_catch_clause_get_type (void);
GType vala_lock_statement_get_type (void);
GType vala_delete_statement_get_type (void);
GType vala_array_creation_expression_get_type (void);
GType vala_literal_get_type (void);
GType vala_boolean_literal_get_type (void);
GType vala_character_literal_get_type (void);
GType vala_integer_literal_get_type (void);
GType vala_real_literal_get_type (void);
GType vala_string_literal_get_type (void);
GType vala_null_literal_get_type (void);
GType vala_method_call_get_type (void);
GType vala_element_access_get_type (void);
GType vala_base_access_get_type (void);
GType vala_postfix_expression_get_type (void);
GType vala_object_creation_expression_get_type (void);
GType vala_sizeof_expression_get_type (void);
GType vala_typeof_expression_get_type (void);
GType vala_unary_expression_get_type (void);
GType vala_cast_expression_get_type (void);
GType vala_pointer_indirection_get_type (void);
GType vala_addressof_expression_get_type (void);
GType vala_reference_transfer_expression_get_type (void);
GType vala_binary_expression_get_type (void);
GType vala_typecheck_get_type (void);
GType vala_conditional_expression_get_type (void);
GType vala_lambda_expression_get_type (void);
GType vala_assignment_get_type (void);
GType vala_value_type_get_type (void);
GType vala_struct_value_type_get_type (void);
ValaSourceFile* vala_source_reference_get_file (ValaSourceReference* self);
void vala_semantic_analyzer_set_current_source_file (ValaSemanticAnalyzer* self, ValaSourceFile* value);
void vala_semantic_analyzer_set_current_symbol (ValaSemanticAnalyzer* self, ValaSymbol* value);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
ValaAttribute* vala_code_node_get_attribute (ValaCodeNode* self, const char* name);
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
gboolean vala_member_get_hides (ValaMember* self);
ValaSymbol* vala_member_get_hidden_member (ValaMember* self);
void vala_report_warning (ValaSourceReference* source, const char* message);
gboolean vala_semantic_analyzer_is_type_accessible (ValaSemanticAnalyzer* self, ValaSymbol* sym, ValaDataType* type);
ValaDataType* vala_expression_get_value_type (ValaExpression* self);
gboolean vala_code_node_get_tree_can_fail (ValaCodeNode* self);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self, ValaSemanticAnalyzer* analyzer);
static void vala_method_set_entry_point (ValaMethod* self, gboolean value);
static gboolean vala_method_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
GType vala_void_type_get_type (void);
GType vala_array_type_get_type (void);
ValaDataType* vala_array_type_get_element_type (ValaArrayType* self);
void vala_symbol_set_owner (ValaSymbol* self, ValaScope* value);
void vala_method_set_body (ValaMethod* self, ValaBlock* value);
ValaBasicBlock* vala_method_get_entry_block (ValaMethod* self);
void vala_method_set_entry_block (ValaMethod* self, ValaBasicBlock* value);
ValaBasicBlock* vala_method_get_exit_block (ValaMethod* self);
void vala_method_set_exit_block (ValaMethod* self, ValaBasicBlock* value);
void vala_method_set_binding (ValaMethod* self, MemberBinding value);
const char* vala_method_get_vfunc_name (ValaMethod* self);
const char* vala_method_get_sentinel (ValaMethod* self);
void vala_method_set_is_abstract (ValaMethod* self, gboolean value);
void vala_method_set_is_virtual (ValaMethod* self, gboolean value);
void vala_method_set_overrides (ValaMethod* self, gboolean value);
gboolean vala_method_get_is_inline (ValaMethod* self);
void vala_method_set_is_inline (ValaMethod* self, gboolean value);
gboolean vala_method_get_returns_modified_pointer (ValaMethod* self);
gboolean vala_method_get_entry_point (ValaMethod* self);
ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self);
void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value);
void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value);
double vala_method_get_cinstance_parameter_position (ValaMethod* self);
double vala_method_get_carray_length_parameter_position (ValaMethod* self);
double vala_method_get_cdelegate_target_parameter_position (ValaMethod* self);
gboolean vala_method_get_no_array_length (ValaMethod* self);
gboolean vala_method_get_array_null_terminated (ValaMethod* self);
gboolean vala_method_get_printf_format (ValaMethod* self);
gboolean vala_method_get_scanf_format (ValaMethod* self);
gboolean vala_method_get_has_construct_function (ValaMethod* self);
ValaSignal* vala_method_get_signal_reference (ValaMethod* self);
void vala_method_set_signal_reference (ValaMethod* self, ValaSignal* value);
void vala_method_set_coroutine (ValaMethod* self, gboolean value);
static void vala_method_finalize (ValaCodeNode* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new method.
 *
 * @param name        method name
 * @param return_type method return type
 * @param source      reference to source code
 * @return            newly created method
 */
ValaMethod* vala_method_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaMethod* self;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_member_construct (object_type, name, source_reference);
	vala_method_set_return_type (self, return_type);
	vala_method_set_carray_length_parameter_position (self, (double) (-3));
	vala_method_set_cdelegate_target_parameter_position (self, (double) (-3));
	return self;
}


ValaMethod* vala_method_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference);
}


/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
void vala_method_add_parameter (ValaMethod* self, ValaFormalParameter* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	/* default C parameter position*/
	vala_formal_parameter_set_cparameter_position (param, (double) (gee_collection_get_size ((GeeCollection*) self->priv->parameters) + 1));
	vala_formal_parameter_set_carray_length_parameter_position (param, vala_formal_parameter_get_cparameter_position (param) + 0.1);
	vala_formal_parameter_set_cdelegate_target_parameter_position (param, vala_formal_parameter_get_cparameter_position (param) + 0.1);
	gee_collection_add ((GeeCollection*) self->priv->parameters, param);
	if (!vala_formal_parameter_get_ellipsis (param)) {
		vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) param), (ValaSymbol*) param);
	}
}


GeeList* vala_method_get_parameters (ValaMethod* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->parameters);
	return result;
}


/**
 * Remove all parameters from this method.
 */
void vala_method_clear_parameters (ValaMethod* self) {
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			if (!vala_formal_parameter_get_ellipsis (param)) {
				vala_scope_remove (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) param));
			}
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	gee_collection_clear ((GeeCollection*) self->priv->parameters);
}


static void vala_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}


static void vala_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	if (vala_method_get_return_type (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_method_get_return_type (self), visitor);
	}
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_code_node_accept ((ValaCodeNode*) param, visitor);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _error_type_it;
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_error_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		while (TRUE) {
			ValaDataType* error_type;
			if (!gee_iterator_next (_error_type_it)) {
				break;
			}
			error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
			vala_code_node_accept ((ValaCodeNode*) error_type, visitor);
			(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
		}
		(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
	}
	if (self->priv->_result_var != NULL) {
		vala_code_node_accept ((ValaCodeNode*) self->priv->_result_var, visitor);
	}
	{
		GeeIterator* _precondition_it;
		_precondition_it = gee_iterable_iterator ((GeeIterable*) self->priv->preconditions);
		while (TRUE) {
			ValaExpression* precondition;
			if (!gee_iterator_next (_precondition_it)) {
				break;
			}
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			vala_code_node_accept ((ValaCodeNode*) precondition, visitor);
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
		}
		(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
	}
	{
		GeeIterator* _postcondition_it;
		_postcondition_it = gee_iterable_iterator ((GeeIterable*) self->priv->postconditions);
		while (TRUE) {
			ValaExpression* postcondition;
			if (!gee_iterator_next (_postcondition_it)) {
				break;
			}
			postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
			vala_code_node_accept ((ValaCodeNode*) postcondition, visitor);
			(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
		}
		(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
	}
	if (vala_method_get_body (self) != NULL) {
		vala_code_node_accept ((ValaCodeNode*) vala_method_get_body (self), visitor);
	}
}


/**
 * Returns the interface name of this method as it is used in C code.
 *
 * @return the name to be used in C code
 */
char* vala_method_get_cname (ValaMethod* self) {
	char* result;
	const char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->cname == NULL) {
		char* _tmp0_;
		_tmp0_ = NULL;
		self->priv->cname = (_tmp0_ = vala_method_get_default_cname (self), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp0_);
	}
	_tmp1_ = NULL;
	result = (_tmp1_ = self->priv->cname, (_tmp1_ == NULL) ? NULL : g_strdup (_tmp1_));
	return result;
}


/**
 * Returns the default interface name of this method as it is used in C
 * code.
 *
 * @return the name to be used in C code by default
 */
static char* vala_method_real_get_default_cname (ValaMethod* self) {
	char* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = FALSE;
	if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "main") == 0) {
		_tmp0_ = vala_symbol_get_name (vala_symbol_get_parent_symbol ((ValaSymbol*) self)) == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		/* avoid conflict with generated main function*/
		result = g_strdup ("_main");
		return result;
	} else {
		if (g_str_has_prefix (vala_symbol_get_name ((ValaSymbol*) self), "_")) {
			char* _tmp1_;
			char* _tmp2_;
			_tmp1_ = NULL;
			_tmp2_ = NULL;
			result = (_tmp2_ = g_strdup_printf ("_%s%s", _tmp1_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), g_utf8_offset_to_pointer (vala_symbol_get_name ((ValaSymbol*) self), (glong) 1)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
			return result;
		} else {
			char* _tmp3_;
			char* _tmp4_;
			_tmp3_ = NULL;
			_tmp4_ = NULL;
			result = (_tmp4_ = g_strdup_printf ("%s%s", _tmp3_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
			return result;
		}
	}
}


char* vala_method_get_default_cname (ValaMethod* self) {
	return VALA_METHOD_GET_CLASS (self)->get_default_cname (self);
}


/**
 * Returns the implementation name of this data type as it is used in C
 * code.
 *
 * @return the name to be used in C code
 */
static char* vala_method_real_get_real_cname (ValaMethod* self) {
	char* result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = FALSE;
	if (vala_method_get_base_method (self) != NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_method_get_base_interface_method (self) != NULL;
	}
	if (_tmp0_) {
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = NULL;
		_tmp2_ = NULL;
		result = (_tmp2_ = g_strdup_printf ("%sreal_%s", _tmp1_ = vala_symbol_get_lower_case_cprefix (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), vala_symbol_get_name ((ValaSymbol*) self)), _tmp1_ = (g_free (_tmp1_), NULL), _tmp2_);
		return result;
	} else {
		result = vala_method_get_cname (self);
		return result;
	}
}


char* vala_method_get_real_cname (ValaMethod* self) {
	return VALA_METHOD_GET_CLASS (self)->get_real_cname (self);
}


/**
 * Sets the name of this method as it is used in C code.
 *
 * @param cname the name to be used in C code
 */
void vala_method_set_cname (ValaMethod* self, const char* cname) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->cname = (_tmp1_ = (_tmp0_ = cname, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->cname = (g_free (self->priv->cname), NULL), _tmp1_);
}


static void vala_method_process_ccode_attribute (ValaMethod* self, ValaAttribute* a) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	if (vala_attribute_has_argument (a, "cname")) {
		char* _tmp0_;
		_tmp0_ = NULL;
		vala_method_set_cname (self, _tmp0_ = vala_attribute_get_string (a, "cname"));
		_tmp0_ = (g_free (_tmp0_), NULL);
	}
	if (vala_attribute_has_argument (a, "cheader_filename")) {
		char* val;
		val = vala_attribute_get_string (a, "cheader_filename");
		{
			char** _tmp1_;
			char** filename_collection;
			int filename_collection_length1;
			int filename_it;
			_tmp1_ = NULL;
			filename_collection = _tmp1_ = g_strsplit (val, ",", 0);
			filename_collection_length1 = _vala_array_length (_tmp1_);
			for (filename_it = 0; filename_it < _vala_array_length (_tmp1_); filename_it = filename_it + 1) {
				const char* _tmp2_;
				char* filename;
				_tmp2_ = NULL;
				filename = (_tmp2_ = filename_collection[filename_it], (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_));
				{
					vala_member_add_cheader_filename ((ValaMember*) self, filename);
					filename = (g_free (filename), NULL);
				}
			}
			filename_collection = (_vala_array_free (filename_collection, filename_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		val = (g_free (val), NULL);
	}
	if (vala_attribute_has_argument (a, "vfunc_name")) {
		char* _tmp3_;
		_tmp3_ = NULL;
		vala_method_set_vfunc_name (self, _tmp3_ = vala_attribute_get_string (a, "vfunc_name"));
		_tmp3_ = (g_free (_tmp3_), NULL);
	}
	if (vala_attribute_has_argument (a, "sentinel")) {
		char* _tmp4_;
		_tmp4_ = NULL;
		vala_method_set_sentinel (self, _tmp4_ = vala_attribute_get_string (a, "sentinel"));
		_tmp4_ = (g_free (_tmp4_), NULL);
	}
	if (vala_attribute_has_argument (a, "instance_pos")) {
		vala_method_set_cinstance_parameter_position (self, vala_attribute_get_double (a, "instance_pos"));
	}
	if (vala_attribute_has_argument (a, "array_length")) {
		vala_method_set_no_array_length (self, !vala_attribute_get_bool (a, "array_length"));
	}
	if (vala_attribute_has_argument (a, "array_null_terminated")) {
		vala_method_set_array_null_terminated (self, vala_attribute_get_bool (a, "array_null_terminated"));
	}
	if (vala_attribute_has_argument (a, "array_length_pos")) {
		vala_method_set_carray_length_parameter_position (self, vala_attribute_get_double (a, "array_length_pos"));
	}
	if (vala_attribute_has_argument (a, "delegate_target_pos")) {
		vala_method_set_cdelegate_target_parameter_position (self, vala_attribute_get_double (a, "delegate_target_pos"));
	}
	if (vala_attribute_has_argument (a, "has_construct_function")) {
		vala_method_set_has_construct_function (self, vala_attribute_get_bool (a, "has_construct_function"));
	}
}


/**
 * Process all associated attributes.
 */
void vala_method_process_attributes (ValaMethod* self) {
	g_return_if_fail (self != NULL);
	{
		GList* a_collection;
		GList* a_it;
		a_collection = ((ValaCodeNode*) self)->attributes;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			ValaAttribute* _tmp0_;
			ValaAttribute* a;
			_tmp0_ = NULL;
			a = (_tmp0_ = (ValaAttribute*) a_it->data, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			{
				if (_vala_strcmp0 (vala_attribute_get_name (a), "CCode") == 0) {
					vala_method_process_ccode_attribute (self, a);
				} else {
					if (_vala_strcmp0 (vala_attribute_get_name (a), "ReturnsModifiedPointer") == 0) {
						vala_method_set_returns_modified_pointer (self, TRUE);
					} else {
						if (_vala_strcmp0 (vala_attribute_get_name (a), "FloatingReference") == 0) {
							vala_data_type_set_floating_reference (vala_method_get_return_type (self), TRUE);
						} else {
							if (_vala_strcmp0 (vala_attribute_get_name (a), "PrintfFormat") == 0) {
								vala_method_set_printf_format (self, TRUE);
							} else {
								if (_vala_strcmp0 (vala_attribute_get_name (a), "ScanfFormat") == 0) {
									vala_method_set_scanf_format (self, TRUE);
								}
							}
						}
					}
				}
				(a == NULL) ? NULL : (a = (vala_code_node_unref (a), NULL));
			}
		}
	}
}


/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean vala_method_compatible (ValaMethod* self, ValaMethod* base_method, char** invalid_match) {
	gboolean result;
	ValaObjectType* object_type;
	ValaDataType* actual_base_type;
	GeeIterator* method_params_it;
	gint param_index;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (invalid_match != NULL) {
		*invalid_match = NULL;
	}
	if (self->priv->_binding != base_method->priv->_binding) {
		char* _tmp0_;
		_tmp0_ = NULL;
		(*invalid_match) = (_tmp0_ = g_strdup ("incompatible binding"), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp0_);
		result = FALSE;
		return result;
	}
	object_type = NULL;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
		ValaObjectType* _tmp1_;
		_tmp1_ = NULL;
		object_type = (_tmp1_ = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (vala_symbol_get_parent_symbol ((ValaSymbol*) self))), (object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL)), _tmp1_);
		{
			GeeList* _tmp2_;
			GeeIterator* _tmp3_;
			GeeIterator* _type_parameter_it;
			_tmp2_ = NULL;
			_tmp3_ = NULL;
			_type_parameter_it = (_tmp3_ = gee_iterable_iterator ((GeeIterable*) (_tmp2_ = vala_object_type_symbol_get_type_parameters (vala_object_type_get_type_symbol (object_type)))), (_tmp2_ == NULL) ? NULL : (_tmp2_ = (gee_collection_object_unref (_tmp2_), NULL)), _tmp3_);
			while (TRUE) {
				ValaTypeParameter* type_parameter;
				ValaGenericType* type_arg;
				if (!gee_iterator_next (_type_parameter_it)) {
					break;
				}
				type_parameter = (ValaTypeParameter*) gee_iterator_get (_type_parameter_it);
				type_arg = vala_generic_type_new (type_parameter);
				vala_data_type_set_value_owned ((ValaDataType*) type_arg, TRUE);
				vala_data_type_add_type_argument ((ValaDataType*) object_type, (ValaDataType*) type_arg);
				(type_parameter == NULL) ? NULL : (type_parameter = (vala_code_node_unref (type_parameter), NULL));
				(type_arg == NULL) ? NULL : (type_arg = (vala_code_node_unref (type_arg), NULL));
			}
			(_type_parameter_it == NULL) ? NULL : (_type_parameter_it = (gee_collection_object_unref (_type_parameter_it), NULL));
		}
	}
	actual_base_type = vala_data_type_get_actual_type (vala_method_get_return_type (base_method), (ValaDataType*) object_type, NULL, (ValaCodeNode*) self);
	if (!vala_data_type_equals (vala_method_get_return_type (self), actual_base_type)) {
		char* _tmp4_;
		_tmp4_ = NULL;
		(*invalid_match) = (_tmp4_ = g_strdup ("incompatible return type"), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp4_);
		result = FALSE;
		(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
		(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
		return result;
	}
	method_params_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
	param_index = 1;
	{
		GeeIterator* _base_param_it;
		_base_param_it = gee_iterable_iterator ((GeeIterable*) base_method->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* base_param;
			ValaDataType* _tmp6_;
			ValaFormalParameter* _tmp7_;
			gboolean _tmp8_;
			if (!gee_iterator_next (_base_param_it)) {
				break;
			}
			base_param = (ValaFormalParameter*) gee_iterator_get (_base_param_it);
			/* this method may not expect less arguments */
			if (!gee_iterator_next (method_params_it)) {
				char* _tmp5_;
				_tmp5_ = NULL;
				(*invalid_match) = (_tmp5_ = g_strdup ("too few parameters"), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp5_);
				result = FALSE;
				(base_param == NULL) ? NULL : (base_param = (vala_code_node_unref (base_param), NULL));
				(_base_param_it == NULL) ? NULL : (_base_param_it = (gee_collection_object_unref (_base_param_it), NULL));
				(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
				(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
				(method_params_it == NULL) ? NULL : (method_params_it = (gee_collection_object_unref (method_params_it), NULL));
				return result;
			}
			_tmp6_ = NULL;
			actual_base_type = (_tmp6_ = vala_data_type_get_actual_type (vala_formal_parameter_get_parameter_type (base_param), (ValaDataType*) object_type, NULL, (ValaCodeNode*) self), (actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL)), _tmp6_);
			_tmp7_ = NULL;
			if ((_tmp8_ = !vala_data_type_equals (actual_base_type, vala_formal_parameter_get_parameter_type (_tmp7_ = (ValaFormalParameter*) gee_iterator_get (method_params_it))), (_tmp7_ == NULL) ? NULL : (_tmp7_ = (vala_code_node_unref (_tmp7_), NULL)), _tmp8_)) {
				char* _tmp9_;
				_tmp9_ = NULL;
				(*invalid_match) = (_tmp9_ = g_strdup_printf ("incompatible type of parameter %d", param_index), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp9_);
				result = FALSE;
				(base_param == NULL) ? NULL : (base_param = (vala_code_node_unref (base_param), NULL));
				(_base_param_it == NULL) ? NULL : (_base_param_it = (gee_collection_object_unref (_base_param_it), NULL));
				(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
				(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
				(method_params_it == NULL) ? NULL : (method_params_it = (gee_collection_object_unref (method_params_it), NULL));
				return result;
			}
			param_index++;
			(base_param == NULL) ? NULL : (base_param = (vala_code_node_unref (base_param), NULL));
		}
		(_base_param_it == NULL) ? NULL : (_base_param_it = (gee_collection_object_unref (_base_param_it), NULL));
	}
	/* this method may not expect more arguments */
	if (gee_iterator_next (method_params_it)) {
		char* _tmp10_;
		_tmp10_ = NULL;
		(*invalid_match) = (_tmp10_ = g_strdup ("too many parameters"), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp10_);
		result = FALSE;
		(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
		(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
		(method_params_it == NULL) ? NULL : (method_params_it = (gee_collection_object_unref (method_params_it), NULL));
		return result;
	}
	/* this method may throw less but not more errors than the base method */
	{
		GeeList* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _method_error_type_it;
		/* this method may throw less but not more errors than the base method */
		_tmp11_ = NULL;
		_tmp12_ = NULL;
		_method_error_type_it = (_tmp12_ = gee_iterable_iterator ((GeeIterable*) (_tmp11_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp11_ == NULL) ? NULL : (_tmp11_ = (gee_collection_object_unref (_tmp11_), NULL)), _tmp12_);
		/* this method may throw less but not more errors than the base method */
		while (TRUE) {
			ValaDataType* method_error_type;
			gboolean match;
			/* this method may throw less but not more errors than the base method */
			if (!gee_iterator_next (_method_error_type_it)) {
				/* this method may throw less but not more errors than the base method */
				break;
			}
			/* this method may throw less but not more errors than the base method */
			method_error_type = (ValaDataType*) gee_iterator_get (_method_error_type_it);
			match = FALSE;
			{
				GeeList* _tmp13_;
				GeeIterator* _tmp14_;
				GeeIterator* _base_method_error_type_it;
				_tmp13_ = NULL;
				_tmp14_ = NULL;
				_base_method_error_type_it = (_tmp14_ = gee_iterable_iterator ((GeeIterable*) (_tmp13_ = vala_code_node_get_error_types ((ValaCodeNode*) base_method))), (_tmp13_ == NULL) ? NULL : (_tmp13_ = (gee_collection_object_unref (_tmp13_), NULL)), _tmp14_);
				while (TRUE) {
					ValaDataType* base_method_error_type;
					if (!gee_iterator_next (_base_method_error_type_it)) {
						break;
					}
					base_method_error_type = (ValaDataType*) gee_iterator_get (_base_method_error_type_it);
					if (vala_data_type_compatible (method_error_type, base_method_error_type)) {
						match = TRUE;
						(base_method_error_type == NULL) ? NULL : (base_method_error_type = (vala_code_node_unref (base_method_error_type), NULL));
						break;
					}
					(base_method_error_type == NULL) ? NULL : (base_method_error_type = (vala_code_node_unref (base_method_error_type), NULL));
				}
				(_base_method_error_type_it == NULL) ? NULL : (_base_method_error_type_it = (gee_collection_object_unref (_base_method_error_type_it), NULL));
			}
			if (!match) {
				char* _tmp16_;
				char* _tmp15_;
				_tmp16_ = NULL;
				_tmp15_ = NULL;
				(*invalid_match) = (_tmp16_ = g_strdup_printf ("incompatible error type `%s'", _tmp15_ = vala_code_node_to_string ((ValaCodeNode*) method_error_type)), (*invalid_match) = (g_free ((*invalid_match)), NULL), _tmp16_);
				_tmp15_ = (g_free (_tmp15_), NULL);
				result = FALSE;
				(method_error_type == NULL) ? NULL : (method_error_type = (vala_code_node_unref (method_error_type), NULL));
				(_method_error_type_it == NULL) ? NULL : (_method_error_type_it = (gee_collection_object_unref (_method_error_type_it), NULL));
				(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
				(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
				(method_params_it == NULL) ? NULL : (method_params_it = (gee_collection_object_unref (method_params_it), NULL));
				return result;
			}
			(method_error_type == NULL) ? NULL : (method_error_type = (vala_code_node_unref (method_error_type), NULL));
		}
		(_method_error_type_it == NULL) ? NULL : (_method_error_type_it = (gee_collection_object_unref (_method_error_type_it), NULL));
	}
	result = TRUE;
	(object_type == NULL) ? NULL : (object_type = (vala_code_node_unref (object_type), NULL));
	(actual_base_type == NULL) ? NULL : (actual_base_type = (vala_code_node_unref (actual_base_type), NULL));
	(method_params_it == NULL) ? NULL : (method_params_it = (gee_collection_object_unref (method_params_it), NULL));
	return result;
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_method_add_type_parameter (ValaMethod* self, ValaTypeParameter* p) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	gee_collection_add ((GeeCollection*) self->priv->type_parameters, p);
	vala_scope_add (vala_symbol_get_scope ((ValaSymbol*) self), vala_symbol_get_name ((ValaSymbol*) p), (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
GeeList* vala_method_get_type_parameters (ValaMethod* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->type_parameters);
	return result;
}


gint vala_method_get_type_parameter_index (ValaMethod* self, const char* name) {
	gint result;
	gint i;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		GeeIterator* _parameter_it;
		_parameter_it = gee_iterable_iterator ((GeeIterable*) self->priv->type_parameters);
		while (TRUE) {
			ValaTypeParameter* parameter;
			if (!gee_iterator_next (_parameter_it)) {
				break;
			}
			parameter = (ValaTypeParameter*) gee_iterator_get (_parameter_it);
			if (_vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) parameter), name) == 0) {
				result = i;
				(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
				(_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL));
				return result;
			}
			i++;
			(parameter == NULL) ? NULL : (parameter = (vala_code_node_unref (parameter), NULL));
		}
		(_parameter_it == NULL) ? NULL : (_parameter_it = (gee_collection_object_unref (_parameter_it), NULL));
	}
	result = -1;
	return result;
}


/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void vala_method_add_precondition (ValaMethod* self, ValaExpression* precondition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	gee_collection_add ((GeeCollection*) self->priv->preconditions, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
GeeList* vala_method_get_preconditions (ValaMethod* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->preconditions);
	return result;
}


/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void vala_method_add_postcondition (ValaMethod* self, ValaExpression* postcondition) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	gee_collection_add ((GeeCollection*) self->priv->postconditions, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
GeeList* vala_method_get_postconditions (ValaMethod* self) {
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = (GeeList*) gee_read_only_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, self->priv->postconditions);
	return result;
}


static void vala_method_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaMethod * self;
	GeeList* error_types;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_method_get_return_type (self) == old_type) {
		vala_method_set_return_type (self, new_type);
		return;
	}
	error_types = vala_code_node_get_error_types ((ValaCodeNode*) self);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaDataType* _tmp1_;
				gboolean _tmp2_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < gee_collection_get_size ((GeeCollection*) error_types))) {
					break;
				}
				_tmp1_ = NULL;
				if ((_tmp2_ = (_tmp1_ = (ValaDataType*) gee_list_get (error_types, i)) == old_type, (_tmp1_ == NULL) ? NULL : (_tmp1_ = (vala_code_node_unref (_tmp1_), NULL)), _tmp2_)) {
					gee_list_set (error_types, i, new_type);
					(error_types == NULL) ? NULL : (error_types = (gee_collection_object_unref (error_types), NULL));
					return;
				}
			}
		}
	}
	(error_types == NULL) ? NULL : (error_types = (gee_collection_object_unref (error_types), NULL));
}


static void vala_method_find_base_methods (ValaMethod* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			gboolean _tmp0_;
			gboolean _tmp1_;
			vala_method_find_base_interface_method (self, VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
			_tmp0_ = FALSE;
			_tmp1_ = FALSE;
			if (self->priv->_is_virtual) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = self->priv->_is_abstract;
			}
			if (_tmp1_) {
				_tmp0_ = TRUE;
			} else {
				_tmp0_ = self->priv->_overrides;
			}
			if (_tmp0_) {
				vala_method_find_base_class_method (self, VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)));
			}
		}
	} else {
		if (VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			gboolean _tmp2_;
			_tmp2_ = FALSE;
			if (self->priv->_is_virtual) {
				_tmp2_ = TRUE;
			} else {
				_tmp2_ = self->priv->_is_abstract;
			}
			if (_tmp2_) {
				ValaMethod* _tmp4_;
				ValaMethod* _tmp3_;
				_tmp4_ = NULL;
				_tmp3_ = NULL;
				self->priv->_base_interface_method = (_tmp4_ = (_tmp3_ = self, (_tmp3_ == NULL) ? NULL : vala_code_node_ref (_tmp3_)), (self->priv->_base_interface_method == NULL) ? NULL : (self->priv->_base_interface_method = (vala_code_node_unref (self->priv->_base_interface_method), NULL)), _tmp4_);
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}


static void vala_method_find_base_class_method (ValaMethod* self, ValaClass* cl) {
	ValaSymbol* sym;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) cl), vala_symbol_get_name ((ValaSymbol*) self));
	if (VALA_IS_METHOD (sym)) {
		ValaMethod* _tmp0_;
		ValaMethod* base_method;
		gboolean _tmp1_;
		_tmp0_ = NULL;
		base_method = (_tmp0_ = VALA_METHOD (sym), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
		_tmp1_ = FALSE;
		if (base_method->priv->_is_abstract) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = base_method->priv->_is_virtual;
		}
		if (_tmp1_) {
			char* invalid_match;
			char* _tmp4_;
			gboolean _tmp3_;
			char* _tmp2_;
			invalid_match = NULL;
			_tmp4_ = NULL;
			_tmp2_ = NULL;
			if (!(_tmp3_ = vala_method_compatible (self, base_method, &_tmp2_), invalid_match = (_tmp4_ = _tmp2_, invalid_match = (g_free (invalid_match), NULL), _tmp4_), _tmp3_)) {
				char* _tmp7_;
				char* _tmp6_;
				char* _tmp5_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp7_ = NULL;
				_tmp6_ = NULL;
				_tmp5_ = NULL;
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp7_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp5_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp6_ = vala_symbol_get_full_name ((ValaSymbol*) base_method), invalid_match));
				_tmp7_ = (g_free (_tmp7_), NULL);
				_tmp6_ = (g_free (_tmp6_), NULL);
				_tmp5_ = (g_free (_tmp5_), NULL);
				invalid_match = (g_free (invalid_match), NULL);
				(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return;
			}
			self->priv->_base_method = base_method;
			invalid_match = (g_free (invalid_match), NULL);
			(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
			(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			return;
		}
		(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
	} else {
		if (VALA_IS_SIGNAL (sym)) {
			ValaSignal* _tmp8_;
			ValaSignal* sig;
			_tmp8_ = NULL;
			sig = (_tmp8_ = VALA_SIGNAL (sym), (_tmp8_ == NULL) ? NULL : vala_code_node_ref (_tmp8_));
			if (vala_signal_get_is_virtual (sig)) {
				ValaMethod* _tmp9_;
				ValaMethod* base_method;
				char* invalid_match;
				char* _tmp12_;
				gboolean _tmp11_;
				char* _tmp10_;
				_tmp9_ = NULL;
				base_method = (_tmp9_ = vala_signal_get_default_handler (sig), (_tmp9_ == NULL) ? NULL : vala_code_node_ref (_tmp9_));
				invalid_match = NULL;
				_tmp12_ = NULL;
				_tmp10_ = NULL;
				if (!(_tmp11_ = vala_method_compatible (self, base_method, &_tmp10_), invalid_match = (_tmp12_ = _tmp10_, invalid_match = (g_free (invalid_match), NULL), _tmp12_), _tmp11_)) {
					char* _tmp15_;
					char* _tmp14_;
					char* _tmp13_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp15_ = NULL;
					_tmp14_ = NULL;
					_tmp13_ = NULL;
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp15_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp14_ = vala_symbol_get_full_name ((ValaSymbol*) base_method), invalid_match));
					_tmp15_ = (g_free (_tmp15_), NULL);
					_tmp14_ = (g_free (_tmp14_), NULL);
					_tmp13_ = (g_free (_tmp13_), NULL);
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
					invalid_match = (g_free (invalid_match), NULL);
					(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
					(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
					return;
				}
				self->priv->_base_method = base_method;
				(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
				invalid_match = (g_free (invalid_match), NULL);
				(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
				return;
			}
			(sig == NULL) ? NULL : (sig = (vala_code_node_unref (sig), NULL));
		}
	}
	if (vala_class_get_base_class (cl) != NULL) {
		vala_method_find_base_class_method (self, vala_class_get_base_class (cl));
	}
	(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
}


static void vala_method_find_base_interface_method (ValaMethod* self, ValaClass* cl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	/* FIXME report error if multiple possible base methods are found*/
	{
		GeeList* _tmp0_;
		GeeIterator* _tmp1_;
		GeeIterator* _type_it;
		/* FIXME report error if multiple possible base methods are found*/
		_tmp0_ = NULL;
		_tmp1_ = NULL;
		_type_it = (_tmp1_ = gee_iterable_iterator ((GeeIterable*) (_tmp0_ = vala_class_get_base_types (cl))), (_tmp0_ == NULL) ? NULL : (_tmp0_ = (gee_collection_object_unref (_tmp0_), NULL)), _tmp1_);
		/* FIXME report error if multiple possible base methods are found*/
		while (TRUE) {
			ValaDataType* type;
			/* FIXME report error if multiple possible base methods are found*/
			if (!gee_iterator_next (_type_it)) {
				/* FIXME report error if multiple possible base methods are found*/
				break;
			}
			/* FIXME report error if multiple possible base methods are found*/
			type = (ValaDataType*) gee_iterator_get (_type_it);
			if (VALA_IS_INTERFACE (vala_data_type_get_data_type (type))) {
				ValaSymbol* sym;
				sym = vala_scope_lookup (vala_symbol_get_scope ((ValaSymbol*) vala_data_type_get_data_type (type)), vala_symbol_get_name ((ValaSymbol*) self));
				if (VALA_IS_METHOD (sym)) {
					ValaMethod* _tmp2_;
					ValaMethod* base_method;
					gboolean _tmp3_;
					_tmp2_ = NULL;
					base_method = (_tmp2_ = VALA_METHOD (sym), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
					_tmp3_ = FALSE;
					if (base_method->priv->_is_abstract) {
						_tmp3_ = TRUE;
					} else {
						_tmp3_ = base_method->priv->_is_virtual;
					}
					if (_tmp3_) {
						char* invalid_match;
						char* _tmp6_;
						gboolean _tmp5_;
						char* _tmp4_;
						ValaMethod* _tmp11_;
						ValaMethod* _tmp10_;
						invalid_match = NULL;
						_tmp6_ = NULL;
						_tmp4_ = NULL;
						if (!(_tmp5_ = vala_method_compatible (self, base_method, &_tmp4_), invalid_match = (_tmp6_ = _tmp4_, invalid_match = (g_free (invalid_match), NULL), _tmp6_), _tmp5_)) {
							char* _tmp9_;
							char* _tmp8_;
							char* _tmp7_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp9_ = NULL;
							_tmp8_ = NULL;
							_tmp7_ = NULL;
							vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp9_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp7_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp8_ = vala_symbol_get_full_name ((ValaSymbol*) base_method), invalid_match));
							_tmp9_ = (g_free (_tmp9_), NULL);
							_tmp8_ = (g_free (_tmp8_), NULL);
							_tmp7_ = (g_free (_tmp7_), NULL);
							invalid_match = (g_free (invalid_match), NULL);
							(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
							(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
							(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
							(_type_it == NULL) ? NULL : (_type_it = (gee_collection_object_unref (_type_it), NULL));
							return;
						}
						_tmp11_ = NULL;
						_tmp10_ = NULL;
						self->priv->_base_interface_method = (_tmp11_ = (_tmp10_ = base_method, (_tmp10_ == NULL) ? NULL : vala_code_node_ref (_tmp10_)), (self->priv->_base_interface_method == NULL) ? NULL : (self->priv->_base_interface_method = (vala_code_node_unref (self->priv->_base_interface_method), NULL)), _tmp11_);
						invalid_match = (g_free (invalid_match), NULL);
						(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
						(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
						(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
						(_type_it == NULL) ? NULL : (_type_it = (gee_collection_object_unref (_type_it), NULL));
						return;
					}
					(base_method == NULL) ? NULL : (base_method = (vala_code_node_unref (base_method), NULL));
				}
				(sym == NULL) ? NULL : (sym = (vala_code_node_unref (sym), NULL));
			}
			(type == NULL) ? NULL : (type = (vala_code_node_unref (type), NULL));
		}
		(_type_it == NULL) ? NULL : (_type_it = (gee_collection_object_unref (_type_it), NULL));
	}
}


static gboolean vala_method_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaMethod * self;
	gboolean result;
	gboolean _tmp3_;
	ValaSourceFile* _tmp12_;
	ValaSourceFile* old_source_file;
	ValaSymbol* _tmp13_;
	ValaSymbol* old_symbol;
	ValaClass* _tmp14_;
	ValaClass* old_class;
	ValaStruct* _tmp15_;
	ValaStruct* old_struct;
	ValaDataType* _tmp16_;
	ValaDataType* old_return_type;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp21_;
	ValaAttribute* init_attr;
	ValaClass* _tmp26_;
	ValaClass* _tmp25_;
	ValaStruct* _tmp28_;
	ValaStruct* _tmp27_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp29_;
	gboolean _tmp41_;
	gboolean _tmp42_;
	gboolean _tmp43_;
	gboolean _tmp56_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		result = !vala_code_node_get_error ((ValaCodeNode*) self);
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_method_process_attributes (self);
	if (self->priv->_coroutine) {
		{
			GeeIterator* _param_it;
			_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
			while (TRUE) {
				ValaFormalParameter* param;
				if (!gee_iterator_next (_param_it)) {
					break;
				}
				param = (ValaFormalParameter*) gee_iterator_get (_param_it);
				if (vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) param), "Reference parameter types are not yet supported for yielding functions");
					result = FALSE;
					(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
					(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
					return result;
				}
				(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
			}
			(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
		}
	}
	if (self->priv->_is_abstract) {
		if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			ValaClass* _tmp0_;
			ValaClass* cl;
			_tmp0_ = NULL;
			cl = (_tmp0_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_));
			if (!vala_class_get_is_abstract (cl)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
				return result;
			}
			(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
		} else {
			if (!VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		if (self->priv->_is_virtual) {
			gboolean _tmp1_;
			_tmp1_ = FALSE;
			if (!VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				_tmp1_ = !VALA_IS_INTERFACE (vala_symbol_get_parent_symbol ((ValaSymbol*) self));
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
			if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
				ValaClass* _tmp2_;
				ValaClass* cl;
				_tmp2_ = NULL;
				cl = (_tmp2_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp2_ == NULL) ? NULL : vala_code_node_ref (_tmp2_));
				if (vala_class_get_is_compact (cl)) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Virtual methods may not be declared in compact classes");
					result = FALSE;
					(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
					return result;
				}
				(cl == NULL) ? NULL : (cl = (vala_code_node_unref (cl), NULL));
			}
		} else {
			if (self->priv->_overrides) {
				if (!VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			}
		}
	}
	_tmp3_ = FALSE;
	if (self->priv->_is_abstract) {
		_tmp3_ = vala_method_get_body (self) != NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = FALSE;
		_tmp5_ = FALSE;
		_tmp6_ = FALSE;
		_tmp7_ = FALSE;
		if (self->priv->_is_abstract) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = self->priv->_is_virtual;
		}
		if (_tmp7_) {
			_tmp6_ = vala_symbol_get_external ((ValaSymbol*) self);
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			_tmp5_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = !vala_symbol_get_external (vala_symbol_get_parent_symbol ((ValaSymbol*) self));
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp8_;
			_tmp8_ = FALSE;
			if (vala_symbol_get_external ((ValaSymbol*) self)) {
				_tmp8_ = vala_method_get_body (self) != NULL;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Extern methods cannot have bodies");
			} else {
				gboolean _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				_tmp9_ = FALSE;
				_tmp10_ = FALSE;
				_tmp11_ = FALSE;
				if (!self->priv->_is_abstract) {
					_tmp11_ = !vala_symbol_get_external ((ValaSymbol*) self);
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					_tmp10_ = !vala_symbol_get_external_package ((ValaSymbol*) self);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_tmp9_ = vala_method_get_body (self) == NULL;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp12_ = NULL;
	old_source_file = (_tmp12_ = vala_semantic_analyzer_get_current_source_file (analyzer), (_tmp12_ == NULL) ? NULL : vala_source_file_ref (_tmp12_));
	_tmp13_ = NULL;
	old_symbol = (_tmp13_ = vala_semantic_analyzer_get_current_symbol (analyzer), (_tmp13_ == NULL) ? NULL : vala_code_node_ref (_tmp13_));
	_tmp14_ = NULL;
	old_class = (_tmp14_ = analyzer->current_class, (_tmp14_ == NULL) ? NULL : vala_code_node_ref (_tmp14_));
	_tmp15_ = NULL;
	old_struct = (_tmp15_ = analyzer->current_struct, (_tmp15_ == NULL) ? NULL : vala_code_node_ref (_tmp15_));
	_tmp16_ = NULL;
	old_return_type = (_tmp16_ = analyzer->current_return_type, (_tmp16_ == NULL) ? NULL : vala_code_node_ref (_tmp16_));
	if (vala_code_node_get_source_reference ((ValaCodeNode*) self) != NULL) {
		vala_semantic_analyzer_set_current_source_file (analyzer, vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self)));
	}
	vala_semantic_analyzer_set_current_symbol (analyzer, (ValaSymbol*) self);
	if (VALA_IS_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
		ValaClass* _tmp18_;
		ValaClass* _tmp17_;
		_tmp18_ = NULL;
		_tmp17_ = NULL;
		analyzer->current_class = (_tmp18_ = (_tmp17_ = VALA_CLASS (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp17_ == NULL) ? NULL : vala_code_node_ref (_tmp17_)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp18_);
	} else {
		if (VALA_IS_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) self))) {
			ValaStruct* _tmp20_;
			ValaStruct* _tmp19_;
			_tmp20_ = NULL;
			_tmp19_ = NULL;
			analyzer->current_struct = (_tmp20_ = (_tmp19_ = VALA_STRUCT (vala_symbol_get_parent_symbol ((ValaSymbol*) self)), (_tmp19_ == NULL) ? NULL : vala_code_node_ref (_tmp19_)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp20_);
		}
	}
	_tmp22_ = NULL;
	_tmp21_ = NULL;
	analyzer->current_return_type = (_tmp22_ = (_tmp21_ = vala_method_get_return_type (self), (_tmp21_ == NULL) ? NULL : vala_code_node_ref (_tmp21_)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp22_);
	vala_code_node_check ((ValaCodeNode*) vala_method_get_return_type (self), analyzer);
	init_attr = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	if (init_attr != NULL) {
		vala_code_context_set_module_init_method (vala_source_file_get_context (vala_source_reference_get_file (vala_code_node_get_source_reference ((ValaCodeNode*) self))), self);
	}
	if (vala_method_get_return_type (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_method_get_return_type (self), analyzer);
	}
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
		while (TRUE) {
			ValaFormalParameter* param;
			if (!gee_iterator_next (_param_it)) {
				break;
			}
			param = (ValaFormalParameter*) gee_iterator_get (_param_it);
			vala_code_node_check ((ValaCodeNode*) param, analyzer);
			(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	{
		GeeList* _tmp23_;
		GeeIterator* _tmp24_;
		GeeIterator* _error_type_it;
		_tmp23_ = NULL;
		_tmp24_ = NULL;
		_error_type_it = (_tmp24_ = gee_iterable_iterator ((GeeIterable*) (_tmp23_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp23_ == NULL) ? NULL : (_tmp23_ = (gee_collection_object_unref (_tmp23_), NULL)), _tmp24_);
		while (TRUE) {
			ValaDataType* error_type;
			if (!gee_iterator_next (_error_type_it)) {
				break;
			}
			error_type = (ValaDataType*) gee_iterator_get (_error_type_it);
			vala_code_node_check ((ValaCodeNode*) error_type, analyzer);
			(error_type == NULL) ? NULL : (error_type = (vala_code_node_unref (error_type), NULL));
		}
		(_error_type_it == NULL) ? NULL : (_error_type_it = (gee_collection_object_unref (_error_type_it), NULL));
	}
	if (self->priv->_result_var != NULL) {
		vala_code_node_check ((ValaCodeNode*) self->priv->_result_var, analyzer);
	}
	{
		GeeIterator* _precondition_it;
		_precondition_it = gee_iterable_iterator ((GeeIterable*) self->priv->preconditions);
		while (TRUE) {
			ValaExpression* precondition;
			if (!gee_iterator_next (_precondition_it)) {
				break;
			}
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			vala_code_node_check ((ValaCodeNode*) precondition, analyzer);
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
		}
		(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
	}
	{
		GeeIterator* _postcondition_it;
		_postcondition_it = gee_iterable_iterator ((GeeIterable*) self->priv->postconditions);
		while (TRUE) {
			ValaExpression* postcondition;
			if (!gee_iterator_next (_postcondition_it)) {
				break;
			}
			postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
			vala_code_node_check ((ValaCodeNode*) postcondition, analyzer);
			(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
		}
		(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
	}
	if (vala_method_get_body (self) != NULL) {
		vala_code_node_check ((ValaCodeNode*) vala_method_get_body (self), analyzer);
	}
	vala_semantic_analyzer_set_current_source_file (analyzer, old_source_file);
	vala_semantic_analyzer_set_current_symbol (analyzer, old_symbol);
	_tmp26_ = NULL;
	_tmp25_ = NULL;
	analyzer->current_class = (_tmp26_ = (_tmp25_ = old_class, (_tmp25_ == NULL) ? NULL : vala_code_node_ref (_tmp25_)), (analyzer->current_class == NULL) ? NULL : (analyzer->current_class = (vala_code_node_unref (analyzer->current_class), NULL)), _tmp26_);
	_tmp28_ = NULL;
	_tmp27_ = NULL;
	analyzer->current_struct = (_tmp28_ = (_tmp27_ = old_struct, (_tmp27_ == NULL) ? NULL : vala_code_node_ref (_tmp27_)), (analyzer->current_struct == NULL) ? NULL : (analyzer->current_struct = (vala_code_node_unref (analyzer->current_struct), NULL)), _tmp28_);
	_tmp30_ = NULL;
	_tmp29_ = NULL;
	analyzer->current_return_type = (_tmp30_ = (_tmp29_ = old_return_type, (_tmp29_ == NULL) ? NULL : vala_code_node_ref (_tmp29_)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp30_);
	if (VALA_IS_METHOD (vala_symbol_get_parent_symbol (vala_semantic_analyzer_get_current_symbol (analyzer)))) {
		ValaMethod* _tmp31_;
		ValaMethod* up_method;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp32_;
		/* lambda expressions produce nested methods */
		_tmp31_ = NULL;
		up_method = (_tmp31_ = VALA_METHOD (vala_symbol_get_parent_symbol (vala_semantic_analyzer_get_current_symbol (analyzer))), (_tmp31_ == NULL) ? NULL : vala_code_node_ref (_tmp31_));
		_tmp33_ = NULL;
		_tmp32_ = NULL;
		analyzer->current_return_type = (_tmp33_ = (_tmp32_ = vala_method_get_return_type (up_method), (_tmp32_ == NULL) ? NULL : vala_code_node_ref (_tmp32_)), (analyzer->current_return_type == NULL) ? NULL : (analyzer->current_return_type = (vala_code_node_unref (analyzer->current_return_type), NULL)), _tmp33_);
		(up_method == NULL) ? NULL : (up_method = (vala_code_node_unref (up_method), NULL));
	}
	if (VALA_IS_STRUCT (vala_semantic_analyzer_get_current_symbol (analyzer))) {
		gboolean _tmp34_;
		gboolean _tmp35_;
		_tmp34_ = FALSE;
		_tmp35_ = FALSE;
		if (self->priv->_is_abstract) {
			_tmp35_ = TRUE;
		} else {
			_tmp35_ = self->priv->_is_virtual;
		}
		if (_tmp35_) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = self->priv->_overrides;
		}
		if (_tmp34_) {
			char* _tmp37_;
			char* _tmp36_;
			_tmp37_ = NULL;
			_tmp36_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp37_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstract", _tmp36_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp37_ = (g_free (_tmp37_), NULL);
			_tmp36_ = (g_free (_tmp36_), NULL);
			result = FALSE;
			(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
			(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
			(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
			(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
			(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
			(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
			return result;
		}
	} else {
		gboolean _tmp38_;
		_tmp38_ = FALSE;
		if (self->priv->_overrides) {
			_tmp38_ = vala_method_get_base_method (self) == NULL;
		} else {
			_tmp38_ = FALSE;
		}
		if (_tmp38_) {
			char* _tmp40_;
			char* _tmp39_;
			_tmp40_ = NULL;
			_tmp39_ = NULL;
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp40_ = g_strdup_printf ("%s: no suitable method found to override", _tmp39_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
			_tmp40_ = (g_free (_tmp40_), NULL);
			_tmp39_ = (g_free (_tmp39_), NULL);
		}
	}
	_tmp41_ = FALSE;
	_tmp42_ = FALSE;
	_tmp43_ = FALSE;
	if (!vala_symbol_get_external_package ((ValaSymbol*) self)) {
		_tmp43_ = !self->priv->_overrides;
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		_tmp42_ = !vala_member_get_hides ((ValaMember*) self);
	} else {
		_tmp42_ = FALSE;
	}
	if (_tmp42_) {
		ValaSymbol* _tmp44_;
		_tmp44_ = NULL;
		_tmp41_ = (_tmp44_ = vala_member_get_hidden_member ((ValaMember*) self)) != NULL;
		(_tmp44_ == NULL) ? NULL : (_tmp44_ = (vala_code_node_unref (_tmp44_), NULL));
	} else {
		_tmp41_ = FALSE;
	}
	if (_tmp41_) {
		char* _tmp48_;
		char* _tmp47_;
		ValaSymbol* _tmp46_;
		char* _tmp45_;
		_tmp48_ = NULL;
		_tmp47_ = NULL;
		_tmp46_ = NULL;
		_tmp45_ = NULL;
		vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp48_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was intentional", _tmp45_ = vala_symbol_get_full_name ((ValaSymbol*) self), _tmp47_ = vala_symbol_get_full_name (_tmp46_ = vala_member_get_hidden_member ((ValaMember*) self))));
		_tmp48_ = (g_free (_tmp48_), NULL);
		_tmp47_ = (g_free (_tmp47_), NULL);
		(_tmp46_ == NULL) ? NULL : (_tmp46_ = (vala_code_node_unref (_tmp46_), NULL));
		_tmp45_ = (g_free (_tmp45_), NULL);
	}
	/* check whether return type is at least as accessible as the method*/
	if (!vala_semantic_analyzer_is_type_accessible (analyzer, (ValaSymbol*) self, vala_method_get_return_type (self))) {
		char* _tmp51_;
		char* _tmp50_;
		char* _tmp49_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp51_ = NULL;
		_tmp50_ = NULL;
		_tmp49_ = NULL;
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), _tmp51_ = g_strdup_printf ("return type `%s` is less accessible than method `%s`", _tmp49_ = vala_code_node_to_string ((ValaCodeNode*) vala_method_get_return_type (self)), _tmp50_ = vala_symbol_get_full_name ((ValaSymbol*) self)));
		_tmp51_ = (g_free (_tmp51_), NULL);
		_tmp50_ = (g_free (_tmp50_), NULL);
		_tmp49_ = (g_free (_tmp49_), NULL);
		result = FALSE;
		(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
		(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
		(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
		(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
		(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
		(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
		return result;
	}
	{
		GeeList* _tmp52_;
		GeeIterator* _tmp53_;
		GeeIterator* _precondition_it;
		_tmp52_ = NULL;
		_tmp53_ = NULL;
		_precondition_it = (_tmp53_ = gee_iterable_iterator ((GeeIterable*) (_tmp52_ = vala_method_get_preconditions (self))), (_tmp52_ == NULL) ? NULL : (_tmp52_ = (gee_collection_object_unref (_tmp52_), NULL)), _tmp53_);
		while (TRUE) {
			ValaExpression* precondition;
			if (!gee_iterator_next (_precondition_it)) {
				break;
			}
			precondition = (ValaExpression*) gee_iterator_get (_precondition_it);
			if (vala_code_node_get_error ((ValaCodeNode*) precondition)) {
				/* if there was an error in the precondition, skip this check*/
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
				(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
				(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
				(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
				return result;
			}
			if (!vala_data_type_compatible (vala_expression_get_value_type (precondition), analyzer->bool_type)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) precondition), "Precondition must be boolean");
				result = FALSE;
				(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
				(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
				(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
				(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
				return result;
			}
			(precondition == NULL) ? NULL : (precondition = (vala_code_node_unref (precondition), NULL));
		}
		(_precondition_it == NULL) ? NULL : (_precondition_it = (gee_collection_object_unref (_precondition_it), NULL));
	}
	{
		GeeList* _tmp54_;
		GeeIterator* _tmp55_;
		GeeIterator* _postcondition_it;
		_tmp54_ = NULL;
		_tmp55_ = NULL;
		_postcondition_it = (_tmp55_ = gee_iterable_iterator ((GeeIterable*) (_tmp54_ = vala_method_get_postconditions (self))), (_tmp54_ == NULL) ? NULL : (_tmp54_ = (gee_collection_object_unref (_tmp54_), NULL)), _tmp55_);
		while (TRUE) {
			ValaExpression* postcondition;
			if (!gee_iterator_next (_postcondition_it)) {
				break;
			}
			postcondition = (ValaExpression*) gee_iterator_get (_postcondition_it);
			if (vala_code_node_get_error ((ValaCodeNode*) postcondition)) {
				/* if there was an error in the postcondition, skip this check*/
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
				(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
				(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
				(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
				return result;
			}
			if (!vala_data_type_compatible (vala_expression_get_value_type (postcondition), analyzer->bool_type)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) postcondition), "Postcondition must be boolean");
				result = FALSE;
				(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
				(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
				(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
				(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
				(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
				(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
				(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
				(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
				return result;
			}
			(postcondition == NULL) ? NULL : (postcondition = (vala_code_node_unref (postcondition), NULL));
		}
		(_postcondition_it == NULL) ? NULL : (_postcondition_it = (gee_collection_object_unref (_postcondition_it), NULL));
	}
	_tmp56_ = FALSE;
	if (vala_code_node_get_tree_can_fail ((ValaCodeNode*) self)) {
		_tmp56_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "main") == 0;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "\"main\" method cannot throw errors");
	}
	/* check that all errors that can be thrown in the method body are declared*/
	if (vala_method_get_body (self) != NULL) {
		{
			GeeList* _tmp57_;
			GeeIterator* _tmp58_;
			GeeIterator* _body_error_type_it;
			_tmp57_ = NULL;
			_tmp58_ = NULL;
			_body_error_type_it = (_tmp58_ = gee_iterable_iterator ((GeeIterable*) (_tmp57_ = vala_code_node_get_error_types ((ValaCodeNode*) vala_method_get_body (self)))), (_tmp57_ == NULL) ? NULL : (_tmp57_ = (gee_collection_object_unref (_tmp57_), NULL)), _tmp58_);
			while (TRUE) {
				ValaDataType* body_error_type;
				gboolean can_propagate_error;
				if (!gee_iterator_next (_body_error_type_it)) {
					break;
				}
				body_error_type = (ValaDataType*) gee_iterator_get (_body_error_type_it);
				can_propagate_error = FALSE;
				{
					GeeList* _tmp59_;
					GeeIterator* _tmp60_;
					GeeIterator* _method_error_type_it;
					_tmp59_ = NULL;
					_tmp60_ = NULL;
					_method_error_type_it = (_tmp60_ = gee_iterable_iterator ((GeeIterable*) (_tmp59_ = vala_code_node_get_error_types ((ValaCodeNode*) self))), (_tmp59_ == NULL) ? NULL : (_tmp59_ = (gee_collection_object_unref (_tmp59_), NULL)), _tmp60_);
					while (TRUE) {
						ValaDataType* method_error_type;
						if (!gee_iterator_next (_method_error_type_it)) {
							break;
						}
						method_error_type = (ValaDataType*) gee_iterator_get (_method_error_type_it);
						if (vala_data_type_compatible (body_error_type, method_error_type)) {
							can_propagate_error = TRUE;
						}
						(method_error_type == NULL) ? NULL : (method_error_type = (vala_code_node_unref (method_error_type), NULL));
					}
					(_method_error_type_it == NULL) ? NULL : (_method_error_type_it = (gee_collection_object_unref (_method_error_type_it), NULL));
				}
				if (!can_propagate_error) {
					char* _tmp62_;
					char* _tmp61_;
					_tmp62_ = NULL;
					_tmp61_ = NULL;
					vala_report_warning (vala_code_node_get_source_reference ((ValaCodeNode*) body_error_type), _tmp62_ = g_strdup_printf ("unhandled error `%s'", _tmp61_ = vala_code_node_to_string ((ValaCodeNode*) body_error_type)));
					_tmp62_ = (g_free (_tmp62_), NULL);
					_tmp61_ = (g_free (_tmp61_), NULL);
				}
				(body_error_type == NULL) ? NULL : (body_error_type = (vala_code_node_unref (body_error_type), NULL));
			}
			(_body_error_type_it == NULL) ? NULL : (_body_error_type_it = (gee_collection_object_unref (_body_error_type_it), NULL));
		}
	}
	if (vala_method_is_possible_entry_point (self, analyzer)) {
		vala_method_set_entry_point (self, TRUE);
	}
	result = !vala_code_node_get_error ((ValaCodeNode*) self);
	(old_source_file == NULL) ? NULL : (old_source_file = (vala_source_file_unref (old_source_file), NULL));
	(old_symbol == NULL) ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL));
	(old_class == NULL) ? NULL : (old_class = (vala_code_node_unref (old_class), NULL));
	(old_struct == NULL) ? NULL : (old_struct = (vala_code_node_unref (old_struct), NULL));
	(old_return_type == NULL) ? NULL : (old_return_type = (vala_code_node_unref (old_return_type), NULL));
	(init_attr == NULL) ? NULL : (init_attr = (vala_code_node_unref (init_attr), NULL));
	return result;
}


static gboolean vala_method_is_possible_entry_point (ValaMethod* self, ValaSemanticAnalyzer* analyzer) {
	gboolean result;
	gboolean _tmp0_;
	GeeList* params;
	GeeIterator* params_it;
	ValaFormalParameter* param;
	ValaArrayType* _tmp1_;
	ValaArrayType* array_type;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (analyzer != NULL, FALSE);
	_tmp0_ = FALSE;
	if (vala_symbol_get_name ((ValaSymbol*) self) == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (vala_symbol_get_name ((ValaSymbol*) self), "main") != 0;
	}
	if (_tmp0_) {
		/* method must be called "main"*/
		result = FALSE;
		return result;
	}
	if (self->priv->_binding == MEMBER_BINDING_INSTANCE) {
		/* method must be static*/
		result = FALSE;
		return result;
	}
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (self))) {
	} else {
		if (vala_data_type_get_data_type (vala_method_get_return_type (self)) == vala_data_type_get_data_type (analyzer->int_type)) {
		} else {
			/* return type must be void or int*/
			result = FALSE;
			return result;
		}
	}
	params = vala_method_get_parameters (self);
	if (gee_collection_get_size ((GeeCollection*) params) == 0) {
		/* method may have no parameters*/
		result = TRUE;
		(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
		return result;
	}
	if (gee_collection_get_size ((GeeCollection*) params) > 1) {
		/* method must not have more than one parameter*/
		result = FALSE;
		(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
		return result;
	}
	params_it = gee_iterable_iterator ((GeeIterable*) params);
	gee_iterator_next (params_it);
	param = (ValaFormalParameter*) gee_iterator_get (params_it);
	if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
		/* parameter must not be an out parameter*/
		result = FALSE;
		(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
		(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		return result;
	}
	if (!VALA_IS_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))) {
		/* parameter must be an array*/
		result = FALSE;
		(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
		(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		return result;
	}
	_tmp1_ = NULL;
	array_type = (_tmp1_ = VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param)), (_tmp1_ == NULL) ? NULL : vala_code_node_ref (_tmp1_));
	if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (analyzer->string_type)) {
		/* parameter must be an array of strings*/
		result = FALSE;
		(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
		(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
		(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
		(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
		return result;
	}
	result = TRUE;
	(params == NULL) ? NULL : (params = (gee_collection_object_unref (params), NULL));
	(params_it == NULL) ? NULL : (params_it = (gee_collection_object_unref (params_it), NULL));
	(param == NULL) ? NULL : (param = (vala_code_node_unref (param), NULL));
	(array_type == NULL) ? NULL : (array_type = (vala_code_node_unref (array_type), NULL));
	return result;
}


ValaDataType* vala_method_get_return_type (ValaMethod* self) {
	ValaDataType* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_return_type;
	return result;
}


void vala_method_set_return_type (ValaMethod* self, ValaDataType* value) {
	ValaDataType* _tmp1_;
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_return_type = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_return_type == NULL) ? NULL : (self->priv->_return_type = (vala_code_node_unref (self->priv->_return_type), NULL)), _tmp1_);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_return_type, (ValaCodeNode*) self);
}


ValaBlock* vala_method_get_body (ValaMethod* self) {
	ValaBlock* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_body;
	return result;
}


void vala_method_set_body (ValaMethod* self, ValaBlock* value) {
	ValaBlock* _tmp1_;
	ValaBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_body = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_body == NULL) ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL)), _tmp1_);
	if (self->priv->_body != NULL) {
		vala_symbol_set_owner ((ValaSymbol*) self->priv->_body, vala_symbol_get_scope ((ValaSymbol*) self));
	}
}


ValaBasicBlock* vala_method_get_entry_block (ValaMethod* self) {
	ValaBasicBlock* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_entry_block;
	return result;
}


void vala_method_set_entry_block (ValaMethod* self, ValaBasicBlock* value) {
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_entry_block = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_basic_block_ref (_tmp0_)), (self->priv->_entry_block == NULL) ? NULL : (self->priv->_entry_block = (vala_basic_block_unref (self->priv->_entry_block), NULL)), _tmp1_);
}


ValaBasicBlock* vala_method_get_exit_block (ValaMethod* self) {
	ValaBasicBlock* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_exit_block;
	return result;
}


void vala_method_set_exit_block (ValaMethod* self, ValaBasicBlock* value) {
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_exit_block = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_basic_block_ref (_tmp0_)), (self->priv->_exit_block == NULL) ? NULL : (self->priv->_exit_block = (vala_basic_block_unref (self->priv->_exit_block), NULL)), _tmp1_);
}


MemberBinding vala_method_get_binding (ValaMethod* self) {
	MemberBinding result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_binding;
	return result;
}


void vala_method_set_binding (ValaMethod* self, MemberBinding value) {
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


const char* vala_method_get_vfunc_name (ValaMethod* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_vfunc_name == NULL) {
		char* _tmp1_;
		const char* _tmp0_;
		_tmp1_ = NULL;
		_tmp0_ = NULL;
		self->priv->_vfunc_name = (_tmp1_ = (_tmp0_ = vala_symbol_get_name ((ValaSymbol*) self), (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_vfunc_name = (g_free (self->priv->_vfunc_name), NULL), _tmp1_);
	}
	result = self->priv->_vfunc_name;
	return result;
}


void vala_method_set_vfunc_name (ValaMethod* self, const char* value) {
	char* _tmp3_;
	const char* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	self->priv->_vfunc_name = (_tmp3_ = (_tmp2_ = value, (_tmp2_ == NULL) ? NULL : g_strdup (_tmp2_)), self->priv->_vfunc_name = (g_free (self->priv->_vfunc_name), NULL), _tmp3_);
}


const char* vala_method_get_sentinel (ValaMethod* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->_sentinel == NULL) {
		result = VALA_METHOD_DEFAULT_SENTINEL;
		return result;
	}
	result = self->priv->_sentinel;
	return result;
}


void vala_method_set_sentinel (ValaMethod* self, const char* value) {
	char* _tmp1_;
	const char* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_sentinel = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : g_strdup (_tmp0_)), self->priv->_sentinel = (g_free (self->priv->_sentinel), NULL), _tmp1_);
}


gboolean vala_method_get_is_abstract (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}


void vala_method_set_is_abstract (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean vala_method_get_is_virtual (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}


void vala_method_set_is_virtual (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean vala_method_get_overrides (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}


void vala_method_set_overrides (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


gboolean vala_method_get_is_inline (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}


void vala_method_set_is_inline (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}


gboolean vala_method_get_returns_modified_pointer (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_returns_modified_pointer;
	return result;
}


void vala_method_set_returns_modified_pointer (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_returns_modified_pointer = value;
}


ValaMethod* vala_method_get_base_method (ValaMethod* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	result = self->priv->_base_method;
	return result;
}


ValaMethod* vala_method_get_base_interface_method (ValaMethod* self) {
	ValaMethod* result;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	result = self->priv->_base_interface_method;
	return result;
}


gboolean vala_method_get_entry_point (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}


static void vala_method_set_entry_point (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}


ValaFormalParameter* vala_method_get_this_parameter (ValaMethod* self) {
	ValaFormalParameter* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_this_parameter;
	return result;
}


void vala_method_set_this_parameter (ValaMethod* self, ValaFormalParameter* value) {
	ValaFormalParameter* _tmp1_;
	ValaFormalParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_this_parameter = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_this_parameter == NULL) ? NULL : (self->priv->_this_parameter = (vala_code_node_unref (self->priv->_this_parameter), NULL)), _tmp1_);
}


ValaLocalVariable* vala_method_get_result_var (ValaMethod* self) {
	ValaLocalVariable* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_result_var;
	return result;
}


void vala_method_set_result_var (ValaMethod* self, ValaLocalVariable* value) {
	ValaLocalVariable* _tmp1_;
	ValaLocalVariable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	self->priv->_result_var = (_tmp1_ = (_tmp0_ = value, (_tmp0_ == NULL) ? NULL : vala_code_node_ref (_tmp0_)), (self->priv->_result_var == NULL) ? NULL : (self->priv->_result_var = (vala_code_node_unref (self->priv->_result_var), NULL)), _tmp1_);
}


double vala_method_get_cinstance_parameter_position (ValaMethod* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cinstance_parameter_position;
	return result;
}


void vala_method_set_cinstance_parameter_position (ValaMethod* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_cinstance_parameter_position = value;
}


double vala_method_get_carray_length_parameter_position (ValaMethod* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_carray_length_parameter_position;
	return result;
}


void vala_method_set_carray_length_parameter_position (ValaMethod* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_carray_length_parameter_position = value;
}


double vala_method_get_cdelegate_target_parameter_position (ValaMethod* self) {
	double result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_cdelegate_target_parameter_position;
	return result;
}


void vala_method_set_cdelegate_target_parameter_position (ValaMethod* self, double value) {
	g_return_if_fail (self != NULL);
	self->priv->_cdelegate_target_parameter_position = value;
}


gboolean vala_method_get_no_array_length (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_no_array_length;
	return result;
}


void vala_method_set_no_array_length (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_no_array_length = value;
}


gboolean vala_method_get_array_null_terminated (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_array_null_terminated;
	return result;
}


void vala_method_set_array_null_terminated (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_array_null_terminated = value;
}


gboolean vala_method_get_printf_format (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_printf_format;
	return result;
}


void vala_method_set_printf_format (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_printf_format = value;
}


gboolean vala_method_get_scanf_format (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_scanf_format;
	return result;
}


void vala_method_set_scanf_format (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_scanf_format = value;
}


gboolean vala_method_get_has_construct_function (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_construct_function;
	return result;
}


void vala_method_set_has_construct_function (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_has_construct_function = value;
}


ValaSignal* vala_method_get_signal_reference (ValaMethod* self) {
	ValaSignal* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_signal_reference;
	return result;
}


void vala_method_set_signal_reference (ValaMethod* self, ValaSignal* value) {
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}


gboolean vala_method_get_coroutine (ValaMethod* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}


void vala_method_set_coroutine (ValaMethod* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}


static void vala_method_class_init (ValaMethodClass * klass) {
	vala_method_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_method_real_get_default_cname;
	VALA_METHOD_CLASS (klass)->get_real_cname = vala_method_real_get_real_cname;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_method_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_method_real_check;
}


static void vala_method_instance_init (ValaMethod * self) {
	self->priv = VALA_METHOD_GET_PRIVATE (self);
	self->priv->type_parameters = (GeeList*) gee_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->_binding = MEMBER_BINDING_INSTANCE;
	self->priv->_has_construct_function = TRUE;
	self->priv->parameters = (GeeList*) gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->preconditions = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->postconditions = (GeeList*) gee_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
}


static void vala_method_finalize (ValaCodeNode* obj) {
	ValaMethod * self;
	self = VALA_METHOD (obj);
	(self->priv->type_parameters == NULL) ? NULL : (self->priv->type_parameters = (gee_collection_object_unref (self->priv->type_parameters), NULL));
	(self->priv->_entry_block == NULL) ? NULL : (self->priv->_entry_block = (vala_basic_block_unref (self->priv->_entry_block), NULL));
	(self->priv->_exit_block == NULL) ? NULL : (self->priv->_exit_block = (vala_basic_block_unref (self->priv->_exit_block), NULL));
	(self->priv->_this_parameter == NULL) ? NULL : (self->priv->_this_parameter = (vala_code_node_unref (self->priv->_this_parameter), NULL));
	(self->priv->_result_var == NULL) ? NULL : (self->priv->_result_var = (vala_code_node_unref (self->priv->_result_var), NULL));
	(self->priv->parameters == NULL) ? NULL : (self->priv->parameters = (gee_collection_object_unref (self->priv->parameters), NULL));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	self->priv->_vfunc_name = (g_free (self->priv->_vfunc_name), NULL);
	self->priv->_sentinel = (g_free (self->priv->_sentinel), NULL);
	(self->priv->preconditions == NULL) ? NULL : (self->priv->preconditions = (gee_collection_object_unref (self->priv->preconditions), NULL));
	(self->priv->postconditions == NULL) ? NULL : (self->priv->postconditions = (gee_collection_object_unref (self->priv->postconditions), NULL));
	(self->priv->_return_type == NULL) ? NULL : (self->priv->_return_type = (vala_code_node_unref (self->priv->_return_type), NULL));
	(self->priv->_body == NULL) ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL));
	(self->priv->_base_interface_method == NULL) ? NULL : (self->priv->_base_interface_method = (vala_code_node_unref (self->priv->_base_interface_method), NULL));
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}


GType vala_method_get_type (void) {
	static GType vala_method_type_id = 0;
	if (vala_method_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		vala_method_type_id = g_type_register_static (VALA_TYPE_MEMBER, "ValaMethod", &g_define_type_info, 0);
	}
	return vala_method_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




