/* valamarkupreader.c generated by valac, the Vala compiler
 * generated from valamarkupreader.vala, do not modify */

/* valamarkupreader.vala
 *
 * Copyright (C) 2008-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>


#define VALA_TYPE_MARKUP_READER (vala_markup_reader_get_type ())
#define VALA_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReader))
#define VALA_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))
#define VALA_IS_MARKUP_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_MARKUP_READER))
#define VALA_IS_MARKUP_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_MARKUP_READER))
#define VALA_MARKUP_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_MARKUP_READER, ValaMarkupReaderClass))

typedef struct _ValaMarkupReader ValaMarkupReader;
typedef struct _ValaMarkupReaderClass ValaMarkupReaderClass;
typedef struct _ValaMarkupReaderPrivate ValaMarkupReaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_MARKUP_TOKEN_TYPE (vala_markup_token_type_get_type ())

#define VALA_TYPE_SOURCE_LOCATION (vala_source_location_get_type ())
typedef struct _ValaSourceLocation ValaSourceLocation;

struct _ValaMarkupReader {
	GObject parent_instance;
	ValaMarkupReaderPrivate * priv;
};

struct _ValaMarkupReaderClass {
	GObjectClass parent_class;
};

struct _ValaMarkupReaderPrivate {
	char* _filename;
	char* _name;
	GMappedFile* mapped_file;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	ValaMap* attributes;
	gboolean empty_element;
};

typedef enum  {
	VALA_MARKUP_TOKEN_TYPE_NONE,
	VALA_MARKUP_TOKEN_TYPE_START_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_END_ELEMENT,
	VALA_MARKUP_TOKEN_TYPE_TEXT,
	VALA_MARKUP_TOKEN_TYPE_EOF
} ValaMarkupTokenType;

struct _ValaSourceLocation {
	gchar* pos;
	gint line;
	gint column;
};


static gpointer vala_markup_reader_parent_class = NULL;

GType vala_markup_reader_get_type (void) G_GNUC_CONST;
#define VALA_MARKUP_READER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MARKUP_READER, ValaMarkupReaderPrivate))
enum  {
	VALA_MARKUP_READER_DUMMY_PROPERTY,
	VALA_MARKUP_READER_FILENAME,
	VALA_MARKUP_READER_NAME
};
static void vala_markup_reader_set_filename (ValaMarkupReader* self, const char* value);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const char* message);
ValaMarkupReader* vala_markup_reader_new (const char* filename);
ValaMarkupReader* vala_markup_reader_construct (GType object_type, const char* filename);
char* vala_markup_reader_get_attribute (ValaMarkupReader* self, const char* attr);
static char* vala_markup_reader_read_name (ValaMarkupReader* self);
GType vala_markup_token_type_get_type (void) G_GNUC_CONST;
static void vala_markup_reader_space (ValaMarkupReader* self);
GType vala_source_location_get_type (void) G_GNUC_CONST;
ValaSourceLocation* vala_source_location_dup (const ValaSourceLocation* self);
void vala_source_location_free (ValaSourceLocation* self);
ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
static void vala_markup_reader_set_name (ValaMarkupReader* self, const char* value);
const char* vala_markup_reader_get_filename (ValaMarkupReader* self);
const char* vala_markup_reader_get_name (ValaMarkupReader* self);
static void vala_markup_reader_finalize (GObject* obj);
static void vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
const char* vala_markup_token_type_to_string (ValaMarkupTokenType self);



ValaMarkupReader* vala_markup_reader_construct (GType object_type, const char* filename) {
	GError * _inner_error_;
	ValaMarkupReader * self;
	g_return_val_if_fail (filename != NULL, NULL);
	_inner_error_ = NULL;
	self = (ValaMarkupReader*) g_object_new (object_type, NULL);
	vala_markup_reader_set_filename (self, filename);
	{
		GMappedFile* _tmp0_;
		GMappedFile* _tmp1_;
		_tmp0_ = g_mapped_file_new (filename, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->mapped_file = (_tmp1_ = _tmp0_, _g_mapped_file_free0 (self->priv->mapped_file), _tmp1_);
		self->priv->begin = g_mapped_file_get_contents (self->priv->mapped_file);
		self->priv->end = self->priv->begin + g_mapped_file_get_length (self->priv->mapped_file);
		self->priv->current = self->priv->begin;
		self->priv->line = 1;
		self->priv->column = 1;
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp2_;
			vala_report_error (NULL, _tmp2_ = g_strdup_printf ("Unable to map file `%s': %s", filename, e->message));
			_g_free0 (_tmp2_);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


ValaMarkupReader* vala_markup_reader_new (const char* filename) {
	return vala_markup_reader_construct (VALA_TYPE_MARKUP_READER, filename);
}


char* vala_markup_reader_get_attribute (ValaMarkupReader* self, const char* attr) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attr != NULL, NULL);
	result = (char*) vala_map_get (self->priv->attributes, attr);
	return result;
}


static char* vala_markup_reader_read_name (ValaMarkupReader* self) {
	char* result = NULL;
	gchar* begin;
	g_return_val_if_fail (self != NULL, NULL);
	begin = self->priv->current;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gunichar u;
		if (!(self->priv->current < self->priv->end)) {
			break;
		}
		if (self->priv->current[0] == ' ') {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->priv->current[0] == '>';
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->priv->current[0] == '/';
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = self->priv->current[0] == '=';
		}
		if (_tmp0_) {
			break;
		}
		u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
		if (u != ((gunichar) (-1))) {
			self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
		} else {
			vala_report_error (NULL, "invalid UTF-8 character");
		}
	}
	if (self->priv->current == begin) {
	}
	result = g_strndup ((const char*) begin, self->priv->current - begin);
	return result;
}


ValaMarkupTokenType vala_markup_reader_read_token (ValaMarkupReader* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end) {
	ValaMarkupTokenType result = 0;
	ValaMarkupTokenType type;
	gchar* begin;
	g_return_val_if_fail (self != NULL, 0);
	vala_map_clear (self->priv->attributes);
	if (self->priv->empty_element) {
		self->priv->empty_element = FALSE;
		result = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
		return result;
	}
	vala_markup_reader_space (self);
	type = VALA_MARKUP_TOKEN_TYPE_NONE;
	begin = self->priv->current;
	(*token_begin).pos = begin;
	(*token_begin).line = self->priv->line;
	(*token_begin).column = self->priv->column;
	if (self->priv->current >= self->priv->end) {
		type = VALA_MARKUP_TOKEN_TYPE_EOF;
	} else {
		if (self->priv->current[0] == '<') {
			self->priv->current++;
			if (self->priv->current >= self->priv->end) {
			} else {
				if (self->priv->current[0] == '?') {
				} else {
					if (self->priv->current[0] == '!') {
						gboolean _tmp0_ = FALSE;
						gboolean _tmp1_ = FALSE;
						self->priv->current++;
						if (self->priv->current < (self->priv->end - 1)) {
							_tmp1_ = self->priv->current[0] == '-';
						} else {
							_tmp1_ = FALSE;
						}
						if (_tmp1_) {
							_tmp0_ = self->priv->current[1] == '-';
						} else {
							_tmp0_ = FALSE;
						}
						if (_tmp0_) {
							self->priv->current = self->priv->current + 2;
							while (TRUE) {
								gboolean _tmp2_ = FALSE;
								gboolean _tmp3_ = FALSE;
								if (!(self->priv->current < (self->priv->end - 2))) {
									break;
								}
								if (self->priv->current[0] == '-') {
									_tmp3_ = self->priv->current[1] == '-';
								} else {
									_tmp3_ = FALSE;
								}
								if (_tmp3_) {
									_tmp2_ = self->priv->current[2] == '>';
								} else {
									_tmp2_ = FALSE;
								}
								if (_tmp2_) {
									self->priv->current = self->priv->current + 3;
									break;
								}
								self->priv->current++;
							}
							result = vala_markup_reader_read_token (self, token_begin, token_end);
							return result;
						}
					} else {
						if (self->priv->current[0] == '/') {
							char* _tmp4_;
							gboolean _tmp5_ = FALSE;
							type = VALA_MARKUP_TOKEN_TYPE_END_ELEMENT;
							self->priv->current++;
							vala_markup_reader_set_name (self, _tmp4_ = vala_markup_reader_read_name (self));
							_g_free0 (_tmp4_);
							if (self->priv->current >= self->priv->end) {
								_tmp5_ = TRUE;
							} else {
								_tmp5_ = self->priv->current[0] != '>';
							}
							if (_tmp5_) {
							}
							self->priv->current++;
						} else {
							char* _tmp6_;
							gboolean _tmp13_ = FALSE;
							type = VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
							vala_markup_reader_set_name (self, _tmp6_ = vala_markup_reader_read_name (self));
							_g_free0 (_tmp6_);
							vala_markup_reader_space (self);
							while (TRUE) {
								gboolean _tmp7_ = FALSE;
								gboolean _tmp8_ = FALSE;
								char* attr_name;
								gboolean _tmp9_ = FALSE;
								gboolean _tmp10_ = FALSE;
								gchar* attr_begin;
								char* attr_value;
								gboolean _tmp12_ = FALSE;
								if (self->priv->current < self->priv->end) {
									_tmp8_ = self->priv->current[0] != '>';
								} else {
									_tmp8_ = FALSE;
								}
								if (_tmp8_) {
									_tmp7_ = self->priv->current[0] != '/';
								} else {
									_tmp7_ = FALSE;
								}
								if (!_tmp7_) {
									break;
								}
								attr_name = vala_markup_reader_read_name (self);
								if (self->priv->current >= self->priv->end) {
									_tmp9_ = TRUE;
								} else {
									_tmp9_ = self->priv->current[0] != '=';
								}
								if (_tmp9_) {
								}
								self->priv->current++;
								if (self->priv->current >= self->priv->end) {
									_tmp10_ = TRUE;
								} else {
									_tmp10_ = self->priv->current[0] != '"';
								}
								if (_tmp10_) {
								}
								self->priv->current++;
								attr_begin = self->priv->current;
								while (TRUE) {
									gboolean _tmp11_ = FALSE;
									gunichar u;
									if (self->priv->current < self->priv->end) {
										_tmp11_ = self->priv->current[0] != '"';
									} else {
										_tmp11_ = FALSE;
									}
									if (!_tmp11_) {
										break;
									}
									u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
									if (u != ((gunichar) (-1))) {
										self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
									} else {
										vala_report_error (NULL, "invalid UTF-8 character");
									}
								}
								attr_value = g_strndup ((const char*) attr_begin, self->priv->current - attr_begin);
								if (self->priv->current >= self->priv->end) {
									_tmp12_ = TRUE;
								} else {
									_tmp12_ = self->priv->current[0] != '"';
								}
								if (_tmp12_) {
								}
								self->priv->current++;
								vala_map_set (self->priv->attributes, attr_name, attr_value);
								vala_markup_reader_space (self);
								_g_free0 (attr_value);
								_g_free0 (attr_name);
							}
							if (self->priv->current[0] == '/') {
								self->priv->empty_element = TRUE;
								self->priv->current++;
								vala_markup_reader_space (self);
							} else {
								self->priv->empty_element = FALSE;
							}
							if (self->priv->current >= self->priv->end) {
								_tmp13_ = TRUE;
							} else {
								_tmp13_ = self->priv->current[0] != '>';
							}
							if (_tmp13_) {
							}
							self->priv->current++;
						}
					}
				}
			}
		} else {
			gchar* text_begin;
			vala_markup_reader_space (self);
			text_begin = self->priv->current;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gunichar u;
				if (self->priv->current < self->priv->end) {
					_tmp14_ = self->priv->current[0] != '<';
				} else {
					_tmp14_ = FALSE;
				}
				if (!_tmp14_) {
					break;
				}
				u = g_utf8_get_char_validated ((const char*) self->priv->current, (gssize) ((glong) (self->priv->end - self->priv->current)));
				if (u != ((gunichar) (-1))) {
					self->priv->current = self->priv->current + g_unichar_to_utf8 (u, NULL);
				} else {
					vala_report_error (NULL, "invalid UTF-8 character");
				}
			}
			if (text_begin == self->priv->current) {
				result = vala_markup_reader_read_token (self, token_begin, token_end);
				return result;
			}
			type = VALA_MARKUP_TOKEN_TYPE_TEXT;
		}
	}
	self->priv->column = self->priv->column + ((gint) (self->priv->current - begin));
	(*token_end).pos = self->priv->current;
	(*token_end).line = self->priv->line;
	(*token_end).column = self->priv->column - 1;
	result = type;
	return result;
}


static void vala_markup_reader_space (ValaMarkupReader* self) {
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->current < self->priv->end) {
			_tmp0_ = g_ascii_isspace (self->priv->current[0]);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		if (self->priv->current[0] == '\n') {
			self->priv->line++;
			self->priv->column = 0;
		}
		self->priv->current++;
		self->priv->column++;
	}
}


const char* vala_markup_reader_get_filename (ValaMarkupReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


static void vala_markup_reader_set_filename (ValaMarkupReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
	g_object_notify ((GObject *) self, "filename");
}


const char* vala_markup_reader_get_name (ValaMarkupReader* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_name;
	return result;
}


static void vala_markup_reader_set_name (ValaMarkupReader* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_name = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_name), _tmp0_);
	g_object_notify ((GObject *) self, "name");
}


static void vala_markup_reader_class_init (ValaMarkupReaderClass * klass) {
	vala_markup_reader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaMarkupReaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_markup_reader_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_markup_reader_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_markup_reader_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_MARKUP_READER_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void vala_markup_reader_instance_init (ValaMarkupReader * self) {
	self->priv = VALA_MARKUP_READER_GET_PRIVATE (self);
	self->priv->attributes = (ValaMap*) vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal, g_direct_equal);
}


static void vala_markup_reader_finalize (GObject* obj) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_name);
	_g_mapped_file_free0 (self->priv->mapped_file);
	_vala_collection_object_unref0 (self->priv->attributes);
	G_OBJECT_CLASS (vala_markup_reader_parent_class)->finalize (obj);
}


/**
 * Simple reader for a subset of XML.
 */
GType vala_markup_reader_get_type (void) {
	static volatile gsize vala_markup_reader_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_reader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMarkupReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_markup_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMarkupReader), 0, (GInstanceInitFunc) vala_markup_reader_instance_init, NULL };
		GType vala_markup_reader_type_id;
		vala_markup_reader_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaMarkupReader", &g_define_type_info, 0);
		g_once_init_leave (&vala_markup_reader_type_id__volatile, vala_markup_reader_type_id);
	}
	return vala_markup_reader_type_id__volatile;
}


static void vala_markup_reader_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (object);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		g_value_set_string (value, vala_markup_reader_get_filename (self));
		break;
		case VALA_MARKUP_READER_NAME:
		g_value_set_string (value, vala_markup_reader_get_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_markup_reader_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaMarkupReader * self;
	self = VALA_MARKUP_READER (object);
	switch (property_id) {
		case VALA_MARKUP_READER_FILENAME:
		vala_markup_reader_set_filename (self, g_value_get_string (value));
		break;
		case VALA_MARKUP_READER_NAME:
		vala_markup_reader_set_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


const char* vala_markup_token_type_to_string (ValaMarkupTokenType self) {
	const char* result = NULL;
	switch (self) {
		case VALA_MARKUP_TOKEN_TYPE_START_ELEMENT:
		{
			result = "start element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_END_ELEMENT:
		{
			result = "end element";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_TEXT:
		{
			result = "text";
			return result;
		}
		case VALA_MARKUP_TOKEN_TYPE_EOF:
		{
			result = "end of file";
			return result;
		}
		default:
		{
			result = "unknown token type";
			return result;
		}
	}
}


GType vala_markup_token_type_get_type (void) {
	static volatile gsize vala_markup_token_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_markup_token_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_MARKUP_TOKEN_TYPE_NONE, "VALA_MARKUP_TOKEN_TYPE_NONE", "none"}, {VALA_MARKUP_TOKEN_TYPE_START_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_START_ELEMENT", "start-element"}, {VALA_MARKUP_TOKEN_TYPE_END_ELEMENT, "VALA_MARKUP_TOKEN_TYPE_END_ELEMENT", "end-element"}, {VALA_MARKUP_TOKEN_TYPE_TEXT, "VALA_MARKUP_TOKEN_TYPE_TEXT", "text"}, {VALA_MARKUP_TOKEN_TYPE_EOF, "VALA_MARKUP_TOKEN_TYPE_EOF", "eof"}, {0, NULL, NULL}};
		GType vala_markup_token_type_type_id;
		vala_markup_token_type_type_id = g_enum_register_static ("ValaMarkupTokenType", values);
		g_once_init_leave (&vala_markup_token_type_type_id__volatile, vala_markup_token_type_type_id);
	}
	return vala_markup_token_type_type_id__volatile;
}




