/* valasourcefile.c generated by valac, the Vala compiler
 * generated from valasourcefile.vala, do not modify */

/* valasourcefile.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_TYPE_SOURCE_FILE (vala_source_file_get_type ())
#define VALA_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFile))
#define VALA_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))
#define VALA_IS_SOURCE_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_FILE))
#define VALA_IS_SOURCE_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_FILE))
#define VALA_SOURCE_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_FILE, ValaSourceFileClass))

typedef struct _ValaSourceFile ValaSourceFile;
typedef struct _ValaSourceFileClass ValaSourceFileClass;
typedef struct _ValaSourceFilePrivate ValaSourceFilePrivate;

#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContext ValaCodeContext;
typedef struct _ValaCodeContextClass ValaCodeContextClass;

#define VALA_TYPE_COMMENT (vala_comment_get_type ())
#define VALA_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COMMENT, ValaComment))
#define VALA_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COMMENT, ValaCommentClass))
#define VALA_IS_COMMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COMMENT))
#define VALA_IS_COMMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COMMENT))
#define VALA_COMMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COMMENT, ValaCommentClass))

typedef struct _ValaComment ValaComment;
typedef struct _ValaCommentClass ValaCommentClass;

#define VALA_TYPE_CODE_NODE (vala_code_node_get_type ())
#define VALA_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_NODE, ValaCodeNode))
#define VALA_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))
#define VALA_IS_CODE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_NODE))
#define VALA_IS_CODE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_NODE))
#define VALA_CODE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_NODE, ValaCodeNodeClass))

typedef struct _ValaCodeNode ValaCodeNode;
typedef struct _ValaCodeNodeClass ValaCodeNodeClass;

#define VALA_TYPE_USING_DIRECTIVE (vala_using_directive_get_type ())
#define VALA_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirective))
#define VALA_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))
#define VALA_IS_USING_DIRECTIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_USING_DIRECTIVE))
#define VALA_IS_USING_DIRECTIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_USING_DIRECTIVE))
#define VALA_USING_DIRECTIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_USING_DIRECTIVE, ValaUsingDirectiveClass))

typedef struct _ValaUsingDirective ValaUsingDirective;
typedef struct _ValaUsingDirectiveClass ValaUsingDirectiveClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_collection_object_unref0(var) ((var == NULL) ? NULL : (var = (vala_collection_object_unref (var), NULL)))
#define _g_mapped_file_free0(var) ((var == NULL) ? NULL : (var = (g_mapped_file_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

#define VALA_TYPE_CODE_VISITOR (vala_code_visitor_get_type ())
#define VALA_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitor))
#define VALA_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))
#define VALA_IS_CODE_VISITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_VISITOR))
#define VALA_IS_CODE_VISITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_VISITOR))
#define VALA_CODE_VISITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_VISITOR, ValaCodeVisitorClass))

typedef struct _ValaCodeVisitor ValaCodeVisitor;
typedef struct _ValaCodeVisitorClass ValaCodeVisitorClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_SOURCE_REFERENCE (vala_source_reference_get_type ())
#define VALA_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReference))
#define VALA_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))
#define VALA_IS_SOURCE_REFERENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_IS_SOURCE_REFERENCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SOURCE_REFERENCE))
#define VALA_SOURCE_REFERENCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SOURCE_REFERENCE, ValaSourceReferenceClass))

typedef struct _ValaSourceReference ValaSourceReference;
typedef struct _ValaSourceReferenceClass ValaSourceReferenceClass;

#define VALA_TYPE_SEMANTIC_ANALYZER (vala_semantic_analyzer_get_type ())
#define VALA_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzer))
#define VALA_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))
#define VALA_IS_SEMANTIC_ANALYZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_IS_SEMANTIC_ANALYZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SEMANTIC_ANALYZER))
#define VALA_SEMANTIC_ANALYZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SEMANTIC_ANALYZER, ValaSemanticAnalyzerClass))

typedef struct _ValaSemanticAnalyzer ValaSemanticAnalyzer;
typedef struct _ValaSemanticAnalyzerClass ValaSemanticAnalyzerClass;
typedef struct _ValaParamSpecSourceFile ValaParamSpecSourceFile;

struct _ValaSourceFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaSourceFilePrivate * priv;
};

struct _ValaSourceFileClass {
	GTypeClass parent_class;
	void (*finalize) (ValaSourceFile *self);
};

struct _ValaSourceFilePrivate {
	char* _filename;
	gboolean _external_package;
	char* _gir_namespace;
	char* _gir_version;
	ValaCodeContext* _context;
	ValaArrayList* comments;
	ValaList* _current_using_directives;
	ValaList* nodes;
	char* csource_filename;
	char* cinclude_filename;
	ValaArrayList* source_array;
	GMappedFile* mapped_file;
	char* _content;
};

struct _ValaParamSpecSourceFile {
	GParamSpec parent_instance;
};


static gpointer vala_source_file_parent_class = NULL;

gpointer vala_source_file_ref (gpointer instance);
void vala_source_file_unref (gpointer instance);
GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_file (GValue* value, gpointer v_object);
void vala_value_take_source_file (GValue* value, gpointer v_object);
gpointer vala_value_get_source_file (const GValue* value);
GType vala_source_file_get_type (void) G_GNUC_CONST;
gpointer vala_code_context_ref (gpointer instance);
void vala_code_context_unref (gpointer instance);
GParamSpec* vala_param_spec_code_context (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_context (GValue* value, gpointer v_object);
void vala_value_take_code_context (GValue* value, gpointer v_object);
gpointer vala_value_get_code_context (const GValue* value);
GType vala_code_context_get_type (void) G_GNUC_CONST;
gpointer vala_comment_ref (gpointer instance);
void vala_comment_unref (gpointer instance);
GParamSpec* vala_param_spec_comment (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_comment (GValue* value, gpointer v_object);
void vala_value_take_comment (GValue* value, gpointer v_object);
gpointer vala_value_get_comment (const GValue* value);
GType vala_comment_get_type (void) G_GNUC_CONST;
gpointer vala_code_node_ref (gpointer instance);
void vala_code_node_unref (gpointer instance);
GParamSpec* vala_param_spec_code_node (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_node (GValue* value, gpointer v_object);
void vala_value_take_code_node (GValue* value, gpointer v_object);
gpointer vala_value_get_code_node (const GValue* value);
GType vala_code_node_get_type (void) G_GNUC_CONST;
GType vala_using_directive_get_type (void) G_GNUC_CONST;
#define VALA_SOURCE_FILE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SOURCE_FILE, ValaSourceFilePrivate))
enum  {
	VALA_SOURCE_FILE_DUMMY_PROPERTY
};
ValaSourceFile* vala_source_file_new (ValaCodeContext* context, const char* filename, gboolean pkg, const char* content);
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, const char* filename, gboolean pkg, const char* content);
void vala_source_file_set_filename (ValaSourceFile* self, const char* value);
void vala_source_file_set_external_package (ValaSourceFile* self, gboolean value);
void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value);
void vala_source_file_set_content (ValaSourceFile* self, const char* value);
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment);
ValaList* vala_source_file_get_comments (ValaSourceFile* self);
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns);
ValaList* vala_source_file_get_current_using_directives (ValaSourceFile* self);
void vala_source_file_set_current_using_directives (ValaSourceFile* self, ValaList* value);
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node);
void vala_source_file_remove_node (ValaSourceFile* self, ValaCodeNode* node);
ValaList* vala_source_file_get_nodes (ValaSourceFile* self);
gpointer vala_code_visitor_ref (gpointer instance);
void vala_code_visitor_unref (gpointer instance);
GParamSpec* vala_param_spec_code_visitor (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_code_visitor (GValue* value, gpointer v_object);
void vala_value_take_code_visitor (GValue* value, gpointer v_object);
gpointer vala_value_get_code_visitor (const GValue* value);
GType vala_code_visitor_get_type (void) G_GNUC_CONST;
void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_visitor_visit_source_file (ValaCodeVisitor* self, ValaSourceFile* source_file);
void vala_source_file_accept_children (ValaSourceFile* self, ValaCodeVisitor* visitor);
void vala_code_node_accept (ValaCodeNode* self, ValaCodeVisitor* visitor);
static char* vala_source_file_get_subdir (ValaSourceFile* self);
ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self);
const char* vala_code_context_get_basedir (ValaCodeContext* self);
const char* vala_source_file_get_filename (ValaSourceFile* self);
static char* vala_source_file_get_destination_directory (ValaSourceFile* self);
const char* vala_code_context_get_directory (ValaCodeContext* self);
static char* vala_source_file_get_basename (ValaSourceFile* self);
char* vala_source_file_get_relative_filename (ValaSourceFile* self);
char* vala_source_file_get_csource_filename (ValaSourceFile* self);
gboolean vala_code_context_get_run_output (ValaCodeContext* self);
const char* vala_code_context_get_output (ValaCodeContext* self);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
char* vala_source_file_get_cinclude_filename (ValaSourceFile* self);
const char* vala_code_context_get_header_filename (ValaCodeContext* self);
const char* vala_code_context_get_includedir (ValaCodeContext* self);
char* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno);
const char* vala_source_file_get_content (ValaSourceFile* self);
static void vala_source_file_read_source_lines (ValaSourceFile* self, const char* cont);
static void vala_source_file_read_source_file (ValaSourceFile* self);
gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self);
gpointer vala_source_reference_ref (gpointer instance);
void vala_source_reference_unref (gpointer instance);
GParamSpec* vala_param_spec_source_reference (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_source_reference (GValue* value, gpointer v_object);
void vala_value_take_source_reference (GValue* value, gpointer v_object);
gpointer vala_value_get_source_reference (const GValue* value);
GType vala_source_reference_get_type (void) G_GNUC_CONST;
void vala_report_error (ValaSourceReference* source, const char* message);
gsize vala_source_file_get_mapped_length (ValaSourceFile* self);
GType vala_semantic_analyzer_get_type (void) G_GNUC_CONST;
gboolean vala_source_file_check (ValaSourceFile* self, ValaSemanticAnalyzer* analyzer);
gboolean vala_code_node_check (ValaCodeNode* self, ValaSemanticAnalyzer* analyzer);
gboolean vala_source_file_get_external_package (ValaSourceFile* self);
const char* vala_source_file_get_gir_namespace (ValaSourceFile* self);
void vala_source_file_set_gir_namespace (ValaSourceFile* self, const char* value);
const char* vala_source_file_get_gir_version (ValaSourceFile* self);
void vala_source_file_set_gir_version (ValaSourceFile* self, const char* value);
static void vala_source_file_finalize (ValaSourceFile* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);



/**
 * Creates a new source file.
 *
 * @param filename source file name
 * @param pkg      true if this is a VAPI package file
 * @return         newly created source file
 */
ValaSourceFile* vala_source_file_construct (GType object_type, ValaCodeContext* context, const char* filename, gboolean pkg, const char* content) {
	ValaSourceFile* self;
	g_return_val_if_fail (context != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	self = (ValaSourceFile*) g_type_create_instance (object_type);
	vala_source_file_set_filename (self, filename);
	vala_source_file_set_external_package (self, pkg);
	vala_source_file_set_context (self, context);
	vala_source_file_set_content (self, content);
	return self;
}


ValaSourceFile* vala_source_file_new (ValaCodeContext* context, const char* filename, gboolean pkg, const char* content) {
	return vala_source_file_construct (VALA_TYPE_SOURCE_FILE, context, filename, pkg, content);
}


/**
 * Adds a header comment to this source file.
 */
void vala_source_file_add_comment (ValaSourceFile* self, ValaComment* comment) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment != NULL);
	vala_collection_add ((ValaCollection*) self->priv->comments, comment);
}


/**
 * Returns a copy of the list of header comments.
 *
 * @return list of comments
 */
static gpointer _vala_collection_object_ref0 (gpointer self) {
	return self ? vala_collection_object_ref (self) : NULL;
}


ValaList* vala_source_file_get_comments (ValaSourceFile* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 ((ValaList*) self->priv->comments);
	return result;
}


/**
 * Adds a new using directive with the specified namespace.
 *
 * @param ns reference to namespace
 */
void vala_source_file_add_using_directive (ValaSourceFile* self, ValaUsingDirective* ns) {
	ValaList* old_using_directives;
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	old_using_directives = _vala_collection_object_ref0 (self->priv->_current_using_directives);
	vala_source_file_set_current_using_directives (self, (ValaList*) (_tmp0_ = vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal)));
	_vala_collection_object_unref0 (_tmp0_);
	{
		ValaIterator* _using_directive_it;
		_using_directive_it = vala_iterable_iterator ((ValaIterable*) old_using_directives);
		while (TRUE) {
			ValaUsingDirective* using_directive;
			if (!vala_iterator_next (_using_directive_it)) {
				break;
			}
			using_directive = (ValaUsingDirective*) vala_iterator_get (_using_directive_it);
			vala_collection_add ((ValaCollection*) self->priv->_current_using_directives, using_directive);
			_vala_code_node_unref0 (using_directive);
		}
		_vala_collection_object_unref0 (_using_directive_it);
	}
	vala_collection_add ((ValaCollection*) self->priv->_current_using_directives, ns);
	_vala_collection_object_unref0 (old_using_directives);
}


/**
 * Adds the specified code node to this source file.
 *
 * @param node a code node
 */
void vala_source_file_add_node (ValaSourceFile* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_collection_add ((ValaCollection*) self->priv->nodes, node);
}


void vala_source_file_remove_node (ValaSourceFile* self, ValaCodeNode* node) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	vala_collection_remove ((ValaCollection*) self->priv->nodes, node);
}


/**
 * Returns a copy of the list of code nodes.
 *
 * @return code node list
 */
ValaList* vala_source_file_get_nodes (ValaSourceFile* self) {
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = _vala_collection_object_ref0 (self->priv->nodes);
	return result;
}


void vala_source_file_accept (ValaSourceFile* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_source_file (visitor, self);
}


void vala_source_file_accept_children (ValaSourceFile* self, ValaCodeVisitor* visitor) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (visitor != NULL);
	{
		ValaIterator* _node_it;
		_node_it = vala_iterable_iterator ((ValaIterable*) self->priv->nodes);
		while (TRUE) {
			ValaCodeNode* node;
			if (!vala_iterator_next (_node_it)) {
				break;
			}
			node = (ValaCodeNode*) vala_iterator_get (_node_it);
			vala_code_node_accept (node, visitor);
			_vala_code_node_unref0 (node);
		}
		_vala_collection_object_unref0 (_node_it);
	}
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static char* vala_source_file_get_subdir (ValaSourceFile* self) {
	char* result = NULL;
	char* _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_code_context_get_basedir (self->priv->_context) == NULL) {
		result = g_strdup ("");
		return result;
	}
	if ((_tmp1_ = g_str_has_prefix (self->priv->_filename, _tmp0_ = g_strconcat (vala_code_context_get_basedir (self->priv->_context), "/", NULL)), _g_free0 (_tmp0_), _tmp1_)) {
		char* basename;
		char* subdir;
		basename = g_path_get_basename (self->priv->_filename);
		subdir = string_substring (self->priv->_filename, g_utf8_strlen (vala_code_context_get_basedir (self->priv->_context), -1), (g_utf8_strlen (self->priv->_filename, -1) - g_utf8_strlen (vala_code_context_get_basedir (self->priv->_context), -1)) - g_utf8_strlen (basename, -1));
		while (TRUE) {
			char* _tmp2_;
			if (!(g_utf8_get_char (g_utf8_offset_to_pointer (subdir, 0)) == '/')) {
				break;
			}
			subdir = (_tmp2_ = g_strdup (g_utf8_offset_to_pointer (subdir, (glong) 1)), _g_free0 (subdir), _tmp2_);
		}
		result = subdir;
		_g_free0 (basename);
		return result;
	}
	result = g_strdup ("");
	return result;
}


static char* vala_source_file_get_destination_directory (ValaSourceFile* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_code_context_get_directory (self->priv->_context) == NULL) {
		result = vala_source_file_get_subdir (self);
		return result;
	}
	result = (_tmp1_ = g_strdup_printf ("%s/%s", vala_code_context_get_directory (self->priv->_context), _tmp0_ = vala_source_file_get_subdir (self)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


static char* vala_source_file_get_basename (ValaSourceFile* self) {
	char* result = NULL;
	glong dot;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	dot = g_utf8_pointer_to_offset (self->priv->_filename, g_utf8_strrchr (self->priv->_filename, (gssize) (-1), (gunichar) '.'));
	result = (_tmp1_ = g_path_get_basename (_tmp0_ = string_substring (self->priv->_filename, (glong) 0, dot)), _g_free0 (_tmp0_), _tmp1_);
	return result;
}


char* vala_source_file_get_relative_filename (ValaSourceFile* self) {
	char* result = NULL;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp2_ = g_strconcat (_tmp0_ = vala_source_file_get_subdir (self), _tmp1_ = g_path_get_basename (self->priv->_filename), NULL), _g_free0 (_tmp1_), _g_free0 (_tmp0_), _tmp2_);
	return result;
}


/**
 * Returns the filename to use when generating C source files.
 *
 * @return generated C source filename
 */
char* vala_source_file_get_csource_filename (ValaSourceFile* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->csource_filename == NULL) {
		if (vala_code_context_get_run_output (self->priv->_context)) {
			char* _tmp0_;
			self->priv->csource_filename = (_tmp0_ = g_strconcat (vala_code_context_get_output (self->priv->_context), ".c", NULL), _g_free0 (self->priv->csource_filename), _tmp0_);
		} else {
			gboolean _tmp1_ = FALSE;
			if (vala_code_context_get_ccode_only (self->priv->_context)) {
				_tmp1_ = TRUE;
			} else {
				_tmp1_ = vala_code_context_get_save_csources (self->priv->_context);
			}
			if (_tmp1_) {
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				self->priv->csource_filename = (_tmp4_ = g_strdup_printf ("%s%s.c", _tmp2_ = vala_source_file_get_destination_directory (self), _tmp3_ = vala_source_file_get_basename (self)), _g_free0 (self->priv->csource_filename), _tmp4_);
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
			} else {
				char* _tmp5_;
				char* _tmp6_;
				char* _tmp7_;
				self->priv->csource_filename = (_tmp7_ = g_strdup_printf ("%s%s.vala.c", _tmp5_ = vala_source_file_get_destination_directory (self), _tmp6_ = vala_source_file_get_basename (self)), _g_free0 (self->priv->csource_filename), _tmp7_);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp5_);
			}
		}
	}
	result = g_strdup (self->priv->csource_filename);
	return result;
}


/**
 * Returns the filename to use when including the generated C header
 * file.
 *
 * @return C header filename to include
 */
char* vala_source_file_get_cinclude_filename (ValaSourceFile* self) {
	char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->cinclude_filename == NULL) {
		if (vala_code_context_get_header_filename (self->priv->_context) != NULL) {
			char* _tmp0_;
			self->priv->cinclude_filename = (_tmp0_ = g_path_get_basename (vala_code_context_get_header_filename (self->priv->_context)), _g_free0 (self->priv->cinclude_filename), _tmp0_);
			if (vala_code_context_get_includedir (self->priv->_context) != NULL) {
				char* _tmp1_;
				self->priv->cinclude_filename = (_tmp1_ = g_strdup_printf ("%s/%s", vala_code_context_get_includedir (self->priv->_context), self->priv->cinclude_filename), _g_free0 (self->priv->cinclude_filename), _tmp1_);
			}
		} else {
			char* _tmp2_;
			char* _tmp3_;
			char* _tmp4_;
			self->priv->cinclude_filename = (_tmp4_ = g_strdup_printf ("%s%s.h", _tmp2_ = vala_source_file_get_subdir (self), _tmp3_ = vala_source_file_get_basename (self)), _g_free0 (self->priv->cinclude_filename), _tmp4_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp2_);
		}
	}
	result = g_strdup (self->priv->cinclude_filename);
	return result;
}


/**
 * Returns the requested line from this file, loading it if needed.
 *
 * @param lineno 1-based line number
 * @return       the specified source line
 */
char* vala_source_file_get_source_line (ValaSourceFile* self, gint lineno) {
	char* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->priv->source_array == NULL) {
		if (vala_source_file_get_content (self) != NULL) {
			vala_source_file_read_source_lines (self, vala_source_file_get_content (self));
		} else {
			vala_source_file_read_source_file (self);
		}
	}
	if (lineno < 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = lineno > vala_collection_get_size ((ValaCollection*) self->priv->source_array);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	result = (char*) vala_list_get ((ValaList*) self->priv->source_array, lineno - 1);
	return result;
}


/**
 * Parses the input file into ::source_array.
 */
static void vala_source_file_read_source_file (ValaSourceFile* self) {
	char* cont;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	cont = NULL;
	{
		char* _tmp0_ = NULL;
		char* _tmp1_;
		g_file_get_contents (self->priv->_filename, &_tmp0_, NULL, &_inner_error_);
		cont = (_tmp1_ = _tmp0_, _g_free0 (cont), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch9_g_file_error;
			}
			_g_free0 (cont);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally9;
	__catch9_g_file_error:
	{
		GError * fe;
		fe = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (fe);
			_g_free0 (cont);
			return;
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		_g_free0 (cont);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	vala_source_file_read_source_lines (self, cont);
	_g_free0 (cont);
}


static void vala_source_file_read_source_lines (ValaSourceFile* self, const char* cont) {
	ValaArrayList* _tmp0_;
	gint lines_length1;
	gint _lines_size_;
	char** _tmp2_;
	char** _tmp1_;
	char** lines;
	gint idx = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cont != NULL);
	self->priv->source_array = (_tmp0_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal), _vala_collection_object_unref0 (self->priv->source_array), _tmp0_);
	lines = (_tmp2_ = _tmp1_ = g_strsplit (cont, "\n", 0), lines_length1 = _vala_array_length (_tmp1_), _lines_size_ = lines_length1, _tmp2_);
	{
		gboolean _tmp3_;
		idx = 0;
		_tmp3_ = TRUE;
		while (TRUE) {
			if (!_tmp3_) {
				idx = idx + 1;
			}
			_tmp3_ = FALSE;
			if (!(lines[idx] != NULL)) {
				break;
			}
			vala_collection_add ((ValaCollection*) self->priv->source_array, lines[idx]);
		}
	}
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
}


gchar* vala_source_file_get_mapped_contents (ValaSourceFile* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (vala_source_file_get_content (self) != NULL) {
		result = (gchar*) vala_source_file_get_content (self);
		return result;
	}
	if (self->priv->mapped_file == NULL) {
		{
			GMappedFile* _tmp0_;
			GMappedFile* _tmp1_;
			_tmp0_ = g_mapped_file_new (self->priv->_filename, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch10_g_file_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			self->priv->mapped_file = (_tmp1_ = _tmp0_, _g_mapped_file_free0 (self->priv->mapped_file), _tmp1_);
		}
		goto __finally10;
		__catch10_g_file_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				char* _tmp2_;
				vala_report_error (NULL, _tmp2_ = g_strdup_printf ("Unable to map file `%s': %s", self->priv->_filename, e->message));
				_g_free0 (_tmp2_);
				result = NULL;
				_g_error_free0 (e);
				return result;
			}
		}
		__finally10:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = g_mapped_file_get_contents (self->priv->mapped_file);
	return result;
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


gsize vala_source_file_get_mapped_length (ValaSourceFile* self) {
	gsize result = 0UL;
	g_return_val_if_fail (self != NULL, 0UL);
	if (vala_source_file_get_content (self) != NULL) {
		result = (gsize) string_get_length (vala_source_file_get_content (self));
		return result;
	}
	result = g_mapped_file_get_length (self->priv->mapped_file);
	return result;
}


gboolean vala_source_file_check (ValaSourceFile* self, ValaSemanticAnalyzer* analyzer) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (analyzer != NULL, FALSE);
	{
		ValaIterator* _node_it;
		_node_it = vala_iterable_iterator ((ValaIterable*) self->priv->nodes);
		while (TRUE) {
			ValaCodeNode* node;
			if (!vala_iterator_next (_node_it)) {
				break;
			}
			node = (ValaCodeNode*) vala_iterator_get (_node_it);
			vala_code_node_check (node, analyzer);
			_vala_code_node_unref0 (node);
		}
		_vala_collection_object_unref0 (_node_it);
	}
	result = TRUE;
	return result;
}


const char* vala_source_file_get_filename (ValaSourceFile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_filename;
	return result;
}


void vala_source_file_set_filename (ValaSourceFile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_filename = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_filename), _tmp0_);
}


gboolean vala_source_file_get_external_package (ValaSourceFile* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_external_package;
	return result;
}


void vala_source_file_set_external_package (ValaSourceFile* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_external_package = value;
}


const char* vala_source_file_get_gir_namespace (ValaSourceFile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_gir_namespace;
	return result;
}


void vala_source_file_set_gir_namespace (ValaSourceFile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_gir_namespace = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_gir_namespace), _tmp0_);
}


const char* vala_source_file_get_gir_version (ValaSourceFile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_gir_version;
	return result;
}


void vala_source_file_set_gir_version (ValaSourceFile* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_gir_version = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_gir_version), _tmp0_);
}


ValaCodeContext* vala_source_file_get_context (ValaSourceFile* self) {
	ValaCodeContext* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_context;
	return result;
}


void vala_source_file_set_context (ValaSourceFile* self, ValaCodeContext* value) {
	g_return_if_fail (self != NULL);
	self->priv->_context = value;
}


const char* vala_source_file_get_content (ValaSourceFile* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_content;
	return result;
}


void vala_source_file_set_content (ValaSourceFile* self, const char* value) {
	char* _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_content = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_content), _tmp0_);
	self->priv->source_array = (_tmp1_ = NULL, _vala_collection_object_unref0 (self->priv->source_array), _tmp1_);
}


ValaList* vala_source_file_get_current_using_directives (ValaSourceFile* self) {
	ValaList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_current_using_directives;
	return result;
}


void vala_source_file_set_current_using_directives (ValaSourceFile* self, ValaList* value) {
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_current_using_directives = (_tmp0_ = _vala_collection_object_ref0 (value), _vala_collection_object_unref0 (self->priv->_current_using_directives), _tmp0_);
}


static void vala_value_source_file_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_source_file_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_source_file_unref (value->data[0].v_pointer);
	}
}


static void vala_value_source_file_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_source_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_source_file_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_source_file_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaSourceFile* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_source_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_source_file_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaSourceFile** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_source_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_source_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecSourceFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_SOURCE_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_source_file (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_source_file (GValue* value, gpointer v_object) {
	ValaSourceFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_source_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}


void vala_value_take_source_file (GValue* value, gpointer v_object) {
	ValaSourceFile* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_SOURCE_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_SOURCE_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_source_file_unref (old);
	}
}


static void vala_source_file_class_init (ValaSourceFileClass * klass) {
	vala_source_file_parent_class = g_type_class_peek_parent (klass);
	VALA_SOURCE_FILE_CLASS (klass)->finalize = vala_source_file_finalize;
	g_type_class_add_private (klass, sizeof (ValaSourceFilePrivate));
}


static void vala_source_file_instance_init (ValaSourceFile * self) {
	self->priv = VALA_SOURCE_FILE_GET_PRIVATE (self);
	self->priv->comments = vala_array_list_new (VALA_TYPE_COMMENT, (GBoxedCopyFunc) vala_comment_ref, vala_comment_unref, g_direct_equal);
	self->priv->_current_using_directives = (ValaList*) vala_array_list_new (VALA_TYPE_USING_DIRECTIVE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->nodes = (ValaList*) vala_array_list_new (VALA_TYPE_CODE_NODE, (GBoxedCopyFunc) vala_code_node_ref, vala_code_node_unref, g_direct_equal);
	self->priv->csource_filename = NULL;
	self->priv->cinclude_filename = NULL;
	self->priv->source_array = NULL;
	self->priv->mapped_file = NULL;
	self->priv->_content = NULL;
	self->ref_count = 1;
}


static void vala_source_file_finalize (ValaSourceFile* obj) {
	ValaSourceFile * self;
	self = VALA_SOURCE_FILE (obj);
	_g_free0 (self->priv->_filename);
	_g_free0 (self->priv->_gir_namespace);
	_g_free0 (self->priv->_gir_version);
	_vala_collection_object_unref0 (self->priv->comments);
	_vala_collection_object_unref0 (self->priv->_current_using_directives);
	_vala_collection_object_unref0 (self->priv->nodes);
	_g_free0 (self->priv->csource_filename);
	_g_free0 (self->priv->cinclude_filename);
	_vala_collection_object_unref0 (self->priv->source_array);
	_g_mapped_file_free0 (self->priv->mapped_file);
	_g_free0 (self->priv->_content);
}


/**
 * Represents a Vala source or VAPI package file.
 */
GType vala_source_file_get_type (void) {
	static volatile gsize vala_source_file_type_id__volatile = 0;
	if (g_once_init_enter (&vala_source_file_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_source_file_init, vala_value_source_file_free_value, vala_value_source_file_copy_value, vala_value_source_file_peek_pointer, "p", vala_value_source_file_collect_value, "p", vala_value_source_file_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaSourceFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_source_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSourceFile), 0, (GInstanceInitFunc) vala_source_file_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_source_file_type_id;
		vala_source_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaSourceFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_source_file_type_id__volatile, vala_source_file_type_id);
	}
	return vala_source_file_type_id__volatile;
}


gpointer vala_source_file_ref (gpointer instance) {
	ValaSourceFile* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_source_file_unref (gpointer instance) {
	ValaSourceFile* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_SOURCE_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}




