/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/* settings.c: this file is part of users-admin, a ximian-setup-tool frontend 
 * for user administration.
 * 
 * Copyright (C) 2000-2001 Ximian, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Tambet Ingo <tambet@ximian.com> and Arturo Espinosa <arturo@ximian.com>.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <ctype.h>
#include <gnome.h>

#include "xst.h"
#include "settings.h"
#include "e-table.h"

extern XstTool *tool;

static void
on_cancel_clicked (GtkButton *button, gpointer user_data)
{
	g_warning ("cancel");
}

static void
on_ok_clicked (GtkButton *button, gpointer user_data)
{
	g_warning ("Ok");
}

/*
static XstDialogSignal signals[] = {
	{ "settings_cancel", "clicked",  on_cancel_clicked },
	{ "settings_ok",     "clicked",  on_ok_clicked },
	{ NULL }
};

static const XstWidgetPolicy policies[] = {
	* Name                     Basic                        Advanced                   Root   *
	{ "settings_ok",            XST_WIDGET_MODE_SENSITIVE,   XST_WIDGET_MODE_SENSITIVE, TRUE,  FALSE },
	{ NULL }
};
*/

void
settings_setup (void)
{
	GtkWidget *dialog;
	xmlNode *node = get_selected_node ();

	g_warning ("Settings setup");

	dialog = xst_dialog_get_widget (
		tool->main_dialog, "print_settings_dialog");

/*	xst_dialog_connect_signals (XST_DIALOG (dialog), signals);
	xst_dialog_set_widget_policies (dialog, policies);*/

	gtk_widget_show (dialog);
}
