/* properties.c - properties box for xpenguins_applet
 * Copyright (C) 1999, 2000  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <stdio.h>
#include <config.h>
#include <applet-widget.h>

#include "xpenguins_applet.h"
#include "xpenguins.h"


static void 
property_apply_cb(GtkWidget *widget, void *data, XPenguinData *xp)
{
  xp->number = xp->number_adj->value;
  xp->speed = xp->speed_adj->value;
  if (xp->active) {
    gtk_timeout_remove(xp->timeout);
    xp->timeout = gtk_timeout_add(1000/xp->speed, service_xpenguins,
				  xp);
  }
  xpenguins_set_number(xp->number);
  if (GTK_TOGGLE_BUTTON(xp->ignorepopups_check)->active) {
    xp->ignorepopups = 1;
  }
  else {
    xp->ignorepopups = 0;
  }
  xpenguins_ignorepopups(xp->ignorepopups);
  return;
}

static gint 
property_destroy_cb( GtkWidget *widget, XPenguinData *xp)
{
  xp->prop_window = NULL;
  return FALSE;
}

static void
update_number_cb(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(xp->prop_window));
}

static void
update_speed_cb(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(xp->prop_window));
}

static void
update_ignorepopups_cb(GtkWidget *widget, gpointer data)
{
  XPenguinData *xp = data;
  gnome_property_box_changed(GNOME_PROPERTY_BOX(xp->prop_window));
}

void
property_show (AppletWidget *applet, gpointer data)
{
  static GnomeHelpMenuEntry help_entry = { NULL, "properties" };
  XPenguinData *xp = data;
  GtkWidget *frame;
  GtkWidget *label;
  GtkWidget *table;
  GtkWidget *number_range, *speed_range;

  help_entry.name = gnome_app_id;

  if(xp->prop_window) {
    gdk_window_raise(xp->prop_window->window);
    return;
  }
  xp->prop_window = gnome_property_box_new();
  gtk_window_set_title(GTK_WINDOW(&GNOME_PROPERTY_BOX(xp->prop_window)->dialog.window),
		       _("XPenguins settings"));
  frame = gtk_vbox_new(FALSE, 5);

  table = gtk_table_new(2,2,FALSE);
  gtk_box_pack_start(GTK_BOX(frame), table, TRUE, TRUE, 5);
  gtk_widget_show(table);

  label = gtk_label_new(_("Number of penguins:"));
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		   GTK_FILL | GTK_SHRINK, GTK_FILL | GTK_SHRINK, 5, 5);
  gtk_widget_show(label);

  xp->number_adj = (GtkAdjustment *) gtk_adjustment_new(xp->number,
							1,110,1,1,10);
  number_range = gtk_hscale_new(GTK_ADJUSTMENT(xp->number_adj));
  gtk_table_attach(GTK_TABLE(table), number_range, 1, 2, 0, 1,
		   GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_SHRINK, 5, 5);
  gtk_signal_connect(GTK_OBJECT(xp->number_adj),"value_changed",
		     GTK_SIGNAL_FUNC(update_number_cb), xp);
  gtk_range_set_update_policy(GTK_RANGE(number_range),
			      GTK_UPDATE_DISCONTINUOUS);
  gtk_widget_show(number_range);

  label = gtk_label_new(_("Frame rate (Hz):"));
  gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
		   GTK_FILL | GTK_SHRINK , GTK_FILL | GTK_SHRINK, 5, 5);
  gtk_widget_show(label);

  xp->speed_adj = (GtkAdjustment *) gtk_adjustment_new(xp->speed,
						       1,101,1,1,1);
  speed_range = gtk_hscale_new(GTK_ADJUSTMENT(xp->speed_adj));
  gtk_table_attach(GTK_TABLE(table), speed_range, 1, 2, 1, 2,
		   GTK_FILL | GTK_EXPAND, GTK_FILL | GTK_SHRINK, 5, 5);
  gtk_signal_connect(GTK_OBJECT(xp->speed_adj),"value_changed",
		     GTK_SIGNAL_FUNC(update_speed_cb), xp);
  gtk_range_set_update_policy(GTK_RANGE(speed_range),
			      GTK_UPDATE_DISCONTINUOUS);
  gtk_widget_show(speed_range);

  xp->ignorepopups_check = gtk_check_button_new_with_label("Ignore popup windows");
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(xp->ignorepopups_check),
			       xp->ignorepopups);
  gtk_box_pack_start(GTK_BOX(frame), xp->ignorepopups_check, TRUE, TRUE, 5);
  gtk_signal_connect(GTK_OBJECT(xp->ignorepopups_check),"clicked",
		     GTK_SIGNAL_FUNC(update_ignorepopups_cb), xp);
  gtk_widget_show(xp->ignorepopups_check);

  label = gtk_label_new(_("General"));
  gtk_widget_show(frame);
  gnome_property_box_append_page(GNOME_PROPERTY_BOX(xp->prop_window),
				 frame, label);
  gtk_signal_connect( GTK_OBJECT(xp->prop_window), "apply",
		      GTK_SIGNAL_FUNC(property_apply_cb), xp);

  gtk_signal_connect( GTK_OBJECT(xp->prop_window), "destroy",
		      GTK_SIGNAL_FUNC(property_destroy_cb), xp);

  /* Haven't written any documentation yet... */
  /*
  gtk_signal_connect( GTK_OBJECT(xp->prop_window), "help",
		      GTK_SIGNAL_FUNC(gnome_help_pbox_display),
		      &help_entry );
  */
  gtk_widget_show_all(xp->prop_window);
}

