<?xml version='1.0' encoding='UTF-8'?><!-- -*- indent-tabs-mode: nil -*- -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:yelp="http://www.gnome.org/yelp/ns"
                xmlns:mal="http://www.gnome.org/~shaunm/mallard"
                xmlns="http://www.w3.org/1999/xhtml"
                extension-element-prefixes="yelp"
                version="1.0">

<xsl:import href="/usr/share/yelp-xsl/xslt/mallard/html/mal2xhtml.xsl"/>

<xsl:include href="yelp-common.xsl"/>

<xsl:param name="yelp.stub" select="false()"/>

<xsl:param name="mal2html.editor_mode" select="$yelp.editor_mode"/>

<xsl:param name="mal.chunk.chunk_top" select="true()"/>
<xsl:param name="mal.chunk.extension" select="''"/>

<xsl:param name="mal.cache" select="yelp:input()"/>
<xsl:key name="mal.cache.key" match="mal:page | mal:section" use="@id"/>


<!-- == mal.chunk == -->
<xsl:template name="mal.chunk">
  <xsl:param name="node" select="."/>
  <xsl:param name="href" select="concat($node/@id, $mal.chunk.extension)"/>
  <yelp:document href="{$href}">
    <xsl:apply-templates mode="mal.chunk.content.mode" select="$node"/>
  </yelp:document>
</xsl:template>

<!-- == mal.link.target == -->
<xsl:template name="mal.link.target">
  <xsl:param name="link" select="."/>
  <xsl:param name="xref" select="$link/@xref"/>
  <xsl:param name="href" select="$link/@href"/>
  <xsl:choose>
    <xsl:when test="string($xref) = ''">
      <xsl:value-of select="$href"/>
    </xsl:when>
    <xsl:when test="contains($xref, '/')">
      <xsl:value-of select="$href"/>
    </xsl:when>
    <xsl:when test="contains($xref, '#')">
      <xsl:variable name="pageid" select="substring-before($xref, '#')"/>
      <xsl:variable name="sectionid" select="substring-after($xref, '#')"/>
      <xsl:value-of select="concat('xref:', $pageid, '#', $sectionid)"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="concat('xref:', $xref)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="mal2html.css.custom">
<xsl:text>
div.linkdiv { border: none; }
div.linkdiv:hover {
  border: none;
  outline: solid 1px </xsl:text>
    <xsl:value-of select="$theme.color.blue_background"/><xsl:text>;
  background: -webkit-gradient(linear, left top, left 80, from(</xsl:text>
    <xsl:value-of select="$theme.color.blue_background"/><xsl:text>), to(</xsl:text>
    <xsl:value-of select="$theme.color.background"/><xsl:text>));
}
</xsl:text>
<xsl:if test="$yelp.editor_mode">
<xsl:text>
div.head { margin: 0; }
div.version {
  margin: 0 -12px 1em -12px;
  padding: 0.5em 12px 0.5em 12px;
  position: relative;
  left: auto; right: auto;
  opacity: 1.0;
  max-width: none;
  border: none;
  border-bottom: solid 1px </xsl:text>
    <xsl:value-of select="$theme.color.gray_border"/><xsl:text>;
  background-color: </xsl:text>
    <xsl:value-of select="$theme.color.yellow_background"/><xsl:text>;
}
div.version:hover { opacity: 1.0; }
</xsl:text>
<xsl:if test="$yelp.stub">
<xsl:text>
body, div.body {
  background-color: </xsl:text>
    <xsl:value-of select="$theme.color.red_background"/><xsl:text>;
}
</xsl:text>
</xsl:if>
</xsl:if>
</xsl:template>

<xsl:template name="mal2html.page.head.extra">
  <xsl:call-template name="yelp.common.javascript"/>
</xsl:template>

</xsl:stylesheet>
