/* translation of file(s)
	"petrinet-patterns-basic.k"
	"petrinet-patterns-structured.k"
	"petrinet-patterns-scopes.k"
	"petrinet-patterns-handlers.k"
	"petrinet-patterns-links.k"
	"petrinet-patterns-shortcuts.k"
	"ast-grammar.k"
	"ast-config.k"
	"ast-to-petrinet.k"
	"ast-to-xml.k"
	"ast-to-cfg.k"
	"ast-postprocess.k"
	"ast-rewrite.k"
	"ast-to-visualization.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.11 (C) 1998-2007 Humboldt-University of Berlin $
 */
#define KC_UNPARSE

#include <stdio.h>
#include <string>
#include <stdlib.h>
#include "ast-system-k.h"
#include "ast-system-unpk.h"


namespace kc {
base_uview_class base_uview;
petrinetsmall_class petrinetsmall;
petrinetnew_class petrinetnew;
xml_class xml;
cfg_class cfg;
postprocessing_class postprocessing;
evaluation_class evaluation;
visualization_class visualization;

impl_uviews uviews[] = {
    {"base_uview",&base_uview},
    {"petrinetsmall",&petrinetsmall},
    {"petrinetnew",&petrinetnew},
    {"xml",&xml},
    {"cfg",&cfg},
    {"postprocessing",&postprocessing},
    {"evaluation",&evaluation},
    {"visualization",&visualization},
    {0,0}
};

} // namespace kc
namespace kc { }
using namespace kc;
/* included stuff */
#line 93 "ast-config.k"
#include <iostream>
#include <cmath>
#include <cassert>
#include <map>
#include <set>
#include <climits>
#include <string>

#include "petrinet-patterns-basic.h"
#include "petrinet-patterns-structured.h"
#include "petrinet-patterns-scopes.h"
#include "petrinet-patterns-handlers.h"
#include "petrinet-patterns-links.h"
#include "extension-wsdl.h"			// for class WSDL
#include "options.h"
#include "cfg.h"
#include "helpers.h"
#include "ast-details.h"
#include "ast-tools.h"
#include "globals.h"
#include "extension-chor.h"

using std::endl;
using std::cerr;

extern PetriNet PN;				// introduced in main.c
extern CFGBlock * CFG;				// introduced in cfg.cc

#line  85 "ast-system-unpk.cc"
/* end included stuff */


namespace kc {

#ifndef KC_TRACE_PROVIDED
#define KC_TRACE_PROVIDED(COND,FILE,LINE,NODE) COND
#endif

void
impl_abstract_phylum::unparse(printer_function opf, uview uv)
{
    printer_functor_function_wrapper pf(opf);
    do_unparse(pf, uv);
}

// Everything given as a pointer is expected to have an unparse-method (we
// believe it's a phylum), unless there's a specialisation for it

void
unparse(abstract_phylum kc_p, printer_functor kc_printer, uview kc_current_view)
{
    kc_p->unparse(kc_printer, kc_current_view);
}

void
unparse(void *kc_p, printer_functor kc_printer, uview kc_current_view)
{
    // MPi: 20020628 there shouldn't be any left
    assertionFailed("Unparse called for untyped pointer");
    // MPi: cast should be unnecessary, but there are still void*
    reinterpret_cast<impl_abstract_phylum*>(kc_p)->unparse(kc_printer, kc_current_view);
}

void
unparse(int kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_integer(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(double kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_char_t kc_string[200];
    kc_print_real(kc_string, kc_v);
    kc_printer(kc_string, kc_current_view);
}

void
unparse(kc_char_t *kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v, kc_current_view);
}

void
unparse(kc_string_t kc_v, printer_functor kc_printer, uview kc_current_view)
{
    kc_printer(kc_v.c_str(), kc_current_view);
}

#line  148 "ast-system-unpk.cc"
void
impl_abstract_phylum::default_unparse(printer_functor kc_printer, uview kc_current_view)
{
    register int no_sons = operator_info[prod_sel()].no_sons;
    for (int i=0; i < no_sons; i++)
    subphylum(i)->unparse(kc_printer, kc_current_view);
}

void
impl_casestring__Str::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_nocasestring_NoCaseStr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(name, kc_printer, kc_current_view);
}

void
impl_integer__Int::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_real__Real::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(value, kc_printer, kc_current_view);
}

void
impl_voidptr__VoidPtr::do_unparse(printer_functor kc_printer, uview kc_current_view)
{
    kc::unparse(pointer, kc_printer, kc_current_view);
}


#line  188 "ast-system-unpk.cc"
void
impl_tProcess_Process::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 55 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 55 "ast-to-visualization.k"
		const tPartner_list b = this->tPartner_list_1;
#line 55 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 55 "ast-to-visualization.k"
		const tVariable_list c = this->tVariable_list_1;
#line 55 "ast-to-visualization.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 55 "ast-to-visualization.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 55 "ast-to-visualization.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 55 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 55 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 58 "ast-to-visualization.k"

		globals::visArcs = "";
		(*output) << "digraph N {" << endl;
		(*output) << " graph [fontname=\"Helvetica\" label=\"";
		(*output) << "Visualization of the BPEL-Process generated from " << globals::filename << "\"]" << endl;
		(*output) << "compound = true;" << endl;
		globals::ASTEmap[_id->value]->visConnection = "Process_Start";

#line  223 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 67 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Process activity\";" << endl;  

#line  234 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 71 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

		unsigned int linkId;
		unsigned int source;
		unsigned int target;
		for(set<string>::iterator names = globals::ASTE_linkNames.begin(); names != globals::ASTE_linkNames.end(); names++)
		{
		    linkId = globals::ASTE_linkIdMap[(*names)];

		    source = globals::ASTEmap[linkId]->sourceActivity;
		    target = globals::ASTEmap[linkId]->targetActivity;

		    globals::visArcs += globals::ASTEmap[source]->visConnection + " -> " + globals::ASTEmap[target]->secVisConnection + "["; 
		    if (globals::ASTEmap[target]->structured())
		    {
			globals::visArcs += "lhead=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(target);          
			globals::visArcs += " ";          
		    } 
		    if (globals::ASTEmap[source]->structured())
		    {
			globals::visArcs += "ltail=";
			globals::visArcs += "cluster";          
			globals::visArcs += toString(source);          
		    }
		    globals::visArcs += "];\n";
		}
		(*output) << globals::visArcs;
		(*output) << "}" << endl;

#line  271 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 55 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 55 "ast-postprocess.k"
		const tPartner_list b = this->tPartner_list_1;
#line 55 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 55 "ast-postprocess.k"
		const tVariable_list c = this->tVariable_list_1;
#line 55 "ast-postprocess.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 55 "ast-postprocess.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 55 "ast-postprocess.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 55 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 55 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 57 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = myid;
		myself->parentActivityId = myid;
		globals::PPcurrentScope = myid;


		myself->checkAttributes();
		myself->hasEH = (string(g->op_name()) == "EventHandlers");


		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[g->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[g->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = e->id;

#line  323 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 86 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ e->id ]->catches.begin(); fault != globals::ASTEmap[ e->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }
		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {

			callableFH = true;
		    }
		}
		if ( globals::ASTEmap[ e->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ e->id ]->callable = callableFH;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = globals::ASTEmap[i->id]->enclosedSourceLinks;
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks );
		myself->enclosedSourceLinks = setUnion( myself->enclosedSourceLinks, globals::ASTEmap[g->id]->enclosedSourceLinks );

		myself->enclosedTargetLinks = globals::ASTEmap[i->id]->enclosedTargetLinks;
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks );
		myself->enclosedTargetLinks = setUnion( myself->enclosedTargetLinks, globals::ASTEmap[g->id]->enclosedTargetLinks );

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ e->id ]->enclosedActivities;
		faultIds.insert( e->id );

		enterConflictingActivities( innerIds, faultIds );




		if (globals::ASTE_startActivities.empty())
		SAerror(15, "", myself->attributes["referenceLine"]);





		bool linksOK = true;
		for(map<string, unsigned int>::iterator it = globals::ASTE_linkIdMap.begin(); it != globals::ASTE_linkIdMap.end(); it++)
		{
		    if ( it-> first != "" )
		    {
			assert(globals::ASTEmap[it->second] != NULL);

			if ((globals::ASTEmap[it->second]->targetActivity == 0) || (globals::ASTEmap[it->second]->sourceActivity == 0))
			{
			    SAerror(66, it->first, globals::ASTEmap[it->second]->attributes["referenceLine"]);
			    linksOK = false;
			}


			if (linksOK)
			{
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity] != NULL);
			    assert(globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity] != NULL);
			    set<unsigned int> otherSources = globals::ASTEmap[globals::ASTEmap[it->second]->sourceActivity]->sourceLinks;
			    set<unsigned int> otherTargets = globals::ASTEmap[globals::ASTEmap[it->second]->targetActivity]->targetLinks;
			    set<unsigned int> jointLinks = setIntersection(otherSources, otherTargets);
			    jointLinks.erase(it->second);

			    if (jointLinks.size() > 0)
			    SAerror(67, "`" + it->first + "' and <link> `" + globals::ASTEmap[*(jointLinks.begin())]->attributes["name"] + "'", globals::ASTEmap[it->second]->attributes["referenceLine"]);
			}
		    }
		}



		set<string> reallySharedCorrelationSets;
		if (globals::ASTE_startActivities.size() > 1)
		{
		    for (set<unsigned int>::iterator it = globals::ASTE_startActivities.begin(); it != globals::ASTE_startActivities.end(); it++)
		    {
			if (it == globals::ASTE_startActivities.begin())
			reallySharedCorrelationSets = globals::ASTEmap[*it]->sharedCorrelationSets;
			else
			reallySharedCorrelationSets = setIntersection(reallySharedCorrelationSets, globals::ASTEmap[*it]->sharedCorrelationSets);

			if (reallySharedCorrelationSets.empty())
			{
			    SAerror(57, "", globals::ASTEmap[*it]->attributes["referenceLine"]);
			    break;
			}
		    }
		}




		if (linksOK)
		{
		    assert(myself->enclosedSourceLinks.size() == globals::ASTE_linkNames.size());
		    assert(myself->enclosedTargetLinks.size() == globals::ASTE_linkNames.size());
		}



		globals::ASTE_correlationSetNames.clear(); 
		globals::ASTE_partnerLinkNames.clear();    
		globals::ASTE_startActivities.clear();	

#line  448 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 57 "ast-to-cfg.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 57 "ast-to-cfg.k"
		const tPartner_list b = this->tPartner_list_1;
#line 57 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 57 "ast-to-cfg.k"
		const tVariable_list c = this->tVariable_list_1;
#line 57 "ast-to-cfg.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 57 "ast-to-cfg.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 57 "ast-to-cfg.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 57 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 57 "ast-to-cfg.k"
		const integer j = this->integer_1;
#line 58 "ast-to-cfg.k"


		globals::cfgMap = map<std::string, CFGBlock *>();
		sources = map<std::string, CFGBlock *>();
		targets = map<std::string, CFGBlock *>();


		trace(TRACE_DEBUG, "[CFG] Process\n");
		CFGBlock* firstBlock = new CFGBlock(CFGProcess, this->id, "Process_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGProcess, this->id, "Process_end");


		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		CFG = firstBlock;
		globals::cfgMap[toString(this->id)] = CFG; 

#line  492 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 77 "ast-to-cfg.k"


		CFGBlock *fhFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock *fhLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;


		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);

#line  504 "ast-system-unpk.cc"
		kc::unparse(g, kc_printer, kc_current_view);
#line 97 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(g->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(g->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  515 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 106 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  525 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 57 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 57 "ast-to-xml.k"
		const tPartner_list b = this->tPartner_list_1;
#line 57 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 57 "ast-to-xml.k"
		const tVariable_list c = this->tVariable_list_1;
#line 57 "ast-to-xml.k"
		const tCorrelationSet_list d = this->tCorrelationSet_list_1;
#line 57 "ast-to-xml.k"
		const tFaultHandlers e = this->tFaultHandlers_1;
#line 57 "ast-to-xml.k"
		const tEventHandlers g = this->tEventHandlers_1;
#line 57 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 57 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 58 "ast-to-xml.k"
		inup(); 
#line  552 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<process id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 58 "ast-to-xml.k"
		listAttributes( _id ); 
#line  558 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 60 "ast-to-xml.k"
		if (a->length() == 0) 
#line  562 "ast-system-unpk.cc"
		{
		}
#line 62 "ast-to-xml.k"
		else 
#line  567 "ast-system-unpk.cc"
		{
#line 63 "ast-to-xml.k"
		    inup(); 
#line  571 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partnerLinks>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 63 "ast-to-xml.k"
		    indown(); 
#line  576 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partnerLinks>\n"), kc_current_view); }
		}
#line 65 "ast-to-xml.k"
		if (b->length() == 0) 
#line  581 "ast-system-unpk.cc"
		{
		}
#line 67 "ast-to-xml.k"
		else 
#line  586 "ast-system-unpk.cc"
		{
#line 68 "ast-to-xml.k"
		    inup(); 
#line  590 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<partners>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 68 "ast-to-xml.k"
		    indown(); 
#line  595 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</partners>\n"), kc_current_view); }
		}
#line 70 "ast-to-xml.k"
		if (c->length() == 0) 
#line  600 "ast-system-unpk.cc"
		{
		}
#line 72 "ast-to-xml.k"
		else 
#line  605 "ast-system-unpk.cc"
		{
#line 73 "ast-to-xml.k"
		    inup(); 
#line  609 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables>\n"), kc_current_view); }
		    kc::unparse(c, kc_printer, kc_current_view);
#line 73 "ast-to-xml.k"
		    indown(); 
#line  614 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
#line 75 "ast-to-xml.k"
		if (d->length() == 0) 
#line  619 "ast-system-unpk.cc"
		{
		}
#line 77 "ast-to-xml.k"
		else 
#line  624 "ast-system-unpk.cc"
		{
#line 78 "ast-to-xml.k"
		    inup(); 
#line  628 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlationSets>\n"), kc_current_view); }
		    kc::unparse(d, kc_printer, kc_current_view);
#line 78 "ast-to-xml.k"
		    indown(); 
#line  633 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlationSets>\n"), kc_current_view); }
		}
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 80 "ast-to-xml.k"
		indown(); 
#line  641 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</process>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 164 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  654 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 164 "ast-to-petrinet.k"
		PProcess(this, kc_current_view_base);


		globals::ASTE_scopeNames.clear(); 
#line  666 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  671 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  684 "ast-system-unpk.cc"
void
impl_activity_activityScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  690 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  703 "ast-system-unpk.cc"
void
impl_activity_activityFlow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  709 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  722 "ast-system-unpk.cc"
void
impl_activity_activityPick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  728 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  741 "ast-system-unpk.cc"
void
impl_activity_activityForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  747 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  760 "ast-system-unpk.cc"
void
impl_activity_activityRepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  766 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  779 "ast-system-unpk.cc"
void
impl_activity_activityWhile::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  785 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  798 "ast-system-unpk.cc"
void
impl_activity_activityIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  804 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  817 "ast-system-unpk.cc"
void
impl_activity_activitySequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  823 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  836 "ast-system-unpk.cc"
void
impl_activity_activityCompensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  842 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  855 "ast-system-unpk.cc"
void
impl_activity_activityRethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  861 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  874 "ast-system-unpk.cc"
void
impl_activity_activityThrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  880 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  893 "ast-system-unpk.cc"
void
impl_activity_activityExit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  899 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  912 "ast-system-unpk.cc"
void
impl_activity_activityWait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  918 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  931 "ast-system-unpk.cc"
void
impl_activity_activityOpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  937 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  950 "ast-system-unpk.cc"
void
impl_activity_activityEmpty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  956 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  969 "ast-system-unpk.cc"
void
impl_activity_activityValidate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  975 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  988 "ast-system-unpk.cc"
void
impl_activity_activityAssign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  994 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1007 "ast-system-unpk.cc"
void
impl_activity_activityInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1013 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1026 "ast-system-unpk.cc"
void
impl_activity_activityReply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1032 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1045 "ast-system-unpk.cc"
void
impl_activity_activityReceive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1051 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_activity_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1071 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (activity_list iterator_ = this; iterator_->activity_list_1 != 0; iterator_ = iterator_->activity_list_1)
		    iterator_->activity_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_activity_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1089 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1108 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartnerLink_list iterator_ = this; iterator_->tPartnerLink_list_1 != 0; iterator_ = iterator_->tPartnerLink_list_1)
		    iterator_->tPartnerLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartnerLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1126 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1138 "ast-system-unpk.cc"
void
impl_tPartnerLink_PartnerLink::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 112 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 209 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 211 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();


		if(globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]] != NULL)
		globals::WSDLInfo.partnerLinkTypes[myself->attributes["partnerLinkType"]]->correctOrder(myself);

		myself->definePartnerLink();



#line  1174 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 89 "ast-to-xml.k"
		in(); 
#line  1185 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partnerLink id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 89 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1191 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  1197 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1217 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tPartner_list iterator_ = this; iterator_->tPartner_list_1 != 0; iterator_ = iterator_->tPartner_list_1)
		    iterator_->tPartner_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tPartner_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1235 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1247 "ast-system-unpk.cc"
void
impl_tPartner_Partner::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 121 "ast-to-visualization.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 121 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 236 "ast-postprocess.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 236 "ast-postprocess.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 97 "ast-to-xml.k"
		const tPartnerLink_list a = this->tPartnerLink_list_1;
#line 97 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 98 "ast-to-xml.k"
		inup(); 
#line  1282 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<partner id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 98 "ast-to-xml.k"
		indown(); 
#line  1289 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</partner>\n"), kc_current_view); }
	    }
	    break;
	}

#line  1295 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1308 "ast-system-unpk.cc"
void
impl_tFaultHandlers_FaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 130 "ast-to-visualization.k"
		const tCatch_list a = this->tCatch_list_1;
#line 130 "ast-to-visualization.k"
		const tCatchAll b = this->tCatchAll_1;
#line 130 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 132 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  1324 "ast-system-unpk.cc"
		{
		}
#line 134 "ast-to-visualization.k"
		else 
#line  1329 "ast-system-unpk.cc"
		{
#line 136 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"FaultHandlers\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  1341 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
		    kc::unparse(b, kc_printer, kc_current_view);
#line 146 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  1348 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 245 "ast-postprocess.k"
		const tCatch_list a = this->tCatch_list_1;
#line 245 "ast-postprocess.k"
		const tCatchAll b = this->tCatchAll_1;
#line 245 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 247 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		myself->hasCatchAll = (string(b->op_name()) == "CatchAll");





		{
#line 262 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1382 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 262 "ast-postprocess.k"
			    {
#line 263 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 263 "ast-postprocess.k"
#line 262 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 262 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 263 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid; 
				    globals::ASTEmap[branch->id]->parentActivityId = myid;
				    globals::ASTEmap[branch->id]->parentScopeId = myself->parentScopeId;
				    globals::ASTEmap[innerActivity->id]->controlFlow = FHCF;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  1406 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1411 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 262 "ast-postprocess.k"

#line  1416 "ast-system-unpk.cc"
		    }
		}
#line 271 "ast-postprocess.k"



		{
#line 274 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 277 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 277 "ast-postprocess.k"
#line 276 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 276 "ast-postprocess.k"
			const integer _id = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 277 "ast-postprocess.k"

			assert(globals::ASTEmap[c->id] != NULL);

			globals::ASTEmap[b->id]->parentActivityId = myid;
			globals::ASTEmap[c->id]->controlFlow = FHCF;
			globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;

#line  1441 "ast-system-unpk.cc"
		    } else
		    {
#line 285 "ast-postprocess.k"
#line 285 "ast-postprocess.k"


			if (a->length() == 0)
			SAerror(80, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));

#line  1451 "ast-system-unpk.cc"
		    }
		}
#line 291 "ast-postprocess.k"

#line  1456 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 293 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		{
#line 298 "ast-postprocess.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1469 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 298 "ast-postprocess.k"
			    {
#line 299 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 299 "ast-postprocess.k"
#line 298 "ast-postprocess.k"
				    const tCatch branch = kc_selvar_0_1;
#line 298 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 298 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->integer_1;
#line 299 "ast-postprocess.k"

				    {
#line 300 "ast-postprocess.k"
					tCatch_list kc_fe_selvar_1 =  a;

#line  1492 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
					    ) {
					    tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
					    {
#line 300 "ast-postprocess.k"
						{
#line 301 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 301 "ast-postprocess.k"
#line 300 "ast-postprocess.k"
							const tCatch otherbranch = kc_selvar_1_1;
#line 300 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 300 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 301 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if ( _id2->value < _id3->value )
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  1518 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  1523 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 300 "ast-postprocess.k"

#line  1528 "ast-system-unpk.cc"
					}
				    }
#line 309 "ast-postprocess.k"

#line  1533 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1538 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 298 "ast-postprocess.k"

#line  1543 "ast-system-unpk.cc"
		    }
		}
#line 310 "ast-postprocess.k"

		{
#line 311 "ast-postprocess.k"
		    tCatchAll kc_selvar_0_1 = phylum_cast<tCatchAll>(b);
#line 314 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_CatchAll)) {
#line 314 "ast-postprocess.k"
#line 313 "ast-postprocess.k"
			const activity c = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->activity_1;
#line 313 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tCatchAll_CatchAll*>(kc_selvar_0_1)->integer_1;
#line 314 "ast-postprocess.k"

			{
#line 315 "ast-postprocess.k"
			    tCatch_list kc_fe_selvar_1 =  a;

#line  1564 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
				) {
				tCatch kc_selvar_1_1 = kc_fe_selvar_1->tCatch_1;
				{
#line 315 "ast-postprocess.k"
				    {
#line 316 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Catch)) {
#line 316 "ast-postprocess.k"
#line 315 "ast-postprocess.k"
					    const tCatch otherbranch = kc_selvar_1_1;
#line 315 "ast-postprocess.k"
					    const activity secondActivity = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->activity_1;
#line 315 "ast-postprocess.k"
					    const integer _id3 = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_1_1)->integer_1;
#line 316 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(_id3 != NULL);
					    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );

#line  1587 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  1592 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 315 "ast-postprocess.k"

#line  1597 "ast-system-unpk.cc"
			    }
			}
#line 321 "ast-postprocess.k"

#line  1602 "ast-system-unpk.cc"
		    } else
		    {
#line 323 "ast-postprocess.k"
#line 323 "ast-postprocess.k"


#line  1609 "ast-system-unpk.cc"
		    }
		}
#line 326 "ast-postprocess.k"


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  1618 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tCatchAll_1->prod_sel() == sel_CatchAll)) {
#line 130 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 130 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 130 "ast-to-cfg.k"
		const tCatchAll catchAll = this->tCatchAll_1;
#line 130 "ast-to-cfg.k"
		const activity b = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->activity_1;
#line 130 "ast-to-cfg.k"
		const integer c = phylum_cast<const impl_tCatchAll_CatchAll*>(this->tCatchAll_1)->integer_1;
#line 130 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 131 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined)\n");
		CFGBlock* firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock* lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1647 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 141 "ast-to-cfg.k"

		{
#line 142 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1655 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 142 "ast-to-cfg.k"
			    {
#line 143 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 143 "ast-to-cfg.k"
#line 142 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 143 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1678 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1683 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 142 "ast-to-cfg.k"

#line  1688 "ast-system-unpk.cc"
		    }
		}
#line 152 "ast-to-cfg.k"

#line  1693 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 154 "ast-to-cfg.k"

		CFGBlock * catchAllBlock = new CFGBlock(CFGCatchAll, catchAll->id, "CatchAll");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(firstBlock, catchAllBlock);
		connectBlocks(catchAllBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  1705 "ast-system-unpk.cc"
	    } else
		if ((this->tCatchAll_1->prod_sel() == sel_NoCatchAll)) {
#line 165 "ast-to-cfg.k"
		const tFaultHandlers This = this/**/;
#line 165 "ast-to-cfg.k"
		const tCatch_list a = this->tCatch_list_1;
#line 165 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 166 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] FaultHandler (user defined, no catchAll)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGFaultHandler, this->id, "FaultHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  1724 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 176 "ast-to-cfg.k"

		{
#line 177 "ast-to-cfg.k"
		    tCatch_list kc_fe_selvar_1 =  a;

#line  1732 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCatch_list
			) {
			tCatch kc_selvar_0_1 = kc_fe_selvar_1->tCatch_1;
			{
#line 177 "ast-to-cfg.k"
			    {
#line 178 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Catch)) {
#line 178 "ast-to-cfg.k"
#line 177 "ast-to-cfg.k"
				    const activity catchBlock = phylum_cast<const impl_tCatch_Catch*>(kc_selvar_0_1)->activity_1;
#line 178 "ast-to-cfg.k"

				    CFGBlock * catchIt = new CFGBlock(CFGCatch, kc_selvar_0_1->id, "Catch");
				    CFGBlock * innerFirst = globals::cfgMap.find(toString(catchBlock->id))->second->firstBlock;
				    CFGBlock * innerLast  = globals::cfgMap.find(toString(catchBlock->id))->second->lastBlock;

				    connectBlocks(firstBlock, catchIt);
				    connectBlocks(catchIt, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  1755 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  1760 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCatch_list_1;
#line 177 "ast-to-cfg.k"

#line  1765 "ast-system-unpk.cc"
		    }
		}
#line 187 "ast-to-cfg.k"

#line  1770 "ast-system-unpk.cc"
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 106 "ast-to-xml.k"
		const tCatch_list a = this->tCatch_list_1;
#line 106 "ast-to-xml.k"
		const tCatchAll b = this->tCatchAll_1;
#line 106 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 107 "ast-to-xml.k"
		inup(); 
#line  1786 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<faultHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 107 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  1792 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 107 "ast-to-xml.k"
		indown(); 
#line  1798 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</faultHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 185 "ast-to-petrinet.k"
		PFaultHandlers(this, kc_current_view_base); 
#line  1808 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  1813 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  1827 "ast-system-unpk.cc"
void
impl_tFaultHandlers_volatile_standardFaultHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1833 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  1853 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCatch_list iterator_ = this; iterator_->tCatch_list_1 != 0; iterator_ = iterator_->tCatch_list_1)
		    iterator_->tCatch_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCatch_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  1871 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  1883 "ast-system-unpk.cc"
void
impl_tCatch_Catch::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 153 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 153 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 155 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Catch\";" << endl;  

#line  1899 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 159 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  1905 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 334 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 334 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 336 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();


		if (globals::ASTEmap[globals::PPcurrentScope]->attributes["exitOnStandardFault"] == "yes")
		{
		    if ( myself->attributes["faultName"] == "ambiguousReceive" ||
			myself->attributes["faultName"] == "completionConditionFailure" ||
			myself->attributes["faultName"] == "conflictingReceive" ||
			myself->attributes["faultName"] == "conflictingRequest" ||
			myself->attributes["faultName"] == "correlationViolation" ||
			myself->attributes["faultName"] == "invalidBranchCondition" ||
			myself->attributes["faultName"] == "invalidExpressionValue" ||
			myself->attributes["faultName"] == "invalidVariables" ||
			myself->attributes["faultName"] == "joinFailurea" ||
			myself->attributes["faultName"] == "mismatchedAssignmentFailurei" ||
			myself->attributes["faultName"] == "missingReply" ||
			myself->attributes["faultName"] == "missingRequest" ||
			myself->attributes["faultName"] == "scopeInitializationFailure" ||
			myself->attributes["faultName"] == "selectionFailure" ||
			myself->attributes["faultName"] == "subLanguageExecutionFaultx" ||
			myself->attributes["faultName"] == "uninitializedPartnerRole" ||
			myself->attributes["faultName"] == "uninitializedVariablez" ||
			myself->attributes["faultName"] == "unsupportedReference" ||
			myself->attributes["faultName"] == "xsltInvalidSourcel" ||
			myself->attributes["faultName"] == "xsltStylesheetNotFound" )

		    SAerror( 3, myself->attributes["faultName"], myself->attributes["referenceLine"]);
		}


		if (myself->attributes["faultVariable"] != "")
		{
		    globals::ASTE_variableNames.insert(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"]);
		    if (myself->attributes["faultMessageType"] != "")
		    globals::ASTE_variableMap[(toString(globals::PPcurrentScope) + "." + myself->attributes["faultVariable"])] = myself->attributes["faultMessageType"];
		}

#line  1960 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 380 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  1980 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 110 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 110 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 111 "ast-to-xml.k"
		inup(); 
#line  1993 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catch id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 111 "ast-to-xml.k"
		listAttributes( _id ); 
#line  1999 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 111 "ast-to-xml.k"
		indown(); 
#line  2004 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catch>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2010 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2023 "ast-system-unpk.cc"
void
impl_tCatchAll_NoCatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2029 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  2041 "ast-system-unpk.cc"
void
impl_tCatchAll_CatchAll::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 165 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 165 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 167 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CatchAll\";" << endl;  

#line  2057 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 171 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2063 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 400 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 400 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 402 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  2082 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 410 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		globals::ASTEmap[a->id]->parentActivityId = myid; 


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00071( myid );

#line  2102 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 114 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 114 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 115 "ast-to-xml.k"
		inup(); 
#line  2115 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<catchAll id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 115 "ast-to-xml.k"
		listAttributes( _id ); 
#line  2121 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 115 "ast-to-xml.k"
		indown(); 
#line  2126 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</catchAll>\n"), kc_current_view); }
	    }
	    break;
	}

#line  2132 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2145 "ast-system-unpk.cc"
void
impl_tTerminationHandler_TerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 255 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 255 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 257 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2159 "ast-system-unpk.cc"
		{
		}
#line 259 "ast-to-visualization.k"
		else 
#line  2164 "ast-system-unpk.cc"
		{
#line 261 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"TerminationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2176 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 271 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2182 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 718 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 718 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 720 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = THCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2212 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 738 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00071( myid );


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2231 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 285 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 285 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 286 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] TerminationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGTerminationHandler, this->id, "TerminationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2252 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 296 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2262 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 165 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 165 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 166 "ast-to-xml.k"
		inup(); 
#line  2275 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<terminationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 166 "ast-to-xml.k"
		indown(); 
#line  2282 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</terminationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 189 "ast-to-petrinet.k"
		PTerminationHandler(this, kc_current_view_base); 
#line  2292 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2297 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2310 "ast-system-unpk.cc"
void
impl_tTerminationHandler_volatile_standardTerminationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2316 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2329 "ast-system-unpk.cc"
void
impl_tCompensationHandler_CompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 227 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 227 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 229 "ast-to-visualization.k"
		if (! (globals::ASTEmap[_id->value]->isUserDefined) && globals::hideStandardHandlers) 
#line  2343 "ast-system-unpk.cc"
		{
		}
#line 231 "ast-to-visualization.k"
		else 
#line  2348 "ast-system-unpk.cc"
		{
#line 233 "ast-to-visualization.k"

		    (*output) << "subgraph cluster" << toString(_id->value) << " { label = \"CompensationHandler\";" << endl;  
		    if ( !globals::ASTEmap[_id->value]->callable )
		    {
			(*output) << "\tcolor = grey70;" << endl;
			(*output) << "\tfillcolor = grey80;" << endl;
			(*output) << "\tfontcolor = grey60;" << endl;
		    }

#line  2360 "ast-system-unpk.cc"
		    kc::unparse(a, kc_printer, kc_current_view);
#line 243 "ast-to-visualization.k"

		    (*output) << "}" << endl;    

#line  2366 "ast-system-unpk.cc"
		}
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 643 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 643 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 645 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;
		globals::ASTEmap[a->id]->controlFlow = CHCF;
		globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;

#line  2396 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 663 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );      

		check_SA00070( myid );










		vector<unsigned int> ancestors = myself->ancestorActivities();
		if (myself->isUserDefined && ancestors.size() > 1)
		{
		    unsigned int i = 1;
		    while(i < ancestors.size())
		    {
			string ancestor = globals::ASTEmap[ancestors[i]]->activityTypeName();
			if (ancestor == "catch" ||
			    ancestor == "catchAll" ||
			    ancestor == "terminationHandler" ||
			    ancestor == "compensationHandler")
			{
			    SAerror(79, ancestor);
			    break;
			}
			i++;
		    }
		}


		if (! myself->isUserDefined)
		globals::process_information.implicit_handlers++;

#line  2446 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 258 "ast-to-cfg.k"
		const activity a = this->activity_1;
#line 258 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 259 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensationHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_begin"); 
		CFGBlock * lastBlock  = new CFGBlock(CFGCompensationHandler, this->id, "CompensationHandler_end"); 
		globals::cfgMap[toString(this->id)] = firstBlock;

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

#line  2467 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 269 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(a->id))->second->firstBlock;
		CFGBlock * innerLast  = globals::cfgMap.find(toString(a->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  2477 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 156 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 156 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 157 "ast-to-xml.k"
		inup(); 
#line  2490 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensationHandler id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" callable=\""), kc_current_view); }
#line 157 "ast-to-xml.k"
		*output << globals::ASTEmap[ _id->value ]->callable; 
#line  2496 "ast-system-unpk.cc"
			{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 157 "ast-to-xml.k"
		indown(); 
#line  2501 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensationHandler>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 193 "ast-to-petrinet.k"
		PCompensationHandler(this, kc_current_view_base); 
#line  2511 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2516 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2529 "ast-system-unpk.cc"
void
impl_tCompensationHandler_volatile_standardCompensationHandler::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2535 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2548 "ast-system-unpk.cc"
void
impl_tEventHandlers_EventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 186 "ast-to-visualization.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 186 "ast-to-visualization.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 186 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 188 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"EventHandlers\";" << endl;  

#line  2566 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 192 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  2573 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 452 "ast-postprocess.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 452 "ast-postprocess.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 452 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 454 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;



		if (a->length() == 0 && b->length() == 0)
		SAerror(83, "", toInt(globals::ASTEmap[myself->parentScopeId]->attributes["referenceLine"]));


		{
#line 470 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2607 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 470 "ast-postprocess.k"
			    {
#line 471 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 471 "ast-postprocess.k"
#line 470 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 470 "ast-postprocess.k"
				    const tCorrelation_list _cor = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 470 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 470 "ast-postprocess.k"
				    const activity _act = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 470 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 471 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;


#line  2637 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2642 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 470 "ast-postprocess.k"

#line  2647 "ast-system-unpk.cc"
		    }
		}
#line 479 "ast-postprocess.k"
		{
#line 479 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2655 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 479 "ast-postprocess.k"
			    {
#line 480 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 480 "ast-postprocess.k"
#line 479 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 479 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 479 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 480 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  2680 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2685 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 479 "ast-postprocess.k"

#line  2690 "ast-system-unpk.cc"
		    }
		}
#line 487 "ast-postprocess.k"

#line  2695 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 489 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  2706 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 195 "ast-to-cfg.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 195 "ast-to-cfg.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 195 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 196 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (user defined)\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "EventHandler_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "EventHandler_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;









		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  2738 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 216 "ast-to-cfg.k"

		int i = 1;
		{
#line 218 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  a;

#line  2748 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 218 "ast-to-cfg.k"
			    {
#line 219 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 219 "ast-to-cfg.k"
#line 218 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 218 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 219 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2774 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2779 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 218 "ast-to-cfg.k"

#line  2784 "ast-system-unpk.cc"
		    }
		}
#line 229 "ast-to-cfg.k"
		i = 1; 
		{
#line 230 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  b;

#line  2793 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 230 "ast-to-cfg.k"
			    {
#line 231 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 231 "ast-to-cfg.k"
#line 230 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 230 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 231 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  2818 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  2823 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 230 "ast-to-cfg.k"

#line  2828 "ast-system-unpk.cc"
		    }
		}
#line 239 "ast-to-cfg.k"


#line  2834 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 127 "ast-to-xml.k"
		const tOnMessage_list a = this->tOnMessage_list_1;
#line 127 "ast-to-xml.k"
		const tOnAlarm_list b = this->tOnAlarm_list_1;
#line 127 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 128 "ast-to-xml.k"
		inup(); 
#line  2849 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<eventHandlers id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 128 "ast-to-xml.k"
		indown(); 
#line  2857 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</eventHandlers>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 197 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2867 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 197 "ast-to-petrinet.k"
		PEventHandlers(this, kc_current_view_base); 
#line  2876 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  2881 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  2894 "ast-system-unpk.cc"
void
impl_tEventHandlers_emptyEventHandlers::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 182 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 435 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 437 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  2925 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 244 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 245 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] EventHandler (implicit)\n");
		CFGBlock * block = new CFGBlock(CFGEventHandler, this->id, "implicitEventHandler"); 
		globals::cfgMap[toString(this->id)] = block;
		trace(TRACE_DEBUG, "[CFG] ~EventHandler (implicit)\n");

#line  2941 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 123 "ast-to-xml.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  2954 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  2974 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnMessage_list iterator_ = this; iterator_->tOnMessage_list_1 != 0; iterator_ = iterator_->tOnMessage_list_1)
		    iterator_->tOnMessage_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnMessage_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  2992 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3004 "ast-system-unpk.cc"
void
impl_tOnMessage_OnMessage::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 198 "ast-to-visualization.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 198 "ast-to-visualization.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 198 "ast-to-visualization.k"
		const activity c = this->activity_1;
#line 198 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 200 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnMessage\";" << endl;  

#line  3024 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 204 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3032 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 499 "ast-postprocess.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 499 "ast-postprocess.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 499 "ast-postprocess.k"
		const activity c = this->activity_1;
#line 499 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 501 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		myself->checkAttributes();

		myself->checkPartnerLink();

		myself->checkMessageExchange();

		globals::ASTE_IMAs.insert(myid);

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (b->length() != 0 && myself->attributes["variable"] != "")
		SAerror(63, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <onMessage>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->channelName = myself->createChannel();



		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if(globals::ASTEmap[myself->parentActivityId]->activityTypeName() == "eventHandlers")
		{
		    if(max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    {
			myself->max_occurrences = max_loops * myself-> max_occurrences;
		    } 
		    else
		    {
			myself->max_occurrences = UINT_MAX;
		    }
		}

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;





		{
#line 571 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  a;

#line  3122 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 571 "ast-postprocess.k"
			    {
#line 572 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 572 "ast-postprocess.k"
#line 571 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 571 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 572 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  3143 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  3148 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 571 "ast-postprocess.k"

#line  3153 "ast-system-unpk.cc"
		    }
		}
#line 577 "ast-postprocess.k"

#line  3158 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 579 "ast-postprocess.k"


		assert(globals::ASTEmap[c->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3173 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 131 "ast-to-xml.k"
		const tCorrelation_list a = this->tCorrelation_list_1;
#line 131 "ast-to-xml.k"
		const tFromPart_list b = this->tFromPart_list_1;
#line 131 "ast-to-xml.k"
		const activity c = this->activity_1;
#line 131 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 132 "ast-to-xml.k"
		inup(); 
#line  3190 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onMessage id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 132 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3196 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 134 "ast-to-xml.k"
		if (a->length() == 0) 
#line  3200 "ast-system-unpk.cc"
		{
		}
#line 136 "ast-to-xml.k"
		else 
#line  3205 "ast-system-unpk.cc"
		{
#line 137 "ast-to-xml.k"
		    inup(); 
#line  3209 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<correlations>\n"), kc_current_view); }
		    kc::unparse(a, kc_printer, kc_current_view);
#line 137 "ast-to-xml.k"
		    indown(); 
#line  3214 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</correlations>\n"), kc_current_view); }
		}
#line 139 "ast-to-xml.k"
		if (b->length() == 0) 
#line  3219 "ast-system-unpk.cc"
		{
		}
#line 141 "ast-to-xml.k"
		else 
#line  3224 "ast-system-unpk.cc"
		{
#line 142 "ast-to-xml.k"
		    inup(); 
#line  3228 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<fromParts>\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 142 "ast-to-xml.k"
		    indown(); 
#line  3233 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</fromParts>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
#line 144 "ast-to-xml.k"
		indown(); 
#line  3239 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onMessage>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3245 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3265 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tOnAlarm_list iterator_ = this; iterator_->tOnAlarm_list_1 != 0; iterator_ = iterator_->tOnAlarm_list_1)
		    iterator_->tOnAlarm_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tOnAlarm_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3283 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3295 "ast-system-unpk.cc"
void
impl_tOnAlarm_OnAlarm::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 210 "ast-to-visualization.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 210 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 210 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 212 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"OnAlarm\";" << endl;  

#line  3313 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 216 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  3319 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 592 "ast-postprocess.k"
		const tRepeatEvery b = this->tRepeatEvery_1;
#line 592 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 592 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 594 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		myself->parentScopeId = globals::PPcurrentScope;
		assert(globals::ASTEmap[myself->parentActivityId] != NULL);

		if(string(b->op_name())=="RepeatEvery")
		{
		    myself->cyclic=true;
		    globals::ASTEmap[a->id]->max_occurrences = UINT_MAX;
		} 
		else
		{

		    unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		    if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences * max_loops;
		    else
		    globals::ASTEmap[a->id]->max_occurrences = myself->max_occurrences;
		}


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[a->id]->parentActivityId = myid;

#line  3363 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 625 "ast-postprocess.k"


		assert(globals::ASTEmap[a->id] != NULL);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedSourceLinks, globals::ASTEmap[a->id]->enclosedSourceLinks);
		globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks = setUnion(globals::ASTEmap[ myself->parentActivityId ]->enclosedTargetLinks, globals::ASTEmap[a->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  3376 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 147 "ast-to-xml.k"
		const tRepeatEvery a = this->tRepeatEvery_1;
#line 147 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 147 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 148 "ast-to-xml.k"
		inup(); 
#line  3391 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<onAlarm"), kc_current_view); }
#line 148 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3395 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 148 "ast-to-xml.k"
		indown(); 
#line  3400 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</onAlarm>\n"), kc_current_view); }
	    }
	    break;
	}

#line  3406 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3419 "ast-system-unpk.cc"
void
impl_tRepeatEvery_RepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3425 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  3438 "ast-system-unpk.cc"
void
impl_tRepeatEvery_emptyRepeatEvery::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3444 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3464 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tVariable_list iterator_ = this; iterator_->tVariable_list_1 != 0; iterator_ = iterator_->tVariable_list_1)
		    iterator_->tVariable_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tVariable_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3482 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3494 "ast-system-unpk.cc"
void
impl_tVariable_Variable::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 283 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 765 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 767 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineVariable();

#line  3523 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 174 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 175 "ast-to-xml.k"
		in(); 
#line  3534 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<variable id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 175 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3540 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3546 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3566 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tMessageExchange_list iterator_ = this; iterator_->tMessageExchange_list_1 != 0; iterator_ = iterator_->tMessageExchange_list_1)
		    iterator_->tMessageExchange_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tMessageExchange_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3584 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3596 "ast-system-unpk.cc"
void
impl_tMessageExchange_MessageExchange::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 785 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 787 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineMessageExchange();

#line  3617 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  3622 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3642 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelationSet_list iterator_ = this; iterator_->tCorrelationSet_list_1 != 0; iterator_ = iterator_->tCorrelationSet_list_1)
		    iterator_->tCorrelationSet_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelationSet_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3660 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3672 "ast-system-unpk.cc"
void
impl_tCorrelationSet_CorrelationSet::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 292 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 805 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 807 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->defineCorrelationSet();

#line  3701 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 183 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 184 "ast-to-xml.k"
		in(); 
#line  3712 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlationSet"), kc_current_view); }
#line 184 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3716 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3722 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3742 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCorrelation_list iterator_ = this; iterator_->tCorrelation_list_1 != 0; iterator_ = iterator_->tCorrelation_list_1)
		    iterator_->tCorrelation_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCorrelation_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3760 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3772 "ast-system-unpk.cc"
void
impl_tCorrelation_Correlation::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 301 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 825 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 827 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		string correlationSetName = myself->checkCorrelationSet();


		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		if (globals::ASTEmap[myself->parentActivityId]->isStartActivity &&
		    myself->attributes["initiate"] == "join")
		{
		    globals::ASTEmap[myself->parentActivityId]->sharedCorrelationSets.insert(correlationSetName);
		}

#line  3809 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 192 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 193 "ast-to-xml.k"
		in(); 
#line  3820 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<correlation"), kc_current_view); }
#line 193 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3824 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3830 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3850 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tToPart_list iterator_ = this; iterator_->tToPart_list_1 != 0; iterator_ = iterator_->tToPart_list_1)
		    iterator_->tToPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tToPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3868 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3880 "ast-system-unpk.cc"
void
impl_tToPart_ToPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 309 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 853 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 855 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  3907 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 200 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 201 "ast-to-xml.k"
		in(); 
#line  3918 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<toPart"), kc_current_view); }
#line 201 "ast-to-xml.k"
		listAttributes( _id ); 
#line  3922 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  3928 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  3948 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tFromPart_list iterator_ = this; iterator_->tFromPart_list_1 != 0; iterator_ = iterator_->tFromPart_list_1)
		    iterator_->tFromPart_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tFromPart_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  3966 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  3978 "ast-system-unpk.cc"
void
impl_tFromPart_FromPart::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 313 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 866 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 868 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->checkAttributes();

#line  4005 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 204 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 205 "ast-to-xml.k"
		in(); 
#line  4016 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<fromPart"), kc_current_view); }
#line 205 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4020 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  4026 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4039 "ast-system-unpk.cc"
void
impl_tReceive_Receive::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 322 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 322 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 322 "ast-to-visualization.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 322 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 324 "ast-to-visualization.k"

		(*output) << "receive" << toString(_id->value) << " [shape=rectangle style=filled label=\"receive\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "receive" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "receive" + toString(_id->value);

#line  4064 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1003 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1003 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1003 "ast-postprocess.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 1003 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1005 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();
		globals::ASTE_IMAs.insert(myid);




		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(55, "", myself->attributes["referenceLine"]);


		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <receive>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1051 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4130 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1051 "ast-postprocess.k"
			    {
#line 1052 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1052 "ast-postprocess.k"
#line 1051 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1051 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1052 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4151 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4156 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1051 "ast-postprocess.k"

#line  4161 "ast-system-unpk.cc"
		    }
		}
#line 1057 "ast-postprocess.k"

#line  4166 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1059 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<receive>", myself->attributes["referenceLine"]);
		}

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4182 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 403 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 403 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 403 "ast-to-cfg.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 403 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 404 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Receive\n");
		CFGBlock * block = new CFGBlock(CFGReceive, this->id, "Receive"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4207 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 213 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 213 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 213 "ast-to-xml.k"
		const tFromPart_list c = this->tFromPart_list_1;
#line 213 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 214 "ast-to-xml.k"
		inup(); 
#line  4225 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<receive id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 214 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4231 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 214 "ast-to-xml.k"
		indown(); 
#line  4238 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</receive>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 76 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4248 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 76 "ast-to-petrinet.k"
		PReceive(this, kc_current_view_base); 
#line  4257 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4262 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4275 "ast-system-unpk.cc"
void
impl_tReply_Reply::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 340 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 340 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 340 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 340 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 342 "ast-to-visualization.k"

		(*output) << "reply" << toString(_id->value) << " [shape=rectangle style=filled label=\"reply\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "reply" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "reply" + toString(_id->value);

#line  4300 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1079 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1079 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 1079 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 1079 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1081 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		myself->checkMessageExchange();




		if (globals::wsdl_filename != "")
		{
		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["myRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <reply>"), myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}


		if (c->length() != 0 && myself->attributes["variable"] != "")
		SAerror(59, "", myself->attributes["referenceLine"]);

		myself->channelName = myself->createChannel();
		myself->variableName = myself->checkVariable("variable");

		{
#line 1125 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4364 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 1125 "ast-postprocess.k"
			    {
#line 1126 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 1126 "ast-postprocess.k"
#line 1125 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 1125 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 1126 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4385 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4390 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 1125 "ast-postprocess.k"

#line  4395 "ast-system-unpk.cc"
		    }
		}
#line 1131 "ast-postprocess.k"

#line  4400 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1133 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4407 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 422 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 422 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 422 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 422 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 423 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Reply\n");
		CFGBlock * block = new CFGBlock(CFGReply, this->id, "Reply"); 


		block->channel_name = globals::ASTEmap[d->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4432 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 222 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 222 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 222 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 222 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 223 "ast-to-xml.k"
		inup(); 
#line  4450 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<reply id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 223 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4456 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 223 "ast-to-xml.k"
		indown(); 
#line  4463 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</reply>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 80 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4473 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 80 "ast-to-petrinet.k"
		PReply(this, kc_current_view_base); 
#line  4482 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4487 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4500 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_annotatedInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  4506 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4519 "ast-system-unpk.cc"
void
impl_tInvoke_AsynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 371 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 371 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 371 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 371 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 371 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 373 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4546 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 384 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 384 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 384 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 384 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 384 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 385 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4573 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 235 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 235 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 235 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 235 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 235 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 236 "ast-to-xml.k"
		inup(); 
#line  4593 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 236 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4599 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 236 "ast-to-xml.k"
		indown(); 
#line  4607 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 68 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4617 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 68 "ast-to-petrinet.k"
		PAsynchronousInvoke(this, kc_current_view_base); 
#line  4626 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4631 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4644 "ast-system-unpk.cc"
void
impl_tInvoke_SynchronousInvoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 358 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 358 "ast-to-visualization.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 358 "ast-to-visualization.k"
		const tToPart_list c = this->tToPart_list_1;
#line 358 "ast-to-visualization.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 358 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 360 "ast-to-visualization.k"

		(*output) << "invoke" << toString(_id->value) << " [shape=rectangle style=filled label=\"invoke\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "invoke" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "invoke" + toString(_id->value);

#line  4671 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 371 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 371 "ast-to-cfg.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 371 "ast-to-cfg.k"
		const tToPart_list c = this->tToPart_list_1;
#line 371 "ast-to-cfg.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 371 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 372 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Invoke\n");
		CFGBlock * block = new CFGBlock(CFGInvoke, this->id, "Invoke");


		block->channel_name = globals::ASTEmap[e->value]->channelName;

		globals::cfgMap[toString(this->id)] = block; 

#line  4698 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 231 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 231 "ast-to-xml.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 231 "ast-to-xml.k"
		const tToPart_list c = this->tToPart_list_1;
#line 231 "ast-to-xml.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 231 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 232 "ast-to-xml.k"
		inup(); 
#line  4718 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<invoke id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 232 "ast-to-xml.k"
		listAttributes( _id ); 
#line  4724 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 232 "ast-to-xml.k"
		indown(); 
#line  4732 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</invoke>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 72 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4742 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 72 "ast-to-petrinet.k"
		PSynchronousInvoke(this, kc_current_view_base); 
#line  4751 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4756 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4769 "ast-system-unpk.cc"
void
impl_tInvoke_volatile_Invoke::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 934 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 934 "ast-postprocess.k"
		const tCorrelation_list b = this->tCorrelation_list_1;
#line 934 "ast-postprocess.k"
		const tToPart_list c = this->tToPart_list_1;
#line 934 "ast-postprocess.k"
		const tFromPart_list d = this->tFromPart_list_1;
#line 934 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 936 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		if (c->length() != 0 && myself->attributes["inputVariable"] != "")
		SAerror(51, "", myself->attributes["referenceLine"]);


		if (d->length() != 0 && myself->attributes["outputVariable"] != "")
		SAerror(52, "", myself->attributes["referenceLine"]);

		if (globals::wsdl_filename != "")
		{

		    if (myself->attributes["portType"] != "")
		    if (!( globals::WSDLInfo.checkPortType( myself->attributes["partnerLink"],
				globals::ASTEmap[globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ]]->attributes["partnerRole"],
				myself->attributes["portType"]) ) )
		    SAerror(5, ("portType `" + myself->attributes["portType"] +"' referenced in <invoke>"),myself->attributes["referenceLine"]);

		    globals::WSDLInfo.checkVariable(myself);
		}

		myself->checkPartnerLink();

		if ( globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] != 0 )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( globals::ASTEmap[ globals::ASTE_partnerLinks[ myself->attributes["partnerLink"] ] ]->partnerLinkType );
		}
		if ( globals::parameters[P_STANDARDFAULTS] )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( ";" );
		}

		myself->channelName = myself->createChannel((myself->attributes["outputVariable"] != ""));
		myself->inputVariableName = myself->checkVariable("inputVariable");
		myself->outputVariableName = myself->checkVariable("outputVariable");

		{
#line 984 "ast-postprocess.k"
		    tCorrelation_list kc_fe_selvar_1 =  b;

#line  4840 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCorrelation_list
			) {
			tCorrelation kc_selvar_0_1 = kc_fe_selvar_1->tCorrelation_1;
			{
#line 984 "ast-postprocess.k"
			    {
#line 985 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Correlation)) {
#line 985 "ast-postprocess.k"
#line 984 "ast-postprocess.k"
				    const tCorrelation correlation = kc_selvar_0_1;
#line 984 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tCorrelation_Correlation*>(kc_selvar_0_1)->integer_1;
#line 985 "ast-postprocess.k"

				    assert(_id2 != NULL);
				    assert(globals::ASTEmap[_id2->value] != NULL);
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;

#line  4861 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  4866 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCorrelation_list_1;
#line 984 "ast-postprocess.k"

#line  4871 "ast-system-unpk.cc"
		    }
		}
#line 990 "ast-postprocess.k"

#line  4876 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 992 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4883 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  4888 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  4901 "ast-system-unpk.cc"
void
impl_tAssign_Assign::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 389 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 389 "ast-to-visualization.k"
		const tCopy_list b = this->tCopy_list_1;
#line 389 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 391 "ast-to-visualization.k"

		(*output) << "assign" << toString(_id->value) << " [shape=rectangle style=filled label=\"assign\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "assign" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "assign" + toString(_id->value);

#line  4924 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1144 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1144 "ast-postprocess.k"
		const tCopy_list b = this->tCopy_list_1;
#line 1144 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1146 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  4949 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1158 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  4956 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 441 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 441 "ast-to-cfg.k"
		const tCopy_list b = this->tCopy_list_1;
#line 441 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 442 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Assign\n");
		CFGBlock * firstBlock = new CFGBlock(CFGAssign, this->id, "Assign_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGAssign, this->id, "Assign_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 454 "ast-to-cfg.k"
		    tCopy_list kc_fe_selvar_1 =  b;

#line  4986 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstCopy_list
			) {
			tCopy kc_selvar_0_1 = kc_fe_selvar_1->tCopy_1;
			{
#line 454 "ast-to-cfg.k"
			    {
#line 455 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_Copy)) {
#line 455 "ast-to-cfg.k"
#line 454 "ast-to-cfg.k"
				    const tFrom from = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tFrom_1;
#line 454 "ast-to-cfg.k"
				    const tTo to = phylum_cast<const impl_tCopy_Copy*>(kc_selvar_0_1)->tTo_1;
#line 455 "ast-to-cfg.k"




				    CFGBlock * fromBlock = new CFGBlock(CFGFrom, from->id, "From_" + toString(i));
				    CFGBlock * toBlock   = new CFGBlock(CFGTo,   to->id, "To_" + toString(i++));
				    connectBlocks(last,fromBlock);
				    connectBlocks(fromBlock, toBlock);
				    last = toBlock;

#line  5012 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  5017 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tCopy_list_1;
#line 454 "ast-to-cfg.k"

#line  5022 "ast-system-unpk.cc"
		    }
		}
#line 464 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  5029 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 244 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 244 "ast-to-xml.k"
		const tCopy_list b = this->tCopy_list_1;
#line 244 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 245 "ast-to-xml.k"
		inup(); 
#line  5045 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<assign id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 245 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5051 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 245 "ast-to-xml.k"
		indown(); 
#line  5057 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</assign>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 84 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5067 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 84 "ast-to-petrinet.k"
		PAssign(this, kc_current_view_base); 
#line  5076 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5081 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  5101 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tCopy_list iterator_ = this; iterator_->tCopy_list_1 != 0; iterator_ = iterator_->tCopy_list_1)
		    iterator_->tCopy_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tCopy_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  5119 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  5131 "ast-system-unpk.cc"
void
impl_tCopy_Copy::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 402 "ast-to-visualization.k"
		const tFrom a = this->tFrom_1;
#line 402 "ast-to-visualization.k"
		const tTo b = this->tTo_1;
#line 402 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1164 "ast-postprocess.k"
		const tFrom a = this->tFrom_1;
#line 1164 "ast-postprocess.k"
		const tTo b = this->tTo_1;
#line 1164 "ast-postprocess.k"
		const integer c = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 248 "ast-to-xml.k"
		const tFrom a = this->tFrom_1;
#line 248 "ast-to-xml.k"
		const tTo b = this->tTo_1;
#line 248 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 249 "ast-to-xml.k"
		inup(); 
#line  5175 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<copy id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 249 "ast-to-xml.k"
		indown(); 
#line  5183 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</copy>\n"), kc_current_view); }
	    }
	    break;
	}

#line  5189 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5202 "ast-system-unpk.cc"
void
impl_tFrom_From::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 406 "ast-to-visualization.k"
		const integer a = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1168 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1170 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		if (myself->attributes["has_literal"] == "")
		{
		    if(myself->attributes["has_expression"] == "")
		    {
			if (myself->attributes["variable"] == "")
			{
			    if (myself->attributes["endpointReference"] == "")
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			    else
			    {
				if (! (myself->attributes["property"] == "" && myself->attributes["partnerLink"] != ""
					&& myself->attributes["expressionLanguage"] == "" && myself->attributes["has_query"] == ""
					&& myself->attributes["part"] == ""))
				SAerror(32, "from", myself->attributes["referenceLine"]);
			    }
			}
			else
			{
			    if (! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] != "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				    && myself->attributes["has_query"] == "" && myself->attributes["part"] == "")
				&&
				! (myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				    && myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == "")
			    )
			    SAerror(32, "from", myself->attributes["referenceLine"]);           
			}
		    }
		    else
		    {
			if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
				&& myself->attributes["endpointReference"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == ""&& myself->attributes["part"] == ""))
			SAerror(32, "from", myself->attributes["referenceLine"]);
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["has_expression"] == ""
			    && myself->attributes["variable"] == "" && myself->attributes["endpointReference"] == ""
			    && myself->attributes["property"] == "" && myself->attributes["partnerLink"] == ""
			    && myself->attributes["expressionLanguage"] == "" && myself->attributes["part"] == ""))
		    SAerror(32, "from", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["endpointReference"] == "myRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["myRole"] == "")
		SAerror(35, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);


		if (myself->attributes["endpointReference"] == "partnerRole")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(36, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5295 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 252 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 253 "ast-to-xml.k"
		in(); 
#line  5306 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<from />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5312 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5325 "ast-system-unpk.cc"
void
impl_tTo_To::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 410 "ast-to-visualization.k"
		const integer b = this->integer_1;
		kc::unparse(b, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1246 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1248 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		if(myself->attributes["has_expression"] == "")
		{
		    if (myself->attributes["variable"] == "")
		    {
			if (! (myself->attributes["property"] == "" && myself->attributes["expressionLanguage"] == "" 
				&& myself->attributes["has_query"] == "" && myself->attributes["part"] == ""))
			SAerror(32, "to", myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (! (myself->attributes["property"] != "" && myself->attributes["part"] == ""
				&& myself->attributes["partnerLink"] == "" && myself->attributes["expressionLanguage"] == ""
				&& myself->attributes["has_query"] == "")
			    &&
			    ! (myself->attributes["expressionLanguage"] == "" && myself->attributes["property"] == "" 
				&& myself->attributes["partnerLink"] == "")
			)
			SAerror(32, "to", myself->attributes["referenceLine"]);           
		    }
		}
		else
		{
		    if (! (myself->attributes["has_query"] == "" && myself->attributes["variable"] == "" 
			    && myself->attributes["part"] == "" && myself->attributes["property"] == "" 
			    && myself->attributes["partnerLink"] == ""))
		    SAerror(32, "to", myself->attributes["referenceLine"]);
		}


		if (myself->attributes["partnerLink"] != "")
		if(globals::ASTEmap[globals::ASTE_partnerLinks[myself->attributes["partnerLink"]]]->attributes["partnerRole"] == "")
		SAerror(37, myself->attributes["partnerLink"], myself->attributes["referenceLine"]);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->checkPartnerLink();
		myself->variableName = myself->checkVariable("variable");

#line  5390 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 256 "ast-to-xml.k"
		const integer b = this->integer_1;
#line 257 "ast-to-xml.k"
		in(); 
#line  5401 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<to />\n"), kc_current_view); }
	    }
	    break;
	}

#line  5407 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5420 "ast-system-unpk.cc"
void
impl_tValidate_Validate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 419 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 419 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 421 "ast-to-visualization.k"

		(*output) << "validate" << toString(_id->value) << " [shape=rectangle style=filled label=\"validate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "validate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "validate" + toString(_id->value);

#line  5441 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1301 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1301 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1303 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5464 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1315 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5470 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 327 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 327 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 328 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Validate\n");
		CFGBlock * block = new CFGBlock(CFGValidate, this->id, "Validate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5488 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 265 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 265 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 266 "ast-to-xml.k"
		inup(); 
#line  5502 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<validate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 266 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5508 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 266 "ast-to-xml.k"
		indown(); 
#line  5513 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</validate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5523 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 88 "ast-to-petrinet.k"
		PValidate(this, kc_current_view_base); 
#line  5532 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5537 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5550 "ast-system-unpk.cc"
void
impl_tEmpty_Empty::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 436 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 436 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 438 "ast-to-visualization.k"

		(*output) << "empty" << toString(_id->value) << " [shape=rectangle style=filled label=\"empty\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "empty" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "empty" + toString(_id->value);

#line  5571 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 884 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 884 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 886 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5594 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 898 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5600 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 341 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 341 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 342 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Empty\n");
		CFGBlock * block = new CFGBlock(CFGEmpty, this->id, "Empty"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5618 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 273 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 273 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 274 "ast-to-xml.k"
		inup(); 
#line  5632 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<empty id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 274 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5638 "ast-system-unpk.cc"
#line 275 "ast-to-xml.k"

		{
#line 276 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 278 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 278 "ast-to-xml.k"
#line 278 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 278 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5651 "ast-system-unpk.cc"
				} else
		    {
#line 279 "ast-to-xml.k"
#line 279 "ast-to-xml.k"
			*output << ">\n"; 
#line  5657 "ast-system-unpk.cc"
		    }
		}
#line 281 "ast-to-xml.k"

#line  5662 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 283 "ast-to-xml.k"

		{
#line 284 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 286 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 286 "ast-to-xml.k"
#line 286 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 286 "ast-to-xml.k"

#line  5676 "ast-system-unpk.cc"
		    } else
		    {
#line 287 "ast-to-xml.k"
#line 287 "ast-to-xml.k"
			indown(); *output << "</empty>\n"; 
#line  5682 "ast-system-unpk.cc"
		    }
		}
#line 289 "ast-to-xml.k"

#line  5687 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5696 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 60 "ast-to-petrinet.k"
		PEmpty(this, kc_current_view_base); 
#line  5705 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5710 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5723 "ast-system-unpk.cc"
void
impl_tOpaqueActivity_OpaqueActivity::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 909 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 909 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 911 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5747 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 923 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5753 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 356 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 356 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 357 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] OpaqueActivity\n");
		CFGBlock * block = new CFGBlock(CFGOpaqueActivity, this->id, "OpaqueActivity"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5771 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 298 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 298 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 299 "ast-to-xml.k"
		inup(); 
#line  5785 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<opaqueActivity id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 299 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5791 "ast-system-unpk.cc"
#line 300 "ast-to-xml.k"

		{
#line 301 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 303 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 303 "ast-to-xml.k"
#line 303 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 303 "ast-to-xml.k"
			*output << " />";  indown(); *output << endl; 
#line  5804 "ast-system-unpk.cc"
				} else
		    {
#line 304 "ast-to-xml.k"
#line 304 "ast-to-xml.k"
			*output << ">\n"; 
#line  5810 "ast-system-unpk.cc"
		    }
		}
#line 306 "ast-to-xml.k"

#line  5815 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 308 "ast-to-xml.k"

		{
#line 309 "ast-to-xml.k"
		    standardElements kc_selvar_0_1 = phylum_cast<standardElements>(a);
#line 311 "ast-to-xml.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_StandardElements) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->tSource_list_1->prod_sel() == sel_NiltSource_list) && (phylum_cast<const impl_standardElements_StandardElements*>(kc_selvar_0_1)->joinCondition_1->prod_sel() == sel_standardJoinCondition)) {
#line 311 "ast-to-xml.k"
#line 311 "ast-to-xml.k"
			const standardElements a = kc_selvar_0_1;
#line 311 "ast-to-xml.k"

#line  5829 "ast-system-unpk.cc"
		    } else
		    {
#line 312 "ast-to-xml.k"
#line 312 "ast-to-xml.k"
			indown(); *output << "</opaqueActivity>\n"; 
#line  5835 "ast-system-unpk.cc"
		    }
		}
#line 314 "ast-to-xml.k"

#line  5840 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 64 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5849 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 64 "ast-to-petrinet.k"
		POpaqueActivity(this, kc_current_view_base); 
#line  5858 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5863 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  5876 "ast-system-unpk.cc"
void
impl_tWait_Wait::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 454 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 454 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 456 "ast-to-visualization.k"

		(*output) << "wait" << toString(_id->value) << " [shape=rectangle style=filled label=\"wait\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "wait" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "wait" + toString(_id->value);

#line  5897 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1326 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1326 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1328 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  5920 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1340 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  5926 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 477 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 477 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 478 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Wait\n");
		CFGBlock * block = new CFGBlock(CFGWait, this->id, "Wait"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  5944 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 323 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 323 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 324 "ast-to-xml.k"
		inup(); 
#line  5958 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<wait id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 324 "ast-to-xml.k"
		listAttributes( _id ); 
#line  5964 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 324 "ast-to-xml.k"
		indown(); 
#line  5969 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</wait>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 92 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  5979 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 92 "ast-to-petrinet.k"
		PWait(this, kc_current_view_base); 
#line  5988 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  5993 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6006 "ast-system-unpk.cc"
void
impl_tExit_Exit::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 472 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 472 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 474 "ast-to-visualization.k"

		(*output) << "exit" << toString(_id->value) << " [shape=rectangle style=filled label=\"exit\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "exit" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "exit" + toString(_id->value);

#line  6027 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1549 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1549 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1551 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  6050 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1563 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6061 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 555 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 555 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 556 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Exit\n");
		CFGBlock * block = new CFGBlock(CFGExit, this->id, "Exit"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6079 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 332 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 332 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 333 "ast-to-xml.k"
		inup(); 
#line  6093 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<exit id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 333 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6099 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 333 "ast-to-xml.k"
		indown(); 
#line  6104 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</exit>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 104 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6114 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 104 "ast-to-petrinet.k"
		PExit(this, kc_current_view_base); 
#line  6123 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6128 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6141 "ast-system-unpk.cc"
void
impl_tThrow_Throw::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 490 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 490 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 492 "ast-to-visualization.k"

		(*output) << "throw" << toString(_id->value) << " [shape=rectangle style=filled label=\"throw\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "throw" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "throw" + toString(_id->value);

#line  6162 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1351 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1351 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1353 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();
		globals::ASTEmap[ myself->parentScopeId ]->enterFault( myself->attributes[ "faultName" ] );

#line  6186 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1366 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6197 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 493 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 493 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 494 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Throw\n");
		CFGBlock * block = new CFGBlock(CFGThrow, this->id, "Throw"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6215 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 341 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 341 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 342 "ast-to-xml.k"
		inup(); 
#line  6229 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<throw id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 342 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6235 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 342 "ast-to-xml.k"
		indown(); 
#line  6240 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</throw>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 96 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6250 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 96 "ast-to-petrinet.k"
		PThrow(this, kc_current_view_base); 
#line  6259 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6264 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6277 "ast-system-unpk.cc"
void
impl_tRethrow_Rethrow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 508 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 508 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 510 "ast-to-visualization.k"

		(*output) << "rethrow" << toString(_id->value) << " [shape=rectangle style=filled label=\"rethrow\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "rethrow" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "rethrow" + toString(_id->value);

#line  6298 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1382 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1382 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1384 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    assert(globals::ASTEmap[*it] != NULL);
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(6, "", myself->attributes["referenceLine"]);

#line  6338 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1413 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  6344 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 508 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 508 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 509 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Rethrow\n");
		CFGBlock * block = new CFGBlock(CFGRethrow, this->id, "Rhrow"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6362 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 350 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 350 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 351 "ast-to-xml.k"
		inup(); 
#line  6376 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<rethrow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 351 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6382 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 351 "ast-to-xml.k"
		indown(); 
#line  6387 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</rethrow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 100 "ast-to-petrinet.k"
		PRethrow(this, kc_current_view_base); 
#line  6397 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6402 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6415 "ast-system-unpk.cc"
void
impl_tCompensate_CompensateScope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 540 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 540 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 540 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 542 "ast-to-visualization.k"

		(*output) << "compensateScope" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensateScope\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensateScope" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensateScope" + toString(_id->value);

#line  6438 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1482 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1482 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 1482 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1484 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;



		if (myself->attributes["target"] == "")
		myself->attributes["target"] = string(b->name);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();
		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(7, "", myself->attributes["referenceLine"]);



		if (globals::ASTE_scopeNames[myself->attributes["target"]] == 0)
		SAerror(78, myself->attributes["target"], myself->attributes["referenceLine"]);
		else if (globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]]) == globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end())
		SAerror(77, myself->attributes["target"], myself->attributes["referenceLine"]);

		globals::ASTEmap[ 
		globals::ASTEmap[ 
		*(globals::ASTEmap[myself->parentScopeId]->enclosedScopes.find(globals::ASTE_scopeNames[myself->attributes["target"]])) 
		]->enclosedCH 
		]->callable = true;

#line  6500 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1533 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6511 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 539 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 539 "ast-to-cfg.k"
		const casestring name = this->casestring_1;
#line 539 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 540 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] CompensateScope\n");
		CFGBlock * block = new CFGBlock(CFGCompensateScope, this->id, "CompensateScope"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6531 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 363 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 363 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 363 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 364 "ast-to-xml.k"
		inup(); 
#line  6547 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensateScope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\" target=\""), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 364 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6555 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 364 "ast-to-xml.k"
		indown(); 
#line  6560 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensateScope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 112 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6570 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 112 "ast-to-petrinet.k"
		PCompensateScope(this, kc_current_view_base); 
#line  6579 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6584 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6597 "ast-system-unpk.cc"
void
impl_tCompensate_Compensate::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 526 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 526 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 528 "ast-to-visualization.k"

		(*output) << "compensate" << toString(_id->value) << " [shape=rectangle style=filled label=\"compensate\"";
		if(globals::ASTEmap[_id->value]->highlighted)
		(*output) << " fillcolor=red";
		(*output) << "];" << endl;
		globals::ASTEmap[_id->value]->visConnection= "compensate" + toString(_id->value);
		globals::ASTEmap[_id->value]->secVisConnection= "compensate" + toString(_id->value);

#line  6618 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1424 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1424 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1426 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		bool correctUse = false;
		vector<unsigned int> ancestorActivities = myself->ancestorActivities();

		for (vector<unsigned int>::iterator it = ancestorActivities.begin(); it != ancestorActivities.end(); it++)
		{
		    if (globals::ASTEmap[*it]->activityTypeName() == "faultHandlers" ||
			globals::ASTEmap[*it]->activityTypeName() == "compensationHandler" ||
			globals::ASTEmap[*it]->activityTypeName() == "terminationHandler")
		    {
			correctUse = true;
			break;
		    }
		}
		if (!correctUse)
		SAerror(8, "", myself->attributes["referenceLine"]);


		globals::ASTEmap[myself->parentActivityId]->hasCompensate = true;
		for (set< unsigned int >::iterator scope =  globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin();
		    scope != globals::ASTEmap[myself->parentActivityId]->enclosedScopes.begin(); 
		    scope++)
		{
		    globals::ASTEmap[ globals::ASTEmap[ *scope ]->enclosedCH ]->callable = true;
		}

#line  6669 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1466 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );


		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(121, myself->activityTypeName(), myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  6680 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 524 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 524 "ast-to-cfg.k"
		const integer b = this->integer_1;
#line 525 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Compensate\n");
		CFGBlock * block = new CFGBlock(CFGCompensate, this->id, "Compensate"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  6698 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 359 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 359 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 360 "ast-to-xml.k"
		inup(); 
#line  6712 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<compensate id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 360 "ast-to-xml.k"
		listAttributes( _id ); 
#line  6718 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 360 "ast-to-xml.k"
		indown(); 
#line  6723 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</compensate>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 108 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6733 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 108 "ast-to-petrinet.k"
		PCompensate(this, kc_current_view_base); 
#line  6742 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  6747 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  6760 "ast-system-unpk.cc"
void
impl_tSequence_Sequence::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 558 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 558 "ast-to-visualization.k"
		const activity_list b = this->activity_list_1;
#line 558 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 560 "ast-to-visualization.k"


		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Sequence\";" << endl;  

#line  6779 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 565 "ast-to-visualization.k"


		bool startlist=true;
		bool laststructured = false;
		int lastid = 0;   
		{
#line 570 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6792 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 570 "ast-to-visualization.k"
			    {
				{
#line 571 "ast-to-visualization.k"
#line 570 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 571 "ast-to-visualization.k"

				    if (startlist)
				    {
					startlist=false;
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    else
				    {

					globals::visArcs += globals::ASTEmap[_id->value]->visConnection + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
					if (globals::ASTEmap[innerActivity->id]->structured())
					{
					    globals::visArcs += "lhead=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(innerActivity->id);          
					    globals::visArcs += " ";          
					}
					if (laststructured)
					{
					    globals::visArcs += "ltail=";
					    globals::visArcs += "cluster";          
					    globals::visArcs += toString(lastid);          
					}
					globals::visArcs += "];\n";
				    }
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					lastid = innerActivity->id;
					laststructured = true;
				    }
				    else
				    laststructured = false;

				    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;

#line  6840 "ast-system-unpk.cc"
				}
			    }

#line  6844 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 570 "ast-to-visualization.k"

#line  6849 "ast-system-unpk.cc"
		    }
		}
#line 606 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  6855 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1911 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1911 "ast-postprocess.k"
		const activity_list b = this->activity_list_1;
#line 1911 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1913 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1929 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6889 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1929 "ast-postprocess.k"
			    {
				{
#line 1930 "ast-postprocess.k"
#line 1929 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1930 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  6908 "ast-system-unpk.cc"
				}
			    }

#line  6912 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1929 "ast-postprocess.k"

#line  6917 "ast-system-unpk.cc"
		    }
		}
#line 1936 "ast-postprocess.k"

#line  6922 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1938 "ast-postprocess.k"



		int activityCount = 1;
		{
#line 1942 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  6934 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1942 "ast-postprocess.k"
			    {
				{
#line 1943 "ast-postprocess.k"
#line 1942 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1943 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);

				    bool before = true;
				    {
#line 1947 "ast-postprocess.k"
					activity_list kc_fe_selvar_1 =  b;

#line  6955 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
					    ) {
					    activity kc_selvar_1_1 = kc_fe_selvar_1->activity_1;
					    {
#line 1947 "ast-postprocess.k"
						{
						    {
#line 1948 "ast-postprocess.k"
#line 1947 "ast-postprocess.k"
							const activity innerActivity2 = kc_selvar_1_1;
#line 1948 "ast-postprocess.k"

							if ( innerActivity2->id == innerActivity->id)
							{
							    before == false;
							}
							else if (before == true)
							{
							    enterConsecutiveActivities( innerActivity2->id, innerActivity->id );
							}

#line  6978 "ast-system-unpk.cc"
						    }
						}

#line  6982 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1947 "ast-postprocess.k"

#line  6987 "ast-system-unpk.cc"
					}
				    }
#line 1958 "ast-postprocess.k"


				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity && activityCount++ > 1)
				    SAerror(56, "<" + globals::ASTEmap[innerActivity->id]->activityTypeName() + ">", globals::ASTEmap[innerActivity->id]->attributes["referenceLine"]);

#line  7000 "ast-system-unpk.cc"
				}
			    }

#line  7004 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1942 "ast-postprocess.k"

#line  7009 "ast-system-unpk.cc"
		    }
		}
#line 1967 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7018 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 773 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 773 "ast-to-cfg.k"
		const activity_list b = this->activity_list_1;
#line 773 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 774 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Sequence\n");
		CFGBlock * firstBlock = new CFGBlock(CFGSequence, this->id, "Sequence_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGSequence, this->id, "Sequence_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7042 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 785 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		{
#line 787 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  b;

#line  7051 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 787 "ast-to-cfg.k"
			    {
				{
#line 788 "ast-to-cfg.k"
#line 787 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 788 "ast-to-cfg.k"

				    CFGBlock * current = globals::cfgMap.find(toString(innerActivity->id))->second;

				    connectBlocks(last, current->firstBlock);
				    last = current->lastBlock;

#line  7070 "ast-system-unpk.cc"
				}
			    }

#line  7074 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 787 "ast-to-cfg.k"

#line  7079 "ast-system-unpk.cc"
		    }
		}
#line 793 "ast-to-cfg.k"

		connectBlocks(last, lastBlock);

#line  7086 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 797 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Sequence\n");

#line  7092 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 372 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 372 "ast-to-xml.k"
		const activity_list b = this->activity_list_1;
#line 372 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 373 "ast-to-xml.k"
		inup(); 
#line  7107 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sequence id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 373 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7113 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 373 "ast-to-xml.k"
		indown(); 
#line  7119 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sequence>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 134 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7129 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 134 "ast-to-petrinet.k"
		PSequence(this, kc_current_view_base); 
#line  7138 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7143 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7156 "ast-system-unpk.cc"
void
impl_tIf_If::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 616 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 616 "ast-to-visualization.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 616 "ast-to-visualization.k"
		const tElse c = this->tElse_1;
#line 616 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 618 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"If\";" << endl;  
		(*output) << "if" << toString(_id->value) << " [shape=diamond style=filled label=\"\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "if" + toString(_id->value);

#line  7178 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 624 "ast-to-visualization.k"

		int middle = 0;

		{
#line 627 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7190 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 627 "ast-to-visualization.k"
			    {
#line 628 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 628 "ast-to-visualization.k"
#line 627 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 628 "ast-to-visualization.k"

				    middle += 1;

#line  7207 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7212 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 627 "ast-to-visualization.k"

#line  7217 "ast-system-unpk.cc"
		    }
		}
#line 631 "ast-to-visualization.k"

		{
#line 632 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 635 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 635 "ast-to-visualization.k"
#line 634 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 634 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 634 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 635 "ast-to-visualization.k"

			middle += 1;

#line  7238 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 639 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter=1;

		{
#line 643 "ast-to-visualization.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7251 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 643 "ast-to-visualization.k"
			    {
#line 644 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 644 "ast-to-visualization.k"
#line 643 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 644 "ast-to-visualization.k"

				    globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter+=1;

#line  7282 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7287 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 643 "ast-to-visualization.k"

#line  7292 "ast-system-unpk.cc"
		    }
		}
#line 660 "ast-to-visualization.k"

		{
#line 661 "ast-to-visualization.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 664 "ast-to-visualization.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 664 "ast-to-visualization.k"
#line 663 "ast-to-visualization.k"
			const tElse c = kc_selvar_0_1;
#line 663 "ast-to-visualization.k"
			const activity innerActivity = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 663 "ast-to-visualization.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 664 "ast-to-visualization.k"

			globals::visArcs += "if" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
			if (globals::ASTEmap[innerActivity->id]->structured())
			{
			    globals::visArcs += "lhead=";
			    globals::visArcs += "cluster";          
			    globals::visArcs += toString(innerActivity->id);          
			    globals::visArcs += " ";          
			}
			globals::visArcs += "];\n";

			if (childcounter<=middle)
			{
			    globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
			}

#line  7326 "ast-system-unpk.cc"
		    } else
		    {
#line 680 "ast-to-visualization.k"
#line 680 "ast-to-visualization.k"


#line  7333 "ast-system-unpk.cc"
		    }
		}
#line 683 "ast-to-visualization.k"

		(*output) << "}" << endl;    

#line  7340 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1680 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1680 "ast-postprocess.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 1680 "ast-postprocess.k"
		const tElse c = this->tElse_1;
#line 1680 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1682 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);


		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		globals::if_branches[myid] = 1;




		{
#line 1703 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7381 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1703 "ast-postprocess.k"
			    {
#line 1704 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1704 "ast-postprocess.k"
#line 1703 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1703 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1703 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1704 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

				    globals::if_branches[myid]++;

#line  7407 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7412 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1703 "ast-postprocess.k"

#line  7417 "ast-system-unpk.cc"
		    }
		}
#line 1712 "ast-postprocess.k"


		{
#line 1714 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1717 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1717 "ast-postprocess.k"
#line 1716 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1716 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1716 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1717 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			globals::ASTEmap[d->id]->parentActivityId = myid;
			globals::ASTEmap[d->id]->controlFlow = myself->controlFlow;
			globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;

#line  7442 "ast-system-unpk.cc"
		    } else
		    {
#line 1723 "ast-postprocess.k"
#line 1723 "ast-postprocess.k"

#line  7448 "ast-system-unpk.cc"
		    }
		}
#line 1725 "ast-postprocess.k"

#line  7453 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1727 "ast-postprocess.k"


		{
#line 1729 "ast-postprocess.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7464 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 1729 "ast-postprocess.k"
			    {
#line 1730 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 1730 "ast-postprocess.k"
#line 1729 "ast-postprocess.k"
				    const tElseIf branch = kc_selvar_0_1;
#line 1729 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 1729 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->integer_1;
#line 1730 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

#line  7487 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7492 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 1729 "ast-postprocess.k"

#line  7497 "ast-system-unpk.cc"
		    }
		}
#line 1735 "ast-postprocess.k"

		{
#line 1736 "ast-postprocess.k"
		    tElse kc_selvar_0_1 = phylum_cast<tElse>(c);
#line 1739 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Else)) {
#line 1739 "ast-postprocess.k"
#line 1738 "ast-postprocess.k"
			const tElse c = kc_selvar_0_1;
#line 1738 "ast-postprocess.k"
			const activity d = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->activity_1;
#line 1738 "ast-postprocess.k"
			const integer _id2 = phylum_cast<const impl_tElse_Else*>(kc_selvar_0_1)->integer_1;
#line 1739 "ast-postprocess.k"

			assert(globals::ASTEmap[d->id] != NULL);
			myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
			myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);

#line  7520 "ast-system-unpk.cc"
		    } else
		    {
#line 1744 "ast-postprocess.k"
#line 1744 "ast-postprocess.k"

#line  7526 "ast-system-unpk.cc"
		    }
		}
#line 1746 "ast-postprocess.k"

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7535 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    if ((this->tElse_1->prod_sel() == sel_Else)) {
#line 605 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 605 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 605 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 605 "ast-to-cfg.k"
		const activity c = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->activity_1;
#line 605 "ast-to-cfg.k"
		const integer d = phylum_cast<const impl_tElse_Else*>(this->tElse_1)->integer_1;
#line 605 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 606 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7565 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 618 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 621 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7576 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 621 "ast-to-cfg.k"
			    {
#line 622 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 622 "ast-to-cfg.k"
#line 621 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 621 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 622 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7605 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7610 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 621 "ast-to-cfg.k"

#line  7615 "ast-system-unpk.cc"
		    }
		}
#line 634 "ast-to-cfg.k"

		CFGBlock * elseBlock = new CFGBlock(CFGElse, this->id, "Else");
		CFGBlock * innerFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(last, elseBlock);
		connectBlocks(elseBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  7628 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		if ((this->tElse_1->prod_sel() == sel_NoElse)) {
#line 647 "ast-to-cfg.k"
		const tIf This = this/**/;
#line 647 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 647 "ast-to-cfg.k"
		const tElseIf_list b = this->tElseIf_list_1;
#line 647 "ast-to-cfg.k"
		const integer _id = phylum_cast<const impl_tElse_NoElse*>(this->tElse_1)->integer_1;
#line 647 "ast-to-cfg.k"
		const integer e = this->integer_1;
#line 648 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] If\n");
		CFGBlock * firstBlock = new CFGBlock(CFGIf, this->id, "If_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGIf, this->id, "If_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  7653 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 659 "ast-to-cfg.k"

		CFGBlock * last = firstBlock;
		int i = 1;
		{
#line 662 "ast-to-cfg.k"
		    tElseIf_list kc_fe_selvar_1 =  b;

#line  7663 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstElseIf_list
			) {
			tElseIf kc_selvar_0_1 = kc_fe_selvar_1->tElseIf_1;
			{
#line 662 "ast-to-cfg.k"
			    {
#line 663 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_ElseIf)) {
#line 663 "ast-to-cfg.k"
#line 662 "ast-to-cfg.k"
				    const tElseIf elseIfBranch = kc_selvar_0_1;
#line 662 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tElseIf_ElseIf*>(kc_selvar_0_1)->activity_1;
#line 663 "ast-to-cfg.k"

				    CFGBlock * elseIfBlock = new CFGBlock(CFGElseIf, This->id, "ElseIf_" + toString(i));

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(last, elseIfBlock);
				    connectBlocks(elseIfBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

				    last = elseIfBlock;	    
				    i++;

#line  7692 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  7697 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tElseIf_list_1;
#line 662 "ast-to-cfg.k"

#line  7702 "ast-system-unpk.cc"
		    }
		}
#line 675 "ast-to-cfg.k"










		connectBlocks(last, lastBlock);

#line  7718 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tElseIf_list_1->prod_sel() == sel_ConstElseIf_list) && ((this->tElseIf_list_1)->tElseIf_1->prod_sel() == sel_ElseIf)) {
#line 381 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 381 "ast-to-xml.k"
		const activity b = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->activity_1;
#line 381 "ast-to-xml.k"
		const integer _id2 = phylum_cast<const impl_tElseIf_ElseIf*>((this->tElseIf_list_1)->tElseIf_1)->integer_1;
#line 381 "ast-to-xml.k"
		const tElseIf_list c = (this->tElseIf_list_1)->tElseIf_list_1;
#line 381 "ast-to-xml.k"
		const tElse d = this->tElse_1;
#line 381 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 382 "ast-to-xml.k"
		inup(); 
#line  7741 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<if id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 382 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7747 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
#line 382 "ast-to-xml.k"

#line  7751 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
#line 382 "ast-to-xml.k"
		indown(); 
#line  7758 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</if>\n"), kc_current_view); }
	    } else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 146 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7769 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 146 "ast-to-petrinet.k"
		PIf(this, kc_current_view_base); 
#line  7778 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  7783 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  7804 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tElseIf_list iterator_ = this; iterator_->tElseIf_list_1 != 0; iterator_ = iterator_->tElseIf_list_1)
		    iterator_->tElseIf_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tElseIf_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  7823 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  7836 "ast-system-unpk.cc"
void
impl_tElseIf_ElseIf::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 689 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 689 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1754 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1754 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1756 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

#line  7869 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1766 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7877 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 385 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 385 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 386 "ast-to-xml.k"
		inup(); 
#line  7890 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<elseif id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 386 "ast-to-xml.k"
		listAttributes( _id ); 
#line  7896 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 386 "ast-to-xml.k"
		indown(); 
#line  7901 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</elseif>\n"), kc_current_view); }
	    }
	    break;
	}

#line  7907 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7920 "ast-system-unpk.cc"
void
impl_tElse_NoElse::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1793 "ast-postprocess.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}

#line  7934 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  7947 "ast-system-unpk.cc"
void
impl_tElse_Else::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 694 "ast-to-visualization.k"
		const activity a = this->activity_1;
#line 694 "ast-to-visualization.k"
		const integer _id = this->integer_1;
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1774 "ast-postprocess.k"
		const activity a = this->activity_1;
#line 1774 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1776 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;

#line  7979 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 1785 "ast-postprocess.k"

		myself->enclosedActivities = globals::ASTEmap[ a->id ]->enclosedActivities;
		myself->enclosedActivities.insert( a->id );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  7987 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 389 "ast-to-xml.k"
		const activity a = this->activity_1;
#line 389 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 390 "ast-to-xml.k"
		inup(); 
#line  8000 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<else id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 390 "ast-to-xml.k"
		indown(); 
#line  8007 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</else>\n"), kc_current_view); }
	    }
	    break;
	}

#line  8013 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8026 "ast-system-unpk.cc"
void
impl_tWhile_While::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 703 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 703 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 703 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 705 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"While\";" << endl;  

#line  8044 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 709 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8053 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1800 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1800 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1800 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1802 "ast-postprocess.k"


		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8097 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1833 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8113 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 696 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 696 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 696 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 697 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] While\n");
		CFGBlock * block = new CFGBlock(CFGWhile, this->id, "While"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8133 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 704 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8143 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 398 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 398 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 398 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 399 "ast-to-xml.k"
		inup(); 
#line  8159 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<while id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 399 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8165 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 399 "ast-to-xml.k"
		indown(); 
#line  8171 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</while>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8181 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 126 "ast-to-petrinet.k"
		PWhile(this, kc_current_view_base); 
#line  8190 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8195 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8208 "ast-system-unpk.cc"
void
impl_tRepeatUntil_RepeatUntil::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 722 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 722 "ast-to-visualization.k"
		const activity b = this->activity_1;
#line 722 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 724 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"RepeatUntil\";" << endl;  

#line  8226 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 728 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[b->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[b->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8235 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1856 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1856 "ast-postprocess.k"
		const activity b = this->activity_1;
#line 1856 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1858 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		assert(globals::ASTEmap[b->id] != NULL);
		globals::ASTEmap[b->id]->parentActivityId = myid;
		globals::ASTEmap[b->id]->controlFlow = myself->controlFlow;


		unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
		if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
		globals::ASTEmap[b->id]->max_occurrences = myself->max_occurrences * max_loops;
		else
		globals::ASTEmap[b->id]->max_occurrences = UINT_MAX;

		myself->max_loops = max_loops;

#line  8278 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 1888 "ast-postprocess.k"


		assert(globals::ASTEmap[b->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[b->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[b->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8294 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 744 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 744 "ast-to-cfg.k"
		const activity b = this->activity_1;
#line 744 "ast-to-cfg.k"
		const integer c = this->integer_1;
#line 745 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] RepeatUntil\n");
		CFGBlock * repeat = new CFGBlock(CFGRepeatUntil, this->id, "Repeat"); 
		CFGBlock * until = new CFGBlock(CFGRepeatUntil, this->id, "Until"); 

		repeat->firstBlock = until->firstBlock = repeat;
		repeat->lastBlock  = until->lastBlock  = until;

		globals::cfgMap[toString(this->id)] = repeat; 

#line  8318 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
#line 756 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(b->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(b->id))->second->lastBlock;

		connectBlocks(repeat, innerFirst);
		connectBlocks(innerLast, until);
		connectBlocks(until, repeat);

#line  8329 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 407 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 407 "ast-to-xml.k"
		const activity b = this->activity_1;
#line 407 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 408 "ast-to-xml.k"
		inup(); 
#line  8345 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<repeatUntil id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 408 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8351 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 408 "ast-to-xml.k"
		indown(); 
#line  8357 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 130 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8367 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 130 "ast-to-petrinet.k"
		PRepeatUntil(this, kc_current_view_base); 
#line  8376 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8381 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8394 "ast-system-unpk.cc"
void
impl_tForEach_ForEach::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 741 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 741 "ast-to-visualization.k"
		const casestring b = this->casestring_1;
#line 741 "ast-to-visualization.k"
		const casestring c = this->casestring_2;
#line 741 "ast-to-visualization.k"
		const casestring d = this->casestring_3;
#line 741 "ast-to-visualization.k"
		const tScope e = this->tScope_1;
#line 741 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 743 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"ForEach\";" << endl;  

#line  8418 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 747 "ast-to-visualization.k"

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[e->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[e->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  8426 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2080 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2080 "ast-postprocess.k"
		const casestring b = this->casestring_1;
#line 2080 "ast-postprocess.k"
		const casestring c = this->casestring_2;
#line 2080 "ast-postprocess.k"
		const casestring d = this->casestring_3;
#line 2080 "ast-postprocess.k"
		const tScope e = this->tScope_1;
#line 2080 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2082 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);    

		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();



		myself->checkVariable("counterName");


		assert(globals::ASTEmap[e->id] != NULL);
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->controlFlow = myself->controlFlow;


		unsigned int startCounter = toUInt(b->name);
		unsigned int finalCounter = toUInt(c->name);
		unsigned int completion = toUInt(d->name);

		if (startCounter != UINT_MAX && finalCounter != UINT_MAX)
		{
		    if (startCounter >= finalCounter)
		    {
			string error = "constant <finalCounterValue> `" + toString(finalCounter) +
			"' less or equal than constant <startCounterValue> `" + toString(startCounter) + "'";
			SAerror(74, error, myself->attributes["referenceLine"]);
		    }
		    else
		    {
			if (myself->attributes["hu:maxloops"] != "")
			cerr << "ignoring attribute `hu:maxloops'" << endl; 
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * (finalCounter - startCounter);
			myself->max_loops = (finalCounter - startCounter);
		    }

		    if ((completion != UINT_MAX) && ((completion > (finalCounter-startCounter))))
		    SAerror(75, "", myself->attributes["referenceLine"]);
		}
		else
		{

		    if ((globals::choreography_filename != "") && (string(b->name) == "opaque") && (string(c->name) == "opaque"))
		    {

			myself->max_loops = globals::BPEL4ChorInfo.forEach_count(myid);
		    }
		    else
		    {

			unsigned int max_loops = toUInt(myself->attributes["hu:maxloops"]);
			if (max_loops != UINT_MAX && myself->max_occurrences != UINT_MAX)
			globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences * max_loops;
			else
			globals::ASTEmap[e->id]->max_occurrences = UINT_MAX;

			myself->max_loops = max_loops;
		    }
		}

#line  8511 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
#line 2148 "ast-postprocess.k"


		{
#line 2150 "ast-postprocess.k"
		    tScope kc_selvar_0_1 = phylum_cast<tScope>(e);
#line 2153 "ast-postprocess.k"
		    if ((kc_selvar_0_1->prod_sel() == sel_Scope)) {
#line 2153 "ast-postprocess.k"
#line 2152 "ast-postprocess.k"
			const tScope e = kc_selvar_0_1;
#line 2152 "ast-postprocess.k"
			const tVariable_list _variables = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tVariable_list_1;
#line 2152 "ast-postprocess.k"
			const tMessageExchange_list messageExchange = phylum_cast<const impl_tScope_Scope*>(kc_selvar_0_1)->tMessageExchange_list_1;
#line 2153 "ast-postprocess.k"

			{
#line 2154 "ast-postprocess.k"
			    tVariable_list kc_fe_selvar_1 =  _variables;

#line  8535 "ast-system-unpk.cc"
			    while(
				    kc_fe_selvar_1->prod_sel() == sel_ConstVariable_list
				) {
				tVariable kc_selvar_1_1 = kc_fe_selvar_1->tVariable_1;
				{
#line 2154 "ast-postprocess.k"
				    {
#line 2155 "ast-postprocess.k"
					if ((kc_selvar_1_1->prod_sel() == sel_Variable)) {
#line 2155 "ast-postprocess.k"
#line 2154 "ast-postprocess.k"
					    const tVariable variable = kc_selvar_1_1;
#line 2154 "ast-postprocess.k"
					    const integer _id2 = phylum_cast<const impl_tVariable_Variable*>(kc_selvar_1_1)->integer_1;
#line 2155 "ast-postprocess.k"

					    assert(_id2 != NULL);
					    assert(globals::ASTEmap[_id2->value] != NULL);
					    if (globals::ASTEmap[_id2->value]->attributes["name"] == globals::ASTEmap[_id->value]->attributes["counterName"])
					    SAerror(76, globals::ASTEmap[_id2->value]->attributes["name"], globals::ASTEmap[_id2->value]->attributes["referenceLine"]);

#line  8557 "ast-system-unpk.cc"
					} else
					{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
				    }

#line  8562 "ast-system-unpk.cc"
				}
				kc_fe_selvar_1 = kc_fe_selvar_1->tVariable_list_1;
#line 2154 "ast-postprocess.k"

#line  8567 "ast-system-unpk.cc"
			    }
			}
#line 2160 "ast-postprocess.k"


#line  8573 "ast-system-unpk.cc"
		    } else
			kc_no_default_in_with( "", __LINE__, __FILE__ );
		}
#line 2163 "ast-postprocess.k"


		assert(globals::ASTEmap[e->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

		check_SA00070( myid );

#line  8590 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 720 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 720 "ast-to-cfg.k"
		const casestring b = this->casestring_1;
#line 720 "ast-to-cfg.k"
		const casestring c = this->casestring_2;
#line 720 "ast-to-cfg.k"
		const casestring d = this->casestring_3;
#line 720 "ast-to-cfg.k"
		const tScope e = this->tScope_1;
#line 720 "ast-to-cfg.k"
		const integer f = this->integer_1;
#line 721 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ForEach\n");
		CFGBlock * block = new CFGBlock(CFGForEach, this->id, "ForEach"); 

		globals::cfgMap[toString(this->id)] = block; 

#line  8616 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 728 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(block, innerFirst);
		connectBlocks(innerLast, block);

#line  8626 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 416 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 416 "ast-to-xml.k"
		const casestring b = this->casestring_1;
#line 416 "ast-to-xml.k"
		const casestring c = this->casestring_2;
#line 416 "ast-to-xml.k"
		const casestring d = this->casestring_3;
#line 416 "ast-to-xml.k"
		const tScope e = this->tScope_1;
#line 416 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 417 "ast-to-xml.k"
		inup(); 
#line  8648 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<foreach id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 417 "ast-to-xml.k"
		listAttributes( _id ); 
#line  8654 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 419 "ast-to-xml.k"
		inup(); 
#line  8659 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<startCounterValue>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 419 "ast-to-xml.k"
		indown(); 
#line  8664 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</startCounterValue>\n"), kc_current_view); }
#line 420 "ast-to-xml.k"
		inup(); 
#line  8668 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<finalCounterValue>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 420 "ast-to-xml.k"
		indown(); 
#line  8673 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</finalCounterValue>\n"), kc_current_view); }
#line 421 "ast-to-xml.k"
		inup(); 
#line  8677 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<completionCondition>\n"), kc_current_view); }
		kc::unparse(d, kc_printer, kc_current_view);
#line 421 "ast-to-xml.k"
		indown(); 
#line  8682 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</completionCondition>\n"), kc_current_view); }
		kc::unparse(e, kc_printer, kc_current_view);
#line 423 "ast-to-xml.k"
		indown(); 
#line  8687 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</repeatUntil>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 150 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8697 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 150 "ast-to-petrinet.k"
		PForEach(this, kc_current_view_base); 
#line  8706 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  8711 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  8724 "ast-system-unpk.cc"
void
impl_tPick_Pick::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 760 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 760 "ast-to-visualization.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 760 "ast-to-visualization.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 760 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 762 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Pick\";" << endl;  
		(*output) << "pick" << toString(_id->value) << " [shape=diamond style=filled label=\"?\"];" << endl;
		globals::ASTEmap[_id->value]->secVisConnection = "if" + toString(_id->value);

#line  8746 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 768 "ast-to-visualization.k"

		int middle = 0;
		{
#line 770 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8757 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 770 "ast-to-visualization.k"
			    {
#line 771 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 771 "ast-to-visualization.k"
#line 770 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 770 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 770 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 770 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 770 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 771 "ast-to-visualization.k"

				    middle+=1;

#line  8782 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8787 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 770 "ast-to-visualization.k"

#line  8792 "ast-system-unpk.cc"
		    }
		}
#line 774 "ast-to-visualization.k"
		{
#line 774 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8800 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 774 "ast-to-visualization.k"
			    {
#line 775 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 775 "ast-to-visualization.k"
#line 774 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 774 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 774 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 775 "ast-to-visualization.k"

				    middle+=1;

#line  8821 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8826 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 774 "ast-to-visualization.k"

#line  8831 "ast-system-unpk.cc"
		    }
		}
#line 778 "ast-to-visualization.k"

		middle = middle/2 + (middle % 2);
		int childcounter = 1;

		{
#line 782 "ast-to-visualization.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8843 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 782 "ast-to-visualization.k"
			    {
#line 783 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 783 "ast-to-visualization.k"
#line 782 "ast-to-visualization.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 782 "ast-to-visualization.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 782 "ast-to-visualization.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 782 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 782 "ast-to-visualization.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 783 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8882 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8887 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 782 "ast-to-visualization.k"

#line  8892 "ast-system-unpk.cc"
		    }
		}
#line 800 "ast-to-visualization.k"
		{
#line 800 "ast-to-visualization.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  8900 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 800 "ast-to-visualization.k"
			    {
#line 801 "ast-to-visualization.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 801 "ast-to-visualization.k"
#line 800 "ast-to-visualization.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 800 "ast-to-visualization.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 800 "ast-to-visualization.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 801 "ast-to-visualization.k"

				    globals::visArcs += "pick" + toString(_id->value) + " -> " + globals::ASTEmap[innerActivity->id]->secVisConnection + "["; 
				    if (globals::ASTEmap[innerActivity->id]->structured())
				    {
					globals::visArcs += "lhead=";
					globals::visArcs += "cluster";          
					globals::visArcs += toString(innerActivity->id);          
					globals::visArcs += " ";          
				    }
				    globals::visArcs += "];\n";

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  8935 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  8940 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 800 "ast-to-visualization.k"

#line  8945 "ast-system-unpk.cc"
		    }
		}
#line 818 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  8951 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1980 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1980 "ast-postprocess.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 1980 "ast-postprocess.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 1980 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1982 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();




		{
#line 1998 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  8987 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 1998 "ast-postprocess.k"
			    {
#line 1999 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 1999 "ast-postprocess.k"
#line 1998 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 1998 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 1998 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 1998 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 1998 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 1999 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id2->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id2->value]->max_occurrences = myself->max_occurrences;

#line  9016 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9021 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 1998 "ast-postprocess.k"

#line  9026 "ast-system-unpk.cc"
		    }
		}
#line 2006 "ast-postprocess.k"
		{
#line 2006 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9034 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2006 "ast-postprocess.k"
			    {
#line 2007 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2007 "ast-postprocess.k"
#line 2006 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2006 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2006 "ast-postprocess.k"
				    const integer _id3 = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->integer_1;
#line 2007 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[_id3->value]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[_id3->value]->max_occurrences = myself->max_occurrences;

#line  9059 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9064 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2006 "ast-postprocess.k"

#line  9069 "ast-system-unpk.cc"
		    }
		}
#line 2014 "ast-postprocess.k"

#line  9074 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 2016 "ast-postprocess.k"

		if (myself->isStartActivity)
		{
		    globals::ASTE_startActivities.insert(myid);


		    if (c->length() != 0)
		    SAerror(62, "", myself->attributes["referenceLine"]);


		    if (!globals::ASTEmap[myself->parentActivityId]->checkAncestors() || !myself->targetLinks.empty())
		    SAerror(56, "<pick>", myself->attributes["referenceLine"]);
		}


		{
#line 2031 "ast-postprocess.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9098 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 2031 "ast-postprocess.k"
			    {
#line 2032 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 2032 "ast-postprocess.k"
#line 2031 "ast-postprocess.k"
				    const tOnMessage branch = kc_selvar_0_1;
#line 2031 "ast-postprocess.k"
				    const tCorrelation_list _corr = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tCorrelation_list_1;
#line 2031 "ast-postprocess.k"
				    const tFromPart_list _from = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->tFromPart_list_1;
#line 2031 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 2031 "ast-postprocess.k"
				    const integer _id2 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->integer_1;
#line 2032 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2037 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9129 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2037 "ast-postprocess.k"
						{
#line 2038 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2038 "ast-postprocess.k"
#line 2037 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2037 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2037 "ast-postprocess.k"
							const integer _id3 = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->integer_1;
#line 2038 "ast-postprocess.k"

							assert(_id2 != NULL);
							assert(_id3 != NULL);
							if (_id2->value < _id3->value)
							{
							    enterConflictingActivities( globals::ASTEmap[ _id2->value ]->enclosedActivities, globals::ASTEmap[ _id3->value ]->enclosedActivities );
							}

#line  9155 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9160 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2037 "ast-postprocess.k"

#line  9165 "ast-system-unpk.cc"
					}
				    }
#line 2046 "ast-postprocess.k"

#line  9170 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9175 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2031 "ast-postprocess.k"

#line  9180 "ast-system-unpk.cc"
		    }
		}
#line 2047 "ast-postprocess.k"
		{
#line 2047 "ast-postprocess.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9188 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 2047 "ast-postprocess.k"
			    {
#line 2048 "ast-postprocess.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 2048 "ast-postprocess.k"
#line 2047 "ast-postprocess.k"
				    const tOnAlarm branch = kc_selvar_0_1;
#line 2047 "ast-postprocess.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 2048 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);

				    {
#line 2053 "ast-postprocess.k"
					tOnMessage_list kc_fe_selvar_1 =  b;

#line  9213 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
					    ) {
					    tOnMessage kc_selvar_1_1 = kc_fe_selvar_1->tOnMessage_1;
					    {
#line 2053 "ast-postprocess.k"
						{
#line 2054 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnMessage)) {
#line 2054 "ast-postprocess.k"
#line 2053 "ast-postprocess.k"
							const tOnMessage otherbranch = kc_selvar_1_1;
#line 2053 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_1_1)->activity_1;
#line 2054 "ast-postprocess.k"

							enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );

#line  9232 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9237 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 2053 "ast-postprocess.k"

#line  9242 "ast-system-unpk.cc"
					}
				    }
#line 2057 "ast-postprocess.k"

				    {
#line 2058 "ast-postprocess.k"
					tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9251 "ast-system-unpk.cc"
					while(
						kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
					    ) {
					    tOnAlarm kc_selvar_1_1 = kc_fe_selvar_1->tOnAlarm_1;
					    {
#line 2058 "ast-postprocess.k"
						{
#line 2059 "ast-postprocess.k"
						    if ((kc_selvar_1_1->prod_sel() == sel_OnAlarm)) {
#line 2059 "ast-postprocess.k"
#line 2058 "ast-postprocess.k"
							const tOnAlarm otherbranch = kc_selvar_1_1;
#line 2058 "ast-postprocess.k"
							const activity secondActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_1_1)->activity_1;
#line 2059 "ast-postprocess.k"

							if (innerActivity->id < secondActivity->id)
							{
							    enterConflictingActivities( globals::ASTEmap[ innerActivity->id ]->enclosedActivities, globals::ASTEmap[ secondActivity->id ]->enclosedActivities );
							}

#line  9273 "ast-system-unpk.cc"
						    } else
						    {/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
						}

#line  9278 "ast-system-unpk.cc"
					    }
					    kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2058 "ast-postprocess.k"

#line  9283 "ast-system-unpk.cc"
					}
				    }
#line 2065 "ast-postprocess.k"

#line  9288 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9293 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 2047 "ast-postprocess.k"

#line  9298 "ast-system-unpk.cc"
		    }
		}
#line 2066 "ast-postprocess.k"


		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  9308 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 808 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 808 "ast-to-cfg.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 808 "ast-to-cfg.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 808 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 809 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Pick\n");
		CFGBlock * firstBlock = new CFGBlock(CFGPick, this->id, "Pick_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGPick, this->id, "Pick_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  9334 "ast-system-unpk.cc"
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 821 "ast-to-cfg.k"

		int i = 1;
		{
#line 823 "ast-to-cfg.k"
		    tOnMessage_list kc_fe_selvar_1 =  b;

#line  9344 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnMessage_list
			) {
			tOnMessage kc_selvar_0_1 = kc_fe_selvar_1->tOnMessage_1;
			{
#line 823 "ast-to-cfg.k"
			    {
#line 824 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnMessage)) {
#line 824 "ast-to-cfg.k"
#line 823 "ast-to-cfg.k"
				    const tOnMessage message = kc_selvar_0_1;
#line 823 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnMessage_OnMessage*>(kc_selvar_0_1)->activity_1;
#line 824 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onMessageBlock = new CFGBlock(CFGOnMessage, message->id, "OnMessage_" + toString(i++)); 
				    onMessageBlock->channel_name = globals::ASTEmap[message->id]->channelName;

				    connectBlocks(firstBlock, onMessageBlock);
				    connectBlocks(onMessageBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9370 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9375 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnMessage_list_1;
#line 823 "ast-to-cfg.k"

#line  9380 "ast-system-unpk.cc"
		    }
		}
#line 833 "ast-to-cfg.k"

		i = 1; 
		{
#line 835 "ast-to-cfg.k"
		    tOnAlarm_list kc_fe_selvar_1 =  c;

#line  9390 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstOnAlarm_list
			) {
			tOnAlarm kc_selvar_0_1 = kc_fe_selvar_1->tOnAlarm_1;
			{
#line 835 "ast-to-cfg.k"
			    {
#line 836 "ast-to-cfg.k"
				if ((kc_selvar_0_1->prod_sel() == sel_OnAlarm)) {
#line 836 "ast-to-cfg.k"
#line 835 "ast-to-cfg.k"
				    const tOnAlarm alarm = kc_selvar_0_1;
#line 835 "ast-to-cfg.k"
				    const activity innerActivity = phylum_cast<const impl_tOnAlarm_OnAlarm*>(kc_selvar_0_1)->activity_1;
#line 836 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;
				    CFGBlock * onAlarmBlock = new CFGBlock(CFGOnAlarm, alarm->id, "OnAlarm_" + toString(i++)); 

				    connectBlocks(firstBlock, onAlarmBlock);
				    connectBlocks(onAlarmBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9415 "ast-system-unpk.cc"
				} else
				{/* EMPTY */ /*skip: no matching pattern in foreach patterns*/}
			    }

#line  9420 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tOnAlarm_list_1;
#line 835 "ast-to-cfg.k"

#line  9425 "ast-system-unpk.cc"
		    }
		}
#line 844 "ast-to-cfg.k"


#line  9431 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 431 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 431 "ast-to-xml.k"
		const tOnMessage_list b = this->tOnMessage_list_1;
#line 431 "ast-to-xml.k"
		const tOnAlarm_list c = this->tOnAlarm_list_1;
#line 431 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 432 "ast-to-xml.k"
		inup(); 
#line  9449 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<pick id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 432 "ast-to-xml.k"
		listAttributes( _id ); 
#line  9455 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 432 "ast-to-xml.k"
		indown(); 
#line  9462 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</pick>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 142 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9472 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 142 "ast-to-petrinet.k"
		PPick(this, kc_current_view_base); 
#line  9481 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  9486 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  9499 "ast-system-unpk.cc"
void
impl_tFlow_Flow::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 828 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 828 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 828 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 830 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9517 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 834 "ast-to-visualization.k"

		int middle = 0;
		{
#line 836 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9527 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 836 "ast-to-visualization.k"
			    {
				{
#line 837 "ast-to-visualization.k"
#line 836 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 837 "ast-to-visualization.k"

				    middle+=1;

#line  9543 "ast-system-unpk.cc"
				}
			    }

#line  9547 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 836 "ast-to-visualization.k"

#line  9552 "ast-system-unpk.cc"
		    }
		}
#line 840 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;
		{
#line 842 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9562 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 842 "ast-to-visualization.k"
			    {
				{
#line 843 "ast-to-visualization.k"
#line 842 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 843 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9583 "ast-system-unpk.cc"
				}
			    }

#line  9587 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 842 "ast-to-visualization.k"

#line  9592 "ast-system-unpk.cc"
		    }
		}
#line 851 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9598 "ast-system-unpk.cc"
	    } else
	    {
#line 856 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 856 "ast-to-visualization.k"
		const tLink_list b = this->tLink_list_1;
#line 856 "ast-to-visualization.k"
		const activity_list c = this->activity_list_1;
#line 856 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 858 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Flow\";" << endl;  

#line  9613 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 862 "ast-to-visualization.k"

		int middle = 0;
		{
#line 864 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9624 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 864 "ast-to-visualization.k"
			    {
				{
#line 865 "ast-to-visualization.k"
#line 864 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 865 "ast-to-visualization.k"

				    middle+=1;

#line  9640 "ast-system-unpk.cc"
				}
			    }

#line  9644 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 864 "ast-to-visualization.k"

#line  9649 "ast-system-unpk.cc"
		    }
		}
#line 868 "ast-to-visualization.k"
		middle = middle/2 + (middle % 2);
		int childcounter = 1;    

		{
#line 871 "ast-to-visualization.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9660 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 871 "ast-to-visualization.k"
			    {
				{
#line 872 "ast-to-visualization.k"
#line 871 "ast-to-visualization.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 872 "ast-to-visualization.k"

				    if (childcounter<=middle)
				    {
					globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[innerActivity->id]->secVisConnection;
					globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[innerActivity->id]->visConnection;
				    }
				    childcounter +=1;

#line  9681 "ast-system-unpk.cc"
				}
			    }

#line  9685 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 871 "ast-to-visualization.k"

#line  9690 "ast-system-unpk.cc"
		    }
		}
#line 880 "ast-to-visualization.k"
		(*output) << "}" << endl;    

#line  9696 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1579 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 1579 "ast-postprocess.k"
		const tLink_list b = this->tLink_list_1;
#line 1579 "ast-postprocess.k"
		const activity_list c = this->activity_list_1;
#line 1579 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1581 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);



		a->parentId = myid;

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();





		{
#line 1598 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9733 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1598 "ast-postprocess.k"
			    {
				{
#line 1599 "ast-postprocess.k"
#line 1598 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1599 "ast-postprocess.k"

				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    globals::ASTEmap[innerActivity->id]->parentActivityId = myid;
				    globals::ASTEmap[innerActivity->id]->controlFlow = myself->controlFlow;
				    globals::ASTEmap[innerActivity->id]->max_occurrences = myself->max_occurrences;

#line  9752 "ast-system-unpk.cc"
				}
			    }

#line  9756 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1598 "ast-postprocess.k"

#line  9761 "ast-system-unpk.cc"
		    }
		}
#line 1605 "ast-postprocess.k"
		{
#line 1605 "ast-postprocess.k"
		    tLink_list kc_fe_selvar_1 =  b;

#line  9769 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstLink_list
			) {
			tLink kc_selvar_0_1 = kc_fe_selvar_1->tLink_1;
			{
#line 1605 "ast-postprocess.k"
			    {
				{
#line 1606 "ast-postprocess.k"
#line 1605 "ast-postprocess.k"
				    const tLink link = kc_selvar_0_1;
#line 1606 "ast-postprocess.k"

				    assert(globals::ASTEmap[link->id] != NULL);
				    globals::ASTEmap[ link->id ]->parentActivityId = myid;
				    globals::ASTEmap[ myid ]->enclosedActivities.insert( link->id );

#line  9787 "ast-system-unpk.cc"
				}
			    }

#line  9791 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tLink_list_1;
#line 1605 "ast-postprocess.k"

#line  9796 "ast-system-unpk.cc"
		    }
		}
#line 1611 "ast-postprocess.k"

#line  9801 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 1613 "ast-postprocess.k"


		unsigned int startActivityId = 0;

		{
#line 1617 "ast-postprocess.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9814 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 1617 "ast-postprocess.k"
			    {
				{
#line 1618 "ast-postprocess.k"
#line 1617 "ast-postprocess.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 1618 "ast-postprocess.k"


				    assert(globals::ASTEmap[innerActivity->id] != NULL);
				    myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[innerActivity->id]->enclosedSourceLinks);
				    myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[innerActivity->id]->enclosedTargetLinks);


				    if (globals::ASTEmap[innerActivity->id]->isStartActivity)
				    startActivityId = innerActivity->id;

#line  9837 "ast-system-unpk.cc"
				}
			    }

#line  9841 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1617 "ast-postprocess.k"

#line  9846 "ast-system-unpk.cc"
		    }
		}
#line 1628 "ast-postprocess.k"


		if (startActivityId != 0)
		{
		    {
#line 1632 "ast-postprocess.k"
			activity_list kc_fe_selvar_1 =  c;

#line  9858 "ast-system-unpk.cc"
			while(
				kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			    ) {
			    activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			    {
#line 1632 "ast-postprocess.k"
				{
				    {
#line 1633 "ast-postprocess.k"
#line 1632 "ast-postprocess.k"
					const activity innerActivity = kc_selvar_0_1;
#line 1633 "ast-postprocess.k"

					assert(globals::ASTEmap[innerActivity->id] != NULL);

					if (!globals::ASTEmap[innerActivity->id]->isStartActivity &&
					    globals::ASTEmap[innerActivity->id]->targetLinks.empty())
					{
					    SAerror(56, "<" + globals::ASTEmap[startActivityId]->activityTypeName() + ">", globals::ASTEmap[startActivityId]->attributes["referenceLine"]);
					    break;
					}

#line  9881 "ast-system-unpk.cc"
				    }
				}

#line  9885 "ast-system-unpk.cc"
			    }
			    kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 1632 "ast-postprocess.k"

#line  9890 "ast-system-unpk.cc"
			}
		    }
#line 1643 "ast-postprocess.k"
		}




		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );

#line  9903 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 571 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 571 "ast-to-cfg.k"
		const tLink_list b = this->tLink_list_1;
#line 571 "ast-to-cfg.k"
		const activity_list c = this->activity_list_1;
#line 571 "ast-to-cfg.k"
		const integer d = this->integer_1;
#line 572 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Flow\n");
		CFGBlock * firstBlock = new CFGBlock(CFGFlow, this->id, "Flow_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGFlow, this->id, "Flow_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  9929 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 583 "ast-to-cfg.k"

		{
#line 584 "ast-to-cfg.k"
		    activity_list kc_fe_selvar_1 =  c;

#line  9937 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_Consactivity_list
			) {
			activity kc_selvar_0_1 = kc_fe_selvar_1->activity_1;
			{
#line 584 "ast-to-cfg.k"
			    {
				{
#line 585 "ast-to-cfg.k"
#line 584 "ast-to-cfg.k"
				    const activity innerActivity = kc_selvar_0_1;
#line 585 "ast-to-cfg.k"

				    CFGBlock * innerFirst = globals::cfgMap.find(toString(innerActivity->id))->second->firstBlock;
				    CFGBlock * innerLast = globals::cfgMap.find(toString(innerActivity->id))->second->lastBlock;

				    connectBlocks(firstBlock, innerFirst);
				    connectBlocks(innerLast, lastBlock);

#line  9957 "ast-system-unpk.cc"
				}
			    }

#line  9961 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->activity_list_1;
#line 584 "ast-to-cfg.k"

#line  9966 "ast-system-unpk.cc"
		    }
		}
#line 591 "ast-to-cfg.k"


#line  9972 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 594 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Flow\n");

#line  9978 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tLink_list_1->prod_sel() == sel_NiltLink_list)) {
#line 440 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 440 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 440 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 441 "ast-to-xml.k"
		inup(); 
#line  9993 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 441 "ast-to-xml.k"
		listAttributes( _id ); 
#line  9999 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
#line 441 "ast-to-xml.k"
		indown(); 
#line  10005 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    } else
	    {
#line 444 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 444 "ast-to-xml.k"
		const tLink_list b = this->tLink_list_1;
#line 444 "ast-to-xml.k"
		const activity_list c = this->activity_list_1;
#line 444 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 445 "ast-to-xml.k"
		inup(); 
#line  10019 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<flow id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 445 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10025 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 445 "ast-to-xml.k"
		inup(); 
#line  10030 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<links>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 445 "ast-to-xml.k"
		indown(); 
#line  10035 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</links>\n"), kc_current_view); }
		kc::unparse(c, kc_printer, kc_current_view);
#line 445 "ast-to-xml.k"
		indown(); 
#line  10040 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</flow>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 138 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10050 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 138 "ast-to-petrinet.k"
		PFlow(this, kc_current_view_base); 
#line  10059 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10064 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tLink_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  10084 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tLink_list iterator_ = this; iterator_->tLink_list_1 != 0; iterator_ = iterator_->tLink_list_1)
		    iterator_->tLink_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tLink_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10102 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10114 "ast-system-unpk.cc"
void
impl_tLink_Link::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 885 "ast-to-visualization.k"
		const integer _id = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 1655 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 1657 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);

		myself->parentScopeId = globals::PPcurrentScope;
		myself->checkAttributes();

		myself->linkName = myself->defineLink();

		globals::ASTE_linkIdMap[ myself->linkName ] = myid;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );

#line  10148 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 448 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 449 "ast-to-xml.k"
		in(); 
#line  10159 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<link id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 449 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10165 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  10171 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10184 "ast-system-unpk.cc"
void
impl_tScope_Scope::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 894 "ast-to-visualization.k"
		const standardElements a = this->standardElements_1;
#line 894 "ast-to-visualization.k"
		const tVariable_list b = this->tVariable_list_1;
#line 894 "ast-to-visualization.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 894 "ast-to-visualization.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 894 "ast-to-visualization.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 894 "ast-to-visualization.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 894 "ast-to-visualization.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 894 "ast-to-visualization.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 894 "ast-to-visualization.k"
		const activity i = this->activity_1;
#line 894 "ast-to-visualization.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 894 "ast-to-visualization.k"
		const integer _id = this->integer_1;
#line 896 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value+1000) << " { label = \"Scope\";" << endl;  

#line  10218 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
#line 900 "ast-to-visualization.k"

		(*output) << "subgraph cluster" << toString(_id->value) << " { label = \"Scope Activity\";" << endl;  

#line  10230 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 904 "ast-to-visualization.k"

		(*output) << "}" << endl;    

		globals::ASTEmap[_id->value]->visConnection = globals::ASTEmap[i->id]->visConnection;
		globals::ASTEmap[_id->value]->secVisConnection = globals::ASTEmap[i->id]->secVisConnection;
		(*output) << "}" << endl;    

#line  10240 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2183 "ast-postprocess.k"
		const standardElements a = this->standardElements_1;
#line 2183 "ast-postprocess.k"
		const tVariable_list b = this->tVariable_list_1;
#line 2183 "ast-postprocess.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 2183 "ast-postprocess.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 2183 "ast-postprocess.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 2183 "ast-postprocess.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 2183 "ast-postprocess.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 2183 "ast-postprocess.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 2183 "ast-postprocess.k"
		const activity i = this->activity_1;
#line 2183 "ast-postprocess.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 2183 "ast-postprocess.k"
		const integer _id = this->integer_1;
#line 2185 "ast-postprocess.k"

		assert(_id != NULL);
		unsigned int myid = _id->value;
		ASTE *myself = globals::ASTEmap[myid];
		assert(myself != NULL);
		a->parentId = myid;




		myself->parentScopeId = globals::PPcurrentScope;


		globals::PPcurrentScope = myid;

		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		assert(globals::ASTEmap[myself->parentScopeId] != NULL);
		myself->checkAttributes();

		for ( std::set<unsigned int>::iterator peerScope = globals::ASTEmap[myself->parentScopeId]->enclosedScopes.begin(); 
		    peerScope != globals::ASTEmap[myself->parentScopeId]->enclosedScopes.end(); 
		    peerScope++)
		{
		    globals::ASTEmap[*peerScope]->peerScopes.insert(myid);
		    globals::ASTEmap[myid]->peerScopes.insert(*peerScope);
		}




		if (myself->controlFlow == POSITIVECF)
		globals::ASTEmap[myself->parentScopeId]->enclosedScopes.insert(myid);

		myself->hasEH = (string(f->op_name()) == "EventHandlers");



		assert(globals::ASTEmap[c->id] != NULL);
		assert(globals::ASTEmap[d->id] != NULL);
		assert(globals::ASTEmap[e->id] != NULL);
		assert(globals::ASTEmap[f->id] != NULL);
		assert(globals::ASTEmap[i->id] != NULL);
		globals::ASTEmap[c->id]->parentActivityId = myid;
		globals::ASTEmap[d->id]->parentActivityId = myid;
		globals::ASTEmap[e->id]->parentActivityId = myid;
		globals::ASTEmap[f->id]->parentActivityId = myid;
		globals::ASTEmap[i->id]->parentActivityId = myid;

		myself->enclosedFH = c->id;
		myself->enclosedCH = d->id;

		globals::ASTEmap[c->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[d->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[e->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[f->id]->max_occurrences = myself->max_occurrences;
		globals::ASTEmap[i->id]->max_occurrences = myself->max_occurrences;


		if (myself->attributes["name"] != "")
		{

		    if (globals::ASTE_scopeNames[myself->attributes["name"]] != 0)
		    SAerror(92, myself->attributes["name"], myself->attributes["referenceLine"]);

		    globals::ASTE_scopeNames[myself->attributes["name"]] = myid;
		}


		if (myself->attributes["isolated"] == "yes" &&
		    globals::ASTEmap[myself->parentScopeId]->findIsolatedAncestor())
		SAerror(91, "", myself->attributes["referenceLine"]);

#line  10342 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
		kc::unparse(messageExchange, kc_printer, kc_current_view);
		kc::unparse(j, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
#line 2260 "ast-postprocess.k"


		bool callableFH = false;
		for ( set< string >::iterator fault = globals::ASTEmap[ c->id ]->catches.begin(); fault != globals::ASTEmap[ c->id ]->catches.end(); fault++)
		{
		    string faultName = fault->substr( fault->find_first_of( "|" ) + 1 );
		    faultName = faultName.substr( 0, faultName.find_first_of( "|" ) );
		    if (faultName.find_first_of(":") < faultName.npos)
		    {
			faultName = faultName.substr( faultName.find_first_of(":") + 1 );
		    }

		    if ( myself->possiblyTriggeredFaults.find( faultName ) != myself->possiblyTriggeredFaults.end() )
		    {
			callableFH = true;


		    }
		}
		if ( globals::ASTEmap[ c->id ]->hasCatchAll && ! myself->possiblyTriggeredFaults.empty() )
		{
		    callableFH = true;
		}

		globals::ASTEmap[ c->id ]->callable = callableFH;

		set< unsigned int > innerIds = globals::ASTEmap[ i->id ]->enclosedActivities;
		innerIds.insert( i->id );
		set< unsigned int > faultIds = globals::ASTEmap[ c->id ]->enclosedActivities;
		faultIds.insert( c->id );
		set< unsigned int > compIds = globals::ASTEmap[ d->id ]->enclosedActivities;
		compIds.insert( d->id );

		enterConflictingActivities( innerIds, faultIds );
		enterConflictingActivities( faultIds, compIds );


		globals::ASTEmap[d->id]->enclosedScopes = myself->enclosedScopes;


		assert(globals::ASTEmap[i->id] != NULL);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[i->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[c->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[d->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[e->id]->enclosedSourceLinks);
		myself->enclosedSourceLinks = setUnion(myself->enclosedSourceLinks, globals::ASTEmap[f->id]->enclosedSourceLinks);

		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[i->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[c->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[d->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[e->id]->enclosedTargetLinks);
		myself->enclosedTargetLinks = setUnion(myself->enclosedTargetLinks, globals::ASTEmap[f->id]->enclosedTargetLinks);



		globals::PPcurrentScope = myself->parentScopeId;

		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myid );
		globals::ASTEmap[ myself->parentActivityId ]->enclosedActivities.insert( myself->enclosedActivities.begin(), myself->enclosedActivities.end() );
		enterEnclosedActivities( myid, globals::ASTEmap[ myid ]->enclosedActivities );



		if ( (modus == M_PETRINET || modus == M_CHOREOGRAPHY)
		    && globals::parameters[P_COMMUNICATIONONLY] )
		genericError(120, "", myself->attributes["referenceLine"], ERRORLEVEL_NOTICE);

#line  10421 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 855 "ast-to-cfg.k"
		const standardElements a = this->standardElements_1;
#line 855 "ast-to-cfg.k"
		const tVariable_list b = this->tVariable_list_1;
#line 855 "ast-to-cfg.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 855 "ast-to-cfg.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 855 "ast-to-cfg.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 855 "ast-to-cfg.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 855 "ast-to-cfg.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 855 "ast-to-cfg.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 855 "ast-to-cfg.k"
		const activity i = this->activity_1;
#line 855 "ast-to-cfg.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 855 "ast-to-cfg.k"
		const integer _id = this->integer_1;
#line 856 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] Scope\n");
		CFGBlock * firstBlock = new CFGBlock(CFGScope, this->id, "Scope_begin"); 
		CFGBlock * lastBlock = new CFGBlock(CFGScope, this->id, "Scope_end");

		firstBlock->firstBlock = lastBlock->firstBlock = firstBlock;
		firstBlock->lastBlock  = lastBlock->lastBlock  = lastBlock;

		globals::cfgMap[toString(this->id)] = firstBlock; 

#line  10461 "ast-system-unpk.cc"
		kc::unparse(c, kc_printer, kc_current_view);
#line 867 "ast-to-cfg.k"

		CFGBlock * fhFirst = globals::cfgMap.find(toString(c->id))->second->firstBlock;
		CFGBlock * fhLast  = globals::cfgMap.find(toString(c->id))->second->lastBlock;

		connectBlocks(firstBlock, fhFirst);
		connectBlocks(fhLast, lastBlock);


#line  10472 "ast-system-unpk.cc"
		kc::unparse(d, kc_printer, kc_current_view);
#line 876 "ast-to-cfg.k"

		CFGBlock * chFirst = globals::cfgMap.find(toString(d->id))->second->firstBlock;
		CFGBlock * chLast  = globals::cfgMap.find(toString(d->id))->second->lastBlock;

		connectBlocks(firstBlock, chFirst);
		connectBlocks(chLast, lastBlock);


#line  10483 "ast-system-unpk.cc"
		kc::unparse(e, kc_printer, kc_current_view);
#line 885 "ast-to-cfg.k"

		CFGBlock * thFirst = globals::cfgMap.find(toString(e->id))->second->firstBlock;
		CFGBlock * thLast  = globals::cfgMap.find(toString(e->id))->second->lastBlock;

		connectBlocks(firstBlock, thFirst);
		connectBlocks(thLast, lastBlock);


#line  10494 "ast-system-unpk.cc"
		kc::unparse(f, kc_printer, kc_current_view);
#line 894 "ast-to-cfg.k"

		CFGBlock * ehFirst = globals::cfgMap.find(toString(f->id))->second->firstBlock;
		CFGBlock * ehLast  = globals::cfgMap.find(toString(f->id))->second->lastBlock;

		connectBlocks(firstBlock, ehFirst);
		connectBlocks(ehLast, lastBlock);


#line  10505 "ast-system-unpk.cc"
		kc::unparse(i, kc_printer, kc_current_view);
#line 903 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(i->id))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(i->id))->second->lastBlock;

		connectBlocks(firstBlock, innerFirst);
		connectBlocks(innerLast, lastBlock);

#line  10515 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
#line 911 "ast-to-cfg.k"

		trace(TRACE_DEBUG, "[CFG] ~Scope\n");

#line  10521 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 457 "ast-to-xml.k"
		const standardElements a = this->standardElements_1;
#line 457 "ast-to-xml.k"
		const tVariable_list b = this->tVariable_list_1;
#line 457 "ast-to-xml.k"
		const tMessageExchange_list messageExchange = this->tMessageExchange_list_1;
#line 457 "ast-to-xml.k"
		const tFaultHandlers c = this->tFaultHandlers_1;
#line 457 "ast-to-xml.k"
		const tCompensationHandler d = this->tCompensationHandler_1;
#line 457 "ast-to-xml.k"
		const tTerminationHandler e = this->tTerminationHandler_1;
#line 457 "ast-to-xml.k"
		const tEventHandlers f = this->tEventHandlers_1;
#line 457 "ast-to-xml.k"
		const tCorrelationSet_list g = this->tCorrelationSet_list_1;
#line 457 "ast-to-xml.k"
		const activity i = this->activity_1;
#line 457 "ast-to-xml.k"
		const tPartnerLink_list j = this->tPartnerLink_list_1;
#line 457 "ast-to-xml.k"
		const integer _id = this->integer_1;
#line 458 "ast-to-xml.k"
		inup(); 
#line  10552 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<scope id=\""), kc_current_view); }
		kc::unparse(_id, kc_printer, kc_current_view);
		{ kc_printer(kc_t("\""), kc_current_view); }
#line 458 "ast-to-xml.k"
		listAttributes( _id ); 
#line  10558 "ast-system-unpk.cc"
			{ kc_printer(kc_t(">\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 462 "ast-to-xml.k"
		if (b->length() == 0) 
#line  10563 "ast-system-unpk.cc"
		{
		}
#line 464 "ast-to-xml.k"
		else 
#line  10568 "ast-system-unpk.cc"
		{
#line 465 "ast-to-xml.k"
		    inup(); 
#line  10572 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("<variables id=\""), kc_current_view); }
		    kc::unparse(_id, kc_printer, kc_current_view);
		    { kc_printer(kc_t("\">\n"), kc_current_view); }
		    kc::unparse(b, kc_printer, kc_current_view);
#line 465 "ast-to-xml.k"
		    indown(); 
#line  10579 "ast-system-unpk.cc"
		    	{ kc_printer(kc_t("</variables>\n"), kc_current_view); }
		}
		kc::unparse(c, kc_printer, kc_current_view);
		kc::unparse(d, kc_printer, kc_current_view);
		kc::unparse(e, kc_printer, kc_current_view);
		kc::unparse(f, kc_printer, kc_current_view);
		kc::unparse(g, kc_printer, kc_current_view);
		kc::unparse(i, kc_printer, kc_current_view);
#line 469 "ast-to-xml.k"
		indown(); 
#line  10590 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</scope>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    {
#line 171 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10600 "ast-system-unpk.cc"
	    }
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    {
#line 171 "ast-to-petrinet.k"
		PScope(this, kc_current_view_base); 
#line  10609 "ast-system-unpk.cc"
	    }
	    break;
	}

#line  10614 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  10627 "ast-system-unpk.cc"
void
impl_standardElements_NoStandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  10633 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  10645 "ast-system-unpk.cc"
void
impl_standardElements_StandardElements::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 919 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 920 "ast-to-visualization.k"
		const tSource_list a = this->tSource_list_1;
#line 920 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 921 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 921 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
	    {
#line 922 "ast-to-visualization.k"
		const tTarget_list a = this->tTarget_list_1;
#line 922 "ast-to-visualization.k"
		const tSource_list b = this->tSource_list_1;
#line 922 "ast-to-visualization.k"
		const joinCondition jc = this->joinCondition_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2335 "ast-postprocess.k"
		const tTarget_list a = this->tTarget_list_1;
#line 2335 "ast-postprocess.k"
		const tSource_list b = this->tSource_list_1;
#line 2335 "ast-postprocess.k"
		const joinCondition _joinCondition = this->joinCondition_1;
#line 2337 "ast-postprocess.k"

		assert(globals::ASTEmap[this->parentId] != NULL);
		this->suppressJF = (globals::ASTEmap[this->parentId]->attributes["suppressJoinFailure"] == "yes");


		_joinCondition->parentId = this->parentId;

#line  10695 "ast-system-unpk.cc"
		kc::unparse(_joinCondition, kc_printer, kc_current_view);
#line 2345 "ast-postprocess.k"

		unsigned int linkCount = 0;
		{
#line 2347 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10704 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2347 "ast-postprocess.k"
			    {
				{
#line 2348 "ast-postprocess.k"
#line 2347 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2348 "ast-postprocess.k"

				    assert(globals::ASTEmap[targetLink->id] != NULL);
				    globals::ASTEmap[targetLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[targetLink->id]->parentActivityId = this->parentId;


				    globals::joinCondition_links[globals::ASTEmap[targetLink->id]->attributes["linkName"]] = ++linkCount; 

#line  10725 "ast-system-unpk.cc"
				}
			    }

#line  10729 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2347 "ast-postprocess.k"

#line  10734 "ast-system-unpk.cc"
		    }
		}
#line 2356 "ast-postprocess.k"

		{
#line 2357 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10743 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2357 "ast-postprocess.k"
			    {
				{
#line 2358 "ast-postprocess.k"
#line 2357 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2358 "ast-postprocess.k"

				    assert(globals::ASTEmap[sourceLink->id] != NULL);
				    globals::ASTEmap[sourceLink->id]->controlFlow = globals::ASTEmap[this->parentId]->controlFlow;
				    globals::ASTEmap[sourceLink->id]->parentActivityId = this->parentId;

#line  10761 "ast-system-unpk.cc"
				}
			    }

#line  10765 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2357 "ast-postprocess.k"

#line  10770 "ast-system-unpk.cc"
		    }
		}
#line 2363 "ast-postprocess.k"











		unsigned int assignments = (unsigned int)pow(2.0, a->length());
		for (unsigned int assignment = 0; assignment < assignments; assignment++)
		{

		    for (unsigned int link = 0; link < linkCount; link++)
		    {
			if (((assignment >> link) % 2) == 0) 
			globals::joinCondition_linkStatus[link] = true;
			else
			globals::joinCondition_linkStatus[link] = false;
		    }


		    _joinCondition->unparse(pseudoPrinter, evaluation);


		    {
#line 2390 "ast-postprocess.k"
			joinCondition kc_selvar_0_1 = phylum_cast<joinCondition>(_joinCondition);
#line 2393 "ast-postprocess.k"
			if ((kc_selvar_0_1->prod_sel() == sel_userDefinedJoinCondition)) {
#line 2393 "ast-postprocess.k"
#line 2392 "ast-postprocess.k"
			    const joinCondition _joinCondition = kc_selvar_0_1;
#line 2392 "ast-postprocess.k"
			    const expression _exp = phylum_cast<const impl_joinCondition_userDefinedJoinCondition*>(kc_selvar_0_1)->expression_1;
#line 2393 "ast-postprocess.k"
			    globals::joinCondition_result[_joinCondition->parentId][assignment] = _exp->value; 
#line  10813 "ast-system-unpk.cc"
			    	} else
			{
#line 2394 "ast-postprocess.k"
#line 2394 "ast-postprocess.k"

#line  10819 "ast-system-unpk.cc"
			}
		    }
#line 2396 "ast-postprocess.k"
		}


		globals::joinCondition_links.clear();
		globals::joinCondition_linkStatus.clear();


#line  10830 "ast-system-unpk.cc"
		kc::unparse(a, kc_printer, kc_current_view);
		kc::unparse(b, kc_printer, kc_current_view);
#line 2404 "ast-postprocess.k"


		set<string> targetLinks;
		{
#line 2407 "ast-postprocess.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10841 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 2407 "ast-postprocess.k"
			    {
				{
#line 2408 "ast-postprocess.k"
#line 2407 "ast-postprocess.k"
				    const tTarget targetLink = kc_selvar_0_1;
#line 2408 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[targetLink->id]->linkName;
				    if (targetLinks.find(linkName) != targetLinks.end())
				    SAerror(69, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    targetLinks.insert(linkName);

#line  10863 "ast-system-unpk.cc"
				}
			    }

#line  10867 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 2407 "ast-postprocess.k"

#line  10872 "ast-system-unpk.cc"
		    }
		}
#line 2417 "ast-postprocess.k"

		set<string> sourceLinks;
		{
#line 2419 "ast-postprocess.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10882 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 2419 "ast-postprocess.k"
			    {
				{
#line 2420 "ast-postprocess.k"
#line 2419 "ast-postprocess.k"
				    const tSource sourceLink = kc_selvar_0_1;
#line 2420 "ast-postprocess.k"


				    string linkName = globals::ASTEmap[sourceLink->id]->linkName;
				    if (sourceLinks.find(linkName) != sourceLinks.end())
				    SAerror(68, "<" + globals::ASTEmap[this->parentId]->activityTypeName() + "> must not use <link> `" +
					linkName + "'", globals::ASTEmap[globals::ASTE_linkIdMap[linkName]]->attributes["referenceLine"]);
				    else
				    sourceLinks.insert(linkName);

#line  10904 "ast-system-unpk.cc"
				}
			    }

#line  10908 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 2419 "ast-postprocess.k"

#line  10913 "ast-system-unpk.cc"
		    }
		}
#line 2429 "ast-postprocess.k"


#line  10919 "ast-system-unpk.cc"
	    }
	    break;
	}
	case cfg_enum: {
	    cfg_class& kc_current_view=static_cast<cfg_class&>(kc_current_view_base);
	    {
#line 922 "ast-to-cfg.k"
		const standardElements This = this/**/;
#line 922 "ast-to-cfg.k"
		const tTarget_list a = this->tTarget_list_1;
#line 922 "ast-to-cfg.k"
		const tSource_list b = this->tSource_list_1;
#line 922 "ast-to-cfg.k"
		const joinCondition jc = this->joinCondition_1;
#line 924 "ast-to-cfg.k"

		CFGBlock * innerFirst = globals::cfgMap.find(toString(This->parentId))->second->firstBlock;
		CFGBlock * innerLast = globals::cfgMap.find(toString(This->parentId))->second->lastBlock;
		{
#line 927 "ast-to-cfg.k"
		    tTarget_list kc_fe_selvar_1 =  a;

#line  10942 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstTarget_list
			) {
			tTarget kc_selvar_0_1 = kc_fe_selvar_1->tTarget_1;
			{
#line 927 "ast-to-cfg.k"
			    {
				{
#line 928 "ast-to-cfg.k"
#line 927 "ast-to-cfg.k"
				    const tTarget link = kc_selvar_0_1;
#line 928 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Target\n");



				    CFGBlock * target = new CFGBlock(CFGTarget, link->id, "Target_" + globals::ASTEmap[link->id]->linkName);

				    targets["Source_" + globals::ASTEmap[link->id]->linkName] = target;









				    connectBlocks(target, innerFirst->firstBlock);
				    innerFirst->firstBlock = target;
				    target->lastBlock = innerLast->lastBlock;

#line  10976 "ast-system-unpk.cc"
				}
			    }

#line  10980 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tTarget_list_1;
#line 927 "ast-to-cfg.k"

#line  10985 "ast-system-unpk.cc"
		    }
		}
#line 949 "ast-to-cfg.k"

		{
#line 950 "ast-to-cfg.k"
		    tSource_list kc_fe_selvar_1 =  b;

#line  10994 "ast-system-unpk.cc"
		    while(
			    kc_fe_selvar_1->prod_sel() == sel_ConstSource_list
			) {
			tSource kc_selvar_0_1 = kc_fe_selvar_1->tSource_1;
			{
#line 950 "ast-to-cfg.k"
			    {
				{
#line 951 "ast-to-cfg.k"
#line 950 "ast-to-cfg.k"
				    const tSource link = kc_selvar_0_1;
#line 951 "ast-to-cfg.k"

				    trace(TRACE_DEBUG, "[CFG] Source\n");



				    CFGBlock * source = new CFGBlock(CFGSource, link->id, "Source_" + globals::ASTEmap[link->id]->linkName);

				    sources["Target_" + globals::ASTEmap[link->id]->linkName] = source;













				    connectBlocks(innerLast->lastBlock, source);
				    innerLast->lastBlock = innerFirst->lastBlock = source;

				    innerFirst->firstBlock->lastBlock = source;
				    trace(TRACE_DEBUG, "[CFG] ~Source\n");


#line  11035 "ast-system-unpk.cc"
				}
			    }

#line  11039 "ast-system-unpk.cc"
			}
			kc_fe_selvar_1 = kc_fe_selvar_1->tSource_list_1;
#line 950 "ast-to-cfg.k"

#line  11044 "ast-system-unpk.cc"
		    }
		}
#line 979 "ast-to-cfg.k"



#line  11051 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 477 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
	    } else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 478 "ast-to-xml.k"
		const tSource_list a = this->tSource_list_1;
#line 478 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 478 "ast-to-xml.k"
		inup(); 
#line  11068 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 478 "ast-to-xml.k"
		indown(); 
#line  11073 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    } else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 479 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 479 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 479 "ast-to-xml.k"
		inup(); 
#line  11083 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 479 "ast-to-xml.k"
		indown(); 
#line  11088 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
	    } else
	    {
#line 480 "ast-to-xml.k"
		const tTarget_list a = this->tTarget_list_1;
#line 480 "ast-to-xml.k"
		const tSource_list b = this->tSource_list_1;
#line 480 "ast-to-xml.k"
		const joinCondition jc = this->joinCondition_1;
#line 480 "ast-to-xml.k"
		inup(); 
#line  11100 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<targets>\n"), kc_current_view); }
		kc::unparse(a, kc_printer, kc_current_view);
#line 480 "ast-to-xml.k"
		indown(); 
#line  11105 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</targets>\n"), kc_current_view); }
#line 480 "ast-to-xml.k"
		inup(); 
#line  11109 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<sources>\n"), kc_current_view); }
		kc::unparse(b, kc_printer, kc_current_view);
#line 480 "ast-to-xml.k"
		indown(); 
#line  11114 "ast-system-unpk.cc"
			{ kc_printer(kc_t("</sources>\n"), kc_current_view); }
	    }
	    break;
	}
	case petrinetnew_enum: {
	    petrinetnew_class& kc_current_view=static_cast<petrinetnew_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 210 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 211 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11126 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 214 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 214 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 215 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11135 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 218, this))) {
#line 218 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 218 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 218 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 219 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11146 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 222, this))) {
#line 222 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 222 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 222 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 223 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11157 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 226, this))) {
#line 226 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 226 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 226 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 226 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 227 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11170 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 230, this))) {
#line 230 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 230 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 230 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 230 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 231 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11183 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}
	case petrinetsmall_enum: {
	    petrinetsmall_class& kc_current_view=static_cast<petrinetsmall_class&>(kc_current_view_base);
	    if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list) && (this->tSource_list_1->prod_sel() == sel_NiltSource_list)) {
#line 210 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 211 "ast-to-petrinet.k"
		P_LinkWrapper0(this, kc_current_view_base); 
#line  11195 "ast-system-unpk.cc"
			} else
		if ((this->tTarget_list_1->prod_sel() == sel_NiltTarget_list)) {
#line 214 "ast-to-petrinet.k"
		const tSource_list a = this->tSource_list_1;
#line 214 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 215 "ast-to-petrinet.k"
		P_LinkWrapper1(this, kc_current_view_base); 
#line  11204 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 218, this))) {
#line 218 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 218 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 218 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 219 "ast-to-petrinet.k"
		P_LinkWrapper2(this, kc_current_view_base); 
#line  11215 "ast-system-unpk.cc"
			} else
		if ((this->tSource_list_1->prod_sel() == sel_NiltSource_list) && (KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 222, this))) {
#line 222 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 222 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 222 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 223 "ast-to-petrinet.k"
		P_LinkWrapper3(this, kc_current_view_base); 
#line  11226 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((this/**/->suppressJF), "ast-to-petrinet.k", 226, this))) {
#line 226 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 226 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 226 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 226 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 227 "ast-to-petrinet.k"
		P_LinkWrapper4(this, kc_current_view_base); 
#line  11239 "ast-system-unpk.cc"
			} else
		if ((KC_TRACE_PROVIDED((!this/**/->suppressJF), "ast-to-petrinet.k", 230, this))) {
#line 230 "ast-to-petrinet.k"
		const standardElements This = this/**/;
#line 230 "ast-to-petrinet.k"
		const tTarget_list a = this->tTarget_list_1;
#line 230 "ast-to-petrinet.k"
		const tSource_list b = this->tSource_list_1;
#line 230 "ast-to-petrinet.k"
		const joinCondition jc = this->joinCondition_1;
#line 231 "ast-to-petrinet.k"
		P_LinkWrapper5(this, kc_current_view_base); 
#line  11252 "ast-system-unpk.cc"
			} else
		    goto kc_unparsing_default;
	    break;
	}

#line  11258 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11279 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tTarget_list iterator_ = this; iterator_->tTarget_list_1 != 0; iterator_ = iterator_->tTarget_list_1)
		    iterator_->tTarget_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tTarget_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11298 "ast-system-unpk.cc"
	default:
	kc_unparsing_default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11311 "ast-system-unpk.cc"
void
impl_tTarget_Target::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 924 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2434 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2436 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();



		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedTargetLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->targetLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->targetActivity != 0) 
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->targetActivity = myself->parentActivityId;
		}

		if ( myself->attributes["suppressJoinFailure"]  == "no" )
		{
		    globals::ASTEmap[ myself->parentScopeId]->enterFault( "joinFailure" );
		}

#line  11360 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 482 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 483 "ast-to-xml.k"
		in(); 
#line  11371 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<target"), kc_current_view); }
#line 483 "ast-to-xml.k"
		listAttributes( a ); 
#line  11375 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11381 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}

void
impl_tSource_list::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    if(is_nil())
	nil_do_unparse(kc_printer, kc_current_view_base);
    else
	switch(kc_current_view_base) {

#line  11401 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		for (tSource_list iterator_ = this; iterator_->tSource_list_1 != 0; iterator_ = iterator_->tSource_list_1)
		    iterator_->tSource_1->unparse(kc_printer, kc_current_view);
	    }
	    break;
	}
    }
}

void
impl_tSource_list::nil_do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11419 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11431 "ast-system-unpk.cc"
void
impl_tSource_Source::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case visualization_enum: {
	    visualization_class& kc_current_view=static_cast<visualization_class&>(kc_current_view_base);
	    {
#line 928 "ast-to-visualization.k"
		const integer a = this->integer_1;
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2469 "ast-postprocess.k"
		const integer a = this->integer_1;
#line 2471 "ast-postprocess.k"

		ASTE *myself = globals::ASTEmap[this->id];
		assert(myself != NULL);

		myself->checkAttributes();
		myself->linkName = myself->checkLink();




		assert(globals::ASTEmap[myself->parentActivityId] != NULL);
		unsigned int linkId = globals::ASTE_linkIdMap[ myself->linkName ];
		globals::ASTEmap[myself->parentActivityId]->enclosedSourceLinks.insert(linkId);
		globals::ASTEmap[myself->parentActivityId]->sourceLinks.insert(linkId);


		assert(globals::ASTEmap[linkId] != NULL);
		if (globals::ASTEmap[linkId]->sourceActivity != 0)
		{
		    SAerror(66, myself->attributes["linkName"], myself->attributes["referenceLine"]);
		}
		else
		{
		    globals::ASTEmap[linkId]->sourceActivity = myself->parentActivityId;
		}

#line  11476 "ast-system-unpk.cc"
	    }
	    break;
	}
	case xml_enum: {
	    xml_class& kc_current_view=static_cast<xml_class&>(kc_current_view_base);
	    {
#line 486 "ast-to-xml.k"
		const integer a = this->integer_1;
#line 487 "ast-to-xml.k"
		in(); 
#line  11487 "ast-system-unpk.cc"
			{ kc_printer(kc_t("<source"), kc_current_view); }
#line 487 "ast-to-xml.k"
		listAttributes( a ); 
#line  11491 "ast-system-unpk.cc"
			{ kc_printer(kc_t(" />\n"), kc_current_view); }
	    }
	    break;
	}

#line  11497 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11510 "ast-system-unpk.cc"
void
impl_joinCondition_userDefinedJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2500 "ast-postprocess.k"
		const expression _exp = this->expression_1;
#line 2502 "ast-postprocess.k"
		_exp->parentId = this->parentId; 
#line  11522 "ast-system-unpk.cc"
		kc::unparse(_exp, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11528 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11541 "ast-system-unpk.cc"
void
impl_joinCondition_standardJoinCondition::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {

#line  11547 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
	    }
	    break;
	}
    }
}


#line  11559 "ast-system-unpk.cc"
void
impl_expression_Disjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2562 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2562 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2566 "ast-postprocess.k"
		this->value = (_exp1->value || _exp2->value); 
#line  11575 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2514 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2514 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2516 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11588 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11595 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11608 "ast-system-unpk.cc"
void
impl_expression_Conjunction::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2554 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2554 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
#line 2558 "ast-postprocess.k"
		this->value = (_exp1->value && _exp2->value); 
#line  11624 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2507 "ast-postprocess.k"
		const expression _exp1 = this->expression_1;
#line 2507 "ast-postprocess.k"
		const expression _exp2 = this->expression_2;
#line 2509 "ast-postprocess.k"
		_exp1->parentId = _exp2->parentId = this->parentId; 
#line  11637 "ast-system-unpk.cc"
		kc::unparse(_exp1, kc_printer, kc_current_view);
		kc::unparse(_exp2, kc_printer, kc_current_view);
	    }
	    break;
	}

#line  11644 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


#line  11657 "ast-system-unpk.cc"
void
impl_expression_Term::do_unparse(printer_functor kc_printer, uview kc_current_view_base)
{
    switch(kc_current_view_base) {
	case evaluation_enum: {
	    evaluation_class& kc_current_view=static_cast<evaluation_class&>(kc_current_view_base);
	    {
#line 2530 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
#line 2532 "ast-postprocess.k"


		string linkname_string = string(_linkname->name);
		if (linkname_string[0] == '$')
		linkname_string = linkname_string.substr(1, linkname_string.length() -1);



		if (globals::joinCondition_links[linkname_string] == 0)
		{
		    assert(globals::ASTEmap[this->parentId] != NULL);
		    SAerror(73, linkname_string, globals::ASTEmap[this->parentId]->attributes["referenceLine"]);
		}
		else
		{

		    this->value = globals::joinCondition_linkStatus[globals::joinCondition_links[linkname_string] -1];
		}

#line  11687 "ast-system-unpk.cc"
	    }
	    break;
	}
	case postprocessing_enum: {
	    postprocessing_class& kc_current_view=static_cast<postprocessing_class&>(kc_current_view_base);
	    {
#line 2521 "ast-postprocess.k"
		const casestring _linkname = this->casestring_1;
	    }
	    break;
	}

#line  11700 "ast-system-unpk.cc"
	default:
	case base_uview_enum: {
	    uview kc_current_view=kc_current_view_base;
	    {
		default_unparse(kc_printer, kc_current_view );
	    }
	    break;
	}
    }
}


} // namespace kc
