;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: CLUEI; Base: 10; -*-

;;; 06/01/1992 (Juergen) 
;;;
;;; The following patch is necessary for X11R5 when backing-store :always
;;; is used, since unlike in X11R4 and OpenWindows no exposure events are
;;; generated when a window is mapped for the first time.
 
(in-package :cluei)

(defun realize-state (contact)
  "Make the initial contact-state of a newly-realized CONTACT effective."
  (multiple-value-bind (old-state new-state) (initial-state-transition contact)
    (when old-state
      ;; Problem:  This is a special case because the value of state slot after
      ;;           initialization is not yet in effect and doesn't reflect reality.
      ;; Solution: Temporarily set initial value of state slot to reality (i.e. old-state)     
      ;;           so that (setf contact-state) will take effect correctly.
      (setf (slot-value (the contact contact) 'state) old-state)
      (setf (contact-state contact) new-state)))
  ;;06/01/1992 (Juergen) ***
  (update-backing-store contact)
  )

(defmethod update-backing-store ((self basic-contact))
  ;; nothing to do here
  nil)

(defmethod update-backing-store ((self contact))
  (when (eq (window-backing-store self) :always)
    (display self)))



