;;; -*- Mode:Lisp; Package:CLUEI; Syntax:COMMON-LISP; Base:10; Lowercase:T; Patch-File: T;  -*-

(in-package "CLUEI")

(defun get-contact-resource-table (class-name parent initargs)
  ;; Get the resource database table
  ;;
  ;; Note: This is called with a null parent when class-name is ROOT, in which case
  ;;       this will lose unless INITARGS contains :complete-name and :complete-class.
  ;;
  ;; Patched [Hubertus 9/18/90]:
  ;; To lookup a resource search table, a complete contact name is needed.
  ;; However if :name is not supplied in the initargs, the class-name is used
  ;; as the name of the contact which will be instantiated afterwards.
  ;; This means that the found search table did not contain resource values for
  ;; resource specifications of the form (... <contact-name> <attribute-name>).
  ;; The patched version tries to infer the contact name of the contact
  ;; which will be instantiated from the resource database itself or from
  ;; a resource-list stored as a property of the class-name.
  ;; 
  
  (declare (special *database*))
  (get-search-table
    *database*
    (or (getf initargs :complete-name)
	(contact-complete-name parent
			       ;;***************************
;				      (or (getf initargs :name)
;						 class-name)
			       (get-contact-name-from class-name parent initargs)))
    (or (getf initargs :complete-class)
	(contact-complete-class parent class-name))))

(defun get-contact-name-from (class-name parent initargs)
  ;; returns the name of the contact of a class specified by class-name.

  (or ;; ok if name supplied
    (getf initargs :name)

    ;; try looking up name in resource database (name is a resource-slot!)
    (get-resource *database* 'name 't
		  (or (getf initargs :complete-name)
		      (contact-complete-name parent class-name))
		  (or (getf initargs :complete-class)
		      (contact-complete-class parent class-name)))
	
    ;; lookup name from the resource-list supplied by defcontact
    (getf (cdr (assoc :name (clue-resources class-name))) :initform)
	
    ;; finally we use the class-name as contact name
    class-name))