/*
*  EDMA Advanced Class GENERIC_PROXY
* EDMA: Entorno de Desarrollo Modular y Abierto
* Object Oriented and Componetware Framework
* Copyright (C) 23 January 2011
*    David Martnez Oliveira
*
* This file is part of GNU/EDMA System Classes
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with program.  If not, see <http://www.gnu.org/licenses/>.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : GENERIC_PROXY
    Description : SIU Proxy base clase
    Author      : David Martnez Oliveira
    Date        : 23 January 2011
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class GENERIC_PROXY
***************************************************
*/
 
typedef struct
{
	OBJID		obj;
}DtGENERIC_PROXY;
/*
***************************************************
  Method Declaration for class GENERIC_PROXY
***************************************************
*/
 
ESint32 EDMAPROC
GENERIC_PROXYNewObjZ(OBJID IdObj, EPChar classname )
{
  DtGENERIC_PROXY	*m;

  m = (DtGENERIC_PROXY *) edma_get_data_ref (IdObj);
  m->obj = edma_new_obj (classname);
  return 0;
}


ESint32 EDMAPROC
GENERIC_PROXYFreeObjO(OBJID IdObj)
{
  DtGENERIC_PROXY	*m;

  m = (DtGENERIC_PROXY *) edma_get_data_ref (IdObj);
  edma_free_obj (m->obj);
  return 0;
}


ESint32 EDMAPROC
GENERIC_PROXYWProp3OZP(OBJID IdObj, EPChar Prop, EPVoid val)
{
  DtGENERIC_PROXY	*m;

  m = (DtGENERIC_PROXY *) edma_get_data_ref (IdObj);

  return edma_wprop3_pargs (m->obj, Prop, val);
}


ESint32 EDMAPROC
GENERIC_PROXYRProp3OZP(OBJID IdObj, EPChar Prop, EPVoid val)
{
  DtGENERIC_PROXY	*m;

  m = (DtGENERIC_PROXY *) edma_get_data_ref (IdObj);
  return edma_rprop3_pargs (m->obj, Prop, val);

}


ESint32 EDMAPROC
GENERIC_PROXYMet3OZP(OBJID IdObj, EPChar met_name, EPVoid val)
{
  DtGENERIC_PROXY	*m;

  m = (DtGENERIC_PROXY *) edma_get_data_ref (IdObj);

  return edma_met3_pargs (m->obj, met_name, NULL, 1, val);
}


ESint32
GENERIC_PROXY_class_factory ()
{
  CLASSID    cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);
  
  edma_idf_set_class_name (cid, "GENERIC_PROXY");
  
  edma_idf_set_class_namespace (cid, "system");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_property (cid, "obj", DT_EOBJECT, E_L, 0);
  
  
  /* Method registration */
  edma_add_local_class_method (cid, "NewObj", "Z", (PPROC)GENERIC_PROXYNewObjZ, 0, 0, 0);
  edma_add_local_class_method (cid, "FreeObj", "O", (PPROC)GENERIC_PROXYFreeObjO, 0, 0, 0);
  edma_add_local_class_method (cid, "WProp3", "OZP", (PPROC)GENERIC_PROXYWProp3OZP, 0, 0, 0);
  edma_add_local_class_method (cid, "RProp3", "OZP", (PPROC)GENERIC_PROXYRProp3OZP, 0, 0, 0);
  edma_add_local_class_method (cid, "Met3", "OZP", (PPROC)GENERIC_PROXYMet3OZP, 0, 0, 0);
  
  edma_idf_set_class_id (cid);
  
  return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
