#line 1 "./prim"
\ Gforth primitives

\ Copyright (C) 1995,1996,1997,1998,2000,2003 Free Software Foundation, Inc.

\ This file is part of Gforth.

\ Gforth is free software; you can redistribute it and/or
\ modify it under the terms of the GNU General Public License
\ as published by the Free Software Foundation; either version 2
\ of the License, or (at your option) any later version.

\ This program is distributed in the hope that it will be useful,
\ but WITHOUT ANY WARRANTY; without even the implied warranty of
\ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
\ GNU General Public License for more details.

\ You should have received a copy of the GNU General Public License
\ along with this program; if not, write to the Free Software
\ Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.


\ WARNING: This file is processed by m4. Make sure your identifiers
\ don't collide with m4's (e.g. by undefining them).
\ 
\ 
\ 
\ This file contains primitive specifications in the following :
\ 
\ forth name	( stack effect )	category	[pronunciation]
\ [""glossary entry""]
\ C code
\ [:
\ Forth code]
\ 
\ Note: Fields in brackets are optional.  Word specifications have to
\ be separated by at least one empty line
\
\ Both pronounciation and stack items (in the stack effect) must
\ conform to the C identifier syntax or the C compiler will complain.
\ If you don't have a pronounciation field, the Forth name is used,
\ and has to conform to the C identifier syntax.
\ 
\ These specifications are automatically translated into C-code for the
\ interpreter and into some other files. I hope that your C compiler has
\ decent optimization, otherwise the automatically generated code will
\ be somewhat slow. The Forth version of the code is included for manual
\ compilers, so they will need to compile only the important words.
\ 
\ Note that stack pointer adjustment is performed according to stack
\ effect by automatically generated code and NEXT is automatically
\ appended to the C code. Also, you can use the names in the stack
\ effect in the C code. Stack access is automatic. One exception: if
\ your code does not fall through, the results are not stored into the
\ stack. Use different names on both sides of the '--', if you change a
\ value (some stores to the stack are optimized away).
\
\ For superinstructions the syntax is:
\
\ forth-name [/ c-name] = forth-name forth-name ...
\
\ 
\ The stack variables have the following types:
\ 
\ name matches	type
\ f.*		Bool
\ c.*		Char
\ [nw].*	Cell
\ u.*		UCell
\ d.*		DCell
\ ud.*		UDCell
\ r.*		Float
\ a_.*		Cell *
\ c_.*		Char *
\ f_.*		Float *
\ df_.*		DFloat *
\ sf_.*		SFloat *
\ xt.*		XT
\ f83name.*	F83Name *

\E stack data-stack   sp Cell
\E stack fp-stack     fp Float
\E stack return-stack rp Cell
\E
\E get-current prefixes set-current
\E 
\E s" Bool"		single data-stack type-prefix f
\E s" Char"		single data-stack type-prefix c
\E s" Cell"		single data-stack type-prefix n
\E s" Cell"		single data-stack type-prefix w
\E s" UCell"		single data-stack type-prefix u
\E s" DCell"		double data-stack type-prefix d
\E s" UDCell"		double data-stack type-prefix ud
\E s" Float"		single fp-stack   type-prefix r
\E s" Cell *"		single data-stack type-prefix a_
\E s" Char *"		single data-stack type-prefix c_
\E s" Float *"		single data-stack type-prefix f_
\E s" DFloat *"		single data-stack type-prefix df_
\E s" SFloat *"		single data-stack type-prefix sf_
\E s" Xt"		single data-stack type-prefix xt
\E s" struct F83Name *"	single data-stack type-prefix f83name
\E s" struct Longname *" single data-stack type-prefix longname
\E 
\E return-stack stack-prefix R:
\E inst-stream  stack-prefix #
\E 
\E set-current
\E store-optimization on
\E ' noop tail-nextp2 ! \ now INST_TAIL just stores, but does not jump
\E
\E include-skipped-insts on \ static superinsts include cells for components
\E                          \ useful for dynamic programming and
\E                          \ superinsts across entry points

\ 
\ 
\ 
\ In addition the following names can be used:
\ ip	the instruction pointer
\ sp	the data stack pointer
\ rp	the parameter stack pointer
\ lp	the locals stack pointer
\ NEXT	executes NEXT
\ cfa	
\ NEXT1	executes NEXT1
\ FLAG(x)	makes a Forth flag from a C flag
\ 
\ 
\ 
\ Percentages in comments are from Koopmans book: average/maximum use
\ (taken from four, not very representative benchmarks)
\ 
\ 
\ 
\ To do:
\ 
\ throw execute, cfa and NEXT1 out?
\ macroize *ip, ip++, *ip++ (pipelining)?

\ these m4 macros would collide with identifiers




\F 0 [if]

\ run-time routines for non-primitives.  They are defined as
\ primitives, because that simplifies things.

(docol)	( -- R:a_retaddr )	gforth-internal	paren_docol
""run-time routine for colon definitions""
a_retaddr = (Cell *)IP;
SET_IP((Xt *)PFA(CFA));

(docon) ( -- w )	gforth-internal	paren_docon
""run-time routine for constants""
w = *(Cell *)PFA(CFA);

(dovar) ( -- a_body )	gforth-internal	paren_dovar
""run-time routine for variables and CREATEd words""
a_body = PFA(CFA);

(douser) ( -- a_user )	gforth-internal	paren_douser
""run-time routine for constants""
a_user = (Cell *)(up+*(Cell *)PFA(CFA));

(dodefer) ( -- )	gforth-internal	paren_dodefer
""run-time routine for deferred words""
ip=IP; /* undo any ip updating that may have been performed by NEXT_P0 */
SUPER_END; /* !! probably unnecessary and may lead to measurement errors */
EXEC(*(Xt *)PFA(CFA));

(dofield) ( n1 -- n2 )	gforth-internal	paren_field
""run-time routine for fields""
n2 = n1 + *(Cell *)PFA(CFA);

(dodoes) ( -- a_body R:a_retaddr )	gforth-internal	paren_dodoes
""run-time routine for @code{does>}-defined words""
a_retaddr = (Cell *)IP;
a_body = PFA(CFA);
SET_IP(DOES_CODE1(CFA));

(does-handler) ( -- )	gforth-internal	paren_does_handler
""just a slot to have an encoding for the DOESJUMP, 
which is no longer used anyway (!! eliminate this)""

\F [endif]

\g control

noop	( -- )		gforth
:
 ;

call	( #a_callee -- R:a_retaddr )	new
""Call callee (a variant of docol with inline argument).""
#ifdef NO_IP
INST_TAIL;
JUMP(a_callee);
#else
#ifdef DEBUG
    {
      CFA_TO_NAME((((Cell *)a_callee)-2));
      fprintf(stderr,"%08lx: call %08lx %.*s\n",(Cell)ip,(Cell)a_callee,
	      len,name);
    }
#endif
a_retaddr = (Cell *)IP;
SET_IP((Xt *)a_callee);
#endif

execute	( xt -- )		core
""Perform the semantics represented by the execution token, @i{xt}.""
#ifndef NO_IP
ip=IP;
#endif
IF_spTOS(spTOS = sp[0]);
SUPER_END;
EXEC(xt);

perform	( a_addr -- )	gforth
""@code{@@ execute}.""
/* and pfe */
#ifndef NO_IP
ip=IP;
#endif
IF_spTOS(spTOS = sp[0]);
SUPER_END;
EXEC(*(Xt *)a_addr);
:
 @ execute ;

;s	( R:w -- )		gforth	semis
""The primitive compiled by @code{EXIT}.""
#ifdef NO_IP
INST_TAIL;
goto *(void *)w;
#else
SET_IP((Xt *)w);
#endif

unloop	( R:w1 R:w2 -- )	core
/* !! alias for 2rdrop */
:
 r> rdrop rdrop >r ;

lit-perform	( #a_addr -- )	new	lit_perform
#ifndef NO_IP
ip=IP;
#endif
SUPER_END;
EXEC(*(Xt *)a_addr);

does-exec ( #a_cfa -- R:nest a_pfa )	new	does_exec
#ifdef NO_IP
/* compiled to LIT CALL by compile_prim */
assert(0);
#else
a_pfa = PFA(a_cfa);
nest = (Cell)IP;
IF_spTOS(spTOS = sp[0]);
#ifdef DEBUG
    {
      CFA_TO_NAME(a_cfa);
      fprintf(stderr,"%08lx: does %08lx %.*s\n",
	      (Cell)ip,(Cell)a_cfa,len,name);
    }
#endif
SET_IP(DOES_CODE1(a_cfa));
#endif

\+glocals

branch-lp+!# ( #a_target #nlocals -- )	gforth	branch_lp_plus_store_number
/* this will probably not be used */
lp += nlocals;
#ifdef NO_IP
INST_TAIL;
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
#endif

\+

branch	( #a_target -- )	gforth
#ifdef NO_IP
INST_TAIL;
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
#endif
:
 r> @ >r ;

\ condbranch(forthname,stackeffect,restline,code1,code2,forthcode)
\ this is non-syntactical: code must open a brace that is closed by the macro
#line 329


#line 337
?branch ( #a_target f -- ) f83	question_branch
#line 337
	#ifdef NO_IP
#line 337
INST_TAIL;
#line 337
#endif
#line 337
if (f==0) {
#line 337
	#ifdef NO_IP
#line 337
JUMP(a_target);
#line 337
#else
#line 337
SET_IP((Xt *)a_target);
#line 337
INST_TAIL; NEXT_P2;
#line 337
#endif
#line 337
}
#line 337
SUPER_CONTINUE;
#line 337
:
#line 337
 0= dup 0=          \ !f f
#line 337
 r> tuck cell+      \ !f branchoffset f IP+
#line 337
 and -rot @ and or  \ f&IP+|!f&branch
#line 337
 >r ;
#line 337

#line 337
\+glocals
#line 337

#line 337
?branch-lp+!# ( #a_target #nlocals f -- ) f83	question_branch_lp_plus_store_number
#line 337
	#ifdef NO_IP
#line 337
INST_TAIL;
#line 337
#endif
#line 337
if (f==0) {
#line 337
	lp += nlocals;
#line 337
#ifdef NO_IP
#line 337
JUMP(a_target);
#line 337
#else
#line 337
SET_IP((Xt *)a_target);
#line 337
INST_TAIL; NEXT_P2;
#line 337
#endif
#line 337
}
#line 337
SUPER_CONTINUE;
#line 337

#line 337
\+
#line 337


\ we don't need an lp_plus_store version of the ?dup-stuff, because it
\ is only used in if's (yet)

\+xconds

?dup-?branch	( #a_target f -- f )	new	question_dupe_question_branch
""The run-time procedure compiled by @code{?DUP-IF}.""
if (f==0) {
  sp++;
  IF_spTOS(spTOS = sp[0]);
#ifdef NO_IP
INST_TAIL;
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
  INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;

?dup-0=-?branch ( #a_target f -- ) new	question_dupe_zero_equals_question_branch
""The run-time procedure compiled by @code{?DUP-0=-IF}.""
/* the approach taken here of declaring the word as having the stack
effect ( f -- ) and correcting for it in the branch-taken case costs a
few cycles in that case, but is easy to convert to a CONDBRANCH
invocation */
if (f!=0) {
  sp--;
#ifdef NO_IP
  JUMP(a_target);
#else
  SET_IP((Xt *)a_target);
  NEXT;
#endif
}
SUPER_CONTINUE;

\+
\fhas? skiploopprims 0= [IF]

#line 384
(next) ( #a_target R:n1 -- R:n2 ) cmFORTH	paren_next
#line 384
n2=n1-1;
#line 384
	#ifdef NO_IP
#line 384
INST_TAIL;
#line 384
#endif
#line 384
if (n1) {
#line 384
	#ifdef NO_IP
#line 384
JUMP(a_target);
#line 384
#else
#line 384
SET_IP((Xt *)a_target);
#line 384
INST_TAIL; NEXT_P2;
#line 384
#endif
#line 384
}
#line 384
SUPER_CONTINUE;
#line 384
:
#line 384
 r> r> dup 1- >r
#line 384
 IF @ >r ELSE cell+ >r THEN ;
#line 384

#line 384
\+glocals
#line 384

#line 384
(next)-lp+!# ( #a_target #nlocals R:n1 -- R:n2 ) cmFORTH	paren_next_lp_plus_store_number
#line 384
n2=n1-1;
#line 384
	#ifdef NO_IP
#line 384
INST_TAIL;
#line 384
#endif
#line 384
if (n1) {
#line 384
	lp += nlocals;
#line 384
#ifdef NO_IP
#line 384
JUMP(a_target);
#line 384
#else
#line 384
SET_IP((Xt *)a_target);
#line 384
INST_TAIL; NEXT_P2;
#line 384
#endif
#line 384
}
#line 384
SUPER_CONTINUE;
#line 384

#line 384
\+
#line 384


#line 392
(loop) ( #a_target R:nlimit R:n1 -- R:nlimit R:n2 ) gforth	paren_loop
#line 392
n2=n1+1;
#line 392
	#ifdef NO_IP
#line 392
INST_TAIL;
#line 392
#endif
#line 392
if (n2 != nlimit) {
#line 392
	#ifdef NO_IP
#line 392
JUMP(a_target);
#line 392
#else
#line 392
SET_IP((Xt *)a_target);
#line 392
INST_TAIL; NEXT_P2;
#line 392
#endif
#line 392
}
#line 392
SUPER_CONTINUE;
#line 392
:
#line 392
 r> r> 1+ r> 2dup =
#line 392
 IF >r 1- >r cell+ >r
#line 392
 ELSE >r >r @ >r THEN ;
#line 392

#line 392
\+glocals
#line 392

#line 392
(loop)-lp+!# ( #a_target #nlocals R:nlimit R:n1 -- R:nlimit R:n2 ) gforth	paren_loop_lp_plus_store_number
#line 392
n2=n1+1;
#line 392
	#ifdef NO_IP
#line 392
INST_TAIL;
#line 392
#endif
#line 392
if (n2 != nlimit) {
#line 392
	lp += nlocals;
#line 392
#ifdef NO_IP
#line 392
JUMP(a_target);
#line 392
#else
#line 392
SET_IP((Xt *)a_target);
#line 392
INST_TAIL; NEXT_P2;
#line 392
#endif
#line 392
}
#line 392
SUPER_CONTINUE;
#line 392

#line 392
\+
#line 392


#line 408
(+loop) ( #a_target n R:nlimit R:n1 -- R:nlimit R:n2 ) gforth paren_plus_loop
#line 408
/* !! check this thoroughly */
#line 408
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
#line 408
/* dependent upon two's complement arithmetic */
#line 408
Cell olddiff = n1-nlimit;
#line 408
n2=n1+n;	
#line 408
	#ifdef NO_IP
#line 408
INST_TAIL;
#line 408
#endif
#line 408
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
#line 408
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#line 408
	#ifdef NO_IP
#line 408
JUMP(a_target);
#line 408
#else
#line 408
SET_IP((Xt *)a_target);
#line 408
INST_TAIL; NEXT_P2;
#line 408
#endif
#line 408
}
#line 408
SUPER_CONTINUE;
#line 408
:
#line 408
 r> swap
#line 408
 r> r> 2dup - >r
#line 408
 2 pick r@ + r@ xor 0< 0=
#line 408
 3 pick r> xor 0< 0= or
#line 408
 IF    >r + >r @ >r
#line 408
 ELSE  >r >r drop cell+ >r THEN ;
#line 408

#line 408
\+glocals
#line 408

#line 408
(+loop)-lp+!# ( #a_target #nlocals n R:nlimit R:n1 -- R:nlimit R:n2 ) gforth paren_plus_loop_lp_plus_store_number
#line 408
/* !! check this thoroughly */
#line 408
/* sign bit manipulation and test: (x^y)<0 is equivalent to (x<0) != (y<0) */
#line 408
/* dependent upon two's complement arithmetic */
#line 408
Cell olddiff = n1-nlimit;
#line 408
n2=n1+n;	
#line 408
	#ifdef NO_IP
#line 408
INST_TAIL;
#line 408
#endif
#line 408
if ((olddiff^(olddiff+n))>=0   /* the limit is not crossed */
#line 408
    || (olddiff^n)>=0          /* it is a wrap-around effect */) {
#line 408
	lp += nlocals;
#line 408
#ifdef NO_IP
#line 408
JUMP(a_target);
#line 408
#else
#line 408
SET_IP((Xt *)a_target);
#line 408
INST_TAIL; NEXT_P2;
#line 408
#endif
#line 408
}
#line 408
SUPER_CONTINUE;
#line 408

#line 408
\+
#line 408


\+xconds

#line 416
(-loop) ( #a_target u R:nlimit R:n1 -- R:nlimit R:n2 ) gforth paren_minus_loop
#line 416
UCell olddiff = n1-nlimit;
#line 416
n2=n1-u;
#line 416
	#ifdef NO_IP
#line 416
INST_TAIL;
#line 416
#endif
#line 416
if (olddiff>u) {
#line 416
	#ifdef NO_IP
#line 416
JUMP(a_target);
#line 416
#else
#line 416
SET_IP((Xt *)a_target);
#line 416
INST_TAIL; NEXT_P2;
#line 416
#endif
#line 416
}
#line 416
SUPER_CONTINUE;
#line 416

#line 416

#line 416
\+glocals
#line 416

#line 416
(-loop)-lp+!# ( #a_target #nlocals u R:nlimit R:n1 -- R:nlimit R:n2 ) gforth paren_minus_loop_lp_plus_store_number
#line 416
UCell olddiff = n1-nlimit;
#line 416
n2=n1-u;
#line 416
	#ifdef NO_IP
#line 416
INST_TAIL;
#line 416
#endif
#line 416
if (olddiff>u) {
#line 416
	lp += nlocals;
#line 416
#ifdef NO_IP
#line 416
JUMP(a_target);
#line 416
#else
#line 416
SET_IP((Xt *)a_target);
#line 416
INST_TAIL; NEXT_P2;
#line 416
#endif
#line 416
}
#line 416
SUPER_CONTINUE;
#line 416

#line 416
\+
#line 416


#line 431
(s+loop) ( #a_target n R:nlimit R:n1 -- R:nlimit R:n2 ) gforth	paren_symmetric_plus_loop
#line 431
""The run-time procedure compiled by S+LOOP. It loops until the index
#line 431
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
#line 431
version of (+LOOP).""
#line 431
/* !! check this thoroughly */
#line 431
Cell diff = n1-nlimit;
#line 431
Cell newdiff = diff+n;
#line 431
if (n<0) {
#line 431
    diff = -diff;
#line 431
    newdiff = -newdiff;
#line 431
}
#line 431
n2=n1+n;
#line 431
	#ifdef NO_IP
#line 431
INST_TAIL;
#line 431
#endif
#line 431
if (diff>=0 || newdiff<0) {
#line 431
	#ifdef NO_IP
#line 431
JUMP(a_target);
#line 431
#else
#line 431
SET_IP((Xt *)a_target);
#line 431
INST_TAIL; NEXT_P2;
#line 431
#endif
#line 431
}
#line 431
SUPER_CONTINUE;
#line 431

#line 431

#line 431
\+glocals
#line 431

#line 431
(s+loop)-lp+!# ( #a_target #nlocals n R:nlimit R:n1 -- R:nlimit R:n2 ) gforth	paren_symmetric_plus_loop_lp_plus_store_number
#line 431
""The run-time procedure compiled by S+LOOP. It loops until the index
#line 431
crosses the boundary between limit and limit-sign(n). I.e. a symmetric
#line 431
version of (+LOOP).""
#line 431
/* !! check this thoroughly */
#line 431
Cell diff = n1-nlimit;
#line 431
Cell newdiff = diff+n;
#line 431
if (n<0) {
#line 431
    diff = -diff;
#line 431
    newdiff = -newdiff;
#line 431
}
#line 431
n2=n1+n;
#line 431
	#ifdef NO_IP
#line 431
INST_TAIL;
#line 431
#endif
#line 431
if (diff>=0 || newdiff<0) {
#line 431
	lp += nlocals;
#line 431
#ifdef NO_IP
#line 431
JUMP(a_target);
#line 431
#else
#line 431
SET_IP((Xt *)a_target);
#line 431
INST_TAIL; NEXT_P2;
#line 431
#endif
#line 431
}
#line 431
SUPER_CONTINUE;
#line 431

#line 431
\+
#line 431


\+

(for)   ( ncount -- R:nlimit R:ncount )         cmFORTH         paren_for
/* or (for) = >r -- collides with unloop! */
nlimit=0;
:
 r> swap 0 >r >r >r ;

(do)    ( nlimit nstart -- R:nlimit R:nstart )  gforth          paren_do
:
 r> swap rot >r >r >r ;

(?do) ( #a_target nlimit nstart -- R:nlimit R:nstart ) gforth	paren_question_do
#ifdef NO_IP
    INST_TAIL;
#endif
if (nstart == nlimit) {
#ifdef NO_IP
    JUMP(a_target);
#else
    SET_IP((Xt *)a_target);
    INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;
:
  2dup =
  IF   r> swap rot >r >r
       @ >r
  ELSE r> swap rot >r >r
       cell+ >r
  THEN ;				\ --> CORE-EXT

\+xconds

(+do)	( #a_target nlimit nstart -- R:nlimit R:nstart ) gforth	paren_plus_do
#ifdef NO_IP
    INST_TAIL;
#endif
if (nstart >= nlimit) {
#ifdef NO_IP
    JUMP(a_target);
#else
    SET_IP((Xt *)a_target);
    INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;
:
 swap 2dup
 r> swap >r swap >r
 >=
 IF
     @
 ELSE
     cell+
 THEN  >r ;

(u+do)	( #a_target ulimit ustart -- R:ulimit R:ustart ) gforth	paren_u_plus_do
#ifdef NO_IP
    INST_TAIL;
#endif
if (ustart >= ulimit) {
#ifdef NO_IP
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;
:
 swap 2dup
 r> swap >r swap >r
 u>=
 IF
     @
 ELSE
     cell+
 THEN  >r ;

(-do)	( #a_target nlimit nstart -- R:nlimit R:nstart ) gforth	paren_minus_do
#ifdef NO_IP
    INST_TAIL;
#endif
if (nstart <= nlimit) {
#ifdef NO_IP
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;
:
 swap 2dup
 r> swap >r swap >r
 <=
 IF
     @
 ELSE
     cell+
 THEN  >r ;

(u-do)	( #a_target ulimit ustart -- R:ulimit R:ustart ) gforth	paren_u_minus_do
#ifdef NO_IP
    INST_TAIL;
#endif
if (ustart <= ulimit) {
#ifdef NO_IP
JUMP(a_target);
#else
SET_IP((Xt *)a_target);
INST_TAIL; NEXT_P2;
#endif
}
SUPER_CONTINUE;
:
 swap 2dup
 r> swap >r swap >r
 u<=
 IF
     @
 ELSE
     cell+
 THEN  >r ;

\+

\ don't make any assumptions where the return stack is!!
\ implement this in machine code if it should run quickly!

i	( R:n -- R:n n )		core
:
\ rp@ cell+ @ ;
  r> r> tuck >r >r ;

i'	( R:w R:w2 -- R:w R:w2 w )		gforth		i_tick
:
\ rp@ cell+ cell+ @ ;
  r> r> r> dup itmp ! >r >r >r itmp @ ;
variable itmp

j	( R:n R:d1 -- n R:n R:d1 )		core
:
\ rp@ cell+ cell+ cell+ @ ;
  r> r> r> r> dup itmp ! >r >r >r >r itmp @ ;
[IFUNDEF] itmp variable itmp [THEN]

k	( R:n R:d1 R:d2 -- n R:n R:d1 R:d2 )		gforth
:
\ rp@ [ 5 cells ] Literal + @ ;
  r> r> r> r> r> r> dup itmp ! >r >r >r >r >r >r itmp @ ;
[IFUNDEF] itmp variable itmp [THEN]

\f[THEN]

\ digit is high-level: 0/0%

\g strings

move	( c_from c_to ucount -- )		core
""Copy the contents of @i{ucount} aus at @i{c-from} to
@i{c-to}. @code{move} works correctly even if the two areas overlap.""
/* !! note that the standard specifies addr, not c-addr */
memmove(c_to,c_from,ucount);
/* make an Ifdef for bsd and others? */
:
 >r 2dup u< IF r> cmove> ELSE r> cmove THEN ;

cmove	( c_from c_to u -- )	string	c_move
""Copy the contents of @i{ucount} characters from data space at
@i{c-from} to @i{c-to}. The copy proceeds @code{char}-by-@code{char}
from low address to high address; i.e., for overlapping areas it is
safe if @i{c-to}=<@i{c-from}.""
cmove(c_from,c_to,u);
:
 bounds ?DO  dup c@ I c! 1+  LOOP  drop ;

cmove>	( c_from c_to u -- )	string	c_move_up
""Copy the contents of @i{ucount} characters from data space at
@i{c-from} to @i{c-to}. The copy proceeds @code{char}-by-@code{char}
from high address to low address; i.e., for overlapping areas it is
safe if @i{c-to}>=@i{c-from}.""
cmove_up(c_from,c_to,u);
:
 dup 0= IF  drop 2drop exit  THEN
 rot over + -rot bounds swap 1-
 DO  1- dup c@ I c!  -1 +LOOP  drop ;

fill	( c_addr u c -- )	core
""Store @i{c} in @i{u} chars starting at @i{c-addr}.""
memset(c_addr,c,u);
:
 -rot bounds
 ?DO  dup I c!  LOOP  drop ;

compare	( c_addr1 u1 c_addr2 u2 -- n )	string
""Compare two strings lexicographically. If they are equal, @i{n} is 0; if
the first string is smaller, @i{n} is -1; if the first string is larger, @i{n}
is 1. Currently this is based on the machine's character
comparison. In the future, this may change to consider the current
locale and its collation order.""
/* close ' to keep fontify happy */ 
n = compare(c_addr1, u1, c_addr2, u2);
:
 rot 2dup swap - >r min swap -text dup
 IF  rdrop  ELSE  drop r> sgn  THEN ;
: sgn ( n -- -1/0/1 )
 dup 0= IF EXIT THEN  0< 2* 1+ ;

\ -text is only used by replaced primitives now; move it elsewhere
\ -text	( c_addr1 u c_addr2 -- n )	new	dash_text
\ n = memcmp(c_addr1, c_addr2, u);
\ if (n<0)
\   n = -1;
\ else if (n>0)
\   n = 1;
\ :
\  swap bounds
\  ?DO  dup c@ I c@ = WHILE  1+  LOOP  drop 0
\  ELSE  c@ I c@ - unloop  THEN  sgn ;
\ : sgn ( n -- -1/0/1 )
\  dup 0= IF EXIT THEN  0< 2* 1+ ;

toupper	( c1 -- c2 )	gforth
""If @i{c1} is a lower-case character (in the current locale), @i{c2}
is the equivalent upper-case character. All other characters are unchanged.""
c2 = toupper(c1);
:
 dup [char] a - [ char z char a - 1 + ] Literal u<  bl and - ;

/string	( c_addr1 u1 n -- c_addr2 u2 )	string	slash_string
""Adjust the string specified by @i{c-addr1, u1} to remove @i{n}
characters from the start of the string.""
c_addr2 = c_addr1+n;
u2 = u1-n;
:
 tuck - >r + r> dup 0< IF  - 0  THEN ;

\g arith

lit	( #w -- w )		gforth
:
 r> dup @ swap cell+ >r ;

+	( n1 n2 -- n )		core	plus
n = n1+n2;

\ lit+ / lit_plus = lit +

lit+	( n1 #n2 -- n )		new	lit_plus
n=n1+n2;

\ PFE-0.9.14 has it differently, but the next release will have it as follows
under+	( n1 n2 n3 -- n n2 )	gforth	under_plus
""add @i{n3} to @i{n1} (giving @i{n})""
n = n1+n3;
:
 rot + swap ;

-	( n1 n2 -- n )		core	minus
n = n1-n2;
:
 negate + ;

negate	( n1 -- n2 )		core
/* use minus as alias */
n2 = -n1;
:
 invert 1+ ;

1+	( n1 -- n2 )		core		one_plus
n2 = n1+1;
:
 1 + ;

1-	( n1 -- n2 )		core		one_minus
n2 = n1-1;
:
 1 - ;

max	( n1 n2 -- n )	core
if (n1<n2)
  n = n2;
else
  n = n1;
:
 2dup < IF swap THEN drop ;

min	( n1 n2 -- n )	core
if (n1<n2)
  n = n1;
else
  n = n2;
:
 2dup > IF swap THEN drop ;

abs	( n -- u )	core
if (n<0)
  u = -n;
else
  u = n;
:
 dup 0< IF negate THEN ;

*	( n1 n2 -- n )		core	star
n = n1*n2;
:
 um* drop ;

/	( n1 n2 -- n )		core	slash
n = n1/n2;
:
 /mod nip ;

mod	( n1 n2 -- n )		core
n = n1%n2;
:
 /mod drop ;

/mod	( n1 n2 -- n3 n4 )		core		slash_mod
n4 = n1/n2;
n3 = n1%n2; /* !! is this correct? look into C standard! */
:
 >r s>d r> fm/mod ;

2*	( n1 -- n2 )		core		two_star
""Shift left by 1; also works on unsigned numbers""
n2 = 2*n1;
:
 dup + ;

2/	( n1 -- n2 )		core		two_slash
""Arithmetic shift right by 1.  For signed numbers this is a floored
division by 2 (note that @code{/} not necessarily floors).""
n2 = n1>>1;
:
 dup MINI and IF 1 ELSE 0 THEN
 [ bits/byte cell * 1- ] literal 
 0 DO 2* swap dup 2* >r MINI and 
     IF 1 ELSE 0 THEN or r> swap
 LOOP nip ;

fm/mod	( d1 n1 -- n2 n3 )		core		f_m_slash_mod
""Floored division: @i{d1} = @i{n3}*@i{n1}+@i{n2}, @i{n1}>@i{n2}>=0 or 0>=@i{n2}>@i{n1}.""
#ifdef BUGGY_LONG_LONG
DCell r = fmdiv(d1,n1);
n2=r.hi;
n3=r.lo;
#else
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3>0 is optimized by the compiler */
if (1%-3>0 && (d1<0) != (n1<0) && n2!=0) {
  n3--;
  n2+=n1;
}
#endif
:
 dup >r dup 0< IF  negate >r dnegate r>  THEN
 over       0< IF  tuck + swap  THEN
 um/mod
 r> 0< IF  swap negate swap  THEN ;

sm/rem	( d1 n1 -- n2 n3 )		core		s_m_slash_rem
""Symmetric division: @i{d1} = @i{n3}*@i{n1}+@i{n2}, sign(@i{n2})=sign(@i{d1}) or 0.""
#ifdef BUGGY_LONG_LONG
DCell r = smdiv(d1,n1);
n2=r.hi;
n3=r.lo;
#else
/* assumes that the processor uses either floored or symmetric division */
n3 = d1/n1;
n2 = d1%n1;
/* note that this 1%-3<0 is optimized by the compiler */
if (1%-3<0 && (d1<0) != (n1<0) && n2!=0) {
  n3++;
  n2-=n1;
}
#endif
:
 over >r dup >r abs -rot
 dabs rot um/mod
 r> r@ xor 0< IF       negate       THEN
 r>        0< IF  swap negate swap  THEN ;

m*	( n1 n2 -- d )		core	m_star
#ifdef BUGGY_LONG_LONG
d = mmul(n1,n2);
#else
d = (DCell)n1 * (DCell)n2;
#endif
:
 2dup      0< and >r
 2dup swap 0< and >r
 um* r> - r> - ;

um*	( u1 u2 -- ud )		core	u_m_star
/* use u* as alias */
#ifdef BUGGY_LONG_LONG
ud = ummul(u1,u2);
#else
ud = (UDCell)u1 * (UDCell)u2;
#endif
:
   0 -rot dup [ 8 cells ] literal -
   DO
	dup 0< I' and d2*+ drop
   LOOP ;
: d2*+ ( ud n -- ud+n c )
   over MINI
   and >r >r 2dup d+ swap r> + swap r> ;

um/mod	( ud u1 -- u2 u3 )		core	u_m_slash_mod
""ud=u3*u1+u2, u1>u2>=0""
#ifdef BUGGY_LONG_LONG
UDCell r = umdiv(ud,u1);
u2=r.hi;
u3=r.lo;
#else
u3 = ud/u1;
u2 = ud%u1;
#endif
:
   0 swap [ 8 cells 1 + ] literal 0
   ?DO /modstep
   LOOP drop swap 1 rshift or swap ;
: /modstep ( ud c R: u -- ud-?u c R: u )
   >r over r@ u< 0= or IF r@ - 1 ELSE 0 THEN  d2*+ r> ;
: d2*+ ( ud n -- ud+n c )
   over MINI
   and >r >r 2dup d+ swap r> + swap r> ;

m+	( d1 n -- d2 )		double		m_plus
#ifdef BUGGY_LONG_LONG
d2.lo = d1.lo+n;
d2.hi = d1.hi - (n<0) + (d2.lo<d1.lo);
#else
d2 = d1+n;
#endif
:
 s>d d+ ;

d+	( d1 d2 -- d )		double	d_plus
#ifdef BUGGY_LONG_LONG
d.lo = d1.lo+d2.lo;
d.hi = d1.hi + d2.hi + (d.lo<d1.lo);
#else
d = d1+d2;
#endif
:
 rot + >r tuck + swap over u> r> swap - ;

d-	( d1 d2 -- d )		double		d_minus
#ifdef BUGGY_LONG_LONG
d.lo = d1.lo - d2.lo;
d.hi = d1.hi-d2.hi-(d1.lo<d2.lo);
#else
d = d1-d2;
#endif
:
 dnegate d+ ;

dnegate	( d1 -- d2 )		double	d_negate
/* use dminus as alias */
#ifdef BUGGY_LONG_LONG
d2 = dnegate(d1);
#else
d2 = -d1;
#endif
:
 invert swap negate tuck 0= - ;

d2*	( d1 -- d2 )		double		d_two_star
""Shift left by 1; also works on unsigned numbers""
#ifdef BUGGY_LONG_LONG
d2.lo = d1.lo<<1;
d2.hi = (d1.hi<<1) | (d1.lo>>(CELL_BITS-1));
#else
d2 = 2*d1;
#endif
:
 2dup d+ ;

d2/	( d1 -- d2 )		double		d_two_slash
""Arithmetic shift right by 1.  For signed numbers this is a floored
division by 2.""
#ifdef BUGGY_LONG_LONG
d2.hi = d1.hi>>1;
d2.lo= (d1.lo>>1) | (d1.hi<<(CELL_BITS-1));
#else
d2 = d1>>1;
#endif
:
 dup 1 and >r 2/ swap 2/ [ 1 8 cells 1- lshift 1- ] Literal and
 r> IF  [ 1 8 cells 1- lshift ] Literal + THEN  swap ;

and	( w1 w2 -- w )		core
w = w1&w2;

or	( w1 w2 -- w )		core
w = w1|w2;
:
 invert swap invert and invert ;

xor	( w1 w2 -- w )		core	x_or
w = w1^w2;

invert	( w1 -- w2 )		core
w2 = ~w1;
:
 MAXU xor ;

rshift	( u1 n -- u2 )		core	r_shift
""Logical shift right by @i{n} bits.""
  u2 = u1>>n;
:
    0 ?DO 2/ MAXI and LOOP ;

lshift	( u1 n -- u2 )		core	l_shift
  u2 = u1<<n;
:
    0 ?DO 2* LOOP ;

\g compare

\ comparisons(prefix, args, prefix, arg1, arg2, wordsets...)
#line 1010


0=	( n -- f )		core	zero_equals
#line 1012
f = FLAG(n==0);
#line 1012
:
#line 1012
    [ char 0x char 0 = [IF]
#line 1012
	] IF false ELSE true THEN [
#line 1012
    [ELSE]
#line 1012
	] xor 0= [
#line 1012
    [THEN] ] ;
#line 1012

#line 1012
0<>	( n -- f )		core-ext	zero_not_equals
#line 1012
f = FLAG(n!=0);
#line 1012
:
#line 1012
    [ char 0x char 0 = [IF]
#line 1012
	] IF true ELSE false THEN [
#line 1012
    [ELSE]
#line 1012
	] xor 0<> [
#line 1012
    [THEN] ] ;
#line 1012

#line 1012
0<	( n -- f )		core	zero_less_than
#line 1012
f = FLAG(n<0);
#line 1012
:
#line 1012
    [ char 0x char 0 = [IF]
#line 1012
	] MINI and 0<> [
#line 1012
    [ELSE] char 0x char u = [IF]
#line 1012
	]   2dup xor 0<  IF nip ELSE - THEN 0<  [
#line 1012
	[ELSE]
#line 1012
	    ] MINI xor >r MINI xor r> u< [
#line 1012
	[THEN]
#line 1012
    [THEN] ] ;
#line 1012

#line 1012
0>	( n -- f )		core-ext	zero_greater_than
#line 1012
f = FLAG(n>0);
#line 1012
:
#line 1012
    [ char 0x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1012
    0< ;
#line 1012

#line 1012
0<=	( n -- f )		gforth	zero_less_or_equal
#line 1012
f = FLAG(n<=0);
#line 1012
:
#line 1012
    0> 0= ;
#line 1012

#line 1012
0>=	( n -- f )		gforth	zero_greater_or_equal
#line 1012
f = FLAG(n>=0);
#line 1012
:
#line 1012
    [ char 0x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1012
    0<= ;
#line 1012

#line 1012

=	( n1 n2 -- f )		core	equals
#line 1013
f = FLAG(n1==n2);
#line 1013
:
#line 1013
    [ char x char 0 = [IF]
#line 1013
	] IF false ELSE true THEN [
#line 1013
    [ELSE]
#line 1013
	] xor 0= [
#line 1013
    [THEN] ] ;
#line 1013

#line 1013
<>	( n1 n2 -- f )		core-ext	not_equals
#line 1013
f = FLAG(n1!=n2);
#line 1013
:
#line 1013
    [ char x char 0 = [IF]
#line 1013
	] IF true ELSE false THEN [
#line 1013
    [ELSE]
#line 1013
	] xor 0<> [
#line 1013
    [THEN] ] ;
#line 1013

#line 1013
<	( n1 n2 -- f )		core	less_than
#line 1013
f = FLAG(n1<n2);
#line 1013
:
#line 1013
    [ char x char 0 = [IF]
#line 1013
	] MINI and 0<> [
#line 1013
    [ELSE] char x char u = [IF]
#line 1013
	]   2dup xor 0<  IF nip ELSE - THEN 0<  [
#line 1013
	[ELSE]
#line 1013
	    ] MINI xor >r MINI xor r> u< [
#line 1013
	[THEN]
#line 1013
    [THEN] ] ;
#line 1013

#line 1013
>	( n1 n2 -- f )		core	greater_than
#line 1013
f = FLAG(n1>n2);
#line 1013
:
#line 1013
    [ char x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1013
    < ;
#line 1013

#line 1013
<=	( n1 n2 -- f )		gforth	less_or_equal
#line 1013
f = FLAG(n1<=n2);
#line 1013
:
#line 1013
    > 0= ;
#line 1013

#line 1013
>=	( n1 n2 -- f )		gforth	greater_or_equal
#line 1013
f = FLAG(n1>=n2);
#line 1013
:
#line 1013
    [ char x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1013
    <= ;
#line 1013

#line 1013

u=	( u1 u2 -- f )		gforth	u_equals
#line 1014
f = FLAG(u1==u2);
#line 1014
:
#line 1014
    [ char ux char 0 = [IF]
#line 1014
	] IF false ELSE true THEN [
#line 1014
    [ELSE]
#line 1014
	] xor 0= [
#line 1014
    [THEN] ] ;
#line 1014

#line 1014
u<>	( u1 u2 -- f )		gforth	u_not_equals
#line 1014
f = FLAG(u1!=u2);
#line 1014
:
#line 1014
    [ char ux char 0 = [IF]
#line 1014
	] IF true ELSE false THEN [
#line 1014
    [ELSE]
#line 1014
	] xor 0<> [
#line 1014
    [THEN] ] ;
#line 1014

#line 1014
u<	( u1 u2 -- f )		core	u_less_than
#line 1014
f = FLAG(u1<u2);
#line 1014
:
#line 1014
    [ char ux char 0 = [IF]
#line 1014
	] MINI and 0<> [
#line 1014
    [ELSE] char ux char u = [IF]
#line 1014
	]   2dup xor 0<  IF nip ELSE - THEN 0<  [
#line 1014
	[ELSE]
#line 1014
	    ] MINI xor >r MINI xor r> u< [
#line 1014
	[THEN]
#line 1014
    [THEN] ] ;
#line 1014

#line 1014
u>	( u1 u2 -- f )		core-ext	u_greater_than
#line 1014
f = FLAG(u1>u2);
#line 1014
:
#line 1014
    [ char ux char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1014
    u< ;
#line 1014

#line 1014
u<=	( u1 u2 -- f )		gforth	u_less_or_equal
#line 1014
f = FLAG(u1<=u2);
#line 1014
:
#line 1014
    u> 0= ;
#line 1014

#line 1014
u>=	( u1 u2 -- f )		gforth	u_greater_or_equal
#line 1014
f = FLAG(u1>=u2);
#line 1014
:
#line 1014
    [ char ux char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1014
    u<= ;
#line 1014

#line 1014


\ dcomparisons(prefix, args, prefix, arg1, arg2, wordsets...)
#line 1060


\+dcomps

d=	( d1 d2 -- f )		double	d_equals
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.lo==d2.lo && d1.hi==d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1==d2);
#line 1064
#endif
#line 1064

#line 1064
d<>	( d1 d2 -- f )		gforth	d_not_equals
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.lo!=d2.lo || d1.hi!=d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1!=d2);
#line 1064
#endif
#line 1064

#line 1064
d<	( d1 d2 -- f )		double	d_less_than
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.hi==d2.hi ? d1.lo<d2.lo : d1.hi<d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1<d2);
#line 1064
#endif
#line 1064

#line 1064
d>	( d1 d2 -- f )		gforth	d_greater_than
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.hi==d2.hi ? d1.lo>d2.lo : d1.hi>d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1>d2);
#line 1064
#endif
#line 1064

#line 1064
d<=	( d1 d2 -- f )		gforth	d_less_or_equal
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.hi==d2.hi ? d1.lo<=d2.lo : d1.hi<=d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1<=d2);
#line 1064
#endif
#line 1064

#line 1064
d>=	( d1 d2 -- f )		gforth	d_greater_or_equal
#line 1064
#ifdef BUGGY_LONG_LONG
#line 1064
f = FLAG(d1.hi==d2.hi ? d1.lo>=d2.lo : d1.hi>=d2.hi);
#line 1064
#else
#line 1064
f = FLAG(d1>=d2);
#line 1064
#endif
#line 1064

#line 1064

d0=	( d -- f )		double	d_zero_equals
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.lo==DZERO.lo && d.hi==DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d==DZERO);
#line 1065
#endif
#line 1065

#line 1065
d0<>	( d -- f )		gforth	d_zero_not_equals
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.lo!=DZERO.lo || d.hi!=DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d!=DZERO);
#line 1065
#endif
#line 1065

#line 1065
d0<	( d -- f )		double	d_zero_less_than
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.hi==DZERO.hi ? d.lo<DZERO.lo : d.hi<DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d<DZERO);
#line 1065
#endif
#line 1065

#line 1065
d0>	( d -- f )		gforth	d_zero_greater_than
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.hi==DZERO.hi ? d.lo>DZERO.lo : d.hi>DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d>DZERO);
#line 1065
#endif
#line 1065

#line 1065
d0<=	( d -- f )		gforth	d_zero_less_or_equal
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.hi==DZERO.hi ? d.lo<=DZERO.lo : d.hi<=DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d<=DZERO);
#line 1065
#endif
#line 1065

#line 1065
d0>=	( d -- f )		gforth	d_zero_greater_or_equal
#line 1065
#ifdef BUGGY_LONG_LONG
#line 1065
f = FLAG(d.hi==DZERO.hi ? d.lo>=DZERO.lo : d.hi>=DZERO.hi);
#line 1065
#else
#line 1065
f = FLAG(d>=DZERO);
#line 1065
#endif
#line 1065

#line 1065

du=	( ud1 ud2 -- f )		gforth	d_u_equals
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.lo==ud2.lo && ud1.hi==ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1==ud2);
#line 1066
#endif
#line 1066

#line 1066
du<>	( ud1 ud2 -- f )		gforth	d_u_not_equals
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.lo!=ud2.lo || ud1.hi!=ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1!=ud2);
#line 1066
#endif
#line 1066

#line 1066
du<	( ud1 ud2 -- f )		double-ext	d_u_less_than
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.hi==ud2.hi ? ud1.lo<ud2.lo : ud1.hi<ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1<ud2);
#line 1066
#endif
#line 1066

#line 1066
du>	( ud1 ud2 -- f )		gforth	d_u_greater_than
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.hi==ud2.hi ? ud1.lo>ud2.lo : ud1.hi>ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1>ud2);
#line 1066
#endif
#line 1066

#line 1066
du<=	( ud1 ud2 -- f )		gforth	d_u_less_or_equal
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.hi==ud2.hi ? ud1.lo<=ud2.lo : ud1.hi<=ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1<=ud2);
#line 1066
#endif
#line 1066

#line 1066
du>=	( ud1 ud2 -- f )		gforth	d_u_greater_or_equal
#line 1066
#ifdef BUGGY_LONG_LONG
#line 1066
f = FLAG(ud1.hi==ud2.hi ? ud1.lo>=ud2.lo : ud1.hi>=ud2.hi);
#line 1066
#else
#line 1066
f = FLAG(ud1>=ud2);
#line 1066
#endif
#line 1066

#line 1066


\+

within	( u1 u2 u3 -- f )		core-ext
""u2=<u1<u3 or: u3=<u2 and u1 is not in [u3,u2).  This works for
unsigned and signed numbers (but not a mixture).  Another way to think
about this word is to consider the numbers as a circle (wrapping
around from @code{max-u} to 0 for unsigned, and from @code{max-n} to
min-n for signed numbers); now consider the range from u2 towards
increasing numbers up to and excluding u3 (giving an empty range if
u2=u3); if u1 is in this range, @code{within} returns true.""
f = FLAG(u1-u2 < u3-u2);
:
 over - >r - r> u< ;

\g stack

useraddr	( #u -- a_addr )	new
a_addr = (Cell *)(up+u);

up!	( a_addr -- )	gforth	up_store
UP=up=(char *)a_addr;
:
 up ! ;
Variable UP

sp@	( -- a_addr )		gforth		sp_fetch
a_addr = sp+1;

sp!	( a_addr -- )		gforth		sp_store
sp = a_addr;
/* works with and without spTOS caching */

rp@	( -- a_addr )		gforth		rp_fetch
a_addr = rp;

rp!	( a_addr -- )		gforth		rp_store
rp = a_addr;

\+floating

fp@	( -- f_addr )	gforth	fp_fetch
f_addr = fp;

fp!	( f_addr -- )	gforth	fp_store
fp = f_addr;

\+

>r	( w -- R:w )		core	to_r
:
 (>r) ;
: (>r)  rp@ cell+ @ rp@ ! rp@ cell+ ! ;

r>	( R:w -- w )		core	r_from
:
 rp@ cell+ @ rp@ @ rp@ cell+ ! (rdrop) rp@ ! ;
Create (rdrop) ' ;s A,

rdrop	( R:w -- )		gforth
:
 r> r> drop >r ;

2>r	( d -- R:d )	core-ext	two_to_r
:
 swap r> swap >r swap >r >r ;

2r>	( R:d -- d )	core-ext	two_r_from
:
 r> r> swap r> swap >r swap ;

2r@	( R:d -- R:d d )	core-ext	two_r_fetch
:
 i' j ;

2rdrop	( R:d -- )		gforth	two_r_drop
:
 r> r> drop r> drop >r ;

over	( w1 w2 -- w1 w2 w1 )		core
:
 sp@ cell+ @ ;

drop	( w -- )		core
:
 IF THEN ;

swap	( w1 w2 -- w2 w1 )		core
:
 >r (swap) ! r> (swap) @ ;
Variable (swap)

dup	( w -- w w )		core	dupe
:
 sp@ @ ;

rot	( w1 w2 w3 -- w2 w3 w1 )	core	rote
:
[ defined? (swap) [IF] ]
    (swap) ! (rot) ! >r (rot) @ (swap) @ r> ;
Variable (rot)
[ELSE] ]
    >r swap r> swap ;
[THEN]

-rot	( w1 w2 w3 -- w3 w1 w2 )	gforth	not_rote
:
 rot rot ;

nip	( w1 w2 -- w2 )		core-ext
:
 swap drop ;

tuck	( w1 w2 -- w2 w1 w2 )	core-ext
:
 swap over ;

?dup	( w -- w )			core	question_dupe
""Actually the stack effect is: @code{( w -- 0 | w w )}.  It performs a
@code{dup} if w is nonzero.""
if (w!=0) {
  IF_spTOS(*sp-- = w;)
#ifndef USE_TOS
  *--sp = w;
#endif
}
:
 dup IF dup THEN ;

pick	( u -- w )			core-ext
""Actually the stack effect is @code{ x0 ... xu u -- x0 ... xu x0 }.""
w = sp[u+1];
:
 1+ cells sp@ + @ ;

2drop	( w1 w2 -- )		core	two_drop
:
 drop drop ;

2dup	( w1 w2 -- w1 w2 w1 w2 )	core	two_dupe
:
 over over ;

2over	( w1 w2 w3 w4 -- w1 w2 w3 w4 w1 w2 )	core	two_over
:
 3 pick 3 pick ;

2swap	( w1 w2 w3 w4 -- w3 w4 w1 w2 )	core	two_swap
:
 rot >r rot r> ;

2rot	( w1 w2 w3 w4 w5 w6 -- w3 w4 w5 w6 w1 w2 )	double-ext	two_rote
:
 >r >r 2swap r> r> 2swap ;

2nip	( w1 w2 w3 w4 -- w3 w4 )	gforth	two_nip
:
 2swap 2drop ;

2tuck	( w1 w2 w3 w4 -- w3 w4 w1 w2 w3 w4 )	gforth	two_tuck
:
 2swap 2over ;

\ toggle is high-level: 0.11/0.42%

\g memory

@	( a_addr -- w )		core	fetch
""@i{w} is the cell stored at @i{a_addr}.""
w = *a_addr;

\ lit@ / lit_fetch = lit @

lit@		( #a_addr -- w ) new	lit_fetch
w = *a_addr;

!	( w a_addr -- )		core	store
""Store @i{w} into the cell at @i{a-addr}.""
*a_addr = w;

+!	( n a_addr -- )		core	plus_store
""Add @i{n} to the cell at @i{a-addr}.""
*a_addr += n;
:
 tuck @ + swap ! ;

c@	( c_addr -- c )		core	c_fetch
""@i{c} is the char stored at @i{c_addr}.""
c = *c_addr;
:
[ bigendian [IF] ]
    [ cell>bit 4 = [IF] ]
	dup [ 0 cell - ] Literal and @ swap 1 and
	IF  $FF and  ELSE  8>>  THEN  ;
    [ [ELSE] ]
	dup [ cell 1- ] literal and
	tuck - @ swap [ cell 1- ] literal xor
 	0 ?DO 8>> LOOP $FF and
    [ [THEN] ]
[ [ELSE] ]
    [ cell>bit 4 = [IF] ]
	dup [ 0 cell - ] Literal and @ swap 1 and
	IF  8>>  ELSE  $FF and  THEN
    [ [ELSE] ]
	dup [ cell  1- ] literal and 
	tuck - @ swap
	0 ?DO 8>> LOOP 255 and
    [ [THEN] ]
[ [THEN] ]
;
: 8>> 2/ 2/ 2/ 2/  2/ 2/ 2/ 2/ ;

c!	( c c_addr -- )		core	c_store
""Store @i{c} into the char at @i{c-addr}.""
*c_addr = c;
:
[ bigendian [IF] ]
    [ cell>bit 4 = [IF] ]
	tuck 1 and IF  $FF and  ELSE  8<<  THEN >r
	dup -2 and @ over 1 and cells masks + @ and
	r> or swap -2 and ! ;
	Create masks $00FF , $FF00 ,
    [ELSE] ]
	dup [ cell 1- ] literal and dup 
	[ cell 1- ] literal xor >r
	- dup @ $FF r@ 0 ?DO 8<< LOOP invert and
	rot $FF and r> 0 ?DO 8<< LOOP or swap ! ;
    [THEN]
[ELSE] ]
    [ cell>bit 4 = [IF] ]
	tuck 1 and IF  8<<  ELSE  $FF and  THEN >r
	dup -2 and @ over 1 and cells masks + @ and
	r> or swap -2 and ! ;
	Create masks $FF00 , $00FF ,
    [ELSE] ]
	dup [ cell 1- ] literal and dup >r
	- dup @ $FF r@ 0 ?DO 8<< LOOP invert and
	rot $FF and r> 0 ?DO 8<< LOOP or swap ! ;
    [THEN]
[THEN]
: 8<< 2* 2* 2* 2*  2* 2* 2* 2* ;

2!	( w1 w2 a_addr -- )		core	two_store
""Store @i{w2} into the cell at @i{c-addr} and @i{w1} into the next cell.""
a_addr[0] = w2;
a_addr[1] = w1;
:
 tuck ! cell+ ! ;

2@	( a_addr -- w1 w2 )		core	two_fetch
""@i{w2} is the content of the cell stored at @i{a-addr}, @i{w1} is
the content of the next cell.""
w2 = a_addr[0];
w1 = a_addr[1];
:
 dup cell+ @ swap @ ;

cell+	( a_addr1 -- a_addr2 )	core	cell_plus
""@code{1 cells +}""
a_addr2 = a_addr1+1;
:
 cell + ;

cells	( n1 -- n2 )		core
"" @i{n2} is the number of address units of @i{n1} cells.""
n2 = n1 * sizeof(Cell);
:
 [ cell
 2/ dup [IF] ] 2* [ [THEN]
 2/ dup [IF] ] 2* [ [THEN]
 2/ dup [IF] ] 2* [ [THEN]
 2/ dup [IF] ] 2* [ [THEN]
 drop ] ;

char+	( c_addr1 -- c_addr2 )	core	char_plus
""@code{1 chars +}.""
c_addr2 = c_addr1 + 1;
:
 1+ ;

(chars)	( n1 -- n2 )	gforth	paren_chars
n2 = n1 * sizeof(Char);
:
 ;

count	( c_addr1 -- c_addr2 u )	core
""@i{c-addr2} is the first character and @i{u} the length of the
counted string at @i{c-addr1}.""
u = *c_addr1;
c_addr2 = c_addr1+1;
:
 dup 1+ swap c@ ;

\g compiler

\+f83headerstring

(f83find)	( c_addr u f83name1 -- f83name2 )	new	paren_f83find
for (; f83name1 != NULL; f83name1 = (struct F83Name *)(f83name1->next))
  if ((UCell)F83NAME_COUNT(f83name1)==u &&
      memcasecmp(c_addr, f83name1->name, u)== 0 /* or inline? */)
    break;
f83name2=f83name1;
:
    BEGIN  dup WHILE  (find-samelen)  dup  WHILE
	>r 2dup r@ cell+ char+ capscomp  0=
	IF  2drop r>  EXIT  THEN
	r> @
    REPEAT  THEN  nip nip ;
: (find-samelen) ( u f83name1 -- u f83name2/0 )
    BEGIN  2dup cell+ c@ $1F and <> WHILE  @  dup 0= UNTIL  THEN ;
: capscomp ( c_addr1 u c_addr2 -- n )
 swap bounds
 ?DO  dup c@ I c@ <>
     IF  dup c@ toupper I c@ toupper =
     ELSE  true  THEN  WHILE  1+  LOOP  drop 0
 ELSE  c@ toupper I c@ toupper - unloop  THEN  sgn ;
: sgn ( n -- -1/0/1 )
 dup 0= IF EXIT THEN  0< 2* 1+ ;

\-

(listlfind)	( c_addr u longname1 -- longname2 )	new	paren_listlfind
longname2=listlfind(c_addr, u, longname1);
:
    BEGIN  dup WHILE  (findl-samelen)  dup  WHILE
	>r 2dup r@ cell+ cell+ capscomp  0=
	IF  2drop r>  EXIT  THEN
	r> @
    REPEAT  THEN  nip nip ;
: (findl-samelen) ( u longname1 -- u longname2/0 )
    BEGIN  2dup cell+ @ lcount-mask and <> WHILE  @  dup 0= UNTIL  THEN ;

\+hash

(hashlfind)	( c_addr u a_addr -- longname2 )	new	paren_hashlfind
longname2 = hashlfind(c_addr, u, a_addr);
:
 BEGIN  dup  WHILE
        2@ >r >r dup r@ cell+ @ lcount-mask and =
        IF  2dup r@ cell+ cell+ capscomp 0=
	    IF  2drop r> rdrop  EXIT  THEN  THEN
	rdrop r>
 REPEAT nip nip ;

(tablelfind)	( c_addr u a_addr -- longname2 )	new	paren_tablelfind
""A case-sensitive variant of @code{(hashfind)}""
longname2 = tablelfind(c_addr, u, a_addr);
:
 BEGIN  dup  WHILE
        2@ >r >r dup r@ cell+ @ lcount-mask and =
        IF  2dup r@ cell+ cell+ -text 0=
	    IF  2drop r> rdrop  EXIT  THEN  THEN
	rdrop r>
 REPEAT nip nip ;
: -text ( c_addr1 u c_addr2 -- n )
 swap bounds
 ?DO  dup c@ I c@ = WHILE  1+  LOOP  drop 0
 ELSE  c@ I c@ - unloop  THEN  sgn ;
: sgn ( n -- -1/0/1 )
 dup 0= IF EXIT THEN  0< 2* 1+ ;

(hashkey1)	( c_addr u ubits -- ukey )		gforth	paren_hashkey1
""ukey is the hash key for the string c_addr u fitting in ubits bits""
ukey = hashkey1(c_addr, u, ubits);
:
 dup rot-values + c@ over 1 swap lshift 1- >r
 tuck - 2swap r> 0 2swap bounds
 ?DO  dup 4 pick lshift swap 3 pick rshift or
      I c@ toupper xor
      over and  LOOP
 nip nip nip ;
Create rot-values
  5 c, 0 c, 1 c, 2 c, 3 c,  4 c, 5 c, 5 c, 5 c, 5 c,
  3 c, 5 c, 5 c, 5 c, 5 c,  7 c, 5 c, 5 c, 5 c, 5 c,
  7 c, 5 c, 5 c, 5 c, 5 c,  6 c, 5 c, 5 c, 5 c, 5 c,
  7 c, 5 c, 5 c,

\+

\+

(parse-white)	( c_addr1 u1 -- c_addr2 u2 )	gforth	paren_parse_white
struct Cellpair r=parse_white(c_addr1, u1);
c_addr2 = (Char *)(r.n1);
u2 = r.n2;
:
 BEGIN  dup  WHILE  over c@ bl <=  WHILE  1 /string
 REPEAT  THEN  2dup
 BEGIN  dup  WHILE  over c@ bl >   WHILE  1 /string
 REPEAT  THEN  nip - ;

aligned	( c_addr -- a_addr )	core
"" @i{a-addr} is the first aligned address greater than or equal to @i{c-addr}.""
a_addr = (Cell *)((((Cell)c_addr)+(sizeof(Cell)-1))&(-sizeof(Cell)));
:
 [ cell 1- ] Literal + [ -1 cells ] Literal and ;

faligned	( c_addr -- f_addr )	float	f_aligned
"" @i{f-addr} is the first float-aligned address greater than or equal to @i{c-addr}.""
f_addr = (Float *)((((Cell)c_addr)+(sizeof(Float)-1))&(-sizeof(Float)));
:
 [ 1 floats 1- ] Literal + [ -1 floats ] Literal and ;

\ threading stuff is currently only interesting if we have a compiler
\fhas? standardthreading has? compiler and [IF]
threading-method	( -- n )	gforth	threading_method
""0 if the engine is direct threaded. Note that this may change during
the lifetime of an image.""
#if defined(DOUBLY_INDIRECT)
n=2;
#else
# if defined(DIRECT_THREADED)
n=0;
# else
n=1;
# endif
#endif
:
 1 ;

\f[THEN]

\g hostos

key-file	( wfileid -- n )		gforth	paren_key_file
#ifdef HAS_FILE
fflush(stdout);
n = key((FILE*)wfileid);
#else
n = key(stdin);
#endif

key?-file	( wfileid -- n )		facility	key_q_file
#ifdef HAS_FILE
fflush(stdout);
n = key_query((FILE*)wfileid);
#else
n = key_query(stdin);
#endif

\+os

stdin	( -- wfileid )	gforth
wfileid = (Cell)stdin;

stdout	( -- wfileid )	gforth
wfileid = (Cell)stdout;

stderr	( -- wfileid )	gforth
wfileid = (Cell)stderr;

form	( -- urows ucols )	gforth
""The number of lines and columns in the terminal. These numbers may change
with the window size.""
/* we could block SIGWINCH here to get a consistent size, but I don't
 think this is necessary or always beneficial */
urows=rows;
ucols=cols;

flush-icache	( c_addr u -- )	gforth	flush_icache
""Make sure that the instruction cache of the processor (if there is
one) does not contain stale data at @i{c-addr} and @i{u} bytes
afterwards. @code{END-CODE} performs a @code{flush-icache}
automatically. Caveat: @code{flush-icache} might not work on your
installation; this is usually the case if direct threading is not
supported on your machine (take a look at your @file{machine.h}) and
your machine has a separate instruction cache. In such cases,
@code{flush-icache} does nothing instead of flushing the instruction
cache.""
FLUSH_ICACHE(c_addr,u);

(bye)	( n -- )	gforth	paren_bye
SUPER_END;
return (Label *)n;

(system)	( c_addr u -- wretval wior )	gforth	paren_system
#ifndef MSDOS
int old_tp=terminal_prepped;
deprep_terminal();
#endif
wretval=system(cstr(c_addr,u,1)); /* ~ expansion on first part of string? */
wior = IOR(wretval==-1 || (wretval==127 && errno != 0));
#ifndef MSDOS
if (old_tp)
  prep_terminal();
#endif

getenv	( c_addr1 u1 -- c_addr2 u2 )	gforth
""The string @i{c-addr1 u1} specifies an environment variable. The string @i{c-addr2 u2}
is the host operating system's expansion of that environment variable. If the
environment variable does not exist, @i{c-addr2 u2} specifies a string 0 characters
in length.""
/* close ' to keep fontify happy */
c_addr2 = getenv(cstr(c_addr1,u1,1));
u2 = (c_addr2 == NULL ? 0 : strlen(c_addr2));

open-pipe	( c_addr u wfam -- wfileid wior )	gforth	open_pipe
wfileid=(Cell)popen(cstr(c_addr,u,1),pfileattr[wfam]); /* ~ expansion of 1st arg? */
wior = IOR(wfileid==0); /* !! the man page says that errno is not set reliably */

close-pipe	( wfileid -- wretval wior )		gforth	close_pipe
wretval = pclose((FILE *)wfileid);
wior = IOR(wretval==-1);

time&date	( -- nsec nmin nhour nday nmonth nyear )	facility-ext	time_and_date
""Report the current time of day. Seconds, minutes and hours are numbered from 0.
Months are numbered from 1.""
#if 1
time_t now;
struct tm *ltime;
time(&now);
ltime=localtime(&now);
#else
struct timeval time1;
struct timezone zone1;
struct tm *ltime;
gettimeofday(&time1,&zone1);
/* !! Single Unix specification: 
   If tzp is not a null pointer, the behaviour is unspecified. */
ltime=localtime((time_t *)&time1.tv_sec);
#endif
nyear =ltime->tm_year+1900;
nmonth=ltime->tm_mon+1;
nday  =ltime->tm_mday;
nhour =ltime->tm_hour;
nmin  =ltime->tm_min;
nsec  =ltime->tm_sec;

ms	( n -- )	facility-ext
""Wait at least @i{n} milli-second.""
struct timeval timeout;
timeout.tv_sec=n/1000;
timeout.tv_usec=1000*(n%1000);
(void)select(0,0,0,0,&timeout);

allocate	( u -- a_addr wior )	memory
""Allocate @i{u} address units of contiguous data space. The initial
contents of the data space is undefined. If the allocation is successful,
@i{a-addr} is the start address of the allocated region and @i{wior}
is 0. If the allocation fails, @i{a-addr} is undefined and @i{wior}
is a non-zero I/O result code.""
a_addr = (Cell *)malloc(u?u:1);
wior = IOR(a_addr==NULL);

free	( a_addr -- wior )		memory
""Return the region of data space starting at @i{a-addr} to the system.
The region must originally have been obtained using @code{allocate} or
@code{resize}. If the operational is successful, @i{wior} is 0.
If the operation fails, @i{wior} is a non-zero I/O result code.""
free(a_addr);
wior = 0;

resize	( a_addr1 u -- a_addr2 wior )	memory
""Change the size of the allocated area at @i{a-addr1} to @i{u}
address units, possibly moving the contents to a different
area. @i{a-addr2} is the address of the resulting area.
If the operation is successful, @i{wior} is 0.
If the operation fails, @i{wior} is a non-zero
I/O result code. If @i{a-addr1} is 0, Gforth's (but not the Standard)
@code{resize} @code{allocate}s @i{u} address units.""
/* the following check is not necessary on most OSs, but it is needed
   on SunOS 4.1.2. */
/* close ' to keep fontify happy */
if (a_addr1==NULL)
  a_addr2 = (Cell *)malloc(u);
else
  a_addr2 = (Cell *)realloc(a_addr1, u);
wior = IOR(a_addr2==NULL);	/* !! Define a return code */

strerror	( n -- c_addr u )	gforth
c_addr = strerror(n);
u = strlen(c_addr);

strsignal	( n -- c_addr u )	gforth
c_addr = (Address)strsignal(n);
u = strlen(c_addr);

call-c	( w -- )	gforth	call_c
""Call the C function pointed to by @i{w}. The C function has to
access the stack itself. The stack pointers are exported in the global
variables @code{SP} and @code{FP}.""
/* This is a first attempt at support for calls to C. This may change in
   the future */
IF_fpTOS(fp[0]=fpTOS);
FP=fp;
SP=sp;
((void (*)())w)();
sp=SP;
fp=FP;
IF_spTOS(spTOS=sp[0]);
IF_fpTOS(fpTOS=fp[0]);

\+
\+file

close-file	( wfileid -- wior )		file	close_file
wior = IOR(fclose((FILE *)wfileid)==EOF);

open-file	( c_addr u wfam -- wfileid wior )	file	open_file
wfileid = (Cell)fopen(tilde_cstr(c_addr, u, 1), fileattr[wfam]);
wior =  IOR(wfileid == 0);

create-file	( c_addr u wfam -- wfileid wior )	file	create_file
Cell	fd;
fd = open(tilde_cstr(c_addr, u, 1), O_CREAT|O_TRUNC|ufileattr[wfam], 0666);
if (fd != -1) {
  wfileid = (Cell)fdopen(fd, fileattr[wfam]);
  wior = IOR(wfileid == 0);
} else {
  wfileid = 0;
  wior = IOR(1);
}

delete-file	( c_addr u -- wior )		file	delete_file
wior = IOR(unlink(tilde_cstr(c_addr, u, 1))==-1);

rename-file	( c_addr1 u1 c_addr2 u2 -- wior )	file-ext	rename_file
""Rename file @i{c_addr1 u1} to new name @i{c_addr2 u2}""
wior = rename_file(c_addr1, u1, c_addr2, u2);

file-position	( wfileid -- ud wior )	file	file_position
/* !! use tell and lseek? */
ud = OFF2UD(ftello((FILE *)wfileid));
wior = IOR(UD2OFF(ud)==-1);

reposition-file	( ud wfileid -- wior )	file	reposition_file
wior = IOR(fseeko((FILE *)wfileid, UD2OFF(ud), SEEK_SET)==-1);

file-size	( wfileid -- ud wior )	file	file_size
struct stat buf;
wior = IOR(fstat(fileno((FILE *)wfileid), &buf)==-1);
ud = OFF2UD(buf.st_size);

resize-file	( ud wfileid -- wior )	file	resize_file
wior = IOR(ftruncate(fileno((FILE *)wfileid), UD2OFF(ud))==-1);

read-file	( c_addr u1 wfileid -- u2 wior )	file	read_file
/* !! fread does not guarantee enough */
u2 = fread(c_addr, sizeof(Char), u1, (FILE *)wfileid);
wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
/* !! is the value of ferror errno-compatible? */
if (wior)
  clearerr((FILE *)wfileid);

(read-line)	( c_addr u1 wfileid -- u2 flag u3 wior ) file	paren_read_line
struct Cellquad r = read_line(c_addr, u1, wfileid);
u2   = r.n1;
flag = r.n2;
u3   = r.n3;
wior = r.n4;

\+

write-file	( c_addr u1 wfileid -- wior )	file	write_file
/* !! fwrite does not guarantee enough */
#ifdef HAS_FILE
{
  UCell u2 = fwrite(c_addr, sizeof(Char), u1, (FILE *)wfileid);
  wior = FILEIO(u2<u1 && ferror((FILE *)wfileid));
  if (wior)
    clearerr((FILE *)wfileid);
}
#else
TYPE(c_addr, u1);
#endif

emit-file	( c wfileid -- wior )	gforth	emit_file
#ifdef HAS_FILE
wior = FILEIO(putc(c, (FILE *)wfileid)==EOF);
if (wior)
  clearerr((FILE *)wfileid);
#else
PUTC(c);
#endif

\+file

flush-file	( wfileid -- wior )		file-ext	flush_file
wior = IOR(fflush((FILE *) wfileid)==EOF);

file-status	( c_addr u -- wfam wior )	file-ext	file_status
struct Cellpair r = file_status(c_addr, u);
wfam = r.n1;
wior = r.n2;

file-eof?	( wfileid -- flag )	gforth	file_eof_query
flag = FLAG(feof((FILE *) wfileid));

open-dir	( c_addr u -- wdirid wior )	gforth	open_dir
""Open the directory specified by @i{c-addr, u}
and return @i{dir-id} for futher access to it.""
wdirid = (Cell)opendir(tilde_cstr(c_addr, u, 1));
wior =  IOR(wdirid == 0);

read-dir	( c_addr u1 wdirid -- u2 flag wior )	gforth	read_dir
""Attempt to read the next entry from the directory specified
by @i{dir-id} to the buffer of length @i{u1} at address @i{c-addr}. 
If the attempt fails because there is no more entries,
@i{ior}=0, @i{flag}=0, @i{u2}=0, and the buffer is unmodified.
If the attempt to read the next entry fails because of any other reason, 
return @i{ior}<>0.
If the attempt succeeds, store file name to the buffer at @i{c-addr}
and return @i{ior}=0, @i{flag}=true and @i{u2} equal to the size of the file name.
If the length of the file name is greater than @i{u1}, 
store first @i{u1} characters from file name into the buffer and
indicate "name too long" with @i{ior}, @i{flag}=true, and @i{u2}=@i{u1}.""
struct dirent * dent;
dent = readdir((DIR *)wdirid);
wior = 0;
flag = -1;
if(dent == NULL) {
  u2 = 0;
  flag = 0;
} else {
  u2 = strlen(dent->d_name);
  if(u2 > u1) {
    u2 = u1;
    wior = -512-ENAMETOOLONG;
  }
  memmove(c_addr, dent->d_name, u2);
}

close-dir	( wdirid -- wior )	gforth	close_dir
""Close the directory specified by @i{dir-id}.""
wior = IOR(closedir((DIR *)wdirid));

filename-match	( c_addr1 u1 c_addr2 u2 -- flag )	gforth	match_file
char * string = cstr(c_addr1, u1, 1);
char * pattern = cstr(c_addr2, u2, 0);
flag = FLAG(!fnmatch(pattern, string, 0));

\+

newline	( -- c_addr u )	gforth
""String containing the newline sequence of the host OS""
char newline[] = {
#if DIRSEP=='/'
/* Unix */
'\n'
#else
/* DOS, Win, OS/2 */
'\r','\n'
#endif
};
c_addr=newline;
u=sizeof(newline);
:
 "newline count ;
Create "newline e? crlf [IF] 2 c, $0D c, [ELSE] 1 c, [THEN] $0A c,

\+os

utime	( -- dtime )	gforth
""Report the current time in microseconds since some epoch.""
struct timeval time1;
gettimeofday(&time1,NULL);
dtime = timeval2us(&time1);

cputime ( -- duser dsystem ) gforth
""duser and dsystem are the respective user- and system-level CPU
times used since the start of the Forth system (excluding child
processes), in microseconds (the granularity may be much larger,
however).  On platforms without the getrusage call, it reports elapsed
time (since some epoch) for duser and 0 for dsystem.""
#ifdef HAVE_GETRUSAGE
struct rusage usage;
getrusage(RUSAGE_SELF, &usage);
duser = timeval2us(&usage.ru_utime);
dsystem = timeval2us(&usage.ru_stime);
#else
struct timeval time1;
gettimeofday(&time1,NULL);
duser = timeval2us(&time1);
#ifndef BUGGY_LONG_LONG
dsystem = (DCell)0;
#else
dsystem=(DCell){0,0};
#endif
#endif

\+

\+floating

\g floating

f=	( r1 r2 -- f )		gforth	f_equals
#line 1854
f = FLAG(r1==r2);
#line 1854
:
#line 1854
    [ char fx char 0 = [IF]
#line 1854
	] IF false ELSE true THEN [
#line 1854
    [ELSE]
#line 1854
	] xor 0= [
#line 1854
    [THEN] ] ;
#line 1854

#line 1854
f<>	( r1 r2 -- f )		gforth	f_not_equals
#line 1854
f = FLAG(r1!=r2);
#line 1854
:
#line 1854
    [ char fx char 0 = [IF]
#line 1854
	] IF true ELSE false THEN [
#line 1854
    [ELSE]
#line 1854
	] xor 0<> [
#line 1854
    [THEN] ] ;
#line 1854

#line 1854
f<	( r1 r2 -- f )		float	f_less_than
#line 1854
f = FLAG(r1<r2);
#line 1854
:
#line 1854
    [ char fx char 0 = [IF]
#line 1854
	] MINI and 0<> [
#line 1854
    [ELSE] char fx char u = [IF]
#line 1854
	]   2dup xor 0<  IF nip ELSE - THEN 0<  [
#line 1854
	[ELSE]
#line 1854
	    ] MINI xor >r MINI xor r> u< [
#line 1854
	[THEN]
#line 1854
    [THEN] ] ;
#line 1854

#line 1854
f>	( r1 r2 -- f )		gforth	f_greater_than
#line 1854
f = FLAG(r1>r2);
#line 1854
:
#line 1854
    [ char fx char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1854
    f< ;
#line 1854

#line 1854
f<=	( r1 r2 -- f )		gforth	f_less_or_equal
#line 1854
f = FLAG(r1<=r2);
#line 1854
:
#line 1854
    f> 0= ;
#line 1854

#line 1854
f>=	( r1 r2 -- f )		gforth	f_greater_or_equal
#line 1854
f = FLAG(r1>=r2);
#line 1854
:
#line 1854
    [ char fx char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1854
    f<= ;
#line 1854

#line 1854

f0=	( r -- f )		float	f_zero_equals
#line 1855
f = FLAG(r==0.);
#line 1855
:
#line 1855
    [ char f0x char 0 = [IF]
#line 1855
	] IF false ELSE true THEN [
#line 1855
    [ELSE]
#line 1855
	] xor 0= [
#line 1855
    [THEN] ] ;
#line 1855

#line 1855
f0<>	( r -- f )		gforth	f_zero_not_equals
#line 1855
f = FLAG(r!=0.);
#line 1855
:
#line 1855
    [ char f0x char 0 = [IF]
#line 1855
	] IF true ELSE false THEN [
#line 1855
    [ELSE]
#line 1855
	] xor 0<> [
#line 1855
    [THEN] ] ;
#line 1855

#line 1855
f0<	( r -- f )		float	f_zero_less_than
#line 1855
f = FLAG(r<0.);
#line 1855
:
#line 1855
    [ char f0x char 0 = [IF]
#line 1855
	] MINI and 0<> [
#line 1855
    [ELSE] char f0x char u = [IF]
#line 1855
	]   2dup xor 0<  IF nip ELSE - THEN 0<  [
#line 1855
	[ELSE]
#line 1855
	    ] MINI xor >r MINI xor r> u< [
#line 1855
	[THEN]
#line 1855
    [THEN] ] ;
#line 1855

#line 1855
f0>	( r -- f )		gforth	f_zero_greater_than
#line 1855
f = FLAG(r>0.);
#line 1855
:
#line 1855
    [ char f0x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1855
    f0< ;
#line 1855

#line 1855
f0<=	( r -- f )		gforth	f_zero_less_or_equal
#line 1855
f = FLAG(r<=0.);
#line 1855
:
#line 1855
    f0> 0= ;
#line 1855

#line 1855
f0>=	( r -- f )		gforth	f_zero_greater_or_equal
#line 1855
f = FLAG(r>=0.);
#line 1855
:
#line 1855
    [ char f0x char 0 = [IF] ] negate [ [ELSE] ] swap [ [THEN] ]
#line 1855
    f0<= ;
#line 1855

#line 1855


d>f	( d -- r )		float	d_to_f
#ifdef BUGGY_LONG_LONG
extern double ldexp(double x, int exp);
if (d.hi<0) {
  DCell d2=dnegate(d);
  r = -(ldexp((Float)d2.hi,CELL_BITS) + (Float)d2.lo);
} else
  r = ldexp((Float)d.hi,CELL_BITS) + (Float)d.lo;
#else
r = d;
#endif

f>d	( r -- d )		float	f_to_d
extern DCell double2ll(Float r);
d = double2ll(r);

f!	( r f_addr -- )	float	f_store
""Store @i{r} into the float at address @i{f-addr}.""
*f_addr = r;

f@	( f_addr -- r )	float	f_fetch
""@i{r} is the float at address @i{f-addr}.""
r = *f_addr;

df@	( df_addr -- r )	float-ext	d_f_fetch
""Fetch the double-precision IEEE floating-point value @i{r} from the address @i{df-addr}.""
#ifdef IEEE_FP
r = *df_addr;
#else
!! df@
#endif

df!	( r df_addr -- )	float-ext	d_f_store
""Store @i{r} as double-precision IEEE floating-point value to the
address @i{df-addr}.""
#ifdef IEEE_FP
*df_addr = r;
#else
!! df!
#endif

sf@	( sf_addr -- r )	float-ext	s_f_fetch
""Fetch the single-precision IEEE floating-point value @i{r} from the address @i{sf-addr}.""
#ifdef IEEE_FP
r = *sf_addr;
#else
!! sf@
#endif

sf!	( r sf_addr -- )	float-ext	s_f_store
""Store @i{r} as single-precision IEEE floating-point value to the
address @i{sf-addr}.""
#ifdef IEEE_FP
*sf_addr = r;
#else
!! sf!
#endif

f+	( r1 r2 -- r3 )	float	f_plus
r3 = r1+r2;

f-	( r1 r2 -- r3 )	float	f_minus
r3 = r1-r2;

f*	( r1 r2 -- r3 )	float	f_star
r3 = r1*r2;

f/	( r1 r2 -- r3 )	float	f_slash
r3 = r1/r2;

f**	( r1 r2 -- r3 )	float-ext	f_star_star
""@i{r3} is @i{r1} raised to the @i{r2}th power.""
r3 = pow(r1,r2);

fnegate	( r1 -- r2 )	float	f_negate
r2 = - r1;

fdrop	( r -- )		float	f_drop

fdup	( r -- r r )	float	f_dupe

fswap	( r1 r2 -- r2 r1 )	float	f_swap

fover	( r1 r2 -- r1 r2 r1 )	float	f_over

frot	( r1 r2 r3 -- r2 r3 r1 )	float	f_rote

fnip	( r1 r2 -- r2 )	gforth	f_nip

ftuck	( r1 r2 -- r2 r1 r2 )	gforth	f_tuck

float+	( f_addr1 -- f_addr2 )	float	float_plus
""@code{1 floats +}.""
f_addr2 = f_addr1+1;

floats	( n1 -- n2 )	float
""@i{n2} is the number of address units of @i{n1} floats.""
n2 = n1*sizeof(Float);

floor	( r1 -- r2 )	float
""Round towards the next smaller integral value, i.e., round toward negative infinity.""
/* !! unclear wording */
r2 = floor(r1);

fround	( r1 -- r2 )	gforth	f_round
""Round to the nearest integral value.""
r2 = rint(r1);

fmax	( r1 r2 -- r3 )	float	f_max
if (r1<r2)
  r3 = r2;
else
  r3 = r1;

fmin	( r1 r2 -- r3 )	float	f_min
if (r1<r2)
  r3 = r1;
else
  r3 = r2;

represent	( r c_addr u -- n f1 f2 )	float
char *sig;
size_t siglen;
int flag;
int decpt;
sig=ecvt(r, u, &decpt, &flag);
n=(r==0. ? 1 : decpt);
f1=FLAG(flag!=0);
f2=FLAG(isdigit((unsigned)(sig[0]))!=0);
siglen=strlen(sig);
if (siglen>u) /* happens in glibc-2.1.3 if 999.. is rounded up */
  siglen=u;
memcpy(c_addr,sig,siglen);
memset(c_addr+siglen,f2?'0':' ',u-siglen);

>float	( c_addr u -- flag )	float	to_float
""Actual stack effect: ( c_addr u -- r t | f ).  Attempt to convert the
character string @i{c-addr u} to internal floating-point
representation. If the string represents a valid floating-point number
@i{r} is placed on the floating-point stack and @i{flag} is
true. Otherwise, @i{flag} is false. A string of blanks is a special
case and represents the floating-point number 0.""
Float r;
flag = to_float(c_addr, u, &r);
if (flag) {
  IF_fpTOS(fp[0] = fpTOS);
  fp += -1;
  fpTOS = r;
}

fabs	( r1 -- r2 )	float-ext	f_abs
r2 = fabs(r1);

facos	( r1 -- r2 )	float-ext	f_a_cos
r2 = acos(r1);

fasin	( r1 -- r2 )	float-ext	f_a_sine
r2 = asin(r1);

fatan	( r1 -- r2 )	float-ext	f_a_tan
r2 = atan(r1);

fatan2	( r1 r2 -- r3 )	float-ext	f_a_tan_two
""@i{r1/r2}=tan(@i{r3}). ANS Forth does not require, but probably
intends this to be the inverse of @code{fsincos}. In gforth it is.""
r3 = atan2(r1,r2);

fcos	( r1 -- r2 )	float-ext	f_cos
r2 = cos(r1);

fexp	( r1 -- r2 )	float-ext	f_e_x_p
r2 = exp(r1);

fexpm1	( r1 -- r2 )	float-ext	f_e_x_p_m_one
""@i{r2}=@i{e}**@i{r1}@minus{}1""
#ifdef HAVE_EXPM1
extern double
#ifdef NeXT
              const
#endif
                    expm1(double);
r2 = expm1(r1);
#else
r2 = exp(r1)-1.;
#endif

fln	( r1 -- r2 )	float-ext	f_l_n
r2 = log(r1);

flnp1	( r1 -- r2 )	float-ext	f_l_n_p_one
""@i{r2}=ln(@i{r1}+1)""
#ifdef HAVE_LOG1P
extern double
#ifdef NeXT
              const
#endif
                    log1p(double);
r2 = log1p(r1);
#else
r2 = log(r1+1.);
#endif

flog	( r1 -- r2 )	float-ext	f_log
""The decimal logarithm.""
r2 = log10(r1);

falog	( r1 -- r2 )	float-ext	f_a_log
""@i{r2}=10**@i{r1}""
extern double pow10(double);
r2 = pow10(r1);

fsin	( r1 -- r2 )	float-ext	f_sine
r2 = sin(r1);

fsincos	( r1 -- r2 r3 )	float-ext	f_sine_cos
""@i{r2}=sin(@i{r1}), @i{r3}=cos(@i{r1})""
r2 = sin(r1);
r3 = cos(r1);

fsqrt	( r1 -- r2 )	float-ext	f_square_root
r2 = sqrt(r1);

ftan	( r1 -- r2 )	float-ext	f_tan
r2 = tan(r1);
:
 fsincos f/ ;

fsinh	( r1 -- r2 )	float-ext	f_cinch
r2 = sinh(r1);
:
 fexpm1 fdup fdup 1. d>f f+ f/ f+ f2/ ;

fcosh	( r1 -- r2 )	float-ext	f_cosh
r2 = cosh(r1);
:
 fexp fdup 1/f f+ f2/ ;

ftanh	( r1 -- r2 )	float-ext	f_tan_h
r2 = tanh(r1);
:
 f2* fexpm1 fdup 2. d>f f+ f/ ;

fasinh	( r1 -- r2 )	float-ext	f_a_cinch
r2 = asinh(r1);
:
 fdup fdup f* 1. d>f f+ fsqrt f/ fatanh ;

facosh	( r1 -- r2 )	float-ext	f_a_cosh
r2 = acosh(r1);
:
 fdup fdup f* 1. d>f f- fsqrt f+ fln ;

fatanh	( r1 -- r2 )	float-ext	f_a_tan_h
r2 = atanh(r1);
:
 fdup f0< >r fabs 1. d>f fover f- f/  f2* flnp1 f2/
 r> IF  fnegate  THEN ;

sfloats	( n1 -- n2 )	float-ext	s_floats
""@i{n2} is the number of address units of @i{n1}
single-precision IEEE floating-point numbers.""
n2 = n1*sizeof(SFloat);

dfloats	( n1 -- n2 )	float-ext	d_floats
""@i{n2} is the number of address units of @i{n1}
double-precision IEEE floating-point numbers.""
n2 = n1*sizeof(DFloat);

sfaligned	( c_addr -- sf_addr )	float-ext	s_f_aligned
""@i{sf-addr} is the first single-float-aligned address greater
than or equal to @i{c-addr}.""
sf_addr = (SFloat *)((((Cell)c_addr)+(sizeof(SFloat)-1))&(-sizeof(SFloat)));
:
 [ 1 sfloats 1- ] Literal + [ -1 sfloats ] Literal and ;

dfaligned	( c_addr -- df_addr )	float-ext	d_f_aligned
""@i{df-addr} is the first double-float-aligned address greater
than or equal to @i{c-addr}.""
df_addr = (DFloat *)((((Cell)c_addr)+(sizeof(DFloat)-1))&(-sizeof(DFloat)));
:
 [ 1 dfloats 1- ] Literal + [ -1 dfloats ] Literal and ;

v*	( f_addr1 nstride1 f_addr2 nstride2 ucount -- r ) gforth v_star
""dot-product: r=v1*v2.  The first element of v1 is at f_addr1, the
next at f_addr1+nstride1 and so on (similar for v2). Both vectors have
ucount elements.""
r = v_star(f_addr1, nstride1, f_addr2, nstride2, ucount);
:
 >r swap 2swap swap 0e r> 0 ?DO
     dup f@ over + 2swap dup f@ f* f+ over + 2swap
 LOOP 2drop 2drop ; 

faxpy	( ra f_x nstridex f_y nstridey ucount -- )	gforth
""vy=ra*vx+vy""
faxpy(ra, f_x, nstridex, f_y, nstridey, ucount);
:
 >r swap 2swap swap r> 0 ?DO
     fdup dup f@ f* over + 2swap dup f@ f+ dup f! over + 2swap
 LOOP 2drop 2drop fdrop ;

\+

\ The following words access machine/OS/installation-dependent
\   Gforth internals
\ !! how about environmental queries DIRECT-THREADED,
\   INDIRECT-THREADED, TOS-CACHED, FTOS-CACHED, CODEFIELD-DOES */

\ local variable implementation primitives

\+glocals

\g locals

@local#	( #noffset -- w )	gforth	fetch_local_number
w = *(Cell *)(lp+noffset);

@local0	( -- w )	new	fetch_local_zero
w = ((Cell *)lp)[0];

@local1	( -- w )	new	fetch_local_four
w = ((Cell *)lp)[1];

@local2	( -- w )	new	fetch_local_eight
w = ((Cell *)lp)[2];

@local3	( -- w )	new	fetch_local_twelve
w = ((Cell *)lp)[3];

\+floating

f@local#	( #noffset -- r )	gforth	f_fetch_local_number
r = *(Float *)(lp+noffset);

f@local0	( -- r )	new	f_fetch_local_zero
r = ((Float *)lp)[0];

f@local1	( -- r )	new	f_fetch_local_eight
r = ((Float *)lp)[1];

\+

laddr#	( #noffset -- c_addr )	gforth	laddr_number
/* this can also be used to implement lp@ */
c_addr = (Char *)(lp+noffset);

lp+!#	( #noffset -- )	gforth	lp_plus_store_number
""used with negative immediate values it allocates memory on the
local stack, a positive immediate argument drops memory from the local
stack""
lp += noffset;

lp-	( -- )	new	minus_four_lp_plus_store
lp += -sizeof(Cell);

lp+	( -- )	new	eight_lp_plus_store
lp += sizeof(Float);

lp+2	( -- )	new	sixteen_lp_plus_store
lp += 2*sizeof(Float);

lp!	( c_addr -- )	gforth	lp_store
lp = (Address)c_addr;

>l	( w -- )	gforth	to_l
lp -= sizeof(Cell);
*(Cell *)lp = w;

\+floating

f>l	( r -- )	gforth	f_to_l
lp -= sizeof(Float);
*(Float *)lp = r;

fpick	( u -- r )		gforth
""Actually the stack effect is @code{ r0 ... ru u -- r0 ... ru r0 }.""
r = fp[u+1]; /* +1, because update of fp happens before this fragment */
:
 floats fp@ + f@ ;

\+
\+

\+OS

\g syslib

open-lib	( c_addr1 u1 -- u2 )	gforth	open_lib
#if defined(HAVE_LIBDL) || defined(HAVE_DLOPEN)
#ifndef RTLD_GLOBAL
#define RTLD_GLOBAL 0
#endif
u2=(UCell) dlopen(cstr(c_addr1, u1, 1), RTLD_GLOBAL | RTLD_LAZY);
#else
#  ifdef _WIN32
u2 = (Cell) GetModuleHandle(cstr(c_addr1, u1, 1));
#  else
#warning Define open-lib!
u2 = 0;
#  endif
#endif

lib-sym	( c_addr1 u1 u2 -- u3 )	gforth	lib_sym
#if defined(HAVE_LIBDL) || defined(HAVE_DLOPEN)
u3 = (UCell) dlsym((void*)u2,cstr(c_addr1, u1, 1));
#else
#  ifdef _WIN32
u3 = (Cell) GetProcAddress((HMODULE)u2, cstr(c_addr1, u1, 1));
#  else
#warning Define lib-sym!
u3 = 0;
#  endif
#endif

wcall	( u -- )	gforth
IF_fpTOS(fp[0]=fpTOS);
FP=fp;
sp=(Cell*)(SYSCALL(Cell*(*)(Cell *, void *))u)(sp, &FP);
fp=FP;
IF_spTOS(spTOS=sp[0];)
IF_fpTOS(fpTOS=fp[0]);

\+FFCALL

av-start-void	( c_addr -- )	gforth  av_start_void
av_start_void(alist, c_addr);

av-start-int	( c_addr -- )	gforth  av_start_int
av_start_int(alist, c_addr, &irv);

av-start-float	( c_addr -- )	gforth  av_start_float
av_start_float(alist, c_addr, &frv);

av-start-double	( c_addr -- )	gforth  av_start_double
av_start_double(alist, c_addr, &drv);

av-start-longlong	( c_addr -- )	gforth  av_start_longlong
av_start_longlong(alist, c_addr, &llrv);

av-start-ptr	( c_addr -- )	gforth  av_start_ptr
av_start_ptr(alist, c_addr, void*, &prv);

av-int  ( w -- )  gforth  av_int
av_int(alist, w);

av-float	( r -- )	gforth  av_float
av_float(alist, r);

av-double	( r -- )	gforth  av_double
av_double(alist, r);

av-longlong	( d -- )	gforth  av_longlong
av_longlong(alist, d);

av-ptr	( c_addr -- )	gforth  av_ptr
av_ptr(alist, void*, c_addr);

av-int-r  ( R:w -- )  gforth  av_int_r
av_int(alist, w);

av-float-r	( -- )	gforth  av_float_r
float r = *(Float*)lp;
lp += sizeof(Float);
av_float(alist, r);

av-double-r	( -- )	gforth  av_double_r
double r = *(Float*)lp;
lp += sizeof(Float);
av_double(alist, r);

av-longlong-r	( R:d -- )	gforth  av_longlong_r
av_longlong(alist, d);

av-ptr-r	( R:c_addr -- )	gforth  av_ptr_r
av_ptr(alist, void*, c_addr);

av-call-void	( -- )	gforth  av_call_void
SAVE_REGS
av_call(alist);
REST_REGS

av-call-int	( -- w )	gforth  av_call_int
SAVE_REGS
av_call(alist);
REST_REGS
w = irv;

av-call-float	( -- r )	gforth  av_call_float
SAVE_REGS
av_call(alist);
REST_REGS
r = frv;

av-call-double	( -- r )	gforth  av_call_double
SAVE_REGS
av_call(alist);
REST_REGS
r = drv;

av-call-longlong	( -- d )	gforth  av_call_longlong
SAVE_REGS
av_call(alist);
REST_REGS
d = llrv;

av-call-ptr	( -- c_addr )	gforth  av_call_ptr
SAVE_REGS
av_call(alist);
REST_REGS
c_addr = prv;

alloc-callback	( a_ip -- c_addr )	gforth	alloc_callback
c_addr = (char *)alloc_callback(engine_callback, (Xt *)a_ip);

va-start-void	( -- )	gforth	va_start_void
va_start_void(clist);

va-start-int	( -- )	gforth	va_start_int
va_start_int(clist);

va-start-longlong	( -- )	gforth	va_start_longlong
va_start_longlong(clist);

va-start-ptr	( -- )	gforth	va_start_ptr
va_start_ptr(clist, (char *));

va-start-float	( -- )	gforth	va_start_float
va_start_float(clist);

va-start-double	( -- )	gforth	va_start_double
va_start_double(clist);

va-arg-int	( -- w )	gforth	va_arg_int
w = va_arg_int(clist);

va-arg-longlong	( -- d )	gforth	va_arg_longlong
d = va_arg_longlong(clist);

va-arg-ptr	( -- c_addr )	gforth	va_arg_ptr
c_addr = (char *)va_arg_ptr(clist,char*);

va-arg-float	( -- r )	gforth	va_arg_float
r = va_arg_float(clist);

va-arg-double	( -- r )	gforth	va_arg_double
r = va_arg_double(clist);

va-return-void ( -- )	gforth va_return_void
va_return_void(clist);
return 0;

va-return-int ( w -- )	gforth va_return_int
va_return_int(clist, w);
return 0;

va-return-ptr ( c_addr -- )	gforth va_return_ptr
va_return_ptr(clist, void *, c_addr);
return 0;

va-return-longlong ( d -- )	gforth va_return_longlong
va_return_longlong(clist, d);
return 0;

va-return-float ( r -- )	gforth va_return_float
va_return_float(clist, r);
return 0;

va-return-double ( r -- )	gforth va_return_double
va_return_double(clist, r);
return 0;

\+

\+OLDCALL

#line 2432

#line 2435

\ argflist(argnum): Forth argument list
#line 2439

\ argdlist(argnum): declare C's arguments
#line 2443

\ argclist(argnum): pass C's arguments
#line 2447

\ icall(argnum)
#line 2453

#line 2458


\ close ' to keep fontify happy

icall0	( u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)())u)();
#line 2462

#line 2462
icall1	( u1 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell))u)(u1);
#line 2462

#line 2462
icall2	( u1 u2 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell, Cell))u)(u1, u2);
#line 2462

#line 2462
icall3	( u1 u2 u3 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell))u)(u1, u2, u3);
#line 2462

#line 2462
icall4	( u1 u2 u3 u4 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4);
#line 2462

#line 2462
icall5	( u1 u2 u3 u4 u5 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5);
#line 2462

#line 2462
icall6	( u1 u2 u3 u4 u5 u6 u -- uret )	gforth
#line 2462
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6);
#line 2462

#line 2462

icall20	( u1 u2 u3 u4 u5 u6 u7 u8 u9 u10 u11 u12 u13 u14 u15 u16 u17 u18 u19 u20 u -- uret )	gforth
#line 2463
uret = (SYSCALL(Cell(*)(Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12, u13, u14, u15, u16, u17, u18, u19, u20);
#line 2463

#line 2463

fcall0	( u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)())u)();
#line 2464

#line 2464
fcall1	( u1 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell))u)(u1);
#line 2464

#line 2464
fcall2	( u1 u2 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell, Cell))u)(u1, u2);
#line 2464

#line 2464
fcall3	( u1 u2 u3 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell, Cell, Cell))u)(u1, u2, u3);
#line 2464

#line 2464
fcall4	( u1 u2 u3 u4 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4);
#line 2464

#line 2464
fcall5	( u1 u2 u3 u4 u5 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5);
#line 2464

#line 2464
fcall6	( u1 u2 u3 u4 u5 u6 u -- rret )	gforth
#line 2464
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6);
#line 2464

#line 2464

fcall20	( u1 u2 u3 u4 u5 u6 u7 u8 u9 u10 u11 u12 u13 u14 u15 u16 u17 u18 u19 u20 u -- rret )	gforth
#line 2465
rret = (SYSCALL(Float(*)(Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell, Cell))u)(u1, u2, u3, u4, u5, u6, u7, u8, u9, u10, u11, u12, u13, u14, u15, u16, u17, u18, u19, u20);
#line 2465

#line 2465


\+
\+

\g peephole

\+peephole

compile-prim1 ( a_prim -- ) gforth compile_prim1
""compile prim (incl. immargs) at @var{a_prim}""
compile_prim1(a_prim);

finish-code ( -- ) gforth finish_code
""Perform delayed steps in code generation (branch resolution, I-cache
flushing).""
finish_code();

forget-dyncode ( c_code -- f ) gforth-internal forget_dyncode
f = forget_dyncode(c_code);

decompile-prim ( a_code -- a_prim ) gforth-internal decompile_prim
""a_prim is the code address of the primitive that has been
compile_prim1ed to a_code""
a_prim = (Cell *)decompile_code((Label)a_code);

\ set-next-code and call2 do not appear in images and can be
\ renumbered arbitrarily

set-next-code ( #w -- ) gforth set_next_code
#ifdef NO_IP
next_code = (Label)w;
#endif

call2 ( #a_callee #a_ret_addr -- R:a_ret_addr ) gforth
/* call with explicit return address */
#ifdef NO_IP
INST_TAIL;
JUMP(a_callee);
#else
assert(0);
#endif

tag-offsets ( -- a_addr ) gforth tag_offsets
extern Cell groups[32];
a_addr = groups;

\+

\g static_super

\C #if !defined(GFORTH_DEBUGGING) && !defined(INDIRECT_THREADED) && !defined(DOUBLY_INDIRECT) && !defined(VM_PROFILING)

#line 1 "peeprules.vmg"
\ taken from David Gregg's EuroForth 2001 paper; omitted some sequences
super1 = lit +
super2 = lit call
super3 = lit @
super4 = lit @ call
super5 = @ call
super6 = lit !
super7 = lit lit
super8 = dup lit
super9 = ! lit
super10 = lit ! lit
super11 = ! ;s
super12 = lit + @
super13 = 0= ?branch
super14 = dup call
super15 = useraddr @
super16 = + @
super17 = lit @ ?branch
super18 = lit ! ;s
super19 = lit @ and
super20 = = ?branch
super21 = lit lit !
super22 = @ ?branch
super23 = useraddr !
super24 = dup ?branch
super25 = @ ;s
super26 = lit @ +
super27 = dup @
#line 2518 "./prim"


\C #endif

\g end
