/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: edit.h
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    

#ifndef __EDIT_H
#define __EDIT_H

typedef enum { 
  UNDO_ACTION_INSERT, 
  UNDO_ACTION_DELETE,
  UNDO_ACTION_REPLACE,
  UNDO_ACTION_NONE,
} undoActionType;

/* functions of Edit menu */
void editMenu_Cut();
void editMenu_Copy();
void editMenu_Paste();
void editMenu_Undo();
void editMenu_Redo();
void editMenu_SelectAll();
void editMenu_DeleteLine();
void editMenu_Find();
void editMenu_Replace();
void editMenu_ToggleSelectMode();
void remove_selected_text(int recordAction);
void clear_selected_range();
void swap_lines();
void swap_chars();
void initEdit();
void undoAddChar(undoActionType utype, int lwhere, int cwhere, char what);
int  undoAddUtfChar(undoActionType utype, int lwhere, int cwhere, char *rwhat);

/* 
 * boolean telling if we are in selecting mode 
 * (i.e. using SHIFT+Arrow to select) 
 */
int SELECTING;
int SELECTED;
int CLIPBOARD_IS_EMPTY;
int total_lines_in_clipboard;
char *clipboard;

typedef struct { //structure defining a point by its position in
  int nline;	 //line number (zero-based), and
  int nchar;	 //char number (zero-based)
} point;
//char selected_text[MAX_CLIPBOARD_SIZE];
point sel_range_start;//start point of selected text
point sel_range_end;  //end point of selected text

struct undostruct
{
    undoActionType type;
    int   lineStart,  charStart;
    int   lineCount,  byteCount;
    int  rlineCount, rbyteCount;
    char *text;
    char *rtext;
    struct undostruct *prev, *next;
};

//definitions for the find/replace functions
void _replace(int pos, char *f, char *r);
void _do_replace(int pos, char *f, char *r);
void _find(char *f);

void calcTotalCharsInLine(int pos);
void calcTotalCharsInLineC(int pos, int *carry);
int utfstrlen(char *str);
int fixViewPostUndo(int first);

#endif
