/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2013, 2014, 2015, 2016, 2017, 2018 (c)
 * 
 *    file: defs.h
 *    This file is part of Prime.
 *
 *    Prime is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    Prime is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with Prime.  If not, see <http://www.gnu.org/licenses/>.
 */    

/**********************************************
  This file contains definitions for constants 
  and functions used by the Prime program.
 **********************************************/
#ifndef __Prime_H
#define __Prime_H

//#define PRODUCTION  1

#ifdef PRODUCTION
#   define dialogs_header   "../corelib/dialogs.h"
#   define kbd_header       "../corelib/kbd.h"
#else
#   define dialogs_header   "dialogs.h"
#   define kbd_header       "kbd.h"
#endif

#include <stdio.h>
#include <errno.h>
#include <dirent.h>
#include <sys/stat.h>
#include dialogs_header
#include kbd_header

#define MAXENTRIES		2048
int MAX_DIR_NAME_LEN;
int MAX_FILE_NAME_LEN;

static int one(const struct dirent *unused) 
{
  return 1;
}

//Function prototypes//
void init();
int read_config_file();
int write_config_file_defaults();
void scanDir(char *dir);
void drawMenuBar(int x, int y, int w);
void refreshAll();
void refreshWindows();
void refreshDirView();
void refreshFileView();
void refreshBottomView();
void showMenu(int index);
void showErrorMsgBox(char *msg, char *arg);
void showPropertiesDialog();
void toggleSelected();
void exit_gracefully();

//Main menu items//
#define totalMainMenus	4	//total items in main menu bar
#define fTotal		5	//total items in file menu
#define eTotal		7	//total items in edit menu
#define oTotal		3	//total items in options menu
#define hTotal		4	//total items in help menu
char *menu[4];
char *fileMenu[6];
char *editMenu[8];
char *optionsMenu[3];
char *helpMenu[5];

int numVisDirs, firstVisDir, selectedDir, totalDirs;
int numVisFiles, firstVisFile, selectedFile, totalFiles;
char *dirHighLight;	//the hightlight bar to delineate the selected dir
char *fileHighLight;	//the hightlight bar to delineate the selected file
int activeWindow;	//int value indicating which window is active

//values used in the activeWindow variable//
#define DIR_WIN		1
#define FILE_WIN	2
#define FILE_MENU	3
#define EDIT_MENU	4
#define HELP_MENU	5

//optional -- ask user for file name to export to
void exportTree(int showFileNameDialogBox); 
void exportTreeFromCommandLine(char *d, char *f);

//function called by exportTree() function
void scanThisDir(char tmp[], int level, int showProgress);

//int alphasort(const struct dirent **a, const struct dirent **b);

#ifdef MAIN
#   define MAIN_EXTERN
#else
#   define MAIN_EXTERN   extern
#endif

MAIN_EXTERN char *cwd;	//the current working directory
MAIN_EXTERN int cwdlen;

#ifdef ARGS
#   define ARGS_EXTERN
#else
#   define ARGS_EXTERN   extern
#endif

/* defined in args.c */
ARGS_EXTERN char *config_file_name;//string holding the name of the config file
ARGS_EXTERN FILE *config_file;
ARGS_EXTERN int GNU_DOS_LEVEL;

//Array to store different colors that will be given
//to files of different types.. The array is indexed by
//a character indicating the type of file/dir.. Currently,
//the chars are:
//'d' for directories
//'x' for executable files
//'r' for regular files
//'l' for links
//'a' for archives
//'h' for hidden files
//'p' for picture files
//'%' special case, used to indicate that the directory is empty
char FILE_DIR_COLOR[26];

/* defined in args.c */
extern char *prime_ver;
extern void parse_args(int argc, char **argv);
extern char *prime_ver;
extern char *copyright_notice;
void LOG(char *msg, char *arg);

extern int fcloseall (void);    /* stdio.h */
extern char * strcasestr (const char *HAYSTACK, const char *NEEDLE);    /* string.h */
extern int strcasecmp (const char *S1, const char *S2);

#endif
