/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

/*
 * Sample application to illustrate the use of a VrScopeSink.
 * The input here is provided by the VrSigSource signal generator.
 */

#include <VrSigSource.h>
#include <VrScopeSink.h>
#include <VrConnect.h>
#include <VrMultiTask.h>
#include "VrGUI.h" 

#define MAX_FREQUENCY		1000000.0      //  1Mhz
#define FREQUENCY           20000.0       // 20Khz
#define AMPLITUDE           1000000.0
#define WAVEFORM            VR_SIN_WAVE
#define SAMPLING_FREQUENCY  33e6            // samples/sec
#define BPS					8	          // bits per sample

VrSigSource<char> *source;
VrScopeSink<char> *sink;

void set_my_freq(double f) {
  source->setFrequency(f);
}
void set_my_scale(double f) {
  sink->setScale(f);
}
#define DEFAULT_TPD			10000/10 /*divisions*/

int main(int argc, char **argv) {
  VrGUI *guimain = new VrGUI(argc, argv);
  VrGUILayout *horiz = guimain->top->horizontal();
  VrGUILayout *vert = horiz->vertical();

  source = new VrSigSource<char>(SAMPLING_FREQUENCY, WAVEFORM, 1000/*FREQUENCY*/, AMPLITUDE);
  sink = new VrScopeSink<char>(vert, DEFAULT_TPD, -128, 127);
  (void) new VrGUISlider(vert, set_my_scale, "Time per division (microseconds)", DEFAULT_TPD/100, DEFAULT_TPD);

  VrMultiTask *m = new VrMultiTask ();

  m->add (sink);

  CONNECT(sink, source, SAMPLING_FREQUENCY, BPS);

  (void) new VrGUINumber(horiz, "Signal Generator", "Frequency (cycles/sec)", set_my_freq,
		MAX_FREQUENCY, FREQUENCY);

  m->start();
  guimain->start();
  while (1){
    guimain->processEvents(10 /*ms*/);
    m->process ();
  }
}
