/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1999 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 *    Create May 25, 1998 Matthew L. Welborn
 */
#define FOUR  1
#define EIGHT 0
#define SYNC_VERSION        1
#define PULSE_VERSION       0

int symbols_per_period = 50;
int symbol_rate = 2000;
int sync_rate = symbol_rate / symbols_per_period;
int source_rate = 400000;
float nominal_samples_per_symbol = (float) source_rate / (float) symbol_rate;
float nominal_samples_per_period = (float) source_rate / (float) sync_rate;
int sync_input, data_input;

#include "VrFileSource.h"
#include "VrSigSource.h"
#include "VrDigMod.h"
#include "VrFFTSink.h"
#include "VrSyncCorr.h"
#include "VrComplexDemod.h"
#include "VrUDPSource.h"
#include "VrFileSink.h"
#include "VrPointSink.h"
#include "VrAWGN.h"
#include "VrMultiTask.h"
#include "VrGUI.h"

int persistent = 0;
int run=1;

VrPointSink *sink;
VrComplexDemod<char> *demod;
VrSyncCorr<char>* corr;  // for sync detection
VrAWGN<char>* noise;

int center_freq_mult = 4; //jca 4;
int display_width = 500;

#if 0
void set_freq_offset(double f) {
  demod->setCenter_Freq(((center_freq_mult) * symbol_rate) - f);
}
void set_phase_offset(double f) {
  demod->setPhase_Offset(VrComplex(cos(f*M_PI/100.0),sin(f*M_PI/100.0)));
}
void set_filter_taps(double t) {
  demod->setNumber_Taps((int)t);
}
#if 0
void set_timing_bump(double t) {
  filter1->setSymbol_Timing((float)t);
}
#endif
void set_noise(double f) {
  noise->setSNR((int)f);
}
#endif
#if 0
void set_adv()
{
  set_timing_bump(0.05);
}
void set_ret()
{
  set_timing_bump(-0.05);
}
#endif
void set_clear()
{
  sink->clear();
}
void set_run()
{
  run = 1-run;
  sink->setRun(run);
}


void set_persistent()
{
	persistent = 1 - persistent;
	sink->set_persistent(persistent);
}

int main(int argc,char** argv)
{
  int sync_oversample = 10;
  //  int dec = source_rate / symbol_rate;             // one output per symbol period
  //  int dec_sync = dec / sync_oversample;    // multiple outputs per symbol period
  //  float dummy;
  //  float gain = 1.0/800.0 ;
  float filter_freq = (float)((center_freq_mult) * symbol_rate);
  int data_taps = 50, sync_taps = 50, step_size;

  step_size = (int) (nominal_samples_per_symbol / (float) sync_oversample);
  if (step_size == 0) step_size = 1;
 

  VrGUI *guimain = new VrGUI(argc, argv);
  VrUDPSource<char>* source = new VrUDPSource<char>(source_rate, 5001);
  noise = new VrAWGN<char>();
  corr = new VrSyncCorr<char>(source_rate/sync_rate,step_size, sync_taps, filter_freq);
  //  corr = new VrCorr<VrComplex,Sync_result>(1, 10, 2, 4);
  demod = new VrComplexDemod<char>(corr, data_taps, filter_freq);
  sink = new VrPointSink(guimain->top, -3, 3, 25, 1);


#if 1
  CONNECT(sink, demod, symbol_rate, 64);
  CONNECT(demod, noise, source_rate, 8);
  data_input = 0;
  cout << sizeof(struct corr_result) << endl;
  CONNECT(noise, source, source_rate, 8);
#endif
#if 1
  CONNECT(demod, corr, sync_rate*12, 8);
  sync_input = 1;
  CONNECT(corr, noise, source_rate, 8);
#endif

  VrMultiTask *m = new VrMultiTask();
  m->add(sink);  
  m->start(); 
  guimain->start();

#if 0
  filter1 -> setSymbol_Timing((float)0.0);
  dummy = filter1 -> getSymbol_Period();
  cout << "Original period: " << dummy << endl;
   if(argc==2) filter1 -> setSymbol_Period(atof(argv[1]));
   if(argc==3) {
     filter1 -> setSymbol_Period(atof(argv[1]));
     filter1 -> setSymbol_Timing(atof(argv[2]));
   }
#endif
 
   while(1) {
     guimain->processEvents(10 /*ms*/);
     m->process(); 
   } /* while(1) */
}










