/*
 * $Id: VariableProvider.java,v 1.4 1999/12/19 17:43:31 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998,1999 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel.tests;

public class VariableProvider {
  public double xvar;
  
  public double x() {return xvar;};

  public double[] arr;

  public static final double[] arrs={1.0,2.0,3.0};
  
  public VariableProvider() {
    arr=new double[3];
    arr[0]=4.0;
    arr[1]=5.0;
    arr[2]=6.0;
  };

  public static int throw_arg_eq_4(int x) throws Exception {
    if (x==4) throw new Exception("An exception from testsuite.");
    return 0;
  };

  public static int bool2int(boolean b) {
    if (b) return 1; else return 0;
  };

  public static float NaNf() {
    return Float.NaN;
  };

  public static double NaNd() {
    return Double.NaN;
  };

  public static Double makeDoubleObject(double d) {
    return new Double(d);
  };

};

