
;;; c2j.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: c2j.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unix Backup
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(define-derived-mode c2j-mode java-mode "C2J Mode"
  "DOCSTRING"
  ;;(java-mode)
  ;;(setq major-mode 'c2j-mode)
  ;;(setq mode-name "C2J Mode")
  ;;(make-local-variable 'c2j-mode-map)
  ;;(setq c2j-mode-map (copy-keymap java-mode-map))
  ;;(use-local-map c2j-mode-map)
  (assert (fboundp 'd-indent-line))
  (setcdr (assq 9 c2j-mode-map) 'd-indent-line)
  (define-key c2j-mode-map [tab] 'd-indent-line)
  (define-key c2j-mode-map [(tab)] 'd-indent-line)
  (define-key c2j-mode-map "\t" 'd-indent-line)
  )

(setq auto-mode-alist (cons '("\\.c2j$" . c2j-mode) auto-mode-alist))

(add-hook 'font-lock-mode-hook 'd-c2j-font-lock-mode-hook nil)
;;(remove-hook 'font-lock-mode-hook 'd-c2j-font-lock-mode-hook)

(defun d-c2j-font-lock-mode-hook ()
  (when (eq major-mode 'c2j-mode)
    (d-font-lock-add-begin
     '(
       ("\\<strobe\\>" 0 'd-face-cc-debugging t)
       ("\\<sp\\>"     0 'font-lock-type-face t)
       ("\\<r[0-9]\\>" 0 'font-lock-type-face t)
       ;;("\\(^\\|[^a-z0-9_]\\)\\(\\([+-]?[0-9]+\\)\\(\\.[0-9]+\\)?\\([eE][+-]?[0-9]+\\)?\\>\\)" 2 'd-face-cc-digits t)
       ("\\(\\<nop \\)\\([a-zA-Z0-9_]*\\);\\(.*\\)$"
        (1 'bold t)
        (2 'fg:lightred t)
        (3 'font-lock-comment-face nil)
        )
       ("\\(\\<label\\) \\([a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ("\\(\\<return\\>\\)["                 1 'bold nil)
       ("\\(\\<goto\\) \\([a-zA-Z0-9_]+\\)"  (1 'bold t) (2 'font-lock-function-name-face t))
       ("\\(\\<line_[a-zA-Z0-9_]*\\)"         1 'font-lock-function-name-face t)
       ("[0-9]+"                              0 'd-face-cc-digits t)
       ;;("\\<\\(fcall\\) \\([a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ;;("\\<\\(jcall\\) \\(function_[a-zA-Z0-9_]+\\)" (1 'bold t) (2 'font-lock-function-name-face t))
       ;;("\\<\\(xif\\|negate\\|not\\|newvar\\|p?push\\|p?pop\\|newmove\\|move\\|addby\\|multiplyby\\|subtractby\\|callnot\\|call\\|eq\\)\\>" 1 'bold t)
       ;;("\\<push \\([a-zA-Z][a-zA-Z0-9_]*\\)" 1 'fg:lightred t)
       )))
  (when (and prefs-advanced-user-p (eq major-mode 'c2j-mode))
    (d-font-lock-add-end
     '(
       ("\\(\\<nop beg_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop end_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop BEG_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       ("\\(\\<nop END_.*;\\)//.*$" 1 'font-lock-function-name-face t)
       )))
  )

(provide 'c2j)
;;; c2j.el ends here
