/* loop.c - Main loop of proxyknife.
 *
 * Copyright (C) 2005-2006 Jia Wang (skyroam@gmail.com)
 *
 *
 *
 * This file is part of proxyknife.
 * Proxyknife is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the 
 * Free Software Foundation; either version 2 of the License, or (at your 
 * option) any later version.
 *
 * Proxyknife is distributed in the hope that it will be useful, but WITHOUT ANY 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 *
 *
 * You should have received a copy of the GNU General Public License 
 * along with Proxyknife; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/* all functions are declared in proxyknife.h */
#include <proxyknife.h>
#include <sys/time.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>
int errno;
/* functions defined in this file */
int READAPROXY (struct thread_mem *thread_mem);
int VERIFY (int sockfd, struct timeval *finddata,
	    struct timeval *findkey, struct thread_mem *thread_mem);
int BUILDPROXYADDR (struct thread_mem *thread_mem);

/* Top function defined in this file */
/* Loop is called after thread is created.
 * Loop reads testproxy from proxylist file one by one  and validates it 
 * according to configuration.
 *  
 * The var *arg was a number used to identify the order of pthread_create.
 * Thread order: *((int *)arg) 
 * */
void *
loop (void *arg)
{
  int read, sockfd;
  struct timeval rcvwait, sndwait;

  struct thread_mem loop_mem;
  /* struct queue queue; */
  struct timeval start_via, end_estab, start_GET, enter_data, enter_key;
  struct timeval start_CON, end_CON;

  while (1)
    {

      thread_mem_init (&loop_mem);
      /* read loop_mem.queue.testproxy */
      read = READAPROXY (&loop_mem);
      if (read == -1)
	break;			/* end of file */
      if (read == -2)
	continue;
      /* create socket */
      if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) == -1)
	{
	  fprintf (stderr, "%s: loop:Thread %d---", progname, *((int *) arg));
	  perror ("loop:socket:Create socket");
	  break;		/* fatal thread error. */
	}

      /* set timeout */
      /* I only know this works on my gentoo box. */
      rcvwait.tv_sec = rcvtimeo;
      rcvwait.tv_usec = 0;
      sndwait.tv_sec = sndtimeo;
      sndwait.tv_usec = 0;
      if (setsockopt
	  (sockfd, SOL_SOCKET, SO_RCVTIMEO, &rcvwait, sizeof (rcvwait)) < 0)
	{
	  perror ("loop:setsockopt:SO_RCVTIMEO");
	}
      if (setsockopt
	  (sockfd, SOL_SOCKET, SO_SNDTIMEO, &sndwait, sizeof (sndwait)) < 0)
	{
	  perror ("loop:setsockopt:SO_RCVTIMEO");
	}


      fprintf (stderr, "%s: loop:Thread %d Checking %s\n", progname,
	       *(int *) arg, loop_mem.queue.testproxy);
      /* connect to testproxy (via myproxy now) */
      /* use loop_mem.queue.testproxy to send CONNECT request,
         No BUILDPROXYADDR,no loop_mem.queue.proxyaddr.  */
      if ((my.mytype == HTTP_CONNECT) || (my.mytype == HTTP_CONNECT_AUTH))
	{
	  if (CONVIAHTTP (sockfd, &start_via, &end_estab, &loop_mem) == -1)
	    goto loop_ex;
	}
      else
	{
	  /* build proxyaddr , no new malloc. */
	  if (BUILDPROXYADDR (&loop_mem) == -1)
	    {
	      fprintf (stderr, "%s: loop:BUILDPROXYADDR\n", progname);
	      goto loop_ex;
	    }


      /* only connect to testproxy via my */
	  if ((my.mytype == SOCKS5_CONNECT_AUTH)
	      || (my.mytype == SOCKS5_CONNECT))
	    {
	      if (CONVIASOCKS5 (sockfd, &start_via, &end_estab, &loop_mem) ==
		  -1)
		goto loop_ex;
	    }
	  else if (my.mytype == DIRECT)
	    {
	      if (connect
		  (sockfd, (struct sockaddr *) &(loop_mem.queue.proxyaddr),
		   sizeof (struct sockaddr)) == -1)
		{
		  if ((errno == EINPROGRESS))
		    {
		      fprintf (stderr, "loop:connect:timeout!\n");
		    }
		  else
		    {
		      perror ("loop:connect:->unexpected error");
		    }
		  goto loop_ex;
		}
	    }
	}
      /* protocol will be added here in the future */

      if (loop_mem.queue.proto == HTTP)
	{
	  /* test.mothod only control http testproxy */
	  switch (test.httptestmethod)
	    {
	    case HTTP_GET:
	      if (PGET (sockfd, &start_GET, &loop_mem) == -1)
		break;
	      /* goto loop_ex; */

	      /* verify the result */
	      if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
		{
		  printf ("Thread %d--Found~~~%s@HTTP delay=%f %f %f\n",
			  *((int *) arg), loop_mem.queue.testproxy,
			  time_sub (end_estab, start_via),
			  time_sub (enter_data, start_GET),
			  time_sub (enter_key, enter_data));
		  pthread_mutex_lock (&counter_mutex_out);
		  fprintf (out, "%s@HTTP\t%f %f %f\n",
			   loop_mem.queue.testproxy,
			   time_sub (end_estab, start_via),
			   time_sub (enter_data, start_GET),
			   time_sub (enter_key, enter_data));
		  pthread_mutex_unlock (&counter_mutex_out);
		}
	      break;
	    case HTTP_CONNECT:
	      if (PCONGET
		  (sockfd, &start_CON, &end_CON, &start_GET, &loop_mem) == -1)
		goto loop_ex;
	      if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
		{
		  printf ("Thread %d--Found~~~%s@HTTPC delay=%f %f %f %f\n",
			  *((int *) arg), loop_mem.queue.testproxy,
			  time_sub (end_estab, start_via),
			  time_sub (enter_data, start_GET),
			  time_sub (enter_key, enter_data), time_sub (end_CON,
								      start_CON));
		  fprintf (out, "%s@HTTPC %f %f %f %f\n",
			   loop_mem.queue.testproxy, time_sub (end_estab,
							       start_via),
			   time_sub (enter_data, start_GET),
			   time_sub (enter_key, enter_data),
			   time_sub (end_CON, start_CON));
		}
	      break;
	    default:		/* not necessay,should be done in init */
	      fprintf (stderr,
		       "%s: loop:Unknown http method for testproxy!\n",
		       progname);
	      break;
	    }
	}
      else if (loop_mem.queue.proto == SOCKS5)
	{
	  switch (test.socks5testmethod)
	    {
	    case SOCKS5_CONNECT:
	      /* Default as CONNECT even wrong conf */
	    default:
	      if (S5PCONGET
		  (sockfd, &start_CON, &end_CON, &start_GET, &loop_mem) == -1)
		goto loop_ex;
	      if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
		{
		  printf ("Thread %d--Found~~~%s@SOCKS5C delay=%f %f %f %f\n",
			  *((int *) arg), loop_mem.queue.testproxy,
			  time_sub (end_estab, start_via),
			  time_sub (enter_data, start_GET),
			  time_sub (enter_key, enter_data), time_sub (end_CON,
								      start_CON));
		  fprintf (out, "%s@SOCKS5C %f %f %f %f\n",
			   loop_mem.queue.testproxy, time_sub (end_estab,
							       start_via),
			   time_sub (enter_data, start_GET),
			   time_sub (enter_key, enter_data),
			   time_sub (end_CON, start_CON));
		}
	      break;
	    }
	}
     else if (loop_mem.queue.proto == SOCKS4)
	{
	  switch (test.socks4testmethod)
	    {
	    case SOCKS4_CONNECT:
	      /* Default as CONNECT even wrong conf */
	    default:
	      if (S4PCONGET
		  (sockfd, &start_CON, &end_CON, &start_GET, &loop_mem) == -1)
		goto loop_ex;
	      if (VERIFY (sockfd, &enter_data, &enter_key, &loop_mem) == 0)
		{
		  printf ("Thread %d--Found~~~%s@SOCKS4C delay=%f %f %f %f\n",
			  *((int *) arg), loop_mem.queue.testproxy,
			  time_sub (end_estab, start_via),
			  time_sub (enter_data, start_GET),
			  time_sub (enter_key, enter_data), time_sub (end_CON,
								      start_CON));
		  fprintf (out, "%s@SOCKS4C %f %f %f %f\n",
			   loop_mem.queue.testproxy, time_sub (end_estab,
							       start_via),
			   time_sub (enter_data, start_GET),
			   time_sub (enter_key, enter_data),
			   time_sub (end_CON, start_CON));
		}
	      break;
	    }
	}

      else
	{			/* continue next proxy */
	  fprintf (stderr, "%s: loop:Proto %d was not implemented now!\n",
		   progname, loop_mem.queue.proto);

	}
    loop_ex:
      if (loop_mem.queue.testproxy != NULL)
	pxfree ((void **) &(loop_mem.queue.testproxy));
      close (sockfd);
    }
  return arg;
}


/* Read a line from proxylist file ,check it and store a valid 
 * testproxy to buffer queue.testproxy.
 *
 * Return value:
 * -1: Can't find a data  end with '\n';
 * -2: Can't find a valid testproxy in the line.
 *  >0: Success! Return the size of lines read(including \n).
 * */
int
READAPROXY (struct thread_mem *thread_mem)
{
  int mlen = 80;
  int read;

  thread_mem->line = NULL;
  /* read a line into thread_mem->line */
  pthread_mutex_lock (&counter_mutex_in);
  read = getaline_r ((char **) &(thread_mem->line), &mlen, in, thread_mem);
  pthread_mutex_unlock (&counter_mutex_in);

  if (read == -1)		/* not memory errors */
    {
      if (thread_mem->line)
	pxfree ((void **) &(thread_mem->line));
      return -1;
    }				/* read = -1(end of file or stop after errors) or >=1, will not be 0 */
  if (*(thread_mem->line + read - 1) == '\n')
    *(thread_mem->line + read - 1) = '\x0';
  /* debug */
  fprintf (stderr, "%s: READAPROXY:Parsing %d bytes: %s\n",
	   progname, read - 1, thread_mem->line);
  /* read to testproxy, return -2 when data invalid */
  /* save into thread_mem->queue.testproxy from thread_mem->line if success */
  if (checkaline (thread_mem) == -1)
    {
      read = -2;
    }
  else
    {
      fprintf (stderr, "%s: READAPROXY:Testproxy=%d len: %s proto: %d\n",
	       progname, strlen (thread_mem->queue.testproxy),
	       thread_mem->queue.testproxy, thread_mem->queue.proto);
    }

  if (thread_mem->line)
    pxfree ((void **) &(thread_mem->line));
  return read;			/* -1 means end of file */

}


/* Get IPV4 addr of testproxy from queue.testproxy and store it
 * to queue.proxyaddr.
 *
 * Return value:
 * 0: Success!
 * -1: Can find valid IPV4 addr.-- This should not happen now
 *  (see checkaline).
 *  
 * */
int
BUILDPROXYADDR (struct thread_mem *thread_mem)
{
  char *p;
  int ret;
  p = strchr (thread_mem->queue.testproxy, ':');
  if (p == NULL)
    {
      return -1;
    }
  thread_mem->queue.proxyaddr.sin_port = htons (atoi (p + 1));
  *p = '\0';
  ret = inet_aton (thread_mem->queue.testproxy,
		   &(thread_mem->queue.proxyaddr.sin_addr));
  *p = ':';
  /*fprintf(stderr,"Begin BUILD%s\n",inet_ntoa(thread_mem->queue.proxyaddr.sin_addr));*/
  if (ret == 0)
    return -1;
  thread_mem->queue.proxyaddr.sin_family = AF_INET;
  memset (&(thread_mem->queue.proxyaddr.sin_zero), 0,
	  sizeof (thread_mem->queue.proxyaddr.sin_zero));
  return 0;
}


/* Find the key from the data reply from target. A valid testproxy
 * should response with data including key. 
 *
 * Return value:
 * 0: Find key!
 * -1: Can't find key in reply data at most testtagreplysize bytes.
 * */
int
VERIFY (int sockfd, struct timeval *finddata,
	struct timeval *findkey, struct thread_mem *thread_mem)
{
  int numbytes;
  char *p;			/* danger? */
  int t = 0;

  thread_mem->reply = pxmalloc (test.testtagreplysize, thread_mem);
  p = thread_mem->reply;
  memset (p, 0, test.testtagreplysize);
  /* -1 for \0 ->strstr */
  while (1)
    {
      numbytes =
	read (sockfd, p, test.testtagreplysize - (p - thread_mem->reply) - 1);
      if (numbytes <= 0)
	{

	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
      t++;
      if (t == 1)
	gettimeofday (finddata, NULL);
      /* printf("RETURN!!!!!!!!!!!!!!!%s",buf); */

      gettimeofday (findkey, NULL);	/* save time */
      if (strstr (thread_mem->reply, target.key) != NULL)
	{
	  /* gettimeofday (findkey, NULL); */
	  pxfree ((void **) &(thread_mem->reply));
	  return 0;
	}
      p += numbytes;
      if ((p - thread_mem->reply) == (test.testtagreplysize - 1))
	{
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
    };
  /* return -1; */
}
