/* tool_help_loader.h header file for the class which provides
 *                    access to the toolhelp.dll
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __tool_help_loader_h__
#define __tool_help_loader_h__

#include<dll_loader.h>
#include<tlhelp32.h>

typedef BOOL (WINAPI *pHeap32First)( LPHEAPENTRY32 lphe, DWORD th32ProcessID, DWORD th32HeapID); 
typedef BOOL (WINAPI *pHeap32Next)(LPHEAPENTRY32 lphe); 
typedef BOOL (WINAPI *pHeap32ListFirst)( HANDLE hSnapshot, LPHEAPLIST32 lphl); 
typedef BOOL (WINAPI *pHeap32ListNext)( HANDLE hSnapshot, LPHEAPLIST32 lphl ); 
typedef BOOL (WINAPI *pModule32First)( HANDLE hSnapshot, LPMODULEENTRY32 lpme); 
typedef BOOL (WINAPI *pModule32Next)( HANDLE hSnapshot, LPMODULEENTRY32 lpme ); 
typedef BOOL (WINAPI *pProcess32First)( HANDLE hSnapshot, LPPROCESSENTRY32 lppe); 
typedef BOOL (WINAPI *pProcess32Next)( HANDLE hSnapshot, LPPROCESSENTRY32 lppe); 
typedef BOOL (WINAPI *pThread32First)( HANDLE hSnapshot, LPTHREADENTRY32 lpte); 
typedef BOOL (WINAPI *pThread32Next)( HANDLE hSnapshot, LPTHREADENTRY32 lpte); 
typedef HANDLE (WINAPI *pCreateToolhelp32Snapshot)(DWORD dwFlags, DWORD th32ProcessID);

 
class tool_help_loader : public dll_loader {
public:
	tool_help_loader() : dll_loader() { ; }
	UINT32 Init();
	pHeap32First  ThHeap32First;
    pHeap32Next ThHeap32Next; 
	pHeap32ListFirst ThHeap32ListFirst; 
	pHeap32ListNext ThHeap32ListNext; 
	pModule32First ThModule32First; 
	pModule32Next ThModule32Next; 
	pProcess32First ThProcess32First; 
	pProcess32Next ThProcess32Next; 
	pThread32First ThThread32First; 
	pThread32Next ThThread32Next; 
	pCreateToolhelp32Snapshot ThCreateToolhelp32Snapshot;
};

#endif /* __tool_help_loader_h__ */