/* w32_seeder.h header file for seeder base class
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __w32_seeder_h__
#define __w32_seeder_h__

#include<pcp_common.h>

class seeder {
public:
	seeder(UINT32 buffer_size);
	virtual UINT32 get_seed(UINT8 *seed, UINT32& desired_length) = 0;
	virtual UINT32 get_internal_seed_size();
	virtual void set_internal_seed_size(UINT32 new_size);
	virtual UINT32 get_expected_seed_size() = 0;
	virtual ~seeder() { ; }
protected:
	UINT32 internal_seed_length;
};

#endif /* __w32_seeder_h__ */