/* w95_slow.h header file for 95/98 specific slow seeder
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __w95_slow_h__
#define __w95_slow_h__

#include<pcp_common.h>
#include<mem_writer.h>
#include<w32_seeder.h>
#include<tool_help_loader.h>


class win95_slow_seeder : public seeder {
public:
	win95_slow_seeder(tool_help_loader *th);
	win95_slow_seeder(UINT32 internal_buffer_size, tool_help_loader *th);
	virtual UINT32 get_seed(UINT8 *seed, UINT32& desired_length);
	virtual ~win95_slow_seeder();
	virtual UINT32 get_expected_seed_size();
protected:
	tool_help_loader *tool_help;
	UINT32 walk_heaps_of_heaplist(mem_writer& w, DWORD pid, DWORD hid);
	UINT32 walk_heaplist_of_process(mem_writer& w, DWORD pid);
	UINT32 walk_modules_of_process(mem_writer& w, DWORD pid);
	UINT32 walk_threads(mem_writer& w);
	UINT32 walk_processes(mem_writer& w);
};

#endif /* __w95_slow_h__ */