/* win32_entropy.cpp layer implementing C interface
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#include<win32_entropy.h>
#include<w32_seeder.h>
#include<w32_fast.h>
#include<tool_help_loader.h>
#include<netapi_loader.h>
#include<wnt_slow.h>
#include<w95_slow.h>

void WINAPI WS_delete_instance(WIN32_SEEDER that)
{
	seeder *help = (seeder *)(that);
	
	delete help;
}

static seeder *make_windows(UINT32 *reason)
{
	tool_help_loader *th;
	seeder *result = NULL;

	if ((th = new tool_help_loader) != NULL)
	{	
		if ((*reason = th->Init()) == PCP_SUCCESS)
		{
			if ((result = new win95_slow_seeder(th)) == NULL)
			{
				delete th;
				*reason = PCP_SEEDER_NO_MEM;
			}
		}
		else
		{
			delete th;
		}
	}
	else
	{
		*reason = PCP_SEEDER_NO_MEM;
	}

	return result;
}

static seeder *make_nt(UINT32 *reason)
{
	netapi_loader *na;
	seeder *result = NULL;

	if ((na = new netapi_loader) != NULL)
	{	
		if ((*reason = na->Init()) == PCP_SUCCESS)
		{
			if ((result = new nt_slow_seeder(na)) == NULL)
			{
				delete na;
				*reason = PCP_SEEDER_NO_MEM;
			}
		}
		else
		{
			delete na;
		}
	}
	else
	{
		*reason = PCP_SEEDER_NO_MEM;
	}

	return result;
}

WIN32_SEEDER WINAPI WS_create_instance(SEEDER_TYPE type, UINT32 *reason)
{
	seeder *help = NULL;
	OSVERSIONINFO version;

	*reason = PCP_SUCCESS;

	switch(type)
	{
	case WIN32_SLOW_SEEDER:
		version.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);

		if (GetVersionEx(&version) != 0)
		{
			switch(version.dwPlatformId)
			{
			case VER_PLATFORM_WIN32_NT:
				help = make_nt(reason);
				break;
			case VER_PLATFORM_WIN32_WINDOWS:
				help = make_windows(reason);
				break;
			default:
				*reason = PCP_UNKNOWN_PLATFORM; 
				break;
			}
		}
		else
		{
			*reason = PCP_ERROR_VERSION;
		}
		break;
	case WIN32_FAST_SEEDER:
		if ((help = new win32_fast_seeder) == NULL)
		{
			*reason = PCP_SEEDER_NO_MEM;
		}
		break;
	default:
		*reason = PCP_UNKNOWN_SEEDER_TYPE;
		break;
	}

	return help;
}

unsigned int WINAPI WS_get_internal_seed_size(WIN32_SEEDER that)
{
	seeder *help = (seeder *)that;

	return (help->get_internal_seed_size());
}

unsigned int WINAPI WS_get_expected_seed_size(WIN32_SEEDER that)
{
	seeder *help = (seeder *)that;

	return (help->get_expected_seed_size());
}

unsigned int WINAPI WS_get_seed(WIN32_SEEDER that, unsigned char *buffer, unsigned int *desired_length)
{
	seeder *help = (seeder *)that;
	unsigned int result;

	if ((desired_length == NULL) || (help == NULL))
	{
		result = PCP_NULL_POINTER;
	}
	else
	{
		result = help->get_seed(buffer, *desired_length);
	}
	
	return result;
}

void WINAPI WS_set_internal_seed_size(WIN32_SEEDER that, unsigned int new_size)
{
	seeder *help = (seeder *)that;

	help->set_internal_seed_size(new_size);
}