/* wnt_slow.h header file for NT specific slow seeder class
 *	Copyright (C) 1999 Martin Grap
 *
 * This file is part of winseed.
 *
 * winseed is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * winseed is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#ifndef __wnt_slow_h__
#define __wnt_slow_h__

#include<w32_seeder.h>
#include<mem_writer.h>
#include<netapi_loader.h>

class nt_slow_seeder : public seeder {
public:
	nt_slow_seeder(netapi_loader *na);
	nt_slow_seeder(UINT32 internal_buffer_size, netapi_loader *na);
	virtual UINT32 get_seed(UINT8 *seed, UINT32& desired_length);
	virtual ~nt_slow_seeder();
	virtual UINT32 get_expected_seed_size();
protected:
	virtual UINT32 query_network_statistics(mem_writer &w, LPWSTR service);
	UINT32 query_performance_data(UINT8 *buffer, UINT32 &buffer_length);
	UINT32 get_log_entries(PCP_CHAR *log_name, mem_writer& w);
	netapi_loader *netapi;
};

#endif /* __wnt_slow_h__ */