// SPDX-FileCopyrightText: 2023 g10 code GmbH
// SPDX-Contributor: Carl Schwan <carl.schwan@gnupg.com>
// SPDX-License-Identifier: GPL-2.0-or-later

#pragma once

#include <QHttpServerResponse>
#include <QString>

#include "../model/serverstate.h"

class AbstractController
{
protected:
    Q_REQUIRED_RESULT
    static QHttpServerResponse badRequest(const QString &reason = {});
    static QHttpServerResponse forbidden();

    static std::optional<Server> checkAuthentification(const QHttpServerRequest &request);
};
