#ifdef WITH_CPP_WRAPPER

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "gpgme.h"
#include "gpgme-c++.h"


gpgme_key::gpgme_key (gpgme_key_t key)
{
    if (!key)
	abort ();
    key = key;
    ctx = NULL;
    edit_ctx = NULL;
    passphrase = NULL;
}

gpgme_key::~gpgme_key (void)
{
    if (key)
	gpgme_key_release (key);
    if (ctx)
	gpgme_release (ctx);
    if (edit_ctx)
	gpgme_editkey_release (edit_ctx);
}


int
gpgme_key::set_passwd (const char * passwd)
{
    if (!passwd)
	return GPG_ERR_INV_VALUE;

    if (passphrase) {
	delete [] passphrase;
	passphrase = NULL;
    }
    passphrase = new char[strlen (passwd)+1];
    if (!passphrase)
	abort ();
    strcpy (passphrase, passwd);
    return GPG_ERR_SUCCESS;
}

unsigned
gpgme_key::ulong_attr (int what, int idx)
{
    assert (key);
    return gpgme_key_get_ulong_attr (key, (gpgme_attr_t)what, NULL, idx);
}


const char *
gpgme_key::string_attr (int what, int idx)
{
    assert (key);
    return gpgme_key_get_string_attr (key, (gpgme_attr_t)what, NULL, idx);
}


const void * 
gpgme_key::attrib_attr (int * nbytes)
{
    assert (key);
    return gpgme_key_get_string_attr (key, GPGME_ATTR_PHOTO, (void **)&nbytes, 0);
}


int
gpgme_key::sign (int sigclass, int local)
{
    gpgme_error_t rc;

    if (!passphrase)
	return GPG_ERR_PWD_NOT_SET;
    return 0;
}


#endif /* WITH_CPP_WRAPPER */