/* wptSymEnc.cpp - Symmetric encryption support
 *	Copyright (C) 2002, 2003, 2004 Timo Schulz
 *
 * This file is part of WinPT.
 *
 * WinPT is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation; either version 2 
 * of the License, or (at your option) any later version.
 *  
 * WinPT is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with WinPT; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA 
 */

#include <windows.h>

#include "wptGPG.h"
#include "wptCommonCtl.h"
#include "wptContext.h"
#include "wptDlgs.h"
#include "wptNLS.h"
#include "wptUTF8.h"
#include "wptTypes.h"
#include "wptErrors.h"

int
gpgme_encrypt_symmetric (void)
{
    gpgme_ctx_t ctx;
    gpgme_error_t rc;
    char * pass = NULL;
    int cancel = 0;
    
    pass = request_passphrase2 (_("Symmetric Encryption"), &cancel);
    if (cancel)
	return WPTERR_GENERAL;
    rc = gpgme_new (&ctx);
    if (rc)
	BUG (0);
    gpgme_set_passphrase (ctx, pass);
    rc = gpgme_op_clip_symenc (ctx);
    sfree_if_alloc (pass);
    if (rc)
	msg_box (NULL, gpgme_strerror (rc), _("Symmetric Encryption"), MB_ERR);
    else
	show_msg (GetDesktopWindow (), 1500, _("GnuPG Status: Finished"));
    gpgme_release (ctx);
    return rc? WPTERR_GENERAL : 0;
} /* gpgme_encrypt_symmetric */