%module Listbox


%{
#include "Object.h"
#include "Button.h"
#include "Listbox.h"
%}


%include Types.i
%include Constants.i
%import Object.i
%import Widget.i
%import Frame.i


class ListBox : public QFrame
{
public:
    ListBox(QWidget *parent=0, const char *name=0, int f=0  );
   ~ListBox();

    unsigned int	count() const;

    void	insertStrList(const QStrList *list, int index=-1 );

    void	insertItem( const char *text, int index=-1 );
%name(insertPixmap)    void	insertItem( const QPixmap &pixmap, int index=-1 );
    void	inSort( const char *text );

    void	removeItem( int index );
    void	clear();

    const char *text( int index )	const;
    const QPixmap *pixmap( int index )	const;

    void	changeItem( const char *text, int index );
%name(changePixmap)    void	changeItem( const QPixmap &pixmap, int index );

    bool	autoUpdate()	const;
    void	setAutoUpdate( bool );

    int		numItemsVisible() const;

    int		currentItem()	const;
    void	setCurrentItem( int index );
    void	centerCurrentItem();
    int		topItem()	const;
    void	setTopItem( int index );

    bool	dragSelect()		const;
    void	setDragSelect( bool );
    bool	autoScroll()		const;
    void	setAutoScroll( bool );
    bool	autoScrollBar()		const;
    void	setAutoScrollBar( bool );
    bool	scrollBar()		const;
    void	setScrollBar( bool );
    bool	autoBottomScrollBar()	const;
    void	setAutoBottomScrollBar( bool );
    bool	bottomScrollBar()	const;
    void	setBottomScrollBar( bool );
    bool	smoothScrolling()	const;
    void	setSmoothScrolling( bool );

    int		itemHeight()		const;
%name(itemHeightAt)    int		itemHeight( int index ) const;

    long	maxItemWidth();

    bool	isMultiSelection() const;
    void	setMultiSelection( bool );

    void	setSelected( int, bool );
    bool	isSelected( int ) const;

    void	clearSelection();

/*
signals:
    void	highlighted( int index );
    void	selected( int index );
    void	highlighted( const char * );
    void	selected( const char * );

    void	selectionChanged();
*/

};
